/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class IndexTemplateMetaData {
    private final String name;
    private final int order;
    private final String template;
    private final Settings settings;
    private final ImmutableOpenMap<String, CompressedString> mappings;
    private final ImmutableOpenMap<String, AliasMetaData> aliases;
    private final ImmutableOpenMap<String, IndexMetaData.Custom> customs;

    public IndexTemplateMetaData(String name, int order, String template, Settings settings, ImmutableOpenMap<String, CompressedString> mappings, ImmutableOpenMap<String, AliasMetaData> aliases, ImmutableOpenMap<String, IndexMetaData.Custom> customs) {
        this.name = name;
        this.order = order;
        this.template = template;
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
        this.customs = customs;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    public int getOrder() {
        return this.order();
    }

    public String getName() {
        return this.name;
    }

    public String template() {
        return this.template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings();
    }

    public ImmutableOpenMap<String, CompressedString> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, CompressedString> getMappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, AliasMetaData> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, AliasMetaData> getAliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, IndexMetaData.Custom> getCustoms() {
        return this.customs;
    }

    public <T extends IndexMetaData.Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetaData that = (IndexTemplateMetaData)o;
        if (this.order != that.order) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return this.template.equals(that.template);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.order;
        result = 31 * result + this.template.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    public static class Builder {
        private static final Set<String> VALID_FIELDS = Sets.newHashSet("template", "order", "mappings", "settings");
        private String name;
        private int order;
        private String template;
        private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, CompressedString> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetaData> aliases;
        private final ImmutableOpenMap.Builder<String, IndexMetaData.Custom> customs;

        public Builder(String name) {
            this.name = name;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(IndexTemplateMetaData indexTemplateMetaData) {
            this.name = indexTemplateMetaData.name();
            this.order(indexTemplateMetaData.order());
            this.template(indexTemplateMetaData.template());
            this.settings(indexTemplateMetaData.settings());
            this.mappings = ImmutableOpenMap.builder(indexTemplateMetaData.mappings());
            this.aliases = ImmutableOpenMap.builder(indexTemplateMetaData.aliases());
            this.customs = ImmutableOpenMap.builder(indexTemplateMetaData.customs());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public String template() {
            return this.template;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder removeMapping(String mappingType) {
            this.mappings.remove(mappingType);
            return this;
        }

        public Builder putMapping(String mappingType, CompressedString mappingSource) throws IOException {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            this.mappings.put(mappingType, new CompressedString(mappingSource));
            return this;
        }

        public Builder putAlias(AliasMetaData aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData);
            return this;
        }

        public Builder putAlias(AliasMetaData.Builder aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData.build());
            return this;
        }

        public Builder putCustom(String type, IndexMetaData.Custom customIndexMetaData) {
            this.customs.put(type, customIndexMetaData);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public IndexMetaData.Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public IndexTemplateMetaData build() {
            return new IndexTemplateMetaData(this.name, this.order, this.template, this.settings, this.mappings.build(), this.aliases.build(), this.customs.build());
        }

        public static void toXContent(IndexTemplateMetaData indexTemplateMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            Map mapping;
            XContentParser parser;
            builder.startObject(indexTemplateMetaData.name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("order", indexTemplateMetaData.order());
            builder.field("template", indexTemplateMetaData.template());
            builder.startObject("settings");
            ImmutableMap<String, String> overrideParams = ImmutableMap.of("flat_settings", params.param("flat_settings", Boolean.TRUE.toString()));
            indexTemplateMetaData.settings().toXContent(builder, new ToXContent.DelegatingMapParams(overrideParams, params));
            builder.endObject();
            if (params.paramAsBoolean("reduce_mappings", false)) {
                builder.startObject("mappings");
                for (ObjectObjectCursor<String, CompressedString> objectObjectCursor : indexTemplateMetaData.mappings()) {
                    byte[] mappingSource = ((CompressedString)objectObjectCursor.value).uncompressed();
                    parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                    mapping = parser.map();
                    if (mapping.size() == 1 && mapping.containsKey(objectObjectCursor.key)) {
                        mapping = (Map)mapping.get(objectObjectCursor.key);
                    }
                    builder.field((String)objectObjectCursor.key);
                    builder.map(mapping);
                }
                builder.endObject();
            } else {
                builder.startArray("mappings");
                for (ObjectObjectCursor<String, CompressedString> objectObjectCursor : indexTemplateMetaData.mappings()) {
                    byte[] data = ((CompressedString)objectObjectCursor.value).uncompressed();
                    parser = XContentFactory.xContent(data).createParser(data);
                    mapping = parser.mapOrderedAndClose();
                    builder.map(mapping);
                }
                builder.endArray();
            }
            for (ObjectObjectCursor<String, Object> objectObjectCursor : indexTemplateMetaData.customs()) {
                builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                IndexMetaData.lookupFactorySafe((String)objectObjectCursor.key).toXContent((IndexMetaData.Custom)objectObjectCursor.value, builder, params);
                builder.endObject();
            }
            builder.startObject("aliases");
            for (ObjectCursor objectCursor : indexTemplateMetaData.aliases().values()) {
                AliasMetaData.Builder.toXContent((AliasMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            builder.endObject();
        }

        public static IndexTemplateMetaData fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = Builder.skipTemplateName(parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        ImmutableSettings.Builder templateSettingsBuilder = ImmutableSettings.settingsBuilder();
                        for (Map.Entry<String, String> entry : SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered()).entrySet()) {
                            if (!entry.getKey().startsWith("index.")) {
                                templateSettingsBuilder.put("index." + entry.getKey(), entry.getValue());
                                continue;
                            }
                            templateSettingsBuilder.put(entry.getKey(), entry.getValue());
                        }
                        builder.settings(templateSettingsBuilder.build());
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            String mappingType = currentFieldName;
                            Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                            builder.putMapping(mappingType, XContentFactory.jsonBuilder().map(mappingSource).string());
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    IndexMetaData.Custom.Factory factory = IndexMetaData.lookupFactory(currentFieldName);
                    if (factory == null) {
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(factory.type(), (IndexMetaData.Custom)factory.fromXContent(parser));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!"mappings".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Map<String, Object> mapping = parser.mapOrdered();
                        if (mapping.size() != 1) continue;
                        String mappingType = mapping.keySet().iterator().next();
                        String mappingSource = XContentFactory.jsonBuilder().map(mapping).string();
                        if (mappingSource == null) continue;
                        builder.putMapping(mappingType, mappingSource);
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("template".equals(currentFieldName)) {
                    builder.template(parser.text());
                    continue;
                }
                if (!"order".equals(currentFieldName)) continue;
                builder.order(parser.intValue());
            }
            return builder.build();
        }

        private static String skipTemplateName(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token != null && token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (VALID_FIELDS.contains(currentFieldName)) {
                    return currentFieldName;
                }
                parser.nextToken();
            }
            return null;
        }

        public static IndexTemplateMetaData readFrom(StreamInput in) throws IOException {
            int i;
            Builder builder = new Builder(in.readString());
            builder.order(in.readInt());
            builder.template(in.readString());
            builder.settings(ImmutableSettings.readSettingsFromStream(in));
            int mappingsSize = in.readVInt();
            for (int i2 = 0; i2 < mappingsSize; ++i2) {
                builder.putMapping(in.readString(), CompressedString.readCompressedString(in));
            }
            if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
                int aliasesSize = in.readVInt();
                for (i = 0; i < aliasesSize; ++i) {
                    AliasMetaData aliasMd = AliasMetaData.Builder.readFrom(in);
                    builder.putAlias(aliasMd);
                }
            }
            int customSize = in.readVInt();
            for (i = 0; i < customSize; ++i) {
                String type = in.readString();
                Object customIndexMetaData = IndexMetaData.lookupFactorySafe(type).readFrom(in);
                builder.putCustom(type, (IndexMetaData.Custom)customIndexMetaData);
            }
            return builder.build();
        }

        public static void writeTo(IndexTemplateMetaData indexTemplateMetaData, StreamOutput out) throws IOException {
            out.writeString(indexTemplateMetaData.name());
            out.writeInt(indexTemplateMetaData.order());
            out.writeString(indexTemplateMetaData.template());
            ImmutableSettings.writeSettingsToStream(indexTemplateMetaData.settings(), out);
            out.writeVInt(indexTemplateMetaData.mappings().size());
            for (ObjectObjectCursor<String, CompressedString> objectObjectCursor : indexTemplateMetaData.mappings()) {
                out.writeString((String)objectObjectCursor.key);
                ((CompressedString)objectObjectCursor.value).writeTo(out);
            }
            if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
                out.writeVInt(indexTemplateMetaData.aliases().size());
                for (ObjectCursor objectCursor : indexTemplateMetaData.aliases().values()) {
                    AliasMetaData.Builder.writeTo((AliasMetaData)objectCursor.value, out);
                }
            }
            out.writeVInt(indexTemplateMetaData.customs().size());
            for (ObjectObjectCursor objectObjectCursor : indexTemplateMetaData.customs()) {
                out.writeString((String)objectObjectCursor.key);
                IndexMetaData.lookupFactorySafe((String)objectObjectCursor.key).writeTo((IndexMetaData.Custom)objectObjectCursor.value, out);
            }
        }

        static {
            VALID_FIELDS.addAll(IndexMetaData.customFactories.keySet());
        }
    }
}

