/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.ObjectDirectory;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachedObjectDirectory
extends FileObjectDatabase {
    private final ObjectIdOwnerMap<UnpackedObjectId> unpackedObjects = new ObjectIdOwnerMap();
    private final ObjectDirectory wrapped;
    private FileObjectDatabase.AlternateHandle[] alts;

    CachedObjectDirectory(ObjectDirectory wrapped) {
        this.wrapped = wrapped;
        File objects = wrapped.getDirectory();
        String[] fanout = objects.list();
        if (fanout == null) {
            fanout = new String[]{};
        }
        for (String d : fanout) {
            String[] entries;
            if (d.length() != 2 || (entries = new File(objects, d).list()) == null) continue;
            for (String e : entries) {
                if (e.length() != 38) continue;
                try {
                    ObjectId id = ObjectId.fromString(d + e);
                    this.unpackedObjects.add(new UnpackedObjectId(id));
                }
                catch (IllegalArgumentException notAnObject) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this;
    }

    @Override
    FileObjectDatabase newCachedFileObjectDatabase() {
        return this;
    }

    @Override
    File getDirectory() {
        return this.wrapped.getDirectory();
    }

    @Override
    Config getConfig() {
        return this.wrapped.getConfig();
    }

    @Override
    FS getFS() {
        return this.wrapped.getFS();
    }

    @Override
    Set<ObjectId> getShallowCommits() throws IOException {
        return this.wrapped.getShallowCommits();
    }

    @Override
    Collection<? extends CachedPack> getCachedPacks() throws IOException {
        return this.wrapped.getCachedPacks();
    }

    @Override
    FileObjectDatabase.AlternateHandle[] myAlternates() {
        if (this.alts == null) {
            FileObjectDatabase.AlternateHandle[] src = this.wrapped.myAlternates();
            this.alts = new FileObjectDatabase.AlternateHandle[src.length];
            for (int i = 0; i < this.alts.length; ++i) {
                FileObjectDatabase s = src[i].db;
                this.alts[i] = new FileObjectDatabase.AlternateHandle(s.newCachedFileObjectDatabase());
            }
        }
        return this.alts;
    }

    @Override
    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id) throws IOException {
        this.wrapped.resolve(matches, id);
    }

    @Override
    boolean tryAgain1() {
        return this.wrapped.tryAgain1();
    }

    @Override
    public boolean has(AnyObjectId objectId) {
        return this.hasObjectImpl1(objectId);
    }

    @Override
    boolean hasObject1(AnyObjectId objectId) {
        return this.unpackedObjects.contains(objectId) || this.wrapped.hasObject1(objectId);
    }

    @Override
    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        return this.openObjectImpl1(curs, objectId);
    }

    @Override
    ObjectLoader openObject1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return this.wrapped.openObject2(curs, objectId.name(), objectId);
        }
        return this.wrapped.openObject1(curs, objectId);
    }

    @Override
    boolean hasObject2(String objectId) {
        return this.unpackedObjects.contains(ObjectId.fromString(objectId));
    }

    @Override
    ObjectLoader openObject2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return this.wrapped.openObject2(curs, objectName, objectId);
        }
        return null;
    }

    @Override
    long getObjectSize1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return this.wrapped.getObjectSize2(curs, objectId.name(), objectId);
        }
        return this.wrapped.getObjectSize1(curs, objectId);
    }

    @Override
    long getObjectSize2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return this.wrapped.getObjectSize2(curs, objectName, objectId);
        }
        return -1L;
    }

    @Override
    FileObjectDatabase.InsertLooseObjectResult insertUnpackedObject(File tmp, ObjectId objectId, boolean createDuplicate) throws IOException {
        FileObjectDatabase.InsertLooseObjectResult result = this.wrapped.insertUnpackedObject(tmp, objectId, createDuplicate);
        switch (result) {
            case INSERTED: 
            case EXISTS_LOOSE: {
                this.unpackedObjects.addIfAbsent(new UnpackedObjectId(objectId));
                break;
            }
        }
        return result;
    }

    @Override
    PackFile openPack(File pack) throws IOException {
        return this.wrapped.openPack(pack);
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        this.wrapped.selectObjectRepresentation(packer, otp, curs);
    }

    private static class UnpackedObjectId
    extends ObjectIdOwnerMap.Entry {
        UnpackedObjectId(AnyObjectId id) {
            super(id);
        }
    }
}

