/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.google.common.base.Strings;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class CiXStreamWriter
implements CiWriter {
    private final HierarchicalStreamWriter writer;
    private final boolean suppressOuterElement;
    private Writer stringWriter = null;
    private final DateTimeAdapter dateTimeAdapter = new DateTimeAdapter();
    private boolean suppressListElement = false;
    private Deque<Boolean> suppressListStack = new ArrayDeque<Boolean>();

    public CiXStreamWriter() {
        this.stringWriter = new StringWriter();
        this.writer = new PrettyPrintWriter(this.stringWriter);
        this.suppressOuterElement = false;
    }

    public CiXStreamWriter(HierarchicalStreamWriter writer) {
        this(writer, false);
    }

    public CiXStreamWriter(HierarchicalStreamWriter writer, boolean suppressOuterElement) {
        this.writer = writer;
        this.suppressOuterElement = suppressOuterElement;
    }

    public String toString() {
        if (this.stringWriter != null) {
            return this.stringWriter.toString();
        }
        return this.writer.toString();
    }

    @Override
    public void startList() {
        if (this.suppressListElement) {
            return;
        }
        this.writer.startNode("list");
    }

    @Override
    public void endList() {
        if (this.suppressListElement) {
            return;
        }
        this.writer.endNode();
    }

    @Override
    public void startCi(String type, String id) {
        if (!this.suppressOuterElement) {
            this.writer.startNode(type);
        }
        this.writer.addAttribute("id", id);
    }

    @Override
    public void endCi() {
        if (this.suppressOuterElement) {
            return;
        }
        this.writer.endNode();
    }

    @Override
    public void token(String token) {
        this.writer.addAttribute("token", Strings.nullToEmpty((String)token));
    }

    @Override
    public void ciAttributes(CiAttributes ciAttributes) {
        this.addStringAttribute("created-by", ciAttributes.getCreatedBy());
        this.addDateAttribute("created-at", ciAttributes.getCreatedAt());
        this.addStringAttribute("last-modified-by", ciAttributes.getLastModifiedBy());
        this.addDateAttribute("last-modified-at", ciAttributes.getLastModifiedAt());
    }

    private void addStringAttribute(String attrName, String attrValue) {
        if (attrValue != null) {
            this.writer.addAttribute(attrName, attrValue);
        }
    }

    private void addDateAttribute(String attrName, DateTime attrValue) {
        if (attrValue != null) {
            this.writer.addAttribute(attrName, this.dateTimeAdapter.marshal(attrValue));
        }
    }

    @Override
    public void startProperty(String name) {
        this.writer.startNode(name);
        this.suppressListStack.push(this.suppressListElement);
        this.suppressListElement = true;
    }

    @Override
    public void endProperty() {
        this.suppressListElement = this.suppressListStack.pop();
        this.writer.endNode();
    }

    @Override
    public void valueAsString(Object value) {
        this.writer.setValue(String.valueOf(value));
    }

    @Override
    public void valuesAsStrings(Collection<?> values) {
        for (Object value : values) {
            this.writer.startNode("value");
            this.valueAsString(value);
            this.writer.endNode();
        }
    }

    @Override
    public void mapAsStrings(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.writer.startNode("entry");
            this.writer.addAttribute("key", entry.getKey().toString());
            this.valueAsString(entry.getValue());
            this.writer.endNode();
        }
    }

    @Override
    public void ciReference(String reference) {
        this.writer.addAttribute("ref", reference);
    }

    @Override
    public void ciReferences(Collection<String> references) {
        for (String reference : references) {
            this.writer.startNode("ci");
            this.ciReference(reference);
            this.writer.endNode();
        }
    }

    @Override
    public void typedCiReference(ConfigurationItemId ci) {
        this.writer.startNode("ci");
        this.writer.addAttribute("ref", ci.getId());
        if (ci.getType() != null) {
            this.writer.addAttribute("type", ci.getType().toString());
        }
        this.writer.endNode();
    }

    @Override
    public void typedCiReferences(Collection<ConfigurationItemId> references) {
        this.writer.startNode("list");
        for (ConfigurationItemId item : references) {
            this.typedCiReference(item);
        }
        this.writer.endNode();
    }

    @Override
    public void validationMessages(List<ValidationMessage> validations) {
        this.writer.startNode("validation-messages");
        for (ValidationMessage validation : validations) {
            this.writer.startNode("validation-message");
            this.writer.addAttribute("ci", validation.getCiId());
            if (validation.getPropertyName() != null) {
                this.writer.addAttribute("property", validation.getPropertyName());
            }
            this.writer.setValue(validation.getMessage());
            this.writer.endNode();
        }
        this.writer.endNode();
    }
}

