/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractInternalPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;

public class InternalPercentiles
extends AbstractInternalPercentiles
implements Percentiles {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentiles");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalPercentiles readResult(StreamInput in) throws IOException {
            InternalPercentiles result = new InternalPercentiles();
            result.readFrom(in);
            return result;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalPercentiles() {
    }

    public InternalPercentiles(String name, double[] percents, TDigestState state, boolean keyed) {
        super(name, percents, state, keyed);
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percentile(double percent) {
        return this.state.quantile(percent / 100.0);
    }

    @Override
    public double value(double key) {
        return this.percentile(key);
    }

    @Override
    protected AbstractInternalPercentiles createReduced(String name, double[] keys, TDigestState merged, boolean keyed) {
        return new InternalPercentiles(name, keys, merged, keyed);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    public static class Iter
    extends UnmodifiableIterator<Percentile> {
        private final double[] percents;
        private final TDigestState state;
        private int i;

        public Iter(double[] percents, TDigestState state) {
            this.percents = percents;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        @Override
        public Percentile next() {
            InternalPercentile next = new InternalPercentile(this.percents[this.i], this.state.quantile(this.percents[this.i] / 100.0));
            ++this.i;
            return next;
        }
    }
}

