/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.replication.IndexReplicationOperationRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportIndexReplicationOperationAction<Request extends IndexReplicationOperationRequest, Response extends ActionResponse, ShardRequest extends ShardReplicationOperationRequest, ShardReplicaRequest extends ShardReplicationOperationRequest, ShardResponse extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportShardReplicationOperationAction<ShardRequest, ShardReplicaRequest, ShardResponse> shardAction;

    protected TransportIndexReplicationOperationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportShardReplicationOperationAction<ShardRequest, ShardReplicaRequest, ShardResponse> shardAction) {
        super(settings, actionName, threadPool);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        transportService.registerHandler(actionName, new TransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        GroupShardsIterator groups;
        ClusterState clusterState = this.clusterService.state();
        ClusterBlockException blockException = this.checkGlobalBlock(clusterState, request);
        if (blockException != null) {
            throw blockException;
        }
        ((IndexReplicationOperationRequest)request).index(clusterState.metaData().concreteSingleIndex(((IndexReplicationOperationRequest)request).index()));
        blockException = this.checkRequestBlock(clusterState, request);
        if (blockException != null) {
            throw blockException;
        }
        try {
            groups = this.shards(request);
        }
        catch (Throwable e) {
            listener.onFailure(e);
            return;
        }
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger failureCounter = new AtomicInteger();
        AtomicInteger completionCounter = new AtomicInteger(groups.size());
        final AtomicReferenceArray shardsResponses = new AtomicReferenceArray(groups.size());
        for (ShardIterator shardIt : groups) {
            ShardRequest shardRequest = this.newShardRequestInstance(request, shardIt.shardId().id());
            ((ShardReplicationOperationRequest)shardRequest).beforeLocalFork();
            ((ShardReplicationOperationRequest)shardRequest).operationThreaded(true);
            ((ActionRequest)shardRequest).listenerThreaded(false);
            this.shardAction.execute(shardRequest, new ActionListener<ShardResponse>((IndexReplicationOperationRequest)request, shardIt, completionCounter, listener){
                final /* synthetic */ IndexReplicationOperationRequest val$request;
                final /* synthetic */ ShardIterator val$shardIt;
                final /* synthetic */ AtomicInteger val$completionCounter;
                final /* synthetic */ ActionListener val$listener;
                {
                    this.val$request = indexReplicationOperationRequest;
                    this.val$shardIt = shardIterator;
                    this.val$completionCounter = atomicInteger3;
                    this.val$listener = actionListener;
                }

                @Override
                public void onResponse(ShardResponse result) {
                    shardsResponses.set(indexCounter.getAndIncrement(), new ShardActionResult(TransportIndexReplicationOperationAction.this, (ActionResponse)result));
                    this.returnIfNeeded();
                }

                @Override
                public void onFailure(Throwable e) {
                    failureCounter.getAndIncrement();
                    int index = indexCounter.getAndIncrement();
                    if (TransportIndexReplicationOperationAction.this.accumulateExceptions()) {
                        shardsResponses.set(index, new ShardActionResult(TransportIndexReplicationOperationAction.this, new DefaultShardOperationFailedException(this.val$request.index, this.val$shardIt.shardId().id(), e)));
                    }
                    this.returnIfNeeded();
                }

                private void returnIfNeeded() {
                    if (this.val$completionCounter.decrementAndGet() == 0) {
                        ArrayList<ActionResponse> responses = Lists.newArrayList();
                        ArrayList<ShardOperationFailedException> failures = Lists.newArrayList();
                        for (int i = 0; i < shardsResponses.length(); ++i) {
                            ShardActionResult shardActionResult = (ShardActionResult)shardsResponses.get(i);
                            if (shardActionResult == null) {
                                assert (!TransportIndexReplicationOperationAction.this.accumulateExceptions());
                                continue;
                            }
                            if (shardActionResult.isFailure()) {
                                assert (TransportIndexReplicationOperationAction.this.accumulateExceptions() && shardActionResult.shardFailure != null);
                                failures.add(shardActionResult.shardFailure);
                                continue;
                            }
                            responses.add(shardActionResult.shardResponse);
                        }
                        assert (failures.size() == 0 || failures.size() == failureCounter.get());
                        this.val$listener.onResponse(TransportIndexReplicationOperationAction.this.newResponseInstance(this.val$request, responses, failureCounter.get(), failures));
                    }
                }
            });
        }
    }

    protected abstract Request newRequestInstance();

    protected abstract Response newResponseInstance(Request var1, List<ShardResponse> var2, int var3, List<ShardOperationFailedException> var4);

    protected abstract GroupShardsIterator shards(Request var1) throws ElasticsearchException;

    protected abstract ShardRequest newShardRequestInstance(Request var1, int var2);

    protected abstract boolean accumulateExceptions();

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2);

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportIndexReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportIndexReplicationOperationAction.this.execute(request, new ActionListener<Response>((IndexReplicationOperationRequest)request){
                final /* synthetic */ IndexReplicationOperationRequest val$request;
                {
                    this.val$request = indexReplicationOperationRequest;
                }

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportIndexReplicationOperationAction.this.logger.warn("Failed to send error response for action [" + TransportIndexReplicationOperationAction.this.actionName + "] and request [" + this.val$request + "]", e1, new Object[0]);
                    }
                }
            });
        }
    }

    private static class ShardActionResult {
        private final ShardResponse shardResponse;
        private final ShardOperationFailedException shardFailure;
        final /* synthetic */ TransportIndexReplicationOperationAction this$0;

        private ShardActionResult(ShardResponse shardResponse) {
            this.this$0 = var1_1;
            assert (shardResponse != null);
            this.shardResponse = shardResponse;
            this.shardFailure = null;
        }

        private ShardActionResult(TransportIndexReplicationOperationAction transportIndexReplicationOperationAction, ShardOperationFailedException shardOperationFailedException) {
            this.this$0 = transportIndexReplicationOperationAction;
            assert (shardOperationFailedException != null);
            this.shardFailure = shardOperationFailedException;
            this.shardResponse = null;
        }

        boolean isFailure() {
            return this.shardFailure != null;
        }
    }
}

