#
# Basic execution of test cases on a host
#
from com.xebialabs.overthere.util import CapturingOverthereExecutionOutputHandler
import com.xebialabs.xltest.domain.Event as Event
import java.util.Date as Date

host = self.host

if host.hasProperty('jobParameters'):
    jobParameters = dict(parameters)
    jobParameters['XL_TEST_RUN_ID'] = testRunId
    host.setProperty('jobParameters', jobParameters)

connection = host.getConnection()
exitCode = -1
importStartDate = Date()
eventHandler.onReceive(Event(testRunId, Event.EXECUTION_STARTED, {"commandLine": resolvedCommandLine, "parameters": parameters}))
try:
    print "Performing:", str(self.cmdLine), "on host", str(host)
    stdoutHandler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    stderrHandler = CapturingOverthereExecutionOutputHandler.capturingHandler()
    workingDirectory = self.getWorkingDirectory()
    if workingDirectory and (len(str(workingDirectory)) > 0):
        connection.setWorkingDirectory(connection.getFile(str(workingDirectory)))
        print 'Set up the handlers, now executing in working directory %s...' % str(self.getWorkingDirectory())
    else:
        print "Set up the handlers, now executing in default working directory..."
    exitCode = connection.execute(stdoutHandler, stderrHandler, self.getCmdLine(resolvedCommandLine))

    for line in stdoutHandler.getOutputLines():
        print "output:", line
    for line in stderrHandler.getOutputLines():
        print "error:", line

    print "All done, no exceptions"
finally:
    connection.close()
    # TODO: add "failureReason" property when needed.
    eventHandler.onReceive(Event(testRunId, Event.EXECUTION_FINISHED, {"exitCode": exitCode}))

resultHolder.setResult(exitCode)
