/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.ByteArrayFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class OverthereUtils {
    public static byte[] read(final OverthereFile from) {
        try {
            return ByteStreams.toByteArray((InputSupplier)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return from.getInputStream();
                }
            });
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static String read(final OverthereFile from, final String charsetName) {
        try {
            return CharStreams.toString((InputSupplier)new InputSupplier<Reader>(){

                public Reader getInput() throws IOException {
                    return new InputStreamReader(from.getInputStream(), charsetName);
                }
            });
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void write(byte[] from, OverthereFile to) {
        new ByteArrayFile(to.getPath(), from).copyTo(to);
    }

    public static void write(String from, String charsetName, OverthereFile to) {
        try {
            OverthereUtils.write(from.getBytes(charsetName), to);
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException("Cannot write string to " + to, exc);
        }
    }

    public static String getName(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            return path.substring(lastSlash + 1);
        }
        int lastBackslash = path.lastIndexOf(92);
        if (lastBackslash >= 0) {
            return path.substring(lastBackslash + 1);
        }
        return path;
    }

    public static String getBaseName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            return name.substring(0, dot);
        }
        return name;
    }

    public static String getExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            return name.substring(dot);
        }
        return "";
    }

    public static String constructPath(OverthereFile parent, String child) {
        return parent.getPath() + parent.getConnection().getHostOperatingSystem().getFileSeparator() + child;
    }

    public static void closeQuietly(Closeable c) {
        try {
            Closeables.close((Closeable)c, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

