/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class RequestParamMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    private final boolean useDefaultResolution;

    public RequestParamMethodArgumentResolver(ConfigurableBeanFactory beanFactory, boolean useDefaultResolution) {
        super(beanFactory);
        this.useDefaultResolution = useDefaultResolution;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            if (Map.class.isAssignableFrom(paramType)) {
                String paramName = ((RequestParam)parameter.getParameterAnnotation(RequestParam.class)).value();
                return StringUtils.hasText((String)paramName);
            }
            return true;
        }
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return false;
        }
        if (MultipartFile.class.equals((Object)paramType) || "javax.servlet.http.Part".equals(paramType.getName())) {
            return true;
        }
        if (this.useDefaultResolution) {
            return BeanUtils.isSimpleProperty((Class)paramType);
        }
        return false;
    }

    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestParam annotation = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        return annotation != null ? new RequestParamNamedValueInfo(annotation) : new RequestParamNamedValueInfo();
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest webRequest) throws Exception {
        String[] arg;
        HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
        MultipartHttpServletRequest multipartRequest = WebUtils.getNativeRequest((ServletRequest)servletRequest, MultipartHttpServletRequest.class);
        if (MultipartFile.class.equals((Object)parameter.getParameterType())) {
            this.assertIsMultipartRequest(servletRequest);
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFile(name);
        } else if (this.isMultipartFileCollection(parameter)) {
            this.assertIsMultipartRequest(servletRequest);
            Assert.notNull((Object)multipartRequest, (String)"Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
            arg = multipartRequest.getFiles(name);
        } else if ("javax.servlet.http.Part".equals(parameter.getParameterType().getName())) {
            this.assertIsMultipartRequest(servletRequest);
            arg = servletRequest.getPart(name);
        } else {
            String[] paramValues;
            List files;
            arg = null;
            if (multipartRequest != null && !(files = multipartRequest.getFiles(name)).isEmpty()) {
                String[] stringArray = arg = files.size() == 1 ? files.get(0) : files;
            }
            if (arg == null && (paramValues = webRequest.getParameterValues(name)) != null) {
                arg = paramValues.length == 1 ? paramValues[0] : paramValues;
            }
        }
        return arg;
    }

    private void assertIsMultipartRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/")) {
            throw new MultipartException("The current request is not a multipart request");
        }
    }

    private boolean isMultipartFileCollection(MethodParameter parameter) {
        Class valueType;
        Class paramType = parameter.getParameterType();
        return (Collection.class.equals((Object)paramType) || List.class.isAssignableFrom(paramType)) && (valueType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)parameter)) != null && valueType.equals(MultipartFile.class);
    }

    protected void handleMissingValue(String paramName, MethodParameter parameter) throws ServletException {
        throw new MissingServletRequestParameterException(paramName, parameter.getParameterType().getSimpleName());
    }

    private static class RequestParamNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        public RequestParamNamedValueInfo() {
            super("", false, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        public RequestParamNamedValueInfo(RequestParam annotation) {
            super(annotation.value(), annotation.required(), annotation.defaultValue());
        }
    }
}

