/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.warmer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class IndexWarmersMetaData
implements IndexMetaData.Custom {
    public static final String TYPE = "warmers";
    public static final Factory FACTORY = new Factory();
    private final ImmutableList<Entry> entries;

    public IndexWarmersMetaData(Entry ... entries) {
        this.entries = ImmutableList.copyOf(entries);
    }

    public ImmutableList<Entry> entries() {
        return this.entries;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public static class Factory
    implements IndexMetaData.Custom.Factory<IndexWarmersMetaData> {
        @Override
        public String type() {
            return IndexWarmersMetaData.TYPE;
        }

        @Override
        public IndexWarmersMetaData readFrom(StreamInput in) throws IOException {
            Entry[] entries = new Entry[in.readVInt()];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = new Entry(in.readString(), in.readStringArray(), in.readBoolean() ? in.readBytesReference() : null);
            }
            return new IndexWarmersMetaData(entries);
        }

        @Override
        public void writeTo(IndexWarmersMetaData warmers, StreamOutput out) throws IOException {
            out.writeVInt(warmers.entries().size());
            for (Entry entry : warmers.entries()) {
                out.writeString(entry.name());
                out.writeStringArray(entry.types());
                if (entry.source() == null) {
                    out.writeBoolean(false);
                    continue;
                }
                out.writeBoolean(true);
                out.writeBytesReference(entry.source());
            }
        }

        @Override
        public IndexWarmersMetaData fromMap(Map<String, Object> map) throws IOException {
            if (map.size() == 1 && map.containsKey(IndexWarmersMetaData.TYPE)) {
                map = (Map)map.values().iterator().next();
            }
            XContentBuilder builder = XContentFactory.smileBuilder().map(map);
            try (XContentParser parser = XContentFactory.xContent(XContentType.SMILE).createParser(builder.bytes());){
                parser.nextToken();
                IndexWarmersMetaData indexWarmersMetaData = this.fromXContent(parser);
                return indexWarmersMetaData;
            }
        }

        @Override
        public IndexWarmersMetaData fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            String currentFieldName = null;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                String name = currentFieldName;
                ArrayList<String> types = new ArrayList<String>(2);
                BytesReference source = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (!"types".equals(currentFieldName)) continue;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            types.add(parser.text());
                        }
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        if (!"source".equals(currentFieldName)) continue;
                        XContentBuilder builder = XContentFactory.jsonBuilder().map(parser.mapOrdered());
                        source = builder.bytes();
                        continue;
                    }
                    if (token != XContentParser.Token.VALUE_EMBEDDED_OBJECT || !"source".equals(currentFieldName)) continue;
                    source = new BytesArray(parser.binaryValue());
                }
                entries.add(new Entry(name, types.size() == 0 ? Strings.EMPTY_ARRAY : types.toArray(new String[types.size()]), source));
            }
            return new IndexWarmersMetaData(entries.toArray(new Entry[entries.size()]));
        }

        @Override
        public void toXContent(IndexWarmersMetaData warmers, XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Entry entry : warmers.entries()) {
                this.toXContent(entry, builder, params);
            }
        }

        @Override
        public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject(entry.name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("types", entry.types());
            builder.field("source");
            if (binary) {
                builder.value(entry.source());
            } else {
                Map<String, Object> mapping = XContentFactory.xContent(entry.source()).createParser(entry.source()).mapOrderedAndClose();
                builder.map(mapping);
            }
            builder.endObject();
        }

        @Override
        public IndexWarmersMetaData merge(IndexWarmersMetaData first, IndexWarmersMetaData second) {
            ArrayList<Entry> entries = Lists.newArrayList();
            entries.addAll(first.entries());
            for (Entry secondEntry : second.entries()) {
                boolean found = false;
                for (Entry firstEntry : first.entries()) {
                    if (!firstEntry.name().equals(secondEntry.name())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                entries.add(secondEntry);
            }
            return new IndexWarmersMetaData(entries.toArray(new Entry[entries.size()]));
        }
    }

    public static class Entry {
        private final String name;
        private final String[] types;
        private final BytesReference source;

        public Entry(String name, String[] types, BytesReference source) {
            this.name = name;
            this.types = types == null ? Strings.EMPTY_ARRAY : types;
            this.source = source;
        }

        public String name() {
            return this.name;
        }

        public String[] types() {
            return this.types;
        }

        @Nullable
        public BytesReference source() {
            return this.source;
        }
    }
}

