/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public interface AtomicFieldData<Script extends ScriptDocValues>
extends Accountable {
    public BytesValues getBytesValues();

    public Script getScriptValues();

    public void close();

    public static enum Order {
        BYTES,
        NUMERIC,
        CUSTOM,
        NONE;

    }

    public static interface WithOrdinals<Script extends ScriptDocValues>
    extends AtomicFieldData<Script> {
        public static final WithOrdinals<ScriptDocValues.Strings> EMPTY = new WithOrdinals<ScriptDocValues.Strings>(){

            @Override
            public ScriptDocValues.Strings getScriptValues() {
                return new ScriptDocValues.Strings(this.getBytesValues());
            }

            @Override
            public void close() {
            }

            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public BytesValues.WithOrdinals getBytesValues() {
                return new BytesValues.WithOrdinals(false){

                    @Override
                    public int setDocument(int docId) {
                        return 0;
                    }

                    @Override
                    public long nextOrd() {
                        return -1L;
                    }

                    @Override
                    public BytesRef getValueByOrd(long ord) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long getOrd(int docId) {
                        return -1L;
                    }

                    @Override
                    public long getMaxOrd() {
                        return 0L;
                    }
                };
            }
        };

        @Override
        public BytesValues.WithOrdinals getBytesValues();
    }
}

