/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class PercolateShardRequest
extends BroadcastShardOperationRequest {
    private String documentType;
    private BytesReference source;
    private BytesReference docSource;
    private boolean onlyCount;
    private int numberOfShards;

    public PercolateShardRequest() {
    }

    public PercolateShardRequest(String index, int shardId) {
        super(index, shardId);
    }

    public PercolateShardRequest(String index, int shardId, int numberOfShards, PercolateRequest request) {
        super(index, shardId, request);
        this.documentType = request.documentType();
        this.source = request.source();
        this.docSource = request.docSource();
        this.onlyCount = request.onlyCount();
        this.numberOfShards = numberOfShards;
    }

    public PercolateShardRequest(ShardId shardId, PercolateRequest request) {
        super(shardId.index().name(), shardId.id());
        this.documentType = request.documentType();
        this.source = request.source();
        this.docSource = request.docSource();
        this.onlyCount = request.onlyCount();
    }

    public String documentType() {
        return this.documentType;
    }

    public BytesReference source() {
        return this.source;
    }

    public BytesReference docSource() {
        return this.docSource;
    }

    public boolean onlyCount() {
        return this.onlyCount;
    }

    void documentType(String documentType) {
        this.documentType = documentType;
    }

    void source(BytesReference source) {
        this.source = source;
    }

    void docSource(BytesReference docSource) {
        this.docSource = docSource;
    }

    void onlyCount(boolean onlyCount) {
        this.onlyCount = onlyCount;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.documentType = in.readString();
        this.source = in.readBytesReference();
        this.docSource = in.readBytesReference();
        this.onlyCount = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_1_2_0)) {
            this.numberOfShards = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.documentType);
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.docSource);
        out.writeBoolean(this.onlyCount);
        if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
            out.writeVInt(this.numberOfShards);
        }
    }
}

