/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlt.plugin.api.resultparser;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParser;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.UUID;

public class TestResultParserDriver {
    private final TestResultParser testResultParser;

    public TestResultParserDriver(TestResultParser testResultParser) {
        this.testResultParser = (TestResultParser)Preconditions.checkNotNull((Object)testResultParser);
    }

    public List<List<Event>> run(SortedSet<OverthereFile> files, String testSpecificationName) throws ImportException {
        ArrayList<List<Event>> runs = new ArrayList<List<Event>>();
        for (List<Event> eventList : this.testResultParser.generateEventsFromFiles(new ArrayList<OverthereFile>(files))) {
            UUID runId = UUID.randomUUID();
            this.updateEvents(eventList, runId, testSpecificationName);
            runs.add(new ArrayList<Event>(eventList));
        }
        return runs;
    }

    private void updateEvents(List<Event> eventList, UUID runId, String testSpecificationName) {
        for (Event e : eventList) {
            e.setTestRunId(runId.toString());
            if (!Strings.isNullOrEmpty((String)e.getTestSpecificationName())) continue;
            e.setTestSpecificationName(testSpecificationName);
        }
    }
}

