package com.xebialabs.xltest.jenkins;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;

import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

class StatusCodeAndContent {
    private final JsonProvider jsonProvider;

    final int statusCode;
    final Object json;

    public StatusCodeAndContent(int statusCode, String content) {
        this.jsonProvider = JsonProviderFactory.createProvider();
        this.statusCode = statusCode;
        this.json = jsonProvider.parse(content);
    }


    public <T> T path(String path) {
        return JsonPath.read(json, path);
    }

    public int pathCount(String path) {
        Object results = JsonPath.read(json, path);
        if (results instanceof JSONArray) {
            return ((JSONArray) results).size();
        } else if (results instanceof JSONObject) {
            return ((JSONObject) results).size();
        }
        return results != null ? 1 : 0;

    }
}
