/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.xebialabs.xltest.jenkins.StatusCodeAndContent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jboss.resteasy.util.Base64;

public class JenkinsRequest {
    private final Boolean useAuthorization;
    private final String encoding;

    public JenkinsRequest(String userName, String password) {
        Preconditions.checkNotNull((Object)userName);
        this.useAuthorization = true;
        String userPassword = userName + ":" + (password == null ? "" : password);
        this.encoding = new String(Base64.encodeBytes((byte[])userPassword.getBytes()));
    }

    public JenkinsRequest() {
        this.useAuthorization = false;
        this.encoding = "";
    }

    public StatusCodeAndContent httpGetRequest(URL url) throws IOException {
        return this.httpRequest("GET", url);
    }

    public StatusCodeAndContent httpPostRequest(URL url) throws IOException {
        return this.httpRequest("POST", url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCodeAndContent httpRequest(String method, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestMethod(method);
            connection.setConnectTimeout(5000);
            if (this.useAuthorization.booleanValue()) {
                connection.setRequestProperty("Authorization", "Basic " + this.encoding);
            }
            int statusCode = connection.getResponseCode();
            String content = CharStreams.toString((Readable)new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            StatusCodeAndContent statusCodeAndContent = new StatusCodeAndContent(statusCode, content);
            return statusCodeAndContent;
        }
        finally {
            connection.disconnect();
        }
    }
}

