package com.xebialabs.xltest.jenkins;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jboss.resteasy.util.Base64;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;

public class JenkinsRequest {
    private final Boolean useAuthorization;
    private final String encoding;

    /**
     * Construct a JenkinsRequest that uses authorization
     *
     * @param userName userName to be used
     * @param password password to be used
     */
    public JenkinsRequest(String userName, String password) {
        Preconditions.checkNotNull(userName);
        this.useAuthorization = true;
        String userPassword = userName + ":" + (password == null ? "" : password);
        this.encoding = new String(Base64.encodeBytes(userPassword.getBytes()));
    }

    /**
     * Construct a JenkinsRequest that uses no authorization
     */
    public JenkinsRequest() {
        this.useAuthorization = false;
        this.encoding = "";
    }

    public StatusCodeAndContent httpGetRequest(URL url) throws IOException {
        return httpRequest("GET", url);
    }

    public StatusCodeAndContent httpPostRequest(URL url) throws IOException {
        return httpRequest("POST", url);
    }

    public StatusCodeAndContent httpRequest(String method, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        try {
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestMethod(method);
            connection.setConnectTimeout(5000);
            if (useAuthorization) {
                connection.setRequestProperty("Authorization", "Basic " + encoding);
            }

            int statusCode = connection.getResponseCode();
            String content = CharStreams.toString(new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            return new StatusCodeAndContent(statusCode, content);
        } finally {
            connection.disconnect();
        }
    }

}