/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.gatling;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.gatling.GatlingSimulationLogImporter;
import com.xebialabs.xltest.utils.OverthereFileComparator;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class GatlingTestTool
extends BaseTestTool {
    public String getName() {
        return "Gatling";
    }

    public List<Importable> findImportables(OverthereFile resultPath, FileMatcher fileMatcher) throws ImportFailedException {
        SortedSet<OverthereFile> testResultFiles = this.findTestResultPaths(resultPath, fileMatcher);
        ArrayList<Importable> importables = new ArrayList<Importable>();
        for (OverthereFile each : testResultFiles) {
            importables.add((Importable)new GatlingSimulationLogImporter(each));
        }
        return importables;
    }

    public String getDefaultSearchPattern() {
        return "**/simulation.log";
    }

    public String getCategory() {
        return "performance";
    }

    public SortedSet<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher) {
        SortedSet testResultFiles = super.findTestResultPaths(searchRoot, fileMatcher);
        TreeSet<OverthereFile> simulationResultDirectories = new TreeSet<OverthereFile>((Comparator<OverthereFile>)new OverthereFileComparator());
        for (OverthereFile resultFile : testResultFiles) {
            OverthereFile parentFile = resultFile.getParentFile();
            if (!parentFile.getFile("js/global_stats.json").exists()) continue;
            simulationResultDirectories.add(parentFile);
        }
        if (simulationResultDirectories.isEmpty()) {
            throw new IllegalArgumentException("No simulation result directories were found that contains both simulation.log and js/global_stats.json files");
        }
        return simulationResultDirectories;
    }
}

