package com.xebialabs.xltest.gatling;


import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class JsonParser {

    private final JsonProvider jsonProvider;
    private Object json;

    private static final Logger LOG = LoggerFactory.getLogger(JsonParser.class.getName());

    public JsonParser() {
        jsonProvider = JsonProviderFactory.createProvider();
    }

    public void parse(final String content) {
        json = jsonProvider.parse(content);
    }

    public Object getValue(final String path) {
        return JsonPath.read(json, path);
    }

}
