package com.xebialabs.xltest.gatling;

import java.util.*;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.OverthereFileComparator;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;

public class GatlingTestTool extends BaseTestTool {

    @Override
    public String getName() {
        return "Gatling";
    }

    @Override
    public List<Importable> findImportables(final OverthereFile resultPath, final FileMatcher fileMatcher) throws ImportFailedException {
        Collection<OverthereFile> testResultFiles = this.findTestResultPaths(resultPath, fileMatcher);

        List<Importable> importables = new ArrayList<>();
        for (OverthereFile each : testResultFiles) {
            importables.add(new GatlingSimulationLogImporter(each));
        }
        return importables;
    }

    @Override
    public String getDefaultSearchPattern() {
        return "**/simulation.log";
    }

    @Override
    public String getCategory() {
        return TestToolCategory.PERFORMANCE;
    }

    @Override
    public SortedSet<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher) {
        Collection<OverthereFile> testResultFiles = super.findTestResultPaths(searchRoot, fileMatcher);
        SortedSet<OverthereFile> simulationResultDirectories = new TreeSet<>(new OverthereFileComparator());
        for (OverthereFile resultFile : testResultFiles) {
            // Look for parent's parent, since we check for files/testResults
            OverthereFile parentFile = resultFile.getParentFile();
            if (parentFile.getFile("js/global_stats.json").exists()) {
                simulationResultDirectories.add(parentFile);
            }
        }
        if (simulationResultDirectories.isEmpty()) {
            throw new IllegalArgumentException("No simulation result directories were found that contains both simulation.log and js/global_stats.json files");
        }
        return simulationResultDirectories;
    }

}
