/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.xltest.fitnesse.EventMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class TestSummary
implements EventMap {
    public final String name;
    public final Set<String> tags;
    public final long timestamp;
    public final long duration;
    public final int right;
    public final int wrong;
    public final String result;
    public final int exceptions;
    public final String firstError;

    public TestSummary(String name, Set<String> tags, long timestamp, long duration, int right, int wrong, String result, int exceptions, String firstError) {
        this.name = name;
        this.tags = tags;
        this.timestamp = timestamp;
        this.duration = duration;
        this.right = right;
        this.wrong = wrong;
        this.result = wrong + exceptions > 0 ? "FAILED" : "PASSED";
        this.exceptions = exceptions;
        this.firstError = firstError;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + this.exceptions;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.right;
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.wrong;
        result = 31 * result + (this.firstError == null ? 0 : this.firstError.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSummary other = (TestSummary)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (this.exceptions != other.exceptions) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.wrong != other.wrong) {
            return false;
        }
        return !(this.firstError == null ? other.firstError != null : !this.firstError.equals(other.firstError));
    }

    public String toString() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("type", (Object)"result");
            obj.put("name", (Object)this.name);
            obj.put("tags", this.tags);
            obj.put("timestamp", this.timestamp);
            obj.put("duration", this.duration);
            obj.put("right", this.right);
            obj.put("wrong", this.wrong);
            obj.put("result", (Object)this.result);
            obj.put("exceptions", this.exceptions);
            if (this.firstError != null) {
                obj.put("firstError", (Object)this.firstError);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Can not make JSON", e);
        }
        return obj.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("tags", this.tags);
        map.put("timestamp", this.timestamp);
        map.put("duration", this.duration);
        map.put("right", this.right);
        map.put("wrong", this.wrong);
        map.put("result", this.result);
        map.put("exceptions", this.exceptions);
        if (this.firstError != null) {
            map.put("firstError", this.firstError);
        }
        return map;
    }
}

