/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.fitnesse.PageHistoryExtractor;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class FitNesseTestTool
extends BaseTestTool {
    public String getName() {
        return "FitNesse";
    }

    public Collection<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher) {
        Collection testResultFiles = super.findTestResultPaths(searchRoot, fileMatcher);
        HashSet<OverthereFile> testResultDirectories = new HashSet<OverthereFile>();
        for (OverthereFile resultFile : testResultFiles) {
            if (!resultFile.getFile("files").getFile("testResults").exists()) continue;
            testResultDirectories.add(resultFile);
        }
        return testResultDirectories;
    }

    public List<Importable> findImportables(OverthereFile remoteResultPath, FileMatcher fileMatcher) {
        LocalFile resultPath = this.retrieveFiles(remoteResultPath);
        Collection<OverthereFile> fitNesseRoots = this.findTestResultPaths((OverthereFile)resultPath, fileMatcher);
        try {
            ArrayList<Importable> importables = new ArrayList<Importable>();
            for (OverthereFile fitNesseRoot : fitNesseRoots) {
                LocalFile localFile = (LocalFile)fitNesseRoot;
                importables.addAll(new PageHistoryExtractor(localFile.getFile()).tellMeAboutAllSuites());
            }
            return importables;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine what to import from FitNesse path " + remoteResultPath, e);
        }
    }

    public String getSearchPattern() {
        return "**/FitNesseRoot";
    }

    public String getCategory() {
        return "functional";
    }
}

