package com.xebialabs.xltest.fitnesse;

import java.util.*;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;

import fitnesse.FitNesseContext;

public class FitNesseTestTool extends BaseTestTool {

    @Override
    public String getName() {
        return "FitNesse";
    }

    @Override
    public Collection<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher) {
        Collection<OverthereFile> testResultFiles = super.findTestResultPaths(searchRoot, fileMatcher);
        Set<OverthereFile> testResultDirectories = new HashSet<>();
        for (OverthereFile resultFile : testResultFiles) {
            if (resultFile.getFile("files").getFile(FitNesseContext.testResultsDirectoryName).exists()) {
                testResultDirectories.add(resultFile);
            }
        }
        return testResultDirectories;
    }

    @Override
    public List<Importable> findImportables(OverthereFile remoteResultPath, FileMatcher fileMatcher) {
        LocalFile resultPath = retrieveFiles(remoteResultPath);

        Collection<OverthereFile> fitNesseRoots = findTestResultPaths(resultPath, fileMatcher);

        try {
            List<Importable> importables = new ArrayList<>();
            for (OverthereFile fitNesseRoot : fitNesseRoots) {
                LocalFile localFile = (LocalFile) fitNesseRoot;
                importables.addAll(new PageHistoryExtractor(localFile.getFile()).tellMeAboutAllSuites());
            }
            return importables;
        } catch (Exception e) {
            throw new RuntimeException("Unable to determine what to import from FitNesse path " + remoteResultPath, e);
        }
    }

    @Override
    public String getSearchPattern() {
        return "**/FitNesseRoot";
    }

    @Override
    public String getCategory() {
        return TestToolCategory.FUNCTIONAL;
    }

}
