/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchBooter {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchBooter.class);
    public static final String INDEX_XLTEST = "xltest";
    public volatile Client client;

    public ElasticSearchBooter() {
        this.boot();
    }

    private void boot() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    java.util.logging.Logger.getLogger("org.elasticsearch").setLevel(Level.SEVERE);
                    ImmutableSettings.Builder nodeSettings = NodeBuilder.nodeBuilder().settings();
                    nodeSettings.put("network.host", "127.0.0.1");
                    nodeSettings.put("cluster.name", "elasticsearch_xltest");
                    nodeSettings.put("index.number_of_shards", 1);
                    nodeSettings.put("index.number_of_replicas", 0);
                    nodeSettings.put("node.name", "XL Test");
                    nodeSettings.put("http.enabled", "true".equals(System.getenv("DEV_MODE")) || "true".equals(System.getenv("DEV_ES_HTTP")));
                    Node node = NodeBuilder.nodeBuilder().local(true).settings(nodeSettings.build()).node();
                    ElasticSearchBooter.this.client = node.client();
                    LOG.info("ElasticSearch up and running");
                }
                catch (Throwable tr) {
                    throw new RuntimeException(tr);
                }
            }
        });
        thread.setContextClassLoader(classLoader);
        thread.start();
    }

    public void insert(String type, String json) {
        this.client.prepareIndex(INDEX_XLTEST, type).setSource(json).execute().actionGet();
    }

    public List<String> query(String query) throws IOException {
        ArrayList<String> all = new ArrayList<String>();
        QueryStringQueryBuilder b = QueryBuilders.queryString((String)query);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{INDEX_XLTEST}).setQuery((QueryBuilder)b).addSort("timestamp", SortOrder.ASC).setFrom(0).setSize(100000).execute().actionGet();
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            all.add(hit.sourceAsString());
        }
        return all;
    }
}

