package com.xebialabs.xltest.cucumber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;

public class CucumberTestTool extends BaseTestTool {

    @Override
    public String getName() {
        return "Cucumber";
    }

    @Override
    public List<Importable> findImportables(final OverthereFile searchPath, final FileMatcher fileMatcher) {
        Collection<OverthereFile> testResultFiles = globbit(searchPath, fileMatcher);

        List<Importable> importables = new ArrayList<>();
        for (OverthereFile testResult : testResultFiles) {
            importables.add(new CucumberReportJsonImporter(testResult));
        }

        return importables;
    }

    @Override
    public String getSearchPattern() {
        return "**/cucumber-report.json";
    }

    @Override
    public String getCategory() {
        return TestToolCategory.FUNCTIONAL;
    }

}
