(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[4],{

/***/ 101:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.rgbToHexString = rgbToHexString;
exports.hexToRgb = hexToRgb;
exports.hexToRgbString = hexToRgbString;
exports.default = {
    // PRIMARY COLORS
    blue: '#0079BC',
    yellow: '#FCD866',
    green: '#00875A',
    red: '#CC4A3C',
    orange: '#FFAB00',
    purple: '#991C71',

    // SECONDARY COLORS
    xldblue: '#14B0E4',
    lightblue: '#5FCBF4',
    darkblue: '#4C6C87',

    // SHADES OF GRAY
    black: '#414C58',
    antracite: '#495561',
    gray: '#65747C',
    lightgray: '#ADB9C3',
    background: '#F3F5F8',
    silver: '#F8F9FA',
    white: '#FFFFFF',

    // Semantic COLORS
    oddRowColor: '#FFFFFF',
    evenRowColor: '#F8F9FA',

    hoverColor: '#F3F5F8',
    selectedColor: '#E3E8Ef',
    highlightColor: '#CDEFDC',

    successBackground: '#E6F3EE',
    successHover: '#F6D2CE',

    warningBackground: '#FFF6E9',
    warningHover: '#FFE2C3',

    errorBackground: '#F7E4E2',
    errorHover: '#C1EBD4'
};
function rgbToHexString(r, g, b) {
    return '#' + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
}

function hexToRgb(hex) {
    // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function (m, r, g, b) {
        return r + r + g + g + b + b;
    });

    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}

function hexToRgbString(hex) {
    var rgbObject = hexToRgb(hex);
    return 'rgb(' + rgbObject.r + ', ' + rgbObject.g + ', ' + rgbObject.b + ')';
}

/***/ }),

/***/ 110:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = IdsFactory;
function IdsFactory() {

    var SEPARATOR = '/';

    var releaseRegex = /.*Release[^\/-]*/;

    var phaseRegex = /Phase[^\/-]*/;

    var taskRegex = /Task[^\/-].*/;

    var phaseTaskRegex = /Phase.*Task[^\/-].*/;

    var folderIdRegex = /(^|\/|\-)Folder.+?(?=(?:\/|\-|$))/gm;

    var releasePrefix = "Release";

    var phasePrefix = "Phase";

    var taskPrefix = "Task";

    var releaseIdToFolderId = function releaseIdToFolderId(viewId) {
        if (angular.isDefined(viewId)) {
            return "Applications/" + viewId.split("-").slice(0, -1).join(SEPARATOR);
        } else {
            return null;
        }
    };

    var toFullId = function toFullId(viewId) {
        return viewId.replace(/-/g, SEPARATOR);
    };
    var toDomainId = function toDomainId(viewId) {
        return "Applications/" + toFullId(viewId);
    };
    var noApplications = function noApplications(id) {
        return id !== null ? id.replace(/^Applications\//, '') : null;
    };
    var toInternalId = function toInternalId(viewId) {
        return viewId ? noApplications(viewId).replace(/\//g, '-') : null;
    };
    var toConfigurationId = function toConfigurationId(viewId) {
        return "Configuration/Custom/" + toFullId(viewId);
    };
    var releaseIdFrom = function releaseIdFrom(viewId) {
        return viewId.match(releaseRegex)[0];
    };
    var phaseIdFrom = function phaseIdFrom(viewId) {
        var regexMatch = viewId.match(phaseRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var taskIdFrom = function taskIdFrom(viewId) {
        var regexMatch = viewId.match(taskRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var phaseTaskIdFrom = function phaseTaskIdFrom(viewId) {
        var regexMatch = viewId.match(phaseTaskRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var isRootGeneral = function isRootGeneral(id, separator) {
        return id.indexOf(separator) === -1;
    };
    var isRoot = function isRoot(id) {
        return isRootGeneral(id, SEPARATOR);
    };
    var getParentIdGeneral = function getParentIdGeneral(id, separator) {
        if (isRootGeneral(id, separator)) return null;
        return id.substring(0, id.lastIndexOf(separator));
    };
    var getParentId = function getParentId(id) {
        return getParentIdGeneral(id, SEPARATOR);
    };
    var getName = function getName(id) {
        return isRoot(id) ? id : id.substring(id.lastIndexOf(SEPARATOR) + 1);
    };
    var getNameByExternalId = function getNameByExternalId(id) {
        return getName(toFullId(id));
    };
    var getParentFolderIdFrom = function getParentFolderIdFrom(viewId) {
        return !isInFolder(viewId) ? null : getParentId(releaseIdFrom(toDomainId(viewId)));
    };
    var isInFolder = function isInFolder(id) {
        return id.indexOf('Folder') !== -1;
    };
    var folderDepth = function folderDepth(id) {
        return noApplications(id).split('/').length - 1;
    };
    var getInternalFolderId = function getInternalFolderId(id) {
        var regexMatch = (id || '').match(folderIdRegex);
        if (regexMatch !== null) {
            return regexMatch.map(function (id) {
                return _.trim(id, '-/');
            }).join('-');
        }
        return null;
    };
    var isReleaseId = function isReleaseId(id) {
        return id.substring(id.lastIndexOf("-") + 1).startsWith(releasePrefix);
    };
    var isPhaseId = function isPhaseId(id) {
        return id.substring(id.lastIndexOf("-") + 1).startsWith(phasePrefix);
    };
    var isTaskId = function isTaskId(id) {
        return id.substring(id.lastIndexOf("-") + 1).startsWith(taskPrefix);
    };
    return {
        releaseIdToFolderId: releaseIdToFolderId,
        toDomainId: toDomainId,
        toInternalId: toInternalId,
        toConfigurationId: toConfigurationId,
        releaseIdFrom: releaseIdFrom,
        phaseIdFrom: phaseIdFrom,
        taskIdFrom: taskIdFrom,
        phaseTaskIdFrom: phaseTaskIdFrom,
        getParentId: getParentId,
        getParentIdGeneral: getParentIdGeneral,
        getName: getName,
        isRoot: isRoot,
        getParentFolderIdFrom: getParentFolderIdFrom,
        isInFolder: isInFolder,
        getNameByExternalId: getNameByExternalId,
        noApplications: noApplications,
        folderDepth: folderDepth,
        getInternalFolderId: getInternalFolderId,
        isReleaseId: isReleaseId,
        isPhaseId: isPhaseId,
        isTaskId: isTaskId
    };
}

/***/ }),

/***/ 111:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

exports.default = getAngularService;
exports.asyncGetAngularService = asyncGetAngularService;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getAngularService(name) {
    return angular.element(document.body).injector().get(name);
}

function asyncGetAngularService(name) {
    var service = getAngularService(name);
    return _promise2.default.resolve(service);
}

/***/ }),

/***/ 112:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SchedulerFilter = exports.EnvironmentReservation = exports.ReservationModel = exports.Application = exports.Environment = exports.Stage = exports.Label = undefined;

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Label = exports.Label = _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    title: _propTypes2.default.string.isRequired,
    color: _propTypes2.default.string.isRequired
});

var Stage = exports.Stage = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    title: _propTypes2.default.string
});

var Environment = exports.Environment = _propTypes2.default.shape({
    stage: Stage,
    id: _propTypes2.default.string,
    title: _propTypes2.default.string,
    description: _propTypes2.default.string,
    labels: _propTypes2.default.arrayOf(Label)
});

var Application = exports.Application = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    title: _propTypes2.default.string,
    environments: _propTypes2.default.arrayOf(Environment)
});

var ReservationModel = exports.ReservationModel = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    environment: Environment,
    applications: _propTypes2.default.arrayOf(_propTypes2.default.any),
    startDate: _propTypes2.default.any,
    endDate: _propTypes2.default.any,
    note: _propTypes2.default.string
});

var EnvironmentReservation = exports.EnvironmentReservation = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    title: _propTypes2.default.string,
    description: _propTypes2.default.string,
    stage: Stage,
    labels: _propTypes2.default.arrayOf(Label),
    reservations: _propTypes2.default.arrayOf(ReservationModel)
});

var SchedulerFilter = exports.SchedulerFilter = _propTypes2.default.shape({
    environmentTitle: _propTypes2.default.string,
    from: _propTypes2.default.number.isRequired,
    to: _propTypes2.default.number.isRequired,
    applications: _propTypes2.default.arrayOf(Application),
    stages: _propTypes2.default.arrayOf(Stage),
    labels: _propTypes2.default.arrayOf(Label)
});

/***/ }),

/***/ 123:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.reservedCharactersValidator = exports.createErrorMessage = exports.validateExistence = exports.validateMinLength = exports.validateMaxLength = exports.itemAlreadyDefined = undefined;

var _defineProperty2 = __webpack_require__(19);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _some = __webpack_require__(706);

var _some2 = _interopRequireDefault(_some);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var existByField = function existByField(list, field, value) {
    return (0, _some2.default)(list, function (e) {
        return e[field].trim().toLowerCase() === value.trim().toLowerCase();
    });
};

var findById = function findById(list, id, defaultField) {
    return list.find(function (e) {
        return e.id === id;
    }) || (0, _defineProperty3.default)({}, defaultField, '');
};

var itemAlreadyDefined = exports.itemAlreadyDefined = function itemAlreadyDefined(list, selectedId, field, value) {
    return existByField(list, field, value) && findById(list, selectedId, field)[field].trim().toLowerCase() !== value.trim().toLowerCase();
};

var validateMaxLength = exports.validateMaxLength = function validateMaxLength(inputText, maxLength) {
    return inputText && inputText.trim().length > maxLength;
};

var validateMinLength = exports.validateMinLength = function validateMinLength(inputText, minLength) {
    return inputText && inputText.trim().length < minLength;
};

var validateExistence = exports.validateExistence = function validateExistence(inputText) {
    return !inputText || !inputText.trim();
};

var validateReservedCharacters = function validateReservedCharacters(text) {
    return text.includes('`');
};

var createErrorMessage = exports.createErrorMessage = function createErrorMessage(text) {
    return { show: false, text: text, type: 'ERROR' };
};

var reservedCharactersValidator = exports.reservedCharactersValidator = function reservedCharactersValidator(label) {
    return function (text) {
        return {
            condition: validateReservedCharacters(text),
            message: createErrorMessage(label + ' contains forbidden characters')
        };
    };
};

/***/ }),

/***/ 212:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.store = undefined;

var _typeof2 = __webpack_require__(124);

var _typeof3 = _interopRequireDefault(_typeof2);

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

var _redux = __webpack_require__(147);

var _reduxSaga = __webpack_require__(277);

var _reduxSaga2 = _interopRequireDefault(_reduxSaga);

var _effects = __webpack_require__(54);

var _ducks = __webpack_require__(3173);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(combinedSaga); /* global window */


var sagaMiddleware = (0, _reduxSaga2.default)();

function combinedSaga() {
    return _regenerator2.default.wrap(function combinedSaga$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    if (false) {}

                    _context.prev = 1;
                    _context.next = 4;
                    return (0, _effects.all)([(0, _effects.call)(_ducks.trackedItemSagas), (0, _effects.call)(_ducks.deliveryPatternSagas), (0, _effects.call)(_ducks.stageSagas), (0, _effects.call)(_ducks.transitionSagas)]);

                case 4:
                    _context.next = 9;
                    break;

                case 6:
                    _context.prev = 6;
                    _context.t0 = _context['catch'](1);

                    /* eslint-disable no-console, angular/log */
                    console.error('Release deliveries root saga:', _context.t0);
                    /* eslint-enable */

                case 9:
                    _context.next = 0;
                    break;

                case 11:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[1, 6]]);
}

/* eslint-disable no-underscore-dangle,angular/typecheck-object,angular/module-getter */
var composeEnhancers = (typeof window === 'undefined' ? 'undefined' : (0, _typeof3.default)(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
    name: 'deliveries'
    // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...
}) : _redux.compose;

function configureStore(preloadedState) {
    var enhancer = composeEnhancers((0, _redux.applyMiddleware)(sagaMiddleware));

    var store = (0, _redux.createStore)((0, _redux.combineReducers)({ trackedItems: _ducks.trackedItems, deliveryPatterns: _ducks.deliveryPatterns, stages: _ducks.stages, transitions: _ducks.transitions }), preloadedState, enhancer);

    sagaMiddleware.run(combinedSaga);

    return store;
}

var store = exports.store = configureStore();
/* eslint-enable */

/***/ }),

/***/ 221:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = ReleaseStatusFactory;
function ReleaseStatusFactory() {
    return {
        isReleaseCompleted: function isReleaseCompleted(release) {
            return release && (release.status === 'COMPLETED' || release.status === 'ABORTED');
        },
        isReleaseAborted: function isReleaseAborted(release) {
            return release && release.status === 'ABORTED';
        },
        isReleasePlanned: function isReleasePlanned(release) {
            return release && release.status === 'PLANNED';
        },
        isReleaseInProgress: function isReleaseInProgress(release) {
            return release && release.status === 'IN_PROGRESS';
        },
        isReleaseFailed: function isReleaseFailed(release) {
            return release && release.status === 'FAILED';
        },
        isReleaseFailing: function isReleaseFailing(release) {
            return release && release.status === 'FAILING';
        },
        isReleasePaused: function isReleasePaused(release) {
            return release && release.status === 'PAUSED';
        },
        hasCompletedStatus: function hasCompletedStatus(release) {
            return release && release.status === 'COMPLETED';
        },
        isTemplate: function isTemplate(release) {
            return release && release.status === 'TEMPLATE';
        },
        isReleaseArchived: function isReleaseArchived(release) {
            return release && release.archived;
        },
        isReleaseActive: function isReleaseActive(release) {
            return release && (release.status === 'IN_PROGRESS' || release.status === "FAILED" || release.status === "FAILING" || release.status === "PAUSED");
        }
    };
}

/***/ }),

/***/ 222:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RiskSettingsService = exports.fetchReferences = exports.copyRiskProfile = exports.deleteRiskProfile = exports.updateRiskProfile = exports.createRiskProfile = exports.fetchRiskProfile = exports.fetchRiskProfiles = exports.fetchRiskAssessors = exports.fetchRiskConfig = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _http = __webpack_require__(71);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var riskApi = 'api/v1/risks';

var fetchRiskConfig = exports.fetchRiskConfig = function fetchRiskConfig() {
    return (0, _http.httpGET)(riskApi + "/config");
};
var fetchRiskAssessors = exports.fetchRiskAssessors = function fetchRiskAssessors() {
    return (0, _http.httpGET)(riskApi + "/assessors");
};
var fetchRiskProfiles = exports.fetchRiskProfiles = function fetchRiskProfiles() {
    return (0, _http.httpGET)(riskApi + "/profiles");
};
var fetchRiskProfile = exports.fetchRiskProfile = function fetchRiskProfile(riskProfileId) {
    return (0, _http.httpGET)(riskApi + "/profiles/" + riskProfileId);
};
var createRiskProfile = exports.createRiskProfile = function createRiskProfile(riskProfile) {
    return (0, _http.httpPOST)(riskApi + "/profiles", riskProfile);
};
var updateRiskProfile = exports.updateRiskProfile = function updateRiskProfile(riskProfile) {
    return (0, _http.httpPUT)(riskApi + "/profiles/" + riskProfile.id, riskProfile);
};
var deleteRiskProfile = exports.deleteRiskProfile = function deleteRiskProfile(riskProfileId) {
    return (0, _http.httpDELETE)(riskApi + "/profiles/" + riskProfileId);
};
var copyRiskProfile = exports.copyRiskProfile = function copyRiskProfile(riskProfileId) {
    return (0, _http.httpPOST)(riskApi + "/profiles/" + riskProfileId + "/copy");
};
var fetchReferences = exports.fetchReferences = function fetchReferences(riskProfileId) {
    return (0, _http.httpGET)("risks/profiles/" + riskProfileId + "/references");
};

var RiskSettingsService = exports.RiskSettingsService = function () {
    function RiskSettingsService() {
        (0, _classCallCheck3.default)(this, RiskSettingsService);
    }

    (0, _createClass3.default)(RiskSettingsService, [{
        key: "getAll",
        value: function getAll() {
            return fetchRiskProfiles();
        }
    }]);
    return RiskSettingsService;
}();

/***/ }),

/***/ 229:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    DELIVERY_PATTERN_CREATE_FORM: "DELIVERY_PATTERN/CREATE_FORM",
    DELIVERY_PATTERN_CREATE_DELIVERY_FORM: "DELIVERY_PATTERN/CREATE_DELIVERY_FORM",
    DELIVERY_PATTERN_LIST_SUCCEEDED: 'DELIVERY_PATTERN/LIST_SUCCEEDED',
    DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED: 'DELIVERY_PATTERN/CREATE_CANCEL_REQUESTED',
    DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED: 'DELIVERY_PATTERN/CREATE_CANCEL_SUCCEEDED',
    DELIVERY_PATTERN_PRISTINE: 'DELIVERY_PATTERN/PRISTINE',
    DELIVERY_PATTERN_VALID: 'DELIVERY_PATTERN/VALID',
    DELIVERY_PATTERN_MODEL_CHANGE: 'DELIVERY_PATTERN/MODEL_CHANGE',
    DELIVERY_PATTERN_CREATE_REQUESTED: 'DELIVERY_PATTERN/CREATE_REQUESTED',
    DELIVERY_PATTERN_CREATE_SUCCEEDED: 'DELIVERY_PATTERN/CREATE_SUCCEEDED',
    DELIVERY_PATTERN_UPDATE_REQUESTED: 'DELIVERY_PATTERN/UPDATE_REQUESTED',
    DELIVERY_PATTERN_UPDATE_SUCCEEDED: 'DELIVERY_PATTERN/UPDATE_SUCCEEDED',
    DELIVERY_PATTERN_DELETE_REQUESTED: 'DELIVERY_PATTERN/DELETE_REQUESTED',
    DELIVERY_PATTERN_DELETE_SUCCEEDED: 'DELIVERY_PATTERN/DELETE_SUCCEEDED',
    DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED: 'DELIVERY_PATTERN/FILTER_CHANGE_REQUESTED',
    DELIVERY_PATTERN_LIST_FAILED: 'DELIVERY_PATTERN/LIST_FAILED',
    DELIVERY_PATTERN_GO_TO_DETAILS: 'DELIVERY_PATTERN/DETAILS',
    DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY: 'DELIVERY_PATTERN/GO_TO_CREATE_DELIVERY',
    DELIVERY_PATTERN_LOAD_REQUESTED: 'DELIVERY_PATTERN/LOAD_REQUESTED',
    DELIVERY_PATTERN_LOAD_SUCCEEDED: 'DELIVERY_PATTERN/LOAD_SUCCEEDED',
    DELIVERY_PATTERN_RESET_REQUESTED: 'DELIVERY_PATTERN/RESET_REQUESTED',
    DELIVERY_PATTERN_COPY_REQUESTED: 'DELIVERY_PATTERN/COPY_REQUESTED',
    DELIVERY_PATTERN_GET_ALL_REQUESTED: 'DELIVERY_PATTERN/GET_ALL_REQUESTED',
    DELIVERY_PATTERN_GET_ALL_SUCCEEDED: 'DELIVERY_PATTERN/GET_ALL_SUCCEEDED',
    DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED: 'DELIVERY_PATTERN/VALIDATE_TITLE_REQUESTED',
    DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED: 'DELIVERY_PATTERN/VALIDATE_TITLE_SUCCEEDED'
};

var deliveryPatternForm = exports.deliveryPatternForm = function deliveryPatternForm() {
    return { type: actionTypes.DELIVERY_PATTERN_CREATE_FORM };
};
var createDeliveryForm = exports.createDeliveryForm = function createDeliveryForm() {
    return { type: actionTypes.DELIVERY_PATTERN_CREATE_DELIVERY_FORM };
};
var listLoaded = exports.listLoaded = function listLoaded(list) {
    return { type: actionTypes.DELIVERY_PATTERN_LIST_SUCCEEDED, payload: list };
};
var listFailed = exports.listFailed = function listFailed() {
    return { type: actionTypes.DELIVERY_PATTERN_LIST_FAILED };
};
var cancelCreate = exports.cancelCreate = function cancelCreate() {
    return { type: actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED };
};
var createCancelled = exports.createCancelled = function createCancelled() {
    return { type: actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED };
};
var changeValidation = exports.changeValidation = function changeValidation(valid) {
    return { type: actionTypes.DELIVERY_PATTERN_VALID, payload: valid };
};
var changeModel = exports.changeModel = function changeModel(model) {
    return { type: actionTypes.DELIVERY_PATTERN_MODEL_CHANGE, payload: model };
};
var createDeliveryPattern = exports.createDeliveryPattern = function createDeliveryPattern() {
    return { type: actionTypes.DELIVERY_PATTERN_CREATE_REQUESTED };
};
var deliveryPatternCreated = exports.deliveryPatternCreated = function deliveryPatternCreated(deliveryPattern) {
    return { type: actionTypes.DELIVERY_PATTERN_CREATE_SUCCEEDED, payload: deliveryPattern };
};
var deleteDeliveryPattern = exports.deleteDeliveryPattern = function deleteDeliveryPattern(id) {
    return { type: actionTypes.DELIVERY_PATTERN_DELETE_REQUESTED, payload: id };
};
var deliveryPatternDeleted = exports.deliveryPatternDeleted = function deliveryPatternDeleted(id) {
    return { type: actionTypes.DELIVERY_PATTERN_DELETE_SUCCEEDED, payload: id };
};
var changeDeliveryPatternFilter = exports.changeDeliveryPatternFilter = function changeDeliveryPatternFilter(filter) {
    return {
        type: actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED,
        payload: filter
    };
};
var goToDetails = exports.goToDetails = function goToDetails(id) {
    return { type: actionTypes.DELIVERY_PATTERN_GO_TO_DETAILS, payload: id };
};
var goToCreateDelivery = exports.goToCreateDelivery = function goToCreateDelivery(id) {
    return { type: actionTypes.DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY, payload: id };
};
var deliveryLoaded = exports.deliveryLoaded = function deliveryLoaded(deliveryPattern) {
    return { type: actionTypes.DELIVERY_PATTERN_LOAD_SUCCEEDED, payload: deliveryPattern };
};
var updateDeliveryPattern = exports.updateDeliveryPattern = function updateDeliveryPattern() {
    return { type: actionTypes.DELIVERY_PATTERN_UPDATE_REQUESTED };
};
var deliveryPatternUpdated = exports.deliveryPatternUpdated = function deliveryPatternUpdated(deliveryPattern) {
    return { type: actionTypes.DELIVERY_PATTERN_UPDATE_SUCCEEDED, payload: deliveryPattern };
};
var resetDeliveryPattern = exports.resetDeliveryPattern = function resetDeliveryPattern() {
    return { type: actionTypes.DELIVERY_PATTERN_RESET_REQUESTED };
};
var copyDeliveryPattern = exports.copyDeliveryPattern = function copyDeliveryPattern(deliveryPattern) {
    return { type: actionTypes.DELIVERY_PATTERN_COPY_REQUESTED, payload: deliveryPattern };
};
var changePristine = exports.changePristine = function changePristine(pristine) {
    return { type: actionTypes.DELIVERY_PATTERN_PRISTINE, payload: pristine };
};
var allPatternsLoaded = exports.allPatternsLoaded = function allPatternsLoaded(defs) {
    return { type: actionTypes.DELIVERY_PATTERN_GET_ALL_SUCCEEDED, payload: defs };
};
var validateTitle = exports.validateTitle = function validateTitle(id, title) {
    return { type: actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED, payload: { id: id, title: title } };
};
var titleValidated = exports.titleValidated = function titleValidated(valid) {
    return { type: actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED, payload: valid };
};

/***/ }),

/***/ 2368:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(2369);
__webpack_require__(2376);
__webpack_require__(2388);
__webpack_require__(2441);
__webpack_require__(3067);
__webpack_require__(3234);
__webpack_require__(3269);
__webpack_require__(3327);
__webpack_require__(3340);
__webpack_require__(3372);
__webpack_require__(3418);
__webpack_require__(3427);
module.exports = __webpack_require__(3431);


/***/ }),

/***/ 2369:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2370);

__webpack_require__(2372);

/***/ }),

/***/ 2370:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2372:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _activityLogsListController = __webpack_require__(796);

var _activityLogsListController2 = _interopRequireDefault(_activityLogsListController);

var _releaseActivityLogsController = __webpack_require__(2373);

var _releaseActivityLogsController2 = _interopRequireDefault(_releaseActivityLogsController);

var _releaseActivityLogs = __webpack_require__(2374);

var _releaseActivityLogs2 = _interopRequireDefault(_releaseActivityLogs);

var _activityLogsList = __webpack_require__(2375);

var _activityLogsList2 = _interopRequireDefault(_activityLogsList);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease.activityLogs', ['xlrelease', 'ui.router']).controller('releaseActivityLogsController', _releaseActivityLogsController2.default).component('activityLogsList', {
    bindings: {
        filters: '<',
        containerId: '<'
    },
    controller: _activityLogsListController2.default,
    template: _activityLogsList2.default
}).config(['$stateProvider', function ($stateProvider) {
    $stateProvider.state('releaseLogs', {
        url: '/releases/:releaseId/logs',
        reloadOnSearch: false,
        template: _releaseActivityLogs2.default,
        controller: 'releaseActivityLogsController',
        controllerAs: '$ctrl',
        resolve: {
            filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
                return Filters.getLogsFiltersSettings($stateParams.releaseId);
            }]
        }
    }).state('templateLogs', {
        url: '/templates/:releaseId/logs',
        reloadOnSearch: false,
        template: _releaseActivityLogs2.default,
        controller: 'releaseActivityLogsController',
        controllerAs: '$ctrl',
        resolve: {
            filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
                return Filters.getLogsFiltersSettings($stateParams.releaseId);
            }]
        }
    });
}]);

/***/ }),

/***/ 2373:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseActivityLogsController = function () {
    function ReleaseActivityLogsController($scope, $stateParams, Backend, Page, filterSettings) {
        (0, _classCallCheck3.default)(this, ReleaseActivityLogsController);

        this._Backend = Backend;
        this._Page = Page;
        this._$scope = $scope;

        this._$scope.containerId = $stateParams.releaseId;
        this._$scope.filters = filterSettings;
        this._$scope.activityFilters = [{ id: "display-important", model: "important", label: "Important" }, { id: "display-lifecycle", model: "lifecycle", label: "Release life cycle" }, { id: "display-release_edit", model: "releaseEdit", label: "Release edits" }, { id: "display-task_edit", model: "taskEdit", label: "Task edits" }, { id: "display-reassign", model: "reassign", label: "Task assignment" }, { id: "display-comments", model: "comments", label: "Comments" }, { id: "display-security", model: "security", label: "Security" }, { id: "display-other", model: "other", label: "Other" }];
    }

    (0, _createClass3.default)(ReleaseActivityLogsController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this._Backend.get('releases/' + this._$scope.containerId).then(function (resp) {
                var release = resp.data;
                _this._$scope.release = release;
                _this._Page.setReleaseOpened(release);
            });
        }
    }]);
    return ReleaseActivityLogsController;
}();

ReleaseActivityLogsController.$inject = ['$scope', '$stateParams', 'Backend', 'Page', 'filterSettings'];
exports.default = ReleaseActivityLogsController;

/***/ }),

/***/ 2374:
/***/ (function(module, exports) {

module.exports = "<div id=\"logs\" ng-if=\"filters\">\n    <div release-header>\n        <div class=\"filters\" ng-controller=\"FiltersController\">\n            <div class=\"actions\">\n                <input id=\"search-filter\" autofocus type=\"search\" class=\"filter\" placeholder=\"Filter by user or action...\" ng-model=\"filters.filter\">\n                <button type=\"button\" class=\"button dropdown-button filter\" bs-popover\n                        data-content-template=\"static/9.5.5/include/ActivityLogs/activity-logs-filter/activity-logs-categories-filter.html\"\n                        data-placement=\"bottom\" auto-close=\"true\">Filter categories\n                </button>\n                <span class=\"filter\" ng-include=\"'partials/filters/from-to-date-filters.html'\"/>\n            </div>\n        </div>\n        <span doc-icon=\"activity-logs.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <activity-logs-list filters=\"filters\" container-id=\"containerId\" />\n    </div>\n</div>\n"

/***/ }),

/***/ 2375:
/***/ (function(module, exports) {

module.exports = "<div id=\"logs-list\" class=\"container-fluid\">\n    <div class=\"logs-header row\">\n        <div class=\"col-xs-2\">User</div>\n        <div class=\"col-xs-7\">Action</div>\n        <div class=\"col-xs-3 date\" ng-click=\"$ctrl.filters.dateAsc = !$ctrl.filters.dateAsc\">\n            Date ({{$ctrl.timeZone}})\n            <i class=\"xl-icon icon-s\" ng-class=\"{'sort-asc-icon': $ctrl.filters.dateAsc, 'sort-desc-icon': !$ctrl.filters.dateAsc}\"></i>\n        </div>\n    </div>\n    <div class=\"log row\" ng-repeat=\"log in $ctrl.logs\">\n        <div class=\"col-xs-2 username\">\n            <span display-user=\"log.user\"></span>\n        </div>\n        <div class=\"col-xs-7 message\">\n                <span ng-if=\"log.message.length <= 400\" style=\"word-wrap: break-word;\">\n                    {{log.message}}\n                </span>\n\n            <span ng-if=\"log.message.length > 400\" style=\"word-wrap: break-word;\">\n                    <span ng-show=\"!showMore\">\n                        {{log.message | limitTo:400 }} ...\n                        <span class=\"link\" ng-click=\"showMore = true\">\n                            More\n                        </span>\n                    </span>\n                    <span ng-show=\"showMore\">\n                        {{log.message}}\n                        <span class=\"link\" ng-click=\"showMore = false\">\n                            Hide\n                        </span>\n                    </span>\n                </span>\n        </div>\n        <div class=\"col-xs-3 time\">{{log.eventTime | date:'medium'}}</div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2376:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2377);

__webpack_require__(2387);

/***/ }),

/***/ 2377:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.scmCommitDataModal = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _parseGithubUrl = __webpack_require__(2378);

var _parseGithubUrl2 = _interopRequireDefault(_parseGithubUrl);

__webpack_require__(2385);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-header">\n        <h4 class="modal-title pull-left" id="modal-title">Meta information - {{$ctrl.resolve.data.title}} </h4>\n        <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix"/>\n    </div>\n    <div class="modal-body version-control">\n        <h4> Source Control Management </h4>\n       \n        <p ng-show="$ctrl.noData"> No data available.</p>\n        \n        <div  ng-hide="$ctrl.noData">\n            <div class="col-sm-3">\n               Commit\n            </div>\n            <div class="col-sm-9">\n                <span class="coc-label-button"> {{$ctrl.coc.kind | uppercase }} </span> <a href={{$ctrl.coc.commitUrl}} target="_blank" rel="noopener" class="coc-link"> {{$ctrl.coc.commit}} </a> \n            </div>\n            <div class="col-sm-3">\n               Timestamp\n            </div>\n            <div class="col-sm-9">\n                {{ $ctrl.coc.date | date:\'MMM dd, yyyy hh:mm:ss a\' }}\n            </div>\n            <div class="col-sm-3">\n               Committed by\n            </div>\n            <div class="col-sm-9">\n                {{$ctrl.coc.author}}\n            </div>\n            <div class="col-sm-3">\n               Summary\n            </div>\n            <div class="col-sm-9 coc-message">\n                {{$ctrl.coc.message}}\n            </div>\n         \n            <div class="col-sm-3">\n               Source\n            </div>\n            <div class="col-sm-9">\n                <a href={{$ctrl.coc.url}} target="_blank" rel="noopener" class="coc-link"> {{$ctrl.coc.url}} </a>\n            </div>\n            <div class="col-sm-3">\n                File name\n            </div>\n            <div class="col-sm-9">\n                <a href={{$ctrl.coc.fileUrl}} target="_blank" rel="noopener" class="coc-link"> {{$ctrl.coc.fileName}} </a>\n            </div>\n        </div>\n    </div>\n    <div class="modal-footer">\n        &nbsp;<button type="button" class="button cancel" ng-click="$ctrl.dismiss()">Close</button>\n    </div>\n';

var SCMCommitDataModalController = function () {
    function SCMCommitDataModalController(XlrCocSCMService) {
        (0, _classCallCheck3.default)(this, SCMCommitDataModalController);

        this.XlrCocSCMService = XlrCocSCMService;
    }

    (0, _createClass3.default)(SCMCommitDataModalController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.noData = true;
            var fetchedData = this.XlrCocSCMService.fetchSCMData(this.resolve.data.scmId);

            if (fetchedData) {
                fetchedData.then(function (coc) {
                    _this.coc = coc.data;

                    if (_this.coc && _this.coc !== null) {
                        _this.noData = false;
                        _this.coc.commitUrl = _this.getCommitUrl(_this.coc.commit);
                        _this.coc.fileUrl = _this.getFileUrl(_this.coc.commit, _this.coc.fileName);
                        _this.coc.url = _this.getUrl('');
                    }
                });
            }
        }
    }, {
        key: 'getFileUrl',
        value: function getFileUrl(commit, file) {
            var filePath = 'blob/' + commit + '/' + file;
            return this.getUrl(filePath);
        }
    }, {
        key: 'getUrl',
        value: function getUrl(path) {
            var url = (0, _parseGithubUrl2.default)(this.coc.remote);
            var sourceUrl = 'https://' + url.host + '/' + url.owner + '/' + url.name;
            return sourceUrl + '/' + path;
        }
    }, {
        key: 'getCommitUrl',
        value: function getCommitUrl(path) {
            var commitPath = 'commit/' + path;
            return this.getUrl(commitPath);
        }
    }]);
    return SCMCommitDataModalController;
}();

SCMCommitDataModalController.$inject = ['XlrCocSCMService'];
var scmCommitDataModal = exports.scmCommitDataModal = {
    bindings: {
        close: '&',
        dismiss: '&',
        resolve: '<'
    },
    controller: SCMCommitDataModalController,
    template: template
};

angular.module('xlrelease').component('xlrSCMModal', scmCommitDataModal);

/***/ }),

/***/ 2385:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2387:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrCocSCMService = function () {
    function XlrCocSCMService(Backend) {
        (0, _classCallCheck3.default)(this, XlrCocSCMService);

        this.Backend = Backend;
    }

    (0, _createClass3.default)(XlrCocSCMService, [{
        key: 'fetchSCMData',
        value: function fetchSCMData(scmId) {
            if (scmId) {
                return this.Backend.get('coc/scm-traceability?id=' + scmId);
            }
            return null;
        }
    }]);
    return XlrCocSCMService;
}();

XlrCocSCMService.$inject = ['Backend'];


angular.module('xlrelease').service('XlrCocSCMService', XlrCocSCMService);

/***/ }),

/***/ 2388:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2389);

__webpack_require__(2390);

__webpack_require__(2391);

__webpack_require__(2392);

__webpack_require__(2393);

__webpack_require__(2394);

__webpack_require__(2395);

__webpack_require__(2396);

__webpack_require__(2397);

__webpack_require__(2399);

__webpack_require__(2400);

__webpack_require__(2401);

__webpack_require__(2402);

__webpack_require__(2403);

__webpack_require__(2405);

__webpack_require__(2407);

__webpack_require__(2408);

__webpack_require__(2410);

__webpack_require__(2414);

__webpack_require__(2418);

__webpack_require__(2420);

__webpack_require__(2422);

__webpack_require__(2426);

__webpack_require__(2434);

/***/ }),

/***/ 2389:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease.dashboard', ['gridster', 'ui.router', 'mgcrea.ngStrap']).config(['$stateProvider', '$urlMatcherFactoryProvider', function ($stateProvider, $urlMatcherFactoryProvider) {
    $urlMatcherFactoryProvider.type('DashboardId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: /Applications\/Dashboard\w+/
    });
    $urlMatcherFactoryProvider.type('TileId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: /Applications\/Dashboard\w+\/Tile\w+/
    });
    $stateProvider.state('defaultDashboard', {
        url: '/dashboards',
        template: '<xlr-dashboard-placeholder sub-menu-items="subMenuItems"></xlr-dashboard-placeholder>'
    }).state('dashboards', {
        url: '/dashboards/{dashboardId: DashboardId}?dashboardMode&{refresh:bool}',
        template: '<div xlr-dashboard></div>'
    }).state('folderDashboards', {
        url: '/folders-dashboards/{dashboardId: DashboardId}?dashboardMode&folderId&{refresh:bool}',
        template: '<div xlr-dashboard></div>'
    }).state('folderDashboardsNew', {
        url: '/folders-dashboards/new?folderId',
        template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
    }).state('globalDashboardNew', {
        url: '/dashboards/new',
        template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
    }).state('globalDashboardDetails', {
        url: '/dashboards/{tileId: TileId}/details',
        templateUrl: 'static/9.5.5/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService) {
                return XlrDashboardService.loadTile($stateParams.tileId);
            }],
            dashboardPromise: [function () {}],
            releasePromise: [function () {}]
        }
    }).state('folderDashboardDetails', {
        url: '/folders-dashboards/{tileId: TileId}/details',
        templateUrl: 'static/9.5.5/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', function ($stateParams, XlrDashboardService) {
                return XlrDashboardService.loadTile($stateParams.tileId);
            }],
            dashboardPromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
                return XlrDashboardService.loadConfiguration(Ids.getParentId($stateParams.tileId));
            }],
            releasePromise: [function () {}]
        }
    }).state('releasesDashboard', {
        url: '/releases/:releaseId/summary/:tileId/details',
        templateUrl: 'static/9.5.5/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
                return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
            }],
            dashboardPromise: [function () {}],
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
            }]
        }
    }).state('templatesDashboard', {
        url: '/templates/:releaseId/summary/:tileId/details',
        templateUrl: 'static/9.5.5/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
                return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
            }],
            dashboardPromise: [function () {}],
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
            }]
        }
    });
}]);

angular.module('xlrelease.dashboard').factory('xlrDashboardConfigProvider', function () {
    return {
        getPlaceholderProperties: function getPlaceholderProperties() {
            return {
                draggable: { enabled: false },
                resizable: { enabled: false }
            };
        },
        getConfig: function getConfig(designMode, changeCallback) {
            return {
                minSizeY: 1,
                minSizeX: 1,
                defaultSizeX: 1,
                defaultSizeY: 1,
                pushing: true,
                floating: true, // whether to automatically float items up so they stack (you can temporarily disable if you are adding unsorted items with ng-repeat)
                swapping: true, // whether or not to have items of the same size switch places instead of pushing down if they are the same size
                colWidth: 'auto',
                minRows: 1,
                rowHeight: 290,
                margins: [10, 10],
                mobileBreakPoint: 60,
                resizable: {
                    enabled: designMode,
                    handles: ['n', 'e', 's', 'w', 'ne', 'se', 'sw', 'nw'],
                    start: function start(event, $element) {
                        $element.addClass('dashboard-resizing');
                    },
                    stop: function stop(event, $element) {
                        $element.removeClass('dashboard-resizing');
                        changeCallback();
                    }
                },
                draggable: {
                    enabled: designMode,
                    handle: '.xlr-tile-drag-handle',
                    stop: function stop() {
                        return changeCallback();
                    }
                }
            };
        }
    };
});

angular.module('xlrelease').run(['MenuItemsProviderRegistry', 'Backend', '$state', function (MenuItemsProviderRegistry, Backend, $state) {
    MenuItemsProviderRegistry.addProvider('xlrelease.dashboard.provider', function () {
        return Backend.get('dashboards').then(function (resp) {
            var dashboards = resp.data.map(function (dashboard) {
                return {
                    label: dashboard.title,
                    pathSuffix: 'dashboards/' + dashboard.id,
                    permitted: true
                };
            });

            if ($state.is('globalDashboardNew')) {
                dashboards.push({
                    label: 'New dashboard',
                    pathSuffix: 'dashboards/new',
                    permitted: true
                });
            }

            return dashboards;
        });
    });
}]);

/***/ }),

/***/ 2390:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrDashboardConstants = __webpack_require__(268);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrDashboardController = function () {
    function XlrDashboardController($scope, $q, $state, $stateParams, Ids, Authenticator, ReleasesService, xlrDashboardConfigProvider, XlrDashboardService, VariablesService, XlrSidebarService, $uibModal, $rootScope, Events, Page) {
        (0, _classCallCheck3.default)(this, XlrDashboardController);

        this.Ids = Ids;
        this.$state = $state;
        this.$stateParams = $stateParams;
        this.$scope = $scope;
        this.$q = $q;
        this.XlrSidebarService = XlrSidebarService;
        this.Authenticator = Authenticator;
        this.ReleasesService = ReleasesService;
        this.XlrDashboardService = XlrDashboardService;
        this.VariablesService = VariablesService;
        this.xlrDashboardConfigProvider = xlrDashboardConfigProvider;
        this.$uibModal = $uibModal;
        this.$rootScope = $rootScope;
        this.Events = Events;
        this.Page = Page;

        this.filteredTileTypeDefs = [];
        this.showAddTileModal = false;
        this.dashboardMode = $stateParams.dashboardMode || _xlrDashboardConstants.DASHBOARD_MODE.VIEW;
        this.gridsterOpts = xlrDashboardConfigProvider.getConfig(this.isDesignMode(), this.saveDashboard.bind(this));

        this.initialized = false;

        this.sidebarOpts = {
            position: 'right',
            backdropOpacity: 0
        };

        if (this.$stateParams.releaseId) {
            this.parentId = this.$stateParams.releaseId;
            this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE;
        } else if (this.$stateParams.folderId) {
            this.parentId = this.$stateParams.folderId;
            this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER;
        } else {
            this.parentId = null;
            this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
        }

        if (this.isGlobalDashboard() || this.isFolderDashboard()) {
            this.initWithGlobalContext();
        } else {
            this.initWithRelease();
        }

        this.DASHBOARD_WIDGETS_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_WIDGETS_SIDEBAR_NAME;
        this.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME;
        this.DASHBOARD_PROPERTIES_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_PROPERTIES_SIDEBAR_NAME;
    }

    (0, _createClass3.default)(XlrDashboardController, [{
        key: 'initPlaceholders',
        value: function initPlaceholders(maxCol, maxRow) {
            this.gridsterPlaceholderOpts = (0, _extends3.default)({}, this.gridsterOpts, this.xlrDashboardConfigProvider.getPlaceholderProperties());

            var col = 0;
            var row = 0;
            var sizeX = 1;

            this.placeholders = _.fill(Array(maxCol * maxRow), {}).map(function () {
                var config = { col: col, row: row, sizeX: sizeX };

                if (col + 1 >= maxCol) {
                    col = 0;
                    row++;
                } else {
                    col++;
                }
                return config;
            });
        }
    }, {
        key: 'initWithRelease',
        value: function initWithRelease() {
            var _this = this;

            this.dashboard = {
                id: this.Ids.toDomainId(this.$stateParams.releaseId) + '/' + this.$stateParams.extensionPath,
                tiles: []
            };
            this.release = _.get(this.$scope, 'releasePageExtensionCtrl.release');
            this.canEditDashboard = this.Authenticator.hasEditPermission(this.release) && !this.ReleasesService.isReleaseArchived(this.release);
            this.canDeleteDashboard = false;

            this.$q.all([this.loadTiles(), this.loadTileTypes(), this.loadAllVariables(), this.loadAllVariableValues()]).then(function () {
                _this.initialized = true;
            });
        }
    }, {
        key: 'initWithGlobalContext',
        value: function initWithGlobalContext() {
            var _this2 = this;

            this.dashboard = {
                id: this.$stateParams.dashboardId,
                tiles: []
            };
            this.release = {};
            this.$q.all([this.loadTiles(), this.loadTileTypes(), this.loadAllVariables(), this.loadAllVariableValues()]).then(function () {
                _this2.initialized = true;
                _this2.canEditDashboard = _this2.Authenticator.hasPermission("dashboard#edit", _this2.dashboard.metadata);
                _this2.canDeleteDashboard = _this2.canEditDashboard;
            });
        }
    }, {
        key: 'loadTiles',
        value: function loadTiles() {
            var _this3 = this;

            var refresh = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

            if (refresh) {
                this.$state.go(this.$state.$current.name, { refresh: true }, { notify: false });
            }
            return this.XlrDashboardService.loadConfiguration(this.dashboard.id, refresh).then(function (response) {
                if (!_.isEmpty(response.data)) {
                    _this3.dashboard = response.data;
                    _this3.gridsterOpts = _this3.getDashboardGridsterOpts(_this3.gridsterOpts);
                    _this3.initPlaceholders(_this3.dashboard.columns, _this3.dashboard.rows);
                    if (_this3.isFolderDashboard()) {
                        _this3.Page.setDashboardOpened(_this3.dashboard);
                    }
                }
                return _this3.dashboard;
            });
        }
    }, {
        key: 'loadTileTypes',
        value: function loadTileTypes() {
            var _this4 = this;

            return this.XlrDashboardService.tileTypes(this.dashboardLevel).then(function (response) {
                _this4.tileTypes = response.data;
                _this4.tileTypeDefs = _.reduce(_this4.tileTypes, function (memo, it) {
                    it.property = _.keyBy(it.properties, 'name');
                    memo[it.type] = it;
                    return memo;
                }, {});
                _this4.filteredTileTypeDefs = _.values(_this4.tileTypeDefs);
                return _this4.tileTypeDefs;
            });
        }
    }, {
        key: 'loadAllVariables',
        value: function loadAllVariables() {
            var _this5 = this;

            return this.VariablesService.getAllVariables(this.$stateParams.releaseId, this.$stateParams.folderId).then(function (allVariables) {
                _this5.allVariables = allVariables;
                return _this5.allVariables;
            });
        }
    }, {
        key: 'loadAllVariableValues',
        value: function loadAllVariableValues() {
            var _this6 = this;

            return this.VariablesService.getAllVariableValues(this.$stateParams.releaseId, this.$stateParams.folderId).then(function (allVariableValues) {
                _this6.allVariableValues = allVariableValues;
                return _this6.allVariableValues;
            });
        }
    }, {
        key: 'modeSwitch',
        value: function modeSwitch() {
            this.dashboardMode = this.isDesignMode() ? _xlrDashboardConstants.DASHBOARD_MODE.VIEW : _xlrDashboardConstants.DASHBOARD_MODE.DESIGN;
            this.gridsterOpts = this.getDashboardGridsterOpts(this.xlrDashboardConfigProvider.getConfig(this.isDesignMode(), this.saveDashboard.bind(this)));
        }
    }, {
        key: 'getDashboardGridsterOpts',
        value: function getDashboardGridsterOpts(config) {
            return (0, _extends3.default)({}, config, {
                columns: this.dashboard.columns,
                rowHeight: 150 + 450 / this.dashboard.columns,
                rows: this.dashboard.rows,
                maxSizeY: this.dashboard.rows,
                maxSizeX: this.dashboard.columns
            });
        }
    }, {
        key: 'isDesignMode',
        value: function isDesignMode() {
            return this.dashboardMode === _xlrDashboardConstants.DASHBOARD_MODE.DESIGN;
        }
    }, {
        key: 'getVariables',
        value: function getVariables() {
            return this.isDesignMode() ? this.allVariables : this.allVariableValues;
        }
    }, {
        key: 'newTile',
        value: function newTile(tileType, dashboardColumns) {
            return {
                id: null,
                type: tileType,
                title: this.tileTypeDefs[tileType].property.title.default,
                uri: this.tileTypeDefs[tileType].property.uri.default,
                sizeX: this.tileTypeDefs[tileType].property.width.default > dashboardColumns ? dashboardColumns : this.tileTypeDefs[tileType].property.width.default
            };
        }
    }, {
        key: 'saveDashboard',
        value: function saveDashboard(switchMode) {
            var _this7 = this;

            var refreshTiles = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            this.XlrDashboardService.update(this.getDashboard()).then(function (response) {
                if (refreshTiles) {
                    _this7.dashboard = response.data;
                }

                if (switchMode) {
                    _this7.modeSwitch();
                }

                _this7.XlrSidebarService.closeAll();
            });
        }
    }, {
        key: 'isReleaseDashboard',
        value: function isReleaseDashboard() {
            return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE;
        }
    }, {
        key: 'isGlobalDashboard',
        value: function isGlobalDashboard() {
            return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
        }
    }, {
        key: 'isFolderDashboard',
        value: function isFolderDashboard() {
            return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER;
        }
    }, {
        key: 'deleteDashboard',
        value: function deleteDashboard() {
            var _this8 = this;

            this.$uibModal.open({
                animation: false,
                component: 'xlrDeleteDashboardModal',
                resolve: {
                    data: {
                        dashboard: this.getDashboard()
                    }
                }
            }).result.then(function () {
                _this8.XlrDashboardService.delete(_this8.getDashboard()).then(function () {
                    _this8.$rootScope.$emit(_this8.Events.ui.subMenuRefresh, {
                        onRefresh: function onRefresh() {
                            if (_this8.Authenticator.hasPermission('reports#view')) {
                                _this8.$state.go('reports');
                            } else {
                                _this8.$state.go('defaultDashboard');
                            }
                        }
                    });
                });
            });
        }
    }, {
        key: 'getDashboard',
        value: function getDashboard() {
            return _.omit(this.dashboard, ['metadata']);
        }
    }, {
        key: 'updateDashboard',
        value: function updateDashboard(dashboard) {
            if (!_.isEmpty(dashboard)) {
                this.dashboard = dashboard;
            }
        }
    }, {
        key: 'addTile',
        value: function addTile(tileType) {
            var _this9 = this;

            if (tileType) {
                var changedDashboard = angular.copy(this.getDashboard());
                changedDashboard.tiles.push(this.newTile(tileType, changedDashboard.columns));

                this.XlrDashboardService.update(changedDashboard).then(function (response) {
                    _this9.updateDashboard(response.data);
                });
            }
        }
    }, {
        key: 'removeTile',
        value: function removeTile(item) {
            var _this10 = this;

            var changedDashboard = angular.copy(this.getDashboard());
            var tileIndex = _.findIndex(this.dashboard.tiles, { id: item.id });
            changedDashboard.tiles.splice(tileIndex, 1);

            this.XlrDashboardService.update(changedDashboard).then(function (response) {
                _this10.updateDashboard(response.data);
            });
        }
    }, {
        key: 'saveTile',
        value: function saveTile(tile) {
            var _this11 = this;

            this.XlrDashboardService.saveTile(tile).then(function (response) {
                var updatedTile = response.data;
                var tileIndex = _.findIndex(_this11.dashboard.tiles, { id: updatedTile.id });

                if (tileIndex >= 0) {
                    _this11.dashboard.tiles[tileIndex] = updatedTile;
                    _this11.tile = updatedTile;
                } else {
                    // the first dashboard has tile with default IDs.
                    // Those IDs are changed to unique/fresh values the first time the Dashboard is persisted.
                    // Hence we need to fetch the persisted dashboard containing the (same) tiles but with the persisted IDs,
                    // so that on subsequent runs `tileIndex` will find the tile by ID
                    _this11.loadTiles();
                }

                _this11.XlrSidebarService.close('tileConfigureSidebar');
            });
        }
    }, {
        key: 'configureTile',
        value: function configureTile(tile) {
            this.currentTile = tile;
            this.XlrSidebarService.open(_xlrDashboardConstants.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME);
        }
    }, {
        key: 'editDashboard',
        value: function editDashboard() {
            this.XlrSidebarService.toggle(_xlrDashboardConstants.DASHBOARD_PROPERTIES_SIDEBAR_NAME);
        }
    }, {
        key: 'toggleWidgets',
        value: function toggleWidgets() {
            this.XlrSidebarService.toggle(_xlrDashboardConstants.DASHBOARD_WIDGETS_SIDEBAR_NAME);
        }
    }]);
    return XlrDashboardController;
}();

XlrDashboardController.$inject = ['$scope', '$q', '$state', '$stateParams', 'Ids', 'Authenticator', 'ReleasesService', 'xlrDashboardConfigProvider', 'xlrelease.XlrDashboardService', 'VariablesService', 'xlrelease.XlrSidebarService', '$uibModal', '$rootScope', 'Events', 'Page'];


var XlrDashboard = function XlrDashboard() {
    return {
        transclude: true,
        templateUrl: 'static/9.5.5/include/DashboardPage/xlr-dashboard.html',
        controller: 'xlrelease.dashboard.XlrDashboardController',
        controllerAs: 'xlrDashboard'
    };
};

angular.module('xlrelease.dashboard').directive('xlrDashboard', XlrDashboard).controller('xlrelease.dashboard.XlrDashboardController', XlrDashboardController);

/***/ }),

/***/ 2391:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrDashboardService = function () {
    function XlrDashboardService(Backend) {
        (0, _classCallCheck3.default)(this, XlrDashboardService);

        this.Backend = Backend;
    }

    (0, _createClass3.default)(XlrDashboardService, [{
        key: 'loadConfiguration',
        value: function loadConfiguration(dashboardId, refresh) {
            var params = {};
            if (!!refresh) {
                params = { params: { refresh: refresh } };
            }
            return this.Backend.get('dashboards/' + dashboardId, params);
        }
    }, {
        key: 'update',
        value: function update(dashboard) {
            return this.Backend.put('dashboards/' + dashboard.id, dashboard);
        }
    }, {
        key: 'create',
        value: function create(dashboard) {
            return this.Backend.post('dashboards', dashboard);
        }
    }, {
        key: 'delete',
        value: function _delete(dashboard) {
            return this.Backend.del('dashboards/' + dashboard.id);
        }
    }, {
        key: 'tileTypes',
        value: function tileTypes(tileScope) {
            return this.Backend.get('tiles/tile-types?scope=' + tileScope);
        }
    }, {
        key: 'saveTile',
        value: function saveTile(tile) {
            return this.Backend.put('tiles/' + tile.id, tile);
        }
    }, {
        key: 'loadTile',
        value: function loadTile(tileId) {
            return this.Backend.get('tiles/' + tileId);
        }
    }, {
        key: 'list',
        value: function list(parentId, title) {
            return this.Backend.get('dashboards', { params: { parentId: parentId, title: title } }).then(function (resp) {
                return resp.data;
            });
        }
    }, {
        key: 'getDashboardTemplates',
        value: function getDashboardTemplates(tileScope) {
            return this.Backend.get('dashboards/templates?scope=' + tileScope);
        }
    }]);
    return XlrDashboardService;
}();

XlrDashboardService.$inject = ['Backend'];


angular.module('xlrelease.dashboard').service('xlrelease.XlrDashboardService', XlrDashboardService);

/***/ }),

/***/ 2392:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _keys = __webpack_require__(116);

var _keys2 = _interopRequireDefault(_keys);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrSidebarService = function () {
    function XlrSidebarService(SidebarJS) {
        (0, _classCallCheck3.default)(this, XlrSidebarService);

        this.SidebarJS = SidebarJS;
    }

    (0, _createClass3.default)(XlrSidebarService, [{
        key: 'open',
        value: function open(sidebarName) {
            this.closeAll();
            this.SidebarJS.open(sidebarName);
        }
    }, {
        key: 'close',
        value: function close(sidebarName) {
            this.SidebarJS.close(sidebarName);
        }
    }, {
        key: 'closeAll',
        value: function closeAll() {
            var _this = this;

            (0, _keys2.default)(this.SidebarJS.instances).map(function (instanceName) {
                return _this.SidebarJS.close(instanceName);
            });
        }
    }, {
        key: 'toggle',
        value: function toggle(sidebarName) {
            var sidebar = this.SidebarJS.instances[sidebarName];
            if (sidebar.isVisible()) {
                this.closeAll();
            } else {
                this.open(sidebarName);
            }
        }
    }]);
    return XlrSidebarService;
}();

XlrSidebarService.$inject = ['SidebarJS'];


angular.module('xlrelease.dashboard').service('xlrelease.XlrSidebarService', XlrSidebarService);

/***/ }),

/***/ 2393:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrTileUtil = __webpack_require__(797);

var _xlrDashboardConstants = __webpack_require__(268);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrTileController = function () {
    function XlrTileController($scope, $location, Ids) {
        (0, _classCallCheck3.default)(this, XlrTileController);

        this.$scope = $scope;
        this.$location = $location;
        this.Ids = Ids;

        this.buttons = {};
        this.tile = $scope.tile;
        this.title = this.tile.title;

        this.variables = $scope.variables;

        this.detailsUrl = (0, _xlrTileUtil.tileOrDefaultUrl)(this.tile.detailsUri);
        this.templateUrl = (0, _xlrTileUtil.tileOrDefaultUrl)(this.tile.uri);

        this.hasDetailsMode = !!this.tile.detailsUri;
    }

    (0, _createClass3.default)(XlrTileController, [{
        key: 'details',
        value: function details() {
            if (this.hasDetailsMode && this.$scope.dashboardMode !== 'design') {
                if (this.$scope.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE) {
                    var subPath = this.$scope.release.status === 'TEMPLATE' ? 'templates' : 'releases';
                    var hyphenatedReleaseId = this.$scope.release.id;
                    var domainReleaseId = this.Ids.toDomainId(hyphenatedReleaseId);

                    this.$location.path('/' + subPath + '/' + this.tile.id.replace(domainReleaseId, hyphenatedReleaseId) + '/details');
                } else if (this.$scope.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER) {
                    this.$location.path('folders-dashboards/' + this.tile.id + '/details');
                } else {
                    this.$location.path('dashboards/' + this.tile.id + '/details');
                }
            }
        }
    }, {
        key: 'configure',
        value: function configure() {
            this.tile = angular.copy(this.$scope.tile);
            this.state = 'config';
            this.$scope.configure({ item: this.tile });
        }
    }, {
        key: 'view',
        value: function view() {
            this.state = 'view';
        }
    }, {
        key: 'remove',
        value: function remove() {
            this.$scope.remove({ item: this.tile });
            this.view();
        }
    }, {
        key: 'addButton',
        value: function addButton(btn) {
            if (!_(this.buttons).includes(btn.title)) {
                this.buttons[btn.title] = btn;
            }
        }
    }, {
        key: 'onBtnClick',
        value: function onBtnClick(btn) {
            btn.onClick();
        }
    }]);
    return XlrTileController;
}();

XlrTileController.$inject = ['$scope', '$location', 'Ids'];


var xlrTileInject = ['$timeout', 'Events', 'Window'];
var XlrTile = function XlrTile($timeout, Events, Window) {
    return {
        scope: {
            tile: '=',
            tileTypeDefinition: '=',
            release: '=',
            variables: '=',
            dashboardMode: '=',
            dashboardLevel: '=',
            remove: '&',
            configure: '&'
        },
        restrict: 'A',
        templateUrl: 'static/9.5.5/include/DashboardPage/xlr-tile.html',
        controller: 'xlrelease.dashboard.XlrTileController',
        controllerAs: 'xlrTile',
        require: ['xlrTile', '^xlrDashboard'],
        link: function link(scope, elem, attr, ctrls) {
            var vm = ctrls[0];
            scope.xlrDashboard = ctrls[1];

            vm.setTitle = function (transcludedContent) {
                elem.find('.tile-title span').replaceWith(transcludedContent);
            };

            function adjustTileDimensions(el) {
                // left here just for backwards compatibility
                var panelBody = el.find('.panel-body');
                vm.height = panelBody.innerHeight();
                vm.width = panelBody.width();
                scope.$broadcast(Events.tile.resized);
            }

            scope.$on('gridster-item-resized', function (event) {
                adjustTileDimensions(event.targetScope.gridsterItem.$element);
            });

            var resizeFn = $timeout.bind(null, adjustTileDimensions.bind(null, elem), 200);
            Window.onResize(resizeFn, scope);

            resizeFn();
        }
    };
};
XlrTile.$inject = xlrTileInject;

angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrTileController', XlrTileController).directive('xlrTile', XlrTile);

/***/ }),

/***/ 2394:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrDefaultTileController = function () {
    function XlrDefaultTileController($scope, XlrDefaultTileService) {
        (0, _classCallCheck3.default)(this, XlrDefaultTileController);

        this.XlrDefaultTileService = XlrDefaultTileService;

        this.data = null;
        this.release = $scope.release;
        if ($scope.xlrTile) {
            this.tile = $scope.xlrTile.tile; // summary mode
        } else {
            this.tile = $scope.xlrTileDetailsCtrl.tile; // details mode
        }
    }

    (0, _createClass3.default)(XlrDefaultTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.refresh();
        }
    }, {
        key: 'refresh',
        value: function refresh() {
            var _this = this;

            this.loading = true;
            // Optional query for getting data from an external backend, for example Jira or Jenkins
            this.XlrDefaultTileService.executeQuery(this.tile.id).then(function (response) {
                _this.data = response.data.data;
            }).finally(function () {
                this.loading = false;
            });
        }
    }]);
    return XlrDefaultTileController;
}();

XlrDefaultTileController.$inject = ['$scope', 'xlrelease.dashboard.XlrDefaultTileService'];

var XlrDefaultTileService = function () {
    function XlrDefaultTileService(Backend) {
        (0, _classCallCheck3.default)(this, XlrDefaultTileService);

        this.Backend = Backend;
    }

    (0, _createClass3.default)(XlrDefaultTileService, [{
        key: 'executeQuery',
        value: function executeQuery(tileId) {
            // This will trigger a Jython script (TileType.py by default) to get data from the external source.
            // The script can access input properties.
            // Query parameters can also be used here and will be available as variables in the script.
            return this.Backend.get('tiles/' + tileId + '/data');
        }
    }]);
    return XlrDefaultTileService;
}();

XlrDefaultTileService.$inject = ['Backend'];


angular.module('xlrelease.dashboard').service('xlrelease.dashboard.XlrDefaultTileService', XlrDefaultTileService).controller('xlrelease.dashboard.XlrDefaultTileController', XlrDefaultTileController);

/***/ }),

/***/ 2395:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrTileDetailsController = function () {
    function XlrTileDetailsController(tilePromise, releasePromise, dashboardPromise, Ids, Page) {
        (0, _classCallCheck3.default)(this, XlrTileDetailsController);

        this.tile = _.get(tilePromise, 'data');
        this.release = _.get(releasePromise, 'data');
        this.dashboard = _.get(dashboardPromise, 'data');
        this.Ids = Ids;

        if (this.dashboard) {
            Page.setDashboardOpened(this.dashboard);
        }
    }

    (0, _createClass3.default)(XlrTileDetailsController, [{
        key: 'getDashboardUrl',
        value: function getDashboardUrl() {
            if (this.release) {
                var base = this.release.status === 'TEMPLATE' ? 'templates' : 'releases';
                return '#/' + base + '/' + this.release.id + '/summary';
            } else if (this.dashboard && this.dashboard.parentId) {
                return '#/folders-dashboards/' + this.dashboard.id + '?folderId=' + this.dashboard.parentId;
            } else {
                return '#/dashboards/' + this.Ids.getParentId(this.tile.id);
            }
        }
    }]);
    return XlrTileDetailsController;
}();

XlrTileDetailsController.$inject = ['tilePromise', 'releasePromise', 'dashboardPromise', 'Ids', 'Page'];


angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrTileDetailsController', XlrTileDetailsController);

/***/ }),

/***/ 2396:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var XlrTileTitle = function XlrTileTitle() {
    return {
        restrict: 'A',
        require: ['^xlrTile'],
        transclude: true,
        link: function link(scope, elem, attr, ctrls, transclude) {
            _.head(ctrls).setTitle(transclude);
        }
    };
};

angular.module('xlrelease.dashboard').directive('xlrTileTitle', XlrTileTitle);

/***/ }),

/***/ 2397:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2399:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AddDashboard = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrDashboardConstants = __webpack_require__(268);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <a ng-if="$ctrl.canCreateNewDashboard()" class="button" href="#/dashboards/new">\n    <i class="xl-icon add-icon"></i>\n        Add dashboard\n    </a>\n';

var AddDashboardController = function () {
    function AddDashboardController(Authenticator, GlobalPermissions) {
        (0, _classCallCheck3.default)(this, AddDashboardController);

        this.Authenticator = Authenticator;
        this.GlobalPermission = GlobalPermissions;

        this.sidebarName = _xlrDashboardConstants.DASHBOARD_CREATION_SIDEBAR_NAME;
    }

    (0, _createClass3.default)(AddDashboardController, [{
        key: 'canCreateNewDashboard',
        value: function canCreateNewDashboard() {
            return this.Authenticator.hasPermission(this.GlobalPermission.CREATE_GLOBAL_DASHBOARD);
        }
    }]);
    return AddDashboardController;
}();

AddDashboardController.$inject = ['Authenticator', 'GlobalPermissions'];
var AddDashboard = exports.AddDashboard = {
    controller: AddDashboardController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrAddDashboard', AddDashboard);

/***/ }),

/***/ 2400:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AddDashboardPage = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrDashboardConstants = __webpack_require__(268);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="dashboard-create-page">\n        <div release-header>\n        </div>\n    \n        <div class="content-under-header">\n            <div class="dashboard-sidebar">\n                <div class="right-sidebar">\n                    <xlr-dashboard-templates\n                        ng-if="!$ctrl.selectedTemplateType"\n                        parent-id="$ctrl.folderId"\n                        on-select="$ctrl.onSelect(templateType)"\n                        on-cancel="$ctrl.onCancel()">\n                    </xlr-dashboard-templates>\n                    <xlr-dashboard-properties\n                        ng-if="$ctrl.selectedTemplateType"\n                        parent-id="$ctrl.folderId"\n                        template-type="$ctrl.selectedTemplateType"\n                        on-save="$ctrl.onSave(dashboard, isNew)"\n                        on-cancel="$ctrl.selectedTemplateType = null">\n                    </xlr-dashboard-properties>\n                </div>\n            </div>\n        </div>\n    </div>\n';

var AddDashboardPageController = function () {
    function AddDashboardPageController($state, $stateParams, Page) {
        (0, _classCallCheck3.default)(this, AddDashboardPageController);

        this.$state = $state;
        this.$stateParams = $stateParams;
        this.Page = Page;
    }

    (0, _createClass3.default)(AddDashboardPageController, [{
        key: '$onInit',
        value: function $onInit() {
            this.folderId = this.$stateParams.folderId;
            if (this.folderId) {
                this.Page.setDashboardOpened({ parentId: this.folderId, title: 'New dashboard' });
            }
        }
    }, {
        key: 'onSelect',
        value: function onSelect(templateType) {
            this.selectedTemplateType = templateType;
        }
    }, {
        key: 'onSave',
        value: function onSave(dashboard) {
            var state = this.folderId ? 'folderDashboards' : 'dashboards';
            this.$state.go(state, {
                dashboardId: dashboard.id,
                folderId: this.folderId,
                dashboardMode: this.selectedTemplateType && this.selectedTemplateType.type === 'xlrelease.BlankDashboard' ? _xlrDashboardConstants.DASHBOARD_MODE.DESIGN : _xlrDashboardConstants.DASHBOARD_MODE.VIEW
            }, { reload: true });
        }
    }, {
        key: 'onCancel',
        value: function onCancel() {
            this.$state.go('folders.detail.page', { folderId: this.folderId, page: 'dashboards' });
        }
    }]);
    return AddDashboardPageController;
}();

AddDashboardPageController.$inject = ['$state', '$stateParams', 'Page'];
var AddDashboardPage = exports.AddDashboardPage = {
    controller: AddDashboardPageController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrAddDashboardPage', AddDashboardPage);

/***/ }),

/***/ 2401:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var template = '\n    <div class="modal-header">\n        <h4 class="modal-title pull-left" id="modal-title">Delete dashboard</h4>\n        <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix"/>\n    </div>\n    <div class="modal-body actions-modal">      \n     <p>You are about to delete the dashboard <b>{{::$ctrl.resolve.data.dashboard.title}}</b>.</p>\n    </div>\n    <div class="modal-footer">\n        <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n        <button class="button save primary" type="submit" ng-click="$ctrl.close()">Delete</button>\n    </div>\n';

var deleteDashboardModal = exports.deleteDashboardModal = {
    bindings: {
        close: '&',
        dismiss: '&',
        resolve: '<'
    },
    template: template
};

angular.module('xlrelease.dashboard').component('xlrDeleteDashboardModal', deleteDashboardModal);

/***/ }),

/***/ 2402:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deleteDashboardModal = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="modal-content">\n    <form name="duplicateDashboardForm" id="duplicateDashboardForm" class="form-horizontal" novalidate>\n        <div class="modal-header">\n            <h4 class="modal-title pull-left" id="modal-title">Duplicate dashboard</h4>\n            <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon" /></button>\n            <div class="clearfix"/>\n        </div>\n        <div class="modal-body actions-modal">      \n            <div class="form-group">\n                <label class="col-sm-2 control-label" for="duplicateDashboard-title">New name <span ng-if="duplicateDashboardForm.$error.required" class="error">*</span></label>\n                <div class="col-sm-10">\n                    <input type="text" class="input-block-level" name="title" id="duplicateDashboard-title" \n                    ng-model="$ctrl.duplicate.title" ng-maxlength="255" required autofocus/>\n                    <span class="field-errors" ng-if="duplicateDashboardForm.title.$invalid">\n                        <span ng-if="duplicateDashboardForm.title.$error.required">Dashboard name is mandatory</span>\n                        <span ng-if="duplicateDashboardForm.title.$error.maxlength">Dashboard name is too long</span>\n                    </span>\n                </div>\n            </div>\n        </div>\n        <div class="modal-footer">\n            <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n            <button ng-disabled="duplicateDashboardForm.$invalid" class="button save primary" type="submit" ng-click="$ctrl.close({$value: $ctrl.duplicate})">Duplicate</button>\n        </div>\n    </form>\n</div>\n';

var DeleteDashboardModalcController = function () {
    function DeleteDashboardModalcController() {
        (0, _classCallCheck3.default)(this, DeleteDashboardModalcController);
    }

    (0, _createClass3.default)(DeleteDashboardModalcController, [{
        key: '$onInit',
        value: function $onInit() {
            this.duplicate = {
                title: this.resolve.data.dashboard.title + " (Copy)"
            };
        }
    }]);
    return DeleteDashboardModalcController;
}();

var deleteDashboardModal = exports.deleteDashboardModal = {
    bindings: {
        close: '&',
        dismiss: '&',
        resolve: '<'
    },
    controller: DeleteDashboardModalcController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrDuplicateDashboardModal', deleteDashboardModal);

/***/ }),

/***/ 2403:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.tileVersionFilter = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _map = __webpack_require__(244);

var _map2 = _interopRequireDefault(_map);

var _tileVersionFilterTpl = __webpack_require__(2404);

var _tileVersionFilterTpl2 = _interopRequireDefault(_tileVersionFilterTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var versionFilterType = {
    ALL: "ALL",
    MAJOR_VERSION: "MAJOR_VERSION",
    MINOR_VERSION: "MINOR_VERSION",
    PATCH_VERSION: "PATCH_VERSION",
    SNAPSHOT_VERSION: "SNAPSHOT_VERSION",
    ALPHA_VERSION: "ALPHA_VERSION",
    BETA_VERSION: "BETA_VERSION",
    RC_VERSION: "RC_VERSION",
    CUSTOM: "CUSTOM_VERSION"
};

var versionFilterMap = new _map2.default();
versionFilterMap.set(versionFilterType.ALL, "[^\\n]+");
versionFilterMap.set(versionFilterType.MAJOR_VERSION, "^([0-9]|[1-9][0-9]*)(\\.([0]))(\\.([0]))?$");
versionFilterMap.set(versionFilterType.MINOR_VERSION, "^([0-9]|[1-9][0-9]*)\\.([1-9]|[1-9][1-9]*)*(\\.([0]))?$");
versionFilterMap.set(versionFilterType.PATCH_VERSION, "^([0-9]|[1-9][0-9]*)\\.([0-9]|[1-9][0-9]*)\\.([1-9]|[1-9][1-9]*)$");
versionFilterMap.set(versionFilterType.SNAPSHOT_VERSION, "\\bSNAPSHOT\\b");
versionFilterMap.set(versionFilterType.ALPHA_VERSION, "\\bALPHA\\b");
versionFilterMap.set(versionFilterType.BETA_VERSION, "\\bBETA\\b");
versionFilterMap.set(versionFilterType.RC_VERSION, "\\bRC\\b");
versionFilterMap.set(versionFilterType.CUSTOM, "");

var VersionFilterComponent = function () {
    function VersionFilterComponent() {
        (0, _classCallCheck3.default)(this, VersionFilterComponent);

        this.versionFilterType = versionFilterType;
        this.versionFilterMap = versionFilterMap;
    }

    (0, _createClass3.default)(VersionFilterComponent, [{
        key: "$onInit",
        value: function $onInit() {
            if (this.tile.properties.versionFilterType.value !== this.versionFilterType.CUSTOM) {
                this.tile.properties.versionFilterRegex = this.versionFilterMap.get(this.tile.properties.versionFilterType.value);
            }
        }
    }, {
        key: "onVersionFilterTypeChange",
        value: function onVersionFilterTypeChange() {
            if (this.tile.properties.versionFilterType.value !== this.versionFilterType.CUSTOM || this.tile.properties.versionFilterType.value !== this.versionFilterType.NONE) {
                this.tile.properties.versionFilterRegex = this.versionFilterMap.get(this.tile.properties.versionFilterType.value);
            } else {
                this.tile.properties.versionFilterRegex = "";
            }
        }
    }]);
    return VersionFilterComponent;
}();

var tileVersionFilter = exports.tileVersionFilter = {
    bindings: {
        tile: '<'
    },
    controller: VersionFilterComponent,
    template: _tileVersionFilterTpl2.default
};

angular.module('xlrelease.dashboard').component('xlrTileVersionFilter', tileVersionFilter);

/***/ }),

/***/ 2404:
/***/ (function(module, exports) {

module.exports = "<label for=\"version-filter-select\" class=\"control-label col-xs-3\">Versions</label>\n<div class=\"col-xs-9\">\n    <select class=\"xlr-version-filter-select\"\n            id=\"version-filter-select\"\n            name=\"version-filter-select\"\n            ng-model=\"$ctrl.tile.properties.versionFilterType.value\"\n            ng-change=\"$ctrl.onVersionFilterTypeChange()\">\n        <option value=\"{{$ctrl.versionFilterType.ALL}}\">All</option>\n        <option value=\"{{$ctrl.versionFilterType.MAJOR_VERSION}}\">Major</option>\n        <option value=\"{{$ctrl.versionFilterType.MINOR_VERSION}}\">Minor</option>\n        <option value=\"{{$ctrl.versionFilterType.PATCH_VERSION}}\">Patch</option>\n        <option value=\"{{$ctrl.versionFilterType.SNAPSHOT_VERSION}}\">Snapshot</option>\n        <option value=\"{{$ctrl.versionFilterType.ALPHA_VERSION}}\">Alpha</option>\n        <option value=\"{{$ctrl.versionFilterType.BETA_VERSION}}\">Beta</option>\n        <option value=\"{{$ctrl.versionFilterType.RC_VERSION}}\">Release candidate</option>\n        <option value=\"{{$ctrl.versionFilterType.CUSTOM}}\">Custom</option>\n    </select>\n    <span class=\"description\">\n        Display only the versions of the selected semantic version type.\n        See <a target=\"_blank\" href=\"https://semver.org/\">https://semver.org/</a> for details.\n    </span>\n    <div ng-if=\"$ctrl.tile.properties.versionFilterType.value === $ctrl.versionFilterType.CUSTOM\" class=\"version-filter mtm\">\n        <div class=\"form-group\">\n            <label for=\"regex\" class=\"control-label col-xs-3\">Regular expression <span class=\"error\">*</span></label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"regex\" name=\"regex\" required\n                       ng-model=\"$ctrl.tile.properties.versionFilterRegex\"\n                       class=\"form-control\">\n                <span class=\"description\">Python compatible regular expression, e.g. Major ^([0-9]|[1-9][0-9]*)(\\.([0]))(\\.([0]))?$</span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2405:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2407:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.dashboardPlaceholder = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="dashboard-placeholder">\n    <div release-header></div>\n    <div class="content-under-header"\n        <div ng-if="$ctrl.subMenuItems.length == 0">\n            <div ng-if="$ctrl.hasDashboardCreatePerrmisions()" class="notice">\n                <div class="notice-title">Create your first dashboard</div>\n                <div class="notice-descripton">You haven\'t created any dashboards yet<br/>To get started, click the Add dashboard button</div>\n            </div>\n            <div ng-if="!$ctrl.hasDashboardCreatePerrmisions()" class="notice">\n                <div class="notice-title">No accessible dashboards</div>\n                <div class="notice-descripton">You do not have the permissions required to view dashboards<br/>Contact the XL Release administrator for assistance</div>\n            </div>\n        </div>\n    </div>\n</div>\n';

var DashboardPlaceholderController = function () {
    function DashboardPlaceholderController(Authenticator, GlobalPermissions, $location) {
        (0, _classCallCheck3.default)(this, DashboardPlaceholderController);

        this.Authenticator = Authenticator;
        this.GlobalPermission = GlobalPermissions;
        this.$location = $location;
    }

    (0, _createClass3.default)(DashboardPlaceholderController, [{
        key: '$onChanges',
        value: function $onChanges(changes) {
            if (changes.subMenuItems && changes.subMenuItems.currentValue) {
                var subMenuItems = changes.subMenuItems.currentValue;
                var hasDashboard = _.some(subMenuItems, function (item) {
                    return item.pathSuffix && item.pathSuffix.startsWith('dashboards');
                });
                if (hasDashboard) {
                    this.$location.url(_.head(subMenuItems).pathSuffix);
                }
            }
        }
    }, {
        key: 'hasDashboardCreatePerrmisions',
        value: function hasDashboardCreatePerrmisions() {
            return this.Authenticator.hasPermission(this.GlobalPermission.CREATE_GLOBAL_DASHBOARD);
        }
    }]);
    return DashboardPlaceholderController;
}();

DashboardPlaceholderController.$inject = ['Authenticator', 'GlobalPermissions', '$location'];
var dashboardPlaceholder = exports.dashboardPlaceholder = {
    bindings: {
        subMenuItems: '<'
    },
    controller: DashboardPlaceholderController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrDashboardPlaceholder', dashboardPlaceholder);

/***/ }),

/***/ 2408:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DashboardPropertiesSidebar = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _dashboardPropertiesSidebar = __webpack_require__(2409);

var _dashboardPropertiesSidebar2 = _interopRequireDefault(_dashboardPropertiesSidebar);

var _xlrDashboardConstants = __webpack_require__(268);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DashboardPropertiesSidebarController = function () {
    function DashboardPropertiesSidebarController($state, $rootScope, Events, XlrSidebarService) {
        (0, _classCallCheck3.default)(this, DashboardPropertiesSidebarController);

        this.$state = $state;
        this.$rootScope = $rootScope;
        this.Events = Events;
        this.XlrSidebarService = XlrSidebarService;
        this.sidebarOpts = {
            position: 'right',
            backdropOpacity: 0
        };
    }

    (0, _createClass3.default)(DashboardPropertiesSidebarController, [{
        key: '$onInit',
        value: function $onInit() {
            this.$rootScope.$on('$stateChangeStart', this.onCancel.bind(this));
        }
    }, {
        key: 'onOpenSidebar',
        value: function onOpenSidebar() {
            this.isVisible = true;
        }
    }, {
        key: 'onCloseSidebar',
        value: function onCloseSidebar() {
            this.isVisible = false;
        }
    }, {
        key: 'onCancel',
        value: function onCancel() {
            this.XlrSidebarService.close(this.sidebarName);
        }
    }, {
        key: 'onSave',
        value: function onSave(dashboard, isNew) {
            this.XlrSidebarService.close(this.sidebarName);
            if (dashboard.parentId) {
                this.$state.go('folderDashboards', {
                    dashboardId: dashboard.id,
                    folderId: dashboard.parentId
                }, { reload: true });
            } else {
                this.$rootScope.$emit(this.Events.ui.subMenuRefresh);
                this.$state.go('dashboards', {
                    dashboardId: dashboard.id,
                    dashboardMode: isNew ? _xlrDashboardConstants.DASHBOARD_MODE.DESIGN : undefined
                }, { reload: true });
            }
        }
    }]);
    return DashboardPropertiesSidebarController;
}();

DashboardPropertiesSidebarController.$inject = ['$state', '$rootScope', 'Events', 'xlrelease.XlrSidebarService'];
var DashboardPropertiesSidebar = exports.DashboardPropertiesSidebar = {
    bindings: {
        sidebarName: '<',
        dashboard: '<'
    },
    controller: DashboardPropertiesSidebarController,
    template: _dashboardPropertiesSidebar2.default
};

angular.module('xlrelease.dashboard').component('xlrDashboardPropertiesSidebar', DashboardPropertiesSidebar);

/***/ }),

/***/ 2409:
/***/ (function(module, exports) {

module.exports = "<sidebarjs class=\"dashboard-sidebar\"\n           sidebarjs-name=\"{{$ctrl.sidebarName}}\"\n           sidebarjs-config=\"$ctrl.sidebarOpts\"\n           on-open=\"$ctrl.onOpenSidebar()\"\n           on-close=\"$ctrl.onCloseSidebar()\">\n    <xlr-dashboard-properties\n            ng-if=\"$ctrl.isVisible\"\n            parent-id=\"$ctrl.dashboard.parentId\"\n            current-dashboard=\"$ctrl.dashboard\"\n            on-save=\"$ctrl.onSave(dashboard, isNew)\"\n            on-cancel=\"$ctrl.onCancel()\">\n    </xlr-dashboard-properties>\n</sidebarjs>\n"

/***/ }),

/***/ 2410:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DashboardProperties = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _slicedToArray2 = __webpack_require__(109);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(2411);

var _dashboardProperties = __webpack_require__(2413);

var _dashboardProperties2 = _interopRequireDefault(_dashboardProperties);

var _xlrDashboardConstants = __webpack_require__(268);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DashboardPropertiesController = function () {
    function DashboardPropertiesController(XlrDashboardService, RolesService, UsersService, ClientSettings, $q, TeamsService, FolderPathService) {
        (0, _classCallCheck3.default)(this, DashboardPropertiesController);

        this.XlrDashboardService = XlrDashboardService;
        this.RolesService = RolesService;
        this.UsersService = UsersService;
        this.ClientSettings = ClientSettings;
        this.$q = $q;
        this.TeamsService = TeamsService;
        this.FolderPathService = FolderPathService;
        this._saveListeners = [];
    }

    (0, _createClass3.default)(DashboardPropertiesController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.saving = false;
            this.toStep('PROPERTIES');

            if (this.templateType) {
                var configurationUri = this.templateType.properties.find(function (property) {
                    return property.name === 'configurationUri';
                }).default;
                if (configurationUri) {
                    this.configurationUri = 'static/9.5.5/' + configurationUri;
                }
            }

            var rolesPromise = this.$q.defer();
            if (this.parentId) {
                rolesPromise.resolve([]);
            } else {
                this.RolesService.getRoleNames().then(function (res) {
                    return rolesPromise.resolve(_this._convertToTags(res.data));
                });
            }
            var usersPromise = this.UsersService.getAllUsers().then(function (res) {
                return res.data;
            });

            this.$q.all([rolesPromise.promise, usersPromise]).then(function (_ref) {
                var _ref2 = (0, _slicedToArray3.default)(_ref, 2),
                    allRoles = _ref2[0],
                    allUsers = _ref2[1];

                _this.allRoles = allRoles;
                _this.allUsers = allUsers;

                _this.columns = _.range(1, _xlrDashboardConstants.DASHBOARD_MAX_COLUMNS + 1);

                if (_this.currentDashboard) {
                    _this.dashboard = angular.copy(_this.currentDashboard);
                    _this._assignDashboard(_this.dashboard);
                } else {
                    _this.roleViewers = [];
                    _this.roleEditors = [];
                    _this.dashboard = {
                        title: _this.templateType ? _this.templateType.properties.find(function (property) {
                            return property.name === 'title';
                        }).default : '',
                        description: _this.templateType ? _this.templateType.properties.find(function (property) {
                            return property.name === 'description';
                        }).default : '',
                        templateType: _this.templateType ? _this.templateType.type : null,
                        columns: _this.templateType ? _this.templateType.properties.find(function (property) {
                            return property.name === 'columns';
                        }).default : _xlrDashboardConstants.DASHBOARD_DEFAULT_COLUMNS,
                        parentId: _this.parentId,
                        properties: {}
                    };
                    _this.owner = _this.ClientSettings.getAuthenticationData();
                }

                if (_this.dashboard.parentId) {
                    _this.FolderPathService.getPathFromParentFolderId(_this.dashboard.parentId).then(function (paths) {
                        return _this.inheritedFrom = _.last(paths);
                    });
                }
            });
        }
    }, {
        key: '_assignDashboard',
        value: function _assignDashboard(dashboard) {
            this.roleViewers = this._convertToTags(dashboard.roleViewers);
            this.roleEditors = this._convertToTags(dashboard.roleEditors);
            this.owner = _.find(this.allUsers, { username: dashboard.owner });
        }
    }, {
        key: '_convertToTags',
        value: function _convertToTags(roles) {
            return roles.map(function (roleName) {
                return {
                    name: roleName,
                    type: 'ROLE'
                };
            });
        }
    }, {
        key: 'isNew',
        value: function isNew() {
            return !_.has(this, 'dashboard.id');
        }
    }, {
        key: 'canEditColumns',
        value: function canEditColumns() {
            return !this.isNew() || !this.templateType || this.templateType.type === 'xlrelease.BlankDashboard';
        }
    }, {
        key: 'hasInheritedSecurity',
        value: function hasInheritedSecurity() {
            return !!this.parentId;
        }
    }, {
        key: 'isValid',
        value: function isValid() {
            return this.dashboard.title && this.owner;
        }
    }, {
        key: 'saveDashboard',
        value: function saveDashboard() {
            var _this2 = this;

            this._saveListeners.forEach(function (listener) {
                return listener(_this2.dashboard);
            });
            var dashboardView = (0, _extends3.default)({}, _.omit(this.dashboard, 'metadata'), {
                roleViewers: this.roleViewers.map(function (role) {
                    return role.name;
                }),
                roleEditors: this.roleEditors.map(function (role) {
                    return role.name;
                }),
                owner: this.owner.username
            });
            this.saving = true;
            var promise = void 0;
            if (this.isNew()) {
                promise = this.XlrDashboardService.create(dashboardView);
            } else {
                promise = this.XlrDashboardService.update(dashboardView);
            }

            promise.then(function (resp) {
                var dashboard = resp.data;
                _this2.onSave({ dashboard: dashboard, isNew: _this2.isNew() });
            }).finally(function () {
                return _this2.saving = false;
            });
        }
    }, {
        key: 'cancel',
        value: function cancel() {
            this.onCancel();
        }
    }, {
        key: 'hasConfiguration',
        value: function hasConfiguration() {
            return !!this.configurationUri;
        }
    }, {
        key: 'toStep',
        value: function toStep(step) {
            this.currentStep = step;
        }
    }, {
        key: 'registerSaveListener',
        value: function registerSaveListener(listener) {
            this._saveListeners.push(listener);
        }
    }, {
        key: 'unregisterSaveListener',
        value: function unregisterSaveListener(listener) {
            this._saveListeners = this._saveListeners.filter(function (item) {
                return item !== listener;
            });
        }
    }]);
    return DashboardPropertiesController;
}();

DashboardPropertiesController.$inject = ['xlrelease.XlrDashboardService', 'RolesService', 'UsersService', 'ClientSettings', '$q', 'TeamsService', 'FolderPathService'];
var DashboardProperties = exports.DashboardProperties = {
    bindings: {
        currentDashboard: '<',
        templateType: '<',
        parentId: '<',
        onSave: '&',
        onCancel: '&'
    },
    controller: DashboardPropertiesController,
    template: _dashboardProperties2.default
};

angular.module('xlrelease.dashboard').component('xlrDashboardProperties', DashboardProperties);

/***/ }),

/***/ 2411:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2413:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar dashboard-sidebar-properties\" ng-if=\"$ctrl.dashboard\">\n    <div class=\"sidebar-title\" ng-if=\"$ctrl.isNew()\">Add dashboard</div>\n    <div class=\"sidebar-title\" ng-if=\"!$ctrl.isNew()\">Properties</div>\n    <div class=\"sidebar-container\">\n        <form ng-if=\"$ctrl.dashboard\" id=\"dashboardForm\" name=\"dashboardForm\" class=\"form-horizontal\"\n              data-test=\"dashboard-form\"\n              novalidate>\n            <div ng-if=\"$ctrl.currentStep == 'PROPERTIES'\">\n                <div class=\"form-group\">\n                    <label class=\"control-label col-xs-3\">\n                        Name\n                        <span class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-xs-9\">\n                        <input type=\"text\" class=\"input-block-level\" id=\"title\" name=\"title\"\n                               ng-model=\"$ctrl.dashboard.title\" ng-maxlength=\"255\" autofocus required/>\n                        <span class=\"description\" ng-if=\"dashboardForm.title.$pristine || dashboardForm.title.$valid\">Name of the dashboard</span>\n                        <span class=\"field-errors\" ng-if=\"dashboardForm.title.$dirty && dashboardForm.title.$invalid\">\n                            <span ng-if=\"dashboardForm.title.$error.required\">Dashboard name is mandatory</span>\n                            <span ng-if=\"dashboardForm.title.$error.maxlength\">Dashboard name is too long</span>\n                        </span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"control-label col-xs-3\">\n                        Description\n                    </label>\n\n                    <div class=\"col-xs-9\">\n                    <textarea class=\"input-block-level\" id=\"description\" name=\"description\"\n                              ng-model=\"$ctrl.dashboard.description\" ng-maxlength=\"255\"></textarea>\n                        <span class=\"description\"\n                              ng-if=\"dashboardForm.description.$pristine || dashboardForm.description.$valid\">Short description of the dashboard</span>\n                        <span class=\"field-errors\" ng-if=\"dashboardForm.description.$dirty && dashboardForm.description.$invalid\">\n                            <span ng-if=\"dashboardForm.description.$error.maxlength\">Dashboard description is too long</span>\n                        </span>\n                    </div>\n                </div>\n                <div class=\"form-group\" ng-if=\"$ctrl.canEditColumns()\">\n                    <label class=\"control-label col-xs-3\">\n                        Columns <span class=\"error\">*</span>\n                    </label>\n                    <div class=\"col-xs-9\">\n                        <span uib-dropdown class=\"dropdown-selector\">\n                            <button type=\"button\" class=\"btn btn-flat btn-fixed btn-block\" uib-dropdown-toggle>\n                                <span class=\"dropdown-label pull-left\">{{$ctrl.dashboard.columns}}</span>\n                                <i class=\"xl-icon arrow-down-icon pull-right\"></i>\n                            </button>\n                            <ul uib-dropdown-menu>\n                                <li ng-repeat=\"option in $ctrl.columns\"\n                                    ng-class=\"{active: option === $ctrl.dashboard.columns}\">\n                                    <a ng-click=\"$ctrl.dashboard.columns = option; dashboardForm.$setDirty()\">\n                                       {{option}}\n                                    </a>\n                                </li>\n                            </ul>\n                        </span>\n                        <span class=\"description\">Number of columns for the dashboard</span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"control-label col-xs-3\">Dashboard owner <span class=\"error\">*</span></label>\n\n                    <div class=\"col-xs-9\">\n                        <span ng-if=\"!$ctrl.readOnly\"\n                              class=\"input-block-level dashboard-owner\"\n                              inline-user-editor\n                              model=\"$ctrl.owner\"\n                              autocomplete-data=\"$ctrl.allUsers\"\n                              placeholder=\"Set owner...\">\n                            <span display-user=\"$ctrl.owner\"></span>\n                        </span>\n                        <span class=\"description\">Owner of this dashboard</span>\n                    </div>\n                </div>\n                <div>\n                    <div class=\"form-group\" ng-if=\"$ctrl.hasInheritedSecurity()\">\n                        <label class=\"control-label col-xs-12\">\n                            Inherits teams and permissions from parent folder <a ng-href=\"#folders/{{$ctrl.inheritedFrom.id}}/permissions\">{{$ctrl.inheritedFrom.title}}</a>.\n                        </label>\n                    </div>\n                    <div class=\"form-group\" ng-hide=\"$ctrl.hasInheritedSecurity() && $ctrl.isNew()\">\n                        <label class=\"control-label col-xs-3\">\n                            Viewers\n                        </label>\n\n                        <div class=\"col-xs-9\">\n                            <div ng-if=\"$ctrl.allRoles\"\n                                 name=\"principals\"\n                                 class=\"transparent role-tags role\"\n                                 members-input\n                                 read-only=\"$ctrl.hasInheritedSecurity()\"\n                                 tag-type=\"ROLE\"\n                                 tags=\"$ctrl.roleViewers\"\n                                 placeholder=\"Add a role...\"\n                                 completion-candidates=\"$ctrl.allRoles\"\n                                 on-change=\"dashboardForm.$setDirty()\">\n                            </div>\n                            <span class=\"description\">Roles that can view this dashboard</span>\n                        </div>\n                    </div>\n                    <div class=\"form-group\" ng-hide=\"$ctrl.hasInheritedSecurity() && $ctrl.isNew()\">\n                        <label class=\"control-label col-xs-3\">\n                            Editors\n                        </label>\n\n                        <div class=\"col-xs-9\">\n                            <div ng-if=\"$ctrl.allRoles\"\n                                 name=\"roleEditors\"\n                                 class=\"transparent role-tags role\"\n                                 members-input\n                                 read-only=\"$ctrl.hasInheritedSecurity()\"\n                                 tag-type=\"ROLE\"\n                                 tags=\"$ctrl.roleEditors\"\n                                 placeholder=\"Add a role...\"\n                                 completion-candidates=\"$ctrl.allRoles\"\n                                 on-change=\"dashboardForm.$setDirty()\">\n                            </div>\n                            <span class=\"description\">Roles that can edit this dashboard</span>\n                        </div>\n                    </div>\n                    <div class=\"action-buttons\">\n                        <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.cancel()\">Cancel</button>\n                        <button ng-if=\"!$ctrl.hasConfiguration()\" type=\"button\" class=\"button save primary\"\n                                ng-click=\"$ctrl.saveDashboard()\"\n                                ng-disabled=\"!$ctrl.isValid() || dashboardForm.$invalid || $ctrl.saving\">\n                            {{$ctrl.isNew() ? 'Create' : 'Save' }}\n                        </button>\n                        <button ng-if=\"$ctrl.hasConfiguration()\" type=\"button\" class=\"button save primary\"\n                                ng-click=\"$ctrl.toStep('CONFIGURATION')\"\n                                ng-disabled=\"!$ctrl.isValid() || dashboardForm.$invalid || $ctrl.saving\">\n                            Next\n                        </button>\n                    </div>\n                </div>\n            </div>\n            <div ng-if=\"$ctrl.currentStep == 'CONFIGURATION'\">\n                <div ng-include=\"$ctrl.configurationUri\"></div>\n                <div class=\"action-buttons\">\n                    <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.toStep('PROPERTIES')\">Back</button>\n                    <button type=\"button\" class=\"button save primary\"\n                            ng-click=\"$ctrl.saveDashboard()\"\n                            ng-disabled=\"!$ctrl.isValid() || dashboardForm.$invalid || $ctrl.saving\">\n                        {{$ctrl.isNew() ? 'Create' : 'Save' }}\n                    </button>\n                </div>\n            </div>\n        </form>\n    </div>\n</div>"

/***/ }),

/***/ 2414:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DashboardTemplates = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(2415);

var _dashboardTemplates = __webpack_require__(2417);

var _dashboardTemplates2 = _interopRequireDefault(_dashboardTemplates);

var _xlrDashboardConstants = __webpack_require__(268);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DashboardTemplatesController = function () {
    function DashboardTemplatesController(XlrDashboardService, ClientSettings) {
        (0, _classCallCheck3.default)(this, DashboardTemplatesController);

        this.XlrDashboardService = XlrDashboardService;
        this.ClientSettings = ClientSettings;
    }

    (0, _createClass3.default)(DashboardTemplatesController, [{
        key: '$onInit',
        value: function $onInit() {
            this.loadTemplates();
        }
    }, {
        key: 'loadTemplates',
        value: function loadTemplates() {
            var _this = this;

            var dashboardLevel = this.parentId ? _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER : _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
            this.XlrDashboardService.getDashboardTemplates(dashboardLevel).then(function (response) {
                _this.templateTypes = response.data;
                _this.blankTemplateType = _this.templateTypes.find(function (templateType) {
                    return templateType.type === 'xlrelease.BlankDashboard';
                });
            });
        }
    }, {
        key: 'filterTemplateType',
        value: function filterTemplateType(query) {
            var _this2 = this;

            var searchQuery = _.trim(query).toLowerCase();
            return function (templateType) {
                return templateType !== _this2.blankTemplateType && (!searchQuery || _.toLower(templateType.label).includes(searchQuery) || _.toLower(templateType.description).includes(searchQuery));
            };
        }
    }, {
        key: 'selectTemplate',
        value: function selectTemplate(templateType) {
            this.onSelect({ templateType: templateType });
        }
    }]);
    return DashboardTemplatesController;
}();

DashboardTemplatesController.$inject = ['xlrelease.XlrDashboardService', 'ClientSettings'];
var DashboardTemplates = exports.DashboardTemplates = {
    bindings: {
        parentId: '<',
        onSelect: '&',
        onCancel: '&'
    },
    controller: DashboardTemplatesController,
    template: _dashboardTemplates2.default
};

angular.module('xlrelease.dashboard').component('xlrDashboardTemplates', DashboardTemplates);

/***/ }),

/***/ 2415:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2417:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar\">\n    <div class=\"sidebar-title\">Add dashboard</div>\n    <div class=\"sidebar-subtitle\">Select template</div>\n    <div class=\"sidebar-container\">\n        <div class=\"row mbs\">\n            <div class=\"col-xs-12\">\n                <xlr-tile-card label=\"'Select'\" tile=\"$ctrl.blankTemplateType\" add=\"$ctrl.selectTemplate($ctrl.blankTemplateType)\"></xlr-tile-card>\n            </div>\n        </div>\n        <hr/>\n        <div class=\"row mbs\">\n            <div class=\"col-xs-12 search-bar\">\n                <i class=\"xl-icon search-icon\"></i>\n                <input id=\"tile-filter\"\n                       type=\"search\"\n                       class=\"tile-filter\"\n                       placeholder=\"Search for template\"\n                       ng-model=\"$ctrl.searchQuery\">\n            </div>\n        </div>\n        <div class=\"row mbs\" ng-repeat=\"templateType in $ctrl.templateTypes | filter:$ctrl.filterTemplateType($ctrl.searchQuery)\">\n            <div class=\"col-xs-12\">\n                <xlr-tile-card label=\"'Select'\" tile=\"templateType\" add=\"$ctrl.selectTemplate(templateType)\"></xlr-tile-card>\n            </div>\n        </div>\n    </div>\n</div>"

/***/ }),

/***/ 2418:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _tileConfiguration = __webpack_require__(2419);

var _tileConfiguration2 = _interopRequireDefault(_tileConfiguration);

var _xlrTileUtil = __webpack_require__(797);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TileConfigurationController = function () {
    function TileConfigurationController(VariablesService, XlrSidebarService, $scope) {
        (0, _classCallCheck3.default)(this, TileConfigurationController);

        this.VariablesService = VariablesService;
        this.XlrSidebarService = XlrSidebarService;
        this.$scope = $scope;
        this._saveListeners = [];
    }

    (0, _createClass3.default)(TileConfigurationController, [{
        key: '$onInit',
        value: function $onInit() {
            this.$scope.release = this.release;
        }
    }, {
        key: '$onChanges',
        value: function $onChanges(changes) {
            if (changes.tile && changes.tile.currentValue) {
                this.configureTile(changes.tile.currentValue);
            }
        }
    }, {
        key: 'configureTile',
        value: function configureTile(tile) {
            this.tile = tile;
            this.tileTypeDefinition = this.tileTypeDefs[tile.type];
            this.configurationPropertyDefinitions = _.filter(this.tileTypeDefinition.properties, function (property) {
                return property.category === 'input' && property.hidden !== true;
            });
        }
    }, {
        key: 'getConfigUrl',
        value: function getConfigUrl(tile) {
            return (0, _xlrTileUtil.tileOrDefaultUrl)(tile.configurationUri, 'include/DashboardPage/partials/tile-dip-config.html');
        }
    }, {
        key: 'createVariable',
        value: function createVariable(name, variableType, createdCallback) {
            if (this.release && this.release.id) {
                var variable = {
                    key: name,
                    type: variableType
                };

                this.VariablesService.createReleaseVariable(this.release.id, variable).then(function (resp) {
                    if (createdCallback) {
                        createdCallback(resp.data);
                    }
                });
            }
        }
    }, {
        key: 'save',
        value: function save() {
            var _this = this;

            this._saveListeners.forEach(function (listener) {
                return listener(_this.tile);
            });
            this.saveTile({ item: this.tile });
            this.dismiss();
        }
    }, {
        key: 'update',
        value: function update(tile) {
            this.tile = (0, _extends3.default)({}, tile);
        }
    }, {
        key: 'dismiss',
        value: function dismiss() {
            this.XlrSidebarService.closeAll();
        }
    }, {
        key: 'registerSaveListener',
        value: function registerSaveListener(listener) {
            this._saveListeners.push(listener);
        }
    }, {
        key: 'unregisterSaveListener',
        value: function unregisterSaveListener(listener) {
            this._saveListeners = this._saveListeners.filter(function (item) {
                return item !== listener;
            });
        }
    }]);
    return TileConfigurationController;
}();

TileConfigurationController.$inject = ['VariablesService', 'xlrelease.XlrSidebarService', '$scope'];


var tileConfiguration = {
    bindings: {
        tile: '<',
        tileTypeDefs: '=',
        variables: '=',
        release: '=',
        saveTile: '&'
    },
    controller: TileConfigurationController,
    controllerAs: 'xlrTile', // Note: this is added for backward compatibility of tiles
    template: _tileConfiguration2.default
};

angular.module('xlrelease.dashboard').component('xlrTileConfiguration', tileConfiguration);

/***/ }),

/***/ 2419:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar\" ng-if=\"xlrTile.tile\">\n    <div class=\"sidebar-title\">Edit tile</div>\n    <div class=\"sidebar-container\">\n        <div class=\"sidebar-renderer\" ng-include=\"xlrTile.getConfigUrl(xlrTile.tile)\"></div>\n        <div class=\"action-buttons\">\n            <button class=\"button cancel\" type=\"button\" ng-click=\"xlrTile.dismiss()\">Cancel</button>\n            <button class=\"button save primary\" type=\"submit\" ng-click=\"xlrTile.save()\">Save</button>\n        </div>\n    </div>\n</div>"

/***/ }),

/***/ 2420:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _tileCard = __webpack_require__(2421);

var _tileCard2 = _interopRequireDefault(_tileCard);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var tileCard = {
    bindings: {
        tile: '<',
        add: '&',
        label: '<'
    },
    template: _tileCard2.default
};

angular.module('xlrelease.dashboard').component('xlrTileCard', tileCard);

/***/ }),

/***/ 2421:
/***/ (function(module, exports) {

module.exports = "<div class=\"tile-card\">\n    <div>\n        <span class=\"tile-card-title\">\n         {{::$ctrl.tile.label}}\n        </span>\n        <button class=\"button tile-card-button primary pull-right\" ng-click=\"$ctrl.add()\">{{::$ctrl.label}}</button>\n    </div>\n    <div class=\"tile-content\">\n        <span class=\"tile-card-content\">\n            {{::$ctrl.tile.description}}\n        </span>\n    </div>\n</div>\n"

/***/ }),

/***/ 2422:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _tileSelector = __webpack_require__(2423);

var _tileSelector2 = _interopRequireDefault(_tileSelector);

__webpack_require__(2424);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TileSelectorController = function () {
    function TileSelectorController() {
        (0, _classCallCheck3.default)(this, TileSelectorController);

        this.searchQuery = '';
    }

    (0, _createClass3.default)(TileSelectorController, [{
        key: '$onInit',
        value: function $onInit() {
            this.tileTypeDefsValues = _.values(this.tileTypeDefs);
            this.filteredTileTypeDefs = this.tileTypeDefsValues;
        }
    }, {
        key: 'filterTiles',
        value: function filterTiles() {
            var _this = this;

            var searchQuery = _.trim(this.searchQuery).toLowerCase();

            if (searchQuery) {
                this.filteredTileTypeDefs = _.keys(this.tileTypeDefs).reduce(function (filteredTileTypeDefs, tileDef) {
                    var tileTypeDef = _this.tileTypeDefs[tileDef];
                    if (_.toLower(tileTypeDef.label).includes(searchQuery) || _.toLower(tileTypeDef.description).includes(searchQuery)) {
                        filteredTileTypeDefs.push(tileTypeDef);
                    }
                    return filteredTileTypeDefs;
                }, []);
            } else {
                this.filteredTileTypeDefs = this.tileTypeDefsValues;
            }
        }
    }]);
    return TileSelectorController;
}();

var tileSelector = {
    bindings: {
        tileTypeDefs: '<',
        addTile: '&'
    },
    controller: TileSelectorController,
    template: _tileSelector2.default
};

angular.module('xlrelease.dashboard').component('xlrTileSelector', tileSelector);

/***/ }),

/***/ 2423:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar\">\n    <div class=\"sidebar-title\">Add tiles</div>\n    <div class=\"row mbs\">\n        <div class=\"col-xs-12 search-bar\">\n            <i class=\"xl-icon search-icon\"></i>\n            <input id=\"tile-filter\"\n                   type=\"search\"\n                   class=\"tile-filter\"\n                   placeholder=\"Search...\"\n                   ng-model=\"$ctrl.searchQuery\"\n                   ng-change=\"$ctrl.filterTiles()\">\n        </div>\n    </div>\n    <div class=\"sidebar-container\">\n        <div class=\"row mbs\" ng-repeat=\"tileTypeDef in $ctrl.filteredTileTypeDefs\">\n            <div class=\"col-xs-12\">\n                <xlr-tile-card label=\"'Add'\" tile=\"tileTypeDef\" add=\"$ctrl.addTile({type: tileTypeDef.type})\"></xlr-tile-card>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2424:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2426:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2427);

var _markdownTileViewComponent = __webpack_require__(2429);

var _markdownTileConfigComponent = __webpack_require__(2431);

var _markdownAttachmentFilter = __webpack_require__(2433);

angular.module('xlrelease.dashboard').component('markdownTileConfig', _markdownTileConfigComponent.markdownTileConfig).component('markdownTileView', _markdownTileViewComponent.markdownTileView).filter('markdownAttachment', _markdownAttachmentFilter.markdownAttachmentFilter);

/***/ }),

/***/ 2427:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2429:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.markdownTileView = undefined;

var _markdownTileViewTpl = __webpack_require__(2430);

var _markdownTileViewTpl2 = _interopRequireDefault(_markdownTileViewTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var markdownTileView = exports.markdownTileView = {
    bindings: {
        tile: '<',
        parent: '<',
        variables: '<'
    },
    template: _markdownTileViewTpl2.default
};

/***/ }),

/***/ 2430:
/***/ (function(module, exports) {

module.exports = "<div class=\"markdown-tile-view\">\n    <span ng-bind-html=\"$ctrl.tile.properties.content | markdownAttachment:$ctrl.tile.properties.attachments.value | displayVariables:$ctrl.variables:true\"></span>\n</div>\n"

/***/ }),

/***/ 2431:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.markdownTileConfig = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _markdownTileConfigTpl = __webpack_require__(2432);

var _markdownTileConfigTpl2 = _interopRequireDefault(_markdownTileConfigTpl);

var _constants = __webpack_require__(798);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MarkdownTileConfigController = function () {
    function MarkdownTileConfigController(uuid4) {
        (0, _classCallCheck3.default)(this, MarkdownTileConfigController);
        this.SUPPORTED_ATTACHMENT_TYPES = 'image.*';
        this.MAX_ATTACHMENT_ALLOWED_SIZE = 1000000;

        this.uuid4 = uuid4;

        this.supportAttachments = !!window.FileReader;
        this.onSaveCallback = this.beforeSave.bind(this);
    } // one megabyte, size is presented in bytes

    (0, _createClass3.default)(MarkdownTileConfigController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.parent.registerSaveListener(this.onSaveCallback);
            this.content = this.tile.properties.content;

            if (this.supportAttachments) {
                var reader = new FileReader();
                this.dropdownZone = angular.element('#markdown-tile-dropdown');
                this.dropdownZone.on('dragenter', function (event) {
                    _this.dropCallback(event, function (element) {
                        element.addClass('hover-dropdown');
                    });
                }).on("dragover", function (event) {
                    _this.dropCallback(event, function (element) {
                        element.addClass('hover-dropdown');
                    });
                }).on("dragleave", function (event) {
                    _this.dropCallback(event, function (element) {
                        element.removeClass('hover-dropdown');
                    });
                }).on('drop', function (event) {
                    _this.dropCallback(event, function (element) {
                        element.removeClass('hover-dropdown');
                        reader.onload = _this.onFileReaderLoad(element);
                        var file = event.originalEvent.dataTransfer.files[0]; // upload one picture at the time
                        if (file.type.match(_this.SUPPORTED_ATTACHMENT_TYPES) && file.size < _this.MAX_ATTACHMENT_ALLOWED_SIZE) {
                            reader.readAsDataURL(file);
                        }
                    });
                });
            }
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this.parent.unregisterSaveListener(this.onSaveCallback);
        }
    }, {
        key: 'beforeSave',
        value: function beforeSave(tile) {
            var _this2 = this;

            if (!_.isNull(this.content) && this.supportAttachments) {
                // remove unused attachments
                var usedUuids = [];
                var matchResult = void 0;
                while (matchResult = _constants.markdownImageRegex.exec(this.content)) {
                    usedUuids.push(matchResult[2]);
                }
                _.forEach(_.difference(_.keys(this.tile.properties.attachments.value), usedUuids), function (uuid) {
                    delete _this2.tile.properties.attachments.value[uuid];
                });
            }
            this.tile.properties.content = this.content;
        }
    }, {
        key: 'dropCallback',
        value: function dropCallback(event, callbackFunc) {
            event.preventDefault();
            event.stopPropagation();
            var element = angular.element(event.target);
            if (element.is("textarea")) {
                callbackFunc(element);
            }
        }
    }, {
        key: 'onFileReaderLoad',
        value: function onFileReaderLoad(element) {
            var _this3 = this;

            return function (file) {
                var uuid4 = _this3.uuid4.generate();
                _this3.tile.properties.attachments.value[uuid4] = file.target.result;
                // add image at the cursor position
                var cursorPosition = element.prop("selectionStart");
                var value = element.val();
                var output = [value.slice(0, cursorPosition), '![](' + uuid4 + ')', value.slice(cursorPosition)].join('');
                element.val(output).trigger('change');
            };
        }
    }]);
    return MarkdownTileConfigController;
}();

MarkdownTileConfigController.$inject = ['uuid4'];
var markdownTileConfig = exports.markdownTileConfig = {
    bindings: {
        tile: '<',
        parent: '<',
        variables: '<'
    },
    controller: MarkdownTileConfigController,
    template: _markdownTileConfigTpl2.default
};

/***/ }),

/***/ 2432:
/***/ (function(module, exports) {

module.exports = "<div class=\"markdown-tile-config\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <label for=\"title\" class=\"control-label col-xs-3\">Title</label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"title\" name=\"title\"\n                       ng-model=\"$ctrl.tile.properties.title\"\n                       class=\"form-control\">\n                <span class=\"description\">Name of the tile</span>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"title\" class=\"control-label col-xs-3\">Content <span class=\"error\">*</span></label>\n            <div class=\"col-xs-9\">\n                <div inline-textarea-editor id=\"markdown-tile-dropdown\" model=\"$ctrl.content\" markdown>\n                    <span ng-bind-html=\"$ctrl.content | markdownAttachment:$ctrl.tile.properties.attachments.value | displayVariables:$ctrl.variables:true\"></span>\n                </div>\n                <span class=\"description\">Markdown text to render as the content of the tile.\n                    For a brief syntax overview, see <a target=\"_blank\" href=\"https://docs.xebialabs.com/xl-release/how-to/using-markdown-in-xl-release.html\">documentation</a>.\n                    To embed pictures, drag & drop the desired image file onto the editable text area. The image will be placed at the cursor position and it should not be larger than one megabyte.\n                </span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2433:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.markdownAttachmentFilter = undefined;

var _constants = __webpack_require__(798);

var markdownAttachmentFilter = exports.markdownAttachmentFilter = function markdownAttachmentFilter() {
    return function (text, attachments) {
        if (_.isNull(text) || _.isUndefined(attachments)) return text;
        return text.replace(_constants.markdownImageRegex, function (match, alt, uuid) {
            if (_.has(attachments, uuid)) {
                return "![" + alt + "](" + attachments[uuid] + ")";
            }
            return match;
        });
    };
};

/***/ }),

/***/ 2434:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2435);

var _placeholderTileConfigComponent = __webpack_require__(2437);

var _placeholderTileViewComponent = __webpack_require__(2439);

angular.module('xlrelease.dashboard').component('placeholderTileConfig', _placeholderTileConfigComponent.placeholderTileConfig).component('placeholderTileView', _placeholderTileViewComponent.placeholderTileView);

/***/ }),

/***/ 2435:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2437:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.placeholderTileConfig = undefined;

var _placeholderTileConfigTpl = __webpack_require__(2438);

var _placeholderTileConfigTpl2 = _interopRequireDefault(_placeholderTileConfigTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var placeholderTileConfig = exports.placeholderTileConfig = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    template: _placeholderTileConfigTpl2.default
};

/***/ }),

/***/ 2438:
/***/ (function(module, exports) {

module.exports = "<div class=\"placeholder-tile-config\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <label for=\"content\" class=\"control-label col-xs-3\">Content</label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"content\" name=\"content\"\n                       ng-model=\"$ctrl.tile.properties.content\"\n                       class=\"form-control\">\n                <span class=\"description\">Content of the tile</span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2439:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.placeholderTileView = undefined;

var _placeholderTileViewTpl = __webpack_require__(2440);

var _placeholderTileViewTpl2 = _interopRequireDefault(_placeholderTileViewTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var placeholderTileView = exports.placeholderTileView = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    template: _placeholderTileViewTpl2.default
};

/***/ }),

/***/ 2440:
/***/ (function(module, exports) {

module.exports = "<div class=\"placeholder-tile-view\" ng-class=\"::{'placeholder-tile-view-no-title': !$ctrl.tile.properties.title}\">\n    <div class=\"placeholder-tile-view-content\">\n        <h3 class=\"placeholder-tile-view-text\">{{::$ctrl.tile.properties.content}}</h3>\n    </div>\n</div>"

/***/ }),

/***/ 2441:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _react2angular = __webpack_require__(202);

var _environmentListPage = __webpack_require__(2442);

var _environmentListPage2 = _interopRequireDefault(_environmentListPage);

var _environmentEditPage = __webpack_require__(2819);

var _environmentEditPage2 = _interopRequireDefault(_environmentEditPage);

var _applicationListPage = __webpack_require__(2907);

var _applicationListPage2 = _interopRequireDefault(_applicationListPage);

var _applicationEditPage = __webpack_require__(2916);

var _applicationEditPage2 = _interopRequireDefault(_applicationEditPage);

var _stagePage = __webpack_require__(2941);

var _stagePage2 = _interopRequireDefault(_stagePage);

var _labelPage = __webpack_require__(2949);

var _labelPage2 = _interopRequireDefault(_labelPage);

var _schedulingReleasePage = __webpack_require__(2951);

var _schedulingReleasePage2 = _interopRequireDefault(_schedulingReleasePage);

var _schedulingEnvironmentPage = __webpack_require__(2952);

var _schedulingEnvironmentPage2 = _interopRequireDefault(_schedulingEnvironmentPage);

var _permissionsConstants = __webpack_require__(401);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease.environmentManagement', ['xlrelease']).component('environmentPage', (0, _react2angular.react2angular)(_environmentListPage2.default)).component('environmentEditPage', (0, _react2angular.react2angular)(_environmentEditPage2.default, ['environmentId'])).component('stagePage', (0, _react2angular.react2angular)(_stagePage2.default)).component('labelPage', (0, _react2angular.react2angular)(_labelPage2.default)).component('applicationListPage', (0, _react2angular.react2angular)(_applicationListPage2.default)).component('applicationEditPage', (0, _react2angular.react2angular)(_applicationEditPage2.default)).component('schedulingReleasePage', (0, _react2angular.react2angular)(_schedulingReleasePage2.default)).component('schedulingEnvironmentPage', (0, _react2angular.react2angular)(_schedulingEnvironmentPage2.default)).config(['$urlMatcherFactoryProvider', '$stateProvider', function ($urlMatcherFactoryProvider, $stateProvider) {
    var envMgmtPattern = "Configuration\/environmentManagement";

    $urlMatcherFactoryProvider.type('EnvironmentId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/Environment\\w+")
    });
    $urlMatcherFactoryProvider.type('ApplicationId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/Application\\w+")
    });
    $urlMatcherFactoryProvider.type('EnvironmentStageId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/EnvironmentStage\\w+")
    });
    $urlMatcherFactoryProvider.type('EnvironmentLabelId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/EnvironmentLabel\\w+")
    });
    $urlMatcherFactoryProvider.type('EnvironmentReservationId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/EnvironmentReservation\\w+")
    });

    $stateProvider.state('environmentCreate', {
        url: '/environments/edit?{environmentId: EnvironmentId}',
        template: '<environment-edit-page environment-id="$resolve.environmentId"></environment-edit-page>',
        resolve: {
            environmentId: ['$stateParams', function ($stateParams) {
                if ($stateParams.environmentId) {
                    return $stateParams.environmentId;
                } else {
                    return null;
                }
            }]
        }
    }).state('environmentList', {
        url: '/environments',
        permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_ENVIRONMENT],
        template: '<environment-page></environment-page>'
    }).state('stageList', {
        url: '/environments/stages',
        permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_ENVIRONMENT],
        template: '<stage-page></stage-page>'
    }).state('labelList', {
        url: '/environments/labels',
        permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_ENVIRONMENT],
        template: '<label-page></label-page>'
    }).state('environmentSchedule', {
        url: '/schedule-environments',
        permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_RESERVATION],
        template: '<scheduling-environment-page></scheduling-environment-page>'
    }).state('applicationList', {
        url: '/applications',
        permissions: [_permissionsConstants.GlobalPermissions.EDIT_GLOBAL_APPLICATION],
        template: '<application-list-page></application-list-page>'
    }).state('applicationCreate', {
        url: '/applications/edit?{applicationId: ApplicationId}',
        template: '<application-edit-page application-id="$resolve.applicationId"></application-edit-page>',
        resolve: {
            applicationId: ['$stateParams', function ($stateParams) {
                if ($stateParams.applicationId) {
                    return $stateParams.applicationId;
                } else {
                    return null;
                }
            }]
        }
    });
}]);

/***/ }),

/***/ 2442:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _environmentManagementStore = __webpack_require__(269);

var _environmentListPageContainer = __webpack_require__(2463);

var _environmentListPageContainer2 = _interopRequireDefault(_environmentListPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentListPage = function (_Component) {
    (0, _inherits3.default)(EnvironmentListPage, _Component);

    function EnvironmentListPage() {
        (0, _classCallCheck3.default)(this, EnvironmentListPage);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentListPage.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentListPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_environmentListPageContainer2.default, null)
            );
        }
    }]);
    return EnvironmentListPage;
}(_react.Component);

exports.default = EnvironmentListPage;

/***/ }),

/***/ 2445:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.default = combinedSaga;

var _effects = __webpack_require__(54);

var _environmentListSaga = __webpack_require__(2446);

var _environmentFormSaga = __webpack_require__(2447);

var _stageSaga = __webpack_require__(2448);

var _labelSaga = __webpack_require__(2449);

var _applicationListSaga = __webpack_require__(2450);

var _applicationFormSaga = __webpack_require__(2451);

var _schedulingEnvironmentReservationFormSaga = __webpack_require__(2452);

var _schedulingSaga = __webpack_require__(2453);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(combinedSaga);

function combinedSaga() {
    return _regenerator2.default.wrap(function combinedSaga$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    if (false) {}

                    _context.prev = 1;
                    _context.next = 4;
                    return (0, _effects.all)([(0, _effects.call)(_environmentListSaga.environmentListSaga), (0, _effects.call)(_environmentFormSaga.environmentFormSaga), (0, _effects.call)(_stageSaga.stageSaga), (0, _effects.call)(_labelSaga.labelSaga), (0, _effects.call)(_applicationListSaga.applicationListSaga), (0, _effects.call)(_applicationFormSaga.applicationFormSaga), (0, _effects.call)(_schedulingEnvironmentReservationFormSaga.scheduleEnvironmentReservationFormSaga), (0, _effects.call)(_schedulingSaga.schedulingSaga)]);

                case 4:
                    _context.next = 9;
                    break;

                case 6:
                    _context.prev = 6;
                    _context.t0 = _context['catch'](1);

                    /* eslint-disable no-console, angular/log */
                    console.error('Environment management root saga:', _context.t0);
                    /* eslint-enable */

                case 9:
                    _context.next = 0;
                    break;

                case 11:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[1, 6]]);
}

/***/ }),

/***/ 2446:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getFilters = exports.toastr = undefined;

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.search = search;
exports.addEnvironment = addEnvironment;
exports.editEnvironment = editEnvironment;
exports._deleteEnvironment = _deleteEnvironment;
exports.initEnvironmentList = initEnvironmentList;
exports.environmentListSaga = environmentListSaga;

var _effects = __webpack_require__(54);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _environmentActions = __webpack_require__(447);

var _angularAccessor = __webpack_require__(111);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _environmentService = __webpack_require__(366);

var _stageService = __webpack_require__(367);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(search),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(addEnvironment),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(editEnvironment),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(_deleteEnvironment),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(initEnvironmentList),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(environmentListSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var getFilters = exports.getFilters = function getFilters(state) {
    return state.environmentList.filters;
};

function search(action) {
    var _action$payload, title, stageTitle, stage, environments;

    return _regenerator2.default.wrap(function search$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _action$payload = action.payload, title = _action$payload.title, stageTitle = _action$payload.stageTitle;
                    stage = stageTitle || null;
                    _context.prev = 2;
                    _context.next = 5;
                    return (0, _effects.call)(_environmentService.searchEnvironments, { title: title, stage: stage });

                case 5:
                    environments = _context.sent;
                    _context.next = 8;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_SUCCESS,
                        payload: environments
                    });

                case 8:
                    _context.next = 14;
                    break;

                case 10:
                    _context.prev = 10;
                    _context.t0 = _context['catch'](2);
                    _context.next = 14;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_FAILURE
                    });

                case 14:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[2, 10]]);
}

function addEnvironment() {
    var $state;
    return _regenerator2.default.wrap(function addEnvironment$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 2:
                    $state = _context2.sent;
                    _context2.next = 5;
                    return (0, _effects.call)($state.go, 'environmentCreate');

                case 5:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function editEnvironment(action) {
    var $state;
    return _regenerator2.default.wrap(function editEnvironment$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 2:
                    $state = _context3.sent;
                    _context3.next = 5;
                    return (0, _effects.call)($state.go, 'environmentCreate', { environmentId: action.payload.id });

                case 5:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function _deleteEnvironment(action) {
    var environment, currentFilter;
    return _regenerator2.default.wrap(function _deleteEnvironment$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    environment = action.payload;
                    _context4.prev = 1;
                    _context4.next = 4;
                    return (0, _effects.call)(_environmentService.deleteEnvironment, environment.id);

                case 4:
                    _context4.next = 6;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENT_DELETE_SUCCESS
                    });

                case 6:
                    _context4.next = 8;
                    return (0, _effects.call)(toastr.success, 'Environment [' + environment.title + '] deleted.');

                case 8:
                    _context4.next = 10;
                    return (0, _effects.select)(getFilters);

                case 10:
                    currentFilter = _context4.sent;
                    _context4.next = 13;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
                        payload: currentFilter
                    });

                case 13:
                    _context4.next = 19;
                    break;

                case 15:
                    _context4.prev = 15;
                    _context4.t0 = _context4['catch'](1);
                    _context4.next = 19;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENT_DELETE_FAILURE
                    });

                case 19:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[1, 15]]);
}

function initEnvironmentList() {
    var environments, stages;
    return _regenerator2.default.wrap(function initEnvironmentList$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.prev = 0;
                    _context5.next = 3;
                    return (0, _effects.call)(_environmentService.searchEnvironments, { title: '', stageTitle: '' });

                case 3:
                    environments = _context5.sent;
                    _context5.next = 6;
                    return (0, _effects.call)(_stageService.searchStages);

                case 6:
                    stages = _context5.sent;
                    _context5.next = 9;
                    return (0, _effects.put)((0, _environmentActions.initEnvironmentListSuccess)(environments, stages));

                case 9:
                    _context5.next = 15;
                    break;

                case 11:
                    _context5.prev = 11;
                    _context5.t0 = _context5['catch'](0);
                    _context5.next = 15;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_FAILURE
                    });

                case 15:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this, [[0, 11]]);
}

function environmentListSaga() {
    return _regenerator2.default.wrap(function environmentListSaga$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENT_ADD, addEnvironment), (0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENT_EDIT, editEnvironment), (0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENT_DELETE_REQUEST, _deleteEnvironment), (0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENTS_SEARCH_REQUEST, search), (0, _effects.takeLatest)(_environmentActions.actionTypes.INIT_ENVIRONMENT_LIST, initEnvironmentList)]);

                case 2:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

/***/ }),

/***/ 2447:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _slicedToArray2 = __webpack_require__(109);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.save = save;
exports.cancel = cancel;
exports.initEnvironmentForm = initEnvironmentForm;
exports.cleanEnvironment = cleanEnvironment;
exports.environmentFormSaga = environmentFormSaga;

var _effects = __webpack_require__(54);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _environmentFormActions = __webpack_require__(448);

var _stageActions = __webpack_require__(449);

var _labelActions = __webpack_require__(368);

var _angularAccessor = __webpack_require__(111);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _environmentService = __webpack_require__(366);

var _lodash = __webpack_require__(62);

var _sagas = __webpack_require__(584);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(save),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(cancel),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(initEnvironmentForm),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(cleanEnvironment),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(environmentFormSaga);

var cleanFormFields = { type: _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM };

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function save(action) {
    var $state, environment, environmentForm;
    return _regenerator2.default.wrap(function save$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 3:
                    _context.next = 5;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 5:
                    $state = _context.sent;
                    environment = action.payload;
                    environmentForm = {
                        title: environment.title,
                        stageId: environment.stage.id,
                        description: environment.description,
                        labelIds: (0, _lodash.map)(environment.labels, function (lab) {
                            return lab.id;
                        })
                    };

                    if (!(0, _lodash.isEmpty)(environment.id)) {
                        _context.next = 15;
                        break;
                    }

                    _context.next = 11;
                    return (0, _effects.call)(_environmentService.createEnvironment, environmentForm);

                case 11:
                    _context.next = 13;
                    return (0, _effects.call)(toastr.success, 'Environment [' + environment.title + '] created');

                case 13:
                    _context.next = 19;
                    break;

                case 15:
                    _context.next = 17;
                    return (0, _effects.call)(_environmentService.updateEnvironment, environment.id, environmentForm);

                case 17:
                    _context.next = 19;
                    return (0, _effects.call)(toastr.success, 'Environment [' + environment.title + '] updated');

                case 19:
                    _context.next = 21;
                    return (0, _effects.call)($state.go, 'environmentList');

                case 21:
                    _context.next = 27;
                    break;

                case 23:
                    _context.prev = 23;
                    _context.t0 = _context['catch'](0);
                    _context.next = 27;
                    return (0, _effects.call)(console.error, 'Environment form saga:', _context.t0);

                case 27:
                    _context.prev = 27;
                    _context.next = 30;
                    return (0, _effects.put)(cleanFormFields);

                case 30:
                    return _context.finish(27);

                case 31:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 23, 27, 31]]);
}

function cancel() {
    var $state;
    return _regenerator2.default.wrap(function cancel$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 2:
                    _context2.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context2.sent;
                    _context2.next = 7;
                    return (0, _effects.call)($state.go, 'environmentList');

                case 7:
                    _context2.next = 9;
                    return (0, _effects.put)(cleanFormFields);

                case 9:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function initEnvironmentForm(_ref) {
    var environmentId = _ref.payload;

    var _ref2, _ref3, environments, environment, _environments;

    return _regenerator2.default.wrap(function initEnvironmentForm$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.prev = 0;

                    if (!environmentId) {
                        _context3.next = 12;
                        break;
                    }

                    _context3.next = 4;
                    return (0, _effects.all)([(0, _effects.call)(_environmentService.searchEnvironments, {}), (0, _effects.call)(_environmentService.loadEnvironment, environmentId)]);

                case 4:
                    _ref2 = _context3.sent;
                    _ref3 = (0, _slicedToArray3.default)(_ref2, 2);
                    environments = _ref3[0];
                    environment = _ref3[1];
                    _context3.next = 10;
                    return (0, _effects.put)({
                        type: _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
                        payload: {
                            environment: environment,
                            environments: environments
                        }
                    });

                case 10:
                    _context3.next = 17;
                    break;

                case 12:
                    _context3.next = 14;
                    return (0, _effects.call)(_environmentService.searchEnvironments, {});

                case 14:
                    _environments = _context3.sent;
                    _context3.next = 17;
                    return (0, _effects.put)({
                        type: _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
                        payload: {
                            environments: _environments
                        }
                    });

                case 17:
                    _context3.next = 19;
                    return (0, _effects.put)((0, _stageActions.searchStages)(null));

                case 19:
                    _context3.next = 21;
                    return (0, _effects.put)((0, _labelActions.searchLabels)(null));

                case 21:
                    _context3.next = 27;
                    break;

                case 23:
                    _context3.prev = 23;
                    _context3.t0 = _context3['catch'](0);
                    _context3.next = 27;
                    return (0, _effects.put)({
                        type: _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_FAILURE
                    });

                case 27:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[0, 23]]);
}

function cleanEnvironment() {
    return _regenerator2.default.wrap(function cleanEnvironment$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 2:
                    _context4.next = 4;
                    return (0, _effects.put)(cleanFormFields);

                case 4:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

function environmentFormSaga() {
    return _regenerator2.default.wrap(function environmentFormSaga$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM, cancel), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_SAVE_FORM, save), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM, initEnvironmentForm), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM, _sagas.addConfirmLeavePopup), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE, cleanEnvironment)]);

                case 2:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

/***/ }),

/***/ 2448:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports._searchStages = _searchStages;
exports._saveStage = _saveStage;
exports._deleteStage = _deleteStage;
exports.stageSaga = stageSaga;

var _effects = __webpack_require__(54);

var _isEmpty = __webpack_require__(310);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _stageActions = __webpack_require__(449);

var _stageService = __webpack_require__(367);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(_searchStages),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(_saveStage),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(_deleteStage),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(stageSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function _searchStages(action) {
    var stages;
    return _regenerator2.default.wrap(function _searchStages$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_stageService.searchStages, action.payload);

                case 3:
                    stages = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.STAGE_SEARCH_SUCCESS,
                        payload: stages
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.STAGE_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function _saveStage(action) {
    var stage;
    return _regenerator2.default.wrap(function _saveStage$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    stage = action.payload;
                    _context2.prev = 1;

                    if (!(0, _isEmpty2.default)(stage.id)) {
                        _context2.next = 9;
                        break;
                    }

                    _context2.next = 5;
                    return (0, _effects.call)(_stageService.createStage, stage);

                case 5:
                    _context2.next = 7;
                    return (0, _effects.call)(toastr.success, 'Stage [' + stage.title + '] created');

                case 7:
                    _context2.next = 13;
                    break;

                case 9:
                    _context2.next = 11;
                    return (0, _effects.call)(_stageService.updateStage, stage.id, stage);

                case 11:
                    _context2.next = 13;
                    return (0, _effects.call)(toastr.success, 'Stage [' + stage.title + '] updated');

                case 13:
                    _context2.next = 15;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.SAVE_STAGE_SUCCESS
                    });

                case 15:
                    _context2.next = 21;
                    break;

                case 17:
                    _context2.prev = 17;
                    _context2.t0 = _context2['catch'](1);
                    _context2.next = 21;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.SAVE_STAGE_FAILURE
                    });

                case 21:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[1, 17]]);
}

function _deleteStage(action) {
    var stage;
    return _regenerator2.default.wrap(function _deleteStage$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    stage = action.payload;
                    _context3.prev = 1;
                    _context3.next = 4;
                    return (0, _effects.call)(_stageService.deleteStage, stage.id);

                case 4:
                    _context3.next = 6;
                    return (0, _effects.call)(toastr.success, 'Stage [' + stage.title + '] deleted');

                case 6:
                    _context3.next = 8;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.DELETE_STAGE_SUCCESS
                    });

                case 8:
                    _context3.next = 14;
                    break;

                case 10:
                    _context3.prev = 10;
                    _context3.t0 = _context3['catch'](1);
                    _context3.next = 14;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.DELETE_STAGE_FAILURE
                    });

                case 14:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[1, 10]]);
}

function stageSaga() {
    return _regenerator2.default.wrap(function stageSaga$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_stageActions.actionTypes.SAVE_STAGE, _saveStage), (0, _effects.takeLatest)(_stageActions.actionTypes.DELETE_STAGE, _deleteStage), (0, _effects.takeLatest)([_stageActions.actionTypes.STAGE_SEARCH, _stageActions.actionTypes.DELETE_STAGE_SUCCESS, _stageActions.actionTypes.SAVE_STAGE_SUCCESS], _searchStages)]);

                case 2:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 2449:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports._searchLabels = _searchLabels;
exports._saveLabel = _saveLabel;
exports._deleteLabel = _deleteLabel;
exports.labelSaga = labelSaga;

var _effects = __webpack_require__(54);

var _isEmpty = __webpack_require__(310);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _labelActions = __webpack_require__(368);

var _labelService = __webpack_require__(585);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(_searchLabels),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(_saveLabel),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(_deleteLabel),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(labelSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function _searchLabels(action) {
    var labels;
    return _regenerator2.default.wrap(function _searchLabels$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_labelService.searchLabels, action.payload);

                case 3:
                    labels = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.LABEL_SEARCH_SUCCESS,
                        payload: labels
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.LABEL_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function _saveLabel(action) {
    var envLabel;
    return _regenerator2.default.wrap(function _saveLabel$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    envLabel = action.payload;
                    _context2.prev = 1;

                    if (!(0, _isEmpty2.default)(envLabel.id)) {
                        _context2.next = 9;
                        break;
                    }

                    _context2.next = 5;
                    return (0, _effects.call)(_labelService.createLabel, envLabel);

                case 5:
                    _context2.next = 7;
                    return (0, _effects.call)(toastr.success, 'Label [' + envLabel.title + '] created');

                case 7:
                    _context2.next = 13;
                    break;

                case 9:
                    _context2.next = 11;
                    return (0, _effects.call)(_labelService.updateLabel, envLabel.id, envLabel);

                case 11:
                    _context2.next = 13;
                    return (0, _effects.call)(toastr.success, 'Label [' + envLabel.title + '] updated');

                case 13:
                    _context2.next = 15;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.SAVE_LABEL_SUCCESS
                    });

                case 15:
                    _context2.next = 21;
                    break;

                case 17:
                    _context2.prev = 17;
                    _context2.t0 = _context2['catch'](1);
                    _context2.next = 21;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.SAVE_LABEL_FAILURE
                    });

                case 21:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[1, 17]]);
}

function _deleteLabel(action) {
    var envLabel;
    return _regenerator2.default.wrap(function _deleteLabel$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    envLabel = action.payload;
                    _context3.prev = 1;
                    _context3.next = 4;
                    return (0, _effects.call)(_labelService.deleteLabel, envLabel.id);

                case 4:
                    _context3.next = 6;
                    return (0, _effects.call)(toastr.success, 'Label [' + envLabel.title + '] deleted');

                case 6:
                    _context3.next = 8;
                    return (0, _effects.put)({ type: _labelActions.actionTypes.DELETE_LABEL_SUCCESS });

                case 8:
                    _context3.next = 14;
                    break;

                case 10:
                    _context3.prev = 10;
                    _context3.t0 = _context3['catch'](1);
                    _context3.next = 14;
                    return (0, _effects.put)({ type: _labelActions.actionTypes.DELETE_LABEL_FAILURE });

                case 14:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[1, 10]]);
}

function labelSaga() {
    return _regenerator2.default.wrap(function labelSaga$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_labelActions.actionTypes.SAVE_LABEL, _saveLabel), (0, _effects.takeLatest)(_labelActions.actionTypes.DELETE_LABEL, _deleteLabel), (0, _effects.throttle)(200, [_labelActions.actionTypes.LABEL_SEARCH, _labelActions.actionTypes.SAVE_LABEL_SUCCESS, _labelActions.actionTypes.DELETE_LABEL_SUCCESS], _searchLabels)]);

                case 2:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 2450:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.searchApplications = searchApplications;
exports.goToApplicationCreate = goToApplicationCreate;
exports.goToApplicationEdit = goToApplicationEdit;
exports.deleteApplication = deleteApplication;
exports.applicationListSaga = applicationListSaga;

var _effects = __webpack_require__(54);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _applicationActions = __webpack_require__(311);

var _angularAccessor = __webpack_require__(111);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _applicationService = __webpack_require__(450);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(searchApplications),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(goToApplicationCreate),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(goToApplicationEdit),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(deleteApplication),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(applicationListSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function searchApplications(action) {
    var applications;
    return _regenerator2.default.wrap(function searchApplications$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_applicationService.searchApp, action.payload);

                case 3:
                    applications = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_SEARCH_SUCCESS,
                        payload: applications
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function goToApplicationCreate() {
    var $state;
    return _regenerator2.default.wrap(function goToApplicationCreate$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.put)({ type: _applicationActions.actionTypes.APPLICATION_FORM_CLEAN });

                case 2:
                    _context2.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context2.sent;
                    _context2.next = 7;
                    return (0, _effects.call)($state.go, 'applicationCreate');

                case 7:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function goToApplicationEdit(action) {
    var $state;
    return _regenerator2.default.wrap(function goToApplicationEdit$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.put)({ type: _applicationActions.actionTypes.APPLICATION_FORM_CLEAN });

                case 2:
                    _context3.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context3.sent;
                    _context3.next = 7;
                    return (0, _effects.call)($state.go, 'applicationCreate', { applicationId: action.payload.id });

                case 7:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function deleteApplication(action) {
    var application;
    return _regenerator2.default.wrap(function deleteApplication$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    application = action.payload;
                    _context4.next = 4;
                    return (0, _effects.call)(_applicationService.deleteApp, application.id);

                case 4:
                    _context4.next = 6;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_DELETE_SUCCESS,
                        payload: action.payload
                    });

                case 6:
                    _context4.next = 8;
                    return (0, _effects.call)(toastr.success, 'Deleted application [' + application.title + ']');

                case 8:
                    _context4.next = 14;
                    break;

                case 10:
                    _context4.prev = 10;
                    _context4.t0 = _context4['catch'](0);
                    _context4.next = 14;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_DELETE_FAILURE
                    });

                case 14:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 10]]);
}

function applicationListSaga() {
    return _regenerator2.default.wrap(function applicationListSaga$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_GOTO_CREATE_PAGE, goToApplicationCreate);

                case 2:
                    _context5.next = 4;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_GOTO_EDIT_PAGE, goToApplicationEdit);

                case 4:
                    _context5.next = 6;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_DELETE_REQUEST, deleteApplication);

                case 6:
                    _context5.next = 8;
                    return (0, _effects.throttle)(200, _applicationActions.actionTypes.APPLICATION_SEARCH_REQUEST, searchApplications);

                case 8:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

/***/ }),

/***/ 2451:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.initApplicationForm = initApplicationForm;
exports.cancelApplicationForm = cancelApplicationForm;
exports.updateApplicationModel = updateApplicationModel;
exports.saveApplication = saveApplication;
exports.applicationFormSaga = applicationFormSaga;

var _effects = __webpack_require__(54);

var _isEmpty = __webpack_require__(310);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _applicationActions = __webpack_require__(311);

var _applicationService = __webpack_require__(450);

var _angularAccessor = __webpack_require__(111);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _environmentService = __webpack_require__(366);

var _stageService = __webpack_require__(367);

var _sagas = __webpack_require__(584);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(initApplicationForm),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(cancelApplicationForm),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(updateApplicationModel),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(saveApplication),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(applicationFormSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var cleanFormFields = { type: _applicationActions.actionTypes.APPLICATION_FORM_CLEAN };

function initApplicationForm(action) {
    var applicationId, application, environments, stages, applications;
    return _regenerator2.default.wrap(function initApplicationForm$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    applicationId = action.payload;

                    if ((0, _isEmpty2.default)(applicationId)) {
                        _context.next = 8;
                        break;
                    }

                    _context.next = 5;
                    return (0, _effects.call)(_applicationService.getApp, applicationId);

                case 5:
                    application = _context.sent;
                    _context.next = 8;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS,
                        payload: application
                    });

                case 8:
                    _context.next = 10;
                    return (0, _effects.call)(_environmentService.searchEnvironments, '');

                case 10:
                    environments = _context.sent;
                    _context.next = 13;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_ENV_LOAD_SUCCESS,
                        payload: environments
                    });

                case 13:
                    _context.next = 15;
                    return (0, _effects.call)(_stageService.searchStages, '');

                case 15:
                    stages = _context.sent;
                    _context.next = 18;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_STAGE_LOAD_SUCCESS,
                        payload: stages
                    });

                case 18:
                    _context.next = 20;
                    return (0, _effects.call)(_applicationService.searchApp, '');

                case 20:
                    applications = _context.sent;
                    _context.next = 23;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_LIST_LOAD_SUCCESS,
                        payload: applications
                    });

                case 23:
                    _context.next = 29;
                    break;

                case 25:
                    _context.prev = 25;
                    _context.t0 = _context['catch'](0);
                    _context.next = 29;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_FORM_FAILURE
                    });

                case 29:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 25]]);
}

function cancelApplicationForm() {
    var $state;
    return _regenerator2.default.wrap(function cancelApplicationForm$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 2:
                    _context2.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context2.sent;
                    _context2.next = 7;
                    return (0, _effects.call)($state.go, 'applicationList');

                case 7:
                    _context2.next = 9;
                    return (0, _effects.put)(cleanFormFields);

                case 9:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function updateApplicationModel(action) {
    return _regenerator2.default.wrap(function updateApplicationModel$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS,
                        payload: action.payload
                    });

                case 2:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function saveApplication(action) {
    var application, $state;
    return _regenerator2.default.wrap(function saveApplication$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    application = action.payload;

                    application.environmentIds = application.environments.map(function (env) {
                        return env.id;
                    });
                    _context4.next = 5;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 5:
                    $state = _context4.sent;
                    _context4.next = 8;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 8:
                    if (!(0, _isEmpty2.default)(application.id)) {
                        _context4.next = 17;
                        break;
                    }

                    _context4.next = 11;
                    return (0, _effects.call)(_applicationService.createApp, application);

                case 11:
                    _context4.next = 13;
                    return (0, _effects.call)(toastr.success, 'Created application [' + action.payload.title + ']');

                case 13:
                    _context4.next = 15;
                    return (0, _effects.call)($state.go, 'applicationList');

                case 15:
                    _context4.next = 23;
                    break;

                case 17:
                    _context4.next = 19;
                    return (0, _effects.call)(_applicationService.updateApp, application);

                case 19:
                    _context4.next = 21;
                    return (0, _effects.call)(toastr.success, 'Updated application [' + action.payload.title + ']');

                case 21:
                    _context4.next = 23;
                    return (0, _effects.call)($state.go, 'applicationList');

                case 23:
                    _context4.next = 29;
                    break;

                case 25:
                    _context4.prev = 25;
                    _context4.t0 = _context4['catch'](0);
                    _context4.next = 29;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_SAVE_FAILURE,
                        error: _context4.t0 // for testing purposes
                    });

                case 29:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 25]]);
}

function applicationFormSaga() {
    return _regenerator2.default.wrap(function applicationFormSaga$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_SAVE_REQUEST, saveApplication);

                case 2:
                    _context5.next = 4;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_INIT, initApplicationForm);

                case 4:
                    _context5.next = 6;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_UPDATE_MODEL, updateApplicationModel);

                case 6:
                    _context5.next = 8;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_CANCEL, cancelApplicationForm);

                case 8:
                    _context5.next = 10;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_PRISTINE, _sagas.addConfirmLeavePopup);

                case 10:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

/***/ }),

/***/ 2452:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getStateSchedulerFilter = exports.toastr = undefined;

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.reservationEnvironmentChange = reservationEnvironmentChange;
exports.reserveEnvironment = reserveEnvironment;
exports.cancel = cancel;
exports.deleteEnvironmentReservation = deleteEnvironmentReservation;
exports.initEnvironmentForm = initEnvironmentForm;
exports.scheduleEnvironmentReservationFormSaga = scheduleEnvironmentReservationFormSaga;

var _effects = __webpack_require__(54);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(451);

var _lodash = __webpack_require__(62);

var _schedulingService = __webpack_require__(799);

var _schedulingActions = __webpack_require__(270);

var _environmentService = __webpack_require__(366);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(reservationEnvironmentChange),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(reserveEnvironment),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(cancel),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(deleteEnvironmentReservation),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(initEnvironmentForm),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(scheduleEnvironmentReservationFormSaga);

var cleanFormFields = { type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM };

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var getStateSchedulerFilter = exports.getStateSchedulerFilter = function getStateSchedulerFilter(state) {
    return state.scheduling.schedulerFilter;
};

function reservationEnvironmentChange(action) {
    var applications;
    return _regenerator2.default.wrap(function reservationEnvironmentChange$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;

                    if (!(0, _lodash.isEmpty)(action.payload)) {
                        _context.next = 5;
                        break;
                    }

                    _context.t0 = [];
                    _context.next = 8;
                    break;

                case 5:
                    _context.next = 7;
                    return (0, _effects.call)(_environmentService.getDeployableApplicationsForEnvironment, action.payload.id);

                case 7:
                    _context.t0 = _context.sent;

                case 8:
                    applications = _context.t0;
                    _context.next = 11;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
                        payload: applications
                    });

                case 11:
                    _context.next = 17;
                    break;

                case 13:
                    _context.prev = 13;
                    _context.t1 = _context['catch'](0);
                    _context.next = 17;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
                        payload: []
                    });

                case 17:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 13]]);
}

function reserveEnvironment(action) {
    var reservationModel, reservationForm, schedulerFilter;
    return _regenerator2.default.wrap(function reserveEnvironment$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    reservationModel = action.payload;
                    reservationForm = {
                        environmentId: reservationModel.environment.id,
                        applicationIds: reservationModel.applications.map(function (app) {
                            return app.id;
                        }),
                        startDate: (0, _moment2.default)(reservationModel.startDate).valueOf(),
                        endDate: (0, _moment2.default)(reservationModel.endDate).valueOf(),
                        note: (0, _lodash.isEmpty)(reservationModel.note) ? null : reservationModel.note
                    };
                    _context2.prev = 2;

                    if (!(0, _lodash.isEmpty)(reservationModel.id)) {
                        _context2.next = 10;
                        break;
                    }

                    _context2.next = 6;
                    return (0, _effects.call)(_schedulingService.createReservation, reservationForm);

                case 6:
                    _context2.next = 8;
                    return (0, _effects.call)(toastr.success, 'Environment reserved.');

                case 8:
                    _context2.next = 14;
                    break;

                case 10:
                    _context2.next = 12;
                    return (0, _effects.call)(_schedulingService.updateReservation, reservationModel.id, reservationForm);

                case 12:
                    _context2.next = 14;
                    return (0, _effects.call)(toastr.success, 'Environment reservation updated.');

                case 14:
                    _context2.next = 16;
                    return (0, _effects.put)((0, _schedulingActions.showReservationSidebar)(false));

                case 16:
                    _context2.next = 18;
                    return (0, _effects.put)(cleanFormFields);

                case 18:
                    _context2.next = 20;
                    return (0, _effects.select)(getStateSchedulerFilter);

                case 20:
                    schedulerFilter = _context2.sent;
                    _context2.next = 23;
                    return (0, _effects.put)((0, _schedulingActions.onSearchReservations)(schedulerFilter));

                case 23:
                    _context2.next = 29;
                    break;

                case 25:
                    _context2.prev = 25;
                    _context2.t0 = _context2['catch'](2);
                    _context2.next = 29;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE
                    });

                case 29:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[2, 25]]);
}

function cancel() {
    return _regenerator2.default.wrap(function cancel$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.put)((0, _schedulingActions.showReservationSidebar)(false));

                case 2:
                    _context3.next = 4;
                    return (0, _effects.put)(cleanFormFields);

                case 4:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function deleteEnvironmentReservation(action) {
    var schedulerFilter;
    return _regenerator2.default.wrap(function deleteEnvironmentReservation$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    _context4.next = 3;
                    return (0, _effects.call)(_schedulingService.deleteReservation, action.payload);

                case 3:
                    _context4.next = 5;
                    return (0, _effects.call)(toastr.success, 'Reservation deleted.', action.payload);

                case 5:
                    _context4.next = 7;
                    return (0, _effects.put)((0, _schedulingActions.showReservationSidebar)(false));

                case 7:
                    _context4.next = 9;
                    return (0, _effects.put)(cleanFormFields);

                case 9:
                    _context4.next = 11;
                    return (0, _effects.select)(getStateSchedulerFilter);

                case 11:
                    schedulerFilter = _context4.sent;
                    _context4.next = 14;
                    return (0, _effects.put)((0, _schedulingActions.onSearchReservations)(schedulerFilter));

                case 14:
                    _context4.next = 20;
                    break;

                case 16:
                    _context4.prev = 16;
                    _context4.t0 = _context4['catch'](0);
                    _context4.next = 20;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED
                    });

                case 20:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 16]]);
}

function initEnvironmentForm(action) {
    var reservationId, reservation, reservationModel;
    return _regenerator2.default.wrap(function initEnvironmentForm$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.prev = 0;
                    _context5.next = 3;
                    return (0, _effects.put)(cleanFormFields);

                case 3:
                    reservationId = action.payload;

                    if ((0, _lodash.isEmpty)(reservationId)) {
                        _context5.next = 11;
                        break;
                    }

                    _context5.next = 7;
                    return (0, _effects.call)(_schedulingService.fetchReservation, reservationId);

                case 7:
                    reservation = _context5.sent;
                    reservationModel = {
                        id: reservation.id,
                        environment: {
                            id: reservation.environment.id,
                            title: reservation.environment.title
                        },
                        applications: reservation.applications,
                        startDate: new Date(reservation.startDate),
                        endDate: new Date(reservation.endDate),
                        note: reservation.note
                    };
                    _context5.next = 11;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
                        payload: reservationModel
                    });

                case 11:
                    _context5.next = 17;
                    break;

                case 13:
                    _context5.prev = 13;
                    _context5.t0 = _context5['catch'](0);
                    _context5.next = 17;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED
                    });

                case 17:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this, [[0, 13]]);
}

function scheduleEnvironmentReservationFormSaga() {
    return _regenerator2.default.wrap(function scheduleEnvironmentReservationFormSaga$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE, reservationEnvironmentChange), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE, reserveEnvironment), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION, deleteEnvironmentReservation), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL, cancel), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT, initEnvironmentForm)]);

                case 2:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

/***/ }),

/***/ 2453:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.searchReservation = searchReservation;
exports.openEnvironmentReservationForm = openEnvironmentReservationForm;
exports.loadApplicationsStagesAndLabels = loadApplicationsStagesAndLabels;
exports.schedulingSaga = schedulingSaga;

var _effects = __webpack_require__(54);

var _lodash = __webpack_require__(62);

var _schedulingActions = __webpack_require__(270);

var _schedulingService = __webpack_require__(799);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(451);

var _applicationService = __webpack_require__(450);

var _stageService = __webpack_require__(367);

var _labelService = __webpack_require__(585);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(searchReservation),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(openEnvironmentReservationForm),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(loadApplicationsStagesAndLabels),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(schedulingSaga);

function searchReservation(action) {
    var environmentReservations;
    return _regenerator2.default.wrap(function searchReservation$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_schedulingService.searchReservations, action.payload);

                case 3:
                    environmentReservations = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SEARCH_SUCCESS,
                        payload: environmentReservations
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function openEnvironmentReservationForm(action) {
    return _regenerator2.default.wrap(function openEnvironmentReservationForm$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.prev = 0;
                    _context2.next = 3;
                    return (0, _effects.put)((0, _schedulingEnvironmentReservationFormActions.initEnvironmentReservationForm)(action.payload));

                case 3:
                    _context2.next = 5;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
                        payload: true
                    });

                case 5:
                    _context2.next = 11;
                    break;

                case 7:
                    _context2.prev = 7;
                    _context2.t0 = _context2['catch'](0);
                    _context2.next = 11;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
                        payload: false
                    });

                case 11:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[0, 7]]);
}

function loadApplicationsStagesAndLabels() {
    var applications, stages, labels;
    return _regenerator2.default.wrap(function loadApplicationsStagesAndLabels$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.call)(_applicationService.searchApp, '');

                case 2:
                    applications = _context3.sent;
                    _context3.next = 5;
                    return (0, _effects.call)(_stageService.searchStages, '');

                case 5:
                    stages = _context3.sent;
                    _context3.next = 8;
                    return (0, _effects.call)(_labelService.searchLabels, '');

                case 8:
                    labels = _context3.sent;
                    _context3.next = 11;
                    return (0, _effects.put)({ type: _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS, payload: { applications: applications, stages: stages, labels: labels } });

                case 11:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function schedulingSaga() {
    return _regenerator2.default.wrap(function schedulingSaga$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.all)([(0, _effects.throttle)(200, _schedulingActions.actionTypes.SCHEDULE_SEARCH_REQUEST, searchReservation), (0, _effects.takeLatest)(_schedulingActions.actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM, openEnvironmentReservationForm), (0, _effects.takeLatest)(_schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_REQUEST, loadApplicationsStagesAndLabels)]);

                case 2:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 2454:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _redux = __webpack_require__(147);

var _environmentFormReducer = __webpack_require__(2455);

var _environmentFormReducer2 = _interopRequireDefault(_environmentFormReducer);

var _environmentListReducer = __webpack_require__(2456);

var _environmentListReducer2 = _interopRequireDefault(_environmentListReducer);

var _stageReducer = __webpack_require__(2457);

var _stageReducer2 = _interopRequireDefault(_stageReducer);

var _labelReducer = __webpack_require__(2458);

var _labelReducer2 = _interopRequireDefault(_labelReducer);

var _schedulingEnvironmentReservationFormReducer = __webpack_require__(2459);

var _schedulingEnvironmentReservationFormReducer2 = _interopRequireDefault(_schedulingEnvironmentReservationFormReducer);

var _schedulingReducer = __webpack_require__(2460);

var _schedulingReducer2 = _interopRequireDefault(_schedulingReducer);

var _applicationListReducer = __webpack_require__(2461);

var _applicationListReducer2 = _interopRequireDefault(_applicationListReducer);

var _applicationFormReducer = __webpack_require__(2462);

var _applicationFormReducer2 = _interopRequireDefault(_applicationFormReducer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _redux.combineReducers)({
    environmentForm: _environmentFormReducer2.default,
    environmentList: _environmentListReducer2.default,
    stages: _stageReducer2.default,
    labels: _labelReducer2.default,
    schedulingEnvironmentReservationForm: _schedulingEnvironmentReservationFormReducer2.default,
    scheduling: _schedulingReducer2.default,
    applicationList: _applicationListReducer2.default,
    applicationForm: _applicationFormReducer2.default
});

/***/ }),

/***/ 2455:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _environmentFormActions = __webpack_require__(448);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    environmentModel: {
        stage: {},
        id: null,
        labels: [],
        title: '',
        description: ''
    },
    environments: [],
    formIsPristine: true,
    formIsValid: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM:
            return (0, _extends3.default)({}, initialState, {
                environmentModel: (0, _extends3.default)({}, initialState.environmentModel, {
                    stage: state.environmentModel ? state.environmentModel.stage : {}
                }),
                formIsPristine: state.formIsPristine
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_VALID_FORM:
            return (0, _extends3.default)({}, state, {
                formIsValid: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM:
            return (0, _extends3.default)({}, state, {
                formIsPristine: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM:
            return (0, _extends3.default)({}, state, {
                environmentModel: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                environmentModel: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_SEARCH_SUCCESS:
            return (0, _extends3.default)({}, state, {
                environments: action.payload
            });

        case _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS:
            var _action$payload = action.payload,
                environment = _action$payload.environment,
                environments = _action$payload.environments;

            return (0, _extends3.default)({}, state, {
                environmentModel: environment || initialState.environmentModel,
                environments: environments
            });

        default:
            return state;
    }
};

/***/ }),

/***/ 2456:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _environmentActions = __webpack_require__(447);

var _utils = __webpack_require__(369);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    list: [],
    filters: {
        title: '',
        stage: {}
    },
    loading: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST:
        case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_REQUEST:
            return (0, _extends3.default)({}, state, {
                loading: true
            });
        case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_SUCCESS:
            {
                var environments = action.payload.sort(_utils.byTitle);
                return (0, _extends3.default)({}, state, {
                    list: environments,
                    loading: false
                });
            }
        case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_FAILURE:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.ENVIRONMENT_DELETE_REQUEST:
            return (0, _extends3.default)({}, state, {
                loading: true
            });
        case _environmentActions.actionTypes.ENVIRONMENT_DELETE_SUCCESS:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.ENVIRONMENT_DELETE_FAILURE:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
            {
                var _environments = action.payload.environments;

                return (0, _extends3.default)({}, state, {
                    list: _environments.sort(_utils.byTitle),
                    loading: false
                });
            }
        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_FAILURE:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.TITLE_FILTER_CHANGE:
            var title = action.payload;
            return (0, _extends3.default)({}, state, {
                filters: (0, _extends3.default)({}, state.filters, {
                    title: title
                })
            });
        case _environmentActions.actionTypes.STAGE_FILTER_CHANGE:
            var stage = action.payload;
            return (0, _extends3.default)({}, state, {
                filters: (0, _extends3.default)({}, state.filters, {
                    stage: stage
                })
            });
        default:
            return state;
    }
};

/***/ }),

/***/ 2457:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _stageActions = __webpack_require__(449);

var _environmentActions = __webpack_require__(447);

var _schedulingActions = __webpack_require__(270);

var _utils = __webpack_require__(369);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    stageList: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {

        case _stageActions.actionTypes.STAGE_SEARCH_SUCCESS:
            {
                var stages = action.payload.sort(_utils.byTitle);
                return (0, _extends3.default)({}, state, {
                    stageList: stages
                });
            }

        case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
            {
                var _stages = action.payload.stages;

                return (0, _extends3.default)({}, state, {
                    stageList: _stages.sort(_utils.byTitle)
                });
            }

        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
            {
                var _stages2 = action.payload.stages;

                return (0, _extends3.default)({}, state, {
                    stageList: _stages2.sort(_utils.byTitle)
                });
            }
        default:
            return state;
    }
};

/***/ }),

/***/ 2458:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _labelActions = __webpack_require__(368);

var _schedulingActions = __webpack_require__(270);

var _utils = __webpack_require__(369);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    labelList: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _labelActions.actionTypes.LABEL_SEARCH_SUCCESS:
            {
                var labels = action.payload;
                return (0, _extends3.default)({}, state, {
                    labelList: labels.sort(_utils.byTitle)
                });
            }

        case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
            {
                var _labels = action.payload.labels;

                return (0, _extends3.default)({}, state, {
                    labelList: _labels.sort(_utils.byTitle)
                });
            }

        default:
            return state;
    }
};

/***/ }),

/***/ 2459:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(451);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    reservationModel: {
        id: null,
        environment: {},
        applications: [],
        startDate: new Date(),
        endDate: new Date(new Date().getTime() + 1),
        note: ''
    },
    applications: [],
    environments: [],
    reservationFormIsPristine: true,
    reservationFormIsValid: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE:
            return (0, _extends3.default)({}, state, {
                reservationModel: action.payload
            });
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED:
            return (0, _extends3.default)({}, state, {
                applications: action.payload
            });
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM:
            return (0, _extends3.default)({}, initialState);
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM:
            return (0, _extends3.default)({}, state, {
                reservationFormIsValid: action.payload
            });
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM:
            return (0, _extends3.default)({}, state, {
                reservationFormIsPristine: action.payload
            });

        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE:
            return (0, _extends3.default)({}, state);

        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED:
            return (0, _extends3.default)({}, state, {
                reservationModel: initialState.reservationModel
            });
        default:
            return state;
    }
};

/***/ }),

/***/ 2460:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

var _schedulingActions = __webpack_require__(270);

var _utils = __webpack_require__(369);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    environmentsReservations: [],
    schedulerFilter: {
        environmentTitle: '',
        from: (0, _moment2.default)().startOf('month').valueOf(),
        to: (0, _moment2.default)().endOf('month').valueOf(),
        applications: [],
        stages: [],
        labels: []
    },
    reservationSidebarIsOpen: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _schedulingActions.actionTypes.SCHEDULE_SEARCH_REQUEST:
            return (0, _extends3.default)({}, state, {
                schedulerFilter: action.payload
            });
        case _schedulingActions.actionTypes.SCHEDULE_SEARCH_SUCCESS:
            {
                var environmentsReservations = action.payload;
                return (0, _extends3.default)({}, state, {
                    environmentsReservations: environmentsReservations.sort(_utils.byTitle)
                });
            }
        case _schedulingActions.actionTypes.SCHEDULE_SEARCH_FAILURE:
            return (0, _extends3.default)({}, state);
        case _schedulingActions.actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR:
            return (0, _extends3.default)({}, state, {
                reservationSidebarIsOpen: action.payload
            });
        case _schedulingActions.actionTypes.SCHEDULE_CLEAN_STATE:
            return (0, _extends3.default)({}, initialState);
        default:
            return state;
    }
};

/***/ }),

/***/ 2461:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _applicationActions = __webpack_require__(311);

var _schedulingActions = __webpack_require__(270);

var _utils = __webpack_require__(369);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    applications: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {

        case _applicationActions.actionTypes.APPLICATION_SEARCH_SUCCESS:
            {
                var applications = action.payload.sort(_utils.byTitle);
                return (0, _extends3.default)({}, state, {
                    applications: applications
                });
            }

        case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
            {
                var _applications = action.payload.applications;

                return (0, _extends3.default)({}, state, {
                    applications: _applications.sort(_utils.byTitle)
                });
            }

        case _applicationActions.actionTypes.APPLICATION_DELETE_SUCCESS:
            {
                return (0, _extends3.default)({}, state, {
                    applications: state.applications.filter(function (app) {
                        return app.id !== action.payload.id;
                    })
                });
            }

        default:
            return state;
    }
};

/***/ }),

/***/ 2462:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _applicationActions = __webpack_require__(311);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    stages: [],
    environments: [],
    application: {
        title: "",
        environments: []
    },
    applications: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {

        case _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                application: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_ENV_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                environments: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_STAGE_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                stages: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_LIST_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                applications: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_FORM_CLEAN:
            return (0, _extends3.default)({}, state, {
                application: initialState.application
            });

        default:
            return state;
    }
};

/***/ }),

/***/ 2463:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(43);

var _xlReactComponents = __webpack_require__(47);

var _environmentListHeaderComponent = __webpack_require__(2464);

var _environmentListHeaderComponent2 = _interopRequireDefault(_environmentListHeaderComponent);

var _environmentListComponent = __webpack_require__(2804);

var _environmentListComponent2 = _interopRequireDefault(_environmentListComponent);

var _environmentActions = __webpack_require__(447);

var _environmentSelectors = __webpack_require__(2811);

var _sidebarEnvironmentNavigation = __webpack_require__(462);

var _sidebarEnvironmentNavigation2 = _interopRequireDefault(_sidebarEnvironmentNavigation);

var _components = __webpack_require__(67);

var _types = __webpack_require__(112);

__webpack_require__(385);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentListPageContainer = function (_Component) {
    (0, _inherits3.default)(EnvironmentListPageContainer, _Component);
    (0, _createClass3.default)(EnvironmentListPageContainer, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.initEnvironmentList();
        }
    }]);

    function EnvironmentListPageContainer(props) {
        (0, _classCallCheck3.default)(this, EnvironmentListPageContainer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (EnvironmentListPageContainer.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListPageContainer)).call(this, props));

        _this.handleFilterChange = function (environmentName) {
            _this.props.titleFilterChange(environmentName);
        };

        _this.handleStageChange = function (stage) {
            if (stage) {
                _this.props.stageFilterChange(stage);
            }
        };

        _this.buttons = [{
            action: 'cancel',
            className: 'button cancel',
            keyCodes: [27],
            label: 'Cancel'
        }, {
            action: 'ok',
            className: 'button primary',
            keyCodes: [13],
            label: 'Delete'
        }];

        _this.openConfirmationDialog = function (environment) {
            _this.setState({ show: true, environmentForDelete: environment });
        };

        _this.onClose = function (action) {
            if (action === 'ok') {
                _this.props.onDeleteEnvironment(_this.state.environmentForDelete);
            }

            _this.setState({ show: false, environmentForDelete: null });
        };

        _this.state = { show: false, environmentForDelete: null };
        return _this;
    }

    // modal properties


    (0, _createClass3.default)(EnvironmentListPageContainer, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stages = _props.stages,
                filterStage = _props.filterStage,
                filterEnvironmentName = _props.filterEnvironmentName,
                onAddEnvironment = _props.onAddEnvironment,
                environments = _props.environments,
                onEditEnvironment = _props.onEditEnvironment;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_environmentListHeaderComponent2.default, {
                    filterEnvironmentName: filterEnvironmentName,
                    filterStage: filterStage,
                    onAddNewEnvironment: onAddEnvironment,
                    onFilterChange: this.handleFilterChange,
                    onStageChange: this.handleStageChange,
                    stages: stages
                }),
                _react2.default.createElement(
                    _sidebarEnvironmentNavigation2.default,
                    { menuSelected: 'Environments' },
                    _react2.default.createElement(_environmentListComponent2.default, {
                        environments: environments,
                        onDeleteEnvironment: this.openConfirmationDialog,
                        onEditEnvironment: onEditEnvironment })
                ),
                _react2.default.createElement(
                    _xlReactComponents.XlReactWidgetConfirmationDialog,
                    {
                        buttons: this.buttons,
                        dialogClassName: 'xl-default-modal',
                        onButtonClick: this.onClose,
                        show: this.state.show,
                        title: 'Delete environment' },
                    _react2.default.createElement(
                        _components.AlertMessage,
                        { alertType: _components.alertType.WARNING },
                        _react2.default.createElement(
                            'p',
                            null,
                            'Deleting an environment can lead to missing data for connected resources on reporting and environment scheduling.'
                        )
                    ),
                    _react2.default.createElement(
                        'p',
                        null,
                        'You are about to delete environment ',
                        _react2.default.createElement(
                            'strong',
                            null,
                            this.state.environmentForDelete ? this.state.environmentForDelete.title : ''
                        ),
                        '.'
                    )
                )
            );
        }
    }]);
    return EnvironmentListPageContainer;
}(_react.Component);

EnvironmentListPageContainer.propTypes = {
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    }).isRequired).isRequired,
    filterEnvironmentName: _propTypes2.default.string.isRequired,
    filterStage: _types.Stage,
    initEnvironmentList: _propTypes2.default.func.isRequired,
    onAddEnvironment: _propTypes2.default.func.isRequired,
    onDeleteEnvironment: _propTypes2.default.func.isRequired,
    onEditEnvironment: _propTypes2.default.func.isRequired,
    searchEnvironments: _propTypes2.default.func.isRequired,
    stageFilterChange: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage),
    titleFilterChange: _propTypes2.default.func.isRequired
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        stages: state.stages.stageList,
        environments: (0, _environmentSelectors.getFilteredEnvironments)(state),
        filterStage: state.environmentList.filters.stage,
        filterEnvironmentName: state.environmentList.filters.title
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    stageFilterChange: _environmentActions.stageFilterChange,
    initEnvironmentList: _environmentActions.initEnvironmentList,
    onAddEnvironment: _environmentActions.onAddEnvironment,
    onDeleteEnvironment: _environmentActions.onDeleteEnvironment,
    onEditEnvironment: _environmentActions.onEditEnvironment,
    searchEnvironments: _environmentActions.searchEnvironments,
    titleFilterChange: _environmentActions.titleFilterChange
})(EnvironmentListPageContainer);

/***/ }),

/***/ 2464:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _includes = __webpack_require__(370);

var _includes2 = _interopRequireDefault(_includes);

var _orderBy = __webpack_require__(587);

var _orderBy2 = _interopRequireDefault(_orderBy);

var _xlReactComponents = __webpack_require__(47);

var _headerComponent = __webpack_require__(271);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

var _types = __webpack_require__(112);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var selectStageMetadata = {
    placeholder: 'Filter by stage...'
};

var EnvironmentListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentListHeaderComponent, _Component);

    function EnvironmentListHeaderComponent() {
        (0, _classCallCheck3.default)(this, EnvironmentListHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListHeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentListHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stages = _props.stages,
                filterStage = _props.filterStage,
                filterEnvironmentName = _props.filterEnvironmentName,
                onAddNewEnvironment = _props.onAddNewEnvironment,
                onStageChange = _props.onStageChange,
                onFilterChange = _props.onFilterChange;

            var filterOptions = { placeholder: 'Filter by environment...' };

            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _orderBy2.default)(stages.filter(function (c) {
                    return (0, _includes2.default)(c.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };
            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, model: filterEnvironmentName, onUpdate: onFilterChange }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        className: 'env-stage-filter',
                        handlers: autocompleteHandlers,
                        metadata: selectStageMetadata,
                        model: filterStage,
                        objLabel: 'title',
                        onModelChange: onStageChange
                    }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: onAddNewEnvironment },
                            'New environment'
                        )
                    )
                )
            );
        }
    }]);
    return EnvironmentListHeaderComponent;
}(_react.Component);

EnvironmentListHeaderComponent.propTypes = {
    filterEnvironmentName: _propTypes2.default.string.isRequired,
    filterStage: _types.Stage,
    onAddNewEnvironment: _propTypes2.default.func.isRequired,
    onFilterChange: _propTypes2.default.func.isRequired,
    onStageChange: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};
exports.default = EnvironmentListHeaderComponent;

/***/ }),

/***/ 247:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ITEMS_PER_PAGE = exports.ITEMS_PER_PAGE = 15;
var ITEMS_MAX_DEPTH = exports.ITEMS_MAX_DEPTH = 10;
var AT_RISK = exports.AT_RISK = 'at-risk';
var ATTENTION_NEEDED = exports.ATTENTION_NEEDED = 'attention-needed';
var ON_TRACK = exports.ON_TRACK = 'on-track';
var NONE = exports.NONE = 'none';
var RISK_ON_TRACK_ICON = exports.RISK_ON_TRACK_ICON = 'xl-icon circle-check-icon color-green';

var RISK_ASSESSOR_ICONS = exports.RISK_ASSESSOR_ICONS = {
    'ReleaseFlaggedAt': 'flag-risk-icon icon-l',
    'ReleaseFlaggedAttentionNeeded': 'flag-attention-icon icon-l',
    'ReleaseStatusFailed': 'flag-risk-icon icon-l',
    'ReleaseDueDate': 'pending-icon',
    'ReleaseStatusFailing': 'flag-attention-icon icon-l',
    'ReleaseStatus': 'flag-risk-icon icon-l',
    'TaskAtRisk': 'flag-risk-icon icon-l',
    'TaskWithOneFlagAtRisk': 'flag-risk-icon icon-l',
    'TaskWithTwoOrThreeFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskWithFourFiveOrSixFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskWithMoreThanSixFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskDueDate': 'pending-icon',
    'OneTaskOverDue': 'pending-icon',
    'MoreThanOneTaskOverDue': 'pending-icon',
    'TaskNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithOneFlagNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithTwoOrThreeFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithFourFiveOrSixFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithMoreThanSixFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskRetries': 'lightning-icon color-red',
    'TaskRetries2Retries': 'lightning-icon color-red',
    'TaskRetries3Retries': 'lightning-icon color-red',
    'TaskRetries4Retries': 'lightning-icon color-red',
    'TaskRetries5Retries': 'lightning-icon color-red',
    'TaskRetriesMoreThan5Retries': 'lightning-icon color-red'
};

/***/ }),

/***/ 2473:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2475:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AlertMessage = exports.alertType = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var alertType = exports.alertType = {
    INFO: 'info',
    WARNING: 'warning'
};

var AlertMessage = exports.AlertMessage = function (_PureComponent) {
    (0, _inherits3.default)(AlertMessage, _PureComponent);

    function AlertMessage() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, AlertMessage);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = AlertMessage.__proto__ || (0, _getPrototypeOf2.default)(AlertMessage)).call.apply(_ref, [this].concat(args))), _this), _this.alertIconsClasses = {
            'info': 'info-icon',
            'warning': 'warning-icon'
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(AlertMessage, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                children = _props.children,
                alertType = _props.alertType;

            var alertClass = 'xlr-alert-' + alertType;
            var iconClass = 'xl-icon ' + this.alertIconsClasses[alertType] + ' icon-l';
            return _react2.default.createElement(
                'div',
                { className: alertClass },
                _react2.default.createElement(
                    'div',
                    { className: 'icon' },
                    _react2.default.createElement('i', { className: iconClass })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'message' },
                    children
                )
            );
        }
    }]);
    return AlertMessage;
}(_react.PureComponent);

AlertMessage.propTypes = {
    alertType: _propTypes2.default.oneOf([alertType.INFO, alertType.WARNING]).isRequired,
    children: _propTypes2.default.element.isRequired
};

/***/ }),

/***/ 2476:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.HelpBlock = undefined;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2477);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HelpBlock = exports.HelpBlock = function HelpBlock(_ref) {
    var className = _ref.className,
        children = _ref.children;
    return _react2.default.createElement(
        'div',
        { className: 'help-block-component ' + className },
        children
    );
};

HelpBlock.propTypes = {
    children: _propTypes2.default.oneOfType([_propTypes2.default.arrayOf(_propTypes2.default.node), _propTypes2.default.node]).isRequired,
    className: _propTypes2.default.string
};

HelpBlock.defaultProps = {
    className: ''
};

/***/ }),

/***/ 2477:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2479:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2481:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Popup = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _clickOutside = __webpack_require__(2482);

var _clickOutside2 = _interopRequireDefault(_clickOutside);

var _popupTrigger = __webpack_require__(2483);

var _popupTrigger2 = _interopRequireDefault(_popupTrigger);

__webpack_require__(805);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Trigger = (0, _clickOutside2.default)()(_popupTrigger2.default);

var Popup = exports.Popup = function (_Component) {
  (0, _inherits3.default)(Popup, _Component);

  function Popup(props) {
    (0, _classCallCheck3.default)(this, Popup);

    var _this = (0, _possibleConstructorReturn3.default)(this, (Popup.__proto__ || (0, _getPrototypeOf2.default)(Popup)).call(this, props));

    _this.onClickOutside = function () {
      var onStateChange = _this.props.onStateChange;


      _this.setState({
        isOpen: false
      });

      if (onStateChange) {
        onStateChange(false);
      }
    };

    _this.toggleDropdown = function (e) {
      e.stopPropagation();
      var onStateChange = _this.props.onStateChange;

      var state = !_this.state.isOpen;

      _this.setState({
        isOpen: state
      });

      if (onStateChange) {
        onStateChange(state);
      }
    };

    _this.state = {
      isOpen: false
    };
    return _this;
  }

  (0, _createClass3.default)(Popup, [{
    key: 'render',
    value: function render() {
      return _react2.default.createElement(
        'div',
        { className: 'popup__container ' + (this.state.isOpen ? 'popup--expanded' : '') },
        _react2.default.createElement(
          Trigger,
          {
            enable: this.state.isOpen,
            onClick: this.toggleDropdown,
            onClickOutside: this.onClickOutside
          },
          _react2.default.createElement(
            'div',
            {
              className: 'popup__content ' + (this.state.isOpen ? 'popup__content--open' : ''),
              role: 'presentation'
            },
            this.props.children
          )
        )
      );
    }
  }]);
  return Popup;
}(_react.Component);

Popup.propTypes = {
  children: _propTypes2.default.oneOfType([_propTypes2.default.arrayOf(_propTypes2.default.node), _propTypes2.default.node]).isRequired,
  onStateChange: _propTypes2.default.func
};

/***/ }),

/***/ 2482:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = __webpack_require__(14);

var _reactDom2 = _interopRequireDefault(_reactDom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function clickOutside() {
  return function (WrappedComponent) {
    return function (_Component) {
      (0, _inherits3.default)(WithClickOutside, _Component);
      (0, _createClass3.default)(WithClickOutside, null, [{
        key: 'propTypes',
        get: function get() {
          return {
            enable: _propTypes2.default.bool,
            onClickOutside: _propTypes2.default.func.isRequired
          };
        }
      }, {
        key: 'defaultProps',
        get: function get() {
          return {
            enable: true
          };
        }
      }]);

      function WithClickOutside(props) {
        (0, _classCallCheck3.default)(this, WithClickOutside);

        var _this = (0, _possibleConstructorReturn3.default)(this, (WithClickOutside.__proto__ || (0, _getPrototypeOf2.default)(WithClickOutside)).call(this, props));

        _this.mounted = true;
        _this.handleDocumentClick = _this.handleDocumentClick.bind(_this);
        return _this;
      }

      (0, _createClass3.default)(WithClickOutside, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
          document.addEventListener('click', this.handleDocumentClick, false);
          document.addEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
          this.mounted = false;
          document.removeEventListener('click', this.handleDocumentClick, false);
          document.removeEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: 'handleDocumentClick',
        value: function handleDocumentClick(event) {
          if (this.mounted && this.props.enable) {
            /* eslint-disable react/no-find-dom-node */
            if (!_reactDom2.default.findDOMNode(this).contains(event.target)) {
              if (this.props.onClickOutside) {
                this.props.onClickOutside();
              }
            }
          }
        }
      }, {
        key: 'render',
        value: function render() {
          return _react2.default.createElement(WrappedComponent, this.props);
        }
      }]);
      return WithClickOutside;
    }(_react.Component);
  };
} /* global document */
exports.default = clickOutside;

/***/ }),

/***/ 2483:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(805);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PopupTrigger = function PopupTrigger(props) {
  return _react2.default.createElement(
    'div',
    { className: 'popup__trigger' },
    _react2.default.createElement('i', { className: 'xl-icon options-icon remove-outline', onClick: props.onClick, role: 'button', tabIndex: -1 }),
    props.children
  );
};

PopupTrigger.propTypes = {
  children: _propTypes2.default.element.isRequired,
  onClick: _propTypes2.default.func.isRequired
};

exports.default = PopupTrigger;

/***/ }),

/***/ 2485:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReleaseListComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _const = __webpack_require__(312);

var _releaseHeaderLabel = __webpack_require__(2486);

var _releaseRow = __webpack_require__(2488);

__webpack_require__(589);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseListComponent = exports.ReleaseListComponent = function (_Component) {
    (0, _inherits3.default)(ReleaseListComponent, _Component);

    function ReleaseListComponent() {
        (0, _classCallCheck3.default)(this, ReleaseListComponent);
        return (0, _possibleConstructorReturn3.default)(this, (ReleaseListComponent.__proto__ || (0, _getPrototypeOf2.default)(ReleaseListComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(ReleaseListComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                loadingReleases = _props.loadingReleases,
                header = _props.header,
                onOrderChange = _props.onOrderChange,
                releases = _props.releases,
                noData = _props.noData,
                dateFormat = _props.dateFormat,
                timeFormat = _props.timeFormat;


            var content = noData;
            if (releases.length > 0) {
                var releaseRows = releases.map(function (release) {
                    return _react2.default.createElement(_releaseRow.ReleaseRowComponent, {
                        currentPhase: release.currentPhase,
                        dateFormat: dateFormat,
                        duration: release.duration,
                        endDate: release.endDate,
                        folders: release.folders,
                        id: release.id,
                        isArchived: release.isArchived,
                        key: release.id,
                        progress: release.progress,
                        startDate: release.startDate,
                        status: release.status,
                        timeFormat: timeFormat,
                        title: release.title });
                });

                content = _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(
                        'h4',
                        { className: 'release-list-view-title' },
                        'Search results (top ',
                        releases.length,
                        ')'
                    ),
                    _react2.default.createElement(_releaseHeaderLabel.ReleaseHeaderLabelComponent, { header: header, onOrderChange: onOrderChange }),
                    releaseRows
                );
            }

            if (loadingReleases) {
                content = _react2.default.createElement(
                    'div',
                    { className: 'spinner' },
                    _react2.default.createElement('img', { alt: 'Loading...', src: 'static/9.5.5/styles/img/big-ajax-loader.gif' })
                );
            }

            return _react2.default.createElement(
                'div',
                { className: 'release-list-view' },
                content
            );
        }
    }]);
    return ReleaseListComponent;
}(_react.Component);

ReleaseListComponent.propTypes = {
    dateFormat: _propTypes2.default.string,
    header: _propTypes2.default.arrayOf(_const.HeaderRow).isRequired,
    loadingReleases: _propTypes2.default.bool.isRequired,
    noData: _propTypes2.default.node.isRequired,
    onOrderChange: _propTypes2.default.func.isRequired,
    releases: _propTypes2.default.arrayOf(_const.ReleaseRow).isRequired,
    timeFormat: _propTypes2.default.string
};

/***/ }),

/***/ 2486:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReleaseHeaderLabelComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _const = __webpack_require__(312);

__webpack_require__(589);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseHeaderLabelComponent = exports.ReleaseHeaderLabelComponent = function (_Component) {
    (0, _inherits3.default)(ReleaseHeaderLabelComponent, _Component);

    function ReleaseHeaderLabelComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, ReleaseHeaderLabelComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = ReleaseHeaderLabelComponent.__proto__ || (0, _getPrototypeOf2.default)(ReleaseHeaderLabelComponent)).call.apply(_ref, [this].concat(args))), _this), _this.onOrderChange = function (column) {
            if (column.sortable) {
                _this.props.onOrderChange(column);
            }
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(ReleaseHeaderLabelComponent, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            var header = this.props.header;

            var headerRow = header.map(function (column) {
                var className = column.sortable ? 'sortable' : '';
                return _react2.default.createElement(
                    'div',
                    { className: 'release-row-view-column ' + column.class + ' ' + className, key: column.fieldName, onClick: function onClick() {
                            return _this2.onOrderChange(column);
                        } },
                    column.label,
                    _react2.default.createElement(
                        'div',
                        { className: 'order-icons' },
                        (column.order === _const.OrderConst.SORT_DESC || column.order === _const.OrderConst.SORT_NONE) && _react2.default.createElement('i', { className: 'xl-icon icon-s arrow-up-icon' }),
                        (column.order === _const.OrderConst.SORT_ASC || column.order === _const.OrderConst.SORT_NONE) && _react2.default.createElement('i', { className: 'xl-icon icon-s arrow-down-icon' })
                    )
                );
            });

            return _react2.default.createElement(
                'div',
                { className: 'release-header-row-view' },
                headerRow
            );
        }
    }]);
    return ReleaseHeaderLabelComponent;
}(_react.Component);

ReleaseHeaderLabelComponent.propTypes = {
    header: _propTypes2.default.arrayOf(_const.HeaderRow).isRequired,
    onOrderChange: _propTypes2.default.func.isRequired
};

/***/ }),

/***/ 2488:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReleaseRowComponent = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _const = __webpack_require__(312);

var _displayDuration = __webpack_require__(2489);

var _folderPath = __webpack_require__(2492);

var _releaseStatus = __webpack_require__(806);

var _releaseProgress = __webpack_require__(807);

var _displayDate = __webpack_require__(2499);

__webpack_require__(589);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseRowComponent = exports.ReleaseRowComponent = function (_Component) {
    (0, _inherits3.default)(ReleaseRowComponent, _Component);

    function ReleaseRowComponent() {
        (0, _classCallCheck3.default)(this, ReleaseRowComponent);
        return (0, _possibleConstructorReturn3.default)(this, (ReleaseRowComponent.__proto__ || (0, _getPrototypeOf2.default)(ReleaseRowComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(ReleaseRowComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                id = _props.id,
                title = _props.title,
                status = _props.status,
                duration = _props.duration,
                currentPhase = _props.currentPhase,
                endDate = _props.endDate,
                progress = _props.progress,
                startDate = _props.startDate,
                folders = _props.folders,
                isArchived = _props.isArchived,
                dateFormat = _props.dateFormat,
                timeFormat = _props.timeFormat;


            return _react2.default.createElement(
                'div',
                { className: 'release-list-row-view' },
                _react2.default.createElement(
                    'div',
                    { className: 'release-row-view-column release-title' },
                    _react2.default.createElement(
                        'div',
                        null,
                        _react2.default.createElement(
                            'a',
                            { href: '#/releases/' + id },
                            _react2.default.createElement(
                                'strong',
                                null,
                                title
                            ),
                            currentPhase && ' - ' + currentPhase
                        )
                    ),
                    folders && folders.length > 0 && _react2.default.createElement(_folderPath.FolderPathComponent, { folders: folders })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'release-row-view-column release-status' },
                    _react2.default.createElement(_releaseStatus.ReleaseStatusComponent, { isArchived: isArchived, status: status })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'release-row-view-column release-progress' },
                    _react2.default.createElement(_releaseProgress.ReleaseProgressComponent, { progress: progress })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'release-row-view-column release-start-date' },
                    _react2.default.createElement(_displayDate.DisplayDateComponent, { date: startDate, dateFormat: dateFormat, isLink: true, timeFormat: timeFormat })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'release-row-view-column release-end-date' },
                    _react2.default.createElement(_displayDate.DisplayDateComponent, { date: endDate, dateFormat: dateFormat, isLink: true, timeFormat: timeFormat })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'release-row-view-column release-duration' },
                    _react2.default.createElement(_displayDuration.DisplayDurationComponent, { duration: duration })
                )
            );
        }
    }]);
    return ReleaseRowComponent;
}(_react.Component);

ReleaseRowComponent.propTypes = (0, _extends3.default)({
    dateFormat: _propTypes2.default.string,
    timeFormat: _propTypes2.default.string
}, _const.ReleaseRow.isRequired);

/***/ }),

/***/ 2489:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DisplayDurationComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

__webpack_require__(2490);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DisplayDurationComponent = exports.DisplayDurationComponent = function (_Component) {
    (0, _inherits3.default)(DisplayDurationComponent, _Component);

    function DisplayDurationComponent() {
        (0, _classCallCheck3.default)(this, DisplayDurationComponent);
        return (0, _possibleConstructorReturn3.default)(this, (DisplayDurationComponent.__proto__ || (0, _getPrototypeOf2.default)(DisplayDurationComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(DisplayDurationComponent, [{
        key: 'render',
        value: function render() {
            var duration = this.props.duration;

            return _react2.default.createElement(
                'span',
                { className: 'display-duration-view' },
                _moment2.default.duration(duration, 'ms').format("d[d] h[h] m[m]", { trim: false })
            );
        }
    }]);
    return DisplayDurationComponent;
}(_react.Component);

DisplayDurationComponent.propTypes = {
    duration: _propTypes2.default.number.isRequired
};

/***/ }),

/***/ 2490:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2492:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FolderPathComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _ids = __webpack_require__(110);

var _ids2 = _interopRequireDefault(_ids);

__webpack_require__(2493);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FolderPathComponent = exports.FolderPathComponent = function (_Component) {
    (0, _inherits3.default)(FolderPathComponent, _Component);

    function FolderPathComponent() {
        (0, _classCallCheck3.default)(this, FolderPathComponent);
        return (0, _possibleConstructorReturn3.default)(this, (FolderPathComponent.__proto__ || (0, _getPrototypeOf2.default)(FolderPathComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(FolderPathComponent, [{
        key: 'render',
        value: function render() {
            var folders = this.props.folders;

            var folderUrl = '#/folders/Applications';
            var folderList = folders.map(function (folder, idx) {
                folderUrl += '/' + ('' + (0, _ids2.default)().noApplications(folder.id));
                return _react2.default.createElement(
                    'li',
                    { key: folder.id },
                    _react2.default.createElement(
                        'div',
                        null,
                        idx !== 0 && _react2.default.createElement('i', { className: 'xl-icon icon-xs chevron-right-icon' }),
                        ' ',
                        _react2.default.createElement(
                            'a',
                            { href: folderUrl + '/templates' },
                            _react2.default.createElement('i', { className: 'xl-icon icon-xs folder-icon' }),
                            ' ',
                            folder.title
                        )
                    )
                );
            });

            return _react2.default.createElement(
                'ul',
                { className: 'folder-path-view' },
                folderList
            );
        }
    }]);
    return FolderPathComponent;
}(_react.Component);

FolderPathComponent.propTypes = {
    folders: _propTypes2.default.array.isRequired
};

/***/ }),

/***/ 2493:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2495:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2497:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2499:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DisplayDateComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _utils = __webpack_require__(808);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DisplayDateComponent = exports.DisplayDateComponent = function (_Component) {
    (0, _inherits3.default)(DisplayDateComponent, _Component);

    function DisplayDateComponent(props) {
        (0, _classCallCheck3.default)(this, DisplayDateComponent);
        return (0, _possibleConstructorReturn3.default)(this, (DisplayDateComponent.__proto__ || (0, _getPrototypeOf2.default)(DisplayDateComponent)).call(this, props));
    }

    (0, _createClass3.default)(DisplayDateComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                date = _props.date,
                dateFormat = _props.dateFormat,
                isLink = _props.isLink,
                color = _props.color,
                timeFormat = _props.timeFormat;

            var format = (0, _utils.formatDateTime)(date, dateFormat, timeFormat);

            var style = {
                color: color || '#414C58'
            };

            if (isLink) {
                return _react2.default.createElement(
                    'a',
                    { href: '#/calendar?month=' + (0, _moment2.default)(date).format('MM-YYYY'), style: style },
                    format
                );
            }
            return _react2.default.createElement(
                'span',
                { style: style },
                format
            );
        }
    }]);
    return DisplayDateComponent;
}(_react.Component);

DisplayDateComponent.propTypes = {
    color: _propTypes2.default.string,
    date: _propTypes2.default.number.isRequired,
    dateFormat: _propTypes2.default.string,
    isLink: _propTypes2.default.bool,
    timeFormat: _propTypes2.default.string
};
DisplayDateComponent.defaultProps = {
    dateFormat: 'YYYY-MM-DD',
    timeFormat: 'h:mm A'
};

/***/ }),

/***/ 2500:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var angularJsDateFormatToMomentFormat = exports.angularJsDateFormatToMomentFormat = {
    'd/M/yy': 'D/M/YY',
    'M/d/yy': 'M/D/YY',
    'dd/MM/yy': 'DD/MM/YY',
    'yy/MM/dd': 'YY/MM/DD'
};

var angularJsTimeFormatToMomentFormat = exports.angularJsTimeFormatToMomentFormat = {
    'HH:mm': 'HH:mm',
    'h:mm a': 'h:mm A'
};

/***/ }),

/***/ 2501:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReleaseCountComponent = exports.ReleaseCountResults = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _antd = __webpack_require__(194);

var _lodash = __webpack_require__(62);

__webpack_require__(2789);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseCountResult = _propTypes2.default.shape({
    total: _propTypes2.default.number,
    byStatus: _propTypes2.default.object
});
var ReleaseCountResults = exports.ReleaseCountResults = _propTypes2.default.shape({
    all: ReleaseCountResult.isRequired,
    live: ReleaseCountResult.isRequired,
    archived: ReleaseCountResult.isRequired
});

var ReleaseCountComponent = exports.ReleaseCountComponent = function (_Component) {
    (0, _inherits3.default)(ReleaseCountComponent, _Component);

    function ReleaseCountComponent() {
        (0, _classCallCheck3.default)(this, ReleaseCountComponent);
        return (0, _possibleConstructorReturn3.default)(this, (ReleaseCountComponent.__proto__ || (0, _getPrototypeOf2.default)(ReleaseCountComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(ReleaseCountComponent, [{
        key: 'render',
        value: function render() {
            var releaseCount = this.props.releaseCount;

            var getIconClass = function getIconClass(status) {
                return status.replace('_', '-').toLowerCase();
            };
            var getStatusText = function getStatusText(status) {
                var lowerCasedStatus = status.replace('_', ' ').toLowerCase();
                return lowerCasedStatus.charAt(0).toUpperCase() + lowerCasedStatus.slice(1);
            };
            var pluralizeReleaseWord = function pluralizeReleaseWord(count) {
                if (count === 1) {
                    return 'release';
                } else {
                    return 'releases';
                }
            };

            // eslint-disable-next-line angular/definedundefined
            if (releaseCount === undefined) {
                return '';
            } else if (releaseCount.all.total === 0) {
                return '';
            }

            var all = (0, _lodash.map)(releaseCount.all.byStatus, function (count, status) {
                return _react2.default.createElement(
                    'p',
                    { key: status },
                    _react2.default.createElement('i', { className: 'circle ' + getIconClass(status) }),
                    count,
                    ' ',
                    getStatusText(status)
                );
            });
            var content = _react2.default.createElement(
                'div',
                { className: 'release-status-count-popup' },
                _react2.default.createElement(
                    'div',
                    null,
                    all
                )
            );

            return _react2.default.createElement(
                'div',
                { className: 'release-count' },
                _react2.default.createElement(
                    _antd.Popover,
                    { content: content, overlayClassName: 'release-count-popover', placement: 'bottom' },
                    releaseCount.all.total,
                    ' ',
                    pluralizeReleaseWord(releaseCount.all.total)
                )
            );
        }
    }]);
    return ReleaseCountComponent;
}(_react.Component);

ReleaseCountComponent.propTypes = {
    releaseCount: ReleaseCountResults
};

/***/ }),

/***/ 256:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getTrackedItemApprovals = exports.isDeliveryUpdatable = exports.updateDelivery = exports.createDeliveryFromPattern = exports.createDelivery = exports.deleteDelivery = exports.getDelivery = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

exports.fetchDeliveries = fetchDeliveries;

var _http = __webpack_require__(71);

var _constants = __webpack_require__(432);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var RELEASE_DELIVERY_API = 'api/v1/deliveries';
var RELEASE_DELIVERY_PATTERN_API = 'api/v1/delivery-patterns';
var RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API = 'activity';

function reduceFilters(filters) {
    var keys = _.keys(filters);

    return _.reduce(keys, function (reduced, key) {
        if (_.has(_constants.RELEASE_STATUS_FILTER_KEY_TO_STATUS, key)) {
            filters[key] && reduced.statuses.push(_constants.RELEASE_STATUS_FILTER_KEY_TO_STATUS[key]);
        } else {
            reduced[key] = filters[key];
        }
        return reduced;
    }, { statuses: [] });
}

function fetchDeliveries(data, pageNumber) {
    var itemsPerPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants.ITEMS_PER_PAGE;

    var params = {
        resultsPerPage: itemsPerPage,
        page: pageNumber,
        orderBy: (data.orderBy || _constants.DEFAULT_ORDER_BY).toUpperCase()
    };
    var url = RELEASE_DELIVERY_API + '/search?' + $.param(params);

    return (0, _http.httpPOST)(url, (0, _extends3.default)({}, reduceFilters(data)));
}

var getDelivery = exports.getDelivery = function getDelivery(deliveryId) {
    var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return (0, _http.httpGET)(RELEASE_DELIVERY_API + '/' + deliveryId, hideAlert);
};

var deleteDelivery = exports.deleteDelivery = function deleteDelivery(deliveryId) {
    return (0, _http.httpDELETE)(RELEASE_DELIVERY_API + '/' + deliveryId);
};

var createDelivery = exports.createDelivery = function createDelivery(delivery) {
    return (0, _http.httpPOST)(RELEASE_DELIVERY_API, delivery);
};

var createDeliveryFromPattern = exports.createDeliveryFromPattern = function createDeliveryFromPattern(patternId, delivery) {
    return (0, _http.httpPOST)(RELEASE_DELIVERY_PATTERN_API + '/' + patternId + '/create', delivery);
};

var updateDelivery = exports.updateDelivery = function updateDelivery(delivery) {
    return (0, _http.httpPUT)(RELEASE_DELIVERY_API + '/' + delivery.id, delivery);
};

var isDeliveryUpdatable = exports.isDeliveryUpdatable = function isDeliveryUpdatable(delivery) {
    return delivery && delivery.status !== 'COMPLETED';
};

var getTrackedItemApprovals = exports.getTrackedItemApprovals = function getTrackedItemApprovals(deliveryId) {
    return (0, _http.httpGET)(RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API + '/' + deliveryId + '/approvals');
};

/***/ }),

/***/ 268:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var DASHBOARD_MAX_COLUMNS = exports.DASHBOARD_MAX_COLUMNS = 8;
var DASHBOARD_DEFAULT_COLUMNS = exports.DASHBOARD_DEFAULT_COLUMNS = 6;
var DASHBOARD_PROPERTIES_SIDEBAR_NAME = exports.DASHBOARD_PROPERTIES_SIDEBAR_NAME = 'DASHBOARD_PROPERTIES_SIDEBAR_NAME';
var DASHBOARD_CREATION_SIDEBAR_NAME = exports.DASHBOARD_CREATION_SIDEBAR_NAME = 'DASHBOARD_CREATION_SIDEBAR_NAME';
var DASHBOARD_WIDGETS_SIDEBAR_NAME = exports.DASHBOARD_WIDGETS_SIDEBAR_NAME = 'DASHBOARD_WIDGETS_SIDEBAR_NAME';
var DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = exports.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = 'DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME';

var DASHBOARD_MODE = exports.DASHBOARD_MODE = {
    VIEW: 'view',
    DESIGN: 'design'
};

var DASHBOARD_LEVEL = exports.DASHBOARD_LEVEL = {
    RELEASE: 'RELEASE',
    FOLDER: 'FOLDER',
    GLOBAL: 'GLOBAL'
};

/***/ }),

/***/ 269:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.store = undefined;

var _typeof2 = __webpack_require__(124);

var _typeof3 = _interopRequireDefault(_typeof2);

var _redux = __webpack_require__(147);

var _reduxSaga = __webpack_require__(277);

var _reduxSaga2 = _interopRequireDefault(_reduxSaga);

var _sagas = __webpack_require__(2445);

var _sagas2 = _interopRequireDefault(_sagas);

var _reducers = __webpack_require__(2454);

var _reducers2 = _interopRequireDefault(_reducers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* global window */
var sagaMiddleware = (0, _reduxSaga2.default)();

/* eslint-disable no-underscore-dangle,angular/typecheck-object,angular/module-getter */
var composeEnhancers = (typeof window === 'undefined' ? 'undefined' : (0, _typeof3.default)(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
    name: 'env-manager'
    // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...
}) : _redux.compose;

function configureStore(preloadedState) {
    var enhancer = composeEnhancers((0, _redux.applyMiddleware)(sagaMiddleware));

    var store = (0, _redux.createStore)(_reducers2.default, preloadedState, enhancer);

    sagaMiddleware.run(_sagas2.default);

    return store;
}

var store = exports.store = store || configureStore();
/* eslint-enable */

/***/ }),

/***/ 270:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    SCHEDULE_SEARCH_REQUEST: 'envMgmt/SCHEDULE_SEARCH_REQUEST',
    SCHEDULE_SEARCH_SUCCESS: 'envMgmt/SCHEDULE_SEARCH_SUCCESS',
    SCHEDULE_SEARCH_FAILURE: 'envMgmt/SCHEDULE_SEARCH_FAILURE',

    SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM: 'envMgmt/SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM',

    SCHEDULE_SHOW_RESERVATION_SIDEBAR: 'envMgmt/SCHEDULE_SHOW_RESERVATION_SIDEBAR',
    SCHEDULE_INIT_HEADER_REQUEST: 'envMgmt/SCHEDULE_INIT_HEADER_REQUEST',
    SCHEDULE_INIT_HEADER_SUCCESS: 'envMgmt/SCHEDULE_INIT_HEADER_SUCCESS',

    SCHEDULE_CLEAN_STATE: 'envMgmt/SCHEDULE_CLEAN_STATE'
};

var onSearchReservations = exports.onSearchReservations = function onSearchReservations(schedulerFilter) {
    return {
        type: actionTypes.SCHEDULE_SEARCH_REQUEST,
        payload: schedulerFilter
    };
};

var openEnvironmentReservationForm = exports.openEnvironmentReservationForm = function openEnvironmentReservationForm(reservationId) {
    return {
        type: actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM,
        payload: reservationId
    };
};

var showReservationSidebar = exports.showReservationSidebar = function showReservationSidebar(isOpen) {
    return {
        type: actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
        payload: isOpen
    };
};

var initHeader = exports.initHeader = function initHeader() {
    return {
        type: actionTypes.SCHEDULE_INIT_HEADER_REQUEST
    };
};

var cleanSchedulingState = exports.cleanSchedulingState = function cleanSchedulingState() {
    return {
        type: actionTypes.SCHEDULE_CLEAN_STATE
    };
};

/***/ }),

/***/ 271:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2473);

var _components = __webpack_require__(67);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HeaderComponent = function (_Component) {
    (0, _inherits3.default)(HeaderComponent, _Component);

    function HeaderComponent() {
        (0, _classCallCheck3.default)(this, HeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (HeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(HeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(HeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                children = _props.children,
                helpUrl = _props.helpUrl;

            return _react2.default.createElement(
                'div',
                { className: 'header', id: 'header-environment' },
                children,
                _react2.default.createElement(_components.DocLink, { section: helpUrl })
            );
        }
    }]);
    return HeaderComponent;
}(_react.Component);

HeaderComponent.propTypes = {
    children: _propTypes2.default.element,
    helpUrl: _propTypes2.default.string.isRequired
};
exports.default = HeaderComponent;

/***/ }),

/***/ 274:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

exports.fetchDeliveryPattern = fetchDeliveryPattern;
exports.createDeliveryPattern = createDeliveryPattern;
exports.copyDeliveryPattern = copyDeliveryPattern;
exports.updateDeliveryPattern = updateDeliveryPattern;
exports.deleteDeliveryPattern = deleteDeliveryPattern;
exports.searchDeliveryPatterns = searchDeliveryPatterns;
exports.fetchStages = fetchStages;
exports.copyStage = copyStage;
exports.deleteStage = deleteStage;
exports.updateStage = updateStage;
exports.addStage = addStage;
exports.fetchTransitions = fetchTransitions;
exports.addTransition = addTransition;
exports.updateTransition = updateTransition;
exports.deleteTransition = deleteTransition;
exports.checkTitle = checkTitle;

var _http = __webpack_require__(71);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var API_URL = 'api/v1/delivery-patterns';

function fetchDeliveryPattern(patternId) {
    return (0, _http.httpGET)(API_URL + '/' + patternId, true).then(function (res) {
        return res.data;
    }).catch(function () {
        return { id: null, title: null };
    });
}

function createDeliveryPattern(deliveryPattern) {
    return (0, _http.httpPOST)(API_URL, (0, _extends3.default)({
        id: '',
        type: 'delivery.Delivery'
    }, deliveryPattern, {
        status: 'template'
    })).then(function (res) {
        return res.data;
    });
}

function copyDeliveryPattern(deliveryPattern) {
    return (0, _http.httpPOST)(API_URL + '/' + deliveryPattern.id + '/duplicate', {
        title: deliveryPattern.title,
        description: deliveryPattern.description
    }).then(function (res) {
        return res.data;
    });
}

function updateDeliveryPattern(deliveryPattern) {
    return (0, _http.httpPUT)(API_URL + '/' + deliveryPattern.id, (0, _extends3.default)({
        type: 'delivery.Delivery'
    }, deliveryPattern, {
        status: 'template'
    })).then(function (res) {
        return res.data;
    });
}

function deleteDeliveryPattern(patternId) {
    return (0, _http.httpDELETE)(API_URL + '/' + patternId);
}

function searchDeliveryPatterns() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$title = _ref.title,
        title = _ref$title === undefined ? '' : _ref$title,
        _ref$folderId = _ref.folderId,
        folderId = _ref$folderId === undefined ? undefined : _ref$folderId,
        _ref$pageNumber = _ref.pageNumber,
        pageNumber = _ref$pageNumber === undefined ? 0 : _ref$pageNumber,
        _ref$itemsPerPage = _ref.itemsPerPage,
        itemsPerPage = _ref$itemsPerPage === undefined ? 100 : _ref$itemsPerPage;

    var params = {
        page: pageNumber,
        resultsPerPage: itemsPerPage
    };
    var url = API_URL + '/search?' + $.param(params);
    return (0, _http.httpPOST)(url, { title: title, folderId: folderId }).then(function (res) {
        return res.data;
    });
}

function fetchStages(defId) {
    return (0, _http.httpGET)(API_URL + '/' + defId + '/stages').then(function (res) {
        return res.data;
    });
}

function copyStage(stageId) {
    return (0, _http.httpPOST)(API_URL + '/' + stageId + '/duplicate').then(function (res) {
        return res.data;
    });
}

function deleteStage(stageId) {
    return (0, _http.httpDELETE)(API_URL + '/' + stageId);
}

function updateStage(stageId, title) {
    return (0, _http.httpPUT)(API_URL + '/' + stageId, { id: stageId, title: title, type: 'delivery.Stage' }).then(function (res) {
        return res.data;
    });
}

function addStage(defId) {
    return (0, _http.httpPOST)(API_URL + '/' + defId + '/stages', { id: null, title: null, type: 'delivery.Stage' }).then(function (res) {
        return res.data;
    });
}

function fetchTransitions(defId) {
    return (0, _http.httpGET)(API_URL + '/' + defId + '/transitions').then(function (res) {
        return res.data;
    });
}

function addTransition(defId, stageId) {
    return (0, _http.httpPOST)(API_URL + '/' + defId + '/transitions', { id: null, title: 'New Transition', type: 'delivery.ManualTransition', fromStageId: stageId }).then(function (res) {
        return res.data;
    });
}

function updateTransition(id, stageId, title) {
    return (0, _http.httpPUT)(API_URL + '/' + id, {
        id: id,
        title: title,
        type: 'delivery.ManualTransition',
        fromStageId: stageId
    }).then(function (res) {
        return res.data;
    });
}

function deleteTransition(transitionId) {
    return (0, _http.httpDELETE)(API_URL + '/' + transitionId);
}

function checkTitle(id, title) {
    return (0, _http.httpPOST)(API_URL + '/checkTitle', { id: id, title: title }).then(function (res) {
        return res.data;
    });
}

/***/ }),

/***/ 275:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var COMPOSITE_FILTER_TYPE = exports.COMPOSITE_FILTER_TYPE = 'xlrelease.CompositeFilter';
var DATE_FILTER_TYPE = exports.DATE_FILTER_TYPE = 'xlrelease.DateFilter';
var FOLDER_FILTER_TYPE = exports.FOLDER_FILTER_TYPE = 'xlrelease.FolderFilter';
var TAG_FILTER_TYPE = exports.TAG_FILTER_TYPE = 'xlrelease.TagsFilter';
var TEMPLATE_FILTER_TYPE = exports.TEMPLATE_FILTER_TYPE = 'xlrelease.TemplateFilter';
var RELEASE_FILTER_TYPE = exports.RELEASE_FILTER_TYPE = 'xlrelease.ReleaseFilter';
var CHANGE_NUMBER_FILTER_TYPE = exports.CHANGE_NUMBER_FILTER_TYPE = 'xlrelease.ChangeNumbersFilter';
var APPLICATION_NAME_FILTER_TYPE = exports.APPLICATION_NAME_FILTER_TYPE = 'xlrelease.ApplicationNamesFilter';
var ENVIRONMENT_NAME_FILTER_TYPE = exports.ENVIRONMENT_NAME_FILTER_TYPE = 'xlrelease.EnvironmentNamesFilter';

var ENTITY_ID_PLACEHOLDER = exports.ENTITY_ID_PLACEHOLDER = "-1";

var DEFAULT_TIME_PERIOD = exports.DEFAULT_TIME_PERIOD = 'LAST_SIX_MONTHS';

/***/ }),

/***/ 276:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var DATE_FILTER_TYPE = exports.DATE_FILTER_TYPE = 'xlrelease.DateFilter';
var FOLDER_FILTER_TYPE = exports.FOLDER_FILTER_TYPE = 'xlrelease.FolderFilter';
var ENVIRONMENT_STAGE_FILTER_TYPE = exports.ENVIRONMENT_STAGE_FILTER_TYPE = 'xlrelease.EnvironmentStageFilter';
var ENVIRONMENT_LABEL_FILTER_TYPE = exports.ENVIRONMENT_LABEL_FILTER_TYPE = 'xlrelease.EnvironmentLabelFilter';
var ENVIRONMENT_FILTER_TYPE = exports.ENVIRONMENT_FILTER_TYPE = 'xlrelease.EnvironmentFilter';
var APPLICATION_FILTER_TYPE = exports.APPLICATION_FILTER_TYPE = 'xlrelease.ApplicationFilter';

var ENTITY_ID_PLACEHOLDER = exports.ENTITY_ID_PLACEHOLDER = "-1";

var DEFAULT_TIME_PERIOD = exports.DEFAULT_TIME_PERIOD = 'LAST_SIX_MONTHS';

var DEPLOYMENT_STATE_ALL = exports.DEPLOYMENT_STATE_ALL = 'all';

var DEPLOYMENT_STATE = exports.DEPLOYMENT_STATE = {
    started: {
        value: 'started',
        className: 'label-active',
        label: 'Started'
    },
    failed: {
        value: 'failed',
        className: 'label-warning-failed',
        label: 'Failed'
    },
    retried: {
        value: 'retried',
        className: 'label-warning-failing',
        label: 'Retried'
    },
    skipped: {
        value: 'skipped',
        className: 'label-default',
        label: 'Skipped'
    },
    aborted: {
        value: 'aborted',
        className: 'label-default',
        label: 'Aborted'
    },
    successful: {
        value: 'completed',
        className: 'label-completed',
        label: 'Successful'
    }
};

/***/ }),

/***/ 2789:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2791:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ButtonWithPopoverComponent = exports.placementList = undefined;

var _defineProperty2 = __webpack_require__(19);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _antd = __webpack_require__(194);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

__webpack_require__(2792);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var placementList = exports.placementList = ['top', 'left', 'right', 'bottom', 'topLeft', 'topRight', 'bottomLeft', 'bottomRight', 'leftTop', 'leftBottom', 'rightTop', 'rightBottom'];

var ButtonWithPopoverComponent = exports.ButtonWithPopoverComponent = function (_Component) {
    (0, _inherits3.default)(ButtonWithPopoverComponent, _Component);

    function ButtonWithPopoverComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, ButtonWithPopoverComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = ButtonWithPopoverComponent.__proto__ || (0, _getPrototypeOf2.default)(ButtonWithPopoverComponent)).call.apply(_ref, [this].concat(args))), _this), _this.handleClick = function (e) {
            var _this$props = _this.props,
                isDisabled = _this$props.isDisabled,
                onActionClick = _this$props.onActionClick;

            if (!isDisabled) {
                onActionClick(e);
            }
        }, _this.renderPopoverContent = function () {
            var content = _this.props.content;

            return _react2.default.createElement(
                'div',
                { className: 'bwp-message' },
                content
            );
        }, _this.renderLink = function () {
            var _this$props2 = _this.props,
                isDisabled = _this$props2.isDisabled,
                label = _this$props2.label,
                buttonClassName = _this$props2.buttonClassName;

            return _react2.default.createElement(
                'span',
                { className: (0, _classnames2.default)('link', (0, _defineProperty3.default)({}, '' + buttonClassName, buttonClassName), { 'disabled': isDisabled }),
                    onClick: _this.handleClick },
                label
            );
        }, _this.renderButton = function () {
            var _this$props3 = _this.props,
                isDisabled = _this$props3.isDisabled,
                label = _this$props3.label,
                buttonClassName = _this$props3.buttonClassName;

            return _react2.default.createElement(
                'button',
                { className: (0, _classnames2.default)('button', (0, _defineProperty3.default)({}, '' + buttonClassName, buttonClassName)), disabled: isDisabled,
                    onClick: _this.handleClick },
                label
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(ButtonWithPopoverComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                isTooltipVisible = _props.isTooltipVisible,
                placement = _props.placement,
                showAsLink = _props.showAsLink;

            var buttonTemplate = _react2.default.createElement(
                'span',
                { className: (0, _classnames2.default)('bwp-button') },
                showAsLink ? this.renderLink() : this.renderButton()
            );

            return isTooltipVisible ? _react2.default.createElement(
                _antd.Popover,
                { content: this.renderPopoverContent(),
                    mouseEnterDelay: 1, mouseLeaveDelay: 0,
                    overlayClassName: 'button-with-popover', placement: placement },
                buttonTemplate
            ) : buttonTemplate;
        }
    }]);
    return ButtonWithPopoverComponent;
}(_react.Component);

ButtonWithPopoverComponent.propTypes = {
    buttonClassName: _propTypes2.default.string,
    content: _propTypes2.default.string.isRequired,
    isDisabled: _propTypes2.default.bool.isRequired,
    isTooltipVisible: _propTypes2.default.bool.isRequired,
    label: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.element]).isRequired,
    onActionClick: _propTypes2.default.func.isRequired,
    placement: _propTypes2.default.oneOf(placementList).isRequired,
    showAsLink: _propTypes2.default.bool
};

/***/ }),

/***/ 2792:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2794:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InfiniteListHeaderComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _constants = __webpack_require__(877);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

var _checkbox = __webpack_require__(2795);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var InfiniteListHeaderComponent = exports.InfiniteListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(InfiniteListHeaderComponent, _Component);

    function InfiniteListHeaderComponent() {
        (0, _classCallCheck3.default)(this, InfiniteListHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (InfiniteListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(InfiniteListHeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(InfiniteListHeaderComponent, [{
        key: 'getNextDirection',
        value: function getNextDirection(propertyName) {
            var orderBy = this.props.orderBy;

            if (orderBy.propertyName !== propertyName) {
                return _constants.OrderConst.SORT_DESC;
            } else {
                return orderBy.direction === _constants.OrderConst.SORT_DESC ? _constants.OrderConst.SORT_ASC : _constants.OrderConst.SORT_DESC;
            }
        }
    }, {
        key: 'onChangeOrder',
        value: function onChangeOrder(column) {
            this.props.onChangeOrder(column.propertyName, this.getNextDirection(column.propertyName));
        }
    }, {
        key: 'renderOrderIcon',
        value: function renderOrderIcon() {
            var orderBy = this.props.orderBy;

            var orderedColumnClassNames = (0, _classnames2.default)('xl-icon icon-s', {
                'arrow-up-icon': orderBy.direction === _constants.OrderConst.SORT_ASC,
                'arrow-down-icon': orderBy.direction === _constants.OrderConst.SORT_DESC
            });

            return _react2.default.createElement(
                'div',
                { className: 'order-icons' },
                _react2.default.createElement('i', { className: orderedColumnClassNames })
            );
        }
    }, {
        key: 'renderDefaultIcon',
        value: function renderDefaultIcon() {
            return _react2.default.createElement(
                'div',
                { className: 'order-icons order-default' },
                _react2.default.createElement('i', { className: 'xl-icon icon-s arrow-up-icon' }),
                _react2.default.createElement('i', { className: 'xl-icon icon-s arrow-down-icon' })
            );
        }
    }, {
        key: 'renderHeaderCell',
        value: function renderHeaderCell(column) {
            var _this2 = this;

            var orderBy = this.props.orderBy;


            return _react2.default.createElement(
                'div',
                {
                    key: column.propertyName,
                    className: (0, _classnames2.default)('list-row-cell ' + column.class, { 'sortable': column.sortable }),
                    onClick: function onClick() {
                        return column.sortable && _this2.onChangeOrder(column);
                    } },
                column.label,
                column.sortable && orderBy && (column.propertyName === orderBy.propertyName ? this.renderOrderIcon() : this.renderDefaultIcon())
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            var _props = this.props,
                columns = _props.columns,
                toggleSelectAll = _props.toggleSelectAll,
                rows = _props.rows,
                selectedRows = _props.selectedRows;

            return _react2.default.createElement(
                'div',
                { className: 'list-header' },
                _react2.default.createElement(_checkbox.Checkbox, {
                    onChange: toggleSelectAll,
                    checked: rows.length === selectedRows.length,
                    isIndeterminate: selectedRows.length > 0 && selectedRows.length < rows.length
                }),
                columns.map(function (column) {
                    return _this3.renderHeaderCell(column);
                })
            );
        }
    }]);
    return InfiniteListHeaderComponent;
}(_react.Component);

InfiniteListHeaderComponent.propTypes = {
    columns: _propTypes2.default.arrayOf(_constants.Column).isRequired,
    selectedRows: _propTypes2.default.arrayOf(_propTypes2.default.string).isRequired,
    rows: _propTypes2.default.arrayOf(_propTypes2.default.any).isRequired,
    onChangeOrder: _propTypes2.default.func.isRequired,
    orderBy: _constants.OrderBy,
    toggleSelectAll: _propTypes2.default.func.isRequired
};

/***/ }),

/***/ 2795:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Checkbox = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Checkbox = exports.Checkbox = function (_Component) {
    (0, _inherits3.default)(Checkbox, _Component);

    function Checkbox(props) {
        (0, _classCallCheck3.default)(this, Checkbox);

        var _this = (0, _possibleConstructorReturn3.default)(this, (Checkbox.__proto__ || (0, _getPrototypeOf2.default)(Checkbox)).call(this, props));

        _this.checkboxRef = _react2.default.createRef();
        return _this;
    }

    (0, _createClass3.default)(Checkbox, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.updateIndeterminateFlag();
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate(prevProps) {
            if (prevProps.isIndeterminate !== this.props.isIndeterminate) {
                this.updateIndeterminateFlag();
            }
        }
    }, {
        key: 'updateIndeterminateFlag',
        value: function updateIndeterminateFlag() {
            this.checkboxRef.current.indeterminate = this.props.isIndeterminate;
        }
    }, {
        key: 'render',
        value: function render() {
            return _react2.default.createElement('input', (0, _extends3.default)({}, _.omit(this.props, 'isIndeterminate'), { type: 'checkbox', ref: this.checkboxRef }));
        }
    }]);
    return Checkbox;
}(_react.Component);

Checkbox.propTypes = {
    isIndeterminate: _propTypes2.default.bool
};
Checkbox.defaultProps = {
    isIndeterminate: false
};

/***/ }),

/***/ 2796:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.InfiniteListBodyComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _debounce = __webpack_require__(148);

var _debounce2 = _interopRequireDefault(_debounce);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var InfiniteListBodyComponent = exports.InfiniteListBodyComponent = function (_Component) {
    (0, _inherits3.default)(InfiniteListBodyComponent, _Component);

    function InfiniteListBodyComponent(props) {
        (0, _classCallCheck3.default)(this, InfiniteListBodyComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (InfiniteListBodyComponent.__proto__ || (0, _getPrototypeOf2.default)(InfiniteListBodyComponent)).call(this, props));

        _this.loadMore = function () {
            var rowsRef = _this.rowsRef.current;
            if (rowsRef.scrollTop + rowsRef.clientHeight >= rowsRef.scrollHeight) {
                _this.debouncedLoadMore();
            }
        };

        _this.debouncedLoadMore = (0, _debounce2.default)(_this.props.loadMore, 500);

        _this.rowsRef = _react2.default.createRef();
        return _this;
    }

    (0, _createClass3.default)(InfiniteListBodyComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.rowsRef.current.addEventListener('scroll', this.loadMore);
            this.loadMore();
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            this.rowsRef.current.removeEventListener('scroll', this.loadMore);
        }

        // TODO this should be debounced on saga, need to update first REL-9148

    }, {
        key: 'renderRow',
        value: function renderRow(row) {
            var _this2 = this;

            return _react2.default.createElement(
                'span',
                { className: 'list-row-view-container', key: row.id },
                _react2.default.createElement('input', {
                    checked: this.props.selectedRows.includes(row.id),
                    type: 'checkbox',
                    onChange: function onChange() {
                        return _this2.props.toggleSelectedRows([row]);
                    }
                }),
                this.props.renderRow(row)
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            var _props = this.props,
                rows = _props.rows,
                onScrollList = _props.onScrollList;

            return _react2.default.createElement(
                'div',
                { className: 'list-view-rows', ref: this.rowsRef, onScroll: onScrollList },
                rows.map(function (row) {
                    return _this3.renderRow(row);
                })
            );
        }
    }]);
    return InfiniteListBodyComponent;
}(_react.Component);

InfiniteListBodyComponent.propTypes = {
    rows: _propTypes2.default.arrayOf(_propTypes2.default.any).isRequired,
    selectedRows: _propTypes2.default.arrayOf(_propTypes2.default.string).isRequired,
    renderRow: _propTypes2.default.func.isRequired,
    loadMore: _propTypes2.default.func.isRequired,
    toggleSelectedRows: _propTypes2.default.func.isRequired,
    onScrollList: _propTypes2.default.func
};

/***/ }),

/***/ 2797:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2799:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ContextMenuComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _antd = __webpack_require__(194);

var _lodash = __webpack_require__(62);

__webpack_require__(2800);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContextMenuComponent = exports.ContextMenuComponent = function (_Component) {
    (0, _inherits3.default)(ContextMenuComponent, _Component);

    function ContextMenuComponent() {
        (0, _classCallCheck3.default)(this, ContextMenuComponent);
        return (0, _possibleConstructorReturn3.default)(this, (ContextMenuComponent.__proto__ || (0, _getPrototypeOf2.default)(ContextMenuComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(ContextMenuComponent, [{
        key: 'renderMenuContent',
        value: function renderMenuContent(menuOptions) {
            return menuOptions.map(function (item, index) {
                return (0, _lodash.isUndefined)(item.isVisible) || !!item.isVisible ? !!item.isDisabled ? _react2.default.createElement(
                    'a',
                    { className: 'link-disabled', key: 'menu-item-' + index },
                    item.label
                ) : _react2.default.createElement(
                    'a',
                    { key: 'menu-item-' + index, onClick: item.handler },
                    item.label
                ) : false;
            });
        }
    }, {
        key: 'renderMenu',
        value: function renderMenu(stageMenuOptions, menuWrapperClassName, menuName) {
            return _react2.default.createElement(
                'span',
                { className: menuWrapperClassName },
                _react2.default.createElement(
                    _antd.Popover,
                    {
                        arrowPointAtCenter: true,
                        content: this.renderMenuContent(stageMenuOptions),
                        overlayClassName: 'context-menu-popover',
                        placement: 'bottomRight',
                        trigger: 'click' },
                    _react2.default.createElement('i', { className: 'xl-icon options-icon icon-l context-menu-btn', 'data-cy': 'popup-' + menuName })
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                menuName = _props.menuName,
                menuOptions = _props.menuOptions,
                menuWrapperClassName = _props.menuWrapperClassName;


            return this.renderMenu(menuOptions, menuWrapperClassName, menuName);
        }
    }]);
    return ContextMenuComponent;
}(_react.Component);

ContextMenuComponent.propTypes = {
    menuName: _propTypes2.default.string,
    menuOptions: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        label: _propTypes2.default.string,
        handler: _propTypes2.default.func,
        isDisabled: _propTypes2.default.bool,
        isVisible: _propTypes2.default.bool
    })),
    menuWrapperClassName: _propTypes2.default.any
};
ContextMenuComponent.defaultProps = {
    menuName: '',
    menuOptions: [],
    menuWrapperClassName: ''
};

/***/ }),

/***/ 2800:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2802:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DocLinkComponent = undefined;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DocLinkComponent = exports.DocLinkComponent = function DocLinkComponent(_ref) {
    var section = _ref.section;
    return _react2.default.createElement('a', { title: 'Open documentation page related to this page in a new browser tab', className: 'xl-icon qmark-icon doc-icon',
        href: 'https://docs.xebialabs.com/xl-release/help/' + section, target: '_blank', rel: 'noopener noreferrer' });
};

DocLinkComponent.propTypes = {
    section: _propTypes2.default.string.isRequired
};

/***/ }),

/***/ 2803:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _colors = __webpack_require__(101);

var _colors2 = _interopRequireDefault(_colors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EditableLabel = function (_React$Component) {
    (0, _inherits3.default)(EditableLabel, _React$Component);

    function EditableLabel(props) {
        (0, _classCallCheck3.default)(this, EditableLabel);

        var _this = (0, _possibleConstructorReturn3.default)(this, (EditableLabel.__proto__ || (0, _getPrototypeOf2.default)(EditableLabel)).call(this, props));

        _this._handleFocus = function () {
            var _this$props = _this.props,
                disabled = _this$props.disabled,
                onFocus = _this$props.onFocus,
                onFocusOut = _this$props.onFocusOut;

            if (!disabled) {
                var _this$state = _this.state,
                    isEditing = _this$state.isEditing,
                    text = _this$state.text;

                if (isEditing) {
                    if (text && text.length > 0) {
                        /* eslint-disable angular/typecheck-function */
                        if (typeof onFocusOut === 'function') {
                            onFocusOut(text, _this.rollback.bind(_this));
                        }
                        /* eslint-enable */
                    }
                } else {
                    /* eslint-disable angular/typecheck-function */
                    if (typeof onFocus === 'function') {
                        onFocus(text);
                    }
                    /* eslint-enable */
                }

                if (text && text.length > 0) {
                    _this.setState({
                        lastSaved: text,
                        isEditing: !isEditing
                    });
                }
            }
        };

        _this._selectValue = function (e) {
            e.target.select();
        };

        _this._handleChange = function (ev) {
            _this.setState({
                text: ev.target.value
            });
            _this.checkForValidation(ev.target.value);
        };

        _this._handleKeyDown = function (e) {
            switch (e.key) {
                case 'Enter':
                    _this._handleChange(e);
                    _this._handleFocus(e);
                    break;
                case 'Escape':
                    _this.setState({
                        text: _this.state.lastSaved,
                        isEditing: false
                    });
                    break;
            }
        };

        _this.state = {
            isEditing: _this.props.isEditing || false,
            text: _this.props.text || "",
            lastSaved: _this.props.text,
            validationResult: { valid: true }
        };
        return _this;
    }

    (0, _createClass3.default)(EditableLabel, [{
        key: 'rollback',
        value: function rollback() {
            this.setState({
                text: this.state.lastSaved
            });
            this.checkForValidation(this.state.lastSaved);
        }
    }, {
        key: 'checkForValidation',
        value: function checkForValidation(value) {
            if (this.props.validators) {
                var isValid = function isValid(_ref) {
                    var message = _ref.message;
                    return message.type !== 'ERROR';
                };

                var validationToShow = this.props.validators.map(function (validator) {
                    return validator(value.trim());
                }).find(function (result) {
                    return result.condition;
                });

                var validationResult = validationToShow && validationToShow.condition ? {
                    message: (0, _extends3.default)({}, validationToShow.message),
                    valid: isValid(validationToShow)
                } : { valid: true };
                this.setState({ validationResult: validationResult });
                this.props.onValidityChange(validationResult.valid);
            }
        }
    }, {
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                null,
                this.state.isEditing ? _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement('input', { autoFocus: true,
                        className: this.props.inputClassName + ' ' + (this.state.validationResult.valid ? '' : 'input-field-error'),
                        maxLength: this.props.inputMaxLength,
                        onBlur: this._handleFocus,
                        onChange: this._handleChange,
                        onFocus: this._selectValue,
                        onKeyDown: this._handleKeyDown,
                        placeholder: this.props.inputPlaceHolder,
                        style: {
                            width: this.props.inputWidth,
                            height: '30px',
                            fontSize: this.props.inputFontSize,
                            fontWeight: this.props.inputFontWeight,
                            borderWidth: this.props.inputBorderWidth,
                            borderColor: this.props.required && this.state.text.length === 0 ? _colors2.default.red : 'none'
                        },
                        tabIndex: this.props.inputTabIndex,
                        type: 'text',
                        value: this.state.text }),
                    this.state.validationResult.valid ? _react2.default.createElement('span', null) : _react2.default.createElement(
                        'span',
                        { className: 'validation-' + this.state.validationResult.message.type.toLowerCase() },
                        this.state.validationResult.message.text
                    )
                ) : _react2.default.createElement(
                    'label',
                    { className: this.props.labelClassName,
                        onClick: this._handleFocus,
                        style: {
                            fontSize: this.props.labelFontSize,
                            fontWeight: this.props.labelFontWeight,
                            height: '30px'
                        },
                        title: this.state.text },
                    this.state.text
                )
            );
        }
    }]);
    return EditableLabel;
}(_react2.default.Component);

EditableLabel.propTypes = {
    disabled: _propTypes2.default.bool,
    inputBorderWidth: _propTypes2.default.string,
    inputClassName: _propTypes2.default.string,
    inputFontSize: _propTypes2.default.string,
    inputFontWeight: _propTypes2.default.string,
    inputHeight: _propTypes2.default.string,
    inputMaxLength: _propTypes2.default.number,
    inputPlaceHolder: _propTypes2.default.string,
    inputTabIndex: _propTypes2.default.number,
    inputWidth: _propTypes2.default.string,
    isEditing: _propTypes2.default.bool,
    labelClassName: _propTypes2.default.string,
    labelFontSize: _propTypes2.default.string,
    labelFontWeight: _propTypes2.default.string,
    onFocus: _propTypes2.default.func,
    onFocusOut: _propTypes2.default.func,
    onValidityChange: _propTypes2.default.func,
    required: _propTypes2.default.bool,
    text: _propTypes2.default.string.isRequired,
    validators: _propTypes2.default.arrayOf(_propTypes2.default.func)
};
exports.default = EditableLabel;

/***/ }),

/***/ 2804:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _environmentListItemComponent = __webpack_require__(2805);

var _environmentListItemComponent2 = _interopRequireDefault(_environmentListItemComponent);

var _components = __webpack_require__(67);

__webpack_require__(318);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var helpMessage = 'Use Environments to define environments that are available in your organization. You can also use Environments to filter the environment scheduler and dashboards.';

var EnvironmentListComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentListComponent, _Component);

    function EnvironmentListComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, EnvironmentListComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = EnvironmentListComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListComponent)).call.apply(_ref, [this].concat(args))), _this), _this.renderHeader = function () {
            return _react2.default.createElement(
                'div',
                { className: 'application-list-header' },
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-7' },
                    'Name'
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-2' },
                    'Stage'
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'col-xs-3' },
                    _react2.default.createElement(
                        'span',
                        { className: 'pull-right action-section' },
                        'Actions'
                    )
                )
            );
        }, _this.renderEnvironmentList = function () {
            var _this$props = _this.props,
                environments = _this$props.environments,
                onEditEnvironment = _this$props.onEditEnvironment,
                onDeleteEnvironment = _this$props.onDeleteEnvironment;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _this.renderHeader(),
                environments.map(function (environment) {
                    return _react2.default.createElement(_environmentListItemComponent2.default, { environment: environment, key: environment.title,
                        onDeleteEnvironment: onDeleteEnvironment, onEditEnvironment: onEditEnvironment });
                })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(EnvironmentListComponent, [{
        key: 'render',
        value: function render() {
            var environments = this.props.environments;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title' },
                    'Environments (',
                    environments.length,
                    ')'
                ),
                _react2.default.createElement(
                    _components.HelpBlock,
                    { className: 'help-message-container' },
                    helpMessage
                ),
                environments.length ? this.renderEnvironmentList() : _react2.default.createElement(_components.NoData, { message: 'No environments found.' })
            );
        }
    }]);
    return EnvironmentListComponent;
}(_react.Component);

EnvironmentListComponent.propTypes = {
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    }).isRequired).isRequired,
    onDeleteEnvironment: _propTypes2.default.func.isRequired,
    onEditEnvironment: _propTypes2.default.func.isRequired
};
exports.default = EnvironmentListComponent;

/***/ }),

/***/ 2805:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

var _labelItem = __webpack_require__(383);

var _labelItem2 = _interopRequireDefault(_labelItem);

var _types = __webpack_require__(112);

__webpack_require__(2808);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentListItemComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentListItemComponent, _Component);

    function EnvironmentListItemComponent(props) {
        (0, _classCallCheck3.default)(this, EnvironmentListItemComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (EnvironmentListItemComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListItemComponent)).call(this, props));

        _this.onEditEnvironment = function (event) {
            event.stopPropagation();
            _this.props.onEditEnvironment(_this.props.environment);
        };

        _this.onDeleteEnvironment = function (event) {
            event.stopPropagation();
            _this.props.onDeleteEnvironment(_this.props.environment);
        };

        _this.renderEnvironmentTitle = function () {
            var environment = _this.props.environment;


            return _react2.default.createElement(
                'div',
                { className: 'environment-title-container' },
                _react2.default.createElement(
                    'div',
                    { className: 'col-xs-7 environment-title', title: environment.title },
                    _react2.default.createElement('i', { className: 'xl-icon environment-icon' }),
                    _react2.default.createElement(
                        'strong',
                        null,
                        environment.title
                    )
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-2' },
                    environment.stage.title
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'actions-container col-xs-3' },
                    _react2.default.createElement(
                        'div',
                        { className: 'actions pull-right' },
                        _react2.default.createElement(
                            'span',
                            { className: 'link color-inherited', 'data-test': 'edit-action', onClick: _this.onEditEnvironment },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon edit-icon', title: 'Edit' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Edit'
                            )
                        ),
                        _react2.default.createElement(
                            'span',
                            { className: 'link delete', 'data-test': 'delete-action', onClick: _this.onDeleteEnvironment },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon delete-icon', title: 'Delete' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Delete'
                            )
                        )
                    )
                )
            );
        };

        _this.renderEnvironmentLabels = function () {
            var labels = _this.props.environment.labels;

            if (!labels.length) {
                return null;
            }
            return _react2.default.createElement(
                'div',
                { className: 'environment-labels' },
                labels.map(function (type) {
                    return _react2.default.createElement(_labelItem2.default, { envLabel: type, key: type.id });
                })
            );
        };

        _this.state = { isSelected: false };
        return _this;
    }

    (0, _createClass3.default)(EnvironmentListItemComponent, [{
        key: 'render',
        value: function render() {
            var environment = this.props.environment;
            var isSelected = this.state.isSelected;


            var panelClass = (0, _classnames2.default)('panel', 'panel-default', 'environment-panel', { 'panel-hover': isSelected });

            return _react2.default.createElement(
                'div',
                { className: panelClass, onClick: this.onEditEnvironment },
                this.renderEnvironmentTitle(),
                (environment.description || !!environment.labels.length) && _react2.default.createElement('div', { className: 'environment-title-separator' }),
                environment.description && _react2.default.createElement(
                    'div',
                    { className: 'environment-description' },
                    environment.description
                ),
                this.renderEnvironmentLabels()
            );
        }
    }]);
    return EnvironmentListItemComponent;
}(_react.Component);

EnvironmentListItemComponent.propTypes = {
    environment: _types.Environment.isRequired,
    onDeleteEnvironment: _propTypes2.default.func.isRequired,
    onEditEnvironment: _propTypes2.default.func.isRequired
};
exports.default = EnvironmentListItemComponent;

/***/ }),

/***/ 2806:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2808:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2811:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getFilteredEnvironments = undefined;

var _reselect = __webpack_require__(751);

var getEnvironments = function getEnvironments(state) {
    return state.environmentList.list;
};
var getEnvironmentFilters = function getEnvironmentFilters(state) {
    return state.environmentList.filters;
};

var getFilteredEnvironments = exports.getFilteredEnvironments = (0, _reselect.createSelector)([getEnvironments, getEnvironmentFilters], function (environments, filters) {
    var title = filters.title,
        stage = filters.stage;

    return environments.filter(function (env) {
        return env.title.toUpperCase().indexOf(title.toUpperCase()) >= 0 && (!stage.title || env.stage.title.toUpperCase() === stage.title.toUpperCase());
    });
});

/***/ }),

/***/ 2816:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2819:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _environmentManagementStore = __webpack_require__(269);

var _environmentEditPageContainer = __webpack_require__(2820);

var _environmentEditPageContainer2 = _interopRequireDefault(_environmentEditPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentEditPage = function (_Component) {
    (0, _inherits3.default)(EnvironmentEditPage, _Component);

    function EnvironmentEditPage() {
        (0, _classCallCheck3.default)(this, EnvironmentEditPage);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentEditPage.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentEditPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentEditPage, [{
        key: 'render',
        value: function render() {
            var environmentId = this.props.environmentId;

            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_environmentEditPageContainer2.default, { environmentId: environmentId })
            );
        }
    }]);
    return EnvironmentEditPage;
}(_react.Component);

EnvironmentEditPage.propTypes = {
    environmentId: _propTypes2.default.string
};
exports.default = EnvironmentEditPage;

/***/ }),

/***/ 2820:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(43);

var _environmentFormActions = __webpack_require__(448);

var _environmentFormContainer = __webpack_require__(2821);

var _environmentFormContainer2 = _interopRequireDefault(_environmentFormContainer);

var _environmentEditHeaderComponent = __webpack_require__(2906);

var _environmentEditHeaderComponent2 = _interopRequireDefault(_environmentEditHeaderComponent);

var _sidebarEnvironmentNavigation = __webpack_require__(462);

var _sidebarEnvironmentNavigation2 = _interopRequireDefault(_sidebarEnvironmentNavigation);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentEditPageContainer = function (_Component) {
    (0, _inherits3.default)(EnvironmentEditPageContainer, _Component);

    function EnvironmentEditPageContainer() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, EnvironmentEditPageContainer);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = EnvironmentEditPageContainer.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentEditPageContainer)).call.apply(_ref, [this].concat(args))), _this), _this.onSave = function () {
            var _this$props = _this.props,
                environmentModel = _this$props.environmentModel,
                onFormSave = _this$props.onFormSave;

            onFormSave(environmentModel);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(EnvironmentEditPageContainer, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                formIsPristine = _props.formIsPristine,
                formIsValid = _props.formIsValid,
                environmentId = _props.environmentId,
                onFormCancel = _props.onFormCancel;

            var saveEnabled = !formIsPristine && formIsValid;
            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_environmentEditHeaderComponent2.default, {
                    environmentId: environmentId,
                    onCancel: onFormCancel,
                    onSave: this.onSave,
                    saveEnabled: saveEnabled }),
                _react2.default.createElement(
                    _sidebarEnvironmentNavigation2.default,
                    { menuSelected: 'Environments' },
                    _react2.default.createElement(_environmentFormContainer2.default, {
                        environmentId: environmentId })
                )
            );
        }
    }]);
    return EnvironmentEditPageContainer;
}(_react.Component);

EnvironmentEditPageContainer.propTypes = {
    environmentId: _propTypes2.default.string,
    environmentModel: _propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string.isRequired
    }).isRequired,
    formIsPristine: _propTypes2.default.bool.isRequired,
    formIsValid: _propTypes2.default.bool.isRequired,
    onFormCancel: _propTypes2.default.func.isRequired,
    onFormSave: _propTypes2.default.func.isRequired
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        environmentModel: state.environmentForm.environmentModel,
        formIsValid: state.environmentForm.formIsValid,
        formIsPristine: state.environmentForm.formIsPristine
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    onFormCancel: _environmentFormActions.onFormCancel,
    onFormSave: _environmentFormActions.onFormSave
})(EnvironmentEditPageContainer);

/***/ }),

/***/ 2821:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(43);

var _environmentFormActions = __webpack_require__(448);

var _labelActions = __webpack_require__(368);

var _environmentFormComponent = __webpack_require__(2822);

var _environmentFormComponent2 = _interopRequireDefault(_environmentFormComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentFormContainer = function (_Component) {
    (0, _inherits3.default)(EnvironmentFormContainer, _Component);

    function EnvironmentFormContainer() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, EnvironmentFormContainer);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = EnvironmentFormContainer.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentFormContainer)).call.apply(_ref, [this].concat(args))), _this), _this.handleFormChange = function (environment) {
            var onFormChange = _this.props.onFormChange;

            onFormChange(environment);
        }, _this.handleFormPristineChange = function (pristine) {
            var onFormPristineChange = _this.props.onFormPristineChange;

            onFormPristineChange(pristine);
        }, _this.handleFormValidChange = function (valid) {
            var onFormValidChange = _this.props.onFormValidChange;

            onFormValidChange(valid);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(EnvironmentFormContainer, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var initEnvironmentForm = this.props.initEnvironmentForm;

            initEnvironmentForm();
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            var cleanEnvironment = this.props.cleanEnvironment;

            cleanEnvironment();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                stageList = _props.stageList,
                environments = _props.environments,
                environmentModel = _props.environmentModel,
                saveLabel = _props.saveLabel,
                labelList = _props.labelList;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_environmentFormComponent2.default, {
                    environmentModel: environmentModel,
                    environments: environments,
                    labelList: labelList,
                    onFormChange: this.handleFormChange,
                    onPristinityChange: this.handleFormPristineChange,
                    onValidationChange: this.handleFormValidChange,
                    saveLabel: saveLabel,
                    stageList: stageList
                })
            );
        }
    }]);
    return EnvironmentFormContainer;
}(_react.Component);

EnvironmentFormContainer.propTypes = {
    cleanEnvironment: _propTypes2.default.func.isRequired,
    environmentId: _propTypes2.default.string,
    environmentModel: _propTypes2.default.shape({
        stage: _propTypes2.default.shape({
            id: _propTypes2.default.string,
            title: _propTypes2.default.string
        }),
        id: _propTypes2.default.string,
        labels: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            color: _propTypes2.default.string.isRequired,
            id: _propTypes2.default.string.isRequired,
            title: _propTypes2.default.string.isRequired
        })),
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string.isRequired
    }).isRequired,
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    })).isRequired,
    initEnvironmentForm: _propTypes2.default.func.isRequired,
    labelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    onFormChange: _propTypes2.default.func.isRequired,
    onFormPristineChange: _propTypes2.default.func.isRequired,
    onFormValidChange: _propTypes2.default.func.isRequired,
    saveLabel: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    })).isRequired
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        environmentModel: state.environmentForm.environmentModel,
        environments: state.environmentForm.environments,
        stageList: state.stages.stageList,
        labelList: state.labels.labelList
    };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
    return (0, _extends3.default)({}, ownProps, stateProps, dispatchProps, {
        initEnvironmentForm: function initEnvironmentForm() {
            return dispatchProps.initEnvironmentForm(ownProps.environmentId, ownProps.environments);
        }
    });
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    cleanEnvironment: _environmentFormActions.cleanEnvironment,
    initEnvironmentForm: _environmentFormActions.initEnvironmentForm,
    onFormChange: _environmentFormActions.onFormChange,
    onFormPristineChange: _environmentFormActions.onFormPristineChange,
    onFormValidChange: _environmentFormActions.onFormValidChange,
    saveLabel: _labelActions.saveLabel
}, mergeProps)(EnvironmentFormContainer);

/***/ }),

/***/ 2822:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactSidebar = __webpack_require__(384);

var _reactSidebar2 = _interopRequireDefault(_reactSidebar);

var _includes = __webpack_require__(370);

var _includes2 = _interopRequireDefault(_includes);

var _orderBy = __webpack_require__(587);

var _orderBy2 = _interopRequireDefault(_orderBy);

var _xlReactComponents = __webpack_require__(47);

var _lodash = __webpack_require__(62);

var _validators = __webpack_require__(123);

var _sidebarLabelList = __webpack_require__(2823);

var _sidebarLabelList2 = _interopRequireDefault(_sidebarLabelList);

var _widgetLinkedLabels = __webpack_require__(2901);

var _widgetLinkedLabels2 = _interopRequireDefault(_widgetLinkedLabels);

__webpack_require__(318);

__webpack_require__(2904);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var nameFormMetadata = {
    label: 'Name',
    placeholder: 'Add...',
    description: 'Name of the environment',
    required: true
};
var descriptionFormMetadata = {
    label: 'Description',
    placeholder: 'Set description...',
    description: 'Description of the environment',
    size: 'MEDIUM'
};

var selectFormMetadata = {
    description: 'Name of the stage',
    label: 'Stage',
    placeholder: 'Select stage...',
    required: true
};

var findEnvironmentById = function findEnvironmentById(environments, id) {
    return environments.find(function (e) {
        return e.id === id;
    }) || {};
};

var nameValidator = function nameValidator(environments, selectedId) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(environments, selectedId, 'title', name),
            message: (0, _validators.createErrorMessage)('Environment already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var EnvironmentFormComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentFormComponent, _Component);

    function EnvironmentFormComponent(props) {
        (0, _classCallCheck3.default)(this, EnvironmentFormComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (EnvironmentFormComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentFormComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
        };

        _this.onNameChange = function (title) {
            var _this$props = _this.props,
                environmentModel = _this$props.environmentModel,
                onFormChange = _this$props.onFormChange;

            if (title !== environmentModel.title) {
                onFormChange((0, _extends3.default)({}, environmentModel, {
                    title: title
                }));
            }
        };

        _this.onStageChange = function (stage) {
            var _this$props2 = _this.props,
                environmentModel = _this$props2.environmentModel,
                onFormChange = _this$props2.onFormChange;

            if (stage && stage.id !== environmentModel.stage.id) {
                onFormChange((0, _extends3.default)({}, environmentModel, {
                    stage: stage
                }));
            }
        };

        _this.onDescriptionChange = function (description) {
            var _this$props3 = _this.props,
                environmentModel = _this$props3.environmentModel,
                onFormChange = _this$props3.onFormChange;

            if (description !== environmentModel.description) {
                onFormChange((0, _extends3.default)({}, environmentModel, {
                    description: description
                }));
            }
        };

        _this.onAddLabel = function (envLabel) {
            var environmentModel = _this.props.environmentModel;

            var labels = (0, _lodash.clone)(environmentModel.labels);

            if ((0, _lodash.isUndefined)((0, _lodash.find)(environmentModel.labels, function (currentEnvLabel) {
                return currentEnvLabel.id === envLabel.id;
            }))) {
                labels.push(envLabel);
            }

            _this.props.onFormChange((0, _extends3.default)({}, environmentModel, {
                labels: labels
            }));
            _this.props.onPristinityChange(false);
        };

        _this.onRemoveLabel = function (envLabel) {
            var environmentModel = _this.props.environmentModel;

            var labels = (0, _lodash.filter)(environmentModel.labels, function (currentLabelType) {
                return currentLabelType.id !== envLabel.id;
            });

            _this.props.onFormChange((0, _extends3.default)({}, environmentModel, {
                labels: labels
            }));
            _this.props.onPristinityChange(false);
        };

        _this.onNameValidityChange = function (valid) {
            var onValidationChange = _this.props.onValidationChange;


            _this.isNameValid = valid;
            onValidationChange(_this.isFormValid);
        };

        _this.onStageValidityChange = function (valid) {
            var onValidationChange = _this.props.onValidationChange;


            _this.isStageValid = valid;
            onValidationChange(_this.isFormValid);
        };

        _this.onNamePristine = function (pristine) {
            _this.setState({ namePristine: pristine });
            var _this$state = _this.state,
                descriptionPristine = _this$state.descriptionPristine,
                stagePristine = _this$state.stagePristine;

            var isFormPristine = pristine && descriptionPristine && stagePristine;
            _this.props.onPristinityChange(isFormPristine);
        };

        _this.onDescPristine = function (pristine) {
            _this.setState({ descriptionPristine: pristine });
            var _this$state2 = _this.state,
                namePristine = _this$state2.namePristine,
                stagePristine = _this$state2.stagePristine;

            var isFormPristine = pristine && namePristine && stagePristine;
            _this.props.onPristinityChange(isFormPristine);
        };

        _this.onStagePristine = function (pristine) {
            _this.setState({ stagePristine: pristine });
            var _this$state3 = _this.state,
                namePristine = _this$state3.namePristine,
                descriptionPristine = _this$state3.descriptionPristine;

            var isFormPristine = pristine && namePristine && descriptionPristine;
            _this.props.onPristinityChange(isFormPristine);
        };

        _this.renderSidebarContent = function () {
            var _this$props4 = _this.props,
                environmentModel = _this$props4.environmentModel,
                labelList = _this$props4.labelList,
                saveLabel = _this$props4.saveLabel;

            var filteredLabelList = (0, _lodash.differenceWith)(labelList, environmentModel.labels, _lodash.isEqual);

            return _react2.default.createElement(_sidebarLabelList2.default, {
                labelList: filteredLabelList,
                onClickLabel: _this.onAddLabel,
                saveLabel: saveLabel
            });
        };

        _this.state = {
            namePristine: true,
            descriptionPristine: true,
            stagePristine: true
        };

        _this.isNameValid = false;
        _this.isStageValid = false;
        return _this;
    }

    (0, _createClass3.default)(EnvironmentFormComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                environmentModel = _props.environmentModel,
                environments = _props.environments,
                stageList = _props.stageList;

            var env = findEnvironmentById(environments, environmentModel.id);
            var subtitle = (0, _lodash.isEmpty)(env) ? 'New Environment' : env.title;

            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _orderBy2.default)(stageList.filter(function (c) {
                    return (0, _includes2.default)(c.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };

            return _react2.default.createElement(
                _reactSidebar2.default,
                {
                    contentClassName: 'environment-form-content',
                    docked: true,
                    open: true,
                    pullRight: true,
                    shadow: false,
                    sidebar: this.renderSidebarContent(),
                    sidebarClassName: 'environment-form-sidebar',
                    transitions: false },
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title', id: 'environment-form-title' },
                    'Environments / ',
                    subtitle
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'environment-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: nameFormMetadata,
                        model: environmentModel.title,
                        onModelChange: this.onNameChange,
                        onPristinityChange: this.onNamePristine,
                        onValidityChange: this.onNameValidityChange,
                        register: this.onRegister,
                        validators: [nameValidator(environments, environmentModel.id), maxLengthValidator(nameFormMetadata.label, 255)]
                    }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: autocompleteHandlers,
                        metadata: selectFormMetadata,
                        model: environmentModel.stage,
                        objLabel: 'title',
                        onModelChange: this.onStageChange,
                        onPristinityChange: this.onStagePristine,
                        onValidityChange: this.onStageValidityChange
                    }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: descriptionFormMetadata,
                        model: environmentModel.description,
                        onModelChange: this.onDescriptionChange,
                        onPristinityChange: this.onDescPristine,
                        validators: [maxLengthValidator(descriptionFormMetadata.label, 1024)]
                    }),
                    _react2.default.createElement(_widgetLinkedLabels2.default, {
                        labelList: environmentModel.labels,
                        onDelete: this.onRemoveLabel
                    })
                )
            );
        }
    }, {
        key: 'isFormValid',
        get: function get() {
            return this.isNameValid && this.isStageValid;
        }
    }]);
    return EnvironmentFormComponent;
}(_react.Component);

EnvironmentFormComponent.propTypes = {
    environmentModel: _propTypes2.default.shape({
        stage: _propTypes2.default.shape({
            id: _propTypes2.default.string,
            title: _propTypes2.default.string
        }),
        description: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string,
        labels: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            color: _propTypes2.default.string.isRequired,
            id: _propTypes2.default.string.isRequired,
            title: _propTypes2.default.string.isRequired
        }))
    }).isRequired,
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    })).isRequired,
    labelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    onFormChange: _propTypes2.default.func.isRequired,
    onPristinityChange: _propTypes2.default.func.isRequired,
    onValidationChange: _propTypes2.default.func.isRequired,
    saveLabel: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    })).isRequired
};
exports.default = EnvironmentFormComponent;

/***/ }),

/***/ 2823:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _includes = __webpack_require__(370);

var _includes2 = _interopRequireDefault(_includes);

var _labelItem = __webpack_require__(383);

var _labelItem2 = _interopRequireDefault(_labelItem);

var _labelModalFormComponent = __webpack_require__(878);

var _labelModalFormComponent2 = _interopRequireDefault(_labelModalFormComponent);

var _labelListComponent = __webpack_require__(888);

__webpack_require__(2899);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var filterLabelFieldMetadata = { placeholder: 'Filter by label...' };

var SidebarLabelList = function (_Component) {
    (0, _inherits3.default)(SidebarLabelList, _Component);

    function SidebarLabelList(props) {
        (0, _classCallCheck3.default)(this, SidebarLabelList);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SidebarLabelList.__proto__ || (0, _getPrototypeOf2.default)(SidebarLabelList)).call(this, props));

        _this.onNameChange = function (name) {
            _this.setState({ labelFilterText: name });
        };

        _this.filterLabels = function (envLabel) {
            var labelFilterText = _this.state.labelFilterText;

            return (0, _includes2.default)(envLabel.title.toLowerCase(), labelFilterText.toLowerCase());
        };

        _this.showCreateLabelModal = function () {
            _this.setState({
                modalIsOpen: true,
                envLabel: (0, _labelListComponent.initEnvLabelState)()
            });
        };

        _this.onConfirmEditModal = function (envLabel, isCreateAnother) {
            _this.props.saveLabel({ title: envLabel.title, color: envLabel.color });

            _this.setState({
                modalIsOpen: isCreateAnother,
                envLabel: (0, _labelListComponent.initEnvLabelState)()
            });
        };

        _this.onCancelEditModal = function () {
            _this.setState({
                modalIsOpen: false,
                envLabel: (0, _labelListComponent.initEnvLabelState)()
            });
        };

        _this.renderLabels = function () {
            var _this$props = _this.props,
                labelList = _this$props.labelList,
                onClickLabel = _this$props.onClickLabel;

            return labelList.filter(function (envLabel) {
                return _this.filterLabels(envLabel);
            }).map(function (envLabel) {
                return _react2.default.createElement(_labelItem2.default, {
                    envLabel: envLabel,
                    key: envLabel.id,
                    onClickLabel: onClickLabel,
                    skin: 'plus'
                });
            });
        };

        _this.state = {
            envLabel: (0, _labelListComponent.initEnvLabelState)(),
            modalIsOpen: false,
            labelFilterText: ''
        };
        return _this;
    }

    (0, _createClass3.default)(SidebarLabelList, [{
        key: 'render',
        value: function render() {
            var labelList = this.props.labelList;
            var _state = this.state,
                envLabel = _state.envLabel,
                modalIsOpen = _state.modalIsOpen;


            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(
                    'div',
                    { className: 'environment-label-sidebar' },
                    _react2.default.createElement(
                        'div',
                        { className: 'header' },
                        _react2.default.createElement(
                            'h4',
                            { className: 'page-title' },
                            'Labels',
                            _react2.default.createElement(
                                'button',
                                { className: 'button pull-right', onClick: this.showCreateLabelModal, type: 'button' },
                                'New label'
                            )
                        ),
                        _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterLabelFieldMetadata, onUpdate: this.onNameChange })
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'environment-sidebar-label-list' },
                        this.renderLabels()
                    )
                ),
                _react2.default.createElement(_labelModalFormComponent2.default, {
                    envLabelList: labelList,
                    envLabelModel: envLabel,
                    modalIsOpen: modalIsOpen,
                    onModalCancel: this.onCancelEditModal,
                    onModalConfirm: this.onConfirmEditModal })
            );
        }
    }]);
    return SidebarLabelList;
}(_react.Component);

SidebarLabelList.propTypes = {
    labelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    onClickLabel: _propTypes2.default.func.isRequired,
    saveLabel: _propTypes2.default.func.isRequired
};
SidebarLabelList.defaultProps = {
    labelList: {}
};
exports.default = SidebarLabelList;

/***/ }),

/***/ 2898:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _headerComponent = __webpack_require__(271);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

var _xlReactComponents = __webpack_require__(47);

var _reactColor = __webpack_require__(879);

__webpack_require__(385);

__webpack_require__(887);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LabelListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(LabelListHeaderComponent, _Component);

    function LabelListHeaderComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, LabelListHeaderComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = LabelListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(LabelListHeaderComponent)).call.apply(_ref, [this].concat(args))), _this), _this.showCreateModal = function () {
            _this.props.onCreate();
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(LabelListHeaderComponent, [{
        key: 'render',
        value: function render() {
            var onFilterChange = this.props.onFilterChange;

            var filterFieldMetadata = { placeholder: 'Filter by label...' };

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterFieldMetadata, onUpdate: onFilterChange }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: this.showCreateModal },
                            'New label'
                        )
                    )
                )
            );
        }
    }]);
    return LabelListHeaderComponent;
}(_react.Component);

LabelListHeaderComponent.propTypes = {
    onCreate: _propTypes2.default.func.isRequired,
    onFilterChange: _propTypes2.default.func.isRequired
};
exports.default = LabelListHeaderComponent;

/***/ }),

/***/ 2899:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2901:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _labelItem = __webpack_require__(383);

var _labelItem2 = _interopRequireDefault(_labelItem);

var _components = __webpack_require__(67);

var _types = __webpack_require__(112);

__webpack_require__(2902);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var labelsFiledMetadata = {
    label: 'Labels',
    required: false
};

var WidgetLinkedLabels = function (_Component) {
    (0, _inherits3.default)(WidgetLinkedLabels, _Component);

    function WidgetLinkedLabels() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, WidgetLinkedLabels);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = WidgetLinkedLabels.__proto__ || (0, _getPrototypeOf2.default)(WidgetLinkedLabels)).call.apply(_ref, [this].concat(args))), _this), _this.renderEmptyContainer = function () {
            return _react2.default.createElement(
                _components.HelpBlock,
                null,
                'Click a label on the right to assign it to the environment'
            );
        }, _this.renderContainer = function (labelList) {
            var onDelete = _this.props.onDelete;


            return _react2.default.createElement(
                'div',
                { className: 'list-block-label-title' },
                labelList.map(function (envLabel) {
                    return _react2.default.createElement(_labelItem2.default, {
                        envLabel: envLabel,
                        key: envLabel.id,
                        onClickLabel: onDelete,
                        skin: 'remove' });
                })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(WidgetLinkedLabels, [{
        key: 'render',
        value: function render() {
            var labelList = this.props.labelList;


            return _react2.default.createElement(
                'div',
                { className: 'xl-react-components' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: labelsFiledMetadata }),
                _react2.default.createElement(
                    'div',
                    { className: 'xl-react-components-input' },
                    labelList.length ? this.renderContainer(labelList) : this.renderEmptyContainer()
                )
            );
        }
    }]);
    return WidgetLinkedLabels;
}(_react.Component);

WidgetLinkedLabels.propTypes = {
    labelList: _propTypes2.default.arrayOf(_types.Label).isRequired,
    onDelete: _propTypes2.default.func.isRequired
};
WidgetLinkedLabels.defaultProps = {
    labelList: []
};
exports.default = WidgetLinkedLabels;

/***/ }),

/***/ 2902:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2904:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2906:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _isEmpty = __webpack_require__(310);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _headerComponent = __webpack_require__(271);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentEditHeaderComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentEditHeaderComponent, _Component);

    function EnvironmentEditHeaderComponent() {
        (0, _classCallCheck3.default)(this, EnvironmentEditHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentEditHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentEditHeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentEditHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                onCancel = _props.onCancel,
                onSave = _props.onSave,
                saveEnabled = _props.saveEnabled,
                environmentId = _props.environmentId;

            var caption = (0, _isEmpty2.default)(environmentId) ? 'Create' : 'Save';
            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    'div',
                    { className: 'buttons' },
                    _react2.default.createElement(
                        'button',
                        { className: 'button cancel', onClick: onCancel },
                        'Cancel'
                    ),
                    _react2.default.createElement(
                        'button',
                        { className: 'button primary', disabled: !saveEnabled, onClick: onSave },
                        caption
                    )
                )
            );
        }
    }]);
    return EnvironmentEditHeaderComponent;
}(_react.Component);

EnvironmentEditHeaderComponent.propTypes = {
    environmentId: _propTypes2.default.string,
    onCancel: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    saveEnabled: _propTypes2.default.bool.isRequired
};
exports.default = EnvironmentEditHeaderComponent;

/***/ }),

/***/ 2907:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _environmentManagementStore = __webpack_require__(269);

var _applicationListPageContainer = __webpack_require__(2908);

var _applicationListPageContainer2 = _interopRequireDefault(_applicationListPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationListPage = function (_Component) {
    (0, _inherits3.default)(ApplicationListPage, _Component);

    function ApplicationListPage() {
        (0, _classCallCheck3.default)(this, ApplicationListPage);
        return (0, _possibleConstructorReturn3.default)(this, (ApplicationListPage.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(ApplicationListPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_applicationListPageContainer2.default, null)
            );
        }
    }]);
    return ApplicationListPage;
}(_react.Component);

exports.default = ApplicationListPage;

/***/ }),

/***/ 2908:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(43);

var _applicationActions = __webpack_require__(311);

var _applicationListComponent = __webpack_require__(2909);

var _applicationListComponent2 = _interopRequireDefault(_applicationListComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        applications: state.applicationList.applications
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    onAddApplication: _applicationActions.applicationList.goToCreatePage,
    onEditApplication: _applicationActions.applicationList.goToEditPage,
    onDeleteApplication: _applicationActions.applicationList.deleteApplication,
    searchApplications: _applicationActions.applicationList.searchApplications
})(_applicationListComponent2.default);

/***/ }),

/***/ 2909:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _applicationListHeaderComponent = __webpack_require__(2910);

var _applicationListHeaderComponent2 = _interopRequireDefault(_applicationListHeaderComponent);

var _applicationListItemComponent = __webpack_require__(2911);

var _applicationListItemComponent2 = _interopRequireDefault(_applicationListItemComponent);

var _components = __webpack_require__(67);

var _types = __webpack_require__(112);

__webpack_require__(318);

__webpack_require__(2914);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var helpMessage = 'Use Applications to logically group applications and the environments they must be deployed to.';

var ApplicationListComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationListComponent, _Component);

    function ApplicationListComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationListComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationListComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListComponent)).call(this, props));

        _this.onFilterChange = function (appName) {
            _this.props.searchApplications(appName);
        };

        _this.goToEditPage = function (application) {
            _this.props.onEditApplication(application);
        };

        _this.goToNewPage = function () {
            _this.props.onAddApplication();
        };

        _this.showDeleteModal = function (application) {
            _this.setState({ deleteModalIsOpen: true, applicationToDelete: application });
        };

        _this.onCloseDeleteModal = function (action) {
            var applicationToDelete = _this.state.applicationToDelete;

            if (action === 'delete') {
                _this.props.onDeleteApplication(applicationToDelete);
            }
            _this.setState({ deleteModalIsOpen: false });
        };

        _this.renderHeader = function () {
            return _react2.default.createElement(
                'div',
                { className: 'application-list-header' },
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-5' },
                    'Name'
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-5' },
                    'Environment'
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'col-xs-2' },
                    _react2.default.createElement(
                        'span',
                        { className: 'pull-right action-section' },
                        'Actions'
                    )
                )
            );
        };

        _this.state = {
            deleteModalIsOpen: false,
            applicationToDelete: {}
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationListComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.searchApplications('');
        }
    }, {
        key: 'renderDeleteModal',
        value: function renderDeleteModal() {
            var _state = this.state,
                deleteModalIsOpen = _state.deleteModalIsOpen,
                applicationToDelete = _state.applicationToDelete;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, deleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseDeleteModal,
                    show: deleteModalIsOpen,
                    title: 'Delete application' },
                _react2.default.createElement(
                    _components.AlertMessage,
                    { alertType: _components.alertType.WARNING },
                    _react2.default.createElement(
                        'p',
                        null,
                        'Deleting an application can lead to missing data for connected resources on reporting and environment scheduling.'
                    )
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete application ',
                    _react2.default.createElement(
                        'strong',
                        null,
                        applicationToDelete.title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderList',
        value: function renderList() {
            var _this2 = this;

            var applications = this.props.applications;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                this.renderDeleteModal(),
                this.renderHeader(),
                applications.map(function (app) {
                    return _react2.default.createElement(_applicationListItemComponent2.default, { application: app, key: app.id, onDelete: _this2.showDeleteModal, onEdit: _this2.goToEditPage });
                })
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var applications = this.props.applications;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_applicationListHeaderComponent2.default, { onApplicationFilterChange: this.onFilterChange, onCreate: this.goToNewPage }),
                _react2.default.createElement(
                    'div',
                    { className: 'application-list-component' },
                    _react2.default.createElement(
                        'h4',
                        { className: 'page-title' },
                        'Applications (',
                        applications.length,
                        ')'
                    ),
                    _react2.default.createElement(
                        _components.HelpBlock,
                        { className: 'help-message-container' },
                        helpMessage
                    ),
                    applications.length ? this.renderList() : _react2.default.createElement(_components.NoData, { message: 'No applications found.' })
                )
            );
        }
    }]);
    return ApplicationListComponent;
}(_react.Component);

ApplicationListComponent.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application).isRequired,
    onAddApplication: _propTypes2.default.func.isRequired,
    onDeleteApplication: _propTypes2.default.func.isRequired,
    onEditApplication: _propTypes2.default.func.isRequired,
    searchApplications: _propTypes2.default.func.isRequired
};
exports.default = ApplicationListComponent;

/***/ }),

/***/ 2910:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _headerComponent = __webpack_require__(271);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var filterOptions = {
    placeholder: 'Filter by application...'
};

var ApplicationListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationListHeaderComponent, _Component);

    function ApplicationListHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationListHeaderComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListHeaderComponent)).call(this, props));

        _this.onFilterChange = function (filter) {
            _this.props.onApplicationFilterChange(filter);
        };

        _this.onCreate = function () {
            _this.props.onCreate();
        };

        _this.state = {
            createButtonDisabled: false,
            modalIsOpen: false,
            title: ''
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationListHeaderComponent, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'applications.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, onUpdate: this.onFilterChange }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: this.onCreate },
                            'New application'
                        )
                    )
                )
            );
        }
    }]);
    return ApplicationListHeaderComponent;
}(_react.Component);

ApplicationListHeaderComponent.propTypes = {
    onApplicationFilterChange: _propTypes2.default.func.isRequired,
    onCreate: _propTypes2.default.func.isRequired
};
exports.default = ApplicationListHeaderComponent;

/***/ }),

/***/ 2911:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

var _types = __webpack_require__(112);

__webpack_require__(2912);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationListItemComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationListItemComponent, _Component);

    function ApplicationListItemComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationListItemComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationListItemComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListItemComponent)).call(this, props));

        _this.onEditApplication = function (event) {
            event.stopPropagation();

            var _this$props = _this.props,
                application = _this$props.application,
                onEdit = _this$props.onEdit;

            onEdit(application);
        };

        _this.onDeleteApplication = function (event) {
            event.stopPropagation();

            var _this$props2 = _this.props,
                application = _this$props2.application,
                onDelete = _this$props2.onDelete;

            onDelete(application);
        };

        _this.renderLinkedEnvironments = function () {
            var environments = _this.props.application.environments;

            var environmentNames = environments ? environments.map(function (env) {
                return env.title;
            }).join(', ') : [];
            return _react2.default.createElement(
                'div',
                { className: 'application-item-environments col-xs-5' },
                environmentNames.length ? _react2.default.createElement(
                    'span',
                    { title: environmentNames },
                    _react2.default.createElement('i', { className: 'xl-icon environment-icon' }),
                    environmentNames
                ) : 'All environments'
            );
        };

        return _this;
    }

    (0, _createClass3.default)(ApplicationListItemComponent, [{
        key: 'render',
        value: function render() {
            var application = this.props.application;


            var panelClass = (0, _classnames2.default)('panel', 'panel-default', 'application-panel');

            return _react2.default.createElement(
                'div',
                { className: panelClass, onClick: this.onEditApplication },
                _react2.default.createElement(
                    'div',
                    { className: 'application-item-title col-xs-5', title: application.title },
                    _react2.default.createElement('i', { className: 'xl-icon app-icon' }),
                    _react2.default.createElement(
                        'strong',
                        null,
                        application.title
                    )
                ),
                this.renderLinkedEnvironments(),
                _react2.default.createElement(
                    'div',
                    { className: 'actions-container col-xs-2' },
                    _react2.default.createElement(
                        'div',
                        { className: 'actions pull-right' },
                        _react2.default.createElement(
                            'span',
                            { className: 'link color-inherited', 'data-test': 'edit-action', onClick: this.onEditApplication },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon edit-icon', title: 'Edit' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Edit'
                            )
                        ),
                        _react2.default.createElement(
                            'span',
                            { className: 'link delete', 'data-test': 'delete-action', onClick: this.onDeleteApplication },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon delete-icon', title: 'Delete' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Delete'
                            )
                        )
                    )
                )
            );
        }
    }]);
    return ApplicationListItemComponent;
}(_react.Component);

ApplicationListItemComponent.propTypes = {
    application: _types.Application.isRequired,
    onDelete: _propTypes2.default.func.isRequired,
    onEdit: _propTypes2.default.func.isRequired
};
exports.default = ApplicationListItemComponent;

/***/ }),

/***/ 2912:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2914:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2916:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _environmentManagementStore = __webpack_require__(269);

var _applicationEditPageContainer = __webpack_require__(2917);

var _applicationEditPageContainer2 = _interopRequireDefault(_applicationEditPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationEditPage = function (_Component) {
    (0, _inherits3.default)(ApplicationEditPage, _Component);

    function ApplicationEditPage() {
        (0, _classCallCheck3.default)(this, ApplicationEditPage);
        return (0, _possibleConstructorReturn3.default)(this, (ApplicationEditPage.__proto__ || (0, _getPrototypeOf2.default)(ApplicationEditPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(ApplicationEditPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_applicationEditPageContainer2.default, { applicationId: this.props.applicationId })
            );
        }
    }]);
    return ApplicationEditPage;
}(_react.Component);

ApplicationEditPage.propTypes = {
    applicationId: _propTypes2.default.string
};
exports.default = ApplicationEditPage;

/***/ }),

/***/ 2917:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _applicationActions = __webpack_require__(311);

var _applicationEditPageComponent = __webpack_require__(2918);

var _applicationEditPageComponent2 = _interopRequireDefault(_applicationEditPageComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        application: state.applicationForm.application,
        applications: state.applicationForm.applications,
        environments: state.applicationForm.environments,
        stages: state.applicationForm.stages
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    onSaveApplication: _applicationActions.applicationForm.saveApplication,
    initComponent: _applicationActions.applicationForm.initForm,
    onUpdateApplication: _applicationActions.applicationForm.updateModel,
    onFormCancel: _applicationActions.applicationForm.cancelForm,
    onFormPristine: _applicationActions.applicationForm.pristineFormChange
})(_applicationEditPageComponent2.default);

/***/ }),

/***/ 2918:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _toConsumableArray2 = __webpack_require__(52);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactSidebar = __webpack_require__(384);

var _reactSidebar2 = _interopRequireDefault(_reactSidebar);

var _lodash = __webpack_require__(62);

var _applicationEditHeaderComponent = __webpack_require__(2919);

var _applicationEditHeaderComponent2 = _interopRequireDefault(_applicationEditHeaderComponent);

var _applicationFormComponent = __webpack_require__(2920);

var _applicationFormComponent2 = _interopRequireDefault(_applicationFormComponent);

var _types = __webpack_require__(112);

var _sidebarEnvironmentList = __webpack_require__(2930);

var _sidebarEnvironmentList2 = _interopRequireDefault(_sidebarEnvironmentList);

__webpack_require__(2939);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var styleSidebar = {
    root: {
        top: '50px'
    }
};

var ApplicationEditPageComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationEditPageComponent, _Component);
    (0, _createClass3.default)(ApplicationEditPageComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _props = this.props,
                applicationId = _props.applicationId,
                initComponent = _props.initComponent;

            initComponent(applicationId);
        }
    }]);

    function ApplicationEditPageComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationEditPageComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationEditPageComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationEditPageComponent)).call(this, props));

        _this.onSave = function () {
            var application = _this.props.application;

            _this.props.onSaveApplication(application);
        };

        _this.onFormValidChange = function (valid) {
            _this.setState({ formValid: valid });
        };

        _this.onApplicationChange = function (application) {
            _this.props.onUpdateApplication(application);
        };

        _this.onAddEnvironment = function (environment) {
            _this.setState({ formPristine: false });
            var application = _this.props.application;

            var updatedApp = (0, _extends3.default)({}, application, {
                environments: [].concat((0, _toConsumableArray3.default)(application.environments), [environment])
            });
            _this.props.onUpdateApplication(updatedApp);
        };

        _this.onPristinityChange = function (pristine) {
            _this.setState({ formPristine: pristine });
            if (!pristine) {
                _this.props.onFormPristine(pristine);
            }
        };

        _this.renderSidebarContent = function () {
            var _this$props = _this.props,
                application = _this$props.application,
                environments = _this$props.environments,
                stages = _this$props.stages;

            var filteredEnvironments = (0, _lodash.differenceBy)(environments, application.environments, 'id');

            return _react2.default.createElement(_sidebarEnvironmentList2.default, {
                environments: filteredEnvironments,
                onClickEnvironment: _this.onAddEnvironment,
                stages: stages
            });
        };

        _this.state = {
            formValid: false,
            formPristine: true
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationEditPageComponent, [{
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                application = _props2.application,
                applications = _props2.applications,
                onFormCancel = _props2.onFormCancel;
            var _state = this.state,
                formValid = _state.formValid,
                formPristine = _state.formPristine;

            var saveEnabled = !formPristine && formValid;
            var saveButtonCaption = (0, _lodash.isEmpty)(application) ? 'Create' : 'Save';

            return _react2.default.createElement(
                'div',
                { className: 'application-form-view' },
                _react2.default.createElement(_applicationEditHeaderComponent2.default, {
                    onCancel: onFormCancel,
                    onSave: this.onSave,
                    saveCaption: saveButtonCaption,
                    saveEnabled: saveEnabled
                }),
                _react2.default.createElement(
                    _reactSidebar2.default,
                    {
                        contentClassName: 'application-form-content',
                        docked: true,
                        open: true,
                        pullRight: true,
                        shadow: false,
                        sidebar: this.renderSidebarContent(),
                        sidebarClassName: 'application-form-sidebar',
                        styles: styleSidebar,
                        transitions: false },
                    _react2.default.createElement(_applicationFormComponent2.default, {
                        applicationList: applications,
                        applicationModel: application,
                        onFormChange: this.onApplicationChange,
                        onPristinityChange: this.onPristinityChange,
                        onValidationChange: this.onFormValidChange
                    })
                )
            );
        }
    }]);
    return ApplicationEditPageComponent;
}(_react.Component);

ApplicationEditPageComponent.propTypes = {
    application: _types.Application,
    applicationId: _propTypes2.default.string,
    applications: _propTypes2.default.arrayOf(_types.Application),
    environments: _propTypes2.default.arrayOf(_types.Environment),
    initComponent: _propTypes2.default.func.isRequired,
    onFormCancel: _propTypes2.default.func.isRequired,
    onFormPristine: _propTypes2.default.func.isRequired,
    onSaveApplication: _propTypes2.default.func.isRequired,
    onUpdateApplication: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};
ApplicationEditPageComponent.defaultProps = {
    application: {},
    stages: [],
    environments: [],
    applications: []
};
exports.default = ApplicationEditPageComponent;

/***/ }),

/***/ 2919:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _headerComponent = __webpack_require__(271);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationEditHeaderComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationEditHeaderComponent, _Component);

    function ApplicationEditHeaderComponent() {
        (0, _classCallCheck3.default)(this, ApplicationEditHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (ApplicationEditHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationEditHeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(ApplicationEditHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                saveCaption = _props.saveCaption,
                saveEnabled = _props.saveEnabled,
                onSave = _props.onSave,
                onCancel = _props.onCancel;

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'applications.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button cancel', onClick: onCancel },
                            'Cancel'
                        ),
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', disabled: !saveEnabled, onClick: onSave },
                            saveCaption
                        )
                    )
                )
            );
        }
    }]);
    return ApplicationEditHeaderComponent;
}(_react.Component);

ApplicationEditHeaderComponent.propTypes = {
    onCancel: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    saveCaption: _propTypes2.default.string.isRequired,
    saveEnabled: _propTypes2.default.bool.isRequired
};
exports.default = ApplicationEditHeaderComponent;

/***/ }),

/***/ 292:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    DELIVERIES_PRE_LOAD: 'DELIVERIES_PRE_LOAD',
    DELIVERIES_SUCCEEDED: 'DELIVERIES_SUCCEEDED',
    DELIVERIES_FAILED: 'DELIVERIES_FAILED',

    MORE_DELIVERIES_SUCCEEDED: 'MORE_DELIVERIES_SUCCEEDED',
    MORE_DELIVERIES_FAILED: 'MORE_DELIVERIES_FAILED',
    MORE_DELIVERIES_REQUESTED: 'MORE_DELIVERIES_REQUESTED',

    UPDATE_FILTERS_REQUESTED: 'UPDATE_DELIVERIES_FILTERS_REQUESTED',
    UPDATE_FILTERS_SUCCEEDED: 'UPDATE_DELIVERIES_FILTERS_SUCCEEDED',
    UPDATE_FILTERS_FAILED: 'UPDATE_DELIVERIES_FILTERS_FAILED',

    COUNT_DELIVERIES: 'COUNT_DELIVERIES',

    DO_DELETE_DELIVERY: 'DELETE_DELIVERY',

    CONFIRM_DELETE_DELIVERY: 'CONFIRM_DELETE_DELIVERY'
};

var getMoreDeliveries = exports.getMoreDeliveries = function getMoreDeliveries() {
    return { type: actionTypes.MORE_DELIVERIES_REQUESTED };
};
var setFilters = exports.setFilters = function setFilters(filters) {
    var loadDeliveries = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return {
        type: actionTypes.UPDATE_FILTERS_REQUESTED,
        payload: { filters: filters, loadDeliveries: loadDeliveries }
    };
};

var getCount = exports.getCount = function getCount() {
    return { type: actionTypes.COUNT_DELIVERIES };
};
var deleteDelivery = exports.deleteDelivery = function deleteDelivery(id) {
    return { type: actionTypes.DO_DELETE_DELIVERY, payload: id };
};

exports.default = {
    setFilters: setFilters
};

/***/ }),

/***/ 2920:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _isEmpty = __webpack_require__(310);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _widgetLinkedEnvironments = __webpack_require__(2921);

var _widgetLinkedEnvironments2 = _interopRequireDefault(_widgetLinkedEnvironments);

var _validators = __webpack_require__(123);

var _index = __webpack_require__(112);

__webpack_require__(318);

__webpack_require__(2928);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var nameFormMetadata = {
    label: 'Name',
    placeholder: 'Add name...',
    description: 'Name of the application',
    required: true
};
var nameValidator = function nameValidator(applications, selectedId) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(applications, selectedId, 'title', name),
            message: (0, _validators.createErrorMessage)('Application already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var findApplicationById = function findApplicationById(applications, id) {
    return applications.find(function (e) {
        return e.id === id;
    }) || {};
};

var ApplicationFormComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationFormComponent, _Component);

    function ApplicationFormComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationFormComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationFormComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationFormComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
        };

        _this.onNameChange = function (title) {
            var applicationModel = _this.props.applicationModel;

            if (title !== applicationModel.title) {
                _this.props.onFormChange((0, _extends3.default)({}, applicationModel, {
                    title: title
                }));
            }
        };

        _this.onEnvironmentDeleted = function (environment) {
            var applicationModel = _this.props.applicationModel;

            var environments = applicationModel.environments.filter(function (e) {
                return e.id !== environment.id;
            });
            _this.props.onFormChange((0, _extends3.default)({}, applicationModel, {
                environments: environments
            }));
            _this.props.onPristinityChange(false);
        };

        _this.onNameValidityChange = function (valid) {
            _this.props.onValidationChange(valid);
        };

        _this.onNamePristine = function (pristine) {
            _this.props.onPristinityChange(pristine);
        };

        return _this;
    }

    (0, _createClass3.default)(ApplicationFormComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                applicationModel = _props.applicationModel,
                applicationList = _props.applicationList;

            var app = findApplicationById(applicationList, applicationModel.id);
            var subtitle = (0, _isEmpty2.default)(app) ? 'New Application' : app.title;

            return _react2.default.createElement(
                'div',
                { className: 'application-edit-form' },
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title' },
                    'Applications / ',
                    subtitle
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'application-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: nameFormMetadata,
                        model: applicationModel.title,
                        onModelChange: this.onNameChange,
                        onPristinityChange: this.onNamePristine,
                        onValidityChange: this.onNameValidityChange,
                        register: this.onRegister,
                        validators: [nameValidator(applicationList, applicationModel.id), maxLengthValidator(nameFormMetadata.label, 255)]
                    }),
                    _react2.default.createElement(_widgetLinkedEnvironments2.default, { environments: applicationModel.environments, onDelete: this.onEnvironmentDeleted })
                )
            );
        }
    }]);
    return ApplicationFormComponent;
}(_react.Component);

ApplicationFormComponent.propTypes = {
    applicationList: _propTypes2.default.arrayOf(_index.Application).isRequired,
    applicationModel: _index.Application,
    onFormChange: _propTypes2.default.func.isRequired,
    onPristinityChange: _propTypes2.default.func.isRequired,
    onValidationChange: _propTypes2.default.func.isRequired
};
ApplicationFormComponent.defaultProps = {
    applicationModel: {}
};
exports.default = ApplicationFormComponent;

/***/ }),

/***/ 2921:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _listBlock = __webpack_require__(2922);

var _components = __webpack_require__(67);

var _index = __webpack_require__(112);

__webpack_require__(2926);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var environmentsMetadata = {
    label: 'Linked environments',
    required: false
};

var WidgetLinkedEnvironments = function (_Component) {
    (0, _inherits3.default)(WidgetLinkedEnvironments, _Component);

    function WidgetLinkedEnvironments() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, WidgetLinkedEnvironments);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = WidgetLinkedEnvironments.__proto__ || (0, _getPrototypeOf2.default)(WidgetLinkedEnvironments)).call.apply(_ref, [this].concat(args))), _this), _this.onClickDelete = function (environment) {
            _this.props.onDelete(environment);
        }, _this.renderEmptyContainer = function () {
            return _react2.default.createElement(
                _components.HelpBlock,
                null,
                'Click an environment on the right to link it to the application'
            );
        }, _this.renderEnvironmentLinked = function (environment) {
            return _react2.default.createElement(
                _listBlock.ListBlock,
                {
                    childrenClassName: 'list-block-env-title',
                    key: environment.id,
                    onDelete: function onDelete() {
                        return _this.onClickDelete(environment);
                    } },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement('i', { className: 'xl-icon environment-icon mrs' }),
                    _react2.default.createElement(
                        'span',
                        { title: environment.title },
                        environment.title
                    )
                )
            );
        }, _this.renderContainer = function (environments) {
            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                environments.map(function (e) {
                    return _this.renderEnvironmentLinked(e);
                })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(WidgetLinkedEnvironments, [{
        key: 'render',
        value: function render() {
            var environments = this.props.environments;


            return _react2.default.createElement(
                'div',
                { className: 'xl-react-components' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: environmentsMetadata }),
                _react2.default.createElement(
                    'div',
                    { className: 'xl-react-components-input' },
                    environments.length ? this.renderContainer(environments) : this.renderEmptyContainer()
                )
            );
        }
    }]);
    return WidgetLinkedEnvironments;
}(_react.Component);

WidgetLinkedEnvironments.propTypes = {
    environments: _propTypes2.default.arrayOf(_index.Environment),
    onDelete: _propTypes2.default.func.isRequired
};
WidgetLinkedEnvironments.defaultProps = {
    environments: []
};
exports.default = WidgetLinkedEnvironments;

/***/ }),

/***/ 2922:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _listBlock = __webpack_require__(2923);

Object.defineProperty(exports, 'ListBlock', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_listBlock).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 2923:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2924);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ListBlock = function ListBlock(_ref) {
    var children = _ref.children,
        childrenClassName = _ref.childrenClassName,
        listBlockClassName = _ref.listBlockClassName,
        onDelete = _ref.onDelete;
    return _react2.default.createElement(
        'div',
        { className: 'list-block ' + listBlockClassName },
        _react2.default.createElement(
            'div',
            { className: 'list-block-children ' + childrenClassName },
            children
        ),
        _react2.default.createElement('span', { className: 'cross xl-icon close-icon', onClick: onDelete })
    );
};

ListBlock.propTypes = {
    children: _propTypes2.default.element.isRequired,
    childrenClassName: _propTypes2.default.string,
    listBlockClassName: _propTypes2.default.string,
    onDelete: _propTypes2.default.func.isRequired
};

ListBlock.defaultProps = {
    childrenClassName: '',
    listBlockClassName: ''
};

exports.default = ListBlock;

/***/ }),

/***/ 2924:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2926:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2928:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 293:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isAtRisk = isAtRisk;
exports.isAttentionNeeded = isAttentionNeeded;
exports.isOnTrack = isOnTrack;
exports.isCompleted = isCompleted;
exports.getRiskStatus = getRiskStatus;
exports.isPlanItemOverdueMessage = isPlanItemOverdueMessage;
exports.getRiskIconClasses = getRiskIconClasses;

var _releasesStatusService = __webpack_require__(221);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

var _ids = __webpack_require__(110);

var _ids2 = _interopRequireDefault(_ids);

var _constants = __webpack_require__(247);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function isAtRisk(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore >= riskThresholds.atRiskFrom;
}

function isAttentionNeeded(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore >= riskThresholds.attentionNeededFrom && riskScore < riskThresholds.atRiskFrom;
}

function isOnTrack(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore < riskThresholds.attentionNeededFrom;
}

function isCompleted(release) {
    return (0, _releasesStatusService2.default)().hasCompletedStatus(release) || (0, _releasesStatusService2.default)().isReleaseAborted(release);
}

function getRiskStatus(release, riskScore, riskThresholds) {
    if (isAtRisk(release, riskScore, riskThresholds)) {
        return _constants.AT_RISK;
    } else if (isAttentionNeeded(release, riskScore, riskThresholds)) {
        return _constants.ATTENTION_NEEDED;
    } else if (isOnTrack(release, riskScore, riskThresholds)) {
        return _constants.ON_TRACK;
    }
    return _constants.NONE;
}

function isPlanItemOverdueMessage(message) {
    var riskAssessorId = message.riskAssessorId;

    return riskAssessorId && (riskAssessorId === 'Applications/ReleaseDueDateRiskAssessor' || riskAssessorId === 'Applications/TaskDueDateRiskAssessor');
}

function getRiskIconClasses(riskAssessor) {
    if (!riskAssessor.riskAssessorId) {
        return _constants.RISK_ON_TRACK_ICON;
    }

    var id = (0, _ids2.default)().toInternalId(riskAssessor.riskAssessorId).replace('RiskAssessor', '');

    return _constants.RISK_ASSESSOR_ICONS[id];
}

/***/ }),

/***/ 2930:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _includes = __webpack_require__(370);

var _includes2 = _interopRequireDefault(_includes);

var _orderBy = __webpack_require__(587);

var _orderBy2 = _interopRequireDefault(_orderBy);

var _defaults = __webpack_require__(889);

var _defaults2 = _interopRequireDefault(_defaults);

var _environmentSidebarItem = __webpack_require__(890);

var _environmentSidebarItem2 = _interopRequireDefault(_environmentSidebarItem);

var _index = __webpack_require__(112);

__webpack_require__(2937);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var stageMetadata = { label: '', placeholder: 'Filter by stage...' };
var filterOptions = { placeholder: 'Filter environment name...' };

var SidebarEnvironmentList = function (_Component) {
    (0, _inherits3.default)(SidebarEnvironmentList, _Component);

    function SidebarEnvironmentList(props) {
        (0, _classCallCheck3.default)(this, SidebarEnvironmentList);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SidebarEnvironmentList.__proto__ || (0, _getPrototypeOf2.default)(SidebarEnvironmentList)).call(this, props));

        _this.onStageChange = function (stage) {
            _this.setState({ stageSelected: stage });
        };

        _this.onNameChange = function (name) {
            _this.setState({ environmentFilter: name });
        };

        _this.onEnvironmentClick = function (environment) {
            _this.props.onClickEnvironment(environment);
        };

        _this.filterEnvironments = function (environment) {
            var _this$state = _this.state,
                environmentFilter = _this$state.environmentFilter,
                stageSelected = _this$state.stageSelected;

            (0, _defaults2.default)(stageSelected, { title: '' });
            return (0, _includes2.default)(environment.title.toLowerCase(), environmentFilter.toLowerCase()) && (0, _includes2.default)(environment.stage.title.toLowerCase(), stageSelected.title.toLowerCase());
        };

        _this.renderEnvironments = function () {
            var environments = _this.props.environments;

            return environments.filter(function (env) {
                return _this.filterEnvironments(env);
            }).map(function (env) {
                return _react2.default.createElement(_environmentSidebarItem2.default, {
                    environment: env,
                    isClickable: true,
                    key: env.id,
                    onClick: _this.onEnvironmentClick });
            });
        };

        _this.state = {
            stageSelected: {
                title: ''
            },
            environmentFilter: ''
        };
        return _this;
    }

    (0, _createClass3.default)(SidebarEnvironmentList, [{
        key: 'render',
        value: function render() {
            var stages = this.props.stages;
            var stageSelected = this.state.stageSelected;

            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _orderBy2.default)(stages.filter(function (c) {
                    return (0, _includes2.default)(c.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };

            return _react2.default.createElement(
                'div',
                { className: 'application-form-environment-sidebar' },
                _react2.default.createElement(
                    'div',
                    { className: 'header' },
                    _react2.default.createElement(
                        'h4',
                        { className: 'page-title' },
                        'Environments'
                    ),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: autocompleteHandlers,
                        metadata: stageMetadata,
                        model: stageSelected,
                        objLabel: 'title',
                        onModelChange: this.onStageChange
                    }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, onUpdate: this.onNameChange })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'environment-sidebar-list' },
                    this.renderEnvironments()
                )
            );
        }
    }]);
    return SidebarEnvironmentList;
}(_react.Component);

SidebarEnvironmentList.propTypes = {
    environments: _propTypes2.default.arrayOf(_index.Environment),
    onClickEnvironment: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_index.Stage)
};
SidebarEnvironmentList.defaultProps = {
    stages: [],
    environments: []
};
exports.default = SidebarEnvironmentList;

/***/ }),

/***/ 2931:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactDom = __webpack_require__(14);

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _takeRight = __webpack_require__(2932);

var _takeRight2 = _interopRequireDefault(_takeRight);

var _antd = __webpack_require__(194);

var _labelItem = __webpack_require__(383);

var _labelItem2 = _interopRequireDefault(_labelItem);

__webpack_require__(2933);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LabelListTruncated = function (_Component) {
    (0, _inherits3.default)(LabelListTruncated, _Component);

    function LabelListTruncated(props) {
        (0, _classCallCheck3.default)(this, LabelListTruncated);

        var _this = (0, _possibleConstructorReturn3.default)(this, (LabelListTruncated.__proto__ || (0, _getPrototypeOf2.default)(LabelListTruncated)).call(this, props));

        _this.setItemRef = function (el) {
            _this.itemRefs.push(el);
        };

        _this.renderLabelList = function (labels) {
            return labels.map(function (label) {
                return _react2.default.createElement(_labelItem2.default, {
                    envLabel: label,
                    key: label.id,
                    ref: _this.setItemRef,
                    size: 'small' });
            });
        };

        _this.renderPopupContent = function () {
            var labels = _this.props.labels;
            var moreItems = _this.state.moreItems;

            var labelListInPopup = (0, _takeRight2.default)(labels, moreItems);
            return _react2.default.createElement(
                'div',
                { className: 'type-popup-content' },
                _this.renderLabelList(labelListInPopup)
            );
        };

        _this.renderLabelListPopup = function () {
            var moreItems = _this.state.moreItems;


            return !!moreItems && _react2.default.createElement(
                _antd.Popover,
                {
                    arrowPointAtCenter: true,
                    content: _this.renderPopupContent(),
                    overlayClassName: 'type-popup',
                    placement: 'bottomRight',
                    trigger: 'hover' },
                _react2.default.createElement(
                    'div',
                    { className: 'more-labels' },
                    moreItems,
                    ' more...'
                )
            );
        };

        _this.containerRef = _react2.default.createRef();
        _this.itemRefs = [];

        _this.state = {
            moreItems: null
        };
        return _this;
    }

    (0, _createClass3.default)(LabelListTruncated, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            /* eslint-disable react/no-find-dom-node */
            var container = _reactDom2.default.findDOMNode(this.containerRef.current);
            /* eslint-enable react/no-find-dom-node */
            if (container && this.itemRefs.length) {
                var bound = container.getBoundingClientRect();
                var moreItems = this.itemRefs.reduce(function (acc, curr) {
                    /* eslint-disable react/no-find-dom-node */
                    var node = _reactDom2.default.findDOMNode(curr);
                    /* eslint-enable react/no-find-dom-node */
                    if (node) {
                        var rect = node.getBoundingClientRect();
                        if (rect.top - bound.top > bound.height / 2) {
                            return acc + 1;
                        }
                    }
                    return acc;
                }, 0);
                if (moreItems) {
                    /* eslint-disable react/no-did-mount-set-state */
                    this.setState({ moreItems: moreItems });
                    /* eslint-enable react/no-did-mount-set-state */
                }
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var labels = this.props.labels;

            return _react2.default.createElement(
                'div',
                { className: 'label-list', ref: this.containerRef },
                this.renderLabelList(labels),
                this.renderLabelListPopup()
            );
        }
    }]);
    return LabelListTruncated;
}(_react.Component);

LabelListTruncated.propTypes = {
    labels: _propTypes2.default.arrayOf(_propTypes2.default.object)
};
exports.default = LabelListTruncated;

/***/ }),

/***/ 2933:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2935:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2937:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2939:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2941:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _environmentManagementStore = __webpack_require__(269);

var _stageListContainer = __webpack_require__(2942);

var _stageListContainer2 = _interopRequireDefault(_stageListContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var StagePage = function (_Component) {
    (0, _inherits3.default)(StagePage, _Component);

    function StagePage() {
        (0, _classCallCheck3.default)(this, StagePage);
        return (0, _possibleConstructorReturn3.default)(this, (StagePage.__proto__ || (0, _getPrototypeOf2.default)(StagePage)).apply(this, arguments));
    }

    (0, _createClass3.default)(StagePage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_stageListContainer2.default, null)
            );
        }
    }]);
    return StagePage;
}(_react.Component);

exports.default = StagePage;

/***/ }),

/***/ 2942:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(43);

var _stageActions = __webpack_require__(449);

var _stageListComponent = __webpack_require__(2943);

var _stageListComponent2 = _interopRequireDefault(_stageListComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        stageList: state.stages.stageList
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    searchStages: _stageActions.searchStages,
    saveStage: _stageActions.saveStage,
    deleteStage: _stageActions.deleteStage
})(_stageListComponent2.default);

/***/ }),

/***/ 2943:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _includes = __webpack_require__(370);

var _includes2 = _interopRequireDefault(_includes);

var _xlReactComponents = __webpack_require__(47);

var _stageListHeaderComponent = __webpack_require__(2944);

var _stageListHeaderComponent2 = _interopRequireDefault(_stageListHeaderComponent);

var _stageListItemComponent = __webpack_require__(2945);

var _stageListItemComponent2 = _interopRequireDefault(_stageListItemComponent);

var _stageEditModal = __webpack_require__(2948);

var _stageEditModal2 = _interopRequireDefault(_stageEditModal);

var _sidebarEnvironmentNavigation = __webpack_require__(462);

var _sidebarEnvironmentNavigation2 = _interopRequireDefault(_sidebarEnvironmentNavigation);

var _components = __webpack_require__(67);

__webpack_require__(318);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var helpMessage = 'Use Stages to logically group environments. You can also use Stages to filter the environment scheduler and dashboards.';

var StageListComponent = function (_Component) {
    (0, _inherits3.default)(StageListComponent, _Component);

    function StageListComponent(props) {
        (0, _classCallCheck3.default)(this, StageListComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageListComponent.__proto__ || (0, _getPrototypeOf2.default)(StageListComponent)).call(this, props));

        _this.onFilterChange = function (filter) {
            _this.setState({ filter: filter });
        };

        _this.showDeleteModal = function (stage) {
            _this.setState({ deleteModalIsOpen: true, stage: stage });
        };

        _this.showEditModal = function (stage) {
            _this.setState({ editModalIsOpen: true, stage: stage });
        };

        _this.onCloseDeleteModal = function (action) {
            var stage = _this.state.stage;

            if (action === 'delete') {
                _this.props.deleteStage(stage);
            }
            _this.setState({ deleteModalIsOpen: false });
        };

        _this.handleStageSave = function (stage) {
            var saveStage = _this.props.saveStage;


            saveStage(stage);
            _this.setState({ editModalIsOpen: false });
        };

        _this.handleCancel = function () {
            _this.setState({ editModalIsOpen: false });
        };

        _this.renderStage = function (stage) {
            return _react2.default.createElement(_stageListItemComponent2.default, {
                key: stage.id,
                onDelete: _this.showDeleteModal,
                onEdit: _this.showEditModal,
                stage: stage
            });
        };

        _this.state = {
            deleteModalIsOpen: false,
            disabledUpdateButton: true,
            editModalIsOpen: false,
            filter: '',
            stage: {
                id: null,
                title: null
            }
        };
        return _this;
    }

    (0, _createClass3.default)(StageListComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.searchStages();
        }
    }, {
        key: 'renderDeleteModal',
        value: function renderDeleteModal() {
            var _state = this.state,
                deleteModalIsOpen = _state.deleteModalIsOpen,
                stage = _state.stage;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, deleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseDeleteModal,
                    show: deleteModalIsOpen,
                    title: 'Delete stage' },
                _react2.default.createElement(
                    _components.AlertMessage,
                    { alertType: _components.alertType.WARNING },
                    _react2.default.createElement(
                        'p',
                        null,
                        'Deleting a stage can lead to missing data for connected resources on reporting and environment scheduling.'
                    )
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete stage ',
                    _react2.default.createElement(
                        'strong',
                        null,
                        stage.title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderStages',
        value: function renderStages() {
            var stageList = this.props.stageList;
            var filter = this.state.filter;


            var stages = stageList.filter(function (stage) {
                return (0, _includes2.default)(stage.title.toLowerCase(), filter.toLowerCase());
            }).map(this.renderStage);

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title' },
                    'Stages (',
                    stages.length,
                    ')'
                ),
                _react2.default.createElement(
                    _components.HelpBlock,
                    { className: 'help-message-container' },
                    helpMessage
                ),
                stages.length ? stages : _react2.default.createElement(_components.NoData, { className: 'no-stages-message', message: 'No stages found.' })
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                stageList = _props.stageList,
                saveStage = _props.saveStage;
            var _state2 = this.state,
                stage = _state2.stage,
                editModalIsOpen = _state2.editModalIsOpen;


            return _react2.default.createElement(
                'div',
                null,
                this.renderDeleteModal(),
                _react2.default.createElement(_stageEditModal2.default, {
                    isOpened: editModalIsOpen,
                    model: stage,
                    onCancel: this.handleCancel,
                    onSave: this.handleStageSave,
                    stages: stageList
                }),
                _react2.default.createElement(_stageListHeaderComponent2.default, {
                    onFilterChange: this.onFilterChange,
                    onSave: saveStage,
                    stageList: stageList
                }),
                _react2.default.createElement(
                    _sidebarEnvironmentNavigation2.default,
                    { menuSelected: 'Stages' },
                    this.renderStages(stageList)
                )
            );
        }
    }]);
    return StageListComponent;
}(_react.Component);

StageListComponent.propTypes = {
    deleteStage: _propTypes2.default.func.isRequired,
    saveStage: _propTypes2.default.func.isRequired,
    searchStages: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    })).isRequired
};
exports.default = StageListComponent;

/***/ }),

/***/ 2944:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _validators = __webpack_require__(123);

var _headerComponent = __webpack_require__(271);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

__webpack_require__(385);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};
var createButton = {
    action: 'create',
    className: 'button primary',
    keyCodes: [13],
    label: 'Create'
};

var nameOptions = {
    label: 'Name',
    placeholder: 'Add...',
    description: 'Name of the stage',
    required: true
};

var nameValidator = function nameValidator(stageList) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(stageList, null, 'title', name),
            message: (0, _validators.createErrorMessage)('Stage already existing')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var StageListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(StageListHeaderComponent, _Component);

    function StageListHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, StageListHeaderComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(StageListHeaderComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
        };

        _this.onCreate = function () {
            _this.setState({ modalIsOpen: true });
        };

        _this.onClose = function (action) {
            if (action === 'create') {
                _this.props.onSave({ title: _this.state.title });
            }
            _this.setState({ modalIsOpen: false });
        };

        _this.closeModal = function () {
            _this.onClose(cancelButton.action);
        };

        _this.onModelChange = function (title) {
            _this.setState({ title: title });
        };

        _this.onValidityChange = function (valid) {
            _this.setState({ createButtonDisabled: !valid });
        };

        _this.state = {
            createButtonDisabled: false,
            modalIsOpen: false,
            title: ''
        };
        return _this;
    }

    (0, _createClass3.default)(StageListHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                onFilterChange = _props.onFilterChange,
                stageList = _props.stageList;
            var _state = this.state,
                modalIsOpen = _state.modalIsOpen,
                createButtonDisabled = _state.createButtonDisabled;

            var filterOptions = { placeholder: 'Filter by stage...' };
            createButton.disabled = createButtonDisabled;

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'New stage',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.closeModal, type: 'button' },
                    _react2.default.createElement('i', { className: 'xl-icon close-icon' })
                )
            );

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, onUpdate: onFilterChange }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: this.onCreate },
                            'New stage'
                        )
                    ),
                    _react2.default.createElement(
                        _xlReactComponents.XlReactWidgetConfirmationDialog,
                        {
                            buttons: [cancelButton, createButton],
                            dialogClassName: 'xl-default-modal',
                            onButtonClick: this.onClose,
                            show: modalIsOpen,
                            title: modalHeader },
                        _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                            metadata: nameOptions,
                            onModelChange: this.onModelChange,
                            onValidityChange: this.onValidityChange,
                            register: this.onRegister,
                            validators: [nameValidator(stageList), maxLengthValidator(nameOptions.label, 255)] })
                    )
                )
            );
        }
    }]);
    return StageListHeaderComponent;
}(_react.Component);

StageListHeaderComponent.propTypes = {
    onFilterChange: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired
};
exports.default = StageListHeaderComponent;

/***/ }),

/***/ 2945:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2946);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var StageListItemComponent = function (_Component) {
    (0, _inherits3.default)(StageListItemComponent, _Component);

    function StageListItemComponent() {
        (0, _classCallCheck3.default)(this, StageListItemComponent);
        return (0, _possibleConstructorReturn3.default)(this, (StageListItemComponent.__proto__ || (0, _getPrototypeOf2.default)(StageListItemComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(StageListItemComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stage = _props.stage,
                onDelete = _props.onDelete,
                onEdit = _props.onEdit;

            return _react2.default.createElement(
                'div',
                { className: 'stage-panel' },
                _react2.default.createElement(
                    'div',
                    { className: 'title env-stage-title col-xs-8', title: stage.title },
                    stage.title
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'actions col-xs-4' },
                    _react2.default.createElement(
                        'span',
                        { className: 'pull-right' },
                        _react2.default.createElement(
                            'span',
                            { className: 'link color-inherited', onClick: function onClick() {
                                    return onEdit(stage);
                                } },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon edit-icon', title: 'Edit' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Edit'
                            )
                        ),
                        _react2.default.createElement(
                            'span',
                            { className: 'link delete', onClick: function onClick() {
                                    return onDelete(stage);
                                } },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon delete-icon', title: 'Delete' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Delete'
                            )
                        )
                    )
                )
            );
        }
    }]);
    return StageListItemComponent;
}(_react.Component);

StageListItemComponent.propTypes = {
    onDelete: _propTypes2.default.func.isRequired,
    onEdit: _propTypes2.default.func.isRequired,
    stage: _propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired
};
exports.default = StageListItemComponent;

/***/ }),

/***/ 2946:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2948:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _validators = __webpack_require__(123);

var _types = __webpack_require__(112);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var nameOptions = {
    label: 'Name',
    description: 'Name of the stage',
    required: true
};

var nameValidator = function nameValidator(stageList, id) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(stageList, id, 'title', name),
            message: (0, _validators.createErrorMessage)('Stage already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var StageEditModal = function (_Component) {
    (0, _inherits3.default)(StageEditModal, _Component);
    (0, _createClass3.default)(StageEditModal, null, [{
        key: 'getDerivedStateFromProps',
        value: function getDerivedStateFromProps(props, state) {
            if (!state.stage || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
                return (0, _extends3.default)({}, state, {
                    stage: props.model,
                    prevModel: props.model
                });
            }
            return null;
        }
    }]);

    function StageEditModal(props) {
        (0, _classCallCheck3.default)(this, StageEditModal);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageEditModal.__proto__ || (0, _getPrototypeOf2.default)(StageEditModal)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
            _this.componentApi = componentApi;
        };

        _this.closeModal = function () {
            _this.handleButtonClick(cancelButton.action);
        };

        _this.handleButtonClick = function (action) {
            var _this$props = _this.props,
                onCancel = _this$props.onCancel,
                onSave = _this$props.onSave;
            var stage = _this.state.stage;


            switch (action) {
                case 'update':
                    onSave(stage);
                    break;
                case 'cancel':
                    onCancel();
                    break;
            }
            _this.resetForm();
        };

        _this.handleModelChange = function (newTitle) {
            var stage = _this.state.stage;


            if (newTitle !== stage.title) {
                _this.setState({
                    stage: (0, _extends3.default)({}, stage, {
                        title: newTitle
                    })
                });
            }
        };

        _this.handleValidityChange = function (valid) {
            _this.isValid = valid;
        };

        _this.handlePristinityChange = function (pristine) {
            _this.isPristine = pristine;
        };

        _this.resetForm = function () {
            _this.setState({ stage: null });
            if (_this.componentApi) {
                _this.componentApi.resetPristinity();
            }
        };

        _this.state = {
            stage: null,
            prevModel: null
        };

        _this.isPristine = null;
        _this.isValid = null;

        _this.componentApi = null;
        return _this;
    }

    (0, _createClass3.default)(StageEditModal, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stages = _props.stages,
                isOpened = _props.isOpened;
            var stage = this.state.stage;


            var disableSaving = this.isPristine || !this.isValid;

            var updateButton = {
                action: 'update',
                className: 'button primary',
                disabled: disableSaving,
                keyCodes: [13],
                label: 'Save'
            };

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Edit stage',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.closeModal, type: 'button' },
                    _react2.default.createElement('i', { className: 'xl-icon close-icon' })
                )
            );

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, updateButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.handleButtonClick,
                    show: isOpened,
                    title: modalHeader },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                    metadata: nameOptions,
                    model: stage.title,
                    onModelChange: this.handleModelChange,
                    onPristinityChange: this.handlePristinityChange,
                    onValidityChange: this.handleValidityChange,
                    register: this.onRegister,
                    validators: [nameValidator(stages, stage.id), maxLengthValidator(nameOptions.label, 255)]
                })
            );
        }
    }]);
    return StageEditModal;
}(_react.Component);

StageEditModal.propTypes = {
    isOpened: _propTypes2.default.bool.isRequired,
    model: _types.Stage.isRequired,
    onCancel: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage).isRequired
};
exports.default = StageEditModal;

/***/ }),

/***/ 2949:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _environmentManagementStore = __webpack_require__(269);

var _labelListContainer = __webpack_require__(2950);

var _labelListContainer2 = _interopRequireDefault(_labelListContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LabelPage = function (_Component) {
    (0, _inherits3.default)(LabelPage, _Component);

    function LabelPage() {
        (0, _classCallCheck3.default)(this, LabelPage);
        return (0, _possibleConstructorReturn3.default)(this, (LabelPage.__proto__ || (0, _getPrototypeOf2.default)(LabelPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(LabelPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_labelListContainer2.default, null)
            );
        }
    }]);
    return LabelPage;
}(_react.Component);

exports.default = LabelPage;

/***/ }),

/***/ 2950:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(43);

var _labelActions = __webpack_require__(368);

var _labelListComponent = __webpack_require__(888);

var _labelListComponent2 = _interopRequireDefault(_labelListComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        labelList: state.labels.labelList
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    deleteLabel: _labelActions.deleteLabel,
    searchLabels: _labelActions.searchLabels,
    saveLabel: _labelActions.saveLabel
})(_labelListComponent2.default);

/***/ }),

/***/ 2951:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SchedulingReleasePage = function (_Component) {
    (0, _inherits3.default)(SchedulingReleasePage, _Component);

    function SchedulingReleasePage() {
        (0, _classCallCheck3.default)(this, SchedulingReleasePage);
        return (0, _possibleConstructorReturn3.default)(this, (SchedulingReleasePage.__proto__ || (0, _getPrototypeOf2.default)(SchedulingReleasePage)).apply(this, arguments));
    }

    (0, _createClass3.default)(SchedulingReleasePage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                { className: 'col-sm-12' },
                _react2.default.createElement(
                    'p',
                    null,
                    'In progress...'
                )
            );
        }
    }]);
    return SchedulingReleasePage;
}(_react.Component);

exports.default = SchedulingReleasePage;

/***/ }),

/***/ 2952:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _environmentManagementStore = __webpack_require__(269);

var _schedulingEnvironmentPageContainer = __webpack_require__(2953);

var _schedulingEnvironmentPageContainer2 = _interopRequireDefault(_schedulingEnvironmentPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SchedulingEnvironmentPage = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentPage, _Component);

    function SchedulingEnvironmentPage() {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentPage);
        return (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentPage.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(SchedulingEnvironmentPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_schedulingEnvironmentPageContainer2.default, null)
            );
        }
    }]);
    return SchedulingEnvironmentPage;
}(_react.Component);

exports.default = SchedulingEnvironmentPage;

/***/ }),

/***/ 2953:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SchedulingEnvironmentPageContainer = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(43);

var _lodash = __webpack_require__(62);

var _reactSidebar = __webpack_require__(384);

var _reactSidebar2 = _interopRequireDefault(_reactSidebar);

var _schedulingEnvironmentHeaderComponent = __webpack_require__(2954);

var _schedulingEnvironmentHeaderComponent2 = _interopRequireDefault(_schedulingEnvironmentHeaderComponent);

var _schedulingEnvironmentContainer = __webpack_require__(2955);

var _schedulingEnvironmentContainer2 = _interopRequireDefault(_schedulingEnvironmentContainer);

var _schedulingEnvironmentReservationFormContainer = __webpack_require__(3046);

var _schedulingEnvironmentReservationFormContainer2 = _interopRequireDefault(_schedulingEnvironmentReservationFormContainer);

var _schedulingActions = __webpack_require__(270);

var _types = __webpack_require__(112);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var styleSidebar = {
    root: {
        top: '56px'
    },
    sidebar: {
        width: '300px',
        padding: '5px 15px',
        background: '#ffffff',
        color: 'black',
        zIndex: 20,
        boxShadow: '-10px 0 10px -10px #F3F5F8'
    },
    overlay: {
        display: 'none'
    },
    dragHandle: {
        zIndex: 10
    }
};

var SchedulingEnvironmentPageContainer = exports.SchedulingEnvironmentPageContainer = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentPageContainer, _Component);

    function SchedulingEnvironmentPageContainer(props) {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentPageContainer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentPageContainer.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentPageContainer)).call(this, props));

        _this.onFilterChange = function () {
            var _this$props = _this.props,
                onSearchReservations = _this$props.onSearchReservations,
                schedulerFilter = _this$props.schedulerFilter;

            onSearchReservations(schedulerFilter);
        };

        _this.createReservation = function () {
            var openEnvironmentReservationForm = _this.props.openEnvironmentReservationForm;

            openEnvironmentReservationForm(null);
        };

        _this.editReservation = function (reservation) {
            var openEnvironmentReservationForm = _this.props.openEnvironmentReservationForm;

            openEnvironmentReservationForm(reservation.id);
        };

        _this.renderReservationForm = function (environmentsReservations) {
            var environments = (0, _lodash.map)(environmentsReservations, function (data) {
                return { id: data.id, title: data.title };
            });

            return _react2.default.createElement(_schedulingEnvironmentReservationFormContainer2.default, { environments: environments });
        };

        _this.addFilterApplication = function (application) {
            _this.setState({ filterEnvironmentByApplication: application });
        };

        _this.addFilterStage = function (stage) {
            _this.setState({ filterEnvironmentByStage: stage });
        };

        _this.addFilterLabels = function (labels) {
            _this.setState({ filterEnvironmentByLabels: labels });
        };

        _this.filterEnvironments = function (environments) {
            var filtered = environments;
            var _this$state = _this.state,
                filterEnvironmentByApplication = _this$state.filterEnvironmentByApplication,
                filterEnvironmentByStage = _this$state.filterEnvironmentByStage,
                filterEnvironmentByLabels = _this$state.filterEnvironmentByLabels;

            if (!(0, _lodash.isEmpty)(filterEnvironmentByApplication)) {
                var applications = _this.props.applications;

                var application = applications.find(function (app) {
                    return app.title === filterEnvironmentByApplication;
                });
                if (application) {
                    filtered = filtered.filter(function (env) {
                        return (0, _lodash.includes)(application.environments.map(function (e) {
                            return e.id;
                        }), env.id);
                    });
                } else {
                    return [];
                }
            }
            if (!(0, _lodash.isEmpty)(filterEnvironmentByStage)) {
                filtered = filtered.filter(function (env) {
                    return env.stage.title === filterEnvironmentByStage;
                });
            }
            if (!(0, _lodash.isEmpty)(filterEnvironmentByLabels)) {
                filtered = filtered.filter(function (env) {
                    return (0, _lodash.difference)(filterEnvironmentByLabels.map(function (t) {
                        return t.value;
                    }), env.labels.map(function (t) {
                        return t.title;
                    })).length === 0;
                });
            }
            return filtered;
        };

        _this.loadData = function () {
            _this.props.initHeader();
        };

        _this.state = {
            filterEnvironmentByApplication: '',
            filterEnvironmentByStage: '',
            filterEnvironmentByLabels: []
        };
        return _this;
    }

    (0, _createClass3.default)(SchedulingEnvironmentPageContainer, [{
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            var cleanSchedulingState = this.props.cleanSchedulingState;

            cleanSchedulingState();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                stages = _props.stages,
                environmentsReservations = _props.environmentsReservations,
                schedulerFilter = _props.schedulerFilter,
                reservationSidebarIsOpen = _props.reservationSidebarIsOpen,
                labels = _props.labels;

            var environmentsFiltered = this.filterEnvironments(environmentsReservations);
            var sidebarContent = reservationSidebarIsOpen ? this.renderReservationForm(environmentsFiltered) : '';
            var isNewReservationDisabled = reservationSidebarIsOpen || !environmentsReservations.length;
            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(_schedulingEnvironmentHeaderComponent2.default, {
                    applications: applications,
                    labels: labels,
                    loadHeaderData: this.loadData,
                    newReservationDisabled: isNewReservationDisabled,
                    onApplicationFilterChange: this.addFilterApplication,
                    onLabelsFilterChange: this.addFilterLabels,
                    onNewReservation: this.createReservation,
                    onStageFilterChange: this.addFilterStage,
                    schedulerFilter: schedulerFilter,
                    stages: stages
                }),
                _react2.default.createElement(
                    _reactSidebar2.default,
                    {
                        open: reservationSidebarIsOpen,
                        pullRight: true,
                        shadow: false,
                        sidebar: sidebarContent,
                        styles: styleSidebar },
                    _react2.default.createElement(_schedulingEnvironmentContainer2.default, {
                        environmentsReservations: environmentsFiltered,
                        onEventClick: this.editReservation,
                        onFilterChange: this.onFilterChange,
                        schedulerFilter: schedulerFilter })
                )
            );
        }
    }]);
    return SchedulingEnvironmentPageContainer;
}(_react.Component);

SchedulingEnvironmentPageContainer.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    cleanSchedulingState: _propTypes2.default.func.isRequired,
    environmentsReservations: _propTypes2.default.arrayOf(_types.EnvironmentReservation),
    initHeader: _propTypes2.default.func.isRequired,
    labels: _propTypes2.default.arrayOf(_types.Label),
    onSearchReservations: _propTypes2.default.func.isRequired,
    openEnvironmentReservationForm: _propTypes2.default.func,
    reservationSidebarIsOpen: _propTypes2.default.bool.isRequired,
    schedulerFilter: _types.SchedulerFilter.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        environmentsReservations: state.scheduling.environmentsReservations,
        reservationSidebarIsOpen: state.scheduling.reservationSidebarIsOpen,
        schedulerFilter: state.scheduling.schedulerFilter,
        applications: state.applicationList.applications,
        stages: state.stages.stageList,
        labels: state.labels.labelList
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, { onSearchReservations: _schedulingActions.onSearchReservations, openEnvironmentReservationForm: _schedulingActions.openEnvironmentReservationForm, initHeader: _schedulingActions.initHeader, cleanSchedulingState: _schedulingActions.cleanSchedulingState })(SchedulingEnvironmentPageContainer);

/***/ }),

/***/ 2954:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _lodash = __webpack_require__(62);

var _headerComponent = __webpack_require__(271);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

var _types = __webpack_require__(112);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var applicationFilterMetadata = {
    label: 'Application',
    placeholder: 'Select application...'
};

var stageFilterMetadata = {
    label: 'Stage',
    placeholder: 'Select stage...'
};

var labelsFilterMetadata = {
    label: 'Labels',
    placeholder: 'Select labels...',
    name: 'autocomplete'
};

var autocompleteHandler = function autocompleteHandler(list) {
    return function (_ref) {
        var metadata = _ref.metadata,
            objLabel = _ref.objLabel,
            suggestedElements = _ref.suggestedElements,
            value = _ref.value;

        return _promise2.default.resolve(list.filter(function (item) {
            return (0, _lodash.includes)(item[objLabel].toLowerCase(), value.toLowerCase());
        }));
    };
};

var SchedulingEnvironmentHeaderComponent = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentHeaderComponent, _Component);

    function SchedulingEnvironmentHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentHeaderComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentHeaderComponent)).call(this, props));

        _this.selectApplication = function (app) {
            _this.setState({ applicationSelected: app });
            _this.props.onApplicationFilterChange(app);
        };

        _this.selectStage = function (stage) {
            _this.setState({ stageSelected: stage });
            _this.props.onStageFilterChange(stage);
        };

        _this.selectLabel = function (labels) {
            _this.setState({ labelsSelected: labels });
            _this.props.onLabelsFilterChange(labels);
        };

        _this.state = {
            applicationSelected: {},
            stageSelected: {},
            labelsSelected: []
        };
        return _this;
    }

    (0, _createClass3.default)(SchedulingEnvironmentHeaderComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.loadHeaderData();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                stages = _props.stages,
                newReservationDisabled = _props.newReservationDisabled,
                onNewReservation = _props.onNewReservation,
                labels = _props.labels;
            var _state = this.state,
                applicationSelected = _state.applicationSelected,
                stageSelected = _state.stageSelected,
                labelsSelected = _state.labelsSelected;


            var applicationsHandler = { addCandidates: autocompleteHandler(applications) };
            var stagesHandler = { addCandidates: autocompleteHandler(stages) };
            var labelsHandler = {
                autocomplete: { addCandidates: autocompleteHandler(labels.map(function (t) {
                        return { color: '', label: t.title, value: t.id };
                    })) }
            };

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'scheduling.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: applicationsHandler,
                        metadata: applicationFilterMetadata,
                        model: applicationSelected,
                        objLabel: 'title',
                        onModelChange: this.selectApplication }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: stagesHandler,
                        metadata: stageFilterMetadata,
                        model: stageSelected,
                        objLabel: 'title',
                        onModelChange: this.selectStage }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetTags, {
                        className: 'long',
                        handlers: labelsHandler,
                        inputType: 'autocomplete',
                        metadata: labelsFilterMetadata,
                        model: labelsSelected,
                        objLabel: 'label',
                        onModelChange: this.selectLabel,
                        skin: 'checkbox',
                        tagTransform: function tagTransform(t) {
                            return t;
                        } }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', disabled: newReservationDisabled,
                                onClick: onNewReservation },
                            'New'
                        )
                    )
                )
            );
        }
    }]);
    return SchedulingEnvironmentHeaderComponent;
}(_react.Component);

SchedulingEnvironmentHeaderComponent.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    labels: _propTypes2.default.arrayOf(_types.Label),
    loadHeaderData: _propTypes2.default.func.isRequired,
    newReservationDisabled: _propTypes2.default.bool.isRequired,
    onApplicationFilterChange: _propTypes2.default.func.isRequired,
    onLabelsFilterChange: _propTypes2.default.func.isRequired,
    onNewReservation: _propTypes2.default.func.isRequired,
    onStageFilterChange: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};
SchedulingEnvironmentHeaderComponent.defaultProps = {
    applications: [],
    labels: [],
    stages: []
};
exports.default = SchedulingEnvironmentHeaderComponent;

/***/ }),

/***/ 2955:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.reservationState = exports.toastr = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(62);

var _reactBigScheduler = __webpack_require__(178);

var _reactBigScheduler2 = _interopRequireDefault(_reactBigScheduler);

var _xlReactComponents = __webpack_require__(47);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

var _withDndContext = __webpack_require__(3029);

var _withDndContext2 = _interopRequireDefault(_withDndContext);

var _toastrFactory = __webpack_require__(81);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _schedulingEnvironmentCalendarHeaderComponent = __webpack_require__(3039);

var _schedulingEnvironmentCalendarHeaderComponent2 = _interopRequireDefault(_schedulingEnvironmentCalendarHeaderComponent);

var _environmentSidebarItem = __webpack_require__(890);

var _environmentSidebarItem2 = _interopRequireDefault(_environmentSidebarItem);

var _components = __webpack_require__(67);

var _types = __webpack_require__(112);

var _colors = __webpack_require__(101);

var _colors2 = _interopRequireDefault(_colors);

__webpack_require__(3042);

__webpack_require__(3044);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var reservationState = exports.reservationState = {
    pending: 'PENDING',
    conflict: 'CONFLICT',
    confirmed: 'CONFIRMED'
};

var getStateDescription = function getStateDescription(state) {
    switch (state) {
        case reservationState.pending:
            return {
                title: 'Pending reservation',
                eventClass: 'event--pending',
                circleClass: 'state-circle--pending'
            };
        case reservationState.conflict:
            return {
                title: 'Possible conflict',
                eventClass: 'event--conflict',
                circleClass: 'state-circle--conflict'
            };
        case reservationState.confirmed:
            return {
                title: 'Confirmed',
                eventClass: 'event--confirmed',
                circleClass: 'state-circle--confirmed'
            };
        default:
            return {
                title: '',
                eventClass: 'event--pending',
                circleClass: 'state-circle--pending'
            };
    }
};

var getSchedulerWidth = function getSchedulerWidth() {
    // {window width}
    return window.innerWidth;
};

var getSchedulerHeight = function getSchedulerHeight() {
    // {window height} - {scheduler header} - {height of header with filters} - {height of sub navigation} - {height of main navigation}
    return window.innerHeight - 52 - 60 - 56 - 43;
};

var getWeekCellWidth = function getWeekCellWidth() {
    var newWidth = (window.innerWidth - 300) / 7;
    return newWidth < 140 ? 140 : newWidth;
};

var getDayCellWidth = function getDayCellWidth() {
    var newWidth = (window.innerWidth - 300) / 24;
    return newWidth < 80 ? 80 : newWidth;
};

var schedulerConfig = {
    schedulerWidth: getSchedulerWidth(), //'1000'
    schedulerMaxHeight: getSchedulerHeight(), //500, // Set schedulerMaxHeight to freeze first row //0
    tableHeaderHeight: 40,

    dayResourceTableWidth: 300, //160
    weekResourceTableWidth: 300, //160
    monthResourceTableWidth: 300, //160

    dayCellWidth: getDayCellWidth(), //30
    weekCellWidth: getWeekCellWidth(), // 140, // 120
    monthCellWidth: 140, //80,

    dayMaxEvents: 99,
    weekMaxEvents: 99,
    monthMaxEvents: 99,

    eventItemHeight: 18, //22,
    eventItemLineHeight: 20, // 24,
    nonAgendaSlotMinHeight: 64, //0
    dayStartFrom: 0,
    dayStopTo: 23,
    defaultEventBgColor: _colors2.default.lightgray,
    selectedAreaColor: _colors2.default.selectedColor,
    nonWorkingTimeHeadColor: _colors2.default.black,
    nonWorkingTimeHeadBgColor: _colors2.default.background,
    nonWorkingTimeBodyBgColor: _colors2.default.white,

    startResizable: false, // true,
    endResizable: false, //true,
    movable: false, //true,
    creatable: false, //true,
    crossResourceMove: true,
    checkConflict: true, // false,
    scrollToTodayEnabled: true,
    eventItemPopoverEnabled: true,
    calendarPopoverEnabled: false, // true, //display calendar popover when clicking on a date label in header
    recurringEventsEnabled: true,
    headerEnabled: false, // true, //we can remove header and add custom component above calendar
    displayWeekend: true,

    resourceName: 'Resource Name',
    addMorePopoverHeaderFormat: 'MMM D, YYYY dddd', // when max event is defined
    eventItemPopoverDateFormat: 'MMM D, YYYY', // 'MMM D',
    nonAgendaDayCellHeaderFormat: 'hh:mm A', //'ha', //when is selected Day
    nonAgendaOtherCellHeaderFormat: 'dddd, MMM D', //'ddd M/D', //when is selected Week or Month

    minuteStep: 60, //30

    views: (0, _lodash.map)(_schedulingEnvironmentCalendarHeaderComponent.viewsMap, function (value) {
        return value;
    })
};

var SchedulingEnvironmentContainer = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentContainer, _Component);

    function SchedulingEnvironmentContainer(props) {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentContainer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentContainer.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentContainer)).call(this, props));

        _this.initSchedulerData = function () {
            var resourceFilter = _react2.default.createElement(
                'div',
                { className: 'calendar-filter' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: { placeholder: 'Filter by environment...' }, onUpdate: _this.filterByEnvironmentName })
            );
            var config = schedulerConfig;
            config.resourceName = resourceFilter;

            // overridden configuration has comment with default value, unnecessary configuration has removed
            var schedulerData = new _reactBigScheduler.SchedulerData((0, _moment2.default)().format(_reactBigScheduler.DATETIME_FORMAT), _reactBigScheduler.ViewTypes.Month, false, false, config);
            schedulerData.setResources([]);
            schedulerData.setEvents([]);

            return schedulerData;
        };

        _this.filterByEnvironmentName = function (name) {
            _this.props.schedulerFilter.environmentTitle = name;
            _this.props.onFilterChange();
        };

        _this.formatEnvironmentsReservations = function () {
            var schedulerData = _this.state.schedulerData;
            if (_this.props.environmentsReservations !== null) {
                schedulerData.setResources(_this.getFormattedResources());
                schedulerData.setEvents(_this.getFormattedEvents());
            } else {
                schedulerData.setResources([]);
                schedulerData.setEvents([]);
            }

            return schedulerData;
        };

        _this.getFormattedResources = function () {
            return (0, _lodash.map)(_this.props.environmentsReservations, function (data) {
                return {
                    id: data.id,
                    name: data.title,
                    stage: data.stage
                    // labels: data.labels
                };
            });
        };

        _this.getFormattedEvents = function () {
            var fatEventList = (0, _lodash.map)(_this.props.environmentsReservations, function (environmentReservation) {
                var resourceId = environmentReservation.id;
                return (0, _lodash.map)(environmentReservation.reservations, function (reservation) {
                    // TODO: read missing value from object after backend change
                    return {
                        id: reservation.id,
                        start: (0, _moment2.default)(reservation.startDate).format(_reactBigScheduler.DATETIME_FORMAT),
                        end: (0, _moment2.default)(reservation.endDate).format(_reactBigScheduler.DATETIME_FORMAT),
                        resourceId: resourceId,
                        title: _this.getTitle(reservation),
                        applications: reservation.applications,
                        state: reservationState.confirmed // reservation.state
                    };
                });
            });

            var flatEventList = (0, _lodash.flatMap)(fatEventList);
            //the event array should be sorted in ascending order by event.start property, otherwise there will be some rendering errors
            return (0, _lodash.sortBy)(flatEventList, function (event) {
                return event.start;
            });
        };

        _this.updateSchedulerEvents = function (schedulerData) {
            schedulerData.setEvents(_this.getFormattedEvents());
            _this.setState({ schedulerData: schedulerData });
        };

        _this.updateDimensions = function () {
            var schedulerData = _this.state.schedulerData;
            schedulerData.config.schedulerWidth = getSchedulerWidth();
            schedulerData.config.schedulerMaxHeight = getSchedulerHeight();
            schedulerData.config.dayCellWidth = getDayCellWidth();
            schedulerData.config.weekCellWidth = getWeekCellWidth();
            _this.setState({ schedulerData: schedulerData });
        };

        _this.prevClick = function (schedulerData) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.prev();
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.nextClick = function (schedulerData) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.next();
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.onCustomViewChange = function (view) {
            _this.onViewChange(_this.state.schedulerData, view);
        };

        _this.onViewChange = function (schedulerData, view) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.setViewType(view.viewType, view.showAgenda, view.isEventPerspective);
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.onSelectDate = function (schedulerData, date) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.setDate(date);
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.nonAgendaCellHeaderTemplateResolver = function (schedulerData, item, formattedDateItems, style) {
            var headerToday = void 0;
            var datetime = schedulerData.localeMoment(item.time);

            if (schedulerData.viewType === _reactBigScheduler.ViewTypes.Day) {
                headerToday = datetime.isSame(new Date(), 'hour') ? 'header-today' : '';
            } else {
                headerToday = datetime.isSame(new Date(), 'day') ? 'header-today' : '';
            }

            return _react2.default.createElement(
                'th',
                { className: 'header3-text', key: item.time, style: style },
                formattedDateItems.map(function (formattedItem, index) {
                    return _react2.default.createElement('div', { className: headerToday,
                        dangerouslySetInnerHTML: { __html: formattedItem.replace(/[0-9]/g, '<b>$&</b>') }, key: index });
                })
            );
        };

        _this.eventItemTemplateResolver = function (schedulerData, event, bgColor, isStart, isEnd, mustAddCssClass, mustBeHeight, agendaMaxEventWidth) {
            var config = schedulerData.config;


            var popup = _react2.default.createElement(
                _components.Popup,
                null,
                _react2.default.createElement(
                    'span',
                    { onClick: function onClick() {
                            return _this.approveReservation(event);
                        } },
                    'Approve'
                ),
                _react2.default.createElement(
                    'span',
                    { onClick: function onClick() {
                            return _this.askForChangeReservation(event);
                        } },
                    'Ask for change'
                ),
                _react2.default.createElement(
                    'span',
                    { onClick: function onClick() {
                            return _this.declineReservation(event);
                        } },
                    'Decline'
                )
            );
            var popupMenu = event.state === reservationState.pending ? popup : '';

            return _react2.default.createElement(
                'div',
                { className: 'event-item ' + getStateDescription(event.state).eventClass, id: event.id, key: event.id, style: { height: config.eventItemHeight } },
                _react2.default.createElement(
                    'span',
                    { style: { marginLeft: '10px', lineHeight: config.eventItemHeight + 'px' } },
                    schedulerData.behaviors.getEventTextFunc(schedulerData, event)
                )
            );
        };

        _this.subtitleGetter = function (schedulerData, event) {
            var title = schedulerData.behaviors.getEventTextFunc(schedulerData, event);
            var stateDescription = getStateDescription(event.state);

            return _react2.default.createElement(
                'div',
                { className: 'event-item-popover-content' },
                title.length > 0 ? _react2.default.createElement(
                    'div',
                    { className: 'event-item-popover-title' },
                    title
                ) : null,
                _react2.default.createElement(
                    'table',
                    { className: 'event-item-popover-description' },
                    _react2.default.createElement(
                        'tbody',
                        null,
                        _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'th',
                                null,
                                _react2.default.createElement('div', { className: stateDescription.circleClass })
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                stateDescription.title
                            )
                        ),
                        event.applications.length > 0 ? _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'th',
                                null,
                                _react2.default.createElement('i', { className: 'xl-icon app-icon' })
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                event.applications.map(function (application) {
                                    return application.title;
                                }).join(', ')
                            )
                        ) : null
                    )
                ),
                _react2.default.createElement(
                    'table',
                    { className: 'event-item-popover-details' },
                    _react2.default.createElement(
                        'tbody',
                        null,
                        _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'td',
                                null,
                                'From:'
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                (0, _moment2.default)(event.start).format('MMM D, YYYY - hh:mm A')
                            )
                        ),
                        _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'td',
                                null,
                                'To:'
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                (0, _moment2.default)(event.end).format('MMM D, YYYY - hh:mm A')
                            )
                        )
                    )
                )
            );
        };

        _this.approveReservation = function (event) {
            toastr.info('Approve: [ ' + event.title + ' ]');
        };

        _this.askForChangeReservation = function (event) {
            toastr.info('Ask for change reservation: [ ' + event.title + ' ]');
        };

        _this.declineReservation = function (event) {
            toastr.info('Decline reservation: [ ' + event.title + ' ]');
        };

        _this.getTitle = function (reservation) {
            if (reservation.release) {
                return reservation.release.title;
            } else if (reservation.applications.length > 0) {
                return reservation.applications.map(function (application) {
                    return application.title;
                }).join(', ');
            } else {
                return '';
            }
        };

        _this.newEvent = function (schedulerData, slotId, slotName, start, end, type, item) {
            //before save open sidebar form
            var newFreshId = 0;
            schedulerData.events.forEach(function (item) {
                if (item.id >= newFreshId) newFreshId = item.id + 1;
            });

            var title = 'New event you just created';
            var newEvent = {
                id: newFreshId,
                title: title,
                start: start,
                end: end,
                resourceId: slotId
            };
            schedulerData.addEvent(newEvent);

            (0, _lodash.each)(_this.props.environmentsReservations, function (data) {
                if (data.id === slotId) {
                    data.reservations.push({
                        id: newFreshId,
                        startDate: (0, _moment2.default)(start).valueOf(),
                        endDate: (0, _moment2.default)(end).valueOf(),
                        state: reservationState.pending,
                        application: {
                            id: 'app_' + slotId + '_' + newFreshId,
                            title: title
                        }
                    });
                }
            });

            _this.setState({ schedulerData: schedulerData });
        };

        _this.eventClicked = function (schedulerData, event) {
            var onEventClick = _this.props.onEventClick;

            onEventClick(event);
        };

        _this.updateEventStart = function (schedulerData, event, newStart) {
            //before save open sidebar form populated with event data
            schedulerData.updateEventStart(event, newStart);
            _this.setState({ schedulerData: schedulerData });
        };

        _this.updateEventEnd = function (schedulerData, event, newEnd) {
            //before save open sidebar form populated with event data
            schedulerData.updateEventEnd(event, newEnd);
            _this.setState({ schedulerData: schedulerData });
        };

        _this.moveEvent = function (schedulerData, event, slotId, slotName, start, end) {
            //before save open sidebar form populated with event data
            schedulerData.moveEvent(event, slotId, slotName, start, end);
            _this.setState({ schedulerData: schedulerData });
        };

        _this.conflictOccurred = function (schedulerData, action, event) {
            //implement conflict functionality
            toastr.warning('Conflict occurred. {action: ' + action + ', event: { newSlotName: ' + event.slotName + ', newStart: ' + event.start + ', newEnd: ' + event.end + ' } }');
        };

        _this.slotItemTemplateResolver = function (schedulerData, item) {
            var environmentsReservations = _this.props.environmentsReservations;

            var environment = (0, _lodash.find)(environmentsReservations, function (env) {
                return env.id === item.slotId;
            });
            return _react2.default.createElement(_environmentSidebarItem2.default, { environment: environment });
        };

        _this.state = {
            schedulerData: _this.initSchedulerData()
        };
        return _this;
    }

    (0, _createClass3.default)(SchedulingEnvironmentContainer, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.filterByEnvironmentName('');
            window.addEventListener('resize', this.updateDimensions);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            window.removeEventListener('resize', this.updateDimensions);
        }
    }, {
        key: 'onDateChange',
        value: function onDateChange(schedulerData) {
            this.props.schedulerFilter.from = (0, _moment2.default)(schedulerData.startDate, 'YYYY-MM-DD').startOf('day').valueOf();
            this.props.schedulerFilter.to = (0, _moment2.default)(schedulerData.endDate, 'YYYY-MM-DD').endOf('day').valueOf();
            this.props.onFilterChange();
        }

        //TODO: sketch of implementation for future tasks

    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            // const schedulerData = this.props.schedulerData;
            var schedulerData = this.formatEnvironmentsReservations();

            return _react2.default.createElement(
                'div',
                { id: 'scheduler-environment' },
                _react2.default.createElement(_schedulingEnvironmentCalendarHeaderComponent2.default, {
                    customNextClick: function customNextClick() {
                        return _this2.nextClick(schedulerData);
                    },
                    customPrevClick: function customPrevClick() {
                        return _this2.prevClick(schedulerData);
                    },
                    dateLabel: schedulerData.getDateLabel(),
                    onViewChange: this.onCustomViewChange,
                    selectedViewType: schedulerData.viewType,
                    title: 'Environments',
                    todayClick: function todayClick() {
                        return _this2.onSelectDate(schedulerData, (0, _moment2.default)());
                    }
                }),
                _react2.default.createElement(_reactBigScheduler2.default, {
                    conflictOccurred: this.conflictOccurred,
                    eventItemClick: this.eventClicked,
                    eventItemTemplateResolver: this.eventItemTemplateResolver,
                    moveEvent: this.moveEvent,
                    newEvent: this.newEvent,
                    nextClick: this.nextClick,
                    nonAgendaCellHeaderTemplateResolver: this.nonAgendaCellHeaderTemplateResolver,
                    onSelectDate: this.onSelectDate,
                    onViewChange: this.onViewChange,
                    prevClick: this.prevClick,
                    schedulerData: schedulerData,
                    slotItemTemplateResolver: this.slotItemTemplateResolver,
                    subtitleGetter: this.subtitleGetter,
                    updateEventEnd: this.updateEventEnd,
                    updateEventStart: this.updateEventStart
                }),
                (!schedulerData || !schedulerData.resources.length) && _react2.default.createElement(
                    'div',
                    { className: 'no-res-environments-message-container' },
                    _react2.default.createElement(_components.NoData, { className: 'no-res-environments-message', message: 'No environments found.' })
                )
            );
        }
    }]);
    return SchedulingEnvironmentContainer;
}(_react.Component);

SchedulingEnvironmentContainer.propTypes = {
    environmentsReservations: _propTypes2.default.arrayOf(_types.EnvironmentReservation),
    onEventClick: _propTypes2.default.func.isRequired,
    onFilterChange: _propTypes2.default.func.isRequired,
    schedulerFilter: _types.SchedulerFilter.isRequired
};
exports.default = (0, _withDndContext2.default)(SchedulingEnvironmentContainer);

/***/ }),

/***/ 3029:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _reactDnd = __webpack_require__(617);

var _reactDndHtml5Backend = __webpack_require__(3030);

var _reactDndHtml5Backend2 = _interopRequireDefault(_reactDndHtml5Backend);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _reactDnd.DragDropContext)(_reactDndHtml5Backend2.default);

/***/ }),

/***/ 3039:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.viewsMap = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactBigScheduler = __webpack_require__(178);

var _xlReactComponents = __webpack_require__(47);

__webpack_require__(3040);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var viewsMap = exports.viewsMap = {
    0: { viewName: 'Day', viewType: _reactBigScheduler.ViewTypes.Day, showAgenda: false, isEventPerspective: false },
    1: { viewName: 'Week', viewType: _reactBigScheduler.ViewTypes.Week, showAgenda: false, isEventPerspective: false },
    2: { viewName: 'Month', viewType: _reactBigScheduler.ViewTypes.Month, showAgenda: false, isEventPerspective: false }
};

var SchedulingEnvironmentCalendarHeaderComponent = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentCalendarHeaderComponent, _Component);

    function SchedulingEnvironmentCalendarHeaderComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, SchedulingEnvironmentCalendarHeaderComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = SchedulingEnvironmentCalendarHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentCalendarHeaderComponent)).call.apply(_ref, [this].concat(args))), _this), _this.buttonToggle = function (value) {
            _this.props.onViewChange(value);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(SchedulingEnvironmentCalendarHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                dateLabel = _props.dateLabel,
                customPrevClick = _props.customPrevClick,
                todayClick = _props.todayClick,
                customNextClick = _props.customNextClick,
                selectedViewType = _props.selectedViewType,
                title = _props.title;


            var options = [{
                value: viewsMap[0],
                label: viewsMap[0].viewName
            }, {
                value: viewsMap[1],
                label: viewsMap[1].viewName
            }, {
                value: viewsMap[2],
                label: viewsMap[2].viewName
            }];

            return _react2.default.createElement(
                'div',
                { id: 'custom-scheduler-header' },
                _react2.default.createElement(
                    'div',
                    { className: 'custom-scheduler-left-header' },
                    _react2.default.createElement(
                        'h4',
                        null,
                        title
                    )
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'custom-scheduler-right-header' },
                    _react2.default.createElement(
                        'div',
                        { className: 'col-sm-3' },
                        _react2.default.createElement(
                            'h4',
                            null,
                            dateLabel
                        )
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'col-sm-6' },
                        _react2.default.createElement(
                            'div',
                            { className: 'button-group-view' },
                            _react2.default.createElement(_xlReactComponents.XlReactToggleButton, {
                                metadata: options,
                                model: options[selectedViewType].value,
                                objLabel: 'label',
                                objValue: 'value',
                                onToggle: this.buttonToggle

                            })
                        )
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'col-sm-3 custom-right-header' },
                        _react2.default.createElement(
                            'div',
                            { className: 'button-group-calendar' },
                            _react2.default.createElement(
                                'button',
                                { className: 'button button-icon prev', onClick: customPrevClick, type: 'button' },
                                _react2.default.createElement('i', { className: 'xl-icon chevron-left-icon' })
                            ),
                            _react2.default.createElement(
                                'button',
                                { className: 'button today', onClick: todayClick, type: 'button' },
                                'Today'
                            ),
                            _react2.default.createElement(
                                'button',
                                { className: 'button button-icon next', onClick: customNextClick, type: 'button' },
                                _react2.default.createElement('i', { className: 'xl-icon chevron-right-icon' })
                            )
                        )
                    )
                )
            );
        }
    }]);
    return SchedulingEnvironmentCalendarHeaderComponent;
}(_react.Component);

SchedulingEnvironmentCalendarHeaderComponent.propTypes = {
    customNextClick: _propTypes2.default.func.isRequired,
    customPrevClick: _propTypes2.default.func.isRequired,
    dateLabel: _propTypes2.default.any.isRequired,
    onViewChange: _propTypes2.default.func.isRequired,
    selectedViewType: _propTypes2.default.number.isRequired,
    title: _propTypes2.default.string,
    todayClick: _propTypes2.default.func.isRequired
};
exports.default = SchedulingEnvironmentCalendarHeaderComponent;

/***/ }),

/***/ 3040:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3044:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3046:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(43);

var _lodash = __webpack_require__(62);

var _xlReactComponents = __webpack_require__(47);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(451);

var _types = __webpack_require__(112);

var _sidebarReservationForm = __webpack_require__(3047);

var _sidebarReservationForm2 = _interopRequireDefault(_sidebarReservationForm);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};
var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var SchedulingEnvironmentReservationFormContainer = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentReservationFormContainer, _Component);

    function SchedulingEnvironmentReservationFormContainer() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, SchedulingEnvironmentReservationFormContainer);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = SchedulingEnvironmentReservationFormContainer.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentReservationFormContainer)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
            reservationToDelete: null,
            deleteModalIsOpen: false
        }, _this.onConfirmNewReservation = function () {
            var _this$props = _this.props,
                onReserveEnvironment = _this$props.onReserveEnvironment,
                reservationModel = _this$props.reservationModel;

            onReserveEnvironment(reservationModel);
        }, _this.showDeleteConfirmationModel = function (id) {
            _this.setState({ deleteModalIsOpen: true, reservationToDelete: id });
        }, _this.onCloseDeleteConfirmationModal = function (action) {
            var reservationToDelete = _this.state.reservationToDelete;

            if (action === 'delete') {
                _this.props.onDeleteEnvironmentReservation(reservationToDelete);
            }
            _this.setState({ deleteModalIsOpen: false, reservationModel: null });
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(SchedulingEnvironmentReservationFormContainer, [{
        key: 'renderDeleteConfirmationModal',
        value: function renderDeleteConfirmationModal() {
            var deleteModalIsOpen = this.state.deleteModalIsOpen;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, deleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseDeleteConfirmationModal,
                    show: deleteModalIsOpen,
                    title: 'Delete reservation' },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete reservation.'
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                environments = _props.environments,
                onReserveEnvironmentCancel = _props.onReserveEnvironmentCancel,
                onReservationEnvironmentChange = _props.onReservationEnvironmentChange,
                onReservationFormChange = _props.onReservationFormChange,
                onReservationFormPristineChange = _props.onReservationFormPristineChange,
                onReservationFormValidChange = _props.onReservationFormValidChange,
                reservationModel = _props.reservationModel,
                reservationFormIsPristine = _props.reservationFormIsPristine,
                reservationFormIsValid = _props.reservationFormIsValid;


            var isEditForm = !(0, _lodash.isEmpty)(reservationModel.id);
            var isSaveEnabled = !reservationFormIsPristine && reservationFormIsValid;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                this.renderDeleteConfirmationModal(),
                _react2.default.createElement(_sidebarReservationForm2.default, {
                    applications: applications,
                    environments: environments,
                    isEditForm: isEditForm,
                    isSaveEnabled: isSaveEnabled,
                    key: reservationModel.id,
                    onCancel: onReserveEnvironmentCancel,
                    onConfirm: this.onConfirmNewReservation,
                    onDelete: this.showDeleteConfirmationModel,
                    onFormChange: onReservationFormChange,
                    onFormPristinityChange: onReservationFormPristineChange,
                    onFormValidationChange: onReservationFormValidChange,
                    onReservationEnvironmentChange: onReservationEnvironmentChange,
                    reservationModel: reservationModel })
            );
        }
    }]);
    return SchedulingEnvironmentReservationFormContainer;
}(_react.Component);

SchedulingEnvironmentReservationFormContainer.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    environments: _propTypes2.default.arrayOf(_types.Environment),
    onDeleteEnvironmentReservation: _propTypes2.default.func.isRequired,
    onReservationEnvironmentChange: _propTypes2.default.func.isRequired,
    onReservationFormChange: _propTypes2.default.func.isRequired,
    onReservationFormPristineChange: _propTypes2.default.func.isRequired,
    onReservationFormValidChange: _propTypes2.default.func.isRequired,
    onReserveEnvironment: _propTypes2.default.func.isRequired,
    onReserveEnvironmentCancel: _propTypes2.default.func.isRequired,
    reservationFormIsPristine: _propTypes2.default.bool,
    reservationFormIsValid: _propTypes2.default.bool,
    reservationModel: _types.ReservationModel
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        applications: state.schedulingEnvironmentReservationForm.applications,
        reservationFormIsPristine: state.schedulingEnvironmentReservationForm.reservationFormIsPristine,
        reservationFormIsValid: state.schedulingEnvironmentReservationForm.reservationFormIsValid,
        reservationModel: state.schedulingEnvironmentReservationForm.reservationModel
    };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
    return (0, _extends3.default)({}, ownProps, stateProps, dispatchProps);
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    initEnvironmentReservationForm: _schedulingEnvironmentReservationFormActions.initEnvironmentReservationForm,
    onDeleteEnvironmentReservation: _schedulingEnvironmentReservationFormActions.onDeleteEnvironmentReservation,
    onReservationFormChange: _schedulingEnvironmentReservationFormActions.onReservationFormChange,
    onReservationEnvironmentChange: _schedulingEnvironmentReservationFormActions.onReservationEnvironmentChange,
    onReservationFormPristineChange: _schedulingEnvironmentReservationFormActions.onReservationFormPristineChange,
    onReservationFormValidChange: _schedulingEnvironmentReservationFormActions.onReservationFormValidChange,
    onReserveEnvironment: _schedulingEnvironmentReservationFormActions.onReserveEnvironment,
    onReserveEnvironmentCancel: _schedulingEnvironmentReservationFormActions.onReserveEnvironmentCancel
}, mergeProps)(SchedulingEnvironmentReservationFormContainer);

/***/ }),

/***/ 3047:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(62);

var _xlReactComponents = __webpack_require__(47);

var _applicationSelect = __webpack_require__(3048);

var _applicationSelect2 = _interopRequireDefault(_applicationSelect);

var _widgets = __webpack_require__(914);

var _types = __webpack_require__(112);

__webpack_require__(3065);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var environmentFieldMetadata = {
    description: 'Environment to reserve',
    label: 'Environment',
    placeholder: 'Select environment...',
    required: true,
    requiredText: 'Environment is required'
};
var startDateFieldMetadata = {
    label: 'Start date',
    placeholder: 'Set start date...',
    description: 'Start date/time for reservation',
    required: true,
    dateFormat: 'MMM D, YYYY'
};
var endDateFieldMetadata = {
    label: 'End date',
    placeholder: 'Set end date...',
    description: 'End date/time for reservation',
    required: true,
    dateFormat: 'MMM D, YYYY'
};
var noteFieldMetadata = {
    label: 'Note',
    placeholder: 'Set note...',
    description: 'Note for approver',
    size: 'MEDIUM'
};

var SidebarReservationForm = function (_Component) {
    (0, _inherits3.default)(SidebarReservationForm, _Component);

    function SidebarReservationForm(props) {
        (0, _classCallCheck3.default)(this, SidebarReservationForm);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SidebarReservationForm.__proto__ || (0, _getPrototypeOf2.default)(SidebarReservationForm)).call(this, props));

        _this.onEnvironmentChange = function (environment) {
            var _this$props = _this.props,
                reservationModel = _this$props.reservationModel,
                onFormChange = _this$props.onFormChange,
                onReservationEnvironmentChange = _this$props.onReservationEnvironmentChange;

            onFormChange((0, _extends3.default)({}, reservationModel, {
                applications: [],
                environment: environment
            }));
            onReservationEnvironmentChange(environment);
        };

        _this.onApplicationChange = function (selectedApplications) {
            var _this$props2 = _this.props,
                onFormChange = _this$props2.onFormChange,
                reservationModel = _this$props2.reservationModel;


            onFormChange((0, _extends3.default)({}, reservationModel, {
                applications: selectedApplications
            }));
        };

        _this.onNoteChange = function (note) {
            var _this$props3 = _this.props,
                reservationModel = _this$props3.reservationModel,
                onFormChange = _this$props3.onFormChange;

            if (note !== reservationModel.note) {
                onFormChange((0, _extends3.default)({}, reservationModel, {
                    note: note
                }));
            }
        };

        _this.onStartDatetimeChange = function (startDate) {
            var _this$props4 = _this.props,
                reservationModel = _this$props4.reservationModel,
                onFormChange = _this$props4.onFormChange;

            if (startDate !== reservationModel.startDate) {
                onFormChange((0, _extends3.default)({}, reservationModel, {
                    startDate: startDate
                }));
            }
        };

        _this.onEndDatetimeChange = function (endDate) {
            var _this$props5 = _this.props,
                reservationModel = _this$props5.reservationModel,
                onFormChange = _this$props5.onFormChange;

            if (endDate !== reservationModel.endDate) {
                onFormChange((0, _extends3.default)({}, reservationModel, {
                    endDate: endDate
                }));
            }
        };

        _this.onEnvironmentPristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state = _this.state,
                applicationsPristine = _this$state.applicationsPristine,
                startDatePristine = _this$state.startDatePristine,
                startTimePristine = _this$state.startTimePristine,
                endDatePristine = _this$state.endDatePristine,
                endTimePristine = _this$state.endTimePristine,
                notePristine = _this$state.notePristine;


            _this.setState({ environmentPristine: pristine });
            var isFormPristine = pristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onApplicationsPristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state2 = _this.state,
                environmentPristine = _this$state2.environmentPristine,
                startDatePristine = _this$state2.startDatePristine,
                startTimePristine = _this$state2.startTimePristine,
                endDatePristine = _this$state2.endDatePristine,
                endTimePristine = _this$state2.endTimePristine,
                notePristine = _this$state2.notePristine;


            _this.setState({ applicationsPristine: pristine });
            var isFormPristine = pristine && environmentPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onStartDatePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state3 = _this.state,
                environmentPristine = _this$state3.environmentPristine,
                applicationsPristine = _this$state3.applicationsPristine,
                startTimePristine = _this$state3.startTimePristine,
                endDatePristine = _this$state3.endDatePristine,
                endTimePristine = _this$state3.endTimePristine,
                notePristine = _this$state3.notePristine;


            _this.setState({ startDatePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onStartTimePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state4 = _this.state,
                environmentPristine = _this$state4.environmentPristine,
                applicationsPristine = _this$state4.applicationsPristine,
                startDatePristine = _this$state4.startDatePristine,
                endDatePristine = _this$state4.endDatePristine,
                endTimePristine = _this$state4.endTimePristine,
                notePristine = _this$state4.notePristine;


            _this.setState({ startTimePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onEndDatePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state5 = _this.state,
                environmentPristine = _this$state5.environmentPristine,
                applicationsPristine = _this$state5.applicationsPristine,
                startDatePristine = _this$state5.startDatePristine,
                startTimePristine = _this$state5.startTimePristine,
                endTimePristine = _this$state5.endTimePristine,
                notePristine = _this$state5.notePristine;


            _this.setState({ endDatePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onEndTimePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state6 = _this.state,
                environmentPristine = _this$state6.environmentPristine,
                applicationsPristine = _this$state6.applicationsPristine,
                startDatePristine = _this$state6.startDatePristine,
                startTimePristine = _this$state6.startTimePristine,
                endDatePristine = _this$state6.endDatePristine,
                notePristine = _this$state6.notePristine;


            _this.setState({ endTimePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onNotePristine = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state7 = _this.state,
                environmentPristine = _this$state7.environmentPristine,
                applicationsPristine = _this$state7.applicationsPristine,
                startDatePristine = _this$state7.startDatePristine,
                startTimePristine = _this$state7.startTimePristine,
                endDatePristine = _this$state7.endDatePristine,
                endTimePristine = _this$state7.endTimePristine;


            _this.setState({ notePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onEnvironmentValidityChange = function (valid) {
            var onFormValidationChange = _this.props.onFormValidationChange;


            _this.isEnvironmentValid = valid;
            onFormValidationChange(_this.isReservationFormValid);
        };

        _this.onStartDateTimeValidityChange = function (valid) {
            var onFormValidationChange = _this.props.onFormValidationChange;


            _this.isStartDateTimeValid = valid;
            onFormValidationChange(_this.isReservationFormValid);
        };

        _this.onEndDateTimeValidityChange = function (valid) {
            var onFormValidationChange = _this.props.onFormValidationChange;


            _this.isEndDateTimeValid = valid;
            onFormValidationChange(_this.isReservationFormValid);
        };

        _this.state = {
            environmentPristine: true,
            applicationsPristine: true,
            startDatePristine: true,
            startTimePristine: true,
            endDatePristine: true,
            endTimePristine: true,
            notePristine: true
        };

        _this.isEnvironmentValid = false;
        _this.isStartDateTimeValid = false;
        _this.isEndDateTimeValid = false;
        return _this;
    }

    (0, _createClass3.default)(SidebarReservationForm, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                environments = _props.environments,
                isEditForm = _props.isEditForm,
                onCancel = _props.onCancel,
                onConfirm = _props.onConfirm,
                onDelete = _props.onDelete,
                reservationModel = _props.reservationModel,
                isSaveEnabled = _props.isSaveEnabled;


            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _lodash.orderBy)(environments.filter(function (env) {
                    return (0, _lodash.includes)(env.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                !!isEditForm ? _react2.default.createElement(
                    'h4',
                    null,
                    'Edit reservation'
                ) : _react2.default.createElement(
                    'h4',
                    null,
                    'New reservation'
                ),
                _react2.default.createElement(
                    'div',
                    { id: 'environment-reservation-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        disabled: isEditForm,
                        handlers: autocompleteHandlers,
                        metadata: environmentFieldMetadata,
                        model: reservationModel.environment,
                        objLabel: 'title',
                        onModelChange: this.onEnvironmentChange,
                        onPristinityChange: this.onEnvironmentPristineChange,
                        onValidityChange: this.onEnvironmentValidityChange }),
                    _react2.default.createElement(_applicationSelect2.default, {
                        model: reservationModel.applications,
                        onModelChange: this.onApplicationChange,
                        onPristinityChange: this.onApplicationsPristineChange,
                        suggestions: applications
                    }),
                    _react2.default.createElement(_widgets.WidgetDateTime, {
                        metadata: startDateFieldMetadata,
                        model: reservationModel.startDate,
                        onDatePristinityChange: this.onStartDatePristineChange,
                        onModelChange: this.onStartDatetimeChange,
                        onTimePristinityChange: this.onStartTimePristineChange,
                        onValidityChange: this.onStartDateTimeValidityChange }),
                    _react2.default.createElement(_widgets.WidgetDateTime, {
                        metadata: endDateFieldMetadata,
                        model: reservationModel.endDate,
                        onDatePristinityChange: this.onEndDatePristineChange,
                        onModelChange: this.onEndDatetimeChange,
                        onTimePristinityChange: this.onEndTimePristineChange,
                        onValidityChange: this.onEndDateTimeValidityChange }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: noteFieldMetadata,
                        model: reservationModel.note,
                        onModelChange: this.onNoteChange,
                        onPristinityChange: this.onNotePristine }),
                    _react2.default.createElement(
                        'div',
                        { className: 'text-right' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button cancel', onClick: onCancel },
                            'Cancel'
                        ),
                        isEditForm && _react2.default.createElement(
                            'button',
                            { className: 'button default', onClick: function onClick() {
                                    return onDelete(reservationModel.id);
                                } },
                            'Delete'
                        ),
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', disabled: !isSaveEnabled, onClick: onConfirm },
                            'Reserve'
                        )
                    )
                )
            );
        }
    }, {
        key: 'isReservationFormValid',
        get: function get() {
            return this.isEnvironmentValid && this.isStartDateTimeValid && this.isEndDateTimeValid;
        }
    }]);
    return SidebarReservationForm;
}(_react.Component);

SidebarReservationForm.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    environments: _propTypes2.default.arrayOf(_types.Environment).isRequired,
    isEditForm: _propTypes2.default.bool.isRequired,
    isSaveEnabled: _propTypes2.default.bool,
    onCancel: _propTypes2.default.func.isRequired,
    onConfirm: _propTypes2.default.func.isRequired,
    onDelete: _propTypes2.default.func.isRequired,
    onFormChange: _propTypes2.default.func.isRequired,
    onFormPristinityChange: _propTypes2.default.func.isRequired,
    onFormValidationChange: _propTypes2.default.func.isRequired,
    onReservationEnvironmentChange: _propTypes2.default.func.isRequired,
    reservationModel: _types.ReservationModel
};
exports.default = SidebarReservationForm;

/***/ }),

/***/ 3048:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _lodash = __webpack_require__(62);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var applicationFieldMetadata = {
    description: 'Applications that will use this environment',
    label: 'Applications',
    name: 'autocomplete',
    placeholder: 'Select applications...'
};

var ApplicationSelect = function (_Component) {
    (0, _inherits3.default)(ApplicationSelect, _Component);

    function ApplicationSelect(props) {
        (0, _classCallCheck3.default)(this, ApplicationSelect);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationSelect.__proto__ || (0, _getPrototypeOf2.default)(ApplicationSelect)).call(this, props));

        _this.getSuggestedApplications = function (_ref) {
            var metadata = _ref.metadata,
                objLabel = _ref.objLabel,
                suggestedElements = _ref.suggestedElements,
                value = _ref.value;
            var suggestions = _this.props.suggestions;

            var term = value.trim().toLowerCase();

            var apps = suggestions.filter(function (s) {
                return s.title.toLowerCase().indexOf(term) >= 0;
            }).map(function (s) {
                return { value: s.title };
            });

            return _promise2.default.resolve(apps);
        };

        _this.handleModelChange = function (changes) {
            var _this$props = _this.props,
                suggestions = _this$props.suggestions,
                onModelChange = _this$props.onModelChange;


            var selectedTitles = changes.map(function (ch) {
                return ch.value;
            });
            var selectedApplications = suggestions.filter(function (app) {
                return (0, _lodash.includes)(selectedTitles, app.title);
            });
            onModelChange(selectedApplications);
        };

        _this.applicationInputHandlers = {
            autocomplete: {
                addCandidates: _this.getSuggestedApplications.bind(_this)
            }
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationSelect, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                model = _props.model,
                onPristinityChange = _props.onPristinityChange;

            var selectedApplications = model.map(function (app) {
                return {
                    value: app.title,
                    label: app.title
                };
            });

            return _react2.default.createElement(_xlReactComponents.XlReactWidgetTags, {
                handlers: this.applicationInputHandlers,
                inputType: 'autocomplete',
                metadata: applicationFieldMetadata,
                model: selectedApplications,
                objLabel: 'value',
                onModelChange: this.handleModelChange,
                onPristinityChange: onPristinityChange,
                skin: 'checkbox',
                tagTransform: function tagTransform(_) {
                    return _;
                }
            });
        }
    }]);
    return ApplicationSelect;
}(_react.Component);

ApplicationSelect.propTypes = {
    model: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        title: _propTypes2.default.string
    })),
    onModelChange: _propTypes2.default.func.isRequired,
    onPristinityChange: _propTypes2.default.func.isRequired,
    suggestions: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        title: _propTypes2.default.string
    }))
};
ApplicationSelect.defaultProps = {
    model: [],
    suggestions: []
};
exports.default = ApplicationSelect;

/***/ }),

/***/ 3049:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WidgetDateTime = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(62);

var _xlReactComponents = __webpack_require__(47);

__webpack_require__(3050);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var WidgetDateTime = exports.WidgetDateTime = function (_Component) {
    (0, _inherits3.default)(WidgetDateTime, _Component);

    function WidgetDateTime(props) {
        (0, _classCallCheck3.default)(this, WidgetDateTime);

        var _this = (0, _possibleConstructorReturn3.default)(this, (WidgetDateTime.__proto__ || (0, _getPrototypeOf2.default)(WidgetDateTime)).call(this, props));

        _this.onStartDateChange = function (selectedDate) {
            var _this$props = _this.props,
                model = _this$props.model,
                onModelChange = _this$props.onModelChange;

            var startDate = (0, _lodash.clone)(model);
            startDate.setFullYear(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate());

            if (startDate !== model) {
                onModelChange(startDate);
            }
        };

        _this.onStartTimeChange = function (selectedDate) {
            var _this$props2 = _this.props,
                model = _this$props2.model,
                onModelChange = _this$props2.onModelChange;

            var startDate = (0, _lodash.clone)(model);
            startDate.setHours(selectedDate.getHours(), selectedDate.getMinutes());

            if (startDate !== model) {
                onModelChange(startDate);
            }
        };

        _this.onDatePristine = function (pristine) {
            var onDatePristinityChange = _this.props.onDatePristinityChange;


            _this.setState({ datePristine: pristine });
            onDatePristinityChange(pristine);
        };

        _this.onTimePristine = function (pristine) {
            var onTimePristinityChange = _this.props.onTimePristinityChange;


            _this.setState({ timePristine: pristine });
            onTimePristinityChange(pristine);
        };

        _this.onTimeValidityChange = function (valid) {
            var onValidityChange = _this.props.onValidityChange;


            _this.isTimeValid = valid;
            onValidityChange(_this.isFormValid);
        };

        _this.onDateValidityChange = function (valid) {
            var onValidityChange = _this.props.onValidityChange;


            _this.isDateValid = valid;
            onValidityChange(_this.isFormValid);
        };

        _this.state = {
            datePristine: true,
            timePristine: true
        };

        _this.isDateValid = false;
        _this.isTimeValid = false;
        return _this;
    }

    (0, _createClass3.default)(WidgetDateTime, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                disabled = _props.disabled,
                model = _props.model,
                metadata = _props.metadata;


            return _react2.default.createElement(
                'div',
                { className: 'xl-react-components widget-datetime' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: metadata }),
                _react2.default.createElement(
                    'div',
                    { className: 'date-time-wrapper' },
                    _react2.default.createElement(
                        'div',
                        { className: 'date-time-input' },
                        _react2.default.createElement(_xlReactComponents.XlReactWidgetDate, {
                            dateFormat: metadata.dateFormat,
                            disabled: disabled,
                            model: model,
                            onModelChange: this.onStartDateChange,
                            onPristinityChange: this.onDatePristine,
                            onValidityChange: this.onDateValidityChange }),
                        _react2.default.createElement(_xlReactComponents.XlReactWidgetTime, {
                            disabled: disabled,
                            model: model,
                            onModelChange: this.onStartTimeChange,
                            onPristinityChange: this.onTimePristine,
                            onValidityChange: this.onTimeValidityChange })
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'xl-react-components-description' },
                        _react2.default.createElement(
                            'div',
                            null,
                            metadata.description
                        )
                    )
                )
            );
        }
    }, {
        key: 'isFormValid',
        get: function get() {
            return this.isDateValid && this.isTimeValid;
        }
    }]);
    return WidgetDateTime;
}(_react.Component);

WidgetDateTime.propTypes = {
    disabled: _propTypes2.default.bool,
    metadata: _propTypes2.default.object,
    model: _propTypes2.default.any,
    onDatePristinityChange: _propTypes2.default.func.isRequired,
    onModelChange: _propTypes2.default.func.isRequired,
    onTimePristinityChange: _propTypes2.default.func.isRequired,
    onValidityChange: _propTypes2.default.func.isRequired
};

/***/ }),

/***/ 305:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var CHECKBOX_STATUSES = {
    CHECKED: 'checked',
    INDETERMINATE: 'indeterminate',
    UNCHECKED: 'unchecked'
};

exports.default = CHECKBOX_STATUSES;

/***/ }),

/***/ 3050:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3052:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WidgetMultiSelect = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _reactSelect = __webpack_require__(929);

var _reactSelect2 = _interopRequireDefault(_reactSelect);

var _widgetMultiselectModules = __webpack_require__(3061);

var _widgetMultiselect = __webpack_require__(3064);

var _colors = __webpack_require__(101);

var _colors2 = _interopRequireDefault(_colors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var customStyles = {
    control: function control(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            minHeight: 30,
            '&:hover': {},
            borderColor: state.isFocused ? _colors2.default.blue : _colors2.default.lightgray,
            boxShadow: state.isFocused ? '0 0 8px #F3F5F8' : 'none',
            outline: 0
        });
    },
    dropdownIndicator: function dropdownIndicator(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            padding: 0
        });
    },
    indicatorSeparator: function indicatorSeparator(providedStyle, state) {
        return {
            display: 'none'
        };
    },
    input: function input(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            margin: 0,
            padding: 0,
            boxShadow: 'none'
        });
    },
    menu: function menu(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            zIndex: 100,
            boxShadow: '0 10px 10px -10px #ADB9C3',
            border: 'solid 1px transparent',
            borderColor: _colors2.default.lightgray,
            marginTop: 2,
            marginBottom: 2
        });
    },
    menuList: function menuList(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            paddingTop: 0,
            paddingBottom: 0,
            maxHeight: 180
        });
    },
    multiValue: function multiValue(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            background: 'none',
            borderRadius: 'none',
            margin: 0,
            height: '28px',
            lineHeight: '28px'
        });
    },
    multiValueLabel: function multiValueLabel(providedStyle, state) {
        return {};
    },
    multiValueRemove: function multiValueRemove() {
        return {
            display: 'none'
        };
    },
    option: function option(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            padding: '7px 10px',
            backgroundColor: state.isFocused ? _colors2.default.background : state.isSelected ? 'rgba(0, 153, 204, 0.15)' : _colors2.default.white,
            WebkitTapHighlightColor: 'rgba(0, 153, 204, 0.15)',
            ':hover': { backgroundColor: _colors2.default.background },
            ':active': { 'backgroundColor': 'inherit' },
            color: state.isSelected ? 'inherit' : 'inherit'
        });
    },
    placeholder: function placeholder(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            margin: 0,
            color: _colors2.default.gray
        });
    },
    valueContainer: function valueContainer(providedStyle, state) {
        return (0, _extends3.default)({}, providedStyle, {
            padding: '1px 10px'
        });
    }
};

var WidgetMultiSelect = exports.WidgetMultiSelect = function (_Component) {
    (0, _inherits3.default)(WidgetMultiSelect, _Component);

    function WidgetMultiSelect() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, WidgetMultiSelect);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = WidgetMultiSelect.__proto__ || (0, _getPrototypeOf2.default)(WidgetMultiSelect)).call.apply(_ref, [this].concat(args))), _this), _this.changePristinityChange = function (pristine) {
            var onPristinityChange = _this.props.onPristinityChange;

            onPristinityChange(pristine);
        }, _this.handleSelect = function (selectedOptions) {
            _this.changePristinityChange(false);_this.props.onSelectChange(selectedOptions);
        }, _this.handleSelectAll = function () {
            _this.changePristinityChange(false);_this.props.onSelectChange(_this.props.options);
        }, _this.handleClearAll = function () {
            _this.changePristinityChange(false);_this.props.onSelectChange([]);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(WidgetMultiSelect, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                metadata = _props.metadata,
                model = _props.model,
                options = _props.options;


            return _react2.default.createElement(
                'div',
                { className: 'xl-react-components' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: metadata }),
                _react2.default.createElement(_reactSelect2.default, {
                    closeMenuOnSelect: false,
                    components: { DropdownIndicator: _widgetMultiselectModules.DropdownIndicator, MultiValueLabel: _widgetMultiselectModules.MultiValueLabel, Menu: _widgetMultiselectModules.Menu, Option: _widgetMultiselectModules.Option },
                    hideSelectedOptions: false,
                    isClearable: false,
                    isMulti: true,
                    noOptionsMessage: function noOptionsMessage() {
                        return metadata.noOptionMessage;
                    },
                    onChange: this.handleSelect,
                    onClearAll: this.handleClearAll,
                    onSelectAll: this.handleSelectAll,
                    options: options,
                    placeholder: metadata.placeholder,
                    styles: customStyles,
                    value: model
                }),
                _react2.default.createElement(
                    'div',
                    { className: 'xl-react-components-description' },
                    _react2.default.createElement(
                        'div',
                        null,
                        metadata.description
                    )
                )
            );
        }
    }]);
    return WidgetMultiSelect;
}(_react.Component);

WidgetMultiSelect.propTypes = {
    metadata: _propTypes2.default.object,
    model: _propTypes2.default.arrayOf(_widgetMultiselect.SelectModel),
    noOptionMessage: _propTypes2.default.string,
    onPristinityChange: _propTypes2.default.func,
    onSelectChange: _propTypes2.default.func,
    options: _propTypes2.default.arrayOf(_widgetMultiselect.SelectModel)
};
WidgetMultiSelect.defaultProps = {
    model: [],
    options: []
};

/***/ }),

/***/ 3061:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Option = exports.Menu = exports.MultiValueLabel = exports.DropdownIndicator = undefined;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactSelect = __webpack_require__(929);

__webpack_require__(3062);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DropdownIndicator = exports.DropdownIndicator = function DropdownIndicator(props) {
    return _reactSelect.components.DropdownIndicator && _react2.default.createElement(
        _reactSelect.components.DropdownIndicator,
        props,
        _react2.default.createElement(
            'span',
            { className: 'Select-arrow-zone' },
            _react2.default.createElement('span', { className: 'Select-arrow' })
        )
    );
};

var MultiValueLabel = exports.MultiValueLabel = function MultiValueLabel(props) {
    return _react2.default.createElement(
        _reactSelect.components.MultiValueLabel,
        props,
        props.children,
        ',\xA0'
    );
};
MultiValueLabel.propTypes = {
    children: _propTypes2.default.any
};

var Menu = exports.Menu = function Menu(props) {
    var _props$selectProps = props.selectProps,
        onSelectAll = _props$selectProps.onSelectAll,
        onClearAll = _props$selectProps.onClearAll;

    return _react2.default.createElement(
        _reactSelect.components.Menu,
        props,
        props.options.length > 0 ? _react2.default.createElement(
            'div',
            { className: 'multiselect-menu-actions' },
            _react2.default.createElement(
                'a',
                { onClick: onSelectAll },
                'Select all'
            ),
            _react2.default.createElement(
                'a',
                { onClick: onClearAll },
                'Clear all'
            )
        ) : null,
        props.children
    );
};
Menu.propTypes = {
    children: _propTypes2.default.any,
    options: _propTypes2.default.any,
    selectProps: _propTypes2.default.any
};

var Option = exports.Option = function Option(props) {
    return _react2.default.createElement(
        _reactSelect.components.Option,
        props,
        props.children
    );
};
Option.propTypes = {
    children: _propTypes2.default.any
};

/***/ }),

/***/ 3062:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3064:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SelectModel = undefined;

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SelectModel = exports.SelectModel = _propTypes2.default.shape({
    value: _propTypes2.default.string,
    label: _propTypes2.default.string
});

/***/ }),

/***/ 3065:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3067:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3068);

__webpack_require__(3077);

__webpack_require__(3096);

__webpack_require__(3162);

__webpack_require__(3167);

/***/ }),

/***/ 3068:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3069);

/***/ }),

/***/ 3069:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3070);

/***/ }),

/***/ 3070:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deliverySelector = __webpack_require__(3071);

var _deliveryItemSelector = __webpack_require__(3072);

var _deliveryTaskDetails = __webpack_require__(3073);

var _findOrCreateDeliveryTaskDetails = __webpack_require__(3076);

angular.module('xlrelease').component('deliverySelector', _deliverySelector.DeliverySelector).component('deliveryItemSelector', _deliveryItemSelector.DeliveryItemSelector).component('deliveryTaskDetails', _deliveryTaskDetails.DeliveryTaskDetails).component('findOrCreateDeliveryTaskDetails', _findOrCreateDeliveryTaskDetails.FindOrCreateDeliveryTaskDetails);

/***/ }),

/***/ 3071:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeliverySelector = undefined;

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _index = __webpack_require__(256);

var _deliveryPattern = __webpack_require__(274);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="form-group">\n    <label class="col-xs-3 control-label" for="deliveryId">\n        {{$ctrl.propertyDefinition.label}} <span class="error">*</span>\n    </label>\n\n    <div class="col-sm-9">\n        <div ng-if="$ctrl.isLoaded" xlr-dropdown-with-variables\n             name="$ctrl.propertyDefinition.name"\n             model="$ctrl.selectedDelivery"\n             variables="$ctrl.variables"\n             metadata="{name: $ctrl.propertyDefinition.name}"\n             on-change="$ctrl.onVariableChange()"\n             reset-value-on-toggle="true"\n             on-new="$ctrl.onVariableCreate(name, variableType, createdCallback)"\n             options="{placeholder: \'Select \' + $ctrl.propertyDefinition.label.toLowerCase() + \'...\', handlers: $ctrl.deliveryHandlers, required: true}"\n             read-only="$ctrl.readOnly"\n        ></div>\n        <div class="description" ng-class="{\'error\': !$ctrl.isDeliveryExist}">{{$ctrl.description}}</div>\n    </div>\n</div>\n';

var DeliverySelectorController = function () {
    function DeliverySelectorController($q, VariablesService, Ids) {
        (0, _classCallCheck3.default)(this, DeliverySelectorController);

        this.VariablesService = VariablesService;
        this.$q = $q;
        this.Ids = Ids;
    }

    (0, _createClass3.default)(DeliverySelectorController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.isLoaded = false;
            this.isDeliveryExist = true;
            this.description = this.propertyDefinition.description;
            this.selectedDelivery = { variable: undefined, value: undefined };
            if (this.VariablesService.containsOnlyVariable(this.deliveryId)) {
                this.selectedDelivery.variable = this.deliveryId;
                this.isLoaded = true;
            } else if (this.deliveryId) {
                this.$q.when(this.fetchDelivery(this.deliveryId)).then(function (delivery) {
                    _this.selectedDelivery.value = delivery;
                    _this.fireOnChange(_this.selectedDelivery, true);
                }, function (err) {
                    if (err.response.status === 404) {
                        _this.isDeliveryExist = false;
                        _this.selectedDelivery = {
                            variable: undefined,
                            value: { id: _this.deliveryId, title: _this.deliveryId }
                        };
                        _this.description = 'Currently selected delivery was deleted';
                    }
                }).finally(function () {
                    return _this.isLoaded = true;
                });
            } else {
                this.isLoaded = true;
            }

            this.searchDeliveries("").then(function (deliveries) {
                return _this.cachedDeliveries = deliveries;
            });

            this.deliveryHandlers = {
                addCandidates: function addCandidates(metadata, options) {
                    return _this.autocompleteHandler(_this.cachedDeliveries, options.term);
                },
                onSelect: function onSelect(newDelivery) {
                    _this.selectedDelivery = { value: newDelivery, variable: undefined };
                    _this.description = _this.propertyDefinition.description;
                    _this.isDeliveryExist = true;
                    _this.fireOnChange(_this.selectedDelivery);
                },
                removeElement: function removeElement() {
                    _this.selectedDelivery = { value: undefined, variable: undefined };
                    _this.description = _this.propertyDefinition.description;
                    _this.isDeliveryExist = true;
                    _this.fireOnChange(_this.selectedDelivery);
                }
            };
        }
    }, {
        key: 'autocompleteHandler',
        value: function autocompleteHandler(items, term) {
            var candidates = _.filter(items, function (item) {
                return item.title.toLowerCase().indexOf(term.toLowerCase()) !== -1;
            });
            return candidates.length > 0 ? _promise2.default.resolve(candidates) : this.searchDeliveries(term);
        }
    }, {
        key: 'onVariableCreate',
        value: function onVariableCreate(name, variableType, createdCallback) {
            this.onNewVariable({ name: name, variableType: variableType, createdCallback: createdCallback });
            this.fireOnChange(this.selectedDelivery);
        }
    }, {
        key: 'onVariableChange',
        value: function onVariableChange() {
            this.selectedDelivery = { value: undefined, variable: this.selectedDelivery.variable };
            this.description = this.propertyDefinition.description;
            this.isDeliveryExist = true;
            this.fireOnChange(this.selectedDelivery);
        }
    }, {
        key: 'fireOnChange',
        value: function fireOnChange(delivery, initialLoad) {
            this.onChange({
                deliveryId: delivery.variable || (delivery.value || {}).id,
                delivery: delivery.value,
                initialLoad: initialLoad
            });
        }
    }, {
        key: 'isPatternMode',
        value: function isPatternMode() {
            return this.mode === 'PATTERN';
        }
    }, {
        key: 'fetchDelivery',
        value: function fetchDelivery(deliveryId) {
            if (this.isPatternMode()) {
                return (0, _deliveryPattern.fetchDeliveryPattern)(deliveryId);
            } else {
                return (0, _index.getDelivery)(this.deliveryId, true).then(function (response) {
                    return response.data;
                });
            }
        }
    }, {
        key: 'searchDeliveries',
        value: function searchDeliveries(term) {
            if (this.isPatternMode()) {
                return (0, _deliveryPattern.searchDeliveryPatterns)({ title: term }).then(function (results) {
                    return _.sortBy(results, 'title');
                });
            } else {
                return (0, _index.fetchDeliveries)({
                    inProgress: true,
                    title: term
                }, 0, 100).then(function (response) {
                    return _.sortBy(response.data, 'title');
                });
            }
        }
    }, {
        key: 'getName',
        value: function getName(id) {
            return this.Ids.getName(id);
        }
    }]);
    return DeliverySelectorController;
}();

DeliverySelectorController.$inject = ['$q', 'VariablesService', 'Ids'];
var DeliverySelector = exports.DeliverySelector = {
    bindings: {
        deliveryId: '<',
        propertyDefinition: '<',
        variables: '<',
        readOnly: '<',
        onChange: '&',
        onNewVariable: '&',
        mode: '@'
    },
    controller: DeliverySelectorController,
    template: template
};

/***/ }),

/***/ 3072:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeliveryItemSelector = undefined;

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="form-group">\n    <label class="col-sm-3 control-label">{{$ctrl.propertyDefinition.label}} <span class="error">*</span></label>\n\n    <div class="col-sm-9">\n        <div xlr-template-from-value-or-variable-selector\n             name="$ctrl.propertyDefinition.name"\n             model="$ctrl.selectedItem"\n             variables="$ctrl.variables"\n             metadata="{name: $ctrl.propertyDefinition.name}"\n             on-change="$ctrl.onVariableChange()"\n             on-new="$ctrl.onVariableCreate(name, variableType, createdCallback)"\n             options="{placeholder: \'Select \' + $ctrl.propertyDefinition.label.toLowerCase() + \'...\', handlers: $ctrl.handlers, required: true}"\n             read-only="$ctrl.readOnly"\n        ></div>\n         <div class="description">{{$ctrl.propertyDefinition.description}}<span ng-show="$ctrl.isLinkEnabled()">. <a ng-click="$ctrl.onGetStages()" style="cursor: pointer;">Use delivery patterns to filter the list of stages</a></span></div>\n         </div>\n</div>\n';

var DeliveryItemSelectorController = function () {
    function DeliveryItemSelectorController(VariablesService) {
        (0, _classCallCheck3.default)(this, DeliveryItemSelectorController);

        this.VariablesService = VariablesService;
    }

    (0, _createClass3.default)(DeliveryItemSelectorController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.setSelectedItem(this.itemId, this.items);
            this.handlers = {
                addCandidates: function addCandidates(metadata, options) {
                    var matches = (_this.items || []).filter(function (item) {
                        return item.title.toLowerCase().indexOf(options.term.toLowerCase()) > -1;
                    });
                    return _promise2.default.resolve(matches);
                },
                onSelect: function onSelect(newItem) {
                    _this.selectedItem = { value: newItem, variable: undefined };
                    _this.fireOnChange(_this.selectedItem);
                },
                removeElement: function removeElement() {
                    _this.selectedItem = { value: undefined, variable: undefined };
                    _this.fireOnChange(_this.selectedItem);
                }
            };
        }
    }, {
        key: '$onChanges',
        value: function $onChanges(changes) {
            if (changes.itemId) {
                this.setSelectedItem(changes.itemId.currentValue, this.items);
            }
            if (changes.items && changes.items.currentValue) {
                this.setSelectedItem(this.itemId, changes.items.currentValue);
            }
        }
    }, {
        key: 'setSelectedItem',
        value: function setSelectedItem(itemId, items) {
            var _this2 = this;

            var isVariable = this.VariablesService.containsOnlyVariable(this.itemId);
            var variable = isVariable ? this.itemId : undefined;
            var value = !isVariable && items ? items.find(function (item) {
                return item.id === _this2.itemId || item.title === _this2.itemId;
            }) || { title: this.itemId } : undefined;
            this.selectedItem = { variable: variable, value: value };
        }
    }, {
        key: 'onVariableCreate',
        value: function onVariableCreate(name, variableType, createdCallback) {
            this.onNewVariable({ name: name, variableType: variableType, createdCallback: createdCallback });
            this.fireOnChange(this.selectedItem);
        }
    }, {
        key: 'onVariableChange',
        value: function onVariableChange() {
            this.selectedItem = { value: undefined, variable: this.selectedItem.variable };
            this.fireOnChange(this.selectedItem);
        }
    }, {
        key: 'fireOnChange',
        value: function fireOnChange(item, initialLoad) {
            this.onChange({ itemId: item.variable || (item.value || {}).id, initialLoad: initialLoad });
        }
    }, {
        key: 'isLinkEnabled',
        value: function isLinkEnabled() {
            return this.propertyDefinition && this.propertyDefinition.name === 'stage' && !this.readOnly && !this.delivery;
        }
    }]);
    return DeliveryItemSelectorController;
}();

DeliveryItemSelectorController.$inject = ['VariablesService'];
var DeliveryItemSelector = exports.DeliveryItemSelector = {
    bindings: {
        delivery: '<?',
        itemId: '<',
        items: '<',
        propertyDefinition: '<',
        variables: '<',
        readOnly: '<',
        onChange: '&',
        onNewVariable: '&',
        onGetStages: '&'
    },
    controller: DeliveryItemSelectorController,
    template: template
};

/***/ }),

/***/ 3073:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeliveryTaskDetails = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deliveryPattern = __webpack_require__(274);

__webpack_require__(3074);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="delivery-task-details">\n    <div class="form-horizontal" ng-form="releaseSyncTaskForm">\n        <div class="properties">\n            <ng-transclude></ng-transclude>\n        </div>\n    </div>\n</div>\n';

var DeliveryTaskDetailsController = function () {
    function DeliveryTaskDetailsController($scope, VariablesService) {
        var _this = this;

        (0, _classCallCheck3.default)(this, DeliveryTaskDetailsController);

        this.updateComponentModels = function (task) {
            _this.deliveryId = task.inputProperties.deliveryId;
            if (!task.inputProperties.patternId || _this.pattern.id !== task.inputProperties.patternId) {
                _this.pattern = null;
            }
            _this.stageId = task.inputProperties.stage;
        };

        this.$scope = $scope;
        this.VariablesService = VariablesService;
    }

    (0, _createClass3.default)(DeliveryTaskDetailsController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this2 = this;

            this.deliveryId = this.task.inputProperties.deliveryId;
            if (this.VariablesService.containsOnlyVariable(this.deliveryId)) {
                this.delivery = null;
            }

            if (this.task.inputProperties.status) {
                this.status = this.task.inputProperties.status.value || "READY";
                this.statusOptions = [];
                if (this.task.scriptDefinitionType === 'delivery.WaitForTrackedItems') {
                    this.statusOptions = [{ title: 'Completed', value: 'READY' }, { title: 'Available', value: 'NOT_READY' }];
                } else if (this.task.scriptDefinitionType === 'delivery.MarkTrackedItems') {
                    this.statusOptions = [{ title: 'Completed', value: 'READY' }, { title: 'Skipped', value: 'SKIPPED' }];
                }
            }

            if (this.task.inputProperties.patternId) {
                this.fetchDeliveryPattern();
            }
            this.stageId = this.task.inputProperties.stage;

            this.dpHandlers = {
                addCandidates: function addCandidates(metadata, options) {
                    return (0, _deliveryPattern.searchDeliveryPatterns)({ title: options.term });
                },
                onSelect: function onSelect(newPattern) {
                    _this2.task.inputProperties.patternId = newPattern.id;
                    _this2.task.inputProperties.stage = _this2.updateStageValue(_this2.task.inputProperties.stage);

                    _this2.onChange(_this2.task);
                    _this2.updateComponentModels(_this2.task);
                },
                removeElement: function removeElement() {
                    _this2.task.inputProperties.patternId = null;
                    _this2.task.inputProperties.stage = _this2.updateStageValue(_this2.task.inputProperties.stage);

                    _this2.onChange(_this2.task);
                    _this2.updateComponentModels(_this2.task);
                }
            };
            this.showDeliveryPattern = !!this.task.inputProperties.patternId && !!this.deliveryId;
        }
    }, {
        key: 'fetchDeliveryPattern',
        value: function fetchDeliveryPattern() {
            var _this3 = this;

            (0, _deliveryPattern.searchDeliveryPatterns)().then(function (data) {
                _this3.pattern = data.find(function (p) {
                    return p.id === _this3.task.inputProperties.patternId;
                });
                _this3.$scope.$digest();
            });
        }
    }, {
        key: 'onGetStages',
        value: function onGetStages() {
            this.showDeliveryPattern = true;
        }
    }, {
        key: 'onDeliveryChange',
        value: function onDeliveryChange(deliveryId, delivery, initialLoad) {
            this.delivery = delivery;
            this.task.inputProperties.deliveryId = deliveryId;

            if (initialLoad) {
                this.$scope.$digest(); // React...
            } else {
                if (!delivery && this.VariablesService.containsOnlyVariable(deliveryId) && !this.showDeliveryPattern) {
                    this.task.inputProperties.stage = this.updateStageValue(this.task.inputProperties.stage);
                }

                if (!!delivery || !deliveryId && !delivery) {
                    this.showDeliveryPattern = false;
                    this.task.inputProperties.patternId = null;
                    this.task.inputProperties.stage = this.updateStageValue(this.task.inputProperties.stage);
                }

                this.onChange(this.task);
                this.updateComponentModels(this.task);
            }
        }
    }, {
        key: 'onStageChange',
        value: function onStageChange(stageId, initialLoad) {
            this.task.inputProperties.stage = stageId;
            if (!initialLoad) {
                this.onChange(this.task);
                this.updateComponentModels(this.task);
            }
        }
    }, {
        key: 'updateStageValue',
        value: function updateStageValue(stage) {
            var isStageVariable = this.VariablesService.containsOnlyVariable(this.stageId);
            if (isStageVariable) {
                return stage;
            } else {
                return null;
            }
        }
    }, {
        key: 'inputMetadataWithout',
        value: function inputMetadataWithout(excludedProperties) {
            if (!this.filteredInputMetadata && this.inputMetadata) {
                this.filteredInputMetadata = this.inputMetadata.filter(function (property) {
                    return !excludedProperties.includes(property.name);
                });
            }
            return this.filteredInputMetadata;
        }
    }, {
        key: 'hasProperty',
        value: function hasProperty(propertyName) {
            return !!this.getProperty(propertyName);
        }
    }, {
        key: 'getProperty',
        value: function getProperty(propertyName) {
            return this.inputMetadata ? this.inputMetadata.find(function (property) {
                return property.name === propertyName;
            }) : undefined;
        }
    }, {
        key: 'onStatusChange',
        value: function onStatusChange() {
            this.task.inputProperties.status = { value: this.status };
            this.onChange(this.task);
        }
    }, {
        key: 'stages',
        get: function get() {
            if (this.showDeliveryPattern && !!this.pattern) {
                return this.pattern.stages;
            } else if (!this.showDeliveryPattern && !!this.delivery) {
                return this.delivery.stages;
            }
        }
    }]);
    return DeliveryTaskDetailsController;
}();

DeliveryTaskDetailsController.$inject = ['$scope', 'VariablesService'];
var DeliveryTaskDetails = exports.DeliveryTaskDetails = {
    bindings: {
        task: '<',
        variables: '<',
        readOnly: '<',
        onNewVariable: '&',
        onChange: '&',
        inputMetadata: '<'
    },
    transclude: true,
    controller: DeliveryTaskDetailsController,
    template: template
};

/***/ }),

/***/ 3074:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3076:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FindOrCreateDeliveryTaskDetails = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="find-or-create-delivery-task-details">\n    <div class="form-horizontal" data-ng-form="releaseSyncTaskForm">\n        <div class="properties">\n            <ng-transclude></ng-transclude>\n        </div>\n    </div>\n</div>\n';

var FindOrCreateDeliveryTaskDetailsController = function () {
    function FindOrCreateDeliveryTaskDetailsController($scope) {
        (0, _classCallCheck3.default)(this, FindOrCreateDeliveryTaskDetailsController);

        this.$scope = $scope;
    }

    (0, _createClass3.default)(FindOrCreateDeliveryTaskDetailsController, [{
        key: '$onInit',
        value: function $onInit() {
            this.patternId = this.task.inputProperties.patternId;
        }
    }, {
        key: 'onPatternChange',
        value: function onPatternChange(patternId, pattern, initialLoad) {
            this.pattern = pattern;
            this.task.inputProperties.patternId = patternId;
            if (initialLoad) {
                this.$scope.$digest(); // React...
            } else {
                this.onChange(this.task);
            }
        }
    }, {
        key: 'inputMetadataWithout',
        value: function inputMetadataWithout(excludedProperties) {
            if (!this.filteredInputMetadata && this.inputMetadata) {
                this.filteredInputMetadata = this.inputMetadata.filter(function (property) {
                    return !excludedProperties.includes(property.name);
                });
            }
            return this.filteredInputMetadata;
        }
    }, {
        key: 'hasProperty',
        value: function hasProperty(propertyName) {
            return !!this.getProperty(propertyName);
        }
    }, {
        key: 'getProperty',
        value: function getProperty(propertyName) {
            return this.inputMetadata ? this.inputMetadata.find(function (property) {
                return property.name === propertyName;
            }) : undefined;
        }
    }, {
        key: 'searchStrategyInputProperty',
        get: function get() {
            if (!this.searchStrategyInput) {
                this.searchStrategyInput = this.getProperty('searchStrategy');
            }
            return this.searchStrategyInput;
        }
    }, {
        key: 'nameFilterInputProperty',
        get: function get() {
            if (!this.nameFilterInput) {
                this.nameFilterInput = this.getProperty('nameFilter');
            }
            return this.nameFilterInput;
        }
    }, {
        key: 'selectionStrategyInputProperty',
        get: function get() {
            if (!this.selectionStrategyInput) {
                this.selectionStrategyInput = this.getProperty('selectionStrategy');
            }
            return this.selectionStrategyInput;
        }
    }, {
        key: 'fallbackProperty',
        get: function get() {
            if (!this.fallback) {
                this.fallback = this.getProperty('fallback');
            }
            return this.fallback;
        }
    }]);
    return FindOrCreateDeliveryTaskDetailsController;
}();

FindOrCreateDeliveryTaskDetailsController.$inject = ['$scope'];
var FindOrCreateDeliveryTaskDetails = exports.FindOrCreateDeliveryTaskDetails = {
    bindings: {
        task: '<',
        variables: '<',
        readOnly: '<',
        onNewVariable: '&',
        onChange: '&',
        inputMetadata: '<'
    },
    transclude: true,
    controller: FindOrCreateDeliveryTaskDetailsController,
    template: template
};

/***/ }),

/***/ 3077:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _releaseStatusLabel = __webpack_require__(427);

var _deliveryList = __webpack_require__(3078);

var _deliveryRow = __webpack_require__(3081);

var _deleteDeliveriesModalComponent = __webpack_require__(3084);

var _deliveryFilter = __webpack_require__(3085);

var _deliverySubHeader = __webpack_require__(3090);

var _deliveriesComponent = __webpack_require__(3092);

var _deliveriesComponent2 = _interopRequireDefault(_deliveriesComponent);

__webpack_require__(3094);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = angular.module('xlrelease.deliveries', []).component('deliveryStatusLabel', _releaseStatusLabel.releaseStatusLabelComponent).component('xlrDeliveryList', _deliveryList.deliveryListComponent).component('xlrDeliveryRow', _deliveryRow.deliveryRowComponent).component('confirmDeleteDelivery', _deleteDeliveriesModalComponent.ConfirmDeleteDelivery).component('deliveryFilter', _deliveryFilter.deliveryFilter).component('deliverySubHeader', _deliverySubHeader.deliverySubHeader).component('deliveries', _deliveriesComponent2.default).config(['$stateProvider', function ($stateProvider) {
    $stateProvider.state('deliveries', {
        url: '/deliveries',
        reloadOnSearch: false,
        controller: ['filters', function (filters) {
            this.filters = filters;
        }],
        template: '<deliveries filters="$ctrl.filters" />',
        controllerAs: '$ctrl',
        resolve: {
            filters: ['Filters', function (Filters) {
                return Filters.getDeliveriesFilterSettings();
            }]
        }
    });
}]).name;

/***/ }),

/***/ 3078:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliveryListComponent = undefined;

var _deliveryListController = __webpack_require__(3079);

var _deliveryListController2 = _interopRequireDefault(_deliveryListController);

var _deliveryListTpl = __webpack_require__(3080);

var _deliveryListTpl2 = _interopRequireDefault(_deliveryListTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deliveryListComponent = exports.deliveryListComponent = {
    bindings: {
        deliveries: '<',
        deliveriesLoadingStatus: '<',
        deliveriesHasMore: '<',
        onShowMoreDeliveries: '&'
    },
    controller: _deliveryListController2.default,
    template: _deliveryListTpl2.default
};

/***/ }),

/***/ 3079:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryListController = function () {
    function DeliveryListController() {
        (0, _classCallCheck3.default)(this, DeliveryListController);
    }

    (0, _createClass3.default)(DeliveryListController, [{
        key: 'showMore',
        value: function showMore() {
            this.onShowMoreDeliveries();
        }
    }, {
        key: 'getDeliveries',
        value: function getDeliveries() {
            return this.deliveries.toJS();
        }
    }, {
        key: 'hasDeliveries',
        value: function hasDeliveries() {
            return _.get(this, 'deliveries.size');
        }
    }, {
        key: 'hasMoreDeliveries',
        value: function hasMoreDeliveries() {
            return this.deliveriesHasMore && !this.deliveriesLoadingStatus;
        }
    }]);
    return DeliveryListController;
}();

exports.default = DeliveryListController;

/***/ }),

/***/ 3080:
/***/ (function(module, exports) {

module.exports = "<div class=\"content-under-header fc-list-items\">\n    <div class=\"row\" ng-if=\"$ctrl.deliveries.size\">\n        <div class=\"col-xs-12\">\n            <xlr-infinite-scroll-wrapper\n                    on-show-more=\"$ctrl.showMore()\"\n                    disable-when=\"!$ctrl.hasMoreDeliveries()\"\n                    show-loader-when=\"$ctrl.deliveriesLoadingStatus\">\n                <div ng-repeat=\"delivery in $ctrl.getDeliveries()\"\n                     ng-class=\"{'fc-list-item-first': $first}\"\n                     class=\"row fc-list-item fc-list-loaded\"\n                     xlr-infinite-scroll>\n                    <xlr-delivery-row delivery=\"delivery\"></xlr-delivery-row>\n                </div>\n            </xlr-infinite-scroll-wrapper>\n        </div>\n    </div>\n    <div class=\"alert notice fc-list-loaded\" ng-if=\"!$ctrl.hasDeliveries() && !$ctrl.deliveriesLoadingStatus\">\n        No deliveries found.\n    </div>\n</div>\n"

/***/ }),

/***/ 3081:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliveryRowComponent = undefined;

var _deliveryRowController = __webpack_require__(3082);

var _deliveryRowController2 = _interopRequireDefault(_deliveryRowController);

var _deliveryRowTpl = __webpack_require__(3083);

var _deliveryRowTpl2 = _interopRequireDefault(_deliveryRowTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deliveryRowComponent = exports.deliveryRowComponent = {
    bindToController: true,
    bindings: {
        delivery: '<'
    },
    controllerAs: '$ctrl',
    controller: _deliveryRowController2.default,
    template: _deliveryRowTpl2.default
};

/***/ }),

/***/ 3082:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deliveriesActions = __webpack_require__(292);

var _services = __webpack_require__(256);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryRowController = function () {
    function DeliveryRowController(Authenticator, ReleasesService, DateService, $ngRedux, $location, $uibModal) {
        (0, _classCallCheck3.default)(this, DeliveryRowController);

        this._releasesService = ReleasesService;
        this._dateService = DateService;
        this._security = Authenticator;
        this._$location = $location;
        this._$uibModal = $uibModal;
        this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.bind(this))(this);
    }

    (0, _createClass3.default)(DeliveryRowController, [{
        key: "$onDestroy",
        value: function $onDestroy() {
            this._unsubscribe();
        }
    }, {
        key: "_mapDispatchToThis",
        value: function _mapDispatchToThis(dispatch) {
            return {
                delete: function _delete(id) {
                    return dispatch((0, _deliveriesActions.deleteDelivery)(id));
                }
            };
        }
    }, {
        key: "hasDuration",
        value: function hasDuration() {
            return this.delivery.status === 'IN_PROGRESS' && this.delivery.startDate && this.delivery.endDate;
        }
    }, {
        key: "getFormattedDuration",
        value: function getFormattedDuration() {
            if (this.hasDuration()) {
                var currentDate = this._dateService.getTodayWithTime();
                var end = moment(this.delivery.endDate);
                var diff = end.diff(currentDate);
                var duration = moment.duration(diff);
                if (duration.asMinutes() < 1 && duration.asMinutes() >= -1) {
                    return "1m";
                } else if (duration.asMinutes() < -1) {
                    var displayDate = duration.format('d[d] h[h] m[m]');
                    displayDate = displayDate.substr(1, displayDate.length);
                    return "Overdue " + displayDate;
                }
                return duration.format('d[d] h[h] m[m]');
            }
        }
    }, {
        key: "getNumberOfTrackedItems",
        value: function getNumberOfTrackedItems() {
            return _.get(this.delivery, 'trackedItems.length') || 0;
        }
    }, {
        key: "isUpdatable",
        value: function isUpdatable(delivery) {
            return (0, _services.isDeliveryUpdatable)(delivery) && this._security.hasDeliveryEditPermission(delivery);
        }
    }, {
        key: "isOverdue",
        value: function isOverdue(date) {
            if (date.indexOf('Overdue') > -1) {
                return true;
            }
            return this._dateService.isOverdue(date);
        }
    }, {
        key: "deleteDelivery",
        value: function deleteDelivery(_delivery) {
            var _this = this;

            this._$uibModal.open({
                animation: false,
                component: 'confirmDeleteDelivery',
                resolve: {
                    delivery: function delivery() {
                        return _delivery;
                    }
                }
            }).result.then(function (confirm) {
                if (confirm) {
                    _this.delete(_delivery.id);
                }
            });
        }
    }, {
        key: "updateDelivery",
        value: function updateDelivery(delivery) {
            this._$location.url("/deliveries/" + delivery.id);
        }
    }]);
    return DeliveryRowController;
}();

DeliveryRowController.$inject = ['Authenticator', 'ReleasesService', 'DateService', '$ngRedux', '$location', '$uibModal'];
exports.default = DeliveryRowController;

/***/ }),

/***/ 3083:
/***/ (function(module, exports) {

module.exports = "<div class=\"col-xs-12 raised-link-wrapper\">\n    <div class=\"fc-list-item-line\">\n        <div class=\"row\">\n            <div class=\"fc-list-item-wrapper\">\n                <a class=\"col-xs-6 raised-link\" href=\"#/deliveries/{{$ctrl.delivery.id}}\"></a>\n                <div class=\"col-xs-3 fc-list-item-title-wrapper\">\n                    <div class=\"fc-list-item-title\">\n                      <i class=\"xl-icon group-icon icon-l\"></i>\n                      <strong class=\"raised-link-target\">\n                          {{$ctrl.delivery.title}}\n                      </strong>\n                    </div>\n                    <div class=\"fc-list-item-item-count\">\n                        <ng-pluralize count=\"$ctrl.getNumberOfTrackedItems()\"\n                                      when=\"{'one': '{} tracked item', 'other': '{} tracked items'}\"></ng-pluralize>\n                    </div>\n                </div>\n                <div class=\"col-xs-9 fc-list-item-content-wrapper\">\n                    <div class=\"row\">\n                        <div class=\"col-xs-2 col-xs-offset-2 fc-list-item-content\">\n                            <delivery-status-label release=\"$ctrl.delivery\" show-archived=\"true\"></delivery-status-label>\n                        </div>\n                        <div class=\"col-xs-2 fc-list-item-content\">\n                            <span ng-if=\"$ctrl.delivery.startDate\">\n                                {{$ctrl.delivery.startDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 fc-list-item-content\">\n                            <span ng-if=\"$ctrl.delivery.endDate\">\n                                {{$ctrl.delivery.endDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 duration fc-list-item-content\" ng-class=\"{'date-overdue': $ctrl.hasDuration() && $ctrl.isOverdue($ctrl.getFormattedDuration())}\">\n                            <span ng-if=\"$ctrl.hasDuration()\">{{$ctrl.getFormattedDuration()}}</span>\n                        </div>\n                        <div class=\"col-xs-2 text-centered fc-list-item-actions\">\n                          <!-- div ng-if=\"vm.isAbortActionAvailable() && !vm.isStartActionAvailable()\" class=\"link\"\n                               scope-less-modal=\"'partials/releases/abort-release-modal-ctrl-binding.html'\" ctrl=\"vm\">\n                              <i class=\"xl-icon cancel-icon\"></i> Abort\n                          </div> -->\n\n                            <div class=\"fc-list-item-actions-button fc-item-update link\" ng-if=\"$ctrl.isUpdatable($ctrl.delivery)\"\n                                  ng-click=\"$ctrl.updateDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon edit-icon\"></i>\n                                <span class=\"action-label\">Edit</span>\n                            </div>\n                            <div class=\"fc-list-item-actions-button fc-item-delete link\" ng-if=\"$ctrl.isUpdatable($ctrl.delivery)\"\n                                  ng-click=\"$ctrl.deleteDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon delete-icon\"></i>\n                                <span class=\"action-label\">Delete</span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 3084:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var template = '\n    <div class="modal-header">\n        <h4 class="modal-title pull-left" id="modal-title">Delete release delivery</h4>\n        <button type="button" class="close pull-right" ng-click="$ctrl.close()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix"/>\n    </div>\n    <div class="modal-body" id="modal-body">\n        You are about to delete the release delivery <strong>{{::$ctrl.resolve.delivery.title}}</strong>.\n    </div>\n    <div class="modal-footer">\n        <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n        <button class="button continue primary" type="button" focus-on="true" ng-click="$ctrl.close({$value: true})">Delete</button>\n    </div>\n';

var ConfirmDeleteDelivery = exports.ConfirmDeleteDelivery = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    template: template
};

/***/ }),

/***/ 3085:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliveryFilter = undefined;

var _deliveryFilterTpl = __webpack_require__(3086);

var _deliveryFilterTpl2 = _interopRequireDefault(_deliveryFilterTpl);

var _deliveryFilterController = __webpack_require__(3087);

var _deliveryFilterController2 = _interopRequireDefault(_deliveryFilterController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deliveryFilter = exports.deliveryFilter = {
    bindings: {
        filters: '<',
        itemsCount: '<',
        filtersChanged: '&'
    },
    template: _deliveryFilterTpl2.default,
    controller: _deliveryFilterController2.default
};

/***/ }),

/***/ 3086:
/***/ (function(module, exports) {

module.exports = "<filter class=\"fc-list-header-filter\" filters=\"$ctrl.filters\" on-change=\"$ctrl.filtersChanged(filters)\">\n    <div class=\"fc-list-header-filter-basic\">\n        <text-filter field=\"'title'\" class=\"delivery\" placeholder=\"'Search for deliveries...'\"></text-filter>\n        <span>\n            <release-filter-status statuses=\"$ctrl.statusOptions\"></release-filter-status>\n            <order-by-filter order-options=\"$ctrl.orderOptions\" class=\"filter last\"></order-by-filter>\n        </span>\n        <div class=\"buttons\">\n            <span class=\"pull-right filter-all\" ng-if=\"$ctrl.itemsCount.live.total > 0\"\n                  bs-tooltip placement=\"bottom\" template=\"{{$ctrl.itemCountTemplate}}\">\n                <span ng-pluralize\n                      count=\"$ctrl.itemsCount.live.total\"\n                      when=\"{'1': '{} delivery', 'other': '{} deliveries', 'few': '{} deliveries', 'many': '{} deliveries'}\"\n                      style=\"font-weight: bold\"></span>\n            </span>\n\n            <span class=\"fc-list-header-doc-icon\" doc-icon=\"deliveries.html\"></span>\n        </div>\n    </div>\n</filter>\n"

/***/ }),

/***/ 3087:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlReactComponents = __webpack_require__(47);

var _colors = __webpack_require__(101);

var _colors2 = _interopRequireDefault(_colors);

var _itemsCountTpl = __webpack_require__(426);

var _itemsCountTpl2 = _interopRequireDefault(_itemsCountTpl);

__webpack_require__(3088);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryListHeaderController = function () {
    function DeliveryListHeaderController() {
        (0, _classCallCheck3.default)(this, DeliveryListHeaderController);
    }

    (0, _createClass3.default)(DeliveryListHeaderController, [{
        key: '$onInit',
        value: function $onInit() {
            this.statusOptions = [{ label: 'In progress', value: 'In progress', color: _colors2.default.blue }, { label: 'Completed', value: 'Completed', color: _colors2.default.green }];
            this.orderOptions = [{
                label: 'Start date',
                filter: 'start_date'
            }, {
                label: 'End date',
                filter: 'end_date'
            }];

            this.itemCountTemplate = _itemsCountTpl2.default;
        }
    }]);
    return DeliveryListHeaderController;
}();

exports.default = DeliveryListHeaderController;

/***/ }),

/***/ 3088:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3090:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliverySubHeader = undefined;

var _deliverySubHeaderTpl = __webpack_require__(3091);

var _deliverySubHeaderTpl2 = _interopRequireDefault(_deliverySubHeaderTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deliverySubHeader = exports.deliverySubHeader = {
    bindings: {
        hasDeliveries: '&'
    },
    template: _deliverySubHeaderTpl2.default
};

/***/ }),

/***/ 3091:
/***/ (function(module, exports) {

module.exports = "<div class=\"container-fluid fc-list-sub-header\" ng-if=\"$ctrl.hasDeliveries()\">\n    <div class=\"col-xs-12\">\n        <div class=\"row\">\n            <div class=\"col-xs-3\">\n                <div class=\"release-table-text\">Name</div>\n            </div>\n            <div class=\"col-xs-9\">\n                <div class=\"row\">\n                    <div class=\"col-xs-4\"></div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">Start date</div>\n                    </div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">End date</div>\n                    </div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">Remaining duration</div>\n                    </div>\n                    <div class=\"col-xs-2\"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 3092:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _deliveriesTpl = __webpack_require__(3093);

var _deliveriesTpl2 = _interopRequireDefault(_deliveriesTpl);

var _deliveriesController = __webpack_require__(916);

var _deliveriesController2 = _interopRequireDefault(_deliveriesController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
    bindings: {
        filters: '<'
    },
    controller: _deliveriesController2.default,
    template: _deliveriesTpl2.default
};

/***/ }),

/***/ 3093:
/***/ (function(module, exports) {

module.exports = "<div class=\"fc-list f-deliveries header\" id=\"deliveries\">\n    <div class=\"fc-list-header\">\n        <div class=\"fc-list-header-actions\">\n            <delivery-filter filters=\"$ctrl.filters\"\n                             filters-changed=\"$ctrl.filtersChanged()\"\n                             items-count=\"$ctrl.itemsCount\"></delivery-filter>\n            <delivery-sub-header has-deliveries=\"$ctrl.hasDeliveries()\"></delivery-sub-header>\n        </div>\n    </div>\n    <div class=\"fc-list-items-wrapper\">\n        <xlr-delivery-list deliveries=\"$ctrl.deliveries\"\n                           deliveries-loading-status=\"$ctrl.loading\"\n                           deliveries-has-more=\"$ctrl.hasMoreDeliveries\"\n                           on-show-more-deliveries=\"$ctrl.loadMoreDeliveries()\">\n        </xlr-delivery-list>\n    </div>\n</div>\n"

/***/ }),

/***/ 3094:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3096:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _header = __webpack_require__(3097);

var _deliveryDetailsPageExtensionContainer = __webpack_require__(917);

var _deliveryDetailsPageExtensionContainer2 = _interopRequireDefault(_deliveryDetailsPageExtensionContainer);

var _deliveriesDetailsPageExtensionController = __webpack_require__(918);

__webpack_require__(3100);

var _index = __webpack_require__(553);

var _deliveryFlow = __webpack_require__(920);

var _deliveryActivityLogs = __webpack_require__(3160);

var _deliveryActivityLogs2 = _interopRequireDefault(_deliveryActivityLogs);

var _deliveryActivityLogsController = __webpack_require__(3161);

var _deliveryActivityLogsController2 = _interopRequireDefault(_deliveryActivityLogsController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = angular.module('xlrelease.deliveriesDetails').component('xlrDeliveryDetailsHeader', _header.deliveryDetailsHeader).config(['$urlMatcherFactoryProvider', '$stateProvider', function ($urlMatcherFactoryProvider, $stateProvider) {

    $urlMatcherFactoryProvider.type('DeliveryId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: /Deliveries\/Delivery\w+/
    });

    $stateProvider.state('deliveryCreate', {
        url: '/deliveries/create?fromPatternId',
        controller: ['$stateParams', '$window', 'Ids', function ($stateParams, $window, Ids) {
            //redirect to previous page when patternId is not defined
            this.patternId = $stateParams.fromPatternId ? Ids.toDomainId($stateParams.fromPatternId) : $window.history.back();
        }],
        controllerAs: 'deliveryCreateCtrl',
        template: '\n                    <div id="delivery-details">\n                        <xlr-delivery-details-header>\n                            <h4>Create new delivery</h4>\n                            <div class="buttons">\n                                <xlr-delivery-properties-header></xlr-delivery-properties-header>\n                                <span doc-icon="deliveries.html"></span>\n                            </div>\n                        </xlr-delivery-details-header>\n                    \n                        <div class="content-under-header">\n                            <xlr-delivery-properties pattern-id="deliveryCreateCtrl.patternId"></xlr-delivery-properties>\n                        </div>\n                    </div>'
    }).state('deliveriesDetails', {
        url: '/deliveries/{deliveryId: DeliveryId}',
        reloadOnSearch: false,
        template: _deliveryDetailsPageExtensionContainer2.default,
        controller: _deliveriesDetailsPageExtensionController.DeliveryDetailsPageExtensionController,
        controllerAs: 'deliveryDetailsPageExtension',
        resolve: {
            deliveryPromise: ['$stateParams', function ($stateParams) {
                return _promise2.default.all([(0, _index.fetchDelivery)($stateParams.deliveryId), _deliveryFlow.deliveryFlowService.fetchStageReleases($stateParams.deliveryId)]).then(function (responses) {
                    return responses;
                });
            }]
        }
    }).state('deliveryLogs', {
        url: '/deliveries/{deliveryId: DeliveryId}/logs',
        reloadOnSearch: false,
        template: _deliveryActivityLogs2.default,
        controller: _deliveryActivityLogsController2.default,
        controllerAs: '$ctrl',
        resolve: {
            filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
                return Filters.getLogsFiltersSettings($stateParams.deliveryId);
            }],
            deliveryPromise: ['$stateParams', function ($stateParams) {
                return (0, _index.fetchDelivery)($stateParams.deliveryId);
            }]
        }
    }).state('deliveryDetailsPageExtension', {
        url: '/deliveries/{deliveryId: DeliveryId}/:extensionPath',
        template: _deliveryDetailsPageExtensionContainer2.default,
        controller: _deliveriesDetailsPageExtensionController.DeliveryDetailsPageExtensionController,
        controllerAs: 'deliveryDetailsPageExtension',
        resolve: {
            deliveryPromise: ['$stateParams', function ($stateParams) {
                if ($stateParams.extensionPath === "") {
                    return _promise2.default.all([(0, _index.fetchDelivery)($stateParams.deliveryId), _deliveryFlow.deliveryFlowService.fetchStageReleases($stateParams.deliveryId)]).then(function (responses) {
                        return responses;
                    });
                }
                return (0, _index.fetchDelivery)($stateParams.deliveryId);
            }]
        }
    });
}]).name;

/***/ }),

/***/ 3097:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliveryDetailsHeader = undefined;

var _deliveryHeaderController = __webpack_require__(3098);

var _deliveryHeader = __webpack_require__(3099);

var _deliveryHeader2 = _interopRequireDefault(_deliveryHeader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deliveryDetailsHeader = exports.deliveryDetailsHeader = {
    bindings: {
        delivery: '<?'
    },
    template: _deliveryHeader2.default,
    replace: true,
    transclude: true,
    controller: _deliveryHeaderController.DeliveryHeaderController,
    controllerAs: '$ctrl'
};

/***/ }),

/***/ 3098:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeliveryHeaderController = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryHeaderController = exports.DeliveryHeaderController = function () {
    function DeliveryHeaderController($parse, $location, UiExtensionsService, Page) {
        var _this = this;

        (0, _classCallCheck3.default)(this, DeliveryHeaderController);

        this.isSubpageDisplayed = function (subpage) {
            if (_.isString(subpage.displayIf)) {
                var displayFunction = _this._$parse(subpage.displayIf);
                return displayFunction(_this);
            }
            return !subpage.hidden;
        };

        this.getSubpageLink = function (subpage) {
            return '#/' + (_this.delivery.status === 'TEMPLATE' ? 'delivery-patterns' : 'deliveries') + '/' + _this.delivery.id + subpage.path;
        };

        this._$parse = $parse;
        this._$location = $location;
        this._UiExtensionsService = UiExtensionsService;
        this._Page = Page;

        this._isBreadCrumbInitialized = false;
        this.isSubpageDropdownAvailable = false;
    }

    (0, _createClass3.default)(DeliveryHeaderController, [{
        key: '$onInit',
        value: function $onInit() {
            if (this.delivery) {
                this._initDropdown();
            }
        }
    }, {
        key: '$onChanges',
        value: function $onChanges(changes) {
            var delivery = changes.delivery;

            if (delivery && delivery.previousValue === null && delivery.currentValue !== null) {
                this._initDropdown();
            }
        }
    }, {
        key: '_initDropdown',
        value: function _initDropdown() {
            this._setBreadcrumbs(this.delivery);
            this._generateSubpages(this.delivery);
        }
    }, {
        key: '_generateSubpages',
        value: function _generateSubpages(delivery) {
            var _this2 = this;

            this.isSubpageDropdownAvailable = angular.isDefined(delivery) && !!delivery;

            this._extendSubpages(delivery).then(function (extendedSubpages) {
                _this2.deliverySubpages = extendedSubpages;

                var notDefaultPages = _.omit(_this2.deliverySubpages, '');
                _this2.page = _.find(notDefaultPages, function (aPage) {
                    var regexp = new RegExp(aPage.path, 'i');
                    return _this2._$location.path().match(regexp); // if current location ends with one of the subpages
                });
                _this2.page = _this2.page || _this2.deliverySubpages[''];
            });
        }
    }, {
        key: '_extendSubpages',
        value: function _extendSubpages(delivery) {
            var menuId = delivery.status === 'TEMPLATE' ? 'xlrelease.DeliveryPatternPageMenu' : 'xlrelease.DeliveryPageMenu';
            return this._UiExtensionsService.getMenuItems(menuId, delivery).then(function (extensions) {
                var extendedSubpages = [];

                _.chain(extensions).filter(function (extension) {
                    return extension.permitted === true;
                }).forEach(function (extension) {
                    extendedSubpages[extension.pathSuffix] = {
                        path: '/' + extension.pathSuffix,
                        label: extension.label,
                        weight: extension.weight
                    };
                }).value();

                extendedSubpages = _(extendedSubpages).toPairs().sortBy(function (keyValue) {
                    return keyValue[1].weight;
                }).fromPairs().value();
                return extendedSubpages;
            });
        }
    }, {
        key: '_setBreadcrumbs',
        value: function _setBreadcrumbs(delivery) {
            if (!this._isBreadCrumbInitialized) {
                this._Page.setFolderEntityOpened(delivery.folderId, delivery);
                this._isBreadCrumbInitialized = true;
            }
        }
    }]);
    return DeliveryHeaderController;
}();

DeliveryHeaderController.$inject = ['$parse', '$location', 'UiExtensionsService', 'Page'];

/***/ }),

/***/ 3099:
/***/ (function(module, exports) {

module.exports = "<div id=\"delivery-header\" class=\"header\">\n    <div class=\"subpage-links\" ng-if=\"$ctrl.isSubpageDropdownAvailable\">\n        <span class=\"show-label\">Show</span>\n        <button type=\"button\" class=\"button dropdown-button\" bs-popover\n                data-content-template=\"static/9.5.5/include/deliveries-details/header/delivery-subpages.html\"\n                data-placement=\"bottom\"\n                auto-close=\"true\">\n            {{ $ctrl.page.label }} <span class=\"caret\"></span>\n        </button>\n    </div>\n\n    <span class=\"header-container-flex\" ng-transclude></span>\n</div>\n"

/***/ }),

/***/ 3100:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3101);

__webpack_require__(3136);

__webpack_require__(3149);

/***/ }),

/***/ 3101:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _react2angular = __webpack_require__(202);

var _deliveryFlow = __webpack_require__(3102);

var _deliveryFlow2 = _interopRequireDefault(_deliveryFlow);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').component('xlrDeliveryFlowView', (0, _react2angular.react2angular)(_deliveryFlow2.default));

/***/ }),

/***/ 3102:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(43);

var _deliveryFlow = __webpack_require__(3103);

var _deliveryFlow2 = __webpack_require__(3107);

var _deliveryFlow3 = _interopRequireDefault(_deliveryFlow2);

var _deliveryFlow4 = __webpack_require__(386);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryFlowPage = function (_Component) {
    (0, _inherits3.default)(DeliveryFlowPage, _Component);

    function DeliveryFlowPage() {
        (0, _classCallCheck3.default)(this, DeliveryFlowPage);
        return (0, _possibleConstructorReturn3.default)(this, (DeliveryFlowPage.__proto__ || (0, _getPrototypeOf2.default)(DeliveryFlowPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(DeliveryFlowPage, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                activeStageReleases = _props.activeStageReleases,
                delivery = _props.delivery;


            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _deliveryFlow.store },
                _react2.default.createElement(_deliveryFlow3.default, { activeStageReleases: activeStageReleases, delivery: delivery })
            );
        }
    }]);
    return DeliveryFlowPage;
}(_react.Component);

DeliveryFlowPage.propTypes = {
    activeStageReleases: _propTypes2.default.arrayOf(_deliveryFlow4.ReleaseInfo),
    delivery: _propTypes2.default.any.isRequired
};
exports.default = DeliveryFlowPage;

/***/ }),

/***/ 3103:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.store = undefined;

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

var _typeof2 = __webpack_require__(124);

var _typeof3 = _interopRequireDefault(_typeof2);

var _redux = __webpack_require__(147);

var _reduxSaga = __webpack_require__(277);

var _reduxSaga2 = _interopRequireDefault(_reduxSaga);

var _effects = __webpack_require__(54);

var _ducks = __webpack_require__(3104);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(combinedSaga); /* global window */


var sagaMiddleware = (0, _reduxSaga2.default)();

/* eslint-disable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log */
var composeEnhancers = (typeof window === 'undefined' ? 'undefined' : (0, _typeof3.default)(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
    name: 'delivery-flow'
    // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...
}) : _redux.compose;

function combinedSaga() {
    return _regenerator2.default.wrap(function combinedSaga$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    if (false) {}

                    _context.prev = 1;
                    _context.next = 4;
                    return (0, _effects.all)([(0, _effects.call)(_ducks.deliveryFlowSagas)]);

                case 4:
                    _context.next = 9;
                    break;

                case 6:
                    _context.prev = 6;
                    _context.t0 = _context['catch'](1);

                    console.error('Release delivery flow saga:', _context.t0);

                case 9:
                    _context.next = 0;
                    break;

                case 11:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[1, 6]]);
}

function configureStore(preloadedState) {
    var enhancer = composeEnhancers((0, _redux.applyMiddleware)(sagaMiddleware));

    var store = (0, _redux.createStore)((0, _redux.combineReducers)({ deliveryFlow: _ducks.deliveryFlow }), preloadedState, enhancer);

    sagaMiddleware.run(combinedSaga);

    return store;
}

var store = exports.store = configureStore();
/* eslint-enable */

/***/ }),

/***/ 3104:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _deliveryFlow = __webpack_require__(3105);

Object.defineProperty(exports, 'deliveryFlow', {
  enumerable: true,
  get: function get() {
    return _deliveryFlow.deliveryFlow;
  }
});

var _deliveryFlow2 = __webpack_require__(3106);

Object.defineProperty(exports, 'deliveryFlowSagas', {
  enumerable: true,
  get: function get() {
    return _deliveryFlow2.deliveryFlowSagas;
  }
});

/***/ }),

/***/ 3105:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliveryFlow = undefined;

var _toConsumableArray2 = __webpack_require__(52);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _deliveryFlow = __webpack_require__(468);

var _lodash = __webpack_require__(62);

var _deliveryFlow2 = __webpack_require__(621);

var _deliveryFlow3 = __webpack_require__(919);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// -- REDUCER --
var INITIAL = {
    activeStageReleases: [],
    loadingReleasesInfo: false,
    trackedItems: [],
    stages: [],
    status: '',
    trackedItemApprovals: [],
    activeTransition: {
        id: null,
        items: [],
        status: null
    }
};

var deliveryFlow = exports.deliveryFlow = function deliveryFlow() {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL;
    var action = arguments[1];

    switch (action.type) {
        case _deliveryFlow2.actionTypes.TRACKED_ITEM_APPROVALS_UPDATE:
            {
                return (0, _extends3.default)({}, state, {
                    trackedItemApprovals: action.payload
                });
            }
        case _deliveryFlow2.actionTypes.TRACKED_ITEM_UPDATE_DATA:
            {
                var activeTransition = state.activeTransition;
                var _action$payload = action.payload,
                    trackedItems = _action$payload.trackedItems,
                    transitions = _action$payload.transitions,
                    stages = _action$payload.stages,
                    status = _action$payload.status;

                var formattedStages = mapTransitionsInStages(stages, transitions, trackedItems, state.activeTransition);

                if (!!activeTransition.id) {
                    var activeStage = formattedStages.find(function (s) {
                        return s.transition && s.transition.id === activeTransition.id;
                    });
                    if (!!activeStage) {
                        activeTransition.items = activeStage.items.filter(function (item) {
                            return item.transitionItem !== null;
                        });
                        activeTransition.status = activeStage.transition;
                    }
                }
                return (0, _extends3.default)({}, state, {
                    trackedItems: trackedItems,
                    stages: formattedStages,
                    status: status
                });
            }
        case _deliveryFlow2.actionTypes.TRACKED_ITEM_REMOVE_SUCCESS:
            {
                var _trackedItems = state.trackedItems,
                    _activeTransition = state.activeTransition;

                if (!!_activeTransition.id) {
                    _activeTransition.items = [].concat((0, _toConsumableArray3.default)(_activeTransition.items.filter(function (item) {
                        return item.trackedItemId !== action.payload;
                    })));
                }
                return (0, _extends3.default)({}, state, {
                    trackedItems: _trackedItems.filter(function (item) {
                        return item.id !== action.payload;
                    })
                });
            }
        case _deliveryFlow2.actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST:
            {
                return (0, _extends3.default)({}, state, {
                    loadingReleasesInfo: true
                });
            }
        case _deliveryFlow2.actionTypes.TRACKED_ITEM_STAGE_RELEASE_SUCCESS:
            {
                return (0, _extends3.default)({}, state, {
                    activeStageReleases: action.payload,
                    loadingReleasesInfo: false
                });
            }
        case _deliveryFlow2.actionTypes.TRANSITION_ACTIVATE:
            {
                return (0, _extends3.default)({}, state, {
                    activeTransition: action.payload
                });
            }
        case _deliveryFlow2.actionTypes.TRANSITION_DEACTIVATE:
            {
                return (0, _extends3.default)({}, state, {
                    activeTransition: INITIAL.activeTransition
                });
            }
        case _deliveryFlow2.actionTypes.TRANSITION_SELECTION_UPDATE:
            {
                return (0, _extends3.default)({}, state, {
                    activeTransition: {
                        id: state.activeTransition.id,
                        items: action.payload.items,
                        status: action.payload.status
                    }
                });
            }
        case _deliveryFlow2.actionTypes.TRACKED_ITEM_SKIP_SUCCESS:
            {
                var _stages = state.stages,
                    _activeTransition2 = state.activeTransition,
                    _trackedItems2 = state.trackedItems;
                var _action$payload2 = action.payload,
                    stage = _action$payload2.stage,
                    trackedItem = _action$payload2.trackedItem;

                var updatedState = updateItemStatus(_stages, _activeTransition2, stage, trackedItem, _deliveryFlow.trackedItemStatus.skipped, _trackedItems2);
                return (0, _extends3.default)({}, state, {
                    stages: updatedState.stages,
                    activeTransition: updatedState.activeTransition
                });
            }
        case _deliveryFlow2.actionTypes.TRACKED_ITEM_COMPLETE_SUCCESS:
            {
                var _stages2 = state.stages,
                    _activeTransition3 = state.activeTransition,
                    _trackedItems3 = state.trackedItems;
                var _action$payload3 = action.payload,
                    _stage = _action$payload3.stage,
                    _trackedItem = _action$payload3.trackedItem;

                var _updatedState = updateItemStatus(_stages2, _activeTransition3, _stage, _trackedItem, _deliveryFlow.trackedItemStatus.ready, _trackedItems3);
                return (0, _extends3.default)({}, state, {
                    stages: _updatedState.stages,
                    activeTransition: _updatedState.activeTransition
                });
            }
        default:
            return state;
    }
};

var updateItemStatus = function updateItemStatus(oldStages, activeTransition, stage, trackedItem, itemStatus, trackedItems) {
    var stagesWithUpdatedItem = oldStages.map(function (s) {
        if (s.id === stage.id) {
            var items = s.items.map(function (item) {
                if (item.trackedItemId === trackedItem.id) {
                    return (0, _extends3.default)({}, item, {
                        status: itemStatus
                    });
                }
                return (0, _extends3.default)({}, item);
            });
            return (0, _extends3.default)({}, s, { items: items });
        }
        return s;
    });

    var stages = stagesWithUpdatedItem.map(function (s, stageIndex) {
        if (s.transition) {
            var expandedStage = formatTransitionOnStage(s.transition, trackedItems, activeTransition, stagesWithUpdatedItem, stageIndex);
            return expandedStage;
        } else {
            return s;
        }
    });

    if (!!activeTransition.id) {
        var stageWithActiveTransition = stages.find(function (s) {
            return s.id === activeTransition.status.fromStageId;
        });
        activeTransition.items = stageWithActiveTransition.items.filter(function (item) {
            return item.transitionItem !== null;
        });
        activeTransition.status.selectedTransitionItemCount = (0, _deliveryFlow3.countSelectedTransitionItems)(stageWithActiveTransition.items);
    }

    return {
        stages: stages,
        activeTransition: activeTransition
    };
};

var mapTransitionsInStages = function mapTransitionsInStages(stages, transitions, trackedItems, activeTransition) {
    // create an object with transitions and tracked item status whether its moved to other
    // stage or not this will help us to decide whether to show the checkbox as checked or not
    var modifiedStages = [];

    var _loop = function _loop(stageIndex) {
        var transition = transitions.find(function (currTransition) {
            return currTransition.fromStageId === stages[stageIndex].id;
        });
        if (transition) {
            var expandedStage = formatTransitionOnStage(transition, trackedItems, activeTransition, stages, stageIndex);
            modifiedStages.push(expandedStage);
        } else {
            modifiedStages.push(stages[stageIndex]);
        }
    };

    for (var stageIndex = 0; stageIndex < stages.length - 1; stageIndex++) {
        _loop(stageIndex);
    }
    modifiedStages.push((0, _lodash.last)(stages));

    return modifiedStages;
};

var formatTransitionOnStage = function formatTransitionOnStage(transition, trackedItems, activeTransition, stages, stageIndex) {
    var isItemDoneInStage = function isItemDoneInStage(stage, trackedItemId) {
        return stage.items.some(function (stageItem) {
            return stageItem.trackedItemId === trackedItemId && (stageItem.status === _deliveryFlow.trackedItemStatus.ready || stageItem.status === _deliveryFlow.trackedItemStatus.skipped);
        });
    };
    // completed items for checkbox visibility
    var listOfReadyItemsInCurrentStage = stages[stageIndex].items.filter(function (currItem) {
        return !trackedItems.find(function (item) {
            return item.id === currItem.trackedItemId;
        }).descoped && stages.slice(0, stageIndex + 1).every(function (stage) {
            return isItemDoneInStage(stage, currItem.trackedItemId);
        });
    });
    var listOfItemsInNextStage = stages[stageIndex + 1].items;

    // compare next stage for availability
    var readyItems = (0, _lodash.differenceBy)(listOfReadyItemsInCurrentStage, listOfItemsInNextStage, 'trackedItemId');
    var alreadyTransitionedItems = (0, _lodash.intersectionBy)(listOfReadyItemsInCurrentStage, listOfItemsInNextStage, 'trackedItemId');

    var readyItemsExpanded = readyItems.map(function (item) {
        return (0, _extends3.default)({}, item, {
            transitionItem: { disabled: false, checked: true }
        });
    });
    var alreadyTransitionedItemsExpanded = alreadyTransitionedItems.map(function (item) {
        return (0, _extends3.default)({}, item, {
            transitionItem: { disabled: true, checked: true }
        });
    });

    var transitionItems = [].concat((0, _toConsumableArray3.default)(readyItemsExpanded), (0, _toConsumableArray3.default)(alreadyTransitionedItemsExpanded));

    if (activeTransition.id && transition.id === activeTransition.id) {
        transitionItems.filter(function (item) {
            return !item.transitionItem.disabled;
        }).forEach(function (item) {
            var activeItem = activeTransition.items.find(function (i) {
                return i.id === item.id;
            });
            if (activeItem && activeItem.transitionItem) {
                item.transitionItem.checked = activeItem.transitionItem.checked;
                item.transitionItem.disabled = activeItem.transitionItem.disabled;
            } else {
                item.transitionItem.checked = false;
            }
        });
    }

    var items = stages[stageIndex].items.map(function (item) {
        var i = transitionItems.find(function (transitionItem) {
            return transitionItem.trackedItemId === item.trackedItemId;
        });
        if (i) {
            return (0, _extends3.default)({}, i);
        } else {
            return (0, _extends3.default)({}, item, {
                transitionItem: null
            });
        }
    });

    var expandedStage = (0, _extends3.default)({}, stages[stageIndex], {
        items: items,
        transition: (0, _extends3.default)({}, transition, {
            selectedTransitionItemCount: (0, _deliveryFlow3.countSelectedTransitionItems)(items),
            closeStages: activeTransition.status ? activeTransition.status.closeStages : false
        }),
        selectableItemsCount: readyItems.length
    });
    expandedStage.transition.disabledTransition = (0, _deliveryFlow3.isDisabledTransition)(expandedStage.transition);
    return expandedStage;
};

/***/ }),

/***/ 3106:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(78);

var _promise2 = _interopRequireDefault(_promise);

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.deliveryFlowSagas = deliveryFlowSagas;

var _effects = __webpack_require__(54);

var _deliveryFlow = __webpack_require__(920);

var _services = __webpack_require__(256);

var _ids = __webpack_require__(110);

var _ids2 = _interopRequireDefault(_ids);

var _deliveryFlow2 = __webpack_require__(621);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(createOrUpdateItem),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(removeItem),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(descopeItem),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(rescopeItem),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(skipItem),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(completeItem),
    _marked7 = /*#__PURE__*/_regenerator2.default.mark(fetchDelivery),
    _marked8 = /*#__PURE__*/_regenerator2.default.mark(fetchTrackedItemApprovals),
    _marked9 = /*#__PURE__*/_regenerator2.default.mark(fetchStagesReleases),
    _marked10 = /*#__PURE__*/_regenerator2.default.mark(postTransition),
    _marked11 = /*#__PURE__*/_regenerator2.default.mark(fetchWithPolling),
    _marked12 = /*#__PURE__*/_regenerator2.default.mark(fetchFullDeliveryDetails),
    _marked13 = /*#__PURE__*/_regenerator2.default.mark(watchFetchDeliveryWithPollingSaga),
    _marked14 = /*#__PURE__*/_regenerator2.default.mark(completeStageInDelivery),
    _marked15 = /*#__PURE__*/_regenerator2.default.mark(reopenStageInDelivery),
    _marked16 = /*#__PURE__*/_regenerator2.default.mark(deliveryFlowSagas);

var POLLING_INTERVAL = 5000;

// -- SAGAS --
function createOrUpdateItem(action) {
    var _action$payload, trackedItem, deliveryId;

    return _regenerator2.default.wrap(function createOrUpdateItem$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _action$payload = action.payload, trackedItem = _action$payload.trackedItem, deliveryId = _action$payload.deliveryId;

                    if (!trackedItem.id) {
                        _context.next = 9;
                        break;
                    }

                    _context.next = 5;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.updateItem, trackedItem);

                case 5:
                    _context.next = 7;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchDeliveryDetails)(deliveryId));

                case 7:
                    _context.next = 13;
                    break;

                case 9:
                    _context.next = 11;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.createItem, deliveryId, trackedItem);

                case 11:
                    _context.next = 13;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchDeliveryDetails)(deliveryId));

                case 13:
                    _context.next = 18;
                    break;

                case 15:
                    _context.prev = 15;
                    _context.t0 = _context['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while creating or updating tracking item...', _context.t0);
                    /* eslint-enable */

                case 18:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 15]]);
}

function removeItem(action) {
    var id;
    return _regenerator2.default.wrap(function removeItem$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.prev = 0;
                    id = action.payload;
                    _context2.next = 4;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.removeItem, id);

                case 4:
                    _context2.next = 6;
                    return (0, _effects.put)((0, _deliveryFlow2.removedTrackedItem)(id));

                case 6:
                    _context2.next = 11;
                    break;

                case 8:
                    _context2.prev = 8;
                    _context2.t0 = _context2['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while removing tracking item...', _context2.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[0, 8]]);
}

function descopeItem(action) {
    var id;
    return _regenerator2.default.wrap(function descopeItem$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.prev = 0;
                    id = action.payload;
                    _context3.next = 4;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.descopeItem, id);

                case 4:
                    _context3.next = 6;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchDeliveryDetails)((0, _ids2.default)().getParentId(id)));

                case 6:
                    _context3.next = 11;
                    break;

                case 8:
                    _context3.prev = 8;
                    _context3.t0 = _context3['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while descoping tracking item...', _context3.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[0, 8]]);
}

function rescopeItem(action) {
    var id;
    return _regenerator2.default.wrap(function rescopeItem$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    id = action.payload;
                    _context4.next = 4;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.rescopeItem, id);

                case 4:
                    _context4.next = 6;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchDeliveryDetails)((0, _ids2.default)().getParentId(id)));

                case 6:
                    _context4.next = 11;
                    break;

                case 8:
                    _context4.prev = 8;
                    _context4.t0 = _context4['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while rescoping tracked item...', _context4.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 8]]);
}

function skipItem(action) {
    var _action$payload2, stage, trackedItem;

    return _regenerator2.default.wrap(function skipItem$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.prev = 0;
                    _action$payload2 = action.payload, stage = _action$payload2.stage, trackedItem = _action$payload2.trackedItem;
                    _context5.next = 4;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.skipItem, stage.id, trackedItem.id);

                case 4:
                    _context5.next = 6;
                    return (0, _effects.put)((0, _deliveryFlow2.trackedItemSkipped)(stage, trackedItem));

                case 6:
                    _context5.next = 11;
                    break;

                case 8:
                    _context5.prev = 8;
                    _context5.t0 = _context5['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while skipping tracking item...', _context5.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this, [[0, 8]]);
}

function completeItem(action) {
    var _action$payload3, stage, trackedItem;

    return _regenerator2.default.wrap(function completeItem$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.prev = 0;
                    _action$payload3 = action.payload, stage = _action$payload3.stage, trackedItem = _action$payload3.trackedItem;
                    _context6.next = 4;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.completeItem, stage.id, trackedItem.id);

                case 4:
                    _context6.next = 6;
                    return (0, _effects.put)((0, _deliveryFlow2.trackedItemCompleted)(stage, trackedItem));

                case 6:
                    _context6.next = 11;
                    break;

                case 8:
                    _context6.prev = 8;
                    _context6.t0 = _context6['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while completing tracking item...', _context6.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this, [[0, 8]]);
}

function fetchDelivery(action) {
    var deliveryResponse;
    return _regenerator2.default.wrap(function fetchDelivery$(_context7) {
        while (1) {
            switch (_context7.prev = _context7.next) {
                case 0:
                    _context7.next = 2;
                    return (0, _effects.call)(_services.getDelivery, action.payload);

                case 2:
                    deliveryResponse = _context7.sent;
                    _context7.next = 5;
                    return (0, _effects.put)((0, _deliveryFlow2.updateDataState)(deliveryResponse.data));

                case 5:
                case 'end':
                    return _context7.stop();
            }
        }
    }, _marked7, this);
}

function fetchTrackedItemApprovals(action) {
    var response;
    return _regenerator2.default.wrap(function fetchTrackedItemApprovals$(_context8) {
        while (1) {
            switch (_context8.prev = _context8.next) {
                case 0:
                    _context8.next = 2;
                    return (0, _effects.call)(_services.getTrackedItemApprovals, action.payload);

                case 2:
                    response = _context8.sent;
                    _context8.next = 5;
                    return (0, _effects.put)((0, _deliveryFlow2.updateTrackedItemApprovals)(response.data));

                case 5:
                case 'end':
                    return _context8.stop();
            }
        }
    }, _marked8, this);
}

function fetchStagesReleases(action) {
    var releaseDetailsList;
    return _regenerator2.default.wrap(function fetchStagesReleases$(_context9) {
        while (1) {
            switch (_context9.prev = _context9.next) {
                case 0:
                    _context9.next = 2;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.fetchStageReleases, action.payload);

                case 2:
                    releaseDetailsList = _context9.sent;
                    _context9.next = 5;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchStageReleasesSuccess)(releaseDetailsList));

                case 5:
                case 'end':
                    return _context9.stop();
            }
        }
    }, _marked9, this);
}

function postTransition(action) {
    var _action$payload4, deliveryId, transition, transitionItems;

    return _regenerator2.default.wrap(function postTransition$(_context10) {
        while (1) {
            switch (_context10.prev = _context10.next) {
                case 0:
                    _context10.prev = 0;
                    _action$payload4 = action.payload, deliveryId = _action$payload4.deliveryId, transition = _action$payload4.transition, transitionItems = _action$payload4.transitionItems;
                    _context10.next = 4;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.makeTransition, transition.id, { transitionItems: transitionItems, closeStages: transition.closeStages });

                case 4:
                    _context10.next = 6;
                    return fetchFullDeliveryDetails(deliveryId);

                case 6:
                    _context10.next = 11;
                    break;

                case 8:
                    _context10.prev = 8;
                    _context10.t0 = _context10['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while posting transition...', _context10.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context10.stop();
            }
        }
    }, _marked10, this, [[0, 8]]);
}

function delay(duration) {
    var promise = new _promise2.default(function (resolve) {
        setTimeout(function () {
            return resolve(true);
        }, duration);
    });
    return promise;
}

function fetchWithPolling(action) {
    var deliveryId;
    return _regenerator2.default.wrap(function fetchWithPolling$(_context11) {
        while (1) {
            switch (_context11.prev = _context11.next) {
                case 0:
                    if (false) {}

                    _context11.prev = 1;
                    deliveryId = action.payload.deliveryId;
                    _context11.next = 5;
                    return (0, _effects.call)(delay, POLLING_INTERVAL);

                case 5:
                    _context11.next = 7;
                    return fetchFullDeliveryDetails(deliveryId);

                case 7:
                    _context11.next = 13;
                    break;

                case 9:
                    _context11.prev = 9;
                    _context11.t0 = _context11['catch'](1);
                    _context11.next = 13;
                    return (0, _effects.put)({ type: _deliveryFlow2.actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_POLLING_FAILURE, payload: _context11.t0 });

                case 13:
                    _context11.next = 0;
                    break;

                case 15:
                case 'end':
                    return _context11.stop();
            }
        }
    }, _marked11, this, [[1, 9]]);
}

function fetchFullDeliveryDetails(deliveryId) {
    return _regenerator2.default.wrap(function fetchFullDeliveryDetails$(_context12) {
        while (1) {
            switch (_context12.prev = _context12.next) {
                case 0:
                    _context12.next = 2;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchDeliveryDetails)(deliveryId));

                case 2:
                    _context12.next = 4;
                    return fetchStagesReleases({ payload: deliveryId });

                case 4:
                    _context12.next = 6;
                    return (0, _effects.put)((0, _deliveryFlow2.requestTrackedItemApprovals)(deliveryId));

                case 6:
                case 'end':
                    return _context12.stop();
            }
        }
    }, _marked12, this);
}

function watchFetchDeliveryWithPollingSaga() {
    var myAction;
    return _regenerator2.default.wrap(function watchFetchDeliveryWithPollingSaga$(_context13) {
        while (1) {
            switch (_context13.prev = _context13.next) {
                case 0:
                    if (false) {}

                    _context13.next = 3;
                    return (0, _effects.take)(_deliveryFlow2.actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING);

                case 3:
                    myAction = _context13.sent;
                    _context13.next = 6;
                    return (0, _effects.race)([(0, _effects.call)(fetchWithPolling, myAction), (0, _effects.take)(_deliveryFlow2.actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING)]);

                case 6:
                    _context13.next = 0;
                    break;

                case 8:
                case 'end':
                    return _context13.stop();
            }
        }
    }, _marked13, this);
}

function completeStageInDelivery(action) {
    var id;
    return _regenerator2.default.wrap(function completeStageInDelivery$(_context14) {
        while (1) {
            switch (_context14.prev = _context14.next) {
                case 0:
                    id = action.payload;
                    _context14.next = 3;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.completeStage, id);

                case 3:
                    _context14.next = 5;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchDeliveryDetails)((0, _ids2.default)().getParentId(id)));

                case 5:
                case 'end':
                    return _context14.stop();
            }
        }
    }, _marked14, this);
}

function reopenStageInDelivery(action) {
    var id;
    return _regenerator2.default.wrap(function reopenStageInDelivery$(_context15) {
        while (1) {
            switch (_context15.prev = _context15.next) {
                case 0:
                    id = action.payload;
                    _context15.next = 3;
                    return (0, _effects.call)(_deliveryFlow.deliveryFlowService.reopenStage, id);

                case 3:
                    _context15.next = 5;
                    return (0, _effects.put)((0, _deliveryFlow2.fetchDeliveryDetails)((0, _ids2.default)().getParentId(id)));

                case 5:
                case 'end':
                    return _context15.stop();
            }
        }
    }, _marked15, this);
}

function deliveryFlowSagas() {
    return _regenerator2.default.wrap(function deliveryFlowSagas$(_context16) {
        while (1) {
            switch (_context16.prev = _context16.next) {
                case 0:
                    _context16.next = 2;
                    return (0, _effects.all)([(0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_REQUEST, createOrUpdateItem), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_REMOVE_REQUEST, removeItem), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_DESCOPE_REQUEST, descopeItem), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_RESCOPE_REQUEST, rescopeItem), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_SKIP_REQUEST, skipItem), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_COMPLETE_REQUEST, completeItem), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_SUCCESS, fetchDelivery), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_APPROVALS_REQUEST, fetchTrackedItemApprovals), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST, fetchStagesReleases), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.TRACKED_ITEM_STAGE_TRANSITION_REQUEST, postTransition), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.STAGE_COMPLETE_REQUEST, completeStageInDelivery), (0, _effects.takeEvery)(_deliveryFlow2.actionTypes.STAGE_REOPEN_REQUEST, reopenStageInDelivery), watchFetchDeliveryWithPollingSaga()]);

                case 2:
                case 'end':
                    return _context16.stop();
            }
        }
    }, _marked16, this);
}

/***/ }),

/***/ 3107:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _reactRedux = __webpack_require__(43);

var _deliveryFlow = __webpack_require__(621);

var _deliveryFlowView = __webpack_require__(3108);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    var deliveryFlow = state.deliveryFlow;


    return {
        activeTransition: deliveryFlow.activeTransition,
        trackedItems: deliveryFlow.trackedItems,
        loadingReleasesInfo: deliveryFlow.loadingReleasesInfo,
        stages: deliveryFlow.stages,
        activeStageReleases: deliveryFlow.activeStageReleases,
        status: deliveryFlow.status,
        trackedItemApprovals: deliveryFlow.trackedItemApprovals
    };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
    return (0, _extends3.default)({}, ownProps, stateProps, dispatchProps, {
        updateDeliveryFlowPropsFromDetails: function updateDeliveryFlowPropsFromDetails() {
            dispatchProps.updateDeliveryFlowProps(ownProps.delivery);
            dispatchProps.updateActiveStageReleases(ownProps.activeStageReleases);
            dispatchProps.requestTrackedItemApprovals(ownProps.delivery.id);
        }
    });
};

var mapDispatchToProps = function mapDispatchToProps(dispatch) {
    return {
        activateTransition: function activateTransition(stage) {
            return dispatch((0, _deliveryFlow.activateTransition)(stage));
        },
        updateTransitionSelection: function updateTransitionSelection(selection) {
            return dispatch((0, _deliveryFlow.updateTransitionSelection)(selection));
        },
        completeStage: function completeStage(id) {
            return dispatch((0, _deliveryFlow.completeStage)(id));
        },
        deactivateTransition: function deactivateTransition() {
            return dispatch((0, _deliveryFlow.deactivateTransition)());
        },
        deleteTrackedItem: function deleteTrackedItem(id) {
            return dispatch((0, _deliveryFlow.removeTrackedItem)(id));
        },
        descopeTrackedItem: function descopeTrackedItem(id) {
            return dispatch((0, _deliveryFlow.descopeTrackedItem)(id));
        },
        rescopeTrackedItem: function rescopeTrackedItem(id) {
            return dispatch((0, _deliveryFlow.rescopeTrackedItem)(id));
        },
        reopenStage: function reopenStage(id) {
            return dispatch((0, _deliveryFlow.reopenStage)(id));
        },
        skipTrackedItem: function skipTrackedItem(stage, trackedItem) {
            return dispatch((0, _deliveryFlow.skipTrackedItem)(stage, trackedItem));
        },
        completeTrackedItem: function completeTrackedItem(stage, trackedItem) {
            return dispatch((0, _deliveryFlow.completeTrackedItem)(stage, trackedItem));
        },
        saveTrackedItem: function saveTrackedItem(item, deliveryId) {
            return dispatch((0, _deliveryFlow.createOrUpdateTrackedItem)(item, deliveryId));
        },
        updateDeliveryFlowProps: function updateDeliveryFlowProps(delivery) {
            return dispatch((0, _deliveryFlow.updateDataState)(delivery));
        },
        getStageReleaseDetails: function getStageReleaseDetails(deliveryId) {
            return dispatch((0, _deliveryFlow.getStageReleaseDetails)(deliveryId));
        },
        postTransitionDetails: function postTransitionDetails(deliveryId, transition, transitionItems) {
            return dispatch((0, _deliveryFlow.postTransitionDetails)(deliveryId, transition, transitionItems));
        },
        fetchDeliveryDetailsWithPolling: function fetchDeliveryDetailsWithPolling(deliveryId) {
            return dispatch((0, _deliveryFlow.fetchDeliveryDetailsWithPolling)(deliveryId));
        },
        requestTrackedItemApprovals: function requestTrackedItemApprovals(deliveryId) {
            return dispatch((0, _deliveryFlow.requestTrackedItemApprovals)(deliveryId));
        },
        stopPolling: function stopPolling() {
            return dispatch((0, _deliveryFlow.stopPolling)());
        },
        updateActiveStageReleases: function updateActiveStageReleases(releases) {
            return dispatch((0, _deliveryFlow.fetchStageReleasesSuccess)(releases));
        }
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps)(_deliveryFlowView.DeliveryFlowViewComponent);

/***/ }),

/***/ 3108:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeliveryFlowViewComponent = exports.initTrackItemState = undefined;

var _defineProperty2 = __webpack_require__(19);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _keys = __webpack_require__(116);

var _keys2 = _interopRequireDefault(_keys);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = __webpack_require__(62);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

var _xlReactComponents = __webpack_require__(47);

var _trackedItemEditModal = __webpack_require__(3109);

var _trackedItemEditModal2 = _interopRequireDefault(_trackedItemEditModal);

var _deliveryTimeline = __webpack_require__(3110);

var _deliveryFlow = __webpack_require__(468);

var _deliveryProperties = __webpack_require__(622);

var _deliveryFlow2 = __webpack_require__(919);

var _stageHeader = __webpack_require__(3113);

var _stageCell = __webpack_require__(3116);

var _transitionHeader = __webpack_require__(3123);

var _transitionCell = __webpack_require__(3129);

var _components = __webpack_require__(67);

__webpack_require__(3132);

__webpack_require__(3134);

var _deliveryFlow3 = __webpack_require__(386);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var filterDeliveryFieldMetadata = { placeholder: 'Filter by tracked item...' };

var deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};

var descopeButton = {
    action: 'descope',
    className: 'button primary',
    keyCodes: [13],
    label: 'Descope'
};

var rescopeButton = {
    action: 'rescope',
    className: 'button primary',
    keyCodes: [13],
    label: 'Rescope'
};

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var skipButton = {
    action: 'skip',
    className: 'button primary',
    keyCodes: [13],
    label: 'Skip'
};

var completeButton = {
    action: 'complete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Complete'
};

var initTrackItemState = exports.initTrackItemState = function initTrackItemState() {
    return {
        id: null,
        title: ''
    };
};

var openModalProps = {
    DELETE: 'deleteModalIsOpen',
    DESCOPE: 'descopeModalIsOpen',
    RESCOPE: 'rescopeModalIsOpen',
    SKIP: 'skipModalIsOpen',
    COMPLETE: 'completeModalIsOpen'
};

var headerHeight = 60;
var rowHeight = 60;

var DeliveryFlowViewComponent = exports.DeliveryFlowViewComponent = function (_Component) {
    (0, _inherits3.default)(DeliveryFlowViewComponent, _Component);

    function DeliveryFlowViewComponent(props) {
        (0, _classCallCheck3.default)(this, DeliveryFlowViewComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (DeliveryFlowViewComponent.__proto__ || (0, _getPrototypeOf2.default)(DeliveryFlowViewComponent)).call(this, props));

        _this.handleTrackedItemRowFocus = function (trackedItemId) {
            _this.setState({
                activeTrackedItemMenu: trackedItemId
            });
        };

        _this.onCloseConfirmModal = function (action) {
            var trackedItem = _this.state.trackedItem;

            switch (action) {
                case 'delete':
                    _this.props.deleteTrackedItem(trackedItem.id);
                    break;
                case 'descope':
                    _this.props.descopeTrackedItem(trackedItem.id);
                    break;
                case 'rescope':
                    _this.props.rescopeTrackedItem(trackedItem.id);
                    break;
                case 'skip':
                    {
                        var stage = _this.state.stage;

                        _this.props.skipTrackedItem(stage, trackedItem);
                        break;
                    }
                case 'complete':
                    {
                        var _stage = _this.state.stage;

                        _this.props.completeTrackedItem(_stage, trackedItem);
                        break;
                    }
            }

            (0, _keys2.default)(openModalProps).forEach(function (key) {
                var prop = openModalProps[key];
                if (_this.state[prop]) {
                    _this.setState((0, _defineProperty3.default)({
                        trackedItem: initTrackItemState()
                    }, prop, false));
                }
            });
        };

        _this.expandStage = function (stage) {
            var _this$props = _this.props,
                delivery = _this$props.delivery,
                getStageReleaseDetails = _this$props.getStageReleaseDetails;


            if (_this.state.activeStageId !== stage.id) {
                if (stage.items.length) {
                    getStageReleaseDetails(delivery.id);
                }

                _this.setState({
                    activeStageId: stage.items.length ? stage.id : null
                });
            }
        };

        _this.collapseStage = function () {
            _this.setState({
                activeStageId: null
            });
        };

        _this.toggleTransition = function (transition) {
            var _this$props2 = _this.props,
                activeTransition = _this$props2.activeTransition,
                activateTransition = _this$props2.activateTransition,
                deactivateTransition = _this$props2.deactivateTransition,
                stages = _this$props2.stages;

            if (activeTransition.id === transition.id) {
                deactivateTransition();
            } else {
                var currentStage = stages.find(function (stage) {
                    return stage.id === transition.fromStageId;
                });
                activateTransition({
                    id: transition.id,
                    items: currentStage.items.filter(function (item) {
                        return item.transitionItem !== null;
                    }),
                    status: currentStage.transition
                });
            }
        };

        _this.handleTransition = function (stage) {
            var _this$props3 = _this.props,
                delivery = _this$props3.delivery,
                postTransitionDetails = _this$props3.postTransitionDetails;


            var transitionItems = (0, _lodash.map)(stage.items, function (item) {
                if (item.transitionItem && !item.transitionItem.disabled && item.transitionItem.checked) {
                    return item.trackedItemId;
                }
            }).filter(function (item) {
                return !(0, _lodash.isUndefined)(item);
            });

            postTransitionDetails(delivery.id, stage.transition, transitionItems);
        };

        _this.showConfirmModal = function (trackedItem, prop) {
            var _this$setState2;

            return _this.setState((_this$setState2 = {}, (0, _defineProperty3.default)(_this$setState2, prop, true), (0, _defineProperty3.default)(_this$setState2, 'trackedItem', trackedItem), _this$setState2));
        };

        _this.showEditModal = function (trackedItem) {
            return _this.setState({
                editModalIsOpen: true,
                trackedItem: trackedItem,
                editModalTitle: 'Edit tracked item'
            });
        };

        _this.onCreate = function () {
            _this.setState({ editModalIsOpen: true, editModalTitle: 'Add new tracked item' });
        };

        _this.handleTrackedItemEditSave = function (trackedItem) {
            var createAnother = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
            var _this$props4 = _this.props,
                saveTrackedItem = _this$props4.saveTrackedItem,
                delivery = _this$props4.delivery;

            saveTrackedItem(trackedItem, delivery.id);
            var trackItemState = initTrackItemState();
            _this.setState({ editModalIsOpen: createAnother, trackedItem: trackItemState });
        };

        _this.handleTrackedItemEditCancel = function () {
            var trackItemState = initTrackItemState();
            _this.setState({ editModalIsOpen: false, trackedItem: trackItemState });
        };

        _this.onNameChange = function (name) {
            _this.setState({ trackedItemFilterText: name });
        };

        _this.onTransitionSelectChange = function (stageId, stageItemId, isSelected) {
            var _this$props5 = _this.props,
                activeTransition = _this$props5.activeTransition,
                stages = _this$props5.stages,
                updateTransitionSelection = _this$props5.updateTransitionSelection;


            var currentStage = stages.find(function (stage) {
                return stage.id === stageId;
            });
            currentStage.items.forEach(function (item) {
                if (item.id === stageItemId) {
                    item.transitionItem.checked = isSelected;
                }
            });
            currentStage.transition.selectedTransitionItemCount = (0, _deliveryFlow2.countSelectedTransitionItems)(currentStage.items);
            currentStage.transition.disabledTransition = (0, _deliveryFlow2.isDisabledTransition)(currentStage.transition);

            if (activeTransition.id !== null) {
                updateTransitionSelection({
                    status: currentStage.transition,
                    items: currentStage.items.filter(function (item) {
                        return item.transitionItem !== null;
                    })
                });
            }
        };

        _this.onTransitionColumnSelectChange = function (stageId, isSelected) {
            var _this$props6 = _this.props,
                stages = _this$props6.stages,
                updateTransitionSelection = _this$props6.updateTransitionSelection;


            var currentStage = stages.find(function (stage) {
                return stage.id === stageId;
            });
            currentStage.items.forEach(function (item) {
                if (item.transitionItem && !item.transitionItem.disabled) {
                    item.transitionItem.checked = isSelected;
                }
            });

            currentStage.transition.selectedTransitionItemCount = (0, _deliveryFlow2.countSelectedTransitionItems)(currentStage.items);

            updateTransitionSelection({
                items: currentStage.items.filter(function (item) {
                    return item.transitionItem !== null;
                }),
                status: currentStage.transition
            });
        };

        _this.onCompletePrevStageChange = function (stage, isSelected) {
            var _this$props7 = _this.props,
                stages = _this$props7.stages,
                updateTransitionSelection = _this$props7.updateTransitionSelection;


            var currentStage = stages.find(function (s) {
                return s.id === stage.id;
            });
            currentStage.transition.closeStages = isSelected;
            currentStage.transition.disabledTransition = (0, _deliveryFlow2.isDisabledTransition)(currentStage.transition);

            updateTransitionSelection({
                items: currentStage.items.filter(function (item) {
                    return item.transitionItem !== null;
                }),
                status: currentStage.transition
            });
        };

        _this.isStageActive = function (stage) {
            var activeStageId = _this.state.activeStageId;

            return !!activeStageId && !!stage && activeStageId === stage.id;
        };

        _this.isTransitionActive = function (transition) {
            var activeTransition = _this.props.activeTransition;

            return !!transition && activeTransition.id === transition.id;
        };

        _this.showSkipItemInStageModal = function (stage, trackedItem) {
            var _this$setState3;

            return _this.setState((_this$setState3 = {}, (0, _defineProperty3.default)(_this$setState3, openModalProps.SKIP, true), (0, _defineProperty3.default)(_this$setState3, 'stage', stage), (0, _defineProperty3.default)(_this$setState3, 'trackedItem', trackedItem), _this$setState3));
        };

        _this.showCompleteItemInStageModal = function (stage, trackedItem) {
            var _this$setState4;

            return _this.setState((_this$setState4 = {}, (0, _defineProperty3.default)(_this$setState4, openModalProps.COMPLETE, true), (0, _defineProperty3.default)(_this$setState4, 'stage', stage), (0, _defineProperty3.default)(_this$setState4, 'trackedItem', trackedItem), _this$setState4));
        };

        _this.renderTrackedItemEditModal = function (editModalIsOpen, editModalTitle, trackedItem, trackedItems) {
            return _react2.default.createElement(_trackedItemEditModal2.default, {
                isOpened: editModalIsOpen,
                modalTitle: editModalTitle,
                model: trackedItem,
                onCancel: _this.handleTrackedItemEditCancel,
                onSave: _this.handleTrackedItemEditSave,
                trackedItems: trackedItems
            });
        };

        _this.renderStageCell = function (stage, stageItem, trackedItem, isStageActive, isTrackedItemEditable) {
            var _this$props8 = _this.props,
                activeStageReleases = _this$props8.activeStageReleases,
                loadingReleasesInfo = _this$props8.loadingReleasesInfo;

            var isMenuVisible = !!stageItem && _this.isRowInFocus(stageItem.trackedItemId) && isTrackedItemEditable;

            var stageMenuOptions = [{ label: 'Skip', handler: function handler() {
                    return _this.showSkipItemInStageModal(stage, trackedItem);
                } }, { label: 'Complete', handler: function handler() {
                    return _this.showCompleteItemInStageModal(stage, trackedItem);
                } }];

            return _react2.default.createElement(_stageCell.StageCellComponent, {
                expandedStageReleases: activeStageReleases,
                isExpanded: isStageActive,
                isMenuVisible: isMenuVisible,
                loading: loadingReleasesInfo,
                stageItem: stageItem,
                stageMenuOptions: stageMenuOptions,
                trackedItem: trackedItem });
        };

        _this.renderFirstColumnCell = function (item) {
            var _this$props9 = _this.props,
                delivery = _this$props9.delivery,
                status = _this$props9.status;
            var isTrackedItemEditable = delivery.isTrackedItemEditable;


            return _this.buildRowCell(function () {
                return _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(
                        'span',
                        { className: 'text-wrap', title: item.title },
                        item.title
                    ),
                    _this.isRowInFocus(item.id) && isTrackedItemEditable && status !== _deliveryFlow.deliveryStatus.completed && _this.renderTrackedItemMenu(item)
                );
            }, 'item-' + item.id, 'tracked-item-cell');
        };

        _this.renderTransitionCell = function (stage, stageItem, item, isTransitionActive, isStageCompleted, isStageClosed) {
            var _this$props10 = _this.props,
                activeTransition = _this$props10.activeTransition,
                delivery = _this$props10.delivery;

            var approval = stageItem && _this.props.trackedItemApprovals.find(function (approval) {
                return approval.targetId === stageItem.id;
            });
            var currentItem = activeTransition.items.find(function (currItem) {
                return currItem.trackedItemId === item.id;
            });
            var transitionItem = !!currentItem ? currentItem.transitionItem : null;

            return _react2.default.createElement(_transitionCell.TransitionCellComponent, {
                approvalDetails: approval,
                handleTransitionSelectChange: function handleTransitionSelectChange(isSelected) {
                    return _this.onTransitionSelectChange(stage.id, stageItem.id, isSelected);
                },
                isClosed: isStageClosed,
                isCompleted: isStageCompleted,
                isEditable: delivery.isEditable,
                isExpanded: isTransitionActive,
                key: stage.selectableItemsCount,
                transitionItem: transitionItem
            });
        };

        _this.buildRow = function (renderer) {
            var rowTrackedItemId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
            return _react2.default.createElement(
                'div',
                {
                    className: (0, _classnames2.default)('table-row', !!rowTrackedItemId ? { 'hover': _this.isRowInFocus(rowTrackedItemId) } : 'last-row'),
                    key: 'row-' + (rowTrackedItemId || 'empty'),
                    onMouseEnter: function onMouseEnter() {
                        return !!rowTrackedItemId && _this.handleTrackedItemRowFocus(rowTrackedItemId);
                    },
                    onMouseLeave: function onMouseLeave() {
                        return !!rowTrackedItemId && _this.handleTrackedItemRowFocus(null);
                    } },
                renderer()
            );
        };

        _this.buildRowCell = function (renderer, key, rowClass) {
            var isExpanded = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
            var isClosed = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
            var isEnabledExpand = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
            var rowClickHandler = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
            return _react2.default.createElement(
                'span',
                {
                    className: (0, _classnames2.default)('body-cell', rowClass, { 'active': isExpanded && isEnabledExpand, 'closed': isClosed, 'disabled-expand': !isEnabledExpand }),
                    key: key,
                    onClick: rowClickHandler },
                renderer && renderer()
            );
        };

        _this.renderStageAndTransitionColumns = function (stage, trackedItem, index, isTrackedItemEditable, isEnabledExpand) {
            var isStageActive = _this.isStageActive(stage);
            var isStageClosed = _this.isStageClosed(stage);
            var isTransitionActive = _this.isTransitionActive(stage.transition);
            var isStageCompleted = _this.isStageCompleted(stage);
            var isEditable = _this.props.delivery.isEditable;

            var stageItem = stage.items.find(function (currItem) {
                return currItem.trackedItemId === trackedItem.id;
            });

            return _react2.default.createElement(
                _react2.default.Fragment,
                { key: 'fragment-' + stage.id + '-' + trackedItem.id + '-' + index },
                _this.buildRowCell(function () {
                    return _this.renderStageCell(stage, stageItem, trackedItem, isStageActive, isTrackedItemEditable);
                }, 'stage-' + trackedItem.id + '-' + index, 'stage-cell', isStageActive, isStageClosed, isEnabledExpand, function () {
                    return isEnabledExpand && _this.expandStage(stage);
                }),
                stage.transition && _this.buildRowCell(function () {
                    return _this.renderTransitionCell(stage, stageItem, trackedItem, isTransitionActive, isStageCompleted, isStageClosed);
                }, 'transition-' + trackedItem.id + '-' + index, 'transition-cell', isTransitionActive, isStageCompleted, isEnabledExpand, function () {
                    return isEditable && isEnabledExpand && !isTransitionActive && _this.toggleTransition(stage.transition);
                })
            );
        };

        _this.renderStageAndTransitionColumnsForLastRow = function (stage, isEditable, isEnabledExpand, index) {
            return _react2.default.createElement(
                _react2.default.Fragment,
                { key: 'fragment-' + stage.id + '-last-row-' + index },
                _this.buildRowCell(null, 'stage-' + stage.id + '-last-row', 'stage-cell', _this.isStageActive(stage), _this.isStageClosed(stage), isEnabledExpand, function () {
                    return isEnabledExpand && _this.expandStage(stage);
                }),
                stage.transition && _this.buildRowCell(function () {
                    return _react2.default.createElement(
                        'span',
                        { className: 'transition-cell-data empty-cell' },
                        _this.isStageCompleted(stage) && _react2.default.createElement(
                            'div',
                            { className: 'closed-transition-content' },
                            '\xA0'
                        )
                    );
                }, 'transition-' + stage.transition.id + '-last-row}', 'transition-cell', _this.isTransitionActive(stage.transition), _this.isStageCompleted(stage), isEnabledExpand, function () {
                    return isEditable && isEnabledExpand && !_this.isTransitionActive(stage.transition) && _this.toggleTransition(stage.transition);
                })
            );
        };

        _this.contentContainerRef = _react2.default.createRef();
        _this.scrollableContentRef = _react2.default.createRef();
        _this.state = {
            editModalIsOpen: false,
            trackedItemFilterText: '',
            editModalTitle: 'Add new tracked item',
            trackedItem: {
                id: null,
                title: null
            },
            activeTrackedItemMenu: null,
            activeStageId: null,
            windowResized: true
        };
        (0, _keys2.default)(openModalProps).forEach(function (key) {
            return _this.state[key] = false;
        });
        return _this;
    }

    (0, _createClass3.default)(DeliveryFlowViewComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _props = this.props,
                updateDeliveryFlowPropsFromDetails = _props.updateDeliveryFlowPropsFromDetails,
                delivery = _props.delivery,
                fetchDeliveryDetailsWithPolling = _props.fetchDeliveryDetailsWithPolling;

            updateDeliveryFlowPropsFromDetails();
            fetchDeliveryDetailsWithPolling(delivery.id);
            window.addEventListener('resize', this.updateContainerClass.bind(this));
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            var stopPolling = this.props.stopPolling;

            stopPolling();
            window.removeEventListener('resize', this.updateContainerClass.bind(this));
        }
    }, {
        key: 'updateContainerClass',
        value: function updateContainerClass() {
            this.setState({
                windowResized: !this.state.windowResized
            });
        }
    }, {
        key: 'isColumnShort',
        value: function isColumnShort(numOfRows) {
            return this.contentContainerRef && this.contentContainerRef.current ? this.contentContainerRef.current.clientHeight - headerHeight - headerHeight > numOfRows * rowHeight : false;
        }
    }, {
        key: 'getTransitionActionBlockHeight',
        value: function getTransitionActionBlockHeight() {
            return this.scrollableContentRef && this.scrollableContentRef.current ? this.scrollableContentRef.current.clientHeight - headerHeight - 1 + 'px' : 'auto';
        }
    }, {
        key: 'isStageClosed',
        value: function isStageClosed(stage) {
            return stage.status === _deliveryProperties.stageStatus.closed;
        }
    }, {
        key: 'isStageCompleted',
        value: function isStageCompleted(stage) {
            return this.isStageClosed(stage) && stage.selectableItemsCount === 0;
        }
    }, {
        key: 'isFirstOpenedStage',
        value: function isFirstOpenedStage(stages, stageId) {
            var _this2 = this;

            var firstOpenedStage = stages.find(function (s) {
                return !_this2.isStageClosed(s);
            });
            return !!firstOpenedStage && firstOpenedStage.id === stageId;
        }
    }, {
        key: 'isLastClosedStage',
        value: function isLastClosedStage(stages, stageId) {
            var _this3 = this;

            var lastClosedStage = (0, _lodash.findLast)(stages, function (s) {
                return _this3.isStageClosed(s);
            });
            return !!lastClosedStage && lastClosedStage.id === stageId;
        }
    }, {
        key: 'isRowInFocus',
        value: function isRowInFocus(trackedItemId) {
            var activeTrackedItemMenu = this.state.activeTrackedItemMenu;

            return activeTrackedItemMenu === trackedItemId;
        }
    }, {
        key: 'renderTrackedItemMenu',
        value: function renderTrackedItemMenu(item) {
            var _this4 = this;

            var menuOptions = [{ label: 'Edit', handler: function handler() {
                    return _this4.showEditModal(item);
                } }, { label: 'Delete', handler: function handler() {
                    return _this4.showConfirmModal(item, openModalProps.DELETE);
                } }, {
                label: 'Rescope',
                handler: function handler() {
                    return _this4.showConfirmModal(item, openModalProps.RESCOPE);
                },
                isVisible: item.descoped
            }, {
                label: 'Descope',
                handler: function handler() {
                    return _this4.showConfirmModal(item, openModalProps.DESCOPE);
                },
                isVisible: !item.descoped
            }];

            return _react2.default.createElement(_components.ContextMenuComponent, { menuOptions: menuOptions, menuWrapperClassName: 'tracked-item-menu-wrapper' });
        }
    }, {
        key: 'renderDeleteModal',
        value: function renderDeleteModal() {
            var deleteModalIsOpen = this.state.deleteModalIsOpen;
            var title = this.state.trackedItem.title;

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Delete tracked item',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.onCloseConfirmModal, type: 'button' },
                    _react2.default.createElement('i', {
                        className: 'xl-icon close-icon' })
                )
            );
            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, deleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseConfirmModal,
                    show: deleteModalIsOpen,
                    title: modalHeader },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete tracked item ',
                    _react2.default.createElement(
                        'strong',
                        { className: 'wrap-text' },
                        title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderDescopeModal',
        value: function renderDescopeModal() {
            var descopeModalIsOpen = this.state.descopeModalIsOpen;
            var title = this.state.trackedItem.title;

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Descope tracked item',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.onCloseConfirmModal, type: 'button' },
                    _react2.default.createElement('i', {
                        className: 'xl-icon close-icon' })
                )
            );
            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, descopeButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseConfirmModal,
                    show: descopeModalIsOpen,
                    title: modalHeader },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to descope tracked item ',
                    _react2.default.createElement(
                        'strong',
                        { className: 'wrap-text' },
                        title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderRescopeModal',
        value: function renderRescopeModal() {
            var rescopeModalIsOpen = this.state.rescopeModalIsOpen;
            var title = this.state.trackedItem.title;

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Rescope tracked item',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.onCloseConfirmModal, type: 'button' },
                    _react2.default.createElement('i', {
                        className: 'xl-icon close-icon' })
                )
            );
            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, rescopeButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseConfirmModal,
                    show: rescopeModalIsOpen,
                    title: modalHeader },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to rescope tracked item ',
                    _react2.default.createElement(
                        'strong',
                        { className: 'wrap-text' },
                        title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderSkipModal',
        value: function renderSkipModal() {
            var skipModalIsOpen = this.state.skipModalIsOpen;
            var title = this.state.trackedItem.title;

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Skip tracked item',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.onCloseConfirmModal, type: 'button' },
                    _react2.default.createElement('i', {
                        className: 'xl-icon close-icon' })
                )
            );
            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, skipButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseConfirmModal,
                    show: skipModalIsOpen,
                    title: modalHeader },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to skip tracked item ',
                    _react2.default.createElement(
                        'strong',
                        { className: 'wrap-text' },
                        title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderCompleteModal',
        value: function renderCompleteModal() {
            var completeModalIsOpen = this.state.completeModalIsOpen;
            var title = this.state.trackedItem.title;

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Complete tracked item',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.onCloseConfirmModal, type: 'button' },
                    _react2.default.createElement('i', {
                        className: 'xl-icon close-icon' })
                )
            );
            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, completeButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseConfirmModal,
                    show: completeModalIsOpen,
                    title: modalHeader },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to complete tracked item ',
                    _react2.default.createElement(
                        'strong',
                        { className: 'wrap-text' },
                        title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderRows',
        value: function renderRows(trackedItems, isTrackedItemEditable, isEditable, isEnabledExpand) {
            var _this5 = this;

            var stages = this.props.stages;


            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                trackedItems.map(function (rowTrackedItem, index) {
                    return _this5.buildRow(function () {
                        return stages.map(function (stage) {
                            return _this5.renderStageAndTransitionColumns(stage, rowTrackedItem, index, isTrackedItemEditable, isEnabledExpand);
                        });
                    }, rowTrackedItem.id);
                }),
                // build empty last row
                this.buildRow(function () {
                    return stages.map(function (stage, index) {
                        return _this5.renderStageAndTransitionColumnsForLastRow(stage, isEditable, isEnabledExpand, index);
                    });
                }, null)
            );
        }
    }, {
        key: 'renderFirstColumnRows',
        value: function renderFirstColumnRows(trackedItems) {
            var _this6 = this;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                trackedItems.map(function (rowTrackedItem, index) {
                    return _this6.buildRow(function () {
                        return _this6.renderFirstColumnCell(rowTrackedItem, index);
                    }, rowTrackedItem.id);
                })
            );
        }
    }, {
        key: 'renderStageHeader',
        value: function renderStageHeader(stage, stages, isEnabledExpand) {
            var _this7 = this;

            var _props2 = this.props,
                completeStage = _props2.completeStage,
                delivery = _props2.delivery,
                reopenStage = _props2.reopenStage,
                status = _props2.status,
                trackedItems = _props2.trackedItems;

            var isStageActive = this.isStageActive(stage);
            var isStageClosed = this.isStageClosed(stage);
            var isMenuVisible = function isMenuVisible(stageId) {
                return status !== _deliveryFlow.deliveryStatus.completed && (_this7.isFirstOpenedStage(stages, stageId) || _this7.isLastClosedStage(stages, stageId));
            };

            return _react2.default.createElement(_stageHeader.StageHeaderComponent, {
                collapseStage: this.collapseStage,
                completeStage: completeStage,
                delivery: delivery,
                isActive: isStageActive && isEnabledExpand,
                isClosed: isStageClosed,
                isMenuVisible: isMenuVisible(stage.id),
                reopenStage: reopenStage,
                stage: stage,
                trackedItems: trackedItems });
        }
    }, {
        key: 'renderTransitionHeader',
        value: function renderTransitionHeader(stage, isEditable, isEnabledExpand) {
            var _this8 = this;

            var activeTransition = this.props.activeTransition;

            var isTransitionActive = this.isTransitionActive(stage.transition);
            var allowedItemForSelectCount = stage.items.filter(function (item) {
                return item.transitionItem && !item.transitionItem.disabled;
            }).length;
            var isSelectedAll = stage.transition && stage.transition.selectedTransitionItemCount === allowedItemForSelectCount;
            var transition = activeTransition.status;
            var isStageClosed = this.isStageClosed(stage);
            var typeName = (0, _lodash.upperFirst)((0, _lodash.toLower)((0, _lodash.startCase)(stage.transition.type.split('.')[1])));

            return _react2.default.createElement(_transitionHeader.TransitionHeaderComponent, {
                containerHeight: this.getTransitionActionBlockHeight(),
                handleCompletePrevStageChange: function handleCompletePrevStageChange(isSelected) {
                    return _this8.onCompletePrevStageChange(stage, isSelected);
                },
                handleTransitionClick: function handleTransitionClick() {
                    return _this8.handleTransition(stage);
                },
                isClosed: isStageClosed,
                isCompleted: this.isStageCompleted(stage),
                isEditable: isEditable,
                isEnabledExpand: isEnabledExpand,
                isExpanded: isTransitionActive && isEnabledExpand,
                isSelectable: stage.selectableItemsCount > 0,
                isSelectedAll: isSelectedAll,
                key: stage.transition.id,
                name: stage.transition.title,
                onTransitionColumnSelectChange: function onTransitionColumnSelectChange(isSelected) {
                    return _this8.onTransitionColumnSelectChange(stage.id, isSelected);
                },
                toggleColumn: function toggleColumn() {
                    return _this8.toggleTransition(stage.transition);
                },
                tooltipTitle: stage.transition.title + ' (' + typeName + ')',
                transition: transition
            });
        }
    }, {
        key: 'renderStageAndTransitionHeaders',
        value: function renderStageAndTransitionHeaders(stages, isEditable, isEnabledExpand) {
            var _this9 = this;

            return stages.map(function (stage, i) {
                return _react2.default.createElement(
                    _react2.default.Fragment,
                    { key: 'header-fragment-' + i },
                    _this9.renderStageHeader(stage, stages, isEnabledExpand),
                    stage.transition && _this9.renderTransitionHeader(stage, isEditable, isEnabledExpand)
                );
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _props3 = this.props,
                stages = _props3.stages,
                status = _props3.status,
                trackedItems = _props3.trackedItems;
            var _props$delivery = this.props.delivery,
                isEditable = _props$delivery.isEditable,
                isTrackedItemEditable = _props$delivery.isTrackedItemEditable;
            var _state = this.state,
                editModalIsOpen = _state.editModalIsOpen,
                editModalTitle = _state.editModalTitle,
                trackedItem = _state.trackedItem,
                trackedItemFilterText = _state.trackedItemFilterText;

            var filteredTrackedItems = trackedItems.filter(function (ti) {
                return (0, _lodash.includes)(ti.title.toLowerCase(), trackedItemFilterText.toLowerCase());
            });
            var isEnabledExpand = filteredTrackedItems.length > 0;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                this.renderDeleteModal(),
                this.renderTrackedItemEditModal(editModalIsOpen, editModalTitle, trackedItem, trackedItems),
                this.renderDescopeModal(),
                this.renderRescopeModal(),
                this.renderSkipModal(),
                this.renderCompleteModal(),
                _react2.default.createElement(
                    'div',
                    { className: 'fixed-container' },
                    _react2.default.createElement(
                        'div',
                        { className: 'content-container', ref: this.contentContainerRef },
                        _react2.default.createElement(
                            'div',
                            { id: 'fixed-content' },
                            _react2.default.createElement(
                                'div',
                                { className: 'left-content delivery-header-text' },
                                'Tracked items',
                                _react2.default.createElement(
                                    'button',
                                    { className: 'button',
                                        disabled: !isTrackedItemEditable || status === _deliveryFlow.deliveryStatus.completed,
                                        onClick: this.onCreate, type: 'button' },
                                    'Add item'
                                )
                            ),
                            _react2.default.createElement(
                                'div',
                                { className: 'right-content delivery-header-text' },
                                _react2.default.createElement(
                                    'span',
                                    null,
                                    'Stages'
                                ),
                                _react2.default.createElement(
                                    'div',
                                    { className: 'timeline-container' },
                                    _react2.default.createElement(_deliveryTimeline.DeliveryTimelineComponent, {
                                        endDate: (0, _moment2.default)(this.props.delivery.endDate),
                                        startDate: (0, _moment2.default)(this.props.delivery.startDate) })
                                )
                            )
                        ),
                        _react2.default.createElement(
                            'div',
                            { id: 'scrollable-content', ref: this.scrollableContentRef },
                            _react2.default.createElement(
                                'div',
                                {
                                    className: (0, _classnames2.default)({ 'fill-screen': this.isColumnShort(filteredTrackedItems.length) }),
                                    id: 'content' },
                                _react2.default.createElement(
                                    'div',
                                    { id: 'top-left' },
                                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterDeliveryFieldMetadata,
                                        onUpdate: this.onNameChange })
                                ),
                                _react2.default.createElement(
                                    'div',
                                    { className: 'content-row', id: 'top-row' },
                                    _react2.default.createElement(
                                        'div',
                                        null,
                                        _react2.default.createElement(
                                            'div',
                                            { className: 'header-empty-cell' },
                                            '\xA0'
                                        )
                                    ),
                                    _react2.default.createElement(
                                        'div',
                                        { className: 'table-head', id: 'top-right' },
                                        stages && this.renderStageAndTransitionHeaders(stages, isEditable, isEnabledExpand)
                                    )
                                ),
                                _react2.default.createElement(
                                    'div',
                                    { className: (0, _classnames2.default)('content-row', { 'empty-row': !isEnabledExpand }),
                                        id: 'bottom-row' },
                                    _react2.default.createElement(
                                        'div',
                                        { className: 'table-body', id: 'left-div' },
                                        this.renderFirstColumnRows(filteredTrackedItems)
                                    ),
                                    _react2.default.createElement(
                                        'div',
                                        { className: 'table-body', id: 'center-div' },
                                        this.renderRows(filteredTrackedItems, isTrackedItemEditable, isEditable, isEnabledExpand)
                                    )
                                )
                            )
                        )
                    )
                )
            );
        }
    }]);
    return DeliveryFlowViewComponent;
}(_react.Component);

DeliveryFlowViewComponent.propTypes = {
    activateTransition: _propTypes2.default.func.isRequired,
    activeStageReleases: _propTypes2.default.arrayOf(_deliveryFlow3.ReleaseInfo),
    activeTransition: _propTypes2.default.shape({
        id: _propTypes2.default.string,
        items: _propTypes2.default.arrayOf(_propTypes2.default.any),
        status: _propTypes2.default.any
    }).isRequired,
    completeStage: _propTypes2.default.func.isRequired,
    completeTrackedItem: _propTypes2.default.func.isRequired,
    deactivateTransition: _propTypes2.default.func.isRequired,
    deleteTrackedItem: _propTypes2.default.func.isRequired,
    delivery: _propTypes2.default.any.isRequired,
    descopeTrackedItem: _propTypes2.default.func.isRequired,
    fetchDeliveryDetailsWithPolling: _propTypes2.default.func.isRequired,
    getStageReleaseDetails: _propTypes2.default.func.isRequired,
    loadingReleasesInfo: _propTypes2.default.bool.isRequired,
    postTransitionDetails: _propTypes2.default.func.isRequired,
    reopenStage: _propTypes2.default.func.isRequired,
    rescopeTrackedItem: _propTypes2.default.func.isRequired,
    saveTrackedItem: _propTypes2.default.func.isRequired,
    skipTrackedItem: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_propTypes2.default.any).isRequired,
    status: _propTypes2.default.string.isRequired,
    stopPolling: _propTypes2.default.func.isRequired,
    trackedItemApprovals: _propTypes2.default.arrayOf(_propTypes2.default.any),
    trackedItems: _propTypes2.default.arrayOf(_propTypes2.default.any).isRequired,
    updateDeliveryFlowPropsFromDetails: _propTypes2.default.func.isRequired,
    updateTransitionSelection: _propTypes2.default.func.isRequired
};

/***/ }),

/***/ 3109:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _validators = __webpack_require__(123);

var _deliveryFlow = __webpack_require__(386);

var _validators2 = __webpack_require__(123);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var nameOptions = {
    label: 'Name',
    description: 'Name of the tracked item',
    required: true
};

var nameValidator = function nameValidator(trackedItemList) {
    var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return function (title) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(trackedItemList, id, 'title', title),
            message: (0, _validators.createErrorMessage)('Tracked item already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var TrackedItemEditModalComponent = function (_Component) {
    (0, _inherits3.default)(TrackedItemEditModalComponent, _Component);
    (0, _createClass3.default)(TrackedItemEditModalComponent, null, [{
        key: 'getDerivedStateFromProps',
        value: function getDerivedStateFromProps(props, state) {
            if (!state.trackedItem || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
                return (0, _extends3.default)({}, state, {
                    trackedItem: props.model,
                    prevModel: props.model
                });
            }
            return null;
        }
    }]);

    function TrackedItemEditModalComponent(props) {
        (0, _classCallCheck3.default)(this, TrackedItemEditModalComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (TrackedItemEditModalComponent.__proto__ || (0, _getPrototypeOf2.default)(TrackedItemEditModalComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
            _this.componentApi = componentApi;
        };

        _this.closeModal = function () {
            _this.handleButtonClick(cancelButton.action);
        };

        _this.onCheckboxClick = function (value) {
            _this.setState({ createAnother: value.target.checked });
        };

        _this.resetForm = function () {
            _this.setState({ trackedItem: null, prevModel: null });
            if (_this.componentApi) {
                _this.componentApi.resetPristinity();
                _this.componentApi.focus();
            }
        };

        _this.handleButtonClick = function (action) {
            var _this$props = _this.props,
                onCancel = _this$props.onCancel,
                onSave = _this$props.onSave;
            var _this$state = _this.state,
                trackedItem = _this$state.trackedItem,
                createAnother = _this$state.createAnother;


            switch (action) {
                case 'update':
                    onSave(trackedItem, createAnother);
                    break;
                case 'cancel':
                    onCancel();
                    _this.setState({ createAnother: false });
                    break;
            }
            _this.resetForm();
        };

        _this.handleModelChange = function (newTitle) {
            var trackedItem = _this.state.trackedItem;


            if (newTitle !== trackedItem.title) {
                _this.setState({
                    trackedItem: (0, _extends3.default)({}, trackedItem, {
                        title: newTitle
                    })
                });
            }
        };

        _this.handleValidityChange = function (valid) {
            _this.isValid = valid;
        };

        _this.handlePristinityChange = function (pristine) {
            _this.isPristine = pristine;
        };

        _this.state = {
            trackedItem: null,
            prevModel: null,
            createAnother: false
        };

        _this.isPristine = null;
        _this.isValid = null;

        _this.componentApi = null;
        return _this;
    }

    (0, _createClass3.default)(TrackedItemEditModalComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                isOpened = _props.isOpened,
                trackedItems = _props.trackedItems;
            var trackedItem = this.state.trackedItem;


            var disableSaving = this.isPristine || !this.isValid;

            var updateButton = {
                action: 'update',
                className: 'button primary',
                disabled: disableSaving,
                keyCodes: [13],
                label: 'Save'
            };

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                this.props.modalTitle,
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.closeModal, type: 'button' },
                    _react2.default.createElement('i', { className: 'xl-icon close-icon' })
                )
            );

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, updateButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.handleButtonClick,
                    onCheckboxClick: this.onCheckboxClick,
                    show: isOpened,
                    skin: this.props.modalTitle !== 'Edit tracked item' ? 'checkbox' : 'default',
                    title: modalHeader },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                    metadata: nameOptions,
                    model: trackedItem.title,
                    onModelChange: this.handleModelChange,
                    onPristinityChange: this.handlePristinityChange,
                    onValidityChange: this.handleValidityChange,
                    register: this.onRegister,
                    validators: [nameValidator(trackedItems, trackedItem.id), maxLengthValidator(nameOptions.label, 255), (0, _validators2.reservedCharactersValidator)(nameOptions.label)]
                })
            );
        }
    }]);
    return TrackedItemEditModalComponent;
}(_react.Component);

TrackedItemEditModalComponent.propTypes = {
    isOpened: _propTypes2.default.bool.isRequired,
    modalTitle: _propTypes2.default.string.isRequired,
    model: _deliveryFlow.TrackedItem.isRequired,
    onCancel: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    trackedItems: _propTypes2.default.arrayOf(_deliveryFlow.TrackedItem).isRequired
};
exports.default = TrackedItemEditModalComponent;

/***/ }),

/***/ 311:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    APPLICATION_SEARCH_REQUEST: 'envMgmt/APPLICATION_SEARCH_REQUEST',
    APPLICATION_SEARCH_SUCCESS: 'envMgmt/APPLICATION_SEARCH_SUCCESS',
    APPLICATION_SEARCH_FAILURE: 'envMgmt/APPLICATION_SEARCH_FAILURE',

    APPLICATION_GOTO_CREATE_PAGE: 'envMgmt/APPLICATION_GOTO_CREATE_PAGE',
    APPLICATION_GOTO_EDIT_PAGE: 'envMgmt/APPLICATION_GOTO_EDIT_PAGE',

    APPLICATION_DELETE_REQUEST: 'envMgmt/APPLICATION_DELETE_REQUEST',
    APPLICATION_DELETE_SUCCESS: 'envMgmt/APPLICATION_DELETE_SUCCESS',
    APPLICATION_DELETE_FAILURE: 'envMgmt/APPLICATION_DELETE_FAILURE',

    APPLICATION_FORM_CANCEL: 'envMgmt/APPLICATION_FORM_CANCEL',
    APPLICATION_FORM_CLEAN: 'envMgmt/APPLICATION_FORM_CLEAN',
    APPLICATION_FORM_INIT: 'envMgmt/APPLICATION_FORM_INIT',
    APPLICATION_FORM_FAILURE: 'envMgmt/APPLICATION_FORM_FAILURE',
    APPLICATION_LOAD_REQUEST: 'envMgmt/APPLICATION_LOAD_REQUEST',
    APPLICATION_LOAD_SUCCESS: 'envMgmt/APPLICATION_LOAD_SUCCESS',
    APPLICATION_ENV_LOAD_SUCCESS: 'envMgmt/APPLICATION_ENV_LOAD_SUCCESS',
    APPLICATION_STAGE_LOAD_SUCCESS: 'envMgmt/APPLICATION_STAGE_LOAD_SUCCESS',
    APPLICATION_LIST_LOAD_SUCCESS: 'envMgmt/APPLICATION_LIST_LOAD_SUCCESS',

    APPLICATION_FORM_UPDATE_MODEL: 'envMgmt/APPLICATION_FORM_UPDATE_MODEL',
    APPLICATION_FORM_PRISTINE: 'envMgmt/APPLICATION_FORM_PRISTINE',

    APPLICATION_SAVE_REQUEST: 'envMgmt/APPLICATION_SAVE_REQUEST',
    APPLICATION_SAVE_FAILURE: 'envMgmt/APPLICATION_SAVE_FAILURE'
};

var applicationList = exports.applicationList = {
    searchApplications: function searchApplications(applicationName) {
        return { type: actionTypes.APPLICATION_SEARCH_REQUEST, payload: applicationName };
    },
    goToCreatePage: function goToCreatePage() {
        return { type: actionTypes.APPLICATION_GOTO_CREATE_PAGE };
    },
    goToEditPage: function goToEditPage(application) {
        return { type: actionTypes.APPLICATION_GOTO_EDIT_PAGE, payload: application };
    },
    deleteApplication: function deleteApplication(application) {
        return { type: actionTypes.APPLICATION_DELETE_REQUEST, payload: application };
    }
};

var applicationForm = exports.applicationForm = {
    initForm: function initForm(applicationId) {
        return { type: actionTypes.APPLICATION_FORM_INIT, payload: applicationId };
    },
    cancelForm: function cancelForm() {
        return { type: actionTypes.APPLICATION_FORM_CANCEL };
    },
    saveApplication: function saveApplication(application) {
        return { type: actionTypes.APPLICATION_SAVE_REQUEST, payload: application };
    },
    updateModel: function updateModel(application) {
        return { type: actionTypes.APPLICATION_FORM_UPDATE_MODEL, payload: application };
    },
    pristineFormChange: function pristineFormChange(pristine) {
        return { type: actionTypes.APPLICATION_FORM_PRISTINE, payload: pristine };
    }
};

/***/ }),

/***/ 3110:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeliveryTimelineComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _antd = __webpack_require__(194);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

__webpack_require__(3111);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryTimelineComponent = exports.DeliveryTimelineComponent = function (_Component) {
    (0, _inherits3.default)(DeliveryTimelineComponent, _Component);

    function DeliveryTimelineComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, DeliveryTimelineComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = DeliveryTimelineComponent.__proto__ || (0, _getPrototypeOf2.default)(DeliveryTimelineComponent)).call.apply(_ref, [this].concat(args))), _this), _this.getPopoverContent = function (endDate) {
            var current = (0, _moment2.default)().startOf('day');
            var duration = _moment2.default.duration(endDate.diff(current, 'days'), 'days').asDays();
            var calculatedDuration = duration > 0 ? duration : 0;
            var humanizedDuration = calculatedDuration + ' ' + (calculatedDuration === 1 ? 'day' : 'days');
            return 'Delivery start and end date (' + humanizedDuration + ' left)';
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(DeliveryTimelineComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                startDate = _props.startDate,
                endDate = _props.endDate;


            return _react2.default.createElement(
                _antd.Popover,
                {
                    content: this.getPopoverContent(endDate),
                    overlayClassName: 'delivery-timeline-popover',
                    placement: 'bottom',
                    trigger: 'hover' },
                _react2.default.createElement(
                    'div',
                    { id: 'delivery-timeline' },
                    _react2.default.createElement(
                        'span',
                        null,
                        startDate.format('ll')
                    ),
                    _react2.default.createElement('i', { className: 'inline-item-icon xl-icon icon-l back-icon flip-icon' }),
                    _react2.default.createElement(
                        'span',
                        null,
                        endDate.format('ll')
                    )
                )
            );
        }
    }]);
    return DeliveryTimelineComponent;
}(_react.Component);

DeliveryTimelineComponent.propTypes = {
    endDate: _propTypes2.default.instanceOf(_moment2.default).isRequired,
    startDate: _propTypes2.default.instanceOf(_moment2.default).isRequired
};

/***/ }),

/***/ 3111:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3113:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.StageHeaderComponent = undefined;

var _set = __webpack_require__(512);

var _set2 = _interopRequireDefault(_set);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

var _xlReactComponents = __webpack_require__(47);

var _deliveryFlow = __webpack_require__(468);

var _components = __webpack_require__(67);

__webpack_require__(3114);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CONFIRM_ACTIONS = {
    reopen: 'reopen',
    complete: 'complete'
};

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var completeButton = {
    action: CONFIRM_ACTIONS.complete,
    className: 'button primary',
    keyCodes: [13],
    label: 'Complete'
};

var reopenButton = {
    action: CONFIRM_ACTIONS.reopen,
    className: 'button primary',
    keyCodes: [13],
    label: 'Reopen'
};

var StageHeaderComponent = exports.StageHeaderComponent = function (_Component) {
    (0, _inherits3.default)(StageHeaderComponent, _Component);

    function StageHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, StageHeaderComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(StageHeaderComponent)).call(this, props));

        _this.handleCompleteConfirmClose = function () {
            _this.setState({
                showCloseConfirm: false
            });
        };

        _this.handleCompleteConfirmAction = function (action) {
            var _this$props = _this.props,
                completeStage = _this$props.completeStage,
                stage = _this$props.stage;

            if (action === CONFIRM_ACTIONS.complete) {
                completeStage(stage.id);
            }
            _this.setState({
                showCloseConfirm: false
            });
        };

        _this.handleReopenConfirmClose = function () {
            _this.setState({
                showReopenConfirm: false
            });
        };

        _this.handleReopenConfirmAction = function (action) {
            var _this$props2 = _this.props,
                reopenStage = _this$props2.reopenStage,
                stage = _this$props2.stage;

            if (action === CONFIRM_ACTIONS.reopen) {
                reopenStage(stage.id);
            }
            _this.setState({
                showReopenConfirm: false
            });
        };

        _this.state = {
            showCloseConfirm: false,
            showReopenConfirm: false
        };
        return _this;
    }

    (0, _createClass3.default)(StageHeaderComponent, [{
        key: 'buildModalHeader',
        value: function buildModalHeader(caption, fn) {
            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(
                    'span',
                    { className: 'delivery-header-text' },
                    caption,
                    _react2.default.createElement(
                        'button',
                        { className: 'btn-close', onClick: fn, type: 'button' },
                        _react2.default.createElement('i', {
                            className: 'xl-icon close-icon' })
                    )
                )
            );
        }
    }, {
        key: 'renderCompleteConfirmDialog',
        value: function renderCompleteConfirmDialog() {
            var _props = this.props,
                delivery = _props.delivery,
                stage = _props.stage,
                trackedItems = _props.trackedItems;
            var showCloseConfirm = this.state.showCloseConfirm;


            var modalHeader = this.buildModalHeader('Complete stage', this.handleCompleteConfirmClose);

            var descopedItemIds = new _set2.default(trackedItems.filter(function (i) {
                return i.descoped;
            }).map(function (i) {
                return i.id;
            }));
            var itemIds = stage.items.filter(function (item) {
                return !descopedItemIds.has(item.trackedItemId) && item.status === _deliveryFlow.trackedItemStatus.notReady;
            }).map(function (item) {
                return item.trackedItemId;
            });
            var isLastStage = delivery.stages.slice(-1)[0].id === stage.id;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, completeButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.handleCompleteConfirmAction,
                    show: showCloseConfirm,
                    title: modalHeader },
                isLastStage && _react2.default.createElement(
                    'p',
                    { className: 'alert alert-warning' },
                    'This stage is the last in this delivery. Completing this stage will complete the delivery. You will not be able to close/reopen stages in the completed delivery.'
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to close the stage ',
                    _react2.default.createElement(
                        'span',
                        { className: 'stage-name' },
                        stage.title
                    ),
                    '.'
                ),
                itemIds.length > 0 && _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(
                        'p',
                        null,
                        'By closing this stage the following not ready items will be marked as descoped in this delivery.'
                    ),
                    _react2.default.createElement(
                        'p',
                        { className: 'tracked-item-list-msg' },
                        'Tracked items that will be descoped (',
                        itemIds.length,
                        ')'
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'tracked-item-container' },
                        trackedItems.filter(function (ti) {
                            return itemIds.includes(ti.id);
                        }).map(function (item, index) {
                            return _react2.default.createElement(
                                'p',
                                { className: 'tracked-item-row', key: index },
                                item.title
                            );
                        })
                    )
                )
            );
        }
    }, {
        key: 'renderReopenConfirmDialog',
        value: function renderReopenConfirmDialog() {
            var stage = this.props.stage;
            var showReopenConfirm = this.state.showReopenConfirm;


            var modalHeader = this.buildModalHeader('Reopen stage', this.handleReopenConfirmClose);

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, reopenButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.handleReopenConfirmAction,
                    show: showReopenConfirm,
                    title: modalHeader },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to reopen the stage ',
                    _react2.default.createElement(
                        'span',
                        { className: 'stage-name' },
                        stage.title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props2 = this.props,
                collapseStage = _props2.collapseStage,
                isActive = _props2.isActive,
                isClosed = _props2.isClosed,
                isMenuVisible = _props2.isMenuVisible,
                stage = _props2.stage;
            var isEditable = this.props.delivery.isEditable;


            var menuOptions = [{
                label: 'Complete', handler: function handler() {
                    _this2.setState({ showCloseConfirm: true });
                },
                isVisible: !isClosed
            }, {
                label: 'Reopen', handler: function handler() {
                    _this2.setState({ showReopenConfirm: true });
                },
                isVisible: isClosed
            }];

            return _react2.default.createElement(
                'span',
                { className: (0, _classnames2.default)('header-cell', 'stage-header', 'curved-border-top', { 'active': isActive }, { 'closed': isClosed }), key: stage.id },
                _react2.default.createElement(
                    'div',
                    { className: 'stage-title-wrapper' },
                    _react2.default.createElement(
                        'div',
                        { className: 'stage-title' },
                        _react2.default.createElement(
                            'h6',
                            { className: 'truncate-title', title: stage.title },
                            stage.title
                        )
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'stage-actions' },
                        isClosed && _react2.default.createElement(
                            'div',
                            { className: 'label label-completed' },
                            'Completed'
                        ),
                        isActive && _react2.default.createElement(
                            'a',
                            { className: 'link-collapse-stage', onClick: collapseStage },
                            'Close detail view'
                        ),
                        isEditable && isMenuVisible && _react2.default.createElement(_components.ContextMenuComponent, {
                            menuName: stage.title,
                            menuOptions: menuOptions,
                            menuWrapperClassName: 'stage-header-menu' })
                    )
                ),
                this.renderCompleteConfirmDialog(),
                this.renderReopenConfirmDialog()
            );
        }
    }]);
    return StageHeaderComponent;
}(_react.Component);

StageHeaderComponent.propTypes = {
    collapseStage: _propTypes2.default.func.isRequired,
    completeStage: _propTypes2.default.func.isRequired,
    delivery: _propTypes2.default.any.isRequired,
    isActive: _propTypes2.default.bool.isRequired,
    isClosed: _propTypes2.default.bool.isRequired,
    isMenuVisible: _propTypes2.default.bool.isRequired,
    reopenStage: _propTypes2.default.func.isRequired,
    stage: _propTypes2.default.any.isRequired,
    trackedItems: _propTypes2.default.arrayOf(_propTypes2.default.any).isRequired
};

/***/ }),

/***/ 3114:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3116:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.StageCellComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = __webpack_require__(62);

var _xlReactComponents = __webpack_require__(47);

var _reactContentLoader = __webpack_require__(3117);

var _reactContentLoader2 = _interopRequireDefault(_reactContentLoader);

var _ids = __webpack_require__(110);

var _ids2 = _interopRequireDefault(_ids);

var _deliveryFlow = __webpack_require__(468);

var _components = __webpack_require__(67);

var _releaseList = __webpack_require__(3118);

__webpack_require__(3121);

var _deliveryFlow2 = __webpack_require__(386);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var Ids = (0, _ids2.default)();

var StageCellComponent = exports.StageCellComponent = function (_Component) {
    (0, _inherits3.default)(StageCellComponent, _Component);

    function StageCellComponent(props) {
        (0, _classCallCheck3.default)(this, StageCellComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageCellComponent.__proto__ || (0, _getPrototypeOf2.default)(StageCellComponent)).call(this, props));

        _this.openReleaseListModal = function () {
            _this.setState({
                showReleaseList: true
            });
        };

        _this.openFailingReleasesModal = function () {
            _this.setState({
                showReleaseList: true,
                onlyFailing: true
            });
        };

        _this.closeReleaseListModal = function () {
            _this.setState({
                showReleaseList: false,
                onlyFailing: false
            });
        };

        _this.isFailing = function (rel) {
            return rel.status === 'failed' || rel.status === 'failing';
        };

        _this.buildContent = function (leftRenderer) {
            var rightRenderer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(
                    'div',
                    { className: 'cell-data-content-left' },
                    leftRenderer()
                ),
                rightRenderer && _react2.default.createElement(
                    'div',
                    { className: 'cell-data-content-right' },
                    rightRenderer()
                )
            );
        };

        _this.renderContent = function () {
            var _this$props = _this.props,
                stageItem = _this$props.stageItem,
                trackedItem = _this$props.trackedItem,
                isExpanded = _this$props.isExpanded,
                expandedStageReleases = _this$props.expandedStageReleases,
                isMenuVisible = _this$props.isMenuVisible,
                stageMenuOptions = _this$props.stageMenuOptions;

            var content = null;
            var status = null;

            if (trackedItem.descoped) {
                status = _react2.default.createElement('i', { className: 'xl-icon icon-xl circle-outline-cross-icon' });
                content = _this.buildContent(function () {
                    return 'Manually descoped';
                }, function () {
                    return _this.renderReleaseCount(trackedItem.releaseIds);
                });
            } else if (stageItem) {
                switch (stageItem.status) {
                    case _deliveryFlow.trackedItemStatus.ready:
                        {
                            status = _react2.default.createElement('i', { className: 'xl-icon icon-xl circle-check-icon' });
                            content = _this.buildContent(function () {
                                return 'Completed this stage';
                            }, function () {
                                return _this.renderReleaseCount(trackedItem.releaseIds);
                            });
                            break;
                        }
                    case _deliveryFlow.trackedItemStatus.notReady:
                        {
                            if (trackedItem.releaseIds && trackedItem.releaseIds.length === 0) {
                                status = _react2.default.createElement('i', { className: 'xl-icon icon-xl pending-icon' });
                                content = _this.buildContent(function () {
                                    return 'Waiting for activity';
                                }, function () {
                                    return _this.renderMenu(stageMenuOptions, isMenuVisible);
                                });
                                break;
                            } else if (expandedStageReleases.length && trackedItem.releaseIds.length) {
                                content = _this.renderRegisteredItemContent();
                            }
                            status = _react2.default.createElement(
                                'i',
                                { className: 'xl-icon icon-xl progress-icon' },
                                !isExpanded && expandedStageReleases.find(function (rel) {
                                    return _this.isFailing(rel) && (trackedItem.releaseIds || []).map(function (id) {
                                        return Ids.getName(id);
                                    }).includes(rel.id);
                                }) && _react2.default.createElement('i', { className: 'xl-icon circle-exclamation-icon top-right' })
                            );
                            break;
                        }
                    case _deliveryFlow.trackedItemStatus.skipped:
                        {
                            status = _react2.default.createElement('i', { className: 'xl-icon icon-xl circle-minus-icon' });
                            content = _this.buildContent(function () {
                                return 'Skipped';
                            }, function () {
                                return _this.renderReleaseCount(trackedItem.releaseIds);
                            });
                            break;
                        }
                }
            }

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                status && _react2.default.createElement(
                    'span',
                    { className: 'details-status' },
                    status
                ) || _react2.default.createElement(
                    'span',
                    null,
                    '\xA0'
                ),
                isExpanded && _react2.default.createElement(
                    'span',
                    { className: 'details-content' },
                    content
                )
            );
        };

        _this.state = {
            showReleaseList: false,
            onlyFailing: false
        };
        return _this;
    }

    (0, _createClass3.default)(StageCellComponent, [{
        key: 'renderDeliveryMemberList',
        value: function renderDeliveryMemberList() {
            var _props = this.props,
                trackedItem = _props.trackedItem,
                expandedStageReleases = _props.expandedStageReleases;
            var showReleaseList = this.state.showReleaseList;

            var releaseList = (0, _lodash.intersectionWith)(expandedStageReleases, (trackedItem.releaseIds || []).map(function (id) {
                return Ids.getName(id);
            }), function (_ref, releaseId) {
                var id = _ref.id;
                return id === releaseId;
            });

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Linked Releases (',
                releaseList.length,
                ')',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.closeReleaseListModal, type: 'button' },
                    _react2.default.createElement('i', { className: 'xl-icon close-icon' })
                )
            );

            releaseList.forEach(function (item) {
                item.fullId = trackedItem.releaseIds.find(function (id) {
                    return Ids.getName(id) === item.id;
                });
            });

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.closeReleaseListModal,
                    show: showReleaseList,
                    title: modalHeader },
                _react2.default.createElement(_releaseList.ReleaseListComponent, {
                    releaseList: this.state.onlyFailing ? releaseList.filter(this.isFailing) : releaseList })
            );
        }
    }, {
        key: 'renderMenu',
        value: function renderMenu(stageMenuOptions, isVisible) {
            return isVisible && _react2.default.createElement(_components.ContextMenuComponent, { menuOptions: stageMenuOptions, menuWrapperClassName: 'stage-menu-wrapper' });
        }
    }, {
        key: 'renderReleaseCount',
        value: function renderReleaseCount(releaseIds) {
            return releaseIds.length > 0 && _react2.default.createElement(
                'a',
                { className: 'release-counter', onClick: this.openReleaseListModal },
                releaseIds.length,
                ' releases'
            );
        }
    }, {
        key: 'renderRegisteredItemContent',
        value: function renderRegisteredItemContent() {
            var _this2 = this;

            var _props2 = this.props,
                trackedItem = _props2.trackedItem,
                expandedStageReleases = _props2.expandedStageReleases,
                stageMenuOptions = _props2.stageMenuOptions,
                isMenuVisible = _props2.isMenuVisible;


            var getReleaseInfo = function getReleaseInfo(releases, releaseId) {
                var failing = releases.find(_this2.isFailing);
                return failing || releases.find(function (rel) {
                    return rel.id === releaseId;
                });
            };
            var ids = (trackedItem.releaseIds || []).map(function (id) {
                return Ids.getName(id);
            });
            var stageReleases = expandedStageReleases.filter(function (r) {
                return ids.includes(r.id);
            });
            var failingCount = stageReleases.filter(this.isFailing).length;
            var release = getReleaseInfo(stageReleases, (0, _lodash.last)(ids));
            var leftContent = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                failingCount === 0 && _react2.default.createElement(
                    'span',
                    { className: 'release-title' },
                    _react2.default.createElement('i', {
                        className: 'xl-icon icon-xl release-icon' }),
                    release && release.title
                ),
                failingCount > 0 && _react2.default.createElement(
                    'div',
                    null,
                    _react2.default.createElement(
                        'div',
                        null,
                        'In progress'
                    ),
                    _react2.default.createElement(
                        'span',
                        { className: 'release-title failed' },
                        failingCount === 1 && _react2.default.createElement(
                            'span',
                            null,
                            _react2.default.createElement('i', { className: 'xl-icon circle-exclamation-icon' }),
                            _react2.default.createElement(
                                'a',
                                {
                                    href: "#/releases/" + release.id },
                                release.title,
                                ' is failing'
                            )
                        ),
                        failingCount > 1 && _react2.default.createElement(
                            'span',
                            null,
                            _react2.default.createElement('i', { className: 'xl-icon circle-exclamation-icon' }),
                            _react2.default.createElement(
                                'a',
                                {
                                    onClick: this.openFailingReleasesModal },
                                failingCount,
                                ' releases are failing'
                            )
                        )
                    )
                )
            );

            var rightContent = _react2.default.createElement(
                'span',
                { className: 'counter-and-menu-wrapper' },
                this.renderMenu(stageMenuOptions, isMenuVisible),
                this.renderReleaseCount(trackedItem.releaseIds)
            );

            return this.buildContent(function () {
                return leftContent;
            }, function () {
                return rightContent;
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _props3 = this.props,
                isExpanded = _props3.isExpanded,
                loading = _props3.loading;


            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(
                    'div',
                    { className: (0, _classnames2.default)('stage-cell-content', isExpanded ? 'active' : '') },
                    loading && isExpanded && _react2.default.createElement(
                        _reactContentLoader2.default,
                        { height: 50, speed: 1, width: 500 },
                        _react2.default.createElement('rect', { height: '30', rx: '20', ry: '20', width: '30', x: '0', y: '0' }),
                        _react2.default.createElement('rect', { height: '14', rx: '4', ry: '4', width: '450', x: '50', y: '9' })
                    ),
                    !(isExpanded && loading) && this.renderContent()
                ),
                this.renderDeliveryMemberList()
            );
        }
    }]);
    return StageCellComponent;
}(_react.Component);

StageCellComponent.propTypes = {
    expandedStageReleases: _propTypes2.default.arrayOf(_deliveryFlow2.ReleaseInfo),
    isExpanded: _propTypes2.default.bool.isRequired,
    isMenuVisible: _propTypes2.default.bool.isRequired,
    loading: _propTypes2.default.bool.isRequired,
    stageItem: _propTypes2.default.any,
    stageMenuOptions: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        label: _propTypes2.default.string,
        handler: _propTypes2.default.func
    })),
    trackedItem: _propTypes2.default.any.isRequired
};

/***/ }),

/***/ 3118:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReleaseListComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _components = __webpack_require__(67);

__webpack_require__(3119);

var _deliveryFlow = __webpack_require__(386);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseListComponent = exports.ReleaseListComponent = function (_Component) {
    (0, _inherits3.default)(ReleaseListComponent, _Component);

    function ReleaseListComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, ReleaseListComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = ReleaseListComponent.__proto__ || (0, _getPrototypeOf2.default)(ReleaseListComponent)).call.apply(_ref, [this].concat(args))), _this), _this.renderReleaseRows = function (releaseList) {
            return releaseList.map(function (releaseDetail, i) {
                var releaseUrl = '#/releases/' + releaseDetail.fullId.replace(/^Applications\//, '').replace(/\//g, '-');

                return _react2.default.createElement(
                    'div',
                    { className: 'col-xs-12 release-list-modal-release-row release', key: i },
                    _react2.default.createElement(
                        'div',
                        { className: 'adjust-release-line release-modal-line release-line' },
                        _react2.default.createElement(
                            'div',
                            { className: 'row-wrapper' },
                            _react2.default.createElement(
                                'div',
                                { className: 'col-xs-5 release-title-wrapper' },
                                _react2.default.createElement(
                                    'strong',
                                    { className: 'release-title raised-link-target' },
                                    _react2.default.createElement(
                                        'a',
                                        { className: 'black-text', href: releaseUrl },
                                        releaseDetail.title
                                    )
                                )
                            ),
                            _react2.default.createElement(
                                'div',
                                { className: 'col-xs-4 text-left' },
                                _react2.default.createElement(_components.ReleaseStatusComponent, { isArchived: releaseDetail.archived, status: releaseDetail.status })
                            ),
                            _react2.default.createElement(
                                'div',
                                { className: 'col-xs-4 text-left calendar-link' },
                                _react2.default.createElement(
                                    'div',
                                    null,
                                    _react2.default.createElement(
                                        'span',
                                        null,
                                        moment(releaseDetail.startDate).format('lll')
                                    )
                                )
                            ),
                            _react2.default.createElement(
                                'div',
                                { className: 'col-xs-4 text-left calendar-link' },
                                _react2.default.createElement(
                                    'div',
                                    null,
                                    _react2.default.createElement(
                                        'span',
                                        null,
                                        releaseDetail.endDate ? moment(releaseDetail.endDate).format('lll') : ''
                                    )
                                )
                            )
                        )
                    )
                );
            });
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(ReleaseListComponent, [{
        key: 'render',
        value: function render() {
            var releaseList = this.props.releaseList;


            return _react2.default.createElement(
                'div',
                { className: 'f-add-release' },
                _react2.default.createElement(
                    'div',
                    { className: 'releases-list-modal-sub-header' },
                    _react2.default.createElement(
                        'div',
                        { className: 'row' },
                        _react2.default.createElement(
                            'div',
                            { className: 'col-xs-12' },
                            _react2.default.createElement(
                                'div',
                                { className: 'row' },
                                _react2.default.createElement(
                                    'div',
                                    { className: 'col-xs-5' },
                                    _react2.default.createElement(
                                        'div',
                                        null,
                                        _react2.default.createElement(
                                            'label',
                                            null,
                                            _react2.default.createElement(
                                                'span',
                                                { className: 'header' },
                                                'Releases'
                                            )
                                        )
                                    )
                                ),
                                _react2.default.createElement(
                                    'div',
                                    { className: 'col-xs-7' },
                                    _react2.default.createElement(
                                        'div',
                                        { className: 'row' },
                                        _react2.default.createElement(
                                            'div',
                                            { className: 'col-xs-2 text-left' },
                                            '\xA0'
                                        ),
                                        _react2.default.createElement(
                                            'div',
                                            { className: 'col-xs-4 text-left' },
                                            _react2.default.createElement(
                                                'div',
                                                { className: 'release-table-text' },
                                                'Start date'
                                            )
                                        ),
                                        _react2.default.createElement(
                                            'div',
                                            { className: 'col-xs-4 text-left end-date' },
                                            _react2.default.createElement(
                                                'div',
                                                { className: 'release-table-text' },
                                                'End date'
                                            )
                                        )
                                    )
                                )
                            )
                        )
                    )
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'release-modal-list' },
                    this.renderReleaseRows(releaseList)
                )
            );
        }
    }]);
    return ReleaseListComponent;
}(_react.Component);

ReleaseListComponent.propTypes = {
    releaseList: _propTypes2.default.arrayOf(_deliveryFlow.ReleaseInfo)
};

/***/ }),

/***/ 3119:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 312:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReleaseRow = exports.HeaderRow = exports.OrderConst = undefined;

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var OrderConst = exports.OrderConst = {
    SORT_ASC: 'asc',
    SORT_DESC: 'desc',
    SORT_NONE: 'none'
};

var HeaderRow = exports.HeaderRow = _propTypes2.default.shape({
    class: _propTypes2.default.string,
    fieldName: _propTypes2.default.string.isRequired,
    label: _propTypes2.default.string.isRequired,
    order: _propTypes2.default.oneOf([OrderConst.SORT_NONE, OrderConst.SORT_DESC, OrderConst.SORT_ASC]),
    sortable: _propTypes2.default.bool.isRequired,
    iteratees: _propTypes2.default.any
});

var ReleaseRow = exports.ReleaseRow = _propTypes2.default.shape({
    currentPhase: _propTypes2.default.string,
    duration: _propTypes2.default.number.isRequired,
    endDate: _propTypes2.default.number.isRequired,
    folders: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    })),
    id: _propTypes2.default.string.isRequired,
    isArchived: _propTypes2.default.bool.isRequired,
    progress: _propTypes2.default.any.isRequired,
    startDate: _propTypes2.default.number.isRequired,
    status: _propTypes2.default.string.isRequired,
    title: _propTypes2.default.string.isRequired
});

/***/ }),

/***/ 3121:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3123:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TransitionHeaderComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(1);

var _classnames2 = _interopRequireDefault(_classnames);

var _antd = __webpack_require__(194);

var _transitionAction = __webpack_require__(3124);

__webpack_require__(3127);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TransitionHeaderComponent = exports.TransitionHeaderComponent = function (_Component) {
    (0, _inherits3.default)(TransitionHeaderComponent, _Component);

    function TransitionHeaderComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, TransitionHeaderComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = TransitionHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(TransitionHeaderComponent)).call.apply(_ref, [this].concat(args))), _this), _this.renderTransitionActionBox = function (transition, isActionSelectable, isEditable, isClosed, handleTransitionClick, handleCompletePrevStageChange, containerHeight) {
            return _react2.default.createElement(
                'span',
                { className: 'transition-action-wrapper' },
                _react2.default.createElement(_transitionAction.TransitionActionComponent, {
                    containerHeight: containerHeight,
                    handleCompletePrevStageChange: handleCompletePrevStageChange,
                    handleTransitionClick: handleTransitionClick,
                    isClosed: isClosed,
                    isEditable: isEditable,
                    isSelectable: isActionSelectable,
                    transition: transition
                })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(TransitionHeaderComponent, [{
        key: 'renderIconPopover',
        value: function renderIconPopover(tooltipTitle) {
            return _react2.default.createElement(
                _antd.Popover,
                {
                    arrowPointAtCenter: true,
                    content: _react2.default.createElement(
                        'span',
                        { className: 'tooltip-title' },
                        tooltipTitle
                    ),
                    overlayClassName: 'help-tooltip',
                    placement: 'bottom' },
                _react2.default.createElement('i', { className: 'xl-icon user-icon icon-l' })
            );
        }
    }, {
        key: 'renderToggleButton',
        value: function renderToggleButton(isExpanded, toggleColumn, isEditable) {
            return _react2.default.createElement(
                'span',
                { className: 'transition-toggle-button', onClick: function onClick() {
                        return toggleColumn();
                    } },
                _react2.default.createElement('i', { className: (0, _classnames2.default)('xl-icon', { 'chevron-left-icon': isExpanded }, { 'chevron-right-icon': !isExpanded }) })
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                isExpanded = _props.isExpanded,
                isSelectable = _props.isSelectable,
                isSelectedAll = _props.isSelectedAll,
                isCompleted = _props.isCompleted,
                name = _props.name,
                tooltipTitle = _props.tooltipTitle,
                onTransitionColumnSelectChange = _props.onTransitionColumnSelectChange,
                toggleColumn = _props.toggleColumn,
                isEditable = _props.isEditable,
                isEnabledExpand = _props.isEnabledExpand,
                transition = _props.transition,
                containerHeight = _props.containerHeight,
                isClosed = _props.isClosed,
                handleTransitionClick = _props.handleTransitionClick,
                handleCompletePrevStageChange = _props.handleCompletePrevStageChange;

            return _react2.default.createElement(
                'span',
                { className: (0, _classnames2.default)('header-cell', 'transition-header', { 'active': isExpanded }, { 'closed': isCompleted }) },
                isExpanded ? _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(
                        'div',
                        { className: 'transition-cell-data' },
                        isEditable && isSelectable && isSelectedAll && _react2.default.createElement(
                            'div',
                            { className: 'header-checkbox selected',
                                onClick: function onClick() {
                                    return onTransitionColumnSelectChange(false);
                                } },
                            '\xA0'
                        ),
                        isEditable && isSelectable && !isSelectedAll && _react2.default.createElement(
                            'div',
                            { className: 'header-checkbox',
                                onClick: function onClick() {
                                    return onTransitionColumnSelectChange(true);
                                } },
                            '\xA0'
                        ),
                        !isEditable && _react2.default.createElement(
                            'div',
                            { className: 'header-checkbox disabled' },
                            '\xA0'
                        ),
                        this.renderTransitionActionBox(transition, isSelectable, isEditable, isClosed, handleTransitionClick, handleCompletePrevStageChange, containerHeight)
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'transition-cell-actions' },
                        _react2.default.createElement(
                            'h6',
                            { className: 'transition-name', title: name },
                            name
                        ),
                        this.renderIconPopover(tooltipTitle)
                    )
                ) : _react2.default.createElement(
                    'div',
                    { className: 'transition-cell-data' },
                    this.renderIconPopover(tooltipTitle)
                ),
                isEnabledExpand && this.renderToggleButton(isExpanded, toggleColumn, isEditable)
            );
        }
    }]);
    return TransitionHeaderComponent;
}(_react.Component);

TransitionHeaderComponent.propTypes = {
    containerHeight: _propTypes2.default.any,
    handleCompletePrevStageChange: _propTypes2.default.func.isRequired,
    handleTransitionClick: _propTypes2.default.func.isRequired,
    isClosed: _propTypes2.default.bool.isRequired,
    isCompleted: _propTypes2.default.bool.isRequired,
    isEditable: _propTypes2.default.bool.isRequired,
    isEnabledExpand: _propTypes2.default.bool.isRequired,
    isExpanded: _propTypes2.default.bool.isRequired,
    isSelectable: _propTypes2.default.bool.isRequired,
    isSelectedAll: _propTypes2.default.bool.isRequired,
    name: _propTypes2.default.string.isRequired,
    onTransitionColumnSelectChange: _propTypes2.default.func.isRequired,
    toggleColumn: _propTypes2.default.func.isRequired,
    tooltipTitle: _propTypes2.default.string.isRequired,
    transition: _propTypes2.default.any
};

/***/ }),

/***/ 3124:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TransitionActionComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

__webpack_require__(3125);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var checkboxFormMetadata = {
    label: '',
    description: ''
};

var TransitionActionComponent = exports.TransitionActionComponent = function (_Component) {
    (0, _inherits3.default)(TransitionActionComponent, _Component);

    function TransitionActionComponent() {
        (0, _classCallCheck3.default)(this, TransitionActionComponent);
        return (0, _possibleConstructorReturn3.default)(this, (TransitionActionComponent.__proto__ || (0, _getPrototypeOf2.default)(TransitionActionComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(TransitionActionComponent, [{
        key: 'renderActionBoxWhenStageOpenedWithSelectableItems',
        value: function renderActionBoxWhenStageOpenedWithSelectableItems(transition, handleTransitionClick, handleCompletePrevStageChange, isEditable, height) {
            return _react2.default.createElement(
                'div',
                { className: 'transition-action-container', style: { height: height } },
                _react2.default.createElement(
                    'h5',
                    { className: 'transition-title' },
                    'Action'
                ),
                _react2.default.createElement(
                    'div',
                    null,
                    'Select the tracked items that should transition to the next stage'
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'transition-action-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactDipBoolean, {
                        disabled: !isEditable,
                        metadata: checkboxFormMetadata,
                        model: transition.closeStages,
                        onModelChange: function onModelChange(isSelected) {
                            return handleCompletePrevStageChange(isSelected);
                        }
                    }),
                    _react2.default.createElement(
                        'div',
                        { className: 'transition-action-form-text' },
                        _react2.default.createElement(
                            'div',
                            { className: 'transition-action-label',
                                onClick: function onClick() {
                                    return handleCompletePrevStageChange(!transition.closeStages);
                                } },
                            'Complete the previous stages'
                        ),
                        _react2.default.createElement(
                            'div',
                            { className: 'transition-action-description' },
                            'Closing a stage causes all tracked items that are not checked to be descoped, and makes it impossible to interact with this and the preceding stages unless they are reopened'
                        )
                    )
                ),
                _react2.default.createElement(
                    'button',
                    {
                        className: 'button primary',
                        disabled: transition.disabledTransition || !isEditable,
                        onClick: handleTransitionClick },
                    'Transition (',
                    transition.selectedTransitionItemCount,
                    ') tracked items'
                )
            );
        }
    }, {
        key: 'renderActionBoxWhenStageOpenedWithoutSelectableItems',
        value: function renderActionBoxWhenStageOpenedWithoutSelectableItems(height) {
            return _react2.default.createElement(
                'div',
                { className: 'transition-action-container without-item', style: { height: height } },
                _react2.default.createElement(
                    'h5',
                    { className: 'transition-title' },
                    'Action'
                ),
                _react2.default.createElement(
                    'div',
                    null,
                    'There are currently no tracked items available to transition to the next stage'
                ),
                _react2.default.createElement(
                    'button',
                    {
                        className: 'button primary',
                        disabled: true
                    },
                    'Transition (0) tracked items'
                )
            );
        }
    }, {
        key: 'renderActionBoxWhenStageClosedWithSelectableItems',
        value: function renderActionBoxWhenStageClosedWithSelectableItems(height) {
            return _react2.default.createElement(
                'div',
                { className: 'transition-action-container without-item', style: { height: height } },
                _react2.default.createElement(
                    'h5',
                    { className: 'transition-title' },
                    'Action'
                ),
                _react2.default.createElement(
                    'div',
                    null,
                    'Some tracked item(s) did not transition to the next stage, please reopen the stage to make a transition.'
                )
            );
        }
    }, {
        key: 'renderActionBoxWhenStageClosedWithoutSelectableItems',
        value: function renderActionBoxWhenStageClosedWithoutSelectableItems() {
            return _react2.default.createElement('div', null);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                isClosed = _props.isClosed,
                containerHeight = _props.containerHeight,
                transition = _props.transition,
                isSelectable = _props.isSelectable,
                handleTransitionClick = _props.handleTransitionClick,
                isEditable = _props.isEditable,
                handleCompletePrevStageChange = _props.handleCompletePrevStageChange;


            if (!isClosed) {
                return isSelectable ? this.renderActionBoxWhenStageOpenedWithSelectableItems(transition, handleTransitionClick, handleCompletePrevStageChange, isEditable, containerHeight) : this.renderActionBoxWhenStageOpenedWithoutSelectableItems(containerHeight);
            } else {
                return isSelectable ? this.renderActionBoxWhenStageClosedWithSelectableItems(containerHeight) : this.renderActionBoxWhenStageClosedWithoutSelectableItems();
            }
        }
    }]);
    return TransitionActionComponent;
}(_react.Component);

TransitionActionComponent.propTypes = {
    containerHeight: _propTypes2.default.string.isRequired,
    handleCompletePrevStageChange: _propTypes2.default.func.isRequired,
    handleTransitionClick: _propTypes2.default.func.isRequired,
    isClosed: _propTypes2.default.bool.isRequired,
    isEditable: _propTypes2.default.bool.isRequired,
    isSelectable: _propTypes2.default.bool.isRequired,
    transition: _propTypes2.default.any.isRequired
};

/***/ }),

/***/ 3125:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3127:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3129:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TransitionCellComponent = undefined;

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _antd = __webpack_require__(194);

var _xlReactComponents = __webpack_require__(47);

__webpack_require__(3130);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var checkboxFormMetadata = {
    label: '',
    description: ''
};

var TransitionCellComponent = exports.TransitionCellComponent = function (_Component) {
    (0, _inherits3.default)(TransitionCellComponent, _Component);

    function TransitionCellComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, TransitionCellComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = TransitionCellComponent.__proto__ || (0, _getPrototypeOf2.default)(TransitionCellComponent)).call.apply(_ref, [this].concat(args))), _this), _this.renderWithPopover = function (content, body) {
            return _react2.default.createElement(
                _antd.Popover,
                {
                    arrowPointAtCenter: true,
                    content: content,
                    mouseLeaveDelay: 0,
                    overlayClassName: 'transition-approval-popover',
                    placement: 'left',
                    trigger: 'hover' },
                _react2.default.createElement(
                    'div',
                    { className: 'transition-popover-body' },
                    body
                )
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(TransitionCellComponent, [{
        key: 'renderApprovalContent',
        value: function renderApprovalContent(approvalDetails) {
            return moment(approvalDetails.eventTime).format('ll') + ' - Transitioned by ' + approvalDetails.user.username;
        }
    }, {
        key: 'renderCellData',
        value: function renderCellData(transitionItem, handleTransitionSelectChange, isClosed, isEditable) {
            return transitionItem && !(isClosed && !transitionItem.disabled) && _react2.default.createElement(_xlReactComponents.XlReactDipBoolean, {
                disabled: transitionItem.disabled || !isEditable,
                metadata: checkboxFormMetadata,
                model: transitionItem.checked,
                onModelChange: function onModelChange(isSelected) {
                    return handleTransitionSelectChange(isSelected);
                }
            });
        }
    }, {
        key: 'renderCompletedTransition',
        value: function renderCompletedTransition(approvalContent) {
            return _react2.default.createElement(
                'div',
                { className: 'closed-transition-content' },
                approvalContent
            );
        }
    }, {
        key: 'renderOpenedTransition',
        value: function renderOpenedTransition(transitionItem, handleTransitionSelectChange, approvalContent, isClosed, isEditable) {
            var cellData = this.renderCellData(transitionItem, handleTransitionSelectChange, isClosed, isEditable);

            return approvalContent ? this.renderWithPopover(approvalContent, cellData) : cellData;
        }
    }, {
        key: 'renderExpandedCell',
        value: function renderExpandedCell() {
            var _props = this.props,
                isEditable = _props.isEditable,
                approvalDetails = _props.approvalDetails,
                isClosed = _props.isClosed,
                isCompleted = _props.isCompleted,
                transitionItem = _props.transitionItem,
                handleTransitionSelectChange = _props.handleTransitionSelectChange;


            var approvalContent = approvalDetails && this.renderApprovalContent(approvalDetails);

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                isCompleted ? this.renderCompletedTransition(approvalContent) : this.renderOpenedTransition(transitionItem, handleTransitionSelectChange, approvalContent, isClosed, isEditable)
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var isExpanded = this.props.isExpanded;


            return _react2.default.createElement(
                'div',
                { className: 'transition-cell-data-wrapper' },
                _react2.default.createElement(
                    'div',
                    { className: 'transition-cell-data' },
                    isExpanded && this.renderExpandedCell()
                )
            );
        }
    }]);
    return TransitionCellComponent;
}(_react.Component);

TransitionCellComponent.propTypes = {
    approvalDetails: _propTypes2.default.any,
    handleTransitionSelectChange: _propTypes2.default.func.isRequired,
    isClosed: _propTypes2.default.bool.isRequired,
    isCompleted: _propTypes2.default.bool.isRequired,
    isEditable: _propTypes2.default.bool.isRequired,
    isExpanded: _propTypes2.default.bool.isRequired,
    transitionItem: _propTypes2.default.any
};

/***/ }),

/***/ 3130:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3132:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3134:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3136:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _react2angular = __webpack_require__(202);

var _deliveryPropertiesHeader = __webpack_require__(3137);

var _deliveryPropertiesHeader2 = _interopRequireDefault(_deliveryPropertiesHeader);

var _deliveryProperties = __webpack_require__(3143);

var _deliveryProperties2 = _interopRequireDefault(_deliveryProperties);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').component('xlrDeliveryPropertiesHeader', (0, _react2angular.react2angular)(_deliveryPropertiesHeader2.default)).component('xlrDeliveryProperties', (0, _react2angular.react2angular)(_deliveryProperties2.default));

/***/ }),

/***/ 3137:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _properties = __webpack_require__(921);

var _deliveryPropertiesHeader = __webpack_require__(3141);

var _deliveryPropertiesHeader2 = _interopRequireDefault(_deliveryPropertiesHeader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryPropertiesHeaderPage = function (_Component) {
    (0, _inherits3.default)(DeliveryPropertiesHeaderPage, _Component);

    function DeliveryPropertiesHeaderPage() {
        (0, _classCallCheck3.default)(this, DeliveryPropertiesHeaderPage);
        return (0, _possibleConstructorReturn3.default)(this, (DeliveryPropertiesHeaderPage.__proto__ || (0, _getPrototypeOf2.default)(DeliveryPropertiesHeaderPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(DeliveryPropertiesHeaderPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _properties.store },
                _react2.default.createElement(_deliveryPropertiesHeader2.default, null)
            );
        }
    }]);
    return DeliveryPropertiesHeaderPage;
}(_react.Component);

exports.default = DeliveryPropertiesHeaderPage;

/***/ }),

/***/ 3138:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _properties = __webpack_require__(3139);

Object.defineProperty(exports, "delivery", {
  enumerable: true,
  get: function get() {
    return _properties.delivery;
  }
});

var _properties2 = __webpack_require__(3140);

Object.defineProperty(exports, "deliverySagas", {
  enumerable: true,
  get: function get() {
    return _properties2.deliverySagas;
  }
});

/***/ }),

/***/ 3139:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.delivery = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _properties = __webpack_require__(469);

var _deliveryProperties = __webpack_require__(622);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    folderTree: {
        key: 0,
        data: []
    },
    form: {
        key: 0,
        model: {
            id: null,
            type: _deliveryProperties.ciTypes.delivery,
            title: '',
            folder: { id: '', title: '' },
            pattern: { id: '', title: '' },
            description: '',
            plannedDuration: 0,
            startDate: new Date(),
            endDate: new Date(new Date().getTime() + 1)
        },
        pristine: true,
        valid: false,
        lastSave: 0,
        isCreateForm: null
    }
};

var delivery = exports.delivery = function delivery() {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _properties.actionTypes.RELEASE_DELIVERY_CREATE_FORM_INIT_SUCCESS:
            {
                var _action$payload = action.payload,
                    pattern = _action$payload.pattern,
                    folder = _action$payload.folder;

                return (0, _extends3.default)({}, initialState, {
                    form: (0, _extends3.default)({}, initialState.form, {
                        model: (0, _extends3.default)({}, initialState.form.model, {
                            description: pattern.description,
                            endDate: (0, _moment2.default)(initialState.form.model.startDate).add(pattern.plannedDuration || 1, pattern.plannedDuration ? 'hour' : 'month').toDate(),
                            pattern: pattern, folder: folder
                        }),
                        isCreateForm: true
                    })
                });
            }
        case _properties.actionTypes.RELEASE_DELIVERY_UPDATE_FORM_INIT_SUCCESS:
            {
                var _action$payload2 = action.payload,
                    _delivery = _action$payload2.delivery,
                    _pattern = _action$payload2.pattern,
                    _folder = _action$payload2.folder,
                    isEditable = _action$payload2.isEditable;

                return (0, _extends3.default)({}, initialState, {
                    form: (0, _extends3.default)({}, initialState.form, {
                        key: (0, _moment2.default)().valueOf(),
                        model: (0, _extends3.default)({}, _delivery, {
                            pattern: _pattern, folder: _folder,
                            startDate: new Date(_delivery.startDate),
                            endDate: new Date(_delivery.endDate)
                        }),
                        isCreateForm: false,
                        isEditable: isEditable
                    })
                });
            }
        case _properties.actionTypes.RELEASE_DELIVERY_MODEL_CHANGE:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    model: action.payload
                })
            });
        case _properties.actionTypes.RELEASE_DELIVERY_FORM_CLEAN:
            {
                return (0, _extends3.default)({}, initialState);
            }
        case _properties.actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    pristine: action.payload
                })
            });
        case _properties.actionTypes.RELEASE_DELIVERY_VALIDATION_CHANGE:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    valid: action.payload
                })
            });
        case _properties.actionTypes.RELEASE_DELIVERY_UPDATE_SUCCESS:
            {
                var _action$payload3 = action.payload,
                    _delivery2 = _action$payload3.delivery,
                    _pattern2 = _action$payload3.pattern,
                    _folder2 = _action$payload3.folder;

                return (0, _extends3.default)({}, state, {
                    form: (0, _extends3.default)({}, state.form, {
                        model: (0, _extends3.default)({}, _delivery2, {
                            pattern: _pattern2,
                            folder: _folder2,
                            startDate: new Date(_delivery2.startDate),
                            endDate: new Date(_delivery2.endDate)
                        }),
                        lastSave: new Date(),
                        // Important for resetting pristinity on form
                        key: (0, _moment2.default)().valueOf()
                    })
                });
            }
        default:
            return state;
    }
};

/***/ }),

/***/ 3140:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.goToDeliveryPatternDetails = goToDeliveryPatternDetails;
exports.goToDeliveryFolder = goToDeliveryFolder;
exports.addConfirmLeavePopup = addConfirmLeavePopup;
exports.removeConfirmLeavePopup = removeConfirmLeavePopup;
exports.deliverySagas = deliverySagas;

var _effects = __webpack_require__(54);

var _properties = __webpack_require__(469);

var _angularAccessor = __webpack_require__(111);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _index = __webpack_require__(256);

var _deliveryPatternService = __webpack_require__(274);

var _deliveryPattern = __webpack_require__(467);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(updateBreadcrumbs),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(initializeForm),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(save),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(cancel),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(discardChanges),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(goToDetails),
    _marked7 = /*#__PURE__*/_regenerator2.default.mark(goToDeliveryPatternDetails),
    _marked8 = /*#__PURE__*/_regenerator2.default.mark(goToDeliveryFolder),
    _marked9 = /*#__PURE__*/_regenerator2.default.mark(addConfirmLeavePopup),
    _marked10 = /*#__PURE__*/_regenerator2.default.mark(removeConfirmLeavePopup),
    _marked11 = /*#__PURE__*/_regenerator2.default.mark(deliverySagas);

var getFormModel = function getFormModel(state) {
    return state.delivery.form.model;
};

var isEditable = function isEditable(delivery) {
    return (0, _angularAccessor2.default)('Authenticator').hasPermission(_deliveryPattern.DELIVERY_EDIT_PERMISSION, delivery.$metadata) && delivery.status !== 'COMPLETED';
};

function updateBreadcrumbs(checkUrl, delivery) {
    var page;
    return _regenerator2.default.wrap(function updateBreadcrumbs$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'Page');

                case 2:
                    page = _context.sent;

                    if (page.isOnPage(checkUrl)) {
                        page.setFolderEntityOpened(delivery.folderId, delivery);
                    }

                case 4:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this);
}

function initializeForm(action) {
    var _action$payload, delivery, patternId, folder, pattern, _pattern, patternFolder;

    return _regenerator2.default.wrap(function initializeForm$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _action$payload = action.payload, delivery = _action$payload.delivery, patternId = _action$payload.patternId;
                    folder = action.payload.folder;

                    if (!(delivery && delivery.id)) {
                        _context2.next = 10;
                        break;
                    }

                    pattern = { id: null, title: null, hasViewAccess: false };

                    if (delivery.originPatternId && delivery.$metadata.details && delivery.$metadata.details.pattern) {
                        pattern.id = delivery.originPatternId;
                        pattern.title = delivery.$metadata.details.pattern;
                        pattern.hasViewAccess = delivery.$metadata.details.hasPatternViewAccess;
                    }
                    if (delivery.folderId && delivery.$metadata.details && delivery.$metadata.details.folder) {
                        if (!folder) {
                            folder = { id: null, title: null, hasViewAccess: false };
                        }
                        folder.id = folder.id || delivery.folderId;
                        folder.title = folder.title || delivery.$metadata.details.folder;
                        folder.hasViewAccess = delivery.$metadata.details.hasFolderViewAccess;
                    }
                    _context2.next = 8;
                    return (0, _effects.put)((0, _properties.initializeUpdateFormSuccess)(delivery, pattern, folder, isEditable(delivery)));

                case 8:
                    _context2.next = 17;
                    break;

                case 10:
                    if (!patternId) {
                        _context2.next = 17;
                        break;
                    }

                    _context2.next = 13;
                    return (0, _effects.call)(_deliveryPatternService.fetchDeliveryPattern, patternId);

                case 13:
                    _pattern = _context2.sent;
                    patternFolder = {
                        id: _pattern.folderId,
                        title: _pattern.$metadata.details.folder,
                        hasViewAccess: _pattern.$metadata.details.hasFolderViewAccess
                    };
                    _context2.next = 17;
                    return (0, _effects.put)((0, _properties.initializeCreateFormSuccess)(_pattern, patternFolder));

                case 17:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function save() {
    var deliveryModel, deliveryForm, $location, urlBeforeUpdate, updatedDeliveryResponse, createdDeliveryResponse;
    return _regenerator2.default.wrap(function save$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.prev = 0;
                    _context3.next = 3;
                    return (0, _effects.select)(getFormModel);

                case 3:
                    deliveryModel = _context3.sent;
                    deliveryForm = {
                        id: deliveryModel.id,
                        type: deliveryModel.type,
                        title: deliveryModel.title,
                        folderId: deliveryModel.folder.id,
                        description: deliveryModel.description,
                        startDate: deliveryModel.startDate.toISOString(),
                        endDate: deliveryModel.endDate.toISOString(),
                        plannedDuration: deliveryModel.plannedDuration,
                        releaseIds: deliveryModel.releaseIds
                    };

                    if (!deliveryForm.id) {
                        _context3.next = 19;
                        break;
                    }

                    _context3.next = 8;
                    return (0, _effects.call)(_angularAccessor2.default, '$location');

                case 8:
                    $location = _context3.sent;
                    urlBeforeUpdate = $location.path();
                    _context3.next = 12;
                    return (0, _effects.call)(_index.updateDelivery, deliveryForm);

                case 12:
                    updatedDeliveryResponse = _context3.sent;
                    _context3.next = 15;
                    return (0, _effects.call)(updateBreadcrumbs, urlBeforeUpdate, updatedDeliveryResponse.data);

                case 15:
                    _context3.next = 17;
                    return (0, _effects.put)((0, _properties.deliveryUpdateSuccess)(updatedDeliveryResponse.data, deliveryModel.pattern, deliveryModel.folder));

                case 17:
                    _context3.next = 24;
                    break;

                case 19:
                    _context3.next = 21;
                    return (0, _effects.call)(_index.createDeliveryFromPattern, deliveryModel.pattern.id, deliveryForm);

                case 21:
                    createdDeliveryResponse = _context3.sent;
                    _context3.next = 24;
                    return (0, _effects.put)((0, _properties.deliveryCreateSuccess)(createdDeliveryResponse.data));

                case 24:
                    _context3.next = 29;
                    break;

                case 26:
                    _context3.prev = 26;
                    _context3.t0 = _context3['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Something went wrong while creating or updating release delivery...', _context3.t0);
                    /* eslint-enable */

                case 29:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[0, 26]]);
}

function cancel() {
    var $window;
    return _regenerator2.default.wrap(function cancel$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    // yield call(removeConfirmLeavePopup);
                    $window = (0, _angularAccessor2.default)('$window');

                    $window.history.back();
                    _context4.next = 4;
                    return (0, _effects.put)((0, _properties.cleanFormFields)());

                case 4:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

function discardChanges(action) {
    var deliveryModel, deliveryResponse;
    return _regenerator2.default.wrap(function discardChanges$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.put)((0, _properties.changePristine)(true));

                case 2:
                    _context5.next = 4;
                    return (0, _effects.select)(getFormModel);

                case 4:
                    deliveryModel = _context5.sent;
                    _context5.next = 7;
                    return (0, _effects.call)(_index.getDelivery, deliveryModel.id);

                case 7:
                    deliveryResponse = _context5.sent;
                    _context5.next = 10;
                    return (0, _effects.put)((0, _properties.initializeUpdateFormSuccess)(deliveryResponse.data, deliveryModel.pattern, deliveryModel.folder, isEditable(deliveryResponse.data)));

                case 10:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

function goToDetails(action) {
    var $location, $rootScope;
    return _regenerator2.default.wrap(function goToDetails$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    $location = (0, _angularAccessor2.default)('$location');
                    $rootScope = (0, _angularAccessor2.default)('$rootScope');

                    $location.url('/deliveries/' + action.payload.id);
                    $rootScope.$digest();

                case 4:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

function goToDeliveryPatternDetails(action) {
    var $location, $rootScope;
    return _regenerator2.default.wrap(function goToDeliveryPatternDetails$(_context7) {
        while (1) {
            switch (_context7.prev = _context7.next) {
                case 0:
                    $location = (0, _angularAccessor2.default)('$location');
                    $rootScope = (0, _angularAccessor2.default)('$rootScope');

                    $location.url('/delivery-patterns/' + action.payload);
                    $rootScope.$digest();

                case 4:
                case 'end':
                    return _context7.stop();
            }
        }
    }, _marked7, this);
}

function goToDeliveryFolder(action) {
    var $location, $rootScope;
    return _regenerator2.default.wrap(function goToDeliveryFolder$(_context8) {
        while (1) {
            switch (_context8.prev = _context8.next) {
                case 0:
                    $location = (0, _angularAccessor2.default)('$location');
                    $rootScope = (0, _angularAccessor2.default)('$rootScope');

                    $location.url('/folders/' + action.payload + '/deliveries');
                    $rootScope.$digest();

                case 4:
                case 'end':
                    return _context8.stop();
            }
        }
    }, _marked8, this);
}

// TODO: don't use temporary
function addConfirmLeavePopup() {
    var confirmLeaveService;
    return _regenerator2.default.wrap(function addConfirmLeavePopup$(_context9) {
        while (1) {
            switch (_context9.prev = _context9.next) {
                case 0:
                    _context9.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'ConfirmLeaveService');

                case 2:
                    confirmLeaveService = _context9.sent;
                    _context9.next = 5;
                    return (0, _effects.call)(confirmLeaveService.requireConfirmation.bind(confirmLeaveService));

                case 5:
                case 'end':
                    return _context9.stop();
            }
        }
    }, _marked9, this);
}

// TODO: don't use temporary
function removeConfirmLeavePopup() {
    var confirmLeaveService;
    return _regenerator2.default.wrap(function removeConfirmLeavePopup$(_context10) {
        while (1) {
            switch (_context10.prev = _context10.next) {
                case 0:
                    _context10.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'ConfirmLeaveService');

                case 2:
                    confirmLeaveService = _context10.sent;
                    _context10.next = 5;
                    return (0, _effects.call)(confirmLeaveService.disableConfirmation.bind(confirmLeaveService));

                case 5:
                case 'end':
                    return _context10.stop();
            }
        }
    }, _marked10, this);
}

function deliverySagas() {
    return _regenerator2.default.wrap(function deliverySagas$(_context11) {
        while (1) {
            switch (_context11.prev = _context11.next) {
                case 0:
                    _context11.next = 2;
                    return (0, _effects.all)([(0, _effects.takeEvery)(_properties.actionTypes.RELEASE_DELIVERY_FORM_INIT_REQUEST, initializeForm), (0, _effects.takeEvery)(_properties.actionTypes.RELEASE_DELIVERY_CREATE_OR_UPDATE_REQUEST, save), (0, _effects.takeEvery)(_properties.actionTypes.RELEASE_DELIVERY_CREATE_CANCEL_REQUEST, cancel), (0, _effects.takeEvery)(_properties.actionTypes.RELEASE_DELIVERY_CREATE_DISCARD_CHANGES_REQUEST, discardChanges), (0, _effects.takeEvery)(_properties.actionTypes.RELEASE_DELIVERY_CREATE_SUCCESS, goToDetails),
                    // takeEvery(actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE, addConfirmLeavePopup),
                    (0, _effects.takeEvery)(_properties.actionTypes.RELEASE_DELIVERY_GO_TO_PATTERN, goToDeliveryPatternDetails), (0, _effects.takeEvery)(_properties.actionTypes.RELEASE_DELIVERY_GO_TO_FOLDER, goToDeliveryFolder)]);

                case 2:
                case 'end':
                    return _context11.stop();
            }
        }
    }, _marked11, this);
}

/***/ }),

/***/ 3141:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(43);

var _properties = __webpack_require__(469);

var _deliveryPropertiesHeader = __webpack_require__(3142);

var _deliveryPropertiesHeader2 = _interopRequireDefault(_deliveryPropertiesHeader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    var delivery = state.delivery;

    return {
        discardChangesDisabled: delivery.form.pristine,
        isCreateForm: delivery.form.isCreateForm,
        lastSave: delivery.form.lastSave,
        saveDisabled: delivery.form.pristine || !delivery.form.valid
    };
};

var mapDispatchToProps = function mapDispatchToProps(dispatch) {
    return {
        onCancelDelivery: function onCancelDelivery() {
            return dispatch((0, _properties.cancelDelivery)());
        },
        onDiscardDeliveryChanges: function onDiscardDeliveryChanges() {
            return dispatch((0, _properties.onDiscardDeliveryChanges)());
        },
        onSaveDelivery: function onSaveDelivery() {
            return dispatch((0, _properties.createOrUpdateDelivery)());
        }
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_deliveryPropertiesHeader2.default);

/***/ }),

/***/ 3142:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryPropertiesHeader = function (_Component) {
    (0, _inherits3.default)(DeliveryPropertiesHeader, _Component);

    function DeliveryPropertiesHeader() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, DeliveryPropertiesHeader);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = DeliveryPropertiesHeader.__proto__ || (0, _getPrototypeOf2.default)(DeliveryPropertiesHeader)).call.apply(_ref, [this].concat(args))), _this), _this.handleSave = function () {
            var onSaveDelivery = _this.props.onSaveDelivery;

            onSaveDelivery();
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(DeliveryPropertiesHeader, [{
        key: 'renderCreateFormButtons',
        value: function renderCreateFormButtons() {
            var _props = this.props,
                onCancelDelivery = _props.onCancelDelivery,
                saveDisabled = _props.saveDisabled;


            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(
                    'button',
                    { className: 'button cancel', onClick: onCancelDelivery },
                    'Cancel'
                ),
                _react2.default.createElement(
                    'button',
                    { className: 'button primary', disabled: saveDisabled, onClick: this.handleSave },
                    'Create'
                )
            );
        }
    }, {
        key: 'renderEditFormButtons',
        value: function renderEditFormButtons() {
            var _props2 = this.props,
                discardChangesDisabled = _props2.discardChangesDisabled,
                onDiscardDeliveryChanges = _props2.onDiscardDeliveryChanges,
                saveDisabled = _props2.saveDisabled,
                lastSave = _props2.lastSave;


            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                lastSave !== 0 && _react2.default.createElement(
                    'span',
                    { className: 'last-save-date' },
                    'Last saved on ',
                    moment(lastSave).format('lll')
                ),
                _react2.default.createElement(
                    'button',
                    { className: 'button cancel', disabled: discardChangesDisabled,
                        onClick: onDiscardDeliveryChanges },
                    'Discard changes'
                ),
                _react2.default.createElement(
                    'button',
                    { className: 'button primary', disabled: saveDisabled, onClick: this.handleSave },
                    'Save'
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var isCreateForm = this.props.isCreateForm;


            return _react2.default.createElement(
                'div',
                null,
                isCreateForm && this.renderCreateFormButtons(),
                isCreateForm === false && this.renderEditFormButtons()
            );
        }
    }]);
    return DeliveryPropertiesHeader;
}(_react.Component);

DeliveryPropertiesHeader.propTypes = {
    discardChangesDisabled: _propTypes2.default.bool.isRequired,
    isCreateForm: _propTypes2.default.bool,
    lastSave: _propTypes2.default.any,
    onCancelDelivery: _propTypes2.default.func.isRequired,
    onDiscardDeliveryChanges: _propTypes2.default.func.isRequired,
    onSaveDelivery: _propTypes2.default.func.isRequired,
    saveDisabled: _propTypes2.default.bool.isRequired
};
exports.default = DeliveryPropertiesHeader;

/***/ }),

/***/ 3143:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _properties = __webpack_require__(921);

var _deliveryProperties = __webpack_require__(3144);

var _deliveryProperties2 = _interopRequireDefault(_deliveryProperties);

var _deliveryProperties3 = __webpack_require__(922);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryPropertiesPage = function (_Component) {
    (0, _inherits3.default)(DeliveryPropertiesPage, _Component);

    function DeliveryPropertiesPage() {
        (0, _classCallCheck3.default)(this, DeliveryPropertiesPage);
        return (0, _possibleConstructorReturn3.default)(this, (DeliveryPropertiesPage.__proto__ || (0, _getPrototypeOf2.default)(DeliveryPropertiesPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(DeliveryPropertiesPage, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                delivery = _props.delivery,
                folder = _props.folder,
                patternId = _props.patternId;


            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _properties.store },
                _react2.default.createElement(_deliveryProperties2.default, { delivery: delivery, folder: folder, patternId: patternId })
            );
        }
    }]);
    return DeliveryPropertiesPage;
}(_react.Component);

DeliveryPropertiesPage.propTypes = {
    delivery: _deliveryProperties3.Delivery,
    folder: _deliveryProperties3.Folder,
    patternId: _propTypes2.default.string
};
exports.default = DeliveryPropertiesPage;

/***/ }),

/***/ 3144:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(43);

var _properties = __webpack_require__(469);

var _deliveryProperties = __webpack_require__(3145);

var _deliveryProperties2 = _interopRequireDefault(_deliveryProperties);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    var delivery = state.delivery;


    return {
        isEditable: delivery.form.isEditable,
        model: delivery.form.model,
        propertiesFormKey: delivery.form.key,
        valid: delivery.form.valid
    };
};

var mapDispatchToProps = function mapDispatchToProps(dispatch) {
    return {
        initDeliveryForm: function initDeliveryForm(delivery, patternId, folder) {
            return dispatch((0, _properties.initDeliveryForm)(delivery, patternId, folder));
        },
        cleanForm: function cleanForm() {
            return dispatch((0, _properties.cleanFormFields)());
        },
        goToFolder: function goToFolder(folderId) {
            return dispatch((0, _properties.goToFolder)(folderId));
        },
        goToDeliveryPattern: function goToDeliveryPattern(patternId) {
            return dispatch((0, _properties.goToDeliveryPatternDetails)(patternId));
        },
        onFormChange: function onFormChange(model) {
            return dispatch((0, _properties.changeModel)(model));
        },
        onPristineChange: function onPristineChange(pristine) {
            return dispatch((0, _properties.changePristine)(pristine));
        },
        onValidationChange: function onValidationChange(valid) {
            return dispatch((0, _properties.changeValidation)(valid));
        },
        onSaveDelivery: function onSaveDelivery() {
            return dispatch((0, _properties.createOrUpdateDelivery)());
        }
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_deliveryProperties2.default);

/***/ }),

/***/ 3145:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(62);

var _xlReactComponents = __webpack_require__(47);

var _validators = __webpack_require__(123);

var _widgets = __webpack_require__(914);

var _deliveryProperties = __webpack_require__(922);

__webpack_require__(3147);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var nameFormMetadata = {
    label: 'Delivery name',
    placeholder: 'Add...',
    description: 'Name of the delivery',
    required: true
};
var patternFormMetadata = {
    label: 'Created from pattern'
};
var folderFormMetadata = {
    label: 'Folder'
};
var descriptionFormMetadata = {
    label: 'Description',
    placeholder: 'Set description...',
    description: 'Description of the delivery',
    size: 'MEDIUM'
};
var startDateFormMetadata = {
    label: 'Start date',
    placeholder: '',
    description: 'Date and time when you want the delivery to start'
};
var endDateFormMetadata = {
    label: 'End date',
    placeholder: '',
    description: 'Date and time when you want the delivery to end'
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var DeliveryPropertiesComponent = function (_Component) {
    (0, _inherits3.default)(DeliveryPropertiesComponent, _Component);

    function DeliveryPropertiesComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, DeliveryPropertiesComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = DeliveryPropertiesComponent.__proto__ || (0, _getPrototypeOf2.default)(DeliveryPropertiesComponent)).call.apply(_ref, [this].concat(args))), _this), _this.isDescriptionPristine = true, _this.isNamePristine = true, _this.isStartDatePristine = true, _this.isStartTimePristine = true, _this.isEndDatePristine = true, _this.isEndTimePristine = true, _this.isNameValid = false, _this.isDescriptionValid = false, _this.isStartDateTimeValid = false, _this.isEndDateTimeValid = false, _this.onRegister = function (componentApi) {
            componentApi.focus();
        }, _this._handleKeyDown = function (e) {
            var valid = _this.props.valid;

            if (e.key === 'Enter' && valid) {
                _this.props.onSaveDelivery();
            }
        }, _this.onNamePristine = function (pristine) {
            _this.isNamePristine = pristine;
            _this.props.onPristineChange(_this.isDeliveryFormPristine);
        }, _this.onDescPristine = function (pristine) {
            _this.isDescriptionPristine = pristine;
            _this.props.onPristineChange(_this.isDeliveryFormPristine);
        }, _this.onStartDatePristineChange = function (pristine) {
            _this.isStartDatePristine = pristine;
            _this.props.onPristineChange(_this.isDeliveryFormPristine);
        }, _this.onStartTimePristineChange = function (pristine) {
            _this.isStartTimePristine = pristine;
            _this.props.onPristineChange(_this.isDeliveryFormPristine);
        }, _this.onEndDatePristineChange = function (pristine) {
            _this.isEndDatePristine = pristine;
            _this.props.onPristineChange(_this.isDeliveryFormPristine);
        }, _this.onEndTimePristineChange = function (pristine) {
            _this.isEndTimePristine = pristine;
            _this.props.onPristineChange(_this.isDeliveryFormPristine);
        }, _this.onNameValidityChange = function (valid) {
            _this.isNameValid = valid;
            _this.props.onValidationChange(_this.isDeliveryFormValid);
        }, _this.onDescriptionValidityChange = function (valid) {
            _this.isDescriptionValid = valid;
            _this.props.onValidationChange(_this.isDeliveryFormValid);
        }, _this.onStartDateTimeValidityChange = function (valid) {
            _this.isStartDateTimeValid = valid;
            _this.props.onValidationChange(_this.isDeliveryFormValid);
        }, _this.onEndDateTimeValidityChange = function (valid) {
            _this.isEndDateTimeValid = valid;
            _this.props.onValidationChange(_this.isDeliveryFormValid);
        }, _this.onNameChange = function (title) {
            var _this$props = _this.props,
                model = _this$props.model,
                onFormChange = _this$props.onFormChange;

            if (title !== model.title) {
                onFormChange((0, _extends3.default)({}, model, {
                    title: title
                }));
            }
        }, _this.onDescriptionChange = function (description) {
            var _this$props2 = _this.props,
                model = _this$props2.model,
                onFormChange = _this$props2.onFormChange;

            if (description !== model.description) {
                onFormChange((0, _extends3.default)({}, model, {
                    description: description
                }));
            }
        }, _this.onStartDatetimeChange = function (startDate) {
            var _this$props3 = _this.props,
                model = _this$props3.model,
                onFormChange = _this$props3.onFormChange;

            if (startDate !== model.startDate) {
                onFormChange((0, _extends3.default)({}, model, {
                    startDate: startDate
                }));
            }
        }, _this.onEndDatetimeChange = function (endDate) {
            var _this$props4 = _this.props,
                model = _this$props4.model,
                onFormChange = _this$props4.onFormChange;

            if (endDate !== model.endDate) {
                onFormChange((0, _extends3.default)({}, model, {
                    endDate: endDate
                }));
            }
        }, _this.goToDeliveryPattern = function () {
            var _this$props5 = _this.props,
                model = _this$props5.model,
                goToDeliveryPattern = _this$props5.goToDeliveryPattern;

            goToDeliveryPattern(model.pattern.id);
        }, _this.goToFolder = function () {
            var _this$props6 = _this.props,
                model = _this$props6.model,
                goToFolder = _this$props6.goToFolder;

            goToFolder(model.folder.id);
        }, _this.renderPattern = function (isNew, pattern) {
            return isNew || pattern.hasViewAccess ? _react2.default.createElement(
                'a',
                { className: 'details-link', onClick: _this.goToDeliveryPattern },
                pattern.title
            ) : _react2.default.createElement(
                'span',
                null,
                pattern.title
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(DeliveryPropertiesComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _props = this.props,
                delivery = _props.delivery,
                folder = _props.folder,
                initDeliveryForm = _props.initDeliveryForm,
                patternId = _props.patternId;

            initDeliveryForm(delivery, patternId, folder);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            var cleanForm = this.props.cleanForm;

            cleanForm();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                model = _props2.model,
                propertiesFormKey = _props2.propertiesFormKey,
                delivery = _props2.delivery;
            // eslint-disable-next-line angular/definedundefined

            var isEditable = this.props.isEditable !== undefined ? this.props.isEditable : true;
            /* eslint-enable angular/definedundefined */
            var isNew = (0, _lodash.isEmpty)(model.id);

            return _react2.default.createElement(
                'div',
                { className: 'row', id: 'delivery-properties', key: propertiesFormKey },
                _react2.default.createElement(
                    'div',
                    { className: 'col-sm-7' },
                    _react2.default.createElement(
                        'fieldset',
                        null,
                        _react2.default.createElement(
                            'legend',
                            null,
                            'Properties ',
                            !isNew && _react2.default.createElement(
                                'span',
                                null,
                                'for ',
                                delivery.title
                            )
                        ),
                        _react2.default.createElement(
                            'div',
                            { onKeyDown: this._handleKeyDown },
                            _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                                disabled: !isEditable,
                                metadata: nameFormMetadata,
                                model: model.title,
                                onModelChange: this.onNameChange,
                                onPristinityChange: this.onNamePristine,
                                onValidityChange: this.onNameValidityChange,
                                register: this.onRegister,
                                validators: [maxLengthValidator(nameFormMetadata.label, 255), (0, _validators.reservedCharactersValidator)(nameFormMetadata.label)]
                            })
                        ),
                        _react2.default.createElement(
                            'div',
                            { className: 'xl-react-components' },
                            _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: patternFormMetadata }),
                            model.pattern && model.pattern.id ? this.renderPattern(isNew, model.pattern) : _react2.default.createElement(
                                'span',
                                null,
                                '[Pattern has been deleted]'
                            )
                        ),
                        _react2.default.createElement(
                            'div',
                            { className: 'xl-react-components' },
                            _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: folderFormMetadata }),
                            model.folder.hasViewAccess ? _react2.default.createElement(
                                'a',
                                { className: 'details-link', 'data-test-id': 'folderId', onClick: this.goToFolder },
                                model.folder.title
                            ) : _react2.default.createElement(
                                'span',
                                { 'data-test-id': 'folderId' },
                                model.folder.title
                            )
                        ),
                        _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                            disabled: !isEditable,
                            metadata: descriptionFormMetadata,
                            model: model.description,
                            onModelChange: this.onDescriptionChange,
                            onPristinityChange: this.onDescPristine,
                            onValidityChange: this.onDescriptionValidityChange,
                            validators: [maxLengthValidator(descriptionFormMetadata.label, 1024)]
                        })
                    )
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'col-sm-5' },
                    _react2.default.createElement(
                        'fieldset',
                        null,
                        _react2.default.createElement(
                            'legend',
                            null,
                            'Delivery details'
                        ),
                        _react2.default.createElement(_widgets.WidgetDateTime, {
                            disabled: !isEditable,
                            metadata: startDateFormMetadata,
                            model: model.startDate,
                            onDatePristinityChange: this.onStartDatePristineChange,
                            onModelChange: this.onStartDatetimeChange,
                            onTimePristinityChange: this.onStartTimePristineChange,
                            onValidityChange: this.onStartDateTimeValidityChange }),
                        _react2.default.createElement(_widgets.WidgetDateTime, {
                            disabled: !isEditable,
                            metadata: endDateFormMetadata,
                            model: model.endDate,
                            onDatePristinityChange: this.onEndDatePristineChange,
                            onModelChange: this.onEndDatetimeChange,
                            onTimePristinityChange: this.onEndTimePristineChange,
                            onValidityChange: this.onEndDateTimeValidityChange })
                    )
                )
            );
        }
    }, {
        key: 'isDeliveryFormPristine',
        get: function get() {
            return this.isDescriptionPristine && this.isNamePristine && this.isStartDatePristine && this.isStartTimePristine && this.isEndDatePristine && this.isEndTimePristine;
        }
    }, {
        key: 'isDeliveryFormValid',
        get: function get() {
            return this.isNameValid && this.isDescriptionValid && this.isStartDateTimeValid && this.isEndDateTimeValid;
        }
    }]);
    return DeliveryPropertiesComponent;
}(_react.Component);

DeliveryPropertiesComponent.propTypes = {
    cleanForm: _propTypes2.default.func,
    delivery: _deliveryProperties.Delivery,
    folder: _deliveryProperties.Folder,
    goToDeliveryPattern: _propTypes2.default.func,
    goToFolder: _propTypes2.default.func,
    initDeliveryForm: _propTypes2.default.func,
    isEditable: _propTypes2.default.bool,
    lastSave: _propTypes2.default.any,
    model: _deliveryProperties.Delivery,
    onFormChange: _propTypes2.default.func.isRequired,
    onPristineChange: _propTypes2.default.func.isRequired,
    onSaveDelivery: _propTypes2.default.func.isRequired,
    onValidationChange: _propTypes2.default.func.isRequired,
    patternId: _propTypes2.default.string,
    propertiesFormKey: _propTypes2.default.number.isRequired,
    valid: _propTypes2.default.bool.isRequired
};
exports.default = DeliveryPropertiesComponent;

/***/ }),

/***/ 3147:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3149:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _components = __webpack_require__(3150);

var _timelineTooltipDirective = __webpack_require__(3154);

var _timelineTooltipDirective2 = _interopRequireDefault(_timelineTooltipDirective);

var _deliveryTimelinePage = __webpack_require__(3157);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = angular.module('xlrelease.deliveriesDetails', ['gantt', 'gantt.table', 'gantt.bounds', 'gantt.progress', 'gantt.overlap', 'gantt.groups']).directive('xlrDeliveryTimelineTooltip', _timelineTooltipDirective2.default).component('xlrDeliveryTimeline', _components.timelineComponent).component('xlrDeliveryTimelinePage', _deliveryTimelinePage.deliveryTimelinePage);

/***/ }),

/***/ 3150:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.timelineComponent = undefined;

var _timelineController = __webpack_require__(3151);

var _timelineController2 = _interopRequireDefault(_timelineController);

var _timelineTpl = __webpack_require__(3153);

var _timelineTpl2 = _interopRequireDefault(_timelineTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var timelineComponent = exports.timelineComponent = {
    bindings: {
        loading: '<',
        delivery: '<',
        onRefresh: '&'
    },
    controller: _timelineController2.default,
    template: _timelineTpl2.default
};

/***/ }),

/***/ 3151:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _timelineRowName = __webpack_require__(3152);

var _timelineRowName2 = _interopRequireDefault(_timelineRowName);

var _deliveriesTimelineActions = __webpack_require__(360);

var _services = __webpack_require__(256);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var phaseContentTemplate = '\n    <div xlr-delivery-timeline-tooltip\n         class="fgt-timeline-task-content">\n         {{::task.model.name}}\n     </div>\n';

var deliveryContentTemplate = '\n    <div xlr-delivery-timeline-tooltip>\n         {{::task.model.name}}\n     </div>\n';

var TimelineController = function () {
    function TimelineController($ngRedux, $scope, ViewStorage, Ids, DateService, Authenticator) {
        (0, _classCallCheck3.default)(this, TimelineController);

        this._scope = $scope;
        this._viewStorage = ViewStorage;
        this._Ids = Ids;
        this._DateService = DateService;
        this._Authenticator = Authenticator;

        this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.bind(this))(this);
    }

    (0, _createClass3.default)(TimelineController, [{
        key: '$onInit',
        value: function $onInit() {
            this.initGanttTableOptions();
            this.currentDate = new Date();
            // For performance reasons, when a lot of tasks are loaded in the gantt chart,
            // tasks outside of the visible scrollable viewport are removed from the DOM.
            this.taskLimitThreshold = 30;
            this.registerGanttApi = this.registerGanttApi.bind(this);
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this.resetToInitialState();
            this._unsubscribe();
        }
    }, {
        key: 'initGanttTableOptions',
        value: function initGanttTableOptions() {
            this.tableColumns = ['row.model.id'];
            this.tableHeaders = { 'row.model.id': 'Name' };
            this.tableContents = { 'row.model.id': _timelineRowName2.default };
            this.tableFormatters = { 'row.model.id': this.getRowModel.bind(this) };
        }
    }, {
        key: 'getRowModel',
        value: function getRowModel(value, column, row) {
            var isDelivery = _.get(row, 'model.tasks[0].data.isDelivery');
            if (isDelivery) {
                return {
                    title: row.model.name,
                    isDelivery: isDelivery
                };
            }

            var release = _.get(row, 'model.data.release');
            return {
                title: release.title,
                releaseEditorURL: this.getReleaseEditorURL(release),
                isDelivery: isDelivery,
                isUpdatable: this.isUpdatable.bind(this)
            };
        }
    }, {
        key: 'getReleaseEditorURL',
        value: function getReleaseEditorURL(release) {
            var releaseId = this._Ids.toInternalId(release.id);
            return '#' + this._viewStorage.getView(releaseId, '/releases/' + releaseId);
        }
    }, {
        key: '_mapDispatchToThis',
        value: function _mapDispatchToThis(dispatch) {
            return {
                fetchDelivery: function fetchDelivery() {
                    dispatch((0, _deliveriesTimelineActions.fetchDelivery)(this.delivery.id));
                },
                resetToInitialState: function resetToInitialState() {
                    dispatch((0, _deliveriesTimelineActions.resetToInitialState)());
                }
            };
        }
    }, {
        key: '_mapStateToThis',
        value: function _mapStateToThis(state) {
            var reducer = state.deliveriesTimeline;
            var newGanttData = this.getGanttData(reducer.delivery, reducer.filteredReleases);
            var ganttData = _.isEqual(reducer.filteredReleasesDateStamp, this.filteredReleasesDateStamp) ? this.ganttData : newGanttData;
            return (0, _extends3.default)({
                delivery: reducer.delivery,
                loading: reducer.loading,
                hasReleases: !!reducer.filteredReleases.length,
                filters: reducer.filters,
                filteredReleasesDateStamp: reducer.filteredReleasesDateStamp
            }, reducer.zoomLevel, ganttData);
        }
    }, {
        key: 'registerGanttApi',
        value: function registerGanttApi(api) {
            api.directives.on.new(this._scope, function (dName, dScope, dElement) {
                switch (dName) {
                    case 'ganttTask':
                        var phaseColor = _.get(dScope, 'task.model.data.phase.color');
                        if (phaseColor) {
                            dElement.css({ 'border-color': phaseColor });
                        }
                        break;
                }
            });
        }
    }, {
        key: 'isUpdatable',
        value: function isUpdatable() {
            return (0, _services.isDeliveryUpdatable)(this.delivery) && this._Authenticator.hasDeliveryEditPermission(this.delivery);
        }
    }, {
        key: 'getPhaseStartDate',
        value: function getPhaseStartDate(phase) {
            return phase.plannedStartDate;
        }
    }, {
        key: 'getPhaseEndDate',
        value: function getPhaseEndDate(phase) {
            return phase.plannedEndDate;
        }
    }, {
        key: 'getGanttData',
        value: function getGanttData(delivery, releases) {
            var _this = this;

            if (!delivery || !releases) {
                return {
                    ganttData: {
                        data: [],
                        timespans: []
                    }
                };
            }
            var height = 36;
            var deliveryTimespan = {
                from: moment(delivery.startDate).toDate(),
                to: moment(delivery.endDate).toDate()
            };
            var data = _.reduce(releases, function (rows, release) {
                rows.push({
                    name: release.title,
                    height: height,
                    sortable: false,
                    classes: 'gantt-row-milestone',
                    tasks: _.chain(release.phases).filter(function (phase) {
                        return _this.getPhaseStartDate(phase) && _this.getPhaseEndDate(phase);
                    }).map(function (phase) {
                        var from = moment(_this.getPhaseStartDate(phase)).toDate();
                        var to = moment(_this.getPhaseEndDate(phase)).toDate();
                        var classes = ['fgt-timeline-task-release-phase'];
                        if (_this._DateService.isOverdue(to)) {
                            classes.push('fgt-timeline-task-incomplete');
                        }
                        return {
                            name: phase.title,
                            from: from,
                            to: to,
                            classes: classes,
                            data: {
                                phase: phase,
                                release: release,
                                $ctrl: _this
                            },
                            content: phaseContentTemplate
                        };
                    }).value(),
                    data: {
                        release: release,
                        isDelivery: false
                    }
                });
                return rows;
            }, [{
                name: delivery.title,
                height: height,
                classes: ['fgt-timeline-task-delivery'],
                tasks: [(0, _extends3.default)({
                    name: delivery.title,
                    content: deliveryContentTemplate,
                    data: {
                        release: { status: 'PLANNED' },
                        isDelivery: true
                    }
                }, deliveryTimespan)]
            }]);

            return {
                ganttData: {
                    data: data,
                    timespans: data.length > 1 ? [deliveryTimespan] : []
                }
            };
        }
    }, {
        key: 'getDateDiff',
        value: function getDateDiff(actualDate, expectedDate) {
            var duration = moment.duration(moment(actualDate).diff(moment(expectedDate)));
            if (duration.asSeconds() <= 0) {
                return '';
            }

            if (duration.asMinutes() < 1) {
                return '(1m overdue)';
            }
            return '(' + duration.format('d[d] h[h] m[m]') + ' overdue)';
        }
    }, {
        key: 'isDateOverdue',
        value: function isDateOverdue(actualDate, expectedDate) {
            return expectedDate && moment(actualDate).diff(moment(expectedDate)) > 0;
        }
    }, {
        key: 'hasReleasesFound',
        value: function hasReleasesFound() {
            return this.hasReleases && !this.loading;
        }
    }]);
    return TimelineController;
}();

TimelineController.$inject = ['$ngRedux', '$scope', 'ViewStorage', 'Ids', 'DateService', 'Authenticator'];
exports.default = TimelineController;

/***/ }),

/***/ 3152:
/***/ (function(module, exports) {

module.exports = "<div class=\"timeline-row-name\" ng-init=\"model = getValue()\">\n    <span class=\"timeline-row-name-release\" ng-if=\"!model.isDelivery\">\n        <a class=\"release-title\" ng-href=\"{{model.releaseEditorURL}}\">{{::model.title}}</a>\n    </span>\n    <span class=\"timeline-row-name-delivery\" ng-if=\"model.isDelivery\">\n        <i class=\"xl-icon group-icon\"></i>\n        <span class=\"delivery-title\">{{::model.title}}</span>\n    </span>\n</div>\n"

/***/ }),

/***/ 3153:
/***/ (function(module, exports) {

module.exports = "<div class=\"content-under-header fgt-timeline\">\n    <div class=\"row\">\n        <div gantt\n             data=\"$ctrl.ganttData.data\"\n             timespans=\"$ctrl.ganttData.timespans\"\n             current-date-value=\"$ctrl.currentDate\"\n             column-width=\"$ctrl.columnWidth\"\n             view-scale=\"$ctrl.viewScale\"\n             headers=\"$ctrl.headers\"\n             headers-scales=\"$ctrl.headersScales\"\n             headers-formats=\"$ctrl.headersFormats\"\n\n             allow-side-resizing=\"false\"\n             api=\"::$ctrl.registerGanttApi\"\n             current-date=\"'line'\"\n             expand-to-fit=\"true\"\n             taskLimitThreshold=\"::$ctrl.taskLimitThreshold\"\n             max-height=\"'100%'\">\n            <gantt-table\n                    columns=\"::$ctrl.tableColumns\"\n                    headers=\"::$ctrl.tableHeaders\"\n                    contents=\"::$ctrl.tableContents\"\n                    formatters=\"::$ctrl.tableFormatters\">\n            </gantt-table>\n\n            <gantt-bounds></gantt-bounds>\n            <gantt-progress></gantt-progress>\n            <gantt-overlap></gantt-overlap>\n            <gantt-deliveries></gantt-deliveries>\n        </div>\n    </div>\n    <div class=\"row alert notice no-release-message\" ng-if=\"!$ctrl.hasReleasesFound() && !$ctrl.loading\">\n        <div>No releases found</div>\n    </div>\n    <div class=\"spinner\" ng-if=\"$ctrl.loading\">\n        <img src=\"static/9.5.5/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" />\n    </div>\n</div>\n"

/***/ }),

/***/ 3154:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _timelinePhaseTooltip = __webpack_require__(3155);

var _timelinePhaseTooltip2 = _interopRequireDefault(_timelinePhaseTooltip);

var _timelineDeliveryTooltip = __webpack_require__(3156);

var _timelineDeliveryTooltip2 = _interopRequireDefault(_timelineDeliveryTooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var tooltipTemplate = '\n    <div class=\'tooltip fgt-timeline-tooltip\' role=\'tooltip\'>\n        <div class=\'tooltip-arrow fgt-timeline-tooltip-arrow\'></div>\n        <div class=\'tooltip-inner\'></div>\n    </div>\n';

exports.default = ['$compile', function ($compile) {
    return {
        restrict: 'A',
        link: function link(scope, element) {
            var template = _.get(scope, 'task.model.data.isDelivery') ? _timelineDeliveryTooltip2.default : _timelinePhaseTooltip2.default;
            element.tooltip({
                title: $compile(template)(scope),
                delay: 50,
                trigger: 'hover',
                placement: 'auto',
                html: true,
                animation: false,
                container: 'body',
                template: tooltipTemplate
            });

            var offStateChangeStart = scope.$on('$stateChangeStart', function () {
                element.tooltip('destroy');
                offStateChangeStart();
            });

            var throttled = _.throttle(trackMove, 0);

            element.mousemove(throttled);

            function trackMove(event) {
                var tooltip = angular.element('.fgt-timeline-tooltip');
                var tooltipArrow = angular.element('.fgt-timeline-tooltip-arrow');
                var tooltipWidth = tooltip.outerWidth();
                var tooltipHalfWidth = tooltipWidth / 2;
                var clientX = parseInt(event.clientX);
                var marginRight = 5;

                if (event.clientX + tooltipHalfWidth + marginRight >= window.outerWidth) {
                    tooltip.css('left', '');
                    tooltip.css('right', marginRight + 'px');
                    tooltipArrow.css('left', tooltipWidth - (window.outerWidth - clientX) + 'px');
                } else {
                    tooltipArrow.css('left', tooltipHalfWidth + 'px');
                    tooltip.css('left', clientX - tooltipHalfWidth + 'px');
                    tooltip.css('right', '');
                }
            }
        }
    };
}];

/***/ }),

/***/ 3155:
/***/ (function(module, exports) {

module.exports = "<span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Phase: {{::task.model.data.phase.title}}</span>\n<ul class=\"list-unstyled\" ng-init=\"phase = task.model.data.phase\">\n    <li ng-if=\"::!phase.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Estimated start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedStartDate, phase.scheduledStartDate)}\">\n            {{::phase.plannedStartDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedStartDate, phase.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::phase.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.startDate, phase.scheduledStartDate)}\">\n            {{::phase.startDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.startDate, phase.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::!phase.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">Estimated end date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedEndDate, phase.dueDate)}\">\n            {{::phase.plannedEndDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedEndDate, phase.dueDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::phase.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">End date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.endDate, phase.dueDate)}\">\n            {{::phase.endDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.endDate, phase.dueDate)}}</div>\n        </span>\n    </li>\n</ul>\n<div class=\"running-task-info\" ng-show=\"::phase.currentTask\">\n    Running task: {{::phase.currentTask}}\n</div>\n<div class=\"fgt-timeline-tooltip-splitter\"></div>\n<div class=\"fgt-timeline-tooltip-release\">\n    <span class=\"fgt-timeline-tooltip-belongs_to\">Release: {{::task.model.data.release.title}}</span>\n    <span class=\"pull-right\">\n        <release-status-label release=\"task.model.data.release\" show-archived=\"true\"></release-status-label>\n    </span>\n</div>\n<ul class=\"list-unstyled\" ng-init=\"release = task.model.data.release\">\n    <li ng-if=\"::!release.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Planned start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedStartDate, release.scheduledStartDate)}\">\n            {{::release.plannedStartDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedStartDate, release.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::release.startDate\" class=\"text-right\">\n        <span class=\"pull-left\">Start date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.startDate, release.scheduledStartDate)}\">\n            {{::release.startDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.startDate, release.scheduledStartDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::!release.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">Planned end date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedEndDate, release.dueDate)}\">\n            {{::release.plannedEndDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedEndDate, release.dueDate)}}</div>\n        </span>\n    </li>\n    <li ng-if=\"::release.endDate\" class=\"text-right\">\n        <span class=\"pull-left\">End date:</span>\n        <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.endDate, release.dueDate)}\">\n            {{::release.endDate | mediumDateShortTime}}\n            <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.endDate, release.dueDate)}}</div>\n        </span>\n    </li>\n</ul>\n"

/***/ }),

/***/ 3156:
/***/ (function(module, exports) {

module.exports = "<span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Delivery: {{::task.model.name}}</span>\n<ul class=\"list-unstyled\">\n    <li>\n        <span>Start date:</span>\n        <span class=\"pull-right\">\n            {{::task.model.from.toDate() | mediumDateShortTime}}\n        </span>\n    </li>\n    <li>\n        <span>End date:</span>\n        <span class=\"pull-right\">\n            {{::task.model.to.toDate() | mediumDateShortTime}}\n        </span>\n    </li>\n</ul>\n"

/***/ }),

/***/ 3157:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliveryTimelinePage = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deliveriesTimelineActions = __webpack_require__(360);

__webpack_require__(3158);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div id="deliveries" class="fc-list fgd-deliveries">\n    <xlr-delivery-details-header delivery="$ctrl.delivery" class="delivery-header-gantt-fix">\n        <filter class="filters"\n                filters="$ctrl.filters"\n                on-change="$ctrl.onFiltersChanged()">\n            <div class="actions">\n                <i class="button-toggle-filter-icon xl-icon search-icon"/>\n                <text-filter field="\'title\'" placeholder="\'Search for releases\'"/>\n                <order-by-filter class="filter last"/>\n                <span class="fgt-zoom filter">\n                        <span class="filter-title">Zoom</span>\n                        <div class="button-delivery">\n                            <button class="btn btn-flat button-icon"\n                                    ng-click="$ctrl.zoomLevelOut && $ctrl.zoomOut()"\n                                    ng-disabled="!$ctrl.zoomLevelOut"><i class="xl-icon minus-icon"/></button>\n                        <button class="btn btn-flat button-icon"\n                                ng-click="$ctrl.zoomLevelIn && $ctrl.zoomIn()"\n                                ng-disabled="!$ctrl.zoomLevelIn"><i class="xl-icon add-icon"/></button>\n                        </div>\n                    </span>\n            </div>\n        </filter>\n\n        <div class="buttons">\n            <span doc-icon="deliveries-details.html"/>\n        </div>\n    </xlr-delivery-details-header>\n    <div class="fc-list-items-wrapper">\n        <xlr-delivery-timeline delivery="$ctrl.delivery" loading="$ctrl.loading" on-refresh="$ctrl.onFiltersChanged()"/>\n    </div>\n</div>\n';

var DeliveryTimelinePageController = function () {
    function DeliveryTimelinePageController($scope, Events, $ngRedux, Page) {
        (0, _classCallCheck3.default)(this, DeliveryTimelinePageController);

        this._$scope = $scope;
        this._Events = Events;
        this._Page = Page;
        this._isBreadCrumbInitialized = false;
        this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.bind(this))(this);
    }

    (0, _createClass3.default)(DeliveryTimelinePageController, [{
        key: '$onInit',
        value: function $onInit() {
            this._$scope.$emit(this._Events.permission.refresh);
            this.fetchTimeline({});
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this.resetToInitialState();
            this._unsubscribe();
        }
    }, {
        key: '_mapDispatchToThis',
        value: function _mapDispatchToThis(dispatch) {
            return {
                resetToInitialState: function resetToInitialState() {
                    dispatch((0, _deliveriesTimelineActions.resetToInitialState)());
                },
                fetchTimeline: function fetchTimeline(filters) {
                    dispatch((0, _deliveriesTimelineActions.getTimeline)(this.delivery, filters));
                },
                updateFilters: function updateFilters(filters) {
                    dispatch((0, _deliveriesTimelineActions.setFilters)(filters));
                },
                zoomIn: function zoomIn() {
                    dispatch({ type: _deliveriesTimelineActions.actionTypes.ZOOM_IN });
                },
                zoomOut: function zoomOut() {
                    dispatch({ type: _deliveriesTimelineActions.actionTypes.ZOOM_OUT });
                }
            };
        }
    }, {
        key: '_mapStateToThis',
        value: function _mapStateToThis(_ref) {
            var deliveriesTimeline = _ref.deliveriesTimeline;
            var delivery = deliveriesTimeline.delivery;

            if (delivery) {
                this._setBreadcrumbs(delivery);
            }

            return (0, _extends3.default)({
                gantt: deliveriesTimeline.gantt,
                delivery: delivery,
                loading: deliveriesTimeline.loading,
                filters: deliveriesTimeline.filters
            }, deliveriesTimeline.zoomLevel);
        }
    }, {
        key: '_setBreadcrumbs',
        value: function _setBreadcrumbs(delivery) {
            if (!this._isBreadCrumbInitialized) {
                this._Page.setFolderEntityOpened(delivery.folderId, delivery);
                this._isBreadCrumbInitialized = true;
            }
        }
    }, {
        key: 'onFiltersChanged',
        value: function onFiltersChanged() {
            this.updateFilters(this.filters);
        }
    }]);
    return DeliveryTimelinePageController;
}();

DeliveryTimelinePageController.$inject = ['$scope', 'Events', '$ngRedux', 'Page'];
var deliveryTimelinePage = exports.deliveryTimelinePage = {
    bindings: {
        delivery: '<',
        folder: '<'
    },
    controller: DeliveryTimelinePageController,
    template: template
};

/***/ }),

/***/ 3158:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3160:
/***/ (function(module, exports) {

module.exports = "<div id=\"logs\" ng-if=\"filters\">\n    <xlr-delivery-details-header delivery=\"delivery\">\n        <div class=\"filters\" ng-controller=\"FiltersController\">\n            <div class=\"actions\">\n                <input id=\"search-filter\" autofocus type=\"search\" class=\"filter\" placeholder=\"Filter by user or action...\" ng-model=\"filters.filter\">\n                <button type=\"button\" class=\"button dropdown-button filter\" bs-popover\n                        data-content-template=\"static/9.5.5/include/ActivityLogs/activity-logs-filter/activity-logs-categories-filter.html\"\n                        data-placement=\"bottom\" auto-close=\"true\">Filter categories\n                </button>\n                <span class=\"filter\" ng-include=\"'partials/filters/from-to-date-filters.html'\"/>\n            </div>\n        </div>\n        <span doc-icon=\"activity-logs.html\"></span>\n    </xlr-delivery-details-header>\n    <div class=\"content-under-header\">\n        <activity-logs-list filters=\"filters\" container-id=\"containerId\" />\n    </div>\n</div>\n"

/***/ }),

/***/ 3161:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryActivityLogsController = function DeliveryActivityLogsController($scope, $stateParams, filterSettings, deliveryPromise) {
    (0, _classCallCheck3.default)(this, DeliveryActivityLogsController);

    this._$scope = $scope;

    this._$scope.containerId = $stateParams.deliveryId;
    this._$scope.filters = filterSettings;
    this._$scope.activityFilters = [{ id: "display-important", model: "important", label: "Important" }, { id: "display-lifecycle", model: "lifecycle", label: "Delivery life cycle" }, { id: "display-delivery_edit", model: "deliveryEdit", label: "Delivery edits" }, { id: "display-other", model: "other", label: "Other" }];
    this._$scope.delivery = deliveryPromise.data;
};

DeliveryActivityLogsController.$inject = ['$scope', '$stateParams', 'filterSettings', 'deliveryPromise'];
exports.default = DeliveryActivityLogsController;

/***/ }),

/***/ 3162:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _folderDeliveriesComponent = __webpack_require__(3163);

angular.module('xlrelease.deliveries').component('folderDeliveriesList', _folderDeliveriesComponent.FolderDeliveriesComponent);

/***/ }),

/***/ 3163:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FolderDeliveriesComponent = undefined;

var _toConsumableArray2 = __webpack_require__(52);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _get2 = __webpack_require__(323);

var _get3 = _interopRequireDefault(_get2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _folderDeliveries = __webpack_require__(3164);

var _folderDeliveries2 = _interopRequireDefault(_folderDeliveries);

var _deliveriesController = __webpack_require__(916);

var _deliveriesController2 = _interopRequireDefault(_deliveriesController);

__webpack_require__(3165);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FolderDeliveriesController = function (_DeliveriesController) {
    (0, _inherits3.default)(FolderDeliveriesController, _DeliveriesController);

    function FolderDeliveriesController(ClientSettings) {
        var _ref;

        (0, _classCallCheck3.default)(this, FolderDeliveriesController);

        for (var _len = arguments.length, superArguments = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            superArguments[_key - 1] = arguments[_key];
        }

        var _this = (0, _possibleConstructorReturn3.default)(this, (_ref = FolderDeliveriesController.__proto__ || (0, _getPrototypeOf2.default)(FolderDeliveriesController)).call.apply(_ref, [this].concat(superArguments)));

        _this._ClientSettings = ClientSettings;
        return _this;
    }

    (0, _createClass3.default)(FolderDeliveriesController, [{
        key: 'filtersChanged',
        value: function filtersChanged() {
            this._ClientSettings.setDeliveryListFilters(this.filters);
            (0, _get3.default)(FolderDeliveriesController.prototype.__proto__ || (0, _getPrototypeOf2.default)(FolderDeliveriesController.prototype), 'filtersChanged', this).call(this);
        }
    }]);
    return FolderDeliveriesController;
}(_deliveriesController2.default);

FolderDeliveriesController.$inject = ['ClientSettings'].concat((0, _toConsumableArray3.default)(_deliveriesController2.default.$inject));
var FolderDeliveriesComponent = exports.FolderDeliveriesComponent = {
    bindings: {
        folder: '<',
        filters: '<'
    },
    controller: FolderDeliveriesController,
    template: _folderDeliveries2.default
};

/***/ }),

/***/ 3164:
/***/ (function(module, exports) {

module.exports = "\n<folder-details folder=\"$ctrl.folder\" ng-class=\"{'header-expanded': $ctrl.isHeaderExpanded}\" >\n    <header class=\"folder-deliveries-header\">\n      <delivery-filter\n          filters=\"$ctrl.filters\"\n          filters-changed=\"$ctrl.filtersChanged()\"\n          items-count=\"$ctrl.itemsCount\">\n      </delivery-filter>\n       <delivery-sub-header has-deliveries=\"$ctrl.hasDeliveries()\"></delivery-sub-header>\n    </header>\n    <content>\n        <div class=\"folder-deliveries-list\" id=\"deliveries\">\n            <xlr-delivery-list\n                 deliveries=\"$ctrl.deliveries\"\n                 deliveries-loading-status=\"$ctrl.loading\"\n                 deliveries-has-more=\"$ctrl.hasMoreDeliveries\"\n                 on-refresh=\"$ctrl.filtersChanged()\"\n                 on-show-more-deliveries=\"$ctrl.loadMoreDeliveries()\">\n            </xlr-delivery-list>\n        </div>\n    </content>\n</folder-details>\n"

/***/ }),

/***/ 3165:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3167:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

__webpack_require__(3168);

var _index = __webpack_require__(202);

var _deliveryPatternListHeader = __webpack_require__(3170);

var _deliveryPatternListHeader2 = _interopRequireDefault(_deliveryPatternListHeader);

var _deliveryPatternCreateHeader = __webpack_require__(3183);

var _deliveryPatternCreateHeader2 = _interopRequireDefault(_deliveryPatternCreateHeader);

var _deliveryPatternList = __webpack_require__(3186);

var _deliveryPatternList2 = _interopRequireDefault(_deliveryPatternList);

var _deliveryPatternForm = __webpack_require__(3193);

var _deliveryPatternForm2 = _interopRequireDefault(_deliveryPatternForm);

var _foldersDeliveryPatterns = __webpack_require__(3200);

var _foldersDeliveryPatterns2 = _interopRequireDefault(_foldersDeliveryPatterns);

var _trackedItem = __webpack_require__(3201);

var _trackedItem2 = _interopRequireDefault(_trackedItem);

var _trackedItemHeader = __webpack_require__(3211);

var _trackedItemHeader2 = _interopRequireDefault(_trackedItemHeader);

var _deliveryPatternPropertiesHeader = __webpack_require__(3214);

var _deliveryPatternPropertiesHeader2 = _interopRequireDefault(_deliveryPatternPropertiesHeader);

var _deliveryPatternFlow = __webpack_require__(3217);

var _deliveryPatternFlow2 = _interopRequireDefault(_deliveryPatternFlow);

var _deliveryPatternFlowHeader = __webpack_require__(3228);

var _deliveryPatternFlowHeader2 = _interopRequireDefault(_deliveryPatternFlowHeader);

var _deliveriesDetailsPageExtensionController = __webpack_require__(918);

var _deliveryDetailsPageExtensionContainer = __webpack_require__(917);

var _deliveryDetailsPageExtensionContainer2 = _interopRequireDefault(_deliveryDetailsPageExtensionContainer);

var _deliveryPattern = __webpack_require__(274);

var _deliveryPatternSubHeaderLabel = __webpack_require__(3231);

var _deliveryPatternSubHeaderLabel2 = _interopRequireDefault(_deliveryPatternSubHeaderLabel);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = angular.module('xlrelease.deliveryPatterns', []).component('deliveryPatternListHeader', (0, _index.react2angular)(_deliveryPatternListHeader2.default)).component('deliveryPatternList', (0, _index.react2angular)(_deliveryPatternList2.default)).component('deliveryPatternForm', (0, _index.react2angular)(_deliveryPatternForm2.default)).component('deliveryPatternCreateHeader', (0, _index.react2angular)(_deliveryPatternCreateHeader2.default)).component('folderDeliveryPatterns', _foldersDeliveryPatterns2.default).component('patternTrackedItems', (0, _index.react2angular)(_trackedItem2.default)).component('patternTrackedItemsHeader', (0, _index.react2angular)(_trackedItemHeader2.default)).component('deliveryPatternPropertiesHeader', (0, _index.react2angular)(_deliveryPatternPropertiesHeader2.default)).component('patternFlow', (0, _index.react2angular)(_deliveryPatternFlow2.default)).component('patternSubHeaderLabel', (0, _index.react2angular)(_deliveryPatternSubHeaderLabel2.default)).component('patternFlowHeader', (0, _index.react2angular)(_deliveryPatternFlowHeader2.default)).config(['$stateProvider', function ($stateProvider) {

    $stateProvider.state('deliveryPatternsDetails', {
        url: '/delivery-patterns/{deliveryId: DeliveryId}',
        template: _deliveryDetailsPageExtensionContainer2.default,
        controller: _deliveriesDetailsPageExtensionController.DeliveryDetailsPageExtensionController,
        controllerAs: 'deliveryDetailsPageExtension',
        resolve: {
            deliveryPromise: ['$stateParams', function ($stateParams) {
                return (0, _deliveryPattern.fetchDeliveryPattern)($stateParams.deliveryId);
            }]
        }
    }).state('deliveryPatternsDetailsPageExtension', {
        url: '/delivery-patterns/{deliveryId: DeliveryId}/:extensionPath',
        template: _deliveryDetailsPageExtensionContainer2.default,
        controller: _deliveriesDetailsPageExtensionController.DeliveryDetailsPageExtensionController,
        controllerAs: 'deliveryDetailsPageExtension',
        resolve: {
            deliveryPromise: ['$stateParams', function ($stateParams) {
                return (0, _deliveryPattern.fetchDeliveryPattern)($stateParams.deliveryId);
            }]
        }
    });
}]).name;

/***/ }),

/***/ 3168:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3170:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(43);

var _deliveryPatternListHeader = __webpack_require__(3171);

var _deliveryPatternListHeader2 = _interopRequireDefault(_deliveryPatternListHeader);

var _deliveries = __webpack_require__(212);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryPatternListHeaderPage = function (_Component) {
    (0, _inherits3.default)(DeliveryPatternListHeaderPage, _Component);

    function DeliveryPatternListHeaderPage() {
        (0, _classCallCheck3.default)(this, DeliveryPatternListHeaderPage);
        return (0, _possibleConstructorReturn3.default)(this, (DeliveryPatternListHeaderPage.__proto__ || (0, _getPrototypeOf2.default)(DeliveryPatternListHeaderPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(DeliveryPatternListHeaderPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _deliveries.store },
                _react2.default.createElement(_deliveryPatternListHeader2.default, { isCreateAllowed: this.props.isCreateAllowed })
            );
        }
    }]);
    return DeliveryPatternListHeaderPage;
}(_react.Component);

DeliveryPatternListHeaderPage.propTypes = {
    isCreateAllowed: _propTypes2.default.bool.isRequired
};
exports.default = DeliveryPatternListHeaderPage;

/***/ }),

/***/ 3171:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(43);

var _deliveryPatternListHeader = __webpack_require__(3172);

var _deliveryPatternListHeader2 = _interopRequireDefault(_deliveryPatternListHeader);

var _deliveryPattern = __webpack_require__(229);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        filter: state.deliveryPatterns.filter
    };
};

var mapDispatchToProps = function mapDispatchToProps(dispatch) {
    return {
        onCreateDeliveryPattern: function onCreateDeliveryPattern() {
            return dispatch((0, _deliveryPattern.deliveryPatternForm)());
        },
        onFilterChange: function onFilterChange(title) {
            return dispatch((0, _deliveryPattern.changeDeliveryPatternFilter)(title));
        }
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_deliveryPatternListHeader2.default);

/***/ }),

/***/ 3172:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(47);

var _components = __webpack_require__(67);

var _activityLogsListController = __webpack_require__(796);

var _activityLogsListController2 = _interopRequireDefault(_activityLogsListController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var filterOptions = { placeholder: 'Filter by name...' };

var DeliveryPatternListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(DeliveryPatternListHeaderComponent, _Component);

    function DeliveryPatternListHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, DeliveryPatternListHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (DeliveryPatternListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(DeliveryPatternListHeaderComponent)).call(this, props));
    }

    (0, _createClass3.default)(DeliveryPatternListHeaderComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _props = this.props,
                filter = _props.filter,
                onFilterChange = _props.onFilterChange;

            onFilterChange(filter);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                filter = _props2.filter,
                isCreateAllowed = _props2.isCreateAllowed,
                onCreateDeliveryPattern = _props2.onCreateDeliveryPattern,
                onFilterChange = _props2.onFilterChange;


            return _react2.default.createElement(
                _react.Fragment,
                null,
                _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, model: filter, onUpdate: onFilterChange,
                    style: { marginBottom: '0' } }),
                isCreateAllowed && _react2.default.createElement(
                    'div',
                    { className: 'buttons' },
                    _react2.default.createElement(
                        'button',
                        { className: 'button primary new-delivery-pattern', onClick: onCreateDeliveryPattern },
                        'New delivery pattern'
                    ),
                    _react2.default.createElement(_components.DocLink, { section: "delivery-patterns.html" })
                )
            );
        }
    }]);
    return DeliveryPatternListHeaderComponent;
}(_react.Component);

DeliveryPatternListHeaderComponent.propTypes = {
    filter: _propTypes2.default.string.isRequired,
    isCreateAllowed: _propTypes2.default.bool.isRequired,
    onCreateDeliveryPattern: _propTypes2.default.func,
    onFilterChange: _propTypes2.default.func.isRequired
};
exports.default = DeliveryPatternListHeaderComponent;

/***/ }),

/***/ 3173:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _deliveryPattern = __webpack_require__(3174);

Object.defineProperty(exports, 'deliveryPatterns', {
  enumerable: true,
  get: function get() {
    return _deliveryPattern.deliveryPatterns;
  }
});

var _trackedItem = __webpack_require__(3175);

Object.defineProperty(exports, 'trackedItems', {
  enumerable: true,
  get: function get() {
    return _trackedItem.trackedItems;
  }
});

var _stage = __webpack_require__(3176);

Object.defineProperty(exports, 'stages', {
  enumerable: true,
  get: function get() {
    return _stage.stages;
  }
});

var _transition = __webpack_require__(3177);

Object.defineProperty(exports, 'transitions', {
  enumerable: true,
  get: function get() {
    return _transition.transitions;
  }
});

var _deliveryPattern2 = __webpack_require__(3178);

Object.defineProperty(exports, 'deliveryPatternSagas', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_deliveryPattern2).default;
  }
});

var _trackedItem2 = __webpack_require__(3179);

Object.defineProperty(exports, 'trackedItemSagas', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_trackedItem2).default;
  }
});

var _stage2 = __webpack_require__(3181);

Object.defineProperty(exports, 'stageSagas', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_stage2).default;
  }
});

var _transition2 = __webpack_require__(3182);

Object.defineProperty(exports, 'transitionSagas', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_transition2).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 3174:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deliveryPatterns = undefined;

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _deliveryPattern = __webpack_require__(229);

var _moment = __webpack_require__(28);

var _moment2 = _interopRequireDefault(_moment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DEFAULT = {
    list: [],
    form: {
        model: {
            plannedDuration: 0,
            id: null,
            title: '',
            description: '',
            folderId: null
        },
        lastSaved: null,
        pristine: true,
        valid: false,
        isTitleValid: true,
        editable: true,
        all: []
    },
    loading: false,
    filter: "",
    canEdit: false
};

var deliveryPatterns = exports.deliveryPatterns = function deliveryPatterns() {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT;
    var action = arguments[1];


    switch (action.type) {
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_CREATE_FORM:
            return (0, _extends3.default)({}, state, {
                form: {
                    model: {
                        plannedDuration: 0,
                        id: null,
                        title: '',
                        description: ''
                    },
                    editable: true,
                    pristine: true,
                    isTitleValid: true,
                    valid: false
                }
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_LIST_SUCCEEDED:
            var list = action.payload;
            return (0, _extends3.default)({}, state, {
                list: list,
                loading: false
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_VALID:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    valid: action.payload
                })
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    valid: state.form.valid && action.payload,
                    isTitleValid: action.payload
                })
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_MODEL_CHANGE:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    model: action.payload,
                    pristine: false
                })
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_CREATE_SUCCEEDED:
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED:
            return (0, _extends3.default)({}, state);
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_DELETE_SUCCEEDED:
            return (0, _extends3.default)({}, state, {
                list: state.list.filter(function (item) {
                    return item.id !== action.payload;
                })
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED:
            return (0, _extends3.default)({}, state, {
                filter: action.payload,
                loading: true
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_LIST_FAILED:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_LOAD_SUCCEEDED:
            var _action$payload = action.payload,
                description = _action$payload.description,
                plannedDuration = _action$payload.plannedDuration,
                folderId = _action$payload.folderId,
                id = _action$payload.id,
                isEditable = _action$payload.isEditable,
                title = _action$payload.title;

            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    model: {
                        plannedDuration: plannedDuration, id: id, title: title, description: description, folderId: folderId
                    },
                    editable: isEditable,
                    pristine: true
                })
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_PRISTINE:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    pristine: action.payload
                })
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_GET_ALL_SUCCEEDED:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    all: action.payload
                })
            });
        case _deliveryPattern.actionTypes.DELIVERY_PATTERN_UPDATE_SUCCEEDED:
            return (0, _extends3.default)({}, state, {
                form: (0, _extends3.default)({}, state.form, {
                    lastSaved: (0, _moment2.default)().format('MMMM DD, YYYY h:mm:ss A'),
                    pristine: true
                })
            });
        default:
            return state;
    }
};

/***/ }),

/***/ 3175:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.trackedItems = undefined;

var _toConsumableArray2 = __webpack_require__(52);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _trackedItem = __webpack_require__(470);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var INITIAL = {
    list: [],
    filter: ''
};

var trackedItems = exports.trackedItems = function trackedItems() {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL;
    var action = arguments[1];

    switch (action.type) {
        case _trackedItem.actionTypes.TRACKED_ITEM_SET_LIST:
            {
                return (0, _extends3.default)({}, state, {
                    list: action.payload
                });
            }
        case _trackedItem.actionTypes.TRACKED_ITEM_ADDED:
            {
                var list = state.list;

                return (0, _extends3.default)({}, state, {
                    list: list.concat([action.payload])
                });
            }
        case _trackedItem.actionTypes.TRACKED_ITEM_UPDATED:
            {
                var _list = state.list;
                var _action$payload = action.payload,
                    id = _action$payload.id,
                    title = _action$payload.title;

                _list.find(function (item) {
                    return item.id === id;
                }).title = title;
                return (0, _extends3.default)({}, state, {
                    list: [].concat((0, _toConsumableArray3.default)(_list))
                });
            }
        case _trackedItem.actionTypes.TRACKED_ITEM_REMOVED:
            {
                var _list2 = state.list;

                return (0, _extends3.default)({}, state, {
                    list: _list2.filter(function (item) {
                        return item.id !== action.payload;
                    })
                });
            }
        case _trackedItem.actionTypes.TRACKED_ITEM_FILTER_CHANGED:
            {
                var filter = action.payload;
                return (0, _extends3.default)({}, state, {
                    filter: filter
                });
            }
        default:
            return state;
    }
};

/***/ }),

/***/ 3176:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.stages = undefined;

var _toConsumableArray2 = __webpack_require__(52);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _stage = __webpack_require__(471);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var INITIAL = {
    list: [],
    isCreateDeliveryDisabled: true
};

var stages = exports.stages = function stages() {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL;
    var action = arguments[1];

    switch (action.type) {
        case _stage.actionTypes.STAGE_LIST_SUCCEEDED:
            {
                var list = action.payload.map(function (stage) {
                    return { id: stage.id, title: stage.title };
                });
                return (0, _extends3.default)({}, state, {
                    list: list,
                    isCreateDeliveryDisabled: isCreateDeliveryDisabled(list)
                });
            }
        case _stage.actionTypes.STAGE_COPY_SUCCEEDED:
            {
                return (0, _extends3.default)({}, state, {
                    list: state.list.concat({ id: action.payload.id, title: action.payload.title })
                });
            }
        case _stage.actionTypes.STAGE_DELETE_SUCCEEDED:
            {
                var _list = state.list.filter(function (stage) {
                    return stage.id !== action.payload;
                });
                return (0, _extends3.default)({}, state, {
                    list: _list,
                    isCreateDeliveryDisabled: isCreateDeliveryDisabled(_list)
                });
            }
        case _stage.actionTypes.STAGE_EDIT_SUCCEEDED:
            {
                var _list2 = state.list;
                var _action$payload = action.payload,
                    id = _action$payload.id,
                    title = _action$payload.title;

                _list2.find(function (s) {
                    return s.id === id;
                }).title = title;
                return (0, _extends3.default)({}, state, {
                    list: [].concat((0, _toConsumableArray3.default)(_list2))
                });
            }
        case _stage.actionTypes.STAGE_ADD_SUCCEEDED:
            {
                return (0, _extends3.default)({}, state, {
                    list: [].concat((0, _toConsumableArray3.default)(state.list), [{ id: action.payload.id, title: action.payload.title }]),
                    isCreateDeliveryDisabled: false
                });
            }
        default:
            return state;
    }
};

function isCreateDeliveryDisabled(stages) {
    return stages.length === 0;
}

/***/ }),

/***/ 3177:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.transitions = undefined;

var _toConsumableArray2 = __webpack_require__(52);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _transition = __webpack_require__(472);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var INITIAL = {
    list: []
};

var transitions = exports.transitions = function transitions() {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : INITIAL;
    var action = arguments[1];

    switch (action.type) {
        case _transition.actionTypes.TRANSITION_LIST_SUCCEEDED:
            {
                return (0, _extends3.default)({}, state, {
                    list: action.payload.map(function (t) {
                        return { id: t.id, title: t.title, fromStageId: t.fromStageId };
                    })
                });
            }
        case _transition.actionTypes.TRANSITION_ADD_SUCCEEDED:
            {
                return (0, _extends3.default)({}, state, {
                    list: [].concat((0, _toConsumableArray3.default)(state.list), [{ id: action.payload.id, title: action.payload.title, fromStageId: action.payload.fromStageId }])
                });
            }
        case _transition.actionTypes.TRANSITION_UPDATE_SUCCEEDED:
            {
                var list = state.list;
                var _action$payload = action.payload,
                    id = _action$payload.id,
                    title = _action$payload.title;

                list.find(function (s) {
                    return s.id === id;
                }).title = title;
                return (0, _extends3.default)({}, state, {
                    list: [].concat((0, _toConsumableArray3.default)(list))
                });
            }
        case _transition.actionTypes.TRANSITION_DELETE_SUCCEEDED:
            {
                return (0, _extends3.default)({}, state, {
                    list: state.list.filter(function (t) {
                        return t.id !== action.payload;
                    })
                });
            }
        default:
            return state;
    }
};

/***/ }),

/***/ 3178:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.default = combinedSaga;

var _effects = __webpack_require__(54);

var _deliveryPattern = __webpack_require__(229);

var _deliveryPattern2 = __webpack_require__(274);

var deliveryPatternService = _interopRequireWildcard(_deliveryPattern2);

var _angularAccessor = __webpack_require__(111);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _sagas = __webpack_require__(584);

var _deliveryPattern3 = __webpack_require__(467);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(updateBreadcrumbs),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(loadDeliveryPattern),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(flowView),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(goToCreateDelivery),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(cancelCreate),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(searchDeliveryPatterns),
    _marked7 = /*#__PURE__*/_regenerator2.default.mark(createDeliveryPattern),
    _marked8 = /*#__PURE__*/_regenerator2.default.mark(updateDeliveryPattern),
    _marked9 = /*#__PURE__*/_regenerator2.default.mark(removeDeliveryPattern),
    _marked10 = /*#__PURE__*/_regenerator2.default.mark(resetDeliveryPattern),
    _marked11 = /*#__PURE__*/_regenerator2.default.mark(duplicateDeliveryPattern),
    _marked12 = /*#__PURE__*/_regenerator2.default.mark(setupConfirmLeavePopup),
    _marked13 = /*#__PURE__*/_regenerator2.default.mark(getAllPatterns),
    _marked14 = /*#__PURE__*/_regenerator2.default.mark(validatePatternTitle),
    _marked15 = /*#__PURE__*/_regenerator2.default.mark(combinedSaga);

function isEditable(def) {
    var authenticator = (0, _angularAccessor2.default)('Authenticator');
    return authenticator.hasPermission(_deliveryPattern3.DELIVERY_PATTERN_EDIT_PERMISSION, def.$metadata);
}

function canCreateDelivery(def) {
    var authenticator = (0, _angularAccessor2.default)('Authenticator');
    return authenticator.hasPermission(_deliveryPattern3.DELIVERY_EDIT_PERMISSION, def.$metadata);
}

function isCreateDeliveryDisabled(def) {
    return def.stages.length === 0;
}

function listView() {
    var param = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

    var $location = (0, _angularAccessor2.default)('$location');
    var $stateParams = (0, _angularAccessor2.default)('$stateParams');
    var $rootScope = (0, _angularAccessor2.default)('$rootScope');
    $location.url('/folders/' + $stateParams.folderId + '/delivery-patterns?' + param);
    $rootScope.$digest();
}

function deliveryPatternForm() {
    listView('action=create');
}

function createDeliveryForm() {
    var $state = (0, _angularAccessor2.default)('$state');
    var Ids = (0, _angularAccessor2.default)('Ids');
    var $stateParams = (0, _angularAccessor2.default)('$stateParams');
    $state.go('deliveryCreate', { fromPatternId: Ids.toInternalId($stateParams.deliveryId) });
}

function updateBreadcrumbs(checkUrl, deliveryPattern) {
    var page;
    return _regenerator2.default.wrap(function updateBreadcrumbs$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'Page');

                case 2:
                    page = _context.sent;

                    if (page.isOnPage(checkUrl)) {
                        page.setFolderEntityOpened(deliveryPattern.folderId, deliveryPattern);
                    }

                case 4:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this);
}

function loadDeliveryPattern(action) {
    var resp;
    return _regenerator2.default.wrap(function loadDeliveryPattern$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.prev = 0;
                    _context2.next = 3;
                    return (0, _effects.call)(deliveryPatternService.fetchDeliveryPattern, action.payload);

                case 3:
                    resp = _context2.sent;
                    _context2.next = 6;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 6:
                    _context2.next = 8;
                    return (0, _effects.put)((0, _deliveryPattern.deliveryLoaded)((0, _extends3.default)({}, resp, { isEditable: isEditable(resp), canCreateDelivery: canCreateDelivery(resp) })));

                case 8:
                    _context2.next = 13;
                    break;

                case 10:
                    _context2.prev = 10;
                    _context2.t0 = _context2['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error while loading delivery pattern...', _context2.t0);
                    /* eslint-enable */

                case 13:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[0, 10]]);
}

function flowView(action) {
    return _regenerator2.default.wrap(function flowView$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    location.href = '#/delivery-patterns/' + action.payload;

                case 1:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function goToCreateDelivery(action) {
    var $state, $rootScope, idsFactory, fromPatternId;
    return _regenerator2.default.wrap(function goToCreateDelivery$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    $state = (0, _angularAccessor2.default)('$state');
                    $rootScope = (0, _angularAccessor2.default)('$rootScope');
                    idsFactory = (0, _angularAccessor2.default)('Ids');
                    fromPatternId = idsFactory.toInternalId(action.payload);

                    $state.go('deliveryCreate', { fromPatternId: fromPatternId });
                    $rootScope.$digest();

                case 6:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

function cancelCreate() {
    var $window;
    return _regenerator2.default.wrap(function cancelCreate$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 2:
                    $window = (0, _angularAccessor2.default)('$window');

                    $window.history.back();
                    _context5.next = 6;
                    return (0, _effects.put)((0, _deliveryPattern.createCancelled)());

                case 6:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

function searchDeliveryPatterns() {
    var folderId, filter, list;
    return _regenerator2.default.wrap(function searchDeliveryPatterns$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.prev = 0;
                    folderId = (0, _angularAccessor2.default)('$stateParams').folderId;
                    _context6.next = 4;
                    return (0, _effects.select)(function (state) {
                        return state.deliveryPatterns.filter;
                    });

                case 4:
                    filter = _context6.sent;
                    _context6.next = 7;
                    return (0, _effects.call)(deliveryPatternService.searchDeliveryPatterns, { title: filter, folderId: folderId });

                case 7:
                    list = _context6.sent;
                    _context6.next = 10;
                    return (0, _effects.put)((0, _deliveryPattern.listLoaded)(list.map(function (d) {
                        return {
                            id: d.id, title: d.title, description: d.description, isEditable: isEditable(d),
                            canCreateDelivery: canCreateDelivery(d), isCreateDeliveryDisabled: isCreateDeliveryDisabled(d)
                        };
                    })));

                case 10:
                    _context6.next = 16;
                    break;

                case 12:
                    _context6.prev = 12;
                    _context6.t0 = _context6['catch'](0);
                    _context6.next = 16;
                    return (0, _effects.put)((0, _deliveryPattern.listFailed)());

                case 16:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this, [[0, 12]]);
}

function createDeliveryPattern() {
    var def, created;
    return _regenerator2.default.wrap(function createDeliveryPattern$(_context7) {
        while (1) {
            switch (_context7.prev = _context7.next) {
                case 0:
                    _context7.prev = 0;
                    _context7.next = 3;
                    return (0, _effects.select)(function (state) {
                        return state.deliveryPatterns.form.model;
                    });

                case 3:
                    def = _context7.sent;

                    def.folderId = (0, _angularAccessor2.default)('$stateParams').folderId;
                    _context7.next = 7;
                    return (0, _effects.call)(deliveryPatternService.createDeliveryPattern, def);

                case 7:
                    created = _context7.sent;
                    _context7.next = 10;
                    return (0, _effects.put)((0, _deliveryPattern.deliveryPatternCreated)(created));

                case 10:
                    _context7.next = 12;
                    return (0, _effects.put)((0, _deliveryPattern.goToDetails)(created.id));

                case 12:
                    _context7.next = 17;
                    break;

                case 14:
                    _context7.prev = 14;
                    _context7.t0 = _context7['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error while creating delivery pattern...', _context7.t0);
                    /* eslint-enable */

                case 17:
                case 'end':
                    return _context7.stop();
            }
        }
    }, _marked7, this, [[0, 14]]);
}

function updateDeliveryPattern() {
    var $location, urlBeforeUpdate, def, updated;
    return _regenerator2.default.wrap(function updateDeliveryPattern$(_context8) {
        while (1) {
            switch (_context8.prev = _context8.next) {
                case 0:
                    _context8.prev = 0;
                    _context8.next = 3;
                    return (0, _effects.call)(_angularAccessor2.default, '$location');

                case 3:
                    $location = _context8.sent;
                    urlBeforeUpdate = $location.path();
                    _context8.next = 7;
                    return (0, _effects.select)(function (state) {
                        return state.deliveryPatterns.form.model;
                    });

                case 7:
                    def = _context8.sent;
                    _context8.next = 10;
                    return (0, _effects.call)(deliveryPatternService.updateDeliveryPattern, def);

                case 10:
                    updated = _context8.sent;
                    _context8.next = 13;
                    return (0, _effects.call)(updateBreadcrumbs, urlBeforeUpdate, updated);

                case 13:
                    _context8.next = 15;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 15:
                    _context8.next = 17;
                    return (0, _effects.call)(getAllPatterns);

                case 17:
                    _context8.next = 19;
                    return (0, _effects.put)((0, _deliveryPattern.deliveryPatternUpdated)(updated));

                case 19:
                    _context8.next = 24;
                    break;

                case 21:
                    _context8.prev = 21;
                    _context8.t0 = _context8['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error while updating delivery pattern...', _context8.t0);
                    /* eslint-enable */

                case 24:
                case 'end':
                    return _context8.stop();
            }
        }
    }, _marked8, this, [[0, 21]]);
}

function removeDeliveryPattern(action) {
    return _regenerator2.default.wrap(function removeDeliveryPattern$(_context9) {
        while (1) {
            switch (_context9.prev = _context9.next) {
                case 0:
                    _context9.prev = 0;
                    _context9.next = 3;
                    return (0, _effects.call)(deliveryPatternService.deleteDeliveryPattern, action.payload);

                case 3:
                    _context9.next = 5;
                    return (0, _effects.put)((0, _deliveryPattern.deliveryPatternDeleted)(action.payload));

                case 5:
                    _context9.next = 10;
                    break;

                case 7:
                    _context9.prev = 7;
                    _context9.t0 = _context9['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error while removing delivery pattern...', _context9.t0);
                    /* eslint-enable */

                case 10:
                case 'end':
                    return _context9.stop();
            }
        }
    }, _marked9, this, [[0, 7]]);
}

function resetDeliveryPattern() {
    var deliveryId, orig;
    return _regenerator2.default.wrap(function resetDeliveryPattern$(_context10) {
        while (1) {
            switch (_context10.prev = _context10.next) {
                case 0:
                    _context10.prev = 0;
                    _context10.next = 3;
                    return (0, _effects.put)((0, _deliveryPattern.changePristine)(true));

                case 3:
                    _context10.next = 5;
                    return (0, _effects.select)(function (state) {
                        return state.deliveryPatterns.form.model.id;
                    });

                case 5:
                    deliveryId = _context10.sent;
                    _context10.next = 8;
                    return (0, _effects.call)(deliveryPatternService.fetchDeliveryPattern, deliveryId);

                case 8:
                    orig = _context10.sent;
                    _context10.next = 11;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 11:
                    _context10.next = 13;
                    return (0, _effects.put)((0, _deliveryPattern.deliveryLoaded)((0, _extends3.default)({}, orig, { isEditable: isEditable(orig), canCreateDelivery: canCreateDelivery(orig) })));

                case 13:
                    _context10.next = 18;
                    break;

                case 15:
                    _context10.prev = 15;
                    _context10.t0 = _context10['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error while resetting delivery pattern...', _context10.t0);
                    /* eslint-enable */

                case 18:
                case 'end':
                    return _context10.stop();
            }
        }
    }, _marked10, this, [[0, 15]]);
}

function duplicateDeliveryPattern(action) {
    var copied;
    return _regenerator2.default.wrap(function duplicateDeliveryPattern$(_context11) {
        while (1) {
            switch (_context11.prev = _context11.next) {
                case 0:
                    _context11.prev = 0;
                    _context11.next = 3;
                    return (0, _effects.call)(deliveryPatternService.copyDeliveryPattern, action.payload);

                case 3:
                    copied = _context11.sent;
                    _context11.next = 6;
                    return (0, _effects.put)((0, _deliveryPattern.goToDetails)(copied.id));

                case 6:
                    _context11.next = 11;
                    break;

                case 8:
                    _context11.prev = 8;
                    _context11.t0 = _context11['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error while duplicating delivery pattern...', _context11.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context11.stop();
            }
        }
    }, _marked11, this, [[0, 8]]);
}

function setupConfirmLeavePopup(action) {
    return _regenerator2.default.wrap(function setupConfirmLeavePopup$(_context12) {
        while (1) {
            switch (_context12.prev = _context12.next) {
                case 0:
                    if (action.payload) {
                        _context12.next = 5;
                        break;
                    }

                    _context12.next = 3;
                    return (0, _effects.call)(_sagas.addConfirmLeavePopup);

                case 3:
                    _context12.next = 7;
                    break;

                case 5:
                    _context12.next = 7;
                    return (0, _effects.call)(_sagas.removeConfirmLeavePopup);

                case 7:
                case 'end':
                    return _context12.stop();
            }
        }
    }, _marked12, this);
}

function getAllPatterns() {
    var _all;

    return _regenerator2.default.wrap(function getAllPatterns$(_context13) {
        while (1) {
            switch (_context13.prev = _context13.next) {
                case 0:
                    _context13.prev = 0;
                    _context13.next = 3;
                    return (0, _effects.call)(deliveryPatternService.searchDeliveryPatterns);

                case 3:
                    _all = _context13.sent;
                    _context13.next = 6;
                    return (0, _effects.put)((0, _deliveryPattern.allPatternsLoaded)(_all));

                case 6:
                    _context13.next = 11;
                    break;

                case 8:
                    _context13.prev = 8;
                    _context13.t0 = _context13['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error loading all patterns...', _context13.t0);
                    /* eslint-enable */

                case 11:
                case 'end':
                    return _context13.stop();
            }
        }
    }, _marked13, this, [[0, 8]]);
}

function validatePatternTitle(action) {
    var _action$payload, id, title, valid;

    return _regenerator2.default.wrap(function validatePatternTitle$(_context14) {
        while (1) {
            switch (_context14.prev = _context14.next) {
                case 0:
                    _context14.prev = 0;
                    _context14.next = 3;
                    return (0, _effects.delay)(1000);

                case 3:
                    _action$payload = action.payload, id = _action$payload.id, title = _action$payload.title;
                    _context14.next = 6;
                    return (0, _effects.call)(deliveryPatternService.checkTitle, id, title);

                case 6:
                    valid = _context14.sent;
                    _context14.next = 9;
                    return (0, _effects.put)((0, _deliveryPattern.titleValidated)(valid));

                case 9:
                    _context14.next = 14;
                    break;

                case 11:
                    _context14.prev = 11;
                    _context14.t0 = _context14['catch'](0);

                    /* eslint-disable no-console, angular/log */
                    console.error('Error validating pattern title...', _context14.t0);
                    /* eslint-enable */

                case 14:
                case 'end':
                    return _context14.stop();
            }
        }
    }, _marked14, this, [[0, 11]]);
}

function combinedSaga() {
    return _regenerator2.default.wrap(function combinedSaga$(_context15) {
        while (1) {
            switch (_context15.prev = _context15.next) {
                case 0:
                    _context15.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_CREATE_FORM, deliveryPatternForm), (0, _effects.takeLatest)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_CREATE_DELIVERY_FORM, createDeliveryForm), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED, cancelCreate), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_CREATE_REQUESTED, createDeliveryPattern), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_DELETE_REQUESTED, removeDeliveryPattern), (0, _effects.takeLatest)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED, searchDeliveryPatterns), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_LOAD_REQUESTED, loadDeliveryPattern), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_GO_TO_DETAILS, flowView), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY, goToCreateDelivery), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_UPDATE_REQUESTED, updateDeliveryPattern), (0, _effects.takeLatest)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_RESET_REQUESTED, resetDeliveryPattern), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_COPY_REQUESTED, duplicateDeliveryPattern), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_PRISTINE, setupConfirmLeavePopup), (0, _effects.takeEvery)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_GET_ALL_REQUESTED, getAllPatterns), (0, _effects.takeLatest)(_deliveryPattern.actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED, validatePatternTitle)]);

                case 2:
                case 'end':
                    return _context15.stop();
            }
        }
    }, _marked15, this);
}

/***/ }),

/***/ 3179:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.default = trackedItemSagas;

var _effects = __webpack_require__(54);

var _trackedItem = __webpack_require__(3180);

var trackedItemsService = _interopRequireWildcard(_trackedItem);

var _trackedItem2 = __webpack_require__(470);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(createOrUpdateItem),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(removeItem),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(list),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(trackedItemSagas);

// -- SAGAS --
function createOrUpdateItem(action) {
    var _action$payload, trackedItem, deliveryId, updated, created;

    return _regenerator2.default.wrap(function createOrUpdateItem$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _action$payload = action.payload, trackedItem = _action$payload.trackedItem, deliveryId = _action$payload.deliveryId;

                    if (!trackedItem.id) {
                        _context.next = 10;
                        break;
                    }

                    _context.next = 5;
                    return (0, _effects.call)(trackedItemsService.updateItem, trackedItem);

                case 5:
                    updated = _context.sent;
                    _context.next = 8;
                    return (0, _effects.put)((0, _trackedItem2.updatedTrackedItem)(updated));

                case 8:
                    _context.next = 15;
                    break;

                case 10:
                    _context.next = 12;
                    return (0, _effects.call)(trackedItemsService.createItem, deliveryId, trackedItem);

                case 12:
                    created = _context.sent;
                    _context.next = 15;
                    return (0, _effects.put)((0, _trackedItem2.addedTrackedItem)(created));

                case 15:
                    _context.next = 20;
                    break;

                case 17:
                    _context.prev = 17;
                    _context.t0 = _context["catch"](0);

                    /* eslint-disable no-console, angular/log */
                    console.error("Something went wrong while creating or updating tracking item...", _context.t0);
                    /* eslint-enable */

                case 20:
                case "end":
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 17]]);
}

function removeItem(action) {
    var id;
    return _regenerator2.default.wrap(function removeItem$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.prev = 0;
                    id = action.payload;
                    _context2.next = 4;
                    return (0, _effects.call)(trackedItemsService.removeItem, id);

                case 4:
                    _context2.next = 6;
                    return (0, _effects.put)((0, _trackedItem2.removedTrackedItem)(id));

                case 6:
                    _context2.next = 11;
                    break;

                case 8:
                    _context2.prev = 8;
                    _context2.t0 = _context2["catch"](0);

                    /* eslint-disable no-console, angular/log */
                    console.error("Something went wrong while removing tracking item...", _context2.t0);
                    /* eslint-enable */

                case 11:
                case "end":
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[0, 8]]);
}

function list(action) {
    var deliveryId, trackedItems;
    return _regenerator2.default.wrap(function list$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    deliveryId = action.payload;
                    _context3.next = 3;
                    return (0, _effects.call)(trackedItemsService.list, deliveryId);

                case 3:
                    trackedItems = _context3.sent;
                    _context3.next = 6;
                    return (0, _effects.put)((0, _trackedItem2.setList)(trackedItems));

                case 6:
                case "end":
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function trackedItemSagas() {
    return _regenerator2.default.wrap(function trackedItemSagas$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.all)([(0, _effects.takeEvery)(_trackedItem2.actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE, createOrUpdateItem), (0, _effects.takeEvery)(_trackedItem2.actionTypes.TRACKED_ITEM_REMOVE, removeItem), (0, _effects.takeEvery)(_trackedItem2.actionTypes.TRACKED_ITEM_FETCH_LIST, list)]);

                case 2:
                case "end":
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 318:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3180:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(6);

var _extends3 = _interopRequireDefault(_extends2);

exports.createItem = createItem;
exports.updateItem = updateItem;
exports.removeItem = removeItem;
exports.list = list;

var _http = __webpack_require__(71);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var API_URL = 'api/v1/delivery-patterns';

function createItem(deliveryId, item) {
    return (0, _http.httpPOST)(API_URL + '/' + deliveryId + '/tracked-items', (0, _extends3.default)({}, item, {
        id: null,
        type: 'delivery.TrackedItem'
    })).then(function (res) {
        return res.data;
    });
}

function updateItem(item) {
    return (0, _http.httpPUT)(API_URL + '/' + item.id, item).then(function (res) {
        return res.data;
    });
}

function removeItem(itemId) {
    return (0, _http.httpDELETE)(API_URL + '/' + itemId).then(function (res) {
        return res.data;
    });
}

function list(deliveryId) {
    return (0, _http.httpGET)(API_URL + '/' + deliveryId + '/tracked-items').then(function (res) {
        return res.data;
    });
}

/***/ }),

/***/ 3181:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.list = list;
exports.duplicate = duplicate;
exports.remove = remove;
exports.edit = edit;
exports.add = add;
exports.default = stageSagas;

var _effects = __webpack_require__(54);

var _deliveryPattern = __webpack_require__(274);

var deliveryPatternService = _interopRequireWildcard(_deliveryPattern);

var _stage = __webpack_require__(471);

var _angularAccessor = __webpack_require__(111);

var _transition = __webpack_require__(472);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(list),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(duplicate),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(remove),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(edit),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(add),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(stageSagas);

function list(action) {
    var stages;
    return _regenerator2.default.wrap(function list$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.next = 2;
                    return (0, _effects.call)(deliveryPatternService.fetchStages, action.payload);

                case 2:
                    stages = _context.sent;
                    _context.next = 5;
                    return (0, _effects.put)((0, _stage.stagesLoaded)(stages));

                case 5:
                case "end":
                    return _context.stop();
            }
        }
    }, _marked, this);
}

function duplicate(action) {
    var copied;
    return _regenerator2.default.wrap(function duplicate$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(deliveryPatternService.copyStage, action.payload);

                case 2:
                    copied = _context2.sent;
                    _context2.next = 5;
                    return (0, _effects.put)((0, _stage.stageCopied)(copied));

                case 5:
                case "end":
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function remove(action) {
    var stageId, $stateParams;
    return _regenerator2.default.wrap(function remove$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    stageId = action.payload;
                    _context3.next = 3;
                    return (0, _effects.call)(deliveryPatternService.deleteStage, stageId);

                case 3:
                    _context3.next = 5;
                    return (0, _effects.put)((0, _stage.stageDeleted)(stageId));

                case 5:
                    _context3.next = 7;
                    return (0, _effects.call)(_angularAccessor.asyncGetAngularService, '$stateParams');

                case 7:
                    $stateParams = _context3.sent;
                    _context3.next = 10;
                    return (0, _effects.put)((0, _transition.loadTransitions)($stateParams.deliveryId));

                case 10:
                case "end":
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function edit(action) {
    var _action$payload, id, title, updated;

    return _regenerator2.default.wrap(function edit$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _action$payload = action.payload, id = _action$payload.id, title = _action$payload.title;
                    _context4.next = 3;
                    return (0, _effects.call)(deliveryPatternService.updateStage, id, title);

                case 3:
                    updated = _context4.sent;
                    _context4.next = 6;
                    return (0, _effects.put)((0, _stage.stageEdited)(updated));

                case 6:
                case "end":
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

function add() {
    var $stateParams, added;
    return _regenerator2.default.wrap(function add$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.call)(_angularAccessor.asyncGetAngularService, '$stateParams');

                case 2:
                    $stateParams = _context5.sent;
                    _context5.next = 5;
                    return (0, _effects.call)(deliveryPatternService.addStage, $stateParams.deliveryId);

                case 5:
                    added = _context5.sent;
                    _context5.next = 8;
                    return (0, _effects.put)((0, _stage.stageAdded)(added));

                case 8:
                case "end":
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

function stageSagas() {
    return _regenerator2.default.wrap(function stageSagas$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.next = 2;
                    return (0, _effects.all)([(0, _effects.takeEvery)(_stage.actionTypes.STAGE_LIST_REQUESTED, list), (0, _effects.takeEvery)(_stage.actionTypes.STAGE_COPY_REQUESTED, duplicate), (0, _effects.takeEvery)(_stage.actionTypes.STAGE_DELETE_REQUESTED, remove), (0, _effects.takeEvery)(_stage.actionTypes.STAGE_EDIT_REQUESTED, edit), (0, _effects.takeEvery)(_stage.actionTypes.STAGE_ADD_REQUESTED, add)]);

                case 2:
                case "end":
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

/***/ }),

/***/ 3182:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(56);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.list = list;
exports.add = add;
exports.edit = edit;
exports.remove = remove;
exports.default = transitionSagas;

var _effects = __webpack_require__(54);

var _deliveryPattern = __webpack_require__(274);

var deliveryPatternService = _interopRequireWildcard(_deliveryPattern);

var _transition = __webpack_require__(472);

var _angularAccessor = __webpack_require__(111);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(list),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(add),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(edit),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(remove),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(transitionSagas);

function list(action) {
    var stages;
    return _regenerator2.default.wrap(function list$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.next = 2;
                    return (0, _effects.call)(deliveryPatternService.fetchTransitions, action.payload);

                case 2:
                    stages = _context.sent;
                    _context.next = 5;
                    return (0, _effects.put)((0, _transition.transitionsLoaded)(stages));

                case 5:
                case "end":
                    return _context.stop();
            }
        }
    }, _marked, this);
}

function add(action) {
    var $stateParams, added;
    return _regenerator2.default.wrap(function add$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(_angularAccessor.asyncGetAngularService, '$stateParams');

                case 2:
                    $stateParams = _context2.sent;
                    _context2.next = 5;
                    return (0, _effects.call)(deliveryPatternService.addTransition, $stateParams.deliveryId, action.payload);

                case 5:
                    added = _context2.sent;
                    _context2.next = 8;
                    return (0, _effects.put)((0, _transition.transitionAdded)(added));

                case 8:
                case "end":
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function edit(action) {
    var _action$payload, id, stageId, title, updated;

    return _regenerator2.default.wrap(function edit$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _action$payload = action.payload, id = _action$payload.id, stageId = _action$payload.stageId, title = _action$payload.title;
                    _context3.next = 3;
                    return (0, _effects.call)(deliveryPatternService.updateTransition, id, stageId, title);

                case 3:
                    updated = _context3.sent;
                    _context3.next = 6;
                    return (0, _effects.put)((0, _transition.transitionUpdated)(updated));

                case 6:
                case "end":
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function remove(action) {
    var id;
    return _regenerator2.default.wrap(function remove$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    id = action.payload;
                    _context4.next = 3;
                    return (0, _effects.call)(deliveryPatternService.deleteTransition, id);

                case 3:
                    _context4.next = 5;
                    return (0, _effects.put)((0, _transition.transitionDeleted)(id));

                case 5:
                case "end":
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

function transitionSagas() {
    return _regenerator2.default.wrap(function transitionSagas$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.all)([(0, _effects.takeEvery)(_transition.actionTypes.TRANSITION_LIST_REQUESTED, list), (0, _effects.takeEvery)(_transition.actionTypes.TRANSITION_ADD_REQUESTED, add), (0, _effects.takeEvery)(_transition.actionTypes.TRANSITION_UPDATE_REQUESTED, edit), (0, _effects.takeEvery)(_transition.actionTypes.TRANSITION_DELETE_REQUESTED, remove)]);

                case 2:
                case "end":
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

/***/ }),

/***/ 3183:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(43);

var _deliveryPatternCreateHeader = __webpack_require__(3184);

var _deliveryPatternCreateHeader2 = _interopRequireDefault(_deliveryPatternCreateHeader);

var _deliveries = __webpack_require__(212);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryPatternListHeaderPage = function (_Component) {
    (0, _inherits3.default)(DeliveryPatternListHeaderPage, _Component);

    function DeliveryPatternListHeaderPage() {
        (0, _classCallCheck3.default)(this, DeliveryPatternListHeaderPage);
        return (0, _possibleConstructorReturn3.default)(this, (DeliveryPatternListHeaderPage.__proto__ || (0, _getPrototypeOf2.default)(DeliveryPatternListHeaderPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(DeliveryPatternListHeaderPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _deliveries.store },
                _react2.default.createElement(_deliveryPatternCreateHeader2.default, null)
            );
        }
    }]);
    return DeliveryPatternListHeaderPage;
}(_react.Component);

exports.default = DeliveryPatternListHeaderPage;

/***/ }),

/***/ 3184:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(43);

var _deliveryPatternCreateHeader = __webpack_require__(3185);

var _deliveryPatternCreateHeader2 = _interopRequireDefault(_deliveryPatternCreateHeader);

var _deliveryPattern = __webpack_require__(229);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    var deliveryPatterns = state.deliveryPatterns;


    return {
        disabled: deliveryPatterns.form.pristine || !deliveryPatterns.form.valid
    };
};

var mapDispatchToProps = function mapDispatchToProps(dispatch) {
    return {
        onCancel: function onCancel() {
            return dispatch((0, _deliveryPattern.cancelCreate)());
        },
        onCreate: function onCreate() {
            return dispatch((0, _deliveryPattern.createDeliveryPattern)());
        }
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_deliveryPatternCreateHeader2.default);

/***/ }),

/***/ 3185:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(21);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(8);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(9);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(22);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _components = __webpack_require__(67);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeliveryPatternCreateHeaderComponent = function (_Com