import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {clone} from 'lodash';
import {XlReactWidgetDate, XlReactWidgetLabel, XlReactWidgetTime} from 'xl-react-components';

import './widget-datetime.less';

export class WidgetDateTime extends Component {

    static propTypes = {
        disabled: PropTypes.bool,
        metadata: PropTypes.object,
        model: PropTypes.any,
        onDatePristinityChange: PropTypes.func.isRequired,
        onModelChange: PropTypes.func.isRequired,
        onTimePristinityChange: PropTypes.func.isRequired,
        onValidityChange: PropTypes.func.isRequired,
    };

    constructor(props) {
        super(props);
        this.state = {
            datePristine: true,
            timePristine: true,
        };

        this.isDateValid = false;
        this.isTimeValid = false;
    }

    onStartDateChange = (selectedDate) => {
        const {model, onModelChange} = this.props;
        const startDate = clone(model);
        startDate.setFullYear(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate());

        if (startDate !== model) {
            onModelChange(startDate);
        }
    };

    onStartTimeChange = (selectedDate) => {
        const {model, onModelChange} = this.props;
        const startDate = clone(model);
        startDate.setHours(selectedDate.getHours(), selectedDate.getMinutes());

        if (startDate !== model) {
            onModelChange(startDate);
        }
    };

    onDatePristine = (pristine) => {
        const {onDatePristinityChange} = this.props;

        this.setState({datePristine: pristine});
        onDatePristinityChange(pristine);
    };

    onTimePristine = (pristine) => {
        const {onTimePristinityChange} = this.props;

        this.setState({timePristine: pristine});
        onTimePristinityChange(pristine);
    };

    get isFormValid() {
        return this.isDateValid && this.isTimeValid;
    }

    onTimeValidityChange = (valid) => {
        const {onValidityChange} = this.props;

        this.isTimeValid = valid;
        onValidityChange(this.isFormValid);
    };

    onDateValidityChange = (valid) => {
        const {onValidityChange} = this.props;

        this.isDateValid = valid;
        onValidityChange(this.isFormValid);
    };

    render() {
        const {disabled, model, metadata} = this.props;

        return (
            <div className='xl-react-components widget-datetime'>
                <XlReactWidgetLabel metadata={metadata}/>
                <div className='date-time-wrapper'>
                    <div className='date-time-input'>
                        <XlReactWidgetDate
                            dateFormat={metadata.dateFormat}
                            disabled={disabled}
                            model={model}
                            onModelChange={this.onStartDateChange}
                            onPristinityChange={this.onDatePristine}
                            onValidityChange={this.onDateValidityChange}/>
                        <XlReactWidgetTime
                            disabled={disabled}
                            model={model}
                            onModelChange={this.onStartTimeChange}
                            onPristinityChange={this.onTimePristine}
                            onValidityChange={this.onTimeValidityChange}/>
                    </div>
                    <div className='xl-react-components-description'>
                        <div>{metadata.description}</div>
                    </div>
                </div>
            </div>
        );
    }
}
