import React from 'react';
import PropTypes from 'prop-types';
import {components} from 'react-select';

import './widget-multiselect-modules.less';

export const DropdownIndicator = (props) => {
    return components.DropdownIndicator && (
        <components.DropdownIndicator {...props}>
            <span className="Select-arrow-zone">
                <span className="Select-arrow"></span>
            </span>
        </components.DropdownIndicator>
    );
};

export const MultiValueLabel = (props) => {
    return (
        <components.MultiValueLabel {...props}>
            {props.children},&nbsp;
        </components.MultiValueLabel>
    );
};
MultiValueLabel.propTypes = {
    children: PropTypes.any,
};

export const Menu = (props) => {
    const {onSelectAll, onClearAll} = props.selectProps;
    return (
        <components.Menu {...props}>
            {props.options.length > 0 ?
                (<div className='multiselect-menu-actions'>
                    <a onClick={onSelectAll}>Select all</a>
                    <a onClick={onClearAll}>Clear all</a>
                </div>) : null}
            {props.children}
        </components.Menu>
    );
};
Menu.propTypes = {
    children: PropTypes.any,
    options: PropTypes.any,
    selectProps: PropTypes.any,
};

export const Option = (props) => {
    return (
        <components.Option {...props}>
            {/*TODO: add checkbox*/}
            {props.children}
        </components.Option>
    );
};
Option.propTypes = {
    children: PropTypes.any
};
