angular.module("xlrelease").run(["$templateCache", function($templateCache) {$templateCache.put("static/9.0.2/partials/calendar/calendar-tooltip.html","<div class=\"calendar-tooltip\" calendar-tooltip on-show=\"loadReleaseDetails(release)\">\n    <div class=\"title\">\n        {{ release.title }}\n    </div>\n    <div class=\"main-content\">\n        <div ng-if=\"release.currentPhase && release.currentSimpleTasks.length\">\n            <p display-variables=\"release.currentPhase\" variables=\"release.variables\"></p>\n            <ul class=\"current-tasks-list\">\n                <li ng-repeat=\"currentTask in release.currentSimpleTasks\">\n                    <span>{{currentTask.title}}</span>\n                </li>\n            </ul>\n        </div>\n        <div ng-show=\"loadingDetails\" class=\"light-text mbm\">Loading dependencies...</div>\n        <div ng-if=\"releasesDependencies && getOutgoingDependencies(release.id).length\">\n            <p class=\"outgoing-header\">Depends on</p>\n            <ul class=\"outgoing-dependencies\">\n                <li ng-repeat=\"dependency in getOutgoingDependencies(release.id)\"\n                    calendar-tooltip-dependency dependency=\"dependency\" type=\"outgoing\"\n                    display-with-separators=\"/\">\n                    <span ng-if=\"isReleaseOrSubtaskFlagged(dependency)\" class=\"flagged\">\n                        <span class=\"xl-icon risk-flag-icon {{ dependency.flag.status | lowercase }}\"></span>\n                    </span>\n                    <span display-when=\"true\">{{ dependency.releaseTitle }}</span>\n                    <span display-when=\"dependency.phaseTitle\">{{ interpolate(dependency.phaseTitle, dependency.releaseId) }}</span>\n                    <span display-when=\"dependency.taskTitle\">{{ interpolate(dependency.taskTitle, dependency.releaseId)  }}</span>\n                </li>\n            </ul>\n        </div>\n        <div ng-if=\"releasesDependencies && getIncomingDependencies(release.id).length\">\n            <p class=\"incoming-header\">Depending on this release</p>\n            <ul class=\"incoming-dependencies\">\n                <li ng-repeat=\"dependency in getIncomingDependencies(release.id)\"\n                    calendar-tooltip-dependency dependency=\"dependency\" type=\"incoming\"\n                    display-with-separators=\"/\">\n                    <span ng-if=\"isReleaseOrSubtaskFlagged(dependency)\" class=\"flagged\">\n                        <span class=\"xl-icon risk-flag-icon {{ dependency.flag.status | lowercase }}\"></span>\n                    </span>\n                    <span display-when=\"true\">{{ dependency.releaseTitle }}</span>\n                    <span display-when=\"dependency.phaseTitle\">{{ interpolate(dependency.phaseTitle, dependency.releaseId) }}</span>\n                    <span display-when=\"dependency.taskTitle\">{{ interpolate(dependency.taskTitle, dependency.releaseId) }}</span>\n                </li>\n            </ul>\n        </div>\n        <div class=\"text-centered tooltip-actions\">\n            <a href=\"#/releases/{{release.id}}\" class=\"link\">View release</a> |\n            <span class=\"link download-ics\" ng-click=\"downloadCalendar(release)\">Export to calendar</span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/calendar/calendar.html","<div id=\"calendar\">\n    <div id=\"calendar-header\" class=\"header\">\n        <div class=\"filter-release filters\" ng-controller=\"FiltersController\">\n            <div id=\"current-month\">{{currentDate.toDate() | date:\'MMMM yyyy\'}}</div>\n            <input class=\"filter\" id=\"searchFilter\" type=\"search\" placeholder=\"Filter by title...\" ng-model=\"filters.title\"\n                   ng-model-options=\"{ debounce: 1200 }\">\n            <div class=\"filter\">\n                <span class=\"tags-label filter-title\">Tags</span>\n                <div class=\"transparent tags-input green-tags\" tags-input tags=\"filters.tags\" focus-on-click\n                     placeholder=\"Filter by tags...\" completion-candidates=\"allTags\"></div>\n            </div>\n            <button type=\"button\" class=\"button dropdown-button filter\" bs-popover data-content-template=\"partials/releases/filter.html\" data-placement=\"bottom\"\n                    auto-close=\"true\">Filter options\n            </button>\n            <div class=\"buttons\">\n                <div class=\"navigation\">\n                    <div class=\"button button-icon previous-month\" ng-click=\"showPreviousMonth()\"><i class=\"xl-icon chevron-left-icon\"/></div>\n                    <div class=\"button show-today\" ng-click=\"showToday()\">Today</div>\n                    <div class=\"button button-icon next-month\" ng-click=\"showNextMonth(month.fullDate)\"><i class=\"xl-icon chevron-right-icon\"/></div>\n                </div>\n            </div>\n        </div>\n        <span doc-icon=\"calendar.html\"></span>\n    </div>\n    <div id=\"calendar-content\" class=\"content\" ng-if=\"weeks.length > 0\" ng-class=\"{\'navigator-opened\': showNavigator}\" resize-days>\n        <div id=\"navigator-toggler\" ng-click=\"toggleNavigator()\" ng-class=\"{\'navigator-opened\': showNavigator}\">\n            <div class=\"arrow-container\">\n                <i class=\"xl-icon\" ng-class=\"{\'chevron-left-icon\': showNavigator, \'chevron-right-icon\': !showNavigator}\"></i>\n            </div>\n        </div>\n        <div id=\"navigator\" ng-show=\"showNavigator\">\n            <div ng-repeat=\"month in months\" class=\"month-link-container\" ng-class=\"{\'highlight\': isCurrentMonth(month)}\">\n                <div class=\"month-link\" ng-click=\"showDate(month.fullDate)\">\n                    {{month.title}} <span class=\"pull-right\" ng-if=\"month.index === 0 || $index === 0\">{{month.year}}</span>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"calendar-body\">\n            <div class=\"alert too-many-results-alert\" ng-show=\"maxLimitReached\">Some releases are not shown because the filter produced too many results. Please\n                narrow your search criteria.\n            </div>\n            <div id=\"days-name\">\n                <div ng-repeat=\"weekDay in weekDays\">{{::weekDay}}</div>\n            </div>\n            <div class=\"clearfix\"></div>\n            <div id=\"days\">\n                <div class=\"week\" ng-repeat=\"week in weeks\" adjust-week-height>\n                    <div ng-repeat=\"day in week.days\" ng-init=\"displayMonth = ($index == 0 && $parent.$index == 0) || day.date == 1\"\n                         class=\"day {{day.dateStatus}}\" tooltip=\"day.label\">\n                        <div class=\"day-header\" ng-style=\"{\'background-color\': computeDayColor(day) }\">\n                            <div class=\"context-menu-button dropdown-button pull-left\"\n                                 bs-popover data-content-template=\"partials/calendar/context-menu.html\" data-placement=\"bottom\" auto-close=\"true\">\n                                <i class=\"xl-icon options-icon\"></i>\n                            </div>\n\n                            <div class=\"pull-left\">\n                                <span ng-show=\"displayMonth\">{{day.month}}</span>\n                                <span ng-show=\"displayMonth && day.label\">|</span>\n                                <span ng-show=\"!displayMonth && !day.label\"></span>\n                                {{day.label}}\n                            </div>\n                            <div ng-click=\"openDay(day)\" class=\"pull-right day-number\">\n                                {{day.date}}\n                            </div>\n                        </div>\n                        <div class=\"day-content\" ng-style=\"{\'background-color\': computeDayColor(day) }\"></div>\n                        <div ng-if=\"day.dateStatus === \'today\'\" class=\"time-indicator\" position-current-time></div>\n                    </div>\n                    <span ng-repeat=\"blackout in week.blackouts\" position-blackout=\"blackout-{{blackout.name}}\" class=\"blackout blackout-{{blackout.name}}\">\n                    <span class=\"blackout-header\" bs-popover\n                          template=\"<calendar-blackout-tooltip blackout=\'blackout\' on-delete=\'deleteBlackout(blackout);\' on-change=\'refreshBlackouts();\'></calendar-blackout-tooltip>\"\n                          container=\"body\" data-placement=\"top\" auto-close=\"true\" tooltip=\"blackout.label\">\n                        <span class=\"blackout-label\">\n                            <i class=\"xl-icon circle-minus-icon\"></i><span>{{::blackout.label}}</span>\n                        </span>\n                    </span>\n                </span>\n\n                    <span ng-repeat=\"release in week.releases\" position-release=\"{{ release.id }}\"\n                          class=\"release {{ release.status | lowercase}} {{ release.id }} {{ release.flag.status | lowercase }}\">\n                    <span display-release-title release=\"release\"></span>\n\n                    <div class=\"tooltip\">\n                        <div ng-include=\"\'partials/calendar/calendar-tooltip.html\'\"></div>\n                    </div>\n                </span>\n                    <span ng-repeat=\"release in week.releases\">\n                    <span ng-repeat=\"phase in release.displayablePhases\" position-phase=\"{{ phase.id }}\" class=\"phase {{phase.id}}\"\n                          ng-style=\"{\'background-color\': computePhaseColor(release, phase)}\"></span>\n                </span>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/calendar/context-menu.html","<xlr-context-menu id=\"context-menu-container\" items=\"menuOptions\" ng-init=\"menuOptions = getContextMenuOptions(day)\"></xlr-context-menu>");
$templateCache.put("static/9.0.2/partials/calendar/release-title.html","<span class=\"title\">\n    <span ng-if=\"isReleaseOrSubtaskFlagged(release)\">\n        <span class=\"xl-icon risk-flag-icon {{ release.flag.status | lowercase }}\"></span>\n    </span>\n    {{ release.title }}\n</span>\n");
$templateCache.put("static/9.0.2/partials/colorpicker/main.html","<span>\n    <span class=\"toggle-picker\"\n         ng-style=\"{ \'background-color\': currentColor }\" ng-hide=\"inline\">\n    </span>\n    <span class=\"simplecolorpicker colors\">\n        <div ng-repeat=\"color in colors\"\n             color-picker-swatch cp-current-color=\"currentColor\" cp-color=\"color\"\n             class=\"button\">\n        </div>\n    </span>\n</span>\n");
$templateCache.put("static/9.0.2/partials/colorpicker/swatch.html","<div title=\"{{color.name}}\"\n     ng-style=\"{ \'background-color\': \'{{color.value || \'#ffffff\'}}\' }\"\n     role=\"button\" tabindex=\"0\"\n     ng-class=\"currentColor == color.value && \'selected\' || \'\'\"\n     ng-click=\"clicked()\">\n</div>\n");
$templateCache.put("static/9.0.2/partials/configuration/configuration.html","<div>\n    <div class=\"global-configuration-details\">\n        <configuration-page folder=\"$detailCtrl.folder\"/>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/configuration/delete-instance-error-modal.html","<div class=\"modal-content modal-error\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Error</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>This configuration instance can not be deleted because it is still referenced.</p>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/attachments-list.html","<table class=\"attachments table table-rounded table-striped\" ng-if=\"attachments.length > 0\">\n    <tbody>\n        <tr ng-repeat=\"attachment in attachments | orderBy:\'-filename\'\">\n            <td class=\"filename title-column\">\n                <a class=\"filelink\" ng-click=\"downloadAttachment(attachment)\">\n                    {{ attachment.filename }}\n                </a>\n                <span class=\"delete pull-right\" ng-click=\"attachment.confirmDelete = true\" ng-if=\"!readonly() && canDeleteAttachments() && !attachment.confirmDelete\">\n                    <i class=\"xl-icon close-icon icon-s\"/>\n                </span>\n\n                <div class=\"confirm\" ng-if=\"!readonly() && canDeleteAttachments() && attachment.confirmDelete\">\n                    Remove this file?&nbsp;\n                    <a class=\"confirmDelete\" ng-click=\"deleteAttachment({attachment: attachment})\">Remove</a>\n                    &middot;\n                    <a class=\"cancelDelete\" ng-click=\"attachment.confirmDelete = false\">Cancel</a>\n                </div>\n            </td>\n        </tr>\n    </tbody>\n</table>\n<div ng-if=\"!readonly()\"\n     upload auto\n     upload-url=\"uploadUrl\"\n     on-success=\"attachmentAdded(uploadResult)\"\n     ng-controller=\"UploadController\"\n        >\n    <input type=\"file\" ng-model=\"file\" file-input ng-disabled=\"creationInProgress\">\n    <span class=\"error\" ng-show=\"UploadService.data.error\">An upload error occurred : {{UploadService.data.errorMessage}}</span>\n    <img class=\"load-attachment\" src=\"static/9.0.2/styles/img/ajax-loader.gif\" ng-show=\"UploadService.data.loading\"/>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/date-editor.html","<span date-time-picker date=\"ngModel\" date-format=\"{{dateFormat}}\" class=\"date-editor\" ng-class=\"{readonly: readonly()}\">\n    <span class=\"date date-picker-holder\">\n        <span ng-hide=\"displayedDate()\" class=\"light-text date-placeholder\">\n            <span ng-if=\"!placeholder\">Set date</span>\n            <span ng-if=\"placeholder\">{{ placeholder }}</span>\n        </span>\n        <input ng-show=\"displayedDate()\" readonly type=\"text\" value=\"{{ displayedDate()| toDate |date:\'shortDate\' }}\" ng-class=\"{\'light-text\': hasNoDate()}\"/>\n    </span>\n\n    <span class=\"time bootstrap-timepicker\" ng-show=\"displayedDate()\">\n        <span class=\"time-picker-holder\">\n            <input readonly type=\"text\" value=\"{{ displayedDate() | toDate | date:\'shortTime\' }}\" ng-class=\"{\'light-text\': hasNoDate()}\"/>\n        </span>\n    </span>\n\n    <span ng-if=\"deletable() && ngModel && !readonly()\" class=\"remove\" ng-click=\"deleteDate()\"><i class=\'xl-icon close-icon icon-s\'></i></span>\n </span>\n");
$templateCache.put("static/9.0.2/partials/directives/dip-control.html","<div ng-hide=\"property.hidden\" ng-switch on=\"property.kind\" class=\"dip-control form-group\">\n    <label ng-class=\"{\'col-sm-5\': large, \'col-sm-3\': !large}\" class=\"control-label\" for=\"{{ property.name }}\">{{ property.label }} <span\n            ng-if=\"property.required\" id=\"{{ property.name }}-required\" class=\"error\">*</span></label>\n    <div ng-class=\"{\'col-sm-7\': large, \'col-sm-9\': !large}\">\n        <div>\n            <div ng-switch-when=\"STRING\">\n                <input ng-if=\"!property.password && property.size !== \'LARGE\'\" type=\"text\" id=\"{{ property.name }}\" ng-model=\"container[property.name]\" name=\"{{ property.name }}\"\n                       ng-required=\"property.required\" class=\"input-block-level\" autocomplete=\"off\" data-ng-disabled=\"readonly\">\n                <textarea ng-if=\"!property.password && property.size === \'LARGE\'\" id=\"{{ property.name }}\" ng-model=\"container[property.name]\"\n                          name=\"{{ property.name }}\" rows=\"4\" ng-required=\"property.required\" class=\"input-block-level\" autocomplete=\"off\" data-ng-disabled=\"readonly\"></textarea>\n                <input ng-if=\"property.password\" type=\"password\" id=\"{{ property.name }}\" ng-model=\"container[property.name]\" name=\"{{ property.name }}\"\n                       ng-required=\"property.required\" class=\"input-block-level\" autocomplete=\"new-password\" data-ng-disabled=\"readonly\">\n            </div>\n\n            <input type=\"checkbox\"\n                   id=\"{{ property.name }}\"\n                   class=\"input-block-level\"\n                   name=\"{{ property.name }}\"\n                   ng-switch-when=\"BOOLEAN\"\n                   ng-model=\"container[property.name]\"\n                   data-ng-disabled=\"readonly\"\n                   ng-required=\"property.required\">\n\n            <input type=\"number\"\n                   id=\"{{ property.name }}\"\n                   class=\"input-block-level\"\n                   name=\"{{ property.name }}\"\n                   ng-switch-when=\"INTEGER\"\n                   ng-model=\"container[property.name]\"\n                   data-ng-disabled=\"readonly\"\n                   ng-required=\"property.required\">\n\n            <div ng-switch-when=\"ENUM\">\n                <div ng-if=\"!readonly\"\n                     inline-select-editor\n                     select-options=\"enumItems\"\n                     placeholder=\"Select a value\"\n                     name=\"{{ property.name }}\"\n                     model=\"container[property.name]\"\n                     id=\"{{ property.name }}\"\n                     class=\"field\"\n                     ng-required=\"property.required\">\n                    {{ container[property.name] }}\n                </div>\n                <input ng-if=\"readonly\" type=\"text\" data-ng-value=\"container[property.name]\" class=\"input-block-level\" disabled/>\n            </div>\n\n            <div ng-switch-when=\"CI\" ng-if=\"ConfigurationInstances.loaded()\">\n                <div xl-widget-autocomplete\n                     id=\"{{ property.name }}\"\n                     class=\"field\"\n                     ng-model=\"value\"\n                     name=\"{{ property.name }}\"\n                     handlers=\"ciHandlers\"\n                     metadata=\"{name: property.name}\"\n                     show-all-on-click=\"true\"\n                     open-on-click=\"true\"\n                     is-required=\"property.required\"\n                     obj-label=\"title\"\n                     is-disabled=\"readonly\"></div>\n            </div>\n\n            <div ng-switch-when=\"SET_OF_STRING\">\n                <div xl-dip-set\n                     class=\"field\"\n                     name=\"{{ property.name }}\"\n                     ng-model=\"container[property.name]\"\n                     metadata=\"{name: property.name, required: property.required }\"\n                     read-only=\"readonly\">\n                </div>\n            </div>\n            <div ng-switch-when=\"LIST_OF_STRING\">\n                <div xl-dip-list\n                     class=\"field\"\n                     name=\"{{ property.name }}\"\n                     ng-model=\"container[property.name]\"\n                     metadata=\"{name: property.name, required: property.required }\"\n                     read-only=\"readonly\">\n                </div>\n            </div>\n            <div ng-switch-when=\"MAP_STRING_STRING\">\n                <span ng-if=\"!property.password\">\n                    <div xl-dip-map-string-string\n                         class=\"field\"\n                         ng-model=\"container[property.name]\"\n                         name=\"{{ property.name} }\"\n                         read-only=\"readonly\"\n                         metadata=\"{name: property.name, required: property.required, minVisibleRow: 5}\"\n                         open-on-click=\"true\">\n                    </div>\n                </span>\n            </div>\n        </div>\n        <div ng-if=\"!readonly\">\n            <div class=\"description\" ng-if=\"property.label != property.description && !isError(form[property.name])\">{{ ::property.description }}</div>\n            <div class=\"field-errors\" ng-if=\"isError(form[property.name])\">\n                <span ng-if=\"form[property.name].$error.required\">{{ ::property.label }} is mandatory</span>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/duration-editor-fields.html","<table>\n    <tbody>\n        <tr>\n            <td>\n                <input type=\"text\" class=\"days\"\n                       ng-model=\"durationData.days\" ng-required=\"true\"\n                       ng-keydown=\"keyDown($event)\" ng-keypress=\"keyPress($event)\"/>\n            </td>\n            <td class=\"duration-label\">days</td>\n            <td>\n                <input type=\"text\" class=\"hours\"\n                       ng-model=\"durationData.hours\" ng-required=\"true\"\n                       ng-keydown=\"keyDown($event)\" ng-keypress=\"keyPress($event)\"/>\n            </td>\n            <td class=\"duration-label\">hours</td>\n            <td>\n                <input type=\"text\" class=\"minutes\"\n                       ng-model=\"durationData.minutes\" ng-required=\"true\"\n                       ng-keydown=\"keyDown($event)\" ng-keypress=\"keyPress($event)\"/>\n            </td>\n            <td class=\"duration-label\">mins</td>\n        </tr>\n    </tbody>\n</table>\n");
$templateCache.put("static/9.0.2/partials/directives/duration-editor.html","<span class=\"pull-right remove-duration\" ng-click=\"removeDuration()\" ng-if=\"hasDuration(duration) && editable()\"><i class=\'xl-icon close-icon icon-s\'></i></span>\n<div class=\"duration-editor\" ng-class=\"{\'editable\': editable()}\" ng-click=\"showDurationPicker()\">\n    <span class=\"duration placeholder\" ng-if=\"!hasDuration(duration) || !editable()\" ng-class=\"{\'done\': done()}\">\n        {{inferredDuration()  | prettyDuration}}\n    </span>\n    <span class=\"duration\" ng-click=\"showDurationPicker()\" ng-if=\"hasDuration(duration) && editable()\">{{duration | prettyDuration}}</span>\n</div>");
$templateCache.put("static/9.0.2/partials/directives/filter-tag-input.html","<ul class=\"tags\" ng-class=\"{\'tags-read-only\': readOnly}\">\n    <li class=\"tag-new\" ng-hide=\"readOnly\" ng-if=\"prepend\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{::placeholder}}\"/>\n    </li>\n    <li ng-repeat=\"tag in tags\" class=\"tag\" ng-class=\"{\'tag-read-only\': readOnly, \'tag-without-title\': !tag.title}\">\n        <span class=\"tag-label\">\n            <span ng-if=\"!tag.title\" tooltip-position=\"bottom\"\n                  tooltip=\"\'You do not have the permissions required to view all filters on this tile, only partial data is available\'\">\n                N/A\n            </span>\n            <span ng-if=\"tag.title\" title=\"{{::tag.title}}\">{{::tag.title}}</span>\n        </span>\n        <a class=\"tag-close\" ng-hide=\"readOnly\" ng-click=\"remove(tag)\">\n            <i class=\'xl-icon close-icon icon-s\'></i>\n        </a>\n    </li>\n    <li class=\"tag-new\" ng-hide=\"readOnly\" ng-if=\"!prepend\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{::placeholder}}\"/>\n    </li>\n</ul>\n");
$templateCache.put("static/9.0.2/partials/directives/grid-date-editor.html","<div date-time-picker date=\"date\" class=\"date-editor\">\n    <span class=\"date date-picker-holder col-sm-12\">\n        <div class=\"left-inner-addon\">\n            <i class=\"xl-icon calendar-icon\"></i>\n            <input ng-if=\"date\" type=\"text\" class=\"ui-grid-filter-input\" ng-attr-placeholder=\"{{placeholder || \'\'}}\" readonly\n                   value=\"{{date | toDate | date:\'shortDate\' }}\" />\n            <input ng-if=\"!date\" type=\"text\" class=\"ui-grid-filter-input\" ng-attr-placeholder=\"{{placeholder || \'\'}}\" readonly value=\"\" />\n        </div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/members-input.html","<ul class=\"tags\" ng-class=\"{\'tags-read-only\': readOnly}\">\n    <li ng-repeat=\"tag in tags\" class=\"tag\" ng-class=\"tag.type | lowercase\">\n        <span class=\"xl-icon tag-icon\"></span>\n        <span class=\"tag-label\" display-member=\"tag\"></span>\n        <a class=\"tag-close\" ng-hide=\"readOnly\" ng-click=\"remove(tag)\">\n            <i class=\'xl-icon close-icon icon-s\'></i>\n        </a>\n    </li>\n    <li class=\"tag-new\" ng-hide=\"readOnly\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{ placeholder }}\"/>\n    </li>\n</ul>\n");
$templateCache.put("static/9.0.2/partials/directives/modal-date-editor.html","<div ng-show=\"!readonly()\">\n    <div ng-show=\"dateModel\" class=\"pull-right remove-date\" ng-click=\"removeDate()\"><i class=\'xl-icon close-icon\'></i></div>\n    <div class=\"date-editor\" date-time-picker date=\"dateModel\">\n        <div class=\"modal-section\">{{dateTitle}}</div>\n        <div class=\"date\">\n            <div ng-class=\"{\'placeholder\': dateModel == undefined}\" time-zone-tooltip ng-include=\"\'partials/directives/modal-date-fields.html\'\">\n            </div>\n        </div>\n        <a class=\"date-picker-holder\"></a>\n\n        <div class=\"time bootstrap-timepicker\" time-zone-tooltip>\n            <i class=\"time-icon\"></i>\n            <span class=\"time-picker-holder\">\n                <input readonly=\"readonly\" type=\"text\" ng-class=\"{placeholder: !dateModel}\" value=\"{{ displayedDate() | toDate | date:\'shortTime\' }}\"/>\n            </span>\n        </div>\n\n    </div>\n</div>\n<div ng-show=\"readonly()\" class=\"date-editor\">\n    <div class=\"modal-section\">{{dateTitle}}</div>\n    <div class=\"date-readonly\" ng-class=\"{\'placeholder\': dateModel == undefined}\">\n        <div ng-include=\"\'partials/directives/modal-date-fields.html\'\">\n        </div>\n    </div>\n\n    <div class=\"time-readonly\">\n        <div>\n            <span time-zone-tooltip ng-class=\"{\'placeholder\': dateModel == undefined}\">\n                <i class=\"time-icon\"></i>\n                {{displayedDate() | toDate | date:\'shortTime\'}}\n            </span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/modal-date-fields.html","<div class=\"day\">{{displayedDate() | toDate | date:\'dd\'}}</div>\n<div class=\"date-detail\" time-zone-tooltip>\n    {{displayedDate() | toDate | date:\'MMMM yyyy\'}}<br/>\n    {{displayedDate() | toDate | date:\'EEEE\'}}\n</div>\n<div class=\"clearfix\"></div>");
$templateCache.put("static/9.0.2/partials/directives/pagination.html","<div id=\"cisLoader\" ng-show=\"ciLoader\">\n    <div ng-show=\"ciLoader.isLoading()\">\n        <img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n    </div>\n    <div ng-show=\"!ciLoader.isLoading()\">\n        <button type=\"button\" class=\"button\" ng-show=\"ciLoader.hasMoreCis()\" ng-click=\"ciLoader.loadNextCis()\">Show more</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/tags-input.html","<ul class=\"tags\" ng-class=\"{\'tags-read-only\': readOnly}\">\n    <li ng-repeat=\"tag in tags\" class=\"tag\" ng-class=\"{\'tag-read-only\': readOnly}\">\n        <span class=\"xl-icon tag-icon\"></span>\n        <span ng-if=\"!variables\" class=\"tag-label\" title=\"{{ tag }}\">{{ tag }}</span>\n        <span ng-if=\"variables\" class=\"tag-label\" display-variables=\"tag\" variables=\"variables\" title=\"{{ tag }}\"></span>\n        <a class=\"tag-close\" ng-hide=\"readOnly\" ng-click=\"remove(tag)\">\n            <i class=\'xl-icon close-icon icon-s\'></i>\n        </a>\n    </li>\n    <li class=\"tag-new\" ng-hide=\"readOnly\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{ placeholder }}\"/>\n    </li>\n</ul>\n");
$templateCache.put("static/9.0.2/partials/directives/users-input.html","<ul class=\"tags\">\n    <li ng-repeat=\"tag in tags\" class=\"tag\">\n        <span class=\"xl-icon tag-icon principal\"></span>\n        <span class=\"tag-label\" display-user=\"tag\"></span>\n        <a class=\"tag-close\" ng-hide=\"readOnly\" ng-click=\"remove(tag)\">\n            <i class=\'xl-icon close-icon icon-s\'></i>\n        </a>\n    </li>\n    <li class=\"tag-new\" ng-hide=\"readOnly\">\n        <input class=\"tag-input\" type=\"text\" ng-model=\"newTag\" placeholder=\"{{ placeholder }}\"/>\n    </li>\n</ul>\n");
$templateCache.put("static/9.0.2/partials/directives/xlr-dip-of-inline-with-variables.html","<div ng-repeat=\"p in xlrDipCtrl.propertyDefinitions\" ng-switch on=\"p.kind\" class=\"form-group\"\n     data-ng-if=\"xlrDipCtrl.IGNORE_SCRIPT_VARIABLE_INTERPOLATION !== p.name\">\n\n    <label class=\"col-xs-3 control-label\" for=\"{{ p.name }}\">\n        {{ p.label }}\n        <span ng-if=\"p.required && xlrDipCtrl.showRequiredSign\" id=\"{{ p.name }}-required\" class=\"error\">*</span>\n    </label>\n\n    <div class=\"col-xs-9\" id=\"{{ p.name }}\">\n\n        <div ng-switch-when=\"STRING\">\n            <div ng-if=\"!p.password && xlrDipCtrl.showVariableSelectorForText\"\n                 xlr-inline-text-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\">\n            </div>\n            <span ng-if=\"!p.password && !xlrDipCtrl.showVariableSelectorForText\">\n                <span ng-if=\"!xlrDipCtrl.readOnly\">\n                    <span inline-text-editor\n                          class=\"field\"\n                          ng-if=\"p.size != \'LARGE\'\"\n                          model=\"xlrDipCtrl.propertyValues[p.name]\"\n                          on-change=\"xlrDipCtrl.onChange()\"\n                          name=\"{{::p.name}}\">\n                        <span display-variables=\"xlrDipCtrl.propertyValues[p.name]\" variables=\"xlrDipCtrl.variables\"></span>\n                    </span>\n                    <span inline-textarea-editor\n                          class=\"field\"\n                          ng-if=\"p.size == \'LARGE\'\"\n                          model=\"xlrDipCtrl.propertyValues[p.name]\"\n                          on-change=\"xlrDipCtrl.onChange()\"\n                          name=\"{{::p.name}}\">\n                        <span data-ng-if=\"!xlrDipCtrl.ignoreVariableInterpolation(p.name)\"\n                              display-variables=\"xlrDipCtrl.propertyValues[p.name]\"\n                              variables=\"xlrDipCtrl.variables\" keep-new-lines></span>\n                        <span data-ng-if=\"xlrDipCtrl.ignoreVariableInterpolation(p.name)\"\n                              data-ng-bind-html=\"xlrDipCtrl.newlinesFilter(xlrDipCtrl.propertyValues[p.name])\"></span>\n                    </span>\n                </span>\n                <span ng-if=\"xlrDipCtrl.readOnly\" class=\"field-readonly read-only\">\n                    <span data-ng-if=\"!xlrDipCtrl.ignoreVariableInterpolation(p.name)\"\n                          display-variables=\"xlrDipCtrl.propertyValues[p.name]\"\n                          variables=\"xlrDipCtrl.variables\" keep-new-lines></span>\n                    <span data-ng-if=\"xlrDipCtrl.ignoreVariableInterpolation(p.name)\"\n                          data-ng-bind-html=\"xlrDipCtrl.newlinesFilter(xlrDipCtrl.propertyValues[p.name])\"></span>\n                </span>\n            </span>\n\n            <div data-ng-if=\"xlrDipCtrl.hasIgnoreScriptProperty(p.name)\">\n                Ignore variable interpolation <input type=\"checkbox\" id=\"ignoreScriptVariableInterpolation\"\n                                                     data-ng-model=\"xlrDipCtrl.propertyValues[xlrDipCtrl.IGNORE_SCRIPT_VARIABLE_INTERPOLATION].value\"\n                                                     data-ng-change=\"xlrDipCtrl.updateIgnoreVariableInterpolation()\"\n                                                     data-ng-disabled=\"xlrDipCtrl.readOnly\" title=\"Ignore variable interpolation\">\n            </div>\n\n            <span ng-if=\"p.password\">\n                <div xlr-inline-password-with-variables\n                     name=\"p.name\"\n                     model=\"xlrDipCtrl.propertyValues[p.name]\"\n                     on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                     on-change=\"xlrDipCtrl.onChange()\"\n                     variables=\"xlrDipCtrl.variables\"\n                     read-only=\"xlrDipCtrl.readOnly\"\n                     enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n            </span>\n        </div>\n\n        <div ng-switch-when=\"INTEGER\">\n            <div xlr-integer-with-variables\n                 class=\"field\"\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\">\n            </div>\n        </div>\n\n        <div ng-switch-when=\"BOOLEAN\">\n            <div xlr-boolean-with-variables\n                 class=\"field\"\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 variables=\"xlrDipCtrl.variables\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n\n        <div ng-switch-when=\"DATE\">\n            <div xlr-date-with-variables\n                 class=\"field\"\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 variables=\"xlrDipCtrl.variables\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\">\n            </div>\n        </div>\n\n        <span ng-switch-when=\"CI\" ng-if=\"xlrDipCtrl.ConfigurationInstances.loaded()\">\n            <div inline-select-editor\n                 ng-if=\"!xlrDipCtrl.readOnly\"\n                 name=\"{{::p.name}}\"\n                 select-options=\"xlrDipCtrl.selectOptions(p)\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-change=\"xlrDipCtrl.onChange();\"\n                 class=\"field\">\n                {{ xlrDipCtrl.ConfigurationInstances.getTitle(xlrDipCtrl.propertyValues[p.name]) }}\n            </div>\n            <span ng-if=\"xlrDipCtrl.readOnly\" class=\"field-readonly\">\n                {{ xlrDipCtrl.ConfigurationInstances.getTitle(xlrDipCtrl.propertyValues[p.name]) }}\n            </span>\n        </span>\n\n        <div ng-switch-when=\"LIST_OF_STRING\">\n            <div xlr-list-of-strings-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n        <div ng-switch-when=\"SET_OF_STRING\">\n            <div xlr-set-of-strings-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n        <div ng-switch-when=\"MAP_STRING_STRING\">\n            <div xlr-map-string-string-with-variables\n                 name=\"p.name\"\n                 model=\"xlrDipCtrl.propertyValues[p.name]\"\n                 on-new=\"xlrDipCtrl.onNewVariablePF(name, variableType, createdCallback)\"\n                 on-change=\"xlrDipCtrl.onChange()\"\n                 variables=\"xlrDipCtrl.variables\"\n                 read-only=\"xlrDipCtrl.readOnly\"\n                 enforce-mode=\"xlrDipCtrl.enforceMode\"></div>\n        </div>\n\n        <div ng-switch-when=\"ENUM\">\n            <span ng-if=\"!xlrDipCtrl.readOnly\">\n                <div inline-select-editor\n                     select-options=\"p.enumValues\"\n                     placeholder=\"Select a value\"\n                     name=\"{{p.name}}\"\n                     model=\"xlrDipCtrl.propertyValues[p.name].value\"\n                     id=\"{{p.name}}\"\n                     class=\"field\"\n                     on-change=\"xlrDipCtrl.onChange()\"\n                     ng-required=\"{{p.required}}\">\n                    {{ xlrDipCtrl.propertyValues[p.name].value }}\n                </div>\n            </span>\n            <span ng-if=\"xlrDipCtrl.readOnly\" class=\"field-readonly read-only\">\n                <span display-variables=\"xlrDipCtrl.propertyValues[p.name].value\" variables=\"xlrDipCtrl.variables\" keep-new-lines></span>\n            </span>\n        </div>\n\n        <div class=\"description\" ng-if=\"p.description != p.label\">{{ ::p.description }}</div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/xlr-template-from-value-or-variable-selector.html","<div class=\"variable-selector\">\n    <span class=\"variable-toggle\" ng-click=\"vm.toggleMode();\" ng-if=\"vm.showToggle == true && !vm.readOnly\">\n        <button class=\"button primary\"\n                ng-if=\"vm.variableMode\"\n                tooltip=\"\'Switch to manual entry\'\"\n                tooltip-position=\"bottom\">\n            ${\n        </button>\n        <button class=\"button\"\n                ng-if=\"!vm.variableMode\"\n                tooltip=\"\'Switch to variable\'\"\n                tooltip-position=\"bottom\">\n            ${\n        </button>\n    </span>\n    <span class=\"variable-dropdown\" ng-if=\"vm.variableMode\">\n        <span ng-if=\"vm.variableMode && vm.readOnly\" class=\"field-readonly read-only\" name=\"{{::vm.name}}\">\n            <span>{{ vm.draft.variable.displayName }}</span>\n         </span>\n        <div ng-if=\"vm.variableMode && !vm.readOnly\"\n             xl-widget-autocomplete\n             ng-model=\"vm.draft.variable\"\n             handlers=\"vm.handlers\"\n             options=\"{placeholder : \'Please select a variable of type \' + vm.variableTypeName}\"\n             obj-label=\"displayName\"\n             show-all-on-click=\"true\"\n             new-item-suffix=\"{{\'<i> &ndash; Create a new variable of type \' + vm.variableTypeName + \'</i>\'}}\"\n             auto-select-on-exact-match=\"false\"\n             ng-required=\"!!vm.options.required\"\n             open-on-click=\"true\"></div>\n    </span>\n    <span class=\"editor\" ng-if=\"!vm.variableMode\">\n        <span ng-if=\"!vm.variableMode && vm.readOnly\" class=\"field-readonly read-only\" name=\"{{::vm.name}}\">\n            <span>{{ vm.model.value.title }}</span>\n         </span>\n        <div ng-if=\"!vm.variableMode && !vm.readOnly\"\n             xl-widget-autocomplete\n             ng-model=\"vm.model.value\"\n             obj-label=\"title\"\n             showAllOnClick=\"true\"\n             handlers=\"vm.options.handlers\"\n             is-required=\"!!vm.options.required\"\n             is-disabled=\"vm.readOnly\"\n             options=\"{placeholder: vm.options.placeholder}\"\n             show-all-on-click=\"true\"\n             open-on-click=\"true\"\n             no-focus=\"true\"\n        ></div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/filters/from-to-date-filters.html","<div class=\"from-to-date-filters\">\n    <div class=\"date-filter from-date\">\n        <b>From:</b>\n        <div date-editor ng-model=\"filters.from\" deletable=\"true\" class=\"date-filter_date\"></div>\n    </div>\n    <div class=\"date-filter to-date\">\n        <b>To:</b>\n        <div date-editor ng-model=\"filters.to\" deletable=\"true\" class=\"date-filter_date\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/filters/time-filters.html","<div class=\"btn-group time-frame\">\n    <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_MONTH\'\" ng-class=\"{active: filters.timeFrame == \'LAST_MONTH\'}\">Last 30 days</button>\n    <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_THREE_MONTHS\'\" ng-class=\"{active: filters.timeFrame == \'LAST_THREE_MONTHS\'}\">Last 3 months</button>\n    <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_SIX_MONTHS\'\" ng-class=\"{active: filters.timeFrame == \'LAST_SIX_MONTHS\'}\">Last 6 months</button>\n    <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'LAST_YEAR\'\" ng-class=\"{active: filters.timeFrame == \'LAST_YEAR\'}\">Last year</button>\n    <button type=\"button\" class=\"btn\" ng-click=\"filters.timeFrame = \'RANGE\'\" ng-class=\"{active: filters.timeFrame == \'ALL_TIME\' || filters.timeFrame == \'RANGE\'}\">Range</button>\n</div>\n<div class=\"dates\" ng-if=\"filters.timeFrame == \'ALL_TIME\' || filters.timeFrame == \'RANGE\'\">\n    <div ng-include=\"\'partials/filters/from-to-date-filters.html\'\"></div>\n</div>");
$templateCache.put("static/9.0.2/partials/flags/delayed-line-directive.html","<div class=\"delayed-line\">\n    <span class=\"warning-padding\">\n        <span class=\"warning-icon icon\"></span>\n        <span>Task {{ task.title }} is delayed</span>\n        <span ng-transclude></span>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/flags/flag-line-directive.html","<div ng-show=\"isItemFlagged(item)\" class=\"flag-line {{ item.flag.status | lowercase }}\">\n    <span class=\"xl-icon risk-flag-icon {{ item.flag.status | lowercase }} icon-l\"></span>\n    <span ng-if=\"item.flag.comment.length\">{{item.flag.comment}}</span>\n    <span ng-if=\"!item.flag.comment.length && isFlaggedAttentionNeeded(item)\">Attention needed</span>\n    <span ng-if=\"!item.flag.comment.length && isFlaggedAtRisk(item)\">At risk</span>\n    <span ng-transclude></span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/flags/flag-picker.html","<div class=\"flag-picker-popover\">\n    <div class=\"ok\" ng-click=\"flag(\'OK\')\" hide-popover-on-click title=\"Disable status flag\"><i class=\"xl-icon flag-none-icon\"/></div>\n    <div class=\"attention_needed\" ng-click=\"flag(\'ATTENTION_NEEDED\')\" hide-popover-on-click title=\"Set status to attention needed\"><i class=\"xl-icon flag-attention-icon\"/></div>\n    <div class=\"at_risk\" ng-click=\"flag(\'AT_RISK\')\" hide-popover-on-click title=\"Set status to at risk\"><i class=\"xl-icon flag-risk-icon\"/></div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/flags/other-alerts.html","<span ng-if=\"releasesAlerts[release.id].totalAlerts > 1\">\n    |\n    <a ng-href=\"#/releases/{{release.id}}/summary\" class=\"link\" stop-click-propagation>\n        See all alerts\n    </a>\n</span>\n");
$templateCache.put("static/9.0.2/partials/folders/context-menu.html","<xlr-context-menu id=\"context-menu-container\" items=\"grid.options.contextMenuItems\"></xlr-context-menu>");
$templateCache.put("static/9.0.2/partials/folders/folder-configuration.html","<div class=\"folder-permissions\">\n    <div class=\"configuration-details\">\n        <configuration-page folder=\"$detailCtrl.folder\"/>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/folders/folder-dashboards.html","<folder-dashboard-list\n        folder=\"$detailCtrl.folder\"\n        filters=\"$detailCtrl.filters\">\n</folder-dashboard-list>");
$templateCache.put("static/9.0.2/partials/folders/folder-groups.html","<folder-groups-list\n    folder=\"$detailCtrl.folder\"\n    filters=\"$detailCtrl.filters\">\n</folder-groups-list>\n");
$templateCache.put("static/9.0.2/partials/folders/folder-permissions.html","<folder-permissions-table folder=\"$detailCtrl.folder\"/>");
$templateCache.put("static/9.0.2/partials/folders/folder-releases.html","<folder-release-list folder=\"$detailCtrl.folder\" filters=\"$detailCtrl.filters\"></folder-release-list>\n");
$templateCache.put("static/9.0.2/partials/folders/folder-templates.html","<folder-template-page folder=\"$detailCtrl.folder\"></folder-template-page>\n");
$templateCache.put("static/9.0.2/partials/folders/folder-variables.html","<folder-variable-list\n        id=\"folder-variables\"\n        folder=\"$detailCtrl.folder\"\n        filters=\"$detailCtrl.filters\">\n</folder-variable-list>\n");
$templateCache.put("static/9.0.2/partials/index/main-menu-extension-container.html","<div class=\"content\">\n    <h4 ng-if=\"vm.menuExtension && !vm.menuExtension.uri\">\n        No <strong>uri</strong> parameter specified in menu item \"{{ vm.menuExtension.label }}\". Please check your plugin.\n    </h4>\n    <div ng-if=\"vm.menuExtension.uri\" ng-include=\"\'static/9.0.2/\' + vm.menuExtension.uri\"></div>\n</div>");
$templateCache.put("static/9.0.2/partials/inline-editor/code-editor.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display inline-textarea display-edit-mode\" ng-hide=\"editMode || hasText(model)\">\n    <span class=\"text placeholder light-text\">{{placeholder}}</span>\n    <i class=\"xl-icon edit-icon\"></i>\n</div>\n<div class=\"code-inline-textarea edit inline-textarea\" ng-show=\"editMode || hasText(model)\">\n    <textarea ng-hide=\"true\" class=\"editable\" name=\"{{name}}\" ng-model=\"draft\" ng-required=\"isRequired\"></textarea>\n    <div class=\"ace-script-editor-container\">\n        <div class=\"ace-script-editor\" ng-class=\"{\'display-edit-mode\': !editMode && !readOnlyMode}\">\n            <div class=\"ace-script-editor-placeholder\" ng-click=\"aceToggleFullScreenMode($event)\"></div>\n            <div class=\"ace-script-editor-wrapper\" ng-if=\"codeEditorModeInitialized\">\n                <div class=\"ace-script-editor-code editable\"\n                     ng-required=\"isRequired\"\n                     ng-model=\"codeEditorModel\"\n                     ng-model-options=\"{ getterSetter: true }\"\n                     ng-readonly=\"readOnlyMode || !editMode\"\n                     ui-ace=\"{showGutter: editMode, onLoad: aceLoaded, onChange: aceChanged, mode: codeEditorMode}\">\n                </div>\n                <button class=\"ace-script-editor-full-screen-mode-icon\" ng-click=\"aceToggleFullscreenBtn($event)\">\n                    <img class=\"full-screen-icon-enter\" src=\"static/9.0.2/styles/img/fullscreen-show.svg\" alt=\"Enter full screen\"/>\n                    <img class=\"full-screen-icon-exit\" src=\"static/9.0.2/styles/img/fullscreen-exit.svg\" alt=\"Exit full screen\"/>\n                </button>\n            </div>\n        </div>\n    </div>\n    <div ng-show=\"editMode\" style=\"margin-top: 10px;\">\n        <span class=\"error\" ng-show=\"isRequired && draft === \'\'\">*</span>\n        <span class=\"ok\">\n            <i class=\"xl-icon check-icon\" style=\"vertical-align: sub; margin-right: 5px;\"></i>Save\n        </span>\n        <span class=\"cancel\">\n            <i class=\"xl-icon close-icon\" style=\"vertical-align: sub; margin-left: 15px; margin-right: 5px;\"></i>Cancel\n        </span>\n        <span ng-if=\"helpUrl\" style=\"margin-left: 15px; margin-right: 5px;\">\n            <a rel=\"noopener\" href=\"{{ helpUrl }}\" target=\"_blank\" style=\"text-decoration: none;\" class=\"help-icon link\" style=\"vertical-align: middle;\"></a>\n        </span>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/inline-drop-down-list.html","<div class=\"inline-drop-down-list-editor\">\n    <div class=\"ui-front\" inline-simple-select-editor\n         ng-show=\"!$ctrl.isListOfObjects && $ctrl.isLoaded\"\n         name=\"{{$ctrl.variable.key}}\"\n         select-options=\"$ctrl.values\"\n         model=\"$ctrl.variable\"\n         on-change=\"$ctrl.onChange({variable: $ctrl.variable})\"\n         ng-required=\"$ctrl.variable.requiresValue\">\n    </div>\n    <div xl-widget-autocomplete\n         ng-if=\"$ctrl.isListOfObjects && $ctrl.isLoaded\"\n         id=\"{{ property.name }}\"\n         ng-model=\"$ctrl.selectedAutocompleteValue\"\n         name=\"{{$ctrl.variable.key}}\"\n         handlers=\"$ctrl.autocompleteHandlers\"\n         show-all-on-click=\"true\"\n         open-on-click=\"true\"\n         is-required=\"$ctrl.variable.requiresValue\"\n         obj-label=\"title\"></div>\n    <div ng-if=\"!$ctrl.isLoaded\" class=\"text-center inline-drop-down-list-editor-loader\">\n        <img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n    </div>\n</div>");
$templateCache.put("static/9.0.2/partials/inline-editor/list.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span ng-show=\"model\" class=\"text\" ng-transclude></span>\n    <span ng-hide=\"model\" class=\"text placeholder light-text\">{{placeholder}}</span>\n    <span class=\"xl-icon edit-icon\"></span>\n</div>\n<label class=\"edit\">\n    <input class=\"editable\" type=\"text\" name=\"{{name}}\" ng-show=\"editMode\" ng-model=\"draft\" ng-list ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/number-field.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"isNumber(model)\" ng-transclude></span>\n    <span ng-hide=\"isNumber(model)\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"xl-icon edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" type=\"number\" name=\"{{name}}\" ng-model=\"draft\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/password-field.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"hasText(model)\" ng-transclude></span>\n    <span ng-hide=\"hasText(model)\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"xl-icon edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" type=\"password\" name=\"{{name}}\" ng-model=\"draft\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/select.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"model\" ng-transclude></span>\n    <span class=\"text placeholder light-text\" ng-hide=\"model\">{{placeholder}}</span>\n    <span class=\"xl-icon edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <select class=\"editable\" name=\"{{name}}\" ng-model=\"draft\" ng-options=\"option.id as option.title for option in selectOptions\" ng-required=\"isRequired\"></select>\n</label>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/simple-select.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    {{ model.value }}\n    <span class=\"xl-icon edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <select class=\"editable\" name=\"{{name}}\" ng-model=\"model.value\" ng-options=\"option as option for option in selectOptions\" ng-required=\"isRequired\"></select>\n</label>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/text-field.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"hasText(model)\" ng-transclude></span>\n    <span ng-hide=\"hasText(model)\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"xl-icon edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" name=\"{{name}}\" type=\"text\" ng-model=\"draft\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/textarea.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display inline-textarea\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"hasText(model)\" ng-transclude></span>\n    <span class=\"text placeholder light-text\" ng-hide=\"hasText(model)\">{{placeholder}}</span>\n    <i class=\"xl-icon edit-icon\"></i>\n</div>\n<div class=\"edit inline-textarea\" ng-show=\"editMode\">\n    <textarea class=\"editable\" name=\"{{name}}\" ng-model=\"draft\" rows=\"10\" ng-required=\"isRequired\"></textarea>\n    <div>\n        <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n        <span class=\"ok\">\n            <i class=\"xl-icon check-icon\" style=\"vertical-align: sub; margin-right: 5px;\"></i>Save\n        </span>\n        <span class=\"cancel\">\n            <i class=\"xl-icon close-icon\" style=\"vertical-align: sub; margin-left: 15px; margin-right: 5px;\"></i>Cancel\n        </span>\n        <span ng-if=\"helpUrl\" style=\"margin-left: 15px; margin-right: 5px;\"><a href=\"{{ helpUrl }}\" target=\"_blank\" rel=\"noopener\" style=\"text-decoration: none;\" class=\"xl-icon help-icon link\" style=\"vertical-align: sub;\"></a></span>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/inline-editor/user.html","<a tabindex=\"0\" class=\"focusable\"></a>\n<div class=\"display\" ng-hide=\"editMode\">\n    <span class=\"text\" ng-show=\"model\" ng-transclude></span>\n    <span ng-hide=\"model\" class=\"text placeholder light-text\">{{ placeholder }}</span>\n    <span class=\"xl-icon edit-icon\"></span>\n</div>\n<label class=\"edit\" ng-show=\"editMode\">\n    <input class=\"editable\" name=\"{{name}}\" type=\"text\" ng-model=\"draft.username\" ng-required=\"isRequired\"/>\n    <span class=\"error\" ng-show=\"isRequired && draft == \'\'\">*</span>\n</label>\n");
$templateCache.put("static/9.0.2/partials/login/login.html","<div id=\"login\">\n    <div class=\"content\">\n        <div class=\"disabled-page-dialog login-dialog\">\n            <div class=\"disabled-page-title\">\n                Log in\n            </div>\n            <form name=\"loginForm\" ng-submit=\"login()\">\n                <div class=\"login-label\">\n                    <label class=\"control-label\" for=\"inputLogin\">\n                        User\n                        <span class=\"required\">*</span>\n                    </label>\n                </div>\n                <div class=\"login-input\">\n                    <input type=\"text\" id=\"inputLogin\" placeholder=\"User\" ng-model=\"loginInfo.login\" autofocus required>\n                </div>\n                <div class=\"login-label\">\n                    <label class=\"control-label\" for=\"inputPassword\">\n                        Password\n                        <span class=\"required\">*</span>\n                    </label>\n                </div>\n                <div class=\"login-input\">\n                    <input type=\"password\" id=\"inputPassword\" placeholder=\"Password\" ng-model=\"loginInfo.password\" required>\n                </div>\n                <div class=\"login-label\" ng-if=\"clientSessionRememberEnabled\">\n                    <label class=\"control-label\" for=\"rememberMe\">\n                        <input id=\"rememberMe\" type=\"checkbox\" ng-model=\"loginInfo.rememberMe\" />\n                        Keep me logged in\n                    </label>\n                </div>\n                <div class=\"error-content\" ng-if=\'loginInfo.failedStatus\'>\n                    <span ng-show=\'loginInfo.failedStatus == 401\'>\n                        The username and/or password you have entered is incorrect.\n                    </span>\n                    <span ng-show=\'loginInfo.failedStatus == 403\'>\n                        Permission \'login\' is not granted to you.\n                    </span>\n                    <span ng-show=\'loginInfo.failedStatus == -1\'>\n                        The server is not active or XL-Release is unable to communicate with it. Restart the server or reinstall XL-Release.\n                    </span>\n                </div>\n                <div ng-include=\"\'partials/menu/license-warning.html\'\"></div>\n                <div class=\"login-button\">\n                    <button class=\"button primary\" type=\"submit\">Log in</button>\n                </div>\n            </form>\n            <div class=\"login-providers\" ng-if=\"providers.length > 0\">\n                <hr/>\n                <div class=\"login-provider\" ng-repeat=\"provider in providers\">\n                    <a class=\"button {{provider.loginCss}}\" ng-click=\"provider.login()\"><img ng-src=\"{{provider.loginIcon}}\">{{provider.loginLabel}}</a>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n<div class=\"disabled-page-background\"></div>\n");
$templateCache.put("static/9.0.2/partials/menu/about.html","<div class=\"modal-content about\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"$dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>About</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p class=\"brand\"><img src=\"static/9.0.2/styles/img/xl_release_logo_purple_no_trademark.svg\" class=\"logo\"/></p>\n        <p class=\"version-text\">Version {{ version }}</p>\n\n        <fieldset id =\"license-box\" ng-if=\"license\">\n            <legend>License information</legend>\n            Expires on <span ng-class=\'{expired: licenseIsExpired() || licenseIsAlmostExpired()}\'>{{ license.expiresAfter | date:\'shortDate\' }}</span><br/>\n            <span ng-show=\"license.maxNumberOfUsers\">Maximum number of users {{ license.maxNumberOfUsers }}<br/></span>\n            <span ng-show=\"license.repositoryId\">Repository ID {{ license.repositoryId }}<br/></span>\n            Licensed to {{ license.licensedTo }}<br/>\n            License version {{ license.version }}<br/>\n            <strong><a href=\"productregistration\" ng-if=\"isAdmin()\">Renew license</a></strong>\n        </fieldset>\n\n        <p class=\"bold\">&copy; 2019 XebiaLabs, Inc. and its affiliates. All rights reserved.</p>\n        <p class=\"brand-xl\"><img src=\"static/9.0.2/styles/img/xebialabs_logo2.svg\"></p>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/menu/help.html","<help-popover></help-popover>");
$templateCache.put("static/9.0.2/partials/menu/license-warning.html","<span ng-controller=\"LicenseController\" class=\"license-warning\">\n    <span ng-if=\"licenseIsAlmostExpired() && isAdmin()\">\n        Your XL Release license expires on {{ license.expiresAfter | date:\'mediumDate\' }}. <a href=\"productregistration\">Register, renew or extend your license.</a>\n    </span>\n    <span ng-if=\"licenseIsExpired() && license.repositoryId && isAdmin()\">\n        Your repository ID is {{ license.repositoryId }}. <a href=\"productregistration\">Register, renew or extend your license.</a>\n    </span>\n</span>\n");
$templateCache.put("static/9.0.2/partials/menu/navigation-menu-item.html","<li ng-if=\"$ctrl.isPermitted($ctrl.item)\"\n    hover-menu ng-style=\"{\'background-color\': $ctrl.isItemActive($ctrl.item) ? $ctrl.getHoverColor() : \'\'}\"\n    is-active-item=\"$ctrl.isItemActive($ctrl.item)\">\n    <a ng-click=\"$ctrl.goToRoute()\"><span class=\"menu-element\">{{$ctrl.item.label}}</span></a>\n</li>\n");
$templateCache.put("static/9.0.2/partials/menu/navigation-menu.html","<ul class=\"menu-level-{{$ctrl.level}}\">\n    <navigation-menu-item ng-repeat=\"menuItem in $ctrl.items\" item=\"menuItem\" ng-if=\"!menuItem.disabled\"></navigation-menu-item>\n</ul>");
$templateCache.put("static/9.0.2/partials/menu/settings.html","<settings-popover></settings-popover>");
$templateCache.put("static/9.0.2/partials/menu/sub-header.html","<div class=\"sub-header\" ng-class=\"{\'full-page\': isFullPage(), \'reports-pages\': isReportsPages()}\">\n    <div class=\"sub-header-top\" ng-class=\"{\'has-action-button\': isDashboardsPages() || isReportsPages()}\">\n        <div class=\"header-environment-name\" ng-style=\"{\'background-color\': theme.headerAccentColor}\">{{theme.headerName}}</div>\n        <div class=\"header-alert-wrapper\" ng-class=\"{\'header-alert-wrapper-margin\': theme.headerName}\">\n            <div ng-controller=\"LicenseController\">\n                <div ng-if=\"!isLoginPage() && showLicenseInfo()\" class=\"system-message license-alert\">\n                    <div class=\"xlr-alert-warning\">\n                        <div class=\"icon\">\n                            <i class=\"xl-icon warning-icon\"/>\n                        </div>\n                        <div class=\"message\">\n                            <span ng-include=\"\'partials/menu/license-warning.html\'\"></span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <xlr-system-message\n                    ng-if=\"!isLoginPage()\"\n                    system-message=\"systemMessage\"\n            ></xlr-system-message>\n        </div>\n        <div class=\"header-submenu\">\n            <xlr-breadcrumbs ng-if=\"!isLoginPage()\"\n                             sub-menu-items=\"subMenuItems\"\n                             breadcrumbs=\"breadcrumbs\"\n                             class=\"pull-left bread-crumbs\"\n                             ng-class=\"{\'full-width-breadcrumbs\': !isTemplateDetailsPage()}\">\n            </xlr-breadcrumbs>\n            <xlr-template-label ng-if=\"isTemplateDetailsPage()\"></xlr-template-label>\n            <xlr-add-dashboard class=\"sub-header-button pull-right\" ng-if=\"isGlobalDashboardsPages() || isReportsPages()\"></xlr-add-dashboard>\n        </div>\n        <div class=\"clearfix\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/menu/sub-nav.html","<div class=\"sub-nav\">\n    <sub-nav-content></sub-nav-content>\n</div>");
$templateCache.put("static/9.0.2/partials/overlay-spinner/loading-overlay-template.html","<div class=\"overlay-spinner\" style=\"\">\n    <div class=\"overlay-spinner-loader\">\n        <img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/profile/profile.html","<div id=\"profile\" class=\"standalone-form\">\n    <div id=\"user-profile-header\" class=\"header\">\n        <span class=\"last-saved error\" ng-if=\"$ctrl.previousPasswordIsInvalid\">Previous password is invalid.</span>\n        <div class=\"buttons\">\n                <span ng-if=\"$ctrl.lastSavedDate\" class=\"last-saved\">Last saved on {{ $ctrl.lastSavedDate | date: \'medium\' }}</span>\n                <button ng-click=\"$ctrl.save()\" ng-disabled=\"profileForm.$invalid || ($ctrl.profile.password != $ctrl.profile.passwordConfirmation)\"\n                class=\"button save primary\">\n            Save\n        </button>\n        <span doc-icon=\"profile.html\"></span>\n        </div>\n    </div>\n    <div class=\"content-under-header\">\n        <h4>Personal settings for {{ ::$ctrl.username }}</h4>\n        <form ng-if=\"$ctrl.profile\" name=\"profileForm\" id=\"profileForm\" class=\"form-horizontal\" confirm-leave>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"full-name\">Name</label>\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level text\" id=\"full-name\" name=\"full-name\" ng-model=\"$ctrl.profile.fullName\"/>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"email\">Email address</label>\n                <div class=\"col-sm-9\">\n                    <input type=\"email\" class=\"input-block-level email\" id=\"email\" name=\"email\" ng-model=\"$ctrl.profile.email\" autofocus/>\n                    <span class=\"error\" ng-if=\"profileForm.email.$error.email\">Malformed email address</span>\n                </div>\n            </div>\n            <br/>\n\n            <div ng-if=\"$ctrl.isInternalUser($ctrl.profile)\">\n                <h4>Change password</h4>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"previousPassword\">Previous password</label>\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level password\" id=\"previousPassword\" name=\"previousPassword\"\n                               ng-model=\"$ctrl.profile.previousPassword\" ng-required=\"$ctrl.profile.password.length > 0\"/>\n                        <span class=\"error\" ng-if=\"profileForm.previousPassword.$error.required\">Previous password is required when changing passwords</span>\n                    </div>\n                </div>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"password\">New password</label>\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level password\" id=\"password\" name=\"password\"\n                               ng-model=\"$ctrl.profile.password\"/>\n                    </div>\n                </div>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"password\">Confirm new password</label>\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level password\" id=\"passwordConfirmation\" name=\"passwordConfirmation\"\n                               ng-model=\"$ctrl.profile.passwordConfirmation\"/>\n                        <span class=\"error\" ng-if=\"$ctrl.profile.password != $ctrl.profile.passwordConfirmation\">Passwords don\'t match</span>\n                    </div>\n                </div>\n            </div>\n            <br/>\n\n            <h4>Personal regional settings</h4>\n\n            <div class=\"help\">\n                These settings control date formats, time formats, and the first day of the week in the calendar.\n                Changes made here will be used instead of the default browser settings.\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Date format</label>\n                <div class=\"col-sm-9\">\n                    <select ng-model=\"$ctrl.profile.dateFormat\" ng-options=\"$ctrl.getDateLabel(format) for format in ::$ctrl.dateFormats\"></select>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Time format</label>\n                <div class=\"col-sm-9\">\n                    <select ng-model=\"$ctrl.profile.timeFormat\" ng-options=\"$ctrl.getTimeLabel(format) for format in ::$ctrl.timeFormats\"></select>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">First day of week</label>\n                <div class=\"col-sm-9\">\n                    <select ng-model=\"$ctrl.profile.firstDayOfWeek\"\n                            ng-options=\"$ctrl.getFirstDayOfWeekLabel(format) for format in ::$ctrl.firstDayOfWeekFormats\"></select>\n                </div>\n            </div>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/reports/dashboard.html","<div id=\"report\" class=\"dashboard-tiles-layout\">\n    <div ng-include=\"\'partials/reports/reports-header.html\'\"></div>\n    <div class=\"content-under-header\">\n        <div class=\"row dashboard-row\">\n            <div class=\"col-xs-4\">\n                <div class=\"row\">\n                    <div class=\"col-xs-6 short-tile tile\">\n                        <div class=\"short-card\" tile-container id=\"completed-releases\" report=\"reports.completedRelease\">\n                            <tile-title>Completed releases</tile-title>\n                            <tile-content>\n                                {{ reports.completedRelease.data.completedReleases }}\n                            </tile-content>\n                            <tile-footer>\n                                Started from {{ reports.completedRelease.data.createdFromTemplates }} different\n                                <ng-pluralize count=\"reports.completedRelease.data.createdFromTemplates\"\n                                              when=\"{\'0\': \'templates\', \'one\': \'template\', \'other\': \'templates\'}\"></ng-pluralize>\n                            </tile-footer>\n                        </div>\n                    </div>\n\n                    <div class=\"col-xs-6 short-tile tile\">\n                        <div class=\"short-card\" tile-container id=\"longest-task-types\" report=\"reports.longestTaskTypes\">\n                            <tile-title>Longest task type</tile-title>\n                            <tile-content shorten-content>\n                                {{ getTaskNameByType(reports.longestTaskTypes.data[0].taskType)}}\n                            </tile-content>\n                            <tile-footer>\n                                Task found in\n                                <ng-pluralize count=\"reports.longestTaskTypes.data[0].containedInNumberOfReleases\"\n                                              when=\"{\'0\': \'{} releases\', \'one\': \'{} release\', \'other\': \'{} releases\'}\"></ng-pluralize>\n                            </tile-footer>\n                        </div>\n                    </div>\n\n                </div>\n                <div class=\"row\">\n                    <div class=\"col-xs-6 short-tile tile\">\n                        <div class=\"short-card\" tile-container id=\"avg-release-duration\" report=\"reports.averageAndLongestReleaseDuration\">\n                            <tile-title>Avg. release duration</tile-title>\n                            <tile-content>\n                                {{ formatDuration(reports.averageAndLongestReleaseDuration.data.averageReleaseDuration) }}\n                            </tile-content>\n                            <tile-footer>\n                            Longest release duration was {{ formatDuration(reports.averageAndLongestReleaseDuration.data.longestReleaseDuration) }}\n                        </tile-footer>\n                        </div>\n                    </div>\n                    <div class=\"col-xs-6 short-tile tile\">\n                        <div class=\"short-card\" tile-container id=\"avg-task-duration\" report=\"reports.averageAndLongestTaskDuration\">\n                            <tile-title>Avg. task duration</tile-title>\n                            <tile-content>\n                                {{ formatDuration(reports.averageAndLongestTaskDuration.data.averageTaskDuration) }}\n                            </tile-content>\n                            <tile-footer>\n                            Longest task duration was {{ formatDuration(reports.averageAndLongestTaskDuration.data.longestTaskDuration) }}\n                        </tile-footer>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <div id=\"task-efficiency\" class=\"col-xs-4 tile\">\n                <div class=\"big-card\" tile-container report=\"reports.echartsTaskEfficiency\">\n                    <tile-title>\n                        Task efficiency\n                    </tile-title>\n                    <tile-content>\n                        <echarts options=\"reports.echartsTaskEfficiency.data\" class=\"cursor-default-important\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n            <div id=\"time-spent\" class=\"col-xs-4 tile\">\n                <div class=\"big-card\" tile-container report=\"reports.echartsTaskTimeSpent\">\n                    <tile-title>\n                        Time spent by task category\n                    </tile-title>\n                    <tile-content>\n                        <echarts options=\"reports.echartsTaskTimeSpent.data\" class=\"cursor-default-important\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n        </div>\n        <div class=\"row dashboard-row big-row\">\n            <div id=\"release-efficiency\" class=\"col-xs-6 tile\">\n                <div class=\"bigger-card\" tile-container report=\"reports.echartsReleaseEfficiency\">\n                    <tile-title>\n                        Release efficiency\n                    </tile-title>\n                    <tile-content>\n                        <echarts options=\"reports.echartsReleaseEfficiency.data\" class=\"cursor-default-important\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n            <div id=\"number-of-releases\" class=\"col-xs-6 tile\">\n                <div class=\"bigger-card\" tile-container report=\"reports.echartsNumberOfReleasesPerMonth\">\n                    <tile-title>\n                        Number of releases\n                    </tile-title>\n                    <tile-content>\n                        <echarts options=\"reports.echartsNumberOfReleasesPerMonth.data\" class=\"cursor-default-important\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"row dashboard-row big-row\">\n            <div id=\"longest-releases\" class=\"col-xs-6 tile\">\n                <div class=\"bigger-card\" tile-container report=\"reports.echartsLongestReleases\">\n                    <tile-title>\n                        <a class=\"link color-inherited export-action pull-right\" ng-click=\"exportReport(\'TOP_LONGEST_RELEASE\')\">\n                            <i class=\"xl-icon export-icon\"></i>Export\n                        </a>\n                        Top 10 longest releases\n                    </tile-title>\n                    <tile-content>\n                        <echarts options=\"reports.echartsLongestReleases.data\"\n                                 ec-click=\"goToRelease(params, reports.echartsLongestReleases.data.sortedData)\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n            <div id=\"avg-release-duration-over-time\" class=\"col-xs-6 tile\">\n                <div class=\"bigger-card\" tile-container report=\"reports.echartsReleaseDuration\">\n                    <tile-title>\n                        Average release duration over time\n                    </tile-title>\n                    <tile-content>\n                        <echarts options=\"reports.echartsReleaseDuration.data\" class=\"cursor-default-important\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n        </div>\n\n        <div class=\"row dashboard-row big-row\">\n            <div id=\"longest-phases\" class=\"col-xs-6 tile\">\n                <div class=\"bigger-card\" tile-container report=\"reports.echartsLongestPhases\">\n                    <tile-title>\n                        <a class=\"link color-inherited export-action pull-right\" ng-click=\"exportReport(\'TOP_LONGEST_PHASE\')\">\n                            <i class=\"xl-icon export-icon\"></i>Export\n                        </a>\n                        Top 10 longest phases\n                    </tile-title>\n                    <tile-content>\n                        <echarts options=\"reports.echartsLongestPhases.data\"\n                                 ec-click=\"goToRelease(params, reports.echartsLongestPhases.data.sortedData)\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n            <div id=\"longest-tasks\" class=\"col-xs-6 tile\">\n                <div class=\"bigger-card\" tile-container report=\"reports.echartsLongestTasks\">\n                    <tile-title>\n                        <a class=\"link color-inherited export-action pull-right\" ng-click=\"exportReport(\'TOP_LONGEST_TASK\')\">\n                            <i class=\"xl-icon export-icon\"></i>Export\n                        </a>\n                        Top 10 longest tasks\n                    </tile-title>\n                    <tile-content>\n                        <!-- Top 10 longest tasks -->\n                        <echarts options=\"reports.echartsLongestTasks.data\"\n                                 ec-click=\"goToRelease(params, reports.echartsLongestTasks.data.sortedData)\"></echarts>\n                    </tile-content>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/reports/report-container.html","<div>\n    <div ng-if=\"report.loading()\" class=\"spinner\"><img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" /></div>\n    <div ng-if=\"!report.loading() && report.isEmpty()\" class=\"no-data\">No Data</div>\n    <div ng-if=\"!report.loading() && !report.isEmpty()\" ng-transclude></div>\n</div>");
$templateCache.put("static/9.0.2/partials/reports/reports-header.html","<div id=\"reports-header\" class=\"header\" ng-controller=\"FiltersController\">\n    <div class=\"actions\">\n        <div class=\"time-filters-container\" ng-include=\"\'partials/filters/time-filters.html\'\"></div>\n        <div class=\"tags-label\">Tags</div>\n        <div class=\"transparent tags-input green-tags\" tags-input tags=\"filters.tags\" focus-on-click\n                placeholder=\"Filter by tags...\" autofocus completion-candidates=\"allTags\"></div>\n        <div class=\"buttons\">\n            <xlr-export-content-button class=\"export-content-button\" data-html2canvas-ignore></xlr-export-content-button>\n        </div>\n        <span doc-icon=\"reports.html\" data-html2canvas-ignore></span>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/reports/tile-container.html","<div ng-if=\"!report.loading()\" class=\"card-title\" ng-transclude=\"title\"></div>\n<div class=\"card-content\" ng-class=\"(report.isConfigured() && !report.loading() && !report.isEmpty()) ? \'loaded\' : \'not-loaded\'\">\n    <div ng-if=\"report.isConfigured() && !report.loading() && !report.isEmpty()\" ng-transclude=\"content\"></div>\n    <div ng-if=\"!report.isConfigured()\" class=\"tile-not-configured\">\n        <i class=\"xl-icon cross-icon\"></i>\n        <small>Tile not configured</small>\n    </div>\n    <div ng-if=\"report.isConfigured() && !report.loading() && report.hasError()\" class=\"tile-error\"\n         tooltip=\"report.errorMessage()\" tooltip-position=\"bottom\">\n        <i class=\"xl-icon cross-icon\"></i>\n        <small>An error occurred</small>\n    </div>\n\n    <div ng-if=\"report.isConfigured() && !report.loading() && !report.hasError() && report.isEmpty()\" class=\"tile-no-data\">\n        <i class=\"xl-icon column-icon\"></i>\n        <small>No data for period</small>\n    </div>\n    <div ng-if=\"report.loading()\" class=\"spinner\"><img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/></div>\n</div>\n<div class=\"card-footer\" ng-if=\"report.isConfigured() && !report.loading() && !report.isEmpty()\" ng-transclude=\"footer\"></div>");
$templateCache.put("static/9.0.2/partials/releases/abort-release-modal-context-menu.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"$dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Abort Release</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to abort the release <b>{{ctrl.release.title}}</b>.</p>\n\n        <form name=\"abortTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"abortComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"$dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" ng-click=\"ctrl.onAbort(abortComment);$dismiss()\" ng-disabled=\"abortTaskForm.$invalid\">Abort</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/abort-release-modal-ctrl-binding.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Abort Release</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to abort the release <b>{{ctrl.release.title}}</b>.</p>\n\n        <form name=\"abortTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"abortComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" ng-click=\"ctrl.onAbort(abortComment);dismiss()\" ng-disabled=\"abortTaskForm.$invalid\">Abort</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/abort-release-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Abort Release</h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to abort the release <b>{{release.title}}</b>.</p>\n\n        <form name=\"abortTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"abortComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" ng-click=\"abortRelease(release, abortComment);dismiss()\" ng-disabled=\"abortTaskForm.$invalid\">Abort</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/add-attachment-modal.html","<div id=\"addAttachmentModal\" class=\"modal-content\" upload upload-url=\"upload/attachment/{{release.id}}\">\n    <form name=\"addAttachmentForm\" id=\"addAttachmentForm\" class=\"form-horizontal\">\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n            <h4>Add attachment</h4>\n        </div>\n        <div>\n            <div class=\"modal-body\">\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"addAttachment-file\">Attachment<span ng-if=\"addAttachmentForm.$error.required\" class=\"error\">*</span></label>\n\n                    <div class=\"col-sm-9\">\n                        <input type=\"file\" ng-model=\"file\" file-input id=\"addAttachment-file\" required></input>\n                        <span class=\"error\" ng-show=\"addAttachmentForm.$error.required\">Attachment required</span>\n                    </div>\n                    <span class=\"error pull-right\" ng-show=\"UploadService.data.error\">An upload error occurred</span>\n                </div>\n                <img class=\"pull-right\" src=\"static/9.0.2/styles/img/ajax-loader.gif\" ng-show=\"UploadService.data.loading\"/>\n            </div>\n            <div class=\"modal-footer\">\n                <button class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n                <button class=\"button import primary\" ng-disabled=\"addAttachmentForm.$invalid\" ng-click=\"upload(file)\">Import</button>\n            </div>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/completed-release-filter.html","<div id=\"filter-container\">\n    <label class=\"filter-item\" for=\"display-flagged\">\n        <input type=\"checkbox\" ng-model=\"filters.flagged\" id=\"display-flagged\" ng-change=\"setFilters(release.id, filters)\"/>\n        <i class=\"xl-icon flag-none-icon\" />\n        <span>Show flagged tasks</span>\n    </label>\n    <label class=\"filter-item\" for=\"display-failed\">\n        <input type=\"checkbox\" ng-model=\"filters.failed\" id=\"display-failed\" ng-change=\"setFilters(release.id, filters)\"/>\n        <i class=\"xl-icon lightning-icon\" />\n        <span>Show failed tasks</span>\n    </label>\n    <label class=\"filter-item\" for=\"display-delayed\">\n        <input type=\"checkbox\" ng-model=\"filters.delayed\" id=\"display-delayed\" ng-change=\"setFilters(release.id, filters)\"/>\n        <i class=\"xl-icon delay-icon\" />\n        <span></span>Show delayed tasks</span>\n    </label>\n    <label class=\"filter-item\" for=\"display-clean\">\n        <input type=\"checkbox\" ng-model=\"filters.clean\" id=\"display-clean\" ng-change=\"setFilters(release.id, filters)\"/> Show clean tasks\n    </label>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/context-menu.html","<xlr-context-menu id=\"context-menu-container\" items=\"vm.contextMenuItems\"></xlr-context-menu>\n");
$templateCache.put("static/9.0.2/partials/releases/delete-phase-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Delete Phase</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the phase <b>{{phase.title}}</b>.\n        All tasks within this phase will be deleted.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" focus-on=\"true\" ng-click=\"deletePhase(phase);dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/delete-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Delete Task</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the task <b>{{task.title}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" focus-on=\"true\" ng-click=\"ctrl.deleteTask(container, task);dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/filter.html","<div id=\"filter-container\">\n    <label class=\"filter-item\" for=\"display-active\">\n        <input type=\"checkbox\" ng-model=\"filters.active\" id=\"display-active\"/> All active releases\n    </label>\n    <label class=\"filter-item\" for=\"display-planned\">\n        <input type=\"checkbox\" ng-model=\"filters.planned\" id=\"display-planned\"/> All planned releases\n    </label>\n    <label class=\"filter-item\" for=\"display-completed\">\n        <input type=\"checkbox\" ng-model=\"filters.inactive\" id=\"display-completed\"/> All completed and aborted releases\n    </label>\n    <label class=\"filter-item\" for=\"display-only-mine\">\n        <input type=\"checkbox\" ng-model=\"filters.onlyMine\" id=\"display-only-mine\"/> Only my releases\n    </label>\n    <label class=\"filter-item\" for=\"display-only-flagged\">\n        <input type=\"checkbox\" ng-model=\"filters.onlyFlagged\" id=\"display-only-flagged\"/> Only flagged releases\n    </label>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/phase-details-modal.html","<div class=\"modal-content\" ng-controller=\"phaseDetailsController\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 ng-if=\"isEditable()\" class=\"phase-title\" inline-text-editor model=\"phase.title\" on-change=\"updatePhase(phase)\">\n            <span display-variables=\"phase.title\" variables=\"release.variables\"></span>\n        </h4>\n        <h4 ng-if=\"!isEditable()\" class=\"phase-title\">{{phase.title}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayScheduledStartDateBefore && !phase.startDate\"><i class=\"small-warning-icon\"></i>Start date is before the scheduled start date of the release, which is {{release.scheduledStartDate | date:\'medium\'}}</div>\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayScheduledStartDateAfter && !phase.startDate\"><i class=\"small-warning-icon\"></i>Start date is after the due date of the release, which is {{release.dueDate | date:\'medium\'}}</div>\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayDueDateBefore && !phase.endDate\"><i class=\"small-warning-icon\"></i>Due date is before the scheduled start date of the release, which is {{release.scheduledStartDate | date:\'medium\'}}</div>\n        <div class=\"alert alert-warning\" ng-show=\"warning.displayDueDateAfter && !phase.endDate\"><i class=\"small-warning-icon\"></i>Due date is after the due date of the release, which is {{release.dueDate | date:\'medium\'}}</div>\n        <div class=\"pull-left left-detail\">\n            <div ng-show=\"isEditable()\">\n                <!--<div inline-textarea-editor-->\n                     <!--placeholder=\"Set phase description\"-->\n                     <!--model=\"phase.description\"-->\n                     <!--on-change=\"updatePhase(phase)\"-->\n                     <!--markdown-->\n                     <!--class=\"phase-description\">-->\n                    <!--<span display-variables=\"phase.description\" variables=\"release.variables\" markdown class=\"markdown\"></span>-->\n                <!--</div>-->\n                <div xlr-inline-textarea-with-variables release=\"release\" variables=\"allVariablesWithReleaseVars\" model=\"phase.description\" on-change=\"updatePhase(phase)\" markdown class=\"phase-description\">\n                </div>\n            </div>\n            <div class=\"phase-description\" ng-hide=\"isEditable()\">\n                <span display-variables=\"phase.description\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n            </div>\n        </div>\n        <div class=\"pull-right right-detail\">\n            <div class=\"scheduled-start-date\" ng-if=\"!phase.startDate\"\n                 modal-date-editor\n                 date-model=\"phase.scheduledStartDate\"\n                 on-change=\"planning.updateScheduledStartDate(phase)\"\n                 readonly=\"!isEditable()\"\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 date-title=\"Start date\">\n            </div>\n            <div class=\"start-date\" ng-if=\"phase.startDate\"\n                 modal-date-editor\n                 date-model=\"phase.startDate\"\n                 date-title=\"Start date\"\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 readonly=\"true\">\n            </div>\n            <div class=\"due-date\" ng-if=\"!phase.endDate\"\n                 modal-date-editor\n                 date-model=\"phase.dueDate\"\n                 on-change=\"planning.updateDueDate(phase)\"\n                 readonly=\"!isEditable()\"\n                 inferred-date=\"planning.planElement.displayEndDate\"\n                 date-title=\"Due date\">\n            </div>\n            <div class=\"end-date\" ng-if=\"phase.endDate\"\n                 modal-date-editor\n                 date-model=\"phase.endDate\"\n                 date-title=\"End date\"\n                 inferred-date=\"planning.planElement.displayEndDate\"\n                 readonly=\"true\">\n            </div>\n            <div class=\"modal-section\">\n                Duration\n            </div>\n            <div duration-editor\n                 duration=\"phase.plannedDuration\"\n                 inferred-duration=\"planning.planElement.displayDuration\"\n                 on-change=\"planning.updateDuration(phase)\"\n                 editable=\"isEditable()\"\n                 done=\"phase.done\"/>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/release-editor.html","<div id=\"release\" class=\"{{ release.status | lowercase }}\">\n    <div id=\"navigator-toggler\" ng-show=\"hasOverflow\" ng-click=\"showNavigator = !showNavigator\"\n         ng-class=\"{\'navigator-opened\': showNavigator, \'navigator-shifted\': release.status !== \'TEMPLATE\'}\">\n        <div class=\"arrow-container\">\n            <i class=\"xl-icon\" ng-class=\"{\'chevron-left-icon\': hasOverflow && showNavigator, \'chevron-right-icon\': hasOverflow && !showNavigator}\"></i>\n        </div>\n    </div>\n    <div id=\"navigator\" ng-show=\"showNavigator && hasOverflow\"\n         ng-class=\"{\'navigator-shifted\': release.status !== \'TEMPLATE\'}\">\n        <div class=\"phase-link-container\" ng-if=\"areDonePhasesCollapsed(release)\">\n            <div class=\"phase-link\">Completed phases <br>\n                <span class=\"light-text\">\n                    <span ng-pluralize\n                          count=\"countPhasesDone(release)\"\n                          when=\"{\'1\': \'{} phase\', \'other\': \'{} phases\'}\"></span>&nbsp;completed\n                </span>\n            </div>\n        </div>\n        <div ng-repeat=\"phase in release.phases | filter:collapseFilter(release) track by phase.id\" class=\"phase-link-container\">\n            <div class=\"phase-link\">\n                <span display-variables=\"phase.title\" variables=\"release.variables\"></span>\n                <br>\n                <span class=\"light-text\" ng-pluralize\n                      count=\"getLeafTasks(phase).length\"\n                      when=\"{\'0\': \'No tasks\', \'1\': \'{} task\', \'other\': \'{} tasks\'}\"></span>\n            </div>\n        </div>\n    </div>\n    <div worksheet-scrolling class=\"wrapper\">\n        <div release-flow-header class=\"release-flow-header\">\n            <button type=\"button\" class=\"button dropdown-button completed-release-filter-button\" ng-if=\"isReleaseCompleted(release)\"\n                    bs-popover data-content-template=\"partials/releases/completed-release-filter.html\" data-placement=\"bottom\" auto-close=\"true\">\n                Filter options\n            </button>\n            <div class=\"buttons\">\n                <a ng-click=\"addPhase()\" class=\"add-phase button\" ng-if=\"!isReleaseCompleted(release) && security.hasEditPermission(release)\">Add Phase</a>\n                <a ng-if=\"release.status != \'TEMPLATE\' && security.hasPermission(\'release#abort\', release) && !isReleaseCompleted(release) && !hasAutomatedTaskInProgress\"\n                   modal=\"\'partials/releases/abort-release-modal.html\'\" class=\"abort-release button\">Abort Release</a>\n                <a ng-show=\"canRestartPhases(release)\"\n                   class=\"restart-phases button\"\n                   modal=\"\'partials/releases/restart-phases-modal.html\'\">\n                    Restart Phase...\n                </a>\n                <a class=\"resume primary button\" ng-if=\"canResume(release)\" ng-click=\"resumeRelease(release)\">Resume Release</a>\n                <button type=\"button\" class=\"export-buttons button dropdown-button\" bs-popover\n                        data-content-template=\"partials/releases/template-export-dropdown.html\"\n                        data-placement=\"bottom\"\n                        auto-close=\"true\">\n                    <span>Export</span>\n                    <i class=\"xl-icon arrow-down-icon icon-s\"/>\n                </button>\n                <a ng-if=\"countPhasesDone(release) > 0 && !areDonePhasesCollapsed(release) && !isReleaseCompleted(release)\"\n                   class=\"button collapse-completed-phases\"\n                   ng-click=\"toggleDonePhasesCollapseState(release)\">Hide completed</a>\n                <span ng-if=\"isReleasePlanned(release) && release.autoStart\" class=\"xl-icon pending-icon\"\n                      bs-tooltip\n                      placement=\"bottom\"\n                      data-container=\"body\"\n                      data-title=\"Start date scheduled on\n                        {{release.scheduledStartDate | date: \'mediumDate\'}}\n                        {{release.scheduledStartDate | date: \'shortTime\'}}.\">\n                </span>\n                <a ng-if=\"isReleasePlanned(release) && security.hasPermission(\'release#start\', release)\" modal=\"\'partials/releases/start-release-modal.html\'\"\n                   class=\"start-release primary button\">Start Release</a>\n\n                <a ng-if=\"showNewReleaseButton()\" class=\"new-release button primary\"\n                   ng-href=\"#/releases/create?fromTemplateId={{ release.id }}\">New release</a>\n\n                <span doc-icon=\"release-flow-editor.html\"></span>\n            </div>\n            <div class=\"release-status-line\" ng-if=\"release.status !== \'TEMPLATE\'\">\n                <release-status-label release=\"release\"></release-status-label>\n                <release-progress-bar progress=\"release.extensions.progress\"></release-progress-bar>\n            </div>\n        </div>\n        <div id=\"release-content\" phase-sortable\n             ng-class=\"{\'navigator-opened\': showNavigator, \'release\': release.status != \'TEMPLATE\', \'template\': release.status === \'TEMPLATE\'}\">\n            <div class=\"phase collapsed drag-disabled\" ng-if=\"areDonePhasesCollapsed(release)\">\n                <div class=\"phase-header-wrapper\">\n                    <div class=\"phase-header\">\n                    <span class=\"phase-title\">\n                        <span ng-pluralize\n                              count=\"countPhasesDone(release)\"\n                              when=\"{\'1\': \'One phase\', \'other\': \'{} phases\'}\"></span>&nbsp;completed\n                    </span>\n                    </div>\n                </div>\n                <div class=\"phase-content\">\n                    <a ng-click=\"toggleDonePhasesCollapseState(release)\" class=\"expand link light-text\" stop-click-propagation>View all completed phases</a>\n                </div>\n            </div>\n            <div class=\"phase pull-left overflow\"\n                 ng-repeat=\"phase in release.phases | filter:collapseFilter(release) track by phase.id\"\n                 ng-class=\"{\'drag-disabled\': !isPhasePlanned(phase) || !security.hasEditPermission(release), \'done\': isPhaseReadOnly(phase)}\"\n                 ng-controller=\"ContainerController\">\n                <div class=\"phase-header-wrapper\" ng-class=\"{\'critical\': isCritical(phase) && isReleaseCompleted(release)}\">\n                    <div class=\"phase-header phase-sort-handle\" ng-style=\"{\'border-top-color\': phase.color}\"\n                         ng-class=\"{\'active-phase\': isPhaseInProgress(phase), \'planned-phase\': isPhasePlanned(phase), \'critical\': isCritical(phase) && isReleaseCompleted(release)}\">\n                        <div class=\"expander\" ng-if=\"isPhasePlanned(phase)\">\n                            <i class=\"xl-icon\"\n                               ng-class=\"{\'arrow-down-icon\': !collapsedPhases[phase.id], \'arrow-right-icon\': collapsedPhases[phase.id]}\"\n                               ng-click=\"togglePlannedPhaseCollapseState(phase)\"></i>\n                        </div>\n                        <div ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" class=\"phase-title\" inline-text-editor model=\"phase.title\"\n                             on-change=\"updatePhase(phase)\" required>\n                            <span display-variables=\"phase.title\" variables=\"release.variables\"></span>\n                        </div>\n                        <span ng-if=\"isPhaseReadOnly(phase) || !security.hasEditPermission(release)\" class=\"phase-title\">\n                            <span class=\"display-text\">{{phase.title}}</span>\n                        </span>\n                        <div class=\"actions\">\n                        <span ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" color-picker colors=\"PhaseColors\"\n                              current-color=\"phase.color\" tooltip=\"\'Select phase color\'\" on-change=\"updatePhaseColor(phase, color)\" class=\"pick-color\"></span>\n                            <span ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" ng-click=\"duplicatePhase(phase)\"\n                                  class=\"duplicate-phase\"\n                                  tooltip=\"\'Duplicate phase\'\"><i class=\"xl-icon duplicate-icon\"></i></span>\n                            <span modal=\"\'partials/releases/phase-details-modal.html\'\" on-modal-hide=\"loadReleaseAfterPhaseUpdate()\">\n                                <span class=\"phase-details\" tooltip=\"\'Phase details\'\"><i class=\"xl-icon edit-icon\"></i></span>\n                            </span>\n                            <span ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release) && !isPhaseInProgress(phase)\"\n                                  modal=\"\'partials/releases/delete-phase-modal.html\'\">\n                                <span class=\"delete-phase\" tooltip=\"\'Delete phase\'\"><i class=\"xl-icon delete-icon\"></i></span>\n                            </span>\n                        </div>\n                    </div>\n                </div>\n\n                <div class=\"phase-wrapper\">\n                    <span ng-if=\"isRequestedOrPhaseInProgress(phase)\" scroll-to-me></span>\n                    <div ng-if=\"!isPhasePlanned(phase) || (isPhasePlanned(phase) && !collapsedPhases[phase.id])\" class=\"phase-content\"\n                         ng-class=\"{\'critical\': isCritical(phase) && isReleaseCompleted(release)}\">\n                        <div class=\"phase-content-inner\">\n                            <ul task-sortable ng-model=\"phase.tasks\" data-container-id=\"{{phase.id}}\" class=\"task-sortable\"\n                                ng-class=\"{\'drop-disabled\': isPhaseReadOnly(phase) || !security.hasEditPermission(release)}\">\n                                <li ng-repeat=\"task in phase.tasks | filter:taskFilter(release, filters) track by task.id\" class=\"item-sortable\"\n                                    ng-class=\"{\'drag-disabled\': !isTaskDraggable(task, phase) || !security.hasEditPermission(release)}\">\n                                    <div ng-include=\"\'partials/releases/task-in-release.html\'\"></div>\n                                </li>\n                            </ul>\n                            <div ng-if=\"!isPhaseReadOnly(phase) && security.hasEditPermission(release)\" quick-task-generator add-task=\"addTask(phase, taskForm)\"\n                                 task-definitions=\"taskDefinitions\" class=\"task-generator\"></div>\n                        </div>\n                    </div>\n                    <div class=\"phase-content\" ng-if=\"isPhasePlanned(phase) && collapsedPhases[phase.id]\">\n                        <div class=\"phase-content-inner\">\n                            <div class=\"view-nested-tasks\">\n                                <a class=\"link light-text\" ng-click=\"togglePlannedPhaseCollapseState(phase)\">\n                                    View <span ng-pluralize count=\"getLeafTasks(phase).length\"\n                                               when=\"{\'0\': \'{} tasks\', \'1\': \'one task\', \'other\': \'{} tasks\', \'many\': \'{} tasks\', \'few\': \'{} tasks\'}\"></span>\n                                </a>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/release-flow-header.html","<div id=\"release-header\" class=\"header\" ng-controller=\"releaseHeaderController\">\n    <div class=\"subpage-links\">\n        <span class=\"show-label visible-lg-inline\">Show</span>\n        <button type=\"button\" class=\"button dropdown-button\" bs-popover data-content-template=\"partials/releases/subpages.html\" data-placement=\"bottom\"\n                auto-close=\"true\">\n            {{ page.label }}\n            <span class=\"caret\"></span>\n        </button>\n    </div>\n    <div class=\"btn-group btn-group-padding\">\n        <a class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'\')}\" ng-href=\"#/{{releaseTemplateVariable}}/{{release.id}}\">\n            <i class=\"xl-icon column-icon\"/><span class=\"visible-lg-inline\">Flow</span>\n        </a>\n        <a class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'/table\')}\" ng-href=\"#/{{releaseTemplateVariable}}/{{release.id}}/table\">\n            <i class=\"xl-icon table-icon\"/><span class=\"visible-lg-inline\">Table</span>\n        </a>\n        <a class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'/planner\')}\"\n           ng-href=\"#/{{releaseTemplateVariable}}/{{release.id}}/planner\">\n            <i class=\"xl-icon planner-icon\"/><span class=\"visible-lg-inline\">Planner</span>\n        </a>\n        <a ng-if=\"release.status == \'TEMPLATE\'\" class=\"btn btn-flat btn-fixed\" ng-class=\"{\'btn-flat-active\': isActive(\'/releasefile\')}\"\n           ng-href=\"#/templates/{{release.id}}/releasefile?\">\n            <i class=\"xl-icon code-icon\"/><span class=\"visible-lg-inline\">Releasefile</span>\n        </a>\n    </div>\n    <release-grid-actions-bar ng-if=\"selectedCount > 0 && isActive(\'/table\')\" class=\"buttons\"></release-grid-actions-bar>\n    <span class=\"actions\" ng-transclude ng-if=\"!isActive(\'/table\') || selectedCount === 0\"></span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/release-header.html","<div id=\"release-header\" class=\"header\">\n    <div class=\"subpage-links\" ng-if=\"isSubpageDropdownAvailable\">\n        <span class=\"show-label\">Show</span>\n        <button type=\"button\" class=\"button dropdown-button\" bs-popover\n                data-content-template=\"partials/releases/subpages.html\"\n                data-placement=\"bottom\"\n                auto-close=\"true\">\n            {{ page.label }} <span class=\"caret\"></span>\n        </button>\n    </div>\n\n    <span class=\"header-container-flex\" ng-transclude></span>\n</div>\n\n");
$templateCache.put("static/9.0.2/partials/releases/release-page-extension-container.html","<div ng-if=\"releasePageExtensionCtrl.pageExtension.uri\" ng-include=\"\'static/9.0.2/\' + releasePageExtensionCtrl.pageExtension.uri\"></div>\n<div ng-if=\"releasePageExtensionCtrl.pageExtension && !releasePageExtensionCtrl.pageExtension.uri\">\n    <div release-header></div>\n    <div class=\"content-under-header\">\n        <h4>\n            No <strong>uri</strong> parameter specified in release menu item [{{ releasePageExtensionCtrl.pageExtension.label }}]. Please check your plugin.\n        </h4>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/release-permissions.html","<div id=\"release-permissions\">\n    <div release-header>\n        <div class=\"buttons\">\n                <span class=\"last-saved\" ng-if=\"$ctrl.lastSavedDate\">Last saved on {{ $ctrl.lastSavedDate | date: \'medium\' }}</span>\n                <button class=\"button reset\" ng-click=\"$ctrl.reset()\" ng-disabled=\"!$ctrl.dirty || $ctrl.readOnly\">Reset</button>\n                <button class=\"button primary save\" ng-click=\"$ctrl.save()\" ng-disabled=\"!$ctrl.dirty || $ctrl.readOnly\">Save</button>\n                <span doc-icon=\"release-permissions.html\"></span>\n        </div>\n    </div>\n    <div class=\"ng-cloak content-under-header\">\n        <p ng-if=\"$ctrl.inherited\">Permissions and Teams are inherited from the folder\n            <span><a ng-href=\"#folders/{{$ctrl.inheritedFrom.id}}/permissions\">{{$ctrl.inheritedFrom.title}}</a></span>\n        </p>\n        <div id=\"teams-permissions-table\" ng-model=\"$ctrl.teamsCollapsed\" bs-collapse>\n            <div>\n                <h4 class=\"title\">\n                    <i class=\"xl-icon\" ng-class=\"{\'arrow-down-icon\': !$ctrl.teamsCollapsed, \'arrow-right-icon\': $ctrl.teamsCollapsed}\" bs-collapse-toggle></i>\n                    Teams\n                    <button class=\"button primary button-add-team\" ng-click=\"$ctrl.openAddTeamModal()\" ng-disabled=\"$ctrl.readOnly\">New team</button>\n                </h4>\n            </div>\n\n            <permission-table-v2\n                                 columns=\"$ctrl.teamsTableColumns\"\n                                 read-only=\"$ctrl.readOnly\"\n                                 permissions=\"$ctrl.teamsPermissionsContainer\"\n                                 on-update=\"$ctrl.setDirty()\"\n                                 on-remove=\"$ctrl.onRemoveTeam(row)\"\n                                 bs-collapse-target>\n            </permission-table-v2>\n        </div>\n        <div id=\"permissions-table\" ng-model=\"$ctrl.permissionsCollapsed\" bs-collapse>\n            <div>\n                <h4 class=\"title\">\n                    <i class=\"xl-icon\" ng-class=\"{\'arrow-down-icon\': !$ctrl.permissionsCollapsed, \'arrow-right-icon\': $ctrl.permissionsCollapsed}\" bs-collapse-toggle></i>\n                    {{$ctrl.isTemplate() ? \'Template permissions\' : \'Release permissions\'}}\n                </h4>\n            </div>\n            <permission-table-v2\n                columns=\"$ctrl.permissionsTableColumns\"\n                read-only=\"$ctrl.readOnly\"\n                permissions=\"$ctrl.permissionsContainers\"\n                on-update=\"$ctrl.setDirty()\"\n                bs-collapse-target>\n            </permission-table-v2>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/release-variables.html","<div id=\"release-variables\">\n    <div release-header>\n        <div class=\"filters actions\">\n            <input id=\"variables-filter\" autofocus type=\"search\" class=\"filter\" placeholder=\"Search...\" ng-model=\"filters.filter\">\n        </div>\n        <div class=\"buttons\">\n            <div class=\"btn-group\" data-ng-if=\"isInFolder\">\n                <a class=\"btn btn-flat\" ng-class=\"{\'btn-flat-active\': releaseVariable}\" ng-click=\"showReleaseVariable(true)\">\n                    Release variables\n                </a>\n                <a class=\"btn btn-flat\" ng-class=\"{\'btn-flat-active\': !releaseVariable}\" ng-click=\"showReleaseVariable(false)\">\n                    Folder variables\n                </a>\n            </div>\n            <button ng-if=\"!readonly\" edit-variable\n                    data-ng-disabled=\"!releaseVariable\"\n                    init-variable=\"newVariable()\"\n                    save=\"createReleaseVariable\"\n                    on-new-variable=\"createReleaseVariable\"\n                    is-new=\"true\"\n                    is-readonly=\"false\"\n                    is-rename-enabled=\"true\"\n                    page-type=\"pageType\"\n                    all-variables=\"allVariables\"\n                    class=\"button primary new-variable\">New variable\n            </button>\n            <span doc-icon=\"variables.html\"></span>\n        </div>\n    </div>\n    <div id=\"variables-content\" class=\"content-under-header\">\n        <div ng-if=\"releaseVariable\"\n             variables-list\n             variables=\"variables\"\n             all-variables=\"allVariables\"\n             filter=\"filters.filter\"\n             on-change=\"updateReleaseVariable\"\n             on-delete=\"deleteReleaseVariable(variable, callback)\"\n             on-reorder=\"reorderReleaseVariables(variables)\"\n             on-new-variable=\"createReleaseVariable\"\n             is-readonly=\"readonly\"\n             is-rename-enabled=\"!readonly && (release.status === \'PLANNED\' || release.status === \'TEMPLATE\')\"\n             page-type=\"pageType\"></div>\n\n        <div ng-if=\"!releaseVariable\"\n             variables-list\n             variables=\"folderVariables\"\n             all-variables=\"folderVariables\"\n             filter=\"filters.filter\"\n             is-readonly=\"true\"\n             show-folder-path=\"true\"\n             is-rename-enabled=\"false\"\n             page-type=\"\'FOLDER\'\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/restart-phases-modal.html","<div class=\"modal-content restart-phases-modal\" ng-controller=\"restartPhasesController as $ctrl\">\n    <form name=\"restartPhaseForm\" id=\"restartPhaseForm\" class=\"form-horizontal\">\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n            <h4>Restart phase in \'{{ release.title }}\'</h4>\n        </div>\n        <div ng-if=\"!$ctrl.releaseRestored\">\n            <div class=\"modal-body\">\n                <div class=\"form-group\">\n                    <span class=\"col-sm-3 control-label\">Phase version</span>\n                    <span class=\"col-sm-9\">\n                        <select data-test=\"phaseType\"\n                                ng-change=\"$ctrl.onTypeChange()\"\n                                ng-model=\"$ctrl.phaseType\"\n                                ng-options=\"type as type.label for type in $ctrl.restartPhaseTypes track by type.type\">\n                        </select>\n                    </span>\n                </div>\n                <div class=\"form-group\">\n                    <span class=\"col-sm-3 control-label\">Select phase to restart from</span>\n                    <span class=\"col-sm-9\">\n                        <select data-test=\"fromPhase\"\n                                ng-change=\"$ctrl.onPhaseChange()\"\n                                ng-model=\"$ctrl.fromPhase\"\n                                ng-options=\"phase as $ctrl.interpolate(phase.title) for phase in $ctrl.phases2restart\">\n                        </select>\n                    </span>\n                </div>\n                <div class=\"form-group\" ng-show=\"$ctrl.canSelectTasks()\">\n                    <span class=\"col-sm-3 control-label\">Task to start with</span>\n                    <span class=\"col-sm-9\">\n                        <select data-test=\"fromTask\"\n                                ng-model=\"$ctrl.fromTask\"\n                                ng-options=\"task as $ctrl.interpolate(task.title) for task in $ctrl.tasks2restart\">\n                        </select>\n                    </span>\n                </div>\n                <p>\n                    The remaining tasks in the current phase will be skipped, and the release will be paused. When resumed, the release will continue from the first task of the recreated phases.\n                </p>\n            </div>\n            <div class=\"modal-footer\">\n                <div class=\"pull-left\" ng-if=\"$ctrl.phaseRestartInProgress\">\n                    Restarting phase<img src=\"static/9.0.2/styles/img/ajax-loader.gif\"/>\n                </div>\n                <button class=\"button cancel\"\n                        ng-click=\"$ctrl.dismiss()\"\n                        ng-disabled=\"$ctrl.phaseRestartInProgress\"\n                        type=\"button\">\n                    Cancel\n                </button>\n                <button class=\"button continue primary\"\n                        ng-click=\"$ctrl.restartPhasesFrom($ctrl.phaseType)\"\n                        ng-disabled=\"$ctrl.phaseRestartInProgress\"\n                        type=\"button\">\n                    Continue\n                </button>\n            </div>\n        </div>\n        <div ng-if=\"$ctrl.releaseRestored\">\n            <div class=\"modal-body\">\n                <p ng-pluralize\n                   count=\"$ctrl.numberOfPhaseRestarted\"\n                   when=\"{\'one\': \'The new phase was added and the release has been paused.\',\n                          \'other\': \'The new phases were added and the release has been paused. \'}\"></p>\n                <p>You can resume the release now or later. By choosing \'Resume now\' you will continue the release flow immediately. If you want to review the newly added phase first or change release variables before carrying on, choose \'Resume later\'.</p>\n            </div>\n            <div class=\"modal-footer\">\n                <button class=\"button resume-later\"\n                        ng-click=\"$ctrl.dismiss()\"\n                        ng-disabled=\"restartPhaseForm.$invalid\"\n                        type=\"button\">\n                    Resume later\n                </button>\n                <button class=\"button resume-now primary\"\n                        ng-click=\"$ctrl.resumeRelease(release);$ctrl.dismiss()\"\n                        ng-disabled=\"restartPhaseForm.$invalid\"\n                        type=\"button\">\n                    Resume now\n                </button>\n            </div>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/start-release-modal-ctrl-binding.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4>{{ctrl.release.title}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to start a release.\n        Team members will be notified and once the release start date has been reached, the release flow will commence.\n    </div>\n    <div class=\"modal-body\" ng-if=\"ctrl.release.autoStart\">\n        This release is scheduled to start <strong>automatically</strong> on\n        {{::ctrl.release.scheduledStartDate | date: \'mediumDate\'}}\n        {{::ctrl.release.scheduledStartDate | date: \'shortTime\'}}.\n        Are you sure you want to start the release now?\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.onStart(ctrl.release);dismiss()\">Start</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/start-release-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4>{{release.title}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to start a release.\n        Team members will be notified and once the release start date has been reached, the release flow will commence.\n    </div>\n    <div class=\"modal-body\" ng-if=\"release.autoStart\">\n        This release is scheduled to start <strong>automatically</strong> on\n        {{::release.scheduledStartDate | date: \'mediumDate\'}}\n        {{::release.scheduledStartDate | date: \'shortTime\'}}.\n        Are you sure you want to start the release now?\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"startRelease(release);dismiss()\">Start</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/subpages.html","<div id=\"subpages-container\">\n    <span>\n        <a ng-repeat=\"subpage in releaseSubpages\"\n           ng-href=\"{{getSubpageLink(subpage)}}\"\n           ng-if=\"isSubpageDisplayed(subpage)\"\n           class=\"{{subpage.class}}\">\n            <div><span ng-class=\"{\'active\': page === subpage}\"></span> {{ subpage.label }}</div>\n        </a>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/task-in-release.html","<div class=\"arrow-wrapper\">\n    <i class=\"xl-icon arrow-right-icon task-status\" ng-show=\"isTaskOrPreconditionInProgress(task) && !isTaskGroup(task)\"></i>\n</div>\n<div class=\"task-container task-sort-handle {{task.type | taskTypeCssClass}} {{ task.status | lowercase}}\" ng-class=\"{\'done\': isTaskReadOnly(task), \'active\': isTaskOrPreconditionInProgress(task), \'release-completed\': isReleaseCompleted(release)}\">\n    <div ng-controller=\"taskDetailsController\" class=\"task-box row-fluid {{task.type | taskTypeCssClass}}\" ng-style=\"{\'border-top-color\': isReleaseCompleted(release) ? \'\' : task.color }\" ng-class=\"{\'active\': isTaskOrPreconditionInProgress(task), \'done\': isTaskReadOnly(task), \'planned\': isTaskPlanned(task), \'release-completed\': isReleaseCompleted(release), \'locked\': isLocked(task)}\">\n        <div class=\"task {{task.type | taskTypeCssClass}}  {{ task.status | lowercase}}\" ng-class=\"{\'active\': isTaskOrPreconditionInProgress(task)}\">\n            <div class=\"pull-left expander\" ng-if=\"isTaskGroup(task)\">\n                <i ng-class=\"{\'xl-icon arrow-down-icon\': !isCollapsed, \'xl-icon arrow-right-icon\': isCollapsed}\" ng-click=\"toggleTaskGroupCollapseState(task)\"></i>\n            </div>\n\n            <div context-menu-popover\n                 items=\"taskContextMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout)\" scrollable-change-task-type=\"true\"></div>\n            <div class=\"cursor-pointer\" ng-click=\"openTaskDetailsModal(task)\" ng-init=\"openTaskDetailsModalIfRequested(task)\">\n                <div class=\"labels\" ng-if=\"isTaskDisabledInView(task)\">\n                    <span class=\"pull-right xl-icon pending-icon\"></span>\n                </div>\n                <div class=\"labels\" ng-if=\"!isTaskDisabledInView(task)\">\n                    <span ng-if=\"isTaskFlagged(task)\" class=\"pull-right risk-flag-icon-container\">\n                        <span class=\"risk-flag-icon xl-icon {{ task.flag.status | lowercase }}\" tooltip=\"task.flag.comment\"></span>\n                    </span>\n                    <span ng-if=\"isTaskPending(task)\" class=\"pull-right pending xl-icon pending-icon\" scheduled-start-date-tooltip=\"task.scheduledStartDate\"></span>\n                    <span ng-if=\"isTaskSkipped(task) || isTaskSkippedInAdvance(task)\" class=\"pull-right label label-default\">Skipped</span>\n                    <span ng-if=\"isTaskFailed(task)\" class=\"pull-right label label-warning-failed\">Failed</span>\n                    <span ng-if=\"isTaskFailing(task)\" class=\"pull-right label label-warning-failing\">Failing</span>\n                    <span ng-if=\"isTaskWaitingForInput(task)\" class=\"pull-right label label-waiting\">Needs input</span>\n                    <span ng-if=\"isTaskAborted(task)\" class=\"pull-right label label-default\">Aborted</span>\n                    <span ng-if=\"isTaskInProgress(task)\" class=\"pull-right label label-inprogress\">In progress</span>\n                    <span ng-if=\"isTaskDelayedDuringBlackout(task)\" class=\"pull-right xl-icon circle-minus-icon\" bs-tooltip data-title=\"Postpone during blackout\" data-container=\"body\"></span>\n                    <span ng-if=\"isTaskPreconditionInProgress(task)\" class=\"pull-right label label-preconditioninprogress\">Precondition</span>\n                    <span ng-if=\"isTaskFacetInProgress(task)\" class=\"pull-right label label-preconditioninprogress\">Verifying</span>\n                    <span ng-if=\"isTaskFailureHandlerInProgress(task)\" class=\"pull-right label label-warning-failing\">Handling failure</span>\n                    <span ng-if=\"isUserInputTask(task)\" class=\"pull-right xl-icon keyboard-icon\"></span>\n                    <span ng-if=\"isNotificationTask(task)\" class=\"pull-right xl-icon mail-icon\"></span>\n                    <span ng-if=\"isScriptTask(task)\" class=\"xl-icon script-icon pull-right\"></span>\n                    <span ng-if=\"isGateTask(task)\" class=\"pull-right xl-icon marker-check-icon\"></span>\n                    <span ng-if=\"isParallelGroup(task)\" class=\"pull-right xl-icon parallel-icon\"></span>\n                    <span ng-if=\"isSequentialGroup(task)\" class=\"pull-right xl-icon sequential-icon\"></span>\n                    <span ng-if=\"isCreateReleaseTask(task)\" class=\"pull-right xl-icon add-icon\"></span>\n                    <span ng-if=\"isManualTask(task) && task.owner\" class=\"pull-right xl-icon user-icon\"></span>\n                    <span ng-if=\"isManualTask(task) && !task.owner\" class=\"pull-right xl-icon users-icon\"></span>\n                    <span ng-if=\"task.precondition && task.preconditionEnabled\" class=\"pull-right xl-icon precondition-icon\"></span>\n                    <span ng-if=\"task.taskFailureHandlerEnabled && task.failureHandlerEnabled\" class=\"pull-right xl-icon failure-handler-icon\"></span>\n                    <span ng-if=\"isCustomScriptTask(task) && !task.customIconLocation\" class=\"pull-right xl-icon script-icon\"></span>\n                    <span ng-if=\"isCustomScriptTask(task) && task.customIconLocation\" class=\"pull-right custom-script-image\">\n                        <img ng-src=\"static/9.0.2/{{ task.customIconLocation }}\">\n                    </span>\n                </div>\n                <div class=\"task-header\">\n                    <i class=\"xl-icon lock-icon\" data-ng-if=\"isLocked(task)\"></i> <span class=\"task-title\" display-variables=\"task.title\" variables=\"release.variables\"></span>\n                </div>\n                <span ng-if=\"isCustomScriptTask(task) && isTaskInProgress(task) && task.statusLine\" class=\"status-line\">\n                    {{task.statusLine}}\n                </span>\n\n                <span ng-if=\"isCreateReleaseTask(task) && isTaskCompleted(task) && task.createdReleaseId\"\n                      class=\"status-line\" ng-init=\"internalId = getInternalId(task.createdReleaseId)\"\n                      ng-click=\"preventBubblingEvent($event)\">\n                    <a href=\"#/releases/{{internalId}}\">{{task.createdReleaseTitle}}</a>\n                </span>\n\n                <span ng-if=\"shouldTaskShowStatusLine(task) && isTaskCompleted(task) && (task.statusLine.indexOf(\'Running\') === -1)\" class=\"status-line\"  ng-click=\"preventBubblingEvent($event)\" >\n                   <span markdown slim display-variables=\"task.statusLine\"> </span>\n                </span>\n\n                <div class=\"task-infos\" ng-if=\"!isAutomated(task) && !isTaskGroup(task) && !isReleaseCompleted(release)\">\n                    <span class=\"pull-left\" ng-show=\"task.owner\" display-user=\"task.owner\" variables=\"release.variables\"></span>\n                    <span class=\"pull-left\" ng-show=\"!task.owner && task.team\">{{task.team}}</span>\n                    <span ng-if=\"(isTaskPlanned(task) || isTaskPending(task)) && task.scheduledStartDate\" class=\"pull-right\">\n                        <span ng-if=\"task.waitForScheduledStartDate\">Starts&nbsp;</span>\n                        {{task.scheduledStartDate | dateFormatter}} at {{ task.scheduledStartDate | date:\'shortTime\' }}\n                    </span>\n                    <span ng-if=\"(isTaskInProgress(task) || !task.scheduledStartDate && !task.endDate) && task.dueDate\" class=\"pull-right\" ng-class=\"{\'date-overdue\': isOverdue(task.dueDate)}\">{{task.dueDate | dateFormatter}}</span>\n                    <span ng-if=\"isTaskCompleted(task) || isTaskSkipped(task)\" class=\"pull-right\">{{ getCIDuration(task) | duration }}</span>\n                    <span ng-if=\"isTaskCompletedInAdvance(task)\" class=\"pull-right\">Completed on {{task.endDate | date:\'shortDate\'}}</span>\n                    <span ng-if=\"isTaskSkippedInAdvance(task)\" class=\"pull-right\">Skipped on {{task.endDate | date:\'shortDate\'}}</span>\n                </div>\n                <div class=\"task-infos\" ng-if=\"isAutomated(task) && !isReleaseCompleted(release)\">\n                    <span ng-if=\"isTaskCompleted(task) || isTaskSkipped(task)\" class=\"pull-right\">{{ getCIDuration(task) | duration }}</span>\n                    <span ng-if=\"isCustomScriptTask(task)\" class=\"pull-left\">{{ task.typeDisplayGroup }}: {{ task.typeDisplayName }}</span>\n                </div>\n                <div class=\"task-infos\" ng-if=\"isReleaseCompleted(release) && !isTaskGroup(task)\">\n                    <span class=\"flag-count\"\n                          ng-show=\"task.flagsCount\"\n                          tooltip=\"\'Has been flagged\'\">\n                        <i class=\"xl-icon flag-none-icon icon-s\" />\n                    </span>\n                    <span class=\"failure-count\"\n                          ng-show=\"task.failuresCount == 1\"\n                          tooltip=\"\'Failed once\'\">\n                        <i class=\"xl-icon lightning-icon icon-s\" />\n                        1\n                    </span>\n                    <span class=\"failure-count\"\n                          ng-show=\"task.failuresCount > 1\"\n                          ng-class=\"{\'count-warning\': task.failuresCount >= getWarningThreshold(), \'count-error\': task.failuresCount >= getErrorThreshold()}\"\n                          tooltip=\"\'Failed \' + task.failuresCount + \' times\'\">\n                        <i class=\"xl-icon lightning-icon icon-s\" />\n                        {{task.failuresCount}}\n                    </span>\n                    <span class=\"delay-count\"\n                          ng-show=\"task.delaysCount == 1\"\n                          tooltip=\"\'Has been delayed\'\">\n                        <i class=\'xl-icon delay-icon icon-s\' />\n                    </span>\n                    <span class=\"pull-right\" ng-if=\"!isTaskGroup(task)\">{{ getCIDuration(task) | duration }}</span>\n                </div>\n                <div class=\"task-infos\" ng-if=\"isReleaseCompleted(release) && isTaskGroup(task) && isTaskGroupCollapsed(task)\">\n                    <task-counters flags-count=\"task.flagsCount\" delays-count=\"task.delaysCount\" failures-count=\"task.failuresCount\"></task-counters>\n                </div>\n            </div>\n            <div class=\"task-group\" ng-if=\"isTaskGroup(task) && !isCollapsed\" ng-controller=\"ContainerController\">\n                <ul task-sortable ng-model=\"task.tasks\" data-container-id=\"{{task.id}}\" class=\"task-sortable\" ng-class=\"{\'drop-disabled\': !isTaskGroupDroppable(task)}\">\n                    <li ng-repeat=\"task in task.tasks | filter:taskFilter(release, filters) track by task.id\" class=\"item-sortable\" ng-class=\"{\'drag-disabled\': !isTaskDraggable(task, container) || !security.hasEditPermission(release)}\">\n                        <div class=\"task-inner-active\" ng-include=\"\'partials/releases/task-in-release.html\'\"></div>\n                    </li>\n                </ul>\n                <div ng-if=\"canAddTask(release, task)\" quick-task-generator add-task=\"addTask(task, taskForm)\" task-definitions=\"taskDefinitions\" class=\"task-generator\"></div>\n            </div>\n            <div class=\"task-group\" ng-if=\"isTaskGroup(task) && isCollapsed\" ng-controller=\"ContainerController\">\n                <a class=\"link light-text view-nested-tasks\" ng-click=\"toggleTaskGroupCollapseState(task)\">\n                    View <span ng-pluralize count=\"getSubTasks(task).length\" when=\"{\'0\': \'{} tasks\', \'1\': \'one task\', \'other\': \'{} tasks\', \'many\': \'{} tasks\', \'few\': \'{} tasks\'}\"></span>\n                </a>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/template-export-dropdown.html","<div class=\"export-buttons-container\">\n    <span>\n        <a ng-if=\"release.status === \'TEMPLATE\'\" ng-click=\"exportZip(release)\">\n            <div>XLR Template</div>\n        </a>\n        <a ng-if=\"release.status === \'TEMPLATE\'\" ng-click=\"exportDsl(release)\">\n            <div>Releasefile (Groovy)</div>\n        </a>\n        <a ng-click=\"downloadExcel(release)\">\n           <div>Release audit report (Excel)</div>\n        </a>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/risks/custom-slider.html","<div class=\"rzslider\" style=\"text-overflow: clip;\">\n    <span class=\"rz-bar-wrapper rz-left-out-selection\"><span class=rz-bar></span></span> <!-- // 0 (left) Highlight outside two handles -->\n    <span class=\"rz-bar-wrapper rz-right-out-selection\"><span class=rz-bar></span></span> <!-- // 1 (right) Highlight outside two handles -->\n    <span class=\"rz-bar-wrapper\"><span class=\"rz-bar\"></span></span>\n    <!-- // 0 The slider bar -->\n    <span class=\"rz-bar-wrapper\">\n        <label class=\"attention-label\">Attention needed</label>\n        <i class=\"xl-icon circle-exclamation-icon icon-l risk-icon-yellow slider-icon\" />\n        <span class=\"rz-bar rz-selection\" ng-style=\"barStyle\"></span>\n    </span>\n    <!-- // 1 Highlight between two handles -->\n    <span class=\"rz-pointer rz-pointer-min\" ng-style=minPointerStyle>\n        <span class=\"rz-ruleset-pointer\" background-color=\"minPointerStyle.backgroundColor\" slider-rule ng-style=\"{\'color\': \'#fff\'}\">\n        </span>\n    </span>\n    <!-- // 2 Left slider handle -->\n    <span class=\"rz-pointer rz-pointer-max\"></span>\n    <!-- // 3 Right slider handle -->\n    <span class=\"rz-bubble rz-limit rz-floor\"></span>\n    <!-- // 4 Floor label -->\n    <span class=\"rz-bubble rz-limit rz-ceil\"></span>\n    <!-- // 5 Ceiling label -->\n    <span class=\"rz-bubble min-label\"></span>\n    <!-- // 6 Label above left slider handle -->\n    <span class=\"rz-bubble max-label\"></span>\n    <!-- // 7 Label above right slider handle -->\n    <span class=\"rz-bubble\"></span>\n    <!-- // 8 Range label when the slider handles are close ex. 15 - 17 -->\n    <ul ng-show=\"showTicks\" class=\"rz-ticks\">\n        <!-- // 9 The ticks -->\n        <li ng-repeat=\"t in ticks track by $index\" class=\"rz-tick\" ng-class=\"{\'rz-selected\': t.selected}\" ng-style=\"t.style\" ng-attr-uib-tooltip=\"{{ t.tooltip }}\"\n            ng-attr-tooltip-placement=\"{{t.tooltipPlacement}}\" ng-attr-tooltip-append-to-body=\"{{ t.tooltip ? true : undefined}}\">\n            <span ng-if=\"t.value != null\" class=\"rz-tick-value\" ng-attr-uib-tooltip=\"{{ t.valueTooltip }}\" ng-attr-tooltip-placement=\"{{t.valueTooltipPlacement}}\">{{ t.value }}</span>\n            <span ng-if=\"t.legend != null\" class=\"rz-tick-legend\">{{ t.legend }}</span>\n            <span ng-if=\"((rzSliderModel/2) | number:0) == $index\" class=\"green-value-text\" ng-show=\"rzSliderModel > 9\">\n                On track\n            </span>\n            <span ng-if=\"((rzSliderModel/2) | number:0) == $index\" ng-show=\"rzSliderModel > 3\"> <i class=\"xl-icon circle-check-icon icon-l risk-icon-green slider-icon\" /></span>\n            <span ng-if=\"(rzSliderHigh + ((100-rzSliderHigh)/2) | number:0) == $index\" class=\"red-value-text\" ng-show=\"rzSliderHigh < 92\">\n                At risk\n            </span>\n            <span ng-if=\"(rzSliderHigh + ((100-rzSliderHigh)/2) | number:0) == $index\" class=\"red-value-icon\"  ng-show=\"rzSliderHigh < 97\">\n                <i class=\"xl-icon circle-cross-icon icon-l risk-icon-red slider-icon\" />\n            </span>\n        </li>\n    </ul>\n</div>\n");
$templateCache.put("static/9.0.2/partials/risks/risk-settings.html","<div id=\"risk-settings\" class=\"standalone-form\">\n    <div id=\"risks-header\" class=\"header\">\n        <div class=\"actions\">\n            <input id=\"risk-profile-filter\" type=\"search\" class=\"risk-profile-filter\" placeholder=\"Search...\" ng-model=\"ctrl.searchQuery\">\n            <div class=\"buttons\">\n                <span ng-if=\"ctrl.globalRiskThresholds.lastSavedDate\" class=\"last-saved\">Last saved on {{ ctrl.globalRiskThresholds.lastSavedDate | date: \'medium\' }}</span>\n                <button ng-if=\"ctrl.hasEditRiskProfilePermission()\" class=\"button primary new-risk-profile\" ui-sref=\"riskProfile({riskProfileId: \'new\'})\">New risk profile</button>\n            </div>\n            <span doc-icon=\"configure-risk-settings.html\"></span>\n        </div>\n        \n    </div>\n    <br/>\n    <div class=\"content-under-header\">\n        <div>\n            <div class=\"global-risk-threshold-container row\">\n                <div class=\"col-md-3 global-risk-threshold-description-container\">\n                    <p class=\"risk-text-600\">Global risk threshold</p>\n                    <div class=\"global-risk-threshold-description\">The threshold value is used to determine when a release is marked with On track, Attention needed, or At risk. The Global Risk Threshold is used for every risk profile.</div>\n                </div>\n                <div class=\"col-md-6 col-md-offset-1 slider-wrapper\">\n                    <rzslider ng-if=\"ctrl.globalRiskThresholds.isInitialized\"\n                              class=\"custom-slider\" ng-class=\"{\'disabled\' : !ctrl.canEditAsAdmin()}\"\n                              rz-slider-model=\"ctrl.globalRiskThresholds.attentionNeededFrom\"\n                              rz-slider-high=\"ctrl.globalRiskThresholds.atRiskFrom\"\n                              rz-slider-options=\"ctrl.sliderOptions\"\n                              rz-slider-tpl-url=\"partials/risks/custom-slider.html\"></rzslider>\n                </div>\n                <div class=\"col-md-2 align-config-slider\">\n                    <a ng-if=\"!ctrl.canEdit() && ctrl.hasAdminPermission()\" class=\"link color-inherited risk-action\" ng-click=\"ctrl.editRisk()\" data-test=\"editThreshold\" id=\"editRisk\">\n                        <i title=\"Edit\" class=\"xl-icon edit-icon\"></i>\n                        <span>Edit</span>\n                    </a>\n                    <a class=\"link color-inherited risk-action\"\n                       id=\"submit\"\n                       ng-if=\"ctrl.canEdit() && ctrl.hasAdminPermission()\"\n                       ng-disabled=\"!ctrl.canEditAsAdmin()\"\n                       ng-click=\"ctrl.saveRisk()\"\n                       ng-style=\"{ \'margin-left\': \'5px\' }\"\n                    >\n                        <i title=\"Save\" class=\"xl-icon check-icon\"></i>\n                        <span>Save</span>\n                    </a>\n                    <a class=\"link color-inherited risk-action\"\n                       data-test=\"editThreshold\"\n                       ng-click=\"ctrl.cancelRiskEdit()\"\n                       ng-if=\"ctrl.canEdit() && ctrl.hasAdminPermission()\"\n                       ng-style=\"{ \'margin-left\': \'30px\' }\"\n                    >\n                        <i title=\"Cancel\" class=\"xl-icon close-icon\"></i>\n                        <span>Cancel</span>\n                    </a>\n                </div>\n                <div class=\"clear\">&nbsp;</div>\n            </div>\n\n            <div class=\"risk-profile-list-container\">\n                <div class=\"risk-profile-list\" ng-if=\"!ctrl.loading\">\n                    <div class=\"row-table container-fluid\" id=\"risk-profile-table\" ng-if=\"ctrl.filteredRiskProfiles().length\">\n                        <div class=\"header-row row\">\n                            <div class=\"col-xs-9 plm\">Risk profile name</div>\n                            <div ng-if=\"ctrl.hasEditRiskProfilePermission()\" class=\"col-xs-3\">Actions</div>\n                        </div>\n                        <div class=\"xl-dip-collection-of-ci row\">\n                            <div ng-repeat=\"rp in ctrl.filteredRiskProfiles()\" class=\"risk-profile\">\n                                <div class=\"data-row row ui-sortable\">\n                                    <div class=\"col-xs-9 plm\" ui-sref=\"riskProfile({riskProfileId: rp.id})\">{{ rp.title }}</div>\n                                    <div class=\"col-xs-3\">\n                                        <div class=\"row variable-actions\">\n                                            <div ng-if=\"!ctrl.notDefaultAndHasEditRiskProfilePermission(rp)\" class=\"col-md-12\">\n                                                <span class=\"action copy copy-action\" ng-click=\"ctrl.copy(rp.id)\" ng-if=\"ctrl.hasEditRiskProfilePermission()\">\n                                                    <i class=\"xl-icon duplicate-icon\"></i>Duplicate\n                                                </span>\n                                            </div>\n                                            <div ng-if=\"ctrl.notDefaultAndHasEditRiskProfilePermission(rp)\" class=\"col-md-12\">\n                                                <span class=\"action copy copy-action\" ng-click=\"ctrl.copy(rp.id)\">\n                                                    <i class=\"xl-icon duplicate-icon\"></i>Duplicate\n                                                </span>\n                                                <span class=\"action edit open-action\" ng-click=\"ctrl.editRiskProfile(rp)\" >\n                                                    <i class=\"xl-icon edit-icon\"></i>Edit\n                                                </span>\n                                                <span class=\"action remove remove-action\" ng-click=\"ctrl.deleteRiskProfile(rp)\">\n                                                    <i class=\"xl-icon delete-icon\"></i>Delete\n                                                </span>\n                                            </div>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n\n                <div ng-if=\"!ctrl.loading && !ctrl.filteredRiskProfiles().length\" class=\"alert notice\">\n                    No risk profiles found\n                </div>\n\n                <div ng-if=\"ctrl.loading\" class=\"spinner spinner-container\" style=\"text-align: center\">\n                    <img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/security/delete-user-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4>Delete User</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the user <b>{{user.username}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" focus-on=\"true\" ng-click=\"deleteUser(user);dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/security/permissions.html","<div id=\"permissions\">\n    <div id=\"permissions-header\" class=\"header\">\n        <div class=\"buttons\" ng-show=\"$ctrl.permissionsContainer.length > 0\">\n            <span class=\"last-saved\" ng-if=\"$ctrl.lastSavedDate\">Last saved on {{ $ctrl.lastSavedDate | date: \'medium\' }}</span>\n            <button class=\"button reset\" ng-click=\"$ctrl.reset()\" ng-disabled=\"!$ctrl.dirty\">Reset</button>\n            <button class=\"button save primary\" ng-click=\"$ctrl.save()\" ng-disabled=\"!$ctrl.dirty\">Save</button>\n        </div>\n        <span doc-icon=\"global-permissions.html\"></span>\n    </div>\n    <div class=\"ng-cloak content-under-header\">\n        <div class=\"help\">\n            Use this page to define which part of XL Release is accessible for its users. <br>\n            Permissions are set on roles – see the <a href=\"#/roles\">Roles screen</a>. <br>\n\n            After editing, press Save to apply the changes.\n        </div>\n        <permission-table-v2\n                columns=\"$ctrl.permissionsTableColumns\"\n                read-only=\"false\"\n                permissions=\"$ctrl.permissionsContainer\"\n                on-update=\"$ctrl.setDirty()\">\n        </permission-table-v2>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/security/task-access.html","<div id=\"task-access\">\n    <div id=\"task-access-header\" class=\"header\">\n        <div class=\"buttons\">\n            <span ng-if=\"$pageCtrl.lastSavedDate\" class=\"last-saved\">Last saved on {{ $pageCtrl.lastSavedDate | date: \'medium\' }}</span>\n            <span ng-click=\"!$pageCtrl.isUnchanged() && $pageCtrl.reset()\" class=\"button reset\" ng-disabled=\"$pageCtrl.isUnchanged()\" disabled=\"disabled\">Reset</span>\n            <span ng-click=\"$pageCtrl.save()\" class=\"button save primary\" ng-disabled=\"$pageCtrl.isUnchanged()\">Save</span>\n        </div>\n        <span doc-icon=\"task-access.html\"></span>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            On this page you can restrict task types to be used only by certain roles. See the <a ng-href=\"#/roles\">Roles screen</a> to see who is in a\n            role.<br>\n            After editing, press Save to apply the changes.\n        </div>\n\n        <form name=\"taskAccessForm\" confirm-leave>\n            <table class=\"table table-rounded table-striped\">\n                <thead>\n                <tr>\n                    <th class=\"title-column\">Task type</th>\n                    <th class=\"checkbox-column\">Available for all users</th>\n                    <th>Available to roles</th>\n                </tr>\n                </thead>\n                <tbody ng-repeat=\"taskAccesses in $pageCtrl.groupedTaskAccesses | toArray | orderBy:\'$key\'\">\n                <tr>\n                    <td colspan=\"3\" class=\"group\">\n                        {{taskAccesses.$key | capitalize}}\n                    </td>\n                </tr>\n                <tr ng-repeat=\"taskAccess in taskAccesses\">\n                    <td class=\"name title-column\">\n                        {{taskAccess.label}}\n                    </td>\n                    <td class=\"checkbox-column\">\n                        <input type=\"checkbox\" ng-model=\"taskAccess.allowedToAll\" ng-change=\"$pageCtrl.onCheckboxAllowToAllChange(taskAccess)\"/>\n                    </td>\n                    <td class=\"roles content-column\">\n                        <div class=\"roles transparent\"\n                             tags-input\n                             tags=\"taskAccess.roles\"\n                             placeholder=\"Add a role...\"\n                             completion-candidates=\"$pageCtrl.allRoles\"\n                             on-change=\"taskAccess.allowedToAll = false\">\n                        </div>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/security/user-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">\n            <i class=\"xl-icon close-icon\" />\n        </button>\n        <h4>User</h4>\n    </div>\n    <form name=\"userForm\" id=\"userForm\" class=\"form-horizontal\" novalidate\n          ng-submit=\"userForm.$valid && users.isFormValid() && users.saveUser(dismiss)\">\n        <div class=\"modal-body\">\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"username\">\n                    Username\n                    <span ng-show=\"userForm.username.$error.required\" class=\"error\">*</span>\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level\" id=\"username\" name=\"username\" ng-model=\"users.editedUser.username\" autofocus required ng-disabled=\"!users.newUser\"/>\n                    <span ng-show=\"users.conflict\" class=\"error\">User already exists</span>\n                    <span class=\"error\" ng-if=\"userForm.username.$error.required\">Username is required</span>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"full-name\">\n                    Name\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level\" id=\"full-name\" name=\"full-name\" ng-model=\"users.editedUser.fullName\"/>\n                </div>\n            </div>\n\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"email\">\n                    Email\n                    <span ng-show=\"userForm.email.$error.email\" class=\"error\">*</span>\n                </label>\n\n                <div class=\"col-sm-9\">\n                    <input type=\"email\" class=\"input-block-level\" id=\"email\" name=\"email\" ng-model=\"users.editedUser.email\"/>\n                    <span class=\"error\" ng-if=\"userForm.email.$error.email\">Malformed email address</span>\n                </div>\n            </div>\n\n            <div ng-if=\"isInternalUser(users.editedUser)\">\n                <div class=\"form-group\" data-ng-if=\"users.isPasswordConfirmationRequired()\">\n                    <label class=\"col-sm-3 control-label\" for=\"previousPassword\">\n                        <span>Previous password</span>\n                        <span class=\"error\" ng-if=\"users.editedUser.password !== \'\' && users.editedUser.previousPassword === \'\'\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level\" id=\"previousPassword\" name=\"previousPassword\"\n                               ng-model=\"users.editedUser.previousPassword\"/>\n                        <span class=\"error\" ng-if=\"users.editedUser.password !== \'\' && users.editedUser.previousPassword === \'\'\">Previous password is required</span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"password\">\n                        <span ng-show=\"users.newUser\">Set password</span>\n                        <span ng-hide=\"users.newUser\">Change password</span>\n                        <span class=\"error\" ng-if=\"userForm.password.$error.required\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level\" id=\"password\" name=\"password\"\n                               ng-model=\"users.editedUser.password\" ng-required=\"users.newUser\"/>\n                        <span class=\"error\" ng-if=\"userForm.password.$error.required\">Password is required</span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\" for=\"passwordConfirmation\">\n                        Confirm password\n                        <span class=\"error\" ng-if=\"userForm.password.$error.required\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-9\">\n                        <input type=\"password\" class=\"input-block-level\" id=\"passwordConfirmation\" name=\"passwordConfirmation\"\n                               ng-model=\"users.editedUser.passwordConfirmation\" ng-required=\"users.newUser\"/>\n                        <span class=\"error\" ng-if=\"users.editedUser.password != users.editedUser.passwordConfirmation\">Passwords don\'t match</span>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"button save primary\" ng-click=\"users.saveUser(dismiss)\" ng-disabled=\"userForm.$invalid || !users.isFormValid()\">Save</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/security/users.html","<div id=\"users\">\n    <div id=\"users-header\" class=\"header\">\n        <div class=\"actions\">            \n            <input type=\"search\" placeholder=\"Filter...\" ng-model=\"userFilter\">\n            <span ng-show=\"LimitedUsers.isEnabled()\" id=\"limited-users-message\">\n                <span ng-if=\"!LimitedUsers.maximumReached()\">\n                    You can allow <span ng-pluralize count=\"LimitedUsers.countLeft()\" when=\"{\'1\': \'1 more user\', \'other\': \'{} more users\', \'many\': \'{} more users\', \'few\': \'{} more users\'}\"></span> to login.\n                </span>\n                <span ng-if=\"LimitedUsers.maximumReached()\">\n                    You have reached the maximum number of users allowed to login by your license.\n                </span>\n            </span>\n            <div class=\"buttons\">\n                <span modal=\"\'partials/security/user-modal.html\'\" init=\"users.editNewUser()\" class=\"button primary new-user\">New user</span>\n            </div>\n            <span doc-icon=\"users.html\"></span>\n        </div>\n        \n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            <h4>XL Release users</h4>\n            Internal users are managed by XL Release and can be added and removed by an administrator. <br>\n            External users are maintained in an external system like Active Directory. <br>\n        </div>\n        <table class=\"table table-rounded table-striped\" ng-show=\"users.all.length > 0\">\n            <thead>\n                <tr>\n                    <th class=\"full-name-column\" ng-click=\"sortBy(\'fullName\')\">Name<i class=\"pull-right\" ng-show=\"sortColumn === \'fullName\'\" ng-class=\"toggleSortStyle()\"/></th>\n                    <th class=\"name-column\" ng-click=\"sortBy(\'username\')\">Username<i class=\"pull-right\" ng-show=\"sortColumn === \'username\'\" ng-class=\"toggleSortStyle()\"/></th>\n                    <th class=\"email-column\" ng-click=\"sortBy(\'email\')\">Email address<i class=\"pull-right\" ng-show=\"sortColumn === \'email\'\" ng-class=\"toggleSortStyle()\"/></th>\n                    <th class=\"last-active-column\" ng-click=\"sortBy(\'lastActive\')\">Last active<i class=\"pull-right\" ng-show=\"sortColumn === \'lastActive\'\" ng-class=\"toggleSortStyle()\"/></th>\n                    <th class=\"type-column\">Type</th>\n                    <th class=\"login-permission-column\">Enabled</th>\n                    <th>&nbsp;</th>\n                </tr>\n            </thead>\n            <tbody>\n                <tr ng-repeat=\"user in users.all | filter:userFilter | orderBy:sortColumn:sortDirection\" modal=\"\'partials/security/user-modal.html\'\" init=\"users.editUser(user)\">\n                    <td class=\"full-name\">{{ user.fullName }}</td>\n                    <td class=\"name\">{{ user.username }}</td>\n                    <td class=\"email\">{{ user.email }}</td>\n                    <td class=\"last-active\" ng-show=\"user.lastActive\">{{ user.lastActive | date: \'mediumDate\' }} - {{ user.lastActive | date: \'mediumTime\' }}</td>\n                    <td class=\"last-active\" ng-hide=\"user.lastActive\"><i>Never</i></td>\n                    <td class=\"type\">{{ (user.external) ? \'External\' : \'Internal\' }}</td>\n                    <td class=\"login-permission\" stop-click-propagation>\n                        <input type=\"checkbox\"\n                               ng-model=\"user.loginAllowed\"\n                               ng-show=\"!isUserNameAdmin(user.username)\"\n                               ng-disabled=\"LimitedUsers.maximumReached() && !user.loginAllowed\"\n                               ng-change=\"users.toggleLoginPermission(user)\"/>\n                    </td>\n                    <td ng-if=\"!isUserNameAdmin(user.username)\" class=\"delete-user action-column\" modal=\"\'partials/security/delete-user-modal.html\'\" stop-click-propagation><i class=\"xl-icon delete-icon\"/></td>\n                    <td ng-if=\"isUserNameAdmin(user.username)\" class=\"no-action\" stop-click-propagation>&nbsp;</td>\n                </tr>\n            </tbody>\n        </table>\n        <h3 ng-show=\"users.all.length == 0\">No users defined</h3>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/server-error/forbidden-access.html","<div class=\"content\" id=\"forbidden-access\">\n    <div class=\"standalone-form\">\n        <h3>Forbidden access</h3>\n        <p>Your request has been rejected, your permissions may have been revoked.</p>\n        <div ng-if=\"errorMessage\">\n            Error message :\n            <ul>\n                <li>{{errorMessage}}</li>\n            </ul>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/server-error/version-changed.html","<div class=\"modal-content about\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4>Version changed</h4>\n    </div>\n    <div class=\"modal-body\">\n        {{ versionChangedMessage }}\n        <br/>\n        <br/>\n        <button class=\"button primary\" ng-click=\"dismiss()\">Reload</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/settings/general-settings.html","<div id=\"general-settings\" class=\"standalone-form\">\n    <div id=\"general-settings-header\" class=\"header\">\n\n        <div class=\"buttons\">\n            <span ng-if=\"lastSavedDate\" class=\"last-saved\">Last saved on {{ lastSavedDate | date: \'medium\' }}</span>\n            <span ng-click=\"reset()\" class=\"button reset\" ng-disabled=\"isUnchanged()\">Cancel</span>\n            <button class=\"button submit primary\" ng-click=\"save()\" ng-disabled=\"isUnchanged()\">Save</button>\n        </div>\n        <span doc-icon=\"general-settings.html\"></span>    \n        \n    </div>\n    <div class=\"content-under-header\">\n        <form name=\"settingsForm\" class=\"form-horizontal\" confirm-leave>\n            <div class=\"help\">\n                After editing, press Save to apply the changes.\n            </div>\n\n            <div data-ng-repeat=\"plugin in pluginSettings\">\n                <fieldset data-ng-if=\"plugin.isPresent\">\n                    <legend>{{plugin.title}}</legend>\n                    <div class=\"help\" data-ng-if=\"!!plugin.help\">{{plugin.help}}</div>\n                    <div ng-repeat=\"property in pluginCIs[plugin.descriptorType].editableProperties\" dip-control large=\"true\" property=\"property\"\n                         container=\"pluginCIs[plugin.descriptorType].ci\"></div>\n                </fieldset>\n            </div>\n\n            <fieldset id=\"form-group\">\n                <legend>XL Release header</legend>\n                <div class=\"form-group header-settings\">\n                    <label class=\"col-sm-5 control-label header-color-label\">Header color</label>\n                    <div class=\"col-sm-7\">\n                        <div class=\"header-color\">\n                            <button color-picker colors=\"PhaseColors\"\n                                    current-color=\"themeSettings.ci.headerAccentColor\" tooltip=\"\'Select header color\'\" on-change=\"setHeaderColor(color)\"\n                                    class=\"pick-color\">\n                            </button>\n                        </div>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"col-sm-5 control-label\" for=\"header-form-title\">\n                        Instance name\n                    </label>\n                    <div class=\"col-sm-7\">\n                        <input type=\"text\" id=\"header-form-title\"\n                               name=\"title\"\n                               class=\"input-block-level\"\n                               ng-model=\"themeSettings.ci.headerName\"\n                               auto-focus>\n                        <span class=\"description\">\n                            Name that identifies the XL Release environment (for example, Development)\n                        </span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"col-sm-5 control-label\">Description</label>\n                    <div class=\"col-sm-7\">\n                        <span class=\"release-description\" inline-textarea-editor model=\"themeSettings.ci.description\"\n                              placeholder=\"Set description...\" markdown>\n                        <span display-variables=\"themeSettings.ci.description\" markdown class=\"markdown\"></span>\n                        </span>\n                    </div>\n                </div>\n                <div id=\"custom-logo-upload\" class=\"form-group\" upload upload-url=\"\'settings/custom-logo/upload\'\"\n                     on-success=\"customLogoAddedCallback(uploadResult)\">\n                    <label class=\"col-sm-5 control-label\">Logo file (26*26px)</label>\n                    <div class=\"col-sm-7\">\n                        <input id=\"custom-logo-image\" type=\"file\" ng-attr-accept=\"{{allowedContentType}}\"\n                               ng-model=\"file\" file-input class=\"hidden\"/>\n                        <label class=\"button button-choose-file\" for=\"custom-logo-image\" ng-disabled=\"UploadService.data.loading\">Choose file</label>\n                        <img src=\"static/9.0.2/styles/img/ajax-loader.gif\" ng-show=\"UploadService.data.loading\"/>\n\n                        <span ng-if=\"!isCustomLogoImageUndefined()\">\n                            <span class=\"uploaded-filename\" ng-attr-title=\"{{file || customLogoSettings.ci.filename}}\">{{file || customLogoSettings.ci.filename}}</span>\n                            <span ng-click=\"removeLoadedImage()\" class=\"custom-logo-remove\" alt=\"Remove custom logo\"><i class=\'xl-icon close-icon\'></i></span>\n                        </span>\n                        <span ng-if=\"isCustomLogoImageUndefined()\">No file chosen</span>\n\n                        <div class=\"error\" ng-show=\"UploadService.data.error\">\n                            An upload error occurred\n                            <!-- On IE9 the error message is not set since it\'s based on an iframe -->\n                            <span ng-show=\"UploadService.data.errorMessage\">: {{UploadService.data.errorMessage}}</span>\n                        </div>\n                    </div>\n                </div>\n            </fieldset>\n\n            <fieldset id=\"reports-settings\">\n                <legend>Reports</legend>\n                <div class=\"help\">\n                    XL Release will use these settings in the <a ng-href=\"#/release-value-stream\">Release Value Stream report</a>.\n                </div>\n                <div ng-repeat=\"property in reportsSettings.editableProperties\" dip-control large=\"true\" property=\"property\"\n                     container=\"reportsSettings.ci\"></div>\n            </fieldset>\n\n            <fieldset id=\"polling-settings\">\n                <legend>Task polling</legend>\n                <div class=\"help\">\n                    XL Release will use these settings to automatically refresh screens when task status change.\n                </div>\n                <div ng-repeat=\"property in pollingSettings.editableProperties\" dip-control large=\"true\" property=\"property\"\n                     container=\"pollingSettings.ci\"></div>\n            </fieldset>\n\n            <fieldset id=\"archiving-settings\">\n                <legend>Archiving</legend>\n                <div class=\"help\">\n                    XL Release will use these settings to archive completed releases. <br/> <strong>Note:</strong> Only archived releases appear in reports.\n                </div>\n\n                <div class=\"form-group archiving-settings-age\">\n                    <label class=\"col-sm-5 control-label\" for=\"archivingSettingsAge\">{{ getProperty(archivingSettings, \'releaseAgeToDeleteFromJcr\').label\n                        }}</label>\n                    <div class=\"col-sm-7\">\n                        <div class=\"row\">\n                            <div class=\"col-xs-8\">\n                                <input type=\"number\"\n                                       id=\"archivingSettingsAge\"\n                                       class=\"input-block-level\"\n                                       min=\"0\"\n                                       ng-model=\"archivingSettingsAge\"\n                                       required>\n                            </div>\n                            <div class=\"col-xs-4 age-unit-wrapper\">\n                                <select ng-model=\"archivingSettingsAgeUnit\"\n                                        ng-options=\"unit for unit in [\'Days\', \'Hours\']\"\n                                        ng-change=\"changeUnitType()\"></select>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </fieldset>\n\n            <fieldset id=\"audit-report-settings\">\n                <legend>Release audit reports</legend>\n                <div class=\"help\">\n                    XL Release will use these settings to delete release audit reports that have been generated on the server. After deletion, Release audit reports can no longer be downloaded.<br/>\n                </div>\n\n                <div class=\"form-group audit-report-retention-period\">\n                    <label class=\"col-sm-5 control-label\" for=\"auditReportRetention\">{{ getProperty(auditReportSettings, \'reportsRetentionPeriod\').label\n                        }}</label>\n                    <div class=\"col-sm-7\">\n                        <div class=\"row\">\n                            <div class=\"col-xs-8\">\n                                <input type=\"number\"\n                                       id=\"auditReportRetention\"\n                                       class=\"input-block-level\"\n                                       min=\"1\"\n                                       ng-model=\"auditReportRetentionPeriod\"\n                                       required>\n                            </div>\n                            <div class=\"col-xs-4 retention-period-unit-wrapper\">\n                                <div id=\"auditReportRetentionPeriodUnit\">Days</div>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </fieldset>\n        </form>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/smtp/smtp.html","<div id=\"smtp\" class=\"standalone-form\">\n    <div id=\"smtp-header\" class=\"header\">\n        <div class=\"buttons\">\n            <span ng-if=\"smtp.lastSavedDate\" class=\"last-saved\">Last saved on {{ smtp.lastSavedDate | date: \'medium\' }}</span>\n            <button ng-disabled=\"smtpForm.$invalid || invalidTestAddress(smtp.ci.testAddress) || isBusy\" id=\"submit\" class=\"button\" ng-click=\"testConfiguration()\">Send test notification</button>\n            <button ng-disabled=\"smtpForm.$invalid\" id=\"submit\" class=\"button primary\" ng-click=\"smtp.save()\">Save</button>    \n            <span doc-icon=\"smtp-server.html\"></span>\n        </div>\n        \n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            XL Release will use these settings to send notifications. <br><br>\n\n            After editing, press Save to apply the changes.\n        </div>\n        <div class=\"container-fluid\">\n            <div class=\"row\">\n                <div class=\"col-md-2\">\n                    <form name=\"smtpForm\" class=\"form-horizontal\" confirm-leave>\n                        <div ng-repeat=\"property in smtp.editableProperties\">\n                            <div dip-control property=\"property\" container=\"smtp.ci\"/>\n                        </div>\n                    </form>\n                </div>\n                <div class=\"col-md-10\"></div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/abort-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to abort the task.</p>\n\n        <form name=\"abortTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"abortComment\" placeholder=\"Give feedback or place a comment...\" required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.abortTask(task, abortComment);dismiss()\" ng-disabled=\"abortTaskForm.$invalid\">Abort</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/assignee.html","<span class=\"assignee\">\n    <span ng-if=\"owner || team\">\n        Assigned to\n\n        <span ng-if=\"owner.username == loggedUser.username\">me</span>\n        <span ng-if=\"owner && owner.username != loggedUser.username\" display-user=\"owner\" variables=\"variables\"></span>\n        <span ng-if=\"owner && team\" class=\'team-name\'>({{team}})</span>\n        <span ng-if=\"!owner && team\" class=\'team-name\'>{{team}}</span>\n    </span>\n    <span ng-if=\"!owner && !team\">\n        Not Assigned\n    </span>\n</span>\n");
$templateCache.put("static/9.0.2/partials/tasks/change-type-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4>Change Task Type</h4>\n    </div>\n    <div class=\"modal-body\">\n        The task type will be changed from <strong>{{task.typeDisplayName}}</strong> to <strong>{{item.taskDefinition.displayName}}</strong>.\n        <p><span ng-if=\"task.typeDisplayName != \'Manual\'\">XL Release will copy task properties where possible.</span></p>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" auto-focus ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.changeType(container, task, item.taskDefinition.typeName);dismiss()\">Change Task</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/change-type-submenu-item.html","<a tabindex=\"-1\" ng-click=\"!item.isSameType && openModal(\'partials/tasks/change-type-modal.html\', item)\"  class=\"task-definition-name\" ng-class=\"{\'current-type\': item.isSameType}\"\n   ng-disabled=\"item.disabled\" hide-popover-on-click>\n    <i ng-class=\"{\'xl-icon check-icon\': item.isSameType}\">&nbsp;</i>\n    <span>{{ item.taskDefinition.displayName }}</span>\n</a>\n");
$templateCache.put("static/9.0.2/partials/tasks/claim-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        Would you like to pick up the task?\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" auto-focus ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"assignToMe(task);dismiss()\">Assign to me</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/complete-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to complete the task.</p>\n        <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"completeComment\" placeholder=\"Give feedback or place a comment...\" auto-focus></textarea>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.completeTask(task, completeComment);dismiss()\">Complete</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/context-menu.html","<div class=\"popover\" tabindex=\"-1\">\n    <div class=\"arrow\"></div>\n    <div context-menu\n         id=\"context-menu-container\"\n         items=\"taskContextMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout)\"\n         ctrl=\"ctrl\"\n         task=\"task\"\n         container=\"container\">\n    </div>\n</div>");
$templateCache.put("static/9.0.2/partials/tasks/fail-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to fail the task.</p>\n\n        <form name=\"failTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"failComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.failTask(task, failComment);dismiss()\" ng-disabled=\"failTaskForm.$invalid\">Fail</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/filter.html","<div id=\"filter-container\">\n    <label class=\"filter-item\" for=\"display-active\">\n        <input type=\"checkbox\" ng-model=\"filters.active\" id=\"display-active\"/> Active tasks\n    </label>\n    <label class=\"filter-item\" for=\"display-me\">\n        <input type=\"checkbox\" ng-model=\"filters.assignedToMe\" id=\"display-me\"/> Assigned to me\n    </label>\n    <label class=\"filter-item\" for=\"display-teams\">\n        <input type=\"checkbox\" ng-model=\"filters.assignedToMyTeams\" id=\"display-teams\"/> Assigned to my teams\n    </label>\n     <label class=\"filter-item\" for=\"display-anybody\">\n         <input type=\"checkbox\" ng-model=\"filters.assignedToAnybody\" id=\"display-anybody\"/> Assigned to anybody\n     </label>\n    <label class=\"filter-item\" for=\"display-not-assigned\">\n        <input type=\"checkbox\" ng-model=\"filters.notAssigned\" id=\"display-not-assigned\"/> Not assigned\n    </label>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/quick-task-generator.html","<a class=\"add-task link\" ng-hide=\"showForm || taskGeneratorDisabled\">Add task</a>\n<div ng-show=\"showForm\" class=\"form-container\">\n    <form name=\"quickTaskForm\" class=\"form-horizontal\">\n        <input type=\"text\" class=\"quick-title\" ng-model=\"title\" placeholder=\"Task title...\" required/><br>\n        <div class=\"quick-controls-container\">\n            <xlr-multilevel-dropdown\n                    append-to=\"body\"\n                    class=\"task-type\"\n                    items=\"groupedTaskDefinitions\"\n                    on-select=\"onSelect($locals)\"\n                    selected-item-id=\"{{ taskType }}\"\n                    selected-item=\"{{ taskTypeName }}\"\n            ></xlr-multilevel-dropdown>\n            <div class=\"button-container pull-right\">\n                <a class=\"button cancel\">Cancel</a>\n                <a class=\"button add primary\" ng-disabled=\"quickTaskForm.$invalid\">Add</a>\n            </div>\n        </div>\n    </form>\n    <div class=\"clearfix\"></div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/reopen-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to reopen the task.</p>\n\n        <form name=\"reopenTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"reopenComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.reopenTask(task, reopenComment);dismiss()\" ng-disabled=\"reopenTaskForm.$invalid\">Reopen</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/retry-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to retry the task.</p>\n\n        <form name=\"retryTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"retryComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.retryTask(task, retryComment);dismiss()\" ng-disabled=\"retryTaskForm.$invalid\">Retry</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/skip-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to skip the task.</p>\n\n        <form name=\"skipTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"skipComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.skipTask(task, skipComment);dismiss()\" ng-disabled=\"skipTaskForm.$invalid\">Skip</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/start-task-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4 display-variables=\"task.title\" variables=\"release.variables\"></h4>\n    </div>\n    <div class=\"modal-body\">\n        <p>You are about to start the pending task.</p>\n\n        <form name=\"startTaskForm\">\n            <textarea rows=\"4\" class=\"input-block-level\" ng-model=\"startComment\" placeholder=\"Give feedback or place a comment...\" auto-focus required></textarea>\n            <div class=\"task-actions-info\" ng-if=\"task.delayDuringBlackout && ctrl.withinBlackout\">\n                <span class=\"error\">Are you sure you want to run this task during the blackout period?</span>\n            </div>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" ng-click=\"ctrl.startNow(task, startComment);dismiss()\" ng-disabled=\"startTaskForm.$invalid\">Start now</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/task-context-menu.html","<ul class=\"dropdown-menu\" role=\"menu\" ng-class=\"{\'active\': !level}\">\n    <li ng-if=\"item.type === \'modal\'\" ng-repeat-start=\"item in items\"\n        ng-class=\"{\'disabled\': item.disabled}\"\n        ng-mouseenter=\"mouseEnter($event, item)\">\n        <a class=\"{{ item.cssClass }}\"\n           hide-popover-on-click\n           ng-click=\"openModal(item.modal, item)\"\n           ng-disabled=\"item.disabled\"\n           tabindex=\"-1\">\n            {{ item.text }}\n        </a>\n    </li>\n    <li ng-if=\"item.type === \'click\'\"\n        ng-class=\"{\'disabled\': item.disabled}\"\n        ng-mouseenter=\"mouseEnter($event, item)\">\n        <a class=\"{{ item.cssClass }}\"\n           hide-popover-on-click\n           ng-click=\"item.disabled || handleClick(item)\"\n           ng-disabled=\"item.disabled\">\n            {{ item.text }}\n        </a>\n    </li>\n    <li ng-if=\"item.type === \'noAction\'\"\n        ng-class=\"{\'disabled\': item.disabled}\"\n        ng-mouseenter=\"mouseEnter($event, item)\">\n        <a tabindex=\"-1\" class=\"{{item.cssClass}}\">\n            {{ item.text }}\n        </a>\n    </li>\n    <li ng-if=\"item.type === \'submenu\' && item.items.length\"\n        class=\"dropdown-submenu\"\n        data-content-id=\"{{ getContentPath(path, item) }}\"\n        ng-class=\"{\'disabled\': item.disabled}\"\n        ng-mouseenter=\"mouseEnter($event, item)\">\n        <a tabindex=\"-1\" class=\"{{item.cssClass}}\">\n            {{ item.text }}\n        </a>\n        <div portal\n             ng-include=\"\'partials/tasks/task-context-menu.html\'\"\n             ng-init=\"items = item.items; level = +level + 1\">\n        </div>\n    </li>\n    <li ng-if=\"item.type === \'template\'\" ng-class=\"{\'disabled\': item.disabled}\" ng-include=\"item.templateUrl\"></li>\n    <li ng-if=\"item.type === \'divider\'\" ng-repeat-end class=\"divider\"></li>\n</ul>\n");
$templateCache.put("static/9.0.2/partials/tasks/task-labels.html","<div class=\"labels\">\n    <span ng-if=\"isTaskPlanned(task)\" class=\"label label-planned\">Planned</span>\n    <span ng-if=\"!isTaskAborted(task) && (isTaskCompleted(task) || isTaskCompletedInAdvance(task))\" class=\"label label-completed\">Completed</span>\n    <span ng-if=\"isTaskAborted(task)\" class=\"label label-default\">Aborted</span>\n    <span ng-if=\"isTaskSkipped(task) || isTaskSkippedInAdvance(task)\" class=\"label label-warning\">Skipped</span>\n    <span ng-if=\"isTaskFailed(task)\" class=\"label label-warning-failed\">Failed</span>\n    <span ng-if=\"isTaskFailing(task)\" class=\"label label-warning-failing\">Failing</span>\n    <span ng-if=\"isTaskWaitingForInput(task)\" class=\"label label-waiting\">Needs input</span>\n    <span ng-if=\"isTaskInProgress(task)\" class=\"label label-active\">In progress</span>\n    <span ng-if=\"isTaskPreconditionInProgress(task)\" class=\"pull-right label label-preconditioninprogress\">Precondition</span>\n    <span ng-if=\"isTaskFacetInProgress(task)\" class=\"pull-right label label-preconditioninprogress\">Verifying</span>\n    <span ng-if=\"isTaskPending(task)\" class=\"label label-pending\">Pending</span>\n    <span ng-if=\"isTaskFailureHandlerInProgress(task)\" class=\"label label-warning-failing\">Handling failure</span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/task.html","<div id=\"single-task\">\n    <div id=\"tasks-header\" class=\"header\">\n        <div class=\"filter-tasks actions\">\n            <span><span class=\"light-text\">Release: </span>\n                <a ng-if=\"security.hasViewPermission(release)\" href=\"#/releases/{{task.releaseId}}\" class=\"link\">{{task.releaseTitle}}</a>\n                <span ng-if=\"!security.hasViewPermission(release)\">{{task.releaseTitle}}</span>\n            </span>\n            <span><span class=\"light-text\">Phase: </span>{{task.phaseTitle}}</span>\n            <span><span class=\"light-text\">Task: </span>{{task.title}}</span>\n        </div>\n        <span doc-icon=\"task-overview.html\"></span>\n    </div>\n\n    <div id=\"tasks-content\" class=\"content-under-header\">\n        <task-list index=\"0\" tasks=\"tasks\" release=\"release\" on-task-details-closed=\"onTaskDetailsClosed()\" on-task-change=\"onTaskChange()\" show-task-details-modal=\"showTaskDetailsModal\"></task-list>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/tasks.html","<div id=\"tasks\">\n    <div id=\"tasks-header\" class=\"header\">\n        <div class=\"actions\">\n            <div class=\"filters\">\n                <div class=\"filter-tasks\" ng-controller=\"FiltersController\">\n                    <input class=\"filter first\" id=\"searchFilter\" type=\"text\" placeholder=\"Search...\" ng-model=\"filters.filter\" ng-model-options=\"{ debounce: 1200 }\">\n                    <button type=\"button\" class=\"button dropdown-button filter\" bs-popover data-content-template=\"partials/tasks/filter.html\" data-placement=\"bottom\" auto-close=\"true\">Filter options</button>\n                    <span class=\"filter\" ng-include=\"\'partials/filters/from-to-date-filters.html\'\" />\n                </div>\n                <order-selector class=\"filter\" on-select=\"onChange(order)\" order-by-values=\"orderByValues\"></order-selector>\n            </div>\n            <div class=\"buttons\">\n                <span doc-icon=\"task-overview.html\"></span>\n            </div>\n        </div>\n    </div>\n    <div id=\"tasks-content\" class=\"content-under-header container-fluid\">\n        <div class=\"alert too-many-results-alert\" ng-show=\"limitReached\">Some tasks are not shown because the filter produced too many results. Please narrow your search criteria.</div>\n        <div ng-repeat=\"release in releases\" data-release-title=\"{{release.title}}\">\n            <div expander=\"tasks{{$index}}\">\n                <fieldset>\n                    <legend class=\"task-header\">\n                        <span class=\"expander xl-icon arrow-down-icon\"></span>\n                        <span class=\"expander xl-icon arrow-right-icon hide\"></span>\n                        <span class=\"expander group-title release-name\">{{release.title}} ({{release.tasks.length}})</span>\n                    </legend>\n\n                    <task-list index=\"$index\" tasks=\"release.tasks\" on-task-details-closed=\"onTaskDetailsClosed()\" on-task-change=\"onTaskChange()\" release=\"release\"/>\n                </fieldset>\n            </div>\n        </div>\n        <div class=\"alert notice\" ng-show=\"releases.length == 0\">No tasks found.</div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/templates/context-menu.html","<xlr-context-menu id=\"context-menu-container\" items=\"vm.contextMenuItems\"></xlr-context-menu>");
$templateCache.put("static/9.0.2/partials/templates/copy-template-modal.html","<div class=\"modal-content\">\n    <form name=\"copyTemplateForm\" id=\"copyTemplateForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n            <h4>Copy Template</h4>\n        </div>\n        <div class=\"modal-body\">\n            <div class=\"form-group\">\n                  <label class=\"col-sm-2 control-label\" for=\"copyTemplate-title\">Template name <span ng-if=\"ctrl.templatePropertiesForm.$error.required\" class=\"error\">*</span></label>\n                <div class=\"col-sm-10\">\n                    <input type=\"text\" class=\"input-block-level\" name=\"title\" id=\"copyTemplate-title\" ng-model=\"ctrl.copyOfTemplate.title\" required autofocus/>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-2 control-label\" for=\"copyTemplate-description\">Description</label>\n\n                <div class=\"col-sm-10\">\n                    <textarea rows=\"4\" class=\"input-block-level\" id=\"copyTemplate-description\" ng-model=\"ctrl.copyOfTemplate.description\"></textarea>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <ul class=\"form-errors mln list-unstyled\">\n                <li ng-if=\"!ctrl.hasPermissionToEdit()\">Passwords will be cleared because you do not have permission to edit the original template.</li>\n                <li ng-if=\"copyTemplateForm.title.$error.required\">Template name is mandatory</li>\n            </ul>\n            <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"button continue primary\" ng-click=\"ctrl.copyTemplate(dismiss)\" ng-disabled=\"copyTemplateForm.$invalid\">Continue</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/templates/delete-template-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <h4>Delete Template</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the template <b>{{ctrl.template.title}}</b>.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button continue primary\" focus-on=\"true\" ng-click=\"ctrl.deleteTemplate(); dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/templates/import-template-modal.html","<div id=\"importTemplateModal\" class=\"modal-content\"\n     upload\n     upload-url=\"\'upload/templates/zip?folderId={{folderId}}\'\">\n    <form name=\"importTemplateForm\" id=\"importTemplateForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n            <h4>Import Template</h4>\n        </div>\n        <div ng-show=\"!UploadService.data.result\">\n            <div class=\"modal-body\">\n                <div class=\"form-group\">\n                    <label class=\"col-sm-2 control-label\" for=\"importTemplate-file\">Template file<span ng-if=\"importTemplateForm.$error.required\" class=\"error\">*</span></label>\n\n                    <div class=\"col-sm-10\">\n                        <input type=\"file\" ng-model=\"file\" file-input id=\"importTemplate-file\" required />\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <div class=\"col-sm-offset-2 col-sm-10\">\n                        <span class=\"error\" ng-show=\"importTemplateForm.$error.required\">Template file required</span>\n                        <span class=\"error\" ng-show=\"UploadService.data.error\">\n                            An upload error occurred\n                            <!-- On IE9 the error message is not set since it\'s based on an iframe -->\n                            <span ng-show=\"UploadService.data.errorMessage\">: {{UploadService.data.errorMessage}}</span>\n                        </span>\n                    </div>\n                </div>\n                <img class=\"pull-right\" src=\"static/9.0.2/styles/img/ajax-loader.gif\" ng-show=\"UploadService.data.loading\"/>\n            </div>\n            <div class=\"modal-footer\">\n                <button class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n                <button class=\"button import primary\" ng-disabled=\"importTemplateForm.$invalid\" ng-click=\"upload(file)\">Import</button>\n            </div>\n        </div>\n        <div ng-show=\"UploadService.data.result\">\n            <div class=\"modal-body\">\n                <div class=\"form-group\" ng-repeat=\"templateImport in UploadService.data.result\">\n                    <label class=\"col-xs-4 control-label\">\n                        <a ng-href=\"#/templates/{{templateImport.id}}\" ng-click=\"dismiss()\">{{templateImport.title}}</a>\n                    </label>\n\n                    <div class=\"col-xs-8 results\">\n                        <ul ng-if=\"templateImport.warnings.length > 0\">\n                            <li ng-repeat=\"warning in templateImport.warnings track by $index\">{{warning}}</li>\n                        </ul>\n                        <span ng-if=\"templateImport.warnings.length == 0\">\n                            Template successfully imported\n                        </span>\n                    </div>\n                </div>\n            </div>\n            <div class=\"modal-footer\">\n                <button class=\"button ok primary\" ng-click=\"dismiss()\">OK</button>\n            </div>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/templates/move-template-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <h4>Move template to</h4>\n    </div>\n    <form name=\"moveTemplateForm\">\n        <div class=\"modal-body\">\n            <folder-explorer class=\"folder-explorer\" mode=\"moveTemplateMode\" on-select=\"ctrl.onFolderSelect(folder)\">\n            </folder-explorer>\n        </div>\n        <span ng-if=\"ctrl.containsUnclickableRows()\" class=\"default-padding-left\">* Some folders are not available because you do not have the Edit Template permission on them.</span>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"button continue primary\" ng-disabled=\"!ctrl.canMove\" ng-click=\"ctrl.moveTemplate(dismiss)\">Move</button>\n        </div>\n    </form>\n</div>");
$templateCache.put("static/9.0.2/partials/templates/template-edit-trigger.html","<div id=\"triggers\">\n    <div release-header>\n        <div class=\"buttons\">\n            <button id=\"cancel\" class=\"button cancel\" ng-click=\"$ctrl.listTriggers()\">Cancel</button>\n            <button ng-disabled=\"triggerForm.$invalid\" id=\"submit\" class=\"button primary\" ng-click=\"$ctrl.saveTrigger()\">Save</button>\n            <span doc-icon=\"creating-custom-trigger.html\"></span>\n        </div>\n    </div>\n    <div class=\"container-fluid\">\n        <div class=\"row\">\n            <div class=\"col-md-2\">\n                <div class=\"content-under-header form-content\">\n                    <h4>{{ $ctrl.descriptor.label }}</h4>\n                    <div class=\"help\">\n                        After editing, press Save to apply the changes.<br>\n\n                        <div ng-if=\"$ctrl.variableProperties\">\n                            <br>\n                            The following trigger variables can be used in release title and tags:\n                            <ul>\n                                <li ng-repeat=\"variable in $ctrl.variableProperties\">${<span ng-bind=\"variable.name\"></span>}</li>\n                            </ul>\n                        </div>\n                    </div>\n                    <form name=\"triggerForm\" class=\"form-horizontal\">\n                        <div ng-repeat=\"(category, properties) in $ctrl.groupedProperties\">\n                            <fieldset>\n                                <legend ng-if=\"$ctrl.isNotCommonCategory(category)\">{{ category }}</legend>\n                                <div ng-repeat=\"property in properties\" dip-control large=\"false\" property=\"property\" container=\"$ctrl.trigger.properties\"></div>\n                            </fieldset>\n                        </div>\n\n                        <fieldset>\n                            <legend>Release tags</legend>\n                            <div class=\"form-group\">\n                                <label class=\"col-sm-3 control-label\">Tags</label>\n\n                                <div class=\"col-sm-9\">\n                                    <div id=\"tags\" class=\"transparent green-tags\" tags-input tags=\"$ctrl.trigger.tags\" placeholder=\"Add a tag...\" stop-submit-propagation></div>\n                                </div>\n                            </div>\n                        </fieldset>\n\n                        <fieldset ng-if=\"$ctrl.trigger.variables.length\">\n                            <legend>Template variables</legend>\n                            <div variables-editor\n                                 variables=\"$ctrl.trigger.variables\"\n                                 readonly=\"false\"\n                                 filter=\"{showOnReleaseStart: true}\">\n                            </div>\n                        </fieldset>\n\n                    </form>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n\n");
$templateCache.put("static/9.0.2/partials/templates/template-properties.html","<div id=\"template-properties\">\n    <div ng-if=\"!templateForm.newTemplate\" release-header>\n        <span doc-icon=\"release-properties.html\"></span>\n    </div>\n    <div id=\"new-template-header\" class=\"header\" ng-if=\"templateForm.newTemplate\">\n        <h4>{{title}}</h4>\n        <span doc-icon=\"creating-a-template.html\"></span>\n    </div>\n    <div class=\"content-under-header form-content\" ng-class=\"{\'new-template\': templateForm.newTemplate}\">\n        <form name=\"templatePropertiesForm\" id=\"templatePropertiesForm\" class=\"form-horizontal\">\n            <div class=\"row\">\n                <div class=\"col-sm-7\">\n                    <fieldset>\n                        <legend ng-if=\"!templateForm.newTemplate\">Properties for {{ release.title }}</legend>\n\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\" for=\"templateForm-title\">Template name <span ng-if=\"templatePropertiesForm.$error.required\"\n                                                                                                                        class=\"error\">*</span></label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <input type=\"text\" class=\"input-block-level\" id=\"templateForm-title\" ng-model=\"templateForm.title\" required autofocus\n                                       ng-disabled=\"!canEditTemplate()\"/>\n                                <span class=\"error\" ng-if=\"templatePropertiesForm.title.$error.required\">Template name is mandatory</span>\n                            </div>\n                        </div>\n\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Description</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <span class=\"template-description\" ng-if=\"canEditTemplate()\" inline-textarea-editor model=\"templateForm.description\"\n                                      placeholder=\"Set description...\" markdown>\n                                    <span display-variables=\"templateForm.description\" variables=\"templateForm.variables\" markdown class=\"markdown\"></span>\n                                </span>\n                                <span ng-if=\"!canEditTemplate()\" class=\"template-description markdown\">\n                                    <span display-variables=\"templateForm.description\" variables=\"templateForm.variables\" markdown class=\"markdown\"></span>\n                                </span>\n                            </div>\n                        </div>\n\n                    </fieldset>\n                    <div class=\"form-footer\">\n                        <button class=\"button continue primary\" ng-click=\"templatePropertiesUpdated();\"\n                                ng-disabled=\"templatePropertiesForm.$invalid || !canEditTemplate()\">\n                            <span ng-if=\"templateForm.newTemplate\">Create</span>\n                            <span ng-if=\"!templateForm.newTemplate\">Save</span>\n                        </button>\n                        <button ng-if=\"templateForm.newTemplate\" type=\"button\" class=\"button cancel\" ng-click=\"back()\">Cancel</button>\n                        <button ng-if=\"!templateForm.newTemplate\" ng-disabled=\"!templatePropertiesForm.$dirty\" type=\"button\" class=\"button\"\n                                ng-click=\"templatePropertiesForm.$setPristine(); initTemplateForm()\">Reset\n                        </button>\n                        <div ng-if=\"templateUpdatedAt\" class=\"pull-left last-saved\">Last saved on {{ templateUpdatedAt | date: \'medium\' }}</div>\n                    </div>\n                </div>\n                <div class=\"col-sm-5\">\n                    <fieldset>\n                        <legend>Template details</legend>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Scheduled start date <span ng-if=\"!templateForm.hasValidDates\" class=\"error\">*</span></label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                            <span class=\"scheduled-start-date\"\n                                  date-editor\n                                  ng-model=\"templateForm.scheduledStartDate\"\n                                  deletable=\"false\"\n                                  on-change=\"planning.updateScheduledStartDate(templateForm)\">\n                            </span>\n                                &nbsp;{{CurrentTimeZone.timeZone}}\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Due date</label>\n\n                            <div class=\"due-date col-sm-8 col-lg-9\"\n                                 date-editor\n                                 ng-model=\"templateForm.dueDate\"\n                                 placeholder=\"No date\"\n                                 inferred-date=\"planning.planElement.displayEndDate\"\n                                 deletable=\"true\"\n                                 on-change=\"planning.updateDueDate(templateForm)\">\n                            </div>\n                            <div class=\"col-sm-8 col-lg-9\" ng-if=\"!templateForm.hasValidDates\">\n                                <span class=\"error\">Start date must be before due date</span>\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Duration</label>\n\n                            <div class=\"col-sm-8 col-lg-9 duration\" duration-editor\n                                 inferred-duration=\"planning.planElement.displayDuration\"\n                                 duration=\"templateForm.plannedDuration\"\n                                 editable=\"true\"\n                                 on-change=\"planning.updateDuration(templateForm)\">\n                            </div>\n                        </div>\n                        <hr>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Run automated tasks as user</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <span ng-if=\"!templateForm.readonly\" class=\"input-block-level script-username\" inline-user-editor model=\"templateForm.scriptUsername\"\n                                      autocomplete-data=\"allUsers\" placeholder=\"Set user...\">\n                                    <span display-user=\"templateForm.scriptUsername\"></span>\n                                </span>\n                                <span ng-if=\"templateForm.readonly\" class=\"script-username read-only\">\n                                    <span display-user=\"templateForm.scriptUsername\"></span>\n                                </span>\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Password</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <span ng-if=\"!templateForm.readonly\" class=\"input-block-level script-userpassword\" inline-password-editor\n                                      model=\"templateForm.scriptUserPassword\" placeholder=\"Set password...\">\n                                    <span class=\"light-text\">Click here to modify the password</span>\n                                </span>\n                                <span ng-if=\"templateForm.readonly\" class=\"script-userpassword read-only\">\n                                    <span class=\"light-text\">*****</span>\n                                </span>\n                            </div>\n                        </div>\n                        <hr>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\" for=\"templateForm-abortOnFailure\">Abort on failure</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <input type=\"checkbox\" ng-model=\"templateForm.abortOnFailure\" id=\"templateForm-abortOnFailure\"/>\n                            </div>\n                        </div>\n                        <div class=\"form-group\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Tags</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <div id=\"tags\" class=\"transparent green-tags\" tags-input tags=\'templateForm.tags\' placeholder=\"Add a tag...\" read-only=\"!canEditTemplate()\"></div>\n                            </div>\n                        </div>\n                        <div class=\"form-group attachments-list\" ng-if=\"!templateForm.newTemplate\">\n                            <label class=\"col-sm-4 col-lg-3 control-label\">Attachments</label>\n\n                            <div class=\"col-sm-8 col-lg-9\">\n                                <div attachments-list\n                                     attachments=\"templateForm.attachments\"\n                                     readonly=\"!canEditTemplate()\"\n                                     upload-url=\"\'upload/attachment/\' + templateForm.templateId\"\n                                     can-delete-attachments=\"canEditTemplate()\"\n                                     delete-attachment=\"deleteAttachment(attachment)\"></div>\n                            </div>\n                        </div>\n\n                    </fieldset>\n                </div>\n            </div>\n        </form>\n\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/templates/template-triggers.html","<div id=\"triggers\">\n    <div release-header>\n        <div class=\"buttons\">\n            <span doc-icon=\"triggers.html\"></span>\n        </div>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"help\">\n            On this page you can define your triggers, and the setting about the trigger execution.\n        </div>\n        <div id=\"triggers-settings\">\n\n            <h3>Settings</h3>\n\n            <form name=\"releaseTriggerOptions\" id=\"releaseTriggerOptions\" class=\"form-horizontal\">\n                <div class=\"form-group\">\n                    <label class=\"col-xs-3 control-label\" for=\"templateForm-allowConcurrentReleasesFromTrigger\">Allow concurrent\n                        triggered releases</label>\n\n                    <div class=\"col-xs-8\">\n                        <input type=\"checkbox\" ng-model=\"$ctrl.template.allowConcurrentReleasesFromTrigger\"\n                               id=\"templateForm-allowConcurrentReleasesFromTrigger\"/>\n                    </div>\n                </div>\n                <div class=\"last-saved\">\n                    <span ng-if=\"$ctrl.templateUpdatedAt\">Last saved on {{ $ctrl.templateUpdatedAt | date: \'medium\' }}</span>\n                    <span ng-if=\"!$ctrl.templateUpdatedAt\">&nbsp;</span>\n                </div>\n                <div class=\"form-footer\">\n                    <button type=\"submit\" class=\"button primary continue\" id=\"templateForm-save\"\n                            ng-click=\"$ctrl.updateTemplate()\" ng-disabled=\"releaseTriggerOptions.$pristine\">\n                        <span>Save</span>\n                    </button>\n                </div>\n            </form>\n        </div>\n        <hr/>\n        <div id=\"triggers-list\">\n            <h3>Triggers list</h3>\n            <table class=\"table table-rounded table-striped\" ng-if=\"$ctrl.triggers && $ctrl.triggers.length > 0\">\n                <tbody>\n                <tr ng-repeat=\"trigger in $ctrl.triggers\" class=\"trigger-instance\">\n                    <td class=\"open-instance\">\n                        <a class=\"link\"\n                           ng-href=\"#/templates/{{$ctrl.template.id}}/triggers/edit/{{trigger.id}}\">{{trigger.title}}</a>\n                    </td>\n                    <td class=\"open-related-release\">\n                        <a class=\"link\" ng-href=\"#/releases?tags={{trigger.name}}&has_filter&inProgress&paused&failing&failed\">\n                            Releases linked to this trigger\n                        </a>\n                    </td>\n                    <td class=\"delete-instance\" ng-click=\"$ctrl.deleteTrigger(trigger)\"><i class=\"xl-icon close-icon\"></i></td>\n                </tr>\n                </tbody>\n            </table>\n            <div ng-if=\"!$ctrl.triggers || $ctrl.triggers.length == 0\">\n                <p class=\"bold\">No triggers</p>\n            </div>\n            <select class=\"trigger-types\"\n                    ng-if=\"$ctrl.canCreateTriggers\"\n                    ng-change=\"$ctrl.addTrigger(triggerType)\"\n                    ng-model=\"triggerType\"\n                    ng-options=\"triggerType.type as triggerType.label for triggerType in $ctrl.triggerTypes\">\n                <option value=\"\" disabled selected>Add trigger ...</option>\n            </select>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/templates/templates.html","<div id=\"templates\" class=\"container-fluid\">\n    <div id=\"templates-header\" class=\"header\">\n        <filter filters=\"filters\" on-change=\"filtersChanged(filters)\">\n            <text-filter class=\"searchFilter_templates\" field=\"\'title\'\" placeholder=\"\'Filter by title...\'\"></text-filter>\n            <div class=\"filter\">\n                <span class=\"filter-title\">Tags</span>\n                <tag-filter all-tags=\"allTags\" class=\"tags-input\"></tag-filter>\n            </div>\n        </filter>\n        <div class=\"buttons\">\n            <a class=\"button import-template\" ng-show=\"security.hasPermission(\'template#create\')\"\n               ng-click=\"UploadService.reset()\"\n               modal=\"\'partials/templates/import-template-modal.html\'\"\n               ng-controller=\"UploadController\">Import</a>\n            <a ng-href=\"#/templates/create\" class=\"button primary new-template\" ng-show=\"security.hasPermission(\'template#create\')\">New template</a>\n            <span doc-icon=\"template-overview.html\"></span>\n        </div>\n    </div>\n    <xlr-template-list-component list=\"templates\"\n                                 templates-loader=\"templatesLoader\"\n                                 on-change=\"loadTemplates()\">\n    </xlr-template-list-component>\n</div>\n");
$templateCache.put("static/9.0.2/partials/value-stream-mapping/release-value-stream.html","<div id=\"release-value-stream\">\n    <div id=\"release-value-stream-header\" class=\"header\">\n        <div class=\"filter-release actions\" ng-controller=\"FiltersController\">\n            <input id=\"searchFilter\" autofocus type=\"search\" placeholder=\"Filter by title...\" ng-model=\"filters.title\" ng-model-options=\"{ debounce: 1000 }\">\n            <div class=\"time-filters-container\" ng-include=\"\'partials/filters/time-filters.html\'\"></div>\n            <span class=\"tags-label\">Tags</span>\n            <div class=\"transparent tags-input green-tags\" tags-input tags=\"filters.tags\"\n                 completion-candidates=\"allTags\"\n                 placeholder=\"Filter by tags...\" focus-on-click></div>\n            <div class=\"buttons\">\n                <span doc-icon=\"release-value-stream.html\"></span>\n            </div>\n        </div>\n    </div>\n    <div class=\"content\">\n        <div ng-if=\"releases.length != 0\">\n            <div id=\"legend\">\n                <strong>Legend</strong><span class=\"flag-count legend-item\"><i class=\"xl-icon flag-none-icon\" />Flagged tasks</span><span class=\"failure-count legend-item\"><i class=\"xl-icon lightning-icon\" />Failed tasks</span><span class=\"delay-count legend-item\"><i class=\"xl-icon delay-icon\" />Delayed tasks</span>\n            </div>\n\n\n            <xlr-infinite-scroll-wrapper\n                    on-show-more=\"releasesLoader.loadNextCis()\"\n                    disable-when=\"!releasesLoader.hasMoreCis() || releasesLoader.isLoading()\"\n                    show-loader-when=\"releasesLoader.isLoading()\">\n\n                <div ng-repeat=\"release in releases\" xlr-infinite-scroll>\n                    <a class=\"release section color-inherited\" ui-sref=\"release({releaseId: release.id})\">\n                        <div class=\"section-header\">\n                            <span class=\"release-title\">{{ release.title }}</span>\n                            <span class=\"release-details\">From {{ release.startDate | date:\'mediumDate\' }} to {{ release.endDate | date:\'mediumDate\' }} | Duration {{ getCIDuration(release) | duration}}\n                            <span class=\"critical-phases-counter\" ng-show=\"getCriticalPhasesCount(release) > 0\">\n                                | <span ng-pluralize count=\"getCriticalPhasesCount(release)\" when=\"{\'0\': \'{} tasks\', \'1\': \'1 Critical phase\', \'other\': \'{} Critical phases\', \'many\': \'{} Critical phases\', \'few\': \'{} Critical phases\'}\"></span>\n                            </span>\n                            <span class=\"label label-aborted\" ng-show=\"release.status == \'ABORTED\'\">Aborted</span>\n                        </span>\n                        </div>\n                        <div class=\"section-body\">\n                            <div class=\"phase\" ng-repeat=\"phase in release.phases\" ng-class=\"{\'done\': isPhaseReadOnly(phase), \'critical\': isCritical(phase)}\">\n                                <div class=\"phase-body\">\n                                    <div class=\"phase-header\" ng-style=\"{\'border-top-color\': phase.color}\">\n                                        <span class=\"phase-title\">{{ phase.title }}</span>\n                                    </div>\n                                    <div class=\"phase-content\">\n                                        <span ng-pluralize count=\"getLeafTasks(phase).length\"\n                                              when=\"{\'0\': \'{} tasks\', \'1\': \'1 task\', \'other\': \'{} tasks\', \'many\': \'{} tasks\', \'few\': \'{} tasks\'}\"></span>\n                                        <br/>\n                                        <task-counters class=\"counters\" flags-count=\"phase.taskFlaggedCount\" delays-count=\"phase.taskDelayCount\"\n                                                       failures-count=\"phase.taskFailureCount\"></task-counters>\n                                    </div>\n                                </div>\n                                <div class=\"phase-footer\">\n                                    <span class=\"phase-duration\">{{ getCIDuration(phase) | duration }}</span>, {{ getDurationPercentage(release, phase) }}%\n                                    <span class=\"phase-duration-graph\" phase-duration></span>\n                                </div>\n                            </div>\n                        </div>\n                    </a>\n                    <div class=\"clearfix\"></div>\n                </div>\n\n            </xlr-infinite-scroll-wrapper>\n\n        </div>\n        <div class=\"alert notice\" ng-show=\"!releasesLoader.isLoading() && !releases.length\">No releases found.</div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/variables/delete-variable-modal.html","<div class=\"modal-content delete-variable-modal\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">\n            <i class=\"xl-icon close-icon\" />\n        </button>\n        <h4>{{ pageType !== \'GLOBAL\' ? \'Replace and delete\' : \'Delete\' }} {{::getKey(variable)}}</h4>\n    </div>\n    <div class=\"modal-body\">\n        <form name=\"deleteVariableForm\" class=\"form-horizontal delete-variable-form\" novalidate>\n            <span>\n                You are about to delete the variable <strong>{{::variable.key}}</strong>.\n            </span>\n            <div ng-if=\"pageType === \'GLOBAL\'\">\n                <p class=\"mtm\">This variable may still be in use. Tasks that use this variable will not be able to start.</p>\n            </div>\n            <div ng-if=\"checksUsage()\">\n                <div ng-if=\"isUsed\" class=\"variable-replacement\">\n                    <p class=\"mtm\">This variable is still in use.</p>\n                    <div variables-editor\n                         variables=\"replacement\"\n                         form=\"deleteVariableForm\"\n                         readonly=\"false\"\n                         all-variables=\"allVariables\"\n                         replace-variables=\"true\"\n                         supports-new-variable=\"true\"\n                         on-new-variable=\"createVariable(name, variableType, createdCallback)\"\n                         filter=\"{}\">\n                    </div>\n                </div>\n                <div ng-if=\"!isUsed\">\n                    <p class=\"mtm\">This variable is not currently in use.</p>\n                </div>\n            </div>\n        </form>\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button class=\"button delete primary\" focus-on=\"true\" ng-disabled=\"deleteVariableForm.$invalid\" ng-click=\"deleteVariable(variable, dismiss);\">\n            {{ isUsed ? \'Replace and delete\' : \'Delete\' }}\n        </button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/variables/edit-variable-modal.html","<div class=\"modal-content edit-variable-modal\">\n    <form name=\"editVariableForm\" class=\"form-horizontal edit-variable-form\" novalidate>\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\">\n                <i class=\"xl-icon close-icon\"/>\n            </button>\n            <h4 ng-if=\"isReadonly\">{{::getKey(var)}}\n                <folder-path ng-if=\"showFolderPath\"\n                             folder-id=\"variable.folderId\"\n                             folder-tab=\"variables\"></folder-path>\n            </h4>\n            <h4 ng-if=\"!isReadonly && !isNew\">Edit {{::getKey(var)}}</h4>\n            <h4 ng-if=\"!isReadonly && isNew\">Create variable {{getKey(var)}}</h4>\n        </div>\n        <div class=\"modal-body\">\n            <!-- name -->\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Variable name</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"isRenameEnabled\" class=\"variable-name\">\n                        <div ng-if=\"VARIABLE_TYPES.isGlobalOrFolder(pageType)\">\n                            <div class=\"input-group\" ng-init=\"currKey = getVariableKeyWithoutPrefix(var.key); varPrefix = getVariableKeyPrefix(var.key);\">\n                                <span class=\"input-group-addon\">{{varPrefix}}</span>\n                                <input name=\"fieldKey\" type=\"text\" class=\"input-block-level\" ng-model=\"currKey\" ng-change=\"var.key = varPrefix + currKey\"\n                                       required not-in-list=\"existingVariableKeys\" autofocus>\n                            </div>\n                        </div>\n                        <div ng-if=\"!VARIABLE_TYPES.isGlobalOrFolder(pageType)\">\n                            <input name=\"fieldKey\" type=\"text\" class=\"input-block-level\" ng-model=\"var.key\"\n                                   required not-in-list=\"existingVariableKeys\" autofocus ng-pattern=\"allowedKeyPattern\">\n                        </div>\n                    </div>\n                    <div ng-if=\"!isRenameEnabled\" class=\"variable-name\">\n                        <span class=\"field-readonly\">{{::getKey(var)}}</span>\n                    </div>\n                    <div ng-if=\"!isReadonly\">\n                        <div class=\"description\" ng-if=\"!editVariableForm.fieldKey.$dirty || editVariableForm.$valid\">Unique name for the variable.</div>\n                        <div class=\"field-errors\" ng-if=\"editVariableForm.fieldKey.$dirty\">\n                            <span ng-if=\"editVariableForm.fieldKey.$error.required\">Variable name is mandatory</span>\n                            <span ng-if=\"editVariableForm.fieldKey.$error.notInList\">Variable with this name already exists</span>\n                            <span ng-if=\"editVariableForm.fieldKey.$error.pattern\">\n                            {{ pageType === \'TEMPLATE\' ?\n                            \'Template variable names cannot start with \\\'release.\\\', \\\'global.\\\' or \\\'folder.\\\'\' :\n                            \'Release variable names cannot start with \\\'release.\\\', \\\'global.\\\' or \\\'folder.\\\'\' }}\n                        </span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <!-- / name -->\n\n            <!-- label -->\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Label</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"!isReadonly\" class=\"variable-label\">\n                        <input type=\"text\" class=\"input-block-level\" ng-model=\"var.label\" ng-disabled=\"isReadonly\" autofocus/>\n                        <div class=\"description\">The label of the variable.</div>\n                    </div>\n                    <div ng-if=\"isReadonly\" class=\"variable-label\">\n                        <span class=\"field-readonly\" ng-class=\"{ \'empty-value\': !var.label }\">{{ var.label || emptyValue }}</span>\n                    </div>\n                </div>\n            </div>\n            <!-- / label -->\n\n            <!-- type -->\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Type</label>\n\n                <div class=\"col-xs-9\">\n                    <span ng-if=\"!isNew\" class=\"field-readonly\">{{::getVariableType(var).label}}</span>\n                    <select ng-if=\"isNew\" class=\"input-block-level\" ng-model=\"variableType\"\n                            ng-options=\"type as type.label for type in variableTypes track by type.id\"\n                            ng-change=\"typeSelected(\'{{getVariableType(var).id}}\', variableType.id)\">\n                    </select>\n                    <div ng-if=\"!isReadonly\" class=\"description\">Variable type.</div>\n                </div>\n            </div>\n            <!-- / type -->\n\n            <!-- all type except list box -->\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">\n                    {{ pageType === \'TEMPLATE\' ? \'Default value\' : \'Value\' }}\n                </label>\n\n                <div class=\"col-xs-9\">\n                    <div class=\"variable-value\">\n                        <div ng-if=\"!isReadonly\">\n                            <input ng-if=\"isStringVariable(var)\" type=\"text\" class=\"input-block-level\" ng-model=\"var.value\" ng-disabled=\"isReadonly\" autofocus/>\n\n                            <select ng-if=\"isDropDownListBox(var)\" ng-options=\"v as v for v in possibleValues\" ng-model=\"var.value\" class=\"input-block-level\">\n                                <option value=\"\"></option>\n                            </select>\n\n                            <input ng-if=\"var.type == predefinedVariableType.passwordString.key\" type=\"password\" class=\"input-block-level\" ng-model=\"var.value\"\n                                   ng-disabled=\"isReadonly\" autofocus/>\n\n                            <input xl-dip-integer ng-if=\"var.type == predefinedVariableType.integer.key\" type=\"text\" class=\"input-block-level\"\n                                   ng-model=\"var.value\"\n                                   ng-disabled=\"isReadonly\" autofocus metadata=\"{default: 0}\"/>\n\n                            <div ng-if=\"var.type === predefinedVariableType.date.key\">\n                                <div class=\"date-variable\"\n                                     date-editor\n                                     ng-model=\"var.value\"\n                                     date-format=\"YYYY-MM-DDTHH:mm:ssZ\"\n                                     deletable=\"true\"\n                                     placeholder=\"Select date\"\n                                     readonly=\"false\">\n                                </div>\n                            </div>\n                        </div>\n                        <div ng-if=\"isReadonly\">\n                            <span ng-if=\"isSimpleStringType(var.type) ||\n                                         var.type === predefinedVariableType.date.key ||\n                                         var.type === predefinedVariableType.integer.key\"\n                                  class=\"field-readonly\" ng-class=\"{ \'empty-value\': !getValue(var) }\">{{ getValue(var) || emptyValue }}</span>\n                        </div>\n\n                        <div ng-if=\"var.type === predefinedVariableType.boolean.key\">\n                            <input ng-if=\"!isReadonly\" type=\"checkbox\" class=\"input-block-level\" ng-model=\"var.value\"\n                                   ng-checked=\"var.value\" ng-disabled=\"isReadonly\" autofocus/>\n                            <span data-ng-if=\"isReadonly\" class=\"field-readonly\">{{var.value ? \'True\' : \'False\'}}</span>\n                        </div>\n\n                        <div ng-if=\"var.type === predefinedVariableType.listString.key\">\n                            <div ng-if=\"isReadonly && var.value.length === 0\" class=\"empty-value\">{{emptyValue}}</div>\n                            <div ng-hide=\"isReadonly && var.value.length === 0\"\n                                 xl-dip-list\n                                 class=\"ui-front field\"\n                                 ng-model=\"var.value\"\n                                 metadata=\"{name: \'list\', required: false }\"\n                                 read-only=\"isReadonly\"></div>\n                        </div>\n\n                        <div ng-if=\"var.type === predefinedVariableType.setString.key\">\n                            <div ng-if=\"isReadonly && var.value.length === 0\" class=\"field-readonly empty-value\">{{emptyValue}}</div>\n                            <div ng-hide=\"isReadonly && var.value.length === 0\" xl-dip-set\n                                 class=\"ui-front\"\n                                 ng-model=\"var.value\"\n                                 metadata=\"{name: \'set\', required: false }\"\n                                 read-only=\"isReadonly\"></div>\n                        </div>\n                        <div ng-if=\"var.type === predefinedVariableType.mapStringString.key\">\n                            <div ng-if=\"isReadonly && isValueEmpty(var.value)\" class=\"empty-value\">{{emptyValue}}</div>\n                            <div ng-hide=\"isReadonly && isValueEmpty(var.value)\"\n                                 xl-dip-map-string-string\n                                 class=\"field\"\n                                 ng-model=\"var.value\"\n                                 metadata=\"{name: \'mapstringstring\', required: false, minVisibleRow: 3 }\"\n                                 read-only=\"isReadonly\"></div>\n                        </div>\n                    </div>\n                    <div ng-if=\"!isReadonly\" class=\"description\">The value of the variable.</div>\n                </div>\n            </div>\n            <!-- / all type except list box -->\n\n            <!-- list box -->\n            <div ng-if=\"isDropDownListBox(var)\">\n                <!--select input-->\n                <div class=\"form-group\">\n                    <div class=\"col-xs-12\">\n                        <hr/>\n                    </div>\n\n                    <label class=\"col-xs-3 control-label\">\n                        Value provider type\n                    </label>\n                    <div class=\"col-xs-9\">\n                        <label class=\"radio-inline\">\n                            Fixed list <input type=\"radio\" name=\"listBoxInputOptions\" id=\"fixedListBoxInput\"\n                                              data-ng-value=\"listBoxValueProviderType.listOfStringConfiguration\"\n                                              data-ng-change=\"changeValueProvider(selectedValueProviderType)\"\n                                              data-ng-model=\"selectedValueProviderType\"\n                                              ng-disabled=\"isReadonly\"/>\n                        </label>\n                        <label class=\"radio-inline\">\n                            Value provider <input type=\"radio\" name=\"listBoxInputOptions\" id=\"valueProviderListBoxInput\"\n                                                  data-ng-value=\"listBoxValueProviderType.scriptConfiguration\"\n                                                  data-ng-change=\"changeValueProvider(selectedValueProviderType)\"\n                                                  data-ng-model=\"selectedValueProviderType\"\n                                                  ng-disabled=\"isReadonly\"/>\n                        </label>\n                    </div>\n                </div>\n                <!--/ select input-->\n\n                <!-- fixed -->\n                <div ng-if=\"selectedValueProviderType === listBoxValueProviderType.listOfStringConfiguration\" class=\"form-group\">\n                    <label class=\"col-xs-3 control-label\">\n                        Possible values\n                    </label>\n                    <div class=\"col-xs-9\">\n                        <div ng-if=\"isReadonly && expandedValueProvider.values.variable === null && expandedValueProvider.values.value.length === 0\"\n                             class=\"field-readonly empty-value\">{{emptyValue}}\n                        </div>\n                        <div ng-hide=\"isReadonly && expandedValueProvider.values.variable === null && expandedValueProvider.values.value.length === 0\"\n                             xlr-list-of-strings-with-variables\n                             name=\"expanded-value-provider-value\"\n                             model=\"expandedValueProvider.values\"\n                             on-new=\"onNewVariablePF(name, variableType, createdCallback)\"\n                             on-change=\"saveProviderAndPopulateValues()\"\n                             variables=\"allVariables\"\n                             read-only=\"isReadonly\">\n                        </div>\n                        <div ng-if=\"!isReadonly\" class=\"description\">The list of possible values.</div>\n                    </div>\n                </div>\n                <!-- / fixed -->\n\n                <!-- list of value providers with properties -->\n                <div ng-if=\"selectedValueProviderType === listBoxValueProviderType.scriptConfiguration\">\n                    <ng-form name=\"configurationItemForm\">\n                        <dip-ci-control\n                                ci-type-descriptor=\"ciTypeDescriptor\"\n                                configuration-item=\"var.valueProvider\"\n                                readonly=\"isReadonly\"\n                                included-categories=\"[\'Common\']\"\n                                use-radio-buttons=\"false\"\n                                show-description-for-selected-type-descriptor=\"true\"\n                                renderers=\"{\'xlrelease.Configuration\' : \'dip-control\'}\"\n                                default-description=\"\'Script to load the values.\'\">\n                        </dip-ci-control>\n                    </ng-form>\n                </div>\n                <!-- / list of value providers with properties -->\n\n                <div class=\"form-group\">\n                    <div class=\"col-sm-12\">\n                        <hr/>\n                    </div>\n                </div>\n            </div>\n            <!-- / list box -->\n\n            <!-- description -->\n            <div class=\"form-group\">\n                <label class=\"col-xs-3 control-label\">Description</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"!isReadonly\" class=\"variable-description\">\n                        <input type=\"text\" class=\"input-block-level\" ng-model=\"var.description\" ng-disabled=\"isReadonly\" autofocus/>\n                        <div class=\"description\">The description of the variable.</div>\n                    </div>\n                    <div ng-if=\"isReadonly\" class=\"field-readonly\" ng-class=\"{ \'empty-value\': !var.description }\">{{ var.description || emptyValue }}</div>\n                </div>\n            </div>\n            <!-- / description -->\n\n            <!-- checkboxes -->\n            <div class=\"form-group\" ng-if=\"!VARIABLE_TYPES.isGlobalOrFolder(pageType)\">\n                <label class=\"col-xs-3 control-label\">Required</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"!isReadonly\">\n                        <input type=\"checkbox\" ng-model=\"var.requiresValue\" ng-disabled=\"isReadonly\"/>\n                        <div class=\"description\">If selected, the variable cannot be empty when the release or task that uses the variable\n                            starts.\n                        </div>\n                    </div>\n                    <div ng-if=\"isReadonly\" class=\"field-readonly\">{{var.requiresValue ? \'True\' : \'False\'}}</div>\n                </div>\n            </div>\n\n            <div class=\"form-group\" ng-if=\"!VARIABLE_TYPES.isGlobalOrFolder(pageType) && pageType !== \'RELEASE\'\">\n                <label class=\"col-xs-3 control-label\">Show on Create Release form</label>\n\n                <div class=\"col-xs-9\">\n                    <div ng-if=\"!isReadonly\">\n                        <input type=\"checkbox\" ng-model=\"var.showOnReleaseStart\" ng-disabled=\"isReadonly\"/>\n                        <div class=\"description\">Show the variable on the Create Release screen or Create Release task.</div>\n                    </div>\n                    <div ng-if=\"isReadonly\" class=\"field-readonly\">{{var.showOnReleaseStart ? \'True\' : \'False\'}}</div>\n                </div>\n            </div>\n            <!-- / checkboxes -->\n\n            <!-- footer -->\n            <div class=\"modal-footer\">\n                <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">{{isReadonly ? \'Close\' : \'Cancel\'}}</button>\n                <button type=\"submit\" class=\"button save primary\" ng-if=\"!isReadonly\" ng-disabled=\"editVariableForm.$invalid || invalidValueProvider()\"\n                        ng-click=\"saveVariable(var, dismiss);\">{{ isNew ? \'Create\' : \'Save\' }}\n                </button>\n            </div>\n            <!-- / footer -->\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/variables/global-variables.html","<div id=\"global-variables\">\n    <div class=\"header\">\n        <div class=\"filters actions\">\n            <input id=\"variables-filter\" type=\"search\" class=\"filter first\" placeholder=\"Search...\" ng-model=\"filters.filter\">\n            <div class=\"buttons\">\n                <span ng-if=\"!isReadonly\"\n                edit-variable\n                init-variable=\"newVariable()\"\n                save=\"createGlobalVariable\"\n                on-new-variable=\"createGlobalVariable\"\n                is-new=\"true\"\n                is-readonly=\"false\"\n                is-rename-enabled=\"true\"\n                all-variables=\"decoratedVariables\"\n                page-type=\"\'GLOBAL\'\"\n                class=\"button primary new-variable\">New global variable</span>\n            </div>\n            <span doc-icon=\"global-variables.html\"></span>    \n        </div>\n        \n    </div>\n\n    <div id=\"variables-content\" class=\"content-under-header\">\n        <div variables-list\n             variables=\"variables\"\n             all-variables=\"decoratedVariables\"\n             filter=\"filters.filter\"\n             on-change=\"updateGlobalVariable\"\n             on-delete=\"deleteGlobalVariable(variable, callback)\"\n             on-new-variable=\"createGlobalVariable\"\n             is-readonly=\"isReadonly\"\n             is-rename-enabled=\"false\"\n             page-type=\"\'GLOBAL\'\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/variables/variables-editor-default-controls.html","<div ng-if=\"variable.type == \'xlrelease.PasswordStringVariable\' && !readonly\" class=\"password ui-front\" inline-password-editor name=\"{{variable.key}}\"\n     placeholder=\"Set password\" model=\"variable.value\" on-change=\"onChange({variable: variable})\" ng-required=\"variable.requiresValue\"\n     allow-commit-on-invalid=\"true\">\n     <span class=\"light-text\">*****</span>\n</div>\n<div ng-if=\"variable.type == \'xlrelease.PasswordStringVariable\' && readonly\" class=\"password field-readonly read-only\" ng-if=\"vm.readOnly\">\n     <span class=\"light-text\">*****</span>\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.BooleanVariable\'\" class=\"ui-front\" name=\"{{variable.key}}\">\n     <input type=\"checkbox\" ng-model=\"variable.value\" ng-checked=\"variable.value\" ng-change=\"onChange({variable: variable})\" ng-disabled=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.IntegerVariable\'\" class=\"ui-front\" name=\"{{variable.key}}\">\n     <input xl-dip-integer type=\"text\" ng-model=\"variable.value\" ng-blur=\"onChange({variable: variable})\" metadata=\"{default: 0}\" ng-disabled=\"readonly\" ng-class=\"{\'input-readonly read-only\': readonly}\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.ListStringVariable\'\"\n     xl-dip-list\n     class=\"ui-front\"\n     name=\"{{variable.key}}\"\n     ng-model=\"variable.value\"\n     metadata=\"{name: \'list\', required: variable.requiresValue}\"\n     read-only=\"readonly\"\n     on-change=\"onChange({variable: variable})\"></div>\n\n<div ng-if=\"variable.type == \'xlrelease.SetStringVariable\'\"\n     xl-dip-set\n     class=\"ui-front\"\n     name=\"{{variable.key}}\"\n     ng-model=\"variable.value\"\n     metadata=\"{name: \'set\', required: variable.requiresValue}\"\n     read-only=\"readonly\"\n     on-change=\"onChange({variable: variable})\"></div>\n\n<div ng-if=\"variable.type == \'xlrelease.MapStringStringVariable\'\"\n     xl-dip-map-string-string\n     class=\"field\"\n     name=\"{{variable.key}}\"\n     ng-model=\"variable.value\"\n     on-change=\"onChange({variable: variable})\"\n     read-only=\"readonly\"\n     metadata=\"{name: \'mapstringstring\', required: variable.requiresValue, minVisibleRow: 3}\"\n     open-on-click=\"true\"></div>\n\n<div ng-if=\"variable.type === \'xlrelease.DateVariable\'\" class=\"ui-front\">\n    <div class=\"date-variable\"\n         date-editor\n         ng-model=\"variable.value\"\n         date-format=\"YYYY-MM-DDTHH:mm:ssZ\"\n         placeholder=\"Select date\"\n         on-change=\"onChange({variable: variable})\"\n         deletable=\"true\"\n         is-required=\"variable.requiresValue\"\n         readonly=\"readonly\">\n    </div>\n</div>");
$templateCache.put("static/9.0.2/partials/variables/variables-editor-replace-controls.html","<div ng-if=\"variable.type == \'xlrelease.PasswordStringVariable\'\"\n     xlr-inline-password-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.BooleanVariable\'\"\n     xlr-boolean-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.IntegerVariable\'\"\n     xlr-integer-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     metadata=\"{default: 0}\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.ListStringVariable\'\"\n     xlr-list-of-strings-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.SetStringVariable\'\"\n     xlr-set-of-strings-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.MapStringStringVariable\'\"\n     xlr-map-string-string-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"variable.type == \'xlrelease.DateVariable\'\"\n     xlr-date-with-variables\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"allVariablesReplaceable && isStringVariable(variable)\"\n     xlr-inline-text-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n<div ng-if=\"allVariablesReplaceable && isDropDownListBox(variable)\"\n     xlr-inline-text-with-variables\n     class=\"field\"\n     name=\"variable.key\"\n     model=\"variable\"\n     on-change=\"onChange({variable: variable})\"\n     supports-new=\"supportsNewVariable\"\n     on-new=\"onNewVariable({name: name, variableType: variableType, createdCallback: createdCallback})\"\n     variables=\"allVariables\"\n     read-only=\"readonly\">\n</div>\n\n");
$templateCache.put("static/9.0.2/partials/variables/variables-editor.html","<div class=\"variable-editor\">\n    <div class=\"form-group\" ng-repeat=\"variable in variables | filter : filter\">\n        <label class=\"col-sm-3 control-label\" ng-class=\"getVariableControlLabelClass(variable)\">\n            <span tooltip=\"getKey(variable)\" tooltip-position=\"bottom\">{{ getDisplayName(variable) }}</span>\n            <span ng-if=\"variable.requiresValue\"\n                  class=\"error\">*</span>\n        </label>\n        <div class=\"col-sm-9\" id=\"{{variable.key}}\">\n            <div ng-if=\"!allVariablesReplaceable && !readonly\" data-ng-class=\"{\'variable-editor-remove-enabled\': enableRemove}\">\n                <div ng-if=\"isStringVariable(variable)\" class=\"ui-front\" inline-text-editor name=\"{{variable.key}}\" model=\"variable.value\"\n                     on-change=\"onChange({variable: variable})\" ng-required=\"variable.requiresValue\" allow-commit-on-invalid=\"true\">\n                    <span display-variables=\"variable.value\" variables=\"allVariables\"></span>\n                </div>\n                <inline-drop-down-list-editor ng-if=\"isDropDownListBox(variable)\" variable=\"variable\"\n                                              on-change=\"onChange({variable: variable})\"></inline-drop-down-list-editor>\n            </div>\n            <div ng-if=\"!allVariablesReplaceable && readonly\">\n                <div ng-if=\"variable.type == \'xlrelease.StringVariable\'\" class=\"ui-front xl-components\">\n                    <span class=\"field-readonly read-only\">\n                        <span display-variables=\"variable.value\" variables=\"allVariables\"></span>\n                    </span>\n                </div>\n            </div>\n            <div ng-if=\"replaceVariables\"\n                 data-ng-class=\"{\'variable-editor-remove-enabled\': enableRemove}\"\n                 ng-include=\"\'partials/variables/variables-editor-replace-controls.html\'\"></div>\n            <div ng-if=\"!replaceVariables\"\n                 data-ng-class=\"{\'variable-editor-remove-enabled\': enableRemove}\"\n                 ng-include=\"\'partials/variables/variables-editor-default-controls.html\'\"></div>\n\n            <div class=\"description\" ng-if=\"variable.description\">{{ ::variable.description }}</div>\n\n            <span data-ng-if=\"enableRemove && !readonly\"\n                  data-ng-click=\"removeVariable(variable)\"\n                  class=\"xl-icon close-icon variable-editor-remove-icon\"></span>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/variables/variables-list.html","<div class=\"variables-list\">\n    <div class=\"row-table container-fluid\" data-ng-if=\"filteredVariables().length > 0\">\n        <div class=\"header-row row\">\n            <div class=\"col-xs-3 plm\">Variable name</div>\n            <div class=\"col-xs-2\">Label</div>\n            <div class=\"col-xs-3\">{{ pageType === \'TEMPLATE\' ? \'Default value\' : \'Value\' }}</div>\n            <div class=\"col-xs-2\">Type</div>\n            <div class=\"col-xs-2\">Actions</div>\n        </div>\n        <div ui-sortable=\"sortableOptions\" data-ng-model=\"variables\" class=\"xl-dip-collection-of-ci row\">\n            <div data-ng-repeat=\"variable in filteredVariables() track by variable.id\" class=\"variable ui-sortable-handle\">\n                <div edit-variable\n                     init-variable=\"editVariable(variable)\"\n                     save=\"saveVariable\"\n                     on-new-variable=\"createVariable\"\n                     is-new=\"false\"\n                     is-readonly=\"isReadonly\"\n                     all-variables=\"allVariables\"\n                     is-rename-enabled=\"isRenameEnabled\"\n                     page-type=\"pageType\"\n                     class=\"data-row row ui-sortable\" data-ng-class=\"{\'has-folder-path\': !!showFolderPath}\">\n                    <div class=\"col-xs-3 plm\">\n                        <div>{{ getKey(variable) }}</div>\n                        <folder-path ng-if=\"showFolderPath\"\n                                     folder-id=\"variable.folderId\"\n                                     folder-tab=\"variables\"></folder-path>\n                    </div>\n                    <div class=\"col-xs-2\">{{ variable.label }}</div>\n                    <div class=\"col-xs-3\">{{ getValue(variable) }}</div>\n                    <div class=\"col-xs-2\">{{ getVariableType(variable).label }}</div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"row variable-actions\">\n                            <div ng-if=\"isReadonly\" class=\"col-md-12\"><span class=\"action edit\"><i class=\"xl-icon visibility-on-icon\"></i>View</span></div>\n                            <div ng-if=\"!isReadonly\" class=\"col-md-12\">\n                                <span class=\"action edit\"><i class=\"xl-icon edit-icon\"></i><span class=\"action-label\">Edit</span></span>\n                                <span delete-variable model=\"variable\" all-variables=\"allVariables\"\n                                      on-delete=\"onDelete({variable: variable, callback: callback})\"\n                                      on-new-variable=\"createVariable\"\n                                      page-type=\"pageType\"></span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"alert notice\" data-ng-if=\"filteredVariables().length == 0\">No variables defined.</div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/variable-toggle-and-selector.html","<span class=\"variable-toggle\" ng-click=\"vm.toggleMode();\" ng-if=\"vm.showToggle == true && !vm.readOnly\">\n    <button class=\"button primary\"\n            ng-if=\"vm.variableMode\"\n            tooltip=\"\'Switch to manual entry\'\"\n            tooltip-position=\"bottom\">\n        ${\n    </button>\n    <button class=\"button\"\n            ng-if=\"!vm.variableMode\"\n            tooltip=\"\'Switch to variable\'\"\n            tooltip-position=\"bottom\">\n        ${\n    </button>\n</span>\n<span class=\"variable-dropdown\" ng-if=\"vm.variableMode\">\n    <span ng-if=\"vm.variableMode == true && vm.readOnly\" class=\"field-readonly read-only\" name=\"{{::vm.name}}\">\n        <span>{{ vm.draft.variable.displayName }}</span>\n     </span>\n    <div ng-if=\"!vm.readOnly\"\n         xl-widget-autocomplete\n         ng-model=\"vm.draft.variable\"\n         handlers=\"vm.handlers\"\n         options=\"{placeholder : \'Please select a variable of type \' + vm.variableTypeName}\"\n         obj-label=\"displayName\"\n         show-all-on-click=\"true\"\n         new-item-suffix=\"{{\'<i> &ndash; Create a new variable of type \' + vm.variableTypeName + \'</i>\'}}\"\n         auto-select-on-exact-match=\"false\"\n         ng-required=\"!!vm.options.required\"\n         open-on-click=\"true\"></div>\n</span>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-boolean-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"!vm.variableMode\">\n        <div ng-class=\"{\'field\': !vm.readOnly, \'field-readonly\': vm.readOnly}\">\n            <input name=\"{{::vm.name}}\" type=\"checkbox\" ng-model=\"vm.draft.value\"\n                     ng-checked=\"vm.draft.value\" ng-change=\"vm.onChangeInternal()\" ng-disabled=\"vm.readOnly\">\n        </div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-date-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"!vm.variableMode\">\n        <div ng-class=\"{\'field\': !vm.readOnly, \'field-readonly\': vm.readOnly}\">\n            <div class=\"date-variable\"\n                 date-editor\n                 name=\"{{::vm.name}}\"\n                 ng-model=\"vm.draft.value\"\n                 placeholder=\"Select date\"\n                 on-change=\"vm.onChangeInternal()\"\n                 deletable=\"true\"\n                 is-required=\"vm.model.requiresValue\"\n                 readonly=\"vm.readOnly\">\n            </div>\n        </div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-dependency-with-variables.html","<div class=\"variable-selector\">\n    <div class=\"row\">\n        <div class=\"col-md-9\">\n            <div class=\"btn-group btn-group-justified\" role=\"group\">\n                <div class=\"btn-group\">\n                    <button class=\"btn btn-flat manual-dependency-radio\" ng-class=\"{\'btn-flat-active\': !vm.variableMode}\" ng-click=\"vm.variableMode = false; vm.commit()\">\n                        <i class=\"xl-icon edit-icon\"></i>Release, phase, or task\n                    </button>\n                </div>\n                <div class=\"btn-group\">\n                    <button class=\"btn btn-flat variable-dependency-radio\" ng-class=\"{\'btn-flat-active\': vm.variableMode}\"\n                            ng-click=\"vm.variableMode = true; vm.commit()\"\n                            ng-disabled=\"!vm.options.variableModeEnabled\">\n                        <i class=\"xl-icon variable-icon\"></i>Variable\n                    </button>\n                </div>\n            </div>\n        </div>\n    </div>\n    <ng-switch on=\"vm.variableMode\">\n        <div class=\"variable-dropdown variable-dropdown-with-margin\" ng-switch-when=\"true\">\n            <div xl-widget-autocomplete\n                 ng-model=\"vm.draft.variable\"\n                 handlers=\"vm.handlers\"\n                 options=\"{placeholder : \'Please select a variable of type \' + vm.variableTypeName}\"\n                 obj-label=\"displayName\"\n                 show-all-on-click=\"true\"\n                 new-item-suffix=\"{{\'<i> &ndash; Create a new variable of type \' + vm.variableTypeName + \'</i>\'}}\"\n                 auto-select-on-exact-match=\"false\"\n                 open-on-click=\"true\"></div>\n        </div>\n        <div class=\"editor\" ng-switch-default>\n            <dependency-selector\n                 model=\"vm.draft.value\"\n                 task-id=\"vm.options.taskId\"\n                 on-change=\"vm.onChangeInternal()\">\n            </dependency-selector>\n        </div>\n    </ng-switch>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-dropdown-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-if=\"!vm.variableMode\">\n        <div xl-widget-autocomplete\n             ng-model=\"vm.draft.value\"\n             obj-label=\"title\"\n             showAllOnClick=\"true\"\n             handlers=\"vm.options.handlers\"\n             is-required=\"!!vm.options.required\"\n             is-disabled=\"vm.readOnly\"\n             select-mode=\"true\"\n             options=\"{placeholder: vm.options.placeholder}\"\n             show-all-on-click=\"true\"\n             open-on-click=\"true\"\n        ></div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-inline-password-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <span ng-if=\"!vm.readOnly\">\n            <span class=\"field\" name=\"{{::vm.name}}\" inline-password-editor model=\"vm.draft.value\" on-change=\"vm.onChangeInternal()\">\n                <span class=\"light-text\">Click here to modify the password</span>\n            </span>\n        </span>\n        <span class=\"field-readonly read-only\" ng-if=\"vm.readOnly\">\n           <span class=\"light-text\">*****</span>\n        </span>\n    </span>\n</div>");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-inline-text-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-if=\"!vm.variableMode\">\n         <span inline-text-editor\n               ng-if=\"!vm.readOnly\"\n               name=\"{{::vm.name}}\"\n               class=\"field\"\n               model=\"vm.draft.value\"\n               ng-required=\"vm.options.required\"\n               on-change=\"vm.onChangeInternal()\">\n            <span>{{ vm.draft.value }}</span>\n         </span>\n         <span ng-if=\"vm.readOnly\" class=\"field-readonly read-only inline-textarea\" name=\"{{::vm.name}}\">\n             <span>{{ vm.draft.value }}</span>\n         </span>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-inline-textarea-with-variables.html","<span class=\"variable-dropdown\" ng-init=\"vm.isReady = false\">\n    <div inline-textarea-with-variables-editor\n         placeholder=\"Set description\"\n         model=\"vm.model\"\n         enable-auto-complete=\"vm.isReady\"\n         position=\"vm.position\"\n         on-change=\"vm.onChangeInternal()\"\n         markdown\n         class=\"task-description\">\n        <span display-variables=\"vm.model\" variables=\"vm.release.variables\" markdown class=\"markdown\"></span>\n    </div>\n    <div ng-if=\"!vm.readOnly && vm.isReady\"\n         xl-widget-text-autocomplete\n         ng-model=\"vm.model\"\n         handlers=\"vm.handlers\"\n         obj-label=\"displayName\"\n         show-template=\"true\"\n         show-all-on-click=\"true\"\n         supports-new=\"true\"\n         new-item-suffix=\"{{\'<i> &ndash; Create a new variable of type \' + vm.variableTypeName + \'</i>\'}}\"\n         auto-select-on-exact-match=\"false\"\n         enable-auto-complete=\"vm.isReady\"\n         position=\"vm.position\"\n         open-on-click=\"false\"></div>\n</span>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-integer-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"xl-components editor\" ng-show=\"vm.variableMode == false\">\n         <input xl-dip-integer ng-if=\"!vm.readOnly\" name=\"{{::vm.name}}\" type=\"text\" class=\"editable\" ng-model=\"vm.draft.value\"\n                ng-blur=\"vm.onChangeInternal()\" metadata=\"{default: 0}\">\n         <span ng-if=\"vm.readOnly\" class=\"field-readonly read-only\" name=\"{{::vm.name}}\">\n            <span>{{ vm.draft.value }}</span>\n         </span>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-list-of-strings-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <div xl-dip-list\n             class=\"field\"\n             name=\"{{::vm.name}}\"\n             data-ng-model=\"vm.draft.value\"\n             metadata=\"{name: vm.name, required: false}\"\n             read-only=\"vm.readOnly\"\n             on-change=\"vm.onChangeInternal()\"></div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-map-string-string-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <div xl-dip-map-string-string\n             class=\"field\"\n             name=\"{{::vm.name}}\"\n             data-ng-model=\"vm.draft.value\"\n             metadata=\"{name: vm.name, required: false, minVisibleRow: 5}\"\n             read-only=\"vm.readOnly\"\n             on-change=\"vm.onChangeInternal()\"\n             open-on-click=\"true\"></div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/directives/variable-selector/xlr-set-of-strings-with-variables.html","<div class=\"variable-selector\">\n    <span ng-include=\"\'partials/directives/variable-selector/variable-toggle-and-selector.html\'\"></span>\n    <span class=\"editor\" ng-show=\"vm.variableMode == false\">\n        <div xl-dip-set\n             class=\"field\"\n             name=\"{{::vm.name}}\"\n             data-ng-model=\"vm.draft.value\"\n             metadata=\"{name: vm.name, required: false}\"\n             read-only=\"vm.readOnly\"\n             on-change=\"vm.onChangeInternal()\"></div>\n    </span>\n</div>\n");
$templateCache.put("static/9.0.2/partials/folders/modals/folder-create-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"ctrl.clearFolderName(); dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Create a new folder {{ctrl.selectedFolder ? \'in \' + ctrl.selectedFolder.title : \'\'}}</h4>\n    </div>\n    <form name=\"createFolderForm\" class=\"form-horizontal\" novalidate>\n        <div class=\"modal-body\">\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\" for=\"folder-name\">Folder name <span class=\"error\">*</span></label>\n                <div class=\"col-sm-9\">\n                    <input type=\"text\" class=\"input-block-level text\" id=\"folder-name\" name=\"folderName\"\n                           ng-model=\"ctrl.newFolderName\" not-in-list=\"ctrl.folders\" required autofocus/>\n                    <span class=\"description\" ng-if=\"createFolderForm.folderName.$pristine || createFolderForm.folderName.$valid\">\n                        Unique name for the folder.\n                    </span>\n                    <div class=\"field-errors\" ng-if=\"createFolderForm.folderName.$dirty\">\n                        <span ng-if=\"createFolderForm.folderName.$error.notInList\">Folder with this name already exists</span>\n                        <span ng-if=\"createFolderForm.folderName.$error.required\">Folder name is mandatory</span>\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"ctrl.clearFolderName(); dismiss()\">Cancel</button>\n            <button type=\"submit\" class=\"button continue primary\" ng-disabled=\"createFolderForm.$invalid\" ng-click=\"ctrl.add(); dismiss()\">Create</button>\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/folders/modals/folder-delete-error-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Delete Folder</h4>\n    </div>\n    <div class=\"modal-body\">\n        {{ errorMessage }}\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button primary\" ng-click=\"dismiss()\">OK</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/folders/modals/folder-delete-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4>Delete Folder</h4>\n    </div>\n    <div class=\"modal-body\">\n        You are about to delete the folder <b>{{row.entity.title}}</b>.\n        Folders nested in <b>{{row.entity.title}}</b> will also be deleted.\n    </div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button cancel\" ng-click=\"dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"button primary\" focus-on=\"true\" ng-click=\"grid.appScope.vm.del(row.entity); dismiss()\">Delete</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/folders/modals/folder-rename-error-modal.html","<div class=\"modal-content\">\n    <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n        <h4 class=\"modal-title\">Rename Folder</h4>\n    </div>\n    <div class=\"modal-body\">The name <strong>{{folderTitle}}</strong> is already in use. Please choose another name.</div>\n    <div class=\"modal-footer\">\n        <button type=\"button\" class=\"button continue primary\" ng-click=\"dismiss()\">Ok</button>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/gantt/gantt.html","<div id=\"gantt\" class=\"gantt\">\n    <div release-flow-header>\n        <div id=\"gantt-zooms-container\">\n            <span>Zoom</span>\n            <button class=\"btn btn-flat\"\n                    ng-click=\"ganttZoom.select(ganttZoom.previous())\"\n                    ng-disabled=\"!ganttZoom.hasPrevious()\"><i class=\"xl-icon minus-icon icon-s\" /></button>\n            <button class=\"btn btn-flat\"\n                    ng-click=\"ganttZoom.select(ganttZoom.next())\"\n                    ng-disabled=\"!ganttZoom.hasNext()\"><i class=\"xl-icon add-icon icon-s\" /></button>\n            <input type=\"checkbox\" id=\"toggleIsDatesColumnsShown\"\n                   ng-model=\"ganttConfig.isDatesColumnsShown\">\n            <label for=\"toggleIsDatesColumnsShown\">Show dates</label>\n        </div>\n        <div class=\"buttons\">\n            <span doc-icon=\"planner.html\"></span>\n        </div>\n    </div>\n    <div class=\"content-under-header\">\n        <div class=\"gantt-container\" xlr-gantt readonly=\"ganttConfig.isReadOnly\"></div>\n    </div>\n    <div ng-if=\"editTask\" modal=\"\'partials/tasks/details/task-details-modal.html\'\" open-on=\"editTask\" on-modal-hide=\"endEditTask()\" init=\"editTask(task, release)\" ng-controller=\"taskDetailsController\"></div>\n    <div ng-if=\"editPhase\" modal=\"\'partials/releases/phase-details-modal.html\'\" open-on=\"editPhase\" on-modal-hide=\"endEditPhase()\" ng-controller=\"phaseDetailsController\"></div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/gantt/zoom.html","<div id=\"gantt-zooms\">\n    <a ng-repeat=\"zoom in ganttZoom.zooms\" ng-click=\"ganttZoom.select(zoom)\">\n        <div><span ng-class=\"{\'active\': ganttZoom.isCurrent(zoom)}\"></span> {{ zoom.label }}</div>\n    </a>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/grid/grid-context-menu.html","<div context-menu id=\"context-menu-container\" items=\"grid.appScope.ctrl.contextMenuItems(row.entity.planItem, row.entity.container, grid.appScope.ctrl.withinBlackout)\" ctrl=\"grid.appScope.ctrl\" task=\"row.entity.planItem\" container=\"row.entity.container\"></div>");
$templateCache.put("static/9.0.2/partials/releases/grid/more-bulk-actions-menu.html","<div class=\"xlr-popover\">\n    <a class=\"fail-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.fail}\"\n       ng-click=\"$ctrl.allowedActions.fail && $ctrl.fail()\">\n        <div>Fail</div>\n    </a>\n    <a class=\"retry-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.retry}\"\n       ng-click=\"$ctrl.allowedActions.retry && $ctrl.retry()\">\n        <div>Retry</div>\n    </a>\n    <a class=\"abort-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.abort}\"\n       ng-click=\"$ctrl.allowedActions.abort && $ctrl.abort()\">\n        <div>Abort</div>\n    </a>\n    <a class=\"skip-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.skip}\"\n       ng-click=\"$ctrl.allowedActions.skip && $ctrl.skip()\">\n        <div>Skip</div>\n    </a>\n    <a class=\"reopen-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.reopen}\"\n       ng-click=\"$ctrl.allowedActions.reopen && $ctrl.reopen()\">\n        <div>Reopen</div>\n    </a>\n    <a class=\"remove-action\" ng-class=\"{\'link-disabled\': !$ctrl.allowedActions.remove}\"\n       ng-click=\"$ctrl.allowedActions.remove && $ctrl.remove()\">\n        <div>Delete</div>\n    </a>\n</div>\n");
$templateCache.put("static/9.0.2/partials/releases/grid/release-grid.html","<div id=\"release\" class=\"release-grid {{ release.status | lowercase }}\">\n    <div release-flow-header>\n        <div class=\"buttons\">\n            <a ng-if=\"pageCtrl.canRefreshGrid(release)\" ng-click=\"pageCtrl.refreshGrid()\" title=\"Refresh\" class=\"refresh-grid button\">\n                <i class=\"xl-icon refresh-icon\"></i> Refresh\n            </a>\n            <a ng-if=\"pageCtrl.canStartRelease(release)\" modal=\"\'partials/releases/start-release-modal.html\'\" class=\"start-release primary button\">Start Release</a>\n            <a ng-if=\"pageCtrl.canAbortRelease(release)\" modal=\"\'partials/releases/abort-release-modal.html\'\" class=\"abort-release button\">Abort Release</a>\n\n            <span doc-icon=\"release-grid.html\"></span>\n        </div>\n    </div>\n    <div class=\"content-under-header\">\n        <div release-grid release=\"release\"></div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/risks/risk-profile/risk-profile-slider.html","<div class=\"rzslider\" style=\"text-overflow: clip;\">\n    <span class=\"rz-bar-wrapper rz-left-out-selection\"><span class=rz-bar></span></span> <!-- // 0 (left) Highlight outside two handles -->\n    <span class=\"rz-bar-wrapper rz-right-out-selection\"><span class=rz-bar></span></span> <!-- // 1 (right) Highlight outside two handles -->\n    <span class=\"rz-bar-wrapper\"><span class=\"rz-bar\"></span></span>\n    <!-- // 0 The slider bar -->\n    <span class=\"rz-bar-wrapper\">\n        <span class=\"rz-bar rz-selection\" ng-style=\"barStyle\"></span>\n    </span>\n    <!-- // 1 Highlight between two handles -->\n    <span class=\"rz-pointer rz-pointer-min\" ng-style=minPointerStyle>\n        <span class=\"rz-ruleset-pointer\" background-color=\"minPointerStyle.backgroundColor\" slider-rule ng-style=\"{\'color\': \'#fff\'}\" >\n        </span>\n    </span>\n    <!-- // 2 Left slider handle -->\n    <span class=\"rz-pointer rz-pointer-max\"></span>\n    <!-- // 3 Right slider handle -->\n    <span class=\"rz-bubble rz-limit rz-floor\"></span>\n    <!-- // 4 Floor label -->\n    <span class=\"rz-bubble rz-limit rz-ceil\"></span>\n    <!-- // 5 Ceiling label -->\n    <span class=\"rz-bubble min-label\" ng-class=\"minPointerStyle.backgroundColor\"></span>\n    <!-- // 6 Label above left slider handle -->\n    <span class=\"rz-bubble max-label\"></span>\n    <!-- // 7 Label above right slider handle -->\n    <span class=\"rz-bubble\"></span>\n    <!-- // 8 Range label when the slider handles are close ex. 15 - 17 -->\n    <ul ng-show=\"showTicks\" class=\"rz-ticks\">\n        <!-- // 9 The ticks -->\n        <li ng-repeat=\"t in ticks track by $index\" class=\"rz-tick\" ng-class=\"{\'rz-selected\': t.selected}\" ng-style=\"t.style\" ng-attr-uib-tooltip=\"{{ t.tooltip }}\"\n            ng-attr-tooltip-placement=\"{{t.tooltipPlacement}}\" ng-attr-tooltip-append-to-body=\"{{ t.tooltip ? true : undefined}}\">\n            <span ng-if=\"t.value != null\" class=\"rz-tick-value\" ng-attr-uib-tooltip=\"{{ t.valueTooltip }}\" ng-attr-tooltip-placement=\"{{t.valueTooltipPlacement}}\">{{ t.value }}</span>\n            <span ng-if=\"t.legend != null\" class=\"rz-tick-legend\">{{ t.legend }}</span>\n        </li>\n    </ul>\n</div>");
$templateCache.put("static/9.0.2/partials/risks/risk-profile/risk-profile.html","<div id=\"risk-settings\">\n    <form name=\"newRiskProfileForm\" class=\"form-horizontal\" novalidate>\n        <div id=\"risks-header\" class=\"header\">\n            <div class=\"buttons\">\n                <button class=\"button cancel\" ui-sref=\"riskSettings\">Cancel</button>\n                <button ng-disabled=\"!(ctrl.editable && (newRiskProfileForm.$dirty || ctrl.riskAssessorChanged) && ctrl.riskProfile.title)\" id=\"submit\" type=\"submit\" class=\"button save primary\"\n                        ng-click=\"ctrl.save()\">Save\n                </button>\n                <span ng-if=\"lastSavedDate\" class=\"last-saved\">Last saved on {{ ctrl.lastSavedDate | date: \'medium\' }}</span>\n            </div>\n            <span doc-icon=\"configure-risk-settings.html#manage-risk-profiles\"></span>\n        </div>\n        <div class=\"content-under-header\">\n            <div class=\"form-group reset-horizontal-margins\" ng-if=\"!ctrl.loading\">\n                <br/>\n                <div class=\"row\">\n                    <div class=\"col-md-2\">\n                        <label for=\"riskProfileTitle\" class=\"control-label\">\n                            Risk profile name\n                            <span ng-if=\"ctrl.editable\" class=\"error\">*</span>\n                        </label>\n                    </div>\n                    <div class=\"col-md-10\">\n                        <div class=\"risk-profile-name-input\">\n                            <input class=\"form-control\"\n                                   data-ng-model=\"ctrl.riskProfile.title\"\n                                   id=\"riskProfileTitle\"\n                                   maxlength=\"50\"\n                                   name=\"riskProfileTitle\"\n                                   ng-disabled=\"!ctrl.editable\"\n                                   required\n                                   type=\"text\"\n                                   ng-change=\"ctrl.riskProfileChangeListener()\"\n                                   focus-on=\"true\"/>\n                            <span class=\"description\" ng-if=\"newRiskProfileForm.riskProfileTitle.$pristine || newRiskProfileForm.riskProfileTitle.$valid\">\n                                Unique name for the risk profile.\n                            </span>\n                            <span class=\"field-errors\" ng-if=\"newRiskProfileForm.riskProfileTitle.$dirty\">\n                                <span ng-if=\"newRiskProfileForm.riskProfileTitle.$error.required\">Risk profile name is mandatory</span>\n                            </span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <div class=\"slider-view\" ng-if=\"!ctrl.loading\">\n                <div class=\"row\">\n                    <div class=\"col-md-2 align-config-slider\">\n                        <span>\n                            <b> Risk assessors </b>\n                            <span class=\"inline-doc-icon\" doc-icon=\"using-the-risk-aware-view.html\"></span>\n                        </span>\n                    </div>\n                    <div class=\"col-md-9 disabled\">\n                        <rzslider class=\"custom-slider disabled profile-mode\"\n                                  rz-slider-high=\"ctrl.riskGlobalSlider.maxValue\"\n                                  rz-slider-model=\"ctrl.riskGlobalSlider.minValue\"\n                                  rz-slider-options=\"ctrl.riskGlobalSlider.options\"\n                                  rz-slider-tpl-url=\"partials/risks/custom-slider.html\"\n                        ></rzslider>\n                    </div>\n                    <div ng-if=\"ctrl.Authenticator.isAdmin()\" class=\"col-md-1 align-config-slider\">\n                        &nbsp;\n                    </div>\n                </div>\n\n                <div class=\"row risk-profiles slider-profile-wrapper\" ng-repeat=\"riskAssessor in ctrl.riskProfileAssessors track by $index\">\n                    <br ng-if=\"!riskAssessor.id\"/>\n                    <div ng-if=\"riskAssessor.id\">\n                        <div class=\"col-md-2  align-assessor-slider\">\n                            <span ng-if=\"riskAssessor.group\"> {{riskAssessor.group}}  <i ng-class=\"riskAssessor.icon\"></i>  </span>\n                            <span class=\"pull-right\" ng-if=\"riskAssessor.group !== riskAssessor.title\"> {{riskAssessor.title}}  </span>\n                        </div>\n                        <!-- don\'t add any space / formatting here used for :empty-->\n                        <div class=\"col-md-9 slider-profile-wrapper\" ng-if=\"riskAssessor.enabled && ctrl.editable\">\n                            <rzslider class=\"risk-profile-slider\" rz-slider-model=\"riskAssessor.score\" rz-slider-options=\"ctrl.riskProfileSlider.options\"\n                                      rz-slider-tpl-url=\"partials/risks/risk-profile/risk-profile-slider.html\"></rzslider>\n                        </div>\n                        <div class=\"col-md-9 slider-profile-wrapper\" ng-if=\"!riskAssessor.enabled || !ctrl.editable\">\n                            <rzslider class=\"risk-profile-slider\" rz-slider-model=\"riskAssessor.score\"\n                                      rz-slider-options=\"ctrl.riskProfileSliderDisabled.options\"\n                                      rz-slider-tpl-url=\"partials/risks/risk-profile/risk-profile-slider.html\"></rzslider>\n                        </div>\n                        <div class=\"col-md-1 align-assessor-slider\">\n                            <a class=\"link color-inherited risk-action hover-button\" ng-click=\"ctrl.rpEnabled(riskAssessor)\"\n                               ng-if=\"ctrl.editable\">\n                                <i title=\"{{ riskAssessor.enabled ? \'Disable\' : \'Enable\' }}\" class=\"xl-icon power-icon\"></i>\n                                <span>{{ riskAssessor.enabled ? \'Disable\' : \'Enable\' }}</span>\n                            </a>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <div ng-if=\"ctrl.loading\" class=\"spinner\" style=\"text-align: center\">\n                <img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n            </div>\n\n        </div>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/actions/done-in-advance-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"reopenTaskMode = !reopenTaskMode\" ng-hide=\"reopenTaskMode\">Reopen</button>\n</div>\n<div class=\"task-actions\" ng-show=\"reopenTaskMode\">\n    <form name=\"reopenTaskForm\">\n        <textarea rows=\"4\" ng-model=\"reopenFeedback\" placeholder=\"Give feedback or place a comment to reopen the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"reopenTask(task, reopenFeedback); dismiss();\" ng-disabled=\"reopenTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"reopenTaskMode = !reopenTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/actions/failed-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"retryTaskMode = !retryTaskMode; skipTaskMode = false\" ng-hide=\"!security.isAdminOr(task.releaseOwner) && !security.isAdminOr(task.owner) || skipTaskMode || retryTaskMode || isUnknownTask()\">Retry</button>\n    <button class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode; retryTaskMode = false\" ng-disabled=\"!canSkipTask(release, task)\" ng-hide=\"skipTaskMode || retryTaskMode\">Skip</button>\n</div>\n<div class=\"task-actions\" ng-show=\"skipTaskMode\">\n    <form name=\"skipTaskForm\">\n        <textarea rows=\"4\" ng-model=\"skipFeedback\" placeholder=\"Give feedback or place a comment to skip the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"skipTask(task, skipFeedback); dismiss();\" ng-disabled=\"skipTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"retryTaskMode\">\n    <form name=\"retryTaskForm\">\n        <textarea rows=\"4\" ng-model=\"retryFeedback\" placeholder=\"Give feedback or place a comment to retry the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"retryTask(task, retryFeedback); dismiss();\" ng-disabled=\"retryTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button\" ng-click=\"retryTaskMode = !retryTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/actions/in-progress-script-task.html","<div class=\"task-actions\">\n    <button class=\"button\" ng-click=\"abortTaskMode = !abortTaskMode\" ng-hide=\"abortTaskMode\">Abort</button>\n</div>\n<div class=\"task-actions\" ng-show=\"abortTaskMode\">\n    <form name=\"abortTaskForm\">\n        <textarea rows=\"4\" ng-model=\"abortFeedback\" placeholder=\"Give feedback or place a comment to abort the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"abortTask(task, abortFeedback); dismiss();\" ng-disabled=\"abortTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"abortTaskMode = !abortTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/actions/in-progress-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"completeTaskMode = !completeTaskMode; skipTaskMode = false; failTaskMode = false\" ng-disabled=\"!canCompleteTask(release, task)\" ng-hide=\"completeTaskMode || skipTaskMode || failTaskMode\">Complete</button>\n    <button class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode; completeTaskMode = false; failTaskMode = false\" ng-disabled=\"!canSkipTask(release, task)\" ng-hide=\"completeTaskMode || skipTaskMode || failTaskMode\">Skip</button>\n    <button class=\"button\" ng-click=\"failTaskMode = !failTaskMode; completeTaskMode = false; skipTaskMode = false\" ng-hide=\"completeTaskMode || skipTaskMode || failTaskMode\">Fail</button>\n</div>\n<div class=\"task-actions\" ng-show=\"completeTaskMode && canCompleteTask(release, task)\">\n    <form name=\"completeTaskForm\">\n        <textarea rows=\"4\" ng-model=\"feedback\" placeholder=\"Give feedback or place a comment to complete the task...\"></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"completeTask(task, feedback); dismiss();\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"completeTaskMode = !completeTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"skipTaskMode\">\n    <form name=\"skipTaskForm\">\n        <textarea rows=\"4\" ng-model=\"skipFeedback\" placeholder=\"Give feedback or place a comment to skip the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"skipTask(task, skipFeedback); dismiss();\" ng-disabled=\"skipTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"skipTaskMode = !skipTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"failTaskMode\">\n    <form name=\"failTaskForm\">\n        <textarea rows=\"4\" ng-model=\"failFeedback\" placeholder=\"Give feedback or place a comment to fail the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"failTask(task, failFeedback); dismiss();\" ng-disabled=\"failTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"failTaskMode = !failTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/actions/pending-task.html","<div class=\"task-actions\">\n    <div ng-if=\"!canStartTaskWithinBlackout(release)\">\n        <span class=\"error\">\n            You can\'t start this task now because it\'s subject to the current blackout period.\n        </span>\n    </div>\n    <button class=\"button\" ng-click=\"startTaskMode = !startTaskMode;\" ng-hide=\"startTaskMode\" ng-disabled=\"!canStartTaskWithinBlackout(release)\">Start now</button>\n</div>\n<div ng-show=\"startTaskMode\" class=\"task-actions\">\n    <form name=\"startTaskNowForm\">\n        <textarea rows=\"4\" ng-model=\"feedback\" placeholder=\"Give feedback or place a comment to start the task now...\" required></textarea>\n        <div class=\"task-actions-info\" ng-if=\"task.delayDuringBlackout && withinBlackout\">\n            <span class=\"error\">Are you sure you want to run this task during the blackout period?</span>\n        </div>\n        <button type=\"button\" class=\"button primary\" ng-click=\"startNow(task, feedback);dismiss();\" ng-disabled=\"startTaskNowForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"startTaskMode = !startTaskMode;\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/actions/planned-task.html","<div class=\"task-actions\">\n    <button class=\"button primary\" ng-click=\"completeTaskMode = !completeTaskMode; skipTaskMode = false\" ng-disabled=\"isGateClosed(task) || !canCompleteTask(release, task)\" ng-hide=\"isAutomated(task) || completeTaskMode || skipTaskMode\">Complete</button>\n    <button class=\"button\" ng-click=\"skipTaskMode = !skipTaskMode; completeTaskMode = false\" ng-disabled=\"!canSkipTask(release, task)\" ng-hide=\"completeTaskMode || skipTaskMode\">Skip</button>\n</div>\n<div class=\"task-actions\" ng-show=\"!isAutomated(task) && completeTaskMode && !isGateClosed(task)\">\n    <form name=\"completeTaskForm\">\n        <textarea rows=\"4\" ng-model=\"feedback\" placeholder=\"Give feedback or place a comment to complete the task...\"></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"completeTask(task, feedback); dismiss();\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"completeTaskMode = !completeTaskMode\">Cancel</button>\n    </form>\n</div>\n<div class=\"task-actions\" ng-show=\"skipTaskMode\">\n    <form name=\"skipTaskForm\">\n        <textarea rows=\"4\" ng-model=\"skipFeedback\" placeholder=\"Give feedback or place a comment to skip the task...\" required></textarea>\n        <button type=\"button\" class=\"button primary\" ng-click=\"skipTask(task, skipFeedback); dismiss();\" ng-disabled=\"skipTaskForm.$invalid\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"skipTaskMode = !skipTaskMode\">Cancel</button>\n    </form>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/actions/waiting-for-input-task.html","<div>\n    <form name=\"taskVariablesForm\" class=\"form-horizontal\">\n        <p>Please enter the required information and start the task.</p>\n        <div variables-editor\n             variables=\"variables\"\n             form=\"taskVariablesForm\"\n             filter=\"{}\">\n        </div>\n        <button type=\"button\" class=\"button primary\" ng-disabled=\"taskVariablesForm.$invalid\" ng-click=\"startTaskWithInput(task, variables);dismiss();\">Start task</button>\n    </form>\n</div>");
$templateCache.put("static/9.0.2/partials/tasks/details/create-release-details.html","<div class=\"create-release-details\" ng-controller=\"xlrelease.CreateReleaseDetailsController as createReleaseCtrl\">\n    <div class=\"form-horizontal\" ng-form=\"createReleaseForm\">\n        <div class=\"properties\">\n            <hr/>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Release title <span class=\"error\">*</span></label>\n\n                <div class=\"col-sm-9\">\n                    <div ng-if=\"!createReleaseCtrl.readOnlyOrLocked\" class=\"ui-front\" inline-text-editor model=\"createReleaseCtrl.newReleaseTitle\">\n                        <span display-variables=\"createReleaseCtrl.newReleaseTitle\" variables=\"createReleaseCtrl.releaseVariables\"></span>\n                    </div>\n                    <div ng-if=\"createReleaseCtrl.readOnlyOrLocked\" class=\"ui-front field-readonly read-only\">\n                        <span display-variables=\"createReleaseCtrl.newReleaseTitle\" variables=\"createReleaseCtrl.releaseVariables\"></span>\n                    </div>\n                    <div class=\"description\">Title of the release to create.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Template <span class=\"error\">*</span></label>\n\n                <div class=\"col-sm-9\">\n                    <div ng-if=\"createReleaseCtrl.templates && allVariables\"\n                         xlr-template-from-value-or-variable-selector\n                         name=\"template\"\n                         model=\"createReleaseCtrl.selectedTemplate\"\n                         variables=\"createReleaseCtrl.templateVariables\"\n                         metadata=\"{name: \'template\'}\"\n                         on-change=\"createReleaseCtrl.onTemplateVariableChange()\"\n                         on-new=\"createReleaseCtrl.createVariable(name, variableType, createdCallback, true)\"\n                         options=\"{placeholder: \'Select template...\', handlers: createReleaseCtrl.templateListHandlers, required: true}\"\n                         read-only=\"createReleaseCtrl.readOnlyOrLocked\"\n                    ></div>\n                    <div ng-if=\"createReleaseCtrl.showTemplateConfirmation\" class=\"confirm-box\" style=\"padding-top: 5px;\">\n                        <span class=\"error\" style=\"height: 16px;font-family: OpenSans;font-size: 11px;font-weight: normal;font-style: normal;\n                            font-stretch: normal;line-height: 1.45;letter-spacing: normal;\">{{createReleaseCtrl.changeTemplateErrorMsg}}</span>\n                        <div style=\"float: right\">\n                        <span class=\"ok\" style=\"cursor: pointer;\" ng-click=\"createReleaseCtrl.confirmTemplateChange()\">\n                                <i class=\"xl-icon check-icon\" style=\"vertical-align: middle; margin-right: 5px;\"></i>Yes\n                        </span>\n                        <span class=\"cancel\" style=\"cursor: pointer;\" ng-click=\"createReleaseCtrl.cancelTemplateChange()\">\n                            <i class=\"xl-icon close-icon\" style=\"vertical-align: middle; margin-left: 15px; margin-right: 5px;\"></i>No\n                        </span>\n                        </div>\n                    </div>\n                    <div ng-if=\"!createReleaseCtrl.hiddenVariables\" class=\"description\">Template to use when creating the release.</div>\n                    <span ng-if=\"createReleaseCtrl.hiddenVariables\" class=\"field-errors\">You do not have permissions to view the selected template.</span>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Folder</label>\n\n                <div class=\"col-sm-9\">\n                    <xl-react-widget-tree-select ng-if=\"!createReleaseCtrl.readOnlyOrLocked && createReleaseCtrl.foldersReady\"\n                                           clearable=\"false\"\n                                           data=\"createReleaseCtrl.folders\"\n                                           selected-folder-id=\"createReleaseCtrl.folderId\"\n                                           on-model-change=\"createReleaseCtrl.updateSelectedFolder\"></xl-react-widget-tree-select>\n                    <div ng-if=\"createReleaseCtrl.readOnlyOrLocked\" class=\"ui-front field-readonly read-only\">\n                        {{createReleaseCtrl.folderTitle}}\n                    </div>\n                    <div ng-if=\"createReleaseCtrl.showFolderConfirmation\" class=\"confirm-box\" style=\"padding-top: 5px;\">\n                        <span class=\"error\" style=\"height: 16px;font-family: OpenSans;font-size: 11px;font-weight: normal;font-style: normal;\n                            font-stretch: normal;line-height: 1.45;letter-spacing: normal;\">{{createReleaseCtrl.changeFolderConfirmationMsg}}</span>\n                        <div style=\"float: right\">\n                        <span class=\"ok\" style=\"cursor: pointer;\" ng-click=\"createReleaseCtrl.confirmFolderChange()\">\n                                <i class=\"xl-icon check-icon\" style=\"vertical-align: middle; margin-right: 5px;\"></i>Yes\n                        </span>\n                            <span class=\"cancel\" style=\"cursor: pointer;\" ng-click=\"createReleaseCtrl.cancelFolderChange()\">\n                            <i class=\"xl-icon close-icon\" style=\"vertical-align: middle; margin-left: 15px; margin-right: 5px;\"></i>No\n                        </span>\n                        </div>\n                    </div>\n                    <div ng-if=\"!createReleaseCtrl.hiddenFolder\" class=\"description\">The new release will be created in this folder.</div>\n                    <span ng-if=\"createReleaseCtrl.foldersReady && createReleaseCtrl.hiddenFolder && !createReleaseCtrl.showFolderConfirmation\" class=\"field-errors\">You do not have permissions to view the selected folder.</span>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Risk profile <span class=\"error\">*</span></label>\n\n                <div class=\"col-sm-9\">\n                    <div ng-if=\"createReleaseCtrl.readOnlyOrLocked\" class=\"field-readonly read-only\">{{createReleaseCtrl.selectedRiskProfile.title}}</div>\n                    <div ng-if=\"!createReleaseCtrl.readOnlyOrLocked && createReleaseCtrl.riskProfiles\"\n                         xl-widget-autocomplete\n                         ng-model=\"createReleaseCtrl.selectedRiskProfile\"\n                         metadata=\"{name: \'riskProfile\'}\"\n                         obj-label=\"title\"\n                         show-all-on-click=\"true\"\n                         open-on-click=\"true\"\n                         handlers=\"createReleaseCtrl.riskProfileListHandlers\">\n                    </div>\n                    <div class=\"description\">Risk profile to use when creating the release.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Start release</label>\n\n                <div class=\"col-sm-9\">\n                    <div id=\"startRelease\" xlr-boolean-with-variables\n                         class=\"field\"\n                         name=\"\'startRelease\'\"\n                         model=\"createReleaseCtrl.startRelease\"\n                         variables=\"createReleaseCtrl.allVariables\"\n                         on-change=\"createReleaseCtrl.saveTask()\"\n                         on-new=\"createReleaseCtrl.createVariable(name, variableType, createdCallback, true)\"\n                         read-only=\"createReleaseCtrl.readOnlyOrLocked\"></div>\n                    <div class=\"description\">Immediately start the release after it is created.</div>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                <label class=\"col-sm-3 control-label\">Release tags</label>\n\n                <div class=\"col-sm-9\">\n                    <div id=\"releaseTags\" tags-input\n                         class=\"transparent green-tags\"\n                         tags=\"createReleaseCtrl.releaseTags\"\n                         placeholder=\"Add a tag...\"\n                         on-change=\"createReleaseCtrl.updateReleaseTags(tags)\"\n                         read-only=\"createReleaseCtrl.readOnlyOrLocked\"></div>\n                </div>\n            </div>\n\n            <hr/>\n            <div>\n                <h4>Variables</h4>\n                <div class=\"help-block\">Variable values to pass to the created release.</div>\n                <add-variable\n                        data-ng-if=\"createReleaseCtrl.isTemplateFromVariable(createReleaseCtrl.selectedTemplate) && !createReleaseCtrl.readOnlyOrLocked\"\n                        all-variables=\"allVariables\"\n                        variables=\"createReleaseCtrl.variables\"\n                        on-add-variable=\"createReleaseCtrl.addNewVariable()\"></add-variable>\n                <div variables-editor\n                     variables=\"createReleaseCtrl.variables\"\n                     all-variables=\"createReleaseCtrl.allVariables\"\n                     form=\"createReleaseForm\"\n                     readonly=\"createReleaseCtrl.readOnly || createReleaseCtrl.hiddenVariables\"\n                     on-change=\"createReleaseCtrl.onVariableChanged(variable)\"\n                     replace-variables=\"true\"\n                     all-variables-replaceable=\"createReleaseCtrl.isTemplateFromVariable(createReleaseCtrl.selectedTemplate)\"\n                     supports-new-variable=\"true\"\n                     enable-remove=\"createReleaseCtrl.isTemplateFromVariable(createReleaseCtrl.selectedTemplate)\"\n                     on-remove=\"createReleaseCtrl.removeVariable()\"\n                     on-new-variable=\"createReleaseCtrl.createVariable(name, variableType, createdCallback, true)\">\n                </div>\n                <xlr-alert ng-if=\"createReleaseCtrl.hiddenVariables\" alert-type=\"warning\">\n                    You cannot edit variables and the variable information displayed may not be up-to-date because you do not have view permissions on the selected template.\n                </xlr-alert>\n            </div>\n            <hr/>\n            <div>\n                <h4>Output properties</h4>\n                <span class=\"help-block\" id=\"outputVarHelpText\">The ID of the newly created release can be stored in a release variable. This variable can be used in a Gate task dependency to wait for the completion of the release.</span>\n\n                <div class=\"form-group\">\n                    <label class=\"col-sm-3 control-label\">Release ID</label>\n\n                    <div class=\"col-sm-9\" id=\"createdReleaseId\">\n                        <div ng-if=\"createReleaseCtrl.readOnlyOrLocked\" class=\"field-readonly read-only\">{{createReleaseCtrl.createdReleaseId.variable}}</div>\n                        <div ng-if=\"!createReleaseCtrl.readOnlyOrLocked\"\n                             xlr-inline-text-with-variables\n                             name=\"\'createdReleaseId\'\"\n                             model=\"createReleaseCtrl.createdReleaseId\"\n                             on-change=\"createReleaseCtrl.saveTask()\"\n                             on-new=\"createReleaseCtrl.createVariable(name, variableType, createdCallback, false)\"\n                             variables=\"createReleaseCtrl.editableReleaseVariables\"\n                             enforce-mode=\"\'variable\'\">\n                        </div>\n                        <div class=\"description\">ID of the release created from this task.</div>\n                    </div>\n                </div>\n\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/details/custom-script-details.html","<div class=\"form-horizontal\">\n    <div class=\"properties\">\n        <div ng-show=\"scriptDefinition.inputProperties.length > 0\">\n            <h4>Input properties</h4>\n\n            <div xlr-dip-of-inline-with-variables\n                 property-definitions=\"scriptDefinition.inputProperties\"\n                 variables=\"allVariables\"\n                 read-only=\"areTaskPropertiesReadonlyOrLocked()\"\n                 property-values=\"task.inputProperties\"\n                 on-change=\"saveTask(task)\"\n                 reload-task-variables-callback=\"reloadTaskVariablesCallback(release)(task)\"\n                 on-new-variable=\"createRequiredVariable(task, name, variableType, createdCallback)\"\n                 show-variable-selector-for-text=\"false\">\n            </div>\n            <hr>\n        </div>\n        <div ng-show=\"scriptDefinition.outputProperties.length > 0\">\n            <h4>Output properties</h4>\n            <span class=\"help-block\" id=\"outputVarHelpText\">{{task.outputVarHelpText}}</span>\n\n            <div xlr-dip-of-inline-with-variables\n                 property-definitions=\"scriptDefinition.outputProperties\"\n                 variables=\"editableReleaseVariables\"\n                 read-only=\"areTaskPropertiesReadonlyOrLocked()\"\n                 property-values=\"task.outputProperties\"\n                 on-change=\"saveTask(task)\"\n                 on-new-variable=\"createOptionalVariable(task, name, variableType, createdCallback)\"\n                 enforce-mode=\"isDone(task) || isDoneInAdvance(task) || isTaskAborted(task) ? \'editor\' : \'variable\'\"\n                 show-required-sign=\"false\"\n                 show-variable-selector-for-text=\"true\">\n            </div>\n            <hr>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/details/gate-details.html","<div ng-controller=\"gateDetailsController\" class=\"gate-details\">\n    <div ng-repeat=\"condition in task.conditions\" class=\"condition\">\n        <div class=\"row\">\n            <div class=\"col-xs-1\">\n                <input type=\"checkbox\" ng-model=\"condition.checked\" ng-change=\"updateCondition(condition)\"\n                       ng-disabled=\"!canWorkOnTask(release) || release.status == \'TEMPLATE\'\"/>\n            </div>\n            <div class=\"col-xs-10\">\n                <div ng-if=\"canEditAndIsUnlocked()\" inline-text-editor model=\"condition.title\" on-change=\"updateCondition(condition)\"\n                     placeholder=\"Set condition title...\" class=\"condition-title editor\">\n                    <span display-variables=\"condition.title\" variables=\"release.variables\"></span>\n                </div>\n                <div ng-if=\"!canEditAndIsUnlocked()\" class=\"condition-title\">\n                    <span display-variables=\"condition.title\" variables=\"release.variables\"></span>\n                </div>\n            </div>\n            <div ng-if=\"canEditAndIsUnlocked()\" class=\"pull-right remove-condition\" ng-click=\"removeCondition(condition)\" title=\"Remove condition\">\n                <i class=\'xl-icon close-icon\'></i>\n            </div>\n        </div>\n    </div>\n    <a ng-if=\"showAddCondition()\" class=\"link\" ng-click=\"addCondition()\">Add condition</a>\n\n    <hr ng-if=\"showConditions() || showAddCondition()\">\n\n    <div ng-if=\"showDependencies() || showAddDependency()\">\n        <div class=\"dependency-title\" ng-if=\"showDependencies()\">Wait for completion of</div>\n        <div data-ng-if=\"isLoaded\" class=\"dependency\" ng-repeat=\"dependency in task.dependencies\">\n            <div class=\"row line\" ng-hide=\"isEditingDependency(dependency)\">\n                <div class=\"col-xs-1\">\n                    <i ng-if=\"dependency.resolved\" class=\"xl-icon check-icon\"></i>\n                </div>\n                <div ng-if=\"!dependency.variableOrTarget.variable && !dependency.variableOrTarget.value\" class=\"col-xs-8 dependency-objects\">\n                    <span class=\"placeholder\">(empty)</span>\n                </div>\n                <div ng-if=\"dependency.variableOrTarget.value\" class=\"col-xs-8 dependency-objects\">\n                    <a ng-href=\"{{goToRelease(dependency)}}\" class=\"link\"\n                       ng-attr-title=\"{{getDependencyTitle(dependency.variableOrTarget.value)}}\">\n                        {{getDependencyTitle(dependency.variableOrTarget.value)}}\n                    </a>\n                </div>\n                <div ng-if=\"dependency.variableOrTarget.variable\" class=\"col-xs-8 dependency-objects\">{{dependency.variableOrTarget.variable}}</div>\n\n                <div class=\"col-xs-3 dependency-info\">\n                    <status-badge data-ng-if=\"hasDependencyStatuses()\"\n                                  data-ng-repeat=\"status in getDependencyStatus(dependency)\" status=\"status\"></status-badge>\n\n                    <div ng-if=\"canEditDependency(dependency) || canDeleteDependency(dependency)\" class=\"link context-menu-button\" bs-popover\n                         data-content-template=\"partials/tasks/details/component/gate-dependency-context-menu.html\"\n                         data-placement=\"bottom\" auto-close=\"true\">\n                        <i class=\"xl-icon options-icon\"></i>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"row\" ng-if=\"isEditingDependency(dependency)\">\n                <div class=\"col-xs-12\">\n                    <div xlr-dependency-with-variables\n                         enforce-mode=\"dependencyDetailsMode\"\n                         model=\"draftDependency.variableOrTarget\"\n                         name=\"\'target\'\"\n                         on-change=\"onDependencyChange()\"\n                         on-new=\"createRequiredVariable(task, name, variableType, createdCallback)\"\n                         variables=\"allVariables\"\n                         options=\"{\'taskId\': task.id, \'variableModeEnabled\': !isTaskInProgress(task)}\">\n                    </div>\n                    <button class=\"button save primary\" ng-click=\"saveDependency()\" ng-disabled=\"!dependencyWasChanged\">OK</button>\n                    <button class=\"button cancel\" ng-click=\"cancelDependencyEditing()\">Cancel</button>\n                </div>\n            </div>\n        </div>\n\n        <div data-ng-if=\"!isLoaded\" class=\"text-center dependency-loader\">\n            <img src=\"static/9.0.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n        </div>\n\n        <a ng-if=\"showAddDependency() && isLoaded\" class=\"add-dependency link\" ng-click=\"addDependency()\">Add dependency</a>\n        <hr>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/details/notification-details.html","<div class=\"form-horizontal\">\n    <div class=\"properties\">\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">To <span class=\"error\">*</span></label>\n\n            <div class=\"col-sm-9\">\n                <div class=\"transparent mail-tags email-to\"\n                     tags-input\n                     tags=\"task.addresses\"\n                     placeholder=\"Add a recipient...\"\n                     on-change=\"task.addresses = tags; saveTask(task);\"\n                     read-only=\"areTaskPropertiesReadonlyOrLocked()\"\n                     variables=\"release.variables\">\n                </div>\n                <div class=\"description\">List of email addresses where the message will be sent. Separate each email by pressing the Return key</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">CC</label>\n\n            <div class=\"col-sm-9\">\n                <div class=\"transparent mail-tags email-cc\"\n                     tags-input\n                     tags=\"task.cc\"\n                     placeholder=\"Add a recipient...\"\n                     on-change=\"task.cc = tags; saveTask(task);\"\n                     read-only=\"areTaskPropertiesReadonlyOrLocked()\"\n                     variables=\"release.variables\">\n                </div>\n                <div class=\"description\">List of email addresses that receive the message as CC. Separate each email by pressing the Return key</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">BCC</label>\n\n            <div class=\"col-sm-9\">\n                <div class=\"transparent mail-tags email-bcc\"\n                     tags-input\n                     tags=\"task.bcc\"\n                     placeholder=\"Add a recipient...\"\n                     on-change=\"task.bcc = tags; saveTask(task);\"\n                     read-only=\"areTaskPropertiesReadonlyOrLocked()\"\n                     variables=\"release.variables\">\n                </div>\n                <div class=\"description\">List of email addresses that receive the message as BCC. Separate each email by pressing the Return key</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Reply to</label>\n\n            <div class=\"col-sm-9\">\n                <div ng-if=\"!areTaskPropertiesReadonlyOrLocked()\" class=\"email-reply-to\" inline-text-editor model=\"task.replyTo\" on-change=\"saveTask(task);\">\n                    <span display-variables=\"task.replyTo\" variables=\"release.variables\"></span>\n                </div>\n                <div ng-if=\"areTaskPropertiesReadonlyOrLocked()\" class=\"email-reply-to field-readonly read-only\">{{task.replyTo}}</div>\n                <div class=\"description\">The email address of the reply message recipient</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Mail priority</label>\n\n            <div class=\"col-sm-9\">\n                <select class=\"form-control font-size-inherit email-priority\" ng-model=\"task.mailPriority\" ng-change=\"saveTask(task);\"\n                        ng-disabled=\"areTaskPropertiesReadonlyOrLocked()\">\n                    <option value=\"\"></option>\n                    <option value=\"low\">Low</option>\n                    <option value=\"normal\">Normal</option>\n                    <option value=\"high\">High</option>\n                </select>\n                <div class=\"description\">The priority of the mail</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Subject <span class=\"error\">*</span></label>\n\n            <div class=\"col-sm-9\">\n                <div ng-if=\"!areTaskPropertiesReadonlyOrLocked()\" class=\"email-subject ui-front\" inline-text-editor model=\"task.subject\" on-change=\"saveTask(task)\">\n                    <span display-variables=\"task.subject\" variables=\"release.variables\"></span>\n                </div>\n                <div ng-if=\"areTaskPropertiesReadonlyOrLocked()\" class=\"email-subject ui-front field-readonly read-only\">\n                    <span display-variables=\"task.subject\" variables=\"release.variables\"></span>\n                </div>\n                <div class=\"description\">Subject of the message</div>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\">Body <span class=\"error\">*</span></label>\n\n            <div class=\"col-sm-9\">\n                <div ng-if=\"!areTaskPropertiesReadonlyOrLocked()\" class=\"email-body ui-front\">\n                    <div inline-textarea-editor model=\"task.body\" on-change=\"saveTask(task)\" markdown>\n                        <span display-variables=\"task.body\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n                    </div>\n                </div>\n                <div ng-if=\"areTaskPropertiesReadonlyOrLocked()\" class=\"email-body ui-front field-readonly read-only\">\n                    <span display-variables=\"task.body\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n                </div>\n                <div class=\"description\">Message body, in Markdown format</div>\n            </div>\n        </div>\n\n        <hr>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/details/script-details.html","<div class=\"form-horizontal\">\n    <div class=\"properties\">\n        <div class=\"form-group\">\n            <label class=\"col-sm-2 control-label\">Script <span class=\"error\">*</span></label>\n            <div class=\"col-sm-10\">\n                <div class=\"script-content ui-front\"\n                     ng-class=\"{\'pts read-only\': areTaskPropertiesReadonlyOrLocked()}\"\n                     inline-jython-editor\n                     placeholder=\"Set a script\"\n                     model=\"task.script\"\n                     variables=\"release.variables\"\n                     ignore-script-variable-interpolation=\"task.ignoreScriptVariableInterpolation\"\n                     read-only-mode=\"areTaskPropertiesReadonlyOrLocked()\"\n                     on-change=\"saveTask(task)\"></div>\n                <div>\n                    Ignore variable interpolation <input type=\"checkbox\" id=\"ignoreScriptVariableInterpolation\"\n                                                         data-ng-model=\"task.ignoreScriptVariableInterpolation\"\n                                                         data-ng-disabled=\"areTaskPropertiesReadonlyOrLocked()\"\n                                                         data-ng-change=\"saveTask(task, reloadTaskVariablesCallback(release))\"\n                                                         title=\"Ignore variable interpolation\">\n                </div>\n                <div class=\"description\">Python script to execute when the task becomes active. Please see the XL Release Python API for the list of helper\n                    objects, functions, and classes available to the script\n                </div>\n            </div>\n        </div>\n        <hr>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/details/task-details-modal.html","<div class=\"modal-content task-details {{task.type | taskTypeCssClass}} {{ task.status | taskStatusCssClass }}\" ng-style=\"{\'border-color\': task.color}\">\n    <div class=\"modal-header\" ng-style=\"{\'background-color\': task.color}\">\n        <button type=\"button\" class=\"close\" ng-click=\"dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\"/></button>\n        <span ng-if=\"isGateTask(task)\" class=\"xl-icon marker-check-icon\"></span>\n        <div ng-if=\"isUserInputTask(task)\" class=\"task-type-icon\">\n            <i class=\"xl-icon keyboard-icon\"></i>\n            <p>User Input</p>\n        </div>\n        <i ng-if=\"isCustomScriptTask(task) && !task.customIconLocation\" class=\"xl-icon script-icon pull-right\"></i>\n        <img ng-if=\"isCustomScriptTask(task) && task.customIconLocation\" class=\"custom-icon pull-right\"\n             ng-src=\"static/9.0.2/{{ task.customIconLocation }}\">\n\n        <div ng-show=\"canEditAndIsUnlocked()\">\n            <h4 class=\"task-title\" inline-text-editor model=\"task.title\" on-change=\"saveTask(task)\">\n                <span display-variables=\"task.title\" variables=\"release.variables\"></span>\n            </h4>\n        </div>\n        <div ng-hide=\"canEditAndIsUnlocked()\">\n            <h4 class=\"task-title\" display-variables=\"task.title\" variables=\"release.variables\"></h4>\n        </div>\n\n        <div ng-if=\"isScriptTask(task)\" class=\"pull-right\">\n            {{ task.typeDisplayGroup }} : {{ task.typeDisplayName }}\n        </div>\n        <div ng-if=\"isCustomScriptTask(task)\" class=\"pull-right\">\n            {{ scriptDefinition.displayGroup }} : {{ scriptDefinition.displayName }}\n        </div>\n        <div class=\"task-info\">\n            <span class=\"link\" ng-show=\"!security.hasViewPermission(release)\">{{task.releaseTitle}}</span>\n            <span class=\"link\" ng-show=\"security.hasViewPermission(release)\" ng-click=\"dismiss();viewTaskInRelease(release.id)\">{{task.releaseTitle}}</span>\n            /\n            <span display-variables=\"task.phaseTitle\" variables=\"release.variables\"></span>\n        </div>\n    </div>\n\n    <div class=\"task-alert\" ng-if=\"isTaskWaitingForInput(task) && canWorkOnTask(release) && !inGantt\">\n        <div class=\"task-warning-alert\">\n            <i class=\"xl-icon warning-icon\"></i>The task cannot start because some required information is missing.\n        </div>\n    </div>\n\n    <div class=\"modal-body\" data-ng-class=\"{ \'locked\': isLocked() }\">\n        <div class=\"locked-bar\" data-ng-if=\"isLocked()\">\n            <i class=\"xl-icon lock-icon\"></i> Task is locked, you can\'t edit this.\n            <button data-ng-disabled=\"isTaskReadOnly(task) || !hasLockPermission(release)\" data-ng-click=\"unlock(task)\" class=\"button unlock-button\">Unlock\n            </button>\n        </div>\n\n        <div class=\"pull-left left-detail\">\n            <div ng-if=\"isTaskWaitingForInput(task) && canWorkOnTask(release) && !inGantt\">\n                <a id=\"variables-anchor\" name=\"variables\"></a>\n                <div ng-include src=\"\'partials/tasks/actions/waiting-for-input-task.html\'\"></div>\n                <hr>\n            </div>\n\n            <div ng-show=\"canEditAndIsUnlocked()\">\n                <div xlr-inline-textarea-with-variables release=\"release\" variables=\"allVariablesWithReleaseVars\" model=\"task.description\"\n                     on-change=\"saveTask(task)\" markdown class=\"task-description\">\n                </div>\n            </div>\n\n            <div class=\"task-description\" ng-hide=\"canEditAndIsUnlocked()\">\n                <span display-variables=\"task.description\" variables=\"release.variables\" markdown class=\"markdown\"></span>\n            </div>\n\n            <div ng-if=\"isCreateReleaseTask(task)\" ng-include=\"\'partials/tasks/details/create-release-details.html\'\"></div>\n            <div ng-if=\"isUserInputTask(task)\" ng-include=\"\'partials/tasks/details/user-input-details.html\'\"></div>\n            <div ng-if=\"isTaskPending(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/pending-task.html\'\"></div>\n            </div>\n            <div ng-if=\"canUpdateInProgressStatus(task) && canWorkOnTask(release) && !isTaskGroup(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/in-progress-task.html\'\"></div>\n            </div>\n            <div ng-if=\"(isInProgressScriptTask(task) || isTaskPreconditionInProgress(task) || isTaskFailureHandlerInProgress(task)) || isTaskFacetInProgress(task)\n                        && canWorkOnTask(release) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/in-progress-script-task.html\'\"></div>\n            </div>\n            <div ng-if=\"isReleaseInProgress(release) && canUpdatePlannedStatus(task) && canWorkOnTask(release) && !isTaskGroup(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/planned-task.html\'\"></div>\n            </div>\n            <div ng-if=\"canWorkOnFailedTask(release, task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/failed-task.html\'\"></div>\n            </div>\n            <div ng-if=\"isReleaseInProgress(release) && isTaskDoneInAdvance(task) && canWorkOnReadOnlyTask(release) && !isTaskGroup(task) && !inGantt\">\n                <div ng-include src=\"\'partials/tasks/actions/done-in-advance-task.html\'\"></div>\n            </div>\n\n            <hr ng-if=\"canWorkOnTask(release)\">\n\n            <div ng-if=\"hasConfigurationUri(task)\" ng-include=\"getConfigurationUri(task)\"></div>\n            <div ng-if=\"!hasConfigurationUri(task)\" ng-include=\"\'partials/tasks/details/custom-script-details.html\'\"></div>\n\n            <div ng-if=\"task.preconditionEnabled\" class=\"form-horizontal precondition properties form-group mbn\">\n                <span class=\"form-group-toggle\" ng-click=\"togglePreConditionState(task)\">\n                <span ng-if=\"isPreConditionCollapsed(task)\" class=\"xl-icon arrow-right-icon precondition-title-collapsed\"></span>\n                <span ng-if=\"!isPreConditionCollapsed(task)\" class=\"xl-icon arrow-down-icon precondition-title-expanded\"></span>\n                    <h4 class=\"inline-label\">\n                        Precondition &nbsp;<span ng-if=\"task.precondition && task.preconditionEnabled\" class=\"xl-icon precondition-icon\"></span>\n                    </h4>\n                </span>\n                <div data-ng-if=\"(task.precondition === null || task.precondition === \'\') && !canEditPrecondition()  && !isPreConditionCollapsed(task)\">\n                    No precondition configured\n                </div>\n                <div data-ng-if=\"canEditPrecondition() || (task.precondition !== null && task.precondition !== \'\')\">\n                    <div ng-if=\"!isPreConditionCollapsed(task)\" class=\"precondition-form-group\">\n                        <div ng-show=\"canEditPrecondition()\">\n                            <span>Only execute the task if:</span>\n                            <div inline-jython-editor placeholder=\"Set precondition expression or script\" small=\"true\"\n                                 model=\"task.precondition\" on-change=\"saveTask(task)\" class=\"task-precondition ui-front\">\n                                <span display-variables=\"task.precondition\" variables=\"release.variables\" keep-new-lines></span>\n                            </div>\n                        </div>\n                        <div ng-hide=\"canEditPrecondition()\">\n                            <span>Only execute the task if:</span>\n                            <pre ng-if=\"task.precondition\" display-variables=\"task.precondition\" variables=\"release.variables\" keep-new-lines></pre>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <hr ng-if=\"task.preconditionEnabled\">\n\n            <div ng-if=\"task.failureHandlerEnabled\" class=\"form-horizontal failure-handler properties form-group mbn\">\n                <span class=\"form-group-toggle\" ng-click=\"toggleFailureHandlerState(task)\">\n                    <span ng-if=\"isFailureHandlerCollapsed(task)\" class=\"xl-icon arrow-right-icon failure-handler-title-collapsed\"></span>\n                    <span ng-if=\"!isFailureHandlerCollapsed(task)\" class=\"xl-icon arrow-down-icon failure-handler-title-expanded\"></span>\n                    <h4 class=\"inline-label\">\n                        Handling failure\n                    </h4>\n                </span>\n                <div ng-if=\"!isFailureHandlerCollapsed(task)\">\n                    <div data-ng-if=\"!task.taskFailureHandlerEnabled && !canEditFailureHandler()\">\n                        No failure handler\n                    </div>\n                    <div data-ng-if=\"canEditFailureHandler() || task.taskFailureHandlerEnabled\">\n                        <label for=\"task-failure-script\">\n                            <input ng-disabled=\"!canEditFailureHandler() || isTaskFailureHandlerInProgress(task)\" type=\"checkbox\" id=\"task-failure-script\"\n                                   ng-model=\"task.taskFailureHandlerEnabled\" ng-change=\"saveTask(task)\"/>\n                            <span>Enable task failure handler <span doc-icon=\"task-failure-handler.html\"></span></span>\n                        </label>\n                        <div class=\"failure-handler-container\"\n                             ng-if=\"canEditFailureHandler() && !isTaskFailureHandlerInProgress(task) && task.taskFailureHandlerEnabled\">\n                            <div class=\"bold\">If the task fails</div>\n                            <span uib-dropdown class=\"dropdown-selector btn-block\" ng-init=\"initTaskRecoverOp(task)\">\n                                <button type=\"button\" class=\"btn btn-flat btn-fixed\" uib-dropdown-toggle>\n                                    <span class=\"dropdown-label\">{{ (taskRecoverOps | filter: { \'id\': task.taskRecoverOp })[0].title }}</span>\n                                    <span class=\"caret\"></span>\n                                </button>\n                                <ul uib-dropdown-menu>\n                                    <li ng-repeat=\"option in taskRecoverOps\"\n                                        ng-class=\"{active: option.id === task.taskRecoverOp}\">\n                                        <a ng-click=\"task.taskRecoverOp = option.id;saveTask(task);\">\n                                           {{option.title}}\n                                        </a>\n                                    </li>\n                                </ul>\n                            </span>\n                            <div ng-if=\"task.taskRecoverOp === \'Run script\'\">\n                                <div inline-jython-editor placeholder=\"Jython\" model=\"task.failureHandler\"\n                                     on-change=\"saveTask(task)\" class=\"task-failure-handler ui-front\">\n                                    <span display-variables=\"task.failureHandler\" variables=\"release.variables\" keep-new-lines></span>\n                                </div>\n                                <span class=\"text placeholder light-text\">Note: If you do not handle task failure within the script, the task will be failed</span>\n                            </div>\n                        </div>\n                        <div class=\"failure-handler-container\" ng-if=\"!canEditFailureHandler() || isTaskFailureHandlerInProgress(task)\">\n                            <div class=\"bold\">If the task fails</div>\n                            <span>{{task.taskRecoverOp}}</span>\n                            <pre ng-if=\"task.taskRecoverOp === \'Run script\'\" display-variables=\"task.failureHandler\" variables=\"release.variables\"\n                                 keep-new-lines></pre>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <hr ng-if=\"task.failureHandlerEnabled\">\n\n            <div class=\"facets\">\n                <div class=\"form-horizontal precondition properties form-group mbn\" data-test=\"facets\">\n                    <span class=\"form-group-toggle\" ng-click=\"toggleFacetsState(task)\">\n                        <span ng-if=\"areFacetsCollapsed(task)\" class=\"xl-icon arrow-right-icon facet-title-collasicpsed\"></span>\n                        <span ng-if=\"!areFacetsCollapsed(task)\" class=\"xl-icon arrow-down-icon facet-title-expanded\"></span>\n                        <h4 class=\"inline-label\">\n                            Attributes\n                        </h4>\n                    </span>\n                    <div>\n                        <div ng-if=\"!areFacetsCollapsed(task)\">\n                            <facet-list-container task=\"task\" readonly=\"!canEditFacet()\"\n                                                  variables=\"allVariables\"\n                                                  resolved-variables=\"release.variables\"\n                                                  on-new-variable=\"createRequiredVariable(task, name, variableType, createdCallback)\"\n                                                  data-test=\"facet-section\">\n                            </facet-list-container>\n                        </div>\n                    </div>\n                </div>\n\n                <hr>\n            </div>\n\n            <div class=\"comments\">\n                <span class=\"form-group-toggle\" ng-click=\"toggleCommentsState(task)\">\n                    <span ng-if=\"isCommentsCollapsed(task)\" class=\"xl-icon arrow-right-icon comments-title-collapsed\"></span>\n                    <span ng-if=\"!isCommentsCollapsed(task)\" class=\"xl-icon arrow-down-icon comments-title-expanded\"></span>\n                    <h4 class=\"inline-label\">Comments (<span ng-bind=\"comments.length\"></span>)</h4>\n                </span>\n                <div ng-show=\"comments.length > 0 && !isCommentsCollapsed(task)\" class=\"comment\" ng-repeat=\"comment in comments track by comment.id\">\n                    <strong ng-if=\"comment.author.username\" display-user=\"comment.author\" variables=\"release.variables\"></strong>\n                    <strong ng-if=\"!comment.author.username\">SYSTEM</strong>\n                    <span class=\"pull-right comment-date\">{{comment.date | date:\'mediumDate\'}} at {{comment.date | date:\'shortTime\'}}</span><br/>\n\n                    <div>\n                        <span ng-if=\"canCommentOnTask(release)\" inline-textarea-editor model=\"comment.text\" on-change=\"saveComment(comment)\" required\n                              class=\"comment-text\" markdown>\n                            <span ng-bind-html=\"comment.text | markdown\" class=\"markdown\"></span>\n                        </span>\n                        <span ng-if=\"!canCommentOnTask(release)\" style=\"word-wrap: break-word;\" ng-bind-html=\"comment.text | markdown\" class=\"markdown\"></span>\n                    </div>\n                </div>\n\n                <div data-ng-if=\"(!canCommentOnTask(release) && task.numberOfComments === 0) && !isCommentsCollapsed(task)\">\n                    There are no comments on this task\n                </div>\n                <div ng-if=\"canCommentOnTask(release) && !isCommentsCollapsed(task)\">\n                    <form class=\"addCommentForm\" name=\"addCommentForm\" ng-if=\"data.showCommentForm\">\n                        <textarea ng-model=\"data.newComment\" placeholder=\"Give feedback or place a comment ...\" autofocus rows=\"5\"\n                                  class=\"new-comment\"></textarea><br/>\n                        <button class=\"button primary save-comment\" ng-click=\"addComment(task, data.newComment)\" ng-disabled=\"data.newComment.length == 0\">OK\n                        </button>\n                        <button class=\"button cancel\" ng-click=\"data.showCommentForm = !data.showCommentForm\">Cancel</button>\n                    </form>\n                </div>\n\n                <div class=\"comment-actions\" ng-if=\"!data.showCommentForm && !isCommentsCollapsed(task)\">\n                    <button class=\"button add-comment\" ng-if=\"canCommentOnTask(release)\" ng-click=\"data.showCommentForm = !data.showCommentForm\">Add comment\n                    </button>\n                </div>\n            </div>\n\n            <hr>\n\n            <div class=\"attachments-details\">\n                <span class=\"form-group-toggle\" ng-click=\"toggleAttachmentsState(task)\">\n                    <span ng-if=\"isAttachmentsCollapsed(task)\" class=\"xl-icon arrow-right-icon attachments-title-collapsed\"></span>\n                    <span ng-if=\"!isAttachmentsCollapsed(task)\" class=\"xl-icon arrow-down-icon attachments-title-expanded\"></span>\n                    <h4 class=\"inline-label\">Attachments (<span ng-bind=\"task.attachments.length\"></span>)</h4>\n                </span>\n                <div data-ng-if=\"(task.attachments.length === 0 && !canWorkOnReadOnlyTask(release)) && !isAttachmentsCollapsed(task)\">\n                    There are no attachments on this task\n                </div>\n                <div attachments-list\n                     ng-hide=\"isAttachmentsCollapsed(task)\"\n                     attachments=\"task.attachments\"\n                     readonly=\"!canWorkOnReadOnlyTask(release)\"\n                     upload-url=\"\'upload/attachment/\' + task.id\"\n                     can-delete-attachments=\"!isTaskInProgress(task) && !isLocked()\"\n                     delete-attachment=\"deleteAttachment(release, task, attachment)\"\n                     dismiss=\"dismiss()\"></div>\n            </div>\n            <div>&nbsp;</div>\n        </div>\n        <div class=\"pull-right right-detail\">\n            <ng-include src=\"\'partials/tasks/task-labels.html\'\"></ng-include>\n\n            <div class=\"flags\">\n                <div ng-if=\"canEditTask(release)\">\n                    <div class=\"xl-icon risk-flag-icon dropdown-button {{ task.flag.status | lowercase }}\" bs-popover data-content-template=\"partials/flags/flag-picker.html\"\n                         data-placement=\"bottom\" auto-close=\"true\"></div>\n                    <div class=\"flag-comment\" inline-text-editor model=\"task.flag.comment\" placeholder=\"Set status text\" on-change=\"saveTask(task)\">\n                        {{task.flag.comment}}\n                    </div>\n                </div>\n                <div ng-if=\"!canEditTask(release)\" class=\"readonly\">\n                    <div class=\"flags\">\n                        <div class=\"xl-icon risk-flag-icon {{ task.flag.status | lowercase }}\"></div>\n                        <div class=\"flag-comment\">{{task.flag.comment}}</div>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"scheduled-start-date\" ng-if=\"isPlannedOrPending(task)\"\n                 modal-date-editor\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 date-model=\"task.scheduledStartDate\"\n                 on-change=\"planning.updateScheduledStartDate(task)\"\n                 readonly=\"!canEditAndIsUnlocked()\"\n                 date-title=\"Scheduled start date\">\n            </div>\n            <label ng-class=\"{\'disabled\': isTaskPending(task) || isLocked() || isUnknownTask()}\" for=\"wait-for-scheduled-start-date\"\n                   ng-if=\"isPlannedOrPending(task) && task.scheduledStartDate\">\n                <input type=\"checkbox\" id=\"wait-for-scheduled-start-date\" ng-model=\"task.waitForScheduledStartDate\" ng-change=\"saveTask(task)\"\n                       ng-disabled=\"isTaskPending(task) || isLocked() || isUnknownTask()\"/> Wait for start date\n            </label>\n            <div class=\"start-date\" ng-if=\"!isPlannedOrPending(task)\"\n                 modal-date-editor\n                 date-model=\"task.startDate\"\n                 inferred-date=\"planning.planElement.displayStartDate\"\n                 readonly=\"\'true\'\"\n                 date-title=\"Start date\">\n            </div>\n            <div ng-if=\"isPlannedOrPending(task)\"\n                 ng-class=\"{\'disabled\': isLocked() || !(canDelayTask(task) && canEditBlackout(release, task) && !isTaskPostponedDueToBlackout(task))}\">\n                <label for=\"delay-during-blackout\">\n                    <input type=\"checkbox\"\n                           ng-disabled=\"isLocked() || !(canDelayTask(task) && canEditBlackout(release, task) && !isTaskPostponedDueToBlackout(task))\"\n                           id=\"delay-during-blackout\" ng-model=\"task.delayDuringBlackout\" ng-change=\"saveTask(task)\"/> Postpone during blackout\n                </label>\n            </div>\n            <div\n                 ng-class=\"{\'disabled\': isLocked() || isUnknownTask() || isTaskReadOnly(task) || isTaskFacetInProgress(task) || isTaskInProgress(task) || !hasDeploymentFacet(task)}\">\n                <label for=\"check-environment\">\n                    <input type=\"checkbox\"\n                           ng-disabled=\"isLocked() || isUnknownTask() || isTaskReadOnly(task) || isTaskFacetInProgress(task) || isTaskInProgress(task) || !hasDeploymentFacet(task)\"\n                           id=\"check-environment\" ng-model=\"task.checkAttributes\" ng-change=\"saveTask(task)\"/>\n                    <span tooltip=\"getEnvironmentAvailabilityTooltip(task)\" tooltip-position=\"bottom\"> Check environment availability <span style=\"vertical-align: -3px\" doc-icon=\"environment-availability.html\"></span></span>\n                </label>\n            </div>\n            <div class=\"blackout-info\" ng-if=\"isTaskPostponedDueToBlackout(task)\">\n                <label class=\"blackout-text\" ng-if=\"!isTaskInFinishedState(task)\"><i class=\"blackout-icon\"></i>Start date set due to blackout</label>\n                <label class=\"blackout-text\" ng-if=\"isTaskInFinishedState(task)\"><i class=\"blackout-icon\"></i>Task postponed due to blackout</label>\n                <label class=\"blackout-text\" ng-if=\"getOriginalScheduledStartDate(task) != null\">Original scheduled start date was: <br/> <span\n                        class=\"original-date\">{{getOriginalScheduledStartDate(task) | mediumDateShortTime}}</span></label>\n            </div>\n\n            <div class=\"due-date\" ng-if=\"!isTaskReadOnly(task)\"\n                 modal-date-editor\n                 date-model=\"task.dueDate\"\n                 on-change=\"planning.updateDueDate(task)\"\n                 readonly=\"!canEditAndIsUnlocked()\"\n                 date-title=\"Due date\"\n                 inferred-date=\"planning.planElement.displayEndDate\">\n            </div>\n            <div class=\"end-date\" ng-if=\"isTaskReadOnly(task)\"\n                 modal-date-editor\n                 date-model=\"task.endDate\"\n                 inferred-date=\"planning.planElement.displayEndDate\"\n                 date-title=\"End date\"\n                 readonly=\"\'true\'\">\n            </div>\n\n            <div class=\"modal-section\">\n                Duration\n            </div>\n            <div duration-editor\n                 duration=\"task.plannedDuration\"\n                 inferred-duration=\"planning.planElement.displayDuration\"\n                 on-change=\"planning.updateDuration(task)\"\n                 editable=\"canEditAndIsUnlocked()\"\n                 done=\"task.done\">\n            </div>\n\n            <div class=\"assignee\">\n                <div ng-click=\"assignToMe(task)\" ng-if=\"canClaimTask(task, release)\" class=\"pull-right light-text link assign-to-me\">\n                    Assign to me\n                </div>\n                <div class=\"modal-section\">Assigned to</div>\n                <div ng-show=\"!isLocked() && security.hasReassignTaskPermission(release) && !isTaskReadOnly(task)\">\n                    <div ng-show=\"task.owner\" class=\"pull-right remove-owner\" ng-click=\"removeOwner()\" title=\"Remove assignee\"><i class=\'xl-icon close-icon\'></i></div>\n                    <i class=\"pull-left xl-icon user-icon\"></i>\n                    <div inline-user-editor placeholder=\"assign\" model=\"task.owner\" on-change=\"updateOwner(task);\" class=\"task-owner\"\n                         autocomplete-data=\"allUsers\" autocomplete-classes=\"task-assignee-autocomplete\">\n                        <span display-user=\"task.owner\" variables=\"release.variables\"></span>\n                    </div>\n\n                    <div ng-show=\"task.team\" class=\"pull-right remove-team\" ng-click=\"removeTeam()\"><i class=\'xl-icon close-icon\'></i></div>\n                    <i class=\"pull-left xl-icon users-icon\"></i>\n                    <div inline-select-editor select-options=\"teams\" placeholder=\"assign\" model=\"task.team\" on-change=\"updateTeam(task);\" class=\"task-team\">\n                        {{task.team}}\n                    </div>\n                </div>\n                <div ng-hide=\"!isLocked() && security.hasReassignTaskPermission(release) && !isTaskReadOnly(task)\">\n                    <i class=\"pull-left xl-icon user-icon\" ng-show=\"task.owner\"></i>\n                    <div class=\"task-owner\" ng-show=\"task.owner\">\n                        <div class=\"readonly\" display-user=\"task.owner\" variables=\"release.variables\"></div>\n                    </div>\n                    <div ng-show=\"task.team\">\n                        <div class=\"pull-left xl-icon users-icon\"></div>\n                        <div class=\"task-team\">\n                            <div class=\"readonly\">\n                                {{task.team}}\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <div class=\"watchers\">\n                <header class=\"watchers-header\">\n                    <div ng-show=\"!isLocked() && !isTaskReadOnly(task) && !isUserWatchingTask()\"\n                         class=\"pull-right light-text link assign-me-as-watcher\"\n                         ng-click=\"addMeAsWatcher(task)\">\n                        Add me\n                    </div>\n                    <div>\n                        <span class=\"modal-section\">Watchers</span>\n                        <i class=\"xl-icon help-icon\" uib-tooltip=\"{{watchersTooltip.text}}\"\n                           tooltip-placement=\"{{watchersTooltip.placement}}\" style=\"vertical-align: -3.0px;\"></i>\n                    </div>\n                </header>\n                <ul class=\"watchers-list\" ng-show=\"watchers && watchers.length > 0\">\n                    <li ng-repeat=\"watcher in watchers track by watcher.username\">\n                        <i class=\"add-watcher-icon xl-icon watcher-icon\"></i>\n                        <span display-user=\"watcher\" variables=\"release.variables\"></span>\n                        <i ng-if=\"!isLocked() && !isTaskReadOnly(task) && canRemoveWatcher(release, watcher)\"\n                           ng-click=\"removeWatcher(task, watcher)\"\n                           class=\"xl-icon close-icon pull-right\"\n                           title=\"Remove watcher\"></i>\n                    </li>\n                </ul>\n                <footer data-ng-if=\"canEditAndIsUnlocked()\">\n                    <i class=\"add-watcher-icon xl-icon watcher-icon\"></i>\n                    <div inline-user-editor placeholder=\"add user\" autocomplete-data=\"nonWatchingUsers\" model=\"watcherContainer.watcher\"\n                         on-change=\"handleWatcherChange(task, watcherContainer.watcher)\"\n                         class=\"add-watcher-input\"\n                         autocomplete-classes=\"task-assignee-autocomplete\">\n                        <span display-user=\"watcherContainer.watcher\" variables=\"release.variables\"></span>\n                    </div>\n                </footer>\n            </div>\n\n            <div>\n                <div class=\"modal-section\">Tags</div>\n                <div>\n                    <div id=\"tags1\" class=\"transparent green-tags\"\n                         tags-input\n                         tags=\"task.tags\"\n                         placeholder=\"Add a tag...\"\n                         on-change=\"updateTags(tags,task)\"\n                         read-only=\"!canEditAndIsUnlocked()\">\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/partials/tasks/details/user-input-details.html","<div class=\"user-input-details\" ng-controller=\"userInputDetailsController\">\n    <div ng-show=\"!designMode\">\n        <form ng-show=\"task.variables && task.variables.length\" name=\"userInputForm\" class=\"form-horizontal\">\n            <div variables-editor\n                 variables=\"task.variables\"\n                 form=\"userInputForm\"\n                 readonly=\"!canEditVariables || release.status === \'TEMPLATE\'\"\n                 filter=\"{}\" on-change=\"updateReleaseVariable(variable)\">\n            </div>\n        </form>\n        <div ng-hide=\"task.variables && task.variables.length\">\n            <p class=\"lighter-text\">No variables have been added to this task</p>\n        </div>\n        <button class=\"button\" ng-show=\"canEditVariableList()\" ng-click=\"editVariableList();designMode = true\">\n            Edit variable list\n        </button>\n    </div>\n    <div ng-show=\"designMode && canEditVariableList()\">\n        <hr/>\n        <form name=\"userInputDesignForm\" class=\"form-horizontal\">\n            <div xl-dip-list-of-ci\n                 ng-model=\"variableList\"\n                 metadata=\"{name: \'userInputVariables\', label: \'Variables in this task\'}\"\n                 obj-label=\"displayName\"\n                 handlers=\"variableListHandler\"\n                 open-on-click=\"true\"\n                 empty-placeholder=\"Please select a variable\">\n            </div>\n            <div class=\"task-actions\">\n                <button class=\"button primary save\" ng-click=\"saveVariableList();designMode = false;\">Save</button>\n                <button class=\"button cancel\" ng-click=\"designMode = false;\">Cancel</button>\n            </div>\n        </form>\n        <div class=\"help\" style=\"margin-top: 15px;\">\n            Go to the <a ng-href=\"#/releases/{{release.id}}/variables\" ng-click=\"saveVariableList()\">Variables</a> section to see an overview of all variables\n            in the release.\n        </div>\n    </div>\n</div>");
$templateCache.put("static/9.0.2/partials/tasks/details/component/facet-form-component.html","<form name=\"facetForm\" class=\"form-horizontal facet-form\" novalidate autocomplete=\"off\">\n    <div class=\"form-content\">\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"facet-type\">\n                Type\n            </label>\n            <div class=\"col-sm-8\">\n                <xlr-dropdown id=\"facet-type\"\n                              ng-model=\"$ctrl.selectedType\"\n                              on-change=\"$ctrl.onFacetTypeChange()\"\n                              options=\"$ctrl.facetTypeNames\"\n                              placeholder=\"\'Select a type...\'\"\n                              readonly=\"!!$ctrl.readonly\"\n                ></xlr-dropdown>\n                <span class=\"description ng-scope\">Type of attribute</span>\n            </div>\n        </div>\n        <div ng-include src=\"$ctrl.facetTemplateUrl\"></div>\n    </div>\n    <div id=\"facet-form-buttons\">\n        <button type=\"button\" ng-if=\"!$ctrl.readonly\" ng-disabled=\"!$ctrl.selectedType || facetForm.$invalid\" class=\"button primary\" ng-click=\"$ctrl.onFormSubmit()\">OK</button>\n        <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.onCancel()\">Cancel</button>\n    </div>\n</form>\n");
$templateCache.put("static/9.0.2/partials/tasks/details/component/gate-dependency-context-menu.html","<div id=\"context-menu-container\">\n    <ul class=\"dropdown-menu\">\n        <li>\n            <a id=\"editDependency\" ng-if=\"canEditDependency(dependency)\" ng-click=\"editDependency(dependency)\">\n                <i title=\"Edit\" class=\"menu-item-icon xl-icon edit-icon\"></i>Edit\n            </a>\n        </li>\n        <li>\n            <a id=\"removeDependency\" ng-if=\"canDeleteDependency(dependency)\" ng-click=\"removeDependency(dependency)\">\n                <i title=\"Remove\" class=\"menu-item-icon xl-icon close-icon\"></i>Remove\n            </a>\n        </li>\n    </ul>\n</div>\n");
$templateCache.put("static/9.0.2/xlr-components/alert-component/alert-component-partial.html","<div class=\"xlr-alert-{{$ctrl.alertType}}\">\n    <div class=\"icon\">\n        <i class=\"xl-icon {{$ctrl.alertIconsClasses[$ctrl.alertType]}} icon-l\"></i>\n    </div>\n    <div class=\"message\">\n        <ng-transclude></ng-transclude>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/xlr-components/ci-control-component/ci-control-component-partial.html","<div class=\"form-group ci-control-component\"\n     data-ng-if=\"!$ctrl.ciTypeDescriptor.hidden\">\n    <label class=\"col-sm-4 col-lg-3 control-label\">{{ $ctrl.ciTypeDescriptor.label }} <span\n            data-ng-if=\"$ctrl.ciTypeDescriptor.required\" id=\"{{ $ctrl.ciTypeDescriptor.label }}-required\" class=\"error\">*</span></label>\n\n    <div class=\"col-sm-8 col-lg-9\">\n        <div data-ng-if=\"$ctrl.autocompleteCandidates.length <= 3 && $ctrl.useRadioButtons\">\n            <label class=\"radio-inline\"\n                   data-ng-repeat=\"candidate in $ctrl.autocompleteCandidates\">\n                {{ candidate.label }}\n                <input\n                        type=\"radio\"\n                        name=\"{{$ctrl.ciTypeDescriptor.label}}\"\n                        data-ng-change=\"$ctrl.onRadioButtonChange()\"\n                        data-ng-value=\"candidate\"\n                        data-ng-disabled=\"$ctrl.readonly\"\n                        data-ng-required=\"$ctrl.ciTypeDescriptor.required\"\n                        data-ng-model=\"$ctrl.selectedTypeDescriptor\">\n            </label>\n        </div>\n\n        <div data-ng-if=\"$ctrl.autocompleteCandidates.length > 3 || !$ctrl.useRadioButtons\">\n            <span uib-dropdown class=\"dropdown-selector descriptor-dropdown\">\n                <button id=\"{{ $ctrl.ciTypeDescriptor.label }}\" type=\"button\" class=\"btn btn-flat btn-fixed\"\n                        uib-dropdown-toggle ng-disabled=\"$ctrl.readonly || !$ctrl.autocompleteCandidates.length\">\n                    <span class=\"dropdown-label\">{{$ctrl.descriptorDropdownLabel}}</span>\n                    <span class=\"caret\"></span>\n                </button>\n                <ul uib-dropdown-menu>\n                    <li ng-repeat=\"descriptor in $ctrl.autocompleteCandidates\"\n                        ng-class=\"{active: descriptor.type === $ctrl.selectedTypeDescriptor.type}\">\n                        <a ng-click=\"$ctrl.selectedTypeDescriptor = descriptor; $ctrl.onSelect($ctrl.selectedTypeDescriptor)\">\n                           {{descriptor.label}}\n                        </a>\n                    </li>\n                </ul>\n            </span>\n        </div>\n\n        <div ng-if=\"!$ctrl.readonly\">\n            <div class=\"description\"\n                 ng-if=\"$ctrl.ciTypeDescriptor.label != $ctrl.ciTypeDescriptor.description && !$ctrl.isError($ctrl.formCtrl[$ctrl.ciTypeDescriptor.label])\">{{\n                ::$ctrl.ciTypeDescriptor.description }}\n            </div>\n            <div class=\"description\"\n                 ng-if=\"$ctrl.showDescriptionForSelectedTypeDescriptor && $ctrl.selectedTypeDescriptor.label != $ctrl.selectedTypeDescriptor.description &&\n             !$ctrl.isError($ctrl.formCtrl[$ctrl.ciTypeDescriptor.label])\">{{ $ctrl.selectedTypeDescriptor.description }}\n            </div>\n            <div class=\"description\"\n                 ng-if=\"!$ctrl.autocompleteCandidates.length\">\n                {{ $ctrl.defaultDescriptionLabel }}\n            </div>\n            <div class=\"field-errors\" ng-if=\"$ctrl.isError($ctrl.formCtrl[$ctrl.ciTypeDescriptor.label])\">\n                <span ng-if=\"$ctrl.formCtrl[$ctrl.ciTypeDescriptor.label].$error.required\">{{ ::$ctrl.ciTypeDescriptor.label }} is mandatory</span>\n            </div>\n        </div>\n    </div>\n</div>\n\n<div data-ng-repeat=\"property in $ctrl.properties\" data-ng-hide=\"$ctrl.ciTypeDescriptor.hidden\">\n    <div data-ng-if=\"property.kind !== \'CI\'\"\n         dip-control\n         container=\"$ctrl.configurationItem\"\n         readonly=\"$ctrl.readonly\"\n         property=\"property\"></div>\n\n    <div data-ng-if=\"$ctrl.doesNotHaveRenderer(property)\">\n        <dip-ci-control data-ng-if=\"property.kind === \'CI\' && !property.asContainment\"\n                        ci-type-descriptor=\"property\"\n                        configuration-item=\"$ctrl.configurationItem[property.name]\"\n                        reinitialize-form-trigger=\"$ctrl.reinitializeFormTrigger\"\n                        ignored-categories=\"$ctrl.ignoredCategories\"\n                        included-categories=\"$ctrl.includedCategories\"\n                        readonly=\"$ctrl.readonly\">\n        </dip-ci-control>\n    </div>\n\n    <div data-ng-if=\"!$ctrl.doesNotHaveRenderer(property)\">\n        <div ng-switch=\"$ctrl.getRenderer(property)\">\n            <dip-ci-control ng-switch-when=\"dip-ci-control\"\n                            ci-type-descriptor=\"property\"\n                            configuration-item=\"$ctrl.configurationItem[property.name]\"\n                            reinitialize-form-trigger=\"$ctrl.reinitializeFormTrigger\"\n                            ignored-categories=\"$ctrl.ignoredCategories\"\n                            included-categories=\"$ctrl.includedCategories\"\n                            readonly=\"$ctrl.readonly\">\n            </dip-ci-control>\n\n            <div ng-switch-when=\"dip-control\"\n                 dip-control\n                 use-short-id=\"false\"\n                 container=\"$ctrl.configurationItem\"\n                 readonly=\"$ctrl.readonly\"\n                 property=\"property\"></div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/xlr-components/dependency-selector/dependency-selector-partial.html","<div class=\"dependency-selector form-horizontal\">\n    <div class=\"col-xs-offset-2 loading-indicator placeholder\" ng-if=\"$ctrl.showLoadingIndicator\">\n        <img src=\"static/9.0.2/styles/img/ajax-loader.gif\" alt=\"Loading...\"/> Loading...\n    </div>\n    <div class=\"col-xs-offset-2 non-accessible-warning\" ng-if=\"!$ctrl.accessible\">\n        <span class=\"xl-icon warning-icon\"></span>\n        <ng-switch on=\"$ctrl.model.archived\">\n            <span ng-switch-when=\"false\">You do not have permission to view this release</span>\n            <span ng-switch-when=\"true\">This dependency has been archived</span>\n        </ng-switch>\n    </div>\n    <div class=\"form-group\">\n        <label for=\"release-dependency\" class=\"col-xs-2 control-label\">Release</label>\n        <div id=\"release-dependency\" class=\"col-xs-10\">\n            <div xl-widget-autocomplete\n                 is-disabled=\"!$ctrl.accessible || $ctrl.fetchingData\"\n                 ng-model=\"$ctrl.selectedRelease\"\n                 metadata=\"{name: \'release\'}\"\n                 obj-label=\"title\"\n                 show-all-on-click=\"false\"\n                 open-on-click=\"true\"\n                 handlers=\"$ctrl.releaseListHandlers\">\n            </div>\n        </div>\n    </div>\n    <div class=\"form-group\">\n        <label for=\"phase-dependency\" class=\"col-xs-2 control-label\">Phase</label>\n        <div id=\"phase-dependency\" class=\"col-xs-10\">\n            <div xl-widget-autocomplete\n                 is-disabled=\"!$ctrl.accessible || $ctrl.fetchingData\"\n                 ng-model=\"$ctrl.selectedPhase\"\n                 metadata=\"{name: \'phase\'}\"\n                 obj-label=\"title\"\n                 show-all-on-click=\"true\"\n                 open-on-click=\"true\"\n                 handlers=\"$ctrl.phaseListHandlers\">\n            </div>\n        </div>\n    </div>\n    <div class=\"form-group\">\n        <label for=\"task-dependency\" class=\"col-xs-2 control-label\">Task</label>\n        <div id=\"task-dependency\" class=\"col-xs-10\">\n            <div xl-widget-autocomplete\n                 is-disabled=\"!$ctrl.accessible || $ctrl.fetchingData\"\n                 ng-model=\"$ctrl.selectedTask\"\n                 metadata=\"{name: \'task\'}\"\n                 obj-label=\"title\"\n                 show-all-on-click=\"true\"\n                 open-on-click=\"true\"\n                 handlers=\"$ctrl.taskListHandlers\">\n            </div>\n        </div>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/xlr-components/flag-picker-component/flag-picker-popover-partial.html","<div class=\"flag-picker-popover\">\n    <div class=\"ok\" ng-click=\"$ctrl.onUpdate({flag: \'OK\'})\" hide-popover-on-click title=\"Remove status flag\"><i class=\"xl-icon flag-none-icon icon-l\"/></div>\n    <div class=\"attention_needed\" ng-click=\"$ctrl.onUpdate({flag: \'ATTENTION_NEEDED\'})\" hide-popover-on-click title=\"Set status to attention needed\"><i class=\"xl-icon flag-attention-icon\"/></div>\n    <div class=\"at_risk\" ng-click=\"$ctrl.onUpdate({flag: \'AT_RISK\'})\" hide-popover-on-click title=\"Set status to at risk\"><i class=\"xl-icon flag-risk-icon\"/></div>\n</div>");
$templateCache.put("static/9.0.2/xlr-components/multilevel-dropdown/multilevel-dropdown-partial.html","<div auto-close=\"outsideClick\"\n     dropdown-append-to=\"$ctrl.appendToEl\"\n     is-open=\"$ctrl.open\"\n     ng-class=\"{ \'xlr-ctx-menu-dropup\': $ctrl.dropup }\"\n     on-toggle=\"$ctrl.onToggle(open)\"\n     uib-dropdown>\n    <button class=\"btn btn-flat xlr-ctx-menu-toggle\"\n            ng-click=\"$ctrl.onToggleClick()\"\n            title=\"{{ $ctrl.selectedItem }}\"\n            type=\"button\"\n            uib-dropdown-toggle>\n        <!-- FF trick: to put a caret before text -->\n        <span class=\"caret pull-right\"></span>\n        <span>{{ $ctrl.selectedItem }}</span>\n    </button>\n    <div class=\"xlr-ctx-menu-container\"\n         data-id=\"{{ $ctrl.id }}\"\n         uib-dropdown-menu\n    >\n        <ul class=\"xlr-ctx-menu\">\n            <li class=\"xlr-ctx-menu-item\"\n                data-test=\"{{ item.id }}\"\n                ng-if=\"item.type === \'common\'\"\n                ng-click=\"$ctrl.onClick({ event: $event, item })\"\n                ng-repeat-start=\"item in $ctrl.items\">\n                <a title=\"{{ item.text }}\">{{ item.text }}</a>\n            </li>\n            <li class=\"xlr-ctx-menu-item xlr-ctx-submenu\"\n                data-test=\"{{ item.id }}\"\n                ng-click=\"$ctrl.onClick({ event: $event, item })\"\n                ng-if=\"item.type === \'submenu\'\">\n                <a title=\"{{ item.text }}\">{{ item.text }}</a>\n                <xlr-multilevel-submenu\n                        content-id=\"{{ item.id }}\"\n                        is-closed=\"$ctrl.isClosed\"\n                        items=\"{{ item.items }}\"\n                        ng-if=\"$ctrl.hasSubitems(item)\"\n                        on-click=\"$ctrl.onClick($locals)\"\n                ></xlr-multilevel-submenu>\n            </li>\n            <li class=\"xlr-ctx-menu-item xlr-ctx-divider\"\n                ng-if=\"item.type === \'divider\'\"\n                ng-repeat-end>\n            </li>\n        </ul>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/xlr-components/multilevel-dropdown/multilevel-submenu-partial.html","<ul class=\"xlr-ctx-menu\">\n    <li class=\"xlr-ctx-menu-item\"\n        data-test=\"{{ item.id }}\"\n        ng-click=\"onClick({ event: $event, item })\"\n        ng-repeat=\"item in items\">\n        <a title=\"{{ item.text }}\">{{ item.text }}</a>\n        <xlr-multilevel-submenu\n                content-id=\"{{ item.id }}\"\n                items=\"{{ item.items }}\"\n                level=\"{{ +level + 1 }}\"\n                ng-if=\"item.items && item.items.length\"\n                on-click=\"onClick($locals)\"\n        ></xlr-multilevel-submenu>\n    </li>\n</ul>\n");
$templateCache.put("static/9.0.2/xlr-components/permission-table-component/permission-table-row-data-partial.html","<td ng-repeat=\"column in $ctrl.columns\">\n    <div ng-if=\"$ctrl.isString(entry[column.key])\" class=\"pull-left text-column\">\n        {{entry[column.key]}}\n        <i ng-if=\"entry.description\" class=\"xl-icon help-icon\" uib-tooltip=\"{{entry.description}}\" tooltip-placement=\"auto bottom\"></i>\n    </div>\n    <div ng-if=\"!$ctrl.isString(entry[column.key])\"\n         class=\"pull-left member-tags transparent\"\n         members-input\n         strict=\"$ctrl.strict\"\n         tag-type=\"{{column.type}}\"\n         read-only=\"$ctrl.readOnly\"\n         tags=\"entry[column.key]\"\n         on-change=\"$ctrl.updateData(tags)\"\n         placeholder=\"Add...\"\n         completion-candidates=\"column.suggestionData\">\n    </div>\n    <a class=\"action link pull-right remove-action\"\n       ng-if=\"$last && entry.removable && (!$ctrl.readOnly || $ctrl.showActions)\"\n       ng-click=\"$ctrl.onRemove({ row: entry })\"\n       title=\"Delete this team\">\n        <i class=\"xl-icon delete-icon\"></i>\n        <span>{{entry.removeTitle ? entry.removeTitle : \'Delete\'}}</span>\n    </a>\n    <a class=\"action link pull-right\"\n       ng-if=\"$last && entry.action && (!$ctrl.readOnly || $ctrl.showActions)\"\n       ng-click=\"$ctrl.onAction({ row: entry, type: entry.action.type })\">\n        <i class=\"{{entry.action.icon}}\"></i>\n        {{entry.action.title}}\n    </a>\n</td>\n");
$templateCache.put("static/9.0.2/xlr-components/release-properties-component/release-properties-partial.html","<release-properties-container id=\"release-properties\" release=\"$ctrl.release\">\n    <header id=\"new-release-header\">\n        <h4>Create new release</h4>\n        <div class=\"buttons\">\n            <span doc-icon=\"release-properties.html\"></span>\n        </div>\n    </header>\n    <content>\n        <release-properties-form release=\"$ctrl.release\"\n                                 read-only=\"!$ctrl.canEditRelease()\"\n                                 on-save=\"$ctrl.onSave(release)\"\n                                 on-cancel=\"$ctrl.onCancel()\">\n        </release-properties-form>\n    </content>\n</release-properties-container>\n");
$templateCache.put("static/9.0.2/xlr-components/release-properties-form-component/release-properties-form-partial.html","<form name=\"releasePropertiesForm\" class=\"form-horizontal release-properties-form\" confirm-leave autocomplete=\"off\">\n    <div class=\"row\">\n        <!-- Summary? -->\n        <div class=\"col-sm-7\">\n            <fieldset>\n                <!-- this should probably bind to to $ctrl.releaseForm, but the other stuff should be ported to a $ctrl.form that\'s copy of $ctrl.releaseForm -->\n                <legend ng-if=\"!$ctrl.isNewRelease()\">Properties for {{ $ctrl.release.title }}</legend>\n\n                <!-- Release title -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\" for=\"release-form-title\">\n                        {{$ctrl.isTemplate() ? \'Template name\' : \'Release name\'}} <span class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <input type=\"text\" id=\"release-form-title\"\n                               name=\"title\"\n                               class=\"input-block-level\"\n                               ng-model=\"$ctrl.releaseForm.title\"\n                               required\n                               auto-focus\n                               ng-disabled=\"$ctrl.readOnly\">\n                        <span class=\"field-errors\"\n                              ng-if=\"releasePropertiesForm.title.$dirty && releasePropertiesForm.title.$invalid\">\n                            <span ng-if=\"releasePropertiesForm.title.$error.required\">{{$ctrl.isTemplate() ? \'Template\' : \'Release\'}} name is mandatory</span>\n                        </span>\n                    </div>\n                </div>\n\n                <!-- Use template select *New Release* -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && $ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Use template</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <xl-react-widget-autocomplete class=\"template-select\"\n                                                      handlers=$ctrl.templateHandlers\n                                                      metadata=\"{ placeholder: \'No template\' }\"\n                                                      model=$ctrl.templateTitle\n                                                      obj-label=\"\'title\'\"\n                                                      ng-disabled=\"$ctrl.readOnly\"\n                                                      menu-height=\"135\"\n                                                      on-suggestion-selected=\"$ctrl.onTemplateSelected\"\n                                                      on-model-change=$ctrl.updateFormWithTemplate></xl-react-widget-autocomplete>\n                    </div>\n                </div>\n\n                <!-- Use folder id select *New Release* -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && $ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Use folder</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n\n                        <xl-react-widget-tree-select ng-if=\"$ctrl.foldersReady\"\n                                                     data=\"$ctrl.folders\"\n                                                     selected-folder-id=\"$ctrl.releaseForm.parentId\"\n                                                     on-model-change=\"$ctrl.updateSelectedFolder\"></xl-react-widget-tree-select>\n                    </div>\n                </div>\n\n                <!-- Risk Profiles -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isReleaseArchived()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">\n                        Use risk profile\n                        <span class=\"inline-doc-icon\"\n                              doc-icon=\"configure-risk-settings.html#manage-risk-profiles\"></span>\n                    </label>\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <xl-react-widget-autocomplete class=\"risk-profile-select\"\n                                                      handlers=$ctrl.riskProfileHandlers\n                                                      metadata=\"{ placeholder: \'Default risk profile\' }\"\n                                                      model=$ctrl.riskProfileTitleOfThisRelease\n                                                      obj-label=\"\'title\'\"\n                                                      menu-height=\"135\"\n                                                      ng-disabled=\"$ctrl.readOnly\"\n                                                      on-model-change=$ctrl.updateRiskProfile></xl-react-widget-autocomplete>\n                    </div>\n                </div>\n\n                <!-- Release description -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Description</label>\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"release-description\" ng-if=\"!$ctrl.readOnly && $ctrl.isNewRelease()\" inline-textarea-editor\n                              model=\"$ctrl.releaseForm.description\"\n                              placeholder=\"Set description...\" markdown>\n                            <span display-variables=\"$ctrl.releaseForm.description\"\n                                  variables=\"$ctrl.releaseForm.variables\" markdown class=\"markdown\"></span>\n                        </span>\n                        <span class=\"release-description\" ng-if=\"!$ctrl.readOnly && !$ctrl.isNewRelease()\" xlr-inline-textarea-with-variables\n                              release=\"$ctrl.releaseForm\"\n                              variables=\"$ctrl.allVariables\"\n                              model=\"$ctrl.releaseForm.description\"\n                              placeholder=\"Set description...\" markdown>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"release-description markdown\">\n                            <span display-variables=\"$ctrl.releaseForm.description\"\n                                  variables=\"$ctrl.releaseForm.variables\" markdown class=\"markdown\"></span>\n                        </span>\n                    </div>\n                </div>\n\n                <!-- Template link *Edit Release* -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && !$ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Created from template</label>\n                    <div class=\"col-sm-8 col-lg-9 fix-padding\" ng-if=\"!$ctrl.releaseForm.createdFromTemplateId\">No\n                        template\n                    </div>\n                    <div class=\"col-sm-8 col-lg-9 fix-padding\" ng-if=\"$ctrl.releaseForm.createdFromTemplateId\">\n                        <p>\n                            <a ng-if=\"$ctrl.releaseForm.createdFromTemplateTitle\" data-test=\"created-from-template\"\n                               ng-href=\"#/templates/{{$ctrl.releaseForm.createdFromTemplateId}}\">{{$ctrl.releaseForm.createdFromTemplateTitle}}</a>\n                            <span ng-if=\"!$ctrl.releaseForm.createdFromTemplateTitle\">[Template has been deleted]</span>\n                        </p>\n                    </div>\n                </div>\n\n                <!-- Risk profile link *Edit Release* -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && !$ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Risk profile</label>\n                    <div class=\"col-sm-8 col-lg-9 fix-padding\">\n                        <p>\n                            <a ng-if=\"$ctrl.riskProfileTitleOfThisRelease\" data-test=\"release-risk-profile\"\n                               ng-href=\"#/risks/riskProfile/{{$ctrl.releaseForm.syntheticProperties.riskProfile}}\">{{$ctrl.riskProfileTitleOfThisRelease}}</a>\n                            <!-- If the release was archived and the risk profile was deleted -->\n                            <span ng-if=\"!$ctrl.riskProfileTitleOfThisRelease && $ctrl.isReleaseArchived()\">\n                                [Risk profile has been deleted]\n                            </span>\n                        </p>\n                    </div>\n                </div>\n\n                <div class=\"form-group\" ng-if=\"$ctrl.releaseForm.startedFromReleaseId\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Started from release</label>\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <a class=\"started-from-release\" ng-href=\"#/releases/{{$ctrl.releaseForm.startedFromReleaseId}}\">{{$ctrl.releaseForm.startedFromReleaseTitle}}</a>\n                    </div>\n                </div>\n\n            </fieldset>\n\n            <!-- Release variables... -->\n            <div class=\"variables\"\n                 ng-if=\"!$ctrl.isTemplate() && $ctrl.isNewRelease() && ($ctrl.releaseForm.variables | filter: $ctrl.variablesFilter).length > 0\">\n                <span class=\"release-variables-legend\">Release Variables &nbsp;<span\n                        doc-icon=\"variables.html\"></span></span>\n\n                <div variables-editor\n                     variables=\"$ctrl.releaseForm.variables\"\n                     form=\"releasePropertiesForm\"\n                     readonly=\"$ctrl.readOnly\"\n                     filter=\"$ctrl.variablesFilter\">\n                </div>\n            </div>\n\n            <fieldset class=\"variables\" ng-if=\"!$ctrl.isTemplate() && !$ctrl.isNewRelease()\">\n                <legend>Release Variables &nbsp;<span doc-icon=\"variables.html\"></span></legend>\n\n                <div class=\"help\">\n                    Release variables can be set on the <a ng-href=\"#/releases/{{$ctrl.releaseForm.id}}/variables\">Variables\n                    Screen</a>.\n                </div>\n            </fieldset>\n\n            <!-- Actions... -->\n            <div class=\"form-footer\">\n                <!-- should add creation in progress logic... -->\n                <button class=\"button continue primary\" ng-click=\"$ctrl.onUpdate(releasePropertiesForm);\"\n                        ng-disabled=\"releasePropertiesForm.$invalid || !$ctrl.hasValidDates() || $ctrl.readOnly\">\n                    <span>{{$ctrl.isNewRelease() ? \'Create\' : \'Save\'}}</span>\n                </button>\n                <button ng-if=\"$ctrl.isNewRelease()\" type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.onCancel()\">\n                    Cancel\n                </button>\n                <button ng-if=\"!$ctrl.isNewRelease()\" ng-disabled=\"!releasePropertiesForm.$dirty\" type=\"button\"\n                        class=\"button\"\n                        ng-click=\"releasePropertiesForm.$setPristine(); $ctrl.resetForm()\">Reset\n                </button>\n                <div ng-if=\"$ctrl.lastUpdatedAt\" class=\"last-saved\">Last saved on {{ $ctrl.lastUpdatedAt |\n                    date: \'medium\' }}\n                </div>\n            </div>\n        </div>\n\n        <!-- Details column -->\n        <div class=\"col-sm-5\">\n            <fieldset>\n                <legend>{{$ctrl.isTemplate() ? \'Template details\' : \'Release details\'}}</legend>\n\n                <!-- Flag status -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\" for=\"releaseForm-flagComment\">Flag status</label>\n\n                    <div class=\"col-sm-8 col-lg-9 flags\">\n                        <!-- all of this should be extracted to a component -->\n                        <flag-picker ng-if=\"!$ctrl.readOnly\" flag=\"$ctrl.releaseForm.flag.status\"\n                                     on-update=\"$ctrl.onFlagUpdate(flag)\"></flag-picker>\n                        <div ng-if=\"$ctrl.readOnly\"\n                             class=\"xl-icon risk-flag-icon {{ $ctrl.releaseForm.flag.status | lowercase }}\"></div>\n                        &nbsp;\n                        <input type=\"text\" placeholder=\"Set status text...\" class=\"flag-comment\"\n                               id=\"releaseForm-flagComment\"\n                               ng-model=\"$ctrl.releaseForm.flag.comment\" ng-disabled=\"$ctrl.readOnly\"/>\n                    </div>\n                </div>\n\n                <!-- (Schedule) Start date -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">\n                        {{$ctrl.isTemplate() ? \'Scheduled start date\' : \'Start date\'}} <span\n                            ng-if=\"!$ctrl.hasValidDates()\" class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"scheduled-start-date\"\n                              ng-if=\"$ctrl.isTemplate() || !$ctrl.isReleaseStarted()\"\n                              date-editor\n                              ng-model=\"$ctrl.releaseForm.scheduledStartDate\"\n                              placeholder=\"No date\"\n                              deletable=\"false\"\n                              readonly=\"$ctrl.readOnly\"\n                              on-change=\"$ctrl.planning.updateScheduledStartDate($ctrl.releaseForm)\">\n                        </span>\n\n                        <span ng-if=\"!$ctrl.isTemplate() && $ctrl.isReleaseStarted()\"\n                              date-editor\n                              ng-model=\"$ctrl.releaseForm.startDate\"\n                              deletable=\"false\"\n                              readonly=\"\'true\'\">\n                        </span>\n                        <span class=\"scheduled-start-date-time-zone\">\n                            &nbsp;{{$ctrl.timeZone}}\n                        </span>\n                    </div>\n                </div>\n\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\"></label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <input type=\"checkbox\"\n                               class=\"pull-left mls\"\n                               ng-disabled=\"$ctrl.readOnly || $ctrl.isReleaseStarted()\"\n                               ng-model=\"$ctrl.releaseForm.autoStart\"\n                               id=\"release-form-start-on-scheduled-start-date\"/>\n                        <label class=\"pls\" for=\"release-form-start-on-scheduled-start-date\">Start automatically on selected date</label>\n                    </div>\n                </div>\n\n                <!-- Due date -->\n                <div class=\"form-group\" ng-if=\"$ctrl.isTemplate() || !$ctrl.releaseForm.endDate\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Due date</label>\n\n                    <div class=\"due-date col-sm-8 col-lg-9\"\n                         date-editor\n                         ng-model=\"$ctrl.releaseForm.dueDate\"\n                         placeholder=\"No date\"\n                         inferred-date=\"$ctrl.planning.planElement.displayEndDate\"\n                         deletable=\"$ctrl.isTemplate()\"\n                         readonly=\"$ctrl.readOnly\"\n                         on-change=\"$ctrl.planning.updateDueDate($ctrl.releaseForm)\">\n                    </div>\n                    <div class=\"col-sm-8 col-lg-9\" ng-if=\"!$ctrl.hasValidDates()\">\n                        <span class=\"error\">Start date must be before due date</span>\n                    </div>\n                </div>\n\n                <!-- End date -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate() && $ctrl.releaseForm.endDate\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">End date</label>\n\n                    <div class=\"col-sm-8 col-lg-9\" date-editor ng-model=\"$ctrl.releaseForm.endDate\" deletable=\"false\"\n                         readonly=\"$ctrl.readOnly\">\n                    </div>\n                </div>\n\n                <!-- Duration -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Duration</label>\n\n                    <div class=\"col-sm-8 col-lg-9 duration\"\n                         duration-editor\n                         duration=\"$ctrl.releaseForm.plannedDuration\"\n                         inferred-duration=\"$ctrl.planning.planElement.displayDuration\"\n                         editable=\"!$ctrl.readOnly\"\n                         on-change=\"$ctrl.planning.updateDuration($ctrl.releaseForm)\"\n                         done=\"$ctrl.releaseForm.done\">\n                    </div>\n                </div>\n\n                <hr>\n\n                <!-- Release owner -->\n                <div class=\"form-group\" ng-if=\"!$ctrl.isTemplate()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">\n                        Release Owner <span ng-if=\"releasePropertiesForm.owner.$error.required\" class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span class=\"input-block-level release-owner\" ng-if=\"!$ctrl.readOnly\"\n                              inline-user-editor model=\"$ctrl.releaseForm.owner\"\n                              autocomplete-data=\"$ctrl.allUsers\" name=\"owner\" required>\n                            <span display-user=\"$ctrl.releaseForm.owner\"></span>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"release-owner read-only\">\n                            <span display-user=\"$ctrl.releaseForm.owner\"></span>\n                        </span>\n                    </div>\n                </div>\n\n                <!-- Run automated tasks as user -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Run automated tasks as user</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span ng-if=\"!$ctrl.readOnly\"\n                              class=\"input-block-level script-username\"\n                              inline-user-editor\n                              model=\"$ctrl.releaseForm.scriptUsername\"\n                              autocomplete-data=\"$ctrl.allUsers\"\n                              placeholder=\"Set user...\">\n                            <span display-user=\"$ctrl.releaseForm.scriptUsername\"></span>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"script-username read-only\">\n                            <span display-user=\"$ctrl.releaseForm.scriptUsername\"></span>\n                        </span>\n                    </div>\n                </div>\n\n                <!-- Password -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Password</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <span ng-if=\"!$ctrl.readOnly\"\n                              class=\"input-block-level script-userpassword\"\n                              inline-password-editor\n                              model=\"$ctrl.releaseForm.scriptUserPassword\"\n                              placeholder=\"Set password...\">\n                            <span class=\"light-text\">Click here to modify the password</span>\n                        </span>\n                        <span ng-if=\"$ctrl.readOnly\" class=\"script-userpassword read-only\">\n                            <span class=\"light-text\">*****</span>\n                        </span>\n                    </div>\n                </div>\n\n                <hr>\n\n                <!-- Abort on failure -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\" for=\"release-form-abort-on-failure\">Abort on\n                        failure</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <input type=\"checkbox\" ng-disabled=\"$ctrl.readOnly\" ng-model=\"$ctrl.releaseForm.abortOnFailure\"\n                               id=\"release-form-abort-on-failure\"/>\n                    </div>\n                </div>\n\n                <!-- Tags -->\n                <div class=\"form-group\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Tags</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <div id=\"tags\"\n                             class=\"transparent orange-tags\"\n                             tags-input\n                             tags=\"$ctrl.releaseForm.tags\"\n                             placeholder=\"Add a tag...\"\n                             read-only=\"$ctrl.readOnly\"\n                             completion-candidates=\"$ctrl.allTags\">\n                        </div>\n                    </div>\n                </div>\n\n                <!-- Attachments -->\n                <div class=\"form-group attachments-list\" ng-if=\"!$ctrl.isNewRelease()\">\n                    <label class=\"col-sm-4 col-lg-3 control-label\">Attachments</label>\n\n                    <div class=\"col-sm-8 col-lg-9\">\n                        <div attachments-list\n                             attachments=\"$ctrl.releaseForm.attachments\"\n                             readonly=\"$ctrl.readOnly\"\n                             upload-url=\"$ctrl.attachmentUploadUrl\"\n                             can-delete-attachments=\"!$ctrl.readOnly\"\n                             delete-attachment=\"$ctrl.deleteAttachment(attachment)\"></div>\n                    </div>\n                </div>\n\n                <!-- Share calendar -->\n                <div ng-if=\"!$ctrl.isTemplate() && !$ctrl.isNewRelease() && $ctrl.hasValidDates\">\n                    <div class=\"form-group\">\n                        <label class=\"col-sm-4 col-lg-3 control-label\">Share calendar</label>\n\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <input type=\"checkbox\" ng-model=\"$ctrl.releaseForm.calendarPublished\"\n                                   id=\"releaseForm-calendarPublished\"\n                                   ng-disabled=\"$ctrl.readOnly\"/>\n                            <label class=\"public-link\" for=\"releaseForm-calendarPublished\">Publish link</label>\n                        </div>\n                        <div class=\"clearfix\"></div>\n                        <span ng-if=\"$ctrl.releaseForm.calendarPublished\" class=\"subscribe-link\"\n                              href=\"{{ $ctrl.calendarUrl }}\" target=\"_blank\">{{ $ctrl.calendarUrl }}</span>\n                        <div class=\"col-sm-8 col-lg-9\">\n                            <button type=\"button\" class=\"button download-ics\" ng-click=\"$ctrl.downloadCalendar()\"\n                                    ng-disabled=\"creationInProgress\">\n                                Download calendar event\n                            </button>\n                        </div>\n                    </div>\n                </div>\n\n            </fieldset>\n        </div>\n    </div>\n</form>\n");
$templateCache.put("static/9.0.2/xlr-components/template-list-component/template-list-partial.html","<div class=\"content-under-header\">\n    <div ng-show=\"vm.list.length > 0\">\n\n        <xlr-infinite-scroll-wrapper\n                on-show-more=\"vm.templatesLoader.loadNextCis()\"\n                disable-when=\"!vm.templatesLoader.hasMoreCis() || vm.templatesLoader.isLoading()\"\n                show-loader-when=\"vm.templatesLoader.isLoading()\">\n\n            <div class=\"template\" ng-repeat=\'template in vm.list\' xlr-infinite-scroll>\n                <xlr-template-row-component responsive=\"vm.responsive\"\n                                            template=\"template\"\n                                            on-move=\"vm.onChange()\"\n                                            on-delete=\"vm.onChange()\"></xlr-template-row-component>\n            </div>\n            <div class=\"template-error\" ng-if=\"vm.templatesLoader.hasError()\">\n                <i class=\"xl-icon circle-exclamation-icon icon-l\"/><span>A server error has occurred. Failed to load all templates. To retry, refresh this page.</span>\n            </div>\n\n        </xlr-infinite-scroll-wrapper>\n\n    </div>\n    <div class=\"alert notice\" ng-show=\"!vm.templatesLoader.isLoading() && !vm.list\">No templates found.</div>\n</div>\n");
$templateCache.put("static/9.0.2/xlr-components/template-properties-component/template-properties-partial.html","<release-properties-container id=\"template-properties\" release=\"$ctrl.template\">\n    <header id=\"new-release-header\">\n        <h4>Create template</h4>\n        <div class=\"buttons\">\n            <span doc-icon=\"creating-a-template.html\"></span>\n        </div>\n    </header>\n    <content>\n        <release-properties-form release=\"$ctrl.template\"\n                                 read-only=\"!$ctrl.canEditTemplate()\"\n                                 on-save=\"$ctrl.onSave(release, onSaveCallback)\"\n                                 on-cancel=\"$ctrl.onCancel()\">\n        </release-properties-form>\n    </content>\n</release-properties-container>\n");
$templateCache.put("static/9.0.2/xlr-components/template-row-component/template-row-partial.html","<div class=\"title raised-link-wrapper\" ng-class=\"{ \'center\': !vm.isInsideFolder(), \'title-in-folder\': vm.responsive }\">\n    <a class=\"raised-link col-xs-6\" href=\"{{vm.getTemplateEditorURL()}}\"></a>\n    <div class=\"col-xs-6\">\n      <div class=\"template-title\">\n        <i class=\"xl-icon template-icon icon-l\"></i>\n        <strong class=\"raised-link-target\">{{vm.template.title}}</strong>\n      </div>\n\n      <div ng-if=\"vm.isInsideFolder()\">\n          <folder-path ci=\"vm.template\"></folder-path>\n      </div>\n    </div>\n    <div class=\"template-actions col-xs-6\" ng-class=\"{\'center\': vm.isInsideFolder()}\">\n        <span class=\"pull-right\">\n                <span ng-show=\"vm.hasPermissionToEdit()\">\n                    <a class=\"link color-inherited\" href=\"{{vm.getTemplateEditorURL()}}\">\n                        <i title=\"Edit\" class=\"menu-item-icon xl-icon edit-icon\"></i><span class=\"action-label\">Edit</span>\n                    </a>\n                </span>\n                <span ng-show=\"vm.hasPermissionToCreate()\">\n                    <a ng-href=\"#/releases/create?fromTemplateId={{ vm.template.id }}\" class=\"link\" stop-click-propagation>\n                        <i title=\"New release\" class=\"menu-item-icon xl-icon add-icon\"></i><span class=\"action-label\">New release</span>\n                    </a>\n                </span>\n                <span ng-show=\"vm.hasPermissionToCopy()\">\n                    <span class=\"link copy\"\n                          scope-less-modal=\"\'partials/templates/copy-template-modal.html\'\"\n                          ctrl=\"vm\"\n                          stop-click-propagation>\n                        <i title=\"Copy\" class=\"menu-item-icon xl-icon duplicate-icon\"></i><span class=\"action-label\">Copy</span>\n                    </span>\n                </span>\n                <span ng-show=\"vm.hasPermissionToMove()\">\n                    <span class=\"link move\"\n                          scope-less-modal=\"\'partials/templates/move-template-modal.html\'\"\n                          ctrl=\"vm\"\n                          stop-click-propagation>\n                        <i title=\"Move\" class=\"menu-item-icon xl-icon move-folder-icon\"></i><span class=\"action-label\">Move</span>\n                    </span>\n                </span>\n                <span ng-show=\"vm.hasPermissionToDelete()\">\n                    <span class=\"link delete\"\n                          scope-less-modal=\"\'partials/templates/delete-template-modal.html\'\"\n                          ctrl=\"vm\"\n                          stop-click-propagation>\n                        <i title=\"Delete\" class=\"menu-item-icon xl-icon delete-icon\"></i><span class=\"action-label\">Delete</span>\n                    </span>\n                </span>\n                <span >\n                    <div class=\"link context-menu-button dropdown-button template-context-menu\" data-container=\"body\"\n                         bs-popover data-content-template=\"partials/releases/context-menu.html\" data-placement=\"bottom\" auto-close=\"true\">\n                        <i class=\"xl-icon options-icon\"></i>\n                    </div>\n                </span>\n            </span>\n    </div>\n</div>\n");
$templateCache.put("static/9.0.2/xlr-components/template-scm-properties-component/template-scm-properties-partial.html","<fieldset class=\"template-scm-properties-partial\"\n          data-ng-if=\"$ctrl.ciTypeDescriptor !== undefined\">\n    <legend>Automatic synchronization &nbsp;<span doc-icon=\"scm.html\"></span></legend>\n\n    <ng-form name=\"configurationItemForm\">\n        <dip-ci-control\n                ci-type-descriptor=\"$ctrl.ciTypeDescriptor\"\n                configuration-item=\"$ctrl.configurationItemForm\"\n                readonly=\"$ctrl.readonly\"\n                included-categories=\"[\'Scm\']\"\n                reinitialize-form-trigger=\"$ctrl.reinitializeFormTrigger\">\n        </dip-ci-control>\n    </ng-form>\n\n    <div class=\"container-full\" data-ng-if=\"$ctrl.isSelectedScmOption()\">\n        <button class=\"button pull-right\"\n                data-ng-click=\"$ctrl.testConnection()\"\n                data-ng-disabled=\"$ctrl.readonly || configurationItemForm.$invalid || $ctrl.isBusy\">\n            Test\n        </button>\n    </div>\n\n</fieldset>\n");}]);