import some from 'lodash/some';

const existByField = (list, field, value) => {
    return some(list, e => e[field].trim().toLowerCase() === value.trim().toLowerCase());
};

const findById = (list, id, defaultField) => {
    return list.find(e => e.id === id) || {[defaultField]: ''};
};

export const itemAlreadyDefined = (list, selectedId, field, value) => {
  return existByField(list, field, value)
      && findById(list, selectedId, field)[field].trim().toLowerCase() !== value.trim().toLowerCase();
};

export const validateMaxLength = (inputText, maxLength) => {
    return inputText && inputText.length > maxLength;
};

export const createErrorMessage = (text) => ({show: false, text, type: 'ERROR'});
