(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[4],{

/***/ 1012:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 102:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SelectModel = exports.SchedulerFilter = exports.EnvironmentReservation = exports.ReservationModel = exports.Application = exports.Environment = exports.Stage = exports.Label = undefined;

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Label = exports.Label = _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    title: _propTypes2.default.string.isRequired,
    color: _propTypes2.default.string.isRequired
});

var Stage = exports.Stage = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    title: _propTypes2.default.string
});

var Environment = exports.Environment = _propTypes2.default.shape({
    stage: Stage,
    id: _propTypes2.default.string,
    title: _propTypes2.default.string,
    description: _propTypes2.default.string,
    labels: _propTypes2.default.arrayOf(Label)
});

var Application = exports.Application = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    title: _propTypes2.default.string,
    environments: _propTypes2.default.arrayOf(Environment)
});

var ReservationModel = exports.ReservationModel = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    environment: Environment,
    applications: _propTypes2.default.arrayOf(_propTypes2.default.any),
    startDate: _propTypes2.default.any,
    endDate: _propTypes2.default.any,
    note: _propTypes2.default.string
});

var EnvironmentReservation = exports.EnvironmentReservation = _propTypes2.default.shape({
    id: _propTypes2.default.string,
    title: _propTypes2.default.string,
    description: _propTypes2.default.string,
    stage: Stage,
    labels: _propTypes2.default.arrayOf(Label),
    reservations: _propTypes2.default.arrayOf(ReservationModel)
});

var SchedulerFilter = exports.SchedulerFilter = _propTypes2.default.shape({
    environmentTitle: _propTypes2.default.string,
    from: _propTypes2.default.number.isRequired,
    to: _propTypes2.default.number.isRequired,
    applications: _propTypes2.default.arrayOf(Application),
    stages: _propTypes2.default.arrayOf(Stage),
    labels: _propTypes2.default.arrayOf(Label)
});

var SelectModel = exports.SelectModel = _propTypes2.default.shape({
    value: _propTypes2.default.string,
    label: _propTypes2.default.string
});

/***/ }),

/***/ 1029:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.store = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

var _typeof2 = __webpack_require__(81);

var _typeof3 = _interopRequireDefault(_typeof2);

var _redux = __webpack_require__(207);

var _reduxSaga = __webpack_require__(659);

var _reduxSaga2 = _interopRequireDefault(_reduxSaga);

var _xlPluginManager = __webpack_require__(364);

var _notifySaga = __webpack_require__(3797);

var _effects = __webpack_require__(80);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(combinedSaga); /* global window */


var sagaMiddleware = (0, _reduxSaga2.default)();

/* eslint-disable no-underscore-dangle,angular/typecheck-object,angular/module-getter */
var composeEnhancers = (typeof window === 'undefined' ? 'undefined' : (0, _typeof3.default)(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
    // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...
}) : _redux.compose;

function combinedSaga() {
    return _regenerator2.default.wrap(function combinedSaga$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.next = 2;
                    return (0, _effects.all)([(0, _effects.fork)(_xlPluginManager.saga), (0, _effects.fork)(_notifySaga.notificationsSaga)]);

                case 2:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this);
}

function configureStore(preloadedState) {
    var enhancer = composeEnhancers((0, _redux.applyMiddleware)(sagaMiddleware));

    var store = (0, _redux.createStore)(_xlPluginManager.reducer, preloadedState, enhancer);

    sagaMiddleware.run(combinedSaga);

    return store;
}

var store = exports.store = store || configureStore();
/* eslint-enable */

/***/ }),

/***/ 122:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = IdsFactory;
function IdsFactory() {

    var SEPARATOR = '/';

    var releaseRegex = /.*Release[^\/-]*/;

    var phaseRegex = /Phase[^\/-]*/;

    var taskRegex = /Task[^\/-].*/;

    var phaseTaskRegex = /Phase.*Task[^\/-].*/;

    var folderIdRegex = /(^|\/|\-)Folder.+?(?=(?:\/|\-|$))/gm;

    var releaseIdToFolderId = function releaseIdToFolderId(viewId) {
        if (angular.isDefined(viewId)) {
            return 'Applications/' + viewId.split("-").slice(0, -1).join(SEPARATOR);
        } else {
            return null;
        }
    };

    var toFullId = function toFullId(viewId) {
        return viewId.replace(/-/g, SEPARATOR);
    };
    var toDomainId = function toDomainId(viewId) {
        return 'Applications/' + toFullId(viewId);
    };
    var noApplications = function noApplications(id) {
        return id.replace(/^Applications\//, '');
    };
    var toInternalId = function toInternalId(viewId) {
        return noApplications(viewId).replace(/\//g, '-');
    };
    var toConfigurationId = function toConfigurationId(viewId) {
        return 'Configuration/Custom/' + toFullId(viewId);
    };
    var releaseIdFrom = function releaseIdFrom(viewId) {
        return viewId.match(releaseRegex)[0];
    };
    var phaseIdFrom = function phaseIdFrom(viewId) {
        var regexMatch = viewId.match(phaseRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var taskIdFrom = function taskIdFrom(viewId) {
        var regexMatch = viewId.match(taskRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var phaseTaskIdFrom = function phaseTaskIdFrom(viewId) {
        var regexMatch = viewId.match(phaseTaskRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var isRootGeneral = function isRootGeneral(id, separator) {
        return id.indexOf(separator) === -1;
    };
    var isRoot = function isRoot(id) {
        return isRootGeneral(id, SEPARATOR);
    };
    var getParentIdGeneral = function getParentIdGeneral(id, separator) {
        if (isRootGeneral(id, separator)) return null;
        return id.substring(0, id.lastIndexOf(separator));
    };
    var getParentId = function getParentId(id) {
        return getParentIdGeneral(id, SEPARATOR);
    };
    var getName = function getName(id) {
        return isRoot(id) ? id : id.substring(id.lastIndexOf(SEPARATOR) + 1);
    };
    var getNameByExternalId = function getNameByExternalId(id) {
        return getName(toFullId(id));
    };
    var getParentFolderIdFrom = function getParentFolderIdFrom(viewId) {
        return !isInFolder(viewId) ? null : getParentId(releaseIdFrom(toDomainId(viewId)));
    };
    var isInFolder = function isInFolder(id) {
        return id.indexOf('Folder') !== -1;
    };
    var folderDepth = function folderDepth(id) {
        return noApplications(id).split('/').length - 1;
    };
    var getInternalFolderId = function getInternalFolderId(id) {
        var regexMatch = (id || '').match(folderIdRegex);
        if (regexMatch !== null) {
            return regexMatch.map(function (id) {
                return _.trim(id, '-/');
            }).join('-');
        }
        return null;
    };
    return {
        releaseIdToFolderId: releaseIdToFolderId,
        toDomainId: toDomainId,
        toInternalId: toInternalId,
        toConfigurationId: toConfigurationId,
        releaseIdFrom: releaseIdFrom,
        phaseIdFrom: phaseIdFrom,
        taskIdFrom: taskIdFrom,
        phaseTaskIdFrom: phaseTaskIdFrom,
        getParentId: getParentId,
        getParentIdGeneral: getParentIdGeneral,
        getName: getName,
        isRoot: isRoot,
        getParentFolderIdFrom: getParentFolderIdFrom,
        isInFolder: isInFolder,
        getNameByExternalId: getNameByExternalId,
        noApplications: noApplications,
        folderDepth: folderDepth,
        getInternalFolderId: getInternalFolderId
    };
}

/***/ }),

/***/ 177:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = {
    // PRIMARY COLORS
    blue: '#0099CC',
    yellow: '#FCD866',
    green: '#08B153',
    red: '#D94C3D',
    orange: '#FD8D10',
    purple: '#991C71',

    // SECONDARY COLORS
    xldblue: '#14B0E4',
    lightblue: '#5FCBF4',
    darkblue: '#4C6C87',

    // SHADES OF GRAY
    black: '#333333',
    antracite: '#495561',
    gray: '#999999',
    lightgray: '#D5D5D5',
    background: '#F0F0F0',
    silver: '#F9F9F9',
    white: '#FFFFFF',

    // Semantic COLORS
    oddRowColor: '#FFFFFF',
    evenRowColor: '#F9F9F9',

    hoverColor: '#D9F0F8',
    selectedColor: '#BFE5F2',
    highlightColor: '#CDEFDC',

    successBackground: '#CDEFDC',
    successHover: '#F6D2CE',

    warningBackground: '#FFE8CF',
    warningHover: '#FFE2C3',

    errorBackground: '#F8DBD8',
    errorHover: '#C1EBD4'
};

/***/ }),

/***/ 181:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = getAngularService;
function getAngularService(name) {
    return angular.element(document.body).injector().get(name);
}

/***/ }),

/***/ 196:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = ReleaseStatusFactory;
function ReleaseStatusFactory() {
    return {
        isReleaseCompleted: function isReleaseCompleted(release) {
            return release && (release.status === 'COMPLETED' || release.status === 'ABORTED');
        },
        isReleaseAborted: function isReleaseAborted(release) {
            return release && release.status === 'ABORTED';
        },
        isReleasePlanned: function isReleasePlanned(release) {
            return release && release.status === 'PLANNED';
        },
        isReleaseInProgress: function isReleaseInProgress(release) {
            return release && release.status === 'IN_PROGRESS';
        },
        isReleaseFailed: function isReleaseFailed(release) {
            return release && release.status === 'FAILED';
        },
        isReleaseFailing: function isReleaseFailing(release) {
            return release && release.status === 'FAILING';
        },
        isReleasePaused: function isReleasePaused(release) {
            return release && release.status === 'PAUSED';
        },
        hasCompletedStatus: function hasCompletedStatus(release) {
            return release && release.status === 'COMPLETED';
        },
        isTemplate: function isTemplate(release) {
            return release && release.status === 'TEMPLATE';
        },
        isReleaseArchived: function isReleaseArchived(release) {
            return release && release.archived;
        }
    };
}

/***/ }),

/***/ 197:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RiskSettingsService = exports.fetchReferences = exports.copyRiskProfile = exports.deleteRiskProfile = exports.updateRiskProfile = exports.createRiskProfile = exports.fetchRiskProfile = exports.fetchRiskProfiles = exports.fetchRiskAssessors = exports.fetchRiskConfig = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _http = __webpack_require__(88);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var riskApi = 'api/v1/risks';

var fetchRiskConfig = exports.fetchRiskConfig = function fetchRiskConfig() {
    return (0, _http.httpGET)(riskApi + "/config");
};
var fetchRiskAssessors = exports.fetchRiskAssessors = function fetchRiskAssessors() {
    return (0, _http.httpGET)(riskApi + "/assessors");
};
var fetchRiskProfiles = exports.fetchRiskProfiles = function fetchRiskProfiles() {
    return (0, _http.httpGET)(riskApi + "/profiles");
};
var fetchRiskProfile = exports.fetchRiskProfile = function fetchRiskProfile(riskProfileId) {
    return (0, _http.httpGET)(riskApi + "/profiles/" + riskProfileId);
};
var createRiskProfile = exports.createRiskProfile = function createRiskProfile(riskProfile) {
    return (0, _http.httpPOST)(riskApi + "/profiles", riskProfile);
};
var updateRiskProfile = exports.updateRiskProfile = function updateRiskProfile(riskProfile) {
    return (0, _http.httpPUT)(riskApi + "/profiles/" + riskProfile.id, riskProfile);
};
var deleteRiskProfile = exports.deleteRiskProfile = function deleteRiskProfile(riskProfileId) {
    return (0, _http.httpDELETE)(riskApi + "/profiles/" + riskProfileId);
};
var copyRiskProfile = exports.copyRiskProfile = function copyRiskProfile(riskProfileId) {
    return (0, _http.httpPOST)(riskApi + "/profiles/" + riskProfileId + "/copy");
};
var fetchReferences = exports.fetchReferences = function fetchReferences(riskProfileId) {
    return (0, _http.httpGET)("risks/profiles/" + riskProfileId + "/references");
};

var RiskSettingsService = exports.RiskSettingsService = function () {
    function RiskSettingsService() {
        (0, _classCallCheck3.default)(this, RiskSettingsService);
    }

    (0, _createClass3.default)(RiskSettingsService, [{
        key: "getAll",
        value: function getAll() {
            return fetchRiskProfiles();
        }
    }]);
    return RiskSettingsService;
}();

/***/ }),

/***/ 224:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ITEMS_PER_PAGE = exports.ITEMS_PER_PAGE = 15;
var ITEMS_MAX_DEPTH = exports.ITEMS_MAX_DEPTH = 10;
var AT_RISK = exports.AT_RISK = 'at-risk';
var ATTENTION_NEEDED = exports.ATTENTION_NEEDED = 'attention-needed';
var ON_TRACK = exports.ON_TRACK = 'on-track';
var NONE = exports.NONE = 'none';
var RISK_ON_TRACK_ICON = exports.RISK_ON_TRACK_ICON = 'xl-icon circle-check-icon color-green';

var RISK_ASSESSOR_ICONS = exports.RISK_ASSESSOR_ICONS = {
    'ReleaseFlaggedAt': 'flag-risk-icon icon-l',
    'ReleaseFlaggedAttentionNeeded': 'flag-attention-icon icon-l',
    'ReleaseStatusFailed': 'flag-risk-icon icon-l',
    'ReleaseDueDate': 'pending-icon',
    'ReleaseStatusFailing': 'flag-attention-icon icon-l',
    'ReleaseStatus': 'flag-risk-icon icon-l',
    'TaskAtRisk': 'flag-risk-icon icon-l',
    'TaskWithOneFlagAtRisk': 'flag-risk-icon icon-l',
    'TaskWithTwoOrThreeFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskWithFourFiveOrSixFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskWithMoreThanSixFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskDueDate': 'pending-icon',
    'OneTaskOverDue': 'pending-icon',
    'MoreThanOneTaskOverDue': 'pending-icon',
    'TaskNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithOneFlagNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithTwoOrThreeFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithFourFiveOrSixFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithMoreThanSixFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskRetries': 'lightning-icon color-red',
    'TaskRetries2Retries': 'lightning-icon color-red',
    'TaskRetries3Retries': 'lightning-icon color-red',
    'TaskRetries4Retries': 'lightning-icon color-red',
    'TaskRetries5Retries': 'lightning-icon color-red',
    'TaskRetriesMoreThan5Retries': 'lightning-icon color-red'
};

/***/ }),

/***/ 239:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var DASHBOARD_MAX_COLUMNS = exports.DASHBOARD_MAX_COLUMNS = 8;
var DASHBOARD_DEFAULT_COLUMNS = exports.DASHBOARD_DEFAULT_COLUMNS = 6;
var DASHBOARD_PROPERTIES_SIDEBAR_NAME = exports.DASHBOARD_PROPERTIES_SIDEBAR_NAME = 'DASHBOARD_PROPERTIES_SIDEBAR_NAME';
var DASHBOARD_CREATION_SIDEBAR_NAME = exports.DASHBOARD_CREATION_SIDEBAR_NAME = 'DASHBOARD_CREATION_SIDEBAR_NAME';
var DASHBOARD_WIDGETS_SIDEBAR_NAME = exports.DASHBOARD_WIDGETS_SIDEBAR_NAME = 'DASHBOARD_WIDGETS_SIDEBAR_NAME';
var DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = exports.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = 'DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME';

var DASHBOARD_MODE = exports.DASHBOARD_MODE = {
    VIEW: 'view',
    DESIGN: 'design'
};

var DASHBOARD_LEVEL = exports.DASHBOARD_LEVEL = {
    RELEASE: 'RELEASE',
    FOLDER: 'FOLDER',
    GLOBAL: 'GLOBAL'
};

/***/ }),

/***/ 240:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.store = undefined;

var _typeof2 = __webpack_require__(81);

var _typeof3 = _interopRequireDefault(_typeof2);

var _redux = __webpack_require__(207);

var _reduxSaga = __webpack_require__(659);

var _reduxSaga2 = _interopRequireDefault(_reduxSaga);

var _sagas = __webpack_require__(2553);

var _sagas2 = _interopRequireDefault(_sagas);

var _reducers = __webpack_require__(2576);

var _reducers2 = _interopRequireDefault(_reducers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* global window */
var sagaMiddleware = (0, _reduxSaga2.default)();

/* eslint-disable no-underscore-dangle,angular/typecheck-object,angular/module-getter */
var composeEnhancers = (typeof window === 'undefined' ? 'undefined' : (0, _typeof3.default)(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
    name: 'env-manager'
    // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...
}) : _redux.compose;

function configureStore(preloadedState) {
    var enhancer = composeEnhancers((0, _redux.applyMiddleware)(sagaMiddleware));

    var store = (0, _redux.createStore)(_reducers2.default, preloadedState, enhancer);

    sagaMiddleware.run(_sagas2.default);

    return store;
}

var store = exports.store = store || configureStore();
/* eslint-enable */

/***/ }),

/***/ 243:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    SCHEDULE_SEARCH_REQUEST: 'envMgmt/SCHEDULE_SEARCH_REQUEST',
    SCHEDULE_SEARCH_SUCCESS: 'envMgmt/SCHEDULE_SEARCH_SUCCESS',
    SCHEDULE_SEARCH_FAILURE: 'envMgmt/SCHEDULE_SEARCH_FAILURE',

    SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM: 'envMgmt/SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM',

    SCHEDULE_SHOW_RESERVATION_SIDEBAR: 'envMgmt/SCHEDULE_SHOW_RESERVATION_SIDEBAR',
    SCHEDULE_INIT_HEADER_REQUEST: 'envMgmt/SCHEDULE_INIT_HEADER_REQUEST',
    SCHEDULE_INIT_HEADER_SUCCESS: 'envMgmt/SCHEDULE_INIT_HEADER_SUCCESS',

    SCHEDULE_CLEAN_STATE: 'envMgmt/SCHEDULE_CLEAN_STATE'
};

var onSearchReservations = exports.onSearchReservations = function onSearchReservations(schedulerFilter) {
    return {
        type: actionTypes.SCHEDULE_SEARCH_REQUEST,
        payload: schedulerFilter
    };
};

var openEnvironmentReservationForm = exports.openEnvironmentReservationForm = function openEnvironmentReservationForm(reservationId) {
    return {
        type: actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM,
        payload: reservationId
    };
};

var showReservationSidebar = exports.showReservationSidebar = function showReservationSidebar(isOpen) {
    return {
        type: actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
        payload: isOpen
    };
};

var initHeader = exports.initHeader = function initHeader() {
    return {
        type: actionTypes.SCHEDULE_INIT_HEADER_REQUEST
    };
};

var cleanSchedulingState = exports.cleanSchedulingState = function cleanSchedulingState() {
    return {
        type: actionTypes.SCHEDULE_CLEAN_STATE
    };
};

/***/ }),

/***/ 244:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2654);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HeaderComponent = function (_Component) {
    (0, _inherits3.default)(HeaderComponent, _Component);

    function HeaderComponent() {
        (0, _classCallCheck3.default)(this, HeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (HeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(HeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(HeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                children = _props.children,
                helpUrl = _props.helpUrl;

            return _react2.default.createElement(
                'div',
                { className: 'header', id: 'header-environment' },
                children,
                _react2.default.createElement('a', { className: 'xl-icon help-icon doc-icon', href: 'https://docs.xebialabs.com/xl-release/help/' + helpUrl, rel: 'noopener noreferrer', target: '_blank' })
            );
        }
    }]);
    return HeaderComponent;
}(_react.Component);

HeaderComponent.propTypes = {
    children: _propTypes2.default.element,
    helpUrl: _propTypes2.default.string.isRequired
};
exports.default = HeaderComponent;

/***/ }),

/***/ 2481:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(2482);
__webpack_require__(2487);
__webpack_require__(2549);
__webpack_require__(3668);
__webpack_require__(3703);
__webpack_require__(3734);
__webpack_require__(3747);
__webpack_require__(3793);
__webpack_require__(3802);
module.exports = __webpack_require__(3806);


/***/ }),

/***/ 2482:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2483);

__webpack_require__(2485);

/***/ }),

/***/ 2483:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2485:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _activityLogsController = __webpack_require__(2486);

var _activityLogsController2 = _interopRequireDefault(_activityLogsController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_activityLogsController2.default.$inject = ['$scope', '$stateParams', 'Backend', 'CurrentTimeZone', 'Page', 'Events', 'ClientSettings', 'filterSettings'];

angular.module('xlrelease.activityLogs', ['xlrelease', 'ui.router']).controller('activityLogsController', _activityLogsController2.default).config(['$stateProvider', function ($stateProvider) {
    $stateProvider.state('releaseLogs', {
        url: '/releases/:releaseId/logs',
        reloadOnSearch: false,
        templateUrl: 'static/8.6.2/include/ActivityLogs/activity-logs.html',
        controller: 'activityLogsController',
        resolve: {
            filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
                return Filters.getLogsFiltersSettings($stateParams.releaseId);
            }]
        }
    }).state('templateLogs', {
        url: '/templates/:releaseId/logs',
        reloadOnSearch: false,
        templateUrl: 'static/8.6.2/include/ActivityLogs/activity-logs.html',
        controller: 'activityLogsController',
        resolve: {
            filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
                return Filters.getLogsFiltersSettings($stateParams.releaseId);
            }]
        }
    });
}]);

/***/ }),

/***/ 2486:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ActivityLogsController = function () {
    function ActivityLogsController($scope, $stateParams, Backend, CurrentTimeZone, Page, Events, ClientSettings, filterSettings) {
        (0, _classCallCheck3.default)(this, ActivityLogsController);

        this._Backend = Backend;
        this._Page = Page;
        this._Events = Events;
        this._ClientSettings = ClientSettings;

        this._$scope = $scope;
        this._$scope.timeZone = CurrentTimeZone.timeZone;

        this._$scope.filters = filterSettings;

        this._releaseId = $stateParams.releaseId;
    }

    (0, _createClass3.default)(ActivityLogsController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loadLogs();

            this._$scope.$on(this._Events.filters.filterChanged, function (e, filters) {
                _this.loadLogs();
                _this._ClientSettings.setLogsFilters(_this._releaseId, filters);
            });

            this._Backend.get('releases/' + this._releaseId).then(function (resp) {
                var release = resp.data;
                _this._$scope.release = release;
                _this._Page.setReleaseOpened(release);
            });
        }
    }, {
        key: 'loadLogs',
        value: function loadLogs() {
            var _this2 = this;

            this._Backend.post('releases/' + this._releaseId + '/logs/search', this._$scope.filters).then(function (resp) {
                _this2._$scope.logs = resp.data;
            });
        }
    }]);
    return ActivityLogsController;
}();

exports.default = ActivityLogsController;

/***/ }),

/***/ 2487:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2488);

__webpack_require__(2489);

__webpack_require__(2490);

__webpack_require__(2491);

__webpack_require__(2492);

__webpack_require__(2493);

__webpack_require__(2494);

__webpack_require__(2495);

__webpack_require__(2496);

__webpack_require__(2502);

__webpack_require__(2504);

__webpack_require__(2505);

__webpack_require__(2506);

__webpack_require__(2507);

__webpack_require__(2508);

__webpack_require__(2510);

__webpack_require__(2511);

__webpack_require__(2513);

__webpack_require__(2515);

__webpack_require__(2516);

__webpack_require__(2518);

__webpack_require__(2522);

__webpack_require__(2526);

__webpack_require__(2528);

__webpack_require__(2530);

__webpack_require__(2534);

__webpack_require__(2542);

/***/ }),

/***/ 2488:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease.dashboard', ['gridster', 'ui.router', 'mgcrea.ngStrap']).config(['$stateProvider', '$urlMatcherFactoryProvider', function ($stateProvider, $urlMatcherFactoryProvider) {
    $urlMatcherFactoryProvider.type('DashboardId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: /Applications\/Dashboard\w+/
    });
    $urlMatcherFactoryProvider.type('TileId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: /Applications\/Dashboard\w+\/Tile\w+/
    });
    $stateProvider.state('defaultDashboard', {
        url: '/dashboards',
        template: '<xlr-dashboard-placeholder sub-menu-items="subMenuItems"></xlr-dashboard-placeholder>'
    }).state('dashboards', {
        url: '/dashboards/{dashboardId: DashboardId}?dashboardMode&{refresh:bool}',
        template: '<div xlr-dashboard></div>'
    }).state('folderDashboards', {
        url: '/folders-dashboards/{dashboardId: DashboardId}?dashboardMode&folderId&{refresh:bool}',
        template: '<div xlr-dashboard></div>'
    }).state('folderDashboardsNew', {
        url: '/folders-dashboards/new?folderId',
        template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
    }).state('globalDashboardNew', {
        url: '/dashboards/new',
        template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
    }).state('globalDashboardDetails', {
        url: '/dashboards/{tileId: TileId}/details',
        templateUrl: 'static/8.6.2/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService) {
                return XlrDashboardService.loadTile($stateParams.tileId);
            }],
            dashboardPromise: [function () {}],
            releasePromise: [function () {}]
        }
    }).state('folderDashboardDetails', {
        url: '/folders-dashboards/{tileId: TileId}/details',
        templateUrl: 'static/8.6.2/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', function ($stateParams, XlrDashboardService) {
                return XlrDashboardService.loadTile($stateParams.tileId);
            }],
            dashboardPromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
                return XlrDashboardService.loadConfiguration(Ids.getParentId($stateParams.tileId));
            }],
            releasePromise: [function () {}]
        }
    }).state('releasesDashboard', {
        url: '/releases/:releaseId/summary/:tileId/details',
        templateUrl: 'static/8.6.2/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
                return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
            }],
            dashboardPromise: [function () {}],
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
            }]
        }
    }).state('templatesDashboard', {
        url: '/templates/:releaseId/summary/:tileId/details',
        templateUrl: 'static/8.6.2/include/DashboardPage/xlr-dashboard-details-mode.html',
        controller: 'xlrelease.dashboard.XlrTileDetailsController',
        controllerAs: 'xlrTileDetailsCtrl',
        resolve: {
            tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
                return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
            }],
            dashboardPromise: [function () {}],
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
            }]
        }
    });
}]);

angular.module('xlrelease.dashboard').factory('xlrDashboardConfigProvider', function () {
    return {
        getPlaceholderProperties: function getPlaceholderProperties() {
            return {
                draggable: { enabled: false },
                resizable: { enabled: false }
            };
        },
        getConfig: function getConfig(designMode, changeCallback) {
            return {
                minSizeY: 1,
                minSizeX: 1,
                defaultSizeX: 1,
                defaultSizeY: 1,
                pushing: true,
                floating: true, // whether to automatically float items up so they stack (you can temporarily disable if you are adding unsorted items with ng-repeat)
                swapping: true, // whether or not to have items of the same size switch places instead of pushing down if they are the same size
                colWidth: 'auto',
                minRows: 1,
                rowHeight: 290,
                margins: [10, 10],
                mobileBreakPoint: 60,
                resizable: {
                    enabled: designMode,
                    handles: ['n', 'e', 's', 'w', 'ne', 'se', 'sw', 'nw'],
                    start: function start(event, $element) {
                        $element.addClass('dashboard-resizing');
                    },
                    stop: function stop(event, $element) {
                        $element.removeClass('dashboard-resizing');
                        changeCallback();
                    }
                },
                draggable: {
                    enabled: designMode,
                    handle: '.xlr-tile-drag-handle',
                    stop: function stop() {
                        return changeCallback();
                    }
                }
            };
        }
    };
});

angular.module('xlrelease').run(['MenuItemsProviderRegistry', 'Backend', '$state', function (MenuItemsProviderRegistry, Backend, $state) {
    MenuItemsProviderRegistry.addProvider('xlrelease.dashboard.provider', function () {
        return Backend.get('dashboards').then(function (resp) {
            var dashboards = resp.data.map(function (dashboard) {
                return {
                    label: dashboard.title,
                    pathSuffix: 'dashboards/' + dashboard.id,
                    permitted: true
                };
            });

            if ($state.is('globalDashboardNew')) {
                dashboards.push({
                    label: 'New dashboard',
                    pathSuffix: 'dashboards/new',
                    permitted: true
                });
            }

            return dashboards;
        });
    });
}]);

/***/ }),

/***/ 2489:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrDashboardConstants = __webpack_require__(239);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrDashboardController = function () {
    function XlrDashboardController($scope, $q, $state, $stateParams, Ids, Authenticator, ReleasesService, xlrDashboardConfigProvider, XlrDashboardService, VariablesService, XlrSidebarService, $uibModal, $rootScope, Events, Page) {
        (0, _classCallCheck3.default)(this, XlrDashboardController);

        this.Ids = Ids;
        this.$state = $state;
        this.$stateParams = $stateParams;
        this.$scope = $scope;
        this.$q = $q;
        this.XlrSidebarService = XlrSidebarService;
        this.Authenticator = Authenticator;
        this.ReleasesService = ReleasesService;
        this.XlrDashboardService = XlrDashboardService;
        this.VariablesService = VariablesService;
        this.xlrDashboardConfigProvider = xlrDashboardConfigProvider;
        this.$uibModal = $uibModal;
        this.$rootScope = $rootScope;
        this.Events = Events;
        this.Page = Page;

        this.filteredTileTypeDefs = [];
        this.showAddTileModal = false;
        this.dashboardMode = $stateParams.dashboardMode || _xlrDashboardConstants.DASHBOARD_MODE.VIEW;
        this.gridsterOpts = xlrDashboardConfigProvider.getConfig(this.isDesignMode(), this.saveDashboard.bind(this));

        this.initialized = false;

        this.sidebarOpts = {
            position: 'right',
            backdropOpacity: 0
        };

        if (this.$stateParams.releaseId) {
            this.parentId = this.$stateParams.releaseId;
            this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE;
        } else if (this.$stateParams.folderId) {
            this.parentId = this.$stateParams.folderId;
            this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER;
        } else {
            this.parentId = null;
            this.dashboardLevel = _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
        }

        if (this.isGlobalDashboard() || this.isFolderDashboard()) {
            this.initWithGlobalContext();
        } else {
            this.initWithRelease();
        }

        this.DASHBOARD_WIDGETS_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_WIDGETS_SIDEBAR_NAME;
        this.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME;
        this.DASHBOARD_PROPERTIES_SIDEBAR_NAME = _xlrDashboardConstants.DASHBOARD_PROPERTIES_SIDEBAR_NAME;
    }

    (0, _createClass3.default)(XlrDashboardController, [{
        key: 'initPlaceholders',
        value: function initPlaceholders(maxCol, maxRow) {
            this.gridsterPlaceholderOpts = (0, _extends3.default)({}, this.gridsterOpts, this.xlrDashboardConfigProvider.getPlaceholderProperties());

            var col = 0;
            var row = 0;
            var sizeX = 1;

            this.placeholders = _.fill(Array(maxCol * maxRow), {}).map(function () {
                var config = { col: col, row: row, sizeX: sizeX };

                if (col + 1 >= maxCol) {
                    col = 0;
                    row++;
                } else {
                    col++;
                }
                return config;
            });
        }
    }, {
        key: 'initWithRelease',
        value: function initWithRelease() {
            var _this = this;

            this.dashboard = {
                id: this.Ids.toDomainId(this.$stateParams.releaseId) + '/' + this.$stateParams.extensionPath,
                tiles: []
            };
            this.release = _.get(this.$scope, 'releasePageExtensionCtrl.release');
            this.canEditDashboard = this.Authenticator.hasEditPermission(this.release) && !this.ReleasesService.isReleaseArchived(this.release);
            this.canDeleteDashboard = false;

            this.$q.all([this.loadTiles(), this.loadTileTypes(), this.loadAllVariables(), this.loadAllVariableValues()]).then(function () {
                _this.initialized = true;
            });
        }
    }, {
        key: 'initWithGlobalContext',
        value: function initWithGlobalContext() {
            var _this2 = this;

            this.dashboard = {
                id: this.$stateParams.dashboardId,
                tiles: []
            };
            this.release = {};
            this.$q.all([this.loadTiles(), this.loadTileTypes(), this.loadAllVariables(), this.loadAllVariableValues()]).then(function () {
                _this2.initialized = true;
                _this2.canEditDashboard = _this2.Authenticator.hasPermission("dashboard#edit", _this2.dashboard.metadata);
                _this2.canDeleteDashboard = _this2.canEditDashboard;
            });
        }
    }, {
        key: 'loadTiles',
        value: function loadTiles() {
            var _this3 = this;

            var refresh = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

            if (refresh) {
                this.$state.go(this.$state.$current.name, { refresh: true }, { notify: false });
            }
            return this.XlrDashboardService.loadConfiguration(this.dashboard.id, refresh).then(function (response) {
                if (!_.isEmpty(response.data)) {
                    _this3.dashboard = response.data;
                    _this3.gridsterOpts = _this3.getDashboardGridsterOpts(_this3.gridsterOpts);
                    _this3.initPlaceholders(_this3.dashboard.columns, _this3.dashboard.rows);
                    if (_this3.isFolderDashboard()) {
                        _this3.Page.setDashboardOpened(_this3.dashboard);
                    }
                }
                return _this3.dashboard;
            });
        }
    }, {
        key: 'loadTileTypes',
        value: function loadTileTypes() {
            var _this4 = this;

            return this.XlrDashboardService.tileTypes(this.dashboardLevel).then(function (response) {
                _this4.tileTypes = response.data;
                _this4.tileTypeDefs = _.reduce(_this4.tileTypes, function (memo, it) {
                    it.property = _.keyBy(it.properties, 'name');
                    memo[it.type] = it;
                    return memo;
                }, {});
                _this4.filteredTileTypeDefs = _.values(_this4.tileTypeDefs);
                return _this4.tileTypeDefs;
            });
        }
    }, {
        key: 'loadAllVariables',
        value: function loadAllVariables() {
            var _this5 = this;

            return this.VariablesService.getAllVariables(this.$stateParams.releaseId, this.$stateParams.folderId).then(function (allVariables) {
                _this5.allVariables = allVariables;
                return _this5.allVariables;
            });
        }
    }, {
        key: 'loadAllVariableValues',
        value: function loadAllVariableValues() {
            var _this6 = this;

            return this.VariablesService.getAllVariableValues(this.$stateParams.releaseId, this.$stateParams.folderId).then(function (allVariableValues) {
                _this6.allVariableValues = allVariableValues;
                return _this6.allVariableValues;
            });
        }
    }, {
        key: 'modeSwitch',
        value: function modeSwitch() {
            this.dashboardMode = this.isDesignMode() ? _xlrDashboardConstants.DASHBOARD_MODE.VIEW : _xlrDashboardConstants.DASHBOARD_MODE.DESIGN;
            this.gridsterOpts = this.getDashboardGridsterOpts(this.xlrDashboardConfigProvider.getConfig(this.isDesignMode(), this.saveDashboard.bind(this)));
        }
    }, {
        key: 'getDashboardGridsterOpts',
        value: function getDashboardGridsterOpts(config) {
            return (0, _extends3.default)({}, config, {
                columns: this.dashboard.columns,
                rowHeight: 150 + 450 / this.dashboard.columns,
                rows: this.dashboard.rows,
                maxSizeY: this.dashboard.rows,
                maxSizeX: this.dashboard.columns
            });
        }
    }, {
        key: 'isDesignMode',
        value: function isDesignMode() {
            return this.dashboardMode === _xlrDashboardConstants.DASHBOARD_MODE.DESIGN;
        }
    }, {
        key: 'getVariables',
        value: function getVariables() {
            return this.isDesignMode() ? this.allVariables : this.allVariableValues;
        }
    }, {
        key: 'newTile',
        value: function newTile(tileType) {
            return {
                id: null,
                type: tileType,
                title: this.tileTypeDefs[tileType].property.title.default,
                uri: this.tileTypeDefs[tileType].property.uri.default
            };
        }
    }, {
        key: 'saveDashboard',
        value: function saveDashboard(switchMode) {
            var _this7 = this;

            var refreshTiles = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            this.XlrDashboardService.update(this.getDashboard()).then(function (response) {
                if (refreshTiles) {
                    _this7.dashboard = response.data;
                }

                if (switchMode) {
                    _this7.modeSwitch();
                }

                _this7.XlrSidebarService.closeAll();
            });
        }
    }, {
        key: 'isReleaseDashboard',
        value: function isReleaseDashboard() {
            return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE;
        }
    }, {
        key: 'isGlobalDashboard',
        value: function isGlobalDashboard() {
            return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
        }
    }, {
        key: 'isFolderDashboard',
        value: function isFolderDashboard() {
            return this.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER;
        }
    }, {
        key: 'deleteDashboard',
        value: function deleteDashboard() {
            var _this8 = this;

            this.$uibModal.open({
                animation: false,
                component: 'xlrDeleteDashboardModal',
                resolve: {
                    data: {
                        dashboard: this.getDashboard()
                    }
                }
            }).result.then(function () {
                _this8.XlrDashboardService.delete(_this8.getDashboard()).then(function () {
                    _this8.$rootScope.$emit(_this8.Events.ui.subMenuRefresh, {
                        onRefresh: function onRefresh() {
                            if (_this8.Authenticator.hasPermission('reports#view')) {
                                _this8.$state.go('reports');
                            } else {
                                _this8.$state.go('defaultDashboard');
                            }
                        }
                    });
                });
            });
        }
    }, {
        key: 'getDashboard',
        value: function getDashboard() {
            return _.omit(this.dashboard, ['metadata']);
        }
    }, {
        key: 'updateDashboard',
        value: function updateDashboard(dashboard) {
            if (!_.isEmpty(dashboard)) {
                this.dashboard = dashboard;
            }
        }
    }, {
        key: 'addTile',
        value: function addTile(tileType) {
            var _this9 = this;

            if (tileType) {
                var changedDashboard = angular.copy(this.getDashboard());
                changedDashboard.tiles.push(this.newTile(tileType));

                this.XlrDashboardService.update(changedDashboard).then(function (response) {
                    _this9.updateDashboard(response.data);
                });
            }
        }
    }, {
        key: 'removeTile',
        value: function removeTile(item) {
            var _this10 = this;

            var changedDashboard = angular.copy(this.getDashboard());
            var tileIndex = _.findIndex(this.dashboard.tiles, { id: item.id });
            changedDashboard.tiles.splice(tileIndex, 1);

            this.XlrDashboardService.update(changedDashboard).then(function (response) {
                _this10.updateDashboard(response.data);
            });
        }
    }, {
        key: 'saveTile',
        value: function saveTile(tile) {
            var _this11 = this;

            this.XlrDashboardService.saveTile(tile).then(function (response) {
                var updatedTile = response.data;
                var tileIndex = _.findIndex(_this11.dashboard.tiles, { id: updatedTile.id });

                if (tileIndex >= 0) {
                    _this11.dashboard.tiles[tileIndex] = updatedTile;
                    _this11.tile = updatedTile;
                } else {
                    // the first dashboard has tile with default IDs.
                    // Those IDs are changed to unique/fresh values the first time the Dashboard is persisted.
                    // Hence we need to fetch the persisted dashboard containing the (same) tiles but with the persisted IDs,
                    // so that on subsequent runs `tileIndex` will find the tile by ID
                    _this11.loadTiles();
                }

                _this11.XlrSidebarService.close('tileConfigureSidebar');
            });
        }
    }, {
        key: 'configureTile',
        value: function configureTile(tile) {
            this.currentTile = tile;
            this.XlrSidebarService.open(_xlrDashboardConstants.DASHBOARD_TILE_CONFIGURE_SIDEBAR_NAME);
        }
    }, {
        key: 'editDashboard',
        value: function editDashboard() {
            this.XlrSidebarService.toggle(_xlrDashboardConstants.DASHBOARD_PROPERTIES_SIDEBAR_NAME);
        }
    }, {
        key: 'toggleWidgets',
        value: function toggleWidgets() {
            this.XlrSidebarService.toggle(_xlrDashboardConstants.DASHBOARD_WIDGETS_SIDEBAR_NAME);
        }
    }]);
    return XlrDashboardController;
}();

XlrDashboardController.$inject = ['$scope', '$q', '$state', '$stateParams', 'Ids', 'Authenticator', 'ReleasesService', 'xlrDashboardConfigProvider', 'xlrelease.XlrDashboardService', 'VariablesService', 'xlrelease.XlrSidebarService', '$uibModal', '$rootScope', 'Events', 'Page'];


var XlrDashboard = function XlrDashboard() {
    return {
        transclude: true,
        templateUrl: 'static/8.6.2/include/DashboardPage/xlr-dashboard.html',
        controller: 'xlrelease.dashboard.XlrDashboardController',
        controllerAs: 'xlrDashboard'
    };
};

angular.module('xlrelease.dashboard').directive('xlrDashboard', XlrDashboard).controller('xlrelease.dashboard.XlrDashboardController', XlrDashboardController);

/***/ }),

/***/ 2490:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrDashboardService = function () {
    function XlrDashboardService(Backend) {
        (0, _classCallCheck3.default)(this, XlrDashboardService);

        this.Backend = Backend;
    }

    (0, _createClass3.default)(XlrDashboardService, [{
        key: 'loadConfiguration',
        value: function loadConfiguration(dashboardId, refresh) {
            var params = {};
            if (!!refresh) {
                params = { params: { refresh: refresh } };
            }
            return this.Backend.get('dashboards/' + dashboardId, params);
        }
    }, {
        key: 'update',
        value: function update(dashboard) {
            return this.Backend.put('dashboards/' + dashboard.id, dashboard);
        }
    }, {
        key: 'create',
        value: function create(dashboard) {
            return this.Backend.post('dashboards', dashboard);
        }
    }, {
        key: 'delete',
        value: function _delete(dashboard) {
            return this.Backend.del('dashboards/' + dashboard.id);
        }
    }, {
        key: 'tileTypes',
        value: function tileTypes(tileScope) {
            return this.Backend.get('tiles/tile-types?scope=' + tileScope);
        }
    }, {
        key: 'saveTile',
        value: function saveTile(tile) {
            return this.Backend.put('tiles/' + tile.id, tile);
        }
    }, {
        key: 'loadTile',
        value: function loadTile(tileId) {
            return this.Backend.get('tiles/' + tileId);
        }
    }, {
        key: 'list',
        value: function list(parentId, title) {
            return this.Backend.get('dashboards', { params: { parentId: parentId, title: title } }).then(function (resp) {
                return resp.data;
            });
        }
    }, {
        key: 'getDashboardTemplates',
        value: function getDashboardTemplates(tileScope) {
            return this.Backend.get('dashboards/templates?scope=' + tileScope);
        }
    }]);
    return XlrDashboardService;
}();

XlrDashboardService.$inject = ['Backend'];


angular.module('xlrelease.dashboard').service('xlrelease.XlrDashboardService', XlrDashboardService);

/***/ }),

/***/ 2491:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrSidebarService = function () {
    function XlrSidebarService(SidebarJS) {
        (0, _classCallCheck3.default)(this, XlrSidebarService);

        this.SidebarJS = SidebarJS;
    }

    (0, _createClass3.default)(XlrSidebarService, [{
        key: 'open',
        value: function open(sidebarName) {
            this.closeAll();
            this.SidebarJS.open(sidebarName);
        }
    }, {
        key: 'close',
        value: function close(sidebarName) {
            this.SidebarJS.close(sidebarName);
        }
    }, {
        key: 'closeAll',
        value: function closeAll() {
            var _this = this;

            (0, _keys2.default)(this.SidebarJS.instances).map(function (instanceName) {
                return _this.SidebarJS.close(instanceName);
            });
        }
    }, {
        key: 'toggle',
        value: function toggle(sidebarName) {
            var sidebar = this.SidebarJS.instances[sidebarName];
            if (sidebar.isVisible()) {
                this.closeAll();
            } else {
                this.open(sidebarName);
            }
        }
    }]);
    return XlrSidebarService;
}();

XlrSidebarService.$inject = ['SidebarJS'];


angular.module('xlrelease.dashboard').service('xlrelease.XlrSidebarService', XlrSidebarService);

/***/ }),

/***/ 2492:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrTileUtil = __webpack_require__(825);

var _xlrDashboardConstants = __webpack_require__(239);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrTileController = function () {
    function XlrTileController($scope, $location, Ids) {
        (0, _classCallCheck3.default)(this, XlrTileController);

        this.$scope = $scope;
        this.$location = $location;
        this.Ids = Ids;

        this.buttons = {};
        this.tile = $scope.tile;
        this.title = this.tile.title;

        this.variables = $scope.variables;

        this.detailsUrl = (0, _xlrTileUtil.tileOrDefaultUrl)(this.tile.detailsUri);
        this.templateUrl = (0, _xlrTileUtil.tileOrDefaultUrl)(this.tile.uri);

        this.hasDetailsMode = !!this.tile.detailsUri;
    }

    (0, _createClass3.default)(XlrTileController, [{
        key: 'details',
        value: function details() {
            if (this.hasDetailsMode && this.$scope.dashboardMode !== 'design') {
                if (this.$scope.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.RELEASE) {
                    var subPath = this.$scope.release.status === 'TEMPLATE' ? 'templates' : 'releases';
                    var hyphenatedReleaseId = this.$scope.release.id;
                    var domainReleaseId = this.Ids.toDomainId(hyphenatedReleaseId);

                    this.$location.path('/' + subPath + '/' + this.tile.id.replace(domainReleaseId, hyphenatedReleaseId) + '/details');
                } else if (this.$scope.dashboardLevel === _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER) {
                    this.$location.path('folders-dashboards/' + this.tile.id + '/details');
                } else {
                    this.$location.path('dashboards/' + this.tile.id + '/details');
                }
            }
        }
    }, {
        key: 'configure',
        value: function configure() {
            this.tile = angular.copy(this.$scope.tile);
            this.state = 'config';
            this.$scope.configure({ item: this.tile });
        }
    }, {
        key: 'view',
        value: function view() {
            this.state = 'view';
        }
    }, {
        key: 'remove',
        value: function remove() {
            this.$scope.remove({ item: this.tile });
            this.view();
        }
    }, {
        key: 'addButton',
        value: function addButton(btn) {
            if (!_(this.buttons).includes(btn.title)) {
                this.buttons[btn.title] = btn;
            }
        }
    }, {
        key: 'onBtnClick',
        value: function onBtnClick(btn) {
            btn.onClick();
        }
    }]);
    return XlrTileController;
}();

XlrTileController.$inject = ['$scope', '$location', 'Ids'];


var xlrTileInject = ['$timeout', 'Events', 'Window'];
var XlrTile = function XlrTile($timeout, Events, Window) {
    return {
        scope: {
            tile: '=',
            tileTypeDefinition: '=',
            release: '=',
            variables: '=',
            dashboardMode: '=',
            dashboardLevel: '=',
            remove: '&',
            configure: '&'
        },
        restrict: 'A',
        templateUrl: 'static/8.6.2/include/DashboardPage/xlr-tile.html',
        controller: 'xlrelease.dashboard.XlrTileController',
        controllerAs: 'xlrTile',
        require: ['xlrTile', '^xlrDashboard'],
        link: function link(scope, elem, attr, ctrls) {
            var vm = ctrls[0];
            scope.xlrDashboard = ctrls[1];

            vm.setTitle = function (transcludedContent) {
                elem.find('.tile-title span').replaceWith(transcludedContent);
            };

            function adjustTileDimensions(el) {
                // left here just for backwards compatibility
                var panelBody = el.find('.panel-body');
                vm.height = panelBody.innerHeight();
                vm.width = panelBody.width();
                scope.$broadcast(Events.tile.resized);
            }

            scope.$on('gridster-item-resized', function (event) {
                adjustTileDimensions(event.targetScope.gridsterItem.$element);
            });

            var resizeFn = $timeout.bind(null, adjustTileDimensions.bind(null, elem), 200);
            Window.onResize(resizeFn, scope);

            resizeFn();
        }
    };
};
XlrTile.$inject = xlrTileInject;

angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrTileController', XlrTileController).directive('xlrTile', XlrTile);

/***/ }),

/***/ 2493:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrDefaultTileController = function () {
    function XlrDefaultTileController($scope, XlrDefaultTileService) {
        (0, _classCallCheck3.default)(this, XlrDefaultTileController);

        this.XlrDefaultTileService = XlrDefaultTileService;

        this.data = null;
        this.release = $scope.release;
        if ($scope.xlrTile) {
            this.tile = $scope.xlrTile.tile; // summary mode
        } else {
            this.tile = $scope.xlrTileDetailsCtrl.tile; // details mode
        }
    }

    (0, _createClass3.default)(XlrDefaultTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.refresh();
        }
    }, {
        key: 'refresh',
        value: function refresh() {
            var _this = this;

            this.loading = true;
            // Optional query for getting data from an external backend, for example Jira or Jenkins
            this.XlrDefaultTileService.executeQuery(this.tile.id).then(function (response) {
                _this.data = response.data.data;
            }).finally(function () {
                this.loading = false;
            });
        }
    }]);
    return XlrDefaultTileController;
}();

XlrDefaultTileController.$inject = ['$scope', 'xlrelease.dashboard.XlrDefaultTileService'];

var XlrDefaultTileService = function () {
    function XlrDefaultTileService(Backend) {
        (0, _classCallCheck3.default)(this, XlrDefaultTileService);

        this.Backend = Backend;
    }

    (0, _createClass3.default)(XlrDefaultTileService, [{
        key: 'executeQuery',
        value: function executeQuery(tileId) {
            // This will trigger a Jython script (TileType.py by default) to get data from the external source.
            // The script can access input properties.
            // Query parameters can also be used here and will be available as variables in the script.
            return this.Backend.get('tiles/' + tileId + '/data');
        }
    }]);
    return XlrDefaultTileService;
}();

XlrDefaultTileService.$inject = ['Backend'];


angular.module('xlrelease.dashboard').service('xlrelease.dashboard.XlrDefaultTileService', XlrDefaultTileService).controller('xlrelease.dashboard.XlrDefaultTileController', XlrDefaultTileController);

/***/ }),

/***/ 2494:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrTileDetailsController = function () {
    function XlrTileDetailsController(tilePromise, releasePromise, dashboardPromise, Ids, Page) {
        (0, _classCallCheck3.default)(this, XlrTileDetailsController);

        this.tile = _.get(tilePromise, 'data');
        this.release = _.get(releasePromise, 'data');
        this.dashboard = _.get(dashboardPromise, 'data');
        this.Ids = Ids;

        if (this.dashboard) {
            Page.setDashboardOpened(this.dashboard);
        }
    }

    (0, _createClass3.default)(XlrTileDetailsController, [{
        key: 'getDashboardUrl',
        value: function getDashboardUrl() {
            if (this.release) {
                var base = this.release.status === 'TEMPLATE' ? 'templates' : 'releases';
                return '#/' + base + '/' + this.release.id + '/summary';
            } else if (this.dashboard && this.dashboard.parentId) {
                return '#/folders-dashboards/' + this.dashboard.id + '?folderId=' + this.dashboard.parentId;
            } else {
                return '#/dashboards/' + this.Ids.getParentId(this.tile.id);
            }
        }
    }]);
    return XlrTileDetailsController;
}();

XlrTileDetailsController.$inject = ['tilePromise', 'releasePromise', 'dashboardPromise', 'Ids', 'Page'];


angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrTileDetailsController', XlrTileDetailsController);

/***/ }),

/***/ 2495:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var XlrTileTitle = function XlrTileTitle() {
    return {
        restrict: 'A',
        require: ['^xlrTile'],
        transclude: true,
        link: function link(scope, elem, attr, ctrls, transclude) {
            _.head(ctrls).setTitle(transclude);
        }
    };
};

angular.module('xlrelease.dashboard').directive('xlrTileTitle', XlrTileTitle);

/***/ }),

/***/ 2496:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _compositeFilterComponent = __webpack_require__(2497);

var _compositeFilterService = __webpack_require__(2501);

angular.module('xlrelease').component('compositeFilter', _compositeFilterComponent.compositeFilterComponent);
angular.module('xlrelease').service('CompositeFilterService', _compositeFilterService.CompositeFilterService);

/***/ }),

/***/ 2497:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.compositeFilterComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _compositeFilter = __webpack_require__(2498);

var _compositeFilter2 = _interopRequireDefault(_compositeFilter);

__webpack_require__(2499);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CompositeFilterController = function () {
    function CompositeFilterController($element, CompositeFilterService) {
        (0, _classCallCheck3.default)(this, CompositeFilterController);

        this.$element = $element;
        this.CompositeFilterService = CompositeFilterService;
    }

    (0, _createClass3.default)(CompositeFilterController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.isLoading = true;
            this.CompositeFilterService.loadCandidates(this.availableTypes, true).then(function () {
                _this.isLoading = false;
                _this.filters = _this.getStoredFilters();
            }).catch(function () {
                return _this.isLoading = false;
            });
        }
    }, {
        key: '$onChanges',
        value: function $onChanges(changes) {
            var storedFilters = changes.storedFilters;

            if (_.get(storedFilters, 'storedFilters.currentValue.length')) {
                this.filters = this.getStoredFilters();
            }
        }
    }, {
        key: 'getFilterByType',
        value: function getFilterByType(type) {
            return this.CompositeFilterService.getFilter(type);
        }
    }, {
        key: 'isFilterTagsInput',
        value: function isFilterTagsInput(type) {
            return this.getFilterByType(type).filterTag;
        }
    }, {
        key: 'getOperators',
        value: function getOperators(type) {
            return this.getFilterByType(type).operators;
        }
    }, {
        key: 'getAutoCompleteCandidates',
        value: function getAutoCompleteCandidates(type) {
            return this.getFilterByType(type).loadedAutocompleteCandidates;
        }
    }, {
        key: 'setFocus',
        value: function setFocus() {
            this.$element.find('.filter input').focus();
        }
    }, {
        key: 'onAddFilterClick',
        value: function onAddFilterClick() {
            this.filters.push({
                type: null,
                operator: null,
                values: []
            });
        }
    }, {
        key: 'onRemoveFilterClick',
        value: function onRemoveFilterClick(index) {
            if (index !== null && angular.isDefined(index)) {
                if (index !== -1) {
                    this.filters.splice(index, 1);
                    this.triggerOnChange(this.filters.filter(function (f) {
                        return f.type && f.values && f.values.length;
                    }));
                }
            }
        }
    }, {
        key: 'onOperatorChange',
        value: function onOperatorChange() {
            this.triggerOnChange(this.filters);
        }
    }, {
        key: 'onFilterChange',
        value: function onFilterChange(tags, filter) {
            if (filter) {
                filter.values = tags;
            }
            this.triggerOnChange(this.filters.filter(function (f) {
                return f.type && f.values && f.values.length;
            }));
        }
    }, {
        key: 'triggerOnChange',
        value: function triggerOnChange(filters) {
            this.onChange({ filters: this.CompositeFilterService.convertToStored(filters) });
        }
    }, {
        key: 'onFilterTypeChange',
        value: function onFilterTypeChange(filter) {
            filter.values = [];
            filter.operator = filter.type === 'xlrelease.TagsFilter' ? 'CONTAINS_ALL' : 'OR';
        }
    }, {
        key: 'getStoredFilters',
        value: function getStoredFilters() {
            return this.CompositeFilterService.convertFromStored(this.storedFilters, this.availableTypes);
        }
    }]);
    return CompositeFilterController;
}();

CompositeFilterController.$inject = ['$element', 'CompositeFilterService'];
var compositeFilterComponent = exports.compositeFilterComponent = {
    bindings: {
        storedFilters: '<',
        availableTypes: '<',
        onChange: '&'
    },
    controller: CompositeFilterController,
    template: _compositeFilter2.default
};

/***/ }),

/***/ 2498:
/***/ (function(module, exports) {

module.exports = "<div ng-if=\"$ctrl.isLoading\" class=\"spinner\" style=\"text-align: center\">\n    <img src=\"static/8.6.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n</div>\n<div ng-if=\"!$ctrl.isLoading\" class=\"filter-container\">\n    <div ng-repeat=\"filter in $ctrl.filters\" class=\"composite-filter\">\n        <select class=\"filter-type-select\"\n                name=\"filter-type-select\"\n                ng-model=\"filter.type\"\n                ng-change=\"$ctrl.onFilterTypeChange(filter)\"\n        >\n            <option value=\"\">Select filter</option>\n            <option ng-repeat=\"availableType in $ctrl.availableTypes\" value=\"{{availableType}}\">{{$ctrl.getFilterByType(availableType).title}}</option>\n        </select>\n        <div ng-if=\"filter.type\">\n            <select ng-model=\"filter.operator\"\n                    ng-change=\"$ctrl.onOperatorChange()\"\n                    class=\"filter-operator-select\">\n                <option ng-repeat=\"operator in $ctrl.getOperators(filter.type)\" value=\"{{operator.value}}\">{{operator.title}}</option>\n            </select>\n            <div ng-if=\"$ctrl.isFilterTagsInput(filter.type)\" ng-init=\"$ctrl.setFocus()\"\n                 name=\"tags\"\n                 class=\"transparent filter\"\n                 filter-tag-input\n                 on-change=\"$ctrl.onFilterChange(tags, filter)\"\n                 tags=\"filter.values\"\n                 completion-candidates=\"$ctrl.getAutoCompleteCandidates(filter.type)\">\n            </div>\n            <div ng-if=\"!$ctrl.isFilterTagsInput(filter.type)\" ng-init=\"$ctrl.setFocus()\"\n                 name=\"tags\"\n                 class=\"transparent filter\"\n                 tags-input\n                 on-change=\"$ctrl.onFilterChange(tags, filter)\"\n                 tags=\"filter.values\"\n                 completion-candidates=\"$ctrl.getAutoCompleteCandidates(filter.type)\">\n            </div>\n        </div>\n        <button class=\"filter-remove-btn button\"\n                ng-click=\"$ctrl.onRemoveFilterClick($index)\"\n                type=\"button\"\n        ><i class=\"xl-icon delete-icon\"/></button>\n    </div>\n    <button class=\"filter-add-btn button underlined\"\n            ng-click=\"$ctrl.onAddFilterClick()\"\n            type=\"button\">\n        + Add filter\n    </button>\n</div>\n"

/***/ }),

/***/ 2499:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2501:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CompositeFilterService = undefined;

var _defineProperty2 = __webpack_require__(18);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var COMPOSITE_FILTER_TYPE = 'xlrelease.CompositeFilter';
var ENTITY_ID_PLACEHOLDER = "-1";

var CompositeFilterService = exports.CompositeFilterService = function () {
    function CompositeFilterService($q) {
        (0, _classCallCheck3.default)(this, CompositeFilterService);

        this.$q = $q;
        this.filters = {};
    }

    (0, _createClass3.default)(CompositeFilterService, [{
        key: 'registerFilter',
        value: function registerFilter(type, definition) {
            if (!definition.fromStored) {
                definition.fromStored = this.fromStoredDefault.bind(this);
            }
            if (!definition.toStored) {
                definition.toStored = this.toStoredDefault.bind(this);
            }
            this.filters[type] = definition;
        }
    }, {
        key: 'getFilter',
        value: function getFilter(type) {
            return this.filters[type];
        }
    }, {
        key: 'loadCandidates',
        value: function loadCandidates(availableTypes, forceLoad) {
            var _this = this;

            var filters = availableTypes.map(function (availableType) {
                return _this.getFilter(availableType);
            }).filter(Boolean);
            return this.$q.all(filters.map(function (f) {
                return f.autocompleteCandidates(forceLoad);
            })).then(function (results) {
                return _.forEach(results, function (result, index) {
                    return filters[index].loadedAutocompleteCandidates = result;
                });
            });
        }
    }, {
        key: 'convertFromStored',
        value: function convertFromStored(storedFilters, availableTypes) {
            var _this2 = this;

            if (storedFilters) {
                return storedFilters.reduce(function (acc, storedFilter) {
                    var definition = _this2.getFilter(storedFilter.type);
                    if (definition && availableTypes.includes(storedFilter.type)) {
                        acc.push(definition.fromStored(storedFilter, definition));
                    } else if (storedFilter.type === COMPOSITE_FILTER_TYPE) {
                        var type = storedFilter.filters[0].type;
                        acc.push({
                            type: type,
                            operator: 'OR',
                            values: storedFilter.filters.map(function (nestedFilter) {
                                var nestedDefinition = _this2.getFilter(nestedFilter.type);
                                return nestedDefinition.fromStored(nestedFilter, nestedDefinition).values[0];
                            })
                        });
                    }
                    return acc;
                }, []);
            }
            return [];
        }
    }, {
        key: 'convertToStored',
        value: function convertToStored(uiFilters) {
            var _this3 = this;

            return uiFilters.reduce(function (acc, _ref) {
                var type = _ref.type,
                    operator = _ref.operator,
                    values = _ref.values;

                var definition = _this3.getFilter(type);
                if (definition && !_.isEmpty(values)) {
                    acc.push(definition.toStored({ type: type, operator: operator, values: values }, definition));
                }
                return acc;
            }, []);
        }
    }, {
        key: 'toStoredDefault',
        value: function toStoredDefault(uiFilter, definition) {
            var mapper = function mapper(value) {
                return (0, _defineProperty3.default)({
                    id: ENTITY_ID_PLACEHOLDER,
                    type: uiFilter.type
                }, definition.property, value);
            };

            if (uiFilter.values.length === 1) {
                return mapper(uiFilter.values[0].id);
            } else {
                return {
                    id: ENTITY_ID_PLACEHOLDER,
                    type: COMPOSITE_FILTER_TYPE,
                    operator: 'OR',
                    filters: uiFilter.values.map(function (v) {
                        return mapper(v.id);
                    })
                };
            }
        }
    }, {
        key: 'fromStoredDefault',
        value: function fromStoredDefault(storedFilter, definition) {
            return {
                type: storedFilter.type,
                operator: 'OR',
                values: [{
                    id: storedFilter[definition.property],
                    title: this.getFilterTitle(definition.loadedAutocompleteCandidates, storedFilter[definition.property])
                }]
            };
        }
    }, {
        key: 'getFilterTitle',
        value: function getFilterTitle(autocompleteCandidates, id) {
            return _.chain(autocompleteCandidates).find({ id: id }).get('title').value();
        }
    }]);
    return CompositeFilterService;
}();

CompositeFilterService.$inject = ['$q'];

/***/ }),

/***/ 2502:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2504:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AddDashboard = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrDashboardConstants = __webpack_require__(239);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <a ng-if="$ctrl.canCreateNewDashboard()" class="button" href="#/dashboards/new">\n    <i class="xl-icon add-icon"></i>\n        Add dashboard\n    </a>\n';

var AddDashboardController = function () {
    function AddDashboardController(Authenticator, GlobalPermissions) {
        (0, _classCallCheck3.default)(this, AddDashboardController);

        this.Authenticator = Authenticator;
        this.GlobalPermission = GlobalPermissions;

        this.sidebarName = _xlrDashboardConstants.DASHBOARD_CREATION_SIDEBAR_NAME;
    }

    (0, _createClass3.default)(AddDashboardController, [{
        key: 'canCreateNewDashboard',
        value: function canCreateNewDashboard() {
            return this.Authenticator.hasPermission(this.GlobalPermission.CREATE_GLOBAL_DASHBOARD);
        }
    }]);
    return AddDashboardController;
}();

AddDashboardController.$inject = ['Authenticator', 'GlobalPermissions'];
var AddDashboard = exports.AddDashboard = {
    controller: AddDashboardController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrAddDashboard', AddDashboard);

/***/ }),

/***/ 2505:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.AddDashboardPage = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _xlrDashboardConstants = __webpack_require__(239);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="dashboard-create-page">\n        <div release-header>\n        </div>\n    \n        <div class="content-under-header">\n            <div class="dashboard-sidebar">\n                <div class="right-sidebar">\n                    <xlr-dashboard-templates\n                        ng-if="!$ctrl.selectedTemplateType"\n                        parent-id="$ctrl.folderId"\n                        on-select="$ctrl.onSelect(templateType)"\n                        on-cancel="$ctrl.onCancel()">\n                    </xlr-dashboard-templates>\n                    <xlr-dashboard-properties\n                        ng-if="$ctrl.selectedTemplateType"\n                        parent-id="$ctrl.folderId"\n                        template-type="$ctrl.selectedTemplateType"\n                        on-save="$ctrl.onSave(dashboard, isNew)"\n                        on-cancel="$ctrl.selectedTemplateType = null">\n                    </xlr-dashboard-properties>\n                </div>\n            </div>\n        </div>\n    </div>\n';

var AddDashboardPageController = function () {
    function AddDashboardPageController($state, $stateParams, Page) {
        (0, _classCallCheck3.default)(this, AddDashboardPageController);

        this.$state = $state;
        this.$stateParams = $stateParams;
        this.Page = Page;
    }

    (0, _createClass3.default)(AddDashboardPageController, [{
        key: '$onInit',
        value: function $onInit() {
            this.folderId = this.$stateParams.folderId;
            if (this.folderId) {
                this.Page.setDashboardOpened({ parentId: this.folderId, title: 'New dashboard' });
            }
        }
    }, {
        key: 'onSelect',
        value: function onSelect(templateType) {
            this.selectedTemplateType = templateType;
        }
    }, {
        key: 'onSave',
        value: function onSave(dashboard) {
            var state = this.folderId ? 'folderDashboards' : 'dashboards';
            this.$state.go(state, {
                dashboardId: dashboard.id,
                folderId: this.folderId,
                dashboardMode: this.selectedTemplateType && this.selectedTemplateType.type === 'xlrelease.BlankDashboard' ? _xlrDashboardConstants.DASHBOARD_MODE.DESIGN : _xlrDashboardConstants.DASHBOARD_MODE.VIEW
            }, { reload: true });
        }
    }, {
        key: 'onCancel',
        value: function onCancel() {
            this.$state.go('folders.detail.page', { folderId: this.folderId, page: 'dashboards' });
        }
    }]);
    return AddDashboardPageController;
}();

AddDashboardPageController.$inject = ['$state', '$stateParams', 'Page'];
var AddDashboardPage = exports.AddDashboardPage = {
    controller: AddDashboardPageController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrAddDashboardPage', AddDashboardPage);

/***/ }),

/***/ 2506:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var template = '\n    <div class="modal-header">\n        <h4 class="modal-title pull-left" id="modal-title">Delete dashboard</h4>\n        <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix"/>\n    </div>\n    <div class="modal-body actions-modal">      \n     <p>You are about to delete the dashboard <b>{{::$ctrl.resolve.data.dashboard.title}}</b>.</p>\n    </div>\n    <div class="modal-footer">\n        <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n        <button class="button save primary" type="submit" ng-click="$ctrl.close()">Delete</button>\n    </div>\n';

var deleteDashboardModal = exports.deleteDashboardModal = {
    bindings: {
        close: '&',
        dismiss: '&',
        resolve: '<'
    },
    template: template
};

angular.module('xlrelease.dashboard').component('xlrDeleteDashboardModal', deleteDashboardModal);

/***/ }),

/***/ 2507:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deleteDashboardModal = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="modal-content">\n    <form name="duplicateDashboardForm" id="duplicateDashboardForm" class="form-horizontal" novalidate>\n        <div class="modal-header">\n            <h4 class="modal-title pull-left" id="modal-title">Duplicate dashboard</h4>\n            <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon" /></button>\n            <div class="clearfix"/>\n        </div>\n        <div class="modal-body actions-modal">      \n            <div class="form-group">\n                <label class="col-sm-2 control-label" for="duplicateDashboard-title">New name <span ng-if="duplicateDashboardForm.$error.required" class="error">*</span></label>\n                <div class="col-sm-10">\n                    <input type="text" class="input-block-level" name="title" id="duplicateDashboard-title" \n                    ng-model="$ctrl.duplicate.title" ng-maxlength="255" required autofocus/>\n                    <span class="field-errors" ng-if="duplicateDashboardForm.title.$invalid">\n                        <span ng-if="duplicateDashboardForm.title.$error.required">Dashboard name is mandatory</span>\n                        <span ng-if="duplicateDashboardForm.title.$error.maxlength">Dashboard name is too long</span>\n                    </span>\n                </div>\n            </div>\n        </div>\n        <div class="modal-footer">\n            <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n            <button ng-disabled="duplicateDashboardForm.$invalid" class="button save primary" type="submit" ng-click="$ctrl.close({$value: $ctrl.duplicate})">Duplicate</button>\n        </div>\n    </form>\n</div>\n';

var DeleteDashboardModalcController = function () {
    function DeleteDashboardModalcController() {
        (0, _classCallCheck3.default)(this, DeleteDashboardModalcController);
    }

    (0, _createClass3.default)(DeleteDashboardModalcController, [{
        key: '$onInit',
        value: function $onInit() {
            this.duplicate = {
                title: this.resolve.data.dashboard.title + " (Copy)"
            };
        }
    }]);
    return DeleteDashboardModalcController;
}();

var deleteDashboardModal = exports.deleteDashboardModal = {
    bindings: {
        close: '&',
        dismiss: '&',
        resolve: '<'
    },
    controller: DeleteDashboardModalcController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrDuplicateDashboardModal', deleteDashboardModal);

/***/ }),

/***/ 2508:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TileDateRange = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _tileDateRangeTpl = __webpack_require__(2509);

var _tileDateRangeTpl2 = _interopRequireDefault(_tileDateRangeTpl);

var _tileDateRangeConstants = __webpack_require__(826);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SHOW_ERROR_MESSAGE_DELAY_MS = 5000;

var TileDateRangeController = function () {
    function TileDateRangeController($timeout) {
        (0, _classCallCheck3.default)(this, TileDateRangeController);

        this.timeFrameType = _tileDateRangeConstants.TIME_FRAME_TYPES;
        this.$timeout = $timeout;
    }

    (0, _createClass3.default)(TileDateRangeController, [{
        key: '$onInit',
        value: function $onInit() {
            this.descriptionLabel = this.descriptionLabel || 'Time period to display';
            this.range = (0, _extends3.default)({}, this.dateRange);
            this.range.timeFrame = this.range.timeFrame || _tileDateRangeConstants.TIME_FRAME_TYPES.LAST_SIX_MONTHS;
        }
    }, {
        key: 'onDateRangeTypeChange',
        value: function onDateRangeTypeChange() {
            if (this.range.timeFrame !== _tileDateRangeConstants.TIME_FRAME_TYPES.RANGE) {
                this.range.from = null;
                this.range.to = null;
            }
            this.setRange(this.range);
        }
    }, {
        key: 'onDateEditorChange',
        value: function onDateEditorChange(dateKey) {
            var _this = this;

            if (this.isDateRangeValid(this.range.from, this.range.to)) {
                this.setRange(this.range);
            } else {
                this.range[dateKey] = (this.dateRange || {})[dateKey];
                this.showInvalidDateRangeMessage = true;
                this.$timeout(function () {
                    return _this.showInvalidDateRangeMessage = false;
                }, SHOW_ERROR_MESSAGE_DELAY_MS);
            }
        }
    }, {
        key: 'setRange',
        value: function setRange(range) {
            this.dateRange = this.dateRange || {};
            this.dateRange.from = range.from;
            this.dateRange.to = range.to;
            this.dateRange.timeFrame = range.timeFrame;
            this.onDateRangeChange({ dateRange: range });
        }
    }, {
        key: 'isDateRangeValid',
        value: function isDateRangeValid(startDate, endDate) {
            return !(startDate && endDate && moment(startDate).isAfter(moment(endDate)));
        }
    }]);
    return TileDateRangeController;
}();

TileDateRangeController.$inject = ['$timeout'];
var TileDateRange = exports.TileDateRange = {
    bindings: {
        onDateRangeChange: '&',
        dateRange: '<',
        descriptionLabel: '@'
    },
    controller: TileDateRangeController,
    template: _tileDateRangeTpl2.default
};

angular.module('xlrelease.dashboard').component('xlrTileDateRange', TileDateRange);

/***/ }),

/***/ 2509:
/***/ (function(module, exports) {

module.exports = "<label for=\"time-period-select\" class=\"control-label col-xs-3\">Time period</label>\n<div class=\"col-xs-9\">\n    <select class=\"xlr-time-period-select\"\n            id=\"time-period-select\"\n            name=\"time-period-select\"\n            ng-model=\"$ctrl.range.timeFrame\"\n            ng-change=\"$ctrl.onDateRangeTypeChange()\">\n        <option value=\"{{$ctrl.timeFrameType.LAST_MONTH}}\">Last 30 days</option>\n        <option value=\"{{$ctrl.timeFrameType.LAST_THREE_MONTHS}}\">Last 3 months</option>\n        <option value=\"{{$ctrl.timeFrameType.LAST_SIX_MONTHS}}\">Last 6 months</option>\n        <option value=\"{{$ctrl.timeFrameType.LAST_YEAR}}\">Last year</option>\n        <option value=\"{{$ctrl.timeFrameType.RANGE}}\">Range</option>\n    </select>\n    <span class=\"description\">{{$ctrl.descriptionLabel}}</span>\n    <div ng-if=\"$ctrl.range.timeFrame === $ctrl.timeFrameType.RANGE\" class=\"date-filter\">\n        <div class=\"date-picker-container\" data-test=\"date-range-from\">\n            <label>From:</label>\n            <div date-editor\n                 data-ng-model=\"$ctrl.range.from\"\n                 on-change=\"$ctrl.onDateEditorChange('from')\"\n                 data-deletable=\"true\"\n                 class=\"date-picker\">\n            </div>\n        </div>\n        <div class=\"date-picker-container\" data-test=\"date-range-to\">\n            <label>To:</label>\n            <div date-editor\n                 data-ng-model=\"$ctrl.range.to\"\n                 on-change=\"$ctrl.onDateEditorChange('to')\"\n                 data-deletable=\"true\"\n                 class=\"date-picker\">\n            </div>\n        </div>\n    </div>\n</div>\n<div class=\"error col-xs-12\" ng-show=\"$ctrl.showInvalidDateRangeMessage\">Start date must be before end date</div>\n"

/***/ }),

/***/ 2510:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.tileDateRangeLabel = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _tileDateRangeConstants = __webpack_require__(826);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '<span class="card-filter-item"><i class="xl-icon calendar-icon"></i>{{$ctrl.rangeText}}</span>';

var TileDateRangeLabelController = function () {
    function TileDateRangeLabelController($dateFilter) {
        (0, _classCallCheck3.default)(this, TileDateRangeLabelController);

        this.$dateFilter = $dateFilter;
    }

    (0, _createClass3.default)(TileDateRangeLabelController, [{
        key: '$onInit',
        value: function $onInit() {
            this.rangeText = this.getDateFilterText();
        }
    }, {
        key: 'getDateFilterText',
        value: function getDateFilterText() {
            if (this.timeFrame === 'RANGE') {
                if (this.from && this.to) {
                    return 'Range ' + this.formatDate(this.from) + ' - ' + this.formatDate(this.to);
                } else if (this.from && !this.to) {
                    return 'After ' + this.formatDate(this.from);
                } else if (!this.from && this.to) {
                    return 'Before ' + this.formatDate(this.to);
                } else {
                    return 'Any time';
                }
            } else {
                return _tileDateRangeConstants.TIME_FRAME_LABELS[this.timeFrame];
            }
        }
    }, {
        key: 'formatDate',
        value: function formatDate(date) {
            return this.$dateFilter(date, 'short');
        }
    }]);
    return TileDateRangeLabelController;
}();

TileDateRangeLabelController.$inject = ['dateFilter'];
var tileDateRangeLabel = exports.tileDateRangeLabel = {
    bindings: {
        timeFrame: '<',
        from: '<',
        to: '<'
    },
    controller: TileDateRangeLabelController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrTileDateRangeLabel', tileDateRangeLabel);

/***/ }),

/***/ 2511:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.tileVersionFilter = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _map = __webpack_require__(221);

var _map2 = _interopRequireDefault(_map);

var _tileVersionFilterTpl = __webpack_require__(2512);

var _tileVersionFilterTpl2 = _interopRequireDefault(_tileVersionFilterTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var versionFilterType = {
    ALL: "ALL",
    MAJOR_VERSION: "MAJOR_VERSION",
    MINOR_VERSION: "MINOR_VERSION",
    PATCH_VERSION: "PATCH_VERSION",
    SNAPSHOT_VERSION: "SNAPSHOT_VERSION",
    ALPHA_VERSION: "ALPHA_VERSION",
    BETA_VERSION: "BETA_VERSION",
    RC_VERSION: "RC_VERSION",
    CUSTOM: "CUSTOM_VERSION"
};

var versionFilterMap = new _map2.default();
versionFilterMap.set(versionFilterType.ALL, "[^\\n]+");
versionFilterMap.set(versionFilterType.MAJOR_VERSION, "^([0-9]|[1-9][0-9]*)(\\.([0]))(\\.([0]))?$");
versionFilterMap.set(versionFilterType.MINOR_VERSION, "^([0-9]|[1-9][0-9]*)\\.([1-9]|[1-9][1-9]*)*(\\.([0]))?$");
versionFilterMap.set(versionFilterType.PATCH_VERSION, "^([0-9]|[1-9][0-9]*)\\.([0-9]|[1-9][0-9]*)\\.([1-9]|[1-9][1-9]*)$");
versionFilterMap.set(versionFilterType.SNAPSHOT_VERSION, "\\bSNAPSHOT\\b");
versionFilterMap.set(versionFilterType.ALPHA_VERSION, "\\bALPHA\\b");
versionFilterMap.set(versionFilterType.BETA_VERSION, "\\bBETA\\b");
versionFilterMap.set(versionFilterType.RC_VERSION, "\\bRC\\b");
versionFilterMap.set(versionFilterType.CUSTOM, "");

var VersionFilterComponent = function () {
    function VersionFilterComponent() {
        (0, _classCallCheck3.default)(this, VersionFilterComponent);

        this.versionFilterType = versionFilterType;
        this.versionFilterMap = versionFilterMap;
    }

    (0, _createClass3.default)(VersionFilterComponent, [{
        key: "$onInit",
        value: function $onInit() {
            if (this.tile.properties.versionFilterType.value !== this.versionFilterType.CUSTOM) {
                this.tile.properties.versionFilterRegex = this.versionFilterMap.get(this.tile.properties.versionFilterType.value);
            }
        }
    }, {
        key: "onVersionFilterTypeChange",
        value: function onVersionFilterTypeChange() {
            if (this.tile.properties.versionFilterType.value !== this.versionFilterType.CUSTOM || this.tile.properties.versionFilterType.value !== this.versionFilterType.NONE) {
                this.tile.properties.versionFilterRegex = this.versionFilterMap.get(this.tile.properties.versionFilterType.value);
            } else {
                this.tile.properties.versionFilterRegex = "";
            }
        }
    }]);
    return VersionFilterComponent;
}();

var tileVersionFilter = exports.tileVersionFilter = {
    bindings: {
        tile: '<'
    },
    controller: VersionFilterComponent,
    template: _tileVersionFilterTpl2.default
};

angular.module('xlrelease.dashboard').component('xlrTileVersionFilter', tileVersionFilter);

/***/ }),

/***/ 2512:
/***/ (function(module, exports) {

module.exports = "<label for=\"version-filter-select\" class=\"control-label col-xs-3\">Versions</label>\n<div class=\"col-xs-9\">\n    <select class=\"xlr-version-filter-select\"\n            id=\"version-filter-select\"\n            name=\"version-filter-select\"\n            ng-model=\"$ctrl.tile.properties.versionFilterType.value\"\n            ng-change=\"$ctrl.onVersionFilterTypeChange()\">\n        <option value=\"{{$ctrl.versionFilterType.ALL}}\">All</option>\n        <option value=\"{{$ctrl.versionFilterType.MAJOR_VERSION}}\">Major</option>\n        <option value=\"{{$ctrl.versionFilterType.MINOR_VERSION}}\">Minor</option>\n        <option value=\"{{$ctrl.versionFilterType.PATCH_VERSION}}\">Patch</option>\n        <option value=\"{{$ctrl.versionFilterType.SNAPSHOT_VERSION}}\">Snapshot</option>\n        <option value=\"{{$ctrl.versionFilterType.ALPHA_VERSION}}\">Alpha</option>\n        <option value=\"{{$ctrl.versionFilterType.BETA_VERSION}}\">Beta</option>\n        <option value=\"{{$ctrl.versionFilterType.RC_VERSION}}\">Release candidate</option>\n        <option value=\"{{$ctrl.versionFilterType.CUSTOM}}\">Custom</option>\n    </select>\n    <span class=\"description\">\n        Display only the versions of the selected semantic version type.\n        See <a target=\"_blank\" href=\"https://semver.org/\">https://semver.org/</a> for details.\n    </span>\n    <div ng-if=\"$ctrl.tile.properties.versionFilterType.value === $ctrl.versionFilterType.CUSTOM\" class=\"version-filter mtm\">\n        <div class=\"form-group\">\n            <label for=\"regex\" class=\"control-label col-xs-3\">Regular expression <span class=\"error\">*</span></label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"regex\" name=\"regex\" required\n                       ng-model=\"$ctrl.tile.properties.versionFilterRegex\"\n                       class=\"form-control\">\n                <span class=\"description\">Python compatible regular expression, e.g. Major ^([0-9]|[1-9][0-9]*)(\\.([0]))(\\.([0]))?$</span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2513:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2515:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.dashboardPlaceholder = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="dashboard-placeholder">\n    <div release-header></div>\n    <div class="content-under-header"\n        <div ng-if="$ctrl.subMenuItems.length == 0">\n            <div ng-if="$ctrl.hasDashboardCreatePerrmisions()" class="notice">\n                <div class="notice-title">Create your first dashboard</div>\n                <div class="notice-descripton">You haven\'t created any dashboards yet<br/>To get started, click the Add dashboard button</div>\n            </div>\n            <div ng-if="!$ctrl.hasDashboardCreatePerrmisions()" class="notice">\n                <div class="notice-title">No accessible dashboards</div>\n                <div class="notice-descripton">You do not have the permissions required to view dashboards<br/>Contact the XL Release administrator for assistance</div>\n            </div>\n        </div>\n    </div>\n</div>\n';

var DashboardPlaceholderController = function () {
    function DashboardPlaceholderController(Authenticator, GlobalPermissions, $location) {
        (0, _classCallCheck3.default)(this, DashboardPlaceholderController);

        this.Authenticator = Authenticator;
        this.GlobalPermission = GlobalPermissions;
        this.$location = $location;
    }

    (0, _createClass3.default)(DashboardPlaceholderController, [{
        key: '$onChanges',
        value: function $onChanges(changes) {
            if (changes.subMenuItems && changes.subMenuItems.currentValue) {
                var subMenuItems = changes.subMenuItems.currentValue;
                var hasDashboard = _.some(subMenuItems, function (item) {
                    return item.pathSuffix && item.pathSuffix.startsWith('dashboards');
                });
                if (hasDashboard) {
                    this.$location.url(_.head(subMenuItems).pathSuffix);
                }
            }
        }
    }, {
        key: 'hasDashboardCreatePerrmisions',
        value: function hasDashboardCreatePerrmisions() {
            return this.Authenticator.hasPermission(this.GlobalPermission.CREATE_GLOBAL_DASHBOARD);
        }
    }]);
    return DashboardPlaceholderController;
}();

DashboardPlaceholderController.$inject = ['Authenticator', 'GlobalPermissions', '$location'];
var dashboardPlaceholder = exports.dashboardPlaceholder = {
    bindings: {
        subMenuItems: '<'
    },
    controller: DashboardPlaceholderController,
    template: template
};

angular.module('xlrelease.dashboard').component('xlrDashboardPlaceholder', dashboardPlaceholder);

/***/ }),

/***/ 2516:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DashboardPropertiesSidebar = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _dashboardPropertiesSidebar = __webpack_require__(2517);

var _dashboardPropertiesSidebar2 = _interopRequireDefault(_dashboardPropertiesSidebar);

var _xlrDashboardConstants = __webpack_require__(239);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DashboardPropertiesSidebarController = function () {
    function DashboardPropertiesSidebarController($state, $rootScope, Events, XlrSidebarService) {
        (0, _classCallCheck3.default)(this, DashboardPropertiesSidebarController);

        this.$state = $state;
        this.$rootScope = $rootScope;
        this.Events = Events;
        this.XlrSidebarService = XlrSidebarService;
        this.sidebarOpts = {
            position: 'right',
            backdropOpacity: 0
        };
    }

    (0, _createClass3.default)(DashboardPropertiesSidebarController, [{
        key: '$onInit',
        value: function $onInit() {
            this.$rootScope.$on('$stateChangeStart', this.onCancel.bind(this));
        }
    }, {
        key: 'onOpenSidebar',
        value: function onOpenSidebar() {
            this.isVisible = true;
        }
    }, {
        key: 'onCloseSidebar',
        value: function onCloseSidebar() {
            this.isVisible = false;
        }
    }, {
        key: 'onCancel',
        value: function onCancel() {
            this.XlrSidebarService.close(this.sidebarName);
        }
    }, {
        key: 'onSave',
        value: function onSave(dashboard, isNew) {
            this.XlrSidebarService.close(this.sidebarName);
            if (dashboard.parentId) {
                this.$state.go('folderDashboards', {
                    dashboardId: dashboard.id,
                    folderId: dashboard.parentId
                }, { reload: true });
            } else {
                this.$rootScope.$emit(this.Events.ui.subMenuRefresh);
                this.$state.go('dashboards', {
                    dashboardId: dashboard.id,
                    dashboardMode: isNew ? _xlrDashboardConstants.DASHBOARD_MODE.DESIGN : undefined
                }, { reload: true });
            }
        }
    }]);
    return DashboardPropertiesSidebarController;
}();

DashboardPropertiesSidebarController.$inject = ['$state', '$rootScope', 'Events', 'xlrelease.XlrSidebarService'];
var DashboardPropertiesSidebar = exports.DashboardPropertiesSidebar = {
    bindings: {
        sidebarName: '<',
        dashboard: '<'
    },
    controller: DashboardPropertiesSidebarController,
    template: _dashboardPropertiesSidebar2.default
};

angular.module('xlrelease.dashboard').component('xlrDashboardPropertiesSidebar', DashboardPropertiesSidebar);

/***/ }),

/***/ 2517:
/***/ (function(module, exports) {

module.exports = "<sidebarjs class=\"dashboard-sidebar\"\n           sidebarjs-name=\"{{$ctrl.sidebarName}}\"\n           sidebarjs-config=\"$ctrl.sidebarOpts\"\n           on-open=\"$ctrl.onOpenSidebar()\"\n           on-close=\"$ctrl.onCloseSidebar()\">\n    <xlr-dashboard-properties\n            ng-if=\"$ctrl.isVisible\"\n            parent-id=\"$ctrl.dashboard.parentId\"\n            current-dashboard=\"$ctrl.dashboard\"\n            on-save=\"$ctrl.onSave(dashboard, isNew)\"\n            on-cancel=\"$ctrl.onCancel()\">\n    </xlr-dashboard-properties>\n</sidebarjs>\n"

/***/ }),

/***/ 2518:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DashboardProperties = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(2519);

var _dashboardProperties = __webpack_require__(2521);

var _dashboardProperties2 = _interopRequireDefault(_dashboardProperties);

var _xlrDashboardConstants = __webpack_require__(239);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DashboardPropertiesController = function () {
    function DashboardPropertiesController(XlrDashboardService, RolesService, UsersService, ClientSettings, $q, TeamsService, FolderPathService) {
        (0, _classCallCheck3.default)(this, DashboardPropertiesController);

        this.XlrDashboardService = XlrDashboardService;
        this.RolesService = RolesService;
        this.UsersService = UsersService;
        this.ClientSettings = ClientSettings;
        this.$q = $q;
        this.TeamsService = TeamsService;
        this.FolderPathService = FolderPathService;
        this._saveListeners = [];
    }

    (0, _createClass3.default)(DashboardPropertiesController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.saving = false;
            this.toStep('PROPERTIES');

            if (this.templateType) {
                var configurationUri = this.templateType.properties.find(function (property) {
                    return property.name === 'configurationUri';
                }).default;
                if (configurationUri) {
                    this.configurationUri = 'static/8.6.2/' + configurationUri;
                }
            }

            var rolesPromise = this.$q.defer();
            if (this.parentId) {
                rolesPromise.resolve([]);
            } else {
                this.RolesService.getRoleNames().then(function (res) {
                    return rolesPromise.resolve(_this._convertToTags(res.data));
                });
            }
            var usersPromise = this.UsersService.getAllUsers().then(function (res) {
                return res.data;
            });

            this.$q.all([rolesPromise.promise, usersPromise]).then(function (_ref) {
                var _ref2 = (0, _slicedToArray3.default)(_ref, 2),
                    allRoles = _ref2[0],
                    allUsers = _ref2[1];

                _this.allRoles = allRoles;
                _this.allUsers = allUsers;

                _this.columns = _.range(1, _xlrDashboardConstants.DASHBOARD_MAX_COLUMNS + 1);

                if (_this.currentDashboard) {
                    _this.dashboard = angular.copy(_this.currentDashboard);
                    _this._assignDashboard(_this.dashboard);
                } else {
                    _this.roleViewers = [];
                    _this.roleEditors = [];
                    _this.dashboard = {
                        title: _this.templateType ? _this.templateType.properties.find(function (property) {
                            return property.name === 'title';
                        }).default : '',
                        description: _this.templateType ? _this.templateType.properties.find(function (property) {
                            return property.name === 'description';
                        }).default : '',
                        templateType: _this.templateType ? _this.templateType.type : null,
                        columns: _this.templateType ? _this.templateType.properties.find(function (property) {
                            return property.name === 'columns';
                        }).default : _xlrDashboardConstants.DASHBOARD_DEFAULT_COLUMNS,
                        parentId: _this.parentId,
                        properties: {}
                    };
                    _this.owner = _this.ClientSettings.getAuthenticationData();
                }

                if (_this.dashboard.parentId) {
                    _this.FolderPathService.getPathFromParentFolderId(_this.dashboard.parentId).then(function (paths) {
                        return _this.inheritedFrom = _.last(paths);
                    });
                }
            });
        }
    }, {
        key: '_assignDashboard',
        value: function _assignDashboard(dashboard) {
            this.roleViewers = this._convertToTags(dashboard.roleViewers);
            this.roleEditors = this._convertToTags(dashboard.roleEditors);
            this.owner = _.find(this.allUsers, { username: dashboard.owner });
        }
    }, {
        key: '_convertToTags',
        value: function _convertToTags(roles) {
            return roles.map(function (roleName) {
                return {
                    name: roleName,
                    type: 'ROLE'
                };
            });
        }
    }, {
        key: 'isNew',
        value: function isNew() {
            return !_.has(this, 'dashboard.id');
        }
    }, {
        key: 'canEditColumns',
        value: function canEditColumns() {
            return !this.isNew() || !this.templateType || this.templateType.type === 'xlrelease.BlankDashboard';
        }
    }, {
        key: 'hasInheritedSecurity',
        value: function hasInheritedSecurity() {
            return !!this.parentId;
        }
    }, {
        key: 'isValid',
        value: function isValid() {
            return this.dashboard.title && this.owner;
        }
    }, {
        key: 'saveDashboard',
        value: function saveDashboard() {
            var _this2 = this;

            this._saveListeners.forEach(function (listener) {
                return listener(_this2.dashboard);
            });
            var dashboardView = (0, _extends3.default)({}, _.omit(this.dashboard, 'metadata'), {
                roleViewers: this.roleViewers.map(function (role) {
                    return role.name;
                }),
                roleEditors: this.roleEditors.map(function (role) {
                    return role.name;
                }),
                owner: this.owner.username
            });
            this.saving = true;
            var promise = void 0;
            if (this.isNew()) {
                promise = this.XlrDashboardService.create(dashboardView);
            } else {
                promise = this.XlrDashboardService.update(dashboardView);
            }

            promise.then(function (resp) {
                var dashboard = resp.data;
                _this2.onSave({ dashboard: dashboard, isNew: _this2.isNew() });
            }).finally(function () {
                return _this2.saving = false;
            });
        }
    }, {
        key: 'cancel',
        value: function cancel() {
            this.onCancel();
        }
    }, {
        key: 'hasConfiguration',
        value: function hasConfiguration() {
            return !!this.configurationUri;
        }
    }, {
        key: 'toStep',
        value: function toStep(step) {
            this.currentStep = step;
        }
    }, {
        key: 'registerSaveListener',
        value: function registerSaveListener(listener) {
            this._saveListeners.push(listener);
        }
    }, {
        key: 'unregisterSaveListener',
        value: function unregisterSaveListener(listener) {
            this._saveListeners = this._saveListeners.filter(function (item) {
                return item !== listener;
            });
        }
    }]);
    return DashboardPropertiesController;
}();

DashboardPropertiesController.$inject = ['xlrelease.XlrDashboardService', 'RolesService', 'UsersService', 'ClientSettings', '$q', 'TeamsService', 'FolderPathService'];
var DashboardProperties = exports.DashboardProperties = {
    bindings: {
        currentDashboard: '<',
        templateType: '<',
        parentId: '<',
        onSave: '&',
        onCancel: '&'
    },
    controller: DashboardPropertiesController,
    template: _dashboardProperties2.default
};

angular.module('xlrelease.dashboard').component('xlrDashboardProperties', DashboardProperties);

/***/ }),

/***/ 2519:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 252:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var DATE_FILTER_TYPE = exports.DATE_FILTER_TYPE = 'xlrelease.DateFilter';
var FOLDER_FILTER_TYPE = exports.FOLDER_FILTER_TYPE = 'xlrelease.FolderFilter';
var ENVIRONMENT_STAGE_FILTER_TYPE = exports.ENVIRONMENT_STAGE_FILTER_TYPE = 'xlrelease.EnvironmentStageFilter';
var ENVIRONMENT_LABEL_FILTER_TYPE = exports.ENVIRONMENT_LABEL_FILTER_TYPE = 'xlrelease.EnvironmentLabelFilter';
var ENVIRONMENT_FILTER_TYPE = exports.ENVIRONMENT_FILTER_TYPE = 'xlrelease.EnvironmentFilter';
var APPLICATION_FILTER_TYPE = exports.APPLICATION_FILTER_TYPE = 'xlrelease.ApplicationFilter';

var ENTITY_ID_PLACEHOLDER = exports.ENTITY_ID_PLACEHOLDER = "-1";

var DEFAULT_TIME_PERIOD = exports.DEFAULT_TIME_PERIOD = 'LAST_SIX_MONTHS';

var DEPLOYMENT_STATE_ALL = exports.DEPLOYMENT_STATE_ALL = 'all';

var DEPLOYMENT_STATE = exports.DEPLOYMENT_STATE = {
    started: {
        value: 'started',
        className: 'label-active',
        label: 'Started'
    },
    failed: {
        value: 'failed',
        className: 'label-warning-failed',
        label: 'Failed'
    },
    retried: {
        value: 'retried',
        className: 'label-warning-failing',
        label: 'Retried'
    },
    skipped: {
        value: 'skipped',
        className: 'label-default',
        label: 'Skipped'
    },
    aborted: {
        value: 'aborted',
        className: 'label-default',
        label: 'Aborted'
    },
    successful: {
        value: 'completed',
        className: 'label-completed',
        label: 'Successful'
    }
};

/***/ }),

/***/ 2521:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar dashboard-sidebar-properties\" ng-if=\"$ctrl.dashboard\">\n    <div class=\"sidebar-title\" ng-if=\"$ctrl.isNew()\">Add dashboard</div>\n    <div class=\"sidebar-title\" ng-if=\"!$ctrl.isNew()\">Properties</div>\n    <div class=\"sidebar-container\">\n        <form ng-if=\"$ctrl.dashboard\" id=\"dashboardForm\" name=\"dashboardForm\" class=\"form-horizontal\"\n              data-test=\"dashboard-form\"\n              novalidate>\n            <div ng-if=\"$ctrl.currentStep == 'PROPERTIES'\">\n                <div class=\"form-group\">\n                    <label class=\"control-label col-xs-3\">\n                        Name\n                        <span class=\"error\">*</span>\n                    </label>\n\n                    <div class=\"col-xs-9\">\n                        <input type=\"text\" class=\"input-block-level\" id=\"title\" name=\"title\"\n                               ng-model=\"$ctrl.dashboard.title\" ng-maxlength=\"255\" autofocus required/>\n                        <span class=\"description\" ng-if=\"dashboardForm.title.$pristine || dashboardForm.title.$valid\">Name of the dashboard</span>\n                        <span class=\"field-errors\" ng-if=\"dashboardForm.title.$dirty && dashboardForm.title.$invalid\">\n                            <span ng-if=\"dashboardForm.title.$error.required\">Dashboard name is mandatory</span>\n                            <span ng-if=\"dashboardForm.title.$error.maxlength\">Dashboard name is too long</span>\n                        </span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"control-label col-xs-3\">\n                        Description\n                    </label>\n\n                    <div class=\"col-xs-9\">\n                    <textarea class=\"input-block-level\" id=\"description\" name=\"description\"\n                              ng-model=\"$ctrl.dashboard.description\" ng-maxlength=\"255\"></textarea>\n                        <span class=\"description\"\n                              ng-if=\"dashboardForm.description.$pristine || dashboardForm.description.$valid\">Short description of the dashboard</span>\n                        <span class=\"field-errors\" ng-if=\"dashboardForm.description.$dirty && dashboardForm.description.$invalid\">\n                            <span ng-if=\"dashboardForm.description.$error.maxlength\">Dashboard description is too long</span>\n                        </span>\n                    </div>\n                </div>\n                <div class=\"form-group\" ng-if=\"$ctrl.canEditColumns()\">\n                    <label class=\"control-label col-xs-3\">\n                        Columns <span class=\"error\">*</span>\n                    </label>\n                    <div class=\"col-xs-9\">\n                        <span uib-dropdown class=\"dropdown-selector\">\n                            <button type=\"button\" class=\"btn btn-flat btn-fixed btn-block\" uib-dropdown-toggle>\n                                <span class=\"dropdown-label pull-left\">{{$ctrl.dashboard.columns}}</span>\n                                <i class=\"xl-icon arrow-down-icon pull-right\"></i>\n                            </button>\n                            <ul uib-dropdown-menu>\n                                <li ng-repeat=\"option in $ctrl.columns\"\n                                    ng-class=\"{active: option === $ctrl.dashboard.columns}\">\n                                    <a ng-click=\"$ctrl.dashboard.columns = option; dashboardForm.$setDirty()\">\n                                       {{option}}\n                                    </a>\n                                </li>\n                            </ul>\n                        </span>\n                        <span class=\"description\">Number of columns for the dashboard</span>\n                    </div>\n                </div>\n                <div class=\"form-group\">\n                    <label class=\"control-label col-xs-3\">Dashboard owner <span class=\"error\">*</span></label>\n\n                    <div class=\"col-xs-9\">\n                        <span ng-if=\"!$ctrl.readOnly\"\n                              class=\"input-block-level dashboard-owner\"\n                              inline-user-editor\n                              model=\"$ctrl.owner\"\n                              autocomplete-data=\"$ctrl.allUsers\"\n                              placeholder=\"Set owner...\">\n                            <span display-user=\"$ctrl.owner\"></span>\n                        </span>\n                        <span class=\"description\">Owner of this dashboard</span>\n                    </div>\n                </div>\n                <div>\n                    <div class=\"form-group\" ng-if=\"$ctrl.hasInheritedSecurity()\">\n                        <label class=\"control-label col-xs-12\">\n                            Inherits teams and permissions from parent folder <a ng-href=\"#folders/{{$ctrl.inheritedFrom.id}}/permissions\">{{$ctrl.inheritedFrom.title}}</a>.\n                        </label>\n                    </div>\n                    <div class=\"form-group\" ng-hide=\"$ctrl.hasInheritedSecurity() && $ctrl.isNew()\">\n                        <label class=\"control-label col-xs-3\">\n                            Viewers\n                        </label>\n\n                        <div class=\"col-xs-9\">\n                            <div ng-if=\"$ctrl.allRoles\"\n                                 name=\"principals\"\n                                 class=\"transparent role-tags role\"\n                                 members-input\n                                 read-only=\"$ctrl.hasInheritedSecurity()\"\n                                 tag-type=\"ROLE\"\n                                 tags=\"$ctrl.roleViewers\"\n                                 placeholder=\"Add a role...\"\n                                 completion-candidates=\"$ctrl.allRoles\"\n                                 on-change=\"dashboardForm.$setDirty()\">\n                            </div>\n                            <span class=\"description\">Roles that can view this dashboard</span>\n                        </div>\n                    </div>\n                    <div class=\"form-group\" ng-hide=\"$ctrl.hasInheritedSecurity() && $ctrl.isNew()\">\n                        <label class=\"control-label col-xs-3\">\n                            Editors\n                        </label>\n\n                        <div class=\"col-xs-9\">\n                            <div ng-if=\"$ctrl.allRoles\"\n                                 name=\"roleEditors\"\n                                 class=\"transparent role-tags role\"\n                                 members-input\n                                 read-only=\"$ctrl.hasInheritedSecurity()\"\n                                 tag-type=\"ROLE\"\n                                 tags=\"$ctrl.roleEditors\"\n                                 placeholder=\"Add a role...\"\n                                 completion-candidates=\"$ctrl.allRoles\"\n                                 on-change=\"dashboardForm.$setDirty()\">\n                            </div>\n                            <span class=\"description\">Roles that can edit this dashboard</span>\n                        </div>\n                    </div>\n                    <div class=\"action-buttons\">\n                        <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.cancel()\">Cancel</button>\n                        <button ng-if=\"!$ctrl.hasConfiguration()\" type=\"button\" class=\"button save primary\"\n                                ng-click=\"$ctrl.saveDashboard()\"\n                                ng-disabled=\"!$ctrl.isValid() || dashboardForm.$invalid || $ctrl.saving\">\n                            {{$ctrl.isNew() ? 'Create' : 'Save' }}\n                        </button>\n                        <button ng-if=\"$ctrl.hasConfiguration()\" type=\"button\" class=\"button save primary\"\n                                ng-click=\"$ctrl.toStep('CONFIGURATION')\"\n                                ng-disabled=\"!$ctrl.isValid() || dashboardForm.$invalid || $ctrl.saving\">\n                            Next\n                        </button>\n                    </div>\n                </div>\n            </div>\n            <div ng-if=\"$ctrl.currentStep == 'CONFIGURATION'\">\n                <div ng-include=\"$ctrl.configurationUri\"></div>\n                <div class=\"action-buttons\">\n                    <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.toStep('PROPERTIES')\">Back</button>\n                    <button type=\"button\" class=\"button save primary\"\n                            ng-click=\"$ctrl.saveDashboard()\"\n                            ng-disabled=\"!$ctrl.isValid() || dashboardForm.$invalid || $ctrl.saving\">\n                        {{$ctrl.isNew() ? 'Create' : 'Save' }}\n                    </button>\n                </div>\n            </div>\n        </form>\n    </div>\n</div>"

/***/ }),

/***/ 2522:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DashboardTemplates = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(2523);

var _dashboardTemplates = __webpack_require__(2525);

var _dashboardTemplates2 = _interopRequireDefault(_dashboardTemplates);

var _xlrDashboardConstants = __webpack_require__(239);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DashboardTemplatesController = function () {
    function DashboardTemplatesController(XlrDashboardService, ClientSettings) {
        (0, _classCallCheck3.default)(this, DashboardTemplatesController);

        this.XlrDashboardService = XlrDashboardService;
        this.ClientSettings = ClientSettings;
    }

    (0, _createClass3.default)(DashboardTemplatesController, [{
        key: '$onInit',
        value: function $onInit() {
            this.loadTemplates();
        }
    }, {
        key: 'loadTemplates',
        value: function loadTemplates() {
            var _this = this;

            var dashboardLevel = this.parentId ? _xlrDashboardConstants.DASHBOARD_LEVEL.FOLDER : _xlrDashboardConstants.DASHBOARD_LEVEL.GLOBAL;
            this.XlrDashboardService.getDashboardTemplates(dashboardLevel).then(function (response) {
                _this.templateTypes = response.data;
                _this.blankTemplateType = _this.templateTypes.find(function (templateType) {
                    return templateType.type === 'xlrelease.BlankDashboard';
                });
            });
        }
    }, {
        key: 'filterTemplateType',
        value: function filterTemplateType(query) {
            var _this2 = this;

            var searchQuery = _.trim(query).toLowerCase();
            return function (templateType) {
                return templateType !== _this2.blankTemplateType && (!searchQuery || _.toLower(templateType.label).includes(searchQuery) || _.toLower(templateType.description).includes(searchQuery));
            };
        }
    }, {
        key: 'selectTemplate',
        value: function selectTemplate(templateType) {
            this.onSelect({ templateType: templateType });
        }
    }]);
    return DashboardTemplatesController;
}();

DashboardTemplatesController.$inject = ['xlrelease.XlrDashboardService', 'ClientSettings'];
var DashboardTemplates = exports.DashboardTemplates = {
    bindings: {
        parentId: '<',
        onSelect: '&',
        onCancel: '&'
    },
    controller: DashboardTemplatesController,
    template: _dashboardTemplates2.default
};

angular.module('xlrelease.dashboard').component('xlrDashboardTemplates', DashboardTemplates);

/***/ }),

/***/ 2523:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2525:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar\">\n    <div class=\"sidebar-title\">Add dashboard</div>\n    <div class=\"sidebar-subtitle\">Select template</div>\n    <div class=\"sidebar-container\">\n        <div class=\"row mbs\">\n            <div class=\"col-xs-12\">\n                <xlr-tile-card label=\"'Select'\" tile=\"$ctrl.blankTemplateType\" add=\"$ctrl.selectTemplate($ctrl.blankTemplateType)\"></xlr-tile-card>\n            </div>\n        </div>\n        <hr/>\n        <div class=\"row mbs\">\n            <div class=\"col-xs-12 search-bar\">\n                <i class=\"xl-icon search-icon\"></i>\n                <input id=\"tile-filter\"\n                       type=\"search\"\n                       class=\"tile-filter\"\n                       placeholder=\"Search for template\"\n                       ng-model=\"$ctrl.searchQuery\">\n            </div>\n        </div>\n        <div class=\"row mbs\" ng-repeat=\"templateType in $ctrl.templateTypes | filter:$ctrl.filterTemplateType($ctrl.searchQuery)\">\n            <div class=\"col-xs-12\">\n                <xlr-tile-card label=\"'Select'\" tile=\"templateType\" add=\"$ctrl.selectTemplate(templateType)\"></xlr-tile-card>\n            </div>\n        </div>\n    </div>\n</div>"

/***/ }),

/***/ 2526:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _tileConfiguration = __webpack_require__(2527);

var _tileConfiguration2 = _interopRequireDefault(_tileConfiguration);

var _xlrTileUtil = __webpack_require__(825);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TileConfigurationController = function () {
    function TileConfigurationController(VariablesService, XlrSidebarService, $scope) {
        (0, _classCallCheck3.default)(this, TileConfigurationController);

        this.VariablesService = VariablesService;
        this.XlrSidebarService = XlrSidebarService;
        this.$scope = $scope;
        this._saveListeners = [];
    }

    (0, _createClass3.default)(TileConfigurationController, [{
        key: '$onInit',
        value: function $onInit() {
            this.$scope.release = this.release;
        }
    }, {
        key: '$onChanges',
        value: function $onChanges(changes) {
            if (changes.tile && changes.tile.currentValue) {
                this.configureTile(changes.tile.currentValue);
            }
        }
    }, {
        key: 'configureTile',
        value: function configureTile(tile) {
            this.tile = tile;
            this.tileTypeDefinition = this.tileTypeDefs[tile.type];
            this.configurationPropertyDefinitions = _.filter(this.tileTypeDefinition.properties, function (property) {
                return property.category === 'input' && property.hidden !== true;
            });
        }
    }, {
        key: 'getConfigUrl',
        value: function getConfigUrl(tile) {
            return (0, _xlrTileUtil.tileOrDefaultUrl)(tile.configurationUri, 'include/DashboardPage/partials/tile-dip-config.html');
        }
    }, {
        key: 'createVariable',
        value: function createVariable(name, variableType, createdCallback) {
            if (this.release && this.release.id) {
                var variable = {
                    key: name,
                    type: variableType
                };

                this.VariablesService.createReleaseVariable(this.release.id, variable).then(function (resp) {
                    if (createdCallback) {
                        createdCallback(resp.data);
                    }
                });
            }
        }
    }, {
        key: 'save',
        value: function save() {
            var _this = this;

            this._saveListeners.forEach(function (listener) {
                return listener(_this.tile);
            });
            this.saveTile({ item: this.tile });
            this.dismiss();
        }
    }, {
        key: 'update',
        value: function update(tile) {
            this.tile = (0, _extends3.default)({}, tile);
        }
    }, {
        key: 'dismiss',
        value: function dismiss() {
            this.XlrSidebarService.closeAll();
        }
    }, {
        key: 'registerSaveListener',
        value: function registerSaveListener(listener) {
            this._saveListeners.push(listener);
        }
    }, {
        key: 'unregisterSaveListener',
        value: function unregisterSaveListener(listener) {
            this._saveListeners = this._saveListeners.filter(function (item) {
                return item !== listener;
            });
        }
    }]);
    return TileConfigurationController;
}();

TileConfigurationController.$inject = ['VariablesService', 'xlrelease.XlrSidebarService', '$scope'];


var tileConfiguration = {
    bindings: {
        tile: '<',
        tileTypeDefs: '=',
        variables: '=',
        release: '=',
        saveTile: '&'
    },
    controller: TileConfigurationController,
    controllerAs: 'xlrTile', // Note: this is added for backward compatibility of tiles
    template: _tileConfiguration2.default
};

angular.module('xlrelease.dashboard').component('xlrTileConfiguration', tileConfiguration);

/***/ }),

/***/ 2527:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar\" ng-if=\"xlrTile.tile\">\n    <div class=\"sidebar-title\">Edit tile</div>\n    <div class=\"sidebar-container\">\n        <div class=\"sidebar-renderer\" ng-include=\"xlrTile.getConfigUrl(xlrTile.tile)\"></div>\n        <div class=\"action-buttons\">\n            <button class=\"button cancel\" type=\"button\" ng-click=\"xlrTile.dismiss()\">Cancel</button>\n            <button class=\"button save primary\" type=\"submit\" ng-click=\"xlrTile.save()\">Save</button>\n        </div>\n    </div>\n</div>"

/***/ }),

/***/ 2528:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _tileCard = __webpack_require__(2529);

var _tileCard2 = _interopRequireDefault(_tileCard);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var tileCard = {
    bindings: {
        tile: '<',
        add: '&',
        label: '<'
    },
    template: _tileCard2.default
};

angular.module('xlrelease.dashboard').component('xlrTileCard', tileCard);

/***/ }),

/***/ 2529:
/***/ (function(module, exports) {

module.exports = "<div class=\"tile-card\">\n    <div>\n        <span class=\"tile-card-title\">\n         {{::$ctrl.tile.label}}\n        </span>\n        <button class=\"button tile-card-button primary pull-right\" ng-click=\"$ctrl.add()\">{{::$ctrl.label}}</button>\n    </div>\n    <div class=\"tile-content\">\n        <span class=\"tile-card-content\">\n            {{::$ctrl.tile.description}}\n        </span>\n    </div>\n</div>\n"

/***/ }),

/***/ 2530:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _tileSelector = __webpack_require__(2531);

var _tileSelector2 = _interopRequireDefault(_tileSelector);

__webpack_require__(2532);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TileSelectorController = function () {
    function TileSelectorController() {
        (0, _classCallCheck3.default)(this, TileSelectorController);

        this.searchQuery = '';
    }

    (0, _createClass3.default)(TileSelectorController, [{
        key: '$onInit',
        value: function $onInit() {
            this.tileTypeDefsValues = _.values(this.tileTypeDefs);
            this.filteredTileTypeDefs = this.tileTypeDefsValues;
        }
    }, {
        key: 'filterTiles',
        value: function filterTiles() {
            var _this = this;

            var searchQuery = _.trim(this.searchQuery).toLowerCase();

            if (searchQuery) {
                this.filteredTileTypeDefs = _.keys(this.tileTypeDefs).reduce(function (filteredTileTypeDefs, tileDef) {
                    var tileTypeDef = _this.tileTypeDefs[tileDef];
                    if (_.toLower(tileTypeDef.label).includes(searchQuery) || _.toLower(tileTypeDef.description).includes(searchQuery)) {
                        filteredTileTypeDefs.push(tileTypeDef);
                    }
                    return filteredTileTypeDefs;
                }, []);
            } else {
                this.filteredTileTypeDefs = this.tileTypeDefsValues;
            }
        }
    }]);
    return TileSelectorController;
}();

var tileSelector = {
    bindings: {
        tileTypeDefs: '<',
        addTile: '&'
    },
    controller: TileSelectorController,
    template: _tileSelector2.default
};

angular.module('xlrelease.dashboard').component('xlrTileSelector', tileSelector);

/***/ }),

/***/ 2531:
/***/ (function(module, exports) {

module.exports = "<div class=\"sidebar\">\n    <div class=\"sidebar-title\">Add tiles</div>\n    <div class=\"row mbs\">\n        <div class=\"col-xs-12 search-bar\">\n            <i class=\"xl-icon search-icon\"></i>\n            <input id=\"tile-filter\"\n                   type=\"search\"\n                   class=\"tile-filter\"\n                   placeholder=\"Search...\"\n                   ng-model=\"$ctrl.searchQuery\"\n                   ng-change=\"$ctrl.filterTiles()\">\n        </div>\n    </div>\n    <div class=\"sidebar-container\">\n        <div class=\"row mbs\" ng-repeat=\"tileTypeDef in $ctrl.filteredTileTypeDefs\">\n            <div class=\"col-xs-12\">\n                <xlr-tile-card label=\"'Add'\" tile=\"tileTypeDef\" add=\"$ctrl.addTile({type: tileTypeDef.type})\"></xlr-tile-card>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2532:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2534:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2535);

var _markdownTileViewComponent = __webpack_require__(2537);

var _markdownTileConfigComponent = __webpack_require__(2539);

var _markdownAttachmentFilter = __webpack_require__(2541);

angular.module('xlrelease.dashboard').component('markdownTileConfig', _markdownTileConfigComponent.markdownTileConfig).component('markdownTileView', _markdownTileViewComponent.markdownTileView).filter('markdownAttachment', _markdownAttachmentFilter.markdownAttachmentFilter);

/***/ }),

/***/ 2535:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2537:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.markdownTileView = undefined;

var _markdownTileViewTpl = __webpack_require__(2538);

var _markdownTileViewTpl2 = _interopRequireDefault(_markdownTileViewTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var markdownTileView = exports.markdownTileView = {
    bindings: {
        tile: '<',
        parent: '<',
        variables: '<'
    },
    template: _markdownTileViewTpl2.default
};

/***/ }),

/***/ 2538:
/***/ (function(module, exports) {

module.exports = "<div class=\"markdown-tile-view\">\n    <span ng-bind-html=\"$ctrl.tile.properties.content | markdownAttachment:$ctrl.tile.properties.attachments.value | displayVariables:$ctrl.variables:true\"></span>\n</div>\n"

/***/ }),

/***/ 2539:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.markdownTileConfig = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _markdownTileConfigTpl = __webpack_require__(2540);

var _markdownTileConfigTpl2 = _interopRequireDefault(_markdownTileConfigTpl);

var _constants = __webpack_require__(827);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MarkdownTileConfigController = function () {
    function MarkdownTileConfigController(uuid4) {
        (0, _classCallCheck3.default)(this, MarkdownTileConfigController);
        this.SUPPORTED_ATTACHMENT_TYPES = 'image.*';
        this.MAX_ATTACHMENT_ALLOWED_SIZE = 1000000;

        this.uuid4 = uuid4;

        this.supportAttachments = !!window.FileReader;
        this.onSaveCallback = this.beforeSave.bind(this);
    } // one megabyte, size is presented in bytes

    (0, _createClass3.default)(MarkdownTileConfigController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.parent.registerSaveListener(this.onSaveCallback);
            this.content = this.tile.properties.content;

            if (this.supportAttachments) {
                var reader = new FileReader();
                this.dropdownZone = angular.element('#markdown-tile-dropdown');
                this.dropdownZone.on('dragenter', function (event) {
                    _this.dropCallback(event, function (element) {
                        element.addClass('hover-dropdown');
                    });
                }).on("dragover", function (event) {
                    _this.dropCallback(event, function (element) {
                        element.addClass('hover-dropdown');
                    });
                }).on("dragleave", function (event) {
                    _this.dropCallback(event, function (element) {
                        element.removeClass('hover-dropdown');
                    });
                }).on('drop', function (event) {
                    _this.dropCallback(event, function (element) {
                        element.removeClass('hover-dropdown');
                        reader.onload = _this.onFileReaderLoad(element);
                        var file = event.originalEvent.dataTransfer.files[0]; // upload one picture at the time
                        if (file.type.match(_this.SUPPORTED_ATTACHMENT_TYPES) && file.size < _this.MAX_ATTACHMENT_ALLOWED_SIZE) {
                            reader.readAsDataURL(file);
                        }
                    });
                });
            }
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this.parent.unregisterSaveListener(this.onSaveCallback);
        }
    }, {
        key: 'beforeSave',
        value: function beforeSave(tile) {
            var _this2 = this;

            if (!_.isNull(this.content) && this.supportAttachments) {
                // remove unused attachments
                var usedUuids = [];
                var matchResult = void 0;
                while (matchResult = _constants.markdownImageRegex.exec(this.content)) {
                    usedUuids.push(matchResult[2]);
                }
                _.forEach(_.difference(_.keys(this.tile.properties.attachments.value), usedUuids), function (uuid) {
                    delete _this2.tile.properties.attachments.value[uuid];
                });
            }
            this.tile.properties.content = this.content;
        }
    }, {
        key: 'dropCallback',
        value: function dropCallback(event, callbackFunc) {
            event.preventDefault();
            event.stopPropagation();
            var element = angular.element(event.target);
            if (element.is("textarea")) {
                callbackFunc(element);
            }
        }
    }, {
        key: 'onFileReaderLoad',
        value: function onFileReaderLoad(element) {
            var _this3 = this;

            return function (file) {
                var uuid4 = _this3.uuid4.generate();
                _this3.tile.properties.attachments.value[uuid4] = file.target.result;
                // add image at the cursor position
                var cursorPosition = element.prop("selectionStart");
                var value = element.val();
                var output = [value.slice(0, cursorPosition), '![](' + uuid4 + ')', value.slice(cursorPosition)].join('');
                element.val(output).trigger('change');
            };
        }
    }]);
    return MarkdownTileConfigController;
}();

MarkdownTileConfigController.$inject = ['uuid4'];
var markdownTileConfig = exports.markdownTileConfig = {
    bindings: {
        tile: '<',
        parent: '<',
        variables: '<'
    },
    controller: MarkdownTileConfigController,
    template: _markdownTileConfigTpl2.default
};

/***/ }),

/***/ 2540:
/***/ (function(module, exports) {

module.exports = "<div class=\"markdown-tile-config\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <label for=\"title\" class=\"control-label col-xs-3\">Title</label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"title\" name=\"title\"\n                       ng-model=\"$ctrl.tile.properties.title\"\n                       class=\"form-control\">\n                <span class=\"description\">Name of the tile</span>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label for=\"title\" class=\"control-label col-xs-3\">Content <span class=\"error\">*</span></label>\n            <div class=\"col-xs-9\">\n                <div inline-textarea-editor id=\"markdown-tile-dropdown\" model=\"$ctrl.content\" markdown>\n                    <span ng-bind-html=\"$ctrl.content | markdownAttachment:$ctrl.tile.properties.attachments.value | displayVariables:$ctrl.variables:true\"></span>\n                </div>\n                <span class=\"description\">Markdown text to render as the content of the tile.\n                    For a brief syntax overview, see <a target=\"_blank\" href=\"https://docs.xebialabs.com/xl-release/how-to/using-markdown-in-xl-release.html\">documentation</a>.\n                    To embed pictures, drag & drop the desired image file onto the editable text area. The image will be placed at the cursor position and it should not be larger than one megabyte.\n                </span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2541:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.markdownAttachmentFilter = undefined;

var _constants = __webpack_require__(827);

var markdownAttachmentFilter = exports.markdownAttachmentFilter = function markdownAttachmentFilter() {
    return function (text, attachments) {
        if (_.isNull(text) || _.isUndefined(attachments)) return text;
        return text.replace(_constants.markdownImageRegex, function (match, alt, uuid) {
            if (_.has(attachments, uuid)) {
                return "![" + alt + "](" + attachments[uuid] + ")";
            }
            return match;
        });
    };
};

/***/ }),

/***/ 2542:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(2543);

var _placeholderTileConfigComponent = __webpack_require__(2545);

var _placeholderTileViewComponent = __webpack_require__(2547);

angular.module('xlrelease.dashboard').component('placeholderTileConfig', _placeholderTileConfigComponent.placeholderTileConfig).component('placeholderTileView', _placeholderTileViewComponent.placeholderTileView);

/***/ }),

/***/ 2543:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2545:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.placeholderTileConfig = undefined;

var _placeholderTileConfigTpl = __webpack_require__(2546);

var _placeholderTileConfigTpl2 = _interopRequireDefault(_placeholderTileConfigTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var placeholderTileConfig = exports.placeholderTileConfig = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    template: _placeholderTileConfigTpl2.default
};

/***/ }),

/***/ 2546:
/***/ (function(module, exports) {

module.exports = "<div class=\"placeholder-tile-config\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <label for=\"content\" class=\"control-label col-xs-3\">Content</label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"content\" name=\"content\"\n                       ng-model=\"$ctrl.tile.properties.content\"\n                       class=\"form-control\">\n                <span class=\"description\">Content of the tile</span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 2547:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.placeholderTileView = undefined;

var _placeholderTileViewTpl = __webpack_require__(2548);

var _placeholderTileViewTpl2 = _interopRequireDefault(_placeholderTileViewTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var placeholderTileView = exports.placeholderTileView = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    template: _placeholderTileViewTpl2.default
};

/***/ }),

/***/ 2548:
/***/ (function(module, exports) {

module.exports = "<div class=\"placeholder-tile-view\" ng-class=\"::{'placeholder-tile-view-no-title': !$ctrl.tile.properties.title}\">\n    <div class=\"placeholder-tile-view-content\">\n        <h3 class=\"placeholder-tile-view-text\">{{::$ctrl.tile.properties.content}}</h3>\n    </div>\n</div>"

/***/ }),

/***/ 2549:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _react2angular = __webpack_require__(317);

var _environmentListPage = __webpack_require__(2550);

var _environmentListPage2 = _interopRequireDefault(_environmentListPage);

var _environmentEditPage = __webpack_require__(2677);

var _environmentEditPage2 = _interopRequireDefault(_environmentEditPage);

var _applicationListPage = __webpack_require__(2961);

var _applicationListPage2 = _interopRequireDefault(_applicationListPage);

var _applicationEditPage = __webpack_require__(2970);

var _applicationEditPage2 = _interopRequireDefault(_applicationEditPage);

var _stagePage = __webpack_require__(3414);

var _stagePage2 = _interopRequireDefault(_stagePage);

var _labelPage = __webpack_require__(3422);

var _labelPage2 = _interopRequireDefault(_labelPage);

var _schedulingReleasePage = __webpack_require__(3424);

var _schedulingReleasePage2 = _interopRequireDefault(_schedulingReleasePage);

var _schedulingEnvironmentPage = __webpack_require__(3425);

var _schedulingEnvironmentPage2 = _interopRequireDefault(_schedulingEnvironmentPage);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease.environmentManagement', ['xlrelease']).component('environmentPage', (0, _react2angular.react2angular)(_environmentListPage2.default)).component('environmentEditPage', (0, _react2angular.react2angular)(_environmentEditPage2.default, ['environmentId'])).component('stagePage', (0, _react2angular.react2angular)(_stagePage2.default)).component('labelPage', (0, _react2angular.react2angular)(_labelPage2.default)).component('applicationListPage', (0, _react2angular.react2angular)(_applicationListPage2.default)).component('applicationEditPage', (0, _react2angular.react2angular)(_applicationEditPage2.default)).component('schedulingReleasePage', (0, _react2angular.react2angular)(_schedulingReleasePage2.default)).component('schedulingEnvironmentPage', (0, _react2angular.react2angular)(_schedulingEnvironmentPage2.default)).config(['$urlMatcherFactoryProvider', '$stateProvider', function ($urlMatcherFactoryProvider, $stateProvider) {
    var envMgmtPattern = "Configuration\/environmentManagement";

    $urlMatcherFactoryProvider.type('EnvironmentId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/Environment\\w+")
    });
    $urlMatcherFactoryProvider.type('ApplicationId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/Application\\w+")
    });
    $urlMatcherFactoryProvider.type('EnvironmentStageId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/EnvironmentStage\\w+")
    });
    $urlMatcherFactoryProvider.type('EnvironmentLabelId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/EnvironmentLabel\\w+")
    });
    $urlMatcherFactoryProvider.type('EnvironmentReservationId', {
        encode: angular.identity,
        decode: angular.identity,
        pattern: new RegExp(envMgmtPattern + "\/EnvironmentReservation\\w+")
    });

    $stateProvider.state('environmentCreate', {
        url: '/environments/edit?{environmentId: EnvironmentId}',
        template: '<environment-edit-page environment-id="$resolve.environmentId"></environment-edit-page>',
        resolve: {
            environmentId: ['$stateParams', function ($stateParams) {
                if ($stateParams.environmentId) {
                    return $stateParams.environmentId;
                } else {
                    return null;
                }
            }]
        }
    }).state('environmentList', {
        url: '/environments',
        template: '<environment-page></environment-page>'
    }).state('stageList', {
        url: '/environments/stages',
        template: '<stage-page></stage-page>'
    }).state('labelList', {
        url: '/environments/labels',
        template: '<label-page></label-page>'
    }).state('applicationList', {
        url: '/applications',
        template: '<application-list-page></application-list-page>'
    }).state('applicationCreate', {
        url: '/applications/edit?{applicationId: ApplicationId}',
        template: '<application-edit-page application-id="$resolve.applicationId"></application-edit-page>',
        resolve: {
            applicationId: ['$stateParams', function ($stateParams) {
                if ($stateParams.applicationId) {
                    return $stateParams.applicationId;
                } else {
                    return null;
                }
            }]
        }
    });
}]);

/***/ }),

/***/ 2550:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _environmentManagementStore = __webpack_require__(240);

var _environmentListPageContainer = __webpack_require__(2585);

var _environmentListPageContainer2 = _interopRequireDefault(_environmentListPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentListPage = function (_Component) {
    (0, _inherits3.default)(EnvironmentListPage, _Component);

    function EnvironmentListPage() {
        (0, _classCallCheck3.default)(this, EnvironmentListPage);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentListPage.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentListPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_environmentListPageContainer2.default, null)
            );
        }
    }]);
    return EnvironmentListPage;
}(_react.Component);

exports.default = EnvironmentListPage;

/***/ }),

/***/ 2553:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.default = combinedSaga;

var _effects = __webpack_require__(80);

var _environmentListSaga = __webpack_require__(2554);

var _environmentFormSaga = __webpack_require__(2555);

var _stageSaga = __webpack_require__(2556);

var _labelSaga = __webpack_require__(2571);

var _applicationListSaga = __webpack_require__(2572);

var _applicationFormSaga = __webpack_require__(2573);

var _schedulingEnvironmentReservationFormSaga = __webpack_require__(2574);

var _schedulingSaga = __webpack_require__(2575);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(combinedSaga);

function combinedSaga() {
    return _regenerator2.default.wrap(function combinedSaga$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    if (false) {}

                    _context.prev = 1;
                    _context.next = 4;
                    return (0, _effects.all)([(0, _effects.call)(_environmentListSaga.environmentListSaga), (0, _effects.call)(_environmentFormSaga.environmentFormSaga), (0, _effects.call)(_stageSaga.stageSaga), (0, _effects.call)(_labelSaga.labelSaga), (0, _effects.call)(_applicationListSaga.applicationListSaga), (0, _effects.call)(_applicationFormSaga.applicationFormSaga), (0, _effects.call)(_schedulingEnvironmentReservationFormSaga.scheduleEnvironmentReservationFormSaga), (0, _effects.call)(_schedulingSaga.schedulingSaga)]);

                case 4:
                    _context.next = 9;
                    break;

                case 6:
                    _context.prev = 6;
                    _context.t0 = _context['catch'](1);

                    /* eslint-disable no-console, angular/log */
                    console.error('Environment management root saga:', _context.t0);
                    /* eslint-enable */

                case 9:
                    _context.next = 0;
                    break;

                case 11:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[1, 6]]);
}

/***/ }),

/***/ 2554:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getFilters = exports.toastr = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.search = search;
exports.addEnvironment = addEnvironment;
exports.editEnvironment = editEnvironment;
exports._deleteEnvironment = _deleteEnvironment;
exports.initEnvironmentList = initEnvironmentList;
exports.environmentListSaga = environmentListSaga;

var _effects = __webpack_require__(80);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _environmentActions = __webpack_require__(417);

var _angularAccessor = __webpack_require__(181);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _environmentService = __webpack_require__(332);

var _stageService = __webpack_require__(333);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(search),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(addEnvironment),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(editEnvironment),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(_deleteEnvironment),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(initEnvironmentList),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(environmentListSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var getFilters = exports.getFilters = function getFilters(state) {
    return state.environmentList.filters;
};

function search(action) {
    var _action$payload, title, stageTitle, stage, environments;

    return _regenerator2.default.wrap(function search$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _action$payload = action.payload, title = _action$payload.title, stageTitle = _action$payload.stageTitle;
                    stage = stageTitle || null;
                    _context.prev = 2;
                    _context.next = 5;
                    return (0, _effects.call)(_environmentService.searchEnvironments, { title: title, stage: stage });

                case 5:
                    environments = _context.sent;
                    _context.next = 8;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_SUCCESS,
                        payload: environments
                    });

                case 8:
                    _context.next = 14;
                    break;

                case 10:
                    _context.prev = 10;
                    _context.t0 = _context['catch'](2);
                    _context.next = 14;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_FAILURE
                    });

                case 14:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[2, 10]]);
}

function addEnvironment() {
    var $state;
    return _regenerator2.default.wrap(function addEnvironment$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 2:
                    $state = _context2.sent;
                    _context2.next = 5;
                    return (0, _effects.call)($state.go, 'environmentCreate');

                case 5:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function editEnvironment(action) {
    var $state;
    return _regenerator2.default.wrap(function editEnvironment$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 2:
                    $state = _context3.sent;
                    _context3.next = 5;
                    return (0, _effects.call)($state.go, 'environmentCreate', { environmentId: action.payload.id });

                case 5:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function _deleteEnvironment(action) {
    var environment, currentFilter;
    return _regenerator2.default.wrap(function _deleteEnvironment$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    environment = action.payload;
                    _context4.prev = 1;
                    _context4.next = 4;
                    return (0, _effects.call)(_environmentService.deleteEnvironment, environment.id);

                case 4:
                    _context4.next = 6;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENT_DELETE_SUCCESS
                    });

                case 6:
                    _context4.next = 8;
                    return (0, _effects.call)(toastr.success, 'Environment [' + environment.title + '] deleted.');

                case 8:
                    _context4.next = 10;
                    return (0, _effects.select)(getFilters);

                case 10:
                    currentFilter = _context4.sent;
                    _context4.next = 13;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
                        payload: currentFilter
                    });

                case 13:
                    _context4.next = 19;
                    break;

                case 15:
                    _context4.prev = 15;
                    _context4.t0 = _context4['catch'](1);
                    _context4.next = 19;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.ENVIRONMENT_DELETE_FAILURE
                    });

                case 19:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[1, 15]]);
}

function initEnvironmentList() {
    var environments, stages;
    return _regenerator2.default.wrap(function initEnvironmentList$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.prev = 0;
                    _context5.next = 3;
                    return (0, _effects.call)(_environmentService.searchEnvironments, { title: '', stageTitle: '' });

                case 3:
                    environments = _context5.sent;
                    _context5.next = 6;
                    return (0, _effects.call)(_stageService.searchStages);

                case 6:
                    stages = _context5.sent;
                    _context5.next = 9;
                    return (0, _effects.put)((0, _environmentActions.initEnvironmentListSuccess)(environments, stages));

                case 9:
                    _context5.next = 15;
                    break;

                case 11:
                    _context5.prev = 11;
                    _context5.t0 = _context5['catch'](0);
                    _context5.next = 15;
                    return (0, _effects.put)({
                        type: _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_FAILURE
                    });

                case 15:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this, [[0, 11]]);
}

function environmentListSaga() {
    return _regenerator2.default.wrap(function environmentListSaga$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENT_ADD, addEnvironment), (0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENT_EDIT, editEnvironment), (0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENT_DELETE_REQUEST, _deleteEnvironment), (0, _effects.takeLatest)(_environmentActions.actionTypes.ENVIRONMENTS_SEARCH_REQUEST, search), (0, _effects.takeLatest)(_environmentActions.actionTypes.INIT_ENVIRONMENT_LIST, initEnvironmentList)]);

                case 2:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

/***/ }),

/***/ 2555:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.save = save;
exports.cancel = cancel;
exports.initEnvironmentForm = initEnvironmentForm;
exports.addConfirmLeavePopup = addConfirmLeavePopup;
exports.removeConfirmLeavePopup = removeConfirmLeavePopup;
exports.cleanEnvironment = cleanEnvironment;
exports.environmentFormSaga = environmentFormSaga;

var _effects = __webpack_require__(80);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _environmentFormActions = __webpack_require__(418);

var _stageActions = __webpack_require__(419);

var _labelActions = __webpack_require__(334);

var _angularAccessor = __webpack_require__(181);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _environmentService = __webpack_require__(332);

var _lodash = __webpack_require__(79);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(save),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(cancel),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(initEnvironmentForm),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(addConfirmLeavePopup),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(removeConfirmLeavePopup),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(cleanEnvironment),
    _marked7 = /*#__PURE__*/_regenerator2.default.mark(environmentFormSaga);

var cleanFormFields = { type: _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM };

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function save(action) {
    var $state, environment, environmentForm;
    return _regenerator2.default.wrap(function save$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(removeConfirmLeavePopup);

                case 3:
                    _context.next = 5;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 5:
                    $state = _context.sent;
                    environment = action.payload;
                    environmentForm = {
                        title: environment.title,
                        stageId: environment.stage.id,
                        description: environment.description,
                        labelIds: (0, _lodash.map)(environment.labels, function (lab) {
                            return lab.id;
                        })
                    };

                    if (!(0, _lodash.isEmpty)(environment.id)) {
                        _context.next = 15;
                        break;
                    }

                    _context.next = 11;
                    return (0, _effects.call)(_environmentService.createEnvironment, environmentForm);

                case 11:
                    _context.next = 13;
                    return (0, _effects.call)(toastr.success, 'Environment [' + environment.title + '] created');

                case 13:
                    _context.next = 19;
                    break;

                case 15:
                    _context.next = 17;
                    return (0, _effects.call)(_environmentService.updateEnvironment, environment.id, environmentForm);

                case 17:
                    _context.next = 19;
                    return (0, _effects.call)(toastr.success, 'Environment [' + environment.title + '] updated');

                case 19:
                    _context.next = 21;
                    return (0, _effects.call)($state.go, 'environmentList');

                case 21:
                    _context.next = 27;
                    break;

                case 23:
                    _context.prev = 23;
                    _context.t0 = _context['catch'](0);
                    _context.next = 27;
                    return (0, _effects.call)(console.error, 'Environment form saga:', _context.t0);

                case 27:
                    _context.prev = 27;
                    _context.next = 30;
                    return (0, _effects.put)(cleanFormFields);

                case 30:
                    return _context.finish(27);

                case 31:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 23, 27, 31]]);
}

function cancel() {
    var $state;
    return _regenerator2.default.wrap(function cancel$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(removeConfirmLeavePopup);

                case 2:
                    _context2.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context2.sent;
                    _context2.next = 7;
                    return (0, _effects.call)($state.go, 'environmentList');

                case 7:
                    _context2.next = 9;
                    return (0, _effects.put)(cleanFormFields);

                case 9:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function initEnvironmentForm(_ref) {
    var environmentId = _ref.payload;

    var _ref2, _ref3, environments, environment, _environments;

    return _regenerator2.default.wrap(function initEnvironmentForm$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.prev = 0;

                    if (!environmentId) {
                        _context3.next = 12;
                        break;
                    }

                    _context3.next = 4;
                    return (0, _effects.all)([(0, _effects.call)(_environmentService.searchEnvironments, {}), (0, _effects.call)(_environmentService.loadEnvironment, environmentId)]);

                case 4:
                    _ref2 = _context3.sent;
                    _ref3 = (0, _slicedToArray3.default)(_ref2, 2);
                    environments = _ref3[0];
                    environment = _ref3[1];
                    _context3.next = 10;
                    return (0, _effects.put)({
                        type: _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
                        payload: {
                            environment: environment,
                            environments: environments
                        }
                    });

                case 10:
                    _context3.next = 17;
                    break;

                case 12:
                    _context3.next = 14;
                    return (0, _effects.call)(_environmentService.searchEnvironments, {});

                case 14:
                    _environments = _context3.sent;
                    _context3.next = 17;
                    return (0, _effects.put)({
                        type: _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
                        payload: {
                            environments: _environments
                        }
                    });

                case 17:
                    _context3.next = 19;
                    return (0, _effects.put)((0, _stageActions.searchStages)(null));

                case 19:
                    _context3.next = 21;
                    return (0, _effects.put)((0, _labelActions.searchLabels)(null));

                case 21:
                    _context3.next = 27;
                    break;

                case 23:
                    _context3.prev = 23;
                    _context3.t0 = _context3['catch'](0);
                    _context3.next = 27;
                    return (0, _effects.put)({
                        type: _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_FAILURE
                    });

                case 27:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[0, 23]]);
}

function addConfirmLeavePopup() {
    var confirmLeaveService;
    return _regenerator2.default.wrap(function addConfirmLeavePopup$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'ConfirmLeaveService');

                case 2:
                    confirmLeaveService = _context4.sent;
                    _context4.next = 5;
                    return (0, _effects.call)(confirmLeaveService.requireConfirmation.bind(confirmLeaveService));

                case 5:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

function removeConfirmLeavePopup() {
    var confirmLeaveService;
    return _regenerator2.default.wrap(function removeConfirmLeavePopup$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'ConfirmLeaveService');

                case 2:
                    confirmLeaveService = _context5.sent;
                    _context5.next = 5;
                    return (0, _effects.call)(confirmLeaveService.disableConfirmation.bind(confirmLeaveService));

                case 5:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

function cleanEnvironment() {
    return _regenerator2.default.wrap(function cleanEnvironment$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.next = 2;
                    return (0, _effects.call)(removeConfirmLeavePopup);

                case 2:
                    _context6.next = 4;
                    return (0, _effects.put)(cleanFormFields);

                case 4:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

function environmentFormSaga() {
    return _regenerator2.default.wrap(function environmentFormSaga$(_context7) {
        while (1) {
            switch (_context7.prev = _context7.next) {
                case 0:
                    _context7.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM, cancel), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_SAVE_FORM, save), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM, initEnvironmentForm), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM, addConfirmLeavePopup), (0, _effects.takeLatest)(_environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE, cleanEnvironment)]);

                case 2:
                case 'end':
                    return _context7.stop();
            }
        }
    }, _marked7, this);
}

/***/ }),

/***/ 2556:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports._searchStages = _searchStages;
exports._saveStage = _saveStage;
exports._deleteStage = _deleteStage;
exports.stageSaga = stageSaga;

var _effects = __webpack_require__(80);

var _isEmpty = __webpack_require__(335);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _stageActions = __webpack_require__(419);

var _stageService = __webpack_require__(333);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(_searchStages),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(_saveStage),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(_deleteStage),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(stageSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function _searchStages(action) {
    var stages;
    return _regenerator2.default.wrap(function _searchStages$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_stageService.searchStages, action.payload);

                case 3:
                    stages = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.STAGE_SEARCH_SUCCESS,
                        payload: stages
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.STAGE_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function _saveStage(action) {
    var stage;
    return _regenerator2.default.wrap(function _saveStage$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    stage = action.payload;
                    _context2.prev = 1;

                    if (!(0, _isEmpty2.default)(stage.id)) {
                        _context2.next = 9;
                        break;
                    }

                    _context2.next = 5;
                    return (0, _effects.call)(_stageService.createStage, stage);

                case 5:
                    _context2.next = 7;
                    return (0, _effects.call)(toastr.success, 'Stage [' + stage.title + '] created');

                case 7:
                    _context2.next = 13;
                    break;

                case 9:
                    _context2.next = 11;
                    return (0, _effects.call)(_stageService.updateStage, stage.id, stage);

                case 11:
                    _context2.next = 13;
                    return (0, _effects.call)(toastr.success, 'Stage [' + stage.title + '] updated');

                case 13:
                    _context2.next = 15;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.SAVE_STAGE_SUCCESS
                    });

                case 15:
                    _context2.next = 21;
                    break;

                case 17:
                    _context2.prev = 17;
                    _context2.t0 = _context2['catch'](1);
                    _context2.next = 21;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.SAVE_STAGE_FAILURE
                    });

                case 21:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[1, 17]]);
}

function _deleteStage(action) {
    var stage;
    return _regenerator2.default.wrap(function _deleteStage$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    stage = action.payload;
                    _context3.prev = 1;
                    _context3.next = 4;
                    return (0, _effects.call)(_stageService.deleteStage, stage.id);

                case 4:
                    _context3.next = 6;
                    return (0, _effects.call)(toastr.success, 'Stage [' + stage.title + '] deleted');

                case 6:
                    _context3.next = 8;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.DELETE_STAGE_SUCCESS
                    });

                case 8:
                    _context3.next = 14;
                    break;

                case 10:
                    _context3.prev = 10;
                    _context3.t0 = _context3['catch'](1);
                    _context3.next = 14;
                    return (0, _effects.put)({
                        type: _stageActions.actionTypes.DELETE_STAGE_FAILURE
                    });

                case 14:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[1, 10]]);
}

function stageSaga() {
    return _regenerator2.default.wrap(function stageSaga$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_stageActions.actionTypes.SAVE_STAGE, _saveStage), (0, _effects.takeLatest)(_stageActions.actionTypes.DELETE_STAGE, _deleteStage), (0, _effects.takeLatest)([_stageActions.actionTypes.STAGE_SEARCH, _stageActions.actionTypes.DELETE_STAGE_SUCCESS, _stageActions.actionTypes.SAVE_STAGE_SUCCESS], _searchStages)]);

                case 2:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 2571:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports._searchLabels = _searchLabels;
exports._saveLabel = _saveLabel;
exports._deleteLabel = _deleteLabel;
exports.labelSaga = labelSaga;

var _effects = __webpack_require__(80);

var _isEmpty = __webpack_require__(335);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _labelActions = __webpack_require__(334);

var _labelService = __webpack_require__(579);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(_searchLabels),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(_saveLabel),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(_deleteLabel),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(labelSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function _searchLabels(action) {
    var labels;
    return _regenerator2.default.wrap(function _searchLabels$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_labelService.searchLabels, action.payload);

                case 3:
                    labels = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.LABEL_SEARCH_SUCCESS,
                        payload: labels
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.LABEL_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function _saveLabel(action) {
    var envLabel;
    return _regenerator2.default.wrap(function _saveLabel$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    envLabel = action.payload;
                    _context2.prev = 1;

                    if (!(0, _isEmpty2.default)(envLabel.id)) {
                        _context2.next = 9;
                        break;
                    }

                    _context2.next = 5;
                    return (0, _effects.call)(_labelService.createLabel, envLabel);

                case 5:
                    _context2.next = 7;
                    return (0, _effects.call)(toastr.success, 'Label [' + envLabel.title + '] created');

                case 7:
                    _context2.next = 13;
                    break;

                case 9:
                    _context2.next = 11;
                    return (0, _effects.call)(_labelService.updateLabel, envLabel.id, envLabel);

                case 11:
                    _context2.next = 13;
                    return (0, _effects.call)(toastr.success, 'Label [' + envLabel.title + '] updated');

                case 13:
                    _context2.next = 15;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.SAVE_LABEL_SUCCESS
                    });

                case 15:
                    _context2.next = 21;
                    break;

                case 17:
                    _context2.prev = 17;
                    _context2.t0 = _context2['catch'](1);
                    _context2.next = 21;
                    return (0, _effects.put)({
                        type: _labelActions.actionTypes.SAVE_LABEL_FAILURE
                    });

                case 21:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[1, 17]]);
}

function _deleteLabel(action) {
    var envLabel;
    return _regenerator2.default.wrap(function _deleteLabel$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    envLabel = action.payload;
                    _context3.prev = 1;
                    _context3.next = 4;
                    return (0, _effects.call)(_labelService.deleteLabel, envLabel.id);

                case 4:
                    _context3.next = 6;
                    return (0, _effects.call)(toastr.success, 'Label [' + envLabel.title + '] deleted');

                case 6:
                    _context3.next = 8;
                    return (0, _effects.put)({ type: _labelActions.actionTypes.DELETE_LABEL_SUCCESS });

                case 8:
                    _context3.next = 14;
                    break;

                case 10:
                    _context3.prev = 10;
                    _context3.t0 = _context3['catch'](1);
                    _context3.next = 14;
                    return (0, _effects.put)({ type: _labelActions.actionTypes.DELETE_LABEL_FAILURE });

                case 14:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[1, 10]]);
}

function labelSaga() {
    return _regenerator2.default.wrap(function labelSaga$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_labelActions.actionTypes.SAVE_LABEL, _saveLabel), (0, _effects.takeLatest)(_labelActions.actionTypes.DELETE_LABEL, _deleteLabel), (0, _effects.throttle)(200, [_labelActions.actionTypes.LABEL_SEARCH, _labelActions.actionTypes.SAVE_LABEL_SUCCESS, _labelActions.actionTypes.DELETE_LABEL_SUCCESS], _searchLabels)]);

                case 2:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 2572:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.searchApplications = searchApplications;
exports.goToApplicationCreate = goToApplicationCreate;
exports.goToApplicationEdit = goToApplicationEdit;
exports.deleteApplication = deleteApplication;
exports.applicationListSaga = applicationListSaga;

var _effects = __webpack_require__(80);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _applicationActions = __webpack_require__(278);

var _angularAccessor = __webpack_require__(181);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _applicationService = __webpack_require__(423);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(searchApplications),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(goToApplicationCreate),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(goToApplicationEdit),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(deleteApplication),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(applicationListSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

function searchApplications(action) {
    var applications;
    return _regenerator2.default.wrap(function searchApplications$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_applicationService.searchApp, action.payload);

                case 3:
                    applications = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_SEARCH_SUCCESS,
                        payload: applications
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function goToApplicationCreate() {
    var $state;
    return _regenerator2.default.wrap(function goToApplicationCreate$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.put)({ type: _applicationActions.actionTypes.APPLICATION_FORM_CLEAN });

                case 2:
                    _context2.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context2.sent;
                    _context2.next = 7;
                    return (0, _effects.call)($state.go, 'applicationCreate');

                case 7:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function goToApplicationEdit(action) {
    var $state;
    return _regenerator2.default.wrap(function goToApplicationEdit$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.put)({ type: _applicationActions.actionTypes.APPLICATION_FORM_CLEAN });

                case 2:
                    _context3.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context3.sent;
                    _context3.next = 7;
                    return (0, _effects.call)($state.go, 'applicationCreate', { applicationId: action.payload.id });

                case 7:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function deleteApplication(action) {
    var application;
    return _regenerator2.default.wrap(function deleteApplication$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    application = action.payload;
                    _context4.next = 4;
                    return (0, _effects.call)(_applicationService.deleteApp, application.id);

                case 4:
                    _context4.next = 6;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_DELETE_SUCCESS,
                        payload: action.payload
                    });

                case 6:
                    _context4.next = 8;
                    return (0, _effects.call)(toastr.success, 'Deleted application [' + application.title + ']');

                case 8:
                    _context4.next = 14;
                    break;

                case 10:
                    _context4.prev = 10;
                    _context4.t0 = _context4['catch'](0);
                    _context4.next = 14;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_DELETE_FAILURE
                    });

                case 14:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 10]]);
}

function applicationListSaga() {
    return _regenerator2.default.wrap(function applicationListSaga$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_GOTO_CREATE_PAGE, goToApplicationCreate);

                case 2:
                    _context5.next = 4;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_GOTO_EDIT_PAGE, goToApplicationEdit);

                case 4:
                    _context5.next = 6;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_DELETE_REQUEST, deleteApplication);

                case 6:
                    _context5.next = 8;
                    return (0, _effects.throttle)(200, _applicationActions.actionTypes.APPLICATION_SEARCH_REQUEST, searchApplications);

                case 8:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

/***/ }),

/***/ 2573:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.initApplicationForm = initApplicationForm;
exports.cancelApplicationForm = cancelApplicationForm;
exports.updateApplicationModel = updateApplicationModel;
exports.saveApplication = saveApplication;
exports.addConfirmLeavePopup = addConfirmLeavePopup;
exports.removeConfirmLeavePopup = removeConfirmLeavePopup;
exports.applicationFormSaga = applicationFormSaga;

var _effects = __webpack_require__(80);

var _isEmpty = __webpack_require__(335);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _applicationActions = __webpack_require__(278);

var _applicationService = __webpack_require__(423);

var _angularAccessor = __webpack_require__(181);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

var _environmentService = __webpack_require__(332);

var _stageService = __webpack_require__(333);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(initApplicationForm),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(cancelApplicationForm),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(updateApplicationModel),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(saveApplication),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(addConfirmLeavePopup),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(removeConfirmLeavePopup),
    _marked7 = /*#__PURE__*/_regenerator2.default.mark(applicationFormSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var cleanFormFields = { type: _applicationActions.actionTypes.APPLICATION_FORM_CLEAN };

function initApplicationForm(action) {
    var applicationId, application, environments, stages, applications;
    return _regenerator2.default.wrap(function initApplicationForm$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    applicationId = action.payload;

                    if ((0, _isEmpty2.default)(applicationId)) {
                        _context.next = 8;
                        break;
                    }

                    _context.next = 5;
                    return (0, _effects.call)(_applicationService.getApp, applicationId);

                case 5:
                    application = _context.sent;
                    _context.next = 8;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS,
                        payload: application
                    });

                case 8:
                    _context.next = 10;
                    return (0, _effects.call)(_environmentService.searchEnvironments, '');

                case 10:
                    environments = _context.sent;
                    _context.next = 13;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_ENV_LOAD_SUCCESS,
                        payload: environments
                    });

                case 13:
                    _context.next = 15;
                    return (0, _effects.call)(_stageService.searchStages, '');

                case 15:
                    stages = _context.sent;
                    _context.next = 18;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_STAGE_LOAD_SUCCESS,
                        payload: stages
                    });

                case 18:
                    _context.next = 20;
                    return (0, _effects.call)(_applicationService.searchApp, '');

                case 20:
                    applications = _context.sent;
                    _context.next = 23;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_LIST_LOAD_SUCCESS,
                        payload: applications
                    });

                case 23:
                    _context.next = 29;
                    break;

                case 25:
                    _context.prev = 25;
                    _context.t0 = _context['catch'](0);
                    _context.next = 29;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_FORM_FAILURE
                    });

                case 29:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 25]]);
}

function cancelApplicationForm() {
    var $state;
    return _regenerator2.default.wrap(function cancelApplicationForm$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.next = 2;
                    return (0, _effects.call)(removeConfirmLeavePopup);

                case 2:
                    _context2.next = 4;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 4:
                    $state = _context2.sent;
                    _context2.next = 7;
                    return (0, _effects.call)($state.go, 'applicationList');

                case 7:
                    _context2.next = 9;
                    return (0, _effects.put)(cleanFormFields);

                case 9:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function updateApplicationModel(action) {
    return _regenerator2.default.wrap(function updateApplicationModel$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS,
                        payload: action.payload
                    });

                case 2:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function saveApplication(action) {
    var application, $state;
    return _regenerator2.default.wrap(function saveApplication$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    application = action.payload;

                    application.environmentIds = application.environments.map(function (env) {
                        return env.id;
                    });
                    _context4.next = 5;
                    return (0, _effects.call)(_angularAccessor2.default, '$state');

                case 5:
                    $state = _context4.sent;
                    _context4.next = 8;
                    return (0, _effects.call)(removeConfirmLeavePopup);

                case 8:
                    if (!(0, _isEmpty2.default)(application.id)) {
                        _context4.next = 17;
                        break;
                    }

                    _context4.next = 11;
                    return (0, _effects.call)(_applicationService.createApp, application);

                case 11:
                    _context4.next = 13;
                    return (0, _effects.call)(toastr.success, 'Created application [' + action.payload.title + ']');

                case 13:
                    _context4.next = 15;
                    return (0, _effects.call)($state.go, 'applicationList');

                case 15:
                    _context4.next = 23;
                    break;

                case 17:
                    _context4.next = 19;
                    return (0, _effects.call)(_applicationService.updateApp, application);

                case 19:
                    _context4.next = 21;
                    return (0, _effects.call)(toastr.success, 'Updated application [' + action.payload.title + ']');

                case 21:
                    _context4.next = 23;
                    return (0, _effects.call)($state.go, 'applicationList');

                case 23:
                    _context4.next = 29;
                    break;

                case 25:
                    _context4.prev = 25;
                    _context4.t0 = _context4['catch'](0);
                    _context4.next = 29;
                    return (0, _effects.put)({
                        type: _applicationActions.actionTypes.APPLICATION_SAVE_FAILURE,
                        error: _context4.t0 // for testing purposes
                    });

                case 29:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 25]]);
}

function addConfirmLeavePopup() {
    var confirmLeaveService;
    return _regenerator2.default.wrap(function addConfirmLeavePopup$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'ConfirmLeaveService');

                case 2:
                    confirmLeaveService = _context5.sent;
                    _context5.next = 5;
                    return (0, _effects.call)(confirmLeaveService.requireConfirmation.bind(confirmLeaveService));

                case 5:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

function removeConfirmLeavePopup() {
    var confirmLeaveService;
    return _regenerator2.default.wrap(function removeConfirmLeavePopup$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.next = 2;
                    return (0, _effects.call)(_angularAccessor2.default, 'ConfirmLeaveService');

                case 2:
                    confirmLeaveService = _context6.sent;
                    _context6.next = 5;
                    return (0, _effects.call)(confirmLeaveService.disableConfirmation.bind(confirmLeaveService));

                case 5:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

function applicationFormSaga() {
    return _regenerator2.default.wrap(function applicationFormSaga$(_context7) {
        while (1) {
            switch (_context7.prev = _context7.next) {
                case 0:
                    _context7.next = 2;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_SAVE_REQUEST, saveApplication);

                case 2:
                    _context7.next = 4;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_INIT, initApplicationForm);

                case 4:
                    _context7.next = 6;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_UPDATE_MODEL, updateApplicationModel);

                case 6:
                    _context7.next = 8;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_CANCEL, cancelApplicationForm);

                case 8:
                    _context7.next = 10;
                    return (0, _effects.takeLatest)(_applicationActions.actionTypes.APPLICATION_FORM_PRISTINE, addConfirmLeavePopup);

                case 10:
                case 'end':
                    return _context7.stop();
            }
        }
    }, _marked7, this);
}

/***/ }),

/***/ 2574:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getStateSchedulerFilter = exports.toastr = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.reservationEnvironmentChange = reservationEnvironmentChange;
exports.reserveEnvironment = reserveEnvironment;
exports.cancel = cancel;
exports.deleteEnvironmentReservation = deleteEnvironmentReservation;
exports.initEnvironmentForm = initEnvironmentForm;
exports.scheduleEnvironmentReservationFormSaga = scheduleEnvironmentReservationFormSaga;

var _effects = __webpack_require__(80);

var _moment = __webpack_require__(30);

var _moment2 = _interopRequireDefault(_moment);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(424);

var _lodash = __webpack_require__(79);

var _schedulingService = __webpack_require__(833);

var _schedulingActions = __webpack_require__(243);

var _environmentService = __webpack_require__(332);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(reservationEnvironmentChange),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(reserveEnvironment),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(cancel),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(deleteEnvironmentReservation),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(initEnvironmentForm),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(scheduleEnvironmentReservationFormSaga);

var cleanFormFields = { type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM };

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var getStateSchedulerFilter = exports.getStateSchedulerFilter = function getStateSchedulerFilter(state) {
    return state.scheduling.schedulerFilter;
};

function reservationEnvironmentChange(action) {
    var applications;
    return _regenerator2.default.wrap(function reservationEnvironmentChange$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;

                    if (!(0, _lodash.isEmpty)(action.payload)) {
                        _context.next = 5;
                        break;
                    }

                    _context.t0 = [];
                    _context.next = 8;
                    break;

                case 5:
                    _context.next = 7;
                    return (0, _effects.call)(_environmentService.getDeployableApplicationsForEnvironment, action.payload.id);

                case 7:
                    _context.t0 = _context.sent;

                case 8:
                    applications = _context.t0;
                    _context.next = 11;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
                        payload: applications
                    });

                case 11:
                    _context.next = 17;
                    break;

                case 13:
                    _context.prev = 13;
                    _context.t1 = _context['catch'](0);
                    _context.next = 17;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
                        payload: []
                    });

                case 17:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 13]]);
}

function reserveEnvironment(action) {
    var reservationModel, reservationForm, schedulerFilter;
    return _regenerator2.default.wrap(function reserveEnvironment$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    reservationModel = action.payload;
                    reservationForm = {
                        environmentId: reservationModel.environment.id,
                        applicationIds: reservationModel.applications.map(function (app) {
                            return app.id;
                        }),
                        startDate: (0, _moment2.default)(reservationModel.startDate).valueOf(),
                        endDate: (0, _moment2.default)(reservationModel.endDate).valueOf(),
                        note: (0, _lodash.isEmpty)(reservationModel.note) ? null : reservationModel.note
                    };
                    _context2.prev = 2;

                    if (!(0, _lodash.isEmpty)(reservationModel.id)) {
                        _context2.next = 10;
                        break;
                    }

                    _context2.next = 6;
                    return (0, _effects.call)(_schedulingService.createReservation, reservationForm);

                case 6:
                    _context2.next = 8;
                    return (0, _effects.call)(toastr.success, 'Environment reserved.');

                case 8:
                    _context2.next = 14;
                    break;

                case 10:
                    _context2.next = 12;
                    return (0, _effects.call)(_schedulingService.updateReservation, reservationModel.id, reservationForm);

                case 12:
                    _context2.next = 14;
                    return (0, _effects.call)(toastr.success, 'Environment reservation updated.');

                case 14:
                    _context2.next = 16;
                    return (0, _effects.put)((0, _schedulingActions.showReservationSidebar)(false));

                case 16:
                    _context2.next = 18;
                    return (0, _effects.put)(cleanFormFields);

                case 18:
                    _context2.next = 20;
                    return (0, _effects.select)(getStateSchedulerFilter);

                case 20:
                    schedulerFilter = _context2.sent;
                    _context2.next = 23;
                    return (0, _effects.put)((0, _schedulingActions.onSearchReservations)(schedulerFilter));

                case 23:
                    _context2.next = 29;
                    break;

                case 25:
                    _context2.prev = 25;
                    _context2.t0 = _context2['catch'](2);
                    _context2.next = 29;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE
                    });

                case 29:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[2, 25]]);
}

function cancel() {
    return _regenerator2.default.wrap(function cancel$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.put)((0, _schedulingActions.showReservationSidebar)(false));

                case 2:
                    _context3.next = 4;
                    return (0, _effects.put)(cleanFormFields);

                case 4:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function deleteEnvironmentReservation(action) {
    var schedulerFilter;
    return _regenerator2.default.wrap(function deleteEnvironmentReservation$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    _context4.next = 3;
                    return (0, _effects.call)(_schedulingService.deleteReservation, action.payload);

                case 3:
                    _context4.next = 5;
                    return (0, _effects.call)(toastr.success, 'Reservation deleted.', action.payload);

                case 5:
                    _context4.next = 7;
                    return (0, _effects.put)((0, _schedulingActions.showReservationSidebar)(false));

                case 7:
                    _context4.next = 9;
                    return (0, _effects.put)(cleanFormFields);

                case 9:
                    _context4.next = 11;
                    return (0, _effects.select)(getStateSchedulerFilter);

                case 11:
                    schedulerFilter = _context4.sent;
                    _context4.next = 14;
                    return (0, _effects.put)((0, _schedulingActions.onSearchReservations)(schedulerFilter));

                case 14:
                    _context4.next = 20;
                    break;

                case 16:
                    _context4.prev = 16;
                    _context4.t0 = _context4['catch'](0);
                    _context4.next = 20;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED
                    });

                case 20:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 16]]);
}

function initEnvironmentForm(action) {
    var reservationId, reservation, reservationModel;
    return _regenerator2.default.wrap(function initEnvironmentForm$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    _context5.prev = 0;
                    _context5.next = 3;
                    return (0, _effects.put)(cleanFormFields);

                case 3:
                    reservationId = action.payload;

                    if ((0, _lodash.isEmpty)(reservationId)) {
                        _context5.next = 11;
                        break;
                    }

                    _context5.next = 7;
                    return (0, _effects.call)(_schedulingService.fetchReservation, reservationId);

                case 7:
                    reservation = _context5.sent;
                    reservationModel = {
                        id: reservation.id,
                        environment: {
                            id: reservation.environment.id,
                            title: reservation.environment.title
                        },
                        applications: reservation.applications,
                        startDate: new Date(reservation.startDate),
                        endDate: new Date(reservation.endDate),
                        note: reservation.note
                    };
                    _context5.next = 11;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
                        payload: reservationModel
                    });

                case 11:
                    _context5.next = 17;
                    break;

                case 13:
                    _context5.prev = 13;
                    _context5.t0 = _context5['catch'](0);
                    _context5.next = 17;
                    return (0, _effects.put)({
                        type: _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED
                    });

                case 17:
                case 'end':
                    return _context5.stop();
            }
        }
    }, _marked5, this, [[0, 13]]);
}

function scheduleEnvironmentReservationFormSaga() {
    return _regenerator2.default.wrap(function scheduleEnvironmentReservationFormSaga$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    _context6.next = 2;
                    return (0, _effects.all)([(0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE, reservationEnvironmentChange), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE, reserveEnvironment), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION, deleteEnvironmentReservation), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL, cancel), (0, _effects.takeLatest)(_schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT, initEnvironmentForm)]);

                case 2:
                case 'end':
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

/***/ }),

/***/ 2575:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.searchReservation = searchReservation;
exports.openEnvironmentReservationForm = openEnvironmentReservationForm;
exports.loadApplicationsStagesAndLabels = loadApplicationsStagesAndLabels;
exports.schedulingSaga = schedulingSaga;

var _effects = __webpack_require__(80);

var _lodash = __webpack_require__(79);

var _schedulingActions = __webpack_require__(243);

var _schedulingService = __webpack_require__(833);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(424);

var _applicationService = __webpack_require__(423);

var _stageService = __webpack_require__(333);

var _labelService = __webpack_require__(579);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(searchReservation),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(openEnvironmentReservationForm),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(loadApplicationsStagesAndLabels),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(schedulingSaga);

function searchReservation(action) {
    var environmentReservations;
    return _regenerator2.default.wrap(function searchReservation$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_schedulingService.searchReservations, action.payload);

                case 3:
                    environmentReservations = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SEARCH_SUCCESS,
                        payload: environmentReservations
                    });

                case 6:
                    _context.next = 12;
                    break;

                case 8:
                    _context.prev = 8;
                    _context.t0 = _context['catch'](0);
                    _context.next = 12;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SEARCH_FAILURE
                    });

                case 12:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 8]]);
}

function openEnvironmentReservationForm(action) {
    return _regenerator2.default.wrap(function openEnvironmentReservationForm$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.prev = 0;
                    _context2.next = 3;
                    return (0, _effects.put)((0, _schedulingEnvironmentReservationFormActions.initEnvironmentReservationForm)(action.payload));

                case 3:
                    _context2.next = 5;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
                        payload: true
                    });

                case 5:
                    _context2.next = 11;
                    break;

                case 7:
                    _context2.prev = 7;
                    _context2.t0 = _context2['catch'](0);
                    _context2.next = 11;
                    return (0, _effects.put)({
                        type: _schedulingActions.actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
                        payload: false
                    });

                case 11:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[0, 7]]);
}

function loadApplicationsStagesAndLabels() {
    var applications, stages, labels;
    return _regenerator2.default.wrap(function loadApplicationsStagesAndLabels$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.next = 2;
                    return (0, _effects.call)(_applicationService.searchApp, '');

                case 2:
                    applications = _context3.sent;
                    _context3.next = 5;
                    return (0, _effects.call)(_stageService.searchStages, '');

                case 5:
                    stages = _context3.sent;
                    _context3.next = 8;
                    return (0, _effects.call)(_labelService.searchLabels, '');

                case 8:
                    labels = _context3.sent;
                    _context3.next = 11;
                    return (0, _effects.put)({ type: _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS, payload: { applications: applications, stages: stages, labels: labels } });

                case 11:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function schedulingSaga() {
    return _regenerator2.default.wrap(function schedulingSaga$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.all)([(0, _effects.throttle)(200, _schedulingActions.actionTypes.SCHEDULE_SEARCH_REQUEST, searchReservation), (0, _effects.takeLatest)(_schedulingActions.actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM, openEnvironmentReservationForm), (0, _effects.takeLatest)(_schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_REQUEST, loadApplicationsStagesAndLabels)]);

                case 2:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 2576:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _redux = __webpack_require__(207);

var _environmentFormReducer = __webpack_require__(2577);

var _environmentFormReducer2 = _interopRequireDefault(_environmentFormReducer);

var _environmentListReducer = __webpack_require__(2578);

var _environmentListReducer2 = _interopRequireDefault(_environmentListReducer);

var _stageReducer = __webpack_require__(2579);

var _stageReducer2 = _interopRequireDefault(_stageReducer);

var _labelReducer = __webpack_require__(2580);

var _labelReducer2 = _interopRequireDefault(_labelReducer);

var _schedulingEnvironmentReservationFormReducer = __webpack_require__(2581);

var _schedulingEnvironmentReservationFormReducer2 = _interopRequireDefault(_schedulingEnvironmentReservationFormReducer);

var _schedulingReducer = __webpack_require__(2582);

var _schedulingReducer2 = _interopRequireDefault(_schedulingReducer);

var _applicationListReducer = __webpack_require__(2583);

var _applicationListReducer2 = _interopRequireDefault(_applicationListReducer);

var _applicationFormReducer = __webpack_require__(2584);

var _applicationFormReducer2 = _interopRequireDefault(_applicationFormReducer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _redux.combineReducers)({
    environmentForm: _environmentFormReducer2.default,
    environmentList: _environmentListReducer2.default,
    stages: _stageReducer2.default,
    labels: _labelReducer2.default,
    schedulingEnvironmentReservationForm: _schedulingEnvironmentReservationFormReducer2.default,
    scheduling: _schedulingReducer2.default,
    applicationList: _applicationListReducer2.default,
    applicationForm: _applicationFormReducer2.default
});

/***/ }),

/***/ 2577:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _environmentFormActions = __webpack_require__(418);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    environmentModel: {
        stage: {},
        id: null,
        labels: [],
        title: '',
        description: ''
    },
    environments: [],
    formIsPristine: true,
    formIsValid: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM:
            return (0, _extends3.default)({}, initialState);

        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_VALID_FORM:
            return (0, _extends3.default)({}, state, {
                formIsValid: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM:
            return (0, _extends3.default)({}, state, {
                formIsPristine: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM:
            return (0, _extends3.default)({}, state, {
                environmentModel: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                environmentModel: action.payload
            });

        case _environmentFormActions.actionTypes.ENVIRONMENT_SEARCH_SUCCESS:
            return (0, _extends3.default)({}, state, {
                environments: action.payload
            });

        case _environmentFormActions.actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS:
            var _action$payload = action.payload,
                environment = _action$payload.environment,
                environments = _action$payload.environments;

            return (0, _extends3.default)({}, state, {
                environmentModel: environment || initialState.environmentModel,
                environments: environments
            });

        default:
            return state;
    }
};

/***/ }),

/***/ 2578:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _environmentActions = __webpack_require__(417);

var _utils = __webpack_require__(338);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    list: [],
    filters: {
        title: '',
        stage: {}
    },
    loading: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST:
        case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_REQUEST:
            return (0, _extends3.default)({}, state, {
                loading: true
            });
        case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_SUCCESS:
            {
                var environments = action.payload.sort(_utils.byTitle);
                return (0, _extends3.default)({}, state, {
                    list: environments,
                    loading: false
                });
            }
        case _environmentActions.actionTypes.ENVIRONMENTS_SEARCH_FAILURE:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.ENVIRONMENT_DELETE_REQUEST:
            return (0, _extends3.default)({}, state, {
                loading: true
            });
        case _environmentActions.actionTypes.ENVIRONMENT_DELETE_SUCCESS:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.ENVIRONMENT_DELETE_FAILURE:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
            {
                var _environments = action.payload.environments;

                return (0, _extends3.default)({}, state, {
                    list: _environments.sort(_utils.byTitle),
                    loading: false
                });
            }
        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_FAILURE:
            return (0, _extends3.default)({}, state, {
                loading: false
            });
        case _environmentActions.actionTypes.TITLE_FILTER_CHANGE:
            var title = action.payload;
            return (0, _extends3.default)({}, state, {
                filters: (0, _extends3.default)({}, state.filters, {
                    title: title
                })
            });
        case _environmentActions.actionTypes.STAGE_FILTER_CHANGE:
            var stage = action.payload;
            return (0, _extends3.default)({}, state, {
                filters: (0, _extends3.default)({}, state.filters, {
                    stage: stage
                })
            });
        default:
            return state;
    }
};

/***/ }),

/***/ 2579:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _stageActions = __webpack_require__(419);

var _environmentActions = __webpack_require__(417);

var _schedulingActions = __webpack_require__(243);

var _utils = __webpack_require__(338);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    stageList: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {

        case _stageActions.actionTypes.STAGE_SEARCH_SUCCESS:
            {
                var stages = action.payload.sort(_utils.byTitle);
                return (0, _extends3.default)({}, state, {
                    stageList: stages
                });
            }

        case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
            {
                var _stages = action.payload.stages;

                return (0, _extends3.default)({}, state, {
                    stageList: _stages.sort(_utils.byTitle)
                });
            }

        case _environmentActions.actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
            {
                var _stages2 = action.payload.stages;

                return (0, _extends3.default)({}, state, {
                    stageList: _stages2.sort(_utils.byTitle)
                });
            }
        default:
            return state;
    }
};

/***/ }),

/***/ 2580:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _labelActions = __webpack_require__(334);

var _schedulingActions = __webpack_require__(243);

var _utils = __webpack_require__(338);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = {
    labelList: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _labelActions.actionTypes.LABEL_SEARCH_SUCCESS:
            {
                var labels = action.payload;
                return (0, _extends3.default)({}, state, {
                    labelList: labels.sort(_utils.byTitle)
                });
            }

        case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
            {
                var _labels = action.payload.labels;

                return (0, _extends3.default)({}, state, {
                    labelList: _labels.sort(_utils.byTitle)
                });
            }

        default:
            return state;
    }
};

/***/ }),

/***/ 2581:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(424);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    reservationModel: {
        id: null,
        environment: {},
        applications: [],
        startDate: new Date(),
        endDate: new Date(new Date().getTime() + 1),
        note: ''
    },
    applications: [],
    environments: [],
    reservationFormIsPristine: true,
    reservationFormIsValid: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE:
            return (0, _extends3.default)({}, state, {
                reservationModel: action.payload
            });
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED:
            return (0, _extends3.default)({}, state, {
                applications: action.payload
            });
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM:
            return (0, _extends3.default)({}, initialState);
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM:
            return (0, _extends3.default)({}, state, {
                reservationFormIsValid: action.payload
            });
        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM:
            return (0, _extends3.default)({}, state, {
                reservationFormIsPristine: action.payload
            });

        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE:
            return (0, _extends3.default)({}, state);

        case _schedulingEnvironmentReservationFormActions.actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED:
            return (0, _extends3.default)({}, state, {
                reservationModel: initialState.reservationModel
            });
        default:
            return state;
    }
};

/***/ }),

/***/ 2582:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _moment = __webpack_require__(30);

var _moment2 = _interopRequireDefault(_moment);

var _schedulingActions = __webpack_require__(243);

var _utils = __webpack_require__(338);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    environmentsReservations: [],
    schedulerFilter: {
        environmentTitle: '',
        from: (0, _moment2.default)().startOf('month').valueOf(),
        to: (0, _moment2.default)().endOf('month').valueOf(),
        applications: [],
        stages: [],
        labels: []
    },
    reservationSidebarIsOpen: false
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {
        case _schedulingActions.actionTypes.SCHEDULE_SEARCH_REQUEST:
            return (0, _extends3.default)({}, state, {
                schedulerFilter: action.payload
            });
        case _schedulingActions.actionTypes.SCHEDULE_SEARCH_SUCCESS:
            {
                var environmentsReservations = action.payload;
                return (0, _extends3.default)({}, state, {
                    environmentsReservations: environmentsReservations.sort(_utils.byTitle)
                });
            }
        case _schedulingActions.actionTypes.SCHEDULE_SEARCH_FAILURE:
            return (0, _extends3.default)({}, state);
        case _schedulingActions.actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR:
            return (0, _extends3.default)({}, state, {
                reservationSidebarIsOpen: action.payload
            });
        case _schedulingActions.actionTypes.SCHEDULE_CLEAN_STATE:
            return (0, _extends3.default)({}, initialState);
        default:
            return state;
    }
};

/***/ }),

/***/ 2583:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _applicationActions = __webpack_require__(278);

var _schedulingActions = __webpack_require__(243);

var _utils = __webpack_require__(338);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    applications: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {

        case _applicationActions.actionTypes.APPLICATION_SEARCH_SUCCESS:
            {
                var applications = action.payload.sort(_utils.byTitle);
                return (0, _extends3.default)({}, state, {
                    applications: applications
                });
            }

        case _schedulingActions.actionTypes.SCHEDULE_INIT_HEADER_SUCCESS:
            {
                var _applications = action.payload.applications;

                return (0, _extends3.default)({}, state, {
                    applications: _applications.sort(_utils.byTitle)
                });
            }

        case _applicationActions.actionTypes.APPLICATION_DELETE_SUCCESS:
            {
                return (0, _extends3.default)({}, state, {
                    applications: state.applications.filter(function (app) {
                        return app.id !== action.payload.id;
                    })
                });
            }

        default:
            return state;
    }
};

/***/ }),

/***/ 2584:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initialState = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _applicationActions = __webpack_require__(278);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initialState = exports.initialState = {
    stages: [],
    environments: [],
    application: {
        title: "",
        environments: []
    },
    applications: []
};

exports.default = function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments[1];

    switch (action.type) {

        case _applicationActions.actionTypes.APPLICATION_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                application: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_ENV_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                environments: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_STAGE_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                stages: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_LIST_LOAD_SUCCESS:
            return (0, _extends3.default)({}, state, {
                applications: action.payload
            });

        case _applicationActions.actionTypes.APPLICATION_FORM_CLEAN:
            return (0, _extends3.default)({}, state, {
                application: initialState.application
            });

        default:
            return state;
    }
};

/***/ }),

/***/ 2585:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(97);

var _xlReactComponents = __webpack_require__(69);

var _environmentListHeaderComponent = __webpack_require__(2586);

var _environmentListHeaderComponent2 = _interopRequireDefault(_environmentListHeaderComponent);

var _environmentListComponent = __webpack_require__(2656);

var _environmentListComponent2 = _interopRequireDefault(_environmentListComponent);

var _environmentActions = __webpack_require__(417);

var _environmentSelectors = __webpack_require__(2669);

var _sidebarEnvironmentNavigation = __webpack_require__(431);

var _sidebarEnvironmentNavigation2 = _interopRequireDefault(_sidebarEnvironmentNavigation);

var _types = __webpack_require__(102);

__webpack_require__(433);

var _widgetAlertMessage = __webpack_require__(434);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentListPageContainer = function (_Component) {
    (0, _inherits3.default)(EnvironmentListPageContainer, _Component);
    (0, _createClass3.default)(EnvironmentListPageContainer, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.initEnvironmentList();
        }
    }]);

    function EnvironmentListPageContainer(props) {
        (0, _classCallCheck3.default)(this, EnvironmentListPageContainer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (EnvironmentListPageContainer.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListPageContainer)).call(this, props));

        _this.handleFilterChange = function (environmentName) {
            _this.props.titleFilterChange(environmentName);
        };

        _this.handleStageChange = function (stage) {
            if (stage) {
                _this.props.stageFilterChange(stage);
            }
        };

        _this.buttons = [{
            action: 'cancel',
            className: 'button cancel',
            keyCodes: [27],
            label: 'Cancel'
        }, {
            action: 'ok',
            className: 'button primary',
            keyCodes: [13],
            label: 'Delete'
        }];

        _this.openConfirmationDialog = function (environment) {
            _this.setState({ show: true, environmentForDelete: environment });
        };

        _this.onClose = function (action) {
            if (action === 'ok') {
                _this.props.onDeleteEnvironment(_this.state.environmentForDelete);
            }

            _this.setState({ show: false, environmentForDelete: null });
        };

        _this.state = { show: false, environmentForDelete: null };
        return _this;
    }

    // modal properties


    (0, _createClass3.default)(EnvironmentListPageContainer, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stages = _props.stages,
                filterStage = _props.filterStage,
                filterEnvironmentName = _props.filterEnvironmentName,
                onAddEnvironment = _props.onAddEnvironment,
                environments = _props.environments,
                onEditEnvironment = _props.onEditEnvironment;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_environmentListHeaderComponent2.default, {
                    filterEnvironmentName: filterEnvironmentName,
                    filterStage: filterStage,
                    onAddNewEnvironment: onAddEnvironment,
                    onFilterChange: this.handleFilterChange,
                    onStageChange: this.handleStageChange,
                    stages: stages
                }),
                _react2.default.createElement(
                    _sidebarEnvironmentNavigation2.default,
                    { menuSelected: 'Environments' },
                    _react2.default.createElement(_environmentListComponent2.default, {
                        environments: environments,
                        onDeleteEnvironment: this.openConfirmationDialog,
                        onEditEnvironment: onEditEnvironment })
                ),
                _react2.default.createElement(
                    _xlReactComponents.XlReactWidgetConfirmationDialog,
                    {
                        buttons: this.buttons,
                        dialogClassName: 'xl-default-modal',
                        onButtonClick: this.onClose,
                        show: this.state.show,
                        title: 'Delete environment' },
                    _react2.default.createElement(
                        _widgetAlertMessage.WidgetAlertMessage,
                        { alertType: _widgetAlertMessage.alertType.WARNING },
                        _react2.default.createElement(
                            'p',
                            null,
                            'Deleting an environment can lead to missing data for connected resources on reporting and environment scheduling.'
                        )
                    ),
                    _react2.default.createElement(
                        'p',
                        null,
                        'You are about to delete environment ',
                        _react2.default.createElement(
                            'strong',
                            null,
                            this.state.environmentForDelete ? this.state.environmentForDelete.title : ''
                        ),
                        '.'
                    )
                )
            );
        }
    }]);
    return EnvironmentListPageContainer;
}(_react.Component);

EnvironmentListPageContainer.propTypes = {
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    }).isRequired).isRequired,
    filterEnvironmentName: _propTypes2.default.string.isRequired,
    filterStage: _types.Stage,
    initEnvironmentList: _propTypes2.default.func.isRequired,
    onAddEnvironment: _propTypes2.default.func.isRequired,
    onDeleteEnvironment: _propTypes2.default.func.isRequired,
    onEditEnvironment: _propTypes2.default.func.isRequired,
    searchEnvironments: _propTypes2.default.func.isRequired,
    stageFilterChange: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage),
    titleFilterChange: _propTypes2.default.func.isRequired
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        stages: state.stages.stageList,
        environments: (0, _environmentSelectors.getFilteredEnvironments)(state),
        filterStage: state.environmentList.filters.stage,
        filterEnvironmentName: state.environmentList.filters.title
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    stageFilterChange: _environmentActions.stageFilterChange,
    initEnvironmentList: _environmentActions.initEnvironmentList,
    onAddEnvironment: _environmentActions.onAddEnvironment,
    onDeleteEnvironment: _environmentActions.onDeleteEnvironment,
    onEditEnvironment: _environmentActions.onEditEnvironment,
    searchEnvironments: _environmentActions.searchEnvironments,
    titleFilterChange: _environmentActions.titleFilterChange
})(EnvironmentListPageContainer);

/***/ }),

/***/ 2586:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _includes = __webpack_require__(339);

var _includes2 = _interopRequireDefault(_includes);

var _orderBy = __webpack_require__(583);

var _orderBy2 = _interopRequireDefault(_orderBy);

var _xlReactComponents = __webpack_require__(69);

var _headerComponent = __webpack_require__(244);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

var _types = __webpack_require__(102);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var selectStageMetadata = {
    placeholder: 'Filter by stage...'
};

var EnvironmentListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentListHeaderComponent, _Component);

    function EnvironmentListHeaderComponent() {
        (0, _classCallCheck3.default)(this, EnvironmentListHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListHeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentListHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stages = _props.stages,
                filterStage = _props.filterStage,
                filterEnvironmentName = _props.filterEnvironmentName,
                onAddNewEnvironment = _props.onAddNewEnvironment,
                onStageChange = _props.onStageChange,
                onFilterChange = _props.onFilterChange;

            var filterOptions = { placeholder: 'Filter by environment...' };

            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _orderBy2.default)(stages.filter(function (c) {
                    return (0, _includes2.default)(c.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };
            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, model: filterEnvironmentName, onUpdate: onFilterChange }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        className: 'env-stage-filter',
                        handlers: autocompleteHandlers,
                        metadata: selectStageMetadata,
                        model: filterStage,
                        objLabel: 'title',
                        onModelChange: onStageChange
                    }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: onAddNewEnvironment },
                            'New environment'
                        )
                    )
                )
            );
        }
    }]);
    return EnvironmentListHeaderComponent;
}(_react.Component);

EnvironmentListHeaderComponent.propTypes = {
    filterEnvironmentName: _propTypes2.default.string.isRequired,
    filterStage: _types.Stage,
    onAddNewEnvironment: _propTypes2.default.func.isRequired,
    onFilterChange: _propTypes2.default.func.isRequired,
    onStageChange: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};
exports.default = EnvironmentListHeaderComponent;

/***/ }),

/***/ 2654:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2656:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _environmentListItemComponent = __webpack_require__(2657);

var _environmentListItemComponent2 = _interopRequireDefault(_environmentListItemComponent);

var _noData = __webpack_require__(343);

var _helpBlock = __webpack_require__(280);

__webpack_require__(281);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var helpMessage = 'Use Environments to define environments that are available in your organization. You can also use Environments to filter the environment scheduler and dashboards.';

var EnvironmentListComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentListComponent, _Component);

    function EnvironmentListComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, EnvironmentListComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = EnvironmentListComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListComponent)).call.apply(_ref, [this].concat(args))), _this), _this.renderHeader = function () {
            return _react2.default.createElement(
                'div',
                { className: 'application-list-header' },
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-7' },
                    'Name'
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-2' },
                    'Stage'
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'col-xs-3' },
                    _react2.default.createElement(
                        'span',
                        { className: 'pull-right action-section' },
                        'Actions'
                    )
                )
            );
        }, _this.renderEnvironmentList = function () {
            var _this$props = _this.props,
                environments = _this$props.environments,
                onEditEnvironment = _this$props.onEditEnvironment,
                onDeleteEnvironment = _this$props.onDeleteEnvironment;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _this.renderHeader(),
                environments.map(function (environment) {
                    return _react2.default.createElement(_environmentListItemComponent2.default, { environment: environment, key: environment.title,
                        onDeleteEnvironment: onDeleteEnvironment, onEditEnvironment: onEditEnvironment });
                })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(EnvironmentListComponent, [{
        key: 'render',
        value: function render() {
            var environments = this.props.environments;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title' },
                    'Environments (',
                    environments.length,
                    ')'
                ),
                _react2.default.createElement(
                    _helpBlock.HelpBlock,
                    { className: 'help-message-container' },
                    helpMessage
                ),
                environments.length ? this.renderEnvironmentList() : _react2.default.createElement(_noData.NoData, { message: 'No environments found.' })
            );
        }
    }]);
    return EnvironmentListComponent;
}(_react.Component);

EnvironmentListComponent.propTypes = {
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    }).isRequired).isRequired,
    onDeleteEnvironment: _propTypes2.default.func.isRequired,
    onEditEnvironment: _propTypes2.default.func.isRequired
};
exports.default = EnvironmentListComponent;

/***/ }),

/***/ 2657:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(2);

var _classnames2 = _interopRequireDefault(_classnames);

var _labelItem = __webpack_require__(342);

var _labelItem2 = _interopRequireDefault(_labelItem);

var _types = __webpack_require__(102);

__webpack_require__(2660);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentListItemComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentListItemComponent, _Component);

    function EnvironmentListItemComponent(props) {
        (0, _classCallCheck3.default)(this, EnvironmentListItemComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (EnvironmentListItemComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentListItemComponent)).call(this, props));

        _this.onEditEnvironment = function (event) {
            event.stopPropagation();
            _this.props.onEditEnvironment(_this.props.environment);
        };

        _this.onDeleteEnvironment = function (event) {
            event.stopPropagation();
            _this.props.onDeleteEnvironment(_this.props.environment);
        };

        _this.renderEnvironmentTitle = function () {
            var environment = _this.props.environment;


            return _react2.default.createElement(
                'div',
                { className: 'environment-title-container' },
                _react2.default.createElement(
                    'div',
                    { className: 'col-xs-7 environment-title', title: environment.title },
                    _react2.default.createElement('i', { className: 'xl-icon environment-icon' }),
                    _react2.default.createElement(
                        'strong',
                        null,
                        environment.title
                    )
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-2' },
                    environment.stage.title
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'actions-container col-xs-3' },
                    _react2.default.createElement(
                        'div',
                        { className: 'actions pull-right' },
                        _react2.default.createElement(
                            'span',
                            { className: 'link color-inherited', 'data-test': 'edit-action', onClick: _this.onEditEnvironment },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon edit-icon', title: 'Edit' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Edit'
                            )
                        ),
                        _react2.default.createElement(
                            'span',
                            { className: 'link delete', 'data-test': 'delete-action', onClick: _this.onDeleteEnvironment },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon delete-icon', title: 'Delete' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Delete'
                            )
                        )
                    )
                )
            );
        };

        _this.renderEnvironmentLabels = function () {
            var labels = _this.props.environment.labels;

            if (!labels.length) {
                return null;
            }
            return _react2.default.createElement(
                'div',
                { className: 'environment-labels' },
                labels.map(function (type) {
                    return _react2.default.createElement(_labelItem2.default, { envLabel: type, key: type.id });
                })
            );
        };

        _this.state = { isSelected: false };
        return _this;
    }

    (0, _createClass3.default)(EnvironmentListItemComponent, [{
        key: 'render',
        value: function render() {
            var environment = this.props.environment;
            var isSelected = this.state.isSelected;


            var panelClass = (0, _classnames2.default)('panel', 'panel-default', 'environment-panel', { 'panel-hover': isSelected });

            return _react2.default.createElement(
                'div',
                { className: panelClass, onClick: this.onEditEnvironment },
                this.renderEnvironmentTitle(),
                (environment.description || !!environment.labels.length) && _react2.default.createElement('div', { className: 'environment-title-separator' }),
                environment.description && _react2.default.createElement(
                    'div',
                    { className: 'environment-description' },
                    environment.description
                ),
                this.renderEnvironmentLabels()
            );
        }
    }]);
    return EnvironmentListItemComponent;
}(_react.Component);

EnvironmentListItemComponent.propTypes = {
    environment: _types.Environment.isRequired,
    onDeleteEnvironment: _propTypes2.default.func.isRequired,
    onEditEnvironment: _propTypes2.default.func.isRequired
};
exports.default = EnvironmentListItemComponent;

/***/ }),

/***/ 2658:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 266:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isAtRisk = isAtRisk;
exports.isAttentionNeeded = isAttentionNeeded;
exports.isOnTrack = isOnTrack;
exports.isCompleted = isCompleted;
exports.getRiskStatus = getRiskStatus;
exports.isPlanItemOverdueMessage = isPlanItemOverdueMessage;
exports.getRiskIconClasses = getRiskIconClasses;

var _releasesStatusService = __webpack_require__(196);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

var _constants = __webpack_require__(224);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function isAtRisk(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore >= riskThresholds.atRiskFrom;
}

function isAttentionNeeded(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore >= riskThresholds.attentionNeededFrom && riskScore < riskThresholds.atRiskFrom;
}

function isOnTrack(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore < riskThresholds.attentionNeededFrom;
}

function isCompleted(release) {
    return (0, _releasesStatusService2.default)().hasCompletedStatus(release) || (0, _releasesStatusService2.default)().isReleaseAborted(release);
}

function getRiskStatus(release, riskScore, riskThresholds) {
    if (isAtRisk(release, riskScore, riskThresholds)) {
        return _constants.AT_RISK;
    } else if (isAttentionNeeded(release, riskScore, riskThresholds)) {
        return _constants.ATTENTION_NEEDED;
    } else if (isOnTrack(release, riskScore, riskThresholds)) {
        return _constants.ON_TRACK;
    }
    return _constants.NONE;
}

function isPlanItemOverdueMessage(message) {
    var riskAssessorId = message.riskAssessorId;

    return riskAssessorId && (riskAssessorId === 'Applications/ReleaseDueDateRiskAssessor' || riskAssessorId === 'Applications/TaskDueDateRiskAssessor');
}

function getRiskIconClasses(riskAssessor) {
    if (!riskAssessor.riskAssessorId) {
        return _constants.RISK_ON_TRACK_ICON;
    }

    var id = (0, _ids2.default)().toInternalId(riskAssessor.riskAssessorId).replace('RiskAssessor', '');

    return _constants.RISK_ASSESSOR_ICONS[id];
}

/***/ }),

/***/ 2660:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2662:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2663);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NoData = function NoData(_ref) {
    var className = _ref.className,
        message = _ref.message;
    return _react2.default.createElement(
        'div',
        { className: 'no-data-message' + (className ? ' ' + className : '') },
        message
    );
};

NoData.propTypes = {
    className: _propTypes2.default.string,
    message: _propTypes2.default.string.isRequired
};

exports.default = NoData;

/***/ }),

/***/ 2663:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2665:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2666);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HelpBlock = function HelpBlock(_ref) {
    var className = _ref.className,
        children = _ref.children;
    return _react2.default.createElement(
        'div',
        { className: 'help-block-component ' + className },
        children
    );
};

HelpBlock.propTypes = {
    children: _propTypes2.default.string.isRequired,
    className: _propTypes2.default.string
};

HelpBlock.defaultProps = {
    className: ''
};

exports.default = HelpBlock;

/***/ }),

/***/ 2666:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2669:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getFilteredEnvironments = undefined;

var _reselect = __webpack_require__(781);

var getEnvironments = function getEnvironments(state) {
    return state.environmentList.list;
};
var getEnvironmentFilters = function getEnvironmentFilters(state) {
    return state.environmentList.filters;
};

var getFilteredEnvironments = exports.getFilteredEnvironments = (0, _reselect.createSelector)([getEnvironments, getEnvironmentFilters], function (environments, filters) {
    var title = filters.title,
        stage = filters.stage;

    return environments.filter(function (env) {
        return env.title.toUpperCase().indexOf(title.toUpperCase()) >= 0 && (!stage.title || env.stage.title.toUpperCase() === stage.title.toUpperCase());
    });
});

/***/ }),

/***/ 2674:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2677:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _environmentManagementStore = __webpack_require__(240);

var _environmentEditPageContainer = __webpack_require__(2678);

var _environmentEditPageContainer2 = _interopRequireDefault(_environmentEditPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentEditPage = function (_Component) {
    (0, _inherits3.default)(EnvironmentEditPage, _Component);

    function EnvironmentEditPage() {
        (0, _classCallCheck3.default)(this, EnvironmentEditPage);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentEditPage.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentEditPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentEditPage, [{
        key: 'render',
        value: function render() {
            var environmentId = this.props.environmentId;

            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_environmentEditPageContainer2.default, { environmentId: environmentId })
            );
        }
    }]);
    return EnvironmentEditPage;
}(_react.Component);

EnvironmentEditPage.propTypes = {
    environmentId: _propTypes2.default.string
};
exports.default = EnvironmentEditPage;

/***/ }),

/***/ 2678:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(97);

var _environmentFormActions = __webpack_require__(418);

var _environmentFormContainer = __webpack_require__(2679);

var _environmentFormContainer2 = _interopRequireDefault(_environmentFormContainer);

var _environmentEditHeaderComponent = __webpack_require__(2960);

var _environmentEditHeaderComponent2 = _interopRequireDefault(_environmentEditHeaderComponent);

var _sidebarEnvironmentNavigation = __webpack_require__(431);

var _sidebarEnvironmentNavigation2 = _interopRequireDefault(_sidebarEnvironmentNavigation);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentEditPageContainer = function (_Component) {
    (0, _inherits3.default)(EnvironmentEditPageContainer, _Component);

    function EnvironmentEditPageContainer() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, EnvironmentEditPageContainer);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = EnvironmentEditPageContainer.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentEditPageContainer)).call.apply(_ref, [this].concat(args))), _this), _this.onSave = function () {
            var _this$props = _this.props,
                environmentModel = _this$props.environmentModel,
                onFormSave = _this$props.onFormSave;

            onFormSave(environmentModel);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(EnvironmentEditPageContainer, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                formIsPristine = _props.formIsPristine,
                formIsValid = _props.formIsValid,
                environmentId = _props.environmentId,
                onFormCancel = _props.onFormCancel;

            var saveEnabled = !formIsPristine && formIsValid;
            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_environmentEditHeaderComponent2.default, {
                    environmentId: environmentId,
                    onCancel: onFormCancel,
                    onSave: this.onSave,
                    saveEnabled: saveEnabled }),
                _react2.default.createElement(
                    _sidebarEnvironmentNavigation2.default,
                    { menuSelected: 'Environments' },
                    _react2.default.createElement(_environmentFormContainer2.default, {
                        environmentId: environmentId })
                )
            );
        }
    }]);
    return EnvironmentEditPageContainer;
}(_react.Component);

EnvironmentEditPageContainer.propTypes = {
    environmentId: _propTypes2.default.string,
    environmentModel: _propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string.isRequired
    }).isRequired,
    formIsPristine: _propTypes2.default.bool.isRequired,
    formIsValid: _propTypes2.default.bool.isRequired,
    onFormCancel: _propTypes2.default.func.isRequired,
    onFormSave: _propTypes2.default.func.isRequired
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        environmentModel: state.environmentForm.environmentModel,
        formIsValid: state.environmentForm.formIsValid,
        formIsPristine: state.environmentForm.formIsPristine
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    onFormCancel: _environmentFormActions.onFormCancel,
    onFormSave: _environmentFormActions.onFormSave
})(EnvironmentEditPageContainer);

/***/ }),

/***/ 2679:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(97);

var _environmentFormActions = __webpack_require__(418);

var _labelActions = __webpack_require__(334);

var _environmentFormComponent = __webpack_require__(2680);

var _environmentFormComponent2 = _interopRequireDefault(_environmentFormComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentFormContainer = function (_Component) {
    (0, _inherits3.default)(EnvironmentFormContainer, _Component);

    function EnvironmentFormContainer() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, EnvironmentFormContainer);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = EnvironmentFormContainer.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentFormContainer)).call.apply(_ref, [this].concat(args))), _this), _this.handleFormChange = function (environment) {
            var onFormChange = _this.props.onFormChange;

            onFormChange(environment);
        }, _this.handleFormPristineChange = function (pristine) {
            var onFormPristineChange = _this.props.onFormPristineChange;

            onFormPristineChange(pristine);
        }, _this.handleFormValidChange = function (valid) {
            var onFormValidChange = _this.props.onFormValidChange;

            onFormValidChange(valid);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(EnvironmentFormContainer, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var initEnvironmentForm = this.props.initEnvironmentForm;

            initEnvironmentForm();
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            var cleanEnvironment = this.props.cleanEnvironment;

            cleanEnvironment();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                stageList = _props.stageList,
                environments = _props.environments,
                environmentModel = _props.environmentModel,
                saveLabel = _props.saveLabel,
                labelList = _props.labelList;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_environmentFormComponent2.default, {
                    environmentModel: environmentModel,
                    environments: environments,
                    labelList: labelList,
                    onFormChange: this.handleFormChange,
                    onPristinityChange: this.handleFormPristineChange,
                    onValidationChange: this.handleFormValidChange,
                    saveLabel: saveLabel,
                    stageList: stageList
                })
            );
        }
    }]);
    return EnvironmentFormContainer;
}(_react.Component);

EnvironmentFormContainer.propTypes = {
    cleanEnvironment: _propTypes2.default.func.isRequired,
    environmentId: _propTypes2.default.string,
    environmentModel: _propTypes2.default.shape({
        stage: _propTypes2.default.shape({
            id: _propTypes2.default.string,
            title: _propTypes2.default.string
        }),
        id: _propTypes2.default.string,
        labels: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            color: _propTypes2.default.string.isRequired,
            id: _propTypes2.default.string.isRequired,
            title: _propTypes2.default.string.isRequired
        })),
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string.isRequired
    }).isRequired,
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    })).isRequired,
    initEnvironmentForm: _propTypes2.default.func.isRequired,
    labelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    onFormChange: _propTypes2.default.func.isRequired,
    onFormPristineChange: _propTypes2.default.func.isRequired,
    onFormValidChange: _propTypes2.default.func.isRequired,
    saveLabel: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    })).isRequired
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        environmentModel: state.environmentForm.environmentModel,
        environments: state.environmentForm.environments,
        stageList: state.stages.stageList,
        labelList: state.labels.labelList
    };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
    return (0, _extends3.default)({}, ownProps, stateProps, dispatchProps, {
        initEnvironmentForm: function initEnvironmentForm() {
            return dispatchProps.initEnvironmentForm(ownProps.environmentId, ownProps.environments);
        }
    });
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    cleanEnvironment: _environmentFormActions.cleanEnvironment,
    initEnvironmentForm: _environmentFormActions.initEnvironmentForm,
    onFormChange: _environmentFormActions.onFormChange,
    onFormPristineChange: _environmentFormActions.onFormPristineChange,
    onFormValidChange: _environmentFormActions.onFormValidChange,
    saveLabel: _labelActions.saveLabel
}, mergeProps)(EnvironmentFormContainer);

/***/ }),

/***/ 2680:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactSidebar = __webpack_require__(432);

var _reactSidebar2 = _interopRequireDefault(_reactSidebar);

var _includes = __webpack_require__(339);

var _includes2 = _interopRequireDefault(_includes);

var _orderBy = __webpack_require__(583);

var _orderBy2 = _interopRequireDefault(_orderBy);

var _xlReactComponents = __webpack_require__(69);

var _lodash = __webpack_require__(79);

var _validators = __webpack_require__(344);

var _sidebarLabelList = __webpack_require__(2682);

var _sidebarLabelList2 = _interopRequireDefault(_sidebarLabelList);

var _widgetLinkedLabels = __webpack_require__(2955);

var _widgetLinkedLabels2 = _interopRequireDefault(_widgetLinkedLabels);

__webpack_require__(281);

__webpack_require__(2958);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var nameFormMetadata = {
    label: 'Name',
    placeholder: 'Add...',
    description: 'Name of the environment',
    required: true
};
var descriptionFormMetadata = {
    label: 'Description',
    placeholder: 'Set description...',
    description: 'Description of the environment',
    size: 'MEDIUM'
};

var selectFormMetadata = {
    description: 'Name of the stage',
    label: 'Stage',
    placeholder: 'Select stage...',
    required: true
};

var findEnvironmentById = function findEnvironmentById(environments, id) {
    return environments.find(function (e) {
        return e.id === id;
    }) || {};
};

var nameValidator = function nameValidator(environments, selectedId) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(environments, selectedId, 'title', name),
            message: (0, _validators.createErrorMessage)('Environment already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var EnvironmentFormComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentFormComponent, _Component);

    function EnvironmentFormComponent(props) {
        (0, _classCallCheck3.default)(this, EnvironmentFormComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (EnvironmentFormComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentFormComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
        };

        _this.onNameChange = function (title) {
            var _this$props = _this.props,
                environmentModel = _this$props.environmentModel,
                onFormChange = _this$props.onFormChange;

            if (title !== environmentModel.title) {
                onFormChange((0, _extends3.default)({}, environmentModel, {
                    title: title
                }));
            }
        };

        _this.onStageChange = function (stage) {
            var _this$props2 = _this.props,
                environmentModel = _this$props2.environmentModel,
                onFormChange = _this$props2.onFormChange;

            if (stage && stage.id !== environmentModel.stage.id) {
                onFormChange((0, _extends3.default)({}, environmentModel, {
                    stage: stage
                }));
            }
        };

        _this.onDescriptionChange = function (description) {
            var _this$props3 = _this.props,
                environmentModel = _this$props3.environmentModel,
                onFormChange = _this$props3.onFormChange;

            if (description !== environmentModel.description) {
                onFormChange((0, _extends3.default)({}, environmentModel, {
                    description: description
                }));
            }
        };

        _this.onAddLabel = function (envLabel) {
            var environmentModel = _this.props.environmentModel;

            var labels = (0, _lodash.clone)(environmentModel.labels);

            if ((0, _lodash.isUndefined)((0, _lodash.find)(environmentModel.labels, function (currentEnvLabel) {
                return currentEnvLabel.id === envLabel.id;
            }))) {
                labels.push(envLabel);
            }

            _this.props.onFormChange((0, _extends3.default)({}, environmentModel, {
                labels: labels
            }));
            _this.props.onPristinityChange(false);
        };

        _this.onRemoveLabel = function (envLabel) {
            var environmentModel = _this.props.environmentModel;

            var labels = (0, _lodash.filter)(environmentModel.labels, function (currentLabelType) {
                return currentLabelType.id !== envLabel.id;
            });

            _this.props.onFormChange((0, _extends3.default)({}, environmentModel, {
                labels: labels
            }));
            _this.props.onPristinityChange(false);
        };

        _this.onNameValidityChange = function (valid) {
            var onValidationChange = _this.props.onValidationChange;


            _this.isNameValid = valid;
            onValidationChange(_this.isFormValid);
        };

        _this.onStageValidityChange = function (valid) {
            var onValidationChange = _this.props.onValidationChange;


            _this.isStageValid = valid;
            onValidationChange(_this.isFormValid);
        };

        _this.onNamePristine = function (pristine) {
            _this.setState({ namePristine: pristine });
            var _this$state = _this.state,
                descriptionPristine = _this$state.descriptionPristine,
                stagePristine = _this$state.stagePristine;

            var isFormPristine = pristine && descriptionPristine && stagePristine;
            _this.props.onPristinityChange(isFormPristine);
        };

        _this.onDescPristine = function (pristine) {
            _this.setState({ descriptionPristine: pristine });
            var _this$state2 = _this.state,
                namePristine = _this$state2.namePristine,
                stagePristine = _this$state2.stagePristine;

            var isFormPristine = pristine && namePristine && stagePristine;
            _this.props.onPristinityChange(isFormPristine);
        };

        _this.onStagePristine = function (pristine) {
            _this.setState({ stagePristine: pristine });
            var _this$state3 = _this.state,
                namePristine = _this$state3.namePristine,
                descriptionPristine = _this$state3.descriptionPristine;

            var isFormPristine = pristine && namePristine && descriptionPristine;
            _this.props.onPristinityChange(isFormPristine);
        };

        _this.renderSidebarContent = function () {
            var _this$props4 = _this.props,
                environmentModel = _this$props4.environmentModel,
                labelList = _this$props4.labelList,
                saveLabel = _this$props4.saveLabel;

            var filteredLabelList = (0, _lodash.differenceWith)(labelList, environmentModel.labels, _lodash.isEqual);

            return _react2.default.createElement(_sidebarLabelList2.default, {
                labelList: filteredLabelList,
                onClickLabel: _this.onAddLabel,
                saveLabel: saveLabel
            });
        };

        _this.state = {
            namePristine: true,
            descriptionPristine: true,
            stagePristine: true
        };

        _this.isNameValid = false;
        _this.isStageValid = false;
        return _this;
    }

    (0, _createClass3.default)(EnvironmentFormComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                environmentModel = _props.environmentModel,
                environments = _props.environments,
                stageList = _props.stageList;

            var env = findEnvironmentById(environments, environmentModel.id);
            var subtitle = (0, _lodash.isEmpty)(env) ? 'New Environment' : env.title;

            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _orderBy2.default)(stageList.filter(function (c) {
                    return (0, _includes2.default)(c.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };

            return _react2.default.createElement(
                _reactSidebar2.default,
                {
                    contentClassName: 'environment-form-content',
                    docked: true,
                    open: true,
                    pullRight: true,
                    shadow: false,
                    sidebar: this.renderSidebarContent(),
                    sidebarClassName: 'environment-form-sidebar',
                    transitions: false },
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title', id: 'environment-form-title' },
                    'Environments / ',
                    subtitle
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'environment-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: nameFormMetadata,
                        model: environmentModel.title,
                        onModelChange: this.onNameChange,
                        onPristinityChange: this.onNamePristine,
                        onValidityChange: this.onNameValidityChange,
                        register: this.onRegister,
                        validators: [nameValidator(environments, environmentModel.id), maxLengthValidator(nameFormMetadata.label, 255)]
                    }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: autocompleteHandlers,
                        metadata: selectFormMetadata,
                        model: environmentModel.stage,
                        objLabel: 'title',
                        onModelChange: this.onStageChange,
                        onPristinityChange: this.onStagePristine,
                        onValidityChange: this.onStageValidityChange
                    }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: descriptionFormMetadata,
                        model: environmentModel.description,
                        onModelChange: this.onDescriptionChange,
                        onPristinityChange: this.onDescPristine,
                        validators: [maxLengthValidator(descriptionFormMetadata.label, 1024)]
                    }),
                    _react2.default.createElement(_widgetLinkedLabels2.default, {
                        labelList: environmentModel.labels,
                        onDelete: this.onRemoveLabel
                    })
                )
            );
        }
    }, {
        key: 'isFormValid',
        get: function get() {
            return this.isNameValid && this.isStageValid;
        }
    }]);
    return EnvironmentFormComponent;
}(_react.Component);

EnvironmentFormComponent.propTypes = {
    environmentModel: _propTypes2.default.shape({
        stage: _propTypes2.default.shape({
            id: _propTypes2.default.string,
            title: _propTypes2.default.string
        }),
        description: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string,
        labels: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            color: _propTypes2.default.string.isRequired,
            id: _propTypes2.default.string.isRequired,
            title: _propTypes2.default.string.isRequired
        }))
    }).isRequired,
    environments: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string,
        title: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string
    })).isRequired,
    labelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    onFormChange: _propTypes2.default.func.isRequired,
    onPristinityChange: _propTypes2.default.func.isRequired,
    onValidationChange: _propTypes2.default.func.isRequired,
    saveLabel: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    })).isRequired
};
exports.default = EnvironmentFormComponent;

/***/ }),

/***/ 2682:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _includes = __webpack_require__(339);

var _includes2 = _interopRequireDefault(_includes);

var _labelItem = __webpack_require__(342);

var _labelItem2 = _interopRequireDefault(_labelItem);

var _labelModalFormComponent = __webpack_require__(849);

var _labelModalFormComponent2 = _interopRequireDefault(_labelModalFormComponent);

var _labelListComponent = __webpack_require__(901);

__webpack_require__(2953);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var filterLabelFieldMetadata = { placeholder: 'Filter by label...' };

var SidebarLabelList = function (_Component) {
    (0, _inherits3.default)(SidebarLabelList, _Component);

    function SidebarLabelList(props) {
        (0, _classCallCheck3.default)(this, SidebarLabelList);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SidebarLabelList.__proto__ || (0, _getPrototypeOf2.default)(SidebarLabelList)).call(this, props));

        _this.onNameChange = function (name) {
            _this.setState({ labelFilterText: name });
        };

        _this.filterLabels = function (envLabel) {
            var labelFilterText = _this.state.labelFilterText;

            return (0, _includes2.default)(envLabel.title.toLowerCase(), labelFilterText.toLowerCase());
        };

        _this.showCreateLabelModal = function () {
            _this.setState({
                modalIsOpen: true,
                envLabel: (0, _labelListComponent.initEnvLabelState)()
            });
        };

        _this.onConfirmEditModal = function (envLabel, isCreateAnother) {
            _this.props.saveLabel({ title: envLabel.title, color: envLabel.color });

            _this.setState({
                modalIsOpen: isCreateAnother,
                envLabel: (0, _labelListComponent.initEnvLabelState)()
            });
        };

        _this.onCancelEditModal = function () {
            _this.setState({
                modalIsOpen: false,
                envLabel: (0, _labelListComponent.initEnvLabelState)()
            });
        };

        _this.renderLabels = function () {
            var _this$props = _this.props,
                labelList = _this$props.labelList,
                onClickLabel = _this$props.onClickLabel;

            return labelList.filter(function (envLabel) {
                return _this.filterLabels(envLabel);
            }).map(function (envLabel) {
                return _react2.default.createElement(
                    'div',
                    { className: 'truncate-sidebar-label', key: envLabel.id },
                    _react2.default.createElement(_labelItem2.default, {
                        envLabel: envLabel,
                        onClickLabel: onClickLabel,
                        skin: 'plus'
                    })
                );
            });
        };

        _this.state = {
            envLabel: (0, _labelListComponent.initEnvLabelState)(),
            modalIsOpen: false,
            labelFilterText: ''
        };
        return _this;
    }

    (0, _createClass3.default)(SidebarLabelList, [{
        key: 'render',
        value: function render() {
            var labelList = this.props.labelList;
            var _state = this.state,
                envLabel = _state.envLabel,
                modalIsOpen = _state.modalIsOpen;


            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(
                    'div',
                    { className: 'environment-label-sidebar' },
                    _react2.default.createElement(
                        'div',
                        { className: 'header' },
                        _react2.default.createElement(
                            'h4',
                            { className: 'page-title' },
                            'Labels',
                            _react2.default.createElement(
                                'button',
                                { className: 'button pull-right', onClick: this.showCreateLabelModal, type: 'button' },
                                'New label'
                            )
                        ),
                        _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterLabelFieldMetadata, onUpdate: this.onNameChange })
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'environment-sidebar-label-list' },
                        this.renderLabels()
                    )
                ),
                _react2.default.createElement(_labelModalFormComponent2.default, {
                    envLabelList: labelList,
                    envLabelModel: envLabel,
                    modalIsOpen: modalIsOpen,
                    onModalCancel: this.onCancelEditModal,
                    onModalConfirm: this.onConfirmEditModal })
            );
        }
    }]);
    return SidebarLabelList;
}(_react.Component);

SidebarLabelList.propTypes = {
    labelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    onClickLabel: _propTypes2.default.func.isRequired,
    saveLabel: _propTypes2.default.func.isRequired
};
SidebarLabelList.defaultProps = {
    labelList: {}
};
exports.default = SidebarLabelList;

/***/ }),

/***/ 278:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    APPLICATION_SEARCH_REQUEST: 'envMgmt/APPLICATION_SEARCH_REQUEST',
    APPLICATION_SEARCH_SUCCESS: 'envMgmt/APPLICATION_SEARCH_SUCCESS',
    APPLICATION_SEARCH_FAILURE: 'envMgmt/APPLICATION_SEARCH_FAILURE',

    APPLICATION_GOTO_CREATE_PAGE: 'envMgmt/APPLICATION_GOTO_CREATE_PAGE',
    APPLICATION_GOTO_EDIT_PAGE: 'envMgmt/APPLICATION_GOTO_EDIT_PAGE',

    APPLICATION_DELETE_REQUEST: 'envMgmt/APPLICATION_DELETE_REQUEST',
    APPLICATION_DELETE_SUCCESS: 'envMgmt/APPLICATION_DELETE_SUCCESS',
    APPLICATION_DELETE_FAILURE: 'envMgmt/APPLICATION_DELETE_FAILURE',

    APPLICATION_FORM_CANCEL: 'envMgmt/APPLICATION_FORM_CANCEL',
    APPLICATION_FORM_CLEAN: 'envMgmt/APPLICATION_FORM_CLEAN',
    APPLICATION_FORM_INIT: 'envMgmt/APPLICATION_FORM_INIT',
    APPLICATION_FORM_FAILURE: 'envMgmt/APPLICATION_FORM_FAILURE',
    APPLICATION_LOAD_REQUEST: 'envMgmt/APPLICATION_LOAD_REQUEST',
    APPLICATION_LOAD_SUCCESS: 'envMgmt/APPLICATION_LOAD_SUCCESS',
    APPLICATION_ENV_LOAD_SUCCESS: 'envMgmt/APPLICATION_ENV_LOAD_SUCCESS',
    APPLICATION_STAGE_LOAD_SUCCESS: 'envMgmt/APPLICATION_STAGE_LOAD_SUCCESS',
    APPLICATION_LIST_LOAD_SUCCESS: 'envMgmt/APPLICATION_LIST_LOAD_SUCCESS',

    APPLICATION_FORM_UPDATE_MODEL: 'envMgmt/APPLICATION_FORM_UPDATE_MODEL',
    APPLICATION_FORM_PRISTINE: 'envMgmt/APPLICATION_FORM_PRISTINE',

    APPLICATION_SAVE_REQUEST: 'envMgmt/APPLICATION_SAVE_REQUEST',
    APPLICATION_SAVE_FAILURE: 'envMgmt/APPLICATION_SAVE_FAILURE'
};

var applicationList = exports.applicationList = {
    searchApplications: function searchApplications(applicationName) {
        return { type: actionTypes.APPLICATION_SEARCH_REQUEST, payload: applicationName };
    },
    goToCreatePage: function goToCreatePage() {
        return { type: actionTypes.APPLICATION_GOTO_CREATE_PAGE };
    },
    goToEditPage: function goToEditPage(application) {
        return { type: actionTypes.APPLICATION_GOTO_EDIT_PAGE, payload: application };
    },
    deleteApplication: function deleteApplication(application) {
        return { type: actionTypes.APPLICATION_DELETE_REQUEST, payload: application };
    }
};

var applicationForm = exports.applicationForm = {
    initForm: function initForm(applicationId) {
        return { type: actionTypes.APPLICATION_FORM_INIT, payload: applicationId };
    },
    cancelForm: function cancelForm() {
        return { type: actionTypes.APPLICATION_FORM_CANCEL };
    },
    saveApplication: function saveApplication(application) {
        return { type: actionTypes.APPLICATION_SAVE_REQUEST, payload: application };
    },
    updateModel: function updateModel(application) {
        return { type: actionTypes.APPLICATION_FORM_UPDATE_MODEL, payload: application };
    },
    pristineFormChange: function pristineFormChange(pristine) {
        return { type: actionTypes.APPLICATION_FORM_PRISTINE, payload: pristine };
    }
};

/***/ }),

/***/ 280:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _helpBlock = __webpack_require__(2665);

Object.defineProperty(exports, 'HelpBlock', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_helpBlock).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 281:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2952:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _headerComponent = __webpack_require__(244);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

var _xlReactComponents = __webpack_require__(69);

var _reactColor = __webpack_require__(850);

__webpack_require__(433);

__webpack_require__(900);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LabelListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(LabelListHeaderComponent, _Component);

    function LabelListHeaderComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, LabelListHeaderComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = LabelListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(LabelListHeaderComponent)).call.apply(_ref, [this].concat(args))), _this), _this.showCreateModal = function () {
            _this.props.onCreate();
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(LabelListHeaderComponent, [{
        key: 'render',
        value: function render() {
            var onFilterChange = this.props.onFilterChange;

            var filterFieldMetadata = { placeholder: 'Filter by label...' };

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterFieldMetadata, onUpdate: onFilterChange }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: this.showCreateModal },
                            'New label'
                        )
                    )
                )
            );
        }
    }]);
    return LabelListHeaderComponent;
}(_react.Component);

LabelListHeaderComponent.propTypes = {
    onCreate: _propTypes2.default.func.isRequired,
    onFilterChange: _propTypes2.default.func.isRequired
};
exports.default = LabelListHeaderComponent;

/***/ }),

/***/ 2953:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2955:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _types = __webpack_require__(102);

var _labelItem = __webpack_require__(342);

var _labelItem2 = _interopRequireDefault(_labelItem);

var _helpBlock = __webpack_require__(280);

__webpack_require__(2956);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var labelsFiledMetadata = {
    label: 'Labels',
    required: false
};

var WidgetLinkedLabels = function (_Component) {
    (0, _inherits3.default)(WidgetLinkedLabels, _Component);

    function WidgetLinkedLabels() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, WidgetLinkedLabels);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = WidgetLinkedLabels.__proto__ || (0, _getPrototypeOf2.default)(WidgetLinkedLabels)).call.apply(_ref, [this].concat(args))), _this), _this.renderEmptyContainer = function () {
            return _react2.default.createElement(
                _helpBlock.HelpBlock,
                null,
                'Click a label on the right to assign it to the environment'
            );
        }, _this.renderContainer = function (labelList) {
            var onDelete = _this.props.onDelete;


            return _react2.default.createElement(
                'div',
                { className: 'list-block-label-title' },
                labelList.map(function (envLabel) {
                    return _react2.default.createElement(_labelItem2.default, {
                        envLabel: envLabel,
                        key: envLabel.id,
                        onClickLabel: onDelete,
                        skin: 'remove' });
                })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(WidgetLinkedLabels, [{
        key: 'render',
        value: function render() {
            var labelList = this.props.labelList;


            return _react2.default.createElement(
                'div',
                { className: 'xl-react-components' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: labelsFiledMetadata }),
                _react2.default.createElement(
                    'div',
                    { className: 'xl-react-components-input' },
                    labelList.length ? this.renderContainer(labelList) : this.renderEmptyContainer()
                )
            );
        }
    }]);
    return WidgetLinkedLabels;
}(_react.Component);

WidgetLinkedLabels.propTypes = {
    labelList: _propTypes2.default.arrayOf(_types.Label).isRequired,
    onDelete: _propTypes2.default.func.isRequired
};
WidgetLinkedLabels.defaultProps = {
    labelList: []
};
exports.default = WidgetLinkedLabels;

/***/ }),

/***/ 2956:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2958:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2960:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _isEmpty = __webpack_require__(335);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _headerComponent = __webpack_require__(244);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentEditHeaderComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentEditHeaderComponent, _Component);

    function EnvironmentEditHeaderComponent() {
        (0, _classCallCheck3.default)(this, EnvironmentEditHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentEditHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentEditHeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentEditHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                onCancel = _props.onCancel,
                onSave = _props.onSave,
                saveEnabled = _props.saveEnabled,
                environmentId = _props.environmentId;

            var caption = (0, _isEmpty2.default)(environmentId) ? 'Create' : 'Save';
            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    'div',
                    { className: 'buttons' },
                    _react2.default.createElement(
                        'button',
                        { className: 'button cancel', onClick: onCancel },
                        'Cancel'
                    ),
                    _react2.default.createElement(
                        'button',
                        { className: 'button primary', disabled: !saveEnabled, onClick: onSave },
                        caption
                    )
                )
            );
        }
    }]);
    return EnvironmentEditHeaderComponent;
}(_react.Component);

EnvironmentEditHeaderComponent.propTypes = {
    environmentId: _propTypes2.default.string,
    onCancel: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    saveEnabled: _propTypes2.default.bool.isRequired
};
exports.default = EnvironmentEditHeaderComponent;

/***/ }),

/***/ 2961:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _environmentManagementStore = __webpack_require__(240);

var _applicationListPageContainer = __webpack_require__(2962);

var _applicationListPageContainer2 = _interopRequireDefault(_applicationListPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationListPage = function (_Component) {
    (0, _inherits3.default)(ApplicationListPage, _Component);

    function ApplicationListPage() {
        (0, _classCallCheck3.default)(this, ApplicationListPage);
        return (0, _possibleConstructorReturn3.default)(this, (ApplicationListPage.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(ApplicationListPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_applicationListPageContainer2.default, null)
            );
        }
    }]);
    return ApplicationListPage;
}(_react.Component);

exports.default = ApplicationListPage;

/***/ }),

/***/ 2962:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(97);

var _applicationActions = __webpack_require__(278);

var _applicationListComponent = __webpack_require__(2963);

var _applicationListComponent2 = _interopRequireDefault(_applicationListComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        applications: state.applicationList.applications
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    onAddApplication: _applicationActions.applicationList.goToCreatePage,
    onEditApplication: _applicationActions.applicationList.goToEditPage,
    onDeleteApplication: _applicationActions.applicationList.deleteApplication,
    searchApplications: _applicationActions.applicationList.searchApplications
})(_applicationListComponent2.default);

/***/ }),

/***/ 2963:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _applicationListHeaderComponent = __webpack_require__(2964);

var _applicationListHeaderComponent2 = _interopRequireDefault(_applicationListHeaderComponent);

var _applicationListItemComponent = __webpack_require__(2965);

var _applicationListItemComponent2 = _interopRequireDefault(_applicationListItemComponent);

var _types = __webpack_require__(102);

var _noData = __webpack_require__(343);

var _widgetAlertMessage = __webpack_require__(434);

var _helpBlock = __webpack_require__(280);

__webpack_require__(281);

__webpack_require__(2968);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var helpMessage = 'Use Applications to logically group applications and the environments they must be deployed to.';

var ApplicationListComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationListComponent, _Component);

    function ApplicationListComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationListComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationListComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListComponent)).call(this, props));

        _this.onFilterChange = function (appName) {
            _this.props.searchApplications(appName);
        };

        _this.goToEditPage = function (application) {
            _this.props.onEditApplication(application);
        };

        _this.goToNewPage = function () {
            _this.props.onAddApplication();
        };

        _this.showDeleteModal = function (application) {
            _this.setState({ deleteModalIsOpen: true, applicationToDelete: application });
        };

        _this.onCloseDeleteModal = function (action) {
            var applicationToDelete = _this.state.applicationToDelete;

            if (action === 'delete') {
                _this.props.onDeleteApplication(applicationToDelete);
            }
            _this.setState({ deleteModalIsOpen: false });
        };

        _this.renderHeader = function () {
            return _react2.default.createElement(
                'div',
                { className: 'application-list-header' },
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-5' },
                    'Name'
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'col-xs-5' },
                    'Environment'
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'col-xs-2' },
                    _react2.default.createElement(
                        'span',
                        { className: 'pull-right action-section' },
                        'Actions'
                    )
                )
            );
        };

        _this.state = {
            deleteModalIsOpen: false,
            applicationToDelete: {}
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationListComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.searchApplications('');
        }
    }, {
        key: 'renderDeleteModal',
        value: function renderDeleteModal() {
            var _state = this.state,
                deleteModalIsOpen = _state.deleteModalIsOpen,
                applicationToDelete = _state.applicationToDelete;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, deleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseDeleteModal,
                    show: deleteModalIsOpen,
                    title: 'Delete application' },
                _react2.default.createElement(
                    _widgetAlertMessage.WidgetAlertMessage,
                    { alertType: _widgetAlertMessage.alertType.WARNING },
                    _react2.default.createElement(
                        'p',
                        null,
                        'Deleting an application can lead to missing data for connected resources on reporting and environment scheduling.'
                    )
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete application ',
                    _react2.default.createElement(
                        'strong',
                        null,
                        applicationToDelete.title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderList',
        value: function renderList() {
            var _this2 = this;

            var applications = this.props.applications;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                this.renderDeleteModal(),
                this.renderHeader(),
                applications.map(function (app) {
                    return _react2.default.createElement(_applicationListItemComponent2.default, { application: app, key: app.id, onDelete: _this2.showDeleteModal, onEdit: _this2.goToEditPage });
                })
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var applications = this.props.applications;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_applicationListHeaderComponent2.default, { onApplicationFilterChange: this.onFilterChange, onCreate: this.goToNewPage }),
                _react2.default.createElement(
                    'div',
                    { className: 'application-list-component' },
                    _react2.default.createElement(
                        'h4',
                        { className: 'page-title' },
                        'Applications (',
                        applications.length,
                        ')'
                    ),
                    _react2.default.createElement(
                        _helpBlock.HelpBlock,
                        { className: 'help-message-container' },
                        helpMessage
                    ),
                    applications.length ? this.renderList() : _react2.default.createElement(_noData.NoData, { message: 'No applications found.' })
                )
            );
        }
    }]);
    return ApplicationListComponent;
}(_react.Component);

ApplicationListComponent.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application).isRequired,
    onAddApplication: _propTypes2.default.func.isRequired,
    onDeleteApplication: _propTypes2.default.func.isRequired,
    onEditApplication: _propTypes2.default.func.isRequired,
    searchApplications: _propTypes2.default.func.isRequired
};
exports.default = ApplicationListComponent;

/***/ }),

/***/ 2964:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _headerComponent = __webpack_require__(244);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var filterOptions = {
    placeholder: 'Filter by application...'
};

var ApplicationListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationListHeaderComponent, _Component);

    function ApplicationListHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationListHeaderComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListHeaderComponent)).call(this, props));

        _this.onFilterChange = function (filter) {
            _this.props.onApplicationFilterChange(filter);
        };

        _this.onCreate = function () {
            _this.props.onCreate();
        };

        _this.state = {
            createButtonDisabled: false,
            modalIsOpen: false,
            title: ''
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationListHeaderComponent, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'applications.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, onUpdate: this.onFilterChange }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: this.onCreate },
                            'New application'
                        )
                    )
                )
            );
        }
    }]);
    return ApplicationListHeaderComponent;
}(_react.Component);

ApplicationListHeaderComponent.propTypes = {
    onApplicationFilterChange: _propTypes2.default.func.isRequired,
    onCreate: _propTypes2.default.func.isRequired
};
exports.default = ApplicationListHeaderComponent;

/***/ }),

/***/ 2965:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(2);

var _classnames2 = _interopRequireDefault(_classnames);

var _types = __webpack_require__(102);

__webpack_require__(2966);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationListItemComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationListItemComponent, _Component);

    function ApplicationListItemComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationListItemComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationListItemComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationListItemComponent)).call(this, props));

        _this.onEditApplication = function (event) {
            event.stopPropagation();

            var _this$props = _this.props,
                application = _this$props.application,
                onEdit = _this$props.onEdit;

            onEdit(application);
        };

        _this.onDeleteApplication = function (event) {
            event.stopPropagation();

            var _this$props2 = _this.props,
                application = _this$props2.application,
                onDelete = _this$props2.onDelete;

            onDelete(application);
        };

        _this.renderLinkedEnvironments = function () {
            var environments = _this.props.application.environments;

            var environmentNames = environments ? environments.map(function (env) {
                return env.title;
            }).join(', ') : [];
            return _react2.default.createElement(
                'div',
                { className: 'application-item-environments col-xs-5' },
                environmentNames.length ? _react2.default.createElement(
                    'span',
                    { title: environmentNames },
                    _react2.default.createElement('i', { className: 'xl-icon environment-icon' }),
                    environmentNames
                ) : 'All environments'
            );
        };

        return _this;
    }

    (0, _createClass3.default)(ApplicationListItemComponent, [{
        key: 'render',
        value: function render() {
            var application = this.props.application;


            var panelClass = (0, _classnames2.default)('panel', 'panel-default', 'application-panel');

            return _react2.default.createElement(
                'div',
                { className: panelClass, onClick: this.onEditApplication },
                _react2.default.createElement(
                    'div',
                    { className: 'application-item-title col-xs-5', title: application.title },
                    _react2.default.createElement('i', { className: 'xl-icon app-icon' }),
                    _react2.default.createElement(
                        'strong',
                        null,
                        application.title
                    )
                ),
                this.renderLinkedEnvironments(),
                _react2.default.createElement(
                    'div',
                    { className: 'actions-container col-xs-2' },
                    _react2.default.createElement(
                        'div',
                        { className: 'actions pull-right' },
                        _react2.default.createElement(
                            'span',
                            { className: 'link color-inherited', 'data-test': 'edit-action', onClick: this.onEditApplication },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon edit-icon', title: 'Edit' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Edit'
                            )
                        ),
                        _react2.default.createElement(
                            'span',
                            { className: 'link delete', 'data-test': 'delete-action', onClick: this.onDeleteApplication },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon delete-icon', title: 'Delete' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Delete'
                            )
                        )
                    )
                )
            );
        }
    }]);
    return ApplicationListItemComponent;
}(_react.Component);

ApplicationListItemComponent.propTypes = {
    application: _types.Application.isRequired,
    onDelete: _propTypes2.default.func.isRequired,
    onEdit: _propTypes2.default.func.isRequired
};
exports.default = ApplicationListItemComponent;

/***/ }),

/***/ 2966:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2968:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2970:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _environmentManagementStore = __webpack_require__(240);

var _applicationEditPageContainer = __webpack_require__(2971);

var _applicationEditPageContainer2 = _interopRequireDefault(_applicationEditPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationEditPage = function (_Component) {
    (0, _inherits3.default)(ApplicationEditPage, _Component);

    function ApplicationEditPage() {
        (0, _classCallCheck3.default)(this, ApplicationEditPage);
        return (0, _possibleConstructorReturn3.default)(this, (ApplicationEditPage.__proto__ || (0, _getPrototypeOf2.default)(ApplicationEditPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(ApplicationEditPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_applicationEditPageContainer2.default, { applicationId: this.props.applicationId })
            );
        }
    }]);
    return ApplicationEditPage;
}(_react.Component);

ApplicationEditPage.propTypes = {
    applicationId: _propTypes2.default.string
};
exports.default = ApplicationEditPage;

/***/ }),

/***/ 2971:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _applicationActions = __webpack_require__(278);

var _applicationEditPageComponent = __webpack_require__(2972);

var _applicationEditPageComponent2 = _interopRequireDefault(_applicationEditPageComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        application: state.applicationForm.application,
        applications: state.applicationForm.applications,
        environments: state.applicationForm.environments,
        stages: state.applicationForm.stages
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    onSaveApplication: _applicationActions.applicationForm.saveApplication,
    initComponent: _applicationActions.applicationForm.initForm,
    onUpdateApplication: _applicationActions.applicationForm.updateModel,
    onFormCancel: _applicationActions.applicationForm.cancelForm,
    onFormPristine: _applicationActions.applicationForm.pristineFormChange
})(_applicationEditPageComponent2.default);

/***/ }),

/***/ 2972:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactSidebar = __webpack_require__(432);

var _reactSidebar2 = _interopRequireDefault(_reactSidebar);

var _lodash = __webpack_require__(79);

var _applicationEditHeaderComponent = __webpack_require__(2973);

var _applicationEditHeaderComponent2 = _interopRequireDefault(_applicationEditHeaderComponent);

var _applicationFormComponent = __webpack_require__(2974);

var _applicationFormComponent2 = _interopRequireDefault(_applicationFormComponent);

var _types = __webpack_require__(102);

var _sidebarEnvironmentList = __webpack_require__(2984);

var _sidebarEnvironmentList2 = _interopRequireDefault(_sidebarEnvironmentList);

__webpack_require__(3412);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var styleSidebar = {
    root: {
        top: '50px'
    }
};

var ApplicationEditPageComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationEditPageComponent, _Component);
    (0, _createClass3.default)(ApplicationEditPageComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            var _props = this.props,
                applicationId = _props.applicationId,
                initComponent = _props.initComponent;

            initComponent(applicationId);
        }
    }]);

    function ApplicationEditPageComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationEditPageComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationEditPageComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationEditPageComponent)).call(this, props));

        _this.onSave = function () {
            var application = _this.props.application;

            _this.props.onSaveApplication(application);
        };

        _this.onFormValidChange = function (valid) {
            _this.setState({ formValid: valid });
        };

        _this.onApplicationChange = function (application) {
            _this.props.onUpdateApplication(application);
        };

        _this.onAddEnvironment = function (environment) {
            _this.setState({ formPristine: false });
            var application = _this.props.application;

            var updatedApp = (0, _extends3.default)({}, application, {
                environments: [].concat((0, _toConsumableArray3.default)(application.environments), [environment])
            });
            _this.props.onUpdateApplication(updatedApp);
        };

        _this.onPristinityChange = function (pristine) {
            _this.setState({ formPristine: pristine });
            if (!pristine) {
                _this.props.onFormPristine(pristine);
            }
        };

        _this.renderSidebarContent = function () {
            var _this$props = _this.props,
                application = _this$props.application,
                environments = _this$props.environments,
                stages = _this$props.stages;

            var filteredEnvironments = (0, _lodash.differenceBy)(environments, application.environments, 'id');

            return _react2.default.createElement(_sidebarEnvironmentList2.default, {
                environments: filteredEnvironments,
                onClickEnvironment: _this.onAddEnvironment,
                stages: stages
            });
        };

        _this.state = {
            formValid: false,
            formPristine: true
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationEditPageComponent, [{
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                application = _props2.application,
                applications = _props2.applications,
                onFormCancel = _props2.onFormCancel;
            var _state = this.state,
                formValid = _state.formValid,
                formPristine = _state.formPristine;

            var saveEnabled = !formPristine && formValid;
            var saveButtonCaption = (0, _lodash.isEmpty)(application) ? 'Create' : 'Save';

            return _react2.default.createElement(
                'div',
                { className: 'application-form-view' },
                _react2.default.createElement(_applicationEditHeaderComponent2.default, {
                    onCancel: onFormCancel,
                    onSave: this.onSave,
                    saveCaption: saveButtonCaption,
                    saveEnabled: saveEnabled
                }),
                _react2.default.createElement(
                    _reactSidebar2.default,
                    {
                        contentClassName: 'application-form-content',
                        docked: true,
                        open: true,
                        pullRight: true,
                        shadow: false,
                        sidebar: this.renderSidebarContent(),
                        sidebarClassName: 'application-form-sidebar',
                        styles: styleSidebar,
                        transitions: false },
                    _react2.default.createElement(_applicationFormComponent2.default, {
                        applicationList: applications,
                        applicationModel: application,
                        onFormChange: this.onApplicationChange,
                        onPristinityChange: this.onPristinityChange,
                        onValidationChange: this.onFormValidChange
                    })
                )
            );
        }
    }]);
    return ApplicationEditPageComponent;
}(_react.Component);

ApplicationEditPageComponent.propTypes = {
    application: _types.Application,
    applicationId: _propTypes2.default.string,
    applications: _propTypes2.default.arrayOf(_types.Application),
    environments: _propTypes2.default.arrayOf(_types.Environment),
    initComponent: _propTypes2.default.func.isRequired,
    onFormCancel: _propTypes2.default.func.isRequired,
    onFormPristine: _propTypes2.default.func.isRequired,
    onSaveApplication: _propTypes2.default.func.isRequired,
    onUpdateApplication: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};
ApplicationEditPageComponent.defaultProps = {
    application: {},
    stages: [],
    environments: [],
    applications: []
};
exports.default = ApplicationEditPageComponent;

/***/ }),

/***/ 2973:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _headerComponent = __webpack_require__(244);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ApplicationEditHeaderComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationEditHeaderComponent, _Component);

    function ApplicationEditHeaderComponent() {
        (0, _classCallCheck3.default)(this, ApplicationEditHeaderComponent);
        return (0, _possibleConstructorReturn3.default)(this, (ApplicationEditHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationEditHeaderComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(ApplicationEditHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                saveCaption = _props.saveCaption,
                saveEnabled = _props.saveEnabled,
                onSave = _props.onSave,
                onCancel = _props.onCancel;

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'applications.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button cancel', onClick: onCancel },
                            'Cancel'
                        ),
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', disabled: !saveEnabled, onClick: onSave },
                            saveCaption
                        )
                    )
                )
            );
        }
    }]);
    return ApplicationEditHeaderComponent;
}(_react.Component);

ApplicationEditHeaderComponent.propTypes = {
    onCancel: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    saveCaption: _propTypes2.default.string.isRequired,
    saveEnabled: _propTypes2.default.bool.isRequired
};
exports.default = ApplicationEditHeaderComponent;

/***/ }),

/***/ 2974:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _isEmpty = __webpack_require__(335);

var _isEmpty2 = _interopRequireDefault(_isEmpty);

var _validators = __webpack_require__(344);

var _index = __webpack_require__(102);

var _widgetLinkedEnvironments = __webpack_require__(2975);

var _widgetLinkedEnvironments2 = _interopRequireDefault(_widgetLinkedEnvironments);

__webpack_require__(281);

__webpack_require__(2982);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var nameFormMetadata = {
    label: 'Name',
    placeholder: 'Add name...',
    description: 'Name of the application',
    required: true
};
var nameValidator = function nameValidator(applications, selectedId) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(applications, selectedId, 'title', name),
            message: (0, _validators.createErrorMessage)('Application already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var findApplicationById = function findApplicationById(applications, id) {
    return applications.find(function (e) {
        return e.id === id;
    }) || {};
};

var ApplicationFormComponent = function (_Component) {
    (0, _inherits3.default)(ApplicationFormComponent, _Component);

    function ApplicationFormComponent(props) {
        (0, _classCallCheck3.default)(this, ApplicationFormComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationFormComponent.__proto__ || (0, _getPrototypeOf2.default)(ApplicationFormComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
        };

        _this.onNameChange = function (title) {
            var applicationModel = _this.props.applicationModel;

            if (title !== applicationModel.title) {
                _this.props.onFormChange((0, _extends3.default)({}, applicationModel, {
                    title: title
                }));
            }
        };

        _this.onEnvironmentDeleted = function (environment) {
            var applicationModel = _this.props.applicationModel;

            var environments = applicationModel.environments.filter(function (e) {
                return e.id !== environment.id;
            });
            _this.props.onFormChange((0, _extends3.default)({}, applicationModel, {
                environments: environments
            }));
            _this.props.onPristinityChange(false);
        };

        _this.onNameValidityChange = function (valid) {
            _this.props.onValidationChange(valid);
        };

        _this.onNamePristine = function (pristine) {
            _this.props.onPristinityChange(pristine);
        };

        return _this;
    }

    (0, _createClass3.default)(ApplicationFormComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                applicationModel = _props.applicationModel,
                applicationList = _props.applicationList;

            var app = findApplicationById(applicationList, applicationModel.id);
            var subtitle = (0, _isEmpty2.default)(app) ? 'New Application' : app.title;

            return _react2.default.createElement(
                'div',
                { className: 'application-edit-form' },
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title' },
                    'Applications / ',
                    subtitle
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'application-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: nameFormMetadata,
                        model: applicationModel.title,
                        onModelChange: this.onNameChange,
                        onPristinityChange: this.onNamePristine,
                        onValidityChange: this.onNameValidityChange,
                        register: this.onRegister,
                        validators: [nameValidator(applicationList, applicationModel.id), maxLengthValidator(nameFormMetadata.label, 255)]
                    }),
                    _react2.default.createElement(_widgetLinkedEnvironments2.default, { environments: applicationModel.environments, onDelete: this.onEnvironmentDeleted })
                )
            );
        }
    }]);
    return ApplicationFormComponent;
}(_react.Component);

ApplicationFormComponent.propTypes = {
    applicationList: _propTypes2.default.arrayOf(_index.Application).isRequired,
    applicationModel: _index.Application,
    onFormChange: _propTypes2.default.func.isRequired,
    onPristinityChange: _propTypes2.default.func.isRequired,
    onValidationChange: _propTypes2.default.func.isRequired
};
ApplicationFormComponent.defaultProps = {
    applicationModel: {}
};
exports.default = ApplicationFormComponent;

/***/ }),

/***/ 2975:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _index = __webpack_require__(102);

var _listBlock = __webpack_require__(2976);

var _helpBlock = __webpack_require__(280);

__webpack_require__(2980);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var environmentsMetadata = {
    label: 'Linked environments',
    required: false
};

var WidgetLinkedEnvironments = function (_Component) {
    (0, _inherits3.default)(WidgetLinkedEnvironments, _Component);

    function WidgetLinkedEnvironments() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, WidgetLinkedEnvironments);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = WidgetLinkedEnvironments.__proto__ || (0, _getPrototypeOf2.default)(WidgetLinkedEnvironments)).call.apply(_ref, [this].concat(args))), _this), _this.onClickDelete = function (environment) {
            _this.props.onDelete(environment);
        }, _this.renderEmptyContainer = function () {
            return _react2.default.createElement(
                _helpBlock.HelpBlock,
                null,
                'Click an environment on the right to link it to the application'
            );
        }, _this.renderEnvironmentLinked = function (environment) {
            return _react2.default.createElement(
                _listBlock.ListBlock,
                {
                    childrenClassName: 'list-block-env-title',
                    key: environment.id,
                    onDelete: function onDelete() {
                        return _this.onClickDelete(environment);
                    } },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement('i', { className: 'xl-icon environment-icon mrs' }),
                    _react2.default.createElement(
                        'span',
                        { title: environment.title },
                        environment.title
                    )
                )
            );
        }, _this.renderContainer = function (environments) {
            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                environments.map(function (e) {
                    return _this.renderEnvironmentLinked(e);
                })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(WidgetLinkedEnvironments, [{
        key: 'render',
        value: function render() {
            var environments = this.props.environments;


            return _react2.default.createElement(
                'div',
                { className: 'xl-react-components' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: environmentsMetadata }),
                _react2.default.createElement(
                    'div',
                    { className: 'xl-react-components-input' },
                    environments.length ? this.renderContainer(environments) : this.renderEmptyContainer()
                )
            );
        }
    }]);
    return WidgetLinkedEnvironments;
}(_react.Component);

WidgetLinkedEnvironments.propTypes = {
    environments: _propTypes2.default.arrayOf(_index.Environment),
    onDelete: _propTypes2.default.func.isRequired
};
WidgetLinkedEnvironments.defaultProps = {
    environments: []
};
exports.default = WidgetLinkedEnvironments;

/***/ }),

/***/ 2976:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _listBlock = __webpack_require__(2977);

Object.defineProperty(exports, 'ListBlock', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_listBlock).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 2977:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(2978);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ListBlock = function ListBlock(_ref) {
    var children = _ref.children,
        childrenClassName = _ref.childrenClassName,
        listBlockClassName = _ref.listBlockClassName,
        onDelete = _ref.onDelete;
    return _react2.default.createElement(
        'div',
        { className: 'list-block ' + listBlockClassName },
        _react2.default.createElement(
            'div',
            { className: 'list-block-children ' + childrenClassName },
            children
        ),
        _react2.default.createElement('span', { className: 'cross xl-icon close-icon', onClick: onDelete })
    );
};

ListBlock.propTypes = {
    children: _propTypes2.default.element.isRequired,
    childrenClassName: _propTypes2.default.string,
    listBlockClassName: _propTypes2.default.string,
    onDelete: _propTypes2.default.func.isRequired
};

ListBlock.defaultProps = {
    childrenClassName: '',
    listBlockClassName: ''
};

exports.default = ListBlock;

/***/ }),

/***/ 2978:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2980:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2982:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 2984:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _includes = __webpack_require__(339);

var _includes2 = _interopRequireDefault(_includes);

var _orderBy = __webpack_require__(583);

var _orderBy2 = _interopRequireDefault(_orderBy);

var _defaults = __webpack_require__(2985);

var _defaults2 = _interopRequireDefault(_defaults);

var _environmentSidebarItem = __webpack_require__(907);

var _environmentSidebarItem2 = _interopRequireDefault(_environmentSidebarItem);

var _index = __webpack_require__(102);

__webpack_require__(3410);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var stageMetadata = { label: '', placeholder: 'Filter by stage...' };
var filterOptions = { placeholder: 'Filter environment name...' };

var SidebarEnvironmentList = function (_Component) {
    (0, _inherits3.default)(SidebarEnvironmentList, _Component);

    function SidebarEnvironmentList(props) {
        (0, _classCallCheck3.default)(this, SidebarEnvironmentList);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SidebarEnvironmentList.__proto__ || (0, _getPrototypeOf2.default)(SidebarEnvironmentList)).call(this, props));

        _this.onStageChange = function (stage) {
            _this.setState({ stageSelected: stage });
        };

        _this.onNameChange = function (name) {
            _this.setState({ environmentFilter: name });
        };

        _this.onEnvironmentClick = function (environment) {
            _this.props.onClickEnvironment(environment);
        };

        _this.filterEnvironments = function (environment) {
            var _this$state = _this.state,
                environmentFilter = _this$state.environmentFilter,
                stageSelected = _this$state.stageSelected;

            (0, _defaults2.default)(stageSelected, { title: '' });
            return (0, _includes2.default)(environment.title.toLowerCase(), environmentFilter.toLowerCase()) && (0, _includes2.default)(environment.stage.title.toLowerCase(), stageSelected.title.toLowerCase());
        };

        _this.renderEnvironments = function () {
            var environments = _this.props.environments;

            return environments.filter(function (env) {
                return _this.filterEnvironments(env);
            }).map(function (env) {
                return _react2.default.createElement(_environmentSidebarItem2.default, {
                    environment: env,
                    isClickable: true,
                    key: env.id,
                    onClick: _this.onEnvironmentClick });
            });
        };

        _this.state = {
            stageSelected: {
                title: ''
            },
            environmentFilter: ''
        };
        return _this;
    }

    (0, _createClass3.default)(SidebarEnvironmentList, [{
        key: 'render',
        value: function render() {
            var stages = this.props.stages;
            var stageSelected = this.state.stageSelected;

            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _orderBy2.default)(stages.filter(function (c) {
                    return (0, _includes2.default)(c.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };

            return _react2.default.createElement(
                'div',
                { className: 'application-form-environment-sidebar' },
                _react2.default.createElement(
                    'div',
                    { className: 'header' },
                    _react2.default.createElement(
                        'h4',
                        { className: 'page-title' },
                        'Environments'
                    ),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: autocompleteHandlers,
                        metadata: stageMetadata,
                        model: stageSelected,
                        objLabel: 'title',
                        onModelChange: this.onStageChange
                    }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, onUpdate: this.onNameChange })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'environment-sidebar-list' },
                    this.renderEnvironments()
                )
            );
        }
    }]);
    return SidebarEnvironmentList;
}(_react.Component);

SidebarEnvironmentList.propTypes = {
    environments: _propTypes2.default.arrayOf(_index.Environment),
    onClickEnvironment: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_index.Stage)
};
SidebarEnvironmentList.defaultProps = {
    stages: [],
    environments: []
};
exports.default = SidebarEnvironmentList;

/***/ }),

/***/ 327:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fetchCount = exports.fetchArchivedReleaseTags = exports.fetchReleaseTags = exports.abortReleases = exports.startReleases = exports.fetchRisks = exports.fetchReleases = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _http = __webpack_require__(88);

var _constants = __webpack_require__(224);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var fetchReleases = exports.fetchReleases = function fetchReleases(filters, pageNumber) {
    var url = "releases/search?depth=3&numberbypage=" + _constants.ITEMS_PER_PAGE + "&page=" + pageNumber + "&filter=" + filters.filter + '&properties=riskScore&extensions=progress';
    return (0, _http.httpRequest)('POST', url, {
        data: filters
    });
};
var fetchRisks = exports.fetchRisks = function fetchRisks(releaseId) {
    return (0, _http.httpRequest)('GET', "api/v1/risks/" + releaseId + "/Risk");
};
var startReleases = exports.startReleases = function startReleases(releasesIds) {
    return (0, _http.httpRequest)('POST', "releases/start", { data: releasesIds });
};
var abortReleases = exports.abortReleases = function abortReleases(releasesIds) {
    return (0, _http.httpRequest)('POST', "releases/abort", { data: releasesIds });
};

var fetchReleaseTags = exports.fetchReleaseTags = function fetchReleaseTags() {
    return (0, _http.httpGET)('releases/tags');
};

var fetchArchivedReleaseTags = exports.fetchArchivedReleaseTags = function fetchArchivedReleaseTags() {
    return (0, _http.httpGET)('releases/tags/archived');
};

var fetchCount = exports.fetchCount = function fetchCount(filters) {
    if (filters.onlyArchived) {
        filters.planned = false;
        filters.inProgress = false;
        filters.failing = false;
        filters.failed = false;
        filters.paused = false;
    }
    return (0, _http.httpPOST)('releases/count', (0, _extends3.default)({}, filters, { onlyArchived: false }));
};

/***/ }),

/***/ 332:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getDeployableApplicationsForEnvironment = exports.deleteEnvironment = exports.searchEnvironments = exports.updateEnvironment = exports.loadEnvironment = exports.createEnvironment = undefined;

var _http = __webpack_require__(88);

var createEnvironment = exports.createEnvironment = function createEnvironment(environment) {
    return (0, _http.httpPOST)('api/v1/environments', environment);
};

var loadEnvironment = exports.loadEnvironment = function loadEnvironment(environmentId) {
    return (0, _http.httpGET)('api/v1/environments/' + environmentId).then(function (response) {
        return response.data;
    });
};

var updateEnvironment = exports.updateEnvironment = function updateEnvironment(environmentId, environment) {
    return (0, _http.httpPUT)('api/v1/environments/' + environmentId, environment);
};

var searchEnvironments = exports.searchEnvironments = function searchEnvironments(_ref) {
    var title = _ref.title,
        stage = _ref.stage;

    return (0, _http.httpPOST)('api/v1/environments/search', { title: title, stage: stage }).then(function (response) {
        return response.data;
    });
};

var deleteEnvironment = exports.deleteEnvironment = function deleteEnvironment(environmentId) {
    return (0, _http.httpDELETE)('api/v1/environments/' + environmentId);
};

var getDeployableApplicationsForEnvironment = exports.getDeployableApplicationsForEnvironment = function getDeployableApplicationsForEnvironment(environmentId) {
    return (0, _http.httpGET)('api/v1/environments/' + environmentId + '/applications').then(function (response) {
        return response.data;
    });
};

/***/ }),

/***/ 333:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deleteStage = exports.updateStage = exports.getStage = exports.searchStages = exports.createStage = undefined;

var _http = __webpack_require__(88);

var createStage = exports.createStage = function createStage(stage) {
    return (0, _http.httpPOST)('api/v1/environments/stages', stage);
};

var searchStages = exports.searchStages = function searchStages(title) {
    return (0, _http.httpPOST)('api/v1/environments/stages/search', { title: title }).then(function (response) {
        return response.data;
    });
};

var getStage = exports.getStage = function getStage(stageId) {
    return (0, _http.httpGET)('api/v1/environments/stages/' + stageId).then(function (response) {
        return response.data;
    });
};

var updateStage = exports.updateStage = function updateStage(stageId, stage) {
    return (0, _http.httpPUT)('api/v1/environments/stages/' + stageId, stage);
};

var deleteStage = exports.deleteStage = function deleteStage(stageId) {
    return (0, _http.httpDELETE)('api/v1/environments/stages/' + stageId);
};

/***/ }),

/***/ 334:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    LABEL_SEARCH: 'envMgmt/LABEL_SEARCH',
    LABEL_SEARCH_SUCCESS: 'envMgmt/LABEL_SEARCH_SUCCESS',
    LABEL_SEARCH_FAILURE: 'envMgmt/LABEL_SEARCH_FAILURE',
    SAVE_LABEL: 'envMgmt/LABEL_SAVE_LABEL',
    SAVE_LABEL_SUCCESS: 'envMgmt/SAVE_LABEL_SUCCESS',
    SAVE_LABEL_FAILURE: 'envMgmt/SAVE_LABEL_FAILURE',
    DELETE_LABEL: 'envMgmt/DELETE_LABEL_LABEL',
    DELETE_LABEL_SUCCESS: 'envMgmt/DELETE_LABEL_SUCCESS',
    DELETE_LABEL_FAILURE: 'envMgmt/DELETE_LABEL_FAILURE'
};

var searchLabels = exports.searchLabels = function searchLabels(title) {
    return {
        type: actionTypes.LABEL_SEARCH,
        payload: title
    };
};

var saveLabel = exports.saveLabel = function saveLabel(envType) {
    return {
        type: actionTypes.SAVE_LABEL,
        payload: envType
    };
};

var deleteLabel = exports.deleteLabel = function deleteLabel(envType) {
    return {
        type: actionTypes.DELETE_LABEL,
        payload: envType
    };
};

/***/ }),

/***/ 338:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
function by(fieldSelector) {
    return function (a, b) {
        var nameA = fieldSelector(a).toLowerCase();
        var nameB = fieldSelector(b).toLowerCase();
        if (nameA < nameB) {
            return -1;
        }
        if (nameA > nameB) {
            return 1;
        }
        return 0;
    };
}

var byTitle = exports.byTitle = by(function (it) {
    return it.title;
});

/***/ }),

/***/ 3403:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactDom = __webpack_require__(16);

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _takeRight = __webpack_require__(3404);

var _takeRight2 = _interopRequireDefault(_takeRight);

var _antd = __webpack_require__(1030);

var _labelItem = __webpack_require__(342);

var _labelItem2 = _interopRequireDefault(_labelItem);

__webpack_require__(3406);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LabelListTruncated = function (_Component) {
    (0, _inherits3.default)(LabelListTruncated, _Component);

    function LabelListTruncated(props) {
        (0, _classCallCheck3.default)(this, LabelListTruncated);

        var _this = (0, _possibleConstructorReturn3.default)(this, (LabelListTruncated.__proto__ || (0, _getPrototypeOf2.default)(LabelListTruncated)).call(this, props));

        _this.setItemRef = function (el) {
            _this.itemRefs.push(el);
        };

        _this.renderLabelList = function (labels) {
            return labels.map(function (label) {
                return _react2.default.createElement(_labelItem2.default, {
                    envLabel: label,
                    key: label.id,
                    ref: _this.setItemRef,
                    size: 'small' });
            });
        };

        _this.renderPopupContent = function () {
            var labels = _this.props.labels;
            var moreItems = _this.state.moreItems;

            var labelListInPopup = (0, _takeRight2.default)(labels, moreItems);
            return _react2.default.createElement(
                'div',
                { className: 'type-popup-content' },
                _this.renderLabelList(labelListInPopup)
            );
        };

        _this.renderLabelListPopup = function () {
            var moreItems = _this.state.moreItems;


            return !!moreItems && _react2.default.createElement(
                _antd.Popover,
                {
                    arrowPointAtCenter: true,
                    content: _this.renderPopupContent(),
                    overlayClassName: 'type-popup',
                    placement: 'bottomRight',
                    trigger: 'hover' },
                _react2.default.createElement(
                    'div',
                    { className: 'more-labels' },
                    moreItems,
                    ' more...'
                )
            );
        };

        _this.containerRef = _react2.default.createRef();
        _this.itemRefs = [];

        _this.state = {
            moreItems: null
        };
        return _this;
    }

    (0, _createClass3.default)(LabelListTruncated, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            /* eslint-disable react/no-find-dom-node */
            var container = _reactDom2.default.findDOMNode(this.containerRef.current);
            /* eslint-enable react/no-find-dom-node */
            if (container && this.itemRefs.length) {
                var bound = container.getBoundingClientRect();
                var moreItems = this.itemRefs.reduce(function (acc, curr) {
                    /* eslint-disable react/no-find-dom-node */
                    var node = _reactDom2.default.findDOMNode(curr);
                    /* eslint-enable react/no-find-dom-node */
                    if (node) {
                        var rect = node.getBoundingClientRect();
                        if (rect.top - bound.top > bound.height / 2) {
                            return acc + 1;
                        }
                    }
                    return acc;
                }, 0);
                if (moreItems) {
                    /* eslint-disable react/no-did-mount-set-state */
                    this.setState({ moreItems: moreItems });
                    /* eslint-enable react/no-did-mount-set-state */
                }
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var labels = this.props.labels;

            return _react2.default.createElement(
                'div',
                { className: 'label-list', ref: this.containerRef },
                this.renderLabelList(labels),
                this.renderLabelListPopup()
            );
        }
    }]);
    return LabelListTruncated;
}(_react.Component);

LabelListTruncated.propTypes = {
    labels: _propTypes2.default.arrayOf(_propTypes2.default.object)
};
exports.default = LabelListTruncated;

/***/ }),

/***/ 3406:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3408:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3410:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3412:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3414:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _environmentManagementStore = __webpack_require__(240);

var _stageListContainer = __webpack_require__(3415);

var _stageListContainer2 = _interopRequireDefault(_stageListContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var StagePage = function (_Component) {
    (0, _inherits3.default)(StagePage, _Component);

    function StagePage() {
        (0, _classCallCheck3.default)(this, StagePage);
        return (0, _possibleConstructorReturn3.default)(this, (StagePage.__proto__ || (0, _getPrototypeOf2.default)(StagePage)).apply(this, arguments));
    }

    (0, _createClass3.default)(StagePage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_stageListContainer2.default, null)
            );
        }
    }]);
    return StagePage;
}(_react.Component);

exports.default = StagePage;

/***/ }),

/***/ 3415:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(97);

var _stageActions = __webpack_require__(419);

var _stageListComponent = __webpack_require__(3416);

var _stageListComponent2 = _interopRequireDefault(_stageListComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        stageList: state.stages.stageList
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    searchStages: _stageActions.searchStages,
    saveStage: _stageActions.saveStage,
    deleteStage: _stageActions.deleteStage
})(_stageListComponent2.default);

/***/ }),

/***/ 3416:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _includes = __webpack_require__(339);

var _includes2 = _interopRequireDefault(_includes);

var _xlReactComponents = __webpack_require__(69);

var _stageListHeaderComponent = __webpack_require__(3417);

var _stageListHeaderComponent2 = _interopRequireDefault(_stageListHeaderComponent);

var _stageListItemComponent = __webpack_require__(3418);

var _stageListItemComponent2 = _interopRequireDefault(_stageListItemComponent);

var _stageEditModal = __webpack_require__(3421);

var _stageEditModal2 = _interopRequireDefault(_stageEditModal);

var _sidebarEnvironmentNavigation = __webpack_require__(431);

var _sidebarEnvironmentNavigation2 = _interopRequireDefault(_sidebarEnvironmentNavigation);

var _helpBlock = __webpack_require__(280);

var _noData = __webpack_require__(343);

var _widgetAlertMessage = __webpack_require__(434);

__webpack_require__(281);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var helpMessage = 'Use Stages to logically group environments. You can also use Stages to filter the environment scheduler and dashboards.';

var StageListComponent = function (_Component) {
    (0, _inherits3.default)(StageListComponent, _Component);

    function StageListComponent(props) {
        (0, _classCallCheck3.default)(this, StageListComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageListComponent.__proto__ || (0, _getPrototypeOf2.default)(StageListComponent)).call(this, props));

        _this.onFilterChange = function (filter) {
            _this.setState({ filter: filter });
        };

        _this.showDeleteModal = function (stage) {
            _this.setState({ deleteModalIsOpen: true, stage: stage });
        };

        _this.showEditModal = function (stage) {
            _this.setState({ editModalIsOpen: true, stage: stage });
        };

        _this.onCloseDeleteModal = function (action) {
            var stage = _this.state.stage;

            if (action === 'delete') {
                _this.props.deleteStage(stage);
            }
            _this.setState({ deleteModalIsOpen: false });
        };

        _this.handleStageSave = function (stage) {
            var saveStage = _this.props.saveStage;


            saveStage(stage);
            _this.setState({ editModalIsOpen: false });
        };

        _this.handleCancel = function () {
            _this.setState({ editModalIsOpen: false });
        };

        _this.renderStage = function (stage) {
            return _react2.default.createElement(_stageListItemComponent2.default, {
                key: stage.id,
                onDelete: _this.showDeleteModal,
                onEdit: _this.showEditModal,
                stage: stage
            });
        };

        _this.state = {
            deleteModalIsOpen: false,
            disabledUpdateButton: true,
            editModalIsOpen: false,
            filter: '',
            stage: {
                id: null,
                title: null
            }
        };
        return _this;
    }

    (0, _createClass3.default)(StageListComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.searchStages();
        }
    }, {
        key: 'renderDeleteModal',
        value: function renderDeleteModal() {
            var _state = this.state,
                deleteModalIsOpen = _state.deleteModalIsOpen,
                stage = _state.stage;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, deleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseDeleteModal,
                    show: deleteModalIsOpen,
                    title: 'Delete stage' },
                _react2.default.createElement(
                    _widgetAlertMessage.WidgetAlertMessage,
                    { alertType: _widgetAlertMessage.alertType.WARNING },
                    _react2.default.createElement(
                        'p',
                        null,
                        'Deleting a stage can lead to missing data for connected resources on reporting and environment scheduling.'
                    )
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete stage ',
                    _react2.default.createElement(
                        'strong',
                        null,
                        stage.title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderStages',
        value: function renderStages() {
            var stageList = this.props.stageList;
            var filter = this.state.filter;


            var stages = stageList.filter(function (stage) {
                return (0, _includes2.default)(stage.title.toLowerCase(), filter.toLowerCase());
            }).map(this.renderStage);

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title' },
                    'Stages (',
                    stages.length,
                    ')'
                ),
                _react2.default.createElement(
                    _helpBlock.HelpBlock,
                    { className: 'help-message-container' },
                    helpMessage
                ),
                stages.length ? stages : _react2.default.createElement(_noData.NoData, { className: 'no-stages-message', message: 'No stages found.' })
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                stageList = _props.stageList,
                saveStage = _props.saveStage;
            var _state2 = this.state,
                stage = _state2.stage,
                editModalIsOpen = _state2.editModalIsOpen;


            return _react2.default.createElement(
                'div',
                null,
                this.renderDeleteModal(),
                _react2.default.createElement(_stageEditModal2.default, {
                    isOpened: editModalIsOpen,
                    model: stage,
                    onCancel: this.handleCancel,
                    onSave: this.handleStageSave,
                    stages: stageList
                }),
                _react2.default.createElement(_stageListHeaderComponent2.default, {
                    onFilterChange: this.onFilterChange,
                    onSave: saveStage,
                    stageList: stageList
                }),
                _react2.default.createElement(
                    _sidebarEnvironmentNavigation2.default,
                    { menuSelected: 'Stages' },
                    this.renderStages(stageList)
                )
            );
        }
    }]);
    return StageListComponent;
}(_react.Component);

StageListComponent.propTypes = {
    deleteStage: _propTypes2.default.func.isRequired,
    saveStage: _propTypes2.default.func.isRequired,
    searchStages: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    })).isRequired
};
exports.default = StageListComponent;

/***/ }),

/***/ 3417:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _validators = __webpack_require__(344);

var _headerComponent = __webpack_require__(244);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

__webpack_require__(433);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};
var createButton = {
    action: 'create',
    className: 'button primary',
    keyCodes: [13],
    label: 'Create'
};

var nameOptions = {
    label: 'Name',
    placeholder: 'Add...',
    description: 'Name of the stage',
    required: true
};

var nameValidator = function nameValidator(stageList) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(stageList, null, 'title', name),
            message: (0, _validators.createErrorMessage)('Stage already existing')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var StageListHeaderComponent = function (_Component) {
    (0, _inherits3.default)(StageListHeaderComponent, _Component);

    function StageListHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, StageListHeaderComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageListHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(StageListHeaderComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
        };

        _this.onCreate = function () {
            _this.setState({ modalIsOpen: true });
        };

        _this.onClose = function (action) {
            if (action === 'create') {
                _this.props.onSave({ title: _this.state.title });
            }
            _this.setState({ modalIsOpen: false });
        };

        _this.closeModal = function () {
            _this.onClose(cancelButton.action);
        };

        _this.onModelChange = function (title) {
            _this.setState({ title: title });
        };

        _this.onValidityChange = function (valid) {
            _this.setState({ createButtonDisabled: !valid });
        };

        _this.state = {
            createButtonDisabled: false,
            modalIsOpen: false,
            title: ''
        };
        return _this;
    }

    (0, _createClass3.default)(StageListHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                onFilterChange = _props.onFilterChange,
                stageList = _props.stageList;
            var _state = this.state,
                modalIsOpen = _state.modalIsOpen,
                createButtonDisabled = _state.createButtonDisabled;

            var filterOptions = { placeholder: 'Filter by stage...' };
            createButton.disabled = createButtonDisabled;

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'New stage',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.closeModal, type: 'button' },
                    _react2.default.createElement('i', { className: 'xl-icon close-icon' })
                )
            );

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'environments.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: filterOptions, onUpdate: onFilterChange }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', onClick: this.onCreate },
                            'New stage'
                        )
                    ),
                    _react2.default.createElement(
                        _xlReactComponents.XlReactWidgetConfirmationDialog,
                        {
                            buttons: [cancelButton, createButton],
                            dialogClassName: 'xl-default-modal',
                            onButtonClick: this.onClose,
                            show: modalIsOpen,
                            title: modalHeader },
                        _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                            metadata: nameOptions,
                            onModelChange: this.onModelChange,
                            onValidityChange: this.onValidityChange,
                            register: this.onRegister,
                            validators: [nameValidator(stageList), maxLengthValidator(nameOptions.label, 255)] })
                    )
                )
            );
        }
    }]);
    return StageListHeaderComponent;
}(_react.Component);

StageListHeaderComponent.propTypes = {
    onFilterChange: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    stageList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired
};
exports.default = StageListHeaderComponent;

/***/ }),

/***/ 3418:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(3419);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var StageListItemComponent = function (_Component) {
    (0, _inherits3.default)(StageListItemComponent, _Component);

    function StageListItemComponent() {
        (0, _classCallCheck3.default)(this, StageListItemComponent);
        return (0, _possibleConstructorReturn3.default)(this, (StageListItemComponent.__proto__ || (0, _getPrototypeOf2.default)(StageListItemComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(StageListItemComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stage = _props.stage,
                onDelete = _props.onDelete,
                onEdit = _props.onEdit;

            return _react2.default.createElement(
                'div',
                { className: 'stage-panel' },
                _react2.default.createElement(
                    'div',
                    { className: 'title env-stage-title col-xs-8', title: stage.title },
                    stage.title
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'actions col-xs-4' },
                    _react2.default.createElement(
                        'span',
                        { className: 'pull-right' },
                        _react2.default.createElement(
                            'span',
                            { className: 'link color-inherited', onClick: function onClick() {
                                    return onEdit(stage);
                                } },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon edit-icon', title: 'Edit' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Edit'
                            )
                        ),
                        _react2.default.createElement(
                            'span',
                            { className: 'link delete', onClick: function onClick() {
                                    return onDelete(stage);
                                } },
                            _react2.default.createElement('i', { className: 'menu-item-icon xl-icon delete-icon', title: 'Delete' }),
                            _react2.default.createElement(
                                'span',
                                { className: 'action-label' },
                                'Delete'
                            )
                        )
                    )
                )
            );
        }
    }]);
    return StageListItemComponent;
}(_react.Component);

StageListItemComponent.propTypes = {
    onDelete: _propTypes2.default.func.isRequired,
    onEdit: _propTypes2.default.func.isRequired,
    stage: _propTypes2.default.shape({
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired
};
exports.default = StageListItemComponent;

/***/ }),

/***/ 3419:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 342:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(2);

var _classnames2 = _interopRequireDefault(_classnames);

__webpack_require__(2658);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var componentSize = ['small', 'normal'];
var skinType = ['plus', 'remove', 'normal'];

var LabelItem = function (_Component) {
    (0, _inherits3.default)(LabelItem, _Component);

    function LabelItem() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, LabelItem);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = LabelItem.__proto__ || (0, _getPrototypeOf2.default)(LabelItem)).call.apply(_ref, [this].concat(args))), _this), _this.handleClick = function (label) {
            var onClickLabel = _this.props.onClickLabel;

            if (onClickLabel) {
                onClickLabel(label);
            }
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(LabelItem, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props,
                envLabel = _props.envLabel,
                size = _props.size,
                isEditable = _props.isEditable,
                skin = _props.skin;

            var style = (0, _classnames2.default)('label-box', size, { 'editable-label': isEditable });
            return _react2.default.createElement(
                'div',
                { className: style, onClick: function onClick() {
                        return _this2.handleClick(envLabel);
                    }, style: { backgroundColor: envLabel.color }, title: 'Click to edit' },
                skin === 'plus' && _react2.default.createElement('i', { className: 'menu-item-icon xl-icon add-icon icon-s', title: 'Add' }),
                envLabel.title,
                skin === 'remove' && _react2.default.createElement('i', { className: 'menu-item-icon xl-icon close-icon icon-s', title: 'Remove' })
            );
        }
    }]);
    return LabelItem;
}(_react.Component);

LabelItem.propTypes = {
    envLabel: _propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired,
    isEditable: _propTypes2.default.bool,
    onClickLabel: _propTypes2.default.func,
    size: _propTypes2.default.oneOf(componentSize),
    skin: _propTypes2.default.oneOf(skinType)
};
LabelItem.defaultProps = {
    isEditable: false,
    size: 'normal',
    skin: 'normal'
};
exports.default = LabelItem;

/***/ }),

/***/ 3421:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _validators = __webpack_require__(344);

var _types = __webpack_require__(102);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var nameOptions = {
    label: 'Name',
    description: 'Name of the stage',
    required: true
};

var nameValidator = function nameValidator(stageList, id) {
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(stageList, id, 'title', name),
            message: (0, _validators.createErrorMessage)('Stage already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var StageEditModal = function (_Component) {
    (0, _inherits3.default)(StageEditModal, _Component);
    (0, _createClass3.default)(StageEditModal, null, [{
        key: 'getDerivedStateFromProps',
        value: function getDerivedStateFromProps(props, state) {
            if (!state.stage || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
                return (0, _extends3.default)({}, state, {
                    stage: props.model,
                    prevModel: props.model
                });
            }
            return null;
        }
    }]);

    function StageEditModal(props) {
        (0, _classCallCheck3.default)(this, StageEditModal);

        var _this = (0, _possibleConstructorReturn3.default)(this, (StageEditModal.__proto__ || (0, _getPrototypeOf2.default)(StageEditModal)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
            _this.componentApi = componentApi;
        };

        _this.closeModal = function () {
            _this.handleButtonClick(cancelButton.action);
        };

        _this.handleButtonClick = function (action) {
            var _this$props = _this.props,
                onCancel = _this$props.onCancel,
                onSave = _this$props.onSave;
            var stage = _this.state.stage;


            switch (action) {
                case 'update':
                    onSave(stage);
                    break;
                case 'cancel':
                    onCancel();
                    break;
            }
            _this.resetForm();
        };

        _this.handleModelChange = function (newTitle) {
            var stage = _this.state.stage;


            if (newTitle !== stage.title) {
                _this.setState({
                    stage: (0, _extends3.default)({}, stage, {
                        title: newTitle
                    })
                });
            }
        };

        _this.handleValidityChange = function (valid) {
            _this.isValid = valid;
        };

        _this.handlePristinityChange = function (pristine) {
            _this.isPristine = pristine;
        };

        _this.resetForm = function () {
            _this.setState({ stage: null });
            if (_this.componentApi) {
                _this.componentApi.resetPristinity();
            }
        };

        _this.state = {
            stage: null,
            prevModel: null
        };

        _this.isPristine = null;
        _this.isValid = null;

        _this.componentApi = null;
        return _this;
    }

    (0, _createClass3.default)(StageEditModal, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                stages = _props.stages,
                isOpened = _props.isOpened;
            var stage = this.state.stage;


            var disableSaving = this.isPristine || !this.isValid;

            var updateButton = {
                action: 'update',
                className: 'button primary',
                disabled: disableSaving,
                keyCodes: [13],
                label: 'Save'
            };

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                'Edit stage',
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.closeModal, type: 'button' },
                    _react2.default.createElement('i', { className: 'xl-icon close-icon' })
                )
            );

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, updateButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.handleButtonClick,
                    show: isOpened,
                    title: modalHeader },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                    metadata: nameOptions,
                    model: stage.title,
                    onModelChange: this.handleModelChange,
                    onPristinityChange: this.handlePristinityChange,
                    onValidityChange: this.handleValidityChange,
                    register: this.onRegister,
                    validators: [nameValidator(stages, stage.id), maxLengthValidator(nameOptions.label, 255)]
                })
            );
        }
    }]);
    return StageEditModal;
}(_react.Component);

StageEditModal.propTypes = {
    isOpened: _propTypes2.default.bool.isRequired,
    model: _types.Stage.isRequired,
    onCancel: _propTypes2.default.func.isRequired,
    onSave: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage).isRequired
};
exports.default = StageEditModal;

/***/ }),

/***/ 3422:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _environmentManagementStore = __webpack_require__(240);

var _labelListContainer = __webpack_require__(3423);

var _labelListContainer2 = _interopRequireDefault(_labelListContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var LabelPage = function (_Component) {
    (0, _inherits3.default)(LabelPage, _Component);

    function LabelPage() {
        (0, _classCallCheck3.default)(this, LabelPage);
        return (0, _possibleConstructorReturn3.default)(this, (LabelPage.__proto__ || (0, _getPrototypeOf2.default)(LabelPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(LabelPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_labelListContainer2.default, null)
            );
        }
    }]);
    return LabelPage;
}(_react.Component);

exports.default = LabelPage;

/***/ }),

/***/ 3423:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _reactRedux = __webpack_require__(97);

var _labelActions = __webpack_require__(334);

var _labelListComponent = __webpack_require__(901);

var _labelListComponent2 = _interopRequireDefault(_labelListComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var mapStateToProps = function mapStateToProps(state) {
    return {
        labelList: state.labels.labelList
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    deleteLabel: _labelActions.deleteLabel,
    searchLabels: _labelActions.searchLabels,
    saveLabel: _labelActions.saveLabel
})(_labelListComponent2.default);

/***/ }),

/***/ 3424:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SchedulingReleasePage = function (_Component) {
    (0, _inherits3.default)(SchedulingReleasePage, _Component);

    function SchedulingReleasePage() {
        (0, _classCallCheck3.default)(this, SchedulingReleasePage);
        return (0, _possibleConstructorReturn3.default)(this, (SchedulingReleasePage.__proto__ || (0, _getPrototypeOf2.default)(SchedulingReleasePage)).apply(this, arguments));
    }

    (0, _createClass3.default)(SchedulingReleasePage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                { className: 'col-sm-12' },
                _react2.default.createElement(
                    'p',
                    null,
                    'In progress...'
                )
            );
        }
    }]);
    return SchedulingReleasePage;
}(_react.Component);

exports.default = SchedulingReleasePage;

/***/ }),

/***/ 3425:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _environmentManagementStore = __webpack_require__(240);

var _schedulingEnvironmentPageContainer = __webpack_require__(3426);

var _schedulingEnvironmentPageContainer2 = _interopRequireDefault(_schedulingEnvironmentPageContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SchedulingEnvironmentPage = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentPage, _Component);

    function SchedulingEnvironmentPage() {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentPage);
        return (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentPage.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentPage)).apply(this, arguments));
    }

    (0, _createClass3.default)(SchedulingEnvironmentPage, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactRedux.Provider,
                { store: _environmentManagementStore.store },
                _react2.default.createElement(_schedulingEnvironmentPageContainer2.default, null)
            );
        }
    }]);
    return SchedulingEnvironmentPage;
}(_react.Component);

exports.default = SchedulingEnvironmentPage;

/***/ }),

/***/ 3426:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SchedulingEnvironmentPageContainer = undefined;

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(97);

var _lodash = __webpack_require__(79);

var _reactSidebar = __webpack_require__(432);

var _reactSidebar2 = _interopRequireDefault(_reactSidebar);

var _schedulingEnvironmentHeaderComponent = __webpack_require__(3427);

var _schedulingEnvironmentHeaderComponent2 = _interopRequireDefault(_schedulingEnvironmentHeaderComponent);

var _schedulingEnvironmentContainer = __webpack_require__(3428);

var _schedulingEnvironmentContainer2 = _interopRequireDefault(_schedulingEnvironmentContainer);

var _schedulingEnvironmentReservationFormContainer = __webpack_require__(3660);

var _schedulingEnvironmentReservationFormContainer2 = _interopRequireDefault(_schedulingEnvironmentReservationFormContainer);

var _schedulingActions = __webpack_require__(243);

var _types = __webpack_require__(102);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var styleSidebar = {
    root: {
        top: '56px'
    },
    sidebar: {
        width: '300px',
        padding: '5px 15px',
        background: '#ffffff',
        color: 'black',
        zIndex: 20,
        boxShadow: '-10px 0 10px -10px #f0f0f0'
    },
    overlay: {
        display: 'none'
    },
    dragHandle: {
        zIndex: 10
    }
};

var SchedulingEnvironmentPageContainer = exports.SchedulingEnvironmentPageContainer = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentPageContainer, _Component);

    function SchedulingEnvironmentPageContainer(props) {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentPageContainer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentPageContainer.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentPageContainer)).call(this, props));

        _this.onFilterChange = function () {
            var _this$props = _this.props,
                onSearchReservations = _this$props.onSearchReservations,
                schedulerFilter = _this$props.schedulerFilter;

            onSearchReservations(schedulerFilter);
        };

        _this.createReservation = function () {
            var openEnvironmentReservationForm = _this.props.openEnvironmentReservationForm;

            openEnvironmentReservationForm(null);
        };

        _this.editReservation = function (reservation) {
            var openEnvironmentReservationForm = _this.props.openEnvironmentReservationForm;

            openEnvironmentReservationForm(reservation.id);
        };

        _this.renderReservationForm = function (environmentsReservations) {
            var environments = (0, _lodash.map)(environmentsReservations, function (data) {
                return { id: data.id, title: data.title };
            });

            return _react2.default.createElement(_schedulingEnvironmentReservationFormContainer2.default, { environments: environments });
        };

        _this.addFilterApplication = function (application) {
            _this.setState({ filterEnvironmentByApplication: application });
        };

        _this.addFilterStage = function (stage) {
            _this.setState({ filterEnvironmentByStage: stage });
        };

        _this.addFilterLabels = function (labels) {
            _this.setState({ filterEnvironmentByLabels: labels });
        };

        _this.filterEnvironments = function (environments) {
            var filtered = environments;
            var _this$state = _this.state,
                filterEnvironmentByApplication = _this$state.filterEnvironmentByApplication,
                filterEnvironmentByStage = _this$state.filterEnvironmentByStage,
                filterEnvironmentByLabels = _this$state.filterEnvironmentByLabels;

            if (!(0, _lodash.isEmpty)(filterEnvironmentByApplication)) {
                var applications = _this.props.applications;

                var application = applications.find(function (app) {
                    return app.title === filterEnvironmentByApplication;
                });
                if (application) {
                    filtered = filtered.filter(function (env) {
                        return (0, _lodash.includes)(application.environments.map(function (e) {
                            return e.id;
                        }), env.id);
                    });
                } else {
                    return [];
                }
            }
            if (!(0, _lodash.isEmpty)(filterEnvironmentByStage)) {
                filtered = filtered.filter(function (env) {
                    return env.stage.title === filterEnvironmentByStage;
                });
            }
            if (!(0, _lodash.isEmpty)(filterEnvironmentByLabels)) {
                filtered = filtered.filter(function (env) {
                    return (0, _lodash.difference)(filterEnvironmentByLabels.map(function (t) {
                        return t.value;
                    }), env.labels.map(function (t) {
                        return t.title;
                    })).length === 0;
                });
            }
            return filtered;
        };

        _this.loadData = function () {
            _this.props.initHeader();
        };

        _this.state = {
            filterEnvironmentByApplication: '',
            filterEnvironmentByStage: '',
            filterEnvironmentByLabels: []
        };
        return _this;
    }

    (0, _createClass3.default)(SchedulingEnvironmentPageContainer, [{
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            var cleanSchedulingState = this.props.cleanSchedulingState;

            cleanSchedulingState();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                stages = _props.stages,
                environmentsReservations = _props.environmentsReservations,
                schedulerFilter = _props.schedulerFilter,
                reservationSidebarIsOpen = _props.reservationSidebarIsOpen,
                labels = _props.labels;

            var environmentsFiltered = this.filterEnvironments(environmentsReservations);
            var sidebarContent = reservationSidebarIsOpen ? this.renderReservationForm(environmentsFiltered) : '';
            var isNewReservationDisabled = reservationSidebarIsOpen || !environmentsReservations.length;
            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(_schedulingEnvironmentHeaderComponent2.default, {
                    applications: applications,
                    labels: labels,
                    loadHeaderData: this.loadData,
                    newReservationDisabled: isNewReservationDisabled,
                    onApplicationFilterChange: this.addFilterApplication,
                    onLabelsFilterChange: this.addFilterLabels,
                    onNewReservation: this.createReservation,
                    onStageFilterChange: this.addFilterStage,
                    schedulerFilter: schedulerFilter,
                    stages: stages
                }),
                _react2.default.createElement(
                    _reactSidebar2.default,
                    {
                        open: reservationSidebarIsOpen,
                        pullRight: true,
                        shadow: false,
                        sidebar: sidebarContent,
                        styles: styleSidebar },
                    _react2.default.createElement(_schedulingEnvironmentContainer2.default, {
                        environmentsReservations: environmentsFiltered,
                        onEventClick: this.editReservation,
                        onFilterChange: this.onFilterChange,
                        schedulerFilter: schedulerFilter })
                )
            );
        }
    }]);
    return SchedulingEnvironmentPageContainer;
}(_react.Component);

SchedulingEnvironmentPageContainer.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    cleanSchedulingState: _propTypes2.default.func.isRequired,
    environmentsReservations: _propTypes2.default.arrayOf(_types.EnvironmentReservation),
    initHeader: _propTypes2.default.func.isRequired,
    labels: _propTypes2.default.arrayOf(_types.Label),
    onSearchReservations: _propTypes2.default.func.isRequired,
    openEnvironmentReservationForm: _propTypes2.default.func,
    reservationSidebarIsOpen: _propTypes2.default.bool.isRequired,
    schedulerFilter: _types.SchedulerFilter.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        environmentsReservations: state.scheduling.environmentsReservations,
        reservationSidebarIsOpen: state.scheduling.reservationSidebarIsOpen,
        schedulerFilter: state.scheduling.schedulerFilter,
        applications: state.applicationList.applications,
        stages: state.stages.stageList,
        labels: state.labels.labelList
    };
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, { onSearchReservations: _schedulingActions.onSearchReservations, openEnvironmentReservationForm: _schedulingActions.openEnvironmentReservationForm, initHeader: _schedulingActions.initHeader, cleanSchedulingState: _schedulingActions.cleanSchedulingState })(SchedulingEnvironmentPageContainer);

/***/ }),

/***/ 3427:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _lodash = __webpack_require__(79);

var _headerComponent = __webpack_require__(244);

var _headerComponent2 = _interopRequireDefault(_headerComponent);

var _types = __webpack_require__(102);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var applicationFilterMetadata = {
    label: 'Application',
    placeholder: 'Select application...'
};

var stageFilterMetadata = {
    label: 'Stage',
    placeholder: 'Select stage...'
};

var labelsFilterMetadata = {
    label: 'Labels',
    placeholder: 'Select labels...',
    name: 'autocomplete'
};

var autocompleteHandler = function autocompleteHandler(list) {
    return function (_ref) {
        var metadata = _ref.metadata,
            objLabel = _ref.objLabel,
            suggestedElements = _ref.suggestedElements,
            value = _ref.value;

        return _promise2.default.resolve(list.filter(function (item) {
            return (0, _lodash.includes)(item[objLabel].toLowerCase(), value.toLowerCase());
        }));
    };
};

var SchedulingEnvironmentHeaderComponent = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentHeaderComponent, _Component);

    function SchedulingEnvironmentHeaderComponent(props) {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentHeaderComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentHeaderComponent)).call(this, props));

        _this.selectApplication = function (app) {
            _this.setState({ applicationSelected: app });
            _this.props.onApplicationFilterChange(app);
        };

        _this.selectStage = function (stage) {
            _this.setState({ stageSelected: stage });
            _this.props.onStageFilterChange(stage);
        };

        _this.selectLabel = function (labels) {
            _this.setState({ labelsSelected: labels });
            _this.props.onLabelsFilterChange(labels);
        };

        _this.state = {
            applicationSelected: {},
            stageSelected: {},
            labelsSelected: []
        };
        return _this;
    }

    (0, _createClass3.default)(SchedulingEnvironmentHeaderComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.loadHeaderData();
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                stages = _props.stages,
                newReservationDisabled = _props.newReservationDisabled,
                onNewReservation = _props.onNewReservation,
                labels = _props.labels;
            var _state = this.state,
                applicationSelected = _state.applicationSelected,
                stageSelected = _state.stageSelected,
                labelsSelected = _state.labelsSelected;


            var applicationsHandler = { addCandidates: autocompleteHandler(applications) };
            var stagesHandler = { addCandidates: autocompleteHandler(stages) };
            var labelsHandler = {
                autocomplete: { addCandidates: autocompleteHandler(labels.map(function (t) {
                        return { color: '', label: t.title, value: t.id };
                    })) }
            };

            return _react2.default.createElement(
                _headerComponent2.default,
                { helpUrl: 'scheduling.html' },
                _react2.default.createElement(
                    _react2.default.Fragment,
                    null,
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: applicationsHandler,
                        metadata: applicationFilterMetadata,
                        model: applicationSelected,
                        objLabel: 'title',
                        onModelChange: this.selectApplication }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        handlers: stagesHandler,
                        metadata: stageFilterMetadata,
                        model: stageSelected,
                        objLabel: 'title',
                        onModelChange: this.selectStage }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetTags, {
                        className: 'long',
                        handlers: labelsHandler,
                        inputType: 'autocomplete',
                        metadata: labelsFilterMetadata,
                        model: labelsSelected,
                        objLabel: 'label',
                        onModelChange: this.selectLabel,
                        skin: 'checkbox',
                        tagTransform: function tagTransform(t) {
                            return t;
                        } }),
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', disabled: newReservationDisabled,
                                onClick: onNewReservation },
                            'New'
                        )
                    )
                )
            );
        }
    }]);
    return SchedulingEnvironmentHeaderComponent;
}(_react.Component);

SchedulingEnvironmentHeaderComponent.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    labels: _propTypes2.default.arrayOf(_types.Label),
    loadHeaderData: _propTypes2.default.func.isRequired,
    newReservationDisabled: _propTypes2.default.bool.isRequired,
    onApplicationFilterChange: _propTypes2.default.func.isRequired,
    onLabelsFilterChange: _propTypes2.default.func.isRequired,
    onNewReservation: _propTypes2.default.func.isRequired,
    onStageFilterChange: _propTypes2.default.func.isRequired,
    stages: _propTypes2.default.arrayOf(_types.Stage)
};
SchedulingEnvironmentHeaderComponent.defaultProps = {
    applications: [],
    labels: [],
    stages: []
};
exports.default = SchedulingEnvironmentHeaderComponent;

/***/ }),

/***/ 3428:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.reservationState = exports.toastr = undefined;

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(79);

var _reactBigScheduler = __webpack_require__(155);

var _reactBigScheduler2 = _interopRequireDefault(_reactBigScheduler);

var _xlReactComponents = __webpack_require__(69);

var _moment = __webpack_require__(30);

var _moment2 = _interopRequireDefault(_moment);

var _popup = __webpack_require__(3574);

var _withDndContext = __webpack_require__(3579);

var _withDndContext2 = _interopRequireDefault(_withDndContext);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _schedulingEnvironmentCalendarHeaderComponent = __webpack_require__(3653);

var _schedulingEnvironmentCalendarHeaderComponent2 = _interopRequireDefault(_schedulingEnvironmentCalendarHeaderComponent);

var _environmentSidebarItem = __webpack_require__(907);

var _environmentSidebarItem2 = _interopRequireDefault(_environmentSidebarItem);

var _noData = __webpack_require__(343);

__webpack_require__(3656);

__webpack_require__(3658);

var _types = __webpack_require__(102);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var reservationState = exports.reservationState = {
    pending: 'PENDING',
    conflict: 'CONFLICT',
    confirmed: 'CONFIRMED'
};

var getStateDescription = function getStateDescription(state) {
    switch (state) {
        case reservationState.pending:
            return {
                title: 'Pending reservation',
                eventClass: 'event--pending',
                circleClass: 'state-circle--pending'
            };
        case reservationState.conflict:
            return {
                title: 'Possible conflict',
                eventClass: 'event--conflict',
                circleClass: 'state-circle--conflict'
            };
        case reservationState.confirmed:
            return {
                title: 'Confirmed',
                eventClass: 'event--confirmed',
                circleClass: 'state-circle--confirmed'
            };
        default:
            return {
                title: '',
                eventClass: 'event--pending',
                circleClass: 'state-circle--pending'
            };
    }
};

var getSchedulerWidth = function getSchedulerWidth() {
    // {window width}
    return window.innerWidth;
};

var getSchedulerHeight = function getSchedulerHeight() {
    // {window height} - {scheduler header} - {height of header with filters} - {height of sub navigation} - {height of main navigation}
    return window.innerHeight - 52 - 60 - 56 - 43;
};

var getWeekCellWidth = function getWeekCellWidth() {
    var newWidth = (window.innerWidth - 300) / 7;
    return newWidth < 140 ? 140 : newWidth;
};

var getDayCellWidth = function getDayCellWidth() {
    var newWidth = (window.innerWidth - 300) / 24;
    return newWidth < 80 ? 80 : newWidth;
};

var schedulerConfig = {
    schedulerWidth: getSchedulerWidth(), //'1000'
    schedulerMaxHeight: getSchedulerHeight(), //500, // Set schedulerMaxHeight to freeze first row //0
    tableHeaderHeight: 40,

    dayResourceTableWidth: 300, //160
    weekResourceTableWidth: 300, //160
    monthResourceTableWidth: 300, //160

    dayCellWidth: getDayCellWidth(), //30
    weekCellWidth: getWeekCellWidth(), // 140, // 120
    monthCellWidth: 140, //80,

    dayMaxEvents: 99,
    weekMaxEvents: 99,
    monthMaxEvents: 99,

    eventItemHeight: 18, //22,
    eventItemLineHeight: 20, // 24,
    nonAgendaSlotMinHeight: 64, //0
    dayStartFrom: 0,
    dayStopTo: 23,
    defaultEventBgColor: '#D5D5D5', //pending state, user '#D5D5D5' (@lightgray) ?
    selectedAreaColor: '#5FCBF4', // '#7EC2F3',
    nonWorkingTimeHeadColor: '#333333', //@black //'#999999',
    nonWorkingTimeHeadBgColor: '#f0f0f0', //@background //'#fff0f6',
    nonWorkingTimeBodyBgColor: '#ffffff', //'#fff0f6',

    startResizable: false, // true,
    endResizable: false, //true,
    movable: false, //true,
    creatable: false, //true,
    crossResourceMove: true,
    checkConflict: true, // false,
    scrollToTodayEnabled: true,
    eventItemPopoverEnabled: true,
    calendarPopoverEnabled: false, // true, //display calendar popover when clicking on a date label in header
    recurringEventsEnabled: true,
    headerEnabled: false, // true, //we can remove header and add custom component above calendar
    displayWeekend: true,

    resourceName: 'Resource Name',
    addMorePopoverHeaderFormat: 'MMM D, YYYY dddd', // when max event is defined
    eventItemPopoverDateFormat: 'MMM D, YYYY', // 'MMM D',
    nonAgendaDayCellHeaderFormat: 'hh:mm A', //'ha', //when is selected Day
    nonAgendaOtherCellHeaderFormat: 'dddd, MMM D', //'ddd M/D', //when is selected Week or Month

    minuteStep: 60, //30

    views: (0, _lodash.map)(_schedulingEnvironmentCalendarHeaderComponent.viewsMap, function (value) {
        return value;
    })
};

var SchedulingEnvironmentContainer = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentContainer, _Component);

    function SchedulingEnvironmentContainer(props) {
        (0, _classCallCheck3.default)(this, SchedulingEnvironmentContainer);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SchedulingEnvironmentContainer.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentContainer)).call(this, props));

        _this.initSchedulerData = function () {
            var resourceFilter = _react2.default.createElement(
                'div',
                { className: 'calendar-filter' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetFilter, { metadata: { placeholder: 'Filter by environment...' }, onUpdate: _this.filterByEnvironmentName })
            );
            var config = schedulerConfig;
            config.resourceName = resourceFilter;

            // overridden configuration has comment with default value, unnecessary configuration has removed
            var schedulerData = new _reactBigScheduler.SchedulerData((0, _moment2.default)().format(_reactBigScheduler.DATETIME_FORMAT), _reactBigScheduler.ViewTypes.Month, false, false, config);
            schedulerData.setResources([]);
            schedulerData.setEvents([]);

            return schedulerData;
        };

        _this.filterByEnvironmentName = function (name) {
            _this.props.schedulerFilter.environmentTitle = name;
            _this.props.onFilterChange();
        };

        _this.formatEnvironmentsReservations = function () {
            var schedulerData = _this.state.schedulerData;
            if (_this.props.environmentsReservations !== null) {
                schedulerData.setResources(_this.getFormattedResources());
                schedulerData.setEvents(_this.getFormattedEvents());
            } else {
                schedulerData.setResources([]);
                schedulerData.setEvents([]);
            }

            return schedulerData;
        };

        _this.getFormattedResources = function () {
            return (0, _lodash.map)(_this.props.environmentsReservations, function (data) {
                return {
                    id: data.id,
                    name: data.title,
                    stage: data.stage
                    // labels: data.labels
                };
            });
        };

        _this.getFormattedEvents = function () {
            var fatEventList = (0, _lodash.map)(_this.props.environmentsReservations, function (environmentReservation) {
                var resourceId = environmentReservation.id;
                return (0, _lodash.map)(environmentReservation.reservations, function (reservation) {
                    // TODO: read missing value from object after backend change
                    return {
                        id: reservation.id,
                        start: (0, _moment2.default)(reservation.startDate).format(_reactBigScheduler.DATETIME_FORMAT),
                        end: (0, _moment2.default)(reservation.endDate).format(_reactBigScheduler.DATETIME_FORMAT),
                        resourceId: resourceId,
                        title: _this.getTitle(reservation),
                        applications: reservation.applications,
                        state: reservationState.confirmed // reservation.state
                    };
                });
            });

            var flatEventList = (0, _lodash.flatMap)(fatEventList);
            //the event array should be sorted in ascending order by event.start property, otherwise there will be some rendering errors
            return (0, _lodash.sortBy)(flatEventList, function (event) {
                return event.start;
            });
        };

        _this.updateSchedulerEvents = function (schedulerData) {
            schedulerData.setEvents(_this.getFormattedEvents());
            _this.setState({ schedulerData: schedulerData });
        };

        _this.updateDimensions = function () {
            var schedulerData = _this.state.schedulerData;
            schedulerData.config.schedulerWidth = getSchedulerWidth();
            schedulerData.config.schedulerMaxHeight = getSchedulerHeight();
            schedulerData.config.dayCellWidth = getDayCellWidth();
            schedulerData.config.weekCellWidth = getWeekCellWidth();
            _this.setState({ schedulerData: schedulerData });
        };

        _this.prevClick = function (schedulerData) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.prev();
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.nextClick = function (schedulerData) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.next();
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.onCustomViewChange = function (view) {
            _this.onViewChange(_this.state.schedulerData, view);
        };

        _this.onViewChange = function (schedulerData, view) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.setViewType(view.viewType, view.showAgenda, view.isEventPerspective);
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.onSelectDate = function (schedulerData, date) {
            //SchedulerData.events will be clear after calling this method
            schedulerData.setDate(date);
            _this.onDateChange(schedulerData);
            _this.updateSchedulerEvents(schedulerData);
        };

        _this.nonAgendaCellHeaderTemplateResolver = function (schedulerData, item, formattedDateItems, style) {
            var headerToday = void 0;
            var datetime = schedulerData.localeMoment(item.time);

            if (schedulerData.viewType === _reactBigScheduler.ViewTypes.Day) {
                headerToday = datetime.isSame(new Date(), 'hour') ? 'header-today' : '';
            } else {
                headerToday = datetime.isSame(new Date(), 'day') ? 'header-today' : '';
            }

            return _react2.default.createElement(
                'th',
                { className: 'header3-text', key: item.time, style: style },
                formattedDateItems.map(function (formattedItem, index) {
                    return _react2.default.createElement('div', { className: headerToday,
                        dangerouslySetInnerHTML: { __html: formattedItem.replace(/[0-9]/g, '<b>$&</b>') }, key: index });
                })
            );
        };

        _this.eventItemTemplateResolver = function (schedulerData, event, bgColor, isStart, isEnd, mustAddCssClass, mustBeHeight, agendaMaxEventWidth) {
            var config = schedulerData.config;


            var popup = _react2.default.createElement(
                _popup.Popup,
                null,
                _react2.default.createElement(
                    'span',
                    { onClick: function onClick() {
                            return _this.approveReservation(event);
                        } },
                    'Approve'
                ),
                _react2.default.createElement(
                    'span',
                    { onClick: function onClick() {
                            return _this.askForChangeReservation(event);
                        } },
                    'Ask for change'
                ),
                _react2.default.createElement(
                    'span',
                    { onClick: function onClick() {
                            return _this.declineReservation(event);
                        } },
                    'Decline'
                )
            );
            var popupMenu = event.state === reservationState.pending ? popup : '';

            return _react2.default.createElement(
                'div',
                { className: 'event-item ' + getStateDescription(event.state).eventClass, id: event.id, key: event.id, style: { height: config.eventItemHeight } },
                _react2.default.createElement(
                    'span',
                    { style: { marginLeft: '10px', lineHeight: config.eventItemHeight + 'px' } },
                    schedulerData.behaviors.getEventTextFunc(schedulerData, event)
                )
            );
        };

        _this.subtitleGetter = function (schedulerData, event) {
            var title = schedulerData.behaviors.getEventTextFunc(schedulerData, event);
            var stateDescription = getStateDescription(event.state);

            return _react2.default.createElement(
                'div',
                { className: 'event-item-popover-content' },
                title.length > 0 ? _react2.default.createElement(
                    'div',
                    { className: 'event-item-popover-title' },
                    title
                ) : null,
                _react2.default.createElement(
                    'table',
                    { className: 'event-item-popover-description' },
                    _react2.default.createElement(
                        'tbody',
                        null,
                        _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'th',
                                null,
                                _react2.default.createElement('div', { className: stateDescription.circleClass })
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                stateDescription.title
                            )
                        ),
                        event.applications.length > 0 ? _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'th',
                                null,
                                _react2.default.createElement('i', { className: 'xl-icon app-icon' })
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                event.applications.map(function (application) {
                                    return application.title;
                                }).join(', ')
                            )
                        ) : null
                    )
                ),
                _react2.default.createElement(
                    'table',
                    { className: 'event-item-popover-details' },
                    _react2.default.createElement(
                        'tbody',
                        null,
                        _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'td',
                                null,
                                'From:'
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                (0, _moment2.default)(event.start).format('MMM D, YYYY - hh:mm A')
                            )
                        ),
                        _react2.default.createElement(
                            'tr',
                            null,
                            _react2.default.createElement(
                                'td',
                                null,
                                'To:'
                            ),
                            _react2.default.createElement(
                                'td',
                                null,
                                (0, _moment2.default)(event.end).format('MMM D, YYYY - hh:mm A')
                            )
                        )
                    )
                )
            );
        };

        _this.approveReservation = function (event) {
            toastr.info('Approve: [ ' + event.title + ' ]');
        };

        _this.askForChangeReservation = function (event) {
            toastr.info('Ask for change reservation: [ ' + event.title + ' ]');
        };

        _this.declineReservation = function (event) {
            toastr.info('Decline reservation: [ ' + event.title + ' ]');
        };

        _this.getTitle = function (reservation) {
            if (reservation.release) {
                return reservation.release.title;
            } else if (reservation.applications.length > 0) {
                return reservation.applications.map(function (application) {
                    return application.title;
                }).join(', ');
            } else {
                return '';
            }
        };

        _this.newEvent = function (schedulerData, slotId, slotName, start, end, type, item) {
            //before save open sidebar form
            var newFreshId = 0;
            schedulerData.events.forEach(function (item) {
                if (item.id >= newFreshId) newFreshId = item.id + 1;
            });

            var title = 'New event you just created';
            var newEvent = {
                id: newFreshId,
                title: title,
                start: start,
                end: end,
                resourceId: slotId
            };
            schedulerData.addEvent(newEvent);

            (0, _lodash.each)(_this.props.environmentsReservations, function (data) {
                if (data.id === slotId) {
                    data.reservations.push({
                        id: newFreshId,
                        startDate: (0, _moment2.default)(start).valueOf(),
                        endDate: (0, _moment2.default)(end).valueOf(),
                        state: reservationState.pending,
                        application: {
                            id: 'app_' + slotId + '_' + newFreshId,
                            title: title
                        }
                    });
                }
            });

            _this.setState({ schedulerData: schedulerData });
        };

        _this.eventClicked = function (schedulerData, event) {
            var onEventClick = _this.props.onEventClick;

            onEventClick(event);
        };

        _this.updateEventStart = function (schedulerData, event, newStart) {
            //before save open sidebar form populated with event data
            schedulerData.updateEventStart(event, newStart);
            _this.setState({ schedulerData: schedulerData });
        };

        _this.updateEventEnd = function (schedulerData, event, newEnd) {
            //before save open sidebar form populated with event data
            schedulerData.updateEventEnd(event, newEnd);
            _this.setState({ schedulerData: schedulerData });
        };

        _this.moveEvent = function (schedulerData, event, slotId, slotName, start, end) {
            //before save open sidebar form populated with event data
            schedulerData.moveEvent(event, slotId, slotName, start, end);
            _this.setState({ schedulerData: schedulerData });
        };

        _this.conflictOccurred = function (schedulerData, action, event) {
            //implement conflict functionality
            toastr.warning('Conflict occurred. {action: ' + action + ', event: { newSlotName: ' + event.slotName + ', newStart: ' + event.start + ', newEnd: ' + event.end + ' } }');
        };

        _this.slotItemTemplateResolver = function (schedulerData, item) {
            var environmentsReservations = _this.props.environmentsReservations;

            var environment = (0, _lodash.find)(environmentsReservations, function (env) {
                return env.id === item.slotId;
            });
            return _react2.default.createElement(_environmentSidebarItem2.default, { environment: environment });
        };

        _this.state = {
            schedulerData: _this.initSchedulerData()
        };
        return _this;
    }

    (0, _createClass3.default)(SchedulingEnvironmentContainer, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.filterByEnvironmentName('');
            window.addEventListener('resize', this.updateDimensions);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            window.removeEventListener('resize', this.updateDimensions);
        }
    }, {
        key: 'onDateChange',
        value: function onDateChange(schedulerData) {
            this.props.schedulerFilter.from = (0, _moment2.default)(schedulerData.startDate, 'YYYY-MM-DD').startOf('day').valueOf();
            this.props.schedulerFilter.to = (0, _moment2.default)(schedulerData.endDate, 'YYYY-MM-DD').endOf('day').valueOf();
            this.props.onFilterChange();
        }

        //TODO: sketch of implementation for future tasks

    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            // const schedulerData = this.props.schedulerData;
            var schedulerData = this.formatEnvironmentsReservations();

            return _react2.default.createElement(
                'div',
                { id: 'scheduler-environment' },
                _react2.default.createElement(_schedulingEnvironmentCalendarHeaderComponent2.default, {
                    customNextClick: function customNextClick() {
                        return _this2.nextClick(schedulerData);
                    },
                    customPrevClick: function customPrevClick() {
                        return _this2.prevClick(schedulerData);
                    },
                    dateLabel: schedulerData.getDateLabel(),
                    onViewChange: this.onCustomViewChange,
                    selectedViewType: schedulerData.viewType,
                    title: 'Environments',
                    todayClick: function todayClick() {
                        return _this2.onSelectDate(schedulerData, (0, _moment2.default)());
                    }
                }),
                _react2.default.createElement(_reactBigScheduler2.default, {
                    conflictOccurred: this.conflictOccurred,
                    eventItemClick: this.eventClicked,
                    eventItemTemplateResolver: this.eventItemTemplateResolver,
                    moveEvent: this.moveEvent,
                    newEvent: this.newEvent,
                    nextClick: this.nextClick,
                    nonAgendaCellHeaderTemplateResolver: this.nonAgendaCellHeaderTemplateResolver,
                    onSelectDate: this.onSelectDate,
                    onViewChange: this.onViewChange,
                    prevClick: this.prevClick,
                    schedulerData: schedulerData,
                    slotItemTemplateResolver: this.slotItemTemplateResolver,
                    subtitleGetter: this.subtitleGetter,
                    updateEventEnd: this.updateEventEnd,
                    updateEventStart: this.updateEventStart
                }),
                (!schedulerData || !schedulerData.resources.length) && _react2.default.createElement(
                    'div',
                    { className: 'no-res-environments-message-container' },
                    _react2.default.createElement(_noData.NoData, { className: 'no-res-environments-message', message: 'No environments found.' })
                )
            );
        }
    }]);
    return SchedulingEnvironmentContainer;
}(_react.Component);

SchedulingEnvironmentContainer.propTypes = {
    environmentsReservations: _propTypes2.default.arrayOf(_types.EnvironmentReservation),
    onEventClick: _propTypes2.default.func.isRequired,
    onFilterChange: _propTypes2.default.func.isRequired,
    schedulerFilter: _types.SchedulerFilter.isRequired
};
exports.default = (0, _withDndContext2.default)(SchedulingEnvironmentContainer);

/***/ }),

/***/ 343:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _noData = __webpack_require__(2662);

Object.defineProperty(exports, 'NoData', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_noData).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 344:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.createErrorMessage = exports.validateMaxLength = exports.itemAlreadyDefined = undefined;

var _defineProperty2 = __webpack_require__(18);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _findIndex = __webpack_require__(2681);

var _findIndex2 = _interopRequireDefault(_findIndex);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var existByField = function existByField(list, field, value) {
    return (0, _findIndex2.default)(list, function (e) {
        return e[field].toLowerCase() === value.toLowerCase();
    }) > -1;
};

var findById = function findById(list, id, defaultField) {
    return list.find(function (e) {
        return e.id === id;
    }) || (0, _defineProperty3.default)({}, defaultField, '');
};

var itemAlreadyDefined = exports.itemAlreadyDefined = function itemAlreadyDefined(list, selectedId, field, value) {
    return existByField(list, field, value) && findById(list, selectedId, field)[field].toLowerCase() !== value.toLowerCase();
};

var validateMaxLength = exports.validateMaxLength = function validateMaxLength(inputText, maxLength) {
    return inputText && inputText.length > maxLength;
};

var createErrorMessage = exports.createErrorMessage = function createErrorMessage(text) {
    return { show: false, text: text, type: 'ERROR' };
};

/***/ }),

/***/ 3574:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _popup = __webpack_require__(3575);

Object.defineProperty(exports, 'Popup', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_popup).default;
  }
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/***/ }),

/***/ 3575:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _clickOutside = __webpack_require__(3576);

var _clickOutside2 = _interopRequireDefault(_clickOutside);

var _popupTrigger = __webpack_require__(3577);

var _popupTrigger2 = _interopRequireDefault(_popupTrigger);

__webpack_require__(1012);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Trigger = (0, _clickOutside2.default)()(_popupTrigger2.default);

var Popup = function (_Component) {
  (0, _inherits3.default)(Popup, _Component);

  function Popup(props) {
    (0, _classCallCheck3.default)(this, Popup);

    var _this = (0, _possibleConstructorReturn3.default)(this, (Popup.__proto__ || (0, _getPrototypeOf2.default)(Popup)).call(this, props));

    _this.onClickOutside = function () {
      var onStateChange = _this.props.onStateChange;


      _this.setState({
        isOpen: false
      });

      if (onStateChange) {
        onStateChange(false);
      }
    };

    _this.toggleDropdown = function (e) {
      e.stopPropagation();
      var onStateChange = _this.props.onStateChange;

      var state = !_this.state.isOpen;

      _this.setState({
        isOpen: state
      });

      if (onStateChange) {
        onStateChange(state);
      }
    };

    _this.state = {
      isOpen: false
    };
    return _this;
  }

  (0, _createClass3.default)(Popup, [{
    key: 'render',
    value: function render() {
      return _react2.default.createElement(
        'div',
        { className: 'popup__container ' + (this.state.isOpen ? 'popup--expanded' : '') },
        _react2.default.createElement(
          Trigger,
          {
            enable: this.state.isOpen,
            onClick: this.toggleDropdown,
            onClickOutside: this.onClickOutside
          },
          _react2.default.createElement(
            'div',
            {
              className: 'popup__content ' + (this.state.isOpen ? 'popup__content--open' : ''),
              role: 'presentation'
            },
            this.props.children
          )
        )
      );
    }
  }]);
  return Popup;
}(_react.Component);

Popup.propTypes = {
  children: _propTypes2.default.oneOfType([_propTypes2.default.arrayOf(_propTypes2.default.node), _propTypes2.default.node]).isRequired,
  onStateChange: _propTypes2.default.func
};
exports.default = Popup;

/***/ }),

/***/ 3576:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = __webpack_require__(16);

var _reactDom2 = _interopRequireDefault(_reactDom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function clickOutside() {
  return function (WrappedComponent) {
    return function (_Component) {
      (0, _inherits3.default)(WithClickOutside, _Component);
      (0, _createClass3.default)(WithClickOutside, null, [{
        key: 'propTypes',
        get: function get() {
          return {
            enable: _propTypes2.default.bool,
            onClickOutside: _propTypes2.default.func.isRequired
          };
        }
      }, {
        key: 'defaultProps',
        get: function get() {
          return {
            enable: true
          };
        }
      }]);

      function WithClickOutside(props) {
        (0, _classCallCheck3.default)(this, WithClickOutside);

        var _this = (0, _possibleConstructorReturn3.default)(this, (WithClickOutside.__proto__ || (0, _getPrototypeOf2.default)(WithClickOutside)).call(this, props));

        _this.mounted = true;
        _this.handleDocumentClick = _this.handleDocumentClick.bind(_this);
        return _this;
      }

      (0, _createClass3.default)(WithClickOutside, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
          document.addEventListener('click', this.handleDocumentClick, false);
          document.addEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
          this.mounted = false;
          document.removeEventListener('click', this.handleDocumentClick, false);
          document.removeEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: 'handleDocumentClick',
        value: function handleDocumentClick(event) {
          if (this.mounted && this.props.enable) {
            /* eslint-disable react/no-find-dom-node */
            if (!_reactDom2.default.findDOMNode(this).contains(event.target)) {
              if (this.props.onClickOutside) {
                this.props.onClickOutside();
              }
            }
          }
        }
      }, {
        key: 'render',
        value: function render() {
          return _react2.default.createElement(WrappedComponent, this.props);
        }
      }]);
      return WithClickOutside;
    }(_react.Component);
  };
} /* global document */
exports.default = clickOutside;

/***/ }),

/***/ 3577:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

__webpack_require__(1012);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PopupTrigger = function PopupTrigger(props) {
  return _react2.default.createElement(
    'div',
    { className: 'popup__trigger', onClick: props.onClick, role: 'button', tabIndex: -1 },
    props.children
  );
};

PopupTrigger.propTypes = {
  children: _propTypes2.default.element.isRequired,
  onClick: _propTypes2.default.func.isRequired
};

exports.default = PopupTrigger;

/***/ }),

/***/ 3579:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _reactDnd = __webpack_require__(640);

var _reactDndHtml5Backend = __webpack_require__(3580);

var _reactDndHtml5Backend2 = _interopRequireDefault(_reactDndHtml5Backend);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _reactDnd.DragDropContext)(_reactDndHtml5Backend2.default);

/***/ }),

/***/ 363:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var COMPOSITE_FILTER_TYPE = exports.COMPOSITE_FILTER_TYPE = 'xlrelease.CompositeFilter';
var DATE_FILTER_TYPE = exports.DATE_FILTER_TYPE = 'xlrelease.DateFilter';
var FOLDER_FILTER_TYPE = exports.FOLDER_FILTER_TYPE = 'xlrelease.FolderFilter';
var TAG_FILTER_TYPE = exports.TAG_FILTER_TYPE = 'xlrelease.TagsFilter';
var TEMPLATE_FILTER_TYPE = exports.TEMPLATE_FILTER_TYPE = 'xlrelease.TemplateFilter';

var ENTITY_ID_PLACEHOLDER = exports.ENTITY_ID_PLACEHOLDER = "-1";

var DEFAULT_TIME_PERIOD = exports.DEFAULT_TIME_PERIOD = 'LAST_SIX_MONTHS';

/***/ }),

/***/ 3653:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.viewsMap = undefined;

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactBigScheduler = __webpack_require__(155);

var _xlReactComponents = __webpack_require__(69);

__webpack_require__(3654);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var viewsMap = exports.viewsMap = {
    0: { viewName: 'Day', viewType: _reactBigScheduler.ViewTypes.Day, showAgenda: false, isEventPerspective: false },
    1: { viewName: 'Week', viewType: _reactBigScheduler.ViewTypes.Week, showAgenda: false, isEventPerspective: false },
    2: { viewName: 'Month', viewType: _reactBigScheduler.ViewTypes.Month, showAgenda: false, isEventPerspective: false }
};

var SchedulingEnvironmentCalendarHeaderComponent = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentCalendarHeaderComponent, _Component);

    function SchedulingEnvironmentCalendarHeaderComponent() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, SchedulingEnvironmentCalendarHeaderComponent);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = SchedulingEnvironmentCalendarHeaderComponent.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentCalendarHeaderComponent)).call.apply(_ref, [this].concat(args))), _this), _this.buttonToggle = function (value) {
            _this.props.onViewChange(value);
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(SchedulingEnvironmentCalendarHeaderComponent, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                dateLabel = _props.dateLabel,
                customPrevClick = _props.customPrevClick,
                todayClick = _props.todayClick,
                customNextClick = _props.customNextClick,
                selectedViewType = _props.selectedViewType,
                title = _props.title;


            var options = [{
                value: viewsMap[0],
                label: viewsMap[0].viewName
            }, {
                value: viewsMap[1],
                label: viewsMap[1].viewName
            }, {
                value: viewsMap[2],
                label: viewsMap[2].viewName
            }];

            return _react2.default.createElement(
                'div',
                { id: 'custom-scheduler-header' },
                _react2.default.createElement(
                    'div',
                    { className: 'custom-scheduler-left-header' },
                    _react2.default.createElement(
                        'h4',
                        null,
                        title
                    )
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'custom-scheduler-right-header' },
                    _react2.default.createElement(
                        'div',
                        { className: 'col-sm-3' },
                        _react2.default.createElement(
                            'h4',
                            null,
                            dateLabel
                        )
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'col-sm-6' },
                        _react2.default.createElement(
                            'div',
                            { className: 'button-group-view' },
                            _react2.default.createElement(_xlReactComponents.XlReactToggleButton, {
                                metadata: options,
                                model: options[selectedViewType].value,
                                objLabel: 'label',
                                objValue: 'value',
                                onToggle: this.buttonToggle

                            })
                        )
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'col-sm-3 custom-right-header' },
                        _react2.default.createElement(
                            'div',
                            { className: 'button-group-calendar' },
                            _react2.default.createElement(
                                'button',
                                { className: 'button button-icon prev', onClick: customPrevClick, type: 'button' },
                                _react2.default.createElement('i', { className: 'xl-icon chevron-left-icon' })
                            ),
                            _react2.default.createElement(
                                'button',
                                { className: 'button today', onClick: todayClick, type: 'button' },
                                'Today'
                            ),
                            _react2.default.createElement(
                                'button',
                                { className: 'button button-icon next', onClick: customNextClick, type: 'button' },
                                _react2.default.createElement('i', { className: 'xl-icon chevron-right-icon' })
                            )
                        )
                    )
                )
            );
        }
    }]);
    return SchedulingEnvironmentCalendarHeaderComponent;
}(_react.Component);

SchedulingEnvironmentCalendarHeaderComponent.propTypes = {
    customNextClick: _propTypes2.default.func.isRequired,
    customPrevClick: _propTypes2.default.func.isRequired,
    dateLabel: _propTypes2.default.any.isRequired,
    onViewChange: _propTypes2.default.func.isRequired,
    selectedViewType: _propTypes2.default.number.isRequired,
    title: _propTypes2.default.string,
    todayClick: _propTypes2.default.func.isRequired
};
exports.default = SchedulingEnvironmentCalendarHeaderComponent;

/***/ }),

/***/ 3654:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3658:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3660:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRedux = __webpack_require__(97);

var _lodash = __webpack_require__(79);

var _xlReactComponents = __webpack_require__(69);

var _schedulingEnvironmentReservationFormActions = __webpack_require__(424);

var _types = __webpack_require__(102);

var _sidebarReservationForm = __webpack_require__(3661);

var _sidebarReservationForm2 = _interopRequireDefault(_sidebarReservationForm);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};
var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var SchedulingEnvironmentReservationFormContainer = function (_Component) {
    (0, _inherits3.default)(SchedulingEnvironmentReservationFormContainer, _Component);

    function SchedulingEnvironmentReservationFormContainer() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, SchedulingEnvironmentReservationFormContainer);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = SchedulingEnvironmentReservationFormContainer.__proto__ || (0, _getPrototypeOf2.default)(SchedulingEnvironmentReservationFormContainer)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
            reservationToDelete: null,
            deleteModalIsOpen: false
        }, _this.onConfirmNewReservation = function () {
            var _this$props = _this.props,
                onReserveEnvironment = _this$props.onReserveEnvironment,
                reservationModel = _this$props.reservationModel;

            onReserveEnvironment(reservationModel);
        }, _this.showDeleteConfirmationModel = function (id) {
            _this.setState({ deleteModalIsOpen: true, reservationToDelete: id });
        }, _this.onCloseDeleteConfirmationModal = function (action) {
            var reservationToDelete = _this.state.reservationToDelete;

            if (action === 'delete') {
                _this.props.onDeleteEnvironmentReservation(reservationToDelete);
            }
            _this.setState({ deleteModalIsOpen: false, reservationModel: null });
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(SchedulingEnvironmentReservationFormContainer, [{
        key: 'renderDeleteConfirmationModal',
        value: function renderDeleteConfirmationModal() {
            var deleteModalIsOpen = this.state.deleteModalIsOpen;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [cancelButton, deleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onCloseDeleteConfirmationModal,
                    show: deleteModalIsOpen,
                    title: 'Delete reservation' },
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete reservation.'
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                environments = _props.environments,
                onReserveEnvironmentCancel = _props.onReserveEnvironmentCancel,
                onReservationEnvironmentChange = _props.onReservationEnvironmentChange,
                onReservationFormChange = _props.onReservationFormChange,
                onReservationFormPristineChange = _props.onReservationFormPristineChange,
                onReservationFormValidChange = _props.onReservationFormValidChange,
                reservationModel = _props.reservationModel,
                reservationFormIsPristine = _props.reservationFormIsPristine,
                reservationFormIsValid = _props.reservationFormIsValid;


            var isEditForm = !(0, _lodash.isEmpty)(reservationModel.id);
            var isSaveEnabled = !reservationFormIsPristine && reservationFormIsValid;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                this.renderDeleteConfirmationModal(),
                _react2.default.createElement(_sidebarReservationForm2.default, {
                    applications: applications,
                    environments: environments,
                    isEditForm: isEditForm,
                    isSaveEnabled: isSaveEnabled,
                    key: reservationModel.id,
                    onCancel: onReserveEnvironmentCancel,
                    onConfirm: this.onConfirmNewReservation,
                    onDelete: this.showDeleteConfirmationModel,
                    onFormChange: onReservationFormChange,
                    onFormPristinityChange: onReservationFormPristineChange,
                    onFormValidationChange: onReservationFormValidChange,
                    onReservationEnvironmentChange: onReservationEnvironmentChange,
                    reservationModel: reservationModel })
            );
        }
    }]);
    return SchedulingEnvironmentReservationFormContainer;
}(_react.Component);

SchedulingEnvironmentReservationFormContainer.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    environments: _propTypes2.default.arrayOf(_types.Environment),
    onDeleteEnvironmentReservation: _propTypes2.default.func.isRequired,
    onReservationEnvironmentChange: _propTypes2.default.func.isRequired,
    onReservationFormChange: _propTypes2.default.func.isRequired,
    onReservationFormPristineChange: _propTypes2.default.func.isRequired,
    onReservationFormValidChange: _propTypes2.default.func.isRequired,
    onReserveEnvironment: _propTypes2.default.func.isRequired,
    onReserveEnvironmentCancel: _propTypes2.default.func.isRequired,
    reservationFormIsPristine: _propTypes2.default.bool,
    reservationFormIsValid: _propTypes2.default.bool,
    reservationModel: _types.ReservationModel
};


var mapStateToProps = function mapStateToProps(state) {
    return {
        applications: state.schedulingEnvironmentReservationForm.applications,
        reservationFormIsPristine: state.schedulingEnvironmentReservationForm.reservationFormIsPristine,
        reservationFormIsValid: state.schedulingEnvironmentReservationForm.reservationFormIsValid,
        reservationModel: state.schedulingEnvironmentReservationForm.reservationModel
    };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
    return (0, _extends3.default)({}, ownProps, stateProps, dispatchProps);
};

exports.default = (0, _reactRedux.connect)(mapStateToProps, {
    initEnvironmentReservationForm: _schedulingEnvironmentReservationFormActions.initEnvironmentReservationForm,
    onDeleteEnvironmentReservation: _schedulingEnvironmentReservationFormActions.onDeleteEnvironmentReservation,
    onReservationFormChange: _schedulingEnvironmentReservationFormActions.onReservationFormChange,
    onReservationEnvironmentChange: _schedulingEnvironmentReservationFormActions.onReservationEnvironmentChange,
    onReservationFormPristineChange: _schedulingEnvironmentReservationFormActions.onReservationFormPristineChange,
    onReservationFormValidChange: _schedulingEnvironmentReservationFormActions.onReservationFormValidChange,
    onReserveEnvironment: _schedulingEnvironmentReservationFormActions.onReserveEnvironment,
    onReserveEnvironmentCancel: _schedulingEnvironmentReservationFormActions.onReserveEnvironmentCancel
}, mergeProps)(SchedulingEnvironmentReservationFormContainer);

/***/ }),

/***/ 3661:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(79);

var _xlReactComponents = __webpack_require__(69);

var _applicationSelect = __webpack_require__(3662);

var _applicationSelect2 = _interopRequireDefault(_applicationSelect);

var _types = __webpack_require__(102);

var _widgetDatetime = __webpack_require__(3663);

var _widgetDatetime2 = _interopRequireDefault(_widgetDatetime);

__webpack_require__(3666);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var environmentFieldMetadata = {
    description: 'Environment to reserve',
    label: 'Environment',
    placeholder: 'Select environment...',
    required: true,
    requiredText: 'Environment is required'
};
var startDateFieldMetadata = {
    label: 'Start date',
    placeholder: 'Set start date...',
    description: 'Start date/time for reservation',
    required: true,
    dateFormat: 'MMM D, YYYY'
};
var endDateFieldMetadata = {
    label: 'End date',
    placeholder: 'Set end date...',
    description: 'End date/time for reservation',
    required: true,
    dateFormat: 'MMM D, YYYY'
};
var noteFieldMetadata = {
    label: 'Note',
    placeholder: 'Set note...',
    description: 'Note for approver',
    size: 'MEDIUM'
};

var SidebarReservationForm = function (_Component) {
    (0, _inherits3.default)(SidebarReservationForm, _Component);

    function SidebarReservationForm(props) {
        (0, _classCallCheck3.default)(this, SidebarReservationForm);

        var _this = (0, _possibleConstructorReturn3.default)(this, (SidebarReservationForm.__proto__ || (0, _getPrototypeOf2.default)(SidebarReservationForm)).call(this, props));

        _this.onEnvironmentChange = function (environment) {
            var _this$props = _this.props,
                reservationModel = _this$props.reservationModel,
                onFormChange = _this$props.onFormChange,
                onReservationEnvironmentChange = _this$props.onReservationEnvironmentChange;

            onFormChange((0, _extends3.default)({}, reservationModel, {
                applications: [],
                environment: environment
            }));
            onReservationEnvironmentChange(environment);
        };

        _this.onApplicationChange = function (selectedApplications) {
            var _this$props2 = _this.props,
                onFormChange = _this$props2.onFormChange,
                reservationModel = _this$props2.reservationModel;


            onFormChange((0, _extends3.default)({}, reservationModel, {
                applications: selectedApplications
            }));
        };

        _this.onNoteChange = function (note) {
            var _this$props3 = _this.props,
                reservationModel = _this$props3.reservationModel,
                onFormChange = _this$props3.onFormChange;

            if (note !== reservationModel.note) {
                onFormChange((0, _extends3.default)({}, reservationModel, {
                    note: note
                }));
            }
        };

        _this.onStartDatetimeChange = function (startDate) {
            var _this$props4 = _this.props,
                reservationModel = _this$props4.reservationModel,
                onFormChange = _this$props4.onFormChange;

            if (startDate !== reservationModel.startDate) {
                onFormChange((0, _extends3.default)({}, reservationModel, {
                    startDate: startDate
                }));
            }
        };

        _this.onEndDatetimeChange = function (endDate) {
            var _this$props5 = _this.props,
                reservationModel = _this$props5.reservationModel,
                onFormChange = _this$props5.onFormChange;

            if (endDate !== reservationModel.endDate) {
                onFormChange((0, _extends3.default)({}, reservationModel, {
                    endDate: endDate
                }));
            }
        };

        _this.onEnvironmentPristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state = _this.state,
                applicationsPristine = _this$state.applicationsPristine,
                startDatePristine = _this$state.startDatePristine,
                startTimePristine = _this$state.startTimePristine,
                endDatePristine = _this$state.endDatePristine,
                endTimePristine = _this$state.endTimePristine,
                notePristine = _this$state.notePristine;


            _this.setState({ environmentPristine: pristine });
            var isFormPristine = pristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onApplicationsPristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state2 = _this.state,
                environmentPristine = _this$state2.environmentPristine,
                startDatePristine = _this$state2.startDatePristine,
                startTimePristine = _this$state2.startTimePristine,
                endDatePristine = _this$state2.endDatePristine,
                endTimePristine = _this$state2.endTimePristine,
                notePristine = _this$state2.notePristine;


            _this.setState({ applicationsPristine: pristine });
            var isFormPristine = pristine && environmentPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onStartDatePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state3 = _this.state,
                environmentPristine = _this$state3.environmentPristine,
                applicationsPristine = _this$state3.applicationsPristine,
                startTimePristine = _this$state3.startTimePristine,
                endDatePristine = _this$state3.endDatePristine,
                endTimePristine = _this$state3.endTimePristine,
                notePristine = _this$state3.notePristine;


            _this.setState({ startDatePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startTimePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onStartTimePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state4 = _this.state,
                environmentPristine = _this$state4.environmentPristine,
                applicationsPristine = _this$state4.applicationsPristine,
                startDatePristine = _this$state4.startDatePristine,
                endDatePristine = _this$state4.endDatePristine,
                endTimePristine = _this$state4.endTimePristine,
                notePristine = _this$state4.notePristine;


            _this.setState({ startTimePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && endDatePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onEndDatePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state5 = _this.state,
                environmentPristine = _this$state5.environmentPristine,
                applicationsPristine = _this$state5.applicationsPristine,
                startDatePristine = _this$state5.startDatePristine,
                startTimePristine = _this$state5.startTimePristine,
                endTimePristine = _this$state5.endTimePristine,
                notePristine = _this$state5.notePristine;


            _this.setState({ endDatePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endTimePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onEndTimePristineChange = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state6 = _this.state,
                environmentPristine = _this$state6.environmentPristine,
                applicationsPristine = _this$state6.applicationsPristine,
                startDatePristine = _this$state6.startDatePristine,
                startTimePristine = _this$state6.startTimePristine,
                endDatePristine = _this$state6.endDatePristine,
                notePristine = _this$state6.notePristine;


            _this.setState({ endTimePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && notePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onNotePristine = function (pristine) {
            var onFormPristinityChange = _this.props.onFormPristinityChange;
            var _this$state7 = _this.state,
                environmentPristine = _this$state7.environmentPristine,
                applicationsPristine = _this$state7.applicationsPristine,
                startDatePristine = _this$state7.startDatePristine,
                startTimePristine = _this$state7.startTimePristine,
                endDatePristine = _this$state7.endDatePristine,
                endTimePristine = _this$state7.endTimePristine;


            _this.setState({ notePristine: pristine });
            var isFormPristine = pristine && environmentPristine && applicationsPristine && startDatePristine && startTimePristine && endDatePristine && endTimePristine;
            onFormPristinityChange(isFormPristine);
        };

        _this.onEnvironmentValidityChange = function (valid) {
            var onFormValidationChange = _this.props.onFormValidationChange;


            _this.isEnvironmentValid = valid;
            onFormValidationChange(_this.isReservationFormValid);
        };

        _this.onStartDateTimeValidityChange = function (valid) {
            var onFormValidationChange = _this.props.onFormValidationChange;


            _this.isStartDateTimeValid = valid;
            onFormValidationChange(_this.isReservationFormValid);
        };

        _this.onEndDateTimeValidityChange = function (valid) {
            var onFormValidationChange = _this.props.onFormValidationChange;


            _this.isEndDateTimeValid = valid;
            onFormValidationChange(_this.isReservationFormValid);
        };

        _this.state = {
            environmentPristine: true,
            applicationsPristine: true,
            startDatePristine: true,
            startTimePristine: true,
            endDatePristine: true,
            endTimePristine: true,
            notePristine: true
        };

        _this.isEnvironmentValid = false;
        _this.isStartDateTimeValid = false;
        _this.isEndDateTimeValid = false;
        return _this;
    }

    (0, _createClass3.default)(SidebarReservationForm, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                applications = _props.applications,
                environments = _props.environments,
                isEditForm = _props.isEditForm,
                onCancel = _props.onCancel,
                onConfirm = _props.onConfirm,
                onDelete = _props.onDelete,
                reservationModel = _props.reservationModel,
                isSaveEnabled = _props.isSaveEnabled;


            var autocompleteHandler = function autocompleteHandler(_ref) {
                var metadata = _ref.metadata,
                    objLabel = _ref.objLabel,
                    suggestedElements = _ref.suggestedElements,
                    value = _ref.value;

                return _promise2.default.resolve((0, _lodash.orderBy)(environments.filter(function (env) {
                    return (0, _lodash.includes)(env.title.toLowerCase(), value.toLowerCase());
                }), ['title']));
            };
            var autocompleteHandlers = { addCandidates: autocompleteHandler };

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                !!isEditForm ? _react2.default.createElement(
                    'h4',
                    null,
                    'Edit reservation'
                ) : _react2.default.createElement(
                    'h4',
                    null,
                    'New reservation'
                ),
                _react2.default.createElement(
                    'div',
                    { id: 'environment-reservation-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetAutocomplete, {
                        disabled: isEditForm,
                        handlers: autocompleteHandlers,
                        metadata: environmentFieldMetadata,
                        model: reservationModel.environment,
                        objLabel: 'title',
                        onModelChange: this.onEnvironmentChange,
                        onPristinityChange: this.onEnvironmentPristineChange,
                        onValidityChange: this.onEnvironmentValidityChange }),
                    _react2.default.createElement(_applicationSelect2.default, {
                        model: reservationModel.applications,
                        onModelChange: this.onApplicationChange,
                        onPristinityChange: this.onApplicationsPristineChange,
                        suggestions: applications
                    }),
                    _react2.default.createElement(_widgetDatetime2.default, {
                        metadata: startDateFieldMetadata,
                        model: reservationModel.startDate,
                        onDatePristinityChange: this.onStartDatePristineChange,
                        onModelChange: this.onStartDatetimeChange,
                        onTimePristinityChange: this.onStartTimePristineChange,
                        onValidityChange: this.onStartDateTimeValidityChange }),
                    _react2.default.createElement(_widgetDatetime2.default, {
                        metadata: endDateFieldMetadata,
                        model: reservationModel.endDate,
                        onDatePristinityChange: this.onEndDatePristineChange,
                        onModelChange: this.onEndDatetimeChange,
                        onTimePristinityChange: this.onEndTimePristineChange,
                        onValidityChange: this.onEndDateTimeValidityChange }),
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: noteFieldMetadata,
                        model: reservationModel.note,
                        onModelChange: this.onNoteChange,
                        onPristinityChange: this.onNotePristine }),
                    _react2.default.createElement(
                        'div',
                        { className: 'text-right' },
                        _react2.default.createElement(
                            'button',
                            { className: 'button cancel', onClick: onCancel },
                            'Cancel'
                        ),
                        isEditForm && _react2.default.createElement(
                            'button',
                            { className: 'button default', onClick: function onClick() {
                                    return onDelete(reservationModel.id);
                                } },
                            'Delete'
                        ),
                        _react2.default.createElement(
                            'button',
                            { className: 'button primary', disabled: !isSaveEnabled, onClick: onConfirm },
                            'Reserve'
                        )
                    )
                )
            );
        }
    }, {
        key: 'isReservationFormValid',
        get: function get() {
            return this.isEnvironmentValid && this.isStartDateTimeValid && this.isEndDateTimeValid;
        }
    }]);
    return SidebarReservationForm;
}(_react.Component);

SidebarReservationForm.propTypes = {
    applications: _propTypes2.default.arrayOf(_types.Application),
    environments: _propTypes2.default.arrayOf(_types.Environment).isRequired,
    isEditForm: _propTypes2.default.bool.isRequired,
    isSaveEnabled: _propTypes2.default.bool,
    onCancel: _propTypes2.default.func.isRequired,
    onConfirm: _propTypes2.default.func.isRequired,
    onDelete: _propTypes2.default.func.isRequired,
    onFormChange: _propTypes2.default.func.isRequired,
    onFormPristinityChange: _propTypes2.default.func.isRequired,
    onFormValidationChange: _propTypes2.default.func.isRequired,
    onReservationEnvironmentChange: _propTypes2.default.func.isRequired,
    reservationModel: _types.ReservationModel
};
exports.default = SidebarReservationForm;

/***/ }),

/***/ 3662:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _xlReactComponents = __webpack_require__(69);

var _lodash = __webpack_require__(79);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var applicationFieldMetadata = {
    description: 'Applications that will use this environment',
    label: 'Applications',
    name: 'autocomplete',
    placeholder: 'Select applications...'
};

var ApplicationSelect = function (_Component) {
    (0, _inherits3.default)(ApplicationSelect, _Component);

    function ApplicationSelect(props) {
        (0, _classCallCheck3.default)(this, ApplicationSelect);

        var _this = (0, _possibleConstructorReturn3.default)(this, (ApplicationSelect.__proto__ || (0, _getPrototypeOf2.default)(ApplicationSelect)).call(this, props));

        _this.getSuggestedApplications = function (_ref) {
            var metadata = _ref.metadata,
                objLabel = _ref.objLabel,
                suggestedElements = _ref.suggestedElements,
                value = _ref.value;
            var suggestions = _this.props.suggestions;

            var term = value.trim().toLowerCase();

            var apps = suggestions.filter(function (s) {
                return s.title.toLowerCase().indexOf(term) >= 0;
            }).map(function (s) {
                return { value: s.title };
            });

            return _promise2.default.resolve(apps);
        };

        _this.handleModelChange = function (changes) {
            var _this$props = _this.props,
                suggestions = _this$props.suggestions,
                onModelChange = _this$props.onModelChange;


            var selectedTitles = changes.map(function (ch) {
                return ch.value;
            });
            var selectedApplications = suggestions.filter(function (app) {
                return (0, _lodash.includes)(selectedTitles, app.title);
            });
            onModelChange(selectedApplications);
        };

        _this.applicationInputHandlers = {
            autocomplete: {
                addCandidates: _this.getSuggestedApplications.bind(_this)
            }
        };
        return _this;
    }

    (0, _createClass3.default)(ApplicationSelect, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                model = _props.model,
                onPristinityChange = _props.onPristinityChange;

            var selectedApplications = model.map(function (app) {
                return {
                    value: app.title,
                    label: app.title
                };
            });

            return _react2.default.createElement(_xlReactComponents.XlReactWidgetTags, {
                handlers: this.applicationInputHandlers,
                inputType: 'autocomplete',
                metadata: applicationFieldMetadata,
                model: selectedApplications,
                objLabel: 'value',
                onModelChange: this.handleModelChange,
                onPristinityChange: onPristinityChange,
                skin: 'checkbox',
                tagTransform: function tagTransform(_) {
                    return _;
                }
            });
        }
    }]);
    return ApplicationSelect;
}(_react.Component);

ApplicationSelect.propTypes = {
    model: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        title: _propTypes2.default.string
    })),
    onModelChange: _propTypes2.default.func.isRequired,
    onPristinityChange: _propTypes2.default.func.isRequired,
    suggestions: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        title: _propTypes2.default.string
    }))
};
ApplicationSelect.defaultProps = {
    model: [],
    suggestions: []
};
exports.default = ApplicationSelect;

/***/ }),

/***/ 3663:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(79);

var _xlReactComponents = __webpack_require__(69);

__webpack_require__(3664);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var WidgetDateTime = function (_Component) {
    (0, _inherits3.default)(WidgetDateTime, _Component);

    function WidgetDateTime(props) {
        (0, _classCallCheck3.default)(this, WidgetDateTime);

        var _this = (0, _possibleConstructorReturn3.default)(this, (WidgetDateTime.__proto__ || (0, _getPrototypeOf2.default)(WidgetDateTime)).call(this, props));

        _this.onStartDateChange = function (selectedDate) {
            var _this$props = _this.props,
                model = _this$props.model,
                onModelChange = _this$props.onModelChange;

            var startDate = (0, _lodash.clone)(model);
            startDate.setFullYear(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate());

            if (startDate !== model) {
                onModelChange(startDate);
            }
        };

        _this.onStartTimeChange = function (selectedDate) {
            var _this$props2 = _this.props,
                model = _this$props2.model,
                onModelChange = _this$props2.onModelChange;

            var startDate = (0, _lodash.clone)(model);
            startDate.setHours(selectedDate.getHours(), selectedDate.getMinutes());

            if (startDate !== model) {
                onModelChange(startDate);
            }
        };

        _this.onDatePristine = function (pristine) {
            var onDatePristinityChange = _this.props.onDatePristinityChange;


            _this.setState({ datePristine: pristine });
            onDatePristinityChange(pristine);
        };

        _this.onTimePristine = function (pristine) {
            var onTimePristinityChange = _this.props.onTimePristinityChange;


            _this.setState({ timePristine: pristine });
            onTimePristinityChange(pristine);
        };

        _this.onTimeValidityChange = function (valid) {
            var onValidityChange = _this.props.onValidityChange;


            _this.isTimeValid = valid;
            onValidityChange(_this.isFormValid);
        };

        _this.onDateValidityChange = function (valid) {
            var onValidityChange = _this.props.onValidityChange;


            _this.isDateValid = valid;
            onValidityChange(_this.isFormValid);
        };

        _this.state = {
            datePristine: true,
            timePristine: true
        };

        _this.isDateValid = false;
        _this.isTimeValid = false;
        return _this;
    }

    (0, _createClass3.default)(WidgetDateTime, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                model = _props.model,
                metadata = _props.metadata;


            return _react2.default.createElement(
                'div',
                { className: 'xl-react-components widget-datetime' },
                _react2.default.createElement(_xlReactComponents.XlReactWidgetLabel, { metadata: metadata }),
                _react2.default.createElement(_xlReactComponents.XlReactWidgetDate, {
                    dateFormat: metadata.dateFormat,
                    model: model,
                    onModelChange: this.onStartDateChange,
                    onPristinityChange: this.onDatePristine,
                    onValidityChange: this.onDateValidityChange }),
                _react2.default.createElement(_xlReactComponents.XlReactWidgetTime, {
                    model: model,
                    onModelChange: this.onStartTimeChange,
                    onPristinityChange: this.onTimePristine,
                    onValidityChange: this.onTimeValidityChange }),
                _react2.default.createElement(
                    'div',
                    { className: 'xl-react-components-description' },
                    _react2.default.createElement(
                        'div',
                        null,
                        metadata.description
                    )
                )
            );
        }
    }, {
        key: 'isFormValid',
        get: function get() {
            return this.isDateValid && this.isTimeValid;
        }
    }]);
    return WidgetDateTime;
}(_react.Component);

WidgetDateTime.propTypes = {
    metadata: _propTypes2.default.object,
    model: _propTypes2.default.any,
    onDatePristinityChange: _propTypes2.default.func.isRequired,
    onModelChange: _propTypes2.default.func.isRequired,
    onTimePristinityChange: _propTypes2.default.func.isRequired,
    onValidityChange: _propTypes2.default.func.isRequired
};
exports.default = WidgetDateTime;

/***/ }),

/***/ 3664:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3666:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3668:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3669);

__webpack_require__(3672);

__webpack_require__(3680);

__webpack_require__(3681);

__webpack_require__(3682);

__webpack_require__(3683);

__webpack_require__(3684);

__webpack_require__(3689);

__webpack_require__(3691);

__webpack_require__(3693);

__webpack_require__(3695);

__webpack_require__(3697);

__webpack_require__(3699);

__webpack_require__(3701);

/***/ }),

/***/ 3669:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _xlrTileHelper = __webpack_require__(3670);

var _xlrTileHelper2 = _interopRequireDefault(_xlrTileHelper);

__webpack_require__(3671);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_xlrTileHelper2.default.factory.$inject = ['Window'];

angular.module('xlrelease').factory('XlrTileHelper', _xlrTileHelper2.default.factory);

/***/ }),

/***/ 3670:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var XlrTileHelper = function () {
    function XlrTileHelper(Window) {
        var _this = this;

        (0, _classCallCheck3.default)(this, XlrTileHelper);

        this._Window = Window;
        this._taskStatusToTileStatus = {
            COMPLETED: 'completed',
            IN_PROGRESS: 'progress',
            PLANNED: 'planned',
            PENDING: 'planned',
            PRECONDITION_IN_PROGRESS: 'progress',
            WAITING_FOR_INPUT: 'progress',
            FAILED: 'failed',
            SKIPPED: 'skipped',
            COMPLETED_IN_ADVANCE: 'success',
            SKIPPED_IN_ADVANCE: 'skipped',
            ABORTED: 'skipped'
        };

        this.adjustGridHeight = function () {
            var container = angular.element(".grid-container");
            container.height(_this._Window.height() - container.offset().top - 35);
        };
    }

    (0, _createClass3.default)(XlrTileHelper, [{
        key: 'countTasksByStatus',
        value: function countTasksByStatus(tasks, counts) {
            counts = {
                completed: 0,
                progress: 0,
                planned: 0,
                failed: 0,
                skipped: 0
            };

            tasks.forEach(function (build) {
                counts[build.taskStatusCategory] += 1;
            });
            return counts;
        }
    }, {
        key: 'getCategoryByTaskStatus',
        value: function getCategoryByTaskStatus(taskStatus) {
            return this._taskStatusToTileStatus[taskStatus];
        }
    }, {
        key: 'getGridOptions',
        value: function getGridOptions(data, columnDefs) {
            return {
                enableSorting: false,
                enableRowHeaderSelection: false,
                multiSelect: false,
                data: data,
                enableFiltering: true,
                enableColumnResize: true,
                columnDefs: columnDefs,
                onRegisterApi: this.adjustGridHeight
            };
        }
    }, {
        key: 'getChartOptions',
        value: function getChartOptions(options) {
            return {
                topTitleText: function topTitleText() {
                    return "" + options.total;
                },
                bottomTitleText: function bottomTitleText() {
                    return options.total === 1 ? options.label.toLowerCase() : options.label.toLowerCase() + 's';
                },
                series: function series(data) {
                    return [{
                        name: options.label + 's',
                        data: [{
                            y: data.completed,
                            name: 'Completed',
                            color: '#499D2B'
                        }, {
                            y: data.progress,
                            name: 'In progress',
                            color: '#40ADE6'
                        }, {
                            y: data.planned,
                            name: 'Planned',
                            color: '#DDD'
                        }, {
                            y: data.failed,
                            name: 'Failed',
                            color: '#9A2C2E'
                        }, {
                            y: data.skipped,
                            name: 'Skipped',
                            color: '#C3C3C3'
                        }]
                    }];
                },
                showLegend: false,
                donutThickness: '80%'
            };
        }
    }], [{
        key: 'factory',
        value: function factory(Window) {
            return new XlrTileHelper(Window);
        }
    }]);
    return XlrTileHelper;
}();

exports.default = XlrTileHelper;

/***/ }),

/***/ 3671:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('donutChart', ['reportConfigurationService', 'Events', function (reportConfigurationService, Events) {
    return {
        scope: {
            data: '=',
            options: '=' /*
                         topTitleText: Text/Function(scope.data)
                         bottomTitleText: Text/Function(scope.data)
                         series: Function(scope.data) => [{name: 'Tasks', data: [...]}]
                         showLegend: true/false
                         donutThickness: 70%
                         */
        },

        link: function link(scope, element) {

            var chart = [];

            function addTitle() {
                if (this.title) {
                    this.title.destroy();
                }

                // store chart so we can trigger when draw when the file finished resizing
                chart = this;
                var r = this.renderer,
                    x = this.series[0].center[0] + this.plotLeft,
                    y = this.series[0].center[1] + this.plotTop;

                var topTitleText = applyOrGet(scope.options.topTitleText, scope.data);
                var bottomTitleText = applyOrGet(scope.options.bottomTitleText, scope.data);

                var titleHtml = "<div><span>" + topTitleText + "</span><br><span>" + bottomTitleText + "</span></div>";
                this.title = r.label(titleHtml, x - 53, y - 12, 'rect', 0, 0, true, true, 'two-part-title').add();

                chart.container.onclick = null;
            }

            function applyOrGet(textOrFunction, args) {
                return angular.isFunction(textOrFunction) ? textOrFunction(args) : "" + textOrFunction;
            }

            var series = scope.options.series(scope.data);
            series.forEach(function (serie) {
                serie.type = 'pie';
                serie.dataLabels = {
                    enabled: false
                };
            });

            element.highcharts(reportConfigurationService.getHighchartsOptions({
                tooltip: {
                    hideDelay: 0
                },
                chart: {
                    events: {
                        load: addTitle,
                        redraw: addTitle
                    }
                },
                plotOptions: {
                    pie: {
                        showInLegend: scope.options.showLegend,
                        allowPointSelect: false,
                        innerSize: scope.options.donutThickness,
                        borderWidth: 0,
                        point: {
                            events: {
                                legendItemClick: function legendItemClick(e) {
                                    e.preventDefault();
                                }
                            }
                        }
                    }
                },
                title: {
                    text: "",
                    floating: true
                },
                series: series
            }));

            scope.$on(Events.tile.resized, function () {
                chart.reflow();
            });
        }
    };
}]);

/***/ }),

/***/ 3672:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _index = __webpack_require__(3673);

var ui = _interopRequireWildcard(_index);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

angular.module('xlrelease').component('rhRisksList', ui.RhRisksList);
angular.module('xlrelease').component('rhRisk', ui.RhRisk);

/***/ }),

/***/ 3673:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _index = __webpack_require__(3674);

Object.defineProperty(exports, 'RhRisk', {
  enumerable: true,
  get: function get() {
    return _index.RhRisk;
  }
});

var _index2 = __webpack_require__(3677);

Object.defineProperty(exports, 'RhRisksList', {
  enumerable: true,
  get: function get() {
    return _index2.RhRisksList;
  }
});

/***/ }),

/***/ 3674:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RhRisk = undefined;

var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(3675);

var _services = __webpack_require__(327);

var _services2 = __webpack_require__(197);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

var _releasesStatusService = __webpack_require__(196);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

var _riskDetector = __webpack_require__(266);

var riskDetector = _interopRequireWildcard(_riskDetector);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<div class="rh-status-container row" ng-class="{horizontal: $ctrl.horizontal}" ng-mouseenter="$ctrl.loadRiskTile()">\n    <div class="rh-status" ng-class="$ctrl.horizontal ? \'col-xs-6 \' : \'col-xs-12\'">\n        <i ng-class="$ctrl.statusClass"></i>\n        <div class="rh-risk-label">{{$ctrl.message}}</div>\n    </div>\n    <div class="rh-box" ng-class="$ctrl.horizontal ? \'col-xs-6\' : \'col-xs-12\'">\n        <div class="rh-risk" ng-class="$ctrl.riskClass">\n            <div class="text">{{$ctrl.riskScore}}</div>\n        </div>\n        <div class="rh-risk-label">Risk score</div>\n    </div>\n</div>\n';

var RhRiskController = function () {
    function RhRiskController($timeout) {
        var _this = this;

        (0, _classCallCheck3.default)(this, RhRiskController);

        this.loadRiskTile = function () {
            if ((0, _releasesStatusService2.default)().isTemplate(_this.release)) {
                _this.riskScore = 0;
                _this.riskClass = { 'check': true };
            } else {
                var domainId = (0, _ids2.default)().toDomainId(_this.release.id);

                (0, _services2.fetchRiskConfig)().then(function (riskConfigResponse) {
                    (0, _services.fetchRisks)(domainId).then(function (response) {
                        _this.$timeout(function () {
                            var _response$data = response.data,
                                riskAssessments = _response$data.riskAssessments,
                                score = _response$data.score;

                            _this.riskScore = score;
                            var releaseStatus = riskDetector.getRiskStatus(_this.release, _this.riskScore, riskConfigResponse.data);

                            _this.riskClass = {
                                'cross': releaseStatus === 'at-risk',
                                'exclamation': releaseStatus === 'attention-needed',
                                'check': releaseStatus === 'on-track',
                                'completed': riskDetector.isCompleted(_this.release)
                            };

                            _this.statusClass = {};
                            (0, _keys2.default)(_this.riskClass).forEach(function (key) {
                                return _this.statusClass['xl-icon circle-' + key + '-icon'] = _this.riskClass[key];
                            });

                            var pretty = function pretty(status) {
                                switch (status) {
                                    case 'at-risk':
                                        return 'At risk';
                                    case 'attention-needed':
                                        return 'Attention needed';
                                    case 'on-track':
                                        return 'On track';
                                }
                            };

                            if (riskDetector.isCompleted(_this.release)) {
                                _this.message = 'Completed';
                            } else {
                                if (_.isEmpty(riskAssessments)) {
                                    _this.message = '';
                                } else {
                                    _this.message = pretty(releaseStatus) + ' \u2013 ' + _.maxBy(riskAssessments, function (s) {
                                        return s.score;
                                    }).headline;
                                }
                            }
                        }, 100);
                    });
                });
            }
        };

        this.$timeout = $timeout;
    }

    (0, _createClass3.default)(RhRiskController, [{
        key: '$onInit',
        value: function $onInit() {
            this.loadRiskTile();
        }
    }]);
    return RhRiskController;
}();

RhRiskController.$inject = ['$timeout'];

var RhRisk = exports.RhRisk = {
    bindings: {
        release: '<',
        horizontal: '<'
    },
    controller: RhRiskController,
    template: template
};

/***/ }),

/***/ 3675:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3677:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RhRisksList = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _getIterator2 = __webpack_require__(222);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(3678);

var _index = __webpack_require__(327);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

var _riskDetector = __webpack_require__(266);

var riskDetector = _interopRequireWildcard(_riskDetector);

var _releasesStatusService = __webpack_require__(196);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = "\n<div class=\"rh-risks-list\" ng-if=\"$ctrl.risks.length > 0\">\n    <table>\n        <thead>\n            <tr>\n                <th class=\"col-xs-6\">Risk</th>\n                <th class=\"col-xs-6\">Risk score</th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr ng-repeat=\"risk in $ctrl.risks\" ng-class-odd=\"'odd'\" ng-class-even=\"'even'\" ng-switch=\"$ctrl.isPlanItemOverdueMessage(risk)\">\n               <td ng-switch-when=\"false\">\n                   <span class=\"xl-icon\" ng-class=\"$ctrl.getRiskMessageIconClass(risk)\"></span>\n                   <span title=\"{{risk.message}}\" class=\"rh-risk-message\" bs-tooltip display-variables=\"risk.message\" markdown></span>\n                </td>\n                <td ng-switch-default>\n                    <plan-item-overdue-message message=\"risk.message\"/>\n                </td>\n                <td>\n                   {{risk.score}}\n                </td>\n            </tr>\n        </tbody>\n    </table>\n</div>\n";

var ReleaseRisksListController = function () {
    function ReleaseRisksListController($timeout) {
        (0, _classCallCheck3.default)(this, ReleaseRisksListController);

        this.$timeout = $timeout;
    }

    (0, _createClass3.default)(ReleaseRisksListController, [{
        key: "$onInit",
        value: function $onInit() {
            var _this = this;

            if (!(0, _releasesStatusService2.default)().isTemplate(this.release)) {
                var domainId = (0, _ids2.default)().toDomainId(this.release.id);
                (0, _index.fetchRisks)(domainId).then(function (response) {
                    var risks = response.data.riskAssessments.sort(function (a, b) {
                        return b.score - a.score;
                    }).filter(function (rs) {
                        return rs.score > 0;
                    }).reduce(function (acc, rsk) {
                        var _iteratorNormalCompletion = true;
                        var _didIteratorError = false;
                        var _iteratorError = undefined;

                        try {
                            for (var _iterator = (0, _getIterator3.default)(rsk.messages), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                                var message = _step.value;

                                var risk = (0, _extends3.default)({ message: message }, rsk);
                                acc.push(risk);
                            }
                        } catch (err) {
                            _didIteratorError = true;
                            _iteratorError = err;
                        } finally {
                            try {
                                if (!_iteratorNormalCompletion && _iterator.return) {
                                    _iterator.return();
                                }
                            } finally {
                                if (_didIteratorError) {
                                    throw _iteratorError;
                                }
                            }
                        }

                        return acc;
                    }, []);
                    _this.$timeout(function () {
                        return _this.risks = risks;
                    }, 100);
                });
                this.getRiskMessageIconClass = function (risk) {
                    return riskDetector.getRiskIconClasses(risk);
                };
                this.isPlanItemOverdueMessage = function (msg) {
                    return riskDetector.isPlanItemOverdueMessage(msg);
                };
            }
        }
    }]);
    return ReleaseRisksListController;
}();

ReleaseRisksListController.$inject = ['$timeout'];

var RhRisksList = exports.RhRisksList = {
    bindings: {
        release: '<'
    },
    controller: ReleaseRisksListController,
    template: template
};

/***/ }),

/***/ 3678:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3680:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var ReleaseProgressTileViewController = function ReleaseProgressTileViewController($scope, ReleasesService, TasksService, Planner, RegionalSettings) {
    var vm = this;
    vm.isReleaseCompleted = isReleaseCompleted;
    vm.refresh = refresh;
    vm.release = $scope.release;
    vm.getStatus = getStatus;
    vm.calculateDelay = calculateDelay;
    vm.mediumDateFormat = RegionalSettings.currentMediumDateFormat;

    vm.chartOptions = {
        topTitleText: function topTitleText(data) {
            return data.completed + "/" + (data.completed + data.planned);
        },

        bottomTitleText: "tasks",
        legend: {
            borderRadius: 0
        },
        series: function series(data) {
            return [{
                name: 'Tasks',
                data: [{
                    y: data.completed,
                    name: "Completed",
                    color: "#08B153"
                }, {
                    y: data.planned,
                    name: "Planned",
                    color: "#DDD"
                }]
            }];
        },

        showLegend: true,
        donutThickness: '90%'
    };

    ///

    refresh();

    function refresh() {
        var flattenedTasks = ReleasesService.getLeafTasks(vm.release);
        var completedTasks = calculateCompletedTasks(flattenedTasks);
        vm.chartData = {
            completed: completedTasks.length,
            planned: flattenedTasks.length - completedTasks.length
        };
        vm.progress = calculateProgress(completedTasks.length, flattenedTasks.length);
        vm.estimatedEndDate = calculateEstimatedEndDate(vm.release);
    }

    function isReleaseCompleted() {
        return ReleasesService.isReleaseCompleted(vm.release);
    }

    function calculateCompletedTasks(tasks) {
        return _.filter(tasks, TasksService.isTaskReadOnly);
    }

    function calculateProgress(completed, total) {
        var progress = 0;
        if (angular.isNumber(completed) && angular.isNumber(total) && total !== 0) {
            progress = completed / total * 100;
        }
        return progress;
    }

    function calculateEstimatedEndDate(release) {
        Planner.setRelease(release);
        Planner.setReleaseTree(release.tree);
        var plan = Planner.makePlan(false);
        return plan.plannedEndDate;
    }

    function calculateDelay() {
        return moment.duration(vm.estimatedEndDate.diff(moment(vm.release.dueDate)));
    }

    function getStatus() {
        var status = "";
        if (isAborted()) {
            status = "ABORTED";
        } else if (isOnTime()) {
            status = "ON_TIME";
        } else {
            status = "DELAYED";
        }
        return status;
    }

    function isOnTime() {
        return !vm.estimatedEndDate.isAfter(moment(vm.release.dueDate));
    }

    function isAborted() {
        return ReleasesService.isReleaseAborted(vm.release);
    }
};

ReleaseProgressTileViewController.$inject = ['$scope', 'ReleasesService', 'TasksService', 'Planner', 'RegionalSettings'];

angular.module('xlrelease').controller('summary.ReleaseProgressTileViewController', ReleaseProgressTileViewController);

/***/ }),

/***/ 3681:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var ReleaseSummaryPageController = function ReleaseSummaryPageController($scope, ReleasesService, TasksService) {
    var vm = this;
    var xlrDashboard = $scope.xlrDashboard;
    vm.release = xlrDashboard.release;
    vm.isReleaseInProgress = ReleasesService.isReleaseInProgress;
    vm.isReleaseFailing = ReleasesService.isReleaseFailing;
    vm.isReleasePaused = ReleasesService.isReleasePaused;
    vm.isReleaseFailed = ReleasesService.isReleaseFailed;
    vm.isReleasePlanned = ReleasesService.isReleasePlanned;
    vm.isReleaseAborted = ReleasesService.isReleaseAborted;
    vm.isReleaseCompleted = ReleasesService.isReleaseCompleted;
    vm.hasCompletedStatus = ReleasesService.hasCompletedStatus;
    vm.isReleaseArchived = ReleasesService.isReleaseArchived;

    vm.flattenedTasks = ReleasesService.getLeafTasks(vm.release);
    vm.numberOfCompletedTasks = _.filter(vm.flattenedTasks, TasksService.isTaskReadOnly).length;
};

ReleaseSummaryPageController.$inject = ['$scope', 'ReleasesService', 'TasksService'];

angular.module('xlrelease').controller('summary.ReleaseSummaryPageController', ReleaseSummaryPageController);

/***/ }),

/***/ 3682:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var ReleaseSummaryTileViewController = function ReleaseSummaryTileViewController($scope, DateService) {
    var vm = this;
    var release = $scope.release;
    vm.isOverdue = DateService.isOverdue;
    vm.variables = release.variables;

    refresh();

    function refresh() {
        vm.releaseCurrentPhase = getActivePhase(release);
        vm.startDate = getStartDate(release);
        vm.dueDate = getDueDate(release);
        vm.releaseDuration = getDuration(release);
        vm.owner = release.owner;
    }

    function getActivePhase(release) {
        var activePhase = _.filter(release.phases, { 'active': true });
        if (activePhase && activePhase.length > 0) {
            return activePhase[0].title;
        }
        return "Not started";
    }

    function getStartDate(release) {
        return DateService.getStartOrScheduledDate(release);
    }

    function getDueDate(release) {
        return DateService.getEndOrDueDate(release);
    }

    function getDuration(release) {
        var start = DateService.getStartOrScheduledDate(release);
        var end = DateService.getEndOrDueDate(release);

        return start && end && end >= start ? end - start : undefined;
    }
};

ReleaseSummaryTileViewController.$inject = ['$scope', 'DateService'];

angular.module('xlrelease').controller('summary.ReleaseSummaryTileViewController', ReleaseSummaryTileViewController);

/***/ }),

/***/ 3683:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ResourceUsageTileController = function () {
    function ResourceUsageTileController($scope, ReleasesService, TasksService, FlagService) {
        (0, _classCallCheck3.default)(this, ResourceUsageTileController);

        if ($scope.xlrDashboard) {
            // summary page
            this._release = $scope.xlrDashboard.release;
        } else {
            // details page
            this._release = $scope.xlrTileDetailsCtrl.release;
        }

        this._UNASSIGNED_USER = null;
        this._UNASSIGNED_USER_COLOR = '#BBBBBB';

        this.$scope = $scope;
        this.ReleasesService = ReleasesService;
        this.TasksService = TasksService;
        this.FlagService = FlagService;

        this._showOwners = true;
        this._showTeams = false;

        this._colorPool = ['#B85C5A', '#644D52', '#FFDB58', '#7FB2F0', '#BEEB9F', '#35203B', '#FBF3DB', '#009CD8', '#D99E6A', '#68B749', '#8D5495', '#FF9E3B', '#566B9A', '#358F6D', '#FF5A60', '#8B8807', '#FCD364', '#5FCBF4'];

        this._chartOptions = {
            topTitleText: function topTitleText(data) {
                return _.sumBy(data, function (o) {
                    return o.y;
                });
            },
            bottomTitleText: "tasks",
            series: function series(data) {
                return [{
                    name: 'Tasks',
                    data: data
                }];
            },
            showLegend: false,
            donutThickness: '90%'
        };
        this._chartData = [];
        this._flattenedTasks = [];

        this._generateChartData();
    }

    (0, _createClass3.default)(ResourceUsageTileController, [{
        key: '_generateChartData',
        value: function _generateChartData() {
            var _this = this;

            this._flattenedTasks = this.ReleasesService.getLeafTasks(this._release);
            this._ownersTasks = this._groupTasksByProperty(this.flattenedTasks, 'owner.username');
            this._teamsTasks = this._groupTasksByProperty(this.flattenedTasks, 'team', function (team) {
                return team;
            });

            if (this._showOwners && !this._showTeams) {
                this._detailGroupedTasks = this._ownersTasks;
            } else {
                this._detailGroupedTasks = this._teamsTasks;
            }
            var graphElements = _.map(this._detailGroupedTasks, function (data) {
                return {
                    y: data.tasks.length,
                    name: _this.decorateOwnerName(data.owner),
                    color: data.owner ? _this._getColor() : _this._UNASSIGNED_USER_COLOR,
                    originalName: data.owner ? data.owner.username : null,
                    order: data.owner ? data.tasks.length : Number.MAX_VALUE
                };
            });

            this._chartData = _.sortBy(graphElements, 'originalName').reverse();
        }
    }, {
        key: '_groupTasksByProperty',
        value: function _groupTasksByProperty(tasks, propertyName) {
            var groupedTasks = _.chain(tasks).groupBy(propertyName).value();
            var groupKeys = (0, _keys2.default)(groupedTasks);
            var collectionOfTasksGroupedByProperty = [];

            var groupKeysLength = groupKeys.length;
            for (var i = 0; i < groupKeysLength; i++) {
                var key = groupKeys[i];
                collectionOfTasksGroupedByProperty.push({
                    tasks: groupedTasks[key],
                    owner: groupedTasks[key][0].owner,
                    team: groupedTasks[key][0].team
                });
            }

            return _.sortBy(collectionOfTasksGroupedByProperty, propertyName).reverse();
        }
    }, {
        key: 'decorateOwnerName',
        value: function decorateOwnerName(owner) {
            if (!owner) {
                return 'Unassigned';
            }
            if (owner.fullName) {
                return owner.fullName;
            }
            return owner.username;
        }
    }, {
        key: 'decorateTeamName',
        value: function decorateTeamName(team) {
            return team || 'Unassigned';
        }
    }, {
        key: 'selectOwners',
        value: function selectOwners() {
            this._showOwners = true;
            this._showTeams = false;
            this._detailGroupedTasks = this._ownersTasks;
        }
    }, {
        key: 'selectTeams',
        value: function selectTeams() {
            this._showOwners = false;
            this._showTeams = true;
            this._detailGroupedTasks = this._teamsTasks;
        }
    }, {
        key: 'isCurrentTask',
        value: function isCurrentTask(task) {
            return this.TasksService.isTaskInProgress(task) || this.TasksService.isTaskFailed(task) || this.TasksService.isTaskWaitingForInput(task) || this.TasksService.isTaskFailing(task);
        }
    }, {
        key: 'isCurrentTeamTask',
        value: function isCurrentTeamTask(task, team) {
            return this.TasksService.isAssignedToTeam(task, team) && this.isCurrentTask(task);
        }
    }, {
        key: 'isAssignedToTeam',
        value: function isAssignedToTeam(task, team) {
            return this.TasksService.isAssignedToTeam(task, team);
        }
    }, {
        key: 'isAssignedToUser',
        value: function isAssignedToUser(task, user) {
            return this.TasksService.isAssignedToUser(task, user) || !this.TasksService.hasOwner(task) && user === this._UNASSIGNED_USER;
        }
    }, {
        key: 'isCurrentTaskForUser',
        value: function isCurrentTaskForUser(task, user) {
            return this.isAssignedToUser(task, user) && this.isCurrentTask(task);
        }
    }, {
        key: 'isTaskFlagged',
        value: function isTaskFlagged(task) {
            return this.FlagService.isTaskFlagged(task);
        }
    }, {
        key: 'isTaskDelayed',
        value: function isTaskDelayed(task) {
            return this.TasksService.isTaskDelayed(task);
        }
    }, {
        key: '_getColor',
        value: function _getColor() {
            return this._colorPool.pop();
        }
    }, {
        key: 'release',
        get: function get() {
            return this._release;
        }
    }, {
        key: 'chartOptions',
        get: function get() {
            return this._chartOptions;
        }
    }, {
        key: 'flattenedTasks',
        get: function get() {
            return this._flattenedTasks;
        }
    }, {
        key: 'detailGroupedTasks',
        get: function get() {
            return this._detailGroupedTasks;
        }
    }, {
        key: 'chartData',
        get: function get() {
            return this._chartData;
        }
    }, {
        key: 'showOwners',
        get: function get() {
            return this._showOwners;
        }
    }, {
        key: 'showTeams',
        get: function get() {
            return this._showTeams;
        }
    }]);
    return ResourceUsageTileController;
}();

ResourceUsageTileController.$inject = ['$scope', 'ReleasesService', 'TasksService', 'FlagService'];

angular.module('xlrelease').controller('summary.ResourceUsageTileController', ResourceUsageTileController);

/***/ }),

/***/ 3684:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3685);

__webpack_require__(3686);

__webpack_require__(3687);

__webpack_require__(3688);

/***/ }),

/***/ 3685:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('statusBadge', function () {
    return {
        restrict: 'E',
        scope: {
            status: '='
        },
        template: '<span class="label {{badge.style}}">{{ badge.message }}</span>',
        link: function link($scope) {
            var badgesStyle = [];
            badgesStyle.NOT_FOUND = { style: 'label label-warning-failed', message: 'Not found' };
            badgesStyle.IN_PROGRESS = { style: 'label label-active', message: 'In progress' };
            badgesStyle.COMPLETED = { style: 'label label-completed', message: 'Completed' };
            badgesStyle.FAILED = { style: 'label label-warning-failed', message: 'Failed' };
            badgesStyle.FAILING = { style: 'label label-warning-failing', message: 'Failing' };
            badgesStyle.WAITING_FOR_INPUT = { style: 'label label-waiting', message: 'Needs input' };
            badgesStyle.PLANNED = { style: 'label label-planned', message: 'Planned' };
            badgesStyle.PENDING = { style: 'label label-pending', message: 'Pending' };
            badgesStyle.SKIPPED = { style: 'label label-default', message: 'Skipped' };
            badgesStyle.PAUSED = { style: 'label label-paused', message: 'Paused' };
            badgesStyle.ABORTED = { style: 'label label-aborted', message: 'Aborted' };
            badgesStyle.PRECONDITION_IN_PROGRESS = { style: 'label label-preconditioninprogress', message: 'Precondition' };
            badgesStyle.COMPLETED_IN_ADVANCE = { style: 'label label-completed', message: 'Completed' };
            badgesStyle.SKIPPED_IN_ADVANCE = { style: 'label label-default', message: 'Skipped' };
            badgesStyle.FAILURE_HANDLER_IN_PROGRESS = { style: 'label label-warning-failing', message: 'Handling failure' };
            badgesStyle.FACET_CHECK_IN_PROGRESS = { style: 'label label-preconditioninprogress', message: 'Verifying' };

            $scope.badge = badgesStyle[$scope.status.toUpperCase()];
        }
    };
});

/***/ }),

/***/ 3686:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var XlrTimelineDirectiveControllerInject = ['ColorService', 'DateService', 'RegionalSettings', '$filter'];
var XlrTimelineDirectiveController = function XlrTimelineDirectiveController(ColorService, DateService, RegionalSettings, $filter) {
    var vm = this;
    vm._$filter = $filter;
    vm.elapsedWidth = 0;
    vm.plannedWidth = 0;
    vm.estimatedWidth = 0;
    vm.delayWidth = 0;
    vm.timeline = {};
    vm.phases = [];
    vm.timelineHeight = 30;
    vm.phasesMargin = 85;
    vm.outgoingDependencies = [];
    vm.incomingDependencies = [];
    vm.showTimeIndicator = false;

    vm.redrawTimeline = redrawTimeline;
    vm.init = init;

    vm.buildReleaseLink = function (releaseId) {
        return '#/releases/' + releaseId + '/summary';
    };

    var CHARACTER_WIDTH = 8;

    var TIMELINE = {
        QUARTER_OF_HOUR: 15,
        HOURS_IN_A_DAY: 24,
        DAYS_IN_A_WEEK: 7,
        DAYS_IN_MONTH: 30
    };

    var METRICS = {
        MINUTES: 'minutes',
        HOURS: 'hours',
        DAYS: 'days',
        WEEKS: 'weeks',
        MONTHS: 'months'
    };

    var TIMELINE_FORMATS = {
        HOURS: function HOURS() {
            return RegionalSettings.currentTimeFormat.replace('mm', '00');
        },
        DAYS: function DAYS() {
            return RegionalSettings.currentDateFormat;
        },
        MONTHS: function MONTHS() {
            return 'MMM yyyy';
        }
    };

    var COMPARE_FORMAT = {
        HOURS: 'YYYY-MM-DD HH',
        DAYS: 'YYYY-MM-DD'
    };

    var STEP_INDENT = 5;
    var day = 24;
    var week = 168;
    var month = 672;

    function redrawTimeline(width, height) {
        if (vm.timelineData.timeline && width) {
            vm.timelineWidth = Math.ceil(width);
            vm.timelineHeight = height;
            vm.elapsedWidth = 0;
            vm.plannedWidth = 0;
            vm.delayWidth = 0;
            vm.timeline = {};
            vm.showTimeIndicator = vm.timelineData.timeline.release.status === 'IN_PROGRESS' || vm.timelineData.timeline.release.status === 'PLANNED';
            vm.phases = [];
            drawTimeline(vm.timelineData.timeline);
        }
    }

    function init(width, height) {
        redrawTimeline(width, height);
    }

    function buildPhase(phases, release) {
        var currentPhaseX = 0;
        return _.map(phases, function (phase) {
            phase.color = ColorService.computePhaseColor(release, phase);
            var calculatedPhaseX = getPhaseX(phase, vm.timeline);
            if (calculatedPhaseX < currentPhaseX) {
                phase.x = currentPhaseX;
                var widthDiff = currentPhaseX - calculatedPhaseX;
                phase.width = getPhaseWidth(phase, vm.timeline) - widthDiff;
            } else {
                phase.x = calculatedPhaseX;
                phase.width = getPhaseWidth(phase, vm.timeline);
            }
            phase.shortTitle = calculateShortTitle(phase.plainTitle ? phase.plainTitle : phase.title, phase.width);
            currentPhaseX = phase.x + phase.width;
            return phase;
        });
    }

    function buildTimelinePeriods(startDay, format, timelineScale, containerSize) {
        var timeline = [];
        for (var i = 0; i < containerSize; i++) {
            timeline.push({
                title: vm._$filter('date')(startDay.toDate(), format)
            });
            startDay = startDay.add(1, timelineScale);
        }
        return timeline;
    }

    function buildContainer(startDay, endDay, timelineScale) {
        var container = {};
        var timelineStart = moment(startDay.format(COMPARE_FORMAT.DAYS));
        var timelineEnd = moment(endDay.format(COMPARE_FORMAT.DAYS));
        container.stepUnit = 1;
        container[timelineScale] = [];
        container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);

        switch (timelineScale) {
            case METRICS.HOURS:
                container.segments = TIMELINE.QUARTER_OF_HOUR;
                container.minimalMetric = METRICS.MINUTES;
                container.stepUnit = 4;
                timelineStart = moment(startDay.format(COMPARE_FORMAT.HOURS));
                timelineEnd = moment(endDay.format(COMPARE_FORMAT.HOURS));
                container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);
                container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.HOURS(), timelineScale, container.size);
                break;
            case METRICS.DAYS:
                container.segments = TIMELINE.HOURS_IN_A_DAY;
                container.minimalMetric = METRICS.HOURS;
                container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.DAYS(), timelineScale, container.size);
                break;
            case METRICS.WEEKS:
                container.segments = TIMELINE.DAYS_IN_A_WEEK;
                container.minimalMetric = METRICS.DAYS;
                container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.DAYS(), timelineScale, container.size);
                break;
            case METRICS.MONTHS:
                timelineStart = DateService.getTodayWithTime().year(startDay.year()).month(startDay.months()).date(startDay.date());
                timelineEnd = moment(endDay.endOf('month'));
                container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);
                container.segments = TIMELINE.DAYS_IN_MONTH;
                container.minimalMetric = METRICS.DAYS;
                container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.MONTHS(), timelineScale, container.size);
                break;
        }

        container.timelineStart = timelineStart;
        container.timelineEnd = timelineEnd;
        container.metric = timelineScale;
        return container;
    }

    function drawTimeline(data) {
        if (!data || data.startDate === null || data.expectedEndDate === null) return;
        var startDay = data.startDate.clone();
        var endDay = data.expectedEndDate.clone();
        var detectMetric = calculateMetrics(startDay, endDay);
        vm.timeline = createTimeline(detectMetric);
        vm.phases = buildPhase(data.phases, data.release);
        vm.elapsedWidth = getElapsedSectionWidth(vm.timeline);
        vm.delayX = getPlannedSectionWidth(data.endDate, vm.timeline);
        vm.estimatedWidth = getPlannedSectionWidth(data.expectedEndDate, vm.timeline) - vm.phases[0].x;
        var delay = getDelaySectionWidth(data.endDate, data.expectedEndDate, vm.timeline) - vm.delayX;
        vm.delayWidth = delay > 0 ? delay : 0;
        vm.incomingDependencies = buildReleasesViews(vm.timelineData.incomingDependencies);
        vm.outgoingDependencies = buildReleasesViews(vm.timelineData.outgoingDependencies);
        if (vm.isDetailsView) {
            vm.phasesMargin = calculatePhaseMargin();
            vm.timelineHeight = calculateHeight();
        }
    }

    function calculateShortTitle(title, width) {
        if (title) {
            var actual = title;
            var maxLengthOfString = width / CHARACTER_WIDTH;

            if (actual.length > maxLengthOfString) {
                actual = actual.substring(0, maxLengthOfString);
                actual = actual + '...';
            }

            return actual;
        }
    }

    function calculateHeight() {
        var initialHeight = 250;
        var inLength = vm.incomingDependencies.length;
        if (inLength > 2) {
            initialHeight += inLength * 30;
        }
        var outLength = vm.outgoingDependencies.length;
        if (outLength > 2) {
            var delta = outLength - 2;
            initialHeight += delta * 30;
        }
        return initialHeight;
    }

    function calculatePhaseMargin() {
        var initialMargin = 120;
        var inLength = vm.incomingDependencies.length;
        if (inLength > 2) {
            var delta = inLength - 2;
            return initialMargin + delta * 30;
        }
        return initialMargin;
    }

    function calculateMetrics(startDay, endDay) {
        var container = {};

        var diff = endDay.diff(startDay, 'hours');

        if (diff < day * 1.5) {
            return buildContainer(startDay, endDay, 'hours');
        }
        if (diff >= day * 1.5 && diff < week * 3) {
            return buildContainer(startDay, endDay, 'days');
        }
        if (diff >= week * 3 && diff < month * 3) {
            return buildContainer(startDay, endDay, 'weeks');
        }
        if (diff >= month * 3) {
            return buildContainer(startDay, endDay, 'months');
        }
        return container;
    }

    function buildReleasesViews(releases) {
        return _.map(releases, function (release) {
            var releaseCoordinateX = getReleaseX(moment(release.startDate), moment(release.scheduledStartDate));
            var releaseWidth = getReleaseWidth(moment(release.startDate), moment(release.scheduledStartDate), moment(release.endDate), moment(release.dueDate));
            var actualWidth = releaseCoordinateX + releaseWidth > vm.timelineWidth ? vm.timelineWidth - releaseCoordinateX : releaseWidth;
            return {
                id: release.releaseId,
                xCord: releaseCoordinateX,
                width: actualWidth,
                title: release.releaseTitle,
                shortTitle: calculateShortTitle(release.releaseTitle, actualWidth - 30)
            };
        });
    }

    function getReleaseX(startDate, estimatedStartDate) {
        var start = startDate;
        if (!startDate.isValid()) {
            start = estimatedStartDate;
        }
        if (angular.isDefined(vm.timeline.start) && angular.isDefined(start) && start.isAfter(vm.timeline.start)) {
            var time = start.diff(vm.timeline.start, vm.timeline.minimalMetric, true);
            return time * vm.timeline.step / vm.timeline.unit;
        }
        return 0;
    }

    function getReleaseWidth(startDate, estimatedStartDate, endDate, estimatedDueDate) {
        var start = startDate;
        var end = endDate;
        if (startDate && !startDate.isValid()) {
            start = estimatedStartDate;
        }
        if (endDate && !endDate.isValid()) {
            end = estimatedDueDate;
        }
        if (angular.isDefined(vm.timeline.start) && angular.isDefined(start) && angular.isDefined(end)) {
            var time = end.diff(start, vm.timeline.minimalMetric, true);
            return time * vm.timeline.step / vm.timeline.unit;
        }
        return 0;
    }

    function getPhaseWidth(phase, timeline) {
        if (angular.isDefined(timeline.start) && angular.isDefined(phase.startDate)) {
            var time = phase.endDate.diff(phase.startDate, timeline.minimalMetric, true);
            return time * timeline.step / timeline.unit;
        }
        return 0;
    }

    function getPhaseX(phase, timeline) {
        if (angular.isDefined(timeline.start) && angular.isDefined(phase.startDate)) {
            var time = phase.startDate.diff(timeline.start, timeline.minimalMetric, true);
            return time * timeline.step / timeline.unit;
        }
        return 0;
    }

    function getPlannedSectionWidth(endDate, timeline) {
        if (angular.isDefined(endDate) && angular.isDefined(timeline.start)) {
            var time = endDate.diff(timeline.start, timeline.minimalMetric, true);
            return Math.ceil(time * timeline.step / timeline.unit);
        }
        return 0;
    }

    function getDelaySectionWidth(endDate, expectedEndDate, timeline) {
        if (expectedEndDate.isAfter(endDate)) {
            var time = expectedEndDate.diff(timeline.start, timeline.minimalMetric, true);
            return Math.ceil(time * timeline.step / timeline.unit);
        }
        return 0;
    }

    function getElapsedSectionWidth(timeline) {
        if (angular.isObject(timeline) && angular.isDefined(timeline.start)) {
            var end = DateService.getTodayWithTime();
            var time = end.diff(timeline.start, timeline.minimalMetric, true);
            return time * timeline.step / timeline.unit;
        }
        return 0;
    }

    function createTimeline(container) {

        var timeline = {};
        timeline.minimalMetric = container.minimalMetric;
        timeline.columnWidth = vm.timelineWidth / container.size;
        timeline.step = timeline.columnWidth / container.segments;
        timeline.textIndent = STEP_INDENT;
        timeline.titles = container[container.metric];
        timeline.range = [];

        timeline.unit = container.stepUnit;
        timeline.start = container.timelineStart;
        timeline.end = container.timelineEnd;
        for (var i = 0; i < container.size; i++) {
            timeline.range.push(i);
        }
        return timeline;
    }
};
XlrTimelineDirectiveController.$inject = XlrTimelineDirectiveControllerInject;

var XlrTimelineChartInject = ['$window', '$timeout', 'Events'];
var XlrTimelineChart = function XlrTimelineChart($window, $timeout, Events) {
    return {
        bindToController: {
            timelineData: '=',
            isDetailsView: '=detailView'
        },
        require: ['xlrTimelineChart', '?^xlrTile'],
        link: function link($scope, elem, attr, ctrls) {
            var ctrl = ctrls[0];
            var xlrTile = ctrls[1];

            var PANEL_BODY_PADDING = 60;

            if (ctrl.isDetailsView) {
                var resizeFn = function resizeFn() {
                    $timeout(function () {
                        ctrl.redrawTimeline($window.innerWidth - 110);
                    }, 200);
                };
                angular.element($window).bind('resize', resizeFn);
                $scope.$on('$destroy', function () {
                    angular.element($window).unbind('resize', resizeFn);
                });
                ctrl.init($window.innerWidth - 110);
            } else {
                if (xlrTile) {
                    ctrl.init(xlrTile.width, xlrTile.height - PANEL_BODY_PADDING);
                }
                $scope.$on(Events.tile.resized, function () {
                    if (xlrTile) {
                        ctrl.redrawTimeline(xlrTile.width, xlrTile.height - PANEL_BODY_PADDING);
                    }
                });
            }
        },

        controller: 'xlrTimelineDirectiveController',
        controllerAs: 'timelineCtrl',
        templateUrl: 'static/8.6.2/include/TimelineTile/partials/timeline-chart.html'
    };
};
XlrTimelineChart.$inject = XlrTimelineChartInject;

angular.module('xlrelease').controller('xlrTimelineDirectiveController', XlrTimelineDirectiveController);
angular.module('xlrelease').directive('xlrTimelineChart', XlrTimelineChart);

/***/ }),

/***/ 3687:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('Timeline', ['Planner', function (Planner) {
    return {
        init: function init(currentRelease, currentReleaseTree) {
            Planner.setRelease(currentRelease);
            Planner.setReleaseTree(currentReleaseTree);
            var plan = Planner.makePlan();
            var releasePlan = plan.plan;
            var expectedEndDate = plan.plannedEndDate;
            var startDate = plan.elements[0].displayStartDate;
            var endDate = releasePlan.displayEndDate;

            var phaseDetails = _.chain(plan.elements).filter(function (item) {
                return item.type === 'xlrelease.Phase';
            }).map(function (phase) {
                return {
                    title: phase.text,
                    plainTitle: phase.plainText,
                    startDate: moment(phase.start_date),
                    endDate: moment(phase.end_date),
                    color: phase.planItem.color
                };
            }).value();
            return {
                release: currentRelease,
                startDate: startDate,
                expectedEndDate: expectedEndDate,
                endDate: endDate,
                phases: phaseDetails
            };
        }
    };
}]);

/***/ }),

/***/ 3688:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TimelineTileController = function TimelineTileController($scope, TasksService, ReleasesService, Timeline, DependenciesService, $q) {

    var vm = this;
    vm.timelineData = {};
    vm.loading = true;

    if ($scope.xlrDashboard) {
        // summary page
        vm.release = $scope.xlrDashboard.release;
        vm.isDetailsView = false;
    } else {
        // details page
        vm.release = $scope.xlrTileDetailsCtrl.release;
        vm.isDetailsView = true;
    }

    vm.currentPhase = vm.release.currentPhase;
    vm.currentPhaseTasks = getPhaseTasks(vm.release.phases);

    function init() {
        $q.all([getDependencies(), initializeTimeline()]).then(function (_ref) {
            var _ref2 = (0, _slicedToArray3.default)(_ref, 2),
                deps = _ref2[0],
                releaseTree = _ref2[1];

            vm.timelineData.incomingDependencies = deps.data.incomingDependencies;
            vm.timelineData.outgoingDependencies = deps.data.outgoingDependencies;
            vm.timelineData.timeline = releaseTree;
            vm.loading = false;
        });
    }

    init();

    function initializeTimeline() {
        return DependenciesService.getReleaseTree(vm.release).then(function (releaseTree) {
            return Timeline.init(vm.release, releaseTree);
        });
    }

    function getDependencies() {
        return ReleasesService.getReleaseDependencies(vm.release.id, { asReleases: true });
    }

    function getPhaseTasks(phases) {
        var phaseFounded = _.find(phases, function (phase) {
            return phase.status === "IN_PROGRESS" || phase.status === 'FAILED';
        });
        return phaseFounded ? phaseFounded.tasks : [];
    }
};

TimelineTileController.$inject = ['$scope', 'TasksService', 'ReleasesService', 'Timeline', 'DependenciesService', '$q'];

angular.module('xlrelease').controller('summary.timelineTileController', TimelineTileController);

/***/ }),

/***/ 3689:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3691:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3693:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3695:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3697:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3699:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3701:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3703:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3704);

__webpack_require__(3706);

__webpack_require__(3712);

__webpack_require__(3714);

__webpack_require__(3732);

/***/ }),

/***/ 3704:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3706:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _reportTileComponent = __webpack_require__(3707);

var _reportTileConfigComponent = __webpack_require__(3709);

var _reportTileFiltersTooltipComponent = __webpack_require__(3711);

angular.module('xlrelease').component('reportTile', _reportTileComponent.reportTileComponent);
angular.module('xlrelease').component('reportTileConfig', _reportTileConfigComponent.reportTileConfigComponent);
angular.module('xlrelease').component('reportTileFiltersTooltip', _reportTileFiltersTooltipComponent.reportTileFiltersTooltipComponent);

/***/ }),

/***/ 3707:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.reportTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _reportTileFiltersTooltip = __webpack_require__(3708);

var _reportTileFiltersTooltip2 = _interopRequireDefault(_reportTileFiltersTooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div tile-container id="report-tile" report="$ctrl.report" class="report-tile report-tile-centered">\n        <tile-title>\n            <xlr-tile-date-range-label \n                time-frame="$ctrl.dateFilter.timeFrame"\n                from="$ctrl.dateFilter.from"\n                to="$ctrl.dateFilter.to">    \n            </xlr-tile-date-range-label>\n        </tile-title>\n        <tile-content ng-transclude="content"></tile-content>\n        <tile-footer ng-transclude="footer"></tile-footer>\n    </div>\n';

var ReportTileController = function () {
    function ReportTileController(ReportTileService, DeploymentTileService) {
        (0, _classCallCheck3.default)(this, ReportTileController);

        this.ReportTileService = ReportTileService;
        this.DeploymentTileService = DeploymentTileService; // <- having this here is crap but I'm tired already of refactoring
    }

    (0, _createClass3.default)(ReportTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.dateFilter = this.ReportTileService.getDateFilter(this.tile);
            this.ReportTileService.clearCachedPromises();
            this.DeploymentTileService.clearCachedPromises();

            if (this.tile.properties.filters.length > 1) {
                this.parent.addButton({
                    template: _reportTileFiltersTooltip2.default,
                    onClick: function onClick() {},
                    icon: 'filter-icon'
                });
            }
        }
    }]);
    return ReportTileController;
}();

ReportTileController.$inject = ['ReportTileService', 'DeploymentTileService'];
var reportTileComponent = exports.reportTileComponent = {
    bindings: {
        tile: '<',
        parent: '<',
        report: '<'

    },
    transclude: {
        'content': '?reportContent',
        'footer': '?reportFooter'
    },
    controller: ReportTileController,
    template: template
};

/***/ }),

/***/ 3708:
/***/ (function(module, exports) {

module.exports = "<div class=\"popover popover-dark report-tile-filters-tooltip\">\n    <div class=\"arrow\"></div>\n    <div class=\"popover-content\">\n        <report-tile-filters-tooltip tile=\"xlrTile.tile\"></report-tile-filters-tooltip>\n    </div>\n</div>\n"

/***/ }),

/***/ 3709:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.reportTileConfigComponent = undefined;

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _reportTileConfig = __webpack_require__(3710);

var _reportTileConfig2 = _interopRequireDefault(_reportTileConfig);

var _reportTileConstants = __webpack_require__(363);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReportTileConfigController = function () {
    function ReportTileConfigController() {
        (0, _classCallCheck3.default)(this, ReportTileConfigController);
    }

    (0, _createClass3.default)(ReportTileConfigController, [{
        key: '$onInit',
        value: function $onInit() {
            this.tile = (0, _extends3.default)({}, this.tile);
            this.dateFilter = this.initialDateFilter;
            this.availableFilterTypes = [_reportTileConstants.TEMPLATE_FILTER_TYPE, _reportTileConstants.FOLDER_FILTER_TYPE, _reportTileConstants.TAG_FILTER_TYPE];
        }
    }, {
        key: 'tileTitle',
        value: function tileTitle(title) {
            if (arguments.length) {
                this.updateTile({ title: title });
            }
            return this.tile.properties.title;
        }
    }, {
        key: 'onDateFilterChange',
        value: function onDateFilterChange() {
            var dateFilter = this.tile.properties.filters.find(function (f) {
                return f.type === _reportTileConstants.DATE_FILTER_TYPE;
            });
            if (dateFilter) {
                dateFilter.timeFrame = this.dateFilter.timeFrame;
                if (this.dateFilter.timeFrame === 'RANGE') {
                    var stringified = this.stringifyDateFilter(this.dateFilter);
                    dateFilter.from = stringified.from;
                    dateFilter.to = stringified.to;
                } else {
                    dateFilter.from = null;
                    dateFilter.to = null;
                }
            } else {
                this.tile.properties.filters.push((0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                    id: _reportTileConstants.ENTITY_ID_PLACEHOLDER,
                    type: _reportTileConstants.DATE_FILTER_TYPE
                }));
            }
            this.updateTile();
        }
    }, {
        key: 'onFilterChange',
        value: function onFilterChange(rawFilters) {
            var filters = [].concat((0, _toConsumableArray3.default)(rawFilters), [(0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                id: _reportTileConstants.ENTITY_ID_PLACEHOLDER,
                type: _reportTileConstants.DATE_FILTER_TYPE
            })]);
            this.updateTile({ filters: filters });
        }
    }, {
        key: 'updateTile',
        value: function updateTile(tile) {
            this.tile.properties = (0, _extends3.default)({}, this.tile.properties, tile);
            this.onUpdate({ tile: this.tile });
        }
    }, {
        key: 'stringifyDateFilter',
        value: function stringifyDateFilter(dateFilter) {
            if (dateFilter.timeFrame === 'RANGE') {
                return (0, _extends3.default)({}, dateFilter, {
                    from: dateFilter.from ? moment(dateFilter.from).toISOString() : null,
                    to: dateFilter.to ? moment(dateFilter.to).toISOString() : null
                });
            }
            return dateFilter;
        }
    }, {
        key: 'initialDateFilter',
        get: function get() {
            if (this.tile && this.tile.properties && this.tile.properties.filters && this.tile.properties.filters.length) {
                var dateFilter = this.tile.properties.filters.find(function (f) {
                    return f.type === _reportTileConstants.DATE_FILTER_TYPE;
                });
                if (dateFilter) {
                    return dateFilter;
                }
            }
            return {
                timeFrame: _reportTileConstants.DEFAULT_TIME_PERIOD,
                from: null,
                to: null
            };
        }
    }]);
    return ReportTileConfigController;
}();

var reportTileConfigComponent = exports.reportTileConfigComponent = {
    bindings: {
        tile: '<',
        onUpdate: '&'
    },
    controller: ReportTileConfigController,
    template: _reportTileConfig2.default
};

/***/ }),

/***/ 3710:
/***/ (function(module, exports) {

module.exports = "<div class=\"report-tile-config\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <label for=\"title\" class=\"control-label col-xs-3\">Name <span class=\"error\">*</span></label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"title\" name=\"title\" required\n                       ng-model=\"$ctrl.tileTitle\"\n                       ng-model-options=\"{ getterSetter: true }\"\n                       class=\"form-control\">\n                <span class=\"description\">Name of the tile</span>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <xlr-tile-date-range\n                    on-date-range-change=\"$ctrl.onDateFilterChange()\"\n                    date-range=\"$ctrl.dateFilter\">\n            </xlr-tile-date-range>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"control-label col-xs-3\">Filters</label>\n            <div class=\"col-xs-9\">\n                <composite-filter\n                        available-types=\"$ctrl.availableFilterTypes\"\n                        stored-filters=\"$ctrl.tile.properties.filters\"\n                        on-change=\"$ctrl.onFilterChange(filters)\">\n                </composite-filter>\n                <span class=\"description\">Filters to apply to reported data</span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 3711:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.reportTileFiltersTooltipComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _reportTileConstants = __webpack_require__(363);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n        <div>\n           <b>Applied filters</b>\n          <div ng-repeat="filter in $ctrl.appliedFilters">\n          \n               <div class="report-filter" ng-if="$ctrl.isAppliedFilterList(filter)">\n                    <div>{{filter.title}} ({{filter.applied.length}})</div>\n                    <span class="report-filter-tag" ng-class="{\'tag-without-title\': !filter.title}" ng-repeat="applied in filter.applied">\n                        <span ng-if="!applied.title" tooltip-position="bottom" class="tooltip-color"\n                            tooltip="\'You do not have the permissions required to view all filters on this tile, only partial data is available\'">\n                            N/A\n                        </span>\n                        {{$ctrl.getFilterTitle(applied)}}\n                    </span>\n                </div>\n                <div class="report-filter" ng-if="$ctrl.isAppliedFilterObject(filter)">\n                    <div>{{filter.title}}</div>\n                    <span class="report-filter-tag">{{filter.applied.title}}</span>\n                </div>\n            </div>\n    ';

var ReportTileFiltersTooltipController = function () {
    function ReportTileFiltersTooltipController(ReportTileService, CompositeFilterService) {
        (0, _classCallCheck3.default)(this, ReportTileFiltersTooltipController);

        this.ReportTileService = ReportTileService;
        this.CompositeFilterService = CompositeFilterService;
        this.appliedFilters = [];
    }

    (0, _createClass3.default)(ReportTileFiltersTooltipController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            var filterTypes = this.ReportTileService.collectAllFiltersTypes(this.tile.properties.filters);
            this.CompositeFilterService.loadCandidates(filterTypes, false).then(function () {
                _this.appliedFilters = filterTypes.map(function (filterType) {
                    return _this.CompositeFilterService.getFilter(filterType);
                }).filter(Boolean).map(function (definition) {
                    return {
                        title: definition.title,
                        applied: _this.findFilters(_this.tile, definition.type, definition.property, definition.loadedAutocompleteCandidates)
                    };
                });
            }).catch(function () {
                return _this.appliedFilters = [];
            });
        }
    }, {
        key: 'findFilters',
        value: function findFilters(tile, filterType, idProperty, referencedCis) {
            var matchingFilters = this.ReportTileService.findAllFiltersOfType(tile.properties.filters, filterType);
            if (matchingFilters) {
                if (filterType === _reportTileConstants.TAG_FILTER_TYPE) {
                    // <- someone decided tags are special (no id), so now we have special cases for tags across the code, good job!
                    return _.flatten(matchingFilters.map(function (filter) {
                        return (filter[idProperty] || []).map(function (tag) {
                            return { title: tag };
                        });
                    }));
                } else {
                    return matchingFilters.map(function (filter) {
                        return referencedCis.find(function (ci) {
                            return ci.id === filter[idProperty];
                        }) || {};
                    });
                }
            }
        }
    }, {
        key: 'isAppliedFilterList',
        value: function isAppliedFilterList(filter) {
            return _.isArray(filter.applied) && !_.isEmpty(filter.applied);
        }
    }, {
        key: 'isAppliedFilterObject',
        value: function isAppliedFilterObject(filter) {
            return _.has(filter, 'applied.title');
        }
    }, {
        key: 'getFilterTitle',
        value: function getFilterTitle(filter) {
            return filter.title || '';
        }
    }]);
    return ReportTileFiltersTooltipController;
}();

ReportTileFiltersTooltipController.$inject = ['ReportTileService', 'CompositeFilterService'];
var reportTileFiltersTooltipComponent = exports.reportTileFiltersTooltipComponent = {
    bindings: {
        tile: '<'
    },
    controller: ReportTileFiltersTooltipController,
    template: template
};

/***/ }),

/***/ 3712:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _reportTileService = __webpack_require__(3713);

var _reportTileConstants = __webpack_require__(363);

angular.module('xlrelease').service('ReportTileService', _reportTileService.ReportTileService);

angular.module('xlrelease').run(['CompositeFilterService', 'ReportTileService', function (CompositeFilterService, ReportTileService) {
    CompositeFilterService.registerFilter(_reportTileConstants.FOLDER_FILTER_TYPE, {
        type: _reportTileConstants.FOLDER_FILTER_TYPE,
        title: 'Parent folder',
        operators: [{ value: 'OR', title: 'matches' }],
        filterTag: true,
        property: 'folderId',
        autocompleteCandidates: ReportTileService.getAllFolders.bind(ReportTileService)
    });

    CompositeFilterService.registerFilter(_reportTileConstants.TEMPLATE_FILTER_TYPE, {
        type: _reportTileConstants.TEMPLATE_FILTER_TYPE,
        title: 'Source template',
        operators: [{ value: 'OR', title: 'matches' }],
        filterTag: true,
        property: 'templateId',
        autocompleteCandidates: ReportTileService.getAllTemplates.bind(ReportTileService)
    });

    CompositeFilterService.registerFilter(_reportTileConstants.TAG_FILTER_TYPE, {
        type: _reportTileConstants.TAG_FILTER_TYPE,
        title: 'Release tags',
        operators: [{ value: 'CONTAINS_ALL', title: 'contains all' }, { value: 'CONTAINS_ANY', title: 'contains any' }],
        filterTag: false,
        property: 'tags',
        autocompleteCandidates: ReportTileService.getAllTags.bind(ReportTileService),
        toStored: function toStored(curr) {
            return {
                id: _reportTileConstants.ENTITY_ID_PLACEHOLDER,
                type: _reportTileConstants.TAG_FILTER_TYPE,
                operator: curr.operator,
                tags: curr.values
            };
        },
        fromStored: function fromStored(curr) {
            return {
                type: _reportTileConstants.TAG_FILTER_TYPE,
                operator: curr.operator,
                values: curr.tags
            };
        }
    });
}]);

/***/ }),

/***/ 3713:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ReportTileService = undefined;

var _getIterator2 = __webpack_require__(222);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _set = __webpack_require__(706);

var _set2 = _interopRequireDefault(_set);

var _objectWithoutProperties2 = __webpack_require__(32);

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _reportTileConstants = __webpack_require__(363);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TOP_REPORT_SIZE = 10;

var ReportTileService = exports.ReportTileService = function () {
    function ReportTileService(FoldersService, TemplatesService, TagsService, Ids, Backend, Download, $stateParams) {
        (0, _classCallCheck3.default)(this, ReportTileService);

        this.FoldersService = FoldersService;
        this.TemplatesService = TemplatesService;
        this.TagsService = TagsService;
        this.Ids = Ids;
        this.Backend = Backend;
        this.Download = Download;
        this.$stateParams = $stateParams;

        this.clearCachedPromises();
    }

    (0, _createClass3.default)(ReportTileService, [{
        key: 'loadReport',
        value: function loadReport(tile, loader) {
            loader.startLoading();
            this.Backend.post(loader.url, this.getTileParams(tile)).then(function (resp) {
                return loader.loaded(resp.data);
            }).then(loader.endLoading, loader.endLoading);
        }
    }, {
        key: 'exportReport',
        value: function exportReport(tile, type) {
            var params = {
                report: type,
                tileId: tile.id
            };
            this.Download.launch('export/tile-report/?' + $.param(params));
        }
    }, {
        key: 'getAllFolders',
        value: function getAllFolders(forceLoad) {
            var _this = this;

            if (forceLoad || !this._cachedFoldersPromise) {
                this._cachedFoldersPromise = this.FoldersService.list().then(function (response) {
                    return response.data ? _this.flatFoldersTree(response.data).map(function (_ref) {
                        var id = _ref.id,
                            title = _ref.title;
                        return {
                            id: _this.Ids.getName(id),
                            title: title
                        };
                    }) : [];
                }).catch(function (error) {
                    /* eslint-disable no-console, angular/log */
                    console.warn(error);
                });
            }
            return this._cachedFoldersPromise;
        }

        // TODO check this fn

    }, {
        key: 'flatFoldersTree',
        value: function flatFoldersTree(folders) {
            var flatten = [];
            var stack = [].concat((0, _toConsumableArray3.default)(folders));
            var folder = void 0;
            while (angular.isDefined(folder = stack.pop())) {
                if (folder.children && folder.children.length) {
                    folder.children.forEach(function (f) {
                        return stack.push(f);
                    });
                }
                var _folder = folder,
                    children = _folder.children,
                    strippedFolder = (0, _objectWithoutProperties3.default)(_folder, ['children']);

                flatten.push(strippedFolder);
            }
            return flatten;
        }
    }, {
        key: 'getAllTags',
        value: function getAllTags(forceLoad) {
            if (forceLoad || !this._cachedTagsPromise) {
                this._cachedTagsPromise = this.TagsService.getArchivedReleaseTags().catch(function (error) {
                    /* eslint-disable no-console, angular/log */
                    console.warn(error);
                });
            }
            return this._cachedTagsPromise;
        }
    }, {
        key: 'getAllTemplates',
        value: function getAllTemplates(forceLoad) {
            var _this2 = this;

            if (forceLoad || !this._cachedTemplatesPromise) {
                this._cachedTemplatesPromise = this.TemplatesService.getAll().then(function (response) {
                    return response.data && response.data.cis ? response.data.cis.map(function (_ref2) {
                        var id = _ref2.id,
                            title = _ref2.title;
                        return {
                            id: _this2.Ids.getName(_this2.Ids.toDomainId(id)),
                            title: title
                        };
                    }) : [];
                }).catch(function (error) {
                    /* eslint-disable no-console, angular/log */
                    console.warn(error);
                });
            }
            return this._cachedTemplatesPromise;
        }
    }, {
        key: 'collectAllFiltersTypes',
        value: function collectAllFiltersTypes(filters) {
            var filterTypes = new _set2.default();
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = (0, _getIterator3.default)(filters), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var filter = _step.value;

                    if (filter.type === _reportTileConstants.COMPOSITE_FILTER_TYPE) {
                        filterTypes = new _set2.default([].concat((0, _toConsumableArray3.default)(filterTypes), (0, _toConsumableArray3.default)(this.collectAllFiltersTypes(filter.filters))));
                    } else {
                        filterTypes.add(filter.type);
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            return [].concat((0, _toConsumableArray3.default)(filterTypes));
        }
    }, {
        key: 'findAllFiltersOfType',
        value: function findAllFiltersOfType(filters, type) {
            var matchingFilters = [];
            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = undefined;

            try {
                for (var _iterator2 = (0, _getIterator3.default)(filters), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                    var filter = _step2.value;

                    if (filter.type === type) {
                        matchingFilters.push(filter);
                    } else if (filter.type === _reportTileConstants.COMPOSITE_FILTER_TYPE) {
                        matchingFilters.push.apply(matchingFilters, (0, _toConsumableArray3.default)(this.findAllFiltersOfType(filter.filters, type)));
                    }
                }
            } catch (err) {
                _didIteratorError2 = true;
                _iteratorError2 = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion2 && _iterator2.return) {
                        _iterator2.return();
                    }
                } finally {
                    if (_didIteratorError2) {
                        throw _iteratorError2;
                    }
                }
            }

            return matchingFilters;
        }
    }, {
        key: 'getTileParams',
        value: function getTileParams(tile) {
            var dateFilter = this.getDateFilter(tile);
            return {
                timeFrame: dateFilter.timeFrame,
                from: dateFilter.timeFrame === 'RANGE' && dateFilter.from ? moment(dateFilter.from).valueOf() : undefined,
                to: dateFilter.timeFrame === 'RANGE' && dateFilter.to ? moment(dateFilter.to).valueOf() : undefined,
                tags: undefined,
                userSpecific: false,
                filters: tile.properties.filters,
                refresh: this.$stateParams.refresh
            };
        }
    }, {
        key: 'getDateFilter',
        value: function getDateFilter(tile) {
            var filters = this.findAllFiltersOfType(tile.properties.filters, _reportTileConstants.DATE_FILTER_TYPE);
            return (_.isEmpty(filters) ? [{
                timeFrame: _reportTileConstants.DEFAULT_TIME_PERIOD,
                id: _reportTileConstants.ENTITY_ID_PLACEHOLDER,
                type: _reportTileConstants.DATE_FILTER_TYPE
            }] : filters)[0];
        }
    }, {
        key: 'emptyArrayIfAllKeysAreZero',
        value: function emptyArrayIfAllKeysAreZero(data) {
            if (_.sum(_.map(data)) !== 0) {
                return data;
            }
            return [];
        }
    }, {
        key: 'sliceReport',
        value: function sliceReport(data, size) {
            if (data) {
                data = data.slice(0, size || TOP_REPORT_SIZE);
            }
            return data;
        }
    }, {
        key: 'formatDuration',
        value: function formatDuration(durationInMs) {
            var duration = moment.duration(durationInMs);
            return duration < moment.duration(1, 'days').asMilliseconds() ? duration.format('d[d] h[h] m[m] s[s]') : duration.format('d[d] h[h] m[m]');
        }
    }, {
        key: 'clearCachedPromises',
        value: function clearCachedPromises() {
            this._cachedFoldersPromise = null;
            this._cachedTagsPromise = null;
            this._cachedTemplatesPromise = null;
        }
    }]);
    return ReportTileService;
}();

ReportTileService.$inject = ['FoldersService', 'TemplatesService', 'TagsService', 'Ids', 'Backend', 'Download', '$stateParams'];

/***/ }),

/***/ 3714:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _avgReleaseDurationTileComponent = __webpack_require__(3715);

var _completedReleasesTileComponent = __webpack_require__(3716);

var _longestTaskTypeTileComponent = __webpack_require__(3717);

var _avgTaskDurationTileComponent = __webpack_require__(3720);

var _taskEfficiencyTileComponent = __webpack_require__(3721);

var _taskTimeSpentTileComponent = __webpack_require__(3722);

var _releasesByMonthTileComponent = __webpack_require__(3723);

var _releaseEfficiencyTileComponent = __webpack_require__(3724);

var _avgReleaseDurationByMonthTileComponent = __webpack_require__(3725);

var _longestReleasesTileComponent = __webpack_require__(3726);

var _longestPhasesTileComponent = __webpack_require__(3727);

var _longestTasksTileComponent = __webpack_require__(3728);

var _topTenTaskAssigneeTileComponent = __webpack_require__(3729);

angular.module('xlrelease').component('avgReleaseDurationTile', _avgReleaseDurationTileComponent.avgReleaseDurationTileComponent).component('completedReleasesTile', _completedReleasesTileComponent.completedReleasesTileComponent).component('longestTaskTypeTile', _longestTaskTypeTileComponent.longestTaskTypeTileComponent).component('avgTaskDurationTile', _avgTaskDurationTileComponent.avgTaskDurationTileComponent).component('taskEfficiencyTile', _taskEfficiencyTileComponent.taskEfficiencyTileComponent).component('taskTimeSpentTile', _taskTimeSpentTileComponent.taskTimeSpentTileComponent).component('releasesByMonthTile', _releasesByMonthTileComponent.releasesByMonthTileComponent).component('releaseEfficiencyTile', _releaseEfficiencyTileComponent.releaseEfficiencyTileComponent).component('avgReleaseDurationByMonthTile', _avgReleaseDurationByMonthTileComponent.avgReleaseDurationByMonthTileComponent).component('longestReleasesTile', _longestReleasesTileComponent.longestReleasesTileComponent).component('longestPhasesTile', _longestPhasesTileComponent.longestPhasesTileComponent).component('longestTasksTile', _longestTasksTileComponent.longestTasksTileComponent).component('topTenTaskAssigneeTile', _topTenTaskAssigneeTileComponent.topTenTaskAssigneeTileComponent);

/***/ }),

/***/ 3715:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.avgReleaseDurationTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="avg-release-duration" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        {{$ctrl.formatDuration($ctrl.report.data.averageReleaseDuration)}}\n    </report-content>\n    <report-footer>\n        Longest release duration was {{$ctrl.formatDuration($ctrl.report.data.longestReleaseDuration)}}\n    </report-footer>\n</report-tile>';

var AvgReleaseDurationTileController = function () {
    function AvgReleaseDurationTileController(ReportLoader, Report, ReportTileService) {
        (0, _classCallCheck3.default)(this, AvgReleaseDurationTileController);

        this.ReportTileService = ReportTileService;

        this.loader = new ReportLoader('reports/release/average-and-longest-release-duration');
        this.report = new Report().add('data', this.loader, this.ReportTileService.emptyArrayIfAllKeysAreZero);

        this.formatDuration = this.ReportTileService.formatDuration;
    }

    (0, _createClass3.default)(AvgReleaseDurationTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }]);
    return AvgReleaseDurationTileController;
}();

AvgReleaseDurationTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService'];
var avgReleaseDurationTileComponent = exports.avgReleaseDurationTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: AvgReleaseDurationTileController,
    template: template
};

/***/ }),

/***/ 3716:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.completedReleasesTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="completed-releases" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        {{$ctrl.report.data.completedReleases}}\n    </report-content>\n    <report-footer>\n        Started from {{ $ctrl.report.data.createdFromTemplates }} different\n        <ng-pluralize count="$ctrl.report.data.createdFromTemplates"\n        when="{\'0\': \'templates\', \'one\': \'template\', \'other\': \'templates\'}"></ng-pluralize>\n    </report-footer>\n</report-tile>';

var CompletedReleasesTileController = function () {
    function CompletedReleasesTileController(ReportLoader, Report, ReportTileService) {
        (0, _classCallCheck3.default)(this, CompletedReleasesTileController);

        this.ReportTileService = ReportTileService;

        this.loader = new ReportLoader('reports/release/completed');
        this.report = new Report().add('data', this.loader, this.ReportTileService.emptyArrayIfAllKeysAreZero);
    }

    (0, _createClass3.default)(CompletedReleasesTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }]);
    return CompletedReleasesTileController;
}();

CompletedReleasesTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService'];
var completedReleasesTileComponent = exports.completedReleasesTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: CompletedReleasesTileController,
    template: template
};

/***/ }),

/***/ 3717:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.longestTaskTypeTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(3718);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="longest-task-type" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content shorten-content>\n        {{ $ctrl.getTaskNameByType($ctrl.report.data[0].taskType) }}\n    </report-content>\n    <report-footer>\n        Task found in\n        <ng-pluralize count="$ctrl.report.data[0].containedInNumberOfReleases"\n                      when="{\'0\': \'{} releases\', \'one\': \'{} release\', \'other\': \'{} releases\'}"></ng-pluralize>\n    </report-footer>\n</report-tile>';

var LongestTaskTypeTileController = function () {
    function LongestTaskTypeTileController(ReportLoader, Report, ReportTileService, TaskDefinitionsService) {
        (0, _classCallCheck3.default)(this, LongestTaskTypeTileController);

        this.ReportTileService = ReportTileService;
        this.TaskDefinitionsService = TaskDefinitionsService;

        this.loader = new ReportLoader('reports/longest-task-types');
        this.report = new Report().add('data', this.loader, this.ReportTileService.sliceReport);
    }

    (0, _createClass3.default)(LongestTaskTypeTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.loadTaskDefinitions();
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }, {
        key: 'loadTaskDefinitions',
        value: function loadTaskDefinitions() {
            var _this = this;

            this.TaskDefinitionsService.getTaskDefinitions().then(function (resp) {
                _this.taskDefinitions = _.reduce(resp.data, function (result, value) {
                    result[value.typeName] = _.omit(value, 'typeName');
                    return result;
                }, {});
            });
        }
    }, {
        key: 'getTaskNameByType',
        value: function getTaskNameByType(taskType) {
            var taskDefs = this.taskDefinitions;
            var isDefExist = angular.isDefined(taskDefs) && angular.isDefined(taskDefs[taskType]);
            return isDefExist ? taskDefs[taskType].displayGroup + ': ' + taskDefs[taskType].displayName : taskType;
        }
    }]);
    return LongestTaskTypeTileController;
}();

LongestTaskTypeTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'TaskDefinitionsService'];
var longestTaskTypeTileComponent = exports.longestTaskTypeTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: LongestTaskTypeTileController,
    template: template
};

/***/ }),

/***/ 3718:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3720:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.avgTaskDurationTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="avg-task-duration" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        {{$ctrl.formatDuration($ctrl.report.data.averageTaskDuration)}}\n    </report-content>\n    <report-footer>\n        Longest task duration was {{$ctrl.formatDuration($ctrl.report.data.longestTaskDuration)}}\n    </report-footer>\n</report-tile>';

var AvgTaskDurationTileController = function () {
    function AvgTaskDurationTileController(ReportLoader, Report, ReportTileService) {
        (0, _classCallCheck3.default)(this, AvgTaskDurationTileController);

        this.ReportTileService = ReportTileService;

        this.loader = new ReportLoader('reports/average-and-longest-task-duration');
        this.report = new Report().add('data', this.loader, this.ReportTileService.emptyArrayIfAllKeysAreZero);

        this.formatDuration = this.ReportTileService.formatDuration;
    }

    (0, _createClass3.default)(AvgTaskDurationTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }]);
    return AvgTaskDurationTileController;
}();

AvgTaskDurationTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService'];
var avgTaskDurationTileComponent = exports.avgTaskDurationTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: AvgTaskDurationTileController,
    template: template
};

/***/ }),

/***/ 3721:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.taskEfficiencyTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="task-efficiency" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile"></echarts>\n    </report-content>\n</report-tile>';

var TaskEfficiencyTileController = function () {
    function TaskEfficiencyTileController(ReportLoader, Report, ReportTileService, EchartsReportsService) {
        (0, _classCallCheck3.default)(this, TaskEfficiencyTileController);

        this.ReportTileService = ReportTileService;

        this.loader = new ReportLoader('reports/releases/automation');
        this.report = new Report().add('data', this.loader, function (data) {
            if (!!data.releaseEfficiency.totalTasks) {
                return EchartsReportsService.responsivePie(EchartsReportsService.taskEfficiency(data.releaseEfficiency));
            }
        });
    }

    (0, _createClass3.default)(TaskEfficiencyTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }]);
    return TaskEfficiencyTileController;
}();

TaskEfficiencyTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService'];
var taskEfficiencyTileComponent = exports.taskEfficiencyTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: TaskEfficiencyTileController,
    template: template
};

/***/ }),

/***/ 3722:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.taskTimeSpentTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="task-time-spent" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile"></echarts>\n    </report-content>\n</report-tile>';

var TaskTimeSpentTileController = function () {
    function TaskTimeSpentTileController(ReportLoader, Report, ReportTileService, EchartsReportsService) {
        (0, _classCallCheck3.default)(this, TaskTimeSpentTileController);

        this.ReportTileService = ReportTileService;

        this.loader = new ReportLoader('reports/releases/automation');
        this.report = new Report().add('data', this.loader, function (data) {
            if (!!data.releaseEfficiency.totalTasks) {
                return EchartsReportsService.responsivePie(EchartsReportsService.taskTimeSpent(data.releaseEfficiency));
            }
        });
    }

    (0, _createClass3.default)(TaskTimeSpentTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }]);
    return TaskTimeSpentTileController;
}();

TaskTimeSpentTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService'];
var taskTimeSpentTileComponent = exports.taskTimeSpentTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: TaskTimeSpentTileController,
    template: template
};

/***/ }),

/***/ 3723:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.releasesByMonthTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="releases-by-month" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile"></echarts>\n    </report-content>\n</report-tile>';

var ReleasesByMonthTileController = function () {
    function ReleasesByMonthTileController(ReportLoader, Report, ReportTileService, EchartsReportsService) {
        (0, _classCallCheck3.default)(this, ReleasesByMonthTileController);

        this.ReportTileService = ReportTileService;

        var numberOfReleasesPerMonth = new ReportLoader('reports/releases/number-by-month');
        var releasesDuration = new ReportLoader('reports/releases/duration');
        var releasesAutomation = new ReportLoader('reports/releases/automation');

        this.loaders = [numberOfReleasesPerMonth, releasesAutomation, releasesDuration];

        var releaseEfficiency = new Report().add('releasesDuration', releasesDuration, function (data) {
            return data.average;
        }).add('releasesAutomation', releasesAutomation, function (data) {
            return data.averageAutomationPercentage;
        }).add('numberOfReleasesPerMonth', numberOfReleasesPerMonth);

        this.report = new Report().addByReport('data', releaseEfficiency, function (data) {
            if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
                return EchartsReportsService.numberOfReleasesPerMonth(data);
            }
        });
    }

    (0, _createClass3.default)(ReleasesByMonthTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loaders.forEach(function (loader) {
                return _this.ReportTileService.loadReport(_this.tile, loader);
            });
        }
    }]);
    return ReleasesByMonthTileController;
}();

ReleasesByMonthTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService'];
var releasesByMonthTileComponent = exports.releasesByMonthTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: ReleasesByMonthTileController,
    template: template
};

/***/ }),

/***/ 3724:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.releaseEfficiencyTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="release-efficiency" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile"></echarts>\n    </report-content>\n</report-tile>';

var ReleaseEfficiencyTileController = function () {
    function ReleaseEfficiencyTileController(ReportLoader, Report, ReportTileService, EchartsReportsService) {
        (0, _classCallCheck3.default)(this, ReleaseEfficiencyTileController);

        this.ReportTileService = ReportTileService;

        var releasesDuration = new ReportLoader('reports/releases/duration');
        var releasesAutomation = new ReportLoader('reports/releases/automation');

        this.loaders = [releasesAutomation, releasesDuration];

        var averageDurationAndAutomation = new Report().add('releasesDuration', releasesDuration, function (data) {
            return data.average;
        }).add('releasesAutomation', releasesAutomation, function (data) {
            return data.averageAutomationPercentage;
        });

        this.report = new Report().addByReport('data', averageDurationAndAutomation, function (data) {
            if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
                return EchartsReportsService.releaseEfficiency(data);
            }
        });
    }

    (0, _createClass3.default)(ReleaseEfficiencyTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loaders.forEach(function (loader) {
                return _this.ReportTileService.loadReport(_this.tile, loader);
            });
        }
    }]);
    return ReleaseEfficiencyTileController;
}();

ReleaseEfficiencyTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService'];
var releaseEfficiencyTileComponent = exports.releaseEfficiencyTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: ReleaseEfficiencyTileController,
    template: template
};

/***/ }),

/***/ 3725:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.avgReleaseDurationByMonthTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="avg-release-duration-by-month" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile"></echarts>\n    </report-content>\n</report-tile>';

var AvgReleaseDurationByMonthTileController = function () {
    function AvgReleaseDurationByMonthTileController(ReportLoader, Report, ReportTileService, EchartsReportsService) {
        (0, _classCallCheck3.default)(this, AvgReleaseDurationByMonthTileController);

        this.ReportTileService = ReportTileService;

        var releasesDuration = new ReportLoader('reports/releases/duration');
        var releasesAutomation = new ReportLoader('reports/releases/automation');

        this.loaders = [releasesAutomation, releasesDuration];

        var averageDurationAndAutomation = new Report().add('releasesDuration', releasesDuration, function (data) {
            return data.average;
        }).add('releasesAutomation', releasesAutomation, function (data) {
            return data.averageAutomationPercentage;
        });

        this.report = new Report().addByReport('data', averageDurationAndAutomation, function (data) {
            if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
                return EchartsReportsService.releaseDuration(data);
            }
        });
    }

    (0, _createClass3.default)(AvgReleaseDurationByMonthTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loaders.forEach(function (loader) {
                return _this.ReportTileService.loadReport(_this.tile, loader);
            });
        }
    }]);
    return AvgReleaseDurationByMonthTileController;
}();

AvgReleaseDurationByMonthTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService'];
var avgReleaseDurationByMonthTileComponent = exports.avgReleaseDurationByMonthTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: AvgReleaseDurationByMonthTileController,
    template: template
};

/***/ }),

/***/ 3726:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.longestReleasesTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="longest-releases" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile" ec-click="$ctrl.goToRelease(params, $ctrl.report.data.sortedData)"></echarts>\n    </report-content>\n</report-tile>';

var LongestReleasesTileController = function () {
    function LongestReleasesTileController(ReportLoader, Report, ReportTileService, EchartsReportsService, $state) {
        var _this = this;

        (0, _classCallCheck3.default)(this, LongestReleasesTileController);

        this.ReportTileService = ReportTileService;
        this.$state = $state;

        this.loader = new ReportLoader('reports/releases/duration');
        this.report = new Report().add('data', this.loader, function (data) {
            if (!!data.longestReleases.length) {
                return EchartsReportsService.longestReleases(_this.ReportTileService.sliceReport(data.longestReleases, _this.tile.properties.reportSize));
            }
        });
    }

    (0, _createClass3.default)(LongestReleasesTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this2 = this;

            this.parent.addButton({
                title: 'Export',
                onClick: function onClick() {
                    return _this2.ReportTileService.exportReport(_this2.tile, 'TOP_LONGEST_RELEASE');
                },
                icon: 'export-icon'
            });
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }, {
        key: 'goToRelease',
        value: function goToRelease(params, data) {
            var release = data[params.dataIndex];
            if (release && release.releaseId) {
                this.$state.go('release', { releaseId: release.releaseId });
            }
        }
    }]);
    return LongestReleasesTileController;
}();

LongestReleasesTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService', '$state'];
var longestReleasesTileComponent = exports.longestReleasesTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: LongestReleasesTileController,
    template: template
};

/***/ }),

/***/ 3727:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.longestPhasesTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="longest-phases" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile" ec-click="$ctrl.goToRelease(params, $ctrl.report.data.sortedData)"></echarts>\n    </report-content>\n</report-tile>';

var LongestPhasesTileController = function () {
    function LongestPhasesTileController(ReportLoader, Report, ReportTileService, EchartsReportsService, $state) {
        var _this = this;

        (0, _classCallCheck3.default)(this, LongestPhasesTileController);

        this.ReportTileService = ReportTileService;
        this.$state = $state;

        this.loader = new ReportLoader('reports/longest-phases');
        this.report = new Report().add('data', this.loader, function (data) {
            if (!!data.length) {
                return EchartsReportsService.longestPhases(_this.ReportTileService.sliceReport(data, _this.tile.properties.reportSize));
            }
        });
    }

    (0, _createClass3.default)(LongestPhasesTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this2 = this;

            this.parent.addButton({
                title: 'Export',
                onClick: function onClick() {
                    return _this2.ReportTileService.exportReport(_this2.tile, 'TOP_LONGEST_PHASE');
                },
                icon: 'export-icon'
            });
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }, {
        key: 'goToRelease',
        value: function goToRelease(params, data) {
            var release = data[params.dataIndex];
            if (release && release.releaseId) {
                this.$state.go('release', { releaseId: release.releaseId });
            }
        }
    }]);
    return LongestPhasesTileController;
}();

LongestPhasesTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService', '$state'];
var longestPhasesTileComponent = exports.longestPhasesTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: LongestPhasesTileController,
    template: template
};

/***/ }),

/***/ 3728:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.longestTasksTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="longest-tasks" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n    <report-content>\n        <echarts options="$ctrl.report.data" container=".report-tile" ec-click="$ctrl.goToRelease(params, $ctrl.report.data.sortedData)"></echarts>\n    </report-content>\n</report-tile>';

var LongestTasksTileController = function () {
    function LongestTasksTileController(ReportLoader, Report, ReportTileService, EchartsReportsService, $state) {
        var _this = this;

        (0, _classCallCheck3.default)(this, LongestTasksTileController);

        this.ReportTileService = ReportTileService;
        this.$state = $state;

        this.loader = new ReportLoader('reports/longest-tasks');
        this.report = new Report().add('data', this.loader, function (data) {
            if (!!data.length) {
                return EchartsReportsService.longestTasks(_this.ReportTileService.sliceReport(data, _this.tile.properties.reportSize));
            }
        });
    }

    (0, _createClass3.default)(LongestTasksTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this2 = this;

            this.parent.addButton({
                title: 'Export',
                onClick: function onClick() {
                    return _this2.ReportTileService.exportReport(_this2.tile, 'TOP_LONGEST_TASK');
                },
                icon: 'export-icon'
            });
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }, {
        key: 'goToRelease',
        value: function goToRelease(params, data) {
            var release = data[params.dataIndex];
            if (release && release.releaseId) {
                this.$state.go('release', { releaseId: release.releaseId });
            }
        }
    }]);
    return LongestTasksTileController;
}();

LongestTasksTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService', '$state'];
var longestTasksTileComponent = exports.longestTasksTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: LongestTasksTileController,
    template: template
};

/***/ }),

/***/ 3729:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.topTenTaskAssigneeTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(3730);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<report-tile id="most-involved-people-report" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent"\n             class="top-ten-task-assignee-tile">\n    <report-content>\n            <table class="table table-striped">\n                <tr>\n                    <th>Assignee</th>\n                    <th>Total time spent</th>\n                    <th># of tasks assigned</th>\n                </tr>\n                <tr ng-repeat="userParticipation in $ctrl.report.data">\n                    <td><span display-user="userParticipation.user"></span></td>\n                    <td>{{ userParticipation.timeSpent | duration }}</td>\n                    <td>{{ userParticipation.tasksHandled }}</td>\n                </tr>\n            </table>\n    </report-content>\n</report-tile>';

var TopTenTaskAssigneeController = function () {
    function TopTenTaskAssigneeController(ReportLoader, Report, ReportTileService, EchartsReportsService, $state) {
        (0, _classCallCheck3.default)(this, TopTenTaskAssigneeController);

        this.ReportTileService = ReportTileService;
        this.$state = $state;

        this.loader = new ReportLoader('reports/most-involved-people');
        this.report = new Report().add('data', this.loader, this.ReportTileService.emptyArrayIfAllKeysAreZero);
    }

    (0, _createClass3.default)(TopTenTaskAssigneeController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.parent.addButton({
                title: 'Export',
                onClick: function onClick() {
                    return _this.ReportTileService.exportReport(_this.tile, 'TOP_PEOPLE_MOST_INVOLVED');
                },
                icon: 'export-icon'
            });
            this.ReportTileService.loadReport(this.tile, this.loader);
        }
    }, {
        key: 'goToRelease',
        value: function goToRelease(params, data) {
            var release = data[params.dataIndex];
            if (release && release.releaseId) {
                this.$state.go('release', { releaseId: release.releaseId });
            }
        }
    }]);
    return TopTenTaskAssigneeController;
}();

TopTenTaskAssigneeController.$inject = ['ReportLoader', 'Report', 'ReportTileService', 'EchartsReportsService', '$state'];
var topTenTaskAssigneeTileComponent = exports.topTenTaskAssigneeTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: TopTenTaskAssigneeController,
    template: template
};

/***/ }),

/***/ 3730:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3732:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _releaseStatisticsConfigComponent = __webpack_require__(3733);

angular.module('xlrelease').component('releaseStatisticsConfig', _releaseStatisticsConfigComponent.releaseStatisticsConfigComponent);

/***/ }),

/***/ 3733:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.releaseStatisticsConfigComponent = undefined;

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

var _reportTileConstants = __webpack_require__(363);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Ids = (0, _ids2.default)();
var template = '\n<div class="report-tile-config">\n    <div class="form-group">\n        <xlr-tile-date-range\n                on-date-range-change="$ctrl.onDateFilterChange()"\n                date-range="$ctrl.dateFilter">\n        </xlr-tile-date-range>\n    </div>\n    <div class="form-group">\n        <label class="control-label col-xs-3">Filters</label>\n        <div class="col-xs-9">\n            <composite-filter\n                available-types="$ctrl.availableFilterTypes"\n                stored-filters="$ctrl.dashboard.properties.filters"\n                on-change="$ctrl.onFilterChange(filters)">\n            </composite-filter>\n            <span class="description">Filters to apply to reported data</span>\n        </div>\n    </div>\n</div>';

var ReleaseStatisticsController = function () {
    function ReleaseStatisticsController() {
        (0, _classCallCheck3.default)(this, ReleaseStatisticsController);
    }

    (0, _createClass3.default)(ReleaseStatisticsController, [{
        key: '$onInit',
        value: function $onInit() {
            this.dateFilter = this.initialDateFilter;

            this.dashboard.properties.filters = this.dashboard.properties.filters || [];

            if (this.parentId) {
                this.dashboard.properties.filters.push({
                    id: _reportTileConstants.ENTITY_ID_PLACEHOLDER,
                    type: _reportTileConstants.FOLDER_FILTER_TYPE,
                    folderId: Ids.getName(this.parentId)
                });
            }
            this.onDateFilterChange();

            this.availableFilterTypes = [_reportTileConstants.TEMPLATE_FILTER_TYPE, _reportTileConstants.FOLDER_FILTER_TYPE, _reportTileConstants.TAG_FILTER_TYPE];
        }
    }, {
        key: 'onDateFilterChange',
        value: function onDateFilterChange() {
            var dateFilter = this.dashboard.properties.filters.find(function (f) {
                return f.type === _reportTileConstants.DATE_FILTER_TYPE;
            });
            if (dateFilter) {
                dateFilter.timeFrame = this.dateFilter.timeFrame;
                if (this.dateFilter.timeFrame === 'RANGE') {
                    var stringified = this.stringifyDateFilter(this.dateFilter);
                    dateFilter.from = stringified.from;
                    dateFilter.to = stringified.to;
                } else {
                    dateFilter.from = null;
                    dateFilter.to = null;
                }
            } else {
                this.dashboard.properties.filters.push((0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                    id: _reportTileConstants.ENTITY_ID_PLACEHOLDER,
                    type: _reportTileConstants.DATE_FILTER_TYPE
                }));
            }
            this.updateDashboard();
        }
    }, {
        key: 'onFilterChange',
        value: function onFilterChange(rawFilters) {
            var filters = [].concat((0, _toConsumableArray3.default)(rawFilters), [(0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                id: _reportTileConstants.ENTITY_ID_PLACEHOLDER,
                type: _reportTileConstants.DATE_FILTER_TYPE
            })]);
            this.updateDashboard({ filters: filters });
        }
    }, {
        key: 'updateDashboard',
        value: function updateDashboard(filters) {
            this.dashboard.properties = (0, _extends3.default)({}, this.dashboard.properties, filters);
        }
    }, {
        key: 'stringifyDateFilter',
        value: function stringifyDateFilter(dateFilter) {
            if (dateFilter.timeFrame === 'RANGE') {
                return (0, _extends3.default)({}, dateFilter, {
                    from: dateFilter.from ? moment(dateFilter.from).toISOString() : null,
                    to: dateFilter.to ? moment(dateFilter.to).toISOString() : null
                });
            }
            return dateFilter;
        }
    }, {
        key: 'initialDateFilter',
        get: function get() {
            if (this.dashboard && this.dashboard.properties && this.dashboard.properties.filters && this.dashboard.properties.filters.length) {
                var dateFilter = this.dashboard.properties.filters.find(function (f) {
                    return f.type === _reportTileConstants.DATE_FILTER_TYPE;
                });
                if (dateFilter) {
                    return dateFilter;
                }
            }
            return {
                timeFrame: _reportTileConstants.DEFAULT_TIME_PERIOD,
                from: null,
                to: null
            };
        }
    }]);
    return ReleaseStatisticsController;
}();

var releaseStatisticsConfigComponent = exports.releaseStatisticsConfigComponent = {
    bindings: {
        parentId: '<',
        dashboard: '<'
    },
    controller: ReleaseStatisticsController,
    template: template
};

/***/ }),

/***/ 3734:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3735);

var _templateRevisionType = __webpack_require__(3737);

var _templateRevisionType2 = _interopRequireDefault(_templateRevisionType);

var _templateHistoryRevisionController = __webpack_require__(3738);

var _templateHistoryRevisionController2 = _interopRequireDefault(_templateHistoryRevisionController);

var _previewTemplateComponent = __webpack_require__(3740);

var _previewTemplateComponent2 = _interopRequireDefault(_previewTemplateComponent);

var _makeNewVersion = __webpack_require__(3741);

var _makeNewVersion2 = _interopRequireDefault(_makeNewVersion);

var _templateVersioning = __webpack_require__(3742);

var _templateVersioning2 = _interopRequireDefault(_templateVersioning);

var _compareTemplateRevisionsComponent = __webpack_require__(3743);

var _compareTemplateRevisionsComponent2 = _interopRequireDefault(_compareTemplateRevisionsComponent);

var _restoreRevisionConfirmationComponent = __webpack_require__(3744);

var _restoreRevisionConfirmationComponent2 = _interopRequireDefault(_restoreRevisionConfirmationComponent);

var _deleteRevisionConfirmationComponent = __webpack_require__(3745);

var _deleteRevisionConfirmationComponent2 = _interopRequireDefault(_deleteRevisionConfirmationComponent);

var _gitTagDirective = __webpack_require__(3746);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease.templateVersioning', ['xlrelease', 'ui.router']).constant('TemplateRevisionType', _templateRevisionType2.default).service('TemplateVersioningService', _templateVersioning2.default).controller('templateHistoryRevisionController', _templateHistoryRevisionController2.default).component('previewTemplate', _previewTemplateComponent2.default).component('makeNewVersion', _makeNewVersion2.default).component('compareTemplateRevisions', _compareTemplateRevisionsComponent2.default).component('revertRevisionConfirmation', _restoreRevisionConfirmationComponent2.default).component('deleteRevisionConfirmation', _deleteRevisionConfirmationComponent2.default).directive('gitTag', _gitTagDirective.gitTagDirective).config(['$stateProvider', function ($stateProvider) {
    $stateProvider.state('templateRevisions', {
        url: '/templates/:releaseId/revision',
        reloadOnSearch: false,
        templateUrl: 'static/8.6.2/include/template-versioning/template-history-revision.html',
        controller: 'templateHistoryRevisionController',
        controllerAs: '$ctrl',
        resolve: {
            release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }]
            // releasePromise: ['$stateParams', 'ReleasesService', ($stateParams, ReleasesService) => ReleasesService.getReleaseWithDependencies($stateParams.releaseId)],
        }
    });
}]);

/***/ }),

/***/ 3735:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3737:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var TemplateRevisionType = {
    VERSION: 0,
    REVISION: 1
};

exports.default = TemplateRevisionType;

/***/ }),

/***/ 3738:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _versioningBulkSelect = __webpack_require__(3739);

var _versioningBulkSelect2 = _interopRequireDefault(_versioningBulkSelect);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TemplateHistoryRevisionController = function () {
    function TemplateHistoryRevisionController($stateParams, release, $uibModal, Authenticator, Permissions, TemplateRevisionType, Toastr, $q, Page, TemplateVersioningService) {
        var _this = this;

        (0, _classCallCheck3.default)(this, TemplateHistoryRevisionController);

        this.checkboxStatus = function (revisionId) {
            return _this.versioningBulkSelect.getCheckboxStatus(revisionId);
        };

        this.$stateParams = $stateParams;
        this.$uibModal = $uibModal;
        this.Authenticator = Authenticator;
        this.Permissions = Permissions;
        this.TemplateRevisionType = TemplateRevisionType;
        this.TemplateVersioningService = TemplateVersioningService;
        this.Toastr = Toastr;
        this.$q = $q;
        this.Page = Page;
        this.release = release;
        this.templateId = this.$stateParams.releaseId;
        this.filters = {};
        this.filtersChanged.bind(this);
        this.selectedRevisions = [];
        this.currentChanges = [];
        this.selectedVersion = [];

        this.showCurrentState = false;
        this.templateVersioningSettings = undefined;
        this.versioningBulkSelect = new _versioningBulkSelect2.default();
        this.templateHistory = [];
        this.connector = undefined;
    }

    (0, _createClass3.default)(TemplateHistoryRevisionController, [{
        key: '$onInit',
        value: function $onInit() {
            this.Page.setReleaseOpened(this.release);
            this.loadTemplateHistory();
            this.fetchTemplateVersioningSettings();
            this.loadSCMConnection();
        }
    }, {
        key: 'loadTemplateHistory',
        value: function loadTemplateHistory() {
            var _this2 = this;

            this.TemplateVersioningService.getRevisions(this.templateId).then(function (history) {
                _this2.versioningBulkSelect.setRevisions(history);
                _this2.templateHistory = _this2.formatHistoryList(history);
                _this2.unfilteredTemplateHistory = angular.copy(history);

                _this2.filtersChanged(_this2.filters);
            });
        }
    }, {
        key: 'fetchTemplateVersioningSettings',
        value: function fetchTemplateVersioningSettings() {
            var _this3 = this;

            this.TemplateVersioningService.getTemplateVersioningSettings().then(function (resp) {
                _this3.templateVersioningSettings = resp.data;
            });
        }
    }, {
        key: 'loadSCMConnection',
        value: function loadSCMConnection() {
            var _this4 = this;

            this.TemplateVersioningService.getSCMConnection(this.templateId).then(function (connector) {
                if (_.has(connector, 'id')) {
                    _this4.connector = connector;
                }
            });
        }
    }, {
        key: 'formatHistoryList',
        value: function formatHistoryList(historyList) {
            var formattedRevisionList = [];
            var versionObject = null;
            this.currentChanges = [];

            for (var i = 0; i < historyList.length; i++) {
                var item = historyList[i];

                if (item.revisionType === this.TemplateRevisionType.VERSION) {
                    versionObject = item;
                    var revisionList = {
                        revisions: []
                    };
                    angular.extend(versionObject, revisionList);

                    formattedRevisionList.push(versionObject);
                } else if (formattedRevisionList.length === 0 && item.revisionType === this.TemplateRevisionType.REVISION) {
                    this.currentChanges.push(item);
                } else {
                    formattedRevisionList[formattedRevisionList.length - 1].revisions.push(item);
                }
            }

            return formattedRevisionList;
        }
    }, {
        key: 'filtersChanged',
        value: function filtersChanged(filters) {
            var templateHistoryTemp = this.unfilteredTemplateHistory.filter(function (item) {
                if (filters.username) return item.username && item.username.indexOf(filters.username) !== -1;
                return true;
            }).filter(function (item) {
                if (filters.from && filters.to) return item.revisionTime > filters.from && item.revisionTime < filters.to;
                if (filters.from) return item.revisionTime > filters.from;
                if (filters.to) return item.revisionTime < filters.to;
                return true;
            });

            this.templateHistory = this.formatHistoryList(templateHistoryTemp);
        }
    }, {
        key: 'showRevision',
        value: function showRevision(revisionId) {
            var _this5 = this;

            var _version = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

            this.$uibModal.open({
                component: 'previewTemplate',
                resolve: {
                    revisionId: revisionId,
                    version: function version() {
                        return _version;
                    },
                    dsl: function dsl() {
                        return _this5.TemplateVersioningService.getRevision(_this5.templateId, revisionId);
                    }
                },
                size: 'lg'
            });
        }
    }, {
        key: 'selectVersionForRevision',
        value: function selectVersionForRevision(id) {
            var index = this.selectedVersion.indexOf(id);
            if (index === -1) {
                this.selectedVersion.push(id);
            } else {
                this.selectedVersion.splice(index, 1);
            }
        }
    }, {
        key: 'showRevisionForVersion',
        value: function showRevisionForVersion(id) {
            return this.selectedVersion.indexOf(id) !== -1;
        }
    }, {
        key: 'toggleSelection',
        value: function toggleSelection($event, revisionId) {
            this.versioningBulkSelect.selectRevision(revisionId, $event.shiftKey);
        }
    }, {
        key: 'selectionEnabled',
        value: function selectionEnabled(revisionId) {
            return true;
        }
    }, {
        key: 'isSelected',
        value: function isSelected(revisionId) {
            return this.versioningBulkSelect.isSelected(revisionId);
        }
    }, {
        key: 'selectAllCheckBoxStatus',
        value: function selectAllCheckBoxStatus() {
            return this.versioningBulkSelect.selectAllCheckBoxStatus();
        }
    }, {
        key: 'anySelected',
        value: function anySelected() {
            return this.versioningBulkSelect.isAnySelected();
        }
    }, {
        key: 'isAllSelected',
        value: function isAllSelected() {
            return this.versioningBulkSelect.isAllSelected();
        }
    }, {
        key: 'canSelectAll',
        value: function canSelectAll() {
            return this.versioningBulkSelect.canSelectAll();
        }
    }, {
        key: 'diffEnabled',
        value: function diffEnabled() {
            return this.versioningBulkSelect.selectedLength() === 2;
        }
    }, {
        key: 'showDiff',
        value: function showDiff() {
            var _this6 = this;

            var _sort = [].concat((0, _toConsumableArray3.default)(this.versioningBulkSelect.selected)).sort(),
                _sort2 = (0, _slicedToArray3.default)(_sort, 2),
                toRevisionId = _sort2[0],
                revisionId = _sort2[1];

            if (toRevisionId === 0) {
                var _ref = [toRevisionId, revisionId];
                revisionId = _ref[0];
                toRevisionId = _ref[1];
            }

            this.$uibModal.open({
                component: 'compareTemplateRevisions',
                resolve: {
                    dsls: function dsls() {
                        return _this6.TemplateVersioningService.getDiffs(_this6.templateId, revisionId, toRevisionId);
                    }
                },
                size: 'lg'
            });
        }
    }, {
        key: 'makeNewVersionModal',
        value: function makeNewVersionModal() {
            var _this7 = this;

            this.$uibModal.open({
                animation: false,
                component: 'makeNewVersion',
                resolve: {
                    templateId: function templateId() {
                        return _this7.templateId;
                    }
                },
                backdrop: 'static',
                keyboard: false
            }).result.then(function (createNewVersionResponse) {
                if (createNewVersionResponse.success) {
                    _this7.Toastr.success('The version was successfuly created.');
                    _this7.loadTemplateHistory();
                }
            });
        }
    }, {
        key: 'isVersion',
        value: function isVersion(historyItem) {
            return historyItem.revisionType === this.TemplateRevisionType.VERSION;
        }
    }, {
        key: 'hasEditPermission',
        value: function hasEditPermission() {
            return this.Authenticator.hasPermission(this.Permissions.EDIT_TEMPLATE, this.release);
        }
    }, {
        key: 'hasRestorePermission',
        value: function hasRestorePermission() {
            return this.hasEditPermission() && this.Authenticator.hasPermission(this.Permissions.EDIT_TRIGGERS, this.release) && this.Authenticator.hasPermission(this.Permissions.CREATE_RELEASE_FROM_TEMPLATE, this.release);
        }
    }, {
        key: 'restoreRevision',
        value: function restoreRevision(revisionToRestore) {
            var _this8 = this;

            this.$uibModal.open({
                animation: false,
                component: 'revertRevisionConfirmation',
                resolve: {
                    revisionName: function revisionName() {
                        return _this8.isVersion(revisionToRestore) ? revisionToRestore.version : revisionToRestore.id;
                    },
                    revisionTime: function revisionTime() {
                        return revisionToRestore.revisionTime;
                    },
                    templateTitle: function templateTitle() {
                        return _this8.release.title;
                    },
                    diff: function diff() {
                        return _this8.TemplateVersioningService.getDiffs(_this8.templateId, revisionToRestore.id);
                    }
                }
            }).result.then(function (result) {
                if (result === true) {
                    _this8.TemplateVersioningService.restore(_this8.templateId, revisionToRestore.id).then(function (response) {
                        return _this8.Toastr.success('Revision ' + revisionToRestore.id + ' restored.');
                    }, function (error) {
                        return _this8.Toastr.error('Failed to restore revision ' + revisionToRestore.id + '. Status: ' + error.status + '. Response: ' + error.statusText);
                    }).then(function (result) {
                        return _this8.loadTemplateHistory();
                    });
                }
            });
        }
    }, {
        key: 'deleteRevisions',
        value: function deleteRevisions() {
            var _this9 = this;

            var revisionToDelete = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

            var revisionsToDelete = revisionToDelete ? [revisionToDelete.id] : this.versioningBulkSelect.selectedForDelete;

            this.$uibModal.open({
                animation: false,
                component: 'deleteRevisionConfirmation',
                resolve: {
                    revisionsToDeleteN: revisionsToDelete.length
                }
            }).result.then(function (result) {
                if (result === true) {
                    var deletePromise = function deletePromise() {
                        if (revisionsToDelete.length === 1) {
                            var revision = revisionsToDelete[0];
                            return _this9.TemplateVersioningService.deleteRevision(_this9.templateId, revision).then(function (response) {
                                return _this9.Toastr.success('You have successfully deleted revision ' + revision + ' from XL Release');
                            }, function (error) {
                                return _this9.Toastr.error('Failed to delete revision ' + revision + '. Status: ' + error.status + '. Response: ' + error.statusText);
                            });
                        } else {
                            return _this9.TemplateVersioningService.deleteRevisions(_this9.templateId, revisionsToDelete).then(function (response) {
                                return _this9.Toastr.success('You have successfully deleted ' + revisionsToDelete.length + ' revisions from XL Release');
                            }, function (error) {
                                return _this9.Toastr.error('Failed to delete ' + revisionsToDelete.length + ' revisions. Status: ' + error.status + '. Response: ' + error.statusText);
                            });
                        }
                    };

                    deletePromise().then(function (result) {
                        _this9.versioningBulkSelect.clearSelection();
                        _this9.loadTemplateHistory();
                    });
                }
            });
        }
    }, {
        key: 'extractVersion',
        value: function extractVersion(tag) {
            var result = /^xlr\/[0-9a-f]{40}\/(.+)$/.exec(tag);
            if (result === null || result.length !== 2) {
                return tag;
            } else {
                return result[1];
            }
        }
    }]);
    return TemplateHistoryRevisionController;
}();

TemplateHistoryRevisionController.$inject = ['$stateParams', 'release', '$uibModal', 'Authenticator', 'Permissions', 'TemplateRevisionType', 'Toastr', '$q', 'Page', 'TemplateVersioningService'];
exports.default = TemplateHistoryRevisionController;

/***/ }),

/***/ 3739:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _immutable = __webpack_require__(161);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var VersioningBulkSelect = function () {
    function VersioningBulkSelect() {
        var _this = this;

        (0, _classCallCheck3.default)(this, VersioningBulkSelect);

        this.addCheckedSubset = function (current) {
            return function (add) {
                return current.union(add);
            };
        };

        this.removeCheckedSubset = function (current) {
            return function (remove) {
                return current.subtract(remove);
            };
        };

        this.getCheckboxStatus = function (revisionId) {
            if (!_.isUndefined(_this._parents[revisionId])) {
                if (_.every(_this._parents[revisionId], function (revId) {
                    return _this.bulkSelectionState.selected.has(revId);
                })) {
                    return 'checked';
                } else if (_.some(_this._parents[revisionId], function (revId) {
                    return _this.bulkSelectionState.selected.has(revId);
                })) {
                    return 'indeterminate';
                }
            }
            return _this.bulkSelectionState.selected.has(revisionId) ? 'checked' : 'unchecked';
        };

        this.selectAllCheckBoxStatus = function () {
            var selectIntersections = _.intersection(_this.bulkSelectionState.selected.toJS(), _this._selectAll);
            if (!_.isEmpty(selectIntersections) && selectIntersections.length === _this._selectAll.length) {
                return 'checked';
            } else if (!_.isEmpty(selectIntersections)) {
                return 'indeterminate';
            }
            return 'unchecked';
        };

        this.setRevisions = function (revisions) {
            _this._revisions = revisions;
            var currentRevisionId = null;
            _.forEach(revisions, function (revision) {
                if (revision.revisionType === 0) {
                    _this._parents[revision.id] = [];
                    currentRevisionId = revision.id;
                    _this._selectAll.push(revision.id);
                } else if (currentRevisionId !== null) {
                    _this._parents[currentRevisionId].push(revision.id);
                    _this._children[revision.id] = currentRevisionId;
                    _this._selectAll.push(revision.id);
                } else {
                    _this._children[revision.id] = currentRevisionId;
                }
            });
        };

        this.clearSelection = function () {
            _this.bulkSelectionState.selected = (0, _immutable.Set)();
        };

        this.bulkSelectionState = {
            selected: (0, _immutable.Set)(),
            lastSelectedId: undefined
        };
        this._revisions = [];
        this._selectAll = [];
        this._parents = {};
        this._children = {};
    }

    (0, _createClass3.default)(VersioningBulkSelect, [{
        key: 'selectRevision',
        value: function selectRevision(revisionId, isShiftKeyDown) {
            var _this2 = this;

            var toggleFunc = !this.bulkSelectionState.selected.has(revisionId) ? this.addCheckedSubset(this.bulkSelectionState.selected) : this.removeCheckedSubset(this.bulkSelectionState.selected);
            this.bulkSelectionState.lastSelectedId = _.isUndefined(this.bulkSelectionState.lastSelectedId) ? revisionId : this.bulkSelectionState.lastSelectedId;

            var revisionIds = _immutable.Set.of(revisionId);

            if (_.isUndefined(revisionId)) {
                if (this.isAllSelected()) {
                    this.bulkSelectionState.selected = this.removeCheckedSubset(this.bulkSelectionState.selected)((0, _immutable.Set)(this._selectAll));
                } else {
                    this.bulkSelectionState.selected = this.addCheckedSubset(this.bulkSelectionState.selected)((0, _immutable.Set)(this._selectAll));
                }
            } else if (!isShiftKeyDown || this.bulkSelectionState.lastSelectedId === revisionId) {
                this.bulkSelectionState.selected = toggleFunc(revisionIds);
            } else {
                var selectedRevisions = this._revisions.filter(function (revision) {
                    return _.inRange(revision.id, _.min([revisionId, _this2.bulkSelectionState.lastSelectedId]), _.max([revisionId, _this2.bulkSelectionState.lastSelectedId]) + 1);
                }).map(function (revision) {
                    return revision.id;
                });
                this.bulkSelectionState.selected = toggleFunc(revisionIds.concat(selectedRevisions));
            }

            this.bulkSelectionState.lastSelectedId = revisionId;
        }
    }, {
        key: 'isSelected',
        value: function isSelected(revisionId) {
            return this.bulkSelectionState.selected.has(revisionId);
        }
    }, {
        key: 'isAnySelected',
        value: function isAnySelected() {
            return !this.bulkSelectionState.selected.isEmpty();
        }
    }, {
        key: 'isAllSelected',
        value: function isAllSelected() {
            var selectIntersections = _.intersection(this.bulkSelectionState.selected.toJS(), this._selectAll);
            return !_.isEmpty(selectIntersections) && selectIntersections.length === this._selectAll.length;
        }
    }, {
        key: 'canSelectAll',
        value: function canSelectAll() {
            return this._selectAll.length > 0;
        }
    }, {
        key: 'selectedLength',
        value: function selectedLength() {
            return this.bulkSelectionState.selected.size;
        }
    }, {
        key: 'selected',
        get: function get() {
            return this.bulkSelectionState.selected.toJS();
        }
    }, {
        key: 'selectedForDelete',
        get: function get() {
            return _.intersection(this.bulkSelectionState.selected.toJS(), this._selectAll);
        }
    }]);
    return VersioningBulkSelect;
}();

exports.default = VersioningBulkSelect;

/***/ }),

/***/ 3740:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _copyTextToClipboard = __webpack_require__(708);

var _copyTextToClipboard2 = _interopRequireDefault(_copyTextToClipboard);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-header">\n        <button type="button" class="close" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon" /></button>\n        <h5 class="modal-title">\n            <p>Preview of template revision {{$ctrl.resolve.revisionId}}</p>\n            <p data-ng-if="$ctrl.resolve.version !== null" id="version-tag">\n                <a href class="link"\n                    ng-mouseenter="$ctrl.showCopyIcon()" ng-mouseleave="$ctrl.hideCopyIcon()"\n                    data-ng-click="$ctrl.copyToClipboard($ctrl.resolve.version)"\n                    uib-tooltip="Copied" tooltip-trigger="\'none\'" tooltip-is-open="$ctrl.tooltipIsOpen" \n                    tooltip-placement="right" tooltip-class="slide-out-left">                \n                    Version: {{$ctrl.resolve.version}} \n                    <i data-ng-show="$ctrl.copyIconIsVisible" class="copy-icon"></i>\n                </a>                          \n            </p>          \n        </h5>\n    </div>\n    <div class="modal-body scrollable-modal-body">\n        <div id="dsl-content" hljs="" hljs-source="$ctrl.resolve.dsl" hljs-language="groovy"></div>\n    </div>\n    <div class="modal-footer">\n        <div class="button cancel" ng-click="$ctrl.dismiss()">Close</div>\n    </div>\n    ';

var PreviewTemplateComponentController = function () {
    function PreviewTemplateComponentController($timeout) {
        (0, _classCallCheck3.default)(this, PreviewTemplateComponentController);

        this.$timeout = $timeout;
        this.copyIconIsVisible = false;
        this.tooltipIsOpen = false;
        this.iconTimer = undefined;
    }

    (0, _createClass3.default)(PreviewTemplateComponentController, [{
        key: 'showCopyIcon',
        value: function showCopyIcon() {
            this.$timeout.cancel(this.iconTimer);
            this.copyIconIsVisible = true;
        }
    }, {
        key: 'hideCopyIcon',
        value: function hideCopyIcon() {
            var _this = this;

            this.iconTimer = this.$timeout(function () {
                return _this.copyIconIsVisible = false;
            }, 1000);
        }
    }, {
        key: 'copyToClipboard',
        value: function copyToClipboard(objectToCopy) {
            var _this2 = this;

            (0, _copyTextToClipboard2.default)(objectToCopy);
            this.tooltipIsOpen = true;
            this.$timeout(function () {
                return _this2.tooltipIsOpen = false;
            }, 1500);
        }
    }]);
    return PreviewTemplateComponentController;
}();

PreviewTemplateComponentController.$inject = ['$timeout'];

var PreviewTemplateComponent = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    bindToController: true,
    controllerAs: '$ctrl',
    controller: PreviewTemplateComponentController,
    template: template
};

exports.default = PreviewTemplateComponent;

/***/ }),

/***/ 3741:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-content make-new-version-modal"\n            bs-loading-overlay\n            bs-loading-overlay-reference-id="modal">\n        <div class="modal-header">\n            <button type="button" class="close" ng-click="$ctrl.dismiss()" aria-hidden="true"><i class="xl-icon close-icon" /></button>\n            <h4>Save new version</h4>\n        </div>\n        <div class="modal-body"> \n            <xlr-alert alert-type="info">\n                 <p>Version names must be in the proper format.</p>\n                 <p>For more information on this format, see <a href="https://git-scm.com/docs/git-check-ref-format" target="_blank">https://git-scm.com/docs/git-check-ref-format</a>.</p>\n            </xlr-alert>\n            \n            <xlr-alert alert-type="warning" data-ng-if="!$ctrl.createNewVersionResponse.success && $ctrl.createNewVersionResponse.status === 401">\n                <p>SCM connection status: Disconected.</p>\n                <p>Check your Software Configuration Management (SCM) <a data-ng-click="$ctrl.redirectToPropertiesPage()" class="link">access credentials</a> and try again.</p>\n            </xlr-alert>\n            \n            <ng-form name="templateVersionForm" id="templateVersionForm" class="form-horizontal" novalidate>\n                <div class="form-group">\n                    <label class="col-sm-3 control-label" for="versionName">\n                        Name <span class="error">*</span>\n                    </label>\n                    <div class="col-sm-9">\n                        <input id="versionName" type="text" \n                        class="input-block-level" \n                        name="versionName"\n                        ng-model="$ctrl.templateVersionForm.name" \n                        maxlength="255"\n                        git-tag\n                        required\n                        autofocus/>\n                        <span class="error" ng-if="templateVersionForm.versionName.$error.required">Version name is required</span>\n                        <span class="error" ng-if="templateVersionForm.versionName.$error.gitTag && !templateVersionForm.versionName.$error.required">\n                        Version name is of incorrect format\n                        </span>\n                    </div>\n                </div>\n                <div class="form-group">\n                    <label class="col-sm-3 control-label" for="template-version-description">Description <span class="error">*</span></label>\n                    <div class="col-sm-9">\n                        <textarea id="versionDescription"\n                        name="description"\n                        ng-model="$ctrl.templateVersionForm.description"\n                        rows="10" \n                        required\n                        maxlength="255"\n                        class="input-block-level" />\n                        <span class="error" ng-if="templateVersionForm.description.$error.required">Description is required</span>\n                    </div>\n                </div>\n            </ng-form>\n        </div>\n        <div class="modal-footer">        \n            <button class="button cancel" ng-click="$ctrl.dismiss()">Cancel</button>\n            <button class="button save primary" ng-click="$ctrl.save()" ng-disabled="templateVersionForm.$invalid || $ctrl.isBusy">Save</button>\n        </div>\n    </div>\n    ';

var MakeNewVersionController = function () {
    function MakeNewVersionController($state, TemplateVersioningService, Toastr, bsLoadingOverlayService) {
        (0, _classCallCheck3.default)(this, MakeNewVersionController);
        this.OVERLAY_REFERENCE_ID = 'modal';

        this.$state = $state;
        this.TemplateVersioningService = TemplateVersioningService;
        this.Toastr = Toastr;
        this.bsLoadingOverlayService = bsLoadingOverlayService;
        this.isBusy = false;
        this.templateVersionForm = {};
        this.createNewVersionResponse = {};
    }

    (0, _createClass3.default)(MakeNewVersionController, [{
        key: '$onInit',
        value: function $onInit() {
            this.templateId = this.resolve.templateId;
        }
    }, {
        key: 'save',
        value: function save() {
            var _this = this;

            this.isBusy = true;
            this.bsLoadingOverlayService.start({
                referenceId: this.OVERLAY_REFERENCE_ID
            });
            this.TemplateVersioningService.createNewVersion(this.templateId, this.templateVersionForm).then(function (response) {
                _this.createNewVersionResponse = response.data;
                if (_this.createNewVersionResponse.success) {
                    _this.close({
                        $value: _this.createNewVersionResponse
                    });
                } else if (_this.createNewVersionResponse.status !== 401) {
                    _this.Toastr.error(_this.createNewVersionResponse.message);
                }
            }).finally(function () {
                _this.isBusy = false;
                _this.bsLoadingOverlayService.stop({
                    referenceId: _this.OVERLAY_REFERENCE_ID
                });
            });
        }
    }, {
        key: 'redirectToPropertiesPage',
        value: function redirectToPropertiesPage() {
            this.dismiss();
            this.$state.go('templateProperties', { releaseId: this.templateId });
        }
    }]);
    return MakeNewVersionController;
}();

MakeNewVersionController.$inject = ['$state', 'TemplateVersioningService', 'Toastr', 'bsLoadingOverlayService'];

var MakeNewVersionComponent = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    controller: MakeNewVersionController,
    template: template
};

exports.default = MakeNewVersionComponent;

/***/ }),

/***/ 3742:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TemplateVersioningService = function () {
    function TemplateVersioningService(Backend) {
        (0, _classCallCheck3.default)(this, TemplateVersioningService);

        this._Backend = Backend;
    }

    (0, _createClass3.default)(TemplateVersioningService, [{
        key: 'getRevisions',
        value: function getRevisions(templateId) {
            return this._Backend.get('versioning/' + templateId + '/revisions').then(function (response) {
                return response.data;
            });
        }
    }, {
        key: 'getRevision',
        value: function getRevision(templateId, revisionId) {
            return this._Backend.get('versioning/' + templateId + '/revisions/' + revisionId + '/content').then(function (response) {
                return response.data;
            });
        }
    }, {
        key: 'createNewVersion',
        value: function createNewVersion(templateId, newVersion) {
            return this._Backend.post('versioning/' + templateId + '/versions', newVersion);
        }
    }, {
        key: 'getDiffs',
        value: function getDiffs(templateId) {
            var revisionId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var toRevisionId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

            return this._Backend.get('versioning/' + templateId + '/compare?revisionId=' + revisionId + '&toRevisionId=' + toRevisionId).then(function (response) {
                var _response$data = response.data,
                    current = _response$data.current,
                    previous = _response$data.previous;

                return {
                    current: {
                        id: revisionId,
                        content: current
                    },
                    previous: {
                        id: toRevisionId,
                        content: previous
                    }
                };
            });
        }
    }, {
        key: 'restore',
        value: function restore(templateId, revisionId) {
            return this._Backend.put('versioning/' + templateId + '/revisions/' + revisionId + '/restore');
        }
    }, {
        key: 'deleteRevision',
        value: function deleteRevision(templateId, revisionId) {
            return this._Backend.del('versioning/' + templateId + '/revisions/' + revisionId);
        }
    }, {
        key: 'deleteRevisions',
        value: function deleteRevisions(templateId, revisionIds) {
            return this._Backend.del('versioning/' + templateId + '/revisions', { data: revisionIds });
        }
    }, {
        key: 'getTemplateVersioningSettings',
        value: function getTemplateVersioningSettings() {
            return this._Backend.get('versioning/settings', { hideAlert: true });
        }
    }, {
        key: 'getSCMConnection',
        value: function getSCMConnection(templateId) {
            return this._Backend.get('scm/' + templateId + '/connectionInfo').then(function (response) {
                return response.data;
            });
        }
    }]);
    return TemplateVersioningService;
}();

TemplateVersioningService.$inject = ['Backend'];
exports.default = TemplateVersioningService;

/***/ }),

/***/ 3743:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var template = '\n    <div class="modal-header">\n        <button type="button" class="close" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon"/></button>\n        <h5 class="modal-title">See changes for revisions {{$ctrl.resolve.dsls.current.id}} and {{$ctrl.resolve.dsls.previous.id}}</h5>   \n    </div>\n    <div class="modal-body scrollable-modal-body">\n        <pre class="revision-diff" line-diff right-obj="$ctrl.resolve.dsls.current.content" left-obj="$ctrl.resolve.dsls.previous.content"></pre>\n    </div>\n    <div class="modal-footer">\n        <div class="button cancel" ng-click="$ctrl.dismiss()">Close</div>\n    </div>\n    ';

var CompareTemplateRevisionsComponent = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    template: template
};

exports.default = CompareTemplateRevisionsComponent;

/***/ }),

/***/ 3744:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = "\n    <div class=\"modal-content\">\n        <div class=\"modal-header\">\n            <button type=\"button\" class=\"close\" ng-click=\"$ctrl.dismiss()\" aria-hidden=\"true\"><i class=\"xl-icon close-icon\" /></button>\n            <h4 class=\"modal-title\">Restore revision</h4>\n        </div>\n        <div class=\"modal-body scrollable-modal-body\">\n            <p>Revision <strong>'{{$ctrl.revisionName}}'</strong> of template <strong>'{{$ctrl.templateTitle}}'</strong> will be restored to the \n            revision from <strong>{{$ctrl.revisionTime | date:'short'}}</strong>.</p>\n            \n            <pre data-ng-if=\"$ctrl.diff\" class=\"revision-diff\" line-diff right-obj=\"$ctrl.diff.current.content\" left-obj=\"$ctrl.diff.previous.content\"></pre>\n        </div>\n        <div class=\"modal-footer\">\n            <button type=\"button\" class=\"button cancel\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n            <button type=\"button\" class=\"button continue primary\" ng-click=\"$ctrl.close({$value: true})\">Restore</button>\n        </div>\n    </div>\n    ";

var RevertRevisionConfirmationController = function () {
    function RevertRevisionConfirmationController() {
        (0, _classCallCheck3.default)(this, RevertRevisionConfirmationController);
    }

    (0, _createClass3.default)(RevertRevisionConfirmationController, [{
        key: "$onInit",
        value: function $onInit() {
            this.revisionName = this.resolve.revisionName;
            this.revisionTime = this.resolve.revisionTime;
            this.templateTitle = this.resolve.templateTitle;
            this.diff = this.resolve.diff;
        }
    }]);
    return RevertRevisionConfirmationController;
}();

var RevertRevisionConfirmationComponent = {
    bindings: {
        resolve: "<",
        close: "&",
        dismiss: "&"
    },
    controller: RevertRevisionConfirmationController,
    template: template
};

exports.default = RevertRevisionConfirmationComponent;

/***/ }),

/***/ 3745:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _pluralize = __webpack_require__(198);

var _pluralize2 = _interopRequireDefault(_pluralize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-content">\n        <div class="modal-header">\n            <h4 class="modal-title">Delete {{$ctrl.pluralizedRevision}}</h4>\n            <button type="button" class="close" ng-click="$ctrl.dismiss()" aria-hidden="true"><i class="xl-icon close-icon" /></button>\n        </div>\n        <div class="modal-body">\n            <p>{{$ctrl.messageBody}}</p>\n        </div>\n        <div class="modal-footer">\n            <button type="button" class="button cancel" ng-click="$ctrl.dismiss()">Cancel</button>\n            <button type="button" class="button save primary" ng-click="$ctrl.close({$value: true})">Delete</button>\n        </div>\n    </div>\n';

var DeleteRevisionConfirmationController = function () {
    function DeleteRevisionConfirmationController() {
        (0, _classCallCheck3.default)(this, DeleteRevisionConfirmationController);
    }

    (0, _createClass3.default)(DeleteRevisionConfirmationController, [{
        key: '$onInit',
        value: function $onInit() {
            this.toDeleteN = this.resolve.revisionsToDeleteN;
            this.pluralizedRevision = (0, _pluralize2.default)('revision', this.toDeleteN);
            this.messageBody = 'You are about to delete ' + this.toDeleteN + ' ' + this.pluralizedRevision;
        }
    }]);
    return DeleteRevisionConfirmationController;
}();

var DeleteRevisionConfirmationComponent = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    controller: DeleteRevisionConfirmationController,
    template: template
};

exports.default = DeleteRevisionConfirmationComponent;

/***/ }),

/***/ 3746:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var gitTagDirective = exports.gitTagDirective = function gitTagDirective() {
    return {
        require: 'ngModel',
        link: function link(scope, elm, attrs, ctrl) {
            ctrl.$validators.gitTag = function (modelValue, viewValue) {
                return checkRefFormat('refs/tags/' + viewValue);
            };
        }
    };

    function checkRefFormat(refName) {
        var len = refName.length;
        if (len === 0) return false;
        if (refName.endsWith('.lock')) return false;

        var components = 1;
        var p = '\0';
        for (var i = 0; i < len; i++) {
            var c = refName.charAt(i);
            if (c <= ' ') return false;
            switch (c) {
                case '.':
                    switch (p) {
                        case '\0':case '/':case '.':
                            return false;
                    }
                    if (i === len - 1) return false;
                    break;
                case '/':
                    if (i === 0 || i === len - 1) return false;
                    if (p === '/') return false;
                    components++;
                    break;
                case '{':
                    if (p === '@') return false;
                    break;
                case '~':case '^':case ':':
                case '?':case '[':case '*':
                case '\\':
                case '\x7F':
                    return false;
            }
            p = c;
        }
        return components > 1;
    }
};

/***/ }),

/***/ 3747:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3748);

__webpack_require__(3752);

__webpack_require__(3756);

__webpack_require__(3770);

/***/ }),

/***/ 3748:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deploymentsByStageDashboardConfig = __webpack_require__(3749);

__webpack_require__(3750);

angular.module('xlrelease').component('deploymentsByStageDashboardConfig', _deploymentsByStageDashboardConfig.deploymentsByStageDashboardConfig);

/***/ }),

/***/ 3749:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentsByStageDashboardConfig = undefined;

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

var _deploymentTileConstants = __webpack_require__(252);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Ids = (0, _ids2.default)();
var template = "\n<div class=\"report-tile-config deployments-by-stage-config\">\n    <div class=\"form-group\">\n        <label class=\"control-label col-xs-3\">Environment stages</label>\n        <div class=\"col-xs-9\">\n            <div xl-dip-list-of-ci ng-if=\"$ctrl.environmentStages\"\n                     ng-model=\"$ctrl.environmentStages\"\n                     metadata=\"{name: 'environmentStages', label: '', required: true}\"\n                     obj-label=\"title\"\n                     handlers=\"$ctrl.environmentStagesHandler\"\n                     open-on-click=\"true\"\n                     empty-placeholder=\"Select a stage...\">\n                </div>\n            <span class=\"description\">Environment stages to display on the dashboard</span>\n        </div>\n    </div>\n    <div class=\"form-group\">\n        <xlr-tile-date-range\n                on-date-range-change=\"$ctrl.onDateFilterChange()\"\n                date-range=\"$ctrl.dateFilter\">\n        </xlr-tile-date-range>\n    </div>\n    <div class=\"form-group\">\n        <label class=\"control-label col-xs-3\">Filters</label>\n        <div class=\"col-xs-9\">\n            <composite-filter\n                available-types=\"$ctrl.availableFilterTypes\"\n                stored-filters=\"$ctrl.dashboard.properties.filters\"\n                on-change=\"$ctrl.onFilterChange(filters)\">\n            </composite-filter>\n            <span class=\"description\">Additional filters to apply to reported data</span>\n        </div>\n    </div>\n</div>";

var DEFAULT_STAGES = ["Development", "Test", "Acceptance", "Production"];
var MAXIMUM_STAGES = 8;
var TIME_PERIOD = 'LAST_MONTH';

var DeploymentsByStageDashboardConfigController = function () {
    function DeploymentsByStageDashboardConfigController(DeploymentTileService, $q) {
        (0, _classCallCheck3.default)(this, DeploymentsByStageDashboardConfigController);

        this.DeploymentTileService = DeploymentTileService;
        this.$q = $q;

        this.onSaveCallback = this.beforeSave.bind(this);
    }

    (0, _createClass3.default)(DeploymentsByStageDashboardConfigController, [{
        key: "$onInit",
        value: function $onInit() {
            var _this = this;

            this.parent.registerSaveListener(this.onSaveCallback);
            this.dateFilter = this.initialDateFilter;
            this.availableFilterTypes = [_deploymentTileConstants.FOLDER_FILTER_TYPE, _deploymentTileConstants.ENVIRONMENT_LABEL_FILTER_TYPE, _deploymentTileConstants.APPLICATION_FILTER_TYPE];
            this.environmentStagesHandler = {
                addCandidates: function addCandidates(metadata, options) {
                    return _this.environmentStagesAutocomplete(metadata, options);
                }
            };

            this.dashboard.properties.filters = this.dashboard.properties.filters || [];
            this.loadDefaultFolderFilter();
            this.loadDefaultStages();
            this.onDateFilterChange();
        }
    }, {
        key: "$onDestroy",
        value: function $onDestroy() {
            this.parent.unregisterSaveListener(this.onSaveCallback);
        }
    }, {
        key: "loadDefaultFolderFilter",
        value: function loadDefaultFolderFilter() {
            if (this.parentId) {
                this.dashboard.properties.filters.push({
                    id: _deploymentTileConstants.ENTITY_ID_PLACEHOLDER,
                    type: _deploymentTileConstants.FOLDER_FILTER_TYPE,
                    folderId: Ids.getName(this.parentId)
                });
            }
        }
    }, {
        key: "loadDefaultStages",
        value: function loadDefaultStages() {
            var _this2 = this;

            this.DeploymentTileService.getAllEnvironmentStages(true).then(function (envStages) {
                _this2.availableEnvironmentStages = envStages;
                _this2.environmentStages = DEFAULT_STAGES.reduce(function (acc, defaultStage) {
                    var foundStage = envStages.find(function (envStage) {
                        return envStage.title === defaultStage;
                    });
                    if (foundStage) {
                        acc.push(foundStage);
                    }
                    return acc;
                }, []);
            });
        }
    }, {
        key: "onDateFilterChange",
        value: function onDateFilterChange() {
            var dateFilter = this.dashboard.properties.filters.find(function (f) {
                return f.type === _deploymentTileConstants.DATE_FILTER_TYPE;
            });
            if (dateFilter) {
                dateFilter.timeFrame = this.dateFilter.timeFrame;
                if (this.dateFilter.timeFrame === 'RANGE') {
                    var stringified = this.stringifyDateFilter(this.dateFilter);
                    dateFilter.from = stringified.from;
                    dateFilter.to = stringified.to;
                } else {
                    dateFilter.from = null;
                    dateFilter.to = null;
                }
            } else {
                this.dashboard.properties.filters.push((0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                    id: _deploymentTileConstants.ENTITY_ID_PLACEHOLDER,
                    type: _deploymentTileConstants.DATE_FILTER_TYPE
                }));
            }
            this.updateDashboard();
        }
    }, {
        key: "onFilterChange",
        value: function onFilterChange(rawFilters) {
            var filters = [].concat((0, _toConsumableArray3.default)(rawFilters), [(0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                id: _deploymentTileConstants.ENTITY_ID_PLACEHOLDER,
                type: _deploymentTileConstants.DATE_FILTER_TYPE
            })]);
            this.updateDashboard({ filters: filters });
        }
    }, {
        key: "updateDashboard",
        value: function updateDashboard(filters) {
            this.dashboard.properties = (0, _extends3.default)({}, this.dashboard.properties, filters);
        }
    }, {
        key: "beforeSave",
        value: function beforeSave(dashboard) {
            dashboard.properties.stageIds = (this.environmentStages || []).map(function (stage) {
                return stage.id;
            }).slice(0, MAXIMUM_STAGES);
        }
    }, {
        key: "stringifyDateFilter",
        value: function stringifyDateFilter(dateFilter) {
            if (dateFilter.timeFrame === 'RANGE') {
                return (0, _extends3.default)({}, dateFilter, {
                    from: dateFilter.from ? moment(dateFilter.from).toISOString() : null,
                    to: dateFilter.to ? moment(dateFilter.to).toISOString() : null
                });
            }
            return dateFilter;
        }
    }, {
        key: "environmentStagesAutocomplete",
        value: function environmentStagesAutocomplete(metadata, options) {
            var _this3 = this;

            var candidates = _.chain(this.availableEnvironmentStages).reject(function (stage) {
                return _.find(_this3.environmentStages, { id: stage.id });
            }).filter(function (stage) {
                return stage.title.toLowerCase().indexOf(options.term.toLowerCase()) !== -1;
            }).value();
            return this.$q.resolve(candidates);
        }
    }, {
        key: "initialDateFilter",
        get: function get() {
            if (this.dashboard && this.dashboard.properties && this.dashboard.properties.filters && this.dashboard.properties.filters.length) {
                var dateFilter = this.dashboard.properties.filters.find(function (f) {
                    return f.type === _deploymentTileConstants.DATE_FILTER_TYPE;
                });
                if (dateFilter) {
                    return dateFilter;
                }
            }
            return {
                timeFrame: TIME_PERIOD,
                from: null,
                to: null
            };
        }
    }]);
    return DeploymentsByStageDashboardConfigController;
}();

DeploymentsByStageDashboardConfigController.$inject = ['DeploymentTileService', '$q'];
var deploymentsByStageDashboardConfig = exports.deploymentsByStageDashboardConfig = {
    bindings: {
        parentId: '<',
        dashboard: '<',
        parent: '<'
    },
    controller: DeploymentsByStageDashboardConfigController,
    template: template
};

/***/ }),

/***/ 3750:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3752:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _angular = __webpack_require__(131);

var _angular2 = _interopRequireDefault(_angular);

var _deploymentTaskFacetComponent = __webpack_require__(3753);

var _deploymentTaskService = __webpack_require__(3755);

var _deploymentTaskService2 = _interopRequireDefault(_deploymentTaskService);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_angular2.default.module('xlrelease').service('DeploymentTaskService', _deploymentTaskService2.default).component('deploymentTaskFacet', _deploymentTaskFacetComponent.deploymentTaskFacetComponent);

/***/ }),

/***/ 3753:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentTaskFacetComponent = undefined;

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deploymentTaskFacetTpl = __webpack_require__(3754);

var _deploymentTaskFacetTpl2 = _interopRequireDefault(_deploymentTaskFacetTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeploymentTaskFacetComponentController = function () {
    function DeploymentTaskFacetComponentController(DeploymentTaskService, $q, uuid4) {
        (0, _classCallCheck3.default)(this, DeploymentTaskFacetComponentController);

        this.DeploymentTaskService = DeploymentTaskService;
        this.$q = $q;
        this.uuid4 = uuid4;

        this.variablesToBeResolved = {
            variables: false,
            environmentOptions: false,
            applicationOptions: false
        };
        this.isLoaded = false;
    }

    (0, _createClass3.default)(DeploymentTaskFacetComponentController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.templateUniqueKey = this.uuid4.generate();
            this.facet.variableMapping = _.isUndefined(this.facet.variableMapping) ? {} : this.facet.variableMapping;
            this.application = {
                variable: this.facet.variableMapping.applicationId
            };
            this.environment = {
                variable: this.facet.variableMapping.environmentId
            };
            this.version = {
                value: this.facet.version,
                variable: this.facet.variableMapping.version
            };

            _promise2.default.all([this.DeploymentTaskService.searchEnvironments().then(function (response) {
                _this.environmentOptions = response.data.map(function (env) {
                    return { id: env.id, title: env.title };
                });
                _this.environmentOptionsAll = _this.environmentOptions;
                _this.environment.value = _this.environmentOptions.find(function (opt) {
                    return opt.id === _this.facet.environmentId;
                });
                _this.variablesToBeResolved.environmentOptions = true;
                _this.checkIsAllVariablesLoaded();
            }), this.DeploymentTaskService.searchApplications().then(function (response) {
                _this.applicationOptions = response.data.map(function (app) {
                    return { id: app.id, title: app.title, environments: app.environments };
                });
                _this.applicationOptionsAll = _this.applicationOptions;
                _this.application.value = _this.applicationOptions.find(function (opt) {
                    return opt.id === _this.facet.applicationId;
                });
                _this.variablesToBeResolved.applicationOptions = true;
                _this.checkIsAllVariablesLoaded();
            })]).then(function () {
                _this.checkIsAllVariablesLoaded();
            });

            this.environmentCiHandler = {
                addCandidates: function addCandidates(metadata, options) {
                    return _this.addCandidates(metadata, options, _this.environmentOptions);
                },
                onSelect: function onSelect(newValue) {
                    return _this.onEnvironmentChange(newValue);
                },
                removeElement: function removeElement() {
                    return _this.applicationOptions = _this.applicationOptionsAll;
                }
            };
            this.applicationCiHandler = {
                addCandidates: function addCandidates(metadata, options) {
                    return _this.addCandidates(metadata, options, _this.applicationOptions);
                },
                onSelect: function onSelect(newValue) {
                    return _this.onApplicationChange(newValue);
                },
                removeElement: function removeElement() {
                    return _this.environmentOptions = _this.environmentOptionsAll;
                }
            };
        }
    }, {
        key: '$onChanges',
        value: function $onChanges(changes) {
            this.updateLoadedBindings(changes);
            this.checkIsAllVariablesLoaded();
        }
    }, {
        key: 'updateLoadedBindings',
        value: function updateLoadedBindings(changes) {
            var _this2 = this;

            _.forOwn(changes, function (value, key) {
                if (_.has(_this2.variablesToBeResolved, key)) {
                    _this2.variablesToBeResolved[key] = !_.isUndefined(value.currentValue);
                }
            });
        }
    }, {
        key: 'checkIsAllVariablesLoaded',
        value: function checkIsAllVariablesLoaded() {
            this.isLoaded = _.every(_.values(this.variablesToBeResolved));
        }
    }, {
        key: 'onEnvironmentChange',
        value: function onEnvironmentChange(environment) {
            this.facet.environmentId = _.get(environment, 'id');
            this.facet.variableMapping.environmentId = this.environment.variable || undefined;
            if (environment) {
                this.applicationOptions = this.applicationOptionsAll.filter(function (app) {
                    return _.isEmpty(app.environments) || _.includes(app.environments.map(function (e) {
                        return e.id;
                    }), environment.id);
                });
            } else {
                this.applicationOptions = this.applicationOptionsAll;
            }
        }
    }, {
        key: 'onApplicationChange',
        value: function onApplicationChange(application) {
            this.facet.applicationId = _.get(application, 'id');
            this.facet.variableMapping.applicationId = this.application.variable || undefined;
            if (application && !_.isEmpty(application.environments)) {
                this.environmentOptions = this.environmentOptionsAll.filter(function (env) {
                    return _.includes(application.environments.map(function (a) {
                        return a.id;
                    }), env.id);
                });
            } else {
                this.environmentOptions = this.environmentOptionsAll;
            }
        }
    }, {
        key: 'addCandidates',
        value: function addCandidates(metadata, options, selectOptions) {
            var candidates = _.filter(selectOptions, function (val) {
                return val.title.toLowerCase().indexOf(options.term.toLowerCase()) >= 0;
            });
            return this.$q.resolve(candidates);
        }
    }, {
        key: 'onVersionChanged',
        value: function onVersionChanged() {
            this.facet.version = this.version.value;
            this.facet.variableMapping.version = this.version.variable || undefined;
        }
    }, {
        key: 'onNewVariable',
        value: function onNewVariable(name, variableType, createdCallback) {
            this.parent.onNewVariable({ name: name, variableType: variableType, createdCallback: createdCallback });
        }
    }]);
    return DeploymentTaskFacetComponentController;
}();

DeploymentTaskFacetComponentController.$inject = ['DeploymentTaskService', '$q', 'uuid4'];
var deploymentTaskFacetComponent = exports.deploymentTaskFacetComponent = {
    bindings: {
        facet: '<',
        variables: '<',
        readonly: '<',
        parent: '<'
    },
    controller: DeploymentTaskFacetComponentController,
    template: _deploymentTaskFacetTpl2.default
};

/***/ }),

/***/ 3754:
/***/ (function(module, exports) {

module.exports = "<div class=\"deployment-task-facet-form\">\n    <div ng-if=\"$ctrl.isLoaded\">\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"application-{{$ctrl.templateUniqueKey}}\">\n                Application <span class=\"error\">*</span>\n            </label>\n            <div class=\"col-sm-8\">\n                <div xlr-dropdown-with-variables\n                     id=\"application-{{$ctrl.templateUniqueKey}}\"\n                     model=\"$ctrl.application\"\n                     name=\"'application'\"\n                     on-change=\"$ctrl.onApplicationChange()\"\n                     on-new=\"$ctrl.onNewVariable(name, variableType, createdCallback)\"\n                     variables=\"$ctrl.variables\"\n                     options=\"{placeholder: 'Select application...', handlers: $ctrl.applicationCiHandler, required: true}\"\n                     read-only=\"$ctrl.readonly\"\n                ></div>\n                <span class=\"description\">The application deployed by this task</span>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"version-{{$ctrl.templateUniqueKey}}\">\n                Version <span class=\"error\">*</span>\n            </label>\n            <div class=\"col-sm-8\">\n                <div xlr-inline-text-with-variables\n                     id=\"version-{{$ctrl.templateUniqueKey}}\"\n                     name=\"'version'\"\n                     model=\"$ctrl.version\"\n                     on-change=\"$ctrl.onVersionChanged()\"\n                     on-new=\"$ctrl.onNewVariable(name, variableType, createdCallback)\"\n                     variables=\"$ctrl.variables\"\n                     options=\"{required: true}\"\n                     read-only=\"$ctrl.readonly\">\n                </div>\n                <span class=\"description\">Version of the application being deployed</span>\n            </div>\n        </div>\n\n        <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"environment-{{$ctrl.templateUniqueKey}}\">\n                Environment <span class=\"error\">*</span>\n            </label>\n            <div class=\"col-sm-8\">\n                <div xlr-dropdown-with-variables\n                     id=\"environment-{{$ctrl.templateUniqueKey}}\"\n                     model=\"$ctrl.environment\"\n                     name=\"'environment'\"\n                     on-change=\"$ctrl.onEnvironmentChange()\"\n                     on-new=\"$ctrl.onNewVariable(name, variableType, createdCallback)\"\n                     variables=\"$ctrl.variables\"\n                     options=\"{placeholder: 'Select environment...', handlers: $ctrl.environmentCiHandler, required: true}\"\n                     read-only=\"$ctrl.readonly\"\n                ></div>\n                <span class=\"description\">The environment where the application is deployed</span>\n            </div>\n        </div>\n    </div>\n    <div ng-if=\"!$ctrl.isLoaded\" class=\"text-center\">\n        <img src=\"static/8.6.2/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n    </div>\n</div>\n"

/***/ }),

/***/ 3755:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeploymentTaskService = function () {
    function DeploymentTaskService(Backend) {
        (0, _classCallCheck3.default)(this, DeploymentTaskService);

        this.Backend = Backend;
    }

    (0, _createClass3.default)(DeploymentTaskService, [{
        key: 'searchApplications',
        value: function searchApplications(title) {
            return this.Backend.post('api/v1/applications/search', { title: title });
        }
    }, {
        key: 'searchEnvironments',
        value: function searchEnvironments(title) {
            return this.Backend.post('api/v1/environments/search', { title: title });
        }
    }]);
    return DeploymentTaskService;
}();

DeploymentTaskService.$inject = ['Backend'];
exports.default = DeploymentTaskService;

/***/ }),

/***/ 3756:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3757);

__webpack_require__(3759);

__webpack_require__(3768);

/***/ }),

/***/ 3757:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3759:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deploymentTileConfig = __webpack_require__(3760);

var _deploymentActivityDetails = __webpack_require__(3762);

var _deploymentState = __webpack_require__(3765);

var _deploymentDate = __webpack_require__(3766);

var _deploymentOwner = __webpack_require__(3767);

angular.module('xlrelease').component('deploymentTileConfig', _deploymentTileConfig.deploymentTileConfigComponent).component('deploymentDate', _deploymentDate.deploymentDateComponent).component('deploymentActivityDetails', _deploymentActivityDetails.deploymentActivityDetailsComponent).component('deploymentState', _deploymentState.deploymentStateComponent).component('deploymentOwner', _deploymentOwner.deploymentOwnerComponent);

/***/ }),

/***/ 3760:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentTileConfigComponent = undefined;

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deploymentTileConfig = __webpack_require__(3761);

var _deploymentTileConfig2 = _interopRequireDefault(_deploymentTileConfig);

var _deploymentTileConstants = __webpack_require__(252);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeploymentTileConfigController = function () {
    function DeploymentTileConfigController() {
        (0, _classCallCheck3.default)(this, DeploymentTileConfigController);
    }

    (0, _createClass3.default)(DeploymentTileConfigController, [{
        key: '$onInit',
        value: function $onInit() {
            this.tile = (0, _extends3.default)({}, this.tile);
            if (_.has(this.tile.properties, "deploymentStatus.value") && this.tile.properties.deploymentStatus.value) {
                this.deploymentStatus = this.tile.properties.deploymentStatus.value;
            } else {
                this.deploymentStatus = "";
            }
            this.dateFilter = this.initialDateFilter;

            this.availableFilterTypes = [_deploymentTileConstants.FOLDER_FILTER_TYPE, _deploymentTileConstants.APPLICATION_FILTER_TYPE, _deploymentTileConstants.ENVIRONMENT_FILTER_TYPE, _deploymentTileConstants.ENVIRONMENT_STAGE_FILTER_TYPE, _deploymentTileConstants.ENVIRONMENT_LABEL_FILTER_TYPE];
        }
    }, {
        key: 'tileTitle',
        value: function tileTitle(title) {
            if (arguments.length) {
                this.updateTile({ title: title });
            }
            return this.tile.properties.title;
        }
    }, {
        key: 'onDeploymentStatusFilterChange',
        value: function onDeploymentStatusFilterChange() {
            this.tile.properties.deploymentStatus = {
                value: this.deploymentStatus ? this.deploymentStatus : null
            };
            this.updateTile();
        }
    }, {
        key: 'onDateFilterChange',
        value: function onDateFilterChange() {
            var dateFilter = this.tile.properties.filters.find(function (f) {
                return f.type === _deploymentTileConstants.DATE_FILTER_TYPE;
            });
            if (dateFilter) {
                dateFilter.timeFrame = this.dateFilter.timeFrame;
                if (this.dateFilter.timeFrame === 'RANGE') {
                    var stringified = this.stringifyDateFilter(this.dateFilter);
                    dateFilter.from = stringified.from;
                    dateFilter.to = stringified.to;
                } else {
                    dateFilter.from = null;
                    dateFilter.to = null;
                }
            } else {
                this.tile.properties.filters.push((0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                    id: _deploymentTileConstants.ENTITY_ID_PLACEHOLDER,
                    type: _deploymentTileConstants.DATE_FILTER_TYPE
                }));
            }
            this.updateTile();
        }
    }, {
        key: 'onFilterChange',
        value: function onFilterChange(rawFilters) {
            var filters = [].concat((0, _toConsumableArray3.default)(rawFilters), [(0, _extends3.default)({}, this.stringifyDateFilter(this.dateFilter), {
                id: _deploymentTileConstants.ENTITY_ID_PLACEHOLDER,
                type: _deploymentTileConstants.DATE_FILTER_TYPE
            })]);
            this.updateTile({ filters: filters });
        }
    }, {
        key: 'updateTile',
        value: function updateTile(tile) {
            this.tile.properties = (0, _extends3.default)({}, this.tile.properties, tile);
            this.onUpdate({ tile: this.tile });
        }
    }, {
        key: 'stringifyDateFilter',
        value: function stringifyDateFilter(dateFilter) {
            if (dateFilter.timeFrame === 'RANGE') {
                return (0, _extends3.default)({}, dateFilter, {
                    from: dateFilter.from ? moment(dateFilter.from).toISOString() : null,
                    to: dateFilter.to ? moment(dateFilter.to).toISOString() : null
                });
            }
            return dateFilter;
        }
    }, {
        key: 'initialDateFilter',
        get: function get() {
            if (this.tile && this.tile.properties && this.tile.properties.filters && this.tile.properties.filters.length) {
                var dateFilter = this.tile.properties.filters.find(function (f) {
                    return f.type === _deploymentTileConstants.DATE_FILTER_TYPE;
                });
                if (dateFilter) {
                    return dateFilter;
                }
            }
            return {
                timeFrame: _deploymentTileConstants.DEFAULT_TIME_PERIOD,
                from: null,
                to: null
            };
        }
    }]);
    return DeploymentTileConfigController;
}();

var deploymentTileConfigComponent = exports.deploymentTileConfigComponent = {
    bindings: {
        tile: '<',
        onUpdate: '&',
        configureDeploymentState: '<'
    },
    controller: DeploymentTileConfigController,
    template: _deploymentTileConfig2.default
};

/***/ }),

/***/ 3761:
/***/ (function(module, exports) {

module.exports = "<div class=\"report-tile-config\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <label for=\"title\" class=\"control-label col-xs-3\">Name <span class=\"error\">*</span></label>\n            <div class=\"col-xs-9\">\n                <input type=\"text\" id=\"title\" name=\"title\" required\n                       ng-model=\"$ctrl.tileTitle\"\n                       ng-model-options=\"{ getterSetter: true }\"\n                       class=\"form-control\">\n                <span class=\"description\">Name of the tile</span>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <xlr-tile-date-range\n                    on-date-range-change=\"$ctrl.onDateFilterChange()\"\n                    date-range=\"$ctrl.dateFilter\">\n            </xlr-tile-date-range>\n        </div>\n        <div class=\"form-group deployment-state\" ng-if=\"$ctrl.configureDeploymentState\">\n            <label for=\"title\" class=\"control-label col-xs-3\">State of deployments <span class=\"error\">*</span></label>\n            <div class=\"col-xs-9\">\n                <label class=\"radio-inline\">\n                    <input type=\"radio\" name=\"listBoxInputOptions\" value=\"\"\n                           ng-model-options=\"{ getterSetter: true }\"\n                           ng-change=\"$ctrl.onDeploymentStatusFilterChange(value)\"\n                           ng-model=\"$ctrl.deploymentStatus\"/> All\n                </label>\n                <label class=\"radio-inline\">\n                    <input type=\"radio\" name=\"listBoxInputOptions\" value=\"COMPLETED\"\n                           ng-model-options=\"{ getterSetter: true }\"\n                           ng-change=\"$ctrl.onDeploymentStatusFilterChange(value)\"\n                           ng-model=\"$ctrl.deploymentStatus\"/> Successful\n                </label>\n                <label class=\"radio-inline\">\n                    <input type=\"radio\" name=\"listBoxInputOptions\" value=\"FAILED\"\n                           ng-model-options=\"{ getterSetter: true }\"\n                           ng-change=\"$ctrl.onDeploymentStatusFilterChange(value)\"\n                           ng-model=\"$ctrl.deploymentStatus\"/> Failed\n                </label>\n                <span class=\"description\">Type of activity to show</span>\n            </div>\n        </div>\n        <div class=\"form-group\">\n            <label class=\"control-label col-xs-3\">Filters</label>\n            <div class=\"col-xs-9\">\n                <composite-filter\n                        available-types=\"$ctrl.availableFilterTypes\"\n                        stored-filters=\"$ctrl.tile.properties.filters\"\n                        on-change=\"$ctrl.onFilterChange(filters)\">\n                </composite-filter>\n                <span class=\"description\">Filters to apply to reported data</span>\n            </div>\n        </div>\n    </div>\n</div>\n"

/***/ }),

/***/ 3762:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentActivityDetailsComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deploymentTileConstants = __webpack_require__(252);

__webpack_require__(3763);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-header">\n        <h5 class="modal-title pull-left deployments-activity-details-title">\n            Activity in the <xlr-tile-date-range-label\n                    class="xlr-tile-date-range-label"\n                    time-frame="$ctrl.resolve.data.timeFrame"\n                    from="$ctrl.resolve.data.dateFrom"\n                    to="$ctrl.resolve.data.dateTo">\n            </xlr-tile-date-range-label>\n        </h5>\n        <button type="button" class="close pull-right" ng-click="$ctrl.close()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix" />\n    </div>\n    <div class="modal-body deployments-activity-details-body">        \n        <div>\n            <div class="btn-group btn-group-toggle mlm" data-toggle="buttons">\n                <label class="btn" \n                    ng-class="{active: $ctrl.selectedState == \'' + _deploymentTileConstants.DEPLOYMENT_STATE_ALL + '\'}"\n                    ng-click="$ctrl.selectState(\'' + _deploymentTileConstants.DEPLOYMENT_STATE_ALL + '\')">\n                    <input type="radio" name="selectedState" autocomplete="off" checked> All\n                </label>\n                <label class="btn"\n                    ng-class="{active: $ctrl.selectedState == \'' + _deploymentTileConstants.DEPLOYMENT_STATE.successful.value + '\'}"\n                    ng-click="$ctrl.selectState(\'' + _deploymentTileConstants.DEPLOYMENT_STATE.successful.value + '\')">\n                    <input type="radio" name="selectedState" autocomplete="off"> ' + _deploymentTileConstants.DEPLOYMENT_STATE.successful.label + '\n                </label>\n                <label class="btn"\n                    ng-class="{active: $ctrl.selectedState == \'' + _deploymentTileConstants.DEPLOYMENT_STATE.failed.value + '\'}"\n                    ng-click="$ctrl.selectState(\'' + _deploymentTileConstants.DEPLOYMENT_STATE.failed.value + '\')">\n                    <input type="radio" name="selectedState" autocomplete="off"> ' + _deploymentTileConstants.DEPLOYMENT_STATE.failed.label + '\n                </label>\n            </div>\n            <div class="alert notice text-center mtl man" ng-if="!$ctrl.isLoading && !$ctrl.deploymentsActivity.length">No deployment activity found</div>\n            <div class="table-responsive" ng-if="$ctrl.deploymentsActivity && $ctrl.deploymentsActivity.length">\n                <table class="table">\n                    <thead>\n                        <tr>\n                            <th class="col-sm-4">\n                                <span class="state-column mlm">State</span>\n                                <span class="task-in-release-column mll">Task in release</span>\n                            </th>\n                            <th class="col-sm-1">Assignee</th>\n                            <th class="col-sm-2">Application</th>\n                            <th class="col-sm-1">Version</th>\n                            <th class="col-sm-2">Environment</th>\n                            <th class="col-sm-2">Date</th>\n                        </tr>\n                    </thead>\n                </table>                \n                <div class="table-body-container scrollable">\n                    <xlr-infinite-scroll-wrapper\n                         on-show-more="$ctrl.showMore()"\n                         disable-when="!$ctrl.hasMore() || $ctrl.isLoading"\n                         show-loader-when="$ctrl.isLoading">\n                        <table class="table table-scrollable">\n                            <tbody>\n                                <tr ng-repeat="deployment in $ctrl.deploymentsActivity" xlr-infinite-scroll>\n                                    <td class="col-sm-4 task-in-release">\n                                        <span class="state-column text-center mlm">\n                                            <task-icon\n                                                    class="deployment-task-icon"\n                                                    task-type="$ctrl.getTaskType(deployment)"\n                                                    task-owner="deployment.taskOwner"\n                                                    custom-icon-location="deployment.customIconLocation">\n                                                </task-icon>\n                                            <deployment-state state-value="deployment.state"></deployment-state>\n                                        </span>\n                                        <span class="task-in-release-column mll">\n                                            <a href="{{$ctrl.getTaskUrl(deployment.releaseId, deployment.taskId)}}" ng-click="$ctrl.close()"\n                                                   class="task-name link"\n                                                   title="{{deployment.taskTitle}}">\n                                                    {{::deployment.taskTitle}}\n                                            </a>\n                                            <a href="{{$ctrl.getReleaseUrl(deployment.releaseId)}}" ng-click="$ctrl.close()" class="release-name link"\n                                               title="{{deployment.releaseTitle}}">\n                                                {{::deployment.releaseTitle}}\n                                            </a>\n                                        </span>\n                                    </td>\n                                    <td class="col-sm-1">\n                                        <span class="table-deployment-data">\n                                            <deployment-owner task-owner="deployment.taskOwner" task-team="deployment.taskTeam"></deployment-owner>\n                                        </span>\n                                    </td>\n                                    <td class="col-sm-2">                                    \n                                        <span class="table-deployment-data" title="{{::deployment.applicationName}}">\n                                            <i class="xl-icon app-icon"></i> {{::deployment.applicationName}}\n                                        </span>\n                                    </td>\n                                    <td class="col-sm-1">\n                                        <span class="table-deployment-data" title="{{::deployment.version}}">\n                                            <i class="xl-icon package-icon"></i> {{::deployment.version}}\n                                        </span>\n                                    </td>\n                                    <td class="col-sm-2">                                    \n                                        <span class="table-deployment-data" title="{{::deployment.environmentName}}">\n                                            <i class="xl-icon environment-icon"/>\n                                            {{::deployment.environmentName}}\n                                        </span>\n                                    </td>\n                                    <td class="col-sm-2">\n                                        <span class="table-deployment-data">\n                                            <deployment-date change-date="deployment.changeDate" full-date="true"></deployment-date>\n                                        </span>\n                                    </td>\n                                </tr>\n                            </tbody>\n                        </table>\n                    </xlr-infinite-scroll-wrapper>\n                </div>\n            </div>\n        </div>\n    </div>    \n';

var ITEMS_PER_PAGE = 8;

var DeploymentActivityDetailsController = function () {
    function DeploymentActivityDetailsController(DeploymentTileService, ViewStorage, Ids) {
        (0, _classCallCheck3.default)(this, DeploymentActivityDetailsController);

        this.DeploymentTileService = DeploymentTileService;
        this.DEPLOYMENT_STATE = _deploymentTileConstants.DEPLOYMENT_STATE;
        this.ViewStorage = ViewStorage;
        this.Ids = Ids;
    }

    (0, _createClass3.default)(DeploymentActivityDetailsController, [{
        key: '$onInit',
        value: function $onInit() {
            this.selectState(this.resolve.data.selectedState || _deploymentTileConstants.DEPLOYMENT_STATE_ALL);
        }
    }, {
        key: 'selectState',
        value: function selectState(state) {
            this.deploymentsActivity = [];
            this.currentPage = 0;
            this.selectedState = state;
            this.hasData = false;
            this.fetchData();
        }
    }, {
        key: 'showMore',
        value: function showMore() {
            this.currentPage++;
            this.fetchData();
        }
    }, {
        key: 'hasMore',
        value: function hasMore() {
            return this.hasData;
        }
    }, {
        key: 'fetchData',
        value: function fetchData(page, offset) {
            var _this = this;

            this.isLoading = true;
            this.DeploymentTileService.fetchTileData(this.resolve.data.tile.id, {
                params: {
                    deploymentState: this.selectedState === _deploymentTileConstants.DEPLOYMENT_STATE_ALL ? '' : this.selectedState,
                    pageSize: ITEMS_PER_PAGE,
                    offset: this.currentPage * ITEMS_PER_PAGE
                }
            }).then(function (resp) {
                _this.hasData = resp.data.data && resp.data.data.length;
                if (_this.hasData) {
                    _this.deploymentsActivity = _this.deploymentsActivity.concat(resp.data.data);
                }
            }).finally(function () {
                _this.isLoading = false;
            });
        }
    }, {
        key: 'getReleaseUrl',
        value: function getReleaseUrl(releaseId) {
            var internalId = this.Ids.toInternalId(releaseId);
            return '#' + this.ViewStorage.getView(internalId, '/releases/' + internalId);
        }
    }, {
        key: 'getTaskUrl',
        value: function getTaskUrl(releaseId, taskId) {
            var phaseTaskId = this.Ids.phaseTaskIdFrom(taskId);
            var internalId = this.Ids.toInternalId(phaseTaskId);
            return this.getReleaseUrl(releaseId) + '?openTaskDetailsModal=' + internalId;
        }
    }, {
        key: 'getTaskType',
        value: function getTaskType(deployment) {
            if (deployment.isPythonScriptTask) {
                return 'xlrelease.CustomScriptTask';
            }
            return deployment.taskType;
        }
    }]);
    return DeploymentActivityDetailsController;
}();

DeploymentActivityDetailsController.$inject = ['DeploymentTileService', 'ViewStorage', 'Ids'];
var deploymentActivityDetailsComponent = exports.deploymentActivityDetailsComponent = {
    bindings: {
        resolve: '<',
        close: '&'
    },
    controller: DeploymentActivityDetailsController,
    template: template
};

/***/ }),

/***/ 3763:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3765:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentStateComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deploymentTileConstants = __webpack_require__(252);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class=\'labels\'>\n        <span class=\'label {{::$ctrl.deploymentState.className}}\'>{{::$ctrl.deploymentState.label}}</span>\n    </div>\n';

var DeploymentStateController = function () {
    function DeploymentStateController() {
        (0, _classCallCheck3.default)(this, DeploymentStateController);
    }

    (0, _createClass3.default)(DeploymentStateController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            var stateKey = _.keys(_deploymentTileConstants.DEPLOYMENT_STATE).find(function (stateKey) {
                return _deploymentTileConstants.DEPLOYMENT_STATE[stateKey].value === _this.stateValue;
            });
            this.deploymentState = _deploymentTileConstants.DEPLOYMENT_STATE[stateKey];
        }
    }]);
    return DeploymentStateController;
}();

var deploymentStateComponent = exports.deploymentStateComponent = {
    bindings: {
        stateValue: '<'
    },
    controller: DeploymentStateController,
    template: template
};

/***/ }),

/***/ 3766:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentDateComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <span ng-if="$ctrl.fullDate">{{$ctrl.convertDate()}}</span>    \n    <span ng-if="!$ctrl.fullDate" tooltip="$ctrl.changeDate | date: \'medium\'" tooltip-position="top">{{$ctrl.convertDate()}}</span> \n';

var DeploymentDateController = function () {
    (0, _createClass3.default)(DeploymentDateController, [{
        key: '$onInit',
        value: function $onInit() {}
    }]);

    function DeploymentDateController($filter) {
        (0, _classCallCheck3.default)(this, DeploymentDateController);

        this.$filter = $filter;
    }

    (0, _createClass3.default)(DeploymentDateController, [{
        key: 'convertDate',
        value: function convertDate() {
            var toMomentDate = moment(this.changeDate);
            if (toMomentDate > moment().subtract(1, 'd')) {
                return toMomentDate.fromNow();
            } else {
                if (this.fullDate) {
                    return this.$filter('date')(this.changeDate, 'medium');
                } else {
                    return this.$filter('date')(this.changeDate, 'mediumDate');
                }
            }
        }
    }]);
    return DeploymentDateController;
}();

DeploymentDateController.$inject = ['$filter'];
var deploymentDateComponent = exports.deploymentDateComponent = {
    bindings: {
        changeDate: '<',
        fullDate: '<'
    },
    controller: DeploymentDateController,
    template: template
};

/***/ }),

/***/ 3767:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentOwnerComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <i class=\'{{$ctrl.getOwnerIcon()}}\'></i>\n    <span class="mrm text-ellipsis">{{$ctrl.getOwner()}}</span>\n';

var DeploymentOwnerController = function () {
    function DeploymentOwnerController() {
        (0, _classCallCheck3.default)(this, DeploymentOwnerController);
    }

    (0, _createClass3.default)(DeploymentOwnerController, [{
        key: 'getOwnerIcon',
        value: function getOwnerIcon() {

            if (this.taskOwner) {
                return 'xl-icon user-icon';
            } else if (this.taskTeam) {
                return 'xl-icon users-icon';
            }
            return 'xl-icon user-automated-icon';
        }
    }, {
        key: 'getOwner',
        value: function getOwner() {
            return this.taskOwner || this.taskTeam || 'Automated';
        }
    }]);
    return DeploymentOwnerController;
}();

var deploymentOwnerComponent = exports.deploymentOwnerComponent = {
    bindings: {
        taskOwner: '<',
        taskTeam: '<'
    },
    controller: DeploymentOwnerController,
    template: template
};

/***/ }),

/***/ 3768:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deploymentTileService = __webpack_require__(3769);

var _deploymentTileConstants = __webpack_require__(252);

angular.module('xlrelease').service('DeploymentTileService', _deploymentTileService.DeploymentTileService);

angular.module('xlrelease').run(['CompositeFilterService', 'DeploymentTileService', function (CompositeFilterService, DeploymentTileService) {
    CompositeFilterService.registerFilter(_deploymentTileConstants.ENVIRONMENT_STAGE_FILTER_TYPE, {
        type: _deploymentTileConstants.ENVIRONMENT_STAGE_FILTER_TYPE,
        title: 'Environment stage',
        operators: [{ value: 'OR', title: 'matches' }],
        filterTag: true,
        property: 'environmentStageId',
        autocompleteCandidates: DeploymentTileService.getAllEnvironmentStages.bind(DeploymentTileService)
    });

    CompositeFilterService.registerFilter(_deploymentTileConstants.ENVIRONMENT_LABEL_FILTER_TYPE, {
        type: _deploymentTileConstants.ENVIRONMENT_LABEL_FILTER_TYPE,
        title: 'Environment label',
        operators: [{ value: 'OR', title: 'matches' }],
        filterTag: true,
        property: 'environmentLabelId',
        autocompleteCandidates: DeploymentTileService.getAllEnvironmentLabels.bind(DeploymentTileService)
    });

    CompositeFilterService.registerFilter(_deploymentTileConstants.ENVIRONMENT_FILTER_TYPE, {
        type: _deploymentTileConstants.ENVIRONMENT_FILTER_TYPE,
        title: 'Environment',
        operators: [{ value: 'OR', title: 'matches' }],
        filterTag: true,
        property: 'environmentId',
        autocompleteCandidates: DeploymentTileService.getAllEnvironments.bind(DeploymentTileService)
    });

    CompositeFilterService.registerFilter(_deploymentTileConstants.APPLICATION_FILTER_TYPE, {
        type: _deploymentTileConstants.APPLICATION_FILTER_TYPE,
        title: 'Application',
        operators: [{ value: 'OR', title: 'matches' }],
        filterTag: true,
        property: 'applicationId',
        autocompleteCandidates: DeploymentTileService.getAllApplications.bind(DeploymentTileService)
    });
}]);

/***/ }),

/***/ 3769:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DeploymentTileService = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _environmentService = __webpack_require__(332);

var _stageService = __webpack_require__(333);

var _labelService = __webpack_require__(579);

var _applicationService = __webpack_require__(423);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DeploymentTileService = exports.DeploymentTileService = function () {
    function DeploymentTileService(Backend, Ids) {
        (0, _classCallCheck3.default)(this, DeploymentTileService);

        this.Backend = Backend;
        this.Ids = Ids;

        this.clearCachedPromises();
    }

    (0, _createClass3.default)(DeploymentTileService, [{
        key: "fetchTileData",
        value: function fetchTileData(tileId, tileProperties) {
            return this.Backend.get("tiles/" + tileId + "/data", (0, _extends3.default)({}, tileProperties, { hideAlert: true }));
        }
    }, {
        key: "getAllEnvironments",
        value: function getAllEnvironments(forceLoad) {
            var _this = this;

            if (forceLoad || !this._cachedEnvironmentsPromise) {
                this._cachedEnvironmentsPromise = (0, _environmentService.searchEnvironments)("").then(function (response) {
                    return response ? response.map(function (env) {
                        return {
                            id: _this.Ids.getName(env.id),
                            title: env.title
                        };
                    }) : [];
                }).catch(function (error) {
                    /* eslint-disable no-console, angular/log */
                    console.warn(error);
                });
            }
            return this._cachedEnvironmentsPromise;
        }
    }, {
        key: "getAllEnvironmentStages",
        value: function getAllEnvironmentStages(forceLoad) {
            var _this2 = this;

            if (forceLoad || !this._cachedEnvironmentStagesPromise) {
                this._cachedEnvironmentStagesPromise = (0, _stageService.searchStages)("").then(function (response) {
                    return response ? response.map(function (env) {
                        return {
                            id: _this2.Ids.getName(env.id),
                            title: env.title
                        };
                    }) : [];
                }).catch(function (error) {
                    /* eslint-disable no-console, angular/log */
                    console.warn(error);
                });
            }
            return this._cachedEnvironmentStagesPromise;
        }
    }, {
        key: "getAllEnvironmentLabels",
        value: function getAllEnvironmentLabels(forceLoad) {
            var _this3 = this;

            if (forceLoad || !this._cachedEnvironmentLabelsPromise) {
                this._cachedEnvironmentLabelsPromise = (0, _labelService.searchLabels)("").then(function (response) {
                    return response ? response.map(function (env) {
                        return {
                            id: _this3.Ids.getName(env.id),
                            title: env.title
                        };
                    }) : [];
                }).catch(function (error) {
                    /* eslint-disable no-console, angular/log */
                    console.warn(error);
                });
            }
            return this._cachedEnvironmentLabelsPromise;
        }
    }, {
        key: "getAllApplications",
        value: function getAllApplications(forceLoad) {
            var _this4 = this;

            if (forceLoad || !this._cachedApplicationsPromise) {
                this._cachedApplicationsPromise = (0, _applicationService.searchApp)("").then(function (response) {
                    return response ? response.map(function (env) {
                        return {
                            id: _this4.Ids.getName(env.id),
                            title: env.title
                        };
                    }) : [];
                }).catch(function (error) {
                    /* eslint-disable no-console, angular/log */
                    console.warn(error);
                });
            }
            return this._cachedApplicationsPromise;
        }
    }, {
        key: "clearCachedPromises",
        value: function clearCachedPromises() {
            this._cachedEnvironmentStagesPromise = null;
            this._cachedEnvironmentsPromise = null;
            this._cachedEnvironmentLabelsPromise = null;
            this._cachedApplicationsPromise = null;
        }
    }]);
    return DeploymentTileService;
}();

DeploymentTileService.$inject = ['Backend', 'Ids'];

/***/ }),

/***/ 3770:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3771);

__webpack_require__(3779);

__webpack_require__(3783);

__webpack_require__(3787);

__webpack_require__(3791);

/***/ }),

/***/ 3771:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _angular = __webpack_require__(131);

var _angular2 = _interopRequireDefault(_angular);

__webpack_require__(3772);

var _currentApplicationsTile = __webpack_require__(3774);

var _currentApplicationsDetails = __webpack_require__(3776);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_angular2.default.module('xlrelease').component('currentApplicationsTile', _currentApplicationsTile.currentApplicationsTile).component('currentApplicationsDetails', _currentApplicationsDetails.currentApplicationsDetailsComponent);

/***/ }),

/***/ 3772:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3774:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.currentApplicationsTile = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _currentApplicationsTile = __webpack_require__(3775);

var _currentApplicationsTile2 = _interopRequireDefault(_currentApplicationsTile);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CurrentApplicationsTileController = function () {
    function CurrentApplicationsTileController(ReportLoader, Report, ReportTileService, $uibModal, DeploymentTileService) {
        (0, _classCallCheck3.default)(this, CurrentApplicationsTileController);

        this.loader = new ReportLoader();
        this.report = new Report();
        this.ReportTileService = ReportTileService;
        this.$uibModal = $uibModal;
        this.DeploymentTileService = DeploymentTileService;
    }

    (0, _createClass3.default)(CurrentApplicationsTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this.report.add('data', this.loader);
            this.loadData(this.tile, this.loader);
        }
    }, {
        key: 'loadData',
        value: function loadData(tile, loader) {
            this.loader.startLoading();
            this.DeploymentTileService.fetchTileData(this.tile.id, {
                params: {
                    page: tile.sizeY !== null ? tile.sizeY * 3 : 3,
                    offset: 0
                }
            }).then(function (resp) {
                return loader.loaded(resp.data.data);
            }).then(loader.endLoading, loader.failLoading);
        }
    }, {
        key: 'showDetails',
        value: function showDetails() {
            var dateFilter = this.ReportTileService.getDateFilter(this.tile);
            this.$uibModal.open({
                component: 'currentApplicationsDetails',
                resolve: {
                    data: {
                        timeFrame: dateFilter.timeFrame,
                        dateFrom: dateFilter.from,
                        dateTo: dateFilter.to,
                        tile: this.tile
                    }
                },
                windowClass: 'deployment-dialog'
            });
        }
    }]);
    return CurrentApplicationsTileController;
}();

CurrentApplicationsTileController.$inject = ['ReportLoader', 'Report', 'ReportTileService', '$uibModal', 'DeploymentTileService'];
var currentApplicationsTile = exports.currentApplicationsTile = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: CurrentApplicationsTileController,
    template: _currentApplicationsTile2.default
};

/***/ }),

/***/ 3775:
/***/ (function(module, exports) {

module.exports = "<report-tile class=\"current-applications\" report=\"$ctrl.report\" tile=\"$ctrl.tile\" parent=\"$ctrl.parent\">\n    <report-content>\n        <div detect-fully-visible-items parent-selector=\".card-content\"\n             ng-if=\"$ctrl.report.data\">\n            <div class=\"row\" ng-repeat=\"application in $ctrl.report.data\">\n                <div class=\"current-applications-entry\">\n                    <div class=\"col-sm-6 text-left\">\n                        <i class=\"xl-icon app-icon\"></i>\n                        <span class=\"text-ellipsis\" title=\"{{::application.applicationName}}\">{{::application.applicationName}}</span>\n                    </div>\n                    <div class=\"col-sm-6\">\n                        <i class=\"xl-icon package-icon\"></i>\n                        <span class=\"text-ellipsis\" title=\"{{::application.version}}\">{{::application.version}}</span>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </report-content>\n    <report-footer>\n        <button class=\"show-deployment-activity btn-link\" ng-click=\"$ctrl.showDetails(params)\">Show all applications</button>\n    </report-footer>\n</report-tile>\n"

/***/ }),

/***/ 3776:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.currentApplicationsDetailsComponent = undefined;

var _defineProperty2 = __webpack_require__(18);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(3777);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-header">\n        <h5 class="modal-title pull-left current-applications-details-title">\n            Deployed applications in the <xlr-tile-date-range-label\n                    class="xlr-tile-date-range-label"\n                    time-frame="$ctrl.resolve.data.timeFrame"\n                    from="$ctrl.resolve.data.dateFrom"\n                    to="$ctrl.resolve.data.dateTo">\n            </xlr-tile-date-range-label>\n        </h5>\n        <button type="button" class="close pull-right" ng-click="$ctrl.close()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix" />\n    </div>\n    <div class="modal-body current-applications-details-body">\n        <div class="filters" data-ng-if="!$ctrl.isLoading">\n            <div class="filter-group">\n                <label for="">Environment</label>\n                <div xl-widget-autocomplete\n                     ng-model="$ctrl.selectedEnvironment"\n                     showAllOnClick="true"\n                     obj-label="title"\n                     handlers="$ctrl.environmentFilterHandler"\n                     select-mode="true"\n                     options="{placeholder: \'Environment\'}"\n                     show-all-on-click="true"\n                     open-on-click="true"\n                ></div>\n            </div>      \n        </div>\n        <div class="current-applications-details-data-wrapper">\n            <div class="current-applications-details-data" data-ng-if="!$ctrl.isLoading"\n                data-ng-repeat="(environmentName, value) in $ctrl.filterCurrentApplications($ctrl.currentApplications)">\n                <h5>\n                    <i class="xl-icon environment-icon" />\n                    <span>{{::environmentName}}</span>\n                </h5>\n                <table class="table table-curved">\n                    <thead>\n                        <tr>\n                            <th>Application</th>\n                            <th>Version</th>\n                            <th>Environment</th>\n                            <th>User</th>\n                            <th>Date</th>\n                        </tr>\n                    </thead>\n                    <tbody>\n                        <tr ng-repeat="deployment in value">\n                            <td>\n                                <i class="xl-icon application-icon"></i>\n                                <span class="mrm">{{::deployment.applicationName}}</span>\n                            </td>\n                            <td>\n                                <i class="xl-icon package-icon"></i>\n                                <span class="mrm">{{::deployment.version}}</span>\n                            </td>\n                            <td>\n                                <i class="xl-icon environment-icon" />\n                                <span class="mrm">{{::deployment.environmentName}}</span>\n                            </td>\n                            <td>\n                                <deployment-owner task-owner="deployment.taskOwner" task-team="deployment.taskTeam"></deployment-owner>\n                            </td>\n                            <td>{{::deployment.endDate | date: "medium"}}</td>                    \n                        </tr>\n                    </tbody>\n                </table>       \n            </div>\n        </div>\n        <div ng-show="$ctrl.isLoading" class="spinner text-center">\n            <img src="static/8.6.2/styles/img/big-ajax-loader.gif" alt="Loading..."/>\n        </div>  \n    </div>\n';

var CurrentApplicationsDetailsController = function () {
    function CurrentApplicationsDetailsController(DeploymentTileService, $q) {
        var _this = this;

        (0, _classCallCheck3.default)(this, CurrentApplicationsDetailsController);
        this.SELECT_ALL_OPTION = { title: 'All', searchFilter: '' };

        this.DeploymentTileService = DeploymentTileService;
        this.$q = $q;
        this.selectedEnvironment = undefined;
        this.environmentFilterHandler = {
            addCandidates: function addCandidates(metadata, options) {
                return _this.envAddCandidates(metadata, options);
            }
        };
    }

    (0, _createClass3.default)(CurrentApplicationsDetailsController, [{
        key: '$onInit',
        value: function $onInit() {
            this.selectedEnvironment = this.SELECT_ALL_OPTION;
            this.fetchData(this.MAX_VALUE, 0);
        }
    }, {
        key: 'fetchData',
        value: function fetchData(page, offset) {
            var _this2 = this;

            this.isLoading = true;
            this.DeploymentTileService.fetchTileData(this.resolve.data.tile.id).then(function (resp) {
                _this2.currentApplications = _.chain(resp.data.data).groupBy("environmentName").value();
            }).finally(function () {
                _this2.isLoading = false;
            });
        }
    }, {
        key: 'envAddCandidates',
        value: function envAddCandidates(metadata, options) {
            var environments = _.keys(this.currentApplications).map(function (title) {
                return { title: title, searchFilter: title };
            });
            return this.$q.resolve([this.SELECT_ALL_OPTION].concat(environments));
        }
    }, {
        key: 'filterCurrentApplications',
        value: function filterCurrentApplications(currentApplications) {
            if (angular.isUndefined(this.selectedEnvironment)) {
                this.selectedEnvironment = this.SELECT_ALL_OPTION;
            } else if (this.selectedEnvironment.title !== 'All') {
                return (0, _defineProperty3.default)({}, this.selectedEnvironment.searchFilter, currentApplications[this.selectedEnvironment.searchFilter]);
            }
            return currentApplications;
        }
    }]);
    return CurrentApplicationsDetailsController;
}();

CurrentApplicationsDetailsController.$inject = ['DeploymentTileService', '$q'];
var currentApplicationsDetailsComponent = exports.currentApplicationsDetailsComponent = {
    bindings: {
        resolve: '<',
        close: '&'
    },
    controller: CurrentApplicationsDetailsController,
    template: template
};

/***/ }),

/***/ 3777:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3779:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deploymentsActivityTile = __webpack_require__(3780);

angular.module('xlrelease').component('deploymentsActivityTile', _deploymentsActivityTile.deploymentsActivityTileComponent);

/***/ }),

/***/ 3780:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentsActivityTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(3781);

var _deploymentTileConstants = __webpack_require__(252);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <report-tile class="deployments-activity-tile" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n        <report-content>\n            <div detect-fully-visible-items parent-selector=".card-content"\n                 ng-if="$ctrl.deploymentsActivity">\n                <div class="row" ng-repeat="activity in $ctrl.deploymentsActivity">\n                    <div class="deployments-activity-entry">\n                        <div class="col-sm-6 col-md-7 text-left deployments-activity-left-column">\n                            <div>\n                                <deployment-owner task-owner="activity.taskOwner" task-team="activity.taskTeam"></deployment-owner>\n                            </div>\n                            <div>\n                                <i class="xl-icon app-icon"></i>\n                                <span class="text-ellipsis" title="{{activity.applicationName}}">\n                                    {{activity.applicationName}}\n                                </span>\n                            </div>\n                            <div>\n                                <i class="xl-icon package-icon"></i>\n                                <span class="text-ellipsis" title="{{activity.version}}">\n                                    {{activity.version}}\n                                </span>\n                            </div>\n                            <div>                            \n                                <i class="xl-icon environment-icon" /> \n                                <span class="text-ellipsis" title="{{activity.environmentName}}">{{activity.environmentName}}</span>\n                            </div>\n                        </div>\n                        <div class="col-sm-6 col-md-5 text-right deployments-activity-right-column">\n                            <deployment-state state-value="activity.state"></deployment-state>\n                            <deployment-date full-date="false" change-date="activity.changeDate" class="deployment-date"></deployment-date>\n                        </div>\n                    </div>\n                </div>\n            </div>                                    \n        </report-content>\n        <report-footer>\n            <button ng-if="$ctrl.hasData()" class="show-deployment-activity btn-link" ng-click="$ctrl.showDetails(params)">\n                Show all activity\n            </button>\n        </report-footer>\n    </report-tile>        \n';

var DEFAULT_PAGE_SIZE = 3;

var DeploymentsActivityTileController = function () {
    function DeploymentsActivityTileController(ReportLoader, Report, DeploymentTileService, ReportTileService, $uibModal) {
        (0, _classCallCheck3.default)(this, DeploymentsActivityTileController);

        this.DeploymentTileService = DeploymentTileService;
        this.ReportTileService = ReportTileService;
        this.$uibModal = $uibModal;

        this.loader = new ReportLoader();
        this.report = new Report().add('data', this.loader);
    }

    (0, _createClass3.default)(DeploymentsActivityTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            var filterByState = !this.tile.properties.deploymentStatus.value ? '' : this.tile.properties.deploymentStatus.value.toLowerCase();
            this.loader.startLoading();
            this.DeploymentTileService.fetchTileData(this.tile.id, {
                params: {
                    deploymentState: filterByState,
                    pageSize: this.tile.sizeY * DEFAULT_PAGE_SIZE,
                    offset: 0
                }
            }).then(function (resp) {
                _this.deploymentsActivity = resp.data.data;
                _this.loader.endLoading();
                _this.loader.loaded(!!_this.deploymentsActivity.length);
            });
        }
    }, {
        key: 'hasData',
        value: function hasData() {
            return this.report.isConfigured() && !this.report.loading() && !this.report.hasError() && !this.report.isEmpty();
        }
    }, {
        key: 'showDetails',
        value: function showDetails() {
            var dateFilter = this.ReportTileService.getDateFilter(this.tile);
            this.$uibModal.open({
                component: 'deploymentActivityDetails',
                resolve: {
                    data: {
                        timeFrame: dateFilter.timeFrame,
                        dateFrom: dateFilter.from,
                        dateTo: dateFilter.to,
                        tile: this.tile
                    }
                },
                windowClass: 'deployment-dialog'
            });
        }
    }]);
    return DeploymentsActivityTileController;
}();

DeploymentsActivityTileController.$inject = ['ReportLoader', 'Report', 'DeploymentTileService', 'ReportTileService', '$uibModal'];
var deploymentsActivityTileComponent = exports.deploymentsActivityTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: DeploymentsActivityTileController,
    template: template
};

/***/ }),

/***/ 3781:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3783:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deploymentsDistributionTile = __webpack_require__(3784);

angular.module('xlrelease').component('deploymentsDistributionTile', _deploymentsDistributionTile.deploymentsDistributionTileComponent);

/***/ }),

/***/ 3784:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentsDistributionTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _deploymentTileConstants = __webpack_require__(252);

var _colors = __webpack_require__(177);

var _colors2 = _interopRequireDefault(_colors);

__webpack_require__(3785);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <report-tile class=" deployments-distribution-tile" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n        <report-content>\n            <div class="deployments-distribution-delimiter"></div>\n            <echarts ng-if="$ctrl.echartsOptions"\n                     container=".xlr-tile"\n                     options="$ctrl.echartsOptions"\n                     ec-click="$ctrl.showDetails(params)">\n            </echarts>\n        </report-content>\n    </report-tile>\n';

var DeploymentsDistributionTileController = function () {
    function DeploymentsDistributionTileController(ReportLoader, Report, DeploymentTileService, $uibModal, ReportTileService) {
        (0, _classCallCheck3.default)(this, DeploymentsDistributionTileController);

        this.DeploymentTileService = DeploymentTileService;
        this.$uibModal = $uibModal;
        this.ReportTileService = ReportTileService;

        this.loader = new ReportLoader();
        this.report = new Report().add('data', this.loader);
    }

    (0, _createClass3.default)(DeploymentsDistributionTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loader.startLoading();
            this.DeploymentTileService.fetchTileData(this.tile.id).then(function (resp) {
                var data = resp.data.data;
                var hasData = !!data;
                _this.loader.endLoading();
                _this.loader.loaded(hasData);
                if (hasData) {
                    _this.initEchartsOptions(data);
                }
            });
        }
    }, {
        key: 'showDetails',
        value: function showDetails(params) {
            var dateFilter = this.ReportTileService.getDateFilter(this.tile);
            this.$uibModal.open({
                component: 'deploymentActivityDetails',
                resolve: {
                    data: {
                        selectedState: _.get(this.data[params.dataIndex], 'deploymentState'),
                        timeFrame: dateFilter.timeFrame,
                        dateFrom: dateFilter.from,
                        dateTo: dateFilter.to,
                        tile: this.tile
                    }
                },
                windowClass: 'deployment-dialog'
            });
        }
    }, {
        key: 'initEchartsOptions',
        value: function initEchartsOptions(data) {
            var titleItemGap = -40;
            var titleFontSize = 30;
            var legendBottom = 15;
            var seriesRadius = [70, 90];

            if (this.tile.sizeY < 2) {
                titleItemGap = -25;
                titleFontSize = 22;
                legendBottom = 0;
                seriesRadius = [45, '70%'];
            }

            var successful = data.successful || 0;
            var failed = data.failed || 0;
            this.data = [{
                name: 'Successful',
                icon: 'circle',
                textStyle: {
                    color: _colors2.default.gray,
                    fontSize: 11
                },
                deploymentState: _deploymentTileConstants.DEPLOYMENT_STATE.successful.value
            }, {
                name: 'Failed',
                icon: 'circle',
                textStyle: {
                    color: _colors2.default.gray,
                    fontSize: 11
                },
                deploymentState: _deploymentTileConstants.DEPLOYMENT_STATE.failed.value
            }];

            this.echartsOptions = {
                title: {
                    text: successful + '\n',
                    subtext: '' + failed,
                    x: 'center',
                    y: 'center',
                    itemGap: titleItemGap,
                    textStyle: {
                        color: _colors2.default.green,
                        fontSize: titleFontSize,
                        fontWeight: 600,
                        fontFamily: 'OpenSans'
                    },
                    subtextStyle: {
                        color: _colors2.default.red,
                        fontSize: titleFontSize,
                        fontWeight: 600,
                        fontFamily: 'OpenSans'
                    }
                },
                color: [_colors2.default.green, _colors2.default.red],
                legend: {
                    selectedMode: false,
                    left: 'center',
                    bottom: legendBottom,
                    itemWidth: 10,
                    data: this.data
                },
                label: {
                    normal: {
                        show: true
                    }
                },
                series: {
                    type: 'pie',
                    radius: seriesRadius,
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            show: false,
                            position: 'center'
                        },
                        emphasis: {
                            show: false,
                            textStyle: { fontSize: 16 }
                        }
                    },
                    labelLine: {
                        normal: {
                            show: false
                        }
                    },
                    data: [{
                        value: successful,
                        name: 'Successful'
                    }, {
                        value: failed,
                        name: 'Failed'
                    }]
                }
            };
        }
    }]);
    return DeploymentsDistributionTileController;
}();

DeploymentsDistributionTileController.$inject = ['ReportLoader', 'Report', 'DeploymentTileService', '$uibModal', 'ReportTileService'];
var deploymentsDistributionTileComponent = exports.deploymentsDistributionTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: DeploymentsDistributionTileController,
    template: template
};

/***/ }),

/***/ 3785:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3787:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _deploymentsSuccessRateTile = __webpack_require__(3788);

angular.module('xlrelease').component('deploymentsSuccessRateTile', _deploymentsSuccessRateTile.deploymentsSuccessRateComponent);

/***/ }),

/***/ 3788:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deploymentsSuccessRateComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(3789);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <report-tile class="deployments-success-rate-tile" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n        <report-content class="{{::$ctrl.getColorClass()}}">\n            {{::$ctrl.successRate}}%\n        </report-content>\n    </report-tile>\n';

var DeploymentsSuccessRateController = function () {
    function DeploymentsSuccessRateController(ReportLoader, Report, DeploymentTileService) {
        (0, _classCallCheck3.default)(this, DeploymentsSuccessRateController);

        this.DeploymentTileService = DeploymentTileService;

        this.loader = new ReportLoader();
        this.report = new Report().add('data', this.loader);
    }

    (0, _createClass3.default)(DeploymentsSuccessRateController, [{
        key: 'getColorClass',
        value: function getColorClass() {
            if (this.successRate > 90) {
                return 'high';
            }
            if (this.successRate >= 50) {
                return 'medium';
            }
            return 'low';
        }
    }, {
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loader.startLoading();
            this.DeploymentTileService.fetchTileData(this.tile.id, this.tile.properties).then(function (resp) {
                _this.successRate = resp.data.data;
                _this.loader.endLoading();
                _this.loader.loaded(!!_this.successRate || _this.successRate === 0);
            });
        }
    }]);
    return DeploymentsSuccessRateController;
}();

DeploymentsSuccessRateController.$inject = ['ReportLoader', 'Report', 'DeploymentTileService'];
var deploymentsSuccessRateComponent = exports.deploymentsSuccessRateComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: DeploymentsSuccessRateController,
    template: template
};

/***/ }),

/***/ 3789:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3791:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _totalDeploymentsTile = __webpack_require__(3792);

angular.module('xlrelease').component('totalDeploymentsTile', _totalDeploymentsTile.totalDeploymentsTileComponent);

/***/ }),

/***/ 3792:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.totalDeploymentsTileComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <report-tile class="total-deployments-tile" report="$ctrl.report" tile="$ctrl.tile" parent="$ctrl.parent">\n        <report-content>\n            {{$ctrl.totalDeployments}}\n        </report-content>\n    </report-tile>\n';

var TotalDeploymentsTileController = function () {
    function TotalDeploymentsTileController(ReportLoader, Report, DeploymentTileService) {
        (0, _classCallCheck3.default)(this, TotalDeploymentsTileController);

        this.DeploymentTileService = DeploymentTileService;

        this.loader = new ReportLoader();
        this.report = new Report().add('data', this.loader);
    }

    (0, _createClass3.default)(TotalDeploymentsTileController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.loader.startLoading();
            this.DeploymentTileService.fetchTileData(this.tile.id, this.tile.properties).then(function (resp) {
                _this.totalDeployments = resp.data.data;
                _this.loader.endLoading();
                _this.loader.loaded(!!_this.totalDeployments);
            });
        }
    }]);
    return TotalDeploymentsTileController;
}();

TotalDeploymentsTileController.$inject = ['ReportLoader', 'Report', 'DeploymentTileService'];
var totalDeploymentsTileComponent = exports.totalDeploymentsTileComponent = {
    bindings: {
        tile: '<',
        parent: '<'
    },
    controller: TotalDeploymentsTileController,
    template: template
};

/***/ }),

/***/ 3793:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _react2angular = __webpack_require__(317);

var _pluginManager = __webpack_require__(3794);

var _pluginManagerBrowse = __webpack_require__(3798);

var _pluginManagerController = __webpack_require__(3799);

var _pluginManagerController2 = _interopRequireDefault(_pluginManagerController);

__webpack_require__(3800);

var _plumbing = __webpack_require__(538);

var _xlPluginManager = __webpack_require__(364);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var axios = _xlPluginManager.axiosInstance;

axios.interceptors.request.use(function (req) {
    (0, _plumbing.showSpinner)();
    return req;
}, function (error) {
    return error;
});

axios.interceptors.response.use(function (resp) {
    (0, _plumbing.hideSpinner)();
    return resp;
}, function (err) {
    (0, _plumbing.hideSpinner)();
    (0, _plumbing.handleResponseError)(err);
    return _promise2.default.reject(err);
});

angular.module('xlrelease').controller('pluginManagerController', _pluginManagerController2.default).component('pluginManager', (0, _react2angular.react2angular)(_pluginManager.PluginManager)).component('pluginManagerBrowse', (0, _react2angular.react2angular)(_pluginManagerBrowse.PluginManagerBrowse));

/***/ }),

/***/ 3794:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.PluginManager = undefined;

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _store = __webpack_require__(1029);

var _xlPluginManager = __webpack_require__(364);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PluginManager = exports.PluginManager = function (_Component) {
    (0, _inherits3.default)(PluginManager, _Component);

    function PluginManager() {
        (0, _classCallCheck3.default)(this, PluginManager);
        return (0, _possibleConstructorReturn3.default)(this, (PluginManager.__proto__ || (0, _getPrototypeOf2.default)(PluginManager)).apply(this, arguments));
    }

    (0, _createClass3.default)(PluginManager, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(_reactRedux.Provider, { store: _store.store }, _react2.default.createElement(_xlPluginManager.Local, null));
        }
    }]);
    return PluginManager;
}(_react.Component);

/***/ }),

/***/ 3797:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toastr = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.pluginUploaded = pluginUploaded;
exports.pluginFailed = pluginFailed;
exports.pluginInstalled = pluginInstalled;
exports.notificationsSaga = notificationsSaga;

var _effects = __webpack_require__(80);

var _get = __webpack_require__(846);

var _get2 = _interopRequireDefault(_get);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _xlPluginManager = __webpack_require__(364);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(pluginUploaded),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(pluginFailed),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(pluginInstalled),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(notificationsSaga);

var toastr = exports.toastr = (0, _toastrFactory2.default)();

var RESTART_REQUIRED_MSG = 'You must restart XL Release to finish installing the plugin.';

function pluginUploaded(action) {
    var pluginName, successMassage, timeOut;
    return _regenerator2.default.wrap(function pluginUploaded$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    pluginName = (0, _get2.default)(action, 'payload.pluginId');

                    if (!pluginName) {
                        /* eslint-disable no-console, angular/log */
                        console.warn('Cannot extract plugin name');
                    }
                    successMassage = pluginName ? 'The plugin \'' + pluginName + '\' was successfully uploaded.' : 'Plugin was successfully uploaded.';
                    timeOut = 10000;
                    _context.next = 6;
                    return (0, _effects.call)(toastr.success, successMassage);

                case 6:
                    _context.next = 8;
                    return (0, _effects.call)(toastr.info, RESTART_REQUIRED_MSG, timeOut);

                case 8:
                case 'end':
                    return _context.stop();
            }
        }
    }, _marked, this);
}

function pluginFailed(action) {
    var failedMessage;
    return _regenerator2.default.wrap(function pluginFailed$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    failedMessage = action.payload.plugin + ' failed to install.';
                    _context2.next = 3;
                    return (0, _effects.call)(toastr.error, failedMessage);

                case 3:
                case 'end':
                    return _context2.stop();
            }
        }
    }, _marked2, this);
}

function pluginInstalled(action) {
    var timeOut, successMessage;
    return _regenerator2.default.wrap(function pluginInstalled$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    timeOut = 10000;
                    _context3.next = 3;
                    return (0, _effects.call)(toastr.info, RESTART_REQUIRED_MSG, timeOut);

                case 3:
                    successMessage = action.payload.plugin + ' was successfully installed.';
                    _context3.next = 6;
                    return (0, _effects.call)(toastr.success, successMessage);

                case 6:
                case 'end':
                    return _context3.stop();
            }
        }
    }, _marked3, this);
}

function notificationsSaga() {
    return _regenerator2.default.wrap(function notificationsSaga$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.next = 2;
                    return (0, _effects.fork)(_effects.takeLatest, _xlPluginManager.localPluginManagerActionTypes.UPLOAD_PLUGIN_LOCALLY_SUCCESS, pluginUploaded);

                case 2:
                    _context4.next = 4;
                    return (0, _effects.fork)(_effects.takeLatest, _xlPluginManager.remotePluginManagerActionTypes.INSTALL_REMOTE_PLUGIN_SUCCESS, pluginInstalled);

                case 4:
                    _context4.next = 6;
                    return (0, _effects.fork)(_effects.takeLatest, _xlPluginManager.remotePluginManagerActionTypes.INSTALL_REMOTE_PLUGIN_FAILURE, pluginFailed);

                case 6:
                case 'end':
                    return _context4.stop();
            }
        }
    }, _marked4, this);
}

/***/ }),

/***/ 3798:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.PluginManagerBrowse = undefined;

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactRedux = __webpack_require__(97);

var _store = __webpack_require__(1029);

var _xlPluginManager = __webpack_require__(364);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PluginManagerBrowse = exports.PluginManagerBrowse = function (_Component) {
    (0, _inherits3.default)(PluginManagerBrowse, _Component);

    function PluginManagerBrowse() {
        (0, _classCallCheck3.default)(this, PluginManagerBrowse);
        return (0, _possibleConstructorReturn3.default)(this, (PluginManagerBrowse.__proto__ || (0, _getPrototypeOf2.default)(PluginManagerBrowse)).apply(this, arguments));
    }

    (0, _createClass3.default)(PluginManagerBrowse, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(_reactRedux.Provider, { store: _store.store }, _react2.default.createElement(_xlPluginManager.Remote, null));
        }
    }]);
    return PluginManagerBrowse;
}(_react.Component);

/***/ }),

/***/ 3799:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var PluginManagerController = function () {
    function PluginManagerController($state, ServerConfigurationService) {
        (0, _classCallCheck3.default)(this, PluginManagerController);

        this.$state = $state;
        this._ServerConfigurationService = ServerConfigurationService;
    }

    (0, _createClass3.default)(PluginManagerController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this._ServerConfigurationService.isClusterModeStandalone().then(function (isStandalone) {
                if (!isStandalone) {
                    _this.$state.go('default');
                }
            });
        }
    }]);
    return PluginManagerController;
}();

PluginManagerController.$inject = ['$state', 'ServerConfigurationService'];
exports.default = PluginManagerController;

/***/ }),

/***/ 3800:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3802:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3803);

var _jenkinsBuildsTile = __webpack_require__(3805);

_jenkinsBuildsTile.JenkinsBuildsTileController.$inject = ['$scope', 'ReleasesService', 'ConfigurationInstances', 'XlrTileHelper'];
angular.module('xlrelease').controller('summary.JenkinsBuildsTileController', _jenkinsBuildsTile.JenkinsBuildsTileController);

/***/ }),

/***/ 3803:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3805:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var JenkinsBuildsTileController = exports.JenkinsBuildsTileController = function JenkinsBuildsTileController($scope, ReleasesService, ConfigurationInstances, XlrTileHelper) {
    var vm = this;
    if ($scope.xlrDashboard) {
        // summary page
        vm.release = $scope.xlrDashboard.release;
    } else {
        // details page
        vm.release = $scope.xlrTileDetailsCtrl.release;
    }

    loadJenkinsServers().then(function (jenkinsServers) {
        vm.allJenkinsBuilds = getAllJenkinsBuilds(vm.release, jenkinsServers);
        vm.counts = XlrTileHelper.countTasksByStatus(vm.allJenkinsBuilds);
        vm.totalCount = vm.allJenkinsBuilds.length;
        vm.gridOptions = getGridOptions(vm.allJenkinsBuilds);

        vm.chartOptions = XlrTileHelper.getChartOptions({
            label: 'Build',
            total: vm.totalCount
        });
    });

    ///

    function getAllJenkinsBuilds(release, jenkinsServers) {
        return _(ReleasesService.getLeafTasks(release)).filter({ scriptDefinitionType: "jenkins.Build" }).map(function (task) {
            return {
                taskName: task.title,
                taskStatus: task.status,
                taskStatusCategory: XlrTileHelper.getCategoryByTaskStatus(task.status),
                buildNumber: task.outputProperties['buildNumber'].value,
                buildStatus: task.outputProperties['buildStatus'].value,
                buildUrl: getBuildUrl(jenkinsServers, task.inputProperties.jenkinsServer, task.inputProperties.jobName, task.outputProperties['buildNumber'].value)
            };
        }).value();
    }

    function getGridOptions(jenkinsBuilds) {
        var columnDefs = [{
            displayName: "Task name",
            field: "taskName",
            cellTemplate: "static/8.6.2/include/JenkinsBuildsTile/grid/build-name-cell-template.html",
            filterHeaderTemplate: "<div data-ng-include=\"'static/8.6.2/include/JenkinsBuildsTile/grid/filter-template.html'\"></div>",
            enableColumnMenu: false,
            width: '40%'
        }, {
            displayName: "Build number",
            field: "buildNumber",
            cellTemplate: "static/8.6.2/include/JenkinsBuildsTile/grid/build-number-cell-template.html",
            filterHeaderTemplate: "<div data-ng-include=\"'static/8.6.2/include/JenkinsBuildsTile/grid/filter-template.html'\"></div>",
            enableColumnMenu: false,
            width: '20%'
        }, {
            displayName: "Build status",
            field: "taskStatusCategory",
            cellTemplate: "static/8.6.2/include/JenkinsBuildsTile/grid/build-status-cell-template.html",
            filterHeaderTemplate: "<div data-ng-include=\"'static/8.6.2/include/JenkinsBuildsTile/grid/filter-template.html'\"></div>",
            enableColumnMenu: false,
            width: '39%'
        }];

        return XlrTileHelper.getGridOptions(jenkinsBuilds, columnDefs);
    }

    function loadJenkinsServers() {
        $scope.$on('$destroy', function () {
            ConfigurationInstances.reset();
        });

        return ConfigurationInstances.load().then(function () {
            var servers = ConfigurationInstances.getInstancesByType('jenkins.Server');
            var serverIdToUrl = {};
            _.forEach(servers, function (server) {
                var id = server.id;
                var url = server.properties ? server.properties.url : server.url;
                if (url) {
                    serverIdToUrl[id] = url;
                }
            });
            return serverIdToUrl;
        });
    }

    function getBuildUrl(jenkinsServers, serverId, jobName, buildNumber) {
        if (!buildNumber) {
            return undefined;
        }
        var jenkinsUrl = jenkinsServers[serverId];
        if (jenkinsUrl && jobName) {
            var jobContext = '/job/' + encodeURI(jobName) + '/';
            return jenkinsUrl + jobContext + buildNumber;
        }
        return undefined;
    }
};

/***/ }),

/***/ 3806:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(3807);

__webpack_require__(3809);

/***/ }),

/***/ 3807:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3809:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var JiraQueryTileViewController = function () {
    function JiraQueryTileViewController($scope, JiraQueryService, XlrTileHelper) {
        (0, _classCallCheck3.default)(this, JiraQueryTileViewController);

        this._$scope = $scope;
        this._JiraQueryService = JiraQueryService;
        this._XlrTileHelper = XlrTileHelper;

        this.predefinedColors = {};
        this.predefinedColors.Open = '#7E827A';
        this.predefinedColors.Reopened = '#4AA0C8';
        this.predefinedColors['To Do'] = '#7E827A';
        this.predefinedColors['In Progress'] = '#7FB2F0';
        this.predefinedColors.Resolved = '#45BF55';
        this.predefinedColors.Done = '#45BF55';
        this.predefinedColors.Closed = '#468966';
        this.predefinedColors.Testing = '#FFA500';

        this.colorPool = ['#7E8AA2', '#35203B', '#644D52', '#8E2800', '#B85C5A', '#FF8598', '#FF6F69', '#F77A52', '#FCD364', '#FFE11A', '#FFA500'];

        if (this._$scope.xlrTile) {
            // summary mode
            this.tile = this._$scope.xlrTile.tile;
        } else {
            // details mode
            this.tile = this._$scope.xlrTileDetailsCtrl.tile;
        }

        var mapSeries = function mapSeries(data) {
            var series = {
                name: 'Status',
                data: []
            };
            series.data = _.map(data.data, function (value) {
                return { y: value.counter, name: value.status, color: value.color };
            });
            return [series];
        };

        this.chartOptions = {
            topTitleText: function topTitleText(data) {
                return data.total;
            },
            bottomTitleText: 'issues',
            series: mapSeries,
            showLegend: false,
            donutThickness: '60%'
        };

        this.load();
    }

    (0, _createClass3.default)(JiraQueryTileViewController, [{
        key: 'tileConfigurationIsPopulated',
        value: function tileConfigurationIsPopulated() {
            var config = this.tile.properties;
            return !_.isEmpty(config.jiraServer) && !_.isEmpty(config.query);
        }
    }, {
        key: 'getColor',
        value: function getColor(value) {
            if (this.predefinedColors[value]) return this.predefinedColors[value];
            return this.colorPool.pop();
        }
    }, {
        key: 'refresh',
        value: function refresh() {
            this.load({ params: { refresh: true } });
        }
    }, {
        key: 'createGridOptions',
        value: function createGridOptions(jiraData) {
            var filterHeaderTemplate = '<div data-ng-include="partials/releases/grid/templates/name-filter-template.html"></div>';
            var columnDefs = [{
                displayName: "Issue",
                field: "issue",
                cellTemplate: "static/8.6.2/include/JiraQueryTile/grid/issue-cell-template.html",
                filterHeaderTemplate: filterHeaderTemplate,
                enableColumnMenu: false,
                width: '25%'
            }, {
                displayName: "Summary",
                field: "summary",
                cellTemplate: "static/8.6.2/include/JiraQueryTile/grid/summary-cell-template.html",
                filterHeaderTemplate: filterHeaderTemplate,
                enableColumnMenu: false,
                width: '25%'
            }, {
                displayName: "Status",
                field: "status",
                cellTemplate: "static/8.6.2/include/JiraQueryTile/grid/status-cell-template.html",
                filterHeaderTemplate: filterHeaderTemplate,
                enableColumnMenu: false,
                width: '25%'
            }, {
                displayName: "Assigned",
                field: "assignee",
                cellTemplate: "static/8.6.2/include/JiraQueryTile/grid/assigned-cell-template.html",
                filterHeaderTemplate: filterHeaderTemplate,
                enableColumnMenu: false,
                width: '25%'
            }];

            return this._XlrTileHelper.getGridOptions(jiraData, columnDefs);
        }
    }, {
        key: 'mapResponseToUi',
        value: function mapResponseToUi(response) {
            var _this = this;

            var jiraIssueArray = [];
            var issues = response.data.data;
            this.statuses = [];
            this.statusesCounter = 0;
            this.issuesSummaryData = {
                data: null,
                total: 0
            };
            this.issuesSummaryData.data = _.reduce(issues, function (result, value) {
                var status = value.status;
                _this.issuesSummaryData.total += 1;
                if (result[status]) {
                    result[status].counter += 1;
                } else {
                    result[status] = {
                        counter: 1,
                        color: _this.getColor(status),
                        status: status
                    };
                }
                value.color = result[status].color;
                jiraIssueArray.push(value);
                return result;
            }, {});
            _.forEach(this.issuesSummaryData.data, function (value) {
                if (_this.statusesCounter < 5) _this.statuses.push(value);
                _this.statusesCounter++;
            });
            this.gridOptions = this.createGridOptions(jiraIssueArray);
        }
    }, {
        key: 'load',
        value: function load(config) {
            var _this2 = this;

            if (this.tileConfigurationIsPopulated()) {
                this.loading = true;
                this._JiraQueryService.executeQuery(this.tile.id, config).then(this.mapResponseToUi.bind(this)).finally(function () {
                    return _this2.loading = false;
                });
            }
        }
    }]);
    return JiraQueryTileViewController;
}();

JiraQueryTileViewController.$inject = ['$scope', 'xlrelease.jira.JiraQueryService', 'XlrTileHelper'];

var JiraQueryService = function JiraQueryService(Backend) {
    return { executeQuery: function executeQuery(tileId, config) {
            return Backend.get('tiles/' + tileId + '/data', config);
        } };
};
JiraQueryService.$inject = ['Backend'];

angular.module('xlrelease.jira.tile', []);
angular.module('xlrelease.jira.tile').service('xlrelease.jira.JiraQueryService', JiraQueryService);
angular.module('xlrelease.jira.tile').controller('jira.JiraQueryTileViewController', JiraQueryTileViewController);

/***/ }),

/***/ 398:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.showError = showError;
exports.showServerDownError = showServerDownError;
exports.default = AlertsFactory;

var _lodash = __webpack_require__(79);

var _lodash2 = _interopRequireDefault(_lodash);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getResponseData(response) {
    var contentType = getHeader(response, 'content-type');
    return contentType && contentType.indexOf('text/html') === -1 && response.data || '';
}

function getHeader(response, headerName) {
    var defaultVal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

    //we need this logic because we are still using different approaches to call a server
    if (_lodash2.default.isFunction(response.headers)) {
        //this is true for calls from $http
        return _lodash2.default.get(response.headers(), headerName, defaultVal);
    } else {
        return _lodash2.default.get(response.headers, headerName, defaultVal); //this is true for calls from axios
    }
}

function getAlertMsg(response) {
    var responseData = getResponseData(response);
    var path = getHeader(response, 'x-path', response.config.url);
    var date = getHeader(response, 'date');
    return ('\n        <div class=\'alert-details\'>\n            <p>' + responseData + '</p>\n            <p>Status code: ' + response.status + '</p>\n            <p><strong>' + response.config.method + ' ' + path + '</strong></p>\n            <p>' + date + '</p>\n        </div>').split('\n').join('');
}

var toaster = (0, _toastrFactory2.default)();

function showError(response) {
    toaster.error(getAlertMsg(response), 'An error occurred', { escapeHtml: false });
}

function showServerDownError() {
    toaster.error('The XL Release server is not available', 'An error occurred');
}

function AlertsFactory() {
    return {
        error: showError,
        serverDownError: showServerDownError
    };
}

/***/ }),

/***/ 417:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    ENVIRONMENTS_SEARCH_REQUEST: 'envMgmt/ENVIRONMENTS_SEARCH_REQUEST',
    ENVIRONMENTS_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENTS_SEARCH_SUCCESS',
    ENVIRONMENTS_SEARCH_FAILURE: 'envMgmt/ENVIRONMENTS_SEARCH_FAILURE',

    ENVIRONMENT_ADD: 'envMgmt/ENVIRONMENT_ADD',

    ENVIRONMENT_EDIT: 'envMgmt/ENVIRONMENT_EDIT',

    ENVIRONMENT_DELETE_REQUEST: 'envMgmt/ENVIRONMENT_DELETE_REQUEST',
    ENVIRONMENT_DELETE_SUCCESS: 'envMgmt/ENVIRONMENT_DELETE_SUCCESS',
    ENVIRONMENT_DELETE_FAILURE: 'envMgmt/ENVIRONMENT_DELETE_FAILURE',

    INIT_ENVIRONMENT_LIST: 'envMgmt/INIT_ENVIRONMENT_LIST',
    INIT_ENVIRONMENT_LIST_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_LIST_SUCCESS',
    INIT_ENVIRONMENT_LIST_FAILURE: 'envMgmt/INIT_ENVIRONMENT_LIST_FAILURE',

    TITLE_FILTER_CHANGE: 'envMgmt/TITLE_FILTER_CHANGE',
    STAGE_FILTER_CHANGE: 'envMgmt/STAGE_FILTER_CHANGE'
};

var onAddEnvironment = exports.onAddEnvironment = function onAddEnvironment() {
    return {
        type: actionTypes.ENVIRONMENT_ADD
    };
};

var onEditEnvironment = exports.onEditEnvironment = function onEditEnvironment(environment) {
    return {
        type: actionTypes.ENVIRONMENT_EDIT,
        payload: environment
    };
};

var searchEnvironments = exports.searchEnvironments = function searchEnvironments(_ref) {
    var title = _ref.title,
        stageTitle = _ref.stageTitle;
    return {
        type: actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
        payload: { title: title, stageTitle: stageTitle }
    };
};

var onDeleteEnvironment = exports.onDeleteEnvironment = function onDeleteEnvironment(environment) {
    return {
        type: actionTypes.ENVIRONMENT_DELETE_REQUEST,
        payload: environment
    };
};

var initEnvironmentList = exports.initEnvironmentList = function initEnvironmentList() {
    return {
        type: actionTypes.INIT_ENVIRONMENT_LIST
    };
};
var initEnvironmentListSuccess = exports.initEnvironmentListSuccess = function initEnvironmentListSuccess(environments, stages) {
    return {
        type: actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS,
        payload: {
            environments: environments,
            stages: stages
        }
    };
};

var titleFilterChange = exports.titleFilterChange = function titleFilterChange(title) {
    return {
        type: actionTypes.TITLE_FILTER_CHANGE,
        payload: title
    };
};
var stageFilterChange = exports.stageFilterChange = function stageFilterChange(stageTitle) {
    return {
        type: actionTypes.STAGE_FILTER_CHANGE,
        payload: stageTitle
    };
};

/***/ }),

/***/ 418:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    ENVIRONMENT_EDIT_SAVE_FORM: 'envMgmt/ENVIRONMENT_EDIT_SAVE_FORM',
    ENVIRONMENT_EDIT_CANCEL_FORM: 'envMgmt/ENVIRONMENT_EDIT_CANCEL_FORM',
    ENVIRONMENT_EDIT_CLEAN_FORM: 'envMgmt/ENVIRONMENT_EDIT_CLEAN_FORM',
    ENVIRONMENT_EDIT_VALID_FORM: 'envMgmt/ENVIRONMENT_EDIT_VALID_FORM',
    ENVIRONMENT_EDIT_PRISTINE_FORM: 'envMgmt/ENVIRONMENT_EDIT_PRISTINE_FORM',
    ENVIRONMENT_EDIT_CHANGE_FORM: 'envMgmt/ENVIRONMENT_EDIT_CHANGE_FORM',
    ENVIRONMENT_EDIT_CHECK_LEAVE: 'envMgmt/ENVIRONMENT_EDIT_CHECK_LEAVE',
    ENVIRONMENT_LOAD: 'envMgmt/ENVIRONMENT_LOAD',
    ENVIRONMENT_LOAD_SUCCESS: 'envMgmt/ENVIRONMENT_LOAD_SUCCESS',
    ENVIRONMENT_SEARCH: 'envMgmt/ENVIRONMENT_SEARCH',
    ENVIRONMENT_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENT_SEARCH_SUCCESS',
    INIT_ENVIRONMENT_FORM: 'envMgmt/INIT_ENVIRONMENT_FORM',
    INIT_ENVIRONMENT_FORM_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_FORM_SUCCESS',
    INIT_ENVIRONMENT_FORM_FAILURE: 'envMgmt/INIT_ENVIRONMENT_FORM_FAILURE'
};

var onFormChange = exports.onFormChange = function onFormChange(environment) {
    return {
        type: actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM,
        payload: environment
    };
};

var onFormSave = exports.onFormSave = function onFormSave(environment) {
    return {
        type: actionTypes.ENVIRONMENT_EDIT_SAVE_FORM,
        payload: environment
    };
};

var onFormCancel = exports.onFormCancel = function onFormCancel() {
    return {
        type: actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM
    };
};

var onFormValidChange = exports.onFormValidChange = function onFormValidChange(valid) {
    return {
        type: actionTypes.ENVIRONMENT_EDIT_VALID_FORM,
        payload: valid
    };
};

var onFormPristineChange = exports.onFormPristineChange = function onFormPristineChange(pristine) {
    return {
        type: actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM,
        payload: pristine
    };
};

var cleanEnvironment = exports.cleanEnvironment = function cleanEnvironment() {
    return {
        type: actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE
    };
};

var loadEnvironment = exports.loadEnvironment = function loadEnvironment(environmentId) {
    return {
        type: actionTypes.ENVIRONMENT_LOAD,
        payload: environmentId
    };
};

var searchEnvironments = exports.searchEnvironments = function searchEnvironments(title) {
    return {
        type: actionTypes.ENVIRONMENT_SEARCH,
        payload: title
    };
};

var initEnvironmentForm = exports.initEnvironmentForm = function initEnvironmentForm(environmentId) {
    return {
        type: actionTypes.INIT_ENVIRONMENT_FORM,
        payload: environmentId
    };
};

/***/ }),

/***/ 419:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    STAGE_SEARCH: 'envMgmt/STAGE_SEARCH',
    STAGE_SEARCH_SUCCESS: 'envMgmt/STAGE_SEARCH_SUCCESS',
    STAGE_SEARCH_FAILURE: 'envMgmt/STAGE_SEARCH_FAILURE',
    DELETE_STAGE: 'envMgmt/STAGE_DELETE_STAGE',
    DELETE_STAGE_SUCCESS: 'envMgmt/DELETE_STAGE_SUCCESS',
    DELETE_STAGE_FAILURE: 'envMgmt/DELETE_STAGE_FAILURE',
    SAVE_STAGE: 'envMgmt/STAGE_SAVE_STAGE',
    SAVE_STAGE_SUCCESS: 'envMgmt/SAVE_STAGE_SUCCESS',
    SAVE_STAGE_FAILURE: 'envMgmt/SAVE_STAGE_FAILURE'
};

var searchStages = exports.searchStages = function searchStages(title) {
    return {
        type: actionTypes.STAGE_SEARCH,
        payload: title
    };
};

var deleteStage = exports.deleteStage = function deleteStage(stage) {
    return {
        type: actionTypes.DELETE_STAGE,
        payload: stage
    };
};
var saveStage = exports.saveStage = function saveStage(stage) {
    return {
        type: actionTypes.SAVE_STAGE,
        payload: stage
    };
};

/***/ }),

/***/ 423:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deleteApp = exports.updateApp = exports.getApp = exports.createApp = exports.searchApp = undefined;

var _http = __webpack_require__(88);

var searchApp = exports.searchApp = function searchApp(title) {
    return (0, _http.httpPOST)('api/v1/applications/search', { title: title }).then(function (resp) {
        return resp.data;
    });
};

var createApp = exports.createApp = function createApp(application) {
    return (0, _http.httpPOST)('api/v1/applications', application).then(function (response) {
        return response.data;
    });
};

var getApp = exports.getApp = function getApp(applicationId) {
    return (0, _http.httpGET)('api/v1/applications/' + applicationId).then(function (response) {
        return response.data;
    });
};

var updateApp = exports.updateApp = function updateApp(application) {
    return (0, _http.httpPUT)('api/v1/applications/' + application.id, application);
};

var deleteApp = exports.deleteApp = function deleteApp(applicationId) {
    return (0, _http.httpDELETE)('api/v1/applications/' + applicationId);
};

/***/ }),

/***/ 424:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE',
    SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE',
    SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED',
    SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM',
    SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM',
    SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM',

    SCHEDULE_ENVIRONMENT_RESERVE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE',
    SCHEDULE_ENVIRONMENT_RESERVE_CANCEL: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_CANCEL',
    SCHEDULE_ENVIRONMENT_RESERVE_FAILURE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_FAILURE',
    SCHEDULE_ENVIRONMENT_DELETE_RESERVATION: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION',
    SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED',

    SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT',
    SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED'
};

var onReserveEnvironment = exports.onReserveEnvironment = function onReserveEnvironment(reservationModel) {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVE,
        payload: reservationModel
    };
};

var onReserveEnvironmentCancel = exports.onReserveEnvironmentCancel = function onReserveEnvironmentCancel() {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL
    };
};

var onDeleteEnvironmentReservation = exports.onDeleteEnvironmentReservation = function onDeleteEnvironmentReservation(reservationId) {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION,
        payload: reservationId
    };
};

var onReservationFormChange = exports.onReservationFormChange = function onReservationFormChange(reservationModel) {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
        payload: reservationModel
    };
};

var onReservationEnvironmentChange = exports.onReservationEnvironmentChange = function onReservationEnvironmentChange(reservationModel) {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE,
        payload: reservationModel
    };
};

var onReservationFormPristineChange = exports.onReservationFormPristineChange = function onReservationFormPristineChange(pristine) {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM,
        payload: pristine
    };
};

var onReservationFormValidChange = exports.onReservationFormValidChange = function onReservationFormValidChange(valid) {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM,
        payload: valid
    };
};

var initEnvironmentReservationForm = exports.initEnvironmentReservationForm = function initEnvironmentReservationForm(reservationId) {
    return {
        type: actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT,
        payload: reservationId
    };
};

/***/ }),

/***/ 431:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactSidebar = __webpack_require__(432);

var _reactSidebar2 = _interopRequireDefault(_reactSidebar);

var _classnames = __webpack_require__(2);

var _classnames2 = _interopRequireDefault(_classnames);

__webpack_require__(2674);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var menuItems = ['Environments', 'Stages', 'Labels'];
var menuItemsLinks = {
    Environments: '#/environments',
    Stages: '#/environments/stages',
    Labels: '#/environments/labels'
};

var styleSidebar = {
    root: {
        top: '50px'
    },
    content: {
        paddingLeft: '15px',
        paddingRight: '15px'
    },
    sidebar: {
        backgroundColor: '#fff',
        minWidth: '260px',
        boxShadow: '10px 0 10px -10px #f0f0f0'
    }
};

var EnvironmentSidebarComponent = function (_Component) {
    (0, _inherits3.default)(EnvironmentSidebarComponent, _Component);

    function EnvironmentSidebarComponent() {
        (0, _classCallCheck3.default)(this, EnvironmentSidebarComponent);
        return (0, _possibleConstructorReturn3.default)(this, (EnvironmentSidebarComponent.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentSidebarComponent)).apply(this, arguments));
    }

    (0, _createClass3.default)(EnvironmentSidebarComponent, [{
        key: 'renderItem',
        value: function renderItem(item) {
            var selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            var style = (0, _classnames2.default)('item', { selected: selected });
            return _react2.default.createElement(
                'a',
                { className: style, href: menuItemsLinks[item], key: item },
                item
            );
        }
    }, {
        key: 'renderMenu',
        value: function renderMenu() {
            var _this2 = this;

            var menuSelected = this.props.menuSelected;

            var items = menuItems.map(function (it) {
                return _this2.renderItem(it, menuSelected === it);
            });
            return _react2.default.createElement(
                'div',
                { className: 'environment-sidebar' },
                _react2.default.createElement(
                    'div',
                    { className: 'sidebar-title' },
                    'Setup'
                ),
                items
            );
        }
    }, {
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                _reactSidebar2.default,
                { docked: true, open: true, shadow: false, sidebar: this.renderMenu(), styles: styleSidebar, transitions: false },
                this.props.children
            );
        }
    }]);
    return EnvironmentSidebarComponent;
}(_react.Component);

EnvironmentSidebarComponent.propTypes = {
    children: _propTypes2.default.element.isRequired,
    menuSelected: _propTypes2.default.oneOf(menuItems).isRequired
};
exports.default = EnvironmentSidebarComponent;

/***/ }),

/***/ 433:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 434:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.WidgetAlertMessage = exports.alertType = undefined;

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var alertType = exports.alertType = {
    INFO: 'info',
    WARNING: 'warning'
};

var WidgetAlertMessage = exports.WidgetAlertMessage = function (_PureComponent) {
    (0, _inherits3.default)(WidgetAlertMessage, _PureComponent);

    function WidgetAlertMessage() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, WidgetAlertMessage);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = WidgetAlertMessage.__proto__ || (0, _getPrototypeOf2.default)(WidgetAlertMessage)).call.apply(_ref, [this].concat(args))), _this), _this.alertIconsClasses = {
            'info': 'info-icon',
            'warning': 'warning-icon'
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(WidgetAlertMessage, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                children = _props.children,
                alertType = _props.alertType;

            var alertClass = 'xlr-alert-' + alertType;
            var iconClass = 'xl-icon ' + this.alertIconsClasses[alertType] + ' icon-l';
            return _react2.default.createElement(
                'div',
                { className: alertClass },
                _react2.default.createElement(
                    'div',
                    { className: 'icon' },
                    _react2.default.createElement('i', { className: iconClass })
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'message' },
                    children
                )
            );
        }
    }]);
    return WidgetAlertMessage;
}(_react.PureComponent);

WidgetAlertMessage.propTypes = {
    alertType: _propTypes2.default.oneOf([alertType.INFO, alertType.WARNING]).isRequired,
    children: _propTypes2.default.element.isRequired
};

/***/ }),

/***/ 538:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

exports.showSpinner = showSpinner;
exports.hideSpinner = hideSpinner;
exports.handleResponseError = handleResponseError;

var _http = __webpack_require__(88);

var _alerts = __webpack_require__(398);

var _angularAccessor = __webpack_require__(181);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DELAY_BEFORE_AJAX_SPINNER = 1000;
var ajaxSpinnerTimers = [];

function showSpinner() {
    ajaxSpinnerTimers.push(setTimeout(function () {
        angular.element('#loading').show();
    }, DELAY_BEFORE_AJAX_SPINNER));
}

function hideSpinner() {
    clearTimeout(ajaxSpinnerTimers.pop());
    if (ajaxSpinnerTimers.length === 0) {
        angular.element('#loading').hide();
    }
}

function handleResponseError(error) {
    if (error.message === 'Network Error') {
        (0, _alerts.showServerDownError)();
    } else {
        var response = error.response;
        var $rootScope = (0, _angularAccessor2.default)('$rootScope'); //tmp solution
        var Events = (0, _angularAccessor2.default)('Events');
        var showErrorAlert = !response.config.hideAlert && response.status !== response.config.hideAlertOnCode;
        switch (response.status) {
            case _http.httpCodes.PAYMENT_REQUIRED:
                location.href = './productregistration';
                showErrorAlert = false;
                break;
            case _http.httpCodes.UNAUTHORIZED:
                $rootScope.$emit(Events.permission.unauthorized);
                showErrorAlert = false;
                break;
            case _http.httpCodes.FORBIDDEN:
                if (!response.config.dontRedirectWhenForbidden) {
                    var contentType = response.headers['content-type'];
                    // If content-type is HTML, response.data is html, so no readable message.
                    var errorMessage = contentType && contentType.match(/^text\/plain/) ? response.data : '';
                    $rootScope.$emit(Events.permission.forbidden, errorMessage);
                }
                showErrorAlert = false;
                break;
            case _http.httpCodes.VERSION_CHANGED:
                $rootScope.$apply(function () {
                    $rootScope.xlreleaseVersionChanged = true;
                    $rootScope.versionChangedMessage = response.data;
                });
                break;
        }

        if (showErrorAlert) {
            (0, _alerts.showError)(response);
        }
    }
}

(0, _http.registerRequestInterceptor)(function (request) {
    showSpinner();
    return request;
});

(0, _http.registerResponseInterceptors)(function (response) {
    hideSpinner();
    return response;
}, function (error) {
    hideSpinner();
    handleResponseError(error);
    return _promise2.default.reject(error);
});

/***/ }),

/***/ 579:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deleteLabel = exports.updateLabel = exports.getLabel = exports.searchLabels = exports.createLabel = undefined;

var _http = __webpack_require__(88);

var createLabel = exports.createLabel = function createLabel(envLabel) {
    return (0, _http.httpPOST)('api/v1/environments/labels', envLabel);
};

var searchLabels = exports.searchLabels = function searchLabels(title) {
    return (0, _http.httpPOST)('api/v1/environments/labels/search', { title: title }).then(function (response) {
        return response.data;
    });
};

var getLabel = exports.getLabel = function getLabel(envLabelId) {
    return (0, _http.httpGET)('api/v1/environments/labels/' + envLabelId).then(function (response) {
        return response.data;
    });
};

var updateLabel = exports.updateLabel = function updateLabel(envLabelId, envLabel) {
    return (0, _http.httpPUT)('api/v1/environments/labels/' + envLabelId, envLabel);
};

var deleteLabel = exports.deleteLabel = function deleteLabel(envLabelId) {
    return (0, _http.httpDELETE)('api/v1/environments/labels/' + envLabelId);
};

/***/ }),

/***/ 74:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

exports.default = ToastrFactory;

var _toastr = __webpack_require__(707);

var _toastr2 = _interopRequireDefault(_toastr);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ToastrFactory() {

    var _defaultOptions = {
        closeButton: true,
        debug: false,
        newestOnTop: false,
        progressBar: false,
        positionClass: "toast-top-right",
        preventDuplicates: false,
        onclick: null,
        showDuration: 300,
        hideDuration: 300,
        timeOut: 5000,
        extendedTimeOut: 1000,
        escapeHtml: true,
        showEasing: "swing",
        hideEasing: "linear",
        showMethod: "fadeIn",
        hideMethod: "fadeOut",
        closeMethod: "fadeOut",
        closeHtml: '<button><i class="xl-icon close-icon"/></button>'
    };

    function success(message, options) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions, options);
        _toastr2.default.success(message, 'Success');
    }

    function warning(message) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions);
        _toastr2.default.warning(message);
    }

    function error(message, title, options) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions, options);
        _toastr2.default.error(message, title);
    }

    function info(message, timeOut) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions, {
            timeOut: timeOut
        });

        _toastr2.default.info(message, 'Information', {
            iconClass: 'toast-info'
        });
    }

    function clearLastToast() {
        _toastr2.default.clear();
    }

    return {
        success: success,
        warning: warning,
        error: error,
        info: info,
        clearLastToast: clearLastToast
    };
}

/***/ }),

/***/ 825:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.tileOrDefaultUrl = tileOrDefaultUrl;
function tileOrDefaultUrl(uri, defaultUri) {
    return 'static/8.6.2/' + (_.isEmpty(uri) ? _.isUndefined(defaultUri) ? 'include/DashboardPage/partials/no-uri.html' : defaultUri : uri);
}

/***/ }),

/***/ 826:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var TIME_FRAME_TYPES = exports.TIME_FRAME_TYPES = {
    LAST_MONTH: 'LAST_MONTH',
    LAST_THREE_MONTHS: 'LAST_THREE_MONTHS',
    LAST_SIX_MONTHS: 'LAST_SIX_MONTHS',
    LAST_YEAR: 'LAST_YEAR',
    RANGE: 'RANGE'
};

var TIME_FRAME_LABELS = exports.TIME_FRAME_LABELS = {
    LAST_MONTH: 'Last 30 days',
    LAST_THREE_MONTHS: 'Last 3 months',
    LAST_SIX_MONTHS: 'Last 6 months',
    LAST_YEAR: 'Last year',
    RANGE: 'Range'
};

/***/ }),

/***/ 827:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var markdownImageRegex = exports.markdownImageRegex = /\n?!\[([^\n\]]*)\](?:\(([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})\))?/gi;

/***/ }),

/***/ 833:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.deleteReservation = exports.fetchReservation = exports.updateReservation = exports.createReservation = exports.searchReservations = undefined;

var _http = __webpack_require__(88);

var searchReservations = exports.searchReservations = function searchReservations(schedulerFilter) {
    return (0, _http.httpPOST)('api/v1/environments/reservations/search', schedulerFilter).then(function (response) {
        return response.data;
    });
};

var createReservation = exports.createReservation = function createReservation(reservation) {
    return (0, _http.httpPOST)('api/v1/environments/reservations', reservation);
};

var updateReservation = exports.updateReservation = function updateReservation(reservationId, reservation) {
    return (0, _http.httpPUT)('api/v1/environments/reservations/' + reservationId, reservation);
};

var fetchReservation = exports.fetchReservation = function fetchReservation(reservationId) {
    return (0, _http.httpGET)('api/v1/environments/reservations/' + reservationId).then(function (response) {
        return response.data;
    });
};

var deleteReservation = exports.deleteReservation = function deleteReservation(reservationId) {
    return (0, _http.httpDELETE)('api/v1/environments/reservations/' + reservationId);
};

/***/ }),

/***/ 849:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _lodash = __webpack_require__(79);

var _xlReactComponents = __webpack_require__(69);

var _reactColor = __webpack_require__(850);

var _validators = __webpack_require__(344);

__webpack_require__(433);

__webpack_require__(900);

var _widgetAlertMessage = __webpack_require__(434);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};
var createButton = {
    action: 'create',
    className: 'button primary',
    keyCodes: [13],
    label: 'Create'
};
var updateButton = {
    action: 'update',
    className: 'button primary',
    keyCodes: [13],
    label: 'Save'
};

var deleteButton = {
    action: 'delete',
    className: 'button secondary',
    label: 'Delete'
};

var deleteModalDeleteButton = {
    action: 'delete-modal-ok',
    className: 'button primary',
    keyCodes: [13],
    label: 'Delete'
};

var deleteModalCancelButton = {
    action: 'delete-modal-cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
};

var titleFieldMetadata = {
    label: 'Name',
    placeholder: 'Add...',
    description: 'Name of the label',
    required: true
};

var nameValidator = function nameValidator(envLabelList) {
    var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return function (name) {
        return {
            condition: (0, _validators.itemAlreadyDefined)(envLabelList, id, 'title', name),
            message: (0, _validators.createErrorMessage)('Label already exists')
        };
    };
};

var maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
    return function (inputText) {
        return {
            condition: (0, _validators.validateMaxLength)(inputText, maxLength),
            message: (0, _validators.createErrorMessage)(filedLabel + ' must be ' + maxLength + ' characters or less')
        };
    };
};

var defaultColorList = ['#0099cc', '#08b153', '#fd8d10', '#d94c3d', '#999999', '#991c71'];

var LabelModalFormComponent = function (_Component) {
    (0, _inherits3.default)(LabelModalFormComponent, _Component);
    (0, _createClass3.default)(LabelModalFormComponent, null, [{
        key: 'getDerivedStateFromProps',
        value: function getDerivedStateFromProps(props, state) {
            if (!state.labelModel || props.envLabelModel.title !== state.prevModel.title) {
                return (0, _extends3.default)({}, state, {
                    labelModel: props.envLabelModel,
                    prevModel: props.envLabelModel
                });
            }
            return null;
        }
    }]);

    function LabelModalFormComponent(props) {
        (0, _classCallCheck3.default)(this, LabelModalFormComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (LabelModalFormComponent.__proto__ || (0, _getPrototypeOf2.default)(LabelModalFormComponent)).call(this, props));

        _this.onRegister = function (componentApi) {
            componentApi.focus();
            _this.componentApi = componentApi;
        };

        _this.closeModal = function () {
            _this.cancelForm();
            _this.resetForm();
        };

        _this.onButtonClick = function (action) {
            var _this$props = _this.props,
                onModalConfirm = _this$props.onModalConfirm,
                onModalDelete = _this$props.onModalDelete;
            var _this$state = _this.state,
                createAnother = _this$state.createAnother,
                labelModel = _this$state.labelModel;


            switch (action) {
                case createButton.action:
                    onModalConfirm(labelModel, createAnother);
                    _this.resetForm();
                    break;
                case updateButton.action:
                    onModalConfirm(labelModel, createAnother);
                    _this.resetForm();
                    break;
                case deleteButton.action:
                    _this.setState({ isDeleteModal: true });
                    break;
                case deleteModalCancelButton.action:
                    _this.setState({ isDeleteModal: false });
                    break;
                case deleteModalDeleteButton.action:
                    _this.setState({ isDeleteModal: false });
                    if (onModalDelete) {
                        onModalDelete(labelModel);
                    }
                    break;
                default:
                    _this.cancelForm();
                    _this.resetForm();
            }
        };

        _this.cancelForm = function () {
            _this.setState({ createAnother: false });
            _this.props.onModalCancel();
        };

        _this.resetForm = function () {
            _this.colorIsChanged = null;
            _this.setState({ labelModel: null });
            if (_this.componentApi) {
                _this.componentApi.resetPristinity();
                _this.componentApi.focus();
            }
        };

        _this.onCheckboxClick = function (value) {
            _this.setState({ createAnother: value.target.checked });
        };

        _this.onModelChange = function (title) {
            var labelModel = _this.state.labelModel;


            if (title !== labelModel.title) {
                _this.setState({
                    labelModel: (0, _extends3.default)({}, labelModel, {
                        title: title
                    })
                });
            }
        };

        _this.handleValidityChange = function (valid) {
            _this.isValid = valid;
        };

        _this.handlePristinityChange = function (pristine) {
            _this.isPristine = pristine;
        };

        _this.onColorChangeComplete = function (color) {
            var labelModel = _this.state.labelModel;


            if (labelModel.color !== color.hex) {
                _this.colorIsChanged = true;
            }
            _this.setState({
                displayColorPicker: false,
                labelModel: (0, _extends3.default)({}, labelModel, {
                    color: color.hex
                })
            });
        };

        _this.openColorPicker = function () {
            _this.setState({ displayColorPicker: !_this.state.displayColorPicker });
        };

        _this.closeColorPicker = function () {
            _this.setState({ displayColorPicker: false });
        };

        _this.renderColorPickerPopover = function () {
            var displayColorPicker = _this.state.displayColorPicker;
            var color = _this.props.envLabelModel.color;


            return displayColorPicker ? _react2.default.createElement(
                'div',
                { className: 'color-picker-popover' },
                _react2.default.createElement('div', { className: 'cover', onClick: _this.closeColorPicker }),
                _react2.default.createElement(_reactColor.TwitterPicker, {
                    color: color,
                    colors: defaultColorList,
                    onChangeComplete: _this.onColorChangeComplete,
                    width: '204' })
            ) : null;
        };

        _this.state = {
            createAnother: false,
            displayColorPicker: false,
            isDeleteModal: false,
            labelModel: null,
            prevModel: null
        };

        _this.isPristine = null;
        _this.isValid = null;
        _this.colorIsChanged = null;

        _this.componentApi = null;
        return _this;
    }

    (0, _createClass3.default)(LabelModalFormComponent, [{
        key: 'renderDeleteModal',
        value: function renderDeleteModal() {
            var _props = this.props,
                envLabelModel = _props.envLabelModel,
                modalIsOpen = _props.modalIsOpen;

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: [deleteModalCancelButton, deleteModalDeleteButton],
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onButtonClick,
                    show: modalIsOpen,
                    title: 'Delete label' },
                _react2.default.createElement(
                    _widgetAlertMessage.WidgetAlertMessage,
                    { alertType: _widgetAlertMessage.alertType.WARNING },
                    _react2.default.createElement(
                        'p',
                        null,
                        'Deleting a label can lead to missing data for connected resources on reporting and environment scheduling.'
                    )
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    'You are about to delete label ',
                    _react2.default.createElement(
                        'strong',
                        null,
                        envLabelModel.title
                    ),
                    '.'
                )
            );
        }
    }, {
        key: 'renderEditModal',
        value: function renderEditModal() {
            var _props2 = this.props,
                modalIsOpen = _props2.modalIsOpen,
                envLabelList = _props2.envLabelList,
                envLabelModel = _props2.envLabelModel;
            var labelModel = this.state.labelModel;


            var confirmActionButtonDisabled = this.isPristine && !this.colorIsChanged || !this.isValid;

            var buttons = [cancelButton];
            var modalTitle = void 0,
                modalSkin = void 0;
            if ((0, _lodash.isNil)(envLabelModel.id)) {
                createButton.disabled = confirmActionButtonDisabled;
                buttons.push(createButton);
                modalTitle = 'New label';
                modalSkin = 'checkbox';
            } else {
                updateButton.disabled = confirmActionButtonDisabled;
                buttons.push(deleteButton);
                buttons.push(updateButton);
                modalTitle = 'Edit label';
                modalSkin = 'default';
            }
            if ((0, _lodash.isEmpty)(envLabelModel.color)) {
                envLabelModel.color = defaultColorList[0];
            }

            var modalHeader = _react2.default.createElement(
                _react2.default.Fragment,
                null,
                modalTitle,
                _react2.default.createElement(
                    'button',
                    { className: 'btn-close', onClick: this.closeModal, type: 'button' },
                    _react2.default.createElement('i', { className: 'xl-icon close-icon' })
                )
            );

            return _react2.default.createElement(
                _xlReactComponents.XlReactWidgetConfirmationDialog,
                {
                    buttons: buttons,
                    dialogClassName: 'xl-default-modal',
                    onButtonClick: this.onButtonClick,
                    onCheckboxClick: this.onCheckboxClick,
                    show: modalIsOpen,
                    skin: modalSkin,
                    title: modalHeader },
                _react2.default.createElement(
                    'div',
                    { className: 'environment-label-form' },
                    _react2.default.createElement(_xlReactComponents.XlReactWidgetString, {
                        metadata: titleFieldMetadata,
                        model: labelModel.title,
                        onModelChange: this.onModelChange,
                        onPristinityChange: this.handlePristinityChange,
                        onValidityChange: this.handleValidityChange,
                        register: this.onRegister,
                        validators: [nameValidator(envLabelList, labelModel.id), maxLengthValidator(titleFieldMetadata.label, 255)] }),
                    _react2.default.createElement(
                        'div',
                        { className: 'xl-react-components' },
                        _react2.default.createElement(
                            'div',
                            { className: 'xl-react-components-label' },
                            _react2.default.createElement(
                                'label',
                                null,
                                'Color',
                                _react2.default.createElement(
                                    'span',
                                    { className: 'required' },
                                    '*'
                                )
                            )
                        ),
                        _react2.default.createElement(
                            'div',
                            { className: 'xl-react-components-input' },
                            _react2.default.createElement(
                                'div',
                                { className: 'swatch', onClick: this.openColorPicker },
                                _react2.default.createElement('div', { className: 'color', style: { background: labelModel.color } })
                            ),
                            this.renderColorPickerPopover()
                        )
                    )
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var isDeleteModal = this.state.isDeleteModal;

            return isDeleteModal ? this.renderDeleteModal() : this.renderEditModal();
        }
    }]);
    return LabelModalFormComponent;
}(_react.Component);

LabelModalFormComponent.propTypes = {
    envLabelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    envLabelModel: _propTypes2.default.shape({
        color: _propTypes2.default.string,
        id: _propTypes2.default.string,
        title: _propTypes2.default.string
    }).isRequired,
    modalIsOpen: _propTypes2.default.bool.isRequired,
    onModalCancel: _propTypes2.default.func.isRequired,
    onModalConfirm: _propTypes2.default.func.isRequired,
    onModalDelete: _propTypes2.default.func
};
exports.default = LabelModalFormComponent;

/***/ }),

/***/ 88:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.httpCodes = exports.httpRequest = exports.directHttpRequest = exports.registerResponseInterceptors = exports.registerRequestInterceptor = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

exports.httpGET = httpGET;
exports.httpPOST = httpPOST;
exports.httpPUT = httpPUT;
exports.httpDELETE = httpDELETE;

var _axios = __webpack_require__(765);

var _axios2 = _interopRequireDefault(_axios);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var instance = _axios2.default.create();

var registerRequestInterceptor = exports.registerRequestInterceptor = function registerRequestInterceptor(requestInterceptor) {
    instance.interceptors.request.use(requestInterceptor, function (error) {
        return error;
    });
};
var registerResponseInterceptors = exports.registerResponseInterceptors = function registerResponseInterceptors(successInterceptor, errorInterceptor) {
    instance.interceptors.response.use(successInterceptor, errorInterceptor);
};

var directHttpRequest = exports.directHttpRequest = function directHttpRequest(method, url, config, headers) {
    var requestObject = (0, _extends3.default)({}, config, {
        headers: headers,
        method: method,
        url: url
    });
    return instance.request(requestObject);
};

var httpRequest = exports.httpRequest = function httpRequest(method, url, config) {
    var accept = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'application/json';
    return directHttpRequest(method, '' + url, config, {
        'Accept': accept,
        'Accept-Type': accept,
        'X-HTTP-Auth-Override': 'true'
    });
};

var httpCodes = exports.httpCodes = {
    UNAUTHORIZED: 401,
    PAYMENT_REQUIRED: 402,
    FORBIDDEN: 403,
    VERSION_CHANGED: 410
};

function httpGET(url) {
    return httpRequest('GET', url);
}

function httpPOST(url, data) {
    return httpRequest('POST', url, { data: data });
}

function httpPUT(url, data) {
    return httpRequest('PUT', url, { data: data });
}

function httpDELETE(url, data) {
    return httpRequest('DELETE', url, { data: data });
}

/***/ }),

/***/ 900:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 901:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initEnvLabelState = undefined;

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _clone = __webpack_require__(2928);

var _clone2 = _interopRequireDefault(_clone);

var _labelListHeaderComponent = __webpack_require__(2952);

var _labelListHeaderComponent2 = _interopRequireDefault(_labelListHeaderComponent);

var _labelItem = __webpack_require__(342);

var _labelItem2 = _interopRequireDefault(_labelItem);

var _sidebarEnvironmentNavigation = __webpack_require__(431);

var _sidebarEnvironmentNavigation2 = _interopRequireDefault(_sidebarEnvironmentNavigation);

var _labelModalFormComponent = __webpack_require__(849);

var _labelModalFormComponent2 = _interopRequireDefault(_labelModalFormComponent);

var _helpBlock = __webpack_require__(280);

var _noData = __webpack_require__(343);

__webpack_require__(281);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initEnvLabelState = exports.initEnvLabelState = function initEnvLabelState() {
    return {
        id: null,
        title: '',
        color: ''
    };
};

var helpMessage = 'Use Labels to identify your environments. You also use Labels to filter the environment scheduler and dashboards.';

var LabelListComponent = function (_Component) {
    (0, _inherits3.default)(LabelListComponent, _Component);

    function LabelListComponent(props) {
        (0, _classCallCheck3.default)(this, LabelListComponent);

        var _this = (0, _possibleConstructorReturn3.default)(this, (LabelListComponent.__proto__ || (0, _getPrototypeOf2.default)(LabelListComponent)).call(this, props));

        _this.onFilterChange = function (title) {
            _this.props.searchLabels(title);
        };

        _this.showCreateModal = function () {
            _this.setState({
                modalIsOpen: true,
                envLabel: initEnvLabelState()
            });
        };

        _this.showEditModal = function (envLabel) {
            _this.setState({
                modalIsOpen: true,
                envLabel: (0, _clone2.default)(envLabel)
            });
        };

        _this.onConfirmEditModal = function (envLabel, isCreateAnother) {
            _this.props.saveLabel(envLabel);

            var envLabelState = initEnvLabelState();
            if (isCreateAnother) {
                envLabelState.color = envLabel.color;
            }

            _this.setState({
                modalIsOpen: isCreateAnother,
                envLabel: envLabelState
            });
        };

        _this.onCancelEditModal = function () {
            _this.setState({
                modalIsOpen: false,
                envLabel: initEnvLabelState()
            });
        };

        _this.onConfirmDeleteModal = function (envLabel) {
            _this.props.deleteLabel(envLabel);
            _this.onCancelEditModal();
        };

        _this.renderEnvLabel = function (envLabel) {
            return _react2.default.createElement(_labelItem2.default, {
                envLabel: envLabel,
                isEditable: true,
                key: envLabel.id,
                onClickLabel: _this.showEditModal });
        };

        _this.renderLabels = function () {
            var labelList = _this.props.labelList;

            var labels = labelList.map(_this.renderEnvLabel);

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h4',
                    { className: 'page-title' },
                    'Labels (',
                    labels.length,
                    ')'
                ),
                _react2.default.createElement(
                    _helpBlock.HelpBlock,
                    { className: 'help-message-container' },
                    helpMessage
                ),
                labels.length ? labels : _react2.default.createElement(_noData.NoData, { className: 'no-labels-message', message: 'No labels found.' })
            );
        };

        _this.state = {
            modalIsOpen: false,
            envLabel: initEnvLabelState()
        };
        return _this;
    }

    (0, _createClass3.default)(LabelListComponent, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.props.searchLabels();
        }
    }, {
        key: 'render',
        value: function render() {
            var labelList = this.props.labelList;
            var _state = this.state,
                modalIsOpen = _state.modalIsOpen,
                envLabel = _state.envLabel;


            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(_labelListHeaderComponent2.default, {
                    onCreate: this.showCreateModal,
                    onFilterChange: this.onFilterChange }),
                _react2.default.createElement(
                    _sidebarEnvironmentNavigation2.default,
                    { menuSelected: 'Labels' },
                    this.renderLabels()
                ),
                _react2.default.createElement(_labelModalFormComponent2.default, {
                    envLabelList: labelList,
                    envLabelModel: envLabel,
                    modalIsOpen: modalIsOpen,
                    onModalCancel: this.onCancelEditModal,
                    onModalConfirm: this.onConfirmEditModal,
                    onModalDelete: this.onConfirmDeleteModal
                })
            );
        }
    }]);
    return LabelListComponent;
}(_react.Component);

LabelListComponent.propTypes = {
    deleteLabel: _propTypes2.default.func.isRequired,
    labelList: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        color: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired
    }).isRequired).isRequired,
    saveLabel: _propTypes2.default.func.isRequired,
    searchLabels: _propTypes2.default.func.isRequired
};
exports.default = LabelListComponent;

/***/ }),

/***/ 907:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getPrototypeOf = __webpack_require__(35);

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = __webpack_require__(9);

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = __webpack_require__(10);

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(37);

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = __webpack_require__(2);

var _classnames2 = _interopRequireDefault(_classnames);

var _antd = __webpack_require__(1030);

var _index = __webpack_require__(102);

var _labelListTruncated = __webpack_require__(3403);

var _labelListTruncated2 = _interopRequireDefault(_labelListTruncated);

__webpack_require__(3408);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var EnvironmentSideBarItem = function (_Component) {
    (0, _inherits3.default)(EnvironmentSideBarItem, _Component);

    function EnvironmentSideBarItem() {
        var _ref;

        var _temp, _this, _ret;

        (0, _classCallCheck3.default)(this, EnvironmentSideBarItem);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = (0, _possibleConstructorReturn3.default)(this, (_ref = EnvironmentSideBarItem.__proto__ || (0, _getPrototypeOf2.default)(EnvironmentSideBarItem)).call.apply(_ref, [this].concat(args))), _this), _this.onClick = function (environment) {
            var onClick = _this.props.onClick;

            if (onClick) {
                onClick(environment);
            }
        }, _this.renderEnvironmentDescriptionPopup = function (description) {
            return _react2.default.createElement(
                'div',
                { className: 'description-content' },
                description
            );
        }, _this.renderEnvironmentDescriptionPopover = function (environment) {
            return _react2.default.createElement(
                _antd.Popover,
                { arrowPointAtCenter: true,
                    content: _this.renderEnvironmentDescriptionPopup(environment.description),
                    overlayClassName: 'description-popup',
                    placement: 'bottomRight',
                    trigger: 'hover' },
                _react2.default.createElement('i', { className: 'icon-info xl-icon info-icon' })
            );
        }, _temp), (0, _possibleConstructorReturn3.default)(_this, _ret);
    }

    (0, _createClass3.default)(EnvironmentSideBarItem, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props,
                environment = _props.environment,
                isClickable = _props.isClickable;

            var containerClass = (0, _classnames2.default)('environment-item-container', { 'clickable': isClickable });

            return _react2.default.createElement(
                'div',
                { className: containerClass, onClick: function onClick() {
                        return _this2.onClick(environment);
                    } },
                _react2.default.createElement(
                    'div',
                    { className: 'environment-item-title-container' },
                    _react2.default.createElement(
                        'div',
                        { className: 'title', title: environment.title },
                        _react2.default.createElement('i', { className: 'xl-icon environment-icon' }),
                        environment.title
                    ),
                    environment.description && this.renderEnvironmentDescriptionPopover(environment)
                ),
                _react2.default.createElement(
                    'div',
                    null,
                    environment.labels && !!environment.labels.length && _react2.default.createElement(_labelListTruncated2.default, { labels: environment.labels })
                )
            );
        }
    }]);
    return EnvironmentSideBarItem;
}(_react.Component);

EnvironmentSideBarItem.propTypes = {
    environment: _index.Environment.isRequired,
    isClickable: _propTypes2.default.bool,
    onClick: _propTypes2.default.func
};
EnvironmentSideBarItem.defaultProps = {
    isClickable: false,
    environments: []
};
exports.default = EnvironmentSideBarItem;

/***/ })

},[[2481,1,0]]]);