(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[3],Array(74).concat([
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

exports.default = ToastrFactory;

var _toastr = __webpack_require__(707);

var _toastr2 = _interopRequireDefault(_toastr);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ToastrFactory() {

    var _defaultOptions = {
        closeButton: true,
        debug: false,
        newestOnTop: false,
        progressBar: false,
        positionClass: "toast-top-right",
        preventDuplicates: false,
        onclick: null,
        showDuration: 300,
        hideDuration: 300,
        timeOut: 5000,
        extendedTimeOut: 1000,
        escapeHtml: true,
        showEasing: "swing",
        hideEasing: "linear",
        showMethod: "fadeIn",
        hideMethod: "fadeOut",
        closeMethod: "fadeOut",
        closeHtml: '<button><i class="xl-icon close-icon"/></button>'
    };

    function success(message, options) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions, options);
        _toastr2.default.success(message, 'Success');
    }

    function warning(message) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions);
        _toastr2.default.warning(message);
    }

    function error(message, title, options) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions, options);
        _toastr2.default.error(message, title);
    }

    function info(message, timeOut) {
        _toastr2.default.options = (0, _extends3.default)({}, _defaultOptions, {
            timeOut: timeOut
        });

        _toastr2.default.info(message, 'Information', {
            iconClass: 'toast-info'
        });
    }

    function clearLastToast() {
        _toastr2.default.clear();
    }

    return {
        success: success,
        warning: warning,
        error: error,
        info: info,
        clearLastToast: clearLastToast
    };
}

/***/ }),
/* 75 */,
/* 76 */,
/* 77 */,
/* 78 */,
/* 79 */,
/* 80 */,
/* 81 */,
/* 82 */,
/* 83 */,
/* 84 */,
/* 85 */,
/* 86 */,
/* 87 */,
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.httpCodes = exports.httpRequest = exports.directHttpRequest = exports.registerResponseInterceptors = exports.registerRequestInterceptor = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

exports.httpGET = httpGET;
exports.httpPOST = httpPOST;
exports.httpPUT = httpPUT;
exports.httpDELETE = httpDELETE;

var _axios = __webpack_require__(765);

var _axios2 = _interopRequireDefault(_axios);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var instance = _axios2.default.create();

var registerRequestInterceptor = exports.registerRequestInterceptor = function registerRequestInterceptor(requestInterceptor) {
    instance.interceptors.request.use(requestInterceptor, function (error) {
        return error;
    });
};
var registerResponseInterceptors = exports.registerResponseInterceptors = function registerResponseInterceptors(successInterceptor, errorInterceptor) {
    instance.interceptors.response.use(successInterceptor, errorInterceptor);
};

var directHttpRequest = exports.directHttpRequest = function directHttpRequest(method, url, config, headers) {
    var requestObject = (0, _extends3.default)({}, config, {
        headers: headers,
        method: method,
        url: url
    });
    return instance.request(requestObject);
};

var httpRequest = exports.httpRequest = function httpRequest(method, url, config) {
    var accept = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'application/json';
    return directHttpRequest(method, '' + url, config, {
        'Accept': accept,
        'Accept-Type': accept,
        'X-HTTP-Auth-Override': 'true'
    });
};

var httpCodes = exports.httpCodes = {
    UNAUTHORIZED: 401,
    PAYMENT_REQUIRED: 402,
    FORBIDDEN: 403,
    VERSION_CHANGED: 410
};

function httpGET(url) {
    return httpRequest('GET', url);
}

function httpPOST(url, data) {
    return httpRequest('POST', url, { data: data });
}

function httpPUT(url, data) {
    return httpRequest('PUT', url, { data: data });
}

function httpDELETE(url, data) {
    return httpRequest('DELETE', url, { data: data });
}

/***/ }),
/* 89 */,
/* 90 */,
/* 91 */,
/* 92 */,
/* 93 */,
/* 94 */,
/* 95 */,
/* 96 */,
/* 97 */,
/* 98 */,
/* 99 */,
/* 100 */,
/* 101 */,
/* 102 */,
/* 103 */,
/* 104 */,
/* 105 */,
/* 106 */,
/* 107 */,
/* 108 */,
/* 109 */,
/* 110 */,
/* 111 */,
/* 112 */,
/* 113 */,
/* 114 */,
/* 115 */,
/* 116 */,
/* 117 */,
/* 118 */,
/* 119 */,
/* 120 */,
/* 121 */,
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = IdsFactory;
function IdsFactory() {

    var SEPARATOR = '/';

    var releaseRegex = /.*Release[^\/-]*/;

    var phaseRegex = /Phase[^\/-]*/;

    var taskRegex = /Task[^\/-].*/;

    var phaseTaskRegex = /Phase.*Task[^\/-].*/;

    var folderIdRegex = /(^|\/|\-)Folder.+?(?=(?:\/|\-|$))/gm;

    var releaseIdToFolderId = function releaseIdToFolderId(viewId) {
        if (angular.isDefined(viewId)) {
            return 'Applications/' + viewId.split("-").slice(0, -1).join(SEPARATOR);
        } else {
            return null;
        }
    };

    var toFullId = function toFullId(viewId) {
        return viewId.replace(/-/g, SEPARATOR);
    };
    var toDomainId = function toDomainId(viewId) {
        return 'Applications/' + toFullId(viewId);
    };
    var noApplications = function noApplications(id) {
        return id.replace(/^Applications\//, '');
    };
    var toInternalId = function toInternalId(viewId) {
        return noApplications(viewId).replace(/\//g, '-');
    };
    var toConfigurationId = function toConfigurationId(viewId) {
        return 'Configuration/Custom/' + toFullId(viewId);
    };
    var releaseIdFrom = function releaseIdFrom(viewId) {
        return viewId.match(releaseRegex)[0];
    };
    var phaseIdFrom = function phaseIdFrom(viewId) {
        var regexMatch = viewId.match(phaseRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var taskIdFrom = function taskIdFrom(viewId) {
        var regexMatch = viewId.match(taskRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var phaseTaskIdFrom = function phaseTaskIdFrom(viewId) {
        var regexMatch = viewId.match(phaseTaskRegex);
        return regexMatch !== null ? regexMatch[0] : null;
    };
    var isRootGeneral = function isRootGeneral(id, separator) {
        return id.indexOf(separator) === -1;
    };
    var isRoot = function isRoot(id) {
        return isRootGeneral(id, SEPARATOR);
    };
    var getParentIdGeneral = function getParentIdGeneral(id, separator) {
        if (isRootGeneral(id, separator)) return null;
        return id.substring(0, id.lastIndexOf(separator));
    };
    var getParentId = function getParentId(id) {
        return getParentIdGeneral(id, SEPARATOR);
    };
    var getName = function getName(id) {
        return isRoot(id) ? id : id.substring(id.lastIndexOf(SEPARATOR) + 1);
    };
    var getNameByExternalId = function getNameByExternalId(id) {
        return getName(toFullId(id));
    };
    var getParentFolderIdFrom = function getParentFolderIdFrom(viewId) {
        return !isInFolder(viewId) ? null : getParentId(releaseIdFrom(toDomainId(viewId)));
    };
    var isInFolder = function isInFolder(id) {
        return id.indexOf('Folder') !== -1;
    };
    var folderDepth = function folderDepth(id) {
        return noApplications(id).split('/').length - 1;
    };
    var getInternalFolderId = function getInternalFolderId(id) {
        var regexMatch = (id || '').match(folderIdRegex);
        if (regexMatch !== null) {
            return regexMatch.map(function (id) {
                return _.trim(id, '-/');
            }).join('-');
        }
        return null;
    };
    return {
        releaseIdToFolderId: releaseIdToFolderId,
        toDomainId: toDomainId,
        toInternalId: toInternalId,
        toConfigurationId: toConfigurationId,
        releaseIdFrom: releaseIdFrom,
        phaseIdFrom: phaseIdFrom,
        taskIdFrom: taskIdFrom,
        phaseTaskIdFrom: phaseTaskIdFrom,
        getParentId: getParentId,
        getParentIdGeneral: getParentIdGeneral,
        getName: getName,
        isRoot: isRoot,
        getParentFolderIdFrom: getParentFolderIdFrom,
        isInFolder: isInFolder,
        getNameByExternalId: getNameByExternalId,
        noApplications: noApplications,
        folderDepth: folderDepth,
        getInternalFolderId: getInternalFolderId
    };
}

/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ACTION_TYPES = exports.ACTION_TYPES = {
    SELECT_ITEMS: 'RELEASE_GRID_SELECT_ITEMS',
    SET_ALLOWED_ACTIONS: 'RELEASE_GRID_SET_ALLOWED_ACTIONS',
    UN_SELECT_ALL: 'RELEASE_GRID_UNSELECT_ALL',
    SHOW_ASSIGN_TO: 'RELEASE_GRID_ASSIGN_TO',
    SHOW_REMOVE: 'RELEASE_GRID_REMOVE',
    SHOW_COMPLETE: 'RELEASE_GRID_COMPLETE',
    SHOW_ADD_COMMENT: 'RELEASE_GRID_ADD_COMMENT',
    SHOW_SKIP: 'RELEASE_GRID_SKIP',
    SHOW_FAIL: 'RELEASE_GRID_FAIL',
    SHOW_RETRY: 'RELEASE_GRID_RETRY',
    SHOW_ABORT: 'RELEASE_GRID_ABORT',
    SHOW_REOPEN: 'RELEASE_GRID_REOPEN',
    LOAD_USERS_AND_TEAMS: 'RELEASE_GRID_SELECT_ACTION',
    DO_ASSIGN_TO_ACTION: 'RELEASE_GRID_EXECUTE_ASSIGN_TO_ACTION',
    DO_REMOVE_ACTION: 'RELEASE_GRID_EXECUTE_REMOVE_ACTION',
    DO_COMMENT_ACTION: 'RELEASE_GRID_EXECUTE_COMMENT_ACTION',
    DO_COMPLETE_ACTION: 'RELEASE_GRID_EXECUTE_COMPLETE_ACTION',
    DO_SKIP_ACTION: 'RELEASE_GRID_EXECUTE_SKIP_ACTION',
    DO_FAIL_ACTION: 'RELEASE_GRID_EXECUTE_FAIL_ACTION',
    DO_RETRY_ACTION: 'RELEASE_GRID_EXECUTE_RETRY_ACTION',
    DO_ABORT_ACTION: 'RELEASE_GRID_EXECUTE_ABORT_ACTION',
    DO_REOPEN_ACTION: 'RELEASE_GRID_EXECUTE_REOPEN_ACTION',
    SAVE_SELECTION_STATE: 'RELEASE_GRID_SAVE_SELECTION_STATE',
    UPDATE_INDEX: 'UPDATE_INDEX',
    UPDATE_CHECKBOXES: 'UPDATE_CHECKBOXES',
    UPDATE_CURRENT_RELEASE: 'UPDATE_CURRENT_RELEASE'
};

var selectItems = exports.selectItems = function selectItems(items, release, taskService, refreshCallback) {
    return { type: ACTION_TYPES.SELECT_ITEMS, payload: { items: items, release: release, taskService: taskService, refreshCallback: refreshCallback } };
};
var setAllowedActions = exports.setAllowedActions = function setAllowedActions(allowedActions) {
    return { type: ACTION_TYPES.SET_ALLOWED_ACTIONS, payload: allowedActions };
};
var unSelectAll = exports.unSelectAll = function unSelectAll() {
    return { type: ACTION_TYPES.UN_SELECT_ALL };
};

var showModalAction = function showModalAction(type) {
    return function (uibModalService) {
        return { type: type, uibModalService: uibModalService };
    };
};
var doActionWithComment = function doActionWithComment(type) {
    return function (comment) {
        return { type: type, payload: comment };
    };
};

var assignTo = exports.assignTo = showModalAction(ACTION_TYPES.SHOW_ASSIGN_TO);
var remove = exports.remove = showModalAction(ACTION_TYPES.SHOW_REMOVE);
var addComment = exports.addComment = showModalAction(ACTION_TYPES.SHOW_ADD_COMMENT);
var complete = exports.complete = showModalAction(ACTION_TYPES.SHOW_COMPLETE);
var skip = exports.skip = showModalAction(ACTION_TYPES.SHOW_SKIP);
var fail = exports.fail = showModalAction(ACTION_TYPES.SHOW_FAIL);
var retry = exports.retry = showModalAction(ACTION_TYPES.SHOW_RETRY);
var abort = exports.abort = showModalAction(ACTION_TYPES.SHOW_ABORT);
var reopen = exports.reopen = showModalAction(ACTION_TYPES.SHOW_REOPEN);

var loadUsersAndTeams = exports.loadUsersAndTeams = function loadUsersAndTeams(action) {
    return { type: ACTION_TYPES.LOAD_USERS_AND_TEAMS, payload: action };
};

var doAssignToAction = exports.doAssignToAction = function doAssignToAction(selectedOwner, selectedTeam) {
    return {
        type: ACTION_TYPES.DO_ASSIGN_TO_ACTION, payload: {
            selectedOwner: selectedOwner,
            selectedTeam: selectedTeam
        }
    };
};

var doRemoveAction = exports.doRemoveAction = function doRemoveAction() {
    return { type: ACTION_TYPES.DO_REMOVE_ACTION };
};
var doCommentAction = exports.doCommentAction = doActionWithComment(ACTION_TYPES.DO_COMMENT_ACTION);
var doCompleteAction = exports.doCompleteAction = doActionWithComment(ACTION_TYPES.DO_COMPLETE_ACTION);
var doSkipAction = exports.doSkipAction = doActionWithComment(ACTION_TYPES.DO_SKIP_ACTION);
var doFailAction = exports.doFailAction = doActionWithComment(ACTION_TYPES.DO_FAIL_ACTION);
var doRetryAction = exports.doRetryAction = doActionWithComment(ACTION_TYPES.DO_RETRY_ACTION);
var doAbortAction = exports.doAbortAction = doActionWithComment(ACTION_TYPES.DO_ABORT_ACTION);
var doReopenAction = exports.doReopenAction = doActionWithComment(ACTION_TYPES.DO_REOPEN_ACTION);

var saveSelectionState = exports.saveSelectionState = function saveSelectionState(state) {
    return { type: ACTION_TYPES.SAVE_SELECTION_STATE, payload: state };
};

var updateSelectedIndex = exports.updateSelectedIndex = function updateSelectedIndex(index) {
    return { type: ACTION_TYPES.UPDATE_INDEX, payload: index };
};
var updateCheckboxesState = exports.updateCheckboxesState = function updateCheckboxesState(checkboxesState) {
    return { type: ACTION_TYPES.UPDATE_CHECKBOXES, payload: checkboxesState };
};
var updateCurrentRelease = exports.updateCurrentRelease = function updateCurrentRelease(release) {
    return { type: ACTION_TYPES.UPDATE_CURRENT_RELEASE, payload: release };
};

/***/ }),
/* 124 */,
/* 125 */,
/* 126 */,
/* 127 */,
/* 128 */,
/* 129 */,
/* 130 */,
/* 131 */,
/* 132 */,
/* 133 */,
/* 134 */,
/* 135 */,
/* 136 */,
/* 137 */,
/* 138 */,
/* 139 */,
/* 140 */,
/* 141 */,
/* 142 */,
/* 143 */,
/* 144 */,
/* 145 */,
/* 146 */,
/* 147 */,
/* 148 */,
/* 149 */,
/* 150 */,
/* 151 */,
/* 152 */,
/* 153 */,
/* 154 */,
/* 155 */,
/* 156 */,
/* 157 */,
/* 158 */,
/* 159 */,
/* 160 */,
/* 161 */,
/* 162 */,
/* 163 */,
/* 164 */,
/* 165 */,
/* 166 */,
/* 167 */,
/* 168 */,
/* 169 */,
/* 170 */,
/* 171 */,
/* 172 */,
/* 173 */,
/* 174 */,
/* 175 */,
/* 176 */,
/* 177 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = {
    // PRIMARY COLORS
    blue: '#0099CC',
    yellow: '#FCD866',
    green: '#08B153',
    red: '#D94C3D',
    orange: '#FD8D10',
    purple: '#991C71',

    // SECONDARY COLORS
    xldblue: '#14B0E4',
    lightblue: '#5FCBF4',
    darkblue: '#4C6C87',

    // SHADES OF GRAY
    black: '#333333',
    antracite: '#495561',
    gray: '#999999',
    lightgray: '#D5D5D5',
    background: '#F0F0F0',
    silver: '#F9F9F9',
    white: '#FFFFFF',

    // Semantic COLORS
    oddRowColor: '#FFFFFF',
    evenRowColor: '#F9F9F9',

    hoverColor: '#D9F0F8',
    selectedColor: '#BFE5F2',
    highlightColor: '#CDEFDC',

    successBackground: '#CDEFDC',
    successHover: '#F6D2CE',

    warningBackground: '#FFE8CF',
    warningHover: '#FFE2C3',

    errorBackground: '#F8DBD8',
    errorHover: '#C1EBD4'
};

/***/ }),
/* 178 */,
/* 179 */,
/* 180 */,
/* 181 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = getAngularService;
function getAngularService(name) {
    return angular.element(document.body).injector().get(name);
}

/***/ }),
/* 182 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defaultMapDispatchToThis = undefined;
exports.templateBuilder = templateBuilder;
exports.defaultMapStateThis = defaultMapStateThis;

__webpack_require__(1796);

var _tasksToWords = __webpack_require__(542);

var _tasksToWords2 = _interopRequireDefault(_tasksToWords);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function templateBuilder(title, body, actionName) {
    return "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">" + title + "</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body actions-modal\">      \n     " + body + "\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.action()\" ng-disabled=\"$ctrl.isActionDisabled()\">" + actionName + "</button>\n    </div>\n";
}

function defaultMapStateThis(state) {
    return {
        tasks: (0, _tasksToWords2.default)(state.releaseGrid.selectedTasks.length)
    };
}

function defaultMapDispatchToThis(_action) {
    return function (dispatch) {
        return {
            action: function action() {
                dispatch(_action());
                this.dismiss();
            },
            isActionDisabled: function isActionDisabled() {
                return false;
            }
        };
    };
}
exports.defaultMapDispatchToThis = defaultMapDispatchToThis;

/***/ }),
/* 183 */,
/* 184 */,
/* 185 */,
/* 186 */,
/* 187 */,
/* 188 */,
/* 189 */,
/* 190 */,
/* 191 */,
/* 192 */,
/* 193 */,
/* 194 */,
/* 195 */,
/* 196 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = ReleaseStatusFactory;
function ReleaseStatusFactory() {
    return {
        isReleaseCompleted: function isReleaseCompleted(release) {
            return release && (release.status === 'COMPLETED' || release.status === 'ABORTED');
        },
        isReleaseAborted: function isReleaseAborted(release) {
            return release && release.status === 'ABORTED';
        },
        isReleasePlanned: function isReleasePlanned(release) {
            return release && release.status === 'PLANNED';
        },
        isReleaseInProgress: function isReleaseInProgress(release) {
            return release && release.status === 'IN_PROGRESS';
        },
        isReleaseFailed: function isReleaseFailed(release) {
            return release && release.status === 'FAILED';
        },
        isReleaseFailing: function isReleaseFailing(release) {
            return release && release.status === 'FAILING';
        },
        isReleasePaused: function isReleasePaused(release) {
            return release && release.status === 'PAUSED';
        },
        hasCompletedStatus: function hasCompletedStatus(release) {
            return release && release.status === 'COMPLETED';
        },
        isTemplate: function isTemplate(release) {
            return release && release.status === 'TEMPLATE';
        },
        isReleaseArchived: function isReleaseArchived(release) {
            return release && release.archived;
        }
    };
}

/***/ }),
/* 197 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RiskSettingsService = exports.fetchReferences = exports.copyRiskProfile = exports.deleteRiskProfile = exports.updateRiskProfile = exports.createRiskProfile = exports.fetchRiskProfile = exports.fetchRiskProfiles = exports.fetchRiskAssessors = exports.fetchRiskConfig = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _http = __webpack_require__(88);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var riskApi = 'api/v1/risks';

var fetchRiskConfig = exports.fetchRiskConfig = function fetchRiskConfig() {
    return (0, _http.httpGET)(riskApi + "/config");
};
var fetchRiskAssessors = exports.fetchRiskAssessors = function fetchRiskAssessors() {
    return (0, _http.httpGET)(riskApi + "/assessors");
};
var fetchRiskProfiles = exports.fetchRiskProfiles = function fetchRiskProfiles() {
    return (0, _http.httpGET)(riskApi + "/profiles");
};
var fetchRiskProfile = exports.fetchRiskProfile = function fetchRiskProfile(riskProfileId) {
    return (0, _http.httpGET)(riskApi + "/profiles/" + riskProfileId);
};
var createRiskProfile = exports.createRiskProfile = function createRiskProfile(riskProfile) {
    return (0, _http.httpPOST)(riskApi + "/profiles", riskProfile);
};
var updateRiskProfile = exports.updateRiskProfile = function updateRiskProfile(riskProfile) {
    return (0, _http.httpPUT)(riskApi + "/profiles/" + riskProfile.id, riskProfile);
};
var deleteRiskProfile = exports.deleteRiskProfile = function deleteRiskProfile(riskProfileId) {
    return (0, _http.httpDELETE)(riskApi + "/profiles/" + riskProfileId);
};
var copyRiskProfile = exports.copyRiskProfile = function copyRiskProfile(riskProfileId) {
    return (0, _http.httpPOST)(riskApi + "/profiles/" + riskProfileId + "/copy");
};
var fetchReferences = exports.fetchReferences = function fetchReferences(riskProfileId) {
    return (0, _http.httpGET)("risks/profiles/" + riskProfileId + "/references");
};

var RiskSettingsService = exports.RiskSettingsService = function () {
    function RiskSettingsService() {
        (0, _classCallCheck3.default)(this, RiskSettingsService);
    }

    (0, _createClass3.default)(RiskSettingsService, [{
        key: "getAll",
        value: function getAll() {
            return fetchRiskProfiles();
        }
    }]);
    return RiskSettingsService;
}();

/***/ }),
/* 198 */,
/* 199 */,
/* 200 */,
/* 201 */,
/* 202 */,
/* 203 */,
/* 204 */,
/* 205 */,
/* 206 */,
/* 207 */,
/* 208 */,
/* 209 */,
/* 210 */,
/* 211 */,
/* 212 */,
/* 213 */,
/* 214 */,
/* 215 */,
/* 216 */,
/* 217 */,
/* 218 */,
/* 219 */,
/* 220 */,
/* 221 */,
/* 222 */,
/* 223 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    RELEASES_SUCCEEDED: 'RELEASES_SUCCEEDED',
    RELEASES_FAILED: 'RELEASES_FAILED',
    MORE_RELEASES_SUCCEEDED: 'MORE_RELEASES_SUCCEEDED',
    MORE_RELEASES_FAILED: 'MORE_RELEASES_FAILED',
    MORE_RELEASES_REQUESTED: 'MORE_RELEASES_REQUESTED',
    RELEASES_PRE_LOAD: 'RELEASES_PRE_LOAD',
    RISKS_REQUESTED: 'RISKS_REQUESTED',
    RISKS_SUCCEEDED: 'RISKS_SUCCEEDED',
    RISKS_REQUEST_FAILED: 'RISKS_REQUEST_FAILED',
    UPDATE_FILTERS_REQUESTED: 'UPDATE_FILTERS_REQUESTED',
    UPDATE_FILTERS_SUCCEEDED: 'UPDATE_FILTERS_SUCCEEDED',
    TOGGLE_RELEASE: 'TOGGLE_RELEASE',
    START_RELEASES: 'START_RELEASES',
    GROUP_RELEASES: 'GROUP_RELEASES',
    DO_START_RELEASES: 'DO_START_RELEASES',
    ABORT_RELEASES: 'ABORT_RELEASES',
    DO_ABORT_RELEASES: 'DO_ABORT_RELEASES',
    BULK_ACTION_STARTED: 'BULK_ACTION_STARTED',
    BULK_ACTION_STOPPED: 'BULK_ACTION_STOPPED',
    AFTER_BULK_ACTION_EXECUTED: 'AFTER_BULK_ACTION_EXECUTED',
    UNSELECT_ALL: 'UNSELECT_ALL',
    TOGGLE_SELECT_ALL: 'TOGGLE_SELECT_ALL',
    FETCH_TAGS_REQUESTED: 'FETCH_TAGS_REQUESTED',
    FETCH_TAGS_SUCCEEDED: 'FETCH_TAGS_SUCCEEDED',
    COUNT_SUCCEEDED: 'RELEASES_COUNT_SUCCEEDED',
    COUNT_FAILED: 'RELEASES_COUNT_FAILED'
};

var showModalAction = function showModalAction(type) {
    return function (uibModalService) {
        return { type: type, uibModalService: uibModalService };
    };
};
var showModalActionWithPayload = function showModalActionWithPayload(type, payload) {
    return function (uibModalService) {
        return { type: type, payload: payload, uibModalService: uibModalService };
    };
};
var toggleRelease = exports.toggleRelease = function toggleRelease($event, $index, releaseId) {
    return { type: actionTypes.TOGGLE_RELEASE, payload: { $event: $event, $index: $index, releaseId: releaseId } };
};
var startReleases = exports.startReleases = showModalAction(actionTypes.START_RELEASES);
var groupReleases = exports.groupReleases = function groupReleases(uibModalService, selectedReleases) {
    return { type: actionTypes.GROUP_RELEASES, payload: { uibModalService: uibModalService, selectedReleases: selectedReleases } };
};
var abortReleases = exports.abortReleases = showModalAction(actionTypes.ABORT_RELEASES);

var getMoreReleases = exports.getMoreReleases = function getMoreReleases() {
    return { type: actionTypes.MORE_RELEASES_REQUESTED };
};
var getRisks = exports.getRisks = function getRisks(releaseId) {
    return { type: actionTypes.RISKS_REQUESTED, payload: releaseId };
};
var doAbortAction = exports.doAbortAction = function doAbortAction(releaseIds) {
    return { type: actionTypes.DO_ABORT_RELEASES, payload: releaseIds };
};
var doStartAction = exports.doStartAction = function doStartAction(releaseIds) {
    return { type: actionTypes.DO_START_RELEASES, payload: releaseIds };
};
var fetchTags = exports.fetchTags = function fetchTags() {
    return { type: actionTypes.FETCH_TAGS_REQUESTED };
};
var fetchTagsSucceeded = exports.fetchTagsSucceeded = function fetchTagsSucceeded(tags) {
    return { type: actionTypes.FETCH_TAGS_SUCCEEDED, payload: tags };
};
var setFilters = exports.setFilters = function setFilters(filters) {
    var loadReleases = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return { type: actionTypes.UPDATE_FILTERS_REQUESTED, payload: { filters: filters, loadReleases: loadReleases } };
};
var toggleSelectAll = exports.toggleSelectAll = function toggleSelectAll() {
    return { type: actionTypes.TOGGLE_SELECT_ALL };
};
var unSelectAll = exports.unSelectAll = function unSelectAll() {
    return { type: actionTypes.UNSELECT_ALL };
};

exports.default = {
    setFilters: setFilters
};

/***/ }),
/* 224 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ITEMS_PER_PAGE = exports.ITEMS_PER_PAGE = 15;
var ITEMS_MAX_DEPTH = exports.ITEMS_MAX_DEPTH = 10;
var AT_RISK = exports.AT_RISK = 'at-risk';
var ATTENTION_NEEDED = exports.ATTENTION_NEEDED = 'attention-needed';
var ON_TRACK = exports.ON_TRACK = 'on-track';
var NONE = exports.NONE = 'none';
var RISK_ON_TRACK_ICON = exports.RISK_ON_TRACK_ICON = 'xl-icon circle-check-icon color-green';

var RISK_ASSESSOR_ICONS = exports.RISK_ASSESSOR_ICONS = {
    'ReleaseFlaggedAt': 'flag-risk-icon icon-l',
    'ReleaseFlaggedAttentionNeeded': 'flag-attention-icon icon-l',
    'ReleaseStatusFailed': 'flag-risk-icon icon-l',
    'ReleaseDueDate': 'pending-icon',
    'ReleaseStatusFailing': 'flag-attention-icon icon-l',
    'ReleaseStatus': 'flag-risk-icon icon-l',
    'TaskAtRisk': 'flag-risk-icon icon-l',
    'TaskWithOneFlagAtRisk': 'flag-risk-icon icon-l',
    'TaskWithTwoOrThreeFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskWithFourFiveOrSixFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskWithMoreThanSixFlagsAtRisk': 'flag-risk-icon icon-l',
    'TaskDueDate': 'pending-icon',
    'OneTaskOverDue': 'pending-icon',
    'MoreThanOneTaskOverDue': 'pending-icon',
    'TaskNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithOneFlagNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithTwoOrThreeFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithFourFiveOrSixFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskWithMoreThanSixFlagsNeedsAttention': 'flag-attention-icon icon-l',
    'TaskRetries': 'lightning-icon color-red',
    'TaskRetries2Retries': 'lightning-icon color-red',
    'TaskRetries3Retries': 'lightning-icon color-red',
    'TaskRetries4Retries': 'lightning-icon color-red',
    'TaskRetries5Retries': 'lightning-icon color-red',
    'TaskRetriesMoreThan5Retries': 'lightning-icon color-red'
};

/***/ }),
/* 225 */,
/* 226 */,
/* 227 */,
/* 228 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isGroupUpdatable = exports.removeReleaseFromGroup = exports.addReleasesToReleaseGroup = exports.updateGroup = exports.createGroup = exports.deleteGroup = exports.fetchGroups = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _http = __webpack_require__(88);

var _constants = __webpack_require__(540);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var RELEASE_GROUP_API = 'api/v1/release-groups';

function reduceFilters(filters) {
    var keys = _.keys(filters);

    return _.reduce(keys, function (reduced, key) {
        if (_.has(_constants.RELEASE_STATUS_FILTER_KEY_TO_STATUS, key)) {
            filters[key] && reduced.statuses.push(_constants.RELEASE_STATUS_FILTER_KEY_TO_STATUS[key]);
        } else {
            reduced[key] = filters[key];
        }
        return reduced;
    }, { statuses: [] });
}

var fetchGroups = exports.fetchGroups = function fetchGroups(data, pageNumber) {
    var params = {
        resultsPerPage: _constants.ITEMS_PER_PAGE,
        page: pageNumber,
        orderBy: (data.orderBy || _constants.DEFAULT_ORDER_BY).toUpperCase()
    };
    var url = RELEASE_GROUP_API + '/search?' + $.param(params);

    return (0, _http.httpPOST)(url, (0, _extends3.default)({}, reduceFilters(data)));
};

var deleteGroup = exports.deleteGroup = function deleteGroup(groupId) {
    return (0, _http.httpDELETE)(RELEASE_GROUP_API + '/' + groupId);
};

var createGroup = exports.createGroup = function createGroup(releaseGroup) {
    return (0, _http.httpPOST)(RELEASE_GROUP_API, releaseGroup);
};

var updateGroup = exports.updateGroup = function updateGroup(releaseGroup) {
    return (0, _http.httpPUT)(RELEASE_GROUP_API + '/' + releaseGroup.id, releaseGroup);
};

var addReleasesToReleaseGroup = exports.addReleasesToReleaseGroup = function addReleasesToReleaseGroup(memberIds, groupId) {
    return (0, _http.httpPOST)(RELEASE_GROUP_API + '/' + groupId + '/members', memberIds);
};

var removeReleaseFromGroup = exports.removeReleaseFromGroup = function removeReleaseFromGroup(memberId, groupId) {
    return (0, _http.httpDELETE)(RELEASE_GROUP_API + '/' + groupId + '/members', [memberId]);
};

var completedStatuses = ['COMPLETED', 'ABORTED'];
var isGroupUpdatable = exports.isGroupUpdatable = function isGroupUpdatable(group) {
    return group && !completedStatuses.includes(group.status);
};

/***/ }),
/* 229 */,
/* 230 */,
/* 231 */,
/* 232 */,
/* 233 */,
/* 234 */,
/* 235 */,
/* 236 */,
/* 237 */,
/* 238 */,
/* 239 */,
/* 240 */,
/* 241 */,
/* 242 */,
/* 243 */,
/* 244 */,
/* 245 */,
/* 246 */,
/* 247 */,
/* 248 */,
/* 249 */,
/* 250 */,
/* 251 */,
/* 252 */,
/* 253 */,
/* 254 */,
/* 255 */,
/* 256 */,
/* 257 */,
/* 258 */,
/* 259 */,
/* 260 */,
/* 261 */,
/* 262 */,
/* 263 */,
/* 264 */,
/* 265 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    GROUPS_PRE_LOAD: 'GROUPS_PRE_LOAD',
    GROUPS_SUCCEEDED: 'GROUPS_SUCCEEDED',
    GROUPS_FAILED: 'GROUPS_FAILED',

    MORE_GROUPS_SUCCEEDED: 'MORE_GROUPS_SUCCEEDED',
    MORE_GROUPS_FAILED: 'MORE_GROUPS_FAILED',
    MORE_GROUPS_REQUESTED: 'MORE_GROUPS_REQUESTED',

    UPDATE_FILTERS_REQUESTED: 'UPDATE_GROUPS_FILTERS_REQUESTED',
    UPDATE_FILTERS_SUCCEEDED: 'UPDATE_GROUPS_FILTERS_SUCCEEDED',
    UPDATE_FILTERS_FAILED: 'UPDATE_GROUPS_FILTERS_FAILED',

    DO_ADD_RELEASES_SUCCEEDED: 'DO_ADD_RELEASES_SUCCEEDED',
    DO_ADD_RELEASES_REQUESTED: 'DO_ADD_RELEASES_REQUESTED',
    DO_ADD_RELEASES_FAILED: 'DO_ADD_RELEASES_FAILED',

    DO_DELETE_GROUP: 'DELETE_GROUP',
    CONFIRM_DELETE_GROUP: 'CONFIRM_DELETE_GROUP'
};

var getMoreGroups = exports.getMoreGroups = function getMoreGroups() {
    return { type: actionTypes.MORE_GROUPS_REQUESTED };
};
var setFilters = exports.setFilters = function setFilters(filters) {
    var loadGroups = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return {
        type: actionTypes.UPDATE_FILTERS_REQUESTED,
        payload: { filters: filters, loadGroups: loadGroups }
    };
};

var doAddRelease = exports.doAddRelease = function doAddRelease(groupId, releaseIds, closeModal) {
    return {
        type: actionTypes.DO_ADD_RELEASES_REQUESTED,
        payload: { groupId: groupId, releaseIds: releaseIds, closeModal: closeModal }
    };
};

var deleteGroup = exports.deleteGroup = function deleteGroup(id) {
    return { type: actionTypes.DO_DELETE_GROUP, payload: id };
};

exports.default = {
    setFilters: setFilters
};

/***/ }),
/* 266 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isAtRisk = isAtRisk;
exports.isAttentionNeeded = isAttentionNeeded;
exports.isOnTrack = isOnTrack;
exports.isCompleted = isCompleted;
exports.getRiskStatus = getRiskStatus;
exports.isPlanItemOverdueMessage = isPlanItemOverdueMessage;
exports.getRiskIconClasses = getRiskIconClasses;

var _releasesStatusService = __webpack_require__(196);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

var _constants = __webpack_require__(224);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function isAtRisk(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore >= riskThresholds.atRiskFrom;
}

function isAttentionNeeded(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore >= riskThresholds.attentionNeededFrom && riskScore < riskThresholds.atRiskFrom;
}

function isOnTrack(release, riskScore, riskThresholds) {
    return !isCompleted(release) && riskScore < riskThresholds.attentionNeededFrom;
}

function isCompleted(release) {
    return (0, _releasesStatusService2.default)().hasCompletedStatus(release) || (0, _releasesStatusService2.default)().isReleaseAborted(release);
}

function getRiskStatus(release, riskScore, riskThresholds) {
    if (isAtRisk(release, riskScore, riskThresholds)) {
        return _constants.AT_RISK;
    } else if (isAttentionNeeded(release, riskScore, riskThresholds)) {
        return _constants.ATTENTION_NEEDED;
    } else if (isOnTrack(release, riskScore, riskThresholds)) {
        return _constants.ON_TRACK;
    }
    return _constants.NONE;
}

function isPlanItemOverdueMessage(message) {
    var riskAssessorId = message.riskAssessorId;

    return riskAssessorId && (riskAssessorId === 'Applications/ReleaseDueDateRiskAssessor' || riskAssessorId === 'Applications/TaskDueDateRiskAssessor');
}

function getRiskIconClasses(riskAssessor) {
    if (!riskAssessor.riskAssessorId) {
        return _constants.RISK_ON_TRACK_ICON;
    }

    var id = (0, _ids2.default)().toInternalId(riskAssessor.riskAssessorId).replace('RiskAssessor', '');

    return _constants.RISK_ASSESSOR_ICONS[id];
}

/***/ }),
/* 267 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.removeCheckedSubset = exports.addCheckedSubset = exports.bulkSelectReleasesFilter = undefined;
exports.default = selectReleases;
exports.selectAllReleases = selectAllReleases;
exports.filterSelectableReleases = filterSelectableReleases;

var _immutable = __webpack_require__(161);

var _lodash = __webpack_require__(79);

function selectReleases(releaseId, isShiftKeyDown, selectedIndex, releases, currentlySelectedReleases, savedSelectIndex, _security, _releaseService, _allowedActions) {
    var newAllowedActions = _allowedActions;
    var toggleFn = !currentlySelectedReleases.has(releaseId) ? addCheckedSubset(currentlySelectedReleases) : removeCheckedSubset(currentlySelectedReleases);

    if (currentlySelectedReleases.isEmpty()) {
        var firstRelease = isShiftKeyDown ? releases.get(savedSelectIndex) : releases.get(selectedIndex);

        newAllowedActions = (0, _immutable.Map)({
            start: isStartActionAvailable(_security, _releaseService, firstRelease),
            abort: isAbortActionAvailable(_security, _releaseService, firstRelease),
            group: true
        });
    }

    if (!isShiftKeyDown || selectedIndex === savedSelectIndex) {
        return {
            newSelectedReleases: toggleFn(_immutable.Set.of(releaseId)),
            newAllowedActions: newAllowedActions
        };
    } else {
        var selectedReleases = (0, _immutable.Set)(releases.slice(Math.min(selectedIndex, savedSelectIndex), Math.max(selectedIndex, savedSelectIndex) + 1)).filter(function (release) {
            return bulkSelectReleasesFilter(release, newAllowedActions, _security, _releaseService);
        }).map(function (release) {
            return release.id;
        });

        return {
            newSelectedReleases: toggleFn(selectedReleases),
            newAllowedActions: newAllowedActions
        };
    }
}

function selectAllReleases(releases, security, releaseService, allowedActions) {
    var selectableReleases = releases.skipUntil(function (release) {
        return bulkSelectReleasesFilter(release, allowedActions, security, releaseService);
    });

    if (!selectableReleases.isEmpty()) {
        var firstRelease = selectableReleases.first();
        var newAllowedActions = (0, _immutable.Map)({
            start: isStartActionAvailable(security, releaseService, firstRelease),
            abort: isAbortActionAvailable(security, releaseService, firstRelease),
            group: true
        });
        var selectedReleases = filterSelectableReleases(selectableReleases, allowedActions, security, releaseService);
        return {
            selectedReleases: selectedReleases,
            newAllowedActions: newAllowedActions
        };
    }

    return {
        selectedReleases: (0, _immutable.Set)(),
        newAllowedActions: allowedActions
    };
}

function filterSelectableReleases(releases, allowedActions, security, releaseService) {
    return releases.filter(function (release) {
        return bulkSelectReleasesFilter(release, allowedActions, security, releaseService);
    });
}

var bulkSelectReleasesFilter = exports.bulkSelectReleasesFilter = function bulkSelectReleasesFilter(release, allowedActions, security, releaseService) {
    if (allowedActions.get('start') && allowedActions.get('abort') && !allowedActions.get('group')) {
        return isStartActionAvailable(security, releaseService, release) && isAbortActionAvailable(security, releaseService, release);
    }

    return allowedActions.get('start') && isStartActionAvailable(security, releaseService, release) || allowedActions.get('abort') && isAbortActionAvailable(security, releaseService, release) || allowedActions.get('group');
};

var isStartActionAvailable = function isStartActionAvailable(security, releaseService, release) {
    return releaseService.isReleasePlanned(release) && security.hasPermission('release#start', release);
};

var isAbortActionAvailable = function isAbortActionAvailable(security, releaseService, release) {
    return security.hasPermission('release#abort', release) && !releaseService.isReleaseCompleted(release);
};

var addCheckedSubset = exports.addCheckedSubset = function addCheckedSubset(current) {
    return function (add) {
        return current.union(add);
    };
};

var removeCheckedSubset = exports.removeCheckedSubset = function removeCheckedSubset(current) {
    return function (remove) {
        return current.subtract(remove);
    };
};

/***/ }),
/* 268 */,
/* 269 */,
/* 270 */,
/* 271 */,
/* 272 */,
/* 273 */,
/* 274 */,
/* 275 */,
/* 276 */,
/* 277 */,
/* 278 */,
/* 279 */,
/* 280 */,
/* 281 */,
/* 282 */,
/* 283 */,
/* 284 */,
/* 285 */,
/* 286 */,
/* 287 */,
/* 288 */,
/* 289 */,
/* 290 */,
/* 291 */,
/* 292 */,
/* 293 */,
/* 294 */,
/* 295 */,
/* 296 */,
/* 297 */,
/* 298 */,
/* 299 */,
/* 300 */,
/* 301 */,
/* 302 */,
/* 303 */,
/* 304 */,
/* 305 */,
/* 306 */,
/* 307 */,
/* 308 */,
/* 309 */,
/* 310 */,
/* 311 */,
/* 312 */,
/* 313 */,
/* 314 */,
/* 315 */,
/* 316 */,
/* 317 */,
/* 318 */,
/* 319 */,
/* 320 */,
/* 321 */,
/* 322 */,
/* 323 */,
/* 324 */,
/* 325 */,
/* 326 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ACTION_TYPES = exports.ACTION_TYPES = {
    FETCH_ROLES: 'roles/FETCH_ROLES',
    SAVE_ROLES: 'roles/SAVE_ROLES',
    UPDATE_ROLE: 'roles/UPDATE_ROLE',
    EDIT_ROLE: 'roles/EDIT_ROLE',
    NEW_ROLE: 'roles/NEW_ROLE',
    EMPTY_SELECTED_ROLE: 'roles/EMPTY_SELECTED_ROLE',
    DELETE_ROLE: 'roles/DELETE_ROLE',
    CONFIRM_DELETE_ROLE: 'roles/CONFIRM_DELETE_ROLE',
    LOAD_ROLES: 'roles/LOAD_ROLES',
    LOAD_USERS: 'roles/ROLES_LOAD_USERS',
    SELECT_ROLE: 'roles/SELECT_ROLE'
};

var fetchRolesAction = exports.fetchRolesAction = function fetchRolesAction() {
    return { type: ACTION_TYPES.FETCH_ROLES };
};
var saveRolesAction = exports.saveRolesAction = function saveRolesAction(roles) {
    return { type: ACTION_TYPES.SAVE_ROLES, payload: roles };
};
var updateRoleAction = exports.updateRoleAction = function updateRoleAction(role) {
    return { type: ACTION_TYPES.UPDATE_ROLE, payload: role };
};
var editRoleAction = exports.editRoleAction = function editRoleAction(role) {
    return { type: ACTION_TYPES.EDIT_ROLE, payload: role };
};
var newRoleAction = exports.newRoleAction = function newRoleAction() {
    return { type: ACTION_TYPES.NEW_ROLE };
};
var deleteRoleAction = exports.deleteRoleAction = function deleteRoleAction(role) {
    return { type: ACTION_TYPES.DELETE_ROLE, payload: role };
};
var confirmDeleteRoleAction = exports.confirmDeleteRoleAction = function confirmDeleteRoleAction(role) {
    return { type: ACTION_TYPES.CONFIRM_DELETE_ROLE, payload: role };
};
var loadRolesAction = exports.loadRolesAction = function loadRolesAction(roles) {
    return { type: ACTION_TYPES.LOAD_ROLES, payload: roles };
};
var loadUsersAction = exports.loadUsersAction = function loadUsersAction(users) {
    return { type: ACTION_TYPES.LOAD_USERS, payload: users };
};
var selectRoleAction = exports.selectRoleAction = function selectRoleAction(role) {
    return { type: ACTION_TYPES.SELECT_ROLE, payload: role };
};
var emptyRoleAction = exports.emptyRoleAction = function emptyRoleAction(role) {
    return { type: ACTION_TYPES.EMPTY_SELECTED_ROLE };
};

/***/ }),
/* 327 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.fetchCount = exports.fetchArchivedReleaseTags = exports.fetchReleaseTags = exports.abortReleases = exports.startReleases = exports.fetchRisks = exports.fetchReleases = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _http = __webpack_require__(88);

var _constants = __webpack_require__(224);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var fetchReleases = exports.fetchReleases = function fetchReleases(filters, pageNumber) {
    var url = "releases/search?depth=3&numberbypage=" + _constants.ITEMS_PER_PAGE + "&page=" + pageNumber + "&filter=" + filters.filter + '&properties=riskScore&extensions=progress';
    return (0, _http.httpRequest)('POST', url, {
        data: filters
    });
};
var fetchRisks = exports.fetchRisks = function fetchRisks(releaseId) {
    return (0, _http.httpRequest)('GET', "api/v1/risks/" + releaseId + "/Risk");
};
var startReleases = exports.startReleases = function startReleases(releasesIds) {
    return (0, _http.httpRequest)('POST', "releases/start", { data: releasesIds });
};
var abortReleases = exports.abortReleases = function abortReleases(releasesIds) {
    return (0, _http.httpRequest)('POST', "releases/abort", { data: releasesIds });
};

var fetchReleaseTags = exports.fetchReleaseTags = function fetchReleaseTags() {
    return (0, _http.httpGET)('releases/tags');
};

var fetchArchivedReleaseTags = exports.fetchArchivedReleaseTags = function fetchArchivedReleaseTags() {
    return (0, _http.httpGET)('releases/tags/archived');
};

var fetchCount = exports.fetchCount = function fetchCount(filters) {
    if (filters.onlyArchived) {
        filters.planned = false;
        filters.inProgress = false;
        filters.failing = false;
        filters.failed = false;
        filters.paused = false;
    }
    return (0, _http.httpPOST)('releases/count', (0, _extends3.default)({}, filters, { onlyArchived: false }));
};

/***/ }),
/* 328 */,
/* 329 */,
/* 330 */,
/* 331 */,
/* 332 */,
/* 333 */,
/* 334 */,
/* 335 */,
/* 336 */,
/* 337 */,
/* 338 */,
/* 339 */,
/* 340 */,
/* 341 */,
/* 342 */,
/* 343 */,
/* 344 */,
/* 345 */,
/* 346 */,
/* 347 */,
/* 348 */,
/* 349 */,
/* 350 */,
/* 351 */,
/* 352 */,
/* 353 */,
/* 354 */,
/* 355 */,
/* 356 */,
/* 357 */,
/* 358 */,
/* 359 */,
/* 360 */,
/* 361 */,
/* 362 */,
/* 363 */,
/* 364 */,
/* 365 */,
/* 366 */,
/* 367 */,
/* 368 */,
/* 369 */,
/* 370 */,
/* 371 */,
/* 372 */,
/* 373 */,
/* 374 */,
/* 375 */,
/* 376 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
var DEFAULT_FOLDER_TAB = exports.DEFAULT_FOLDER_TAB = 'templates';

/***/ }),
/* 377 */,
/* 378 */,
/* 379 */,
/* 380 */,
/* 381 */,
/* 382 */,
/* 383 */,
/* 384 */,
/* 385 */,
/* 386 */,
/* 387 */,
/* 388 */,
/* 389 */,
/* 390 */,
/* 391 */,
/* 392 */,
/* 393 */,
/* 394 */,
/* 395 */,
/* 396 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    COPY_RISK_PROFILE: 'COPY_RISK_PROFILE',
    COPY_RISK_PROFILE_SUCCEEDED: 'COPY_RISK_PROFILE_SUCCEEDED',
    COPY_RISK_PROFILE_FAILED: 'COPY_RISK_PROFILE_FAILED',
    DELETE_RISK_PROFILE: 'DELETE_RISK_PROFILE',
    DELETE_RISK_PROFILE_FAILED: 'DELETE_RISK_PROFILE_FAILED',
    DELETE_RISK_PROFILE_SUCCEEDED: 'DELETE_RISK_PROFILE_SUCCEEDED',
    LOAD_RISK_PROFILES: 'LOAD_RISK_PROFILES',
    LOAD_RISK_PROFILES_SUCCEEDED: 'LOAD_RISK_PROFILES_SUCCEEDED',
    LOAD_RISK_PROFILES_FAILED: 'LOAD_RISK_PROFILES_FAILED',
    LOAD_REFERENCES: 'LOAD_REFERENCES',
    LOAD_REFERENCES_SUCCEEDED: 'LOAD_REFERENCES_SUCCEEDED'
};

var copyRiskProfile = exports.copyRiskProfile = function copyRiskProfile(riskProfileId) {
    return {
        type: actionTypes.COPY_RISK_PROFILE,
        payload: riskProfileId
    };
};

var showModalAction = function showModalAction(type) {
    return function (uibModalService) {
        return { type: type, uibModalService: uibModalService };
    };
};

var deleteProfile = exports.deleteProfile = showModalAction(actionTypes.DELETE_RISK_PROFILE);

var deleteRiskProfile = exports.deleteRiskProfile = function deleteRiskProfile(riskProfileId) {
    return {
        type: actionTypes.DELETE_RISK_PROFILE,
        payload: riskProfileId
    };
};

var loadRiskProfiles = exports.loadRiskProfiles = function loadRiskProfiles() {
    return {
        type: actionTypes.LOAD_RISK_PROFILES
    };
};

var loadReferences = exports.loadReferences = function loadReferences(riskProfileId) {
    return {
        type: actionTypes.LOAD_REFERENCES,
        payload: riskProfileId
    };
};

var loadReferencesSucceeded = exports.loadReferencesSucceeded = function loadReferencesSucceeded(references) {
    return {
        type: actionTypes.LOAD_REFERENCES_SUCCEEDED,
        payload: references
    };
};

/***/ }),
/* 397 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var CHECKBOX_STATUSES = {
    CHECKED: 'checked',
    INDETERMINATE: 'indeterminate',
    UNCHECKED: 'unchecked'
};

exports.default = CHECKBOX_STATUSES;

/***/ }),
/* 398 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.showError = showError;
exports.showServerDownError = showServerDownError;
exports.default = AlertsFactory;

var _lodash = __webpack_require__(79);

var _lodash2 = _interopRequireDefault(_lodash);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getResponseData(response) {
    var contentType = getHeader(response, 'content-type');
    return contentType && contentType.indexOf('text/html') === -1 && response.data || '';
}

function getHeader(response, headerName) {
    var defaultVal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

    //we need this logic because we are still using different approaches to call a server
    if (_lodash2.default.isFunction(response.headers)) {
        //this is true for calls from $http
        return _lodash2.default.get(response.headers(), headerName, defaultVal);
    } else {
        return _lodash2.default.get(response.headers, headerName, defaultVal); //this is true for calls from axios
    }
}

function getAlertMsg(response) {
    var responseData = getResponseData(response);
    var path = getHeader(response, 'x-path', response.config.url);
    var date = getHeader(response, 'date');
    return ('\n        <div class=\'alert-details\'>\n            <p>' + responseData + '</p>\n            <p>Status code: ' + response.status + '</p>\n            <p><strong>' + response.config.method + ' ' + path + '</strong></p>\n            <p>' + date + '</p>\n        </div>').split('\n').join('');
}

var toaster = (0, _toastrFactory2.default)();

function showError(response) {
    toaster.error(getAlertMsg(response), 'An error occurred', { escapeHtml: false });
}

function showServerDownError() {
    toaster.error('The XL Release server is not available', 'An error occurred');
}

function AlertsFactory() {
    return {
        error: showError,
        serverDownError: showServerDownError
    };
}

/***/ }),
/* 399 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    GROUP_REQUESTED: 'GROUP_DETAILS_REQUESTED',
    GROUP_PRE_LOAD: 'GROUP_DETAILS_GROUP_PRE_LOAD',
    GROUP_SUCCEEDED: 'GROUP_DETAILS_GROUP_SUCCEEDED',
    GROUP_FAILED: 'GROUP_DETAILS_GROUP_FAILED',

    UPDATE_FILTERS_REQUESTED: 'GROUP_DETAILS_UPDATE_FILTERS_REQUESTED',
    UPDATE_FILTERS_SUCCEEDED: 'GROUP_DETAILS_UPDATE_FILTERS_SUCCEEDED',
    UPDATE_FILTERS_FAILED: 'GROUP_DETAILS_UPDATE_FILTERS_FAILED',

    ZOOM_IN: 'GROUP_DETAILS_ZOOM_IN',
    ZOOM_OUT: 'GROUP_DETAILS_ZOOM_OUT',

    RESET_TO_INITIAL_STATE: 'GROUP_DETAILS_RESET_TO_INITIAL_STATE'
};

var setFilters = exports.setFilters = function setFilters(filters) {
    return {
        type: actionTypes.UPDATE_FILTERS_REQUESTED,
        payload: { filters: filters }
    };
};

var fetchGroup = exports.fetchGroup = function fetchGroup(groupId, filters) {
    return {
        type: actionTypes.GROUP_REQUESTED,
        payload: { groupId: groupId, filters: filters }
    };
};

var resetToInitialState = exports.resetToInitialState = function resetToInitialState() {
    return {
        type: actionTypes.RESET_TO_INITIAL_STATE
    };
};

exports.default = {
    setFilters: setFilters,
    fetchGroup: fetchGroup,
    resetToInitialState: resetToInitialState
};

/***/ }),
/* 400 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ACTION_TYPES = exports.ACTION_TYPES = {
    LOAD_TRIGGERS_SUCCEEDED: 'LOAD_TRIGGERS_SUCCEEDED',
    LOAD_TRIGGERS_REQUESTED: 'LOAD_TRIGGERS_REQUESTED',
    SAVE_TRIGGERS: 'SAVE_TRIGGERS',
    RESET_TRIGGERS: 'RESET_TRIGGERS',
    SELECT_TRIGGER: 'SELECT_TRIGGER',
    RESET_SELECTED_TRIGGER: 'RESET_SELECTED_TRIGGER',
    DATA_CHANGED: 'DATA_CHANGED',
    SELECTED_TRIGGER_CHANGED: 'SELECTED_TRIGGER_CHANGED',
    SAVE_TRIGGER_SETTINGS_REQUESTED: 'SAVE_TRIGGER_SETTINGS_REQUESTED',
    SAVE_TRIGGER_SETTINGS_SUCCEEDED: 'SAVE_TRIGGER_SETTINGS_SUCCEEDED'
};

var resetSelectedTrigger = exports.resetSelectedTrigger = function resetSelectedTrigger() {
    return { type: ACTION_TYPES.RESET_SELECTED_TRIGGER };
};
var dataChanged = exports.dataChanged = function dataChanged() {
    var payload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    return { type: ACTION_TYPES.DATA_CHANGED, payload: payload };
};
var fetchTriggers = exports.fetchTriggers = function fetchTriggers() {
    return { type: ACTION_TYPES.LOAD_TRIGGERS_REQUESTED };
};
var resetTriggers = exports.resetTriggers = function resetTriggers() {
    return { type: ACTION_TYPES.RESET_TRIGGERS };
};
var saveTriggers = exports.saveTriggers = function saveTriggers(data) {
    return { type: ACTION_TYPES.SAVE_TRIGGERS, payload: data };
};
var selectTrigger = exports.selectTrigger = function selectTrigger(row) {
    return { type: ACTION_TYPES.SELECT_TRIGGER, payload: row.original };
};
var selectedTriggerChanged = exports.selectedTriggerChanged = function selectedTriggerChanged() {
    var payload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    return { type: ACTION_TYPES.SELECTED_TRIGGER_CHANGED, payload: payload };
};
var saveTriggerSettings = exports.saveTriggerSettings = function saveTriggerSettings(data) {
    return { type: ACTION_TYPES.SAVE_TRIGGER_SETTINGS_REQUESTED, payload: data };
};

/***/ }),
/* 401 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var MemberType = exports.MemberType = {
    PRINCIPAL: 'PRINCIPAL',
    ROLE: 'ROLE',
    TEAM: 'TEAM'
};

var SystemTeams = exports.SystemTeams = {
    FOLDER_OWNER: 'Folder Owner',
    TEMPLATE_OWNER: 'Template Owner',
    RELEASE_ADMIN: 'Release Admin'
};

/***/ }),
/* 402 */,
/* 403 */,
/* 404 */,
/* 405 */,
/* 406 */,
/* 407 */,
/* 408 */,
/* 409 */,
/* 410 */,
/* 411 */,
/* 412 */,
/* 413 */,
/* 414 */,
/* 415 */,
/* 416 */,
/* 417 */,
/* 418 */,
/* 419 */,
/* 420 */,
/* 421 */,
/* 422 */,
/* 423 */,
/* 424 */,
/* 425 */,
/* 426 */,
/* 427 */,
/* 428 */,
/* 429 */,
/* 430 */,
/* 431 */,
/* 432 */,
/* 433 */,
/* 434 */,
/* 435 */,
/* 436 */,
/* 437 */,
/* 438 */,
/* 439 */,
/* 440 */,
/* 441 */,
/* 442 */,
/* 443 */,
/* 444 */,
/* 445 */,
/* 446 */,
/* 447 */,
/* 448 */,
/* 449 */,
/* 450 */,
/* 451 */,
/* 452 */,
/* 453 */,
/* 454 */,
/* 455 */,
/* 456 */,
/* 457 */,
/* 458 */,
/* 459 */,
/* 460 */,
/* 461 */,
/* 462 */,
/* 463 */,
/* 464 */,
/* 465 */,
/* 466 */,
/* 467 */,
/* 468 */,
/* 469 */,
/* 470 */,
/* 471 */,
/* 472 */,
/* 473 */,
/* 474 */,
/* 475 */,
/* 476 */,
/* 477 */,
/* 478 */,
/* 479 */,
/* 480 */,
/* 481 */,
/* 482 */,
/* 483 */,
/* 484 */,
/* 485 */,
/* 486 */,
/* 487 */,
/* 488 */,
/* 489 */,
/* 490 */,
/* 491 */,
/* 492 */,
/* 493 */,
/* 494 */,
/* 495 */,
/* 496 */,
/* 497 */,
/* 498 */,
/* 499 */,
/* 500 */,
/* 501 */,
/* 502 */,
/* 503 */,
/* 504 */,
/* 505 */,
/* 506 */,
/* 507 */,
/* 508 */,
/* 509 */,
/* 510 */,
/* 511 */,
/* 512 */,
/* 513 */,
/* 514 */,
/* 515 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Error when stacking multiple modal:
 * http://stackoverflow.com/questions/13649459/twitter-bootstrap-multiple-modal-error
 */
$.fn.modal.Constructor.prototype.enforceFocus = function () {};

/***/ }),
/* 516 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var variableTypes = {
    GLOBAL: 'GLOBAL',
    FOLDER: 'FOLDER'
};

var isGlobalOrFolder = function isGlobalOrFolder(type) {
    return variableTypes.FOLDER === type || variableTypes.GLOBAL === type;
};

exports.default = (0, _extends3.default)({}, variableTypes, {
    isGlobalOrFolder: isGlobalOrFolder
});

/***/ }),
/* 517 */,
/* 518 */,
/* 519 */,
/* 520 */,
/* 521 */,
/* 522 */,
/* 523 */,
/* 524 */,
/* 525 */,
/* 526 */,
/* 527 */,
/* 528 */,
/* 529 */,
/* 530 */,
/* 531 */,
/* 532 */,
/* 533 */,
/* 534 */,
/* 535 */,
/* 536 */,
/* 537 */,
/* 538 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

exports.showSpinner = showSpinner;
exports.hideSpinner = hideSpinner;
exports.handleResponseError = handleResponseError;

var _http = __webpack_require__(88);

var _alerts = __webpack_require__(398);

var _angularAccessor = __webpack_require__(181);

var _angularAccessor2 = _interopRequireDefault(_angularAccessor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DELAY_BEFORE_AJAX_SPINNER = 1000;
var ajaxSpinnerTimers = [];

function showSpinner() {
    ajaxSpinnerTimers.push(setTimeout(function () {
        angular.element('#loading').show();
    }, DELAY_BEFORE_AJAX_SPINNER));
}

function hideSpinner() {
    clearTimeout(ajaxSpinnerTimers.pop());
    if (ajaxSpinnerTimers.length === 0) {
        angular.element('#loading').hide();
    }
}

function handleResponseError(error) {
    if (error.message === 'Network Error') {
        (0, _alerts.showServerDownError)();
    } else {
        var response = error.response;
        var $rootScope = (0, _angularAccessor2.default)('$rootScope'); //tmp solution
        var Events = (0, _angularAccessor2.default)('Events');
        var showErrorAlert = !response.config.hideAlert && response.status !== response.config.hideAlertOnCode;
        switch (response.status) {
            case _http.httpCodes.PAYMENT_REQUIRED:
                location.href = './productregistration';
                showErrorAlert = false;
                break;
            case _http.httpCodes.UNAUTHORIZED:
                $rootScope.$emit(Events.permission.unauthorized);
                showErrorAlert = false;
                break;
            case _http.httpCodes.FORBIDDEN:
                if (!response.config.dontRedirectWhenForbidden) {
                    var contentType = response.headers['content-type'];
                    // If content-type is HTML, response.data is html, so no readable message.
                    var errorMessage = contentType && contentType.match(/^text\/plain/) ? response.data : '';
                    $rootScope.$emit(Events.permission.forbidden, errorMessage);
                }
                showErrorAlert = false;
                break;
            case _http.httpCodes.VERSION_CHANGED:
                $rootScope.$apply(function () {
                    $rootScope.xlreleaseVersionChanged = true;
                    $rootScope.versionChangedMessage = response.data;
                });
                break;
        }

        if (showErrorAlert) {
            (0, _alerts.showError)(response);
        }
    }
}

(0, _http.registerRequestInterceptor)(function (request) {
    showSpinner();
    return request;
});

(0, _http.registerResponseInterceptors)(function (response) {
    hideSpinner();
    return response;
}, function (error) {
    hideSpinner();
    handleResponseError(error);
    return _promise2.default.reject(error);
});

/***/ }),
/* 539 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _xlReactComponents = __webpack_require__(69);

var STATUSES = [{ label: 'Planned', value: 'Planned', color: _xlReactComponents.colors['xl-gray'] }, { label: 'In progress', value: 'In progress', color: _xlReactComponents.colors['xl-light-blue'] }, { label: 'Paused', value: 'Paused', color: _xlReactComponents.colors['xl-gray'] }, { label: 'Failed', value: 'Failed', color: _xlReactComponents.colors['xl-red'] }, { label: 'Failing', value: 'Failing', color: _xlReactComponents.colors['xl-orange'] }, { label: 'Aborted', value: 'Aborted', color: _xlReactComponents.colors['xl-gray'] }, { label: 'Completed', value: 'Completed', color: _xlReactComponents.colors['xl-green'] }];

exports.default = STATUSES;

/***/ }),
/* 540 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ITEMS_PER_PAGE = exports.ITEMS_PER_PAGE = 15;
var DEFAULT_ORDER_BY = exports.DEFAULT_ORDER_BY = 'risk';
var RELEASE_STATUS_FILTER_KEY_TO_STATUS = exports.RELEASE_STATUS_FILTER_KEY_TO_STATUS = {
    planned: 'PLANNED',
    inProgress: 'IN_PROGRESS',
    paused: 'PAUSED',
    failing: 'FAILING',
    failed: 'FAILED',
    completed: 'COMPLETED',
    aborted: 'ABORTED'
};
var ENTITY_ID_PLACEHOLDER = exports.ENTITY_ID_PLACEHOLDER = -1;

/***/ }),
/* 541 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var actionTypes = exports.actionTypes = {
    FETCH_ITEMS: 'FETCH_ITEMS',
    FETCH_ITEMS_SUCCEEDED: 'FETCH_ITEMS_SUCCEEDED',
    FETCH_ITEMS_FAILED: 'FETCH_ITEMS_FAILED',
    MORE_ITEMS_SUCCEEDED: 'MORE_ITEMS_SUCCEEDED',
    MORE_ITEMS_REQUESTED: 'MORE_ITEMS_REQUESTED',
    ITEMS_TOGGLE_SELECT_ALL: 'ITEMS_TOGGLE_SELECT_ALL',
    ITEM_TOGGLE: 'ITEM_TOGGLE'
};

var fetchItems = exports.fetchItems = function fetchItems(filters) {
    return { type: actionTypes.FETCH_ITEMS, payload: filters };
};
var loadMoreItems = exports.loadMoreItems = function loadMoreItems(filters) {
    return { type: actionTypes.MORE_ITEMS_REQUESTED, payload: filters };
};
var toggleSelectAll = exports.toggleSelectAll = function toggleSelectAll() {
    return { type: actionTypes.ITEMS_TOGGLE_SELECT_ALL };
};
var toggleItem = exports.toggleItem = function toggleItem($event, $index, releaseId) {
    return { type: actionTypes.ITEM_TOGGLE, payload: { $event: $event, $index: $index, releaseId: releaseId } };
};

/***/ }),
/* 542 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = tasksToWords;

var _pluralize = __webpack_require__(198);

var _pluralize2 = _interopRequireDefault(_pluralize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function tasksToWords(number) {
    return number + ' ' + (0, _pluralize2.default)('task', number);
}

/***/ }),
/* 543 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = releasesToWords;

var _pluralize = __webpack_require__(198);

var _pluralize2 = _interopRequireDefault(_pluralize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function releasesToWords(number) {
    return number + ' ' + (0, _pluralize2.default)('release', number);
}

/***/ }),
/* 544 */,
/* 545 */,
/* 546 */,
/* 547 */,
/* 548 */,
/* 549 */,
/* 550 */,
/* 551 */,
/* 552 */,
/* 553 */,
/* 554 */,
/* 555 */,
/* 556 */,
/* 557 */,
/* 558 */,
/* 559 */,
/* 560 */,
/* 561 */,
/* 562 */,
/* 563 */,
/* 564 */,
/* 565 */,
/* 566 */,
/* 567 */,
/* 568 */,
/* 569 */,
/* 570 */,
/* 571 */,
/* 572 */,
/* 573 */,
/* 574 */,
/* 575 */,
/* 576 */,
/* 577 */,
/* 578 */,
/* 579 */,
/* 580 */,
/* 581 */,
/* 582 */,
/* 583 */,
/* 584 */,
/* 585 */,
/* 586 */,
/* 587 */,
/* 588 */,
/* 589 */,
/* 590 */,
/* 591 */,
/* 592 */,
/* 593 */,
/* 594 */,
/* 595 */,
/* 596 */,
/* 597 */,
/* 598 */,
/* 599 */,
/* 600 */,
/* 601 */,
/* 602 */,
/* 603 */,
/* 604 */,
/* 605 */,
/* 606 */,
/* 607 */,
/* 608 */,
/* 609 */,
/* 610 */,
/* 611 */,
/* 612 */,
/* 613 */,
/* 614 */,
/* 615 */,
/* 616 */,
/* 617 */,
/* 618 */,
/* 619 */,
/* 620 */,
/* 621 */,
/* 622 */,
/* 623 */,
/* 624 */,
/* 625 */,
/* 626 */,
/* 627 */,
/* 628 */,
/* 629 */,
/* 630 */,
/* 631 */,
/* 632 */,
/* 633 */,
/* 634 */,
/* 635 */,
/* 636 */,
/* 637 */,
/* 638 */,
/* 639 */,
/* 640 */,
/* 641 */,
/* 642 */,
/* 643 */,
/* 644 */,
/* 645 */,
/* 646 */,
/* 647 */,
/* 648 */,
/* 649 */,
/* 650 */,
/* 651 */,
/* 652 */,
/* 653 */,
/* 654 */,
/* 655 */,
/* 656 */,
/* 657 */,
/* 658 */,
/* 659 */,
/* 660 */,
/* 661 */,
/* 662 */,
/* 663 */,
/* 664 */,
/* 665 */,
/* 666 */,
/* 667 */,
/* 668 */,
/* 669 */,
/* 670 */,
/* 671 */,
/* 672 */,
/* 673 */,
/* 674 */,
/* 675 */,
/* 676 */,
/* 677 */,
/* 678 */,
/* 679 */,
/* 680 */,
/* 681 */,
/* 682 */,
/* 683 */,
/* 684 */,
/* 685 */,
/* 686 */,
/* 687 */,
/* 688 */,
/* 689 */,
/* 690 */,
/* 691 */,
/* 692 */,
/* 693 */,
/* 694 */,
/* 695 */,
/* 696 */,
/* 697 */,
/* 698 */,
/* 699 */,
/* 700 */,
/* 701 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CUSTOM_LOGO_SRC = undefined;

var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _colors = __webpack_require__(177);

var _colors2 = _interopRequireDefault(_colors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @deprecated Since we use ui-router, use states!
 */
var PageUrls = {
    START_PAGE: '/tasks',
    LOGIN_PAGE: '/login',
    FORBIDDEN_CONTENT_PAGE: '/forbidden-access',
    INVALID_LICENSE_PAGE: '/invalid-license',
    TEMPLATE: /templates\/.*Release[^\/]*/
};

var CUSTOM_LOGO_SRC = exports.CUSTOM_LOGO_SRC = 'settings/custom-logo/download';

var Page = function () {
    function Page($rootScope, $location, $state, UiExtensionsService, BreadcrumbsService, Backend, Events, MenuItemsProviderRegistry, $uibModal, SystemMessageService, Authenticator) {
        var _this = this;

        (0, _classCallCheck3.default)(this, Page);

        this._$uibModal = $uibModal;
        this._MenuItemsProviderRegistry = MenuItemsProviderRegistry;
        this._$rootScope = $rootScope;
        this._$location = $location;
        this._$state = $state;
        this._UiExtensionsService = UiExtensionsService;
        this._BreadcrumbsService = BreadcrumbsService;
        this._activeMenuItems = [];
        this._currentTitle = '';
        this._folder = null;
        this._breadcrumbsSet = false;
        this._Backend = Backend;
        this._Events = Events;
        this._SystemMessageService = SystemMessageService;
        this._Authenticator = Authenticator;
        this._theme = {
            headerAccentColor: _colors2.default.green,
            headerName: ''
        };
        this._customLogoSrc = CUSTOM_LOGO_SRC;

        this._$rootScope.$on('$stateChangeSuccess', function () {
            _this._updateCurrentPage();
            _this._breadcrumbsSet = false;
            _this._$rootScope.$emit(_this._Events.ui.subMenuRefresh);

            if (_this._Authenticator.isAuthenticated()) {
                _this._SystemMessageService.emitSystemMessage();
            }
        });
    }

    (0, _createClass3.default)(Page, [{
        key: '_updateCurrentPage',
        value: function _updateCurrentPage() {
            var _this2 = this;

            this._UiExtensionsService.getMainMenuItems().then(function (menuItems) {
                if (_this2._breadcrumbsSet) {
                    return;
                }
                var newActiveMenuItems = _this2._findActiveMenuPath(menuItems);

                var activeMenuHasChanged = !_.isEqual(newActiveMenuItems, _this2._activeMenuItems);
                var isAtRootPath = _this2.isOnPage(_this2._getLeafActiveMenu(newActiveMenuItems).pathSuffix, true);

                if (activeMenuHasChanged || isAtRootPath) {
                    if (!_.isEmpty(newActiveMenuItems)) {
                        _this2._currentTitle = _.last(newActiveMenuItems).label;
                    } else {
                        _this2._currentTitle = '';
                    }
                }

                _this2._activeMenuItems = newActiveMenuItems;
                _this2._BreadcrumbsService.updateBreadcrumbs('');
            });
        }
    }, {
        key: '_findActiveMenuPath',
        value: function _findActiveMenuPath(allItems) {
            for (var i = 0; i < allItems.length; i++) {
                var item = allItems[i];
                var subItems = this._findActiveMenuPath(item.items || []);
                if (subItems.length || this.isOnPage(item.pathSuffix)) {
                    return [item].concat(subItems);
                }
            }
            return [];
        }
    }, {
        key: '_getLeafActiveMenu',
        value: function _getLeafActiveMenu() {
            return _.last(this._activeMenuItems) || {};
        }
    }, {
        key: '_isFolderPresent',
        value: function _isFolderPresent() {
            return this._folder;
        }

        // public methods

    }, {
        key: 'initTheme',
        value: function initTheme() {
            var _this3 = this;

            this._Backend.get("settings/theme", { hideAlert: true }).then(function (resp) {
                return _this3.applyTheme(resp.data);
            });
        }
    }, {
        key: 'applyTheme',
        value: function applyTheme(data) {
            this._theme = data;
            this._$rootScope.$emit(this._Events.ui.themeRefresh);
        }
    }, {
        key: 'initCustomLogo',
        value: function initCustomLogo() {
            this.applyCustomLogo(true);
        }
    }, {
        key: 'applyCustomLogo',
        value: function applyCustomLogo(apply) {
            this._customLogoSrc = apply ? CUSTOM_LOGO_SRC + "?cb=" + new Date().valueOf() : null;
            this._$rootScope.$emit(this._Events.ui.customLogoRefresh);
        }
    }, {
        key: 'getTitle',
        value: function getTitle() {
            return _.isEmpty(this._currentTitle) ? 'XL Release' : [this._currentTitle, 'XL Release'].join(' - ');
        }
    }, {
        key: 'addToTitle',
        value: function addToTitle(subtitle) {
            this._currentTitle = subtitle;
        }
    }, {
        key: 'setReleaseOpened',
        value: function setReleaseOpened(release) {
            this.addToTitle(release.title);
            this._breadcrumbsSet = true;
            this._BreadcrumbsService.updateBreadcrumbsWithRelease(release);
        }
    }, {
        key: 'setFolderOpened',
        value: function setFolderOpened(folder) {
            this.addToTitle(folder.title);
        }
    }, {
        key: 'setRiskProfileOpened',
        value: function setRiskProfileOpened(riskProfile) {
            this.addToTitle(riskProfile.title);
            this._breadcrumbsSet = true;
            this._BreadcrumbsService.updateBreadcrumbsWithRiskProfile(riskProfile);
            this._updateCurrentPage();
        }
    }, {
        key: 'setReleaseGroupOpened',
        value: function setReleaseGroupOpened(releaseGroup) {
            this.addToTitle(releaseGroup.title);
            this._breadcrumbsSet = true;
            this._BreadcrumbsService.updateBreadcrumbsWithReleaseGroup(releaseGroup);
            this._updateCurrentPage();
        }
    }, {
        key: 'setDashboardOpened',
        value: function setDashboardOpened(dashboard) {
            this.addToTitle(dashboard.title);
            this._breadcrumbsSet = true;
            this._BreadcrumbsService.updateBreadcrumbsWithDashboard(dashboard);
            this._updateCurrentPage();
        }
    }, {
        key: 'fetchSubNavMenuItems',
        value: function fetchSubNavMenuItems() {
            var _this4 = this;

            return this._UiExtensionsService.getMainMenuItems().then(function (items) {
                var activeMenu = _this4._findActiveMenuPath(items);
                if (activeMenu.length > 1) {
                    return _.head(activeMenu).items.filter(function (item) {
                        return item.permitted;
                    });
                }
                return activeMenu;
            }).then(function (menuItems) {
                return _this4.useMenuItemsProviders(menuItems);
            });
        }
    }, {
        key: 'useMenuItemsProviders',
        value: function useMenuItemsProviders(menuItems) {
            var _this5 = this;

            var promises = _.reduce(menuItems, function (replacements, item) {
                var providerId = _.get(item, 'properties.itemProvider');
                if (providerId && _this5._MenuItemsProviderRegistry.hasProvider(providerId)) {
                    var provider = _this5._MenuItemsProviderRegistry.getProvider(providerId);
                    replacements.push(provider().then(function (dynamicItems) {
                        return { dynamicItems: dynamicItems, item: item };
                    }));
                }
                return replacements;
            }, []);

            return _promise2.default.all(promises).then(function (replacements) {
                replacements.forEach(function (replacement) {
                    var index = _.findIndex(menuItems, replacement.item);
                    menuItems = [].concat((0, _toConsumableArray3.default)(menuItems.slice(0, index)), (0, _toConsumableArray3.default)(replacement.dynamicItems), (0, _toConsumableArray3.default)(menuItems.slice(index + 1)));
                });

                return menuItems;
            });
        }
    }, {
        key: 'isFullPage',
        value: function isFullPage() {
            return this.isLoginPage() || this.isOnPage(PageUrls.INVALID_LICENSE_PAGE);
        }
    }, {
        key: 'isLoginPage',
        value: function isLoginPage() {
            return this.isOnPage(PageUrls.LOGIN_PAGE);
        }
    }, {
        key: 'isTemplateDetailsPage',
        value: function isTemplateDetailsPage() {
            return PageUrls.TEMPLATE.test(this._$location.path());
        }
    }, {
        key: 'isReleaseFlowPage',
        value: function isReleaseFlowPage() {
            return this._$state.is('release');
        }
    }, {
        key: 'isTemplateReleaseFlowPage',
        value: function isTemplateReleaseFlowPage() {
            return this._$state.is('template');
        }
    }, {
        key: 'isRolePage',
        value: function isRolePage() {
            return this._$state.is('roles');
        }
    }, {
        key: 'isDashboardsPages',
        value: function isDashboardsPages() {
            return this.isGlobalDashboardsPages() || this.isFolderDashboardPage();
        }
    }, {
        key: 'isGlobalDashboardsPages',
        value: function isGlobalDashboardsPages() {
            return this._$state.is('dashboards') || this._$state.is('defaultDashboard');
        }
    }, {
        key: 'isFolderDashboardPage',
        value: function isFolderDashboardPage() {
            return this._$state.is('folderDashboards');
        }
    }, {
        key: 'isReportsPages',
        value: function isReportsPages() {
            return this._$state.is('reports') || this._$state.is('releaseValueStream');
        }
    }, {
        key: 'refresh',
        value: function refresh() {
            document.location.reload(true);
        }
    }, {
        key: 'isOnPage',
        value: function isOnPage(path, isRootPath) {
            if (!path) return false;
            path = path[0] === '/' ? path.substr(1) : path;
            var currentPath = this._$location.path().substr(1);
            var firstPathSegment = currentPath.substr(0, path.length);
            if (!isRootPath) {
                return firstPathSegment === path;
            }
            return firstPathSegment === path && !currentPath.substr(0, path.length + 1).match(/\/$/);
        }
    }, {
        key: 'theme',
        get: function get() {
            return this._theme;
        }
    }, {
        key: 'customLogoSrc',
        get: function get() {
            return this._customLogoSrc;
        }
    }]);
    return Page;
}();

Page.$inject = ['$rootScope', '$location', '$state', 'UiExtensionsService', 'BreadcrumbsService', 'Backend', 'Events', 'MenuItemsProviderRegistry', '$uibModal', 'SystemMessageService', 'Authenticator'];


angular.module('xlrelease').constant('PageUrls', PageUrls).service('Page', Page);

/***/ }),
/* 702 */,
/* 703 */,
/* 704 */,
/* 705 */,
/* 706 */,
/* 707 */,
/* 708 */,
/* 709 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = DateServiceFactory;

var _releasesStatusService = __webpack_require__(196);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleasesStatusService = (0, _releasesStatusService2.default)();

function DateServiceFactory() {
    return {
        isOverdue: function isOverdue(date) {
            if (!date) return false;
            return moment(date).isBefore();
        },
        getToday: function getToday() {
            return this.atMidnight(moment());
        },
        getTodayWithTime: function getTodayWithTime() {
            return moment();
        },
        atMidnight: function atMidnight(date) {
            return moment(date).hours(0).minutes(0).seconds(0).milliseconds(0);
        },
        getDateStatus: function getDateStatus(currentDay) {
            if (currentDay.isBefore(this.getToday())) {
                return 'past';
            } else if (currentDay.isAfter(this.getToday())) {
                return 'future';
            } else {
                return 'today';
            }
        },
        getStartOrScheduledDate: function getStartOrScheduledDate(planItem) {
            return planItem.startDate || planItem.scheduledStartDate;
        },
        getEndOrDueDate: function getEndOrDueDate(planItem) {
            var date = planItem.endDate || planItem.dueDate;
            if (date && planItem.type === "xlrelease.Release" && ReleasesStatusService.isReleaseInProgress(planItem)) {
                date = Math.max(date, this.getTodayWithTime().valueOf());
            }
            return date;
        },
        checkDatesValidator: function checkDatesValidator(form) {
            return function () {
                if (form) {
                    var dueDate = form.dueDate;
                    var scheduledStartDate = form.scheduledStartDate;

                    if (dueDate && scheduledStartDate) {
                        form.hasValidDates = scheduledStartDate <= dueDate;
                    }
                }
            };
        }
    };
}

/***/ }),
/* 710 */,
/* 711 */,
/* 712 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var VariableConstants = exports.VariableConstants = {
    type: {
        string: { id: 'StringVariable', key: 'xlrelease.StringVariable', label: 'Text' },
        dropDownListBox: { id: 'DropDownListBox', key: 'xlrelease.StringVariable', label: 'List box',
            valueProvider: 'xlrelease.ListOfStringValueProviderConfiguration'
        },
        passwordString: { id: 'PasswordStringVariable', key: 'xlrelease.PasswordStringVariable', label: 'Password' },
        boolean: { id: 'BooleanVariable', key: 'xlrelease.BooleanVariable', label: 'Checkbox (boolean)' },
        integer: { id: 'IntegerVariable', key: 'xlrelease.IntegerVariable', label: 'Number (integer)' },
        listString: { id: 'ListStringVariable', key: 'xlrelease.ListStringVariable', label: 'List' },
        date: { id: 'DateVariable', key: 'xlrelease.DateVariable', label: 'Date' },
        mapStringString: { id: 'MapStringStringVariable', key: 'xlrelease.MapStringStringVariable', label: 'Key-value map' },
        setString: { id: 'SetStringVariable', key: 'xlrelease.SetStringVariable', label: 'Set' }
    },
    basicValueProvider: {
        listOfStringConfiguration: 'xlrelease.ListOfStringValueProviderConfiguration',
        scriptConfiguration: 'xlrelease.ScriptValueProviderConfiguration'
    }
};

/***/ }),
/* 713 */,
/* 714 */,
/* 715 */,
/* 716 */,
/* 717 */,
/* 718 */,
/* 719 */,
/* 720 */,
/* 721 */,
/* 722 */,
/* 723 */,
/* 724 */,
/* 725 */,
/* 726 */,
/* 727 */,
/* 728 */,
/* 729 */,
/* 730 */,
/* 731 */,
/* 732 */,
/* 733 */,
/* 734 */,
/* 735 */,
/* 736 */,
/* 737 */,
/* 738 */,
/* 739 */,
/* 740 */,
/* 741 */,
/* 742 */,
/* 743 */,
/* 744 */,
/* 745 */,
/* 746 */,
/* 747 */,
/* 748 */,
/* 749 */,
/* 750 */,
/* 751 */,
/* 752 */,
/* 753 */,
/* 754 */,
/* 755 */,
/* 756 */,
/* 757 */,
/* 758 */,
/* 759 */,
/* 760 */,
/* 761 */,
/* 762 */,
/* 763 */,
/* 764 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _riskProfileController = __webpack_require__(1625);

var _riskProfileController2 = _interopRequireDefault(_riskProfileController);

var _riskSettingsController = __webpack_require__(1643);

var _riskSettingsController2 = _interopRequireDefault(_riskSettingsController);

var _deleteRiskSettingsModalComponent = __webpack_require__(1644);

var _services = __webpack_require__(197);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = angular.module('xlrelease.riskSettings', []).controller('riskProfileController', _riskProfileController2.default).controller('riskSettingsController', _riskSettingsController2.default).component('deleteRiskSettingsModal', _deleteRiskSettingsModalComponent.DeleteRiskSettingsModal).service('RiskSettingsService', _services.RiskSettingsService).name;

/***/ }),
/* 765 */,
/* 766 */,
/* 767 */,
/* 768 */,
/* 769 */,
/* 770 */,
/* 771 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 772 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NO_OP_SCM_CONNECTOR = undefined;

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DEFAULT_RISK_PROFILE_ID = 'Configuration/riskProfiles/RiskProfileDefault';
var NO_OP_SCM_CONNECTOR = exports.NO_OP_SCM_CONNECTOR = 'xlrelease.NoScmConnectorConfig';

var ReleasePropertiesFormController = function () {
    function ReleasePropertiesFormController(Backend, CurrentTimeZone, FlagService, Ids, PlanningDataEditorMixin, ReleasesService, UsersService, VariablesService, TemplatesService, ConfirmLeaveService, $scope, TagsService, $q, FoldersService) {
        var _this = this;

        (0, _classCallCheck3.default)(this, ReleasePropertiesFormController);

        this.updateSelectedFolder = function (folder) {
            _this.releaseForm.parentId = folder.selectedId;
            _this.$scope.$digest();
        };

        this.$scope = $scope;
        this._$q = $q;
        this._Backend = Backend;
        this._CurrentTimeZone = CurrentTimeZone;
        this._FlagService = FlagService;
        this._Ids = Ids;
        this._ReleasesService = ReleasesService;
        this._TemplatesService = TemplatesService;
        this._UsersService = UsersService;
        this._VariablesService = VariablesService;
        this._ConfirmLeaveService = ConfirmLeaveService;
        this._TagsService = TagsService;
        this._FoldersService = FoldersService;
        angular.extend(this, PlanningDataEditorMixin.withSaveCallback(_.noop)); // this really sucks... [oh, yeah...]

        this.lastUpdatedAt = null;
        this.variablesFilter = { showOnReleaseStart: true };
        this.allUsers = [];
        this.templates = [];
        this.riskProfiles = [];
        this.allTags = [];
        this._folders = [];
        this.foldersReady = false;

        this.ICS_ENDPOINT = 'calendar/subscribe/';

        this._selectedRiskProfile = undefined;
        this.updateFormWithTemplate = this.updateFormWithTemplate.bind(this);
        this.updateRiskProfile = this.updateRiskProfile.bind(this);
        this.onTemplateSelected = this.onTemplateSelected.bind(this);
    }

    (0, _createClass3.default)(ReleasePropertiesFormController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this2 = this;

            this.releaseForm = angular.copy(this.release);
            this._FoldersService.list(false).then(function (result) {
                _this2._folders = result.data;
                if (_this2.releaseForm.templateId && _this2._Ids.isInFolder(_this2.releaseForm.templateId)) {
                    _this2.releaseForm.parentId = _this2._Ids.getParentId(_this2._Ids.toDomainId(_this2.releaseForm.templateId));
                }
                _this2.foldersReady = true;
            });

            this.planning.initPlanningData(this.releaseForm, this.release);

            // create copy of release to be used as the form?
            this._UsersService.getAllUsers().then(function (response) {
                _this2.allUsers = response.data;
            });

            this._TagsService.getReleaseTags().then(function (allTags) {
                _this2.allTags = allTags;
            });

            if (this.isRelease() && !this.isNewRelease()) {
                this._initTemplateAndParentReleaseProperties(this.release);
                this._initCalendarURL(this.release);
            }

            if (this.isNewRelease()) {
                _.set(this.releaseForm, ['syntheticProperties', 'riskProfile'], DEFAULT_RISK_PROFILE_ID);
            }

            this._allVariables = [];

            this.loadVariables(this.release);

            var loadTemplates = function loadTemplates() {
                if (_this2.isRelease()) {
                    return _this2._TemplatesService.getAllIds().then(function (response) {
                        _this2.templates = _.sortBy(response.data.cis, 'title');
                    });
                } else {
                    return _this2._$q.resolve();
                }
            };

            var loadRiskProfiles = function loadRiskProfiles() {
                return _this2._Backend.get('api/v1/risks/profiles');
            };

            loadTemplates().then(function () {
                loadRiskProfiles().then(function (riskProfilesResponse) {
                    var hasValidRiskProfile = function hasValidRiskProfile() {
                        var riskProfile = _.get(_this2.releaseForm, ['syntheticProperties', 'riskProfile']);
                        return _.some(_this2.riskProfiles, { id: riskProfile });
                    };

                    var getTemplateRiskProfileOrDefault = function getTemplateRiskProfileOrDefault() {
                        var maybeTemplate = _.find(_this2.templates, { id: _this2.releaseForm.templateId });
                        return _.get(maybeTemplate, ['syntheticProperties', 'riskProfile'], DEFAULT_RISK_PROFILE_ID);
                    };

                    _this2.riskProfiles = _.sortBy(riskProfilesResponse.data, ['title']);
                    if (!hasValidRiskProfile()) {
                        var riskProfile = _this2.isRelease() ? getTemplateRiskProfileOrDefault() : DEFAULT_RISK_PROFILE_ID;
                        _.set(_this2.releaseForm, ['syntheticProperties', 'riskProfile'], riskProfile);
                    }

                    _this2.releaseFormOrig = angular.copy(_this2.releaseForm);
                });
            });

            this.templateHandlers = { addCandidates: this._addTplCandidates.bind(this) };
            this.riskProfileHandlers = { addCandidates: this._addRiskProfileCandidates.bind(this) };
        }
    }, {
        key: '_addTplCandidates',
        value: function _addTplCandidates(_ref) {
            var metadata = _ref.metadata,
                objLabel = _ref.objLabel,
                value = _ref.value;

            return _promise2.default.resolve(this.templates.filter(function (item) {
                return item.title.toLowerCase().indexOf(value.toLowerCase()) > -1;
            }));
        }
    }, {
        key: '_addRiskProfileCandidates',
        value: function _addRiskProfileCandidates(_ref2) {
            var metadata = _ref2.metadata,
                objLabel = _ref2.objLabel,
                value = _ref2.value;

            return _promise2.default.resolve(this.riskProfiles.filter(function (item) {
                return item.title.toLowerCase().indexOf(value.toLowerCase()) > -1;
            }));
        }
    }, {
        key: '$onChanges',
        value: function $onChanges(changes) {
            if (changes.release) {
                _.assign(this.releaseFormOrig, changes.release.currentValue);
                angular.copy(this.releaseForm, this.releaseFormOrig);
            }
        }
    }, {
        key: 'isTemplate',
        value: function isTemplate() {
            return this._ReleasesService.isTemplate(this.release);
        }
    }, {
        key: 'isRelease',
        value: function isRelease() {
            //NOTE: Do not use the following:
            //this._ReleasesService.isRelease(this.release);
            return !this.isTemplate(); // Yes this is the correct statement!
        }
    }, {
        key: 'isNewRelease',
        value: function isNewRelease() {
            return this._ReleasesService.isNewRelease(this.release);
        }
    }, {
        key: 'isReleaseArchived',
        value: function isReleaseArchived() {
            return this._ReleasesService.isReleaseArchived(this.release);
        }
    }, {
        key: 'isReleaseStarted',
        value: function isReleaseStarted() {
            return this.release.status ? !this._ReleasesService.isReleasePlanned(this.releaseForm) : false;
        }
    }, {
        key: 'hasValidDates',
        value: function hasValidDates() {
            return !!this.releaseForm.scheduledStartDate && !!this.releaseForm.dueDate ? this.releaseForm.scheduledStartDate <= this.releaseForm.dueDate : true;
        }
    }, {
        key: 'updateFormWithTemplate',
        value: function updateFormWithTemplate(title, pristine) {
            if (!pristine && !title) {
                this.updateFormWithoutTemplate();
            }
        }
    }, {
        key: 'onTemplateSelected',
        value: function onTemplateSelected(template) {
            var _this3 = this;

            var templateId = template.id;
            this._ReleasesService.getTemplateDuration(templateId).then(function (response) {
                var now = moment();
                var due = moment(now).add(response.data / 60, 'minutes');
                _this3.release.dueDate = due;
                _this3.release.scheduledStartDate = now;
                _this3._ReleasesService.getRelease(templateId).then(function (resp) {
                    var fromTemplate = resp.data;
                    var riskProfileFromTemplate = fromTemplate.syntheticProperties.riskProfile || DEFAULT_RISK_PROFILE_ID;
                    // if no longer found, fall back to default
                    if (!_.find(_this3.riskProfiles, { id: riskProfileFromTemplate })) {
                        riskProfileFromTemplate = DEFAULT_RISK_PROFILE_ID;
                    }

                    var parentId = _this3.releaseForm.parentId;
                    _this3.releaseForm = _.assign({}, _this3.release, {
                        title: _this3.releaseForm.title,
                        templateId: fromTemplate.id,
                        syntheticProperties: {
                            riskProfile: riskProfileFromTemplate
                        },
                        description: fromTemplate.description,
                        tags: fromTemplate.tags,
                        abortOnFailure: fromTemplate.abortOnFailure,
                        scriptUsername: fromTemplate.scriptUsername,
                        scriptUserPassword: fromTemplate.scriptUserPassword,
                        variables: [],
                        parentId: parentId
                    });

                    _this3._VariablesService.getReleaseVariables(templateId).then(function (variablesResponse) {
                        _this3.releaseForm.variables = variablesResponse.data;
                    });
                });
            });
        }
    }, {
        key: 'loadVariables',
        value: function loadVariables(release) {
            var _this4 = this;

            this._VariablesService.getAllVariables(release.id).then(function (allVariables) {
                _this4.allVariables = allVariables;
            });
        }
    }, {
        key: 'updateFormWithoutTemplate',
        value: function updateFormWithoutTemplate() {
            this.releaseForm = this._ReleasesService.initNewRelease();
            this.releaseForm.syntheticProperties = {
                riskProfile: DEFAULT_RISK_PROFILE_ID
            };

            if (!this.$scope.$$phase) this.$scope.$apply(); // for clear template operation (it doesn't reevaluate scope if called from react context)
        }
    }, {
        key: 'resetForm',
        value: function resetForm() {
            this.releaseForm = angular.copy(this.releaseFormOrig);
            this._ConfirmLeaveService.disableConfirmation();
        }
    }, {
        key: 'downloadCalendar',
        value: function downloadCalendar() {
            this._ReleasesService.downloadCalendar(this.releaseForm);
        }
    }, {
        key: 'deleteAttachment',
        value: function deleteAttachment(attachment) {
            var _this5 = this;

            this._Backend.del('releases/' + this.releaseForm.id + '/attachments/' + attachment.id).then(function () {
                _.remove(_this5.releaseForm.attachments, function (candidate) {
                    return candidate.id === attachment.id;
                });
            });
        }
    }, {
        key: 'onFlagUpdate',
        value: function onFlagUpdate(flag) {
            this.releaseForm.flag.status = flag;
            if (!this._FlagService.isItemFlagged(this.releaseForm)) {
                this.releaseForm.flag.comment = '';
            }
        }
    }, {
        key: 'onUpdate',
        value: function onUpdate(releasePropertiesForm) {
            var _this6 = this;

            var updatePromise = this.onSave({ release: this.releaseForm });
            if (updatePromise) {
                updatePromise.then(function () {
                    _this6.lastUpdatedAt = moment().toDate();
                    _this6._ConfirmLeaveService.disableConfirmation();
                    releasePropertiesForm.$setPristine();
                });
            }
        }

        // private...

    }, {
        key: '_initTemplateAndParentReleaseProperties',
        value: function _initTemplateAndParentReleaseProperties(release) {
            var startedFromTaskId = release.startedFromTaskId;
            if (startedFromTaskId) {
                this.releaseForm.startedFromReleaseId = this._Ids.releaseIdFrom(startedFromTaskId);
                this.releaseForm.startedFromReleaseTitle = release.startedFromTaskReleaseTitle;
            }
            var templateId = release.originTemplateId;
            if (templateId) {
                this.releaseForm.createdFromTemplateId = templateId;
                this.releaseForm.createdFromTemplateTitle = release.originTemplateTitle;
            }
        }
    }, {
        key: '_initCalendarURL',
        value: function _initCalendarURL(release) {
            var _this7 = this;

            this._Backend.get('server/host').then(function (serverInfoResponse) {
                var host = serverInfoResponse.data.url;
                if (!host.match(/\/$/)) {
                    host += '/';
                }
                _this7.calendarUrl = host + _this7.ICS_ENDPOINT + release.calendarLinkToken;
            });
        }

        // getter/setters...

    }, {
        key: 'updateRiskProfile',
        value: function updateRiskProfile(title) {
            if (title) {
                var rp = this.riskProfiles.find(function (profile) {
                    return profile.title === title;
                });

                if (rp && rp.id !== this.releaseForm.syntheticProperties.riskProfile) {
                    this.releaseForm.syntheticProperties.riskProfile = rp.id;
                }
            }
        }

        // arrow functions for react2angular

    }, {
        key: 'allVariables',
        get: function get() {
            return this._allVariables;
        },
        set: function set(allVariables) {
            this._allVariables = allVariables;
        }
    }, {
        key: 'timeZone',
        get: function get() {
            return this._CurrentTimeZone.timeZone;
        }
    }, {
        key: 'attachmentUploadUrl',
        get: function get() {
            return 'upload/attachment/' + this.releaseForm.id;
        }
    }, {
        key: 'riskProfileTitleOfThisRelease',
        get: function get() {
            var _this8 = this;

            var maybeProfile = this.riskProfiles.find(function (profile) {
                return profile.id === _this8.releaseForm.syntheticProperties.riskProfile;
            });

            return maybeProfile ? maybeProfile.title : null;
        }
    }, {
        key: 'templateTitle',
        get: function get() {
            var _this9 = this;

            var maybeTemplate = this.templates.find(function (t) {
                return t.id === _this9.releaseForm.templateId;
            });

            return maybeTemplate ? maybeTemplate.title : null;
        }
    }, {
        key: 'selectedRiskProfile',
        get: function get() {
            return this._selectedRiskProfile;
        },
        set: function set(riskProfile) {
            this._selectedRiskProfile = riskProfile;
            var riskProfileId = _.get(riskProfile, 'id');
            _.set(this.releaseForm, ['syntheticProperties', 'riskProfile'], riskProfileId);
            this.$scope.releasePropertiesForm.riskProfile.$setValidity('required', !!riskProfileId);
        }
    }, {
        key: 'folders',
        get: function get() {
            return this._folders;
        }
    }]);
    return ReleasePropertiesFormController;
}();

ReleasePropertiesFormController.$inject = ['Backend', 'CurrentTimeZone', 'FlagService', 'Ids', 'PlanningDataEditorMixin', 'ReleasesService', 'UsersService', 'VariablesService', 'TemplatesService', 'ConfirmLeaveService', '$scope', 'TagsService', '$q', 'FoldersService'];

var ReleasePropertiesFormComponent = {
    bindings: {
        release: '<',
        readOnly: '<',
        onSave: '&',
        onCancel: '&'
    },
    controller: ReleasePropertiesFormController,
    templateUrl: 'static/8.6.1/xlr-components/release-properties-form-component/release-properties-form-partial.html'
};

angular.module('xlrelease').component('releasePropertiesForm', ReleasePropertiesFormComponent);

/***/ }),
/* 773 */
/***/ (function(module, exports) {

module.exports = "<div class=\"tooltip in\">\n    <div class=\"tooltip-arrow\"></div>\n    <div class=\"tooltip-inner\">\n        <div ng-init=\"live = $ctrl.releasesCount.live.byStatus\">\n            <p ng-if=\"live.PLANNED > 0\">\n                <i class=\"circle planned\"></i>\n                {{live.PLANNED}} Planned\n            </p>\n            <p ng-if=\"live.IN_PROGRESS > 0\">\n                <i class=\"circle in-progress\"></i>\n                {{live.IN_PROGRESS}} In progress\n            </p>\n            <p ng-if=\"live.PAUSED > 0\">\n                <i class=\"circle paused\"></i>\n                {{live.PAUSED}} Paused\n            </p>\n            <p ng-if=\"live.FAILED > 0\">\n                <i class=\"circle failed\"></i>\n                {{live.FAILED}} Failed\n            </p>\n            <p ng-if=\"live.FAILING > 0\">\n                <i class=\"circle failing\"></i>\n                {{live.FAILING}} Failing\n            </p>\n            <p ng-if=\"live.COMPLETED > 0\">\n                <i class=\"circle completed\"></i>\n                {{live.COMPLETED}} Completed\n            </p>\n            <p ng-if=\"live.ABORTED > 0\">\n                <i class=\"circle aborted\"></i>\n                {{live.ABORTED}} Aborted\n            </p>\n        </div>\n        <div ng-init=\"archived = $ctrl.releasesCount.archived.byStatus\">\n            <hr ng-if=\"$ctrl.releasesCount.live.total > 0 && $ctrl.releasesCount.archived.total > 0\"/>\n            <p ng-if=\"$ctrl.releasesCount.archived.total > 0\">\n                <i class=\"xl-icon archive-icon\"/> Archived\n            </p>\n            <p ng-if=\"archived.COMPLETED > 0\">\n                <i class=\"circle completed\"></i>\n                {{archived.COMPLETED}} Completed\n            </p>\n            <p ng-if=\"archived.ABORTED > 0\">\n                <i class=\"circle aborted\"></i>\n                {{archived.ABORTED}} Aborted\n            </p>\n        </div>\n    </div>\n</div>"

/***/ }),
/* 774 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.releaseProgressComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HTML = '\n<div class="release-progress-bar">\n    <span ng-style="{\'left\': $ctrl.percent/2 + \'%\'}" class="percent-number">{{$ctrl.percent}}%</span><span class="progress-text"> complete</span>\n    <div class="bar-container">\n        <div class="bar" ng-style="{\'width\': $ctrl.percent +\'%\'}"></div>\n    </div>\n</div>';

var ReleaseProgressCtrl = function () {
    function ReleaseProgressCtrl() {
        (0, _classCallCheck3.default)(this, ReleaseProgressCtrl);
    }

    (0, _createClass3.default)(ReleaseProgressCtrl, [{
        key: '$onInit',
        value: function $onInit() {
            this._percent = 0;
            this.calculate();
        }
    }, {
        key: '$onChanges',
        value: function $onChanges() {
            this.calculate();
        }
    }, {
        key: 'calculate',
        value: function calculate() {
            if (this.progress) {
                var totalTasks = this.progress.totalTasks;
                var totalRemainingTasks = this.progress.totalRemainingTasks;
                var tasksFinished = totalTasks - totalRemainingTasks;
                this.percent = tasksFinished === 0 ? 0 : Math.round(tasksFinished * 100 / totalTasks);
            } else if (this.calculatedPercent) {
                this.percent = this.calculatedPercent;
            }
        }
    }, {
        key: 'percent',
        get: function get() {
            return this._percent;
        },
        set: function set(percent) {
            this._percent = percent;
        }
    }]);
    return ReleaseProgressCtrl;
}();

ReleaseProgressCtrl.$inject = [];

var releaseProgressComponent = exports.releaseProgressComponent = {
    controller: ReleaseProgressCtrl,
    template: HTML,
    bindings: {
        progress: '<',
        calculatedPercent: '<'
    }
};

/***/ }),
/* 775 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.releaseStatusLabelComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HTML = '<div class="release-status">\n    <span class="label label-{{$ctrl.getClassSuffix()}}">{{$ctrl.getLabel()}}</span>\n    <span ng-if="$ctrl.isArchived()" class="label label-archived">Archived</span>\n</div>';

var ReleaseStatusLabelController = function () {
    function ReleaseStatusLabelController() {
        (0, _classCallCheck3.default)(this, ReleaseStatusLabelController);
    }

    (0, _createClass3.default)(ReleaseStatusLabelController, [{
        key: '$onInit',
        value: function $onInit() {
            this._mapping = {
                'IN_PROGRESS': { suffix: 'inprogress', label: 'In progress' },
                'FAILING': { suffix: 'warning-failing', label: 'Failing' },
                'PAUSED': { suffix: 'paused', label: 'Paused' },
                'FAILED': { suffix: 'warning-failed', label: 'Failed' },
                'PLANNED': { suffix: 'planned', label: 'Planned' },
                'ABORTED': { suffix: 'aborted', label: 'Aborted' },
                'COMPLETED': { suffix: 'completed', label: 'Completed' }
            };
        }
    }, {
        key: 'getClassSuffix',
        value: function getClassSuffix() {
            return this._mapping[this.release.status].suffix;
        }
    }, {
        key: 'getLabel',
        value: function getLabel() {
            return this._mapping[this.release.status].label;
        }
    }, {
        key: 'isArchived',
        value: function isArchived() {
            return this.showArchived && this.release && this.release.archived;
        }
    }]);
    return ReleaseStatusLabelController;
}();

ReleaseStatusLabelController.$inject = [];

var releaseStatusLabelComponent = exports.releaseStatusLabelComponent = {
    controller: ReleaseStatusLabelController,
    template: HTML,
    bindings: {
        release: '<',
        showArchived: '<'
    }
};

/***/ }),
/* 776 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defaultMapDispatchToThis = undefined;
exports.templateBuilder = templateBuilder;
exports.defaultMapStateThis = defaultMapStateThis;

var _releaseToWords = __webpack_require__(777);

var _releaseToWords2 = _interopRequireDefault(_releaseToWords);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function templateBuilder(title, body, actionName) {
    return "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">" + title + "</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.dismiss()\"><i class=\"xl-icon close-icon\"/></button>\n        <div class=\"clearfix\"/>\n    </div>\n    <div class=\"modal-body actions-modal\">      \n     " + body + "\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button save primary\" type=\"submit\" ng-click=\"$ctrl.action()\">" + actionName + "</button>\n    </div>\n";
}

function defaultMapStateThis(state) {
    return {
        selectedReleases: state.releaseOverview.selectedReleases,
        releases: (0, _releaseToWords2.default)(state.releaseOverview.selectedReleases.size)
    };
}

function defaultMapDispatchToThis(_action) {
    return function (dispatch) {
        return {
            action: function action() {
                dispatch(_action());
                this.dismiss();
            }
        };
    };
}
exports.defaultMapDispatchToThis = defaultMapDispatchToThis;

/***/ }),
/* 777 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = releasesToWords;

var _pluralize = __webpack_require__(198);

var _pluralize2 = _interopRequireDefault(_pluralize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function releasesToWords(number) {
    return number + ' ' + (0, _pluralize2.default)('release', number);
}

/***/ }),
/* 778 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _releaseGroupsActions = __webpack_require__(265);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseGroupsController = function () {
    function ReleaseGroupsController($scope, Events, Authenticator, $uibModal, $ngRedux) {
        (0, _classCallCheck3.default)(this, ReleaseGroupsController);

        this._$scope = $scope;
        this._Events = Events;
        this._$uibModal = $uibModal;
        this._Authenticator = Authenticator;
        this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.call(this, $uibModal))(this);
    }

    (0, _createClass3.default)(ReleaseGroupsController, [{
        key: '$onInit',
        value: function $onInit() {
            if (this.folder) {
                this.filters.folderId = this.folder.id;
            }
            this._initialFilters = this.filters;
            this._$scope.$emit(this._Events.permission.refresh);
            this.updateFilters(this._initialFilters);
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this._unsubscribe();
        }
    }, {
        key: '_mapDispatchToThis',
        value: function _mapDispatchToThis(uibModalService) {
            return function (dispatch) {
                return {
                    loadMoreGroups: function loadMoreGroups() {
                        dispatch((0, _releaseGroupsActions.getMoreGroups)());
                    },
                    updateFilters: function updateFilters(filters) {
                        dispatch((0, _releaseGroupsActions.setFilters)(filters, true));
                    },
                    deleteGroup: function deleteGroup() {
                        dispatch((0, _releaseGroupsActions.deleteGroup)(uibModalService));
                    }
                };
            };
        }
    }, {
        key: '_mapStateToThis',
        value: function _mapStateToThis(state) {
            var reducer = state.releaseGroups;
            return {
                groups: reducer.groups,
                loading: reducer.loading,
                hasMoreGroups: reducer.hasMoreGroups,
                filters: reducer.filters.toJS(),
                riskConfig: reducer.riskConfig
            };
        }
    }, {
        key: 'filtersChanged',
        value: function filtersChanged() {
            this.updateFilters(this.filters);
        }
    }, {
        key: 'isNewReleaseGroupButtonVisible',
        value: function isNewReleaseGroupButtonVisible() {
            return this._Authenticator.hasReleaseGroupEditPermission(this.folder);
        }
    }, {
        key: 'createReleaseGroup',
        value: function createReleaseGroup() {
            var _this = this;

            var modal = this._$uibModal.open({
                animation: false,
                component: 'createReleaseGroupModal',
                resolve: {
                    folder: function folder() {
                        return _this.folder;
                    }
                }
            });

            modal.result.then(function () {
                return _this.updateFilters(_this.filters);
            });
        }
    }, {
        key: 'hasGroups',
        value: function hasGroups() {
            return !!_.get(this.groups, 'size');
        }
    }]);
    return ReleaseGroupsController;
}();

ReleaseGroupsController.$inject = ['$scope', 'Events', 'Authenticator', '$uibModal', '$ngRedux'];
exports.default = ReleaseGroupsController;

/***/ }),
/* 779 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var ROLES_TYPES = exports.ROLES_TYPES = {
    RELEASE_ADMIN: 'Release Admin',
    TASK_OWNER: 'Task Owner',
    TASK_TEAM: 'Task Team',
    WATCHER: 'Watcher'
};

/***/ }),
/* 780 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.NotificationEventsMap = undefined;

var _map = __webpack_require__(221);

var _map2 = _interopRequireDefault(_map);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function buildEventsMap() {
    var map = new _map2.default();
    map.set('ACTIVE_TASK_ASSIGNED', 'Active task assigned');
    map.set('ACTIVE_TASK_UNASSIGNED', 'Active task unassigned');
    map.set('MANUAL_TASK_STARTED', 'Manual task started');
    map.set('MANUAL_TASK_STARTED_WITHOUT_OWNER', 'Manual task started without assignee');
    map.set('TASK_WAITING_FOR_INPUT', 'Task waiting for input');
    map.set('TASK_OVERDUE', 'Task overdue');
    map.set('TASK_DUE_SOON', 'Task due soon');
    map.set('TASK_FAILED', 'Task failed');
    map.set('TASK_FLAGGED', 'Task flagged');
    map.set('COMMENT_ADDED', 'Comment added');
    map.set('RELEASE_STARTED', 'Release started');
    map.set('RELEASE_COMPLETED', 'Release completed');
    map.set('RELEASE_FLAGGED', 'Release flagged');
    map.set('RELEASE_ABORTED', 'Release aborted');
    map.set('RELEASE_FAILED', 'Release failed');
    map.set('RELEASE_FAILING', 'Release failing');
    return map;
}

var NotificationEventsMap = exports.NotificationEventsMap = buildEventsMap();

/***/ }),
/* 781 */,
/* 782 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.convertUsersToView = convertUsersToView;
exports.convertUsersFromView = convertUsersFromView;
exports.convertRoleToTableView = convertRoleToTableView;

var _teamConstants = __webpack_require__(401);

function convertUsersToView(principals) {
    return principals.map(function (u) {
        return { name: u.username, fullName: u.fullName, type: _teamConstants.MemberType.PRINCIPAL };
    });
}

function convertUsersFromView(principalsView) {
    return principalsView.map(function (u) {
        return { username: u.name, fullName: u.fullName };
    });
}

function convertRoleToTableView(role) {
    return {
        id: role.role.id,
        name: role.role.name,
        principals: convertUsersToView(role.principals),
        removable: true,
        removeTitle: 'Delete role',
        action: {
            title: 'Edit role',
            type: 'EDIT',
            icon: 'xl-icon edit-icon'
        }
    };
}

/***/ }),
/* 783 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.startReleasesModal = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _releaseToWord = __webpack_require__(543);

var _releaseToWord2 = _interopRequireDefault(_releaseToWord);

var _pluralize = __webpack_require__(198);

var _pluralize2 = _interopRequireDefault(_pluralize);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-header">\n        <h4 class="modal-title pull-left" id="modal-title">Start {{$ctrl.pluralizeWord(\'releases\')}}</h4>\n        <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix"/>\n    </div>\n    <div class="modal-body actions-modal">      \n     <p>{{$ctrl.message()}}</p>\n    </div>\n    <div class="modal-footer">\n        <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n        <button class="button save primary" type="submit" ng-click="$ctrl.close()">Start</button>\n    </div>\n';

var StartReleasesModalController = function () {
    function StartReleasesModalController() {
        (0, _classCallCheck3.default)(this, StartReleasesModalController);
    }

    (0, _createClass3.default)(StartReleasesModalController, [{
        key: '$onInit',
        value: function $onInit() {
            this.selectedReleasesSize = this.resolve.selectedReleasesSize;
        }
    }, {
        key: 'pluralizeWord',
        value: function pluralizeWord(word) {
            return (0, _pluralize2.default)(word, this.selectedReleasesSize);
        }
    }, {
        key: 'message',
        value: function message() {
            if (this.selectedReleasesSize > 1) {
                return 'You are about to start ' + (0, _releaseToWord2.default)(this.selectedReleasesSize) + '. Team members will be notified and once releases start dates have been reached, the releases flow will commence.';
            }
            return 'You are about to start a release. Team members will be notified and once the release start date has been reached, the release flow will commence.';
        }
    }]);
    return StartReleasesModalController;
}();

StartReleasesModalController.$inject = [];

var startReleasesModal = exports.startReleasesModal = {
    bindings: {
        close: '&',
        dismiss: '&',
        resolve: '<'
    },
    controller: StartReleasesModalController,
    template: template
};

/***/ }),
/* 784 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

exports.default = filterAllowedActions;

var _lodash = __webpack_require__(79);

var _lodash2 = _interopRequireDefault(_lodash);

var _immutable = __webpack_require__(161);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function filterAllowedActions(filters) {
    var appliedFilters = (0, _keys2.default)(_lodash2.default.pickBy(filters, function (v) {
        return v === true;
    }));
    var plannedGroup = ['planned'];
    var allActiveGroup = ['inProgress', 'paused', 'failing', 'failed'];

    if (!_lodash2.default.isEmpty(_lodash2.default.intersection(appliedFilters, plannedGroup))) {
        return (0, _immutable.Map)({ start: true, abort: true });
    } else if (!_lodash2.default.isEmpty(_lodash2.default.intersection(appliedFilters, allActiveGroup))) {
        return (0, _immutable.Map)({ start: false, abort: true });
    }

    return (0, _immutable.Map)({ start: false, abort: false });
}

/***/ }),
/* 785 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.loadUsernames = loadUsernames;

var _http = __webpack_require__(88);

function loadUsernames(release) {
    return (0, _http.httpGET)('users/names').then(function (resp) {
        return resp.data;
    });
}

/***/ }),
/* 786 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.toDomainIdList = exports.selectFilters = undefined;

var _regenerator = __webpack_require__(92);

var _regenerator2 = _interopRequireDefault(_regenerator);

exports.getReleases = getReleases;
exports.getCount = getCount;
exports.getMoreReleases = getMoreReleases;
exports.getRisks = getRisks;
exports.updateFilters = updateFilters;
exports.afterBulkActionExecuted = afterBulkActionExecuted;
exports.doStartRelease = doStartRelease;
exports.doAbortRelease = doAbortRelease;
exports.startRelease = startRelease;
exports.groupRelease = groupRelease;
exports.abortRelease = abortRelease;
exports.getTags = getTags;
exports.default = root;

var _effects = __webpack_require__(80);

var _releaseOverviewActions = __webpack_require__(223);

var _services = __webpack_require__(327);

var _services2 = __webpack_require__(197);

var _releaseOverviewReducerSelectors = __webpack_require__(1922);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _releaseToWords = __webpack_require__(777);

var _releaseToWords2 = _interopRequireDefault(_releaseToWords);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _marked = /*#__PURE__*/_regenerator2.default.mark(getReleases),
    _marked2 = /*#__PURE__*/_regenerator2.default.mark(getCount),
    _marked3 = /*#__PURE__*/_regenerator2.default.mark(getMoreReleases),
    _marked4 = /*#__PURE__*/_regenerator2.default.mark(getRisks),
    _marked5 = /*#__PURE__*/_regenerator2.default.mark(showToaster),
    _marked6 = /*#__PURE__*/_regenerator2.default.mark(updateFilters),
    _marked7 = /*#__PURE__*/_regenerator2.default.mark(afterBulkActionExecuted),
    _marked8 = /*#__PURE__*/_regenerator2.default.mark(doStartRelease),
    _marked9 = /*#__PURE__*/_regenerator2.default.mark(doAbortRelease),
    _marked10 = /*#__PURE__*/_regenerator2.default.mark(startRelease),
    _marked11 = /*#__PURE__*/_regenerator2.default.mark(groupRelease),
    _marked12 = /*#__PURE__*/_regenerator2.default.mark(abortRelease),
    _marked13 = /*#__PURE__*/_regenerator2.default.mark(getTags),
    _marked14 = /*#__PURE__*/_regenerator2.default.mark(root);

var selectFilters = exports.selectFilters = function selectFilters(state) {
    return state.releaseOverview.filters;
};

function getReleases() {
    var config, filters, response;
    return _regenerator2.default.wrap(function getReleases$(_context) {
        while (1) {
            switch (_context.prev = _context.next) {
                case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return (0, _effects.call)(_services2.fetchRiskConfig);

                case 3:
                    config = _context.sent;
                    _context.next = 6;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.RELEASES_PRE_LOAD });

                case 6:
                    _context.next = 8;
                    return (0, _effects.select)(_releaseOverviewReducerSelectors.getFilters);

                case 8:
                    filters = _context.sent;
                    _context.next = 11;
                    return (0, _effects.call)(_services.fetchReleases, filters, 0);

                case 11:
                    response = _context.sent;
                    _context.next = 14;
                    return (0, _effects.put)({
                        type: _releaseOverviewActions.actionTypes.RELEASES_SUCCEEDED,
                        payload: {
                            page: response.data.page,
                            releases: response.data.cis,
                            riskConfig: config.data
                        }
                    });

                case 14:
                    _context.next = 20;
                    break;

                case 16:
                    _context.prev = 16;
                    _context.t0 = _context["catch"](0);
                    _context.next = 20;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.RELEASES_FAILED });

                case 20:
                case "end":
                    return _context.stop();
            }
        }
    }, _marked, this, [[0, 16]]);
}

function getCount() {
    var filters, response;
    return _regenerator2.default.wrap(function getCount$(_context2) {
        while (1) {
            switch (_context2.prev = _context2.next) {
                case 0:
                    _context2.prev = 0;
                    _context2.next = 3;
                    return (0, _effects.select)(_releaseOverviewReducerSelectors.getFilters);

                case 3:
                    filters = _context2.sent;
                    _context2.next = 6;
                    return (0, _effects.call)(_services.fetchCount, filters);

                case 6:
                    response = _context2.sent;
                    _context2.next = 9;
                    return (0, _effects.put)({
                        type: _releaseOverviewActions.actionTypes.COUNT_SUCCEEDED,
                        payload: {
                            releasesCount: response.data
                        }
                    });

                case 9:
                    _context2.next = 15;
                    break;

                case 11:
                    _context2.prev = 11;
                    _context2.t0 = _context2["catch"](0);
                    _context2.next = 15;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.COUNT_FAILED });

                case 15:
                case "end":
                    return _context2.stop();
            }
        }
    }, _marked2, this, [[0, 11]]);
}

function getMoreReleases() {
    var pageNumber, filters, response;
    return _regenerator2.default.wrap(function getMoreReleases$(_context3) {
        while (1) {
            switch (_context3.prev = _context3.next) {
                case 0:
                    _context3.prev = 0;
                    _context3.next = 3;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.RELEASES_PRE_LOAD });

                case 3:
                    _context3.next = 5;
                    return (0, _effects.select)(_releaseOverviewReducerSelectors.getPageNumber);

                case 5:
                    pageNumber = _context3.sent;
                    _context3.next = 8;
                    return (0, _effects.select)(_releaseOverviewReducerSelectors.getFilters);

                case 8:
                    filters = _context3.sent;
                    _context3.next = 11;
                    return (0, _effects.call)(_services.fetchReleases, filters, pageNumber);

                case 11:
                    response = _context3.sent;
                    _context3.next = 14;
                    return (0, _effects.put)({
                        type: _releaseOverviewActions.actionTypes.MORE_RELEASES_SUCCEEDED, payload: { page: response.data.page, releases: response.data.cis }
                    });

                case 14:
                    _context3.next = 20;
                    break;

                case 16:
                    _context3.prev = 16;
                    _context3.t0 = _context3["catch"](0);
                    _context3.next = 20;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.MORE_RELEASES_FAILED });

                case 20:
                case "end":
                    return _context3.stop();
            }
        }
    }, _marked3, this, [[0, 16]]);
}

function getRisks(action) {
    var response;
    return _regenerator2.default.wrap(function getRisks$(_context4) {
        while (1) {
            switch (_context4.prev = _context4.next) {
                case 0:
                    _context4.prev = 0;
                    _context4.next = 3;
                    return (0, _effects.call)(_services.fetchRisks, action.payload);

                case 3:
                    response = _context4.sent;
                    _context4.next = 6;
                    return (0, _effects.put)({
                        type: _releaseOverviewActions.actionTypes.RISKS_SUCCEEDED, payload: {
                            riskScore: response.data.score,
                            risks: response.data.riskAssessments
                        }
                    });

                case 6:
                    _context4.next = 12;
                    break;

                case 8:
                    _context4.prev = 8;
                    _context4.t0 = _context4["catch"](0);
                    _context4.next = 12;
                    return (0, _effects.put)({
                        type: _releaseOverviewActions.actionTypes.RISKS_REQUEST_FAILED
                    });

                case 12:
                case "end":
                    return _context4.stop();
            }
        }
    }, _marked4, this, [[0, 8]]);
}

function showToaster(requestedNum, updatedNum, type) {
    var msg;
    return _regenerator2.default.wrap(function showToaster$(_context5) {
        while (1) {
            switch (_context5.prev = _context5.next) {
                case 0:
                    msg = type === _releaseOverviewActions.actionTypes.DO_START_RELEASES ? 'started' : 'aborted';

                    if (!(updatedNum === -1)) {
                        _context5.next = 6;
                        break;
                    }

                    _context5.next = 4;
                    return (0, _effects.call)(toaster.warning, "Couldn\u2019t perform the action on selected releases as they have been changed");

                case 4:
                    _context5.next = 13;
                    break;

                case 6:
                    if (!(updatedNum !== requestedNum)) {
                        _context5.next = 11;
                        break;
                    }

                    _context5.next = 9;
                    return (0, _effects.call)(toaster.warning, "You have " + msg + " only " + (0, _releaseToWords2.default)(updatedNum));

                case 9:
                    _context5.next = 13;
                    break;

                case 11:
                    _context5.next = 13;
                    return (0, _effects.call)(toaster.success, "You have successfully " + msg + " " + (0, _releaseToWords2.default)(updatedNum));

                case 13:
                case "end":
                    return _context5.stop();
            }
        }
    }, _marked5, this);
}

function updateFilters(action) {
    var payload;
    return _regenerator2.default.wrap(function updateFilters$(_context6) {
        while (1) {
            switch (_context6.prev = _context6.next) {
                case 0:
                    payload = action.payload;
                    _context6.next = 3;
                    return (0, _effects.put)({
                        type: _releaseOverviewActions.actionTypes.UPDATE_FILTERS_SUCCEEDED, payload: { filters: payload.filters }
                    });

                case 3:
                    _context6.next = 5;
                    return (0, _effects.call)(getCount);

                case 5:
                    if (!payload.loadReleases) {
                        _context6.next = 10;
                        break;
                    }

                    _context6.next = 8;
                    return (0, _effects.call)(getReleases);

                case 8:
                    _context6.next = 10;
                    return (0, _effects.call)(getTags);

                case 10:
                case "end":
                    return _context6.stop();
            }
        }
    }, _marked6, this);
}

function afterBulkActionExecuted(response, requestedNum, type) {
    var updatedNum;
    return _regenerator2.default.wrap(function afterBulkActionExecuted$(_context7) {
        while (1) {
            switch (_context7.prev = _context7.next) {
                case 0:
                    updatedNum = response.data.updatedIds && response.data.updatedIds.length || -1;
                    _context7.next = 3;
                    return (0, _effects.put)({
                        type: _releaseOverviewActions.actionTypes.AFTER_BULK_ACTION_EXECUTED,
                        payload: response.data
                    });

                case 3:
                    _context7.next = 5;
                    return (0, _effects.call)(getReleases);

                case 5:
                    _context7.next = 7;
                    return (0, _effects.call)(showToaster, requestedNum, updatedNum, type);

                case 7:
                case "end":
                    return _context7.stop();
            }
        }
    }, _marked7, this);
}

function doStartRelease(action) {
    var response;
    return _regenerator2.default.wrap(function doStartRelease$(_context8) {
        while (1) {
            switch (_context8.prev = _context8.next) {
                case 0:
                    _context8.next = 2;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.BULK_ACTION_STARTED });

                case 2:
                    _context8.prev = 2;
                    _context8.next = 5;
                    return (0, _effects.call)(_services.startReleases, toDomainIdList(action.payload.toArray()));

                case 5:
                    response = _context8.sent;
                    _context8.next = 8;
                    return (0, _effects.call)(afterBulkActionExecuted, response, action.payload.size, action.type);

                case 8:
                    _context8.prev = 8;
                    _context8.next = 11;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.BULK_ACTION_STOPPED });

                case 11:
                    return _context8.finish(8);

                case 12:
                case "end":
                    return _context8.stop();
            }
        }
    }, _marked8, this, [[2,, 8, 12]]);
}

function doAbortRelease(action) {
    var response;
    return _regenerator2.default.wrap(function doAbortRelease$(_context9) {
        while (1) {
            switch (_context9.prev = _context9.next) {
                case 0:
                    _context9.next = 2;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.BULK_ACTION_STARTED });

                case 2:
                    _context9.prev = 2;
                    _context9.next = 5;
                    return (0, _effects.call)(_services.abortReleases, toDomainIdList(action.payload.toArray()));

                case 5:
                    response = _context9.sent;
                    _context9.next = 8;
                    return (0, _effects.call)(afterBulkActionExecuted, response, action.payload.size, action.type);

                case 8:
                    _context9.prev = 8;
                    _context9.next = 11;
                    return (0, _effects.put)({ type: _releaseOverviewActions.actionTypes.BULK_ACTION_STOPPED });

                case 11:
                    return _context9.finish(8);

                case 12:
                case "end":
                    return _context9.stop();
            }
        }
    }, _marked9, this, [[2,, 8, 12]]);
}

function startRelease(action) {
    return _regenerator2.default.wrap(function startRelease$(_context10) {
        while (1) {
            switch (_context10.prev = _context10.next) {
                case 0:
                    _context10.next = 2;
                    return (0, _effects.call)(action.uibModalService.open, {
                        animation: false,
                        component: 'startReleases'
                    });

                case 2:
                case "end":
                    return _context10.stop();
            }
        }
    }, _marked10, this);
}

function groupRelease(action) {
    return _regenerator2.default.wrap(function groupRelease$(_context11) {
        while (1) {
            switch (_context11.prev = _context11.next) {
                case 0:
                    _context11.next = 2;
                    return (0, _effects.call)(action.payload.uibModalService.open, {
                        animation: false,
                        component: 'addReleaseToReleaseGroupModal',
                        resolve: {
                            data: {
                                releases: action.payload.selectedReleases.toJS()
                            }
                        }
                    });

                case 2:
                case "end":
                    return _context11.stop();
            }
        }
    }, _marked11, this);
}

function abortRelease(action) {
    return _regenerator2.default.wrap(function abortRelease$(_context12) {
        while (1) {
            switch (_context12.prev = _context12.next) {
                case 0:
                    _context12.next = 2;
                    return (0, _effects.call)(action.uibModalService.open, {
                        animation: false,
                        component: 'abortReleases'
                    });

                case 2:
                case "end":
                    return _context12.stop();
            }
        }
    }, _marked12, this);
}

function getTags() {
    var response, tags, archivedTags, filters, responseArchived, combinedTags;
    return _regenerator2.default.wrap(function getTags$(_context13) {
        while (1) {
            switch (_context13.prev = _context13.next) {
                case 0:
                    _context13.next = 2;
                    return (0, _effects.call)(_services.fetchReleaseTags);

                case 2:
                    response = _context13.sent;
                    tags = response.data;
                    archivedTags = [];
                    _context13.next = 7;
                    return (0, _effects.select)(selectFilters);

                case 7:
                    filters = _context13.sent;

                    if (!(filters.get('completed') || filters.get('aborted'))) {
                        _context13.next = 13;
                        break;
                    }

                    _context13.next = 11;
                    return (0, _effects.call)(_services.fetchArchivedReleaseTags);

                case 11:
                    responseArchived = _context13.sent;

                    archivedTags = responseArchived.data;

                case 13:
                    combinedTags = tags.concat(archivedTags.filter(function (tag) {
                        return !tags.includes(tag);
                    }));
                    _context13.next = 16;
                    return (0, _effects.put)((0, _releaseOverviewActions.fetchTagsSucceeded)(combinedTags));

                case 16:
                case "end":
                    return _context13.stop();
            }
        }
    }, _marked13, this);
}

var toaster = (0, _toastrFactory2.default)();
var Ids = (0, _ids2.default)();
var toDomainIdList = exports.toDomainIdList = function toDomainIdList(items) {
    return items.map(function (item) {
        return Ids.toDomainId(item);
    });
};

function root() {
    return _regenerator2.default.wrap(function root$(_context14) {
        while (1) {
            switch (_context14.prev = _context14.next) {
                case 0:
                    _context14.next = 2;
                    return (0, _effects.all)([(0, _effects.takeEvery)(_releaseOverviewActions.actionTypes.MORE_RELEASES_REQUESTED, getMoreReleases), (0, _effects.takeEvery)(_releaseOverviewActions.actionTypes.RISKS_REQUESTED, getRisks), (0, _effects.takeEvery)(_releaseOverviewActions.actionTypes.UPDATE_FILTERS_REQUESTED, updateFilters), (0, _effects.takeLatest)(_releaseOverviewActions.actionTypes.START_RELEASES, startRelease), (0, _effects.takeLatest)(_releaseOverviewActions.actionTypes.GROUP_RELEASES, groupRelease), (0, _effects.takeLatest)(_releaseOverviewActions.actionTypes.DO_START_RELEASES, doStartRelease), (0, _effects.takeLatest)(_releaseOverviewActions.actionTypes.ABORT_RELEASES, abortRelease), (0, _effects.takeLatest)(_releaseOverviewActions.actionTypes.DO_ABORT_RELEASES, doAbortRelease), (0, _effects.takeLatest)(_releaseOverviewActions.actionTypes.FETCH_TAGS_REQUESTED, getTags)]);

                case 2:
                case "end":
                    return _context14.stop();
            }
        }
    }, _marked14, this);
}

/***/ }),
/* 787 */,
/* 788 */,
/* 789 */,
/* 790 */,
/* 791 */,
/* 792 */,
/* 793 */,
/* 794 */,
/* 795 */,
/* 796 */,
/* 797 */,
/* 798 */,
/* 799 */,
/* 800 */,
/* 801 */,
/* 802 */,
/* 803 */,
/* 804 */,
/* 805 */,
/* 806 */,
/* 807 */,
/* 808 */,
/* 809 */,
/* 810 */,
/* 811 */,
/* 812 */,
/* 813 */,
/* 814 */,
/* 815 */,
/* 816 */,
/* 817 */,
/* 818 */,
/* 819 */,
/* 820 */,
/* 821 */,
/* 822 */,
/* 823 */,
/* 824 */,
/* 825 */,
/* 826 */,
/* 827 */,
/* 828 */,
/* 829 */,
/* 830 */,
/* 831 */,
/* 832 */,
/* 833 */,
/* 834 */,
/* 835 */,
/* 836 */,
/* 837 */,
/* 838 */,
/* 839 */,
/* 840 */,
/* 841 */,
/* 842 */,
/* 843 */,
/* 844 */,
/* 845 */,
/* 846 */,
/* 847 */,
/* 848 */,
/* 849 */,
/* 850 */,
/* 851 */,
/* 852 */,
/* 853 */,
/* 854 */,
/* 855 */,
/* 856 */,
/* 857 */,
/* 858 */,
/* 859 */,
/* 860 */,
/* 861 */,
/* 862 */,
/* 863 */,
/* 864 */,
/* 865 */,
/* 866 */,
/* 867 */,
/* 868 */,
/* 869 */,
/* 870 */,
/* 871 */,
/* 872 */,
/* 873 */,
/* 874 */,
/* 875 */,
/* 876 */,
/* 877 */,
/* 878 */,
/* 879 */,
/* 880 */,
/* 881 */,
/* 882 */,
/* 883 */,
/* 884 */,
/* 885 */,
/* 886 */,
/* 887 */,
/* 888 */,
/* 889 */,
/* 890 */,
/* 891 */,
/* 892 */,
/* 893 */,
/* 894 */,
/* 895 */,
/* 896 */,
/* 897 */,
/* 898 */,
/* 899 */,
/* 900 */,
/* 901 */,
/* 902 */,
/* 903 */,
/* 904 */,
/* 905 */,
/* 906 */,
/* 907 */,
/* 908 */,
/* 909 */,
/* 910 */,
/* 911 */,
/* 912 */,
/* 913 */,
/* 914 */,
/* 915 */,
/* 916 */,
/* 917 */,
/* 918 */,
/* 919 */,
/* 920 */,
/* 921 */,
/* 922 */,
/* 923 */,
/* 924 */,
/* 925 */,
/* 926 */,
/* 927 */,
/* 928 */,
/* 929 */,
/* 930 */,
/* 931 */,
/* 932 */,
/* 933 */,
/* 934 */,
/* 935 */,
/* 936 */,
/* 937 */,
/* 938 */,
/* 939 */,
/* 940 */,
/* 941 */,
/* 942 */,
/* 943 */,
/* 944 */,
/* 945 */,
/* 946 */,
/* 947 */,
/* 948 */,
/* 949 */,
/* 950 */,
/* 951 */,
/* 952 */,
/* 953 */,
/* 954 */,
/* 955 */,
/* 956 */,
/* 957 */,
/* 958 */,
/* 959 */,
/* 960 */,
/* 961 */,
/* 962 */,
/* 963 */,
/* 964 */,
/* 965 */,
/* 966 */,
/* 967 */,
/* 968 */,
/* 969 */,
/* 970 */,
/* 971 */,
/* 972 */,
/* 973 */,
/* 974 */,
/* 975 */,
/* 976 */,
/* 977 */,
/* 978 */,
/* 979 */,
/* 980 */,
/* 981 */,
/* 982 */,
/* 983 */,
/* 984 */,
/* 985 */,
/* 986 */,
/* 987 */,
/* 988 */,
/* 989 */,
/* 990 */,
/* 991 */,
/* 992 */,
/* 993 */,
/* 994 */,
/* 995 */,
/* 996 */,
/* 997 */,
/* 998 */,
/* 999 */,
/* 1000 */,
/* 1001 */,
/* 1002 */,
/* 1003 */,
/* 1004 */,
/* 1005 */,
/* 1006 */,
/* 1007 */,
/* 1008 */,
/* 1009 */,
/* 1010 */,
/* 1011 */,
/* 1012 */,
/* 1013 */,
/* 1014 */,
/* 1015 */,
/* 1016 */,
/* 1017 */,
/* 1018 */,
/* 1019 */,
/* 1020 */,
/* 1021 */,
/* 1022 */,
/* 1023 */,
/* 1024 */,
/* 1025 */,
/* 1026 */,
/* 1027 */,
/* 1028 */,
/* 1029 */,
/* 1030 */,
/* 1031 */,
/* 1032 */,
/* 1033 */,
/* 1034 */,
/* 1035 */,
/* 1036 */,
/* 1037 */,
/* 1038 */,
/* 1039 */,
/* 1040 */,
/* 1041 */,
/* 1042 */,
/* 1043 */,
/* 1044 */,
/* 1045 */,
/* 1046 */,
/* 1047 */,
/* 1048 */,
/* 1049 */,
/* 1050 */,
/* 1051 */,
/* 1052 */,
/* 1053 */,
/* 1054 */,
/* 1055 */,
/* 1056 */,
/* 1057 */,
/* 1058 */,
/* 1059 */,
/* 1060 */,
/* 1061 */,
/* 1062 */,
/* 1063 */,
/* 1064 */,
/* 1065 */,
/* 1066 */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(1067);
module.exports = __webpack_require__(1963);


/***/ }),
/* 1067 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(1068);

__webpack_require__(538);

var _confirmLeave = __webpack_require__(1703);

var _confirmLeave2 = _interopRequireDefault(_confirmLeave);

var _releaseOverview = __webpack_require__(1712);

var _releaseOverview2 = _interopRequireDefault(_releaseOverview);

var _releaseListModal = __webpack_require__(1740);

var _releaseListModal2 = _interopRequireDefault(_releaseListModal);

var _releaseGroups = __webpack_require__(1751);

var _releaseGroups2 = _interopRequireDefault(_releaseGroups);

var _releaseGroupsDetails = __webpack_require__(1767);

var _releaseGroupsDetails2 = _interopRequireDefault(_releaseGroupsDetails);

var _notifications = __webpack_require__(1779);

var _notifications2 = _interopRequireDefault(_notifications);

var _releaseGrid = __webpack_require__(1789);

var _releaseGrid2 = _interopRequireDefault(_releaseGrid);

var _iframe = __webpack_require__(1820);

var _iframe2 = _interopRequireDefault(_iframe);

var _teams = __webpack_require__(1823);

var _teams2 = _interopRequireDefault(_teams);

var _templateLabel = __webpack_require__(1825);

var _templateLabel2 = _interopRequireDefault(_templateLabel);

var _exportContentButton = __webpack_require__(1829);

var _exportContentButton2 = _interopRequireDefault(_exportContentButton);

var _taskList = __webpack_require__(1833);

var _taskList2 = _interopRequireDefault(_taskList);

var _roles = __webpack_require__(1836);

var _roles2 = _interopRequireDefault(_roles);

var _folders = __webpack_require__(1846);

var _folders2 = _interopRequireDefault(_folders);

var _appConfig = __webpack_require__(1912);

var _xlreleaseStarter = __webpack_require__(1944);

var _xlreleaseStarter2 = _interopRequireDefault(_xlreleaseStarter);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

var _alerts = __webpack_require__(398);

var _alerts2 = _interopRequireDefault(_alerts);

var _dateService = __webpack_require__(709);

var _dateService2 = _interopRequireDefault(_dateService);

var _releasesStatusService = __webpack_require__(196);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

var _orderSelector = __webpack_require__(1945);

var _orderSelector2 = _interopRequireDefault(_orderSelector);

var _modalHeader = __webpack_require__(1948);

var _modalHeader2 = _interopRequireDefault(_modalHeader);

var _configuration = __webpack_require__(1949);

var _configuration2 = _interopRequireDefault(_configuration);

var _riskSettings = __webpack_require__(764);

var _riskSettings2 = _interopRequireDefault(_riskSettings);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// xlrelease module is defined in xlrelease-module.js.template

angular.module('xlrelease').value('XLRelease', { version: '8.6.1' });

angular.module('xlrelease').config(['$httpProvider', function ($httpProvider) {
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/json';
}]);

angular.module('xlrelease').filter('mediumDateShortTime', ['dateFilter', '$locale', function (dateFilter, $locale) {
    return function (input) {
        return dateFilter(input, $locale.DATETIME_FORMATS.mediumDate + " " + $locale.DATETIME_FORMATS.shortTime);
    };
}]);

angular.module('xlrelease').factory('Ids', _ids2.default);
angular.module('xlrelease').factory('Toastr', _toastrFactory2.default);
angular.module('xlrelease').factory('XlReleaseStarter', _xlreleaseStarter2.default);
angular.module('xlrelease').factory('Alerts', _alerts2.default);
angular.module('xlrelease').factory('DateService', _dateService2.default);
angular.module('xlrelease').factory('ReleasesStatusService', _releasesStatusService2.default);
angular.module('xlrelease').component('orderSelector', _orderSelector2.default);
angular.module('xlrelease').component('modalHeader', _modalHeader2.default);
angular.module('xlrelease').config(_appConfig.xlreleaseConfig);
angular.module('xlrelease').run(_appConfig.xlreleaseRun);
angular.module('xlrelease').config(['$qProvider', '$locationProvider', '$compileProvider', function ($qProvider, $locationProvider) {
    $qProvider.errorOnUnhandledRejections(false);
    $locationProvider.hashPrefix('');
}]);

var modulesList = ['xlrelease', _confirmLeave2.default, _releaseOverview2.default, _releaseListModal2.default, _releaseGroups2.default, _releaseGroupsDetails2.default, _notifications2.default, _iframe2.default, _teams2.default, _templateLabel2.default, _releaseGrid2.default, _taskList2.default, _roles2.default, _folders2.default, _exportContentButton2.default, _configuration2.default, _riskSettings2.default];

angular.module('xlreleaseStartup', modulesList).run(['XlReleaseStarter', function (XlReleaseStarter) {
    return XlReleaseStarter.start();
}]);

/***/ }),
/* 1068 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(1069);

__webpack_require__(1070);

__webpack_require__(1074);

__webpack_require__(1075);

__webpack_require__(1096);

__webpack_require__(1099);

__webpack_require__(1100);

__webpack_require__(1101);

__webpack_require__(1102);

__webpack_require__(1104);

__webpack_require__(1119);

__webpack_require__(1120);

__webpack_require__(1121);

__webpack_require__(1122);

__webpack_require__(1123);

__webpack_require__(1124);

__webpack_require__(1125);

__webpack_require__(1126);

__webpack_require__(1127);

__webpack_require__(1128);

__webpack_require__(1129);

__webpack_require__(1130);

__webpack_require__(1131);

__webpack_require__(1132);

__webpack_require__(1133);

__webpack_require__(1134);

__webpack_require__(1135);

__webpack_require__(1144);

__webpack_require__(1145);

__webpack_require__(1146);

__webpack_require__(1147);

__webpack_require__(1148);

__webpack_require__(1149);

__webpack_require__(1150);

__webpack_require__(1151);

__webpack_require__(1152);

__webpack_require__(1153);

__webpack_require__(1154);

__webpack_require__(1155);

__webpack_require__(1156);

__webpack_require__(1157);

__webpack_require__(1158);

__webpack_require__(1159);

__webpack_require__(1160);

__webpack_require__(1161);

__webpack_require__(1162);

__webpack_require__(1163);

__webpack_require__(1164);

__webpack_require__(1165);

__webpack_require__(1166);

__webpack_require__(1167);

__webpack_require__(1168);

__webpack_require__(1169);

__webpack_require__(1170);

__webpack_require__(1171);

__webpack_require__(1172);

__webpack_require__(1173);

__webpack_require__(1174);

__webpack_require__(1175);

__webpack_require__(1176);

__webpack_require__(701);

__webpack_require__(1184);

__webpack_require__(1185);

__webpack_require__(1186);

__webpack_require__(1187);

__webpack_require__(1188);

__webpack_require__(1189);

__webpack_require__(1190);

__webpack_require__(1191);

__webpack_require__(1192);

__webpack_require__(1193);

__webpack_require__(1194);

__webpack_require__(1195);

__webpack_require__(1196);

__webpack_require__(1197);

__webpack_require__(1198);

__webpack_require__(1199);

__webpack_require__(1200);

__webpack_require__(1201);

__webpack_require__(1202);

__webpack_require__(1203);

__webpack_require__(1204);

__webpack_require__(1210);

__webpack_require__(1211);

__webpack_require__(1212);

__webpack_require__(1213);

__webpack_require__(1214);

__webpack_require__(1215);

__webpack_require__(1216);

__webpack_require__(1217);

__webpack_require__(1218);

__webpack_require__(1219);

__webpack_require__(1220);

__webpack_require__(1221);

__webpack_require__(1222);

__webpack_require__(1223);

__webpack_require__(1224);

__webpack_require__(1225);

__webpack_require__(1226);

__webpack_require__(1227);

__webpack_require__(1228);

__webpack_require__(1229);

__webpack_require__(1230);

__webpack_require__(1231);

__webpack_require__(1232);

__webpack_require__(1233);

__webpack_require__(1234);

__webpack_require__(1235);

__webpack_require__(1236);

__webpack_require__(1237);

__webpack_require__(1238);

__webpack_require__(1239);

__webpack_require__(1240);

__webpack_require__(1241);

__webpack_require__(1242);

__webpack_require__(1243);

__webpack_require__(1244);

__webpack_require__(1245);

__webpack_require__(1246);

__webpack_require__(1247);

__webpack_require__(1250);

__webpack_require__(1251);

__webpack_require__(1252);

__webpack_require__(1253);

__webpack_require__(1254);

__webpack_require__(1255);

__webpack_require__(1256);

__webpack_require__(1257);

__webpack_require__(1258);

__webpack_require__(1259);

__webpack_require__(1260);

__webpack_require__(1261);

__webpack_require__(1262);

__webpack_require__(1263);

__webpack_require__(1264);

__webpack_require__(1265);

__webpack_require__(1266);

__webpack_require__(1267);

__webpack_require__(1268);

__webpack_require__(1269);

__webpack_require__(1270);

__webpack_require__(1271);

__webpack_require__(1272);

__webpack_require__(1273);

__webpack_require__(1274);

__webpack_require__(1275);

__webpack_require__(1276);

__webpack_require__(1277);

__webpack_require__(1278);

__webpack_require__(1279);

__webpack_require__(1280);

__webpack_require__(515);

__webpack_require__(1281);

__webpack_require__(1286);

__webpack_require__(1287);

__webpack_require__(1288);

__webpack_require__(1289);

__webpack_require__(1290);

__webpack_require__(1291);

__webpack_require__(1292);

__webpack_require__(1294);

__webpack_require__(1295);

__webpack_require__(1297);

__webpack_require__(1298);

__webpack_require__(1299);

__webpack_require__(1300);

__webpack_require__(1301);

__webpack_require__(1302);

__webpack_require__(1303);

__webpack_require__(267);

__webpack_require__(1304);

__webpack_require__(1305);

__webpack_require__(1306);

__webpack_require__(1307);

__webpack_require__(1308);

__webpack_require__(1309);

__webpack_require__(1310);

__webpack_require__(1312);

__webpack_require__(1313);

__webpack_require__(1314);

__webpack_require__(1315);

__webpack_require__(1316);

__webpack_require__(1317);

__webpack_require__(1318);

__webpack_require__(1319);

__webpack_require__(1320);

__webpack_require__(1328);

__webpack_require__(764);

__webpack_require__(1645);

/***/ }),
/* 1069 */,
/* 1070 */,
/* 1071 */,
/* 1072 */,
/* 1073 */,
/* 1074 */,
/* 1075 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _from = __webpack_require__(308);

var _from2 = _interopRequireDefault(_from);

var _map = __webpack_require__(221);

var _map2 = _interopRequireDefault(_map);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var AuthenticationRegistry = function () {
    function AuthenticationRegistry() {
        (0, _classCallCheck3.default)(this, AuthenticationRegistry);

        this.providers = new _map2.default();
    }

    (0, _createClass3.default)(AuthenticationRegistry, [{
        key: 'provider',
        value: function provider(name, config) {
            this.providers.set(name, config);
        }
    }, {
        key: 'getProvider',
        value: function getProvider(name) {
            return this.providers.get(name);
        }
    }, {
        key: 'getProviders',
        value: function getProviders() {
            return _.sortBy((0, _from2.default)(this.providers.values()), 'order');
        }
    }, {
        key: 'getAutoProviders',
        value: function getAutoProviders() {
            return _.filter(this.getProviders(), 'autoLogin');
        }
    }, {
        key: 'getFormProviders',
        value: function getFormProviders() {
            return _.filter(this.getProviders(), 'formLogin');
        }
    }]);
    return AuthenticationRegistry;
}();

angular.module('xlrelease').service('AuthenticationRegistry', AuthenticationRegistry);
angular.module('xlrelease').run(['AuthenticationRegistry', '$state', 'RedirectOnLoginService', function (AuthenticationRegistry, $state, RedirectOnLoginService) {
    AuthenticationRegistry.provider('default', {
        order: 10,
        autoLogin: true,
        formLogin: false,
        login: function login() {
            RedirectOnLoginService.registerRequestedURL();
            $state.go('login');
            return true;
        }
    });
}]);

/***/ }),
/* 1076 */,
/* 1077 */,
/* 1078 */,
/* 1079 */,
/* 1080 */,
/* 1081 */,
/* 1082 */,
/* 1083 */,
/* 1084 */,
/* 1085 */,
/* 1086 */,
/* 1087 */,
/* 1088 */,
/* 1089 */,
/* 1090 */,
/* 1091 */,
/* 1092 */,
/* 1093 */,
/* 1094 */,
/* 1095 */,
/* 1096 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _getIterator2 = __webpack_require__(222);

var _getIterator3 = _interopRequireDefault(_getIterator2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').factory('Authenticator', ['$timeout', 'Backend', '$rootScope', '$location', 'Events', 'ForbiddenAccessService', 'ClientSettings', 'UserProfile', '$q', 'RedirectOnLoginService', 'PageUrls', 'UsersService', 'ViewStorage', '$state', 'AuthenticationRegistry', 'WindowLocation', 'EventBus', function ($timeout, Backend, $rootScope, $location, Events, ForbiddenAccessService, ClientSettings, UserProfile, $q, RedirectOnLoginService, PageUrls, UsersService, ViewStorage, $state, AuthenticationRegistry, WindowLocation, EventBus) {
    var ADMINISTRATOR = 'admin';
    var RELEASE_ADMIN_TEAM = 'Release Admin';

    function clearUserData() {
        ClientSettings.removeIdentityProvider();
        ClientSettings.removeAuthenticationData();
        ClientSettings.removePermissions();
        UserProfile.clear();
        ViewStorage.clear();
        EventBus.emitEvent(Events.folders.cleanCache);
    }

    function setCredentials(username) {
        var authenticationData = {
            username: username
        };

        ClientSettings.setAuthenticationData(authenticationData);
    }

    function setSecurity(security) {
        var permissions = security.global;
        if (!permissions) {
            permissions = [];
        }
        ClientSettings.setPermissions(permissions);
    }

    $rootScope.$on(Events.permission.unauthorized, function () {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = (0, _getIterator3.default)(AuthenticationRegistry.getAutoProviders()), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var provider = _step.value;

                if (provider.login(true)) {
                    break;
                }
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }
    });

    $rootScope.$on(Events.permission.forbidden, function (event, errorMessage) {
        var fallback = $location.search().fallback;
        if (fallback) {
            // wrapped in $timeout because if the request gets rejected in a resolve block think UI router blocks all transitions
            // should be able to trigger transition to fallback in a $stateChangeError event handler maybe?
            $timeout(function () {
                return $location.url(fallback);
            });
        } else {
            ForbiddenAccessService.errorMessage = errorMessage;
            $timeout(function () {
                return $location.url(PageUrls.FORBIDDEN_CONTENT_PAGE);
            });
        }
    });

    $rootScope.$on(Events.permission.refresh, function () {
        Backend.get('security').then(function (resp) {
            return setSecurity(resp.data);
        });
    });

    function isAdmin(permissions) {
        return UsersService.isUserNameAdmin(authenticationService.getUsername()) || _.includes(permissions, ADMINISTRATOR);
    }

    function hasAppropriatePermission(release, templatePermission, releasePermission) {
        if (release && release.status === 'TEMPLATE') {
            return authenticationService.hasPermission(templatePermission, release);
        }
        return release && authenticationService.hasPermission(releasePermission, release);
    }

    function hasPermission(permission, release) {
        var globalPermissions = ClientSettings.getPermissions();
        if (globalPermissions === null) {
            return false;
        }
        if (isAdmin(globalPermissions)) {
            return true;
        }

        var permissions = angular.isUndefined(release) ? globalPermissions : release.security.permissions;
        return _.includes(permissions, permission);
    }

    function loadUserDetails(username) {
        return Backend.get('security', { dontRedirectWhenForbidden: true, hideAlert: true }).then(function (response) {
            setSecurity(response.data);

            return UserProfile.load().then(function (profile) {
                return setCredentials(profile.username);
            }).catch(function (err) {
                // UserProfile is not mandatory on the server-side. Could potentially response with invalid JSON
                // Sets credentials by using user input or third-party plugin, like SPNEGO
                setCredentials(username);
                return err;
            });
        });
    }

    var authenticationService = {
        init: function init() {
            this.security = {
                isAuthenticated: authenticationService.isAuthenticated,
                getUsername: authenticationService.getUsername,
                hasPermission: authenticationService.hasPermission,
                hasViewPermission: authenticationService.hasViewPermission,
                hasEditPermission: authenticationService.hasEditPermission,
                hasEditTaskPermission: authenticationService.hasEditTaskPermission,
                hasReassignTaskPermission: authenticationService.hasReassignTaskPermission,
                hasEditSecurityPermission: authenticationService.hasEditSecurityPermission,
                hasReleaseGroupEditPermission: authenticationService.hasReleaseGroupEditPermission,
                isAdminOr: authenticationService.isAdminOr
            };

            $rootScope.security = this.security;
        },
        getUsername: function getUsername() {
            var authenticationData = ClientSettings.getAuthenticationData();
            return authenticationData !== null ? authenticationData.username : null;
        },
        isAuthenticated: function isAuthenticated() {
            return ClientSettings.getAuthenticationData() !== null;
        },

        hasPermission: hasPermission,
        hasEditGlobalVariablesPermission: function hasEditGlobalVariablesPermission() {
            return hasPermission('global_variables#edit');
        },
        hasViewPermission: function hasViewPermission(release) {
            return hasAppropriatePermission(release, 'template#view', 'release#view');
        },
        hasEditPermission: function hasEditPermission(release) {
            return hasAppropriatePermission(release, 'template#edit', 'release#edit');
        },
        hasEditTaskPermission: function hasEditTaskPermission(release) {
            return hasAppropriatePermission(release, 'template#edit', 'release#edit_task');
        },
        hasReassignTaskPermission: function hasReassignTaskPermission(release) {
            return hasAppropriatePermission(release, 'template#edit', 'release#reassign_task');
        },
        hasEditBlackoutPermission: function hasEditBlackoutPermission(release) {
            return hasAppropriatePermission(release, 'template#edit', 'release#edit_blackout');
        },
        hasEditFailureHandlerPermission: function hasEditFailureHandlerPermission(release) {
            return hasAppropriatePermission(release, 'template#edit_failure_handler', 'release#edit_failure_handler');
        },
        hasEditPreconditionPermission: function hasEditPreconditionPermission(release) {
            return hasAppropriatePermission(release, 'template#edit_precondition', 'release#edit_precondition');
        },
        hasLockTaskPermission: function hasLockTaskPermission(release) {
            return hasAppropriatePermission(release, 'template#lock_task', 'release#lock_task');
        },
        hasEditSecurityPermission: function hasEditSecurityPermission(release) {
            return this.hasPermission('security#edit') || hasAppropriatePermission(release, 'template#edit_security', 'release#edit_security');
        },
        hasPermissionToWorkOnTask: function hasPermissionToWorkOnTask(release, task) {
            if (release.archived) {
                return false;
            }
            return this.hasEditTaskPermission(release) || this.isAdminOr(task.owner) || this.isMemberOf(release, task.team);
        },

        //todo: refactor the permissions checker so template, release, and folders can use one method
        hasFolderPermission: function hasFolderPermission(permission, teams) {
            if (!this.isAdminOr(this.getUsername())) {
                var _iteratorNormalCompletion2 = true;
                var _didIteratorError2 = false;
                var _iteratorError2 = undefined;

                try {
                    for (var _iterator2 = (0, _getIterator3.default)(teams), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                        var team = _step2.value;

                        if (team.members.includes(this.getUsername()) && team.permissions.includes(permission)) {
                            return true;
                        }
                    }
                } catch (err) {
                    _didIteratorError2 = true;
                    _iteratorError2 = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                            _iterator2.return();
                        }
                    } finally {
                        if (_didIteratorError2) {
                            throw _iteratorError2;
                        }
                    }
                }

                return false;
            }

            return true;
        },
        hasReleaseGroupEditPermission: function hasReleaseGroupEditPermission(releaseGroup) {
            return this.hasPermission("group#edit", releaseGroup.$metadata);
        },

        isAdmin: isAdmin,
        isAdminOr: function isAdminOr(user) {
            var username = user ? user.username : undefined;
            var permissions = ClientSettings.getPermissions();
            return permissions !== null && (this.getUsername() === username || isAdmin(permissions));
        },
        isMemberOf: function isMemberOf(release, team) {
            var permissions = ClientSettings.getPermissions();
            if (permissions !== null && isAdmin(permissions)) {
                return true;
            }
            var releaseTeams = release.security.teams;

            return releaseTeams !== null && (_.includes(releaseTeams, RELEASE_ADMIN_TEAM) || _.includes(releaseTeams, team));
        },
        login: function login(username, password, rememberMe) {
            var deferred = $q.defer();
            var loginPromise = deferred.promise;
            clearUserData();
            Backend.post('login' + (rememberMe ? '?rememberMe=yes' : ''), { username: username, password: password }, null).then(function () {
                return loadUserDetails(username);
            }).then(function () {
                RedirectOnLoginService.redirect();
                $rootScope.$emit(Events.permission.loggedIn);
            }).catch(function (response) {
                return deferred.reject(response);
            });

            return loginPromise;
        },
        tryLoginByIdentityProvider: function tryLoginByIdentityProvider() {
            clearUserData();
            return this.loadUserDetailsByAuth().then(function () {
                RedirectOnLoginService.redirect();
            }).catch(function (err) {
                return err;
            });
        },


        // The method required by spnego plugin, see REL-5380 for details.
        loadUserDetailsByUsername: function loadUserDetailsByUsername(username) {
            clearUserData();
            return loadUserDetails(username).then(function () {
                RedirectOnLoginService.redirect();
                $rootScope.$emit(Events.permission.loggedIn);
            });
        },
        loadUserDetailsByAuth: function loadUserDetailsByAuth() {
            return Backend.get('auth', { dontRedirectWhenUnauthorized: true, hideAlert: true }).then(function (resp) {
                var identityProvider = resp.data.identityProvider;
                if (identityProvider) {
                    ClientSettings.setIdentityProvider(identityProvider);
                    return loadUserDetails(resp.data.userName).then(function () {
                        return $rootScope.$emit(Events.permission.loggedIn);
                    });
                } else {
                    return true;
                }
            });
        },
        logout: function logout() {
            return $q(function (resolve) {
                // Logout from IdP if needed.
                if (ClientSettings.getIdentityProvider()) {
                    var logoutUrl = ClientSettings.getIdentityProvider().logoutUrl;
                    clearUserData();
                    // Redirect to the IdP logoutUrl. This promise will never resolved.
                    WindowLocation.changeLocation(logoutUrl);
                } else {
                    clearUserData();
                    return Backend.get('logout').finally(resolve);
                }
            });
        }
    };

    return authenticationService;
}]);

/***/ }),
/* 1097 */,
/* 1098 */,
/* 1099 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('Base64', function () {
    var keyStr = 'ABCDEFGHIJKLMNOP' + 'QRSTUVWXYZabcdef' + 'ghijklmnopqrstuv' + 'wxyz0123456789+/' + '=';
    return {
        getBasicAuthorization: function getBasicAuthorization(username, password) {
            return 'Basic ' + this.encode(username + ':' + password);
        },
        encode: function encode(input) {
            var output = "";
            var chr1 = void 0,
                chr2 = void 0,
                chr3 = "";
            var enc1 = void 0,
                enc2 = void 0,
                enc3 = void 0,
                enc4 = "";
            var i = 0;

            do {
                chr1 = input.charCodeAt(i++);
                chr2 = input.charCodeAt(i++);
                chr3 = input.charCodeAt(i++);

                enc1 = chr1 >> 2;
                enc2 = (chr1 & 3) << 4 | chr2 >> 4;
                enc3 = (chr2 & 15) << 2 | chr3 >> 6;
                enc4 = chr3 & 63;

                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                } else if (isNaN(chr3)) {
                    enc4 = 64;
                }

                output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) + keyStr.charAt(enc4);
                chr1 = chr2 = chr3 = "";
                enc1 = enc2 = enc3 = enc4 = "";
            } while (i < input.length);

            return output;
        }
    };
});

/***/ }),
/* 1100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('RedirectOnLoginService', ['$location', 'PageUrls', '$state', function ($location, PageUrls, $state) {
    var redirectOnLoginURL = void 0;

    function hasRedirectOnLoginUrl() {
        return redirectOnLoginURL;
    }

    function isWorthRedirectingTo(pageUrl) {
        return pageUrl !== PageUrls.LOGIN_PAGE;
    }

    return {
        redirect: function redirect() {
            if (hasRedirectOnLoginUrl()) {
                $location.url(redirectOnLoginURL);
                redirectOnLoginURL = undefined;
            } else {
                $state.go('releaseOverview');
            }
        },
        registerRequestedURL: function registerRequestedURL() {
            if (!hasRedirectOnLoginUrl() && isWorthRedirectingTo($location.path())) {
                redirectOnLoginURL = $location.url();
            }
        }
    };
}]);

/***/ }),
/* 1101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _folderConstants = __webpack_require__(376);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var BreadcrumbsService = function () {
        function BreadcrumbsService($rootScope, Events, FolderPathService) {
            (0, _classCallCheck3.default)(this, BreadcrumbsService);

            this._$rootScope = $rootScope;
            this._Events = Events;
            this._FolderPathService = FolderPathService;
        }

        (0, _createClass3.default)(BreadcrumbsService, [{
            key: '_mapAndUpdateBreadcrumbs',
            value: function _mapAndUpdateBreadcrumbs(folders, ci) {
                var breadcrumbs = [];

                _.forEach(folders, function (folder) {
                    breadcrumbs.push({
                        pathSuffix: 'folders/' + folder.id + ('/' + _folderConstants.DEFAULT_FOLDER_TAB),
                        label: folder.title
                    });
                });

                breadcrumbs.push({
                    label: ci.title
                });

                this.updateBreadcrumbs(breadcrumbs, false);
            }
        }, {
            key: 'updateBreadcrumbs',
            value: function updateBreadcrumbs(breadcrumbs) {
                var dropFirstCrumb = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

                breadcrumbs = breadcrumbs.length > 1 && dropFirstCrumb ? _.drop(breadcrumbs) : breadcrumbs;
                this._$rootScope.$emit(this._Events.breadcrumbs.update, breadcrumbs);
            }
        }, {
            key: 'updateBreadcrumbsWithRelease',
            value: function updateBreadcrumbsWithRelease(release) {
                var _this = this;

                this._FolderPathService.getPathFromReleaseId(release.id).then(function (folders) {
                    _this._mapAndUpdateBreadcrumbs(folders, release);
                });
            }
        }, {
            key: 'updateBreadcrumbsWithReleaseGroup',
            value: function updateBreadcrumbsWithReleaseGroup(releaseGroup) {
                var _this2 = this;

                this._FolderPathService.getPathFromParentFolderId(releaseGroup.folderId).then(function (folders) {
                    _this2._mapAndUpdateBreadcrumbs(folders, releaseGroup);
                });
            }
        }, {
            key: 'updateBreadcrumbsWithFolder',
            value: function updateBreadcrumbsWithFolder(folder) {
                var _this3 = this;

                this._FolderPathService.getPathFromFolderId(folder.id).then(function (folders) {
                    _this3._mapAndUpdateBreadcrumbs(folders, folder);
                });
            }
        }, {
            key: 'updateBreadcrumbsWithRiskProfile',
            value: function updateBreadcrumbsWithRiskProfile(riskProfile) {
                var breadcrumbs = [];
                breadcrumbs.push({ pathSuffix: 'risks', label: 'Risk profile settings' });
                breadcrumbs.push({ label: riskProfile.title || "Create new risk profile " });
                this.updateBreadcrumbs(breadcrumbs, false);
            }
        }, {
            key: 'updateBreadcrumbsWithDashboard',
            value: function updateBreadcrumbsWithDashboard(dashboard) {
                var _this4 = this;

                this._FolderPathService.getPathFromParentFolderId(dashboard.parentId).then(function (folders) {
                    _this4._mapAndUpdateBreadcrumbs(folders, dashboard);
                });
            }
        }]);
        return BreadcrumbsService;
    }();

    BreadcrumbsService.$inject = ['$rootScope', 'Events', 'FolderPathService'];

    angular.module('xlrelease').service('BreadcrumbsService', BreadcrumbsService);
})();

/***/ }),
/* 1102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _angular = __webpack_require__(131);

var _angular2 = _interopRequireDefault(_angular);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SystemMessageService = function () {
    function SystemMessageService(Backend, $rootScope, Events) {
        (0, _classCallCheck3.default)(this, SystemMessageService);
        this.SYSTEM_MESSAGE_ID = 'Configuration/settings/SystemMessageSettings';

        this.Backend = Backend;
        this.$rootScope = $rootScope;
        this.Events = Events;
        this.systemMessage = undefined;
    }

    (0, _createClass3.default)(SystemMessageService, [{
        key: 'saveSystemMessage',
        value: function saveSystemMessage(systemMessage) {
            var _this = this;

            return this.Backend.put('settings/ci/' + this.SYSTEM_MESSAGE_ID, systemMessage).then(function (response) {
                _this.systemMessage = response.data;
                return _angular2.default.copy(_this.systemMessage);
            });
        }
    }, {
        key: 'loadSystemMessage',
        value: function loadSystemMessage() {
            var _this2 = this;

            return this.Backend.get('settings/system-message').then(function (response) {
                _this2.systemMessage = response.data;
                return _angular2.default.copy(_this2.systemMessage);
            });
        }
    }, {
        key: 'emitSystemMessage',
        value: function emitSystemMessage() {
            var _this3 = this;

            if (_angular2.default.isDefined(this.systemMessage)) {
                this.$rootScope.$emit(this.Events.settings.systemMessageUpdated, this.systemMessage);
            } else {
                this.loadSystemMessage().then(function (systemMessage) {
                    _this3.$rootScope.$emit(_this3.Events.settings.systemMessageUpdated, systemMessage);
                });
            }
        }
    }, {
        key: 'isMessageEnabled',
        value: function isMessageEnabled(systemMessage) {
            if (_angular2.default.isUndefined(systemMessage)) return false;
            return (!!systemMessage.automated && !!systemMessage.enabled && this._isInRange(systemMessage.startDate, systemMessage.endDate) || !systemMessage.automated && !!systemMessage.enabled) && !!systemMessage.message;
        }
    }, {
        key: '_isInRange',
        value: function _isInRange(startDate, endDate) {
            if (startDate === null || endDate === null) return false;
            var now = new Date();
            var range = moment().range(startDate, endDate);
            return range.contains(now);
        }
    }]);
    return SystemMessageService;
}();

SystemMessageService.$inject = ['Backend', '$rootScope', 'Events'];


_angular2.default.module('xlrelease').service('SystemMessageService', SystemMessageService);

/***/ }),
/* 1103 */,
/* 1104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(1105);

__webpack_require__(1106);

__webpack_require__(1109);

__webpack_require__(1110);

__webpack_require__(1111);

__webpack_require__(1112);

__webpack_require__(1113);

__webpack_require__(1114);

__webpack_require__(1115);

__webpack_require__(1116);

__webpack_require__(1117);

__webpack_require__(1118);

/***/ }),
/* 1105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CalendarService = function () {
    function CalendarService(Backend) {
        (0, _classCallCheck3.default)(this, CalendarService);

        this.Backend = Backend;
    }

    // BLACKOUTS

    (0, _createClass3.default)(CalendarService, [{
        key: 'getBlackout',
        value: function getBlackout(id) {
            return this.Backend.get(this._blackoutsUrl(id));
        }
    }, {
        key: 'getBlackouts',
        value: function getBlackouts(range) {
            var params = {
                from: range.from.valueOf(),
                to: range.to.valueOf()
            };
            return this.Backend.get(this._blackoutsUrl(), { params: params });
        }
    }, {
        key: 'saveBlackout',
        value: function saveBlackout(blackout) {
            return blackout.id ? this._updateBlackout(blackout) : this._createBlackout(blackout);
        }
    }, {
        key: 'deleteBlackout',
        value: function deleteBlackout(id) {
            return this.Backend.del(this._blackoutsUrl(id));
        }
    }, {
        key: '_createBlackout',
        value: function _createBlackout(blackout) {
            return this.Backend.post(this._blackoutsUrl(), this._toBlackoutForm(blackout));
        }
    }, {
        key: '_updateBlackout',
        value: function _updateBlackout(blackout) {
            return this.Backend.put(this._blackoutsUrl(blackout.id), this._toBlackoutForm(blackout));
        }
    }, {
        key: '_toBlackoutForm',
        value: function _toBlackoutForm(blackout) {
            return {
                id: blackout.id || null,
                type: 'xlrelease.Blackout',
                label: blackout.label,
                startDate: moment(blackout.startDate).toISOString(),
                endDate: moment(blackout.endDate).toISOString()
            };
        }

        // SPECIAL DAYS


    }, {
        key: 'getSpecialDay',
        value: function getSpecialDay(date) {
            return this.Backend.get(this._specialDaysUrl(date));
        }
    }, {
        key: 'setSpecialDay',
        value: function setSpecialDay(date, specialDay) {
            var params = {
                id: null,
                type: 'xlrelease.SpecialDay',
                label: specialDay.label,
                color: specialDay.color
            };
            return this.Backend.put(this._specialDaysUrl(date), params);
        }
    }, {
        key: 'getSpecialDays',
        value: function getSpecialDays(range) {
            var params = {
                from: range.from.valueOf(),
                to: range.to.valueOf()
            };
            return this.Backend.get(this._specialDaysUrl(), { params: params });
        }
    }, {
        key: 'specialDayId',
        value: function specialDayId(date) {
            return 'Configuration/Calendar/' + date.format('YYYYMMDD');
        }
    }, {
        key: 'withinBlackout',
        value: function withinBlackout() {
            return this.Backend.get(this._withinBlackoutUrl());
        }

        // PRIVATE

    }, {
        key: '_blackoutsUrl',
        value: function _blackoutsUrl(id) {
            return 'calendar/blackouts' + (id ? '/' + id : '');
        }
    }, {
        key: '_specialDaysUrl',
        value: function _specialDaysUrl(date) {
            return 'calendar/specialDays' + (date ? '/' + this.specialDayId(date) : '');
        }
    }, {
        key: '_withinBlackoutUrl',
        value: function _withinBlackoutUrl() {
            return 'calendar/blackouts/withinBlackout';
        }
    }]);
    return CalendarService;
}();

CalendarService.$inject = ['Backend'];


angular.module('xlrelease').service('CalendarService', CalendarService);

/***/ }),
/* 1106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').controller('CalendarController', ['$q', '$scope', '$location', 'CalendarDateService', 'DateService', 'ReleasesService', 'VariablesInterpolator', 'CalendarNavigator', 'ColorService', 'CalendarService', 'month', 'filterSettings', 'Events', 'ClientSettings', 'Filters', 'RegionalSettings', 'EventBus', '$uibModal', 'GlobalPermissions', 'Authenticator', 'TagsService', function ($q, $scope, $location, CalendarDateService, DateService, ReleasesService, VariablesInterpolator, CalendarNavigator, ColorService, CalendarService, month, filterSettings, Events, ClientSettings, Filters, RegionalSettings, EventBus, $uibModal, GlobalPermissions, Authenticator, TagsService) {
    var URL_DATE_FORMAT = "MM-YYYY";
    var RELEASE_ITEMS_LIMIT = 20;

    $scope.filters = filterSettings;
    $scope.currentDate = moment(month, URL_DATE_FORMAT).locale('en-user').date(1);
    $scope.weekDays = RegionalSettings.weekDays;
    $scope.allTags = [];

    $scope.$on(Events.filters.filterChanged, function (e, filters) {
        load();
        ClientSettings.setCalendarFilters(filters);
    });

    load();

    function load() {
        var calendar = new CalendarDateService($scope.currentDate);
        $scope.calendar = calendar;
        $q.all([getReleases(calendar), getSpecialDays(calendar), getBlackouts(calendar), TagsService.getReleaseTags()]).then(function (_ref) {
            var _ref2 = (0, _slicedToArray3.default)(_ref, 4),
                releases = _ref2[0],
                specialDays = _ref2[1],
                blackouts = _ref2[2],
                allTags = _ref2[3];

            calendar.updateReleases(releases);
            calendar.updateSpecialDays(specialDays);
            calendar.updateBlackouts(blackouts);

            $scope.months = calendar.months;
            $scope.weeks = calendar.weeks;
            $scope.allTags = allTags;
        });
    }

    function refreshBlackouts() {
        getBlackouts($scope.calendar).then(function (blackouts) {
            $scope.calendar.updateBlackouts(blackouts);
        });
    }

    $scope.refreshBlackouts = refreshBlackouts;

    function getReleases(calendar) {
        var filters = angular.copy($scope.filters);
        filters.from = calendar.from.toDate().getTime();
        filters.to = calendar.to.toDate().getTime();
        $scope.releasesDependencies = {};
        return ReleasesService.searchFull(filters, { params: { numberbypage: RELEASE_ITEMS_LIMIT } }).then(function (response) {
            var releases = _.reject(response.data.cis, 'tutorial');
            $scope.maxLimitReached = _.size(response.data.cis) === RELEASE_ITEMS_LIMIT;
            $scope.releasesVariables = _.fromPairs(_.map(releases, function (release) {
                return [release.id, release.variables];
            }));
            return releases;
        });
    }

    function getSpecialDays(calendar) {
        return CalendarService.getSpecialDays({ from: calendar.from, to: calendar.to }).then(function (response) {
            return response.data;
        });
    }

    function getBlackouts(calendar) {
        return CalendarService.getBlackouts({ from: calendar.from, to: calendar.to }).then(function (response) {
            return response.data;
        });
    }

    $scope.loadReleaseDetails = function (release) {
        if (!_.has($scope.releasesDependencies, release.id)) {
            $scope.loadingDetails = true;
            ReleasesService.getReleaseDependencies(release.id).then(function (response) {
                $scope.releasesDependencies[release.id] = response.data;
                $scope.loadingDetails = false;
            });
        }
    };

    $scope.getIncomingDependencies = function (releaseId) {
        return getDependenciesByType(releaseId, 'incomingDependencies');
    };

    $scope.getOutgoingDependencies = function (releaseId) {
        return getDependenciesByType(releaseId, 'outgoingDependencies');
    };

    function getDependenciesByType(releaseId, property) {
        var releaseDependencies = $scope.releasesDependencies[releaseId];
        return releaseDependencies ? releaseDependencies[property] : [];
    }

    $scope.showNavigator = CalendarNavigator.isNavigatorOpen();

    $scope.showDate = function (date) {
        $location.search('month', date.format(URL_DATE_FORMAT));
    };

    $scope.showToday = function () {
        $location.search('month', DateService.getToday().date(1).format(URL_DATE_FORMAT));
    };

    $scope.showPreviousMonth = function () {
        $location.search('month', moment($scope.currentDate).subtract(1, "months").format(URL_DATE_FORMAT));
    };

    $scope.showNextMonth = function () {
        $location.search('month', moment($scope.currentDate).add(1, "months").format(URL_DATE_FORMAT));
    };

    $scope.isCurrentMonth = function (month) {
        return month.fullDate.month() === $scope.currentDate.month() && month.fullDate.year() === $scope.currentDate.year();
    };

    $scope.interpolate = function (title, releaseId) {
        if (title) {
            return VariablesInterpolator.interpolateInText($scope.releasesVariables[releaseId], title);
        }
    };

    $scope.toggleNavigator = function () {
        $scope.showNavigator = CalendarNavigator.toggleNavigator();
    };

    $scope.openDay = function (day) {
        Filters.getCalendarFilterSettings().then(function (filters) {
            var from = moment(day.fullDate).startOf('day');
            filters = _.extend(filters, {
                from: from.toDate().getTime(),
                to: from.add(1, 'days').toDate().getTime(),
                fromCalendar: true
            });
            filters = Filters.asQueryString(filters);
            ReleasesService.redirectToOverview(filters);
        });
    };

    $scope.isReleaseCompleted = ReleasesService.isReleaseCompleted;
    $scope.downloadCalendar = ReleasesService.downloadCalendar;
    $scope.computeDayColor = ColorService.computeDayColor;
    $scope.computePhaseColor = ColorService.computePhaseColor;

    function openSpecialDayModal(data) {
        $uibModal.open({
            animation: false,
            component: 'specialDayModal',
            resolve: {
                day: data.day
            }
        }).result.then(function (specialDay) {
            data.day.label = specialDay.label;
            data.day.color = specialDay.color;
        });
    }

    function openBlackoutModal(data) {
        $uibModal.open({
            animation: false,
            component: 'blackoutEditModal',
            resolve: {
                date: data.day.fullDate
            }
        }).result.then(refreshBlackouts);
    }

    $scope.$on("$destroy", function () {
        EventBus.removeListener(Events.calendar.setLabel, openSpecialDayModal);
        EventBus.removeListener(Events.calendar.setBlackout, openBlackoutModal);
    });

    EventBus.addListener(Events.calendar.setLabel, openSpecialDayModal);
    EventBus.addListener(Events.calendar.setBlackout, openBlackoutModal);

    $scope.getContextMenuOptions = function (day) {
        var contextMenu = [{
            title: day.label ? 'Edit label' : 'Set label',
            eventType: Events.calendar.setLabel,
            data: { day: day },
            icon: 'xl-icon edit-icon',
            disabled: false
        }];
        if (Authenticator.hasPermission(GlobalPermissions.EDIT_GLOBAL_BLACKOUT)) {
            contextMenu.push({
                title: 'Set blackout period',
                eventType: Events.calendar.setBlackout,
                data: { day: day },
                icon: 'xl-icon circle-minus-icon',
                disabled: false
            });
        }
        return contextMenu;
    };
}]);

/***/ }),
/* 1107 */,
/* 1108 */,
/* 1109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('CalendarDateService', ['DateService', 'ReleasesService', 'Ids', 'CalendarService', 'Planner', function (DateService, ReleasesService, Ids, CalendarService, Planner) {

    var TOTAL_WEEKS_DISPLAYED = 6;
    var TOTAL_MONTHS_DISPLAYED = 20;
    var URL_DATE_FORMAT = "MM-YYYY";

    function CalendarDateService(date) {
        this.weeks = getWeeks(date);
        this.months = getMonths(date);
        this.from = moment(this.weeks[0].days[0].fullDate);
        this.to = moment(this.from).add(TOTAL_WEEKS_DISPLAYED, 'week');
    }

    CalendarDateService.prototype.updateReleases = function (releases) {
        updateReleases(releases, this.weeks);
    };

    CalendarDateService.prototype.updateBlackouts = function (blackouts) {
        updateBlackouts(blackouts, this.weeks);
    };

    CalendarDateService.prototype.updateSpecialDays = function (specialDays) {
        updateSpecialDays(specialDays, this.weeks);
    };

    CalendarDateService.currentMonth = function () {
        return DateService.getToday().date(1).format(URL_DATE_FORMAT);
    };

    // Visible for testing
    CalendarDateService.getNumberOfDaysAfter = function (startDate, firstDayOfWeek) {
        var diff = startDate.diff(firstDayOfWeek, 'days', true);
        return diff < 0 ? 0 : diff;
    };

    // Visible for testing
    CalendarDateService.getDuration = function (startDate, endDate, firstDay, lastDay) {
        return lastDay.diff(firstDay, 'days') - this.getNumberOfDaysAfter(startDate, firstDay) - this.getNumberOfDaysAfter(lastDay, endDate);
    };

    // Visible for testing
    CalendarDateService.isActiveDuringWeek = function (startDate, dueDate, firstDayOfWeek) {
        var lastDayOfWeek = moment(firstDayOfWeek).add(7, 'days');
        return startDate && dueDate && firstDayOfWeek.isBefore(dueDate) && lastDayOfWeek.isAfter(startDate);
    };

    function getWeeks(date) {
        var weeks = [];
        var day = moment(date).weekday(0); // first day of current week

        for (var weekIndex = 0; weekIndex < TOTAL_WEEKS_DISPLAYED; weekIndex++) {
            var firstDayOfWeek = DateService.atMidnight(moment(day).weekday(0));

            weeks.push({
                days: getDaysOfTheWeek(firstDayOfWeek),
                releases: [],
                blackouts: []
            });

            day.add(7, 'days');
        }

        return weeks;
    }

    function getDaysOfTheWeek(firstDayOfWeek) {
        var dayInWeek = moment(firstDayOfWeek);
        var days = [];
        for (var dayIndex = 0; dayIndex < 7; dayIndex++) {
            days.push({
                date: dayInWeek.date(),
                month: dayInWeek.format("MMMM"),
                dateStatus: DateService.getDateStatus(dayInWeek),
                fullDate: moment(dayInWeek),
                year: dayInWeek.format("YYYY")
            });
            dayInWeek.add(1, 'days');
        }
        return days;
    }

    function getMonths(date) {
        var firstDayOfCalendar = moment(date).date(1).subtract(TOTAL_MONTHS_DISPLAYED / 2 - 1, 'months');
        return getListOfMonths(TOTAL_MONTHS_DISPLAYED, firstDayOfCalendar);
    }

    function getListOfMonths(numberOfMonths, firstDayOfCalendar) {
        var months = [];
        var firstDayOfMonth = moment(firstDayOfCalendar);
        for (var i = 0; i < numberOfMonths; i++) {
            months.push({
                title: firstDayOfMonth.format("MMMM"),
                year: firstDayOfMonth.format("YYYY"),
                index: firstDayOfMonth.month(),
                fullDate: moment(firstDayOfMonth)
            });

            firstDayOfMonth.add(1, 'months');
        }

        return months;
    }

    function isInsideRelease(release, phase) {
        var releaseStartDate = DateService.getStartOrScheduledDate(release);
        var releaseEndDate = DateService.getEndOrDueDate(release);
        var phaseStartDate = DateService.getStartOrScheduledDate(phase);
        var phaseEndDate = DateService.getEndOrDueDate(phase);
        return moment(phaseStartDate).isBefore(moment(releaseEndDate)) && moment(phaseEndDate).isAfter(moment(releaseStartDate));
    }

    function updateReleases(releases, weeks) {
        var plannedReleases = _.map(releases, function (release) {
            Planner.setRelease(release);
            Planner.setReleaseTree(null);
            var plan = Planner.makePlan(false);
            return angular.extend(release, {
                startDate: plan.displayStartDate,
                endDate: plan.displayEndDate,
                plannedDuration: plan.displayDuration,
                phases: _.map(release.phases, function (phase) {
                    var phasePlan = _.find(plan.elements, function (elem) {
                        return elem.id === phase.id;
                    });
                    return angular.extend(phase, {
                        startDate: phasePlan.displayStartDate,
                        endDate: phasePlan.displayEndDate,
                        plannedDuration: phasePlan.displayDuration
                    });
                })
            });
        });
        _.forEach(weeks, function (week) {
            var firstDayOfWeek = week.days[0].fullDate;
            var lastDayOfWeek = moment(firstDayOfWeek).add(7, 'days');
            week.releases = getReleasesOfTheWeek(plannedReleases, firstDayOfWeek, lastDayOfWeek);
        });
    }

    function updateBlackouts(blackouts, weeks) {
        _.forEach(weeks, function (week) {
            var firstDayOfWeek = week.days[0].fullDate;
            var lastDayOfWeek = moment(firstDayOfWeek).add(7, 'days');
            week.blackouts = getBlackoutsOfTheWeek(blackouts, firstDayOfWeek, lastDayOfWeek);
        });
    }

    function updateSpecialDays(specialDays, weeks) {
        var specialDaysByDate = _.keyBy(specialDays, 'id');
        var days = _.flatMap(weeks, function (week) {
            return week.days;
        });
        _.forEach(days, function (day) {
            var specialDay = specialDaysByDate[CalendarService.specialDayId(day.fullDate)];
            if (specialDay) {
                day.color = specialDay.color;
                day.label = specialDay.label;
            }
        });
    }

    function getReleasesOfTheWeek(releases, firstDayOfWeek, lastDayOfWeek) {
        var releasesOfTheWeek = [];

        _.forEach(releases, function (release) {
            var startDate = moment(DateService.getStartOrScheduledDate(release));
            var endDate = moment(DateService.getEndOrDueDate(release));

            if (CalendarDateService.isActiveDuringWeek(startDate, endDate, firstDayOfWeek)) {
                var enhancedRelease = angular.copy(release);

                angular.extend(enhancedRelease, {
                    currentTask: release.currentTask ? release.currentTask.title : undefined,
                    leftDayOffset: CalendarDateService.getNumberOfDaysAfter(startDate, firstDayOfWeek),
                    numberOfDay: CalendarDateService.getDuration(startDate, endDate, firstDayOfWeek, lastDayOfWeek),
                    displayablePhases: getDisplayablePhases(enhancedRelease, firstDayOfWeek, lastDayOfWeek)
                });

                releasesOfTheWeek.push(enhancedRelease);
            }
        });
        return releasesOfTheWeek;
    }

    function getBlackoutsOfTheWeek(blackouts, firstDayOfWeek, lastDayOfWeek) {
        return _.flatMap(blackouts, function (blackout) {
            var startDate = moment(blackout.startDate);
            var endDate = moment(blackout.endDate);
            if (CalendarDateService.isActiveDuringWeek(startDate, endDate, firstDayOfWeek)) {
                var enhancedBlackout = angular.copy(blackout);

                angular.extend(enhancedBlackout, {
                    name: Ids.getName(blackout.id),
                    leftDayOffset: CalendarDateService.getNumberOfDaysAfter(startDate, firstDayOfWeek),
                    numberOfDay: CalendarDateService.getDuration(startDate, endDate, firstDayOfWeek, lastDayOfWeek)
                });

                return [enhancedBlackout];
            } else {
                return [];
            }
        });
    }

    function getDisplayablePhases(release, firstDayOfWeek, lastDayOfWeek) {
        var phases = release.phases;
        var phasesOfTheWeek = [];
        _.forEach(phases, function (phase) {
            if (DateService.getStartOrScheduledDate(phase) && DateService.getEndOrDueDate(phase)) {
                var dates = ReleasesService.cropToReleaseDate(phase, release);
                var startDate = dates.startDate;
                var endDate = dates.endDate;

                if (CalendarDateService.isActiveDuringWeek(startDate, endDate, firstDayOfWeek) && isInsideRelease(release, phase)) {
                    phase.leftDayOffset = CalendarDateService.getNumberOfDaysAfter(startDate, firstDayOfWeek);
                    phase.numberOfDay = CalendarDateService.getDuration(startDate, endDate, firstDayOfWeek, lastDayOfWeek);
                    phasesOfTheWeek.push(phase);
                }
            }
        });
        return phasesOfTheWeek;
    }

    return CalendarDateService;
}]);

/***/ }),
/* 1110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').value('CalendarConstants', {
    minWeekHeight: 130, // from less file - 1px of day border
    dayHeaderHeight: 34, // from less file is 26px + 8px of padding
    minDayContentHeight: 96, // 130 - 34 = 96
    blackoutHeaderMargins: 20, // left: 10, right: 10
    blackoutHeaderHeight: 30, // 26px + 4px over the top release
    dayPadding: 30, // == blackoutHeaderHeight so we don't need to redraw every release on first/last blackout in/out.
    dayNumberWidth: 18,
    releaseHeight: 26,
    border: 1
});

angular.module('xlrelease').factory('CalendarDisplay', ['DateService', 'CalendarConstants', function (DateService, CalendarConstants) {
    /**
     * Due to FireFox behavior, we can not use directly calendarContent.width() because it is not updated yet.
     * Instead we compute it by hand, according to navigator visibility.
     * In short: keep the Timeout call instead of scope.$evalAsync in resizeDays directive.
     */
    function computeContentWidth(calendarContent, isNavigatorVisible) {
        var calendar = calendarContent.parents("#calendar");
        var navigator = calendar.find("#navigator");
        var contentWidth = calendar.width() - (_.parseInt(calendarContent.css("padding-right")) + _.parseInt(calendarContent.css("padding-left")));
        if (isNavigatorVisible) {
            contentWidth = contentWidth - navigator.width();
        }
        return contentWidth;
    }

    function getDayOuterWidth(weekElement) {
        return (weekElement.width() - 1) / 7;
    }

    function getWidthAndPosition(weekContext, item, dayWidth) {
        var dayOuterWidth = dayWidth ? dayWidth : getDayOuterWidth(weekContext.weekElement);
        return {
            left: item.leftDayOffset * dayOuterWidth,
            width: item.numberOfDay * dayOuterWidth - 3 * CalendarConstants.border
        };
    }

    function getReleasesHeight(weekContext) {
        return weekContext.numberOfReleases() * CalendarConstants.releaseHeight + weekContext.numberOfPhases() * CalendarConstants.border;
    }

    function getDayContentHeight(weekContext) {
        var headerOffset = weekContext.hasBlackouts() ? CalendarConstants.blackoutHeaderHeight : CalendarConstants.dayPadding;
        return Math.max(getReleasesHeight(weekContext) + headerOffset, CalendarConstants.minDayContentHeight);
    }

    function getReleaseTopOffset(weekContext, index, isPhase) {
        var dayContentHeight = getDayContentHeight(weekContext);
        var releasesHeight = getReleasesHeight(weekContext);
        var releasesOffset = dayContentHeight + CalendarConstants.dayHeaderHeight - releasesHeight;
        var phaseOffset = isPhase ? CalendarConstants.border : 0;
        var offset = releasesOffset + (index * CalendarConstants.releaseHeight + phaseOffset);

        return offset;
    }

    function isPhase(item) {
        return item.type === "xlrelease.Phase";
    }

    return {
        getWeekContext: function getWeekContext(weekElement, weekScope) {
            return {
                weekElement: weekElement,
                hasBlackouts: function hasBlackouts() {
                    return weekScope.blackouts.length > 0;
                },
                numberOfReleases: function numberOfReleases() {
                    return weekScope.releases.length;
                },
                numberOfPhases: function numberOfPhases() {
                    return _.filter(weekScope.releases, isPhase).length;
                }
            };
        },
        positionBlackout: function positionBlackout(element, blackout, weekContext, dayWidth) {
            var dimensions = getWidthAndPosition(weekContext, blackout, dayWidth);
            element.css({
                top: CalendarConstants.dayHeaderHeight,
                left: dimensions.left,
                width: dimensions.width + 2 * CalendarConstants.border,
                height: getDayContentHeight(weekContext)
            });
            var header = element.find('.blackout-header');
            header.css({ 'max-width': dimensions.width - CalendarConstants.blackoutHeaderMargins });
            this.adjustWeekHeight(weekContext);
        },
        positionPlanItem: function positionPlanItem(element, planItem, weekContext, index, dayWidth) {
            var dimensions = getWidthAndPosition(weekContext, planItem, dayWidth);
            var leftOffset = planItem.isPhase ? CalendarConstants.border : 0;
            var topOffset = getReleaseTopOffset(weekContext, index, planItem.isPhase);
            element.css({
                top: topOffset,
                left: dimensions.left + leftOffset,
                width: dimensions.width
            });

            if (!isPhase) {
                this.resizeReleaseTitle(element);
            }
            this.adjustWeekHeight(weekContext);
        },
        adjustWeekHeight: function adjustWeekHeight(weekContext) {
            var dayContentHeight = getDayContentHeight(weekContext);
            var day = weekContext.weekElement.find('.day');
            var dayContent = day.find('.day-content');
            dayContent.height(dayContentHeight);
            day.height(dayContentHeight + CalendarConstants.dayHeaderHeight);
            weekContext.weekElement.height(dayContentHeight + CalendarConstants.dayHeaderHeight + CalendarConstants.border);
        },
        positionCurrentTime: function positionCurrentTime(element) {
            var dayWidth = element.parents('.day').outerWidth();
            var midnight = DateService.getToday();
            var currentTime = DateService.getTodayWithTime();

            var todayProgressRatio = currentTime.diff(midnight, 'days', true);
            var halfWidth = element.outerWidth() / 2.0;
            element.css('left', todayProgressRatio * dayWidth - halfWidth);
        },
        resizeDays: function resizeDays(calendarContent, isNavigatorVisible, weeks) {
            var _this = this;

            var calendarHeader = calendarContent.find("#days-name");
            var day = calendarContent.find(".day:first");

            var contentWidth = computeContentWidth(calendarContent, isNavigatorVisible);
            var dayPadding = _.parseInt(day.css("padding-right")) + _.parseInt(day.css("padding-left"));
            var dayWidth = contentWidth / 7;
            var dayWidthWithoutPadding = dayWidth - (dayPadding + CalendarConstants.border);

            calendarContent.find("#days").css({ "width": contentWidth + 1 });
            calendarHeader.css({ "width": contentWidth + CalendarConstants.border + 1 });
            calendarHeader.find("div").css({ "width": dayWidth });
            calendarHeader.find("div:last").css({ "width": dayWidth + CalendarConstants.border });
            calendarContent.find(".day").css({ "width": dayWidthWithoutPadding });
            calendarContent.find(".day-label").css({ "width": dayWidthWithoutPadding - CalendarConstants.dayNumberWidth });
            calendarContent.find(".day-number").css({ "width": CalendarConstants.dayNumberWidth });

            _.forEach(weeks, function (week, weekIdx) {
                var weekElement = calendarContent.find('.week:nth-child(' + (weekIdx + 1) + ')');
                var weekContext = _this.getWeekContext(weekElement, week);
                _.forEach(week.blackouts, function (blackout) {
                    var blackoutElement = weekElement.find('.blackout.blackout-' + blackout.name);
                    _this.positionBlackout(blackoutElement, blackout, weekContext, dayWidth);
                });
                _.forEach(week.releases, function (release, relIdx) {
                    var relElement = weekElement.find('.release.' + release.id);
                    _this.positionPlanItem(relElement, release, weekContext, relIdx, dayWidth);
                    _.forEach(release.phases, function (phase, phaseIdx) {
                        var phaseElement = weekElement.find('.' + phase.id);
                        _this.positionPlanItem(phaseElement, phase, weekContext, relIdx, dayWidth);
                    });
                });
            });
        },
        resizeReleaseTitle: function resizeReleaseTitle(element) {
            var title = element.find('.title');
            var paddingHzl = 2 * _.parseInt(title.css('left'));
            title.width(title.parents('.release').width() - paddingHzl);
        }
    };
}]);

angular.module('xlrelease').directive('positionBlackout', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element) {
        var weekContext = CalendarDisplay.getWeekContext(element.parent('.week'), scope.$parent.week);

        scope.$evalAsync(function () {
            CalendarDisplay.positionBlackout(element, scope.blackout, weekContext);
        });
    };
}]);

angular.module('xlrelease').directive('positionRelease', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element, attrs) {
        var weekContext = CalendarDisplay.getWeekContext(element.parent(), scope.$parent.week);
        var index = scope.$index;
        scope.release.isPhase = false;

        element.bind("mouseout mouseover", function () {
            element.parents('#days').find('.' + attrs.positionRelease).toggleClass('release-hover');
        });

        scope.$evalAsync(function () {
            CalendarDisplay.positionPlanItem(element, scope.release, weekContext, index);
        });
    };
}]);

angular.module('xlrelease').directive('positionPhase', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element) {
        var weekElement = element.parent().parent();
        var weekContext = CalendarDisplay.getWeekContext(weekElement, scope.$parent.week);
        var index = scope.$parent.$index;
        scope.phase.isPhase = true;

        scope.$evalAsync(function () {
            CalendarDisplay.positionPlanItem(element, scope.phase, weekContext, index);
        });
    };
}]);

angular.module('xlrelease').directive('adjustWeekHeight', ['CalendarDisplay', function (CalendarDisplay) {
    return function (scope, element) {
        var weekContext = CalendarDisplay.getWeekContext(element, scope.week);
        scope.$watch('weeks', function () {
            CalendarDisplay.adjustWeekHeight(weekContext);
        });
    };
}]);

angular.module('xlrelease').directive('positionCurrentTime', ['CalendarDisplay', 'Window', 'Timeout', 'Events', function (CalendarDisplay, Window, Timeout, Events) {
    return function (scope, element) {
        Timeout(function () {
            CalendarDisplay.positionCurrentTime(element);
        }, 0);

        Window.onResize(function () {
            CalendarDisplay.positionCurrentTime(element);
        }, scope);

        scope.$watch('showNavigator', function () {
            CalendarDisplay.positionCurrentTime(element);
        });

        scope.$on(Events.timeline.hasBeenResized, function () {
            CalendarDisplay.positionCurrentTime(element);
        });
    };
}]);

angular.module('xlrelease').directive('resizeDays', ['CalendarDisplay', 'Window', 'Timeout', function (CalendarDisplay, Window, Timeout) {
    return function (scope, element) {
        scope.$watchCollection('weeks', function () {
            scope.$evalAsync(function () {
                CalendarDisplay.resizeDays(element, scope.$parent.showNavigator, scope.$parent.weeks);
            });
        });

        Window.onResize(function () {
            CalendarDisplay.resizeDays(element, scope.$parent.showNavigator, scope.$parent.weeks);
        }, scope);

        scope.$watch('showNavigator', function (isNavigatorVisible) {
            Timeout(function () {
                CalendarDisplay.resizeDays(element, isNavigatorVisible, scope.$parent.weeks);
            });
        });
    };
}]);

/***/ }),
/* 1111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('CalendarResolver', ['$q', '$location', '$stateParams', '$state', 'CalendarDateService', function ($q, $location, $stateParams, $state, CalendarDateService) {
    return {
        initCurrentMonth: function initCurrentMonth() {
            var URL_DATE_PATTERN = "^[0-9]{2}-[0-9]{4}$";
            var deferred = $q.defer();

            var month = $location.search().month;
            if (!month || !month.match(URL_DATE_PATTERN)) {
                month = CalendarDateService.currentMonth();
                var searchParams = _.assign($location.search(), {
                    month: month
                });
                $location.search(searchParams).replace();
                deferred.reject('CALENDAR_MONTH_NOT_SET');
            } else {
                deferred.resolve(month);
            }

            return deferred.promise;
        }
    };
}]);

/***/ }),
/* 1112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * This service holds calendar navigator state (displayed / hidden)
 * Allows us to keep it in the same state even if the user has navigated back and forth in the app
 */
angular.module('xlrelease').factory('CalendarNavigator', function () {
    var showNavigator = false;

    return {
        toggleNavigator: function toggleNavigator() {
            showNavigator = !showNavigator;
            return showNavigator;
        },
        isNavigatorOpen: function isNavigatorOpen() {
            return showNavigator;
        }
    };
});

/***/ }),
/* 1113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('calendarTooltip', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function link(scope, tooltipElement, attrs) {
            var releaseElement = tooltipElement.parents('.release');
            releaseElement.qtip({
                content: releaseElement.find('.tooltip').contents(),
                position: {
                    my: 'bottom center',
                    at: 'top center',
                    target: 'mouse',
                    adjust: {
                        mouse: false
                    },
                    viewport: angular.element(window)
                },
                show: 'click',
                hide: 'unfocus',
                style: 'qtip-bootstrap',
                events: {
                    show: function show() {
                        if (attrs.onShow) {
                            scope.$apply(function () {
                                return $parse(attrs.onShow)(scope);
                            });
                        }
                    },
                    toggle: function toggle() {
                        return releaseElement.parents('#days').find('.' + scope.release.id).toggleClass('release-selected');
                    }

                }
            });

            releaseElement.on("$destroy", function () {
                releaseElement.qtip("destroy", true);
            });
        }
    };
}]);

angular.module('xlrelease').directive('calendarTooltipDependency', ['FlagService', function (FlagService) {
    return {
        restrict: 'A',
        link: function link(scope, element, attrs) {
            scope.$watch(attrs.dependency, function (dependency) {
                var type = attrs.type;
                element.on('mouseout mouseover', function () {
                    angular.element("#days " + '.' + dependency.releaseId).toggleClass(type + '-dependency-highlight');
                });
            });
            element.on('$destroy', function () {
                element.off('mouseout mouseover');
            });
            scope.isReleaseOrSubtaskFlagged = FlagService.isReleaseOrSubtaskFlagged;
        }
    };
}]);

/***/ }),
/* 1114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('displayReleaseTitle', ['FlagService', 'CalendarDisplay', 'ReleasesService', function (FlagService, CalendarDisplay, ReleasesService) {
    return {
        templateUrl: "partials/calendar/release-title.html",
        restrict: 'A',
        scope: {
            release: '='
        },
        link: function link(scope, element) {
            scope.isReleaseOrSubtaskFlagged = FlagService.isReleaseOrSubtaskFlagged;
            CalendarDisplay.resizeReleaseTitle(element);
        }
    };
}]);

/***/ }),
/* 1115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-content">\n        <div class="modal-header">\n            <button type="button" class="close" ng-click="$ctrl.dismiss()" aria-hidden="true"><i class="xl-icon close-icon"/></button>\n            <h4>Delete Blackout Period</h4>\n        </div>\n        <div class="modal-body">\n            <p>You are about to delete the blackout period <b>{{$ctrl.resolve.blackout.label}}</b>.</p>\n            \n            <p>Tasks with a scheduled start date set by the blackout period will retain the current scheduled start date.</p>\n        </div>\n        <div class="modal-footer">\n            <button type="button" class="button cancel" ng-click="$ctrl.dismiss()">Cancel</button>\n            <button type="button" class="button continue primary" focus-on="true" ng-click="$ctrl.del()">Delete</button>\n        </div>\n    </div>\n    ';

var BlackoutDeleteModalController = function () {
    function BlackoutDeleteModalController(CalendarService) {
        (0, _classCallCheck3.default)(this, BlackoutDeleteModalController);

        this.CalendarService = CalendarService;
    }

    (0, _createClass3.default)(BlackoutDeleteModalController, [{
        key: 'del',
        value: function del() {
            var _this = this;

            this.CalendarService.deleteBlackout(this.resolve.blackout.id).then(function () {
                return _this.close({ $value: _this.resolve.blackout });
            });
        }
    }]);
    return BlackoutDeleteModalController;
}();

BlackoutDeleteModalController.$inject = ['CalendarService'];

var BlackoutDeleteModal = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    controller: BlackoutDeleteModalController,
    template: template
};

angular.module('xlrelease').component('blackoutDeleteModal', BlackoutDeleteModal);

/***/ }),
/* 1116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <form name="blackoutEditForm" class="form-horizontal" novalidate>\n        <div class="modal-header">\n            <h4 class="modal-title pull-left" id="modal-title">{{:: $ctrl.resolve.blackout ? \'Edit \' + $ctrl.resolve.blackout.label : \'Set a blackout period\' }}</h4>\n            <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon"/></button>\n            <div class="clearfix"/>\n        </div>\n        <div class="modal-body" id="modal-body">        \n            <div class="form-group">\n                <label class="col-sm-3 control-label" for="label">\n                    Label <span ng-if="blackoutEditForm.label.$touched && blackoutEditForm.label.$error.required" class="error">*</span>\n                </label>\n                <div class="col-sm-9">\n                    <input type="text" class="input-block-level text" id="label" name="label" ng-model="$ctrl.blackout.label" ng-required="true"/>\n                </div>\n            </div>\n            <div class="form-group start-date">\n                <label class="col-sm-3 control-label" for="startDate">Start date</label>\n                <div class="col-sm-9">\n                    <div date-editor ng-model="$ctrl.blackout.startDate" deletable="false" on-change="$ctrl.onDateChange($ctrl.blackout.startDate)"></div>\n                </div>\n            </div>\n            <div class="form-group end-date">\n                <label class="col-sm-3 control-label" for="endDate">End date</label>\n                <div class="col-sm-9">\n                     <div date-editor ng-model="$ctrl.blackout.endDate" deletable="false" on-change="$ctrl.onDateChange($ctrl.blackout.endDate)"></div>\n                </div>\n            </div>\n        </div>\n        <div class="modal-footer">\n            <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n            <button class="button save primary" type="submit" ng-click="$ctrl.save()" ng-disabled="blackoutEditForm.$invalid">Save</button>\n        </div>\n    </form>\n    ';

var BlackoutEditModalController = function () {
    function BlackoutEditModalController(CalendarService) {
        (0, _classCallCheck3.default)(this, BlackoutEditModalController);

        this.CalendarService = CalendarService;
    }

    (0, _createClass3.default)(BlackoutEditModalController, [{
        key: '$onInit',
        value: function $onInit() {
            this.blackout = angular.copy(this.resolve.blackout) || {
                startDate: moment(this.resolve.date).startOf('day'),
                endDate: moment(this.resolve.date).endOf('day').milliseconds(0)
            };
        }
    }, {
        key: 'save',
        value: function save() {
            var _this = this;

            this.CalendarService.saveBlackout(this.blackout).then(function () {
                return _this.close({ $value: _this.blackout });
            });
        }
    }, {
        key: 'onDateChange',
        value: function onDateChange(newDate) {
            if (moment(this.blackout.startDate).isAfter(this.blackout.endDate)) {
                this.blackout.startDate = this.blackout.endDate = newDate;
            }
        }
    }]);
    return BlackoutEditModalController;
}();

BlackoutEditModalController.$inject = ['CalendarService'];

var BlackoutEditModal = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    controller: BlackoutEditModalController,
    template: template
};

angular.module('xlrelease').component('blackoutEditModal', BlackoutEditModal);

/***/ }),
/* 1117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CalendarBlackoutTooltipTemplate = '\n        <div class="popover popover-blackout">\n            <div class="arrow"></div>\n            <div class="popover-title" >\n                <span ng-bind="$ctrl.blackout.label"></span>\n                <a class="popover-close" hide-popover-on-click>\n                  <i class="xl-icon close-icon icon-s" />\n                </a>\n            </div>\n            <div class="popover-content">\n                <table>\n                    <tr><td>Start:</td><td><span class="start-date mlm">{{$ctrl.blackout.startDate | date:\'short\'}}</span></td></tr>\n                    <tr><td>End:</td><td><span class="end-date mlm">{{$ctrl.blackout.endDate | date:\'short\'}}</span></td></tr>\n                </table>\n                <div ng-if="$ctrl.canEditBlackout" class="popover-actions">\n                    <a class="link edit" ng-click="$ctrl.edit()" hide-popover-on-click>\n                        <i class="xl-icon edit-icon"></i><span class="link">Edit</span></a>\n                    <a class="link delete" ng-click="$ctrl.del()" hide-popover-on-click>\n                        <i class="xl-icon delete-icon"></i><span>Delete</span></a>\n                </div>\n            </div>\n        </div>\n    ';

var CalendarBlackoutTooltipController = function () {
    function CalendarBlackoutTooltipController($uibModal, GlobalPermissions, Authenticator) {
        (0, _classCallCheck3.default)(this, CalendarBlackoutTooltipController);

        this.$uibModal = $uibModal;
        this.canEditBlackout = Authenticator.hasPermission(GlobalPermissions.EDIT_GLOBAL_BLACKOUT);
    }

    (0, _createClass3.default)(CalendarBlackoutTooltipController, [{
        key: 'edit',
        value: function edit() {
            this._openModal('blackoutEditModal');
        }
    }, {
        key: 'del',
        value: function del() {
            this._openModal('blackoutDeleteModal');
        }
    }, {
        key: '_openModal',
        value: function _openModal(component) {
            this.$uibModal.open({
                animation: false,
                component: component,
                resolve: {
                    blackout: this.blackout
                }
            }).result.then(this.onChange);
        }
    }]);
    return CalendarBlackoutTooltipController;
}();

var CalendarBlackoutTooltipDirective = {
    scope: {
        blackout: '=',
        onChange: '&'
    },
    controller: CalendarBlackoutTooltipController,
    bindToController: true,
    controllerAs: '$ctrl',
    template: CalendarBlackoutTooltipTemplate,
    replace: true
};

angular.module('xlrelease').directive('calendarBlackoutTooltip', ['GlobalPermissions', 'Authenticator', function () {
    return CalendarBlackoutTooltipDirective;
}]);

/***/ }),
/* 1118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <div class="modal-content">\n        <div class="modal-header">\n            <button type="button" class="close" ng-click="$ctrl.dismiss()" aria-hidden="true"><i class="xl-icon close-icon"/></button>\n            <h4>Properties for {{ $ctrl.fullDate }}</h4>\n        </div>\n        <div class="modal-body">\n            <form name="dayForm" id="dayForm" class="form-horizontal">\n                <div class="form-group">\n                    <label class="col-sm-3 control-label" for="day-label">Label</label>\n    \n                    <div class="col-sm-9">\n                        <input type="text" class="input-block-level" id="day-label" ng-model="$ctrl.editedDay.label" autofocus/>\n                    </div>\n                </div>\n                <div class="form-group">\n                    <label class="col-sm-3 control-label">Color</label>\n    \n                    <div class="col-sm-9">\n                        <span color-picker colors="$ctrl.DayColors" current-color="$ctrl.editedDay.color" inline="true" tooltip="\'Select background color\'" class="pick-color"></span>\n                    </div>\n                </div>\n            </form>\n        </div>\n        <div class="modal-footer">\n            <button class="button cancel" ng-click="$ctrl.dismiss()">Cancel</button>\n            <button class="button save primary" ng-click="$ctrl.save()">Save</button>\n        </div>\n    </div>\n    ';

var SpecialDayModalController = function () {
    function SpecialDayModalController(CalendarService, DayColors) {
        (0, _classCallCheck3.default)(this, SpecialDayModalController);

        this.CalendarService = CalendarService;
        this.DayColors = DayColors;
    }

    (0, _createClass3.default)(SpecialDayModalController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            var day = this.resolve.day;
            if (day) {
                this.editedDay = {
                    label: day.label,
                    color: day.color
                };
                this.CalendarService.getSpecialDay(day.fullDate).then(function (response) {
                    _this.editedDay.label = response.data.label;
                    _this.editedDay.color = response.data.color;
                });
                this.fullDate = day.fullDate.format('MMMM Do');
            }
        }
    }, {
        key: 'save',
        value: function save() {
            var _this2 = this;

            this.CalendarService.setSpecialDay(this.resolve.day.fullDate, this.editedDay).then(function () {
                return _this2.close({ $value: _this2.editedDay });
            });
        }
    }]);
    return SpecialDayModalController;
}();

SpecialDayModalController.$inject = ['CalendarService', 'DayColors'];

var SpecialDayModal = {
    bindings: {
        resolve: '<',
        close: '&',
        dismiss: '&'
    },
    controller: SpecialDayModalController,
    template: template
};

angular.module('xlrelease').component('specialDayModal', SpecialDayModal);

/***/ }),
/* 1119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ConfigurationInstances', ['Backend', 'MetadataService', function (Backend, MetadataService) {
    var configurationInstances = void 0,
        configurationDescriptors = void 0,
        instancesByType = {},
        _loaded = false,
        loadingPromise = null;
    var resolvedInstancesByType = {};

    function getAllSubtypesOfType(type, descriptors) {
        return _.chain(descriptors).filter(function (descriptor) {
            return _.includes(descriptor.superTypes, type);
        }).map('type').value();
    }

    function resolveInstancesByType(type, instancesByType, descriptors) {
        var typeInstances = instancesByType[type] || [];
        var subtypeInstances = _.flatten(_.values(_.pick(instancesByType, getAllSubtypesOfType(type, descriptors))));
        return _.union(typeInstances, subtypeInstances);
    }

    return {
        load: function load(folderId) {
            var useShortId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

            if (loadingPromise) {
                return loadingPromise;
            }
            loadingPromise = MetadataService.getConfigurationDescriptors().then(function (descriptors) {
                configurationDescriptors = descriptors;
                return Backend.get('api/v1/config/byTypeAndTitle', {
                    params: {
                        configurationType: 'xlrelease.Configuration',
                        folderOnly: false,
                        folderId: folderId
                    }
                }).then(function (resp) {
                    var instances = resp.data;
                    configurationInstances = instances;
                    instancesByType = _.groupBy(_.sortBy(instances, [function (ci) {
                        return !!ci.title ? ci.title.toLowerCase() : ci.title;
                    }]), 'type');
                    _loaded = true;
                    loadingPromise = null;
                    if (useShortId) {
                        configurationInstances.forEach(function (x) {
                            x.id = x.id.split('/').pop();
                        });
                    }
                    return configurationInstances;
                });
            });
            return loadingPromise;
        },
        getTitle: function getTitle(ciID) {
            var instance = _(configurationInstances).find(function (item) {
                return item.id === ciID;
            });

            return instance ? instance.title : undefined;
        },
        getFolderId: function getFolderId(ciID) {
            var instance = _(configurationInstances).find(function (item) {
                return item.id === ciID;
            });

            return instance && instance.folderId ? instance.folderId : undefined;
        },
        getInstancesByType: function getInstancesByType(type) {
            if (_.isUndefined(resolvedInstancesByType[type])) {
                resolvedInstancesByType[type] = resolveInstancesByType(type, instancesByType, configurationDescriptors);
            }
            return resolvedInstancesByType[type];
        },
        reset: function reset() {
            configurationInstances = null;
            configurationDescriptors = null;
            resolvedInstancesByType = {};
            instancesByType = {};
            _loaded = false;
        },
        loaded: function loaded() {
            return _loaded;
        }
    };
}]);

/***/ }),
/* 1120 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ClusterMode = {
    STANDALONE: 'default'
};

var injectParams = ['$q', 'Backend', 'Authenticator', 'ClusterMode'];

var ServerConfigurationService = function () {
    function ServerConfigurationService($q, Backend, Authenticator) {
        (0, _classCallCheck3.default)(this, ServerConfigurationService);

        this._$q = $q;
        this._Backend = Backend;
        this._Authenticator = Authenticator;
        this._ClusterMode = ClusterMode;

        this._cachedClusterInfo = undefined;
        this._cachedPromise = undefined;
        this._promiseWasRejected = false;
    }

    (0, _createClass3.default)(ServerConfigurationService, [{
        key: '_getClusterInfo',
        value: function _getClusterInfo() {
            var _this = this;

            if (!this._Authenticator.isAuthenticated()) {
                this._cachedPromise = undefined;
                this._cachedClusterInfo = undefined;
                var noInfoPromise = this._$q.defer();
                noInfoPromise.resolve({});
                return noInfoPromise.promise;
            }

            if (!this._cachedPromise || this._promiseWasRejected) {
                this._cachedPromise = this._Backend.get('server/cluster').then(function (response) {
                    _this._promiseWasRejected = false;
                    _this._cachedClusterInfo = response.data;
                    return response.data;
                }, function () {
                    _this._promiseWasRejected = true;
                    _this._cachedClusterInfo = {};
                    return {};
                });
            }
            return this._cachedPromise;
        }
    }, {
        key: 'isClusterModeStandalone',
        value: function isClusterModeStandalone() {
            var _this2 = this;

            return this._getClusterInfo().then(function (info) {
                return info.clusterMode === _this2._ClusterMode.STANDALONE;
            });
        }
    }]);
    return ServerConfigurationService;
}();

ServerConfigurationService.$inject = injectParams;

angular.module('xlrelease').constant('ClusterMode', ClusterMode).service('ServerConfigurationService', ServerConfigurationService);

/***/ }),
/* 1121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _getIterator2 = __webpack_require__(222);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {

    var UiExtensionProperties = {
        PERMISSIONS: 'permissions'
    };

    var injectParams = ['$q', 'Backend', 'Authenticator', 'UiExtensionProperties', 'ServerConfigurationService'];

    var UiExtensionsService = function () {
        function UiExtensionsService($q, Backend, Authenticator, UiExtensionProperties, ServerConfigurationService) {
            (0, _classCallCheck3.default)(this, UiExtensionsService);

            this._$q = $q;
            this._Backend = Backend;
            this._Authenticator = Authenticator;
            this._UiExtensionProperties = UiExtensionProperties;
            this._ServerConfigurationService = ServerConfigurationService;

            this._cachedPromise = undefined;
            this._promiseWasRejected = false;
        }

        (0, _createClass3.default)(UiExtensionsService, [{
            key: 'getMainMenuItems',
            value: function getMainMenuItems() {
                return this._$q.all([this.getMenuItems('xlrelease.menu.Main'), this._ServerConfigurationService.isClusterModeStandalone()]).then(function (data) {
                    var _data = (0, _slicedToArray3.default)(data, 2),
                        items = _data[0],
                        isStandalone = _data[1];

                    items.forEach(function (item) {
                        if (item.id === "xlrelease.menu.Plugins") {
                            angular.extend(item, { disabled: !isStandalone });
                        }
                    });
                    return items;
                });
            }
        }, {
            key: 'getReleaseMenuExtensions',
            value: function getReleaseMenuExtensions(release) {
                return this.getMenuItems('xlrelease.ReleasePageMenu', release);
            }
        }, {
            key: 'getMenuItems',
            value: function getMenuItems(menuId, container) {
                var _this = this;

                return this._getAllMenuExtensions().then(function (extensions) {
                    return _this._fillDefaultsAndPermissions(_this._findMenu(extensions, menuId).items, container);
                });
            }
        }, {
            key: 'findMenuItemForPath',
            value: function findMenuItemForPath(path) {
                var _this2 = this;

                if (path) {
                    path = path[0] === '/' ? path.substr(1) : path;
                }
                return this.getMainMenuItems().then(function (items) {
                    var allItems = _this2._flattenMenu(items);
                    return _.chain(allItems).filter(function (item) {
                        return _.startsWith(path, item.pathSuffix);
                    }).sortBy(function (item) {
                        return -item.pathSuffix.length;
                    }).value()[0];
                });
            }

            ////

        }, {
            key: '_getAllMenuExtensions',
            value: function _getAllMenuExtensions() {
                var _this3 = this;

                if (!this._Authenticator.isAuthenticated()) {
                    this._cachedPromise = undefined;
                    var noItemsPromise = this._$q.defer();
                    noItemsPromise.resolve([]);
                    return noItemsPromise.promise;
                }

                if (!this._cachedPromise || this._promiseWasRejected) {
                    this._cachedPromise = this._Backend.get('api/extension/metadata', { headers: { 'Accept': 'application/json' } }).then(function (response) {
                        _this3._promiseWasRejected = false;
                        return response.data;
                    }, function () {
                        _this3._promiseWasRejected = true;
                        return [];
                    });
                }
                return this._cachedPromise;
            }
        }, {
            key: '_findMenu',
            value: function _findMenu(items, id) {
                return _.find(items, { id: id }) || {};
            }
        }, {
            key: '_fillDefaultsAndPermissions',
            value: function _fillDefaultsAndPermissions(items, container) {
                var _this4 = this;

                items = items || [];
                this._forAllItems(items, function (item) {
                    item.permitted = _this4._isPermitted(item, container);
                    if (_.isUndefined(item.pathSuffix) && item.label) {
                        item.pathSuffix = item.label.replace(/[^A-Za-z0-9-_]/g, '').toLowerCase();
                    }
                });
                return items;
            }
        }, {
            key: '_isPermitted',
            value: function _isPermitted(item, container) {
                var _this5 = this;

                var PROPERTY_PERMISSIONS = this._UiExtensionProperties.PERMISSIONS;
                var isPermitted = true;
                if (item.properties && item.properties[PROPERTY_PERMISSIONS]) {
                    var permissions = _.chain(item.properties[PROPERTY_PERMISSIONS]).split(",").map(function (e) {
                        return _.trim(e);
                    }).filter(function (e) {
                        return !_.isEmpty(e);
                    }).value();
                    isPermitted = _.isEmpty(permissions) || _(permissions).some(function (perm) {
                        return container && _this5._Authenticator.hasPermission(perm, container) || _this5._Authenticator.hasPermission(perm);
                    });
                }
                return isPermitted;
            }
        }, {
            key: '_flattenMenu',
            value: function _flattenMenu(items) {
                var allItems = [];
                this._forAllItems(items, function (item) {
                    return allItems.push(item);
                });
                return allItems;
            }
        }, {
            key: '_forAllItems',
            value: function _forAllItems(items, fnCallback) {
                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = (0, _getIterator3.default)(items), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var item = _step.value;

                        fnCallback(item);
                        if (item.items) {
                            this._forAllItems(item.items, fnCallback);
                        }
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }
            }
        }]);
        return UiExtensionsService;
    }();

    UiExtensionsService.$inject = injectParams;

    angular.module('xlrelease').constant('UiExtensionProperties', UiExtensionProperties).service('UiExtensionsService', UiExtensionsService);
})();

/***/ }),
/* 1122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _angular = __webpack_require__(131);

var _angular2 = _interopRequireDefault(_angular);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ViewContainerController = function () {
    function ViewContainerController($element) {
        (0, _classCallCheck3.default)(this, ViewContainerController);
        this.CLASSES = {
            '#release #navigator.navigator-shifted': 144,
            '.dashboard-sidebar': 92,
            '.view-content': 0,
            '#release #navigator': 93,
            '#release #navigator-toggler': 93,
            '#calendar #navigator-toggler': 93,
            '#calendar #navigator': 93
        };

        this.$element = $element;
        this.viewContainerStyle = undefined;
    }

    (0, _createClass3.default)(ViewContainerController, [{
        key: '$onInit',
        value: function $onInit() {
            this.body = _angular2.default.element('body');
            this.css = _.map(this.CLASSES, function (fromTop, className) {
                return className + '{top: ' + fromTop + 'px !important;}';
            }).join('');
            this.setViewContainerStyle();
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            if (_angular2.default.isDefined(this.viewContainerStyle)) {
                this.viewContainerStyle.remove();
                this.viewContainerStyle = undefined;
            }
        }
    }, {
        key: 'setHeight',
        value: function setHeight(height) {
            this.css = _.map(this.CLASSES, function (fromTop, className) {
                return className + '{top: ' + (fromTop + height) + 'px !important;}';
            }).join('');
            this.setViewContainerStyle();
        }
    }, {
        key: 'setViewContainerStyle',
        value: function setViewContainerStyle() {
            if (_angular2.default.isUndefined(this.viewContainerStyle)) {
                this.viewContainerStyle = _angular2.default.element('<style>' + this.css + '</style>').appendTo(this.body);
            } else if (this.viewContainerStyle.html() !== this.css) {
                this.viewContainerStyle.html(this.css);
            }
        }
    }]);
    return ViewContainerController;
}();

ViewContainerController.$inject = ['$element'];


_angular2.default.module('xlrelease').directive('viewContainer', [function () {
    return {
        restrict: 'A',
        controller: ViewContainerController
    };
}]).directive('headerContainer', ['$window', function ($window) {
    return {
        restrict: 'A',
        require: '^^viewContainer',
        link: function link(scope, element, attrs, ctrl) {
            var windowEl = _angular2.default.element($window);
            windowEl.bind('resize', function () {
                ctrl.setHeight(element.height());
            });
            scope.$watch(function () {
                return element.height();
            }, function (newHeight) {
                ctrl.setHeight(newHeight);
            });
        }
    };
}]);

/***/ }),
/* 1123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _colors = __webpack_require__(177);

var _colors2 = _interopRequireDefault(_colors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').value('PhaseColors', [{ name: "Blue", value: _colors2.default.blue }, { name: "Green", value: _colors2.default.green }, { name: "Orange", value: _colors2.default.orange }, { name: "Red", value: _colors2.default.red }, { name: "Grey", value: _colors2.default.gray }, { name: "Purple", value: _colors2.default.purple }]); /*
                                                                                                                                                                                                                                                                                                                                                             * Adapted from :
                                                                                                                                                                                                                                                                                                                                                             *
                                                                                                                                                                                                                                                                                                                                                             *   https://github.com/tkrotoff/jquery-simplecolorpicker
                                                                                                                                                                                                                                                                                                                                                             *   Copyright (C) 2012-2013 Tanguy Krotoff <tkrotoff@gmail.com>
                                                                                                                                                                                                                                                                                                                                                             *
                                                                                                                                                                                                                                                                                                                                                             *   Licensed under the MIT license.
                                                                                                                                                                                                                                                                                                                                                             */

angular.module('xlrelease').value('DayColors', [// TODO UX: discuss this with UX
{ name: "None", value: '' }, { name: "Blue", value: _colors2.default.hoverColor }, { name: "Green", value: _colors2.default.successBackground }, { name: "Orange", value: _colors2.default.warningBackground }, { name: "Red", value: _colors2.default.errorBackground }]);

angular.module('xlrelease').directive('colorPickerSwatch', function () {
    return {
        templateUrl: 'partials/colorpicker/swatch.html',
        replace: true,
        scope: {
            'color': '=cpColor',
            'currentColor': '=cpCurrentColor'
        },
        link: function link(scope, element) {
            scope.clicked = function () {
                if (element.hasClass('button')) {
                    scope.$parent.selectColor(scope.color.value);
                }
            };
        }
    };
});

angular.module('xlrelease').directive('colorPicker', function () {
    var bootstrapArrowWidth = 18,
        bootstrapArrowHeight = 6;
    return {
        templateUrl: 'partials/colorpicker/main.html',
        replace: true,
        scope: {
            'colors': '=',
            'currentColor': '=',
            'onChange': '&',
            'inline': '='
        },
        link: function link(scope, element, attrs) {
            if (!scope.currentColor) {
                scope.currentColor = scope.colors[0].value;
            }

            var picker = element.find('.simplecolorpicker');
            if (attrs.inline) {
                picker.addClass('inline');
            } else {
                picker.addClass('popup');
            }

            var toggler = element.find('.toggle-picker');
            var popup = element.find('.popup');
            var view = angular.element('.view');

            var showPicker = function showPicker() {
                var pos = toggler.position();
                popup.css({
                    left: pos.left + toggler.width() / 2 - bootstrapArrowWidth + view.scrollLeft() + 2,
                    top: pos.top + toggler.outerHeight() + bootstrapArrowHeight
                });
                popup.show();
            };
            var hidePicker = function hidePicker() {
                popup.hide();
            };
            var togglePicker = function togglePicker() {
                if (popup.is(':visible')) {
                    hidePicker();
                } else {
                    showPicker();
                }
            };
            var mouseDown = function mouseDown(e) {
                e.stopPropagation();
                e.preventDefault();
            };

            toggler.on('mousedown', togglePicker);
            element.on('mousedown', '.popup, .toggle-picker', mouseDown);
            element.parents('.phase-header').on('mouseleave', hidePicker);

            scope.selectColor = function (color) {
                scope.currentColor = color;
                hidePicker();
                scope.onChange({ color: color });
            };
        }
    };
});

/***/ }),
/* 1124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('attachmentsList', ['Download', function (Download) {
    return {
        templateUrl: "partials/directives/attachments-list.html",
        restrict: 'A',
        scope: {
            attachments: '=',
            readonly: '&',
            canDeleteAttachments: '&',
            dismiss: '&',
            deleteAttachment: '&',
            uploadUrl: '='
        },
        link: function link(scope) {
            scope.attachmentAdded = function (result) {
                scope.attachments.push(result[0]);
            };
            scope.downloadAttachment = function (attachment) {
                Download.launch('export/attachments/' + attachment.id);
            };
        }
    };
}]);

/***/ }),
/* 1125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').directive('dateEditor', [function () {
    function setValidity(isRequired, value, ngModelCtrl) {
        if (!_.isUndefined(isRequired) && isRequired === true) {
            if (_.isNull(value) || _.isUndefined(value)) {
                ngModelCtrl.$setValidity('ngModel', false);
            } else {
                ngModelCtrl.$setValidity('ngModel', true);
            }
        }
    }

    return {
        templateUrl: "partials/directives/date-editor.html",
        restrict: 'A',
        scope: {
            placeholder: '@',
            onChange: '&',
            ngModel: '=',
            inferredDate: '&',
            deletable: '&',
            readonly: '&',
            dateFormat: '@',
            isRequired: '<'
        },
        require: 'ngModel',
        link: function link(scope, element, attrs, controller) {
            scope.$watch('ngModel', function (newDate, oldDate) {
                setValidity(scope.isRequired, scope.ngModel, controller);
                if (angular.isUndefined(oldDate) && (angular.isUndefined(newDate) || newDate === null)) {
                    return;
                }
                if (newDate !== oldDate) {
                    scope.onChange();
                }
            });
            scope.deleteDate = function () {
                scope.ngModel = null;
            };
            scope.displayedDate = function () {
                return scope.ngModel || scope.inferredDate();
            };
            scope.hasNoDate = function () {
                return !scope.ngModel;
            };
        }
    };
}]);

angular.module('xlrelease').directive('ganttDateEditor', ['GanttElementsEditor', function (GanttElementsEditor) {
    return {
        scope: true,
        template: "<div date-editor ng-model='date' inferred-date='inferredDate' on-change='setDate(date)' editable='true' deletable='deletable'></div>",
        link: function link(scope, element) {
            var parent = element.parent();
            if (!parent.length) return;

            var timestamp = parent.data('date');
            var id = parent.data('id');
            var type = parent.data('type');

            var date = new Date(parseInt(timestamp, 10));
            if (parent.data('has-own-date')) {
                scope.date = date;
            } else {
                scope.inferredDate = date;
                scope.date = null;
            }
            scope.deletable = parent.data('deletable');

            scope.$watch('date', function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    var ganttElement = gantt.getTask(id);
                    if (type === 'start') {
                        GanttElementsEditor.setStartDate(ganttElement, newValue);
                    } else {
                        GanttElementsEditor.setEndDate(ganttElement, newValue);
                    }
                }
            });
        }
    };
}]);

angular.module('xlrelease').directive('modalDateEditor', function () {
    return {
        templateUrl: "partials/directives/modal-date-editor.html",
        restrict: 'A',
        scope: {
            dateModel: '=',
            readonly: '&',
            dateTitle: '@',
            inferredDate: '&',
            onChange: '&'
        },
        link: function link(scope) {
            scope.removeDate = function () {
                scope.dateModel = null;
            };

            var dateModelWatcher = scope.$watch('dateModel', function (newDate, oldDate) {
                if (angular.isDefined(oldDate) && newDate !== oldDate) {
                    scope.onChange();
                }
            });

            scope.displayedDate = function () {
                return scope.dateModel || scope.inferredDate();
            };

            scope.$on('destroy', dateModelWatcher);
        }
    };
});

var GridDateEditor = function () {
    function GridDateEditor() {
        (0, _classCallCheck3.default)(this, GridDateEditor);

        this.restrict = 'A';
        this.templateUrl = 'partials/directives/grid-date-editor.html';
        this.scope = {
            placeholder: '=',
            date: '=',
            readonly: '&'
        };
    }

    (0, _createClass3.default)(GridDateEditor, [{
        key: 'link',
        value: function link(scope) {
            scope.displayedDate = function () {
                return scope.date;
            };
        }
    }], [{
        key: 'factory',
        value: function factory() {
            GridDateEditor.instance = new GridDateEditor();
            return GridDateEditor.instance;
        }
    }]);
    return GridDateEditor;
}();

angular.module('xlrelease').directive('gridDateEditor', GridDateEditor.factory);

/***/ }),
/* 1126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('dateTimePicker', ['$parse', '$locale', 'DateFormatDetector', 'DateService', 'RegionalSettings', function ($parse, $locale, DateFormatDetector, DateService, RegionalSettings) {

    function overrideDatePart(oldDate, componentDate, dateTimeFormatter) {
        var newDate = moment(componentDate);
        var _oldDate = moment(oldDate);
        newDate.hour(_oldDate.hour());
        newDate.minute(_oldDate.minute());
        newDate.second(_oldDate.second());
        return dateTimeFormatter(newDate);
    }

    function overrideTimePart(oldDate, time, dateTimeFormatter) {
        var date = moment(oldDate);
        var newHoursMinutes = moment(time.value, "hh:mm a");

        date.hours(newHoursMinutes.hours());
        date.minutes(newHoursMinutes.minutes());
        date.seconds(0);
        date.milliseconds(0);
        return dateTimeFormatter(date);
    }

    function saveDateAndClosePicker(scope, dateGetter, dateSetter, date, dateTimeFormatter) {
        scope.$apply(function () {
            dateSetter.assign(scope, overrideDatePart(getTodayIfDateIsEmpty(scope, dateGetter), date, dateTimeFormatter));
        });
    }
    function _formatShortDate() {
        var shortFormat = $locale.DATETIME_FORMATS.shortDate.toLowerCase();
        if (shortFormat.match(/y/gi).length < 2) {
            shortFormat = shortFormat.replace('y', 'yy');
        }
        return shortFormat;
    }

    function setupDatePicker(element, scope, dateGetter, dateSetter, dateTimeFormatter) {
        var datePickerHolder = element.find('.date-picker-holder');

        datePickerHolder.datepicker({
            format: _formatShortDate(),
            language: $locale.id,
            autoclose: true,
            weekStart: RegionalSettings.currentFirstDayOfWeek
        });

        var onHide = function onHide() {
            var newDate = datePickerHolder.datepicker('getDate');
            if (moment(newDate).isValid()) {
                saveDateAndClosePicker(scope, dateGetter, dateSetter, newDate, dateTimeFormatter);
            } else {
                var selectedDates = datePickerHolder.datepicker('getDates');
                if (selectedDates.length === 0) {
                    // if date was deselected by clicking on the already selected date, set it back again
                    // (see bootstrap-datepicker:_toggle_multidate for more details)
                    newDate = moment(getTodayIfDateIsEmpty(scope, dateGetter)).toDate();
                } else {
                    // if date is invalid reset to the current date
                    newDate = DateService.getToday().toDate();
                }
                setDateTime(element, scope, dateGetter);
                saveDateAndClosePicker(scope, dateGetter, dateSetter, newDate, dateTimeFormatter);
            }
        };
        datePickerHolder.datepicker().on('hide', onHide);

        var dateHolder = element.find('.date');
        var onClickDatePickerHolder = function onClickDatePickerHolder() {
            return datePickerHolder.datepicker('show');
        };
        dateHolder.on('click', onClickDatePickerHolder);

        return function () {
            dateHolder.datepicker().off('hide', onHide);
            dateHolder.off('click', onClickDatePickerHolder);
        };
    }

    function setupTimePicker(element, scope, dateGetter, dateSetter, dateTimeFormatter) {
        var timePickerHolder = element.find('.time-picker-holder');
        var ESC_KEY = 27;

        timePickerHolder.timepicker({
            showMeridian: DateFormatDetector.isAmPmVisible()
        });
        var timeClickHandler = function timeClickHandler() {
            timePickerHolder.timepicker('showWidget').one('hide.timepicker', function (event) {
                scope.$apply(function () {
                    dateSetter.assign(scope, overrideTimePart(getTodayIfDateIsEmpty(scope, dateGetter), event.time, dateTimeFormatter));
                });
            });
        };
        var timeEl = element.find('.time');
        timeEl.on('click', timeClickHandler);

        var hideTimePicker = function hideTimePicker(e) {
            if (e.keyCode === ESC_KEY) {
                timePickerHolder.timepicker('hideWidget');
            }
        };

        var document = angular.element(document);
        timePickerHolder.one('show.timepicker', function () {
            document.on('keydown', hideTimePicker);
        });

        return function () {
            document.off('keydown', hideTimePicker);
            timeEl.off('click', timeClickHandler);
        };
    }

    function getTodayIfDateIsEmpty(scope, dateGetter) {
        if (dateGetter(scope) === null || angular.isUndefined(dateGetter(scope))) {
            var today = new Date();
            today.setSeconds(0);
            today.setMilliseconds(0);
            return today;
        }
        return dateGetter(scope);
    }

    function setDateTime(element, scope, dateGetter) {
        var date = getTodayIfDateIsEmpty(scope, dateGetter);
        var timePickerFormat = DateFormatDetector.isAmPmVisible() ? 'hh:mm A' : 'HH:mm';
        var formattedTime = moment(date).format(timePickerFormat);

        var datePickerHolder = element.find('.date-picker-holder');
        datePickerHolder.datepicker('setDate', DateService.atMidnight(date).toDate());

        var timePickerHolder = element.find('.time-picker-holder');
        timePickerHolder.timepicker('setTime', formattedTime);
    }

    return {
        restrict: 'A',
        link: function link(scope, element, attrs) {
            var parentForm = element.inheritedData('$formController');
            var dateGetter = $parse('displayedDate()');
            var dateSetter = $parse(attrs.date);
            var dateSetterWrapper = {
                assign: function assign(scope, value) {
                    if (parentForm) {
                        parentForm.$setDirty();
                    }
                    dateSetter.assign(scope, value);
                }
            };
            var dateTimeFormatter = function dateTimeFormatter(dateFormat) {
                return function (dateTime) {
                    return angular.isDefined(dateFormat) && !!dateFormat ? moment(dateTime).format(dateFormat) : moment(dateTime).valueOf();
                };
            };

            var clearDatePickerHandlers = void 0;
            var clearTimePickerHandlers = void 0;
            var readOnlyWatcher = scope.$watch('readonly()', function (isReadOnly) {
                if (!isReadOnly) {
                    if (angular.isUndefined(clearDatePickerHandlers)) {
                        clearDatePickerHandlers = setupDatePicker(element, scope, dateGetter, dateSetterWrapper, dateTimeFormatter(attrs.dateFormat));
                    }
                    if (angular.isUndefined(clearTimePickerHandlers)) {
                        clearTimePickerHandlers = setupTimePicker(element, scope, dateGetter, dateSetterWrapper, dateTimeFormatter(attrs.dateFormat));
                    }
                } else {
                    if (angular.isDefined(clearDatePickerHandlers)) {
                        clearDatePickerHandlers();
                    }
                    if (angular.isDefined(clearTimePickerHandlers)) {
                        clearTimePickerHandlers();
                    }
                }
            });

            var dateWatcher = scope.$watch('displayedDate()', function (newDate) {
                if (angular.isDefined(newDate) && !scope.readonly()) {
                    setDateTime(element, scope, dateGetter);
                }
            });

            scope.$on('$destroy', function () {
                element.find('.date').off();
                element.find('.date-picker-holder').datepicker('destroy');
                dateWatcher();
                readOnlyWatcher();
                if (angular.isDefined(clearDatePickerHandlers)) {
                    clearDatePickerHandlers();
                }
                if (angular.isDefined(clearTimePickerHandlers)) {
                    clearTimePickerHandlers();
                }
            });
        }
    };
}]);

angular.module('xlrelease').factory('DateFormatDetector', ['dateFilter', '$locale', function (dateFilter, $locale) {
    return {
        isAmPmVisible: function isAmPmVisible() {
            var formattedTime = dateFilter(new Date(2013, 0, 1, 14), 'shortTime');
            return !_.includes(formattedTime, '14');
        },
        isMonthDisplayedBeforeDay: function isMonthDisplayedBeforeDay() {
            var shortDate = $locale.DATETIME_FORMATS.shortDate.toLowerCase();
            return shortDate.indexOf('m') < shortDate.indexOf('d');
        }
    };
}]);

/***/ }),
/* 1127 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('dipControl', ['ConfigurationInstances', '$q', '$stateParams', 'Ids', function (ConfigurationInstances, $q, $stateParams, Ids) {
    return {
        templateUrl: 'partials/directives/dip-control.html',
        scope: {
            property: '=',
            container: '=',
            large: '=?',
            readonly: '<',
            useShortId: '<'
        },
        require: '^form',
        link: function link(scope, element, attrs, formCtrl) {
            scope.form = formCtrl;
            if (scope.container) {
                var realValue = scope.container[scope.property.name];
                var defaultValue = scope.property.default;
                scope.container[scope.property.name] = angular.isDefined(realValue) ? realValue : defaultValue;
                scope.stateParams = $stateParams;

                if (scope.property.kind === 'CI') {
                    if (!ConfigurationInstances.loaded()) {
                        var folderId = $stateParams.folderId ? $stateParams.folderId : Ids.releaseIdToFolderId($stateParams.releaseId);
                        ConfigurationInstances.load(folderId, scope.useShortId);
                    }
                    scope.ConfigurationInstances = ConfigurationInstances;

                    var items = [];
                    scope.$watch('ConfigurationInstances.loaded()', function (newVal) {
                        if (newVal) {
                            items = ConfigurationInstances.getInstancesByType(scope.property.referencedType);
                            scope.value = items.find(function (it) {
                                return it.id === scope.container[scope.property.name];
                            });
                        }
                    });

                    scope.ciHandlers = {
                        onSelect: function onSelect(newVal) {
                            scope.container[scope.property.name] = newVal.id;
                        },
                        removeElement: function removeElement() {
                            delete scope.container[scope.property.name];
                        },
                        addCandidates: function addCandidates(metadata, options) {
                            var differed = $q.defer();
                            var candidates = _.filter(items, function (item) {
                                return item.title.toLowerCase().indexOf(options.term.toLowerCase()) !== -1;
                            });
                            differed.resolve(candidates);
                            return differed.promise;
                        }
                    };

                    scope.$on('$destroy', function () {
                        ConfigurationInstances.reset();
                    });
                } else if (scope.property.kind === 'ENUM') {
                    scope.enumItems = scope.property.enumValues;
                }
            }
            scope.isError = function (field) {
                return field && (field.$touched || field.$dirty) && field.$invalid;
            };
        }
    };
}]);

/***/ }),
/* 1128 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('hoverMenu', ['Page', function (Page) {
    return {
        restrict: 'A',
        scope: {
            isActiveItem: '='
        },
        link: function link(scope, element) {
            element.on('mouseenter', function () {
                element.css({ backgroundColor: Page.theme.headerAccentColor });
            });
            element.on('mouseleave', function () {
                if (!scope.isActiveItem) {
                    element.css({ backgroundColor: '' });
                }
            });
        }
    };
}]);

/***/ }),
/* 1129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('displayMember', ['memberFormatterFilter', 'tooltipService', function (memberFormatterFilter, tooltipService) {

    return function (scope, element, attrs) {
        scope.$watch(attrs.displayMember, function (member) {
            var text = memberFormatterFilter(member);
            var memberName = member ? member.name : '';

            element.text(text);
            // Only display tooltip if it's different from the text
            if (text !== memberName) {
                tooltipService.setup(element, memberName, 'bottom');
            }
        }, true);
    };
}]);

/***/ }),
/* 1130 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('displayUser', ['VariablesInterpolator', 'userFormatterFilter', 'tooltipService', function (VariablesInterpolator, userFormatterFilter, tooltipService) {

    function render(element, user, variables) {
        var displayedName = userFormatterFilter(user);
        var username = user ? user.username : '';
        var interpolatedHtml = void 0;

        if (variables) {
            interpolatedHtml = VariablesInterpolator.interpolateInHtml(variables, _.escape(displayedName));
        } else {
            interpolatedHtml = _.escape(displayedName);
        }

        element.html(interpolatedHtml);
        if (displayedName !== username) {
            tooltipService.setup(element, _.escape(username), 'bottom');
        }
    }

    return function (scope, element, attrs) {
        if (attrs.variables) {
            scope.$watch('[' + attrs.displayUser + ', ' + attrs.variables + ']', function (watchedValues) {
                render(element, watchedValues[0], watchedValues[1]);
            }, true);
        } else {
            scope.$watch(attrs.displayUser, function (user) {
                render(element, user);
            }, true);
        }
    };
}]);

/***/ }),
/* 1131 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('durationEditor', ['$timeout', '$compile', 'DurationEditorService', function ($timeout, $compile, DurationEditorService) {
    var ACCEPTED_KEYS = [8 /* Backspace */, 9 /* Tab */, 46 /* Delete */, 37, 38, 39, 40 /* Up/Down/Left/Right*/];
    var ENTER_KEYCODE = 13;
    var ESCAPE_KEYCODE = 27;

    function Picker(scope, element, commitAction) {
        this.scope = scope;
        this.element = element;
        var parentForm = element.inheritedData('$formController');
        this.commitAction = function () {
            if (parentForm) {
                parentForm.$setDirty();
            }
            commitAction.apply();
        };

        this.scope.adjustPosition = _.bind(this.adjustPosition, this);

        this.unregisterEvents = function () {
            angular.element(window).off('resize', this.resizeHandler);
            angular.element(document).off('mousedown touchstart', this.mouseHandler);
        };
        scope.$on('$destroy', _.bind(function () {
            this.$picker && this.$picker.remove();
        }, this));

        this.removePicker = function (e) {
            if (!(this.element.is(e.target) || this.element.find(e.target).length || this.$picker.is(e.target) || this.$picker.find(e.target).length)) {
                scope.$apply(_.bind(function () {
                    this.closePicker(true);
                }, this));
            }
        };
    }

    Picker.prototype.show = function () {
        if (!this.$picker) {
            // building DOM element
            this.$picker = angular.element('<div class="datepicker datepicker-dropdown dropdown-menu datepicker-orient-left duration-picker"></div>').show();
            $compile(this.$picker.html('<div ng-include="\'partials/directives/duration-editor-fields.html\'" onload="adjustPosition()"></div>'))(this.scope);
            angular.element('body').append(this.$picker);
        }
    };

    Picker.prototype.adjustPosition = function () {
        this.unregisterEvents();
        // Very inspired from bootstrap-datepicker.js
        var pickerWidth = this.$picker.outerWidth();
        var pickerHeight = this.$picker.outerHeight();
        var visualPadding = 10;
        var windowWidth = angular.element(window).width();
        var windowHeight = angular.element(window).height();
        var scrollTop = angular.element(window).scrollTop();

        var offset = this.element.offset();
        var height = this.element.outerHeight(false);

        var yOrient = 'auto';
        var topOverflow = -scrollTop + offset.top - pickerHeight;
        var bottomOverflow = scrollTop + windowHeight - (offset.top + height + pickerHeight);
        if (Math.max(topOverflow, bottomOverflow) === bottomOverflow) {
            yOrient = 'top';
        } else {
            yOrient = 'bottom';
        }

        var top = offset.top;
        if (yOrient === 'top') {
            top += height;
        } else {
            top -= pickerHeight + parseInt(this.$picker.css('padding-top'));
        }

        var left = offset.left;
        if (offset.left < 0) left -= offset.left - visualPadding;else if (offset.left + pickerWidth > windowWidth) left = windowWidth - pickerWidth - visualPadding;

        var zIndex = parseInt(this.element.parents().filter(function () {
            return angular.element(this).css('z-index') !== 'auto';
        }).first().css('z-index')) + 10;

        this.$picker.removeClass('datepicker-orient-top datepicker-orient-bottom ' + 'datepicker-orient-right datepicker-orient-left');
        this.$picker.addClass('datepicker-orient-left ' + 'datepicker-orient-' + yOrient);
        this.$picker.css({
            top: top,
            left: left,
            zIndex: zIndex,
            display: "block"
        });

        this.resizeHandler = _.bind(this.adjustPosition, this);
        this.mouseHandler = _.bind(this.removePicker, this);

        angular.element(window).on('resize', this.resizeHandler);
        angular.element(document).on('mousedown touchstart', this.mouseHandler);

        angular.element('.datepicker .days').focus();
    };

    // Events
    Picker.prototype.closePicker = function (commit) {
        this.unregisterEvents();
        if (this.$picker) {
            this.$picker.remove();
            this.$picker = undefined;
        }
        if (commit) {
            this.commitAction();
        }
    };

    return {
        templateUrl: "partials/directives/duration-editor.html",
        restrict: 'A',
        scope: {
            duration: '=',
            inferredDuration: '&',
            onChange: '&',
            editable: '&',
            done: '&'
        },
        link: function link(scope, element) {
            var picker = new Picker(scope, element, function () {
                if (scope.duration !== scope.durationDraft) {
                    scope.duration = scope.durationDraft;
                    $timeout(function () {
                        scope.onChange();
                    });
                }
            });

            scope.showDurationPicker = function () {
                if (scope.editable()) {
                    picker.show();
                    var duration = DurationEditorService.hasDuration(scope.duration) ? scope.duration : scope.inferredDuration();
                    scope.durationData = DurationEditorService.getDurationData(duration);
                }
            };

            scope.$watch('durationData', function (durationData) {
                scope.durationDraft = DurationEditorService.getDuration(durationData || {});
            }, true);

            scope.keyPress = function (event) {
                if (_.includes(ACCEPTED_KEYS, event.keyCode)) {
                    return;
                }

                var input = String.fromCharCode(event.charCode || event.which);
                if (!/[0-9+]/.test(input)) {
                    event.stopImmediatePropagation();
                    event.preventDefault();
                }
            };

            scope.keyDown = function (event) {
                if (event.keyCode === ENTER_KEYCODE) {
                    picker.closePicker(true);
                }
                if (event.keyCode === ESCAPE_KEYCODE) {
                    picker.closePicker(false);
                }
            };

            scope.removeDuration = function () {
                scope.durationDraft = null;
                picker.closePicker(true);
            };

            scope.hasDuration = DurationEditorService.hasDuration;
        }
    };
}]);

angular.module('xlrelease').constant('Durations', function () {
    var ONE_SECOND = 1000;
    var ONE_MINUTE = 60 * ONE_SECOND;
    var ONE_HOUR = 60 * ONE_MINUTE;
    var ONE_DAY = 24 * ONE_HOUR;

    return {
        ONE_SECOND: ONE_SECOND,
        ONE_MINUTE: ONE_MINUTE,
        ONE_HOUR: ONE_HOUR,
        ONE_DAY: ONE_DAY
    };
}());

angular.module('xlrelease').factory('DurationEditorService', ['Durations', function (Durations) {
    return {
        hasDuration: function hasDuration(duration) {
            return duration !== null;
        },
        getDurationData: function getDurationData(durationInMs) {
            var durationInSec = durationInMs / 1000;
            var durationInMin = Math.round(durationInSec / 60);
            var durationInHour = durationInMin / 60;
            var durationInDay = durationInHour / 24;

            return {
                days: Math.floor(durationInDay),
                hours: Math.floor(durationInHour % 24),
                minutes: Math.floor(durationInMin % 60)
            };
        },
        getDuration: function getDuration(durationData) {
            function toUInt(value) {
                var result = parseFloat(value) || 0;
                return result >= 0 ? result : 0;
            }

            var days = toUInt(durationData.days);
            var hours = toUInt(durationData.hours);
            var minutes = toUInt(durationData.minutes);
            return Durations.ONE_DAY * days + Durations.ONE_HOUR * hours + Durations.ONE_MINUTE * minutes;
        }
    };
}]);

angular.module('xlrelease').filter('prettyDuration', ['DurationEditorService', function (DurationEditorService) {
    function formatTime(number, letter) {
        return ("" + number).slice(-2) + letter;
    }

    return function (input) {
        if (!DurationEditorService.hasDuration(input)) {
            return "";
        }

        var durationData = DurationEditorService.getDurationData(input);

        if (durationData.days === 0 && durationData.hours === 0 && durationData.minutes === 0) {
            return "0d 0h 0m";
        }

        var result = durationData.days ? durationData.days + 'd' : '0d';
        result += ' ' + formatTime(durationData.hours, "h") + ' ' + formatTime(durationData.minutes, "m");
        return result.replace(/^\s+|\s+$/g, '');
    };
}]);

/*
 Filter for converting duration to a "human" format.
 The output is converted to the two most significant units.
 So 2 days, 5 hours and 12 minutes will be converted to 2 days and 5 hours.
 If the second unit is 0 then it will be left off, so 2 days and 0 hours will be 2 days.
*/
angular.module('xlrelease').filter('humanizedDuration', function () {
    return function (duration) {
        if (!duration) {
            return "";
        }

        var formatYear = function formatYear() {
            return duration.years() + (duration.years() === 1 ? " year" : " years");
        };
        var formatMonth = function formatMonth() {
            return duration.months() + (duration.months() === 1 ? " month" : " months");
        };
        var formatDay = function formatDay() {
            return duration.days() + (duration.days() === 1 ? " day" : " days");
        };
        var formatHour = function formatHour() {
            return duration.hours() + (duration.hours() === 1 ? " hour" : " hours");
        };
        var formatMinute = function formatMinute() {
            return duration.minutes() + (duration.minutes() === 1 ? " minute" : " minutes");
        };

        var result = "";
        if (duration.years() > 0) {
            result = duration.months() > 0 ? formatYear() + ' and ' + formatMonth() : formatYear();
        } else if (duration.months() > 0) {
            result = duration.days() > 0 ? formatMonth() + ' and ' + formatDay() : formatMonth();
        } else if (duration.days() > 0) {
            result = duration.hours() > 0 ? formatDay() + ' and ' + formatHour() : formatDay();
        } else if (duration.hours() > 0) {
            result = duration.minutes() > 0 ? formatHour() + ' and ' + formatMinute() : formatHour();
        } else if (duration.minutes() > 0) {
            result = formatMinute();
        }

        return result;
    };
});

angular.module('xlrelease').directive('ganttDurationEditor', ['GanttElementsEditor', function (GanttElementsEditor) {
    function getParameterValue(param, parent) {
        var value = parent.data(param);
        return value !== 'null' ? value : null;
    }

    function getParameterBooleanValue(param, parent) {
        var value = parent.data(param);
        return value === true;
    }

    return {
        template: "<div duration-editor duration='duration' on-change='setDuration(duration)' editable='editable' inferred-duration='displayDuration' done='done'></div>",
        restrict: 'A',
        scope: true,
        link: function link(scope, element) {
            var parent = element.parent();
            if (!parent.length) return;

            scope.duration = getParameterValue('duration', parent);
            scope.displayDuration = getParameterValue('display-duration', parent);
            scope.editable = getParameterBooleanValue('editable', parent);
            scope.done = getParameterBooleanValue('done', parent);

            var id = parent.data('id');
            scope.setDuration = function (duration) {
                var ganttElement = gantt.getTask(id);
                GanttElementsEditor.setDuration(ganttElement, duration);
            };
        }
    };
}]);

/***/ }),
/* 1132 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('expander', function () {
    return function (scope, element, attrs) {
        element.find(".expander").on('click', function () {
            angular.element("#" + attrs.expander).toggleClass("hide");
            element.find(".arrow-down-icon").toggleClass("hide");
            element.find(".arrow-right-icon").toggleClass("hide");
        });
    };
});

/***/ }),
/* 1133 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FocusOnDirective = function () {
    function FocusOnDirective($timeout) {
        (0, _classCallCheck3.default)(this, FocusOnDirective);

        this.restrict = 'A';
        this.$timeout = $timeout;
    }

    (0, _createClass3.default)(FocusOnDirective, [{
        key: 'link',
        value: function link(scope, el, attrs) {
            var _this = this;

            scope.$watch(attrs.focusOn, function (val) {
                return _this.$timeout(function () {
                    return !!val ? el.focus() : el.blur();
                });
            });
        }
    }]);
    return FocusOnDirective;
}();

angular.module('xlrelease').directive('focusOn', ['$timeout', function ($timeout) {
    return new FocusOnDirective($timeout);
}]);

/***/ }),
/* 1134 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('focusOnClick', function () {
    return {
        restrict: 'A',
        link: function link(scope, el) {
            el.css('cursor', 'text');
            el.on('click', function () {
                el.find('input').focus();
            });
        }
    };
});

/***/ }),
/* 1135 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

__webpack_require__(1136);

var _xlrJythonMode = __webpack_require__(1138);

var _xlrJythonMode2 = _interopRequireDefault(_xlrJythonMode);

var _xlrGroovyMode = __webpack_require__(1142);

var _xlrGroovyMode2 = _interopRequireDefault(_xlrGroovyMode);

var _caretPos = __webpack_require__(1143);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').factory('inlineEditor', ['Doc', function (Doc) {
    var setEnableMode = function setEnableMode(scope) {
        scope.enableAutoComplete = angular.isDefined(scope.enableAutoComplete) ? false : scope.enableAutoComplete;
    };

    var leaveEditMode = function leaveEditMode(scope, editable, refocus) {
        scope.editMode = false;
        setEnableMode(scope);
        variableTerm = "";
        if (angular.isUndefined(refocus) || refocus === true) {
            editable.parents(".modal").focus();
        }
    };

    var leaveAutoComplete = function leaveAutoComplete(scope) {
        scope.$apply(function () {
            variableTerm = "";
            startPosition = -1;
            setEnableMode(scope);
        });
    };

    var enableAutoComplete = function enableAutoComplete(scope, editable) {
        scope.$apply(function () {
            variableTerm = "";
            scope.enableAutoComplete = true;
            if (angular.isDefined(editable.autocomplete().data('ui-autocomplete'))) {
                editable.autocomplete('enable');
            }
        });
    };

    var setVariableKey = function setVariableKey(e) {
        if (e.key !== 'Meta') {
            if (COMBINED_KEY_SET.indexOf(e.which) > -1) {
                variableTerm = variableTerm + e.key;
            } else if (e.which === 8) {
                variableTerm = variableTerm.substring(0, variableTerm.length - 1);
            }
        }
        return variableTerm;
    };

    function validate(scope) {
        var status = scope.validate({ 'draft': scope.draft });
        if (angular.isUndefined(status))
            // No validation function provided
            return true;

        scope.$apply(function () {
            scope.validationStatus = status;
        });
        return status;
    }

    var canCommit = function canCommit(scope, editable) {
        return scope.allowCommitOnInvalid === 'true' || isValid(editable) && validate(scope);
    };

    function commit(scope, editable, options, refocus) {
        if (canCommit(scope, editable) && !scope.enableAutoComplete) {
            scope.$apply(function () {
                scope.model = options.getModelFromDraft(scope.draft, scope.model);
                leaveEditMode(scope, editable, refocus);
            });
            // Callback must be called in a separate apply call in order to update the text property first.
            scope.$apply(function () {
                scope.onChange();
            });
        }
    }

    function rollback(scope, editable, refocus) {
        scope.$apply(function () {
            if (angular.isDefined(scope.enableAutoComplete)) {
                scope.draft = scope.tempDraft;
                scope.model = scope.tempDraft;
            } else {
                scope.draft = scope.model;
            }
            leaveEditMode(scope, editable, refocus);

            if (angular.isDefined(scope.validationStatus)) {
                scope.validationStatus = true;
            }
        });
    }

    function edit(scope, editable, options) {
        scope.$apply(function () {
            scope.editMode = true;
            scope.draft = options.getDraftFromModel(scope.model);
            scope.tempDraft = options.getDraftFromModel(scope.model);
        });

        if (editable.is('select')) {
            editable.focus();
        } else {
            editable.select();
        }
    }

    function commitOnBlur(scope, element, editable, options) {
        var onClickHandler = function onClickHandler(event) {
            if (scope.editMode && !angular.element.contains(element[0], event.target)) {
                commit(scope, editable, options);
            }
        };

        var unbindActionHandlers = function unbindActionHandlers() {
            angular.element(document).off('click', onClickHandler);
            angular.element(document).off('mousedown', onClickHandler);
        };

        unbindActionHandlers();
        angular.element(document).on('click', onClickHandler);
        angular.element(document).on('mousedown', onClickHandler);
        element.on('$destroy', unbindActionHandlers);
    }

    function switchOnTab(scope, element, editable, options) {
        var onFocusHandler = function onFocusHandler(event) {
            edit(scope, editable, options);
        };

        var onTabHandler = function onTabHandler(event) {
            if (event.which === 9 && scope.editMode) {
                commit(scope, editable, options, false);
            }
        };

        element.find('.focusable').focus(onFocusHandler);
        editable.keydown(onTabHandler);
    }

    function setupAutocomplete(scope, element, editable, options) {
        scope.$watch('autocompleteData', function (candidates) {
            if (candidates) {
                var autocomplete = editable.autocomplete({
                    autoFocus: true,
                    source: options.filterCandidates(candidates),
                    delay: 0,
                    minLength: 0,
                    position: {
                        my: "left top",
                        at: "left bottom",
                        collision: "flip",
                        within: ".modal-body"
                    },
                    classes: {
                        'ui-autocomplete': scope.autocompleteClasses
                    },
                    select: function select(event, ui) {
                        scope.$apply(function () {
                            scope.draft = options.getModelFromCandidate(ui.item);
                        });
                        commit(scope, editable, options, false);
                    }
                });

                if (angular.isDefined(options.renderAutocompleteItem)) {
                    autocomplete.data('ui-autocomplete')._renderItem = options.renderAutocompleteItem;
                }

                editable.focus(function () {
                    autocomplete.autocomplete('widget').position($.extend({
                        of: editable
                    }, autocomplete.autocomplete('option', 'position')));
                });
            }
        });
    }

    function setupRequired(scope, editable, attrs) {
        scope.$watch(attrs.required, function (value) {
            if (angular.isDefined(attrs.required)) {
                scope.isRequired = angular.isDefined(attrs.required) && attrs.required !== false;
            }
        });
    }

    var getCursorPos = function getCursorPos(input) {
        if ("selectionStart" in input && document.activeElement === input) {
            return {
                start: input.selectionStart,
                end: input.selectionEnd
            };
        } else if (input.createTextRange) {
            var sel = document.selection.createRange();
            if (sel.parentElement() === input) {
                var rng = input.createTextRange();
                rng.moveToBookmark(sel.getBookmark());
                var len = void 0;
                var pos = void 0;
                for (len = 0; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
                    len++;
                }
                rng.setEndPoint("StartToStart", input.createTextRange());
                for (pos = { start: 0, end: len }; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
                    pos.start++;
                    pos.end++;
                }
                return pos;
            }
        }
        return -1;
    };

    function isValid(editable) {
        return editable.hasClass('ng-valid');
    }

    // Reference for Key codes : https://www.cambiaresearch.com/articles/15/javascript-char-codes-key-codes

    var ALLOWED_KEYS_SET1 = _.range(48, 91);
    var ALLOWED_KEYS_SET2 = _.range(96, 112);
    var ALLOWED_KEYS_SET3 = _.range(186, 192);
    var ALLOWED_KEYS_SET4 = [32, 219, 220, 221, 222];
    var COMBINED_KEY_SET = ALLOWED_KEYS_SET1.concat(ALLOWED_KEYS_SET2).concat(ALLOWED_KEYS_SET3).concat(ALLOWED_KEYS_SET4);

    var variableTerm = "";
    var startPosition = -1;

    var DEFAULT_OPTIONS = {
        multiline: false,

        // Use autocomplete filtering by default
        filterCandidates: angular.identity,

        getModelFromCandidate: function getModelFromCandidate(item) {
            return item.value;
        },


        // Use model for draft by default
        getDraftFromModel: angular.identity,

        // Use draft for model by default
        getModelFromDraft: angular.identity
    };

    return {
        directive: function directive(template, options) {
            options = _.defaults(options || {}, DEFAULT_OPTIONS);

            return {
                restrict: 'A',
                templateUrl: 'partials/inline-editor/' + template,
                scope: {
                    name: '@',
                    placeholder: '@',
                    model: '=',
                    onChange: '&',
                    validate: '&',
                    validationStatus: '=',
                    selectOptions: '=',
                    autocompleteData: '=',
                    autocompleteClasses: '@',
                    allowCommitOnInvalid: '@',
                    enableAutoComplete: '=?',
                    position: '=?'
                },
                transclude: true,
                link: function link(scope, element, attrs) {
                    var elemScrollTop = 0;
                    scope.editMode = false;
                    setEnableMode(scope);
                    var editable = element.find('.editable');

                    // On click
                    element.find('.display').on('click', function (event) {
                        if (options.multiline && !angular.element(event.target).hasClass('edit-icon')) {
                            return;
                        }
                        edit(scope, editable, options);
                    });

                    element.on('click', '.display-edit-mode', function () {
                        edit(scope, editable, options);
                    });

                    if (options.multiline) {
                        element.find('.ok').on('click', function () {
                            setEnableMode(scope);
                            commit(scope, editable, options);
                        });
                        element.find('.cancel').on('click', function () {
                            setEnableMode(scope);
                            rollback(scope, editable);
                        });
                    } else {
                        // On enter
                        editable.on('keypress', function (e) {
                            if (e.which === 13 && e.ctrlKey === false) {
                                setEnableMode(scope);
                                commit(scope, editable, options);
                                e.preventDefault();
                            }
                        });
                    }

                    setupAutocomplete(scope, element, editable, options);
                    setupRequired(scope, editable, attrs);

                    // On blur
                    if (!options.doNotCommitOnBlur) {
                        commitOnBlur(scope, element, editable, options);
                    }

                    // On escape
                    editable.on('keyup', function (e) {
                        if (e.which === 27) {
                            setEnableMode(scope);
                            rollback(scope, editable);
                            e.stopPropagation();
                        }
                    });

                    editable.on('keydown', function (e) {
                        if (options.multiline) {
                            var pointerLocation = getCursorPos(editable[0]).start;
                            var left = void 0,
                                top = void 0;
                            var off = (0, _caretPos.offset)(editable[0]);
                            if (getCursorPos(editable[0]) !== -1) {
                                top = off.top - off.height;
                                left = off.left;
                            }
                            elemScrollTop = editable[0].scrollTop;
                            if (angular.isDefined(scope.enableAutoComplete) && !scope.enableAutoComplete && scope.draft && scope.draft.substring(pointerLocation - 2, pointerLocation) === "${" && e.which !== 8 && COMBINED_KEY_SET.indexOf(e.which) > -1) {
                                enableAutoComplete(scope, editable);
                                setVariableKey(e);
                                if (startPosition < 0) {
                                    startPosition = pointerLocation;
                                }
                                scope.position = { 'top': top - elemScrollTop, left: left, startPosition: startPosition, 'zindex': 100000, 'cursor': pointerLocation, 'value': variableTerm };
                            } else if (angular.isDefined(scope.enableAutoComplete) && scope.enableAutoComplete && e.which !== 27) {
                                setVariableKey(e);
                                if (scope.draft.substring(pointerLocation - 2, pointerLocation) === "${" && variableTerm.length === 0) {
                                    leaveAutoComplete(scope);
                                } else {
                                    scope.position = { 'top': top - elemScrollTop, left: left, startPosition: startPosition, 'zindex': 100000, 'cursor': pointerLocation, 'value': variableTerm };
                                }
                            } else {
                                leaveAutoComplete(scope);
                            }

                            if (e.which === 27) {
                                rollback(scope, editable, true);
                            }
                        }
                    });

                    // On tab
                    switchOnTab(scope, element, editable, options);

                    scope.isNumber = angular.isNumber;
                    scope.hasText = function (data) {
                        return !_.isEmpty(data);
                    };

                    if (angular.isDefined(attrs.markdown)) {
                        scope.helpUrl = Doc.getMarkdownSyntaxURL();
                    }

                    // Populate the draft on link so validation attributes run on the correct state
                    scope.$watch('model', function (newModel) {
                        if (newModel) {
                            scope.draft = options.getDraftFromModel(newModel);
                        }
                    });

                    // convert enum structure
                    if (scope.selectOptions && angular.isString(scope.selectOptions[0])) {
                        scope.selectOptions = scope.selectOptions.map(function (item) {
                            return { id: item, title: item };
                        });
                        if (!attrs.required) {
                            scope.selectOptions.unshift({ title: "", id: null });
                        }
                    }
                }
            };
        }
    };
}]);

angular.module('xlrelease').directive('inlineTextEditor', function (inlineEditor) {
    return inlineEditor.directive('text-field.html');
});
angular.module('xlrelease').directive('inlinePasswordEditor', function (inlineEditor) {
    return inlineEditor.directive('password-field.html');
});

angular.module('xlrelease').directive('focusWhen', [function () {
    return {
        restrict: 'A',
        link: function link(scope, element, attrs) {
            scope.$watch(attrs.focusWhen, function (value) {
                if (value) {
                    setTimeout(function () {
                        angular.element(element).focus();
                    });
                }
            });
        }
    };
}]);

angular.module('xlrelease').directive('inlineNumberEditor', function (inlineEditor) {
    return inlineEditor.directive('number-field.html');
});
angular.module('xlrelease').directive('inlineTextareaEditor', function (inlineEditor) {
    return inlineEditor.directive('textarea.html', { multiline: true });
});
angular.module('xlrelease').directive('inlineTextareaWithVariablesEditor', function (inlineEditor) {
    return inlineEditor.directive('textarea.html', { multiline: true, doNotCommitOnBlur: true });
});
angular.module('xlrelease').directive('inlineSelectEditor', function (inlineEditor) {
    return inlineEditor.directive('select.html');
});
angular.module('xlrelease').directive('inlineSimpleSelectEditor', function (inlineEditor) {
    return inlineEditor.directive('simple-select.html');
});
angular.module('xlrelease').directive('inlineListEditor', function (inlineEditor) {
    return inlineEditor.directive('list.html');
});

function inlineCodeEditor(inlineEditor, mode, VariablesInterpolator, VariablesService) {
    var codeEditor = inlineEditor.directive('code-editor.html', { multiline: true, doNotCommitOnBlur: true });

    return _.extend({}, codeEditor, {
        scope: _.extend({}, codeEditor.scope, { readOnlyMode: '=', variables: '=', ignoreScriptVariableInterpolation: '<', small: '<' }),
        link: function link(scope, element, attrs) {
            var ESC_KEY_CODE = 27;
            var aceEditor = element.find('.ace-script-editor');
            var aceScriptEditorContainer = element.find('.ace-script-editor-container');
            var resizableModal = angular.element('#resizable-modal');

            var _editor = void 0;
            var _isFullScreenMode = false;
            scope.$watch('editMode', function (editMode) {
                if (editMode) {
                    scope.aceToggleFullScreenMode();
                }
            });

            Object.defineProperty(scope, 'codeEditorModel', {
                get: function get() {
                    if (scope.editMode || scope.ignoreScriptVariableInterpolation) {
                        return scope.draft;
                    } else {
                        return VariablesInterpolator.interpolateInText(VariablesService.convertToMap(scope.variables), scope.model || '');
                    }
                },
                set: function set(value) {
                    scope.draft = value;
                }
            });

            scope.aceLoaded = function (editor) {
                var scriptEditorCode = element.find('.ace-script-editor-code');
                _editor = editor;
                editor.$blockScrolling = Infinity;
                editor.setOptions({
                    enableBasicAutocompletion: true,
                    enableLiveAutocompletion: true
                });
                editor.commands.on('afterExec', function (e) {
                    if (e.command.name === 'insertstring' && e.args === '.') {
                        editor.execCommand('startAutocomplete');
                    }
                });
                editor.commands.addCommand({
                    name: 'exitFullScreenMode',
                    bindKey: { win: 'ESC', mac: 'ESC' },
                    exec: function exec() {
                        aceEditor.removeClass('full-screen');
                        aceScriptEditorContainer.append(aceEditor);
                        aceEditor.off('keyup', handleExitFullScreenMode);
                        editor.resize();
                        editor.focus();
                        _isFullScreenMode = false;
                    },
                    readOnly: true
                });
                editor.commands.addCommand({
                    name: 'enterFullScreenMode',
                    bindKey: { win: 'Ctrl-Alt-f', mac: 'Command-Alt-f' },
                    exec: function exec() {
                        aceEditor.addClass('full-screen');
                        resizableModal.append(aceEditor);
                        aceEditor.on('keyup', handleExitFullScreenMode);
                        editor.resize();
                        editor.focus();
                        _isFullScreenMode = true;
                    },
                    readOnly: true
                });

                editor.keyBinding.addKeyboardHandler(function (editor, hashId, keyString, keyCode, event) {
                    if (keyCode === ESC_KEY_CODE) {
                        event.preventDefault();
                        event.stopPropagation();
                        return { command: 'null' }; // prevent modal close when press esc key
                    }
                });

                if (scope.small) {
                    scriptEditorCode.addClass('small');
                }
            };

            scope.codeEditorModeInitialized = mode.initialized;
            if (!scope.codeEditorModeInitialized) {
                mode.init().always(function () {
                    return scope.$apply(function () {
                        scope.codeEditorModeInitialized = mode.initialized = true;
                    });
                });
            }
            scope.codeEditorMode = mode.name;

            scope.aceToggleFullscreenBtn = function ($event) {
                if ($event) {
                    $event.preventDefault();
                    $event.stopPropagation();
                }

                var currentEditModeState = scope.editMode;
                if (!_isFullScreenMode && !scope.readOnlyMode) {
                    scope.editMode = true;
                    if (currentEditModeState === scope.editMode) {
                        scope.aceToggleFullScreenMode();
                    }
                } else {
                    scope.aceToggleFullScreenMode();
                }
            };

            scope.aceToggleFullScreenMode = function ($event) {
                if ($event) {
                    $event.preventDefault();
                    $event.stopPropagation();
                }

                if (_editor) {
                    _editor.gotoLine(0, 0);
                    _editor.session.setScrollTop(-1);
                    _editor.session.setScrollLeft(-1);
                    _isFullScreenMode ? _editor.execCommand('exitFullScreenMode') : _editor.execCommand('enterFullScreenMode');
                }
            };

            var handleExitFullScreenMode = function handleExitFullScreenMode(event) {
                event.preventDefault();
                event.stopPropagation();
                if (event.keyCode === ESC_KEY_CODE) {
                    _editor.execCommand('exitFullScreenMode');
                }
            };

            codeEditor.link(scope, element, attrs);
        }
    });
}

angular.module('xlrelease').directive('inlineJythonEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
    return inlineCodeEditor(inlineEditor, _xlrJythonMode2.default, VariablesInterpolator, VariablesService);
}]);
angular.module('xlrelease').directive('inlineGroovyEditor', ['inlineEditor', 'VariablesInterpolator', 'VariablesService', function (inlineEditor, VariablesInterpolator, VariablesService) {
    return inlineCodeEditor(inlineEditor, _xlrGroovyMode2.default, VariablesInterpolator, VariablesService);
}]);

angular.module('xlrelease').directive('inlineUserEditor', ['inlineEditor', 'UserCompletion', function (inlineEditor, UserCompletion) {
    return inlineEditor.directive('user.html', {
        renderAutocompleteItem: UserCompletion.renderItem,
        filterCandidates: UserCompletion.completionMatcher,
        getModelFromCandidate: UserCompletion.getUserFromItem,
        getDraftFromModel: function getDraftFromModel(model) {
            var username = model ? model.username : '';
            return { username: username, fullName: '' };
        },
        getModelFromDraft: function getModelFromDraft(draft, previousModel) {
            if (previousModel && previousModel.username === draft.username) {
                return previousModel;
            }

            return _.isEmpty(draft.username) ? undefined : draft;
        }
    });
}]);

var InlineDropDownListEditorController = function () {
    function InlineDropDownListEditorController(VariablesService, $q) {
        var _this = this;

        (0, _classCallCheck3.default)(this, InlineDropDownListEditorController);

        this._variablesService = VariablesService;
        this._$q = $q;
        this._values = [];
        this.isLoaded = false;
        this.isListOfObjects = false;
        this.selectedAutocompleteValue = undefined;
        this.autocompleteHandlers = {
            addCandidates: function addCandidates(metadata, options) {
                return _this.addCandidates(metadata, options);
            },
            onSelect: function onSelect(newValue) {
                _this.selectedAutocompleteValue = newValue;
                _this.variable.value = newValue.id;
                _this.onChange({ variable: _this.variable });
            },
            removeElement: function removeElement() {
                _this.selectedAutocompleteValue = undefined;
                _this.variable.value = undefined;
                _this.onChange({ variable: _this.variable });
            }
        };
    }

    (0, _createClass3.default)(InlineDropDownListEditorController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this2 = this;

            this._variablesService.getPossibleValues(this.variable).then(function (response) {
                var values = response.data;
                // use autocomplete dropdown if response contain list of object with keys 'title' and 'id'
                _this2.isListOfObjects = !_.isEmpty(values) && _.every(values, function (value) {
                    return _.isPlainObject(value) && _.has(value, "id") && _.has(value, "title");
                });
                if (values.indexOf(_this2.variable.value) === -1 && !_this2.isListOfObjects) {
                    values.unshift(_this2.variable.value);
                }
                if (_this2.isListOfObjects) {
                    _this2.selectedAutocompleteValue = values.find(function (item) {
                        return item.id === _this2.variable.value;
                    });
                }
                _this2._values = values;
                _this2.isLoaded = true;
            });
        }
    }, {
        key: 'addCandidates',
        value: function addCandidates(metadata, options) {
            var result = this.values.filter(function (item) {
                return item.title.toLowerCase().indexOf(options.term.toLowerCase()) >= 0;
            });
            return this._$q.resolve(result);
        }
    }, {
        key: 'values',
        get: function get() {
            return this._values;
        }
    }]);
    return InlineDropDownListEditorController;
}();

InlineDropDownListEditorController.$inject = ['VariablesService', '$q'];

angular.module('xlrelease').component('inlineDropDownListEditor', {
    bindings: {
        variable: '=',
        onChange: '&'
    },
    controller: InlineDropDownListEditorController,
    templateUrl: 'partials/inline-editor/inline-drop-down-list.html'
});

/***/ }),
/* 1136 */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),
/* 1137 */,
/* 1138 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MODE_NAME = 'xlr-jython';
var COMPLETION_ITEM_SCORE = 100;

function createMode(metadata) {
    var builtinSupport = _.reduce(metadata, function (acc, variable) {

        var idx = variable.name.lastIndexOf('.');
        var _ref = [variable.name.substring(0, idx), variable.name.substring(idx + 1)],
            packageName = _ref[0],
            className = _ref[1];


        var variableName = _(className).lowerFirst();

        if (/com\.xebialabs\.xlrelease\.(?:.*)(?:api\.v1)/.test(packageName)) {
            acc.variables[variableName] = variable;
            _.reduce(variable.methods, function (acc, m) {
                if (m.annotations.includes('com.xebialabs.xlplatform.documentation.PublicApiMember') && !acc.includes(m.name)) {
                    acc.push(m.name);
                }
                return acc;
            }, acc.functions);
        }
        return acc;
    }, { variables: {}, functions: [] });

    builtinSupport.variables = (0, _keys2.default)(builtinSupport.variables).sort().reduce(function (acc, key) {
        acc[key] = builtinSupport.variables[key];
        acc[key].methods.sort(byName);
        return acc;
    }, {});

    var builtinSupportVariables = _.keys(builtinSupport.variables);
    var builtinSupportFunctions = builtinSupport.functions;
    var TokenIterator = ace.require('ace/token_iterator').TokenIterator;
    var $modeId = 'ace/mode/' + MODE_NAME;

    ace.define($modeId, function (require, exports) {
        var oop = require('ace/lib/oop');
        var PythonMode = require('ace/mode/python').Mode;
        var jythonHighlightRules = require('ace/mode/' + MODE_NAME + '_highlight_rules').jythonHighlightRules;

        var Mode = function Mode() {
            this.HighlightRules = jythonHighlightRules;
        };
        oop.inherits(Mode, PythonMode);
        exports.Mode = Mode;
    });
    ace.define('ace/mode/' + MODE_NAME + '_highlight_rules', function (require, exports) {
        var oop = require('ace/lib/oop');
        var PythonHighlightRules = require('ace/mode/python_highlight_rules').PythonHighlightRules;
        var customHighlightRules = function customHighlightRules() {
            PythonHighlightRules.call(this);

            var rules = [{
                token: 'support.variable',
                regex: builtinSupportVariables.join('|')
            }, {
                token: 'support.function',
                regex: builtinSupportFunctions.join('|\.')
            }];

            for (var key in this.$rules) {
                this.$rules[key].unshift.apply(this.$rules[key], rules);
            }
        };

        oop.inherits(customHighlightRules, PythonHighlightRules);

        exports.jythonHighlightRules = customHighlightRules;
    });

    var langTools = ace.require('ace/ext/language_tools');
    var jythonCompleter = {
        getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
            if (session.$modeId !== $modeId) {
                return callback(null, []);
            }

            var stream = new TokenIterator(session, pos.row, pos.column);
            var currToken = stream.getCurrentToken();
            var prevToken = stream.stepBackward();

            if (currToken && currToken.value === '.' && prevToken && prevToken.type === 'support.variable' && builtinSupport.variables[prevToken.value]) {

                var prevValue = undefined;
                var cnt = 0;

                var methods = builtinSupport.variables[prevToken.value].methods;
                var completions = methods.filter(function (it) {
                    return it.annotations.includes('com.xebialabs.xlplatform.documentation.PublicApiMember');
                }).map(function (it, index) {
                    return {
                        value: it.name,
                        meta: 'XLRelease API',
                        score: COMPLETION_ITEM_SCORE + methods.length - index,
                        metadata: it
                    };
                })
                /*
                    to make autocomplete keep items with the same name
                    in sorted array
                 */
                .map(function (it) {
                    if (angular.isUndefined(prevValue) || it.value !== prevValue) {

                        prevValue = it.value;
                        cnt = 0;

                        return (0, _extends3.default)({}, it, {
                            caption: it.value
                        });
                    }
                    return (0, _extends3.default)({}, it, {
                        caption: it.value + ' '.repeat(++cnt)
                    });
                });

                return callback(null, completions);
            }

            var maybeVariables = builtinSupportVariables.filter(function (it) {
                return it.startsWith(prefix);
            });
            if (maybeVariables) {
                return callback(null, maybeVariables.map(function (it, index) {
                    return {
                        value: it,
                        meta: 'XLRelease API',
                        score: COMPLETION_ITEM_SCORE + maybeVariables.length - index,
                        metadata: builtinSupport[it]
                    };
                }));
            }
        },
        getDocTooltip: function getDocTooltip(item) {
            var docHTML = [];
            if (item.metadata) {
                docHTML.push('<div>', '<span class="ace_doc-name">', '<span class="ace_icon ' + (item.metadata.constructors ? 'ace_icon-object' : 'ace_icon-method') + '"></span>', item.metadata.name, '</span>', '</div>', '<div class="ace_doc-description">' + item.metadata.description + '</div>');
                if (item.metadata.parameters) {
                    docHTML.push('<ul>', item.metadata.parameters.map(function (p) {
                        return '<li>' + ('<div class="ace_doc-p-type">' + p.type + ' <span class="ace_doc-p-name">' + p.name + '</span></div>') + ('<div class="ace_doc-p-comment">' + (!!p.comment && p.comment) + '</div>') + '</li>';
                    }).join(''), '</ul>');
                }
            }
            item.docHTML = docHTML.join('');
        }
    };

    langTools.addCompleter(jythonCompleter);
}

exports.default = {
    name: MODE_NAME,
    initialized: false,
    init: function init() {
        return $.getJSON('static/8.6.1/metadata/' + MODE_NAME + '.json', function (metadata) {
            return createMode(metadata);
        });
    }
};


function byName(a, b) {
    if (a.name < b.name) return -1;
    if (a.name > b.name) return 1;
    return 0;
}

/***/ }),
/* 1139 */,
/* 1140 */,
/* 1141 */,
/* 1142 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MODE_NAME = 'xlr-groovy';
var COMPLETION_ITEM_SCORE = 100;

function createMode(metadata) {
    var contexts = _.find(metadata, function (m) {
        return !m.plugin;
    }).contexts;
    var builtinDsl = _.keys(contexts).reduce(function (acc, cn) {
        contexts[cn].methods.forEach(function (m) {
            return !acc.includes(m.name) && acc.push(m.name);
        });
        return acc;
    }, ['xlr']).sort();

    var $modeId = 'ace/mode/' + MODE_NAME;

    ace.define($modeId, function (require, exports) {
        var oop = require('ace/lib/oop');
        var GroovyMode = require('ace/mode/groovy').Mode;
        var groovyHighlightRules = require('ace/mode/' + MODE_NAME + '_highlight_rules').groovyHighlightRules;

        var Mode = function Mode() {
            GroovyMode.call(this);
            this.HighlightRules = groovyHighlightRules;
        };
        oop.inherits(Mode, GroovyMode);
        exports.Mode = Mode;
    });

    ace.define('ace/mode/' + MODE_NAME + '_highlight_rules', function (require, exports) {
        var oop = require('ace/lib/oop');
        var GroovyHighlightRules = require('ace/mode/groovy_highlight_rules').GroovyHighlightRules;
        var customHighlightRules = function customHighlightRules() {
            GroovyHighlightRules.call(this);

            var rules = [{
                token: 'support.variable',
                regex: '(' + builtinDsl.join('|') + '){1}\\b'
            }];

            for (var key in this.$rules) {
                this.$rules[key].unshift.apply(this.$rules[key], rules);
            }
        };

        oop.inherits(customHighlightRules, GroovyHighlightRules);

        exports.groovyHighlightRules = customHighlightRules;
    });

    var langTools = ace.require('ace/ext/language_tools');
    var groovyCompleter = {
        getCompletions: function getCompletions(editor, session, pos, prefix, callback) {
            if (session.$modeId !== $modeId) {
                return callback(null, []);
            }

            var prevValue = undefined;
            var cnt = 0;

            var vars = builtinDsl.filter(function (m) {
                return m.startsWith(prefix);
            });
            var completions = vars.map(function (m, index) {
                return {
                    value: m,
                    meta: 'XLRelease DSL',
                    score: COMPLETION_ITEM_SCORE + vars.length - index
                };
            })
            /*
                to make autocomplete keep items with the same name
                in sorted array
             */
            .map(function (it) {
                if (angular.isUndefined(prevValue) || it.value !== prevValue) {

                    prevValue = it.value;
                    cnt = 0;

                    return (0, _extends3.default)({}, it, {
                        caption: it.value
                    });
                }
                return (0, _extends3.default)({}, it, {
                    caption: it.value + ' '.repeat(++cnt)
                });
            });

            callback(null, completions);
        }
    };

    langTools.addCompleter(groovyCompleter);
}

exports.default = {
    name: MODE_NAME,
    initialized: false,
    init: function init() {
        return $.getJSON('static/8.6.1/metadata/' + MODE_NAME + '.json', function (metadata) {
            return createMode(metadata);
        });
    }
};

/***/ }),
/* 1143 */,
/* 1144 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('notInList', function () {
    return {
        restrict: 'A',
        require: 'ngModel',
        scope: {
            values: '=notInList'
        },
        link: function link($scope, elm, attrs, ctrl) {
            ctrl.$validators.notInList = function (modelValue, viewValue) {
                if (angular.isUndefined($scope.values)) {
                    return true;
                }
                if (!angular.isArray($scope.values)) {
                    throw new Error("List of values for 'not-in-list' directive must be an array: " + $scope.values);
                }
                if (ctrl.$isEmpty(modelValue)) {
                    return true;
                }
                if (angular.isUndefined(viewValue)) {
                    return true;
                }
                if (angular.isDefined(attrs.caseInsensitive)) {
                    return !$scope.values.some(function (value) {
                        return value.toLowerCase() === viewValue.toLowerCase();
                    });
                } else {
                    return !$scope.values.includes(viewValue);
                }
            };
        }
    };
});

/***/ }),
/* 1145 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('pagination', [function () {
    return {
        templateUrl: 'partials/directives/pagination.html',
        scope: {
            ciLoader: '='
        }
    };
}]);

/***/ }),
/* 1146 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('onClickOutsideService', [function () {
    return {
        setup: function setup(element, acceptTarget, action) {
            var clickHandler = function clickHandler(event) {
                if (acceptTarget(angular.element(event.target))) {
                    action();
                }
            };

            angular.element(document).on('click', clickHandler);
            angular.element(document).on('mousedown', clickHandler);
            element.on('$destroy', function () {
                angular.element(document).off('click', clickHandler);
                angular.element(document).off('mousedown', clickHandler);
            });
        }
    };
}]);

angular.module('xlrelease').directive('onClickOutside', ['onClickOutsideService', '$parse', function (onClickOutsideService, $parse) {
    return function (scope, element, attrs) {
        var acceptTarget = function acceptTarget(target) {
            return !target.is(element) && !target.parents().is(element);
        };
        var action = function action() {
            scope.$apply(function () {
                $parse(attrs.onClickOutside)(scope);
            });
        };
        onClickOutsideService.setup(element, acceptTarget, action);
    };
}]);

angular.module('xlrelease').directive('hidePopoverOnClick', function () {
    return function (scope, element) {
        element.on('click', function () {
            if (element.attr('disabled')) {
                return;
            }

            element.parents().find('.popover').each(function () {
                var popoverScope = angular.element(this).scope();
                popoverScope.$apply(function () {
                    popoverScope.$hide();
                });
            });
        });
    };
});

/***/ }),
/* 1147 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

exports.filterTagInput = filterTagInput;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @description
 * Directive to manage tag list input with auto-completion.
 *
 * @example
 * <div tags-input tags="releaseForm.tags" placeholder="Add a tag..." completion-candidates="candidates"></div>
 *
 * @param tags List of values within the scope.
 * @param placeholder Placeholder for the input.
 * @param completion-candidates List of candidates values within the scope.
 * @param readOnly Read only mode.
 * @param on-change Callback when tags is updated.
 */
function tagInputsFactory() {
    return {
        directive: function directive(options) {
            options.scope = options.scope || {};
            return {
                templateUrl: options.templateUrl,
                scope: (0, _extends3.default)({
                    tags: '=',
                    readOnly: '=',
                    strict: '=',
                    completionCandidates: '<',
                    variables: '=',
                    placeholder: '@',
                    onChange: '&',
                    onType: '&'
                }, options.scope),
                controller: ['$scope', '$element', function (scope, element) {
                    var ctrl = this;

                    ctrl.add = function (tag) {
                        if (!options.tagFormat.isEmpty(tag)) {
                            var alreadyExist = void 0;

                            scope.$apply(function () {
                                alreadyExist = options.tagFormat.alreadyExist(scope.tags, tag);
                                var canAdd = true;
                                if (scope.strict) {
                                    canAdd = scope.completionCandidates.find(function (e) {
                                        return e.name === tag.name;
                                    });
                                }
                                if (!alreadyExist && canAdd) {
                                    scope.tags.push(tag);
                                    triggerChange();
                                    scope.newTag = '';
                                }
                            });

                            if (alreadyExist) {
                                highlight(tag);
                            }
                        }
                    };

                    ctrl.remove = function (tag) {
                        scope.tags = _.without(scope.tags, tag);
                        triggerChange();
                    };

                    ctrl.initAutocomplete = function (candidates) {
                        var input = element.find('.tag-input');
                        var sortedCandidates = candidates.sort(options.tagFormat.comparator);

                        var fixPositioning = function fixPositioning(element) {
                            element.autocomplete('widget').position(_.assign({ of: input }, element.autocomplete('option', 'position')));
                        };

                        var autocomplete = input.autocomplete({
                            source: function source(request, response) {
                                var onlyUnusedTags = scope.tags && scope.tags.length ? sortedCandidates.filter(function (tag) {
                                    return !options.tagFormat.alreadyExist(scope.tags, tag);
                                }) : sortedCandidates;

                                return response(options.autocomplete.sourceFrom(onlyUnusedTags, request, scope));
                            },
                            delay: 0,
                            autoFocus: true,
                            select: function select(event, ui) {
                                ctrl.add(options.tagFormat.getTagFromAutocomplete(ui.item));
                            },
                            close: function close() {
                                var ul = angular.element(this).autocomplete('widget');
                                input.val(scope.newTag);
                                ul.removeClass('tags-input-autocomplete');
                                ul.css('width', '');
                            },
                            open: function open() {
                                var ul = angular.element(this).autocomplete('widget');
                                var ulW = ul.prop('clientWidth');
                                ul.addClass('tags-input-autocomplete');
                                ul.width('+=' + (ulW - ul.prop('clientWidth')));
                                fixPositioning(angular.element(this));
                            },

                            position: {
                                at: 'left bottom',
                                my: 'left top',
                                collision: 'fit flip'
                            }
                        });
                        if (angular.isDefined(options.autocomplete.renderItem)) {
                            autocomplete.data("ui-autocomplete")._renderItem = options.autocomplete.renderItem;
                        }
                    };

                    function triggerChange() {
                        if (scope.onChange) scope.onChange({ 'tags': scope.tags });
                    }

                    function highlight(tag) {
                        element.find(".tag-label:contains('" + options.tagFormat.getTagLabel(tag) + "')").parents(".tag").effect('highlight');
                    }
                }],
                link: function link(scope, element, attributes, ctrl) {
                    var hasAutocompletion = angular.isDefined(attributes.completionCandidates);
                    scope.newTag = '';
                    scope.remove = ctrl.remove;

                    if ('autofocus' in attributes) {
                        element.find('.tag-input').focus();
                    }

                    if (hasAutocompletion && !scope.readOnly) {
                        scope.$watch('completionCandidates', function (candidates) {
                            if (angular.isDefined(candidates)) {
                                ctrl.initAutocomplete(candidates);
                            }
                        });
                    }

                    element.find('.tag-input').on('keypress', function (event) {
                        // on enter
                        if (event.which === 13) {
                            ctrl.add(options.tagFormat.getTagFromInput(scope.newTag, attributes.tagType));
                            event.preventDefault();
                        }
                    });
                    element.find('.tag-input').on('keydown', function (evt) {
                        var val = element.find('.tag-input').val();
                        if (evt.which === 8 && val.length === 0) {
                            scope.$apply(function () {
                                return scope.remove(scope.tags.pop());
                            });
                        }
                    });
                }
            };
        }
    };
}

function tagsInput(TagsInputs) {
    return TagsInputs.directive({
        templateUrl: 'partials/directives/tags-input.html',
        tagFormat: {
            comparator: function comparator(tag1, tag2) {
                return tag1.localeCompare(tag2, undefined, { numeric: true });
            },
            isEmpty: function isEmpty(tag) {
                return tag === '';
            },
            alreadyExist: function alreadyExist(tags, tag) {
                return _.includes(tags, tag);
            },

            getTagLabel: angular.identity,
            getTagFromAutocomplete: function getTagFromAutocomplete(item) {
                return item.value;
            },

            getTagFromInput: angular.identity
        },
        autocomplete: {
            sourceFrom: function sourceFrom(tags, request) {
                // check https://github.com/jquery/jquery-ui/blob/master/ui/widgets/autocomplete.js#L630
                return angular.element.ui.autocomplete.filter(tags, request.term);
            }
        }
    });
}

function membersInput(TagsInputs, MemberType, memberNameFormatterFilter) {
    return TagsInputs.directive({
        templateUrl: 'partials/directives/members-input.html',
        tagFormat: {
            comparator: function comparator(member1, member2) {
                return member1.name.localeCompare(member2.name, undefined, { numeric: true });
            },
            isEmpty: function isEmpty(member) {
                return member.name === '';
            },
            alreadyExist: function alreadyExist(members, member) {
                return _.some(members, { 'name': member.name, 'type': member.type });
            },
            getTagLabel: function getTagLabel(member) {
                return member.name;
            },
            getTagFromAutocomplete: function getTagFromAutocomplete(member) {
                return (0, _extends3.default)({}, member);
            },
            getTagFromInput: function getTagFromInput(value, tagType) {
                if (tagType) {
                    return { name: value, type: tagType };
                } else {
                    return { name: value, type: MemberType.PRINCIPAL };
                }
            }
        },
        autocomplete: {
            sourceFrom: function sourceFrom(members, request) {
                var search = request.term.toLowerCase();

                function matches(name, search) {
                    return name ? name.toLowerCase().indexOf(search) !== -1 : false;
                }

                var filteredMembers = _.filter(members, function (member) {
                    return matches(member.name, search) || matches(member.fullName, search);
                });
                return filteredMembers.slice(0, 100);
            },
            renderItem: function renderItem(ul, member) {
                var div = angular.element('<div>');
                var a = angular.element('<a class="' + member.type.toLowerCase() + '"><span class="xl-icon tag-icon">');
                var label = angular.element('<span class="tag-label">');
                label.append(document.createTextNode(memberNameFormatterFilter(member)));
                label.appendTo(a);
                a.appendTo(div);

                return angular.element('<li>').attr('data-ui-autocomplete-item', angular.toJson(member)).append(div).appendTo(ul);
            }
        }
    });
}

function filterTagInput(TagsInputs) {
    return TagsInputs.directive({
        templateUrl: 'partials/directives/filter-tag-input.html',
        scope: {
            prepend: '<'
        },
        tagFormat: {
            comparator: function comparator(tag1, tag2) {
                return tag1.id.localeCompare(tag2.id, undefined, { numeric: true });
            },
            isEmpty: function isEmpty(tag) {
                return !tag || !tag.id;
            },
            alreadyExist: function alreadyExist(tags, tag) {
                return !!tags.find(function (t) {
                    return t.id === tag.id;
                });
            },
            getTagLabel: function getTagLabel(tag) {
                return tag.title;
            },
            getTagFromAutocomplete: function getTagFromAutocomplete(tag) {
                return (0, _extends3.default)({}, tag);
            },

            getTagFromInput: angular.identity
        },
        autocomplete: {
            sourceFrom: function sourceFrom(candidates, request, scope) {
                var search = request.term.toLowerCase();

                function matches(title, search) {
                    return title ? title.toLowerCase().indexOf(search) !== -1 : false;
                }

                return candidates.filter(function (candidate) {
                    return matches(candidate.title, search);
                }).slice(0, 100);
            },
            renderItem: function renderItem(ul, tag) {
                return angular.element('<li>').append('<a><span class="tag-label">' + tag.title + '</span></a>').appendTo(ul);
            }
        }
    });
}

filterTagInput.$inject = ['TagsInputs'];
tagsInput.$inject = ['TagsInputs'];
membersInput.$inject = ['TagsInputs', 'MemberType', 'memberNameFormatterFilter'];

angular.module('xlrelease').factory('TagsInputs', tagInputsFactory);

angular.module('xlrelease').directive('tagsInput', tagsInput);
angular.module('xlrelease').directive('membersInput', membersInput);
angular.module('xlrelease').directive('filterTagInput', filterTagInput);

/***/ }),
/* 1148 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('stopClickPropagation', function () {
    return function (scope, element) {
        element.on('click', function (event) {
            event.stopPropagation();
        });
    };
});

angular.module('xlrelease').directive('stopSubmitPropagation', function () {
    return function (scope, element) {
        element.on('keyup keypress', function (event) {
            var code = event.keyCode || event.which;
            if (code === 13) {
                event.stopPropagation();
                return false;
            }
        });
    };
});

/***/ }),
/* 1149 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('scrollToItem', function () {
    return {
        restrict: 'A',
        scope: {
            container: "@",
            scrollTo: "@"
        },
        link: function link(scope, $elm, attr) {
            $elm.on("click", function () {
                var $container = angular.element(scope.container);
                var scrollOffset = angular.element(scope.scrollTo).offset().top - $container.offset().top;
                $container.animate({ scrollTop: scrollOffset }, "slow");
            });
        }
    };
});

/***/ }),
/* 1150 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Detects fully visible items in the parent container.
 *
 * Example:
 * <div class="card-content">
 *      <div class="report-content">
 *          <div show-fully-visible-only parent-selector=".card-content">
 *              <div class="row" ng-repeat="activity in $ctrl.deploymentsActivity"></div>
 *          </div>
 *      </div>
 * </div>
 */
angular.module('xlrelease').directive('detectFullyVisibleItems', ['$timeout', function ($timeout) {
    return {
        restrict: 'A',

        link: function link(scope, element, $attrs) {
            $timeout(function () {
                var outerHeight = ($attrs.parentSelector ? element.parents($attrs.parentSelector) : element).outerHeight();
                var totalHeight = 0;

                var lastVisibleItem = void 0;
                element.children().each(function () {
                    var currentElement = angular.element(this);
                    totalHeight += currentElement.outerHeight();
                    if (totalHeight > outerHeight) {
                        currentElement.addClass('not-fully-visible-item');
                        currentElement.nextAll().addClass('not-visible-item');
                        return false;
                    }
                    lastVisibleItem = currentElement.addClass('fully-visible-item');
                });

                if (lastVisibleItem) {
                    lastVisibleItem.addClass('last-visible-item');
                }
            });
        }
    };
}]);

/***/ }),
/* 1151 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * @ngdoc directive
 * @module xlrelease
 * @name contextMenu
 *
 * @element ANY
 * @description renders menu items using task-context-menu.html template. Menu items can be passed into the directive
 * using `items` attribute. `items` attribute will be evaluated and it should return array of menu items in the
 * expected format (see example or a template for the expected format of menu items).
 *
 * @param {expression} expression to evaluate that will return menu items
 *
 * @example
 * This example shows how to create context menu with a help of a popover.
 * To create a popover:
 *
 ```
 <div ng-if="!isTaskReadOnly(task) || isTaskDoneInAdvance(task)" class="context-menu-button dropdown-button pull-right"
 bs-popover data-content-template="partials/tasks/context-menu.html" data-placement="bottom" auto-close="true" >
 ```
 *
 * and a context-menu.html (uses this directive):
 ```
 <context-menu id="context-menu-container" items="taskContextMenuItems(task, release, container, groupedTaskDefinitions) ctrl='ctrl' task='task' container='task.parent'"></context-menu>
 ```
 *
 * where :
 * ctrl is the controller that offers the necessary functions to the opened modals. The ctrl must have a 'ctrlScope' property. This is used as the parent scope
 *      the resulting model.
 * task is the task that this context menu controls.
 * container is the container for the current task
 * taskContextMenuItems is a controller method that returns menu items with the following structure:
 ```
 var items = [
 {
     type: 'modal,
     text: 'Menu item',
     disabled: 'true|false',
     modal: 'partials/modal/to/show.html',
     cssClass: 'remove-task-button'
 },
 {
     type: 'click',
     text: 'Menu item',
     disabled: 'true|false',
     click: function () {
         // click Action, optional
     },
     cssClass: 'something'
 },
 {
     type: 'noaction',
     text: 'Menu item',
     disabled: 'true',
     cssClass: 'some-class'
 },
 {
     type: 'divider'
 },
 {
     type: 'template',
     disabled: 'true',
     templateUrl: '',
     isSameType: '',
     taskDefinition: {}
 },
 {
     type: 'submenu',
     items: [
     ]
 }
 ];
 ```
 */

angular.module('xlrelease').directive('contextMenuPopover', ['$popover', function ($popover) {
    'use strict';

    return {
        restrict: 'A',
        replace: true,
        template: '<div class="context-menu-button dropdown-button pull-right"><i class="xl-icon options-icon"></i></div>',
        link: function link(scope, element, attrs) {
            scope.items = scope.$eval(attrs.items);
            scope.scrollableChangeTaskType = scope.$eval(attrs.scrollableChangeTaskType);

            var handleScrollPhase = function handleScrollPhase(event) {
                var popover = event.data.popover;

                popover.hide();
            };

            $popover(element, {
                scope: scope,
                templateUrl: 'partials/tasks/context-menu.html',
                placement: 'auto bottom',
                viewport: { selector: '#release-content' },
                autoClose: true,
                target: element,
                onShow: function onShow(attr) {
                    var popover = attr.$element;
                    var phaseContent = popover.closest('.phase-content');
                    phaseContent.on('scroll', { popover: popover }, handleScrollPhase);
                },
                onBeforeHide: function onBeforeHide(attr) {
                    var popover = attr.$element;
                    var phaseContent = popover.closest('.phase-content');
                    phaseContent.off('scroll', handleScrollPhase);
                }
            });
        }
    };
}]);

angular.module('xlrelease').directive('contextMenu', ['$window', 'ModalService', function ($window, ModalService) {
    'use strict';

    return {
        templateUrl: 'partials/tasks/task-context-menu.html',
        restrict: 'EA',
        link: function link(scope, element, attr) {
            scope.items = scope.$eval(attr.items);
            scope.task = scope.$eval(attr.task);
            scope.ctrl = scope.$eval(attr.ctrl);
            scope.container = scope.$eval(attr.container);
            scope.contentContainer = element;
            scope.getContentPath = getContentPath;

            scope.openModal = function (modalUrl, item) {
                if (item.disabled) {
                    return;
                }

                var childScope = scope.ctrl.ctrlScope.$new();
                childScope.task = scope.task;
                childScope.ctrl = scope.ctrl;
                childScope.container = scope.container;
                childScope.item = item;
                ModalService.open(childScope, '\'' + modalUrl + '\'', null, null, false, false);

                childScope.showModal();
            };

            scope.handleClick = function (item) {
                if (item.disabled) {
                    return;
                }
                var promise = item.click();
                var processHandler = function processHandler() {
                    if (scope.ctrl.contextMenuClickProcessed) {
                        scope.ctrl.contextMenuClickProcessed(true);
                    }
                };
                if (promise && promise.then) {
                    promise.then(processHandler);
                } else {
                    processHandler();
                }
            };
            scope.mouseEnter = function (event, item) {
                if (item.disabled) {
                    return;
                }
                var $li = angular.element(event.currentTarget);
                var $ul = $li.parent();
                var level = $ul.data('level') || 0;

                resetActiveElements(scope.contentContainer, level);

                var contentId = $li.data('content-id');
                if (contentId) {
                    var $content = scope.contentContainer.find('ul[data-id="' + contentId + '"]');
                    if ($content.length) {

                        $li.addClass('active');
                        $content.addClass('active');

                        var _getContentCoords = getContentCoords($li, $ul, $content, $window),
                            top = _getContentCoords.top,
                            left = _getContentCoords.left;

                        $content.css({
                            top: top + 'px',
                            left: left + 'px'
                        });
                    }
                }
            };
            element.addClass('dropdown');
        }
    };
}]);

function getContentCoords($li, $ul, $content, $window) {

    var ulPaddingTop = parseInt($ul.css('padding-top'), 10);
    var ulBorderTop = parseInt($ul.css('border-top-width'), 10);
    var ulBorderLeft = parseInt($ul.css('border-left-width'), 10);

    var top = $ul.position().top + $li.position().top - ulPaddingTop + ulBorderTop - 1;
    var left = $ul.position().left + $li.position().left + $li.width() + ulBorderLeft;

    if ($li.offset().top + $content.height() > $window.innerHeight) {
        top = top - $content.height() + $li.height();
    }
    return { top: top, left: left };
}

function resetActiveElements(contentContainer, level) {

    var lis = level ? contentContainer.find('ul.dropdown-menu[data-level="' + level + '"] li') : contentContainer.find('ul.dropdown-menu li');
    lis.removeClass('active');

    contentContainer.find('ul.dropdown-menu[data-level="' + (level + 1) + '"]').removeClass('active');
    contentContainer.find('ul.dropdown-menu[data-level="' + (level + 2) + '"]').removeClass('active');
}

function getContentPath(parentPath, item) {
    return parentPath ? parentPath + '/' + item.text : item.text;
}

angular.module('xlrelease').directive('portal', [function () {
    return {
        restrict: 'EA',
        link: function link(scope, element) {
            // [div.portal] < [li.dropdown-submenu] < [ul.dropdown-menu] < [div#context-menu-container]
            var container = element.parent().parent().parent();
            scope.path = getContentPath(scope.path, scope.item);

            if (container.length) {
                var content = element.children();
                content.attr('data-level', scope.level);
                content.attr('data-id', scope.path);
                container.append(content);
            }
            element.remove();
        }
    };
}]);

/***/ }),
/* 1152 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('timeZoneTooltip', ['tooltipService', 'CurrentTimeZone', function (tooltipService, CurrentTimeZone) {
    return {
        restrict: 'A',
        link: function link(scope, element) {
            var text = CurrentTimeZone.timeZone;
            tooltipService.setup(element, text, 'right');
        }
    };
}]);

angular.module('xlrelease').factory('CurrentTimeZone', [function () {
    var timeZone = jstz.determine().name();

    // "America/New_York" becomes "New York"
    timeZone = timeZone.replace(/^.*\//, '').replace(/_/g, ' ');

    return {
        timeZone: timeZone
    };
}]);

/***/ }),
/* 1153 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('tooltipService', ['$tooltip', '$window', function ($tooltip, $window) {
    return {
        setup: function setup(element, tooltipTitle, position, threshold) {
            if (!position) {
                position = 'top';
            }

            var tt = void 0;
            var initTooltip = function initTooltip() {
                return $tooltip(element, {
                    title: tooltipTitle,
                    placement: position,
                    html: true,
                    container: 'body'
                });
            };
            var onResize = function onResize() {
                if ($window.innerWidth <= threshold && !tt) {
                    tt = initTooltip();
                } else if ($window.innerWidth > threshold && tt) {
                    tt.destroy();
                    tt = undefined;
                }
            };

            if (threshold) {
                if ($window.innerWidth <= threshold) {
                    tt = initTooltip();
                }
                angular.element($window).on('resize', onResize);
            } else {
                tt = initTooltip();
            }

            element.on("$destroy", function () {
                angular.element($window).off('resize', onResize);
                if (tt) {
                    tt.destroy();
                }
            });
        }
    };
}]);

/**
 * Wraps bootstrap tooltip (see http://getbootstrap.com/2.3.2/javascript.html#tooltips)
 *
 * Usage:
 *      Static text :
 *          <span tooltip="'tooltip content'" tooltip-position="top | bottom | left | right"></span>
 *      Dynamic property (here object.property) :
 *          <span tooltip="object.property" tooltip-position="top | bottom | left | right"></span>
 *
 * The tooltip-position attribute is optional, default value is "top".
 * HTML gets escaped.
 */
angular.module('xlrelease').directive('tooltip', ['tooltipService', function (tooltipService) {
    return {
        restrict: 'A',
        link: function link(scope, element, attrs) {
            scope.$watch(attrs.tooltip, function (value) {
                tooltipService.setup(element, _.escape(value), attrs.tooltipPosition, attrs.tooltipThreshold);
            });
        }
    };
}]);

/***/ }),
/* 1154 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var uiLayoutConfig = {
    uiLayout: {
        applyDefaultStyles: false
    }
};

LayoutDirective.$inject = ['$window', '$timeout', 'uiLayoutConfig', 'ClientSettings', 'EventBus', 'Events'];
function LayoutDirective($window, $timeout, uiLayoutConfig, ClientSettings, EventBus, Events) {
    var options = uiLayoutConfig.uiLayout || {};
    var centerMinWidth = 600;

    function compileFn(tElm, tAttrs) {
        if (angular.isUndefined($window.jQuery)) {
            throw new Error('ui-jq: Need jQuery, maybe...');
        }
        if (!angular.isFunction(angular.element(tElm).layout)) {
            throw new Error('ui-jq: Need jquery.layout, maybe...');
        }
        return function (scope, iElement, iAttr) {
            options = angular.extend({}, options, scope.$eval(tAttrs.options));
            var toggleButtons = '<div class="toggler toggler-expand" title="Expand"><i class="xl-icon chevron-right-icon icon-s"/></div>' + '<div class="toggler toggler-collapse" title="Collapse"><i class="xl-icon chevron-left-icon icon-s"/></div>';

            var layoutCache = ClientSettings.getFolderLayoutCache() || {};
            var minWestSize = 330;
            var westSize = layoutCache.westSize || minWestSize;

            options = {
                applyDefaultStyles: true,
                spacing_open: 0,
                spacing_closed: 0,
                //animatePaneSizing: true,
                west__slidable: false,
                west__resizerDblClickToggle: false,
                west__togglerContent_open: toggleButtons,
                west__togglerContent_closed: toggleButtons,
                west__togglerLength_closed: 1,
                west__togglerLength_open: 1,
                west__spacing_closed: 4,
                west__spacing_open: 4,
                west__size: westSize,
                west__initClosed: layoutCache.westIsClosed || false,
                west__onresize: onResize,
                west__onopen: onOpenClose,
                west__onclose: onOpenClose,
                west__minSize: minWestSize,
                stateManagement: {
                    enabled: true
                }
            };

            // only set minWidth if we are not expanded
            if (layoutCache.state !== 'W|') {
                options.center__minWidth = centerMinWidth;
            }

            var layout = angular.element(tElm).layout(options);
            $timeout(layout.resizeAll, 100); // TODO: quick temporary workaround for wrong pane height calculation (78px, that is the parents top too much)

            var $westToggler = layout.togglers.west;
            $westToggler.unbind("click");
            $westToggler.unbind("dblclick");

            $westToggler.find(".toggler-expand").click(expandWest);
            $westToggler.find(".toggler-collapse").click(collapseWest);

            var state = layoutCache.state || 'W|C';
            var previousWestSize = layoutCache.state === 'W|C' ? westSize : 0.25;

            function expandWest(evt) {
                if (state === 'W|C') {
                    //if we don't remove the limits you can't expand the center panel
                    layout.options.center.minWidth = "0%";
                    previousWestSize = layout.state.west.size;
                    layout.sizePane("west", 9999);
                    state = 'W|';
                } else if (state === '|C') {
                    layout.open("west");
                    state = 'W|C';
                }
                EventBus.emitEvent(Events.uiLayout.expand, [state]);
                layoutCache.state = state;
                ClientSettings.setFolderLayoutCache(layoutCache);
            }

            function collapseWest(evt) {
                if (state === 'W|C') {
                    previousWestSize = layout.state.west.layoutWidth;
                    layout.close("west");
                    state = '|C';
                } else if (state === 'W|') {
                    //restore original width restriction
                    layout.options.center.minWidth = centerMinWidth;
                    layout.open("west");
                    layout.sizePane("west", previousWestSize);
                    state = 'W|C';
                }
                EventBus.emitEvent(Events.uiLayout.collapse, [state]);
                layoutCache.state = state;
                ClientSettings.setFolderLayoutCache(layoutCache);
            }

            function onResize() {
                EventBus.emitEvent(Events.uiLayout.resize);
                layoutCache.westSize = layout.state.west.size;
                ClientSettings.setFolderLayoutCache(layoutCache);
            }

            function onOpenClose() {
                layoutCache.westIsClosed = layout.state.west.isClosed;
                ClientSettings.setFolderLayoutCache(layoutCache);
            }
        };
    }

    return {
        priority: 0,
        restrict: 'EA',
        compile: compileFn
    };
}

function PaneDirectiveFactory(clazz) {
    var directive = {
        priority: 1,
        restrict: 'EA',
        transclude: true,
        replace: true,
        template: '<div class=' + clazz + '><div ng-transclude></div></div>'
    };

    return function () {
        return directive;
    };
}

angular.module('xlrelease').value('uiLayoutConfig', uiLayoutConfig);

angular.module('xlrelease').directive('uiLayout', LayoutDirective);
angular.module('xlrelease').directive('uiLayoutCenter', PaneDirectiveFactory('ui-layout-center'));
angular.module('xlrelease').directive('uiLayoutNorth', PaneDirectiveFactory('ui-layout-north'));
angular.module('xlrelease').directive('uiLayoutSouth', PaneDirectiveFactory('ui-layout-south'));
angular.module('xlrelease').directive('uiLayoutEast', PaneDirectiveFactory('ui-layout-east'));
angular.module('xlrelease').directive('uiLayoutWest', PaneDirectiveFactory('ui-layout-west'));

/***/ }),
/* 1155 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('UserCompletion', ['usernameFormatterFilter', function (usernameFormatterFilter) {
    return {
        completionMatcher: function completionMatcher(users) {
            // Ensure username will be set in the input when choosing a candidate.
            _.forEach(users, function (user) {
                return user.value = user.username;
            });
            return function (request, response) {
                var search = request.term.toLowerCase();
                var matches = function matches(name, s) {
                    return name ? name.toLowerCase().indexOf(s) !== -1 : false;
                };
                var filteredUsers = _.filter(users, function (user) {
                    return matches(user.username, search) || matches(user.fullName, search);
                });
                return response(filteredUsers);
            };
        },
        getUserFromItem: function getUserFromItem(item) {
            return { username: item.username, fullName: item.fullName };
        },
        renderItem: function renderItem(ul, user) {
            var div = angular.element('<div>');
            var a = angular.element('<a class="principal"><span class="xl-icon tag-icon">');
            var label = angular.element('<span class="tag-label">');
            label.append(document.createTextNode(usernameFormatterFilter(user)));
            label.appendTo(a);
            a.appendTo(div);

            return angular.element('<li>').attr('data-ui-autocomplete-item', angular.toJson(user)).append(div).appendTo(ul);
        }
    };
}]);

/***/ }),
/* 1156 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


(function () {
    var XlrDipOfInlineWithVariablesDirective = function XlrDipOfInlineWithVariablesDirective() {
        return {
            scope: {
                propertyDefinitions: '=',
                propertyValues: '=',
                variables: '=',
                readOnly: '=',
                enforceMode: '=',
                showRequiredSign: '=?',
                // for task input properties of type text we don't use variable selector, for output properties we do
                showVariableSelectorForText: '=',
                onChange: '&',
                onNewVariable: '&',
                ignoreScriptVariableInterpolation: '=',
                reloadTaskVariablesCallback: '&'
            },
            restrict: 'AE',
            templateUrl: 'partials/directives/xlr-dip-of-inline-with-variables.html',
            controller: 'xlrDipOfInlineWithVariablesController',
            controllerAs: 'xlrDipCtrl',
            bindToController: true
        };
    };

    var injectParams = ['$scope', 'ConfigurationInstances', 'newlinesFilter', '$stateParams', 'Ids'];
    var XlrDipOfInlineWithVariablesController = function XlrDipOfInlineWithVariablesController($scope, ConfigurationInstances, newlinesFilter, $stateParams, Ids) {
        var vm = this;

        vm.newlinesFilter = newlinesFilter;
        vm.IGNORE_SCRIPT_VARIABLE_INTERPOLATION = 'scriptIgnoreVariableInterpolation';
        vm.showRequiredSign = _.isUndefined(vm.showRequiredSign) ? true : vm.showRequiredSign;
        vm.ConfigurationInstances = ConfigurationInstances;
        vm.onNewVariablePF = function (name, variableType, createdCallback) {
            vm.onNewVariable({
                name: name,
                variableType: variableType,
                createdCallback: createdCallback
            });
        };

        var selectOptions = {};
        vm.selectOptions = function (p) {
            if (_.isUndefined(selectOptions[p.name])) {
                selectOptions[p.name] = (p.required ? [] : [{
                    title: "(None)",
                    id: null
                }]).concat(ConfigurationInstances.getInstancesByType(p.referencedType));
            }
            return selectOptions[p.name];
        };
        ///

        vm.updateIgnoreVariableInterpolation = function () {
            vm.onChange().then(function () {
                vm.reloadTaskVariablesCallback();
            });
        };

        vm.ignoreVariableInterpolation = function (name) {
            return vm.hasIgnoreScriptProperty(name) && vm.propertyValues[vm.IGNORE_SCRIPT_VARIABLE_INTERPOLATION].value;
        };

        vm.hasIgnoreScriptProperty = function (propertyName) {
            return propertyName === 'script' && angular.isDefined(vm.propertyValues[vm.IGNORE_SCRIPT_VARIABLE_INTERPOLATION]);
        };

        if (!ConfigurationInstances.loaded()) {
            var folderId = $stateParams.folderId ? $stateParams.folderId : Ids.releaseIdToFolderId($stateParams.releaseId);
            ConfigurationInstances.load(folderId);
        }
        $scope.$on('$destroy', function () {
            ConfigurationInstances.reset();
        });
    };
    XlrDipOfInlineWithVariablesController.$inject = injectParams;

    angular.module('xlrelease').controller('xlrDipOfInlineWithVariablesController', XlrDipOfInlineWithVariablesController);
    angular.module('xlrelease').directive('xlrDipOfInlineWithVariables', XlrDipOfInlineWithVariablesDirective);
})();

/***/ }),
/* 1157 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('xlrInlineTextWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'StringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-inline-text-with-variables.html'
}));

angular.module('xlrelease').directive('xlrInlineTextareaWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'StringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-inline-textarea-with-variables.html',
    getAllTypes: true
}));

angular.module('xlrelease').directive('xlrInlinePasswordWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'PasswordStringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-inline-password-with-variables.html'
}));

angular.module('xlrelease').directive('xlrListOfStringsWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'ListStringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-list-of-strings-with-variables.html'
}));

angular.module('xlrelease').directive('xlrSetOfStringsWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'SetStringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-set-of-strings-with-variables.html'
}));

angular.module('xlrelease').directive('xlrMapStringStringWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'MapStringStringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-map-string-string-with-variables.html'
}));

angular.module('xlrelease').directive('xlrBooleanWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'BooleanVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-boolean-with-variables.html'
}));

angular.module('xlrelease').directive('xlrIntegerWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'IntegerVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-integer-with-variables.html'
}));

angular.module('xlrelease').directive('xlrDependencyWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'StringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-dependency-with-variables.html'
}));

angular.module('xlrelease').directive('xlrDateWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'DateVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-date-with-variables.html'
}));

angular.module('xlrelease').directive('xlrDropdownWithVariables', xlrInputWithVariablesDirective({
    variableTypeId: 'StringVariable',
    templateUrl: 'partials/directives/variable-selector/xlr-dropdown-with-variables.html'
}));

angular.module('xlrelease').directive('xlrTemplateFromValueOrVariableSelector', xlrInputWithVariablesDirective({
    variableTypeId: 'StringVariable',
    templateUrl: 'partials/directives/xlr-template-from-value-or-variable-selector.html'
}));

function xlrInputWithVariablesDirective(viewParameters) {
    var directive = {
        scope: {
            name: '=',
            model: '=',
            onNew: '&',
            supportsNew: '=?',
            onChange: '&',
            variables: '=',
            options: '=',
            readOnly: '=',
            isReady: '=?',
            enforceMode: '=',
            position: '=?',
            release: '=?'
        },
        restrict: 'A',
        controller: InputWithVariablesController,
        controllerAs: 'vm',
        bindToController: true,
        templateUrl: viewParameters.templateUrl
    };

    InputWithVariablesController.$inject = ['$q', '$scope', 'VariablesService'];

    function InputWithVariablesController($q, $scope, VariablesService) {
        var vm = this;
        var draftIsInitialized = false;

        vm.handlers = {
            onSelect: viewParameters.getAllTypes ? variableTextAreaSelectedHandler : variableSelectedHandler,
            addCandidates: viewParameters.getAllTypes ? variableTextInputAutocompleteHandler : variableAutocompleteHandler,
            onFormat: function onFormat(value) {
                var formattedValue = VariablesService.hasVariableSyntax(value) ? value : VariablesService.withVariableSyntax(value);

                // if formattedValue matches fully an existing variable name, take the full displayName to remove the 'New item' option
                var existingVariable = _.find(vm.variables, { variableName: formattedValue });
                if (existingVariable) {
                    formattedValue = existingVariable.displayName;
                }
                return formattedValue;
            }
        };

        var supportsNew = angular.isDefined(vm.supportsNew) ? vm.supportsNew : true;
        if (supportsNew) {
            vm.handlers.onNewItem = createNewVariableHandler;
            vm.handlers.onNewItemInTextArea = createNewVariableInTextAreaHandler;
        }

        vm.toggleMode = toggleMode;
        vm.onChangeInternal = onChangeInternal;

        vm.updateDraftFromModel = updateDraftFromModel;
        vm.updateModelFromDraft = updateModelFromDraft;

        vm.onNewVariable = onNewVariable;

        var variableType = VariablesService.getVariableTypeById(viewParameters.variableTypeId);

        vm.variableType = variableType.key;
        vm.showToggle = false;

        vm.variableTypeName = variableType.label;

        vm.commit = commit;

        calculateMode();

        /////

        function onNewVariable(variable) {
            VariablesService.createReleaseVariable(vm.release.id, variable).then(function (resp) {
                if (variable.createdCallback) {
                    variable.createdCallback(resp.data);
                }
            });
        }

        function updateDraftFromModel(model) {
            vm.draft = {
                variable: _.find(vm.variables, { variableName: model.variable }),
                value: model.value
            };
        }

        function updateModelFromDraft(draft, variableMode) {
            var value = draft.value;
            if (!variableMode && value === vm.model.value && vm.variableTypeName === 'Date') return false;
            var variableName = draft.variable ? draft.variable.variableName : null;

            if (vm.enforceMode === 'variable') {
                _.extend(vm.model, {
                    value: value,
                    variable: variableName
                });
            } else {
                _.extend(vm.model, {
                    value: !variableMode ? value : null,
                    variable: variableMode ? variableName : null
                });
            }

            return true;
        }

        /////

        $scope.$watch(function () {
            return { model: vm.model, variables: vm.variables };
        }, function (val) {

            var isValidModelValue = !(_.isNull(val.model) || _.isUndefined(val.model));

            if (!draftIsInitialized && isValidModelValue && val.variables) {
                vm.updateDraftFromModel(val.model);
                calculateMode();
                draftIsInitialized = true;
            }
        }, true);

        $scope.$watch('vm.draft.variable', function (newVariable, oldVariable) {
            if (oldVariable && !newVariable) {
                variableDeselectedHandler();
            }
        });

        function commit() {
            var isModelUpdated = vm.updateModelFromDraft(vm.draft, vm.variableMode);
            if (isModelUpdated) {
                vm.onChange();
            }
        }

        function toggleMode() {
            vm.variableMode = !vm.variableMode;
            if (!vm.variableMode || vm.variableMode && vm.draft.variable) {
                commit();
            }
        }

        function createNewVariableHandler(variable) {
            var deferred = $q.defer();
            vm.updateModelFromDraft(vm.draft, vm.variableMode);
            vm.onNew({
                name: variable.displayName,
                variableType: vm.variableType,
                createdCallback: function createdCallback(createdVariable) {
                    createdVariable.displayName = createdVariable.variableName = VariablesService.withVariableSyntax(createdVariable.key);
                    vm.variables.push(createdVariable);

                    _.extend(vm.model, {
                        value: null,
                        variable: VariablesService.getKey(createdVariable)
                    });

                    vm.onChange();
                    deferred.resolve(createdVariable.displayName);
                }
            });

            return deferred.promise;
        }

        function createNewVariableInTextAreaHandler(variable) {
            var deferred = $q.defer();
            if (!vm.model) {
                vm.model = "";
                vm.updateDraftFromModel(vm.model);
            }
            vm.updateModelFromDraft(vm.draft, vm.variableMode);
            vm.onNewVariable({
                key: variable.displayName,
                variableType: vm.variableType,
                createdCallback: function createdCallback(createdVariable) {
                    createdVariable.displayName = createdVariable.variableName = VariablesService.withVariableSyntax(createdVariable.key);
                    vm.variables.push(createdVariable);
                    deferred.resolve(createdVariable.displayName);
                }
            });

            return deferred.promise;
        }

        function variableSelectedHandler() {
            commit();
        }

        function variableTextAreaSelectedHandler(newVal) {
            vm.model = newVal.value;
            vm.draft = newVal;
        }

        function variableDeselectedHandler() {
            commit();
        }

        function onChangeInternal() {
            commit();
        }

        function variableAutocompleteHandler(metadata, options) {
            var deferred = $q.defer();
            var candidates = _.filter(vm.variables, function (variable) {
                return vm.variableType === variable.type && variable.displayName.indexOf(options.term) !== -1;
            });
            deferred.resolve(candidates);
            return deferred.promise;
        }

        function variableTextInputAutocompleteHandler(metadata, options) {
            var deferred = $q.defer();
            var candidates = _.filter(vm.variables, function (variable) {
                return variable.displayName.indexOf(options.term) !== -1;
            });
            deferred.resolve(candidates);
            return deferred.promise;
        }

        function calculateMode() {
            if (vm.enforceMode) {
                vm.showToggle = false;
                vm.variableMode = vm.enforceMode === 'variable';
            } else {
                vm.showToggle = true;
                vm.variableMode = vm.draft && !!vm.draft.variable;
            }
        }
    }

    return function () {
        return directive;
    };
}

/***/ }),
/* 1158 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var THROTTLE_TIMEOUT = 100;

angular.module('xlrelease').directive('echarts', ['$window', 'Events', function ($window, Events) {
    var events = {
        ecClick: 'click',
        ecDblclick: 'dblclick',
        ecMousedown: 'mousedown',
        ecMousemove: 'mousemove',
        ecMouseup: 'mouseup',
        ecMouseover: 'mouseover',
        ecMouseout: 'mouseout'
    };

    var eventsKey = _.keys(events);
    var eventsBinding = _.zipObject(eventsKey, _.map(eventsKey, _.constant('&')));

    return {
        restrict: 'E',
        scope: angular.extend({
            options: '=',
            container: '@'
        }, eventsBinding),
        template: '<div options="options"></div>',
        link: function link(scope, element, attrs) {
            var ngWrapper = element.find('div').get(0);
            var ngParent = scope.container ? angular.element(element).closest(scope.container).get(0) : element.parent().parent().get(0);

            var chart = void 0;

            function initChart() {
                chart = echarts.init(ngWrapper);
                // Bind listeners
                _.keys(attrs).forEach(function (attrName) {
                    if (eventsKey.indexOf(attrName) !== -1) {
                        chart.on(events[attrName], function (params) {
                            scope[attrName]({ params: params });
                        });
                    }
                });
            }

            function updateSize() {
                ngWrapper.style.width = ngParent.clientWidth + 'px';
                ngWrapper.style.height = ngParent.clientHeight + 'px';

                if (chart) {
                    chart.resize();
                }
            }

            function setOptions(value) {
                updateSize();
                if (!chart) {
                    initChart();
                }
                chart.setOption(value);
            }

            scope.$watch(function () {
                return scope.options;
            }, function (value) {
                return value && setOptions(value);
            }, true);

            // Add responsiveness to echarts
            var updateSizeWithThrottle = _.throttle(updateSize, THROTTLE_TIMEOUT);
            angular.element($window).on('resize', updateSizeWithThrottle);
            scope.$on(Events.tile.resized, function () {
                return updateSizeWithThrottle();
            });
            scope.$on('$destroy', function () {
                return angular.element($window).off('resize', updateSizeWithThrottle);
            });
        }
    };
}]);

/***/ }),
/* 1159 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('shortenContent', [function () {
    return {
        restrict: 'A',
        link: function link(scope, element) {
            var watch = function watch() {
                var cancel = scope.$watch(function () {
                    return element.prop('scrollHeight');
                }, function () {
                    var isCanceled = false;
                    if (element.height() < element.prop('scrollHeight')) {
                        isCanceled = true;
                        cancel();
                    }
                    var words = element.text().split(' ').filter(function (word) {
                        return word !== '';
                    });
                    while (element.height() < element.prop('scrollHeight')) {
                        words.pop();
                        element.text(words.join(' ') + '...');
                    }
                    if (isCanceled) {
                        watch();
                    }
                });
            };
            watch();
        }
    };
}]);

/***/ }),
/* 1160 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('docIcon', ['Doc', function (Doc) {
    return {
        template: '<a class="xl-icon qmark-icon doc-icon" ng-href="{{ docURL }}" target="_blank" rel="noopener"></a>',
        restrict: 'A',
        scope: {
            section: '@docIcon'
        },
        link: function link(scope) {
            scope.docURL = Doc.getURL() + scope.section;
        }
    };
}]);

angular.module('xlrelease').directive('docLink', ['Doc', function (Doc) {
    return {
        template: '<a class="doc-link" ng-href="{{ docURL }}" target="_blank" ng-transclude rel="noopener"></a>',
        restrict: 'A',
        transclude: true,
        scope: {
            section: '@docLink'
        },
        link: function link(scope) {
            scope.docURL = Doc.getURL() + scope.section;
        }
    };
}]);

/***/ }),
/* 1161 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('Doc', [function () {
    return {
        getURL: function getURL() {
            return 'https://docs.xebialabs.com/xl-release/help/';
        },
        getMarkdownSyntaxURL: function getMarkdownSyntaxURL() {
            return this.getURL() + 'markdownsyntax.html';
        }
    };
}]);

/***/ }),
/* 1162 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FacetsService = function () {
    function FacetsService(Backend) {
        (0, _classCallCheck3.default)(this, FacetsService);

        this._backend = Backend;
    }

    (0, _createClass3.default)(FacetsService, [{
        key: 'getFacets',
        value: function getFacets(taskId) {
            return this._backend.post('api/v1/facets/search', {
                targetId: taskId
            });
        }
    }, {
        key: 'getTypes',
        value: function getTypes(type) {
            return this._backend.get('api/v1/facets/types?baseType=' + type);
        }
    }, {
        key: 'save',
        value: function save(facet) {
            return this._backend.post('api/v1/facets', facet);
        }
    }, {
        key: 'update',
        value: function update(facet) {
            return this._backend.put('api/v1/facets/' + facet.id, facet);
        }
    }, {
        key: 'remove',
        value: function remove(facetId) {
            return this._backend.del('api/v1/facets/' + facetId);
        }
    }]);
    return FacetsService;
}();

FacetsService.$inject = ['Backend'];


angular.module('xlrelease').service('FacetsService', FacetsService);

/***/ }),
/* 1163 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('delayedLine', [function () {
    return {
        templateUrl: 'partials/flags/delayed-line-directive.html',
        restrict: 'A',
        transclude: true,
        scope: {
            task: '='
        }
    };
}]);

/***/ }),
/* 1164 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('flagLine', ['FlagService', function (FlagService) {
    return {
        templateUrl: 'partials/flags/flag-line-directive.html',
        restrict: 'A',
        scope: {
            item: '='
        },
        transclude: true,
        link: function link(scope) {
            scope.isItemFlagged = FlagService.isItemFlagged;
            scope.isFlaggedAttentionNeeded = FlagService.isFlaggedAttentionNeeded;
            scope.isFlaggedAtRisk = FlagService.isFlaggedAtRisk;
        }
    };
}]);

/***/ }),
/* 1165 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('FlagService', [function () {

    var NOT_FLAGGED_STATUS = 'OK';
    var ATTENTION_NEEDED_STATUS = 'ATTENTION_NEEDED';
    var AT_RISK_STATUS = 'AT_RISK';

    function isItemFlagged(item) {
        return item && item.flag && item.flag.status !== NOT_FLAGGED_STATUS;
    }

    function isFlaggedAttentionNeeded(item) {
        return isItemFlagged(item) && item.flag.status === ATTENTION_NEEDED_STATUS;
    }

    function isFlaggedAtRisk(item) {
        return isItemFlagged(item) && item.flag.status === AT_RISK_STATUS;
    }

    function isReleaseFlagged(release) {
        return release && release.releaseFlag && release.releaseFlag.status !== NOT_FLAGGED_STATUS;
    }

    return {
        NOT_FLAGGED_STATUS: NOT_FLAGGED_STATUS,
        isReleaseOrSubtaskFlagged: isItemFlagged,
        isReleaseFlagged: isReleaseFlagged,
        isTaskFlagged: isItemFlagged,
        isItemFlagged: isItemFlagged,
        isFlaggedAttentionNeeded: isFlaggedAttentionNeeded,
        isFlaggedAtRisk: isFlaggedAtRisk
    };
}]);

/***/ }),
/* 1166 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('FiltersController', ['$scope', '$location', 'Filters', 'Events', 'FiltersQueryParams', function ($scope, $location, Filters, Events, FiltersQueryParams) {

    // Watch is necessary for toggling filters since they are accessed using scope.filters
    $scope.$watch('filters', function (newFilters, oldFilters) {
        var filtersChanged = !angular.equals(oldFilters, newFilters);
        var titleFilterChanged = newFilters.filter !== oldFilters.filter;

        if (filtersChanged && !titleFilterChanged) {
            // title filter is handled by a separate delayed watch
            setTimeFilters();
            FiltersQueryParams.update($scope.filters);
        }
    }, true);

    // Reload list of releases once user has changed filter value
    $scope.delayedWatch(500, 'filters.filter', function () {
        FiltersQueryParams.update($scope.filters);
    });

    function setTimeFilters() {
        if ($scope.filters.timeFrame) {
            // ALL_TIME could still be used from previous URLs : ensuring it gets converted to RANGE.
            var usingRange = $scope.filters.timeFrame === 'ALL_TIME' || $scope.filters.timeFrame === 'RANGE';

            if (usingRange) {
                $scope.filters.timeFrame = 'RANGE';
            } else {
                $scope.filters.from = undefined;
                $scope.filters.to = undefined;
            }
        }
    }

    // date pickers need a delay to close correctly before reloading page
    $scope.delayedWatch(100, 'filters.from', function (from) {
        $location.search('from', Filters.dateForFilter(from));
    });
    $scope.delayedWatch(100, 'filters.to', function (to) {
        $location.search('to', Filters.dateForFilter(to));
    });
}]);

/***/ }),
/* 1167 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _getIterator2 = __webpack_require__(222);

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var FiltersQueryParams = function FiltersQueryParams($rootScope, $location, $state, Events, Filters) {
        var shouldReload = true;

        var parseSearchParams = function parseSearchParams(searchString) {
            var searchParams = {};
            _.forEach(searchString.split('&'), function (searchSegment) {
                var _searchSegment$split = searchSegment.split('='),
                    _searchSegment$split2 = (0, _slicedToArray3.default)(_searchSegment$split, 2),
                    key = _searchSegment$split2[0],
                    value = _searchSegment$split2[1];

                if (_.isUndefined(searchParams[key])) {
                    searchParams[key] = decodeURIComponent(value);
                    // If second entry with this name
                } else if (_.isString(searchParams[key])) {
                    searchParams[key] = [searchParams[key], decodeURIComponent(value)];
                    // If third or later entry with this name
                } else {
                    searchParams[key].push(decodeURIComponent(value));
                }
            });
            return searchParams;
        };

        // gets the state and stateParams based on path and search params
        var getStateAndParams = function getStateAndParams(path, searchParams) {
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = (0, _getIterator3.default)($state.get()), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var state = _step.value;

                    if (angular.isFunction(state.$$state)) {
                        var internalState = state.$$state();
                        if (internalState.url) {
                            var params = internalState.url.exec(path, _.keys(parseSearchParams(searchParams)));
                            if (params) {
                                return {
                                    state: state,
                                    params: params
                                };
                            }
                        }
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            return null;
        };

        var getPath = function getPath(url) {
            var start = url.indexOf('#');
            var end = url.indexOf('?') > 0 ? url.indexOf('?') : url.length;
            return url.substring(start + 1, end);
        };

        var getSearchParams = function getSearchParams(url) {
            return url.indexOf('?') > 0 ? url.substring(url.indexOf('?') + 1, url.length) : '';
        };

        var registerRouteListener = function registerRouteListener() {
            var cachedSearchParams = null;

            // we save the search path on a failed transition if it matches the errors...
            $rootScope.$on('$stateChangeError', function (evt, toState, toParams, fromState, fromParams, error) {
                if (error && (error === 'FILTERS_NOT_SET' || error === 'CALENDAR_MONTH_NOT_SET')) {
                    cachedSearchParams = $location.search();
                    $state.go(toState.name, toParams);
                }
            });

            // and reapply them at the start if available...
            $rootScope.$on('$stateChangeStart', function () {
                if (cachedSearchParams) {
                    $location.search(cachedSearchParams).replace();
                    shouldReload = false;
                }
            });

            // and reapply them after a successful one because UI router strips them off...
            $rootScope.$on('$stateChangeSuccess', function () {
                if (cachedSearchParams) {
                    $location.search(cachedSearchParams).replace();
                    cachedSearchParams = null;
                    shouldReload = false;
                }
            });

            // this should mimic this functionality of ngRoute...
            // preparedRouteIsUpdateOnly = preparedRoute && lastRoute && preparedRoute.$$route === lastRoute.$$route
            //     && angular.equals(preparedRoute.pathParams, lastRoute.pathParams)
            //     && !preparedRoute.reloadOnSearch && !forceReload;
            $rootScope.$on('$locationChangeStart', function (evt, next, previous) {
                var nextPath = getPath(next);
                var nextSearchParams = getSearchParams(next);
                var nextStateAndParams = getStateAndParams(nextPath, nextSearchParams);

                if (nextStateAndParams) {
                    var nextState = nextStateAndParams.state;
                    var nextStateParams = nextStateAndParams.params;
                    var reloadOnSearch = _.get(nextState, 'reloadOnSearch', true);

                    if (!reloadOnSearch) {
                        var previousPath = getPath(previous);
                        var previousSearchParams = getSearchParams(previous);
                        var previousStateAndParams = getStateAndParams(previousPath, previousSearchParams);

                        var onlySearchParamsChanged = previousStateAndParams && nextPath === previousPath && nextSearchParams !== previousSearchParams;
                        if (onlySearchParamsChanged) {
                            if (shouldReload) {
                                $state.transitionTo(nextState, nextStateParams, {
                                    reload: nextState.name, inherit: false, location: false
                                });
                            } else {
                                shouldReload = true;
                            }
                        }
                    }
                }
            });
        };

        return {
            update: function update(filters) {
                shouldReload = false;
                $location.search(Filters.asQueryString(filters));
                $rootScope.$broadcast(Events.filters.filterChanged, filters);
            },
            registerRouteListener: registerRouteListener
        };
    };

    FiltersQueryParams.$inject = ['$rootScope', '$location', '$state', 'Events', 'Filters'];

    angular.module('xlrelease').service('FiltersQueryParams', FiltersQueryParams);
})();

/***/ }),
/* 1168 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _reduxPersist = __webpack_require__(661);

var _releaseOverviewActions = __webpack_require__(223);

var _releaseOverviewActions2 = _interopRequireDefault(_releaseOverviewActions);

var _releaseGroupsActions = __webpack_require__(265);

var _releaseGroupsActions2 = _interopRequireDefault(_releaseGroupsActions);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Handle the filters available on various pages of the application.
 *
 * The filter settings are always reflected in the URL query parameters, in order to make the pages bookmarkable.
 * In addition, the last used settings are remembered, and used if the page is accessed without query parameters.
 *
 * The functions exposed here are used as route "resolve" handlers in app.js.
 */
angular.module('xlrelease').factory('Filters', ['$q', '$location', '$state', 'ClientSettings', '$ngRedux', function ($q, $location, $state, ClientSettings, $ngRedux) {

    // Defines the parameters of a filter (can be either booleans or strings)
    function filterDefinition(defaults) {
        var booleans = _.chain(defaults).pickBy(function (value) {
            return typeof value === "boolean";
        }).keys().value();
        var strings = _.chain(defaults).pickBy(function (value) {
            return angular.isString(value);
        }).keys().value();
        var hasEmptyDefaultQueryString = _.chain(defaults).values().every(function (value) {
            return value === false || value === '';
        }).value();
        return {
            defaults: defaults,
            names: _.keys(defaults),
            eachBoolean: function eachBoolean(callback) {
                _.forEach(booleans, callback);
            },
            eachString: function eachString(callback) {
                _.forEach(strings, callback);
            },
            hasEmptyDefaultQueryString: hasEmptyDefaultQueryString
        };
    }

    // Generic algorithm to resolve the filter for a route.
    function generateGetter(defaults, getFromLocalStorage, putInLocalStorage, rules, paths, actionToDispatch) {
        var definition = filterDefinition(defaults);

        return function () {
            var deferred = $q.defer();

            // if filter params are provided in the URL, use that
            var queryFilters = fromQueryString($location.search(), definition);
            if (queryFilters) {
                if (rules) {
                    queryFilters = rules(queryFilters);
                }
                if (isReduxCompatible(paths)) {
                    if (actionToDispatch) {
                        $ngRedux.dispatch(actionToDispatch(queryFilters));
                    }
                } else {
                    putInLocalStorage(queryFilters);
                }
                deferred.resolve(queryFilters);
            } else {
                // have to reject or the state will be loaded twice
                if (isReduxCompatible(paths)) {
                    restoreFromRedux(rules, deferred, paths[0]);
                } else {
                    useSavedOrDefaultsFilters(rules);
                    deferred.reject('FILTERS_NOT_SET');
                }
            }
            return deferred.promise;
        };

        function isReduxCompatible(paths) {
            return paths && paths.indexOf($location.path()) > -1;
        }

        function restoreFromRedux(rules, deferred, path) {
            (0, _reduxPersist.getStoredState)({ keyPrefix: 'filters:' }, function (err, loaded) {
                var filters = definition.defaults;
                if (!err) {
                    var state = $state.get().find(function (state) {
                        return state.url === path;
                    });
                    var stateName = state.name === 'default' ? 'releaseOverview' : state.name;
                    if (loaded[stateName]) {
                        filters = loaded[stateName].filters;
                    }
                }
                if (rules) {
                    filters = rules(filters);
                }
                $location.search(asQueryString(filters)).replace();
                deferred.reject('FILTERS_NOT_SET');
            });
        }

        function useSavedOrDefaultsFilters(rules) {
            var queryString = $location.search();
            var filters = getFromLocalStorage() || definition.defaults;
            if (rules) {
                filters = rules(filters);
            }

            _.assign(queryString, asQueryString(filters));
            $location.search(queryString).replace();
        }
    }

    function generateMapItemGetter(defaults, getFromLocalStorage, putInLocalStorage, rules) {
        return function (id) {
            return generateGetter(defaults, _.partial(getFromLocalStorage, id), _.partial(putInLocalStorage, id), rules)();
        };
    }

    // Used to mark the URL once we have applied filters retrieved from local storage.
    // Without this param we would not be able to differentiate the following cases:
    // 1) 'empty' configuration (all booleans false and all strings empty) that was
    //    previously set by the user
    // 2) no configuration at all (first access to the page)
    var HAS_FILTER = "has_filter";
    var MUST_NOT_BE_EMPTY = ["timeFrame", "orderBy"];

    function fromQueryString(queryString, definition) {
        if (!queryString[HAS_FILTER]) {
            return null;
        }
        var filter = _.pick(queryString, definition.names);
        definition.eachBoolean(function (name) {
            filter[name] = !!filter[name];
        });
        definition.eachString(function (name) {
            if (!filter[name]) {
                if (_.includes(MUST_NOT_BE_EMPTY, name)) {
                    filter[name] = definition.defaults[name];
                } else {
                    filter[name] = "";
                }
            }
        });
        return filter;
    }

    function asQueryString(filters) {
        var queryString = {};
        queryString[HAS_FILTER] = true;
        _.forEach(filters, function (value, key) {
            if (value === true) {
                queryString[key] = true;
            } else if (angular.isString(value) && value.length > 0) {
                queryString[key] = value;
            } else if (angular.isNumber(value)) {
                queryString[key] = value;
            } else if (angular.isArray(value)) {
                queryString[key] = value;
            }
        });
        return queryString;
    }

    function dateFromFilter(dateFilter) {
        return dateFilter ? moment.utc(parseInt(dateFilter, 10)).local().toDate() : null;
    }

    function dateForFilter(date) {
        return date ? moment(date).valueOf() : null;
    }

    var groupsDefaults = {
        planned: false,
        inProgress: true,
        paused: true,
        failing: true,
        failed: true,
        aborted: false,
        completed: false,
        title: '',
        orderBy: 'risk'
    };

    var groupsDetailsDefaults = {
        title: '',
        orderBy: 'risk'
    };

    var releasesDefaults = {
        planned: false,
        inProgress: true,
        paused: true,
        failing: true,
        failed: true,
        aborted: false,
        completed: false,
        onlyArchived: false,
        onlyMine: false,
        onlyFlagged: false,
        title: '',
        from: null,
        to: null,
        orderBy: 'risk',
        tags: [],
        parentId: null
    };
    var calendarDefaults = {
        active: true,
        planned: true,
        inactive: false,
        onlyMine: false,
        onlyFlagged: false,
        title: '',
        tags: [],
        from: null,
        to: null
    };
    var tasksDefaults = {
        active: true,
        assignedToMe: true,
        assignedToMyTeams: true,
        assignedToAnybody: false,
        notAssigned: false,
        filter: '',
        from: null,
        to: null
    };
    var reportsDefaults = { timeFrame: 'LAST_SIX_MONTHS', tags: [], from: null, to: null };
    var templatesDefaults = { title: '', tags: [] };
    var releaseValueStreamDefaults = { title: '', from: null, to: null, tags: [], timeFrame: 'LAST_MONTH' };
    var logsDefaults = {
        filter: '',
        from: null,
        to: null,
        important: true,
        releaseEdit: false,
        taskEdit: false,
        comments: false,
        lifecycle: false,
        reassign: false,
        security: false,
        other: false,
        dateAsc: false
    };

    var dashboardDefaults = { title: '' };

    function calendarRules(filters) {
        return _(filters).thru(convertTagsToArray).thru(fixTitle).value();
    }

    function reportRules(filters) {
        return _(filters).thru(convertTimestampsToNumber).thru(convertTagsToArray).thru(fixTitle).value();
    }

    function templateRules(filters) {
        return _(filters).thru(fixTitle).thru(convertTagsToArray).value();
    }

    function fixTitle(filters) {
        if (filters && filters.filter && !filters.title) {
            filters.title = filters.filter;
            delete filters.filter;
        } else if (_(filters).has('filter')) {
            delete filters.filter;
        }
        return filters;
    }

    function convertTimestampsToNumber(filters) {
        if (filters && filters.from && _.isString(filters.from)) {
            filters.from = _.toNumber(filters.from);
        }
        if (filters && filters.to && _.isString(filters.to)) {
            filters.to = _.toNumber(filters.to);
        }
        return filters;
    }

    function convertTagsToArray(filters) {
        if (filters) {
            filters.tags = _.isString(filters.tags) ? filters.tags.split(',') : filters.tags || [];
        }
        return filters;
    }

    function fixOrderBy(filters) {
        if (filters && ['start_date', 'end_date', 'risk'].indexOf(filters.orderBy) === -1) {
            filters.orderBy = 'risk';
        }
        return filters;
    }

    function releaseRules(filters) {
        return _(filters).thru(convertTimestampsToNumber).thru(fixOrderBy).thru(fixTitle).thru(convertTagsToArray).value();
    }

    function groupRules(filters) {
        return _(filters).thru(fixOrderBy).thru(fixTitle).value();
    }

    function groupsDetailsRules(filters) {
        return _(filters).thru(fixOrderBy).thru(fixTitle).value();
    }

    return {
        getTasksFilterSettings: generateGetter(tasksDefaults, ClientSettings.getTasksFilters, ClientSettings.setTasksFilters, convertTimestampsToNumber),
        getReleasesFilterSettings: generateGetter(releasesDefaults, ClientSettings.getReleasesListFilters, ClientSettings.setReleasesListFilters, releaseRules, ['/default', '/releases'], _releaseOverviewActions2.default.setFilters),
        getGroupsFilterSettings: generateGetter(groupsDefaults, ClientSettings.getGroupsListFilters, ClientSettings.setGroupsListFilters, groupRules, ['/groups'], _releaseGroupsActions2.default.setFilters),
        getGroupsDetailsFilterSettings: generateGetter(groupsDetailsDefaults, angular.noop, angular.noop, groupsDetailsRules),
        getCalendarFilterSettings: generateGetter(calendarDefaults, ClientSettings.getCalendarFilters, ClientSettings.setCalendarFilters, calendarRules),
        getReportsFiltersSettings: generateGetter(reportsDefaults, ClientSettings.getReportsFilters, ClientSettings.setReportsFilters, reportRules),
        getTemplatesFilterSettings: generateGetter(templatesDefaults, ClientSettings.getTemplatesListFilters, ClientSettings.setTemplatesListFilters, templateRules),
        getReleaseValueStreamFilterSettings: generateGetter(releaseValueStreamDefaults, ClientSettings.getReleaseValueStreamFilters, ClientSettings.setReleaseValueStreamFilters, reportRules),
        getLogsFiltersSettings: generateMapItemGetter(logsDefaults, ClientSettings.getLogsFilters, ClientSettings.setLogsFilters, convertTimestampsToNumber),
        getDashboardsFilterSettings: generateGetter(dashboardDefaults, ClientSettings.getFolderDashboardListFilters, ClientSettings.setFolderDashboardListFilters),
        asQueryString: asQueryString,
        dateFromFilter: dateFromFilter,
        dateForFilter: dateForFilter
    };
}]);

/***/ }),
/* 1169 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('Backend', ['$http', 'XLRelease', function ($http, XLRelease) {
    var DELETE_CONFIG = {
        method: 'DELETE', // IE 8 do not support $http.delete()
        data: null, // Without data, Content-Type is deleted
        headers: {
            'Content-Type': 'application/json' // Without Content-Type, Browser's default Content-Type is used
        }
    };

    return {
        post: function post(url, data, config) {
            if (angular.isUndefined(data)) {
                data = {};
            }
            return $http.post(url, data, config);
        },
        get: function get(url, config) {
            return $http.get(url, this._extendWithVersion(this._extendWithCacheBuster(config)));
        },
        put: function put(url, data, config) {
            if (angular.isUndefined(data)) {
                data = {};
            }
            return $http.put(url, data, this._extendWithVersion(config));
        },
        del: function del(url, config) {
            var extendedConfig = angular.extend({}, DELETE_CONFIG, config);
            extendedConfig.url = url;
            return $http(this._extendWithVersion(extendedConfig));
        },

        // overridden in unit tests
        _extendWithCacheBuster: function _extendWithCacheBuster(config) {
            var cacheBuster = {
                cb: new Date().getTime()
            };
            return addParams(config, cacheBuster);
        },
        _extendWithVersion: function _extendWithVersion(config) {
            var version = {
                xlrv: XLRelease.version
            };
            return addParams(config, version);
        }
    };

    function addParams(config, params) {
        var extendedConfig = config ? angular.copy(config) : {};
        extendedConfig.params = angular.extend({}, extendedConfig.params || {}, params);
        return extendedConfig;
    }
}]);

/***/ }),
/* 1170 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').config(['$httpProvider', 'Events', function ($httpProvider, Events) {

    var UNAUTHORIZED = 401;
    var PAYMENT_REQUIRED = 402;
    var FORBIDDEN = 403;
    var VERSION_CHANGED = 410;
    var SERVER_DOWN_CODE = -1;

    var DELAY_BEFORE_AJAX_SPINNER = 1000;
    var ajaxSpinnerTimers = [];

    $httpProvider.interceptors.push(['$rootScope', '$q', '$location', '$window', 'Alerts', 'VersionEnforcer', 'WindowLocation', function ($rootScope, $q, $location, $window, Alerts, VersionEnforcer, WindowLocation) {
        return {
            request: function request(_request) {
                ajaxSpinnerTimers.push(setTimeout(function () {
                    angular.element('#loading').show();
                }, DELAY_BEFORE_AJAX_SPINNER));

                VersionEnforcer.addPrefix(_request);
                //to avoid popup from browser when returning 'WWW-Authenticate: Basic'. See Http401AuthenticationEntryPoint
                _request.headers['X-HTTP-Auth-Override'] = 'true';

                return _request;
            },
            response: function response(_response) {
                hideSpinner();
                return _response;
            },
            responseError: function responseError(response) {
                hideSpinner();
                var status = response.status;

                if (status === PAYMENT_REQUIRED) {
                    WindowLocation.changeLocation('./productregistration');
                    return $q.reject(response);
                }

                if (status === UNAUTHORIZED && !response.config.dontRedirectWhenUnauthorized) {
                    $rootScope.$emit(Events.permission.unauthorized);
                    return $q.reject(response);
                }

                if (status === FORBIDDEN && !response.config.dontRedirectWhenForbidden) {
                    var contentType = response.headers('Content-Type');
                    // If content-type is HTML, response.data is html, so no readable message.
                    var errorMessage = contentType && contentType.match(/^text\/plain/) ? response.data : '';
                    $rootScope.$emit(Events.permission.forbidden, errorMessage);

                    return $q.reject(response);
                }

                if (status === VERSION_CHANGED) {
                    $rootScope.xlreleaseVersionChanged = true;
                    $rootScope.versionChangedMessage = response.data;
                }

                if (status === SERVER_DOWN_CODE) {
                    Alerts.serverDownError();
                    return $q.reject(response);
                }
                if (!response.config.hideAlert && status !== response.config.hideAlertOnCode && (!response.config.hideAlertOnCodes || response.config.hideAlertOnCodes.indexOf(status) === -1)) {
                    Alerts.error(response);
                }
                return $q.reject(response);
            }
        };
    }]);

    function hideSpinner() {
        clearTimeout(ajaxSpinnerTimers.pop());
        if (ajaxSpinnerTimers.length === 0) {
            angular.element('#loading').hide();
        }
    }
}]);

angular.module('xlrelease').factory('WindowLocation', ['$window', function ($window) {
    return {
        changeLocation: function changeLocation(url) {
            $window.location.href = url;
        }
    };
}]);

/***/ }),
/* 1171 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('VersionEnforcer', ['XLRelease', function (XLRelease) {
    return {
        addPrefix: function addPrefix(request) {
            if (request.url.match(/^partials\//)) {
                request.url = 'static/' + XLRelease.version + '/' + request.url;
            }
        }
    };
}]);

/***/ }),
/* 1172 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('defaultRouteController', ['Authenticator', '$state', function (Authenticator, $state) {
    $state.go(Authenticator.isAuthenticated() ? 'releaseOverview' : 'login');
}]);

/***/ }),
/* 1173 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('LicenseController', ['$scope', 'Backend', 'DateService', 'XLRelease', 'Authenticator', function ($scope, Backend, DateService, XLRelease, Authenticator) {
    var DAYS_BEFORE_EXPIRATION_WARNING = 5;
    var expirationDate = null;

    $scope.version = XLRelease.version;

    Backend.get('server/license').then(function (resp) {
        $scope.license = resp.data;
        expirationDate = moment($scope.license.expiresAfter);
    });

    $scope.licenseIsExpired = function () {
        return expirationDate !== null && expirationDate.isBefore(DateService.getToday());
    };

    $scope.licenseIsAlmostExpired = function () {
        return expirationDate !== null && !$scope.licenseIsExpired() && expirationDate.isBefore(DateService.getToday().add(DAYS_BEFORE_EXPIRATION_WARNING, 'days'));
    };

    $scope.showLicenseInfo = function () {
        return $scope.isAdmin() && ($scope.licenseIsAlmostExpired() || $scope.licenseIsExpired() && $scope.license.repositoryId);
    };

    $scope.isAdmin = function () {
        return Authenticator.isAdminOr();
    };
}]);

/***/ }),
/* 1174 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MainController = function () {
    function MainController($scope, Authenticator, ClientSettings, XLRelease, Page, UiExtensionsService, $rootScope, Events, Backend) {
        (0, _classCallCheck3.default)(this, MainController);

        this.UiExtensionsService = UiExtensionsService;
        this.Authenticator = Authenticator;
        this.$rootScope = $rootScope;
        this.Events = Events;
        this.Page = Page;
        this.$scope = $scope;
        this.Backend = Backend;

        $scope.version = XLRelease.version;
        $scope.logout = function () {
            return Authenticator.logout();
        };
        $scope.clearClientSettings = function () {
            return ClientSettings.clear();
        };
        $scope.getPageTitle = function () {
            return Page.getTitle();
        };
        $scope.isFullPage = function () {
            return Page.isFullPage();
        };
        $scope.isPage = function (path, isRootPath) {
            return Page.isOnPage(path, isRootPath);
        };
        $scope.isLoginPage = function () {
            return Page.isLoginPage();
        };
        $scope.isTemplateDetailsPage = function () {
            return Page.isTemplateDetailsPage();
        };
        $scope.isReleaseFlowPage = function () {
            return Page.isReleaseFlowPage();
        };
        $scope.isTemplateReleaseFlowPage = function () {
            return Page.isTemplateReleaseFlowPage();
        };
        $scope.isRolePage = function () {
            return Page.isRolePage();
        };
        $scope.isDashboardsPages = function () {
            return Page.isDashboardsPages();
        };
        $scope.isGlobalDashboardsPages = function () {
            return Page.isGlobalDashboardsPages();
        };
        $scope.isReportsPages = function () {
            return Page.isReportsPages();
        };
        $scope.refreshPage = function () {
            return Page.refresh();
        };
        $scope.mainMenuItems = [];
        $scope.subMenuItems = [];
    }

    (0, _createClass3.default)(MainController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.listeners = [this.$rootScope.$on(this.Events.permission.loggedIn, this.loadMainMenu.bind(this)), this.$rootScope.$on(this.Events.ui.subMenuRefresh, this.loadSubMenu.bind(this)), this.$rootScope.$on(this.Events.ui.themeRefresh, function () {
                return _this.$scope.theme = _this.Page.theme;
            }), this.$rootScope.$on(this.Events.ui.customLogoRefresh, function () {
                return _this.$scope.customLogoSrc = _this.Page.customLogoSrc;
            }), this.$rootScope.$on(this.Events.breadcrumbs.update, function (event, breadcrumbs) {
                return _this.$scope.breadcrumbs = breadcrumbs;
            }), this.$rootScope.$on(this.Events.settings.systemMessageUpdated, function (event, systemMessageSettings) {
                return _this.$scope.systemMessage = systemMessageSettings;
            })];

            if (this.Authenticator.isAuthenticated()) {
                this.loadMainMenu();
            }

            this.Backend.get('server/logo/xl-release', { hideAlert: true }).then(function () {
                return _this.$scope.productLogoSrc = 'server/logo/xl-release';
            }, function () {
                return _this.$scope.productLogoSrc = 'static/8.6.1/styles/img/xl-release-logo-white.svg';
            });

            this.Page.initTheme();
            this.Page.initCustomLogo();
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this.listeners.forEach(function (listener) {
                return listener();
            });
        }
    }, {
        key: 'loadMainMenu',
        value: function loadMainMenu() {
            var _this2 = this;

            this.UiExtensionsService.getMainMenuItems().then(function (items) {
                _this2.$scope.mainMenuItems = items;
                _this2.loadSubMenu();
            });
        }
    }, {
        key: 'loadSubMenu',
        value: function loadSubMenu(event, data) {
            var _this3 = this;

            this.Page.fetchSubNavMenuItems().then(function (items) {
                _this3.$scope.subMenuItems = items;
                if (data && _.isFunction(data.onRefresh)) {
                    data.onRefresh();
                }
            });
        }
    }]);
    return MainController;
}();

MainController.$inject = ['$scope', 'Authenticator', 'ClientSettings', 'XLRelease', 'Page', 'UiExtensionsService', '$rootScope', 'Events', 'Backend'];


angular.module('xlrelease').controller('MainController', MainController);

/***/ }),
/* 1175 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


(function () {

    var injectParams = ['$location', 'UiExtensionsService', 'Page'];

    var MainMenuExtensionController = function MainMenuExtensionController($location, UiExtensionsService, Page) {
        var vm = this;

        UiExtensionsService.findMenuItemForPath($location.path()).then(function (menuExtension) {
            vm.menuExtension = menuExtension;
            if (!vm.menuExtension) {
                $location.path('/default');
                return;
            }

            Page.addToTitle(vm.menuExtension.label);
        });
    };

    MainMenuExtensionController.$inject = injectParams;

    angular.module('xlrelease').controller('mainMenuExtensionController', MainMenuExtensionController);
})();

/***/ }),
/* 1176 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _map = __webpack_require__(221);

var _map2 = _interopRequireDefault(_map);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MenuItemsProviderRegistry = function () {
    function MenuItemsProviderRegistry() {
        (0, _classCallCheck3.default)(this, MenuItemsProviderRegistry);

        this.providers = new _map2.default();
    }

    (0, _createClass3.default)(MenuItemsProviderRegistry, [{
        key: 'hasProvider',
        value: function hasProvider(name) {
            return this.providers.has(name);
        }
    }, {
        key: 'addProvider',
        value: function addProvider(name, config) {
            this.providers.set(name, config);
        }
    }, {
        key: 'getProvider',
        value: function getProvider(name) {
            return this.providers.get(name);
        }
    }]);
    return MenuItemsProviderRegistry;
}();

angular.module('xlrelease').service('MenuItemsProviderRegistry', MenuItemsProviderRegistry);

/***/ }),
/* 1177 */,
/* 1178 */,
/* 1179 */,
/* 1180 */,
/* 1181 */,
/* 1182 */,
/* 1183 */,
/* 1184 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _angular = __webpack_require__(131);

var _angular2 = _interopRequireDefault(_angular);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n<form id="system-message-modal" name="systemMessageForm" novalidate>\n    <div class="modal-header">\n        <h4 class="modal-title pull-left" id="modal-title">System message</h4>\n        <button type="button" class="close pull-right" ng-click="$ctrl.dismiss()"><i class="xl-icon close-icon"/></button>\n        <div class="clearfix"/>\n    </div>\n    <div class="modal-body" id="modal-body">\n        <div class="form-group">\n            <div class="checkbox">\n                <label for="enabled">\n                    <input type="checkbox" id="enabled" name="enabled" data-ng-model="$ctrl.systemMessage.enabled" />\n                    Enable system message\n                </label>\n            </div>\n        </div>\n        <div class="form-group">\n            <label for="message">\n                System message text \n            </label>        \n             <rich-editor\n                name="message"\n                data-ng-if="$ctrl.isLoaded"\n                content="$ctrl.systemMessage.message"\n                disabled="!$ctrl.systemMessage.enabled"\n                toolbar-config="$ctrl.DEFAULT_TOOLBAR_CONFIG"\n                on-content-change="$ctrl.onMessageChange"/>\n        </div>\n        <div class="form-group">\n            <div class="checkbox">\n                <label for="automated">\n                    <input type="checkbox" id="automated" name="automated" data-ng-model="$ctrl.systemMessage.automated" />\n                    Automatically enable/disable system message\n                </label>\n            </div>\n        </div>       \n        <div data-ng-if="$ctrl.systemMessage.automated" class="form-inline">\n            <div class="form-group">\n                <label for="startDate">\n                    Start date\n                </label>\n                <div date-editor\n                     data-ng-model="$ctrl.systemMessage.startDate"\n                     data-deletable="true"\n                     class="date-picker"\n                     is-required="$ctrl.systemMessage.automated"\n                     date-format="{{::$ctrl.DEFAULT_DATE_TIME_FORMAT}}">\n                </div>\n            </div>\n            <div class="form-group">\n                <label for="endDate">\n                    End date\n                </label>\n                <div date-editor\n                     data-ng-model="$ctrl.systemMessage.endDate"\n                     data-deletable="true"\n                     class="date-picker"\n                     is-required="$ctrl.systemMessage.automated"\n                     date-format="{{::$ctrl.DEFAULT_DATE_TIME_FORMAT}}">\n                </div>\n            </div>\n            <div ng-if="$ctrl.systemMessage.startDate && $ctrl.systemMessage.endDate && !$ctrl.isStartDateBeforeEndDate()">\n                <span class="error">Start date must be before end date</span>\n            </div>\n        </div>\n    </div>\n    <div class="modal-footer">\n        <button class="button cancel" type="button" ng-click="$ctrl.dismiss()">Cancel</button>\n        <button class="button save primary" type="submit" ng-click="$ctrl.save()" ng-disabled="!$ctrl.isFormValid() || systemMessageForm.$invalid">Save</button>\n    </div>\n</div>\n';

var SystemMessageController = function () {
    function SystemMessageController(SystemMessageService, ConfirmLeaveService, $scope, $timeout) {
        var _this = this;

        (0, _classCallCheck3.default)(this, SystemMessageController);
        this.DEFAULT_DATE_TIME_FORMAT = 'YYYY-MM-DDTHH:mm:ssZ';
        this.DEFAULT_TOOLBAR_CONFIG = {
            display: ['INLINE_STYLE_BUTTONS'],
            INLINE_STYLE_BUTTONS: [{ label: 'Bold', style: 'BOLD' }, { label: 'Italic', style: 'ITALIC' }, { label: 'Underline', style: 'UNDERLINE' }]
        };

        this.onMessageChange = function (value) {
            _this.$timeout(function () {
                value = this._removeHtmlHeadings(value);
                this.systemMessage.message = value;
            }.bind(_this));
        };

        this.SystemMessageService = SystemMessageService;
        this.ConfirmLeaveService = ConfirmLeaveService;
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.isLoaded = false;
        this.systemMessageCopy = {};
        this.systemMessage = {};
    }

    (0, _createClass3.default)(SystemMessageController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this2 = this;

            this.$scope.$on('modal.closing', function (event) {
                if (!_this2._isUnchanged()) {
                    event.preventDefault();
                    _this2.ConfirmLeaveService.openConfirmationDialog().then(function () {
                        _this2.systemMessage = _angular2.default.copy(_this2.systemMessageCopy);
                        _this2.dismiss();
                    });
                }
            });

            this.SystemMessageService.loadSystemMessage().then(function (systemMessage) {
                _this2.systemMessage = systemMessage;
                if (_angular2.default.isUndefined(_this2.systemMessage.message)) {
                    _this2.systemMessage.message = '';
                }
                if (_angular2.default.isUndefined(_this2.systemMessage.startDate)) {
                    _this2.systemMessage.startDate = moment().format(_this2.DEFAULT_DATE_TIME_FORMAT);
                }
                if (_angular2.default.isUndefined(_this2.systemMessage.endDate)) {
                    _this2.systemMessage.endDate = moment().add(1, 'days').format(_this2.DEFAULT_DATE_TIME_FORMAT);
                }
                _this2.systemMessageCopy = _angular2.default.copy(_this2.systemMessage);
                _this2.isLoaded = true;
            });
        }
    }, {
        key: '_isUnchanged',
        value: function _isUnchanged() {
            return _angular2.default.equals(this.systemMessage, this.systemMessageCopy);
        }
    }, {
        key: 'save',
        value: function save() {
            var _this3 = this;

            this.SystemMessageService.saveSystemMessage(this.systemMessage).then(function (systemMessage) {
                _this3.ConfirmLeaveService.disableConfirmation();
                _this3.systemMessage = _angular2.default.copy(systemMessage);
                _this3.systemMessageCopy = _angular2.default.copy(systemMessage);
                _this3.close({ $value: systemMessage });
            });
        }
    }, {
        key: '_removeHtmlHeadings',
        value: function _removeHtmlHeadings(value) {
            return value.replace(/<h[1-6]>/gi, '<p>').replace(/<\/h[1-6]>/gi, '</p>');
        }
    }, {
        key: 'isFormValid',
        value: function isFormValid() {
            return !this.systemMessage.enabled && !this.systemMessage.automated || this.systemMessage.enabled && !this.isSystemMessageEmpty() && (!this.systemMessage.automated || this.isStartDateBeforeEndDate());
        }
    }, {
        key: 'isStartDateBeforeEndDate',
        value: function isStartDateBeforeEndDate() {
            return moment(this.systemMessage.startDate).isBefore(this.systemMessage.endDate);
        }
    }, {
        key: 'isSystemMessageEmpty',
        value: function isSystemMessageEmpty() {
            return this.systemMessage.message.replace(/<p>|<br>|<\/p>|\n|\r|\r\n|&nbsp;/gi, '') === '';
        }
    }]);
    return SystemMessageController;
}();

SystemMessageController.$inject = ['SystemMessageService', 'ConfirmLeaveService', '$scope', '$timeout'];


var SystemMessageModal = {
    bindings: {
        close: '&',
        dismiss: '&'
    },
    controller: SystemMessageController,
    template: template
};

_angular2.default.module('xlrelease').component('systemMessageModal', SystemMessageModal);

/***/ }),
/* 1185 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* eslint-disable angular/typecheck-string,angular/typecheck-function */
/*
 * Konami-JS ~
 * :: Now with support for touch events and multiple instances for
 * :: those situations that call for multiple easter eggs!
 * Code: http://konami-js.googlecode.com/
 * Examples: http://www.snaptortoise.com/konami-js
 * Copyright (c) 2009 George Mandis (georgemandis.com, snaptortoise.com)
 * Version: 1.4.2 (9/2/2013)
 * Licensed under the MIT License (http://opensource.org/licenses/MIT)
 * Tested in: Safari 4+, Google Chrome 4+, Firefox 3+, IE7+, Mobile Safari 2.2.1 and Dolphin Browser
 */

var Konami = function Konami(callback) {
    var konami = {
        addEvent: function addEvent(obj, type, fn, ref_obj) {
            if (obj.addEventListener) obj.addEventListener(type, fn, false);else if (obj.attachEvent) {
                // IE
                obj["e" + type + fn] = fn;
                obj[type + fn] = function () {
                    obj["e" + type + fn](window.event, ref_obj);
                };
                obj.attachEvent("on" + type, obj[type + fn]);
            }
        },

        input: "",
        pattern: "38384040373937396665",
        load: function load(link) {
            this.addEvent(document, "keydown", function (e, ref_obj) {
                if (ref_obj) konami = ref_obj; // IE
                konami.input += e ? e.keyCode : event.keyCode;
                if (konami.input.length > konami.pattern.length) konami.input = konami.input.substr(konami.input.length - konami.pattern.length);
                if (konami.input === konami.pattern) {
                    konami.code(link);
                    konami.input = "";
                    e.preventDefault();
                    return false;
                }
            }, this);
            this.iphone.load(link);
        },
        code: function code(link) {
            window.location = link;
        },

        iphone: {
            start_x: 0,
            start_y: 0,
            stop_x: 0,
            stop_y: 0,
            tap: false,
            capture: false,
            orig_keys: "",
            keys: ["UP", "UP", "DOWN", "DOWN", "LEFT", "RIGHT", "LEFT", "RIGHT", "TAP", "TAP"],
            code: function code(link) {
                konami.code(link);
            },
            load: function load(link) {
                this.orig_keys = this.keys;
                konami.addEvent(document, "touchmove", function (e) {
                    if (e.touches.length === 1 && konami.iphone.capture === true) {
                        var touch = e.touches[0];
                        konami.iphone.stop_x = touch.pageX;
                        konami.iphone.stop_y = touch.pageY;
                        konami.iphone.tap = false;
                        konami.iphone.capture = false;
                        konami.iphone.check_direction();
                    }
                });
                konami.addEvent(document, "touchend", function (evt) {
                    if (konami.iphone.tap === true) konami.iphone.check_direction(link);
                }, false);
                konami.addEvent(document, "touchstart", function (evt) {
                    konami.iphone.start_x = evt.changedTouches[0].pageX;
                    konami.iphone.start_y = evt.changedTouches[0].pageY;
                    konami.iphone.tap = true;
                    konami.iphone.capture = true;
                });
            },
            check_direction: function check_direction(link) {
                x_magnitude = Math.abs(this.start_x - this.stop_x);
                y_magnitude = Math.abs(this.start_y - this.stop_y);
                x = this.start_x - this.stop_x < 0 ? "RIGHT" : "LEFT";
                y = this.start_y - this.stop_y < 0 ? "DOWN" : "UP";
                result = x_magnitude > y_magnitude ? x : y;
                result = this.tap === true ? "TAP" : result;

                if (result === this.keys[0]) this.keys = this.keys.slice(1, this.keys.length);
                if (this.keys.length === 0) {
                    this.keys = this.orig_keys;
                    this.code(link);
                }
            }
        }
    };

    typeof callback === "string" && konami.load(callback);
    if (typeof callback === "function") {
        konami.code = callback;
        konami.load();
    }

    return konami;
};

Konami(function () {
    /* eslint-disable angular/definedundefined */
    (function (srcs, cfg) {
        var cbcount = 1;var callback = function callback() {
            --cbcount;if (cbcount === 0) {
                BrowserPonies.setBaseUrl(cfg.baseurl);if (!BrowserPoniesBaseConfig.loaded) {
                    BrowserPonies.loadConfig(BrowserPoniesBaseConfig);BrowserPoniesBaseConfig.loaded = true;
                }BrowserPonies.loadConfig(cfg);if (!BrowserPonies.running()) BrowserPonies.start();
            }
        };if (typeof BrowserPoniesConfig === "undefined") {
            window.BrowserPoniesConfig = {};
        }if (typeof BrowserPoniesBaseConfig === "undefined") {
            ++cbcount;BrowserPoniesConfig.onbasecfg = callback;
        }if (typeof BrowserPonies === "undefined") {
            ++cbcount;BrowserPoniesConfig.oninit = callback;
        }var node = document.body || document.documentElement || document.getElementsByTagName('head')[0];for (var id in srcs) {
            if (document.getElementById(id)) continue;if (node) {
                var s = document.createElement('script');s.type = 'text/javascript';s.id = id;s.src = srcs[id];node.appendChild(s);
            } else {
                document.write("<script type=\"text/javscript\" src=\"" + srcs[id] + '" id="' + id + "\"></script>");
            }
        }callback();
    })({ "browser-ponies-script": "https://panzi.github.io/Browser-Ponies/browserponies.js", "browser-ponies-config": "https://panzi.github.io/Browser-Ponies/basecfg.js" }, { "baseurl": "https://panzi.github.io/Browser-Ponies/", "fadeDuration": 500, "volume": 1, "fps": 25, "speed": 3, "audioEnabled": false, "showFps": false, "showLoadProgress": true, "speakProbability": 0.1, "spawn": { "applejack": 1, "fluttershy": 1, "pinkie pie": 1, "rainbow dash": 1, "rarity": 1, "twilight sparkle": 1 } });void 0;
    /* eslint-enable angular/definedundefined */
});

/***/ }),
/* 1186 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DATE_FORMATS = {
    // Month first
    'M/d/yy': {
        shortDate: 'M/d/yy',
        mediumDate: 'MMM d, y',
        longDate: 'MMMM d, y',
        fullDate: 'EEEE, MMMM d, y',
        name: 'Month first'
    },
    // Day first
    'dd/MM/yy': {
        shortDate: 'dd/MM/yy',
        mediumDate: 'dd MMM y',
        longDate: 'dd MMMM y',
        fullDate: 'EEEE dd MMMM y',
        name: 'Day first'
    },
    // Year first
    'yy/MM/dd': {
        shortDate: 'yy/MM/dd',
        mediumDate: 'y MMM dd',
        longDate: 'y MMMM dd',
        fullDate: 'y MMMM dd EEEE',
        name: 'Year first'
    }
};

var TIME_FORMATS = {
    // 24h format
    'HH:mm': {
        shortTime: 'HH:mm',
        mediumTime: 'HH:mm:ss',
        name: '24 hours'
    },
    // 12h format
    'h:mm a': {
        shortTime: 'h:mm a',
        mediumTime: 'h:mm:ss a',
        name: '12 hours'
    }
};

var MONTHS = [{ short: 'Jan', long: 'January' }, { short: 'Feb', long: 'February' }, { short: 'Mar', long: 'March' }, { short: 'Apr', long: 'April' }, { short: 'May', long: 'May' }, { short: 'Jun', long: 'June' }, { short: 'Jul', long: 'July' }, { short: 'Aug', long: 'August' }, { short: 'Sep', long: 'September' }, { short: 'Oct', long: 'October' }, { short: 'Nov', long: 'November' }, { short: 'Dec', long: 'December' }];

var DAYS = [{ short: 'Sun', long: 'Sunday' }, { short: 'Mon', long: 'Monday' }, { short: 'Tue', long: 'Tuesday' }, { short: 'Wed', long: 'Wednesday' }, { short: 'Thu', long: 'Thursday' }, { short: 'Fri', long: 'Friday' }, { short: 'Sat', long: 'Saturday' }];

var AMPMS = ['AM', 'PM'];

var RegionalSettings = function () {
    function RegionalSettings($locale) {
        (0, _classCallCheck3.default)(this, RegionalSettings);

        this.WEEK_DAYS = _.map(DAYS, function (daySpec) {
            return daySpec.long;
        });
        this.DEFAULT_DATE_FORMATS = ['M/d/yy', 'dd/MM/yy', 'yy/MM/dd'];
        this.DEFAULT_TIME_FORMATS = ['HH:mm', 'h:mm a'];
        this.DEFAULT_FIRST_DAY_OF_WEEK_FORMATS = [0, 1];

        this._browserLocale = {
            id: $locale.id,
            firstDayOfWeek: this._detectFirstDayOfWeek(moment().locale($locale.id)),
            dateFormat: {
                shortDate: $locale.DATETIME_FORMATS.shortDate,
                mediumDate: $locale.DATETIME_FORMATS.mediumDate,
                longDate: $locale.DATETIME_FORMATS.longDate,
                fullDate: $locale.DATETIME_FORMATS.fullDate
            },
            timeFormat: {
                shortTime: $locale.DATETIME_FORMATS.shortTime,
                mediumTime: $locale.DATETIME_FORMATS.mediumTime
            }
        };

        this._firstDayOfWeek = this._detectFirstDayOfWeek();

        this.$locale = this._setEnUserLocale($locale);
    }

    (0, _createClass3.default)(RegionalSettings, [{
        key: 'update',
        value: function update(userProfile) {
            if (userProfile) {
                this._updateNgLocale(userProfile);
                this._updateMomentLocale(userProfile);
            }
        }
    }, {
        key: '_setEnUserLocale',
        value: function _setEnUserLocale(locale) {
            locale.id = 'en-user';
            locale.DATETIME_FORMATS.DAY = _.map(DAYS, function (daySpec) {
                return daySpec.long;
            });
            locale.DATETIME_FORMATS.SHORTDAY = _.map(DAYS, function (daySpec) {
                return daySpec.short;
            });
            locale.DATETIME_FORMATS.STANDALONEMONTH = _.map(MONTHS, function (monthSpec) {
                return monthSpec.long;
            });
            locale.DATETIME_FORMATS.MONTH = _.map(MONTHS, function (monthSpec) {
                return monthSpec.long;
            });
            locale.DATETIME_FORMATS.SHORTMONTH = _.map(MONTHS, function (monthSpec) {
                return monthSpec.short;
            });
            locale.DATETIME_FORMATS.AMPMS = AMPMS;

            return locale;
        }
    }, {
        key: '_updateNgLocale',
        value: function _updateNgLocale(userProfile) {
            this._updateNgDates(DATE_FORMATS[userProfile.dateFormat] || this._browserLocale.dateFormat);
            this._updateNgTimes(TIME_FORMATS[userProfile.timeFormat] || this._browserLocale.timeFormat);

            this.$locale.DATETIME_FORMATS.short = this.$locale.DATETIME_FORMATS.shortDate + ' ' + this.$locale.DATETIME_FORMATS.shortTime;
            this.$locale.DATETIME_FORMATS.medium = this.$locale.DATETIME_FORMATS.mediumDate + ' ' + this.$locale.DATETIME_FORMATS.mediumTime;
        }
    }, {
        key: '_updateNgDates',
        value: function _updateNgDates(overrides) {
            var _this = this;

            ['shortDate', 'mediumDate', 'longDate', 'fullDate'].forEach(function (property) {
                if (overrides[property]) {
                    _this.$locale.DATETIME_FORMATS[property] = overrides[property];
                }
            });
        }
    }, {
        key: '_updateNgTimes',
        value: function _updateNgTimes(overrides) {
            var _this2 = this;

            ['shortTime', 'mediumTime'].forEach(function (property) {
                if (overrides[property]) {
                    _this2.$locale.DATETIME_FORMATS[property] = overrides[property];
                }
            });
        }
    }, {
        key: '_updateMomentLocale',
        value: function _updateMomentLocale(userProfile) {
            if (this.isValidFirstDayOfWeek(userProfile.firstDayOfWeek)) {
                moment.defineLocale('en-user', {
                    parentLocale: 'en',
                    ordinalParse: /\d{1,2}(st|nd|rd|th)/, // remove these ordinal overrides once we upgrade to a 2.12+ version
                    ordinal: function ordinal(number) {
                        var b = number % 10;
                        var output = ~~(number % 100 / 10) === 1 ? 'th' : b === 1 ? 'st' : b === 2 ? 'nd' : b === 3 ? 'rd' : 'th';
                        return number + output;
                    },

                    week: {
                        dow: userProfile.firstDayOfWeek
                    }
                });
            } else {
                moment.locale(this._browserLocale.id);
            }
            this._firstDayOfWeek = this._detectFirstDayOfWeek();
        }
    }, {
        key: '_detectFirstDayOfWeek',
        value: function _detectFirstDayOfWeek(date) {
            return (date || moment()).localeData().firstDayOfWeek();
        }
    }, {
        key: 'isValidFirstDayOfWeek',
        value: function isValidFirstDayOfWeek(format) {
            return _.isInteger(format) && format >= 0 && format <= 6;
        }
    }, {
        key: 'getDateFormats',
        value: function getDateFormats(format) {
            return DATE_FORMATS[format] || this._browserLocale.dateFormat;
        }
    }, {
        key: 'getTimeFormats',
        value: function getTimeFormats(format) {
            return TIME_FORMATS[format] || this._browserLocale.timeFormat;
        }
    }, {
        key: 'browserDateFormat',
        get: function get() {
            return this._browserLocale.dateFormat.shortDate;
        }
    }, {
        key: 'browserTimeFormat',
        get: function get() {
            return this._browserLocale.timeFormat.shortTime;
        }
    }, {
        key: 'browserFirstDayOfWeek',
        get: function get() {
            return this._browserLocale.firstDayOfWeek;
        }
    }, {
        key: 'currentDateFormat',
        get: function get() {
            return this.$locale.DATETIME_FORMATS.shortDate;
        }
    }, {
        key: 'currentTimeFormat',
        get: function get() {
            return this.$locale.DATETIME_FORMATS.shortTime;
        }
    }, {
        key: 'currentMediumDateFormat',
        get: function get() {
            return this.$locale.DATETIME_FORMATS.mediumDate;
        }
    }, {
        key: 'currentFirstDayOfWeek',
        get: function get() {
            return this._firstDayOfWeek;
        }
    }, {
        key: 'weekDays',
        get: function get() {
            return this.WEEK_DAYS.slice(this.currentFirstDayOfWeek).concat(this.WEEK_DAYS.slice(0, this.currentFirstDayOfWeek));
        }
    }]);
    return RegionalSettings;
}();

RegionalSettings.$inject = ['$locale'];

angular.module('xlrelease').service('RegionalSettings', RegionalSettings);

/***/ }),
/* 1187 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('LoginController', ['$scope', 'Authenticator', 'AuthenticationRegistry', function ($scope, Authenticator, AuthenticationRegistry) {
    $scope.loginInfo = {
        login: "",
        password: "",
        failed: false
    };

    $scope.providers = AuthenticationRegistry.getFormProviders();

    $scope.login = function () {
        Authenticator.login($scope.loginInfo.login, $scope.loginInfo.password, $scope.loginInfo.rememberMe).then(function success() {
            $scope.loginInfo.failed = false;
        }, function error(response) {
            $scope.loginInfo.failed = true;
            $scope.loginInfo.failedStatus = response.status;
            $scope.loginInfo.password = "";
        });
    };
}]);

/***/ }),
/* 1188 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {

    var NavigationMenu = {
        bindings: {
            items: '<',
            level: '@'
        },
        templateUrl: 'partials/menu/navigation-menu.html'
    };

    var NavigationMenuItemCtrl = function () {
        function NavigationMenuItemCtrl($location, $state, $uibModal, Page, ConfirmLeaveService) {
            (0, _classCallCheck3.default)(this, NavigationMenuItemCtrl);

            this._$location = $location;
            this._$state = $state;
            this._$uibModal = $uibModal;
            this._Page = Page;
            this._ConfirmLeaveService = ConfirmLeaveService;
        }

        (0, _createClass3.default)(NavigationMenuItemCtrl, [{
            key: '$onInit',
            value: function $onInit() {
                this._isMenuItem = _.isUndefined(this.item.items);
            }
        }, {
            key: 'isItemActive',
            value: function isItemActive(item) {
                var _this = this;

                return this._Page.isOnPage(item.pathSuffix) || _.some(item.items, function (subItem) {
                    return _this.isItemActive(subItem);
                });
            }
        }, {
            key: 'goToRoute',
            value: function goToRoute() {
                var _this2 = this;

                if (!this._ConfirmLeaveService.isConfirmationRequired()) {
                    return this._goToRouteInternal();
                }

                var promise = this._ConfirmLeaveService.openConfirmationDialog();
                promise.then(function () {
                    return _this2._goToRouteInternal();
                });
            }
        }, {
            key: 'isPermitted',
            value: function isPermitted(item) {
                if (!_.isEmpty(item.items)) {
                    return _.some(item.items, this.isPermitted);
                }
                return item.permitted;
            }
        }, {
            key: '_goToRouteInternal',
            value: function _goToRouteInternal() {
                var url = this.getTransition(this.item);

                if (this._$location.path() === '/' + url.pathSuffix) {
                    // we basically say stay in this state, but just reload while preserving the current location path...
                    // if the only goal is to keep the location, only the location flag is needed!
                    this._$state.transitionTo(this._$state.current, {}, {
                        reload: true, inherit: false, notify: true, location: false
                    });
                } else {
                    this._$location.url('' + url.pathSuffix);
                }
            }
        }, {
            key: 'getTransition',
            value: function getTransition(item) {
                if (item && item.items) {
                    var permittedItems = item.items.filter(function (itemElement) {
                        return itemElement.permitted;
                    });
                    return permittedItems[0];
                } else {
                    return item;
                }
            }
        }, {
            key: 'getHoverColor',
            value: function getHoverColor(item) {
                return this._Page.theme.headerAccentColor;
            }
        }, {
            key: 'hasSubItems',
            get: function get() {
                return this._hasSubItems;
            }
        }]);
        return NavigationMenuItemCtrl;
    }();

    NavigationMenuItemCtrl.$inject = ['$location', '$state', '$uibModal', 'Page', 'ConfirmLeaveService'];

    var NavigationMenuItem = {
        bindings: {
            item: '<'
        },
        controller: NavigationMenuItemCtrl,
        templateUrl: 'partials/menu/navigation-menu-item.html'
    };

    angular.module('xlrelease').component('navigationMenu', NavigationMenu).component('navigationMenuItem', NavigationMenuItem);
})();

/***/ }),
/* 1189 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var ProfileController = function () {
        function ProfileController($filter, UsersService, UserProfile, RegionalSettings, Authenticator, ConfirmLeaveService) {
            (0, _classCallCheck3.default)(this, ProfileController);

            this._UsersService = UsersService;
            this._UserProfile = UserProfile;
            this._$filter = $filter;
            this._RegionalSettings = RegionalSettings;
            this._ConfirmLeaveService = ConfirmLeaveService;

            this._lastSavedDate = null;
            this._username = Authenticator.getUsername();

            this._previousPasswordIsInvalid = false;

            this.isInternalUser = UsersService.isInternalUser;

            this.now = new Date();

            this._loadProfile();
        }

        (0, _createClass3.default)(ProfileController, [{
            key: 'save',
            value: function save() {
                var _this = this;

                var profileForm = {
                    email: this._profile.email,
                    fullName: this._profile.fullName,
                    timeFormat: this._profile.timeFormat,
                    dateFormat: this._profile.dateFormat,
                    firstDayOfWeek: this._profile.firstDayOfWeek
                };

                if (this._profile.password) {
                    profileForm.password = this._profile.password;
                    profileForm.previousPassword = this._profile.previousPassword;
                }

                var error = function error(response) {
                    if (_this._profile.password && response.status === 400) {
                        _this._previousPasswordIsInvalid = true;
                    }
                };

                var success = function success() {
                    _this._lastSavedDate = moment().toDate();

                    if (_this._profile.password) {
                        delete _this._profile.password;
                        delete _this._profile.passwordConfirmation;
                        delete _this._profile.previousPassword;
                    }
                    _this._previousPasswordIsInvalid = false;
                    _this._ConfirmLeaveService.disableConfirmation();
                };

                this._UserProfile.save(profileForm).then(success, error);
            }
        }, {
            key: 'getDateLabel',
            value: function getDateLabel(format) {
                var formats = this._RegionalSettings.getDateFormats(format);
                return (formats.name || 'Browser setting') + ' \u2013 ' + this._formatDate(formats.mediumDate);
            }
        }, {
            key: 'getTimeLabel',
            value: function getTimeLabel(format) {
                var formats = this._RegionalSettings.getTimeFormats(format);
                return (formats.name || 'Browser setting') + ' \u2013 ' + this._formatDate(formats.shortTime);
            }
        }, {
            key: 'getFirstDayOfWeekLabel',
            value: function getFirstDayOfWeekLabel(format) {
                return this._RegionalSettings.isValidFirstDayOfWeek(format) ? this._RegionalSettings.WEEK_DAYS[format] : 'Browser setting – ' + this._RegionalSettings.WEEK_DAYS[this._RegionalSettings.browserFirstDayOfWeek];
            }
        }, {
            key: '_loadProfile',
            value: function _loadProfile() {
                var _this2 = this;

                this._UserProfile.load().then(function (profile) {
                    _this2._profile = profile;
                });
            }
        }, {
            key: '_formatDate',
            value: function _formatDate(format) {
                return '' + this._$filter('date')(this.now, format);
            }
        }, {
            key: 'username',
            get: function get() {
                return this._username;
            }
        }, {
            key: 'profile',
            get: function get() {
                return this._profile;
            }
        }, {
            key: 'previousPasswordIsInvalid',
            get: function get() {
                return this._previousPasswordIsInvalid;
            }
        }, {
            key: 'lastSavedDate',
            get: function get() {
                return this._lastSavedDate;
            }
        }, {
            key: 'dateFormats',
            get: function get() {
                return this._RegionalSettings.DEFAULT_DATE_FORMATS.concat([null]);
            }
        }, {
            key: 'timeFormats',
            get: function get() {
                return this._RegionalSettings.DEFAULT_TIME_FORMATS.concat([null]);
            }
        }, {
            key: 'firstDayOfWeekFormats',
            get: function get() {
                return this._RegionalSettings.DEFAULT_FIRST_DAY_OF_WEEK_FORMATS.concat([-1]);
            }
        }]);
        return ProfileController;
    }();

    ProfileController.$inject = ['$filter', 'UsersService', 'UserProfile', 'RegionalSettings', 'Authenticator', 'ConfirmLeaveService'];

    angular.module('xlrelease').controller('ProfileController', ProfileController);
})();

/***/ }),
/* 1190 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('UserProfile', ['Backend', 'RegionalSettings', 'ClientSettings', '$state', function (Backend, RegionalSettings, ClientSettings, $state) {
    var userProfile = undefined;
    function applyProfile(resp) {
        userProfile = resp.data;
        RegionalSettings.update(userProfile);
        return userProfile;
    }
    function isProfileOutdated(authenticationData, userProfile) {
        var path = 'username.toLowerCase';
        return authenticationData && _.invoke(authenticationData, path) !== _.invoke(userProfile, path);
    }
    return {
        load: function load() {
            return Backend.get('profile').then(function (response) {
                return applyProfile(response);
            }).then(function () {
                var authenticationData = ClientSettings.getAuthenticationData();
                if (isProfileOutdated(authenticationData, userProfile)) {
                    // Cannot load profile because of outdated authenticationData, reload it
                    $state.go('login', { reloadUserDetails: true });
                } else {
                    return userProfile;
                }
            });
        },
        save: function save(profile) {
            return Backend.put('profile', profile, { hideAlert: true }).then(function (response) {
                return applyProfile(response);
            });
        },
        getCurrentUser: function getCurrentUser() {
            return userProfile ? { username: userProfile.username, fullName: userProfile.fullName } : undefined;
        },
        clear: function clear() {
            userProfile = null;
        }
    };
}]);

/***/ }),
/* 1191 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Hook for acceptance tests: disable collapsing globally

angular.module('xlrelease').value('Collapse', { enabled: true });

angular.module('xlrelease').factory('ReleaseEditorCollapse', ['Collapse', 'ClientSettings', 'ReleasesService', 'PhasesService', 'TasksService', function (Collapse, ClientSettings, ReleasesService, PhasesService, TasksService) {
    function isCollapsed(item, collapsedByDefault) {
        if (!Collapse.enabled) return false;

        var savedState = ClientSettings.getReleaseEditorCollapseState(item.id);
        if (TasksService.isValidCollapsedState(savedState)) {
            return savedState;
        } else {
            return collapsedByDefault;
        }
    }

    function toggleClientSettingsState(state) {
        if (!_.isBoolean(state)) {
            return false;
        }
        return !state;
    }

    return {
        isPreConditionCollapsed: function isPreConditionCollapsed(task) {
            if (!Collapse.enabled) {
                return false;
            }
            if (!_.isBoolean(ClientSettings.getPreConditionCollapseState(task.id))) {
                return _.isEmpty(task.precondition);
            }
            return ClientSettings.getPreConditionCollapseState(task.id);
        },
        togglePreConditionState: function togglePreConditionState(task) {
            ClientSettings.setPreConditionCollapseState(task.id, toggleClientSettingsState(ClientSettings.getPreConditionCollapseState(task.id)));
        },
        isFailureHandlerCollapsed: function isFailureHandlerCollapsed(task) {
            if (!Collapse.enabled) {
                return false;
            }
            if (!_.isBoolean(ClientSettings.getFailureHandlerCollapseState(task.id))) {
                return _.isEmpty(task.failureHandler);
            }
            return ClientSettings.getFailureHandlerCollapseState(task.id);
        },
        toggleFailureHandlerState: function toggleFailureHandlerState(task) {
            ClientSettings.setFailureHandlerCollapseState(task.id, toggleClientSettingsState(ClientSettings.getFailureHandlerCollapseState(task.id)));
        },
        areFacetsCollapsed: function areFacetsCollapsed(task) {
            if (!Collapse.enabled) {
                return false;
            }
            var state = ClientSettings.getFacetsCollapseState(task.id);
            return _.isBoolean(state) ? state : true;
        },
        toggleFacetsState: function toggleFacetsState(task) {
            ClientSettings.setFacetsCollapseState(task.id, toggleClientSettingsState(ClientSettings.getFacetsCollapseState(task.id)));
        },
        isCommentsCollapsed: function isCommentsCollapsed(task) {
            if (!_.isBoolean(ClientSettings.getCommentsState(task.id))) {
                return task.numberOfComments === 0;
            }
            return ClientSettings.getCommentsState(task.id);
        },
        toggleCommentsState: function toggleCommentsState(task) {
            ClientSettings.setCommentsState(task.id, toggleClientSettingsState(ClientSettings.getCommentsState(task.id)));
        },
        isAttachmentsCollapsed: function isAttachmentsCollapsed(task) {
            if (!_.isBoolean(ClientSettings.getAttachmentsState(task.id))) {
                return _.isEmpty(task.attachments);
            }
            return ClientSettings.getAttachmentsState(task.id);
        },
        toggleAttachmentsState: function toggleAttachmentsState(task) {
            ClientSettings.setAttachmentsState(task.id, toggleClientSettingsState(ClientSettings.getAttachmentsState(task.id)));
        },
        isTaskGroupCollapsed: function isTaskGroupCollapsed(group) {
            if (group.wasJustAdded || TasksService.isTaskGroupInProgress(group) && !group.wasToggledSincePageLoad) {
                return false;
            }
            return isCollapsed(group, true);
        },
        toggleTaskGroupCollapseState: function toggleTaskGroupCollapseState(group) {
            ClientSettings.setReleaseEditorCollapseState(group.id, !this.isTaskGroupCollapsed(group));
            group.wasToggledSincePageLoad = true;
            delete group.wasJustAdded;
        },
        transferTaskGroupCollapseState: function transferTaskGroupCollapseState(targetGroupId, fromGroupId) {
            ClientSettings.setReleaseEditorCollapseState(targetGroupId, this.isTaskGroupCollapsed({ id: fromGroupId }));
        },
        isPlannedPhaseCollapsed: function isPlannedPhaseCollapsed(phase) {
            return isCollapsed(phase, false);
        },
        togglePlannedPhaseCollapseState: function togglePlannedPhaseCollapseState(phase) {
            ClientSettings.setReleaseEditorCollapseState(phase.id, !this.isPlannedPhaseCollapsed(phase));
        },
        areDonePhasesCollapsed: function areDonePhasesCollapsed(release) {
            if (!release) return false;

            if (ReleasesService.isReleaseCompleted(release)) {
                return false;
            }

            return ReleasesService.countPhasesDone(release) > 0 && isCollapsed(release, true);
        },
        toggleDonePhasesCollapseState: function toggleDonePhasesCollapseState(release) {
            ClientSettings.setReleaseEditorCollapseState(release.id, !this.areDonePhasesCollapsed(release));
        },
        collapseFilter: function collapseFilter(release) {
            var self = this;
            return function (phase) {
                return !(self.areDonePhasesCollapsed(release) && PhasesService.isPhaseReadOnly(phase));
            };
        }
    };
}]);

/***/ }),
/* 1192 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('releaseEditorController', ['$scope', '$location', '$stateParams', 'Backend', 'Ids', 'TaskPolling', 'TasksService', 'PhaseColors', 'ReleasesService', 'Modal', 'FlagService', 'Authenticator', 'Events', 'PhasesService', 'TaskDetailsUpdates', 'PhaseDetailsUpdates', 'DateService', 'Page', 'ReleaseEditorCollapse', 'DragAndDrop', 'ValueStreamMapping', 'ConfigurationItemService', 'ReleaseEditorTaskFilterService', 'TaskDefinitionsService', 'ViewStorage', 'release', 'CalendarService', function ($scope, $location, $stateParams, Backend, Ids, TaskPolling, TasksService, PhaseColors, ReleasesService, Modal, FlagService, Authenticator, Events, PhasesService, TaskDetailsUpdates, PhaseDetailsUpdates, DateService, Page, ReleaseEditorCollapse, DragAndDrop, ValueStreamMapping, ConfigurationItemService, ReleaseEditorTaskFilterService, TaskDefinitionsService, ViewStorage, release, CalendarService) {
    $scope.init = {
        hasScrolledToCurrentTask: false
    };
    $scope.collapsedPhases = {};

    function emitRefreshEvent() {
        $scope.$emit(Events.permission.refresh);
    }

    function setupScope(release) {
        $scope.release = release;
        Page.setReleaseOpened($scope.release);
        $scope.allTasks = ReleasesService.getAllTasks($scope.release);
        $scope.hasAutomatedTaskInProgress = _.some($scope.allTasks, function (task) {
            return TasksService.isTaskInProgress(task) && TasksService.isAutomated(task);
        });

        if (release.phases) {
            release.phases.forEach(function (p) {
                if (PhasesService.isPhasePlanned(p)) {
                    $scope.collapsedPhases[p.id] = ReleaseEditorCollapse.isPlannedPhaseCollapsed(p);
                }
            });
        }

        startPolling();
        return release;
    }

    $scope.loadRelease = function () {
        emitRefreshEvent();
        return Backend.get('releases/' + $stateParams.releaseId).then(function (resp) {
            return setupScope(resp.data);
        });
    };

    function init() {
        emitRefreshEvent();
        setupScope(release);

        CalendarService.withinBlackout().then(function (response) {
            $scope.withinBlackout = response.data;
        });

        TaskDefinitionsService.getTaskDefinitions().then(function (resp) {
            var definitions = resp.data;
            $scope.taskDefinitions = definitions;
            $scope.groupedTaskDefinitions = definitions ? TaskDefinitionsService.groupTaskDefinitions(definitions).groups : undefined;
        });

        expandIfTaskDetailsModalRequestedForCollapsedPhaseOrTask(release);

        ViewStorage.setView($stateParams.releaseId, $location.path());
    }

    init();

    $scope.loadReleaseAfterTaskUpdate = function () {
        if (TaskDetailsUpdates.planningDataChanged) {
            $scope.loadRelease();
            TaskDetailsUpdates.reset();
        }
    };

    $scope.loadReleaseAfterPhaseUpdate = function () {
        if (PhaseDetailsUpdates.planningDataChanged) {
            $scope.loadRelease();
            PhaseDetailsUpdates.reset();
        }
    };

    function startPolling() {
        TaskPolling.startTaskPolling($scope.allTasks, $scope).then($scope.loadRelease);
        Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling);
    }

    function stopPolling() {
        $scope.$broadcast(Events.polling.stop);
    }

    function expandIfTaskDetailsModalRequestedForCollapsedPhaseOrTask(release) {
        var requestedPhaseTaskId = $location.search().openTaskDetailsModal;
        var requestedPhaseId = $location.search().scrollToPhase;

        if (requestedPhaseTaskId || requestedPhaseId) {
            var phase = requestedPhaseTaskId ? release.phases.find(function (currentPhase) {
                return Ids.phaseIdFrom(currentPhase.id) === Ids.phaseIdFrom(requestedPhaseTaskId);
            }) : release.phases.find(function (currentPhase) {
                return Ids.phaseIdFrom(currentPhase.id) === Ids.phaseIdFrom(requestedPhaseId);
            });

            if (phase) {
                // expand phases
                if (PhasesService.isPhaseReadOnly(phase) && ReleaseEditorCollapse.areDonePhasesCollapsed(release)) {
                    ReleaseEditorCollapse.toggleDonePhasesCollapseState(release);
                } else if (!PhasesService.isPhaseReadOnly(phase) && $scope.collapsedPhases[phase.id]) {
                    $scope.collapsedPhases[phase.id] = !$scope.collapsedPhases[phase.id];
                    ReleaseEditorCollapse.togglePlannedPhaseCollapseState(phase);
                }

                // expand parallel and sequential groups
                if (requestedPhaseTaskId) {
                    expandParallelAndSequentialGroups(requestedPhaseTaskId, phase.tasks);
                }
            }
        }
    }

    function expandParallelAndSequentialGroups(requestedPhaseTaskId, taskList) {
        var requestedTaskId = Ids.taskIdFrom(requestedPhaseTaskId);
        var taskDepth = requestedTaskId.split('-').length;
        var taskIdList = [];

        if (taskDepth > 1) {
            for (var i = 0; i < taskDepth; i++) {
                taskIdList.unshift(requestedTaskId);
                requestedTaskId = requestedTaskId.substring(0, requestedTaskId.lastIndexOf('-'));
            }
        }

        taskIdList.forEach(function (taskId) {
            var group = taskList.find(function (currentTask) {
                return Ids.taskIdFrom(currentTask.id) === taskId;
            });
            if (ReleaseEditorCollapse.isTaskGroupCollapsed(group)) {
                ReleaseEditorCollapse.toggleTaskGroupCollapseState(group);
            }
            taskList = group.tasks || [];
        });
    }

    $scope.isPhaseInProgress = PhasesService.isPhaseInProgress;
    $scope.isPhaseReadOnly = PhasesService.isPhaseReadOnly;
    $scope.isPhasePlanned = PhasesService.isPhasePlanned;
    $scope.updatePhase = PhasesService.updatePhase;
    $scope.updatePhaseColor = function (phase, color) {
        phase.color = color;
        PhasesService.updatePhase(phase);
    };
    $scope.isRequestedOrPhaseInProgress = function (phase) {
        var requestedTaskId = $location.search().openTaskDetailsModal;
        var requestedPhaseId = $location.search().scrollToPhase;
        if (requestedTaskId) {
            return Ids.phaseIdFrom(phase.id) === Ids.phaseIdFrom(requestedTaskId);
        } else if (requestedPhaseId) {
            return Ids.phaseIdFrom(phase.id) === Ids.phaseIdFrom(requestedPhaseId);
        } else {
            return PhasesService.isPhaseInProgress(phase);
        }
    };

    $scope.startRelease = function (release) {
        ReleasesService.startRelease(release).then($scope.loadRelease);
    };

    $scope.abortRelease = function (release) {
        ReleasesService.abortRelease(release).then($scope.loadRelease);
    };

    $scope.showNavigator = false;

    $scope.movePhase = function (fromIndex, toIndex) {
        var moveInfo = {
            originIndex: fromIndex,
            targetIndex: toIndex
        };

        if ($scope.areDonePhasesCollapsed($scope.release)) {
            var offset = $scope.release.phases.length - $scope.displayedIds.length;
            moveInfo.originIndex += offset;
            moveInfo.targetIndex += offset;
        }

        Backend.post('releases/' + $scope.release.id + '/phases/move', moveInfo).then(function () {
            var phase = $scope.release.phases.splice(moveInfo.originIndex, 1)[0];
            $scope.release.phases.splice(moveInfo.targetIndex, 0, phase);
        });
    };

    function taskHasBeenMoved(moveInfo) {
        return moveInfo.originContainerId !== moveInfo.targetContainerId || moveInfo.originIndex !== moveInfo.targetIndex;
    }

    $scope.isActiveTask = TasksService.isActive;

    $scope.moveTask = function (taskId, fromTaskOrPhase, fromIndex, toTaskOrPhase, toIndex) {
        var moveInfo = {
            originContainerId: fromTaskOrPhase.id,
            originIndex: fromIndex,
            targetContainerId: toTaskOrPhase.id,
            targetIndex: toIndex
        };

        if (!taskHasBeenMoved(moveInfo)) {
            return;
        }
        DragAndDrop.enabled = false;
        Backend.post('releases/' + $scope.release.id + '/tasks/move', moveInfo).then(function (resp) {
            var movedTask = resp.data;
            if (TasksService.isTaskGroup(movedTask) && taskId !== movedTask.id) {
                ReleaseEditorCollapse.transferTaskGroupCollapseState(movedTask.id, taskId);
            }
            $scope.loadRelease();
            DragAndDrop.enabled = true;
        }, function (error) {
            $scope.loadRelease();
            DragAndDrop.enabled = true;
        });
    };

    $scope.addPhase = function () {
        Backend.post('releases/' + $scope.release.id + '/phases/add').then(function (resp) {
            $scope.release.phases.push(resp.data);
        });
    };

    $scope.deletePhase = function (phaseToDelete) {
        Backend.del('phases/' + phaseToDelete.id).then(function () {
            var deleted = $scope.release.phases.find(function (p) {
                return p.id === phaseToDelete.id;
            });
            $scope.release.phases = $scope.release.phases.filter(function (p) {
                return p.id !== phaseToDelete.id;
            });
            var progress = $scope.release.extensions.progress;
            if (progress) {
                var tasksCount = deleted.tasks.length;
                $scope.release.extensions.progress = {
                    totalTasks: progress.totalTasks - tasksCount,
                    totalRemainingTasks: progress.totalRemainingTasks - tasksCount
                };
            }
        });
    };

    $scope.duplicatePhase = function (phase) {
        Backend.put('releases/' + $scope.release.id + '/phases/duplicate/' + phase.id).then(function (resp) {
            var duplicatedPhase = resp.data;
            $scope.release.phases.forEach(function (aPhase, index) {
                if (aPhase.id === phase.id) {
                    $scope.release.phases.splice(index + 1, 0, duplicatedPhase);
                }
            });
            var progress = $scope.release.extensions.progress;
            if (progress) {
                var tasksCount = duplicatedPhase.tasks.length;
                $scope.release.extensions.progress = {
                    totalTasks: progress.totalTasks + tasksCount,
                    totalRemainingTasks: progress.totalRemainingTasks + tasksCount
                };
            }
        });
    };

    $scope.addTask = function (container, taskForm) {
        return TasksService.addTask(container, taskForm).then($scope.loadRelease);
    };

    $scope.deleteTask = function (container, taskToDelete) {
        TasksService.deleteTask(container, taskToDelete).then($scope.loadRelease);
    };

    $scope.changeType = function (container, taskToConvert, convertToType) {
        TasksService.changeTaskType(container, taskToConvert, convertToType);
    };

    $scope.duplicateTask = function (release, container, task) {
        TasksService.duplicateTask(release, task, container).then($scope.loadRelease);
    };

    $scope.completeTask = function (task, commentText) {
        TasksService.completeTask(task.id, commentText).then($scope.loadRelease);
    };

    $scope.skipTask = function (task, commentText) {
        TasksService.skipTask(task.id, commentText).then($scope.loadRelease);
    };

    $scope.failTask = function (task, commentText) {
        TasksService.failTask(task.id, commentText).then($scope.loadRelease);
    };

    $scope.abortTask = function (task, commentText) {
        TasksService.abortTask(task.id, commentText).then($scope.loadRelease);
    };

    $scope.retryTask = function (task, commentText) {
        TasksService.retryTask(task.id, commentText).then($scope.loadRelease);
    };

    $scope.cancelTask = function (task, commentText) {
        TasksService.cancelTask(task.id, commentText).then($scope.loadRelease);
    };

    $scope.startNow = function (task, commentText) {
        TasksService.startNow(task.id, commentText).then($scope.loadRelease);
    };

    $scope.startTaskWithInput = function (task, variables) {
        TasksService.startTaskWithInput(task.id, variables).then($scope.loadRelease);
    };

    $scope.reopenTask = function (task, commentText) {
        TasksService.reopenTask(task.id, commentText).then($scope.loadRelease);
    };

    $scope.canRestartPhases = function (release) {
        return release && release.status !== 'TEMPLATE' && Authenticator.hasPermission('release#edit', release) && (ReleasesService.isReleaseInProgress(release) || ReleasesService.isReleaseFailed(release) || ReleasesService.isReleaseFailing(release)) && !$scope.hasAutomatedTaskInProgress;
    };

    $scope.canResume = function (release) {
        return release && release.status !== 'TEMPLATE' && Authenticator.hasPermission('release#edit', release) && ReleasesService.isReleasePaused(release);
    };

    $scope.resumeRelease = function (release) {
        Backend.post('releases/' + release.id + '/resume').then($scope.loadRelease);
    };

    $scope.filters = ReleaseEditorTaskFilterService.getFilters($stateParams.releaseId);
    $scope.setFilters = ReleaseEditorTaskFilterService.setFilters;
    $scope.taskFilter = ReleaseEditorTaskFilterService.getTaskFilter;

    $scope.isReleaseCompleted = ReleasesService.isReleaseCompleted;
    $scope.isReleasePlanned = ReleasesService.isReleasePlanned;
    $scope.countPhasesDone = ReleasesService.countPhasesDone;
    $scope.hasAttachments = ReleasesService.hasAttachments;
    $scope.downloadExcel = ReleasesService.downloadExcel;
    $scope.exportZip = ReleasesService.exportZip;
    $scope.exportDsl = ReleasesService.exportDsl;

    $scope.isPhaseReadOnly = PhasesService.isPhaseReadOnly;
    $scope.getLeafTasks = PhasesService.getLeafTasks;
    $scope.isCritical = ValueStreamMapping.isCritical;
    $scope.getWarningThreshold = ValueStreamMapping.getWarningThreshold;
    $scope.getErrorThreshold = ValueStreamMapping.getErrorThreshold;

    $scope.isTaskPlanned = TasksService.isTaskPlanned;
    $scope.isTaskPending = TasksService.isTaskPending;
    $scope.isTaskInProgress = TasksService.isTaskInProgress;
    $scope.isTaskPreconditionInProgress = TasksService.isTaskPreconditionInProgress;
    $scope.isTaskFacetInProgress = TasksService.isTaskFacetInProgress;
    $scope.isTaskOrPreconditionInProgress = TasksService.isTaskOrPreconditionInProgress;
    $scope.isTaskReadOnly = TasksService.isTaskReadOnly;
    $scope.isTaskSkipped = TasksService.isTaskSkipped;
    $scope.isTaskFailed = TasksService.isTaskFailed;
    $scope.isTaskFailing = TasksService.isTaskFailing;
    $scope.isUserInputTask = TasksService.isUserInputTask;
    $scope.isGateTask = TasksService.isGateTask;
    $scope.isTaskFlagged = FlagService.isTaskFlagged;
    $scope.isManualTask = TasksService.isManualTask;
    $scope.isNotificationTask = TasksService.isNotificationTask;
    $scope.isTaskGroup = TasksService.isTaskGroup;
    $scope.isParallelGroup = TasksService.isParallelGroup;
    $scope.isSequentialGroup = TasksService.isSequentialGroup;
    $scope.isTaskCompleted = TasksService.isTaskCompleted;
    $scope.isTaskCompletedInAdvance = TasksService.isTaskCompletedInAdvance;
    $scope.isTaskSkippedInAdvance = TasksService.isTaskSkippedInAdvance;
    $scope.isTaskDoneInAdvance = TasksService.isTaskDoneInAdvance;
    $scope.isTaskDraggable = TasksService.isTaskDraggable;
    $scope.isTaskGroupDroppable = TasksService.isTaskGroupDroppable;
    $scope.isAutomated = TasksService.isAutomated;
    $scope.isTaskDelayedDuringBlackout = TasksService.isTaskDelayedDuringBlackout;
    $scope.getSubTasks = TasksService.getSubTasks;
    $scope.canAddTask = TasksService.canAddTask;
    $scope.getConfigurationUri = TasksService.getConfigurationUri;
    $scope.hasConfigurationUri = TasksService.hasConfigurationUri;

    $scope.isOverdue = DateService.isOverdue;
    $scope.isTaskWaitingForInput = TasksService.isTaskWaitingForInput;

    $scope.togglePlannedPhaseCollapseState = function (phase) {
        $scope.collapsedPhases[phase.id] = !$scope.collapsedPhases[phase.id];
        ReleaseEditorCollapse.togglePlannedPhaseCollapseState(phase);
    };
    $scope.areDonePhasesCollapsed = ReleaseEditorCollapse.areDonePhasesCollapsed;
    $scope.toggleDonePhasesCollapseState = ReleaseEditorCollapse.toggleDonePhasesCollapseState;
    $scope.collapseFilter = ReleaseEditorCollapse.collapseFilter;

    $scope.DragAndDrop = DragAndDrop;
    $scope.PhaseColors = PhaseColors;

    $scope.getCIDuration = ConfigurationItemService.getCIDuration;

    $scope.displayedIds = [];
    $scope.$watchCollection('release.phases | filter:collapseFilter(release)', function (phases) {
        $scope.displayedIds = _.map(phases, 'id');
        if ($scope.areDonePhasesCollapsed($scope.release)) {
            $scope.displayedIds.unshift('collapsedPhases');
        }
    });

    $scope.isRemoveEnabled = TasksService.isRemoveEnabled;
    $scope.isDuplicateEnabled = TasksService.isDuplicateEnabled;
    $scope.isChangeTypeEnabled = TasksService.isChangeTypeEnabled;
    $scope.isOfType = TasksService.isOfType;
    $scope.getInternalId = function (releaseId) {
        return TasksService.toInternalId(releaseId);
    };

    $scope.preventBubblingEvent = function (e) {
        e.stopPropagation();
    };
}]);

// Expose the container of a task, regardless if it's a phase or a group.
angular.module('xlrelease').controller('ContainerController', ['$scope', function ($scope) {
    $scope.$watch('release', function () {
        $scope.container = $scope.task || $scope.phase;
    });
}]);

/***/ }),
/* 1193 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ReleaseEditorTaskFilterService', ['ReleasesService', 'TasksService', 'ClientSettings', function (ReleasesService, TasksService, ClientSettings) {
    return {
        getFilters: function getFilters(releaseId) {
            var filters = ClientSettings.getReleaseEditorTaskFilters(releaseId);
            return filters || defaultFilters();
        },
        setFilters: function setFilters(releaseId, filters) {
            ClientSettings.setReleaseEditorTaskFilters(releaseId, filters);
        },
        getTaskFilter: function getTaskFilter(release, filters) {
            return function filterTask(task) {
                if (!ReleasesService.isReleaseCompleted(release)) {
                    return true;
                }

                if (TasksService.isTaskGroup(task)) {
                    var subTasks = _.flattenDeep(TasksService.getSubTasks(task));
                    if (!_.isEmpty(subTasks)) {
                        return _.some(subTasks, filterTask);
                    }
                }

                if (filters.flagged && task.flagsCount > 0) {
                    return true;
                }

                if (filters.failed && task.failuresCount > 0) {
                    return true;
                }

                if (filters.delayed && task.delaysCount > 0) {
                    return true;
                }

                if (filters.clean && task.flagsCount === 0 && task.failuresCount === 0 && task.delaysCount === 0) {
                    return true;
                }

                return false;
            };
        }
    };

    function defaultFilters() {
        return {
            flagged: true,
            failed: true,
            delayed: true,
            clean: true
        };
    }
}]);

/***/ }),
/* 1194 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var RestartPhasesController = function () {
    function RestartPhasesController($scope, Authenticator, Backend, ClientSettings, PhasesService, TasksService, VariablesInterpolator) {
        (0, _classCallCheck3.default)(this, RestartPhasesController);

        this._$scope = $scope;
        this._authenticator = Authenticator;
        this._backend = Backend;
        this._clientSettings = ClientSettings;
        this._phasesService = PhasesService;
        this._tasksService = TasksService;
        this._variablesInterpolator = VariablesInterpolator;

        this.dismiss = this._$scope.dismiss;
        this.resumeRelease = this._$scope.resumeRelease;

        this.restartPhaseTypes = [{
            label: 'Original',
            type: 'ORIGINAL'
        }, {
            label: 'Latest',
            type: 'LATEST'
        }];
    }

    (0, _createClass3.default)(RestartPhasesController, [{
        key: '$onInit',
        value: function $onInit() {
            this.releaseRestored = false;
            this.phaseRestartInProgress = false;

            this.phaseType = this._getInitialPhaseType();
            this.phases2restart = this._getPhases2Restart(this.phaseType.type);
            this.fromPhase = this.phases2restart && this.phases2restart[0];
            this.fromTask = this._getFirstTask(this.fromPhase);
            this.tasks2restart = this._getTasks2Restart(this.fromPhase);
        }
    }, {
        key: 'onTypeChange',
        value: function onTypeChange() {
            this.phases2restart = this._getPhases2Restart(this.phaseType.type);

            var fromPhase = this.phases2restart && this.phases2restart[0];
            if (fromPhase.id !== this.fromPhase.id) {
                this.fromPhase = fromPhase;
                this.tasks2restart = this._getTasks2Restart(this.fromPhase);
                this.fromTask = this._getFirstTask(this.fromPhase);
            }
        }
    }, {
        key: 'onPhaseChange',
        value: function onPhaseChange() {
            this.tasks2restart = this._getTasks2Restart(this.fromPhase);
            this.fromTask = this._getFirstTask(this.fromPhase);
        }
    }, {
        key: 'restartPhasesFrom',
        value: function restartPhasesFrom(phaseType) {
            var _this = this;

            if (phaseType) {
                this._clientSettings.setRestartPhaseVersion(phaseType.type);
            }

            this.phaseRestartInProgress = true;
            this.numberOfPhaseRestarted = this.phases2restart.length - _.indexOf(this.phases2restart, this.fromPhase);
            this._backend.post('releases/' + this._$scope.release.id + '/restartPhases', undefined, {
                params: {
                    fromPhaseId: this.fromPhase.id,
                    fromTaskId: this.fromTask ? this.fromTask.id : undefined,
                    phaseVersion: phaseType ? phaseType.type : ''
                }
            }).then(function () {
                _this.phaseRestartInProgress = false;
                _this._$scope.loadRelease();
                _this.releaseRestored = true;
            }, function () {
                _this.phaseRestartInProgress = false;
                _this.releaseRestored = false;
                _this._$scope.dismiss();
            });
        }
    }, {
        key: 'interpolate',
        value: function interpolate(title) {
            return this._variablesInterpolator.interpolateInText(this._$scope.release.variables, title);
        }
    }, {
        key: 'canSelectTasks',
        value: function canSelectTasks() {
            var _this2 = this;

            if (!this.fromPhase || !this.fromPhase.tasks) {
                return false;
            }

            if (this._getTasks2Restart(this.fromPhase).length <= 1) {
                return false;
            }

            var tasks = this.fromPhase.tasks;
            var currentTaskIndex = _.findIndex(tasks, function (task) {
                return task.id === _this2._$scope.release.currentTask.id;
            });

            var tasksToSkips = tasks.slice(0, currentTaskIndex);
            return _.every(tasksToSkips, function (task) {
                return _this2._authenticator.hasPermissionToWorkOnTask(_this2._$scope.release, task);
            });
        }
    }, {
        key: '_getInitialPhaseType',
        value: function _getInitialPhaseType() {
            var phaseTypeId = this._clientSettings.getRestartPhaseVersion();
            if (!phaseTypeId) {
                return this.restartPhaseTypes[1];
            }

            var phaseType = this.restartPhaseTypes.find(function (type) {
                return type.type.toUpperCase() === phaseTypeId.toUpperCase();
            });
            return phaseType || this.restartPhaseTypes[1];
        }
    }, {
        key: '_getPhases2Restart',
        value: function _getPhases2Restart(phaseType) {
            var phases = this._$scope.release.phases;

            if (phaseType === 'ORIGINAL') {
                return _.reject(phases, this._phasesService.isPlannedOrNotOriginal); // notice, this is rejecting, not filtering!
            }
            return _.reject(phases, this._phasesService.isPlannedOrNotMostRecentCopy); // notice, this is rejecting, not filtering!
        }
    }, {
        key: '_getTasks2Restart',
        value: function _getTasks2Restart(fromPhase) {
            var _this3 = this;

            if (!fromPhase || !fromPhase.tasks.length) {
                return [];
            }
            return fromPhase.tasks.filter(function (task) {
                return _this3._tasksService.isActive(task) || _this3._tasksService.isDone(task);
            });
        }
    }, {
        key: '_getFirstTask',
        value: function _getFirstTask(fromPhase) {
            return fromPhase && fromPhase.tasks.length ? fromPhase.tasks[0] : null;
        }
    }]);
    return RestartPhasesController;
}();

RestartPhasesController.$inject = ['$scope', 'Authenticator', 'Backend', 'ClientSettings', 'PhasesService', 'TasksService', 'VariablesInterpolator'];
angular.module('xlrelease').controller('restartPhasesController', RestartPhasesController);

/***/ }),
/* 1195 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').value('DragAndDrop', { enabled: true });

angular.module('xlrelease').directive('phaseSortable', function () {
    return {
        template: '<ul ui-sortable="phaseSortableConfig" ng-model="displayedIds" ng-transclude></ul>',
        replace: true,
        transclude: true,
        link: function link(scope) {
            scope.phaseSortableConfig = {
                "items": '.phase:not(.drag-disabled)',
                "handle": '.phase-sort-handle',
                "cursor": "move",
                "axis": "x",
                "tolerance": "pointer",
                "forcePlaceholderSize": true,
                "opacity": 0.7,
                "placeholder": 'phase-drop-placeholder',
                cancel: '.drag-disabled',
                start: function start(event, ui) {
                    ui.item.fromIndex = scope.displayedIds.indexOf(ui.item.scope().phase.id);
                },
                update: function update(event, ui) {
                    // after list updated
                    scope.$evalAsync(function () {
                        ui.item.toIndex = scope.displayedIds.indexOf(ui.item.scope().phase.id);
                        scope.movePhase(ui.item.fromIndex, ui.item.toIndex);
                    });
                }
            };
        }
    };
});

angular.module('xlrelease').directive('taskSortable', ['DragAndDrop', 'Ids', function (DragAndDrop, Ids) {
    function moveTask(event, ui, scope) {
        // after list updated
        scope.$evalAsync(function () {
            var fromTaskOrPhase = ui.item.fromTaskOrPhase;
            var fromIndex = ui.item.fromIndex;
            var toTaskOrPhase = angular.element(event.target).scope().container;
            var toIndex = _.findIndex(toTaskOrPhase.tasks, { id: ui.item.id });
            if (angular.isUndefined(ui.item.sortable.dropindex)) {
                // sometimes drop event triggers even though task was not droppable, bug in JQuery
                return;
            }
            var taskId = ui.item.id;
            scope.moveTask(taskId, fromTaskOrPhase, ui.item.sortable.index, toTaskOrPhase, ui.item.sortable.dropindex);
        });
    }

    function isMovedBetweenContainers(ui) {
        return ui.item.sortable.received;
    }

    return {
        template: '<ul ui-sortable="taskSortableConfig" ng-transclude></ul>',
        replace: true,
        transclude: true,
        link: function link(scope, element) {
            scope.$watch('DragAndDrop.enabled', function (isDragAndDropEnabled) {
                if (isDragAndDropEnabled) {
                    element.sortable('enable');
                } else {
                    element.sortable('disable');
                }
            });

            var cursorStyle = undefined;
            var body = angular.element('body');
            var moveCursorStyle = '<style>.cursor-pointer{ cursor: move !important; }</style>';
            var notAllowedCursorStyle = '<style>.cursor-pointer{ cursor: not-allowed !important; }</style>';

            scope.taskSortableConfig = {
                "items": '.item-sortable:not(.drag-disabled)',
                "cancel": ".item-sortable.drag-disabled,:input",
                "connectWith": '.phase .task-sortable:not(.drop-disabled)',
                "handle": '.task-sort-handle',
                "cursor": 'auto',
                "tolerance": 'intersect',
                "placeholder": 'task-drop-placeholder',
                "forcePlaceholderSize": true,
                "helper": 'clone', // 'clone' is required in Firefox see REL-2373 & REL-883
                "start": function start(event, ui) {
                    ui.item.fromTaskOrPhase = angular.element(event.target).scope().container;
                    ui.item.fromIndex = ui.item.index();
                    ui.item.id = ui.item.scope().task.id;

                    if (!!ui.item.sortable.model.locked) {
                        var currentContainerId = Ids.getParentIdGeneral(ui.item.sortable.model.id, '-');
                        angular.element('#release-content .phase .task-sortable').each(function () {
                            if (angular.element(this).data('container-id') !== currentContainerId) {
                                angular.element(this).addClass('disable-drop');
                            }
                        });
                    }
                },
                "sort": function sort(event, ui) {
                    // only for cursor style change
                    if (ui.placeholder.css('display') === 'none') {
                        if (angular.isUndefined(cursorStyle)) {
                            cursorStyle = angular.element(notAllowedCursorStyle).appendTo(body);
                        } else if (cursorStyle.html() !== notAllowedCursorStyle) {
                            cursorStyle.html(notAllowedCursorStyle);
                        }
                    } else {
                        if (angular.isUndefined(cursorStyle)) {
                            cursorStyle = angular.element(moveCursorStyle).appendTo(body);
                        } else if (cursorStyle.html() !== moveCursorStyle) {
                            cursorStyle.html(moveCursorStyle);
                        }
                    }
                },
                "update": function update(event, ui) {
                    if (!!ui.item.sortable.model.locked && ui.item.sortable.droptarget.data('container-id') !== ui.item.sortable.source.data('container-id')) {
                        ui.item.sortable.cancel();
                    }
                    if (isMovedBetweenContainers(ui)) {
                        moveTask(event, ui, scope);
                    }
                },
                "stop": function stop(event, ui) {
                    if (!isMovedBetweenContainers(ui)) {
                        moveTask(event, ui, scope);
                    }
                    if (!!ui.item.sortable.model.locked) {
                        angular.element('#release-content .phase .task-sortable').each(function () {
                            angular.element(this).removeClass('disable-drop');
                        });
                    }
                    if (angular.isDefined(cursorStyle)) {
                        cursorStyle.remove();
                        cursorStyle = undefined;
                    }
                }
            };
        }
    };
}]);

/***/ }),
/* 1196 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('worksheetScrolling', ['worksheetService', 'Scroll', 'Window', function (worksheetService, Scroll, Window) {

    var INCLUDE_MARGIN = true;
    var releaseHeaderHeight = void 0,
        navigatorTogglerWidth = void 0,
        wrapper = void 0,
        worksheetWidth = void 0,
        phaseMarginLeft = void 0,
        phaseMarginRight = void 0,
        phaseWidth = void 0,
        allPhasesWidth = void 0,
        scope = void 0;

    function updateOverflowFlag() {
        var contentWidth = wrapper.parents(".view").width();
        var wrapperWidth = wrapper.width();

        scope.hasOverflow = contentWidth < wrapperWidth;
        if (!scope.hasOverflow) {
            scope.showNavigator = false;
        }
    }

    function highlightCurrentPhasesLinks() {
        var phaseLinksConfig = worksheetService.computeWhichPhasesAreHighlighted({
            phaseWidth: phaseWidth,
            scrollLeft: wrapper.parents(".view").scrollLeft(),
            worksheetWidth: worksheetWidth,
            phaseMarginLeft: phaseMarginLeft,
            phaseMarginRight: phaseMarginRight
        });

        highlightPhasesLinks(phaseLinksConfig.firstPhaseVisibleIndex, phaseLinksConfig.numberOfDisplayedPhase);
    }

    function highlightPhasesLinks(firstPhaseVisibleIndex, numberOfDisplayedPhase) {
        var navigator = wrapper.siblings("#navigator");

        navigator.find(".phase-link-container").removeClass('highlight');
        for (var i = firstPhaseVisibleIndex; i < firstPhaseVisibleIndex + numberOfDisplayedPhase; i++) {
            navigator.find(".phase-link-container:nth-child(" + (i + 1) + ")").addClass("highlight");
        }
    }

    function computeDomElementsDimensions() {
        var phases = wrapper.find(".phase");
        phaseMarginLeft = _.parseInt(phases.css("margin-left"));
        phaseMarginRight = _.parseInt(phases.css("margin-right"));
        phaseWidth = phases.outerWidth(INCLUDE_MARGIN);
        allPhasesWidth = phases.length * phaseWidth;
        navigatorTogglerWidth = _.parseInt(wrapper.siblings("#navigator-toggler").width());
        releaseHeaderHeight = _.parseInt(wrapper.find("#release-header").outerHeight());
    }

    function computeWorksheetWidth() {
        worksheetWidth = wrapper.parents(".view").width() - navigatorTogglerWidth;
        if (scope.showNavigator) worksheetWidth -= wrapper.siblings("#navigator").width();

        var viewWithOnePhaseWidth = wrapper.parents(".view").width() - navigatorTogglerWidth - phaseWidth;
        var wrapperWidth = allPhasesWidth + viewWithOnePhaseWidth;

        wrapper.css({ 'min-width': wrapperWidth + 'px' });
    }

    function scrollingCtrl() {
        var ctrl = this;
        ctrl.setupScrollToPhase = function () {
            wrapper.siblings("#navigator").find(".phase-link").each(function (phaseIndex, item) {
                angular.element(item).unbind('click');
                angular.element(item).on('click', function () {
                    var phaseLink = angular.element(this);
                    ctrl.scrollTo(wrapper.find(".phase").eq(phaseIndex), null, function () {
                        phaseLink.addClass("scrolled");
                    });
                });
            });
        };
        ctrl.scrollTo = function (phase, task, callback) {
            var contentMarginLeft = _.parseInt(wrapper.find("#release-content").css("margin-left"));
            contentMarginLeft = isNaN(contentMarginLeft) ? 0 : contentMarginLeft;

            if (task !== null) {
                var phaseContent = phase.find('.phase-content');
                var li = task.parents('li');
                if (li.offset()) {
                    var scrollableContainerTop = phaseContent.offset().top;
                    var scrollableContainerBottom = scrollableContainerTop + phaseContent.height();
                    var currentTaskOffsetTop = li.offset().top;
                    var currentTaskOffsetBottom = currentTaskOffsetTop + li.height();
                    var isTaskVisible = currentTaskOffsetBottom <= scrollableContainerBottom && currentTaskOffsetTop >= scrollableContainerTop;
                    if (!isTaskVisible) {
                        phaseContent.scrollTop(currentTaskOffsetTop - scrollableContainerTop);
                    }
                }
            }

            var scrollParams = {
                scrollLeft: phase.prop('offsetLeft') - (navigatorTogglerWidth + contentMarginLeft + phaseMarginLeft),
                scrollTop: 0
            };

            Scroll.animate(wrapper.parents(".view"), scrollParams, callback);
        };
        ctrl.scrollUntilLastPhase = function () {
            var currentScrollLeft = Scroll.getLeftPosition(wrapper.parents(".view"));
            var phaseOutsideWorksheetWidth = allPhasesWidth - (currentScrollLeft + worksheetWidth);

            if (phaseOutsideWorksheetWidth > 0) {
                Scroll.animate(wrapper.parents(".view"), { scrollLeft: currentScrollLeft + phaseOutsideWorksheetWidth });
            }
        };
    }

    return {
        controller: scrollingCtrl,
        link: function link(currentScope, element, attr, ctrl) {
            wrapper = element;
            scope = currentScope;

            Window.onResize(function () {
                scope.$apply(function () {
                    computeWorksheetWidth();
                    updateOverflowFlag();
                    highlightCurrentPhasesLinks();
                });
            }, scope);

            scope.$watch('release.phases | filter:collapseFilter(release)', function (newPhases, oldPhases) {
                scope.$evalAsync(function () {
                    if (angular.isDefined(newPhases)) {
                        computeDomElementsDimensions();
                        computeWorksheetWidth();
                        updateOverflowFlag();
                        highlightCurrentPhasesLinks();

                        ctrl.setupScrollToPhase();
                        wrapper.parents(".view").unbind('scroll', highlightCurrentPhasesLinks);
                        wrapper.parents(".view").scroll(highlightCurrentPhasesLinks);

                        if (angular.isDefined(oldPhases)) {
                            if (worksheetService.isAddedPhaseLast(newPhases, oldPhases)) {
                                ctrl.scrollUntilLastPhase();
                            }
                        }
                    }
                });
            }, true);

            scope.$watch('showNavigator', function (isNavigatorOpen, wasNavigatorOpen) {
                if (isNavigatorOpen === wasNavigatorOpen) {
                    return;
                }
                computeWorksheetWidth();
                highlightCurrentPhasesLinks();
            });
        }
    };
}]);

angular.module('xlrelease').directive('scrollToMe', function () {
    return {
        require: '^worksheetScrolling',
        link: function link(scope, task, attr, scrollingCtrl) {
            if (!scope.init.hasScrolledToCurrentTask) {
                // DOM must be computed before scrolling
                scope.$watch('', function () {
                    scope.$evalAsync(function () {
                        scope.init.hasScrolledToCurrentTask = true;
                        scrollingCtrl.scrollTo(task.parents(".phase"), task);
                    });
                });
            }
        }
    };
});

/***/ }),
/* 1197 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('worksheetService', [function () {
    return {
        computeWhichPhasesAreHighlighted: function computeWhichPhasesAreHighlighted(worksheetConfig) {
            var hiddenPartOfLeftTruncatedPhase = worksheetConfig.scrollLeft % worksheetConfig.phaseWidth;
            var phaseWidthWithoutMargin = worksheetConfig.phaseWidth - worksheetConfig.phaseMarginLeft - worksheetConfig.phaseMarginRight;

            var firstPhaseStartVisibleOffset = void 0;
            if (hiddenPartOfLeftTruncatedPhase <= worksheetConfig.phaseMarginLeft) {
                firstPhaseStartVisibleOffset = worksheetConfig.phaseMarginLeft - hiddenPartOfLeftTruncatedPhase;
            } else {
                firstPhaseStartVisibleOffset = worksheetConfig.phaseWidth - hiddenPartOfLeftTruncatedPhase + worksheetConfig.phaseMarginLeft;
            }

            var worksheetWithEntirePhasesWidth = worksheetConfig.worksheetWidth - firstPhaseStartVisibleOffset;
            var numberOfDisplayedPhase = 0;
            if (worksheetWithEntirePhasesWidth >= phaseWidthWithoutMargin) {
                numberOfDisplayedPhase = 1 + Math.floor((worksheetWithEntirePhasesWidth - phaseWidthWithoutMargin) / worksheetConfig.phaseWidth);
            }

            var firstPhaseVisibleIndex = Math.floor(worksheetConfig.scrollLeft / worksheetConfig.phaseWidth);
            if (hiddenPartOfLeftTruncatedPhase > worksheetConfig.phaseMarginLeft) {
                firstPhaseVisibleIndex++;
            }

            return {
                firstPhaseVisibleIndex: firstPhaseVisibleIndex,
                numberOfDisplayedPhase: numberOfDisplayedPhase
            };
        },
        isAddedPhaseLast: function isAddedPhaseLast(newPhases, oldPhases) {
            if (newPhases.length === oldPhases.length + 1) {

                var lastNew = newPhases[newPhases.length - 1];
                var lastOld = oldPhases[oldPhases.length - 1];

                return oldPhases.length === 0 || lastNew.id !== lastOld.id;
            }

            return false;
        }
    };
}]);

angular.module('xlrelease').factory('Scroll', [function () {
    var ANIMATION_DURATION = 300;

    return {
        animate: function animate(element, params, callback) {
            element.animate(params, ANIMATION_DURATION, callback);
        },
        getLeftPosition: function getLeftPosition(jqueryElement) {
            return jqueryElement.scrollLeft();
        }
    };
}]);

/***/ }),
/* 1198 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').value('GanttCssClasses', {
    DEFAULT: 'gantt-cell',
    RELEASE: 'gantt-cell-release',
    PHASE: 'gantt-cell-phase',
    PHASE_PREFIX: 'gantt-cell-phase-',
    TASK: 'gantt-cell-task',
    TASK_STATUS_PREFIX: 'gantt-cell-task-status-'
});

angular.module('xlrelease').factory('XlrGantt', ['$rootScope', 'GanttElementsEditor', 'ClientSettings', 'GanttZoomSettings', 'Events', '$locale', 'dateFilter', 'GanttZoom', function ($rootScope, GanttElementsEditor, ClientSettings, GanttZoomSettings, Events, $locale, dateFilter, GanttZoom) {
    var removeLinkEventId = void 0,
        addLinkEventId = void 0,
        scrollState = void 0,
        onAfterLinkDeleteEventId = void 0;
    var eventsToDetach = [];
    var datesColumnsWidth = 115;
    var durationColumnsWidth = 100;
    var titleColumnWidth = 250;
    var RELEASE_TYPE = 'xlrelease.Release';

    var UpdateMode = {
        move: 'move',
        updateStartDate: 'updateStartDate',
        updateEndDate: 'updateEndDate'
    };

    function initStyling() {
        gantt.templates.task_class = taskClass;
        gantt.templates.grid_open = gridOpenHtml;
        gantt.templates.grid_row_class = defaultRowClass;
        gantt.templates.task_row_class = defaultRowClass;
        gantt.templates.grid_file = noIconHtml;
        gantt.templates.grid_folder = noIconHtml;
        gantt.templates.link_class = linkClass;

        function taskClass(start, end, task) {
            var classes = [task.cssClass];

            if (!GanttElementsEditor.canUpdateStartDate(task)) {
                classes.push('gantt-no-left-handle');
            }
            if (!GanttElementsEditor.canUpdateEndDate(task)) {
                classes.push('gantt-no-right-handle');
            }

            var parentTask = task.parent ? gantt.getTask(task.parent) : null;
            if (!GanttElementsEditor.canCreateLinks(parentTask)) {
                classes.push('gantt-no-custom-links');
            }

            return classes.join(' ');
        }

        function linkClass(link) {
            return link.readOnly ? 'readonly-link' : '';
        }

        function defaultRowClass() {
            return 'gantt-row';
        }

        function noIconHtml() {
            return '<span class="no-icon"></span>';
        }

        function gridOpenHtml(item) {
            var classes = ['gantt_tree_icon xl-icon', 'gantt-folder'];
            if (item.$open) {
                classes.push('gantt_close arrow-down-icon', 'gantt-folder-close');
            } else {
                classes.push('gantt_open arrow-right-icon', 'gantt-folder-open');
            }
            return "<div class='" + classes.join(' ') + "'>​</div>​";
        }
    }

    function initLocale() {
        gantt.locale.date = {
            month_full: $locale.DATETIME_FORMATS.MONTH,
            month_short: $locale.DATETIME_FORMATS.SHORTMONTH,
            day_full: $locale.DATETIME_FORMATS.DAY,
            day_short: $locale.DATETIME_FORMATS.SHORTDAY
        };
    }

    function initEvents() {
        eventsToDetach.forEach(function (eventId) {
            gantt.detachEvent(eventId);
        });
        eventsToDetach = [];

        var attachEventToGantt = function attachEventToGantt(event, handler) {
            var eventId = gantt.attachEvent(event, handler);
            eventsToDetach.push(eventId);
            return eventId;
        };

        attachEventToGantt("onBeforeTaskDrag", function (id, mode) {
            scrollState = gantt.getScrollState();

            var element = gantt.getTask(id);
            element.previousScheduledStartDate = element.start_date;
            element.previousDueDate = element.end_date;

            switch (getUpdateMode(mode)) {
                case UpdateMode.move:
                    return GanttElementsEditor.canMove(element);
                case UpdateMode.updateStartDate:
                    return GanttElementsEditor.canUpdateStartDate(element);
                case UpdateMode.updateEndDate:
                    return GanttElementsEditor.canUpdateEndDate(element);
            }
        });

        attachEventToGantt("onAfterTaskDrag", function (id, mode) {
            var element = gantt.getTask(id);

            switch (getUpdateMode(mode)) {
                case UpdateMode.move:
                    GanttElementsEditor.move(element, element.start_date, element.end_date);
                    break;
                case UpdateMode.updateStartDate:
                    GanttElementsEditor.dragLeft(element, element.start_date);
                    break;
                case UpdateMode.updateEndDate:
                    GanttElementsEditor.dragRight(element, element.end_date);
                    break;
            }

            gantt.scrollTo(scrollState.x, scrollState.y);
        });

        function canAddLink(linkId, link) {
            var source = gantt.getTask(link.source);
            var target = gantt.getTask(link.target);

            return GanttElementsEditor.canLink(source, target, link.type);
        }

        function saveCollapseState(id, isOpen) {
            var states = ClientSettings.getGanttElementsCollapseState();
            if (!states) states = {};
            states[id] = isOpen;
            ClientSettings.setGanttElementsCollapseState(states);
        }

        // Almost the same listener here, expect that it doesn't take a linkId
        var canAddLinkWithoutLinkId = _.partial(canAddLink, undefined);

        attachEventToGantt("onLinkValidation", canAddLinkWithoutLinkId);
        attachEventToGantt("onBeforeLinkAdd", canAddLink);
        attachEventToGantt("onTaskClosed", function (id) {
            saveCollapseState(id, false);
        });
        attachEventToGantt("onTaskOpened", function (id) {
            saveCollapseState(id, true);
        });

        addLinkEventId = attachEventToGantt("onAfterLinkAdd", function (linkId, link) {
            var source = gantt.getTask(link.source);
            var target = gantt.getTask(link.target);
            var container = gantt.getTask(source.parent);

            GanttElementsEditor.addLink(link, container, source, target);
        });

        onAfterLinkDeleteEventId = attachEventToGantt("onAfterLinkDelete", function (linkId, link) {
            var source = gantt.getTask(link.source);
            var container = gantt.getTask(source.parent);

            GanttElementsEditor.removeLink(link, container);
        });

        attachEventToGantt("onTaskDblClick", function (elementId) {
            var element = gantt.getTask(elementId);
            if (element.type === "xlrelease.Release") {
                // To be implemented
            } else if (element.type === "xlrelease.Phase") {
                $rootScope.$apply(function () {
                    $rootScope.$broadcast(Events.gantt.openPhaseDetails, elementId);
                });
            } else {
                $rootScope.$apply(function () {
                    $rootScope.$broadcast(Events.gantt.openTaskDetails, elementId);
                });
            }
            return false;
        });

        attachEventToGantt("onTaskClick", function () {
            return false;
        });
    }

    function initRemoveLinkEvent(isReadOnly) {
        removeLinkEventId = gantt.attachEvent("onLinkDblClick", function (linkId) {
            var link = gantt.getLink(linkId);
            var source = gantt.getTask(link.source);
            var parent = gantt.getTask(source.parent);

            return !link.readOnly && !isReadOnly && !parent.locked;
        });
    }

    function formatDateAndTime(date) {
        return "<span class='readonly-date'>" + dateFilter(date, 'shortDate') + "</span><span class='readonly-time'>" + dateFilter(date, 'shortTime') + "</span>";
    }

    function isDateDeletable(element, dateType) {
        if (element.status === "TEMPLATE" && dateType === "end") {
            return true;
        }

        return element.type !== RELEASE_TYPE;
    }

    function dateEditorTemplate(date, dateType, hasOwnDate, element) {
        var elementId = element.id;

        var dateCanBeDeleted = isDateDeletable(element, dateType);
        return "<div class='gantt-date-editor-container' " + "data-date=" + date.getTime() + " " + "data-type='" + dateType + "' " + "data-id='" + elementId + "' " + "data-deletable='" + dateCanBeDeleted + "' " + "data-has-own-date='" + hasOwnDate + "'" + "></div>";
    }

    function durationEditorTemplate(plannedDuration, displayedDuration, elementId, done, editable) {
        function toBoolean(value) {
            return value ? 'true' : 'false';
        }

        return "<div class='gantt-duration-editor-container' " + "data-duration='" + plannedDuration + "' " + "data-display-duration='" + displayedDuration + "' d" + "ata-id='" + elementId + "' " + "data-done='" + toBoolean(done) + "' " + "data-editable='" + toBoolean(editable) + "' " + "></div>";
    }

    function getGridWidth(isDatesColumnsShown) {
        var width = 20;
        width += titleColumnWidth;
        if (isDatesColumnsShown) {
            width += 2 * datesColumnsWidth + durationColumnsWidth;
        }
        return width;
    }

    function getColumns(isDatesColumnsShown) {
        var columns = [{
            name: "text",
            tree: true,
            width: titleColumnWidth + "px"
        }];

        if (isDatesColumnsShown) {
            columns.push({
                name: "start_date",
                align: "left",
                width: datesColumnsWidth + "px",
                template: function template(element) {
                    if (element.hasBeenStarted || gantt.config.readonly) {
                        return formatDateAndTime(element.start_date);
                    } else {
                        return dateEditorTemplate(element.start_date, "start", element.hasOwnStartDate, element);
                    }
                }
            });
            columns.push({
                name: "end_date",
                align: "left",
                width: datesColumnsWidth + "px",
                template: function template(element) {
                    if (!element.isUpdatable || gantt.config.readonly) {
                        return formatDateAndTime(element.end_date);
                    } else {
                        return dateEditorTemplate(element.end_date, "end", element.hasOwnEndDate, element);
                    }
                }
            });
            columns.push({
                name: "duration",
                align: "middle",
                width: durationColumnsWidth + "px",
                template: function template(element) {
                    var editable = element.isUpdatable && !gantt.config.readonly;
                    return durationEditorTemplate(element.planItem.plannedDuration, element.displayDuration, element.id, element.planItem.done, editable);
                }
            });
        }
        return columns;
    }

    return {
        config: function config(isDatesColumnsShown) {
            gantt.config.round_dnd_dates = false;
            gantt.config.fit_tasks = true;
            GanttZoom.getCurrent().apply();

            // set columns
            gantt.locale.labels.column_text = 'Name';

            if (isDatesColumnsShown) {
                gantt.locale.labels.column_start_date = 'Start date';
                gantt.locale.labels.column_end_date = 'End date';
                gantt.locale.labels.column_duration = 'Duration';
            }

            gantt.config.columns = getColumns(isDatesColumnsShown);
            gantt.config.grid_width = getGridWidth(isDatesColumnsShown);

            //read only settings
            gantt.config.show_progress = false;
            gantt.config.drag_links = true;
            gantt.config.min_duration = 60 * 1000;

            initStyling();
            initLocale();
            initEvents();
        },
        initReadOnly: function initReadOnly(isReadOnly) {
            gantt.config.readonly = isReadOnly;
            gantt.config.drag_resize = !isReadOnly;
            initRemoveLinkEvent(isReadOnly);
        },
        destroy: function destroy() {
            gantt.unselectTask();
            gantt.clearAll();
            if (removeLinkEventId) gantt.detachEvent(removeLinkEventId);
            if (addLinkEventId) gantt.detachEvent(addLinkEventId);
            if (onAfterLinkDeleteEventId) gantt.detachEvent(onAfterLinkDeleteEventId);
        }
    };

    function getUpdateMode(mode) {
        if (mode === gantt.config.drag_mode.move) {
            return UpdateMode.move;
        } else if (mode === gantt.config.drag_mode.resize) {
            if (gantt.getState().drag_from_start) {
                return UpdateMode.updateStartDate;
            } else {
                return UpdateMode.updateEndDate;
            }
        }
    }
}]);

/***/ }),
/* 1199 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('GanttController', ['$scope', '$location', 'GanttZoom', 'releasePromise', 'Events', 'ReleasesService', 'GanttElementsEditor', 'Backend', 'TaskDetailsUpdates', 'PhaseDetailsUpdates', 'Page', 'ClientSettings', 'Planner', 'DependenciesService', 'ViewStorage', function ($scope, $location, GanttZoom, releasePromise, Events, ReleasesService, GanttElementsEditor, Backend, TaskDetailsUpdates, PhaseDetailsUpdates, Page, ClientSettings, Planner, DependenciesService, ViewStorage) {
    $scope.release = releasePromise.data;
    Planner.setRelease($scope.release);

    DependenciesService.getReleaseTree($scope.release).then(function (releaseTree) {
        Planner.setReleaseTree(releaseTree);
        GanttElementsEditor.updateGanttElements();
    });

    ViewStorage.setView($scope.release.id, $location.path());

    Page.setReleaseOpened($scope.release);
    $scope.inGantt = true;

    $scope.ganttZoom = GanttZoom;

    $scope.ganttConfig = {
        isReadOnly: !$scope.security.hasEditPermission($scope.release),
        isDatesColumnsShown: ClientSettings.getGanttDatesColumnsCollapseState()
    };

    function loadGanttAfterUpdate() {
        ReleasesService.getRelease($scope.release.id).then(function (resp) {
            $scope.release = resp.data;
            Planner.setRelease($scope.release);
            GanttElementsEditor.updateGanttElements();
        });
    }

    $scope.endEditTask = function () {
        $scope.editTask = false;
        if (TaskDetailsUpdates.planningDataChanged) {
            loadGanttAfterUpdate();
            TaskDetailsUpdates.reset();
        } else {
            GanttElementsEditor.updateGanttElements();
        }
    };

    $scope.$on(Events.gantt.openTaskDetails, function (event, taskId) {
        var tasks = ReleasesService.getAllTasks($scope.release);
        $scope.task = _.find(tasks, function (task) {
            return task.id === taskId;
        });
        $scope.editTask = true;
    });

    $scope.endEditPhase = function () {
        $scope.editPhase = false;
        if (PhaseDetailsUpdates.planningDataChanged) {
            loadGanttAfterUpdate();
            PhaseDetailsUpdates.reset();
        } else {
            GanttElementsEditor.updateGanttElements();
        }
    };

    $scope.$on(Events.gantt.openPhaseDetails, function (event, phaseId) {
        $scope.phase = _.find($scope.release.phases, function (phase) {
            return phase.id === phaseId;
        });
        $scope.editPhase = true;
    });

    $scope.$watch('ganttConfig.isDatesColumnsShown', function (newValue, oldValue) {
        if (newValue !== oldValue) {
            ClientSettings.setGanttDatesColumnsCollapseState($scope.ganttConfig.isDatesColumnsShown);
        }
    });
}]);

/***/ }),
/* 1200 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/* eslint-disable angular/module-getter */
function GanttDirective(Planner, XlrGantt, $parse, Window, $compile, Timeout, Events, GanttWrapper, Layout) {

    function adjustGanttHeight(ganttElement) {
        // 2 extra pixels needed for some unknown reason
        var extra = 2;

        ganttElement.height(Window.height() - ganttElement.offset().top - Layout.mainPageBorder - extra);
    }

    // link need to be undefined for IE...
    var dateEditorLink = undefined;
    var durationEditorLink = undefined;

    function postProcessGanttDom(scope) {
        if (!dateEditorLink) {
            dateEditorLink = $compile("<div gantt-date-editor></div>");
        }
        if (!durationEditorLink) {
            durationEditorLink = $compile("<div gantt-duration-editor></div>");
        }
        Timeout(function () {
            angular.element('.gantt-date-editor-container, .gantt-duration-editor-container').each(function (index, item) {
                var editor = angular.element(item).hasClass('gantt-date-editor-container') ? dateEditorLink : durationEditorLink;
                angular.element(item).empty();
                editor(scope, function (clonedElement) {
                    angular.element(item).append(clonedElement);
                });
            });
        }, 0);
    }

    return function link(scope, element, attrs) {
        XlrGantt.config(scope.ganttConfig.isDatesColumnsShown);

        scope.$on(Events.gantt.hasBeenRefreshed, function () {
            postProcessGanttDom(scope);
        });

        XlrGantt.initReadOnly($parse(attrs.readonly)(scope));
        adjustGanttHeight(element);

        element.dhx_gantt({
            data: {
                data: Planner.makePlan().elements,
                links: Planner.getLinks()
            }
        });

        Window.onResize(function () {
            adjustGanttHeight(element);
        }, scope);

        element.on('$destroy', function () {
            XlrGantt.destroy();
        });

        scope.$watch('ganttConfig.isDatesColumnsShown', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                XlrGantt.config(newValue);
                GanttWrapper.render();
            }
        });
    };
}

GanttDirective.$inject = ['Planner', 'XlrGantt', '$parse', 'Window', '$compile', 'Timeout', 'Events', 'GanttWrapper', 'Layout'];

angular.module('xlrelease').directive('xlrGantt', GanttDirective);

/***/ }),
/* 1201 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('GanttElementsEditor', ['GanttCssClasses', 'PhaseColors', 'TasksService', 'taskTypeCssClassFilter', 'Backend', 'VariablesInterpolator', 'GanttWrapper', 'Planner', 'TopologicalSort', 'PlanningDataEditor', function (GanttCssClasses, PhaseColors, TasksService, taskTypeCssClassFilter, Backend, VariablesInterpolator, GanttWrapper, Planner, TopologicalSort, PlanningDataEditor) {
    var FROM_END_TO_START = '0';

    function createsCycle(existingEdges, newSource, newTarget) {
        var adjacencyList = [];
        var vertices = {};

        _.forEach(existingEdges, function (edge) {
            var sourceId = edge.source,
                targetId = edge.target;
            adjacencyList.push({ sourceId: sourceId, targetId: targetId });
            vertices[sourceId] = vertices[targetId] = true;
        });

        var sourceId = newSource.id,
            targetId = newTarget.id;
        adjacencyList.push({ sourceId: sourceId, targetId: targetId });
        vertices[sourceId] = vertices[targetId] = true;

        var graph = { adjacencyList: adjacencyList, vertices: _.keys(vertices) };
        return TopologicalSort.sort(graph) === null;
    }

    function saveAndRefresh(element) {
        updateGanttElements();
        Backend.put('planning/' + element.id, {
            scheduledStartDate: element.planItem.scheduledStartDate,
            dueDate: element.planItem.dueDate,
            plannedDuration: element.planItem.plannedDuration
        });
    }

    function updateGanttElements() {
        var elements = Planner.makePlan().elements;

        _.forEach(elements, function (updatedElement) {
            var element = GanttWrapper.getTask(updatedElement.id);
            angular.extend(element, updatedElement);
        });

        GanttWrapper.refreshData();
    }

    return {
        dragLeft: function dragLeft(element, date) {
            PlanningDataEditor.dragLeft(element, date);
            saveAndRefresh(element);
        },
        dragRight: function dragRight(element, date) {
            PlanningDataEditor.dragRight(element, date);
            saveAndRefresh(element);
        },
        move: function move(element, startDate, endDate) {
            PlanningDataEditor.move(element, startDate, endDate);
            saveAndRefresh(element);
        },
        setStartDate: function setStartDate(element, date) {
            PlanningDataEditor.setStartDate(element, date);
            saveAndRefresh(element);
        },
        setEndDate: function setEndDate(element, date) {
            PlanningDataEditor.setEndDate(element, date);
            saveAndRefresh(element);
        },
        setDuration: function setDuration(element, duration) {
            PlanningDataEditor.setDuration(element, duration);
            saveAndRefresh(element);
        },
        canMove: function canMove(element) {
            return this.canUpdateStartDate(element) && this.canUpdateEndDate(element) && !element.locked;
        },
        canUpdateStartDate: function canUpdateStartDate(element) {
            return element.hasBeenStarted === false && !element.locked;
        },
        canUpdateEndDate: function canUpdateEndDate(element) {
            return element.isUpdatable && !element.locked;
        },
        canCreateLinks: function canCreateLinks(container) {
            return container && TasksService.isParallelGroup(container) && !container.hasBeenStarted && !container.locked;
        },
        canLink: function canLink(source, target, linkType) {
            return linkType === FROM_END_TO_START && source.parent === target.parent && !GanttWrapper.isLinkExists(Planner.makeLinkId(source.id, target.id)) && !createsCycle(GanttWrapper._get_links_data(), source, target);
        },
        addLink: function addLink(link, container, source, target) {
            var linkForm = {
                sourceId: source.id,
                targetId: target.id
            };
            container.planItem.links.push(linkForm);
            updateGanttElements();
            Backend.post('planning/links/' + container.id, linkForm).then(function (resp) {
                linkForm.id = link.linkId = resp.data.id;
                GanttWrapper.changeLinkId(link.id, Planner.makeLinkId(source.id, target.id));
            });
        },
        removeLink: function removeLink(link, container) {
            container.planItem.links = _.reject(container.planItem.links, function (itemLink) {
                return itemLink.id === link.linkId;
            });
            updateGanttElements();
            Backend.del('planning/links/' + link.linkId);
        },

        updateGanttElements: updateGanttElements
    };
}]);

/***/ }),
/* 1202 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Wrap the gantt global variable for test purposes
 */

angular.module('xlrelease').factory('GanttWrapper', ['$rootScope', 'Events', function ($rootScope, Events) {
    var oldRender = gantt.render;
    var oldRefreshData = gantt.refreshData;

    gantt.render = function () {
        $rootScope.$broadcast(Events.gantt.hasBeenRefreshed);
        oldRender.call(gantt);
    };

    gantt.refreshData = function () {
        $rootScope.$broadcast(Events.gantt.hasBeenRefreshed);
        oldRefreshData.call(gantt);
    };

    return gantt;
}]);

/***/ }),
/* 1203 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('GanttZoom', ['GanttZoomSettings', 'ClientSettings', function (GanttZoomSettings, ClientSettings) {
    var registeredZoomLevel = ClientSettings.getGanttZoomLevel();
    var current = void 0;
    if (registeredZoomLevel) {
        current = GanttZoomSettings.findByLabel(registeredZoomLevel);
    } else {
        current = GanttZoomSettings.defaultZoom;
    }

    var zooms = GanttZoomSettings.zooms;

    function currentIndex() {
        return _.indexOf(zooms, current);
    }

    return {
        zooms: zooms,
        getCurrent: function getCurrent() {
            return current;
        },
        isCurrent: function isCurrent(zoom) {
            return current === zoom;
        },
        next: function next() {
            return this.zooms[currentIndex() + 1];
        },
        previous: function previous() {
            return this.zooms[currentIndex() - 1];
        },
        hasNext: function hasNext() {
            return currentIndex() < this.zooms.length - 1;
        },
        hasPrevious: function hasPrevious() {
            return currentIndex() > 0;
        },
        select: function select(zoom) {
            current = zoom;
            ClientSettings.setGanttZoomLevel(current.label);
            current.render();
        }
    };
}]);

angular.module('xlrelease').factory('GanttZoomSettings', ['DateFormatDetector', function (DateFormatDetector) {
    var Zoom = function Zoom(label, applyFn) {
        this.label = label;
        this.apply = applyFn;
    };

    Zoom.prototype.render = function () {
        this.apply();
        gantt.render();
    };

    var hourFormat = DateFormatDetector.isAmPmVisible() ? "%g%a" : "%Hh";
    var hourFormatWithMinutes = DateFormatDetector.isAmPmVisible() ? "%g:%i%a" : "%Hh%i";

    var isMonthDisplayedBeforeDay = DateFormatDetector.isMonthDisplayedBeforeDay();
    var shortDayFormat = isMonthDisplayedBeforeDay ? "%M %d" : "%d %M";
    var longDayFormat = isMonthDisplayedBeforeDay ? "%F %d" : "%d %F";

    var zooms = [new Zoom('Month', function () {
        gantt.config.scale_unit = "month";
        gantt.config.date_scale = "%M";
        gantt.config.subscales = [];

        gantt.config.time_step = 60 * 24; // minutes
    }), new Zoom('Week', function () {
        gantt.config.scale_unit = "week";
        gantt.config.date_scale = "Week %W";
        gantt.config.subscales = [];

        gantt.config.time_step = 60 * 24; // minutes
    }), new Zoom('Day', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = shortDayFormat;
        gantt.config.subscales = [];

        gantt.config.time_step = 60; // minutes
    }), new Zoom('8h', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = longDayFormat;
        gantt.config.subscales = [{ unit: "hour", step: 8, date: hourFormat }];

        gantt.config.time_step = 10; // minutes
    }), new Zoom('4h', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = longDayFormat;
        gantt.config.subscales = [{ unit: "hour", step: 4, date: hourFormat }];

        gantt.config.time_step = 10; // minutes
    }), new Zoom('2h', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = longDayFormat;
        gantt.config.subscales = [{ unit: "hour", step: 2, date: hourFormat }];

        gantt.config.time_step = 10; // minutes
    }), new Zoom('1h', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = longDayFormat;
        gantt.config.subscales = [{ unit: "hour", step: 1, date: hourFormat }];

        gantt.config.time_step = 10; // minutes
    }), new Zoom('30min', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = longDayFormat;
        gantt.config.subscales = [{ unit: "minute", step: 30, date: hourFormatWithMinutes }];

        gantt.config.time_step = 10; // minutes
    }), new Zoom('15min', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = longDayFormat;
        gantt.config.subscales = [{ unit: "minute", step: 15, date: hourFormatWithMinutes }];

        gantt.config.time_step = 5; // minutes
    }), new Zoom('5min', function () {
        gantt.config.scale_unit = "day";
        gantt.config.date_scale = longDayFormat;
        gantt.config.subscales = [{ unit: "minute", step: 5, date: hourFormatWithMinutes }];

        gantt.config.time_step = 5; // minutes
    })];

    return {
        zooms: zooms,
        defaultZoom: zooms[2],
        findByLabel: function findByLabel(searchedLabel) {
            return _.find(zooms, { label: searchedLabel }) || this.defaultZoom;
        }
    };
}]);

/***/ }),
/* 1204 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _set = __webpack_require__(706);

var _set2 = _interopRequireDefault(_set);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').factory('Planner', ['TasksService', 'TopologicalSort', 'VariablesInterpolator', 'PhaseColors', 'GanttCssClasses', 'PhasesService', 'ClientSettings', 'ReleasesService', 'taskTypeCssClassFilter', 'DateService', 'Ids', function (TasksService, TopologicalSort, VariablesInterpolator, PhaseColors, GanttCssClasses, PhasesService, ClientSettings, ReleasesService, taskTypeCssClassFilter, DateService, Ids) {
    var MANUAL_TASK_DURATION = 60;
    var AUTOMATED_TASK_DURATION = 1;
    var PHASE_COLORS = _.keyBy(PhaseColors, 'value');
    var DEFAULT_PHASE_COLOR = PhaseColors[0].name;
    var FROM_END_TO_START = '0';

    var release = void 0,
        releaseTree = void 0;

    function makeLinkId(sourceId, targetId) {
        return sourceId + '|' + targetId;
    }

    function hasPlannedDuration(planItem) {
        return planItem.plannedDuration !== null && angular.isDefined(planItem.plannedDuration);
    }

    function flattenPlan(plan) {
        var elements = [plan];
        _.forEach(plan.children, function (child) {
            elements = elements.concat(flattenPlan(child));
        });
        return elements;
    }

    var getCollapseState = function getCollapseState(item) {
        var states = ClientSettings.getGanttElementsCollapseState();
        var isOpenByDefault = ReleasesService.isRelease(item) || TasksService.isTask(item) && !TasksService.isTaskGroup(item);
        return states === null || angular.isUndefined(states[item.id]) ? isOpenByDefault : states[item.id];
    };

    return {
        makePlan: function makePlan(showAdditionalProperties) {
            if (_.isUndefined(showAdditionalProperties)) {
                showAdditionalProperties = true;
            }

            var releaseTreeById = flattenReleaseTree(releaseTree, release);
            var now = DateService.getTodayWithTime();
            var processingStack = [];
            var plannedReleaseIds = new _set2.default();
            var plan = makePlan(release, now, now, null, showAdditionalProperties);
            var elements = flattenPlan(plan);

            return {
                plan: plan,
                elements: elements,
                plannedEndDate: findMaxDisplayEndDate(elements)
            };

            function makePlan(item, proposedStartDate, now, parent, enrichPlan) {
                var plan = {
                    id: item.id,
                    type: item.type,
                    displayStartDate: computeStartDate(item, proposedStartDate),
                    children: [],
                    locked: item.locked
                };

                if (_.includes(processingStack, item.id)) {
                    plan.displayEndDate = plan.displayStartDate;
                    plan.displayDuration = 0;
                    cacheDisplayDates(plan, releaseTreeById);
                    return plan;
                }
                processingStack.push(item.id);

                if (TasksService.isParallelGroup(item)) {
                    plan.children = makeSubTaskPlans(item, plan.displayStartDate, now, item, enrichPlan);
                    var proposedDate = findMaxDisplayEndDate(plan.children) || plan.displayStartDate;
                    plan.displayEndDate = computeEndDate(item, proposedDate, plan.displayStartDate);
                } else if (TasksService.isGateTask(item)) {
                    plan.displayEndDate = computeEndDate(item, computeDependenciesEndDate(plan, item), plan.displayStartDate, now);
                } else {
                    var currentDate = plan.displayStartDate;

                    _(getChildren(item)).forEach(function (child) {
                        var childPlan = makePlan(child, currentDate, now, item, enrichPlan);
                        plan.children.push(childPlan);
                        if (!TasksService.isTaskDoneInAdvance(child)) {
                            currentDate = childPlan.displayEndDate;
                        }
                    });

                    plan.displayEndDate = computeEndDate(item, currentDate, plan.displayStartDate, now);
                }
                plan.displayDuration = plan.displayEndDate.diff(plan.displayStartDate, 'milliseconds');

                if (enrichPlan) {
                    addAdditionalProperties(plan, item, parent);
                }

                cacheDisplayDates(plan, releaseTreeById);

                processingStack.pop();
                return plan;
            }

            function addAdditionalProperties(plan, item, parent) {
                plan.hasBeenStarted = item.hasBeenStarted;
                plan.text = VariablesInterpolator.interpolateInHtml(release.variables, item.title);
                plan.plainText = VariablesInterpolator.interpolateInText(release.variables, item.title);
                plan.childrenIds = toIds(plan.children);
                plan.cssClass = GanttCssClasses.DEFAULT + ' ' + getCssClass(item);
                plan.isUpdatable = item.updatable;
                plan.open = getCollapseState(item);
                plan.start_date = plan.displayStartDate.toDate();
                plan.end_date = plan.displayEndDate.toDate();
                plan.parent = getParentId(parent);
                plan.planItem = item;
                plan.hasOwnStartDate = hasOwnStartDate(item);
                plan.hasOwnEndDate = hasOwnEndDate(item);
                plan.status = item.status;
            }

            function hasOwnStartDate(planItem) {
                return planItem.scheduledStartDate || planItem.startDate;
            }

            function hasOwnEndDate(planItem) {
                return planItem.dueDate || planItem.endDate;
            }

            function getParentId(parentElement) {
                return parentElement ? parentElement.id : undefined;
            }

            function getCssClass(item) {
                if (ReleasesService.isRelease(item)) {
                    return GanttCssClasses.RELEASE;
                } else if (PhasesService.isPhase(item)) {
                    return getPhaseCssClass(item);
                } else {
                    return getTaskCssClass(item);
                }
            }

            function getPhaseCssClass(phase) {
                var cssClass = GanttCssClasses.PHASE;

                if (phase.color && PHASE_COLORS[phase.color]) {
                    cssClass += ' ' + GanttCssClasses.PHASE_PREFIX + PHASE_COLORS[phase.color].name;
                } else {
                    cssClass += ' ' + GanttCssClasses.PHASE_PREFIX + DEFAULT_PHASE_COLOR;
                }

                return cssClass;
            }

            function getTaskCssClass(task) {
                var cssClasses = GanttCssClasses.TASK + ' ' + taskTypeCssClassFilter(task.type);
                if (task.status) {
                    cssClasses += ' ' + GanttCssClasses.TASK_STATUS_PREFIX + task.status.toLowerCase();
                }
                return cssClasses;
            }

            function toIds(planItems) {
                return _.map(planItems, 'id');
            }

            function makeSubTaskPlans(item, currentDate, now, parent, enrichPlan) {
                var tasks = getChildren(item);
                var taskIds = toIds(tasks);

                var orderedTaskIds = TopologicalSort.sort({
                    adjacencyList: item.links,
                    vertices: taskIds
                });

                var orderedTasks = mapIdsToObjects(orderedTaskIds, tasks);
                var orderedPlans = [];

                _(orderedTasks).forEach(function (task) {
                    var predecessors = mapIdsToObjects(findPredecessorsIds(item.links, task.id), orderedPlans);
                    var startDate = predecessors.length ? findMaxDisplayEndDate(predecessors) : currentDate;
                    var childPlan = makePlan(task, startDate, now, parent, enrichPlan);
                    orderedPlans.push(childPlan);
                });

                return mapIdsToObjects(taskIds, orderedPlans);
            }

            function findPredecessorsIds(links, taskId) {
                var directPredecessorsIds = _.chain(links).filter(function (link) {
                    return link.targetId === taskId;
                }).map('sourceId').value();
                var predecessorsIds = [];
                _.forEach(directPredecessorsIds, function (predecessorId) {
                    predecessorsIds = predecessorsIds.concat(findPredecessorsIds(links, predecessorId));
                });
                return _.uniq(predecessorsIds.concat(directPredecessorsIds));
            }

            function getChildren(item) {
                return item.phases || item.tasks || item.children;
            }

            function computeStartDate(item, proposedDate) {
                if (item.startDate) {
                    return moment(item.startDate).startOf('minute');
                }
                if (item.scheduledStartDate) {
                    return moment(item.scheduledStartDate).startOf('minute');
                }
                if (item.dueDate && hasPlannedDuration(item)) {
                    return moment(item.dueDate).subtract(item.plannedDuration, 'milliseconds').startOf('minute');
                }
                return moment(proposedDate).startOf('minute');
            }

            function computeEndDate(item, proposedDate, displayStartDate, now) {
                var endDate = void 0;
                if (item.endDate) {
                    endDate = moment(item.endDate);
                } else if (item.dueDate) {
                    endDate = moment(item.dueDate);
                } else if (hasPlannedDuration(item)) {
                    endDate = moment(displayStartDate).add(item.plannedDuration, 'milliseconds');
                } else if (isAutomatedTask(item)) {
                    endDate = moment(proposedDate).add(AUTOMATED_TASK_DURATION, 'minutes');
                } else if (isManualTask(item) && !isDependentTask(item)) {
                    endDate = moment(proposedDate).add(MANUAL_TASK_DURATION, 'minutes');
                } else {
                    endDate = moment(proposedDate);
                }

                if (endDate.isBefore(displayStartDate)) {
                    endDate = moment(displayStartDate);
                }

                if (isActiveLeafTask(item) && endDate.isBefore(now)) {
                    endDate = moment(now);
                }

                return endDate.startOf('minute');
            }

            function cacheDisplayDates(plan, releaseTreeById) {
                if (_.has(releaseTreeById, plan.id)) {
                    var cachedItem = releaseTreeById[plan.id];
                    cachedItem.startDate = plan.displayStartDate;
                    cachedItem.endDate = plan.displayEndDate;
                }
            }

            function computeDependenciesEndDate(plan, item) {
                var proposedEndDate = plan.displayStartDate;
                if (!hasOwnEndDate(item) && !hasPlannedDuration(item) && item.dependencies) {
                    item.dependencies.filter(isDependencyUnresolved).forEach(function (dependency) {
                        var calculatedEndDate = computeDependencyEndDate(dependency);

                        if (calculatedEndDate && calculatedEndDate.isAfter(proposedEndDate)) {
                            proposedEndDate = calculatedEndDate;
                        }
                    });
                }
                return proposedEndDate;
            }

            function isDependencyUnresolved(dependency) {
                return !dependency.resolved && !dependency.archived && _.has(dependency, 'variableOrTarget.value.id');
            }

            function computeDependencyEndDate(dependency) {
                var dependencyNode = dependency.variableOrTarget.value;
                var calculatedEndDate = null;

                if (hasOwnEndDate(dependencyNode)) {
                    calculatedEndDate = moment(dependencyNode.endDate || dependencyNode.dueDate);
                } else {
                    var target = _.get(releaseTreeById, dependencyNode.id);
                    var targetRelease = _.get(releaseTreeById, dependencyNode.id && Ids.releaseIdFrom(dependencyNode.id));

                    if (targetRelease && target) {
                        if (!plannedReleaseIds.has(targetRelease.id)) {
                            makePlan(targetRelease, now, now);
                            plannedReleaseIds.add(targetRelease.id);
                        }
                        calculatedEndDate = moment(target.endDate);
                    }
                }

                return calculatedEndDate;
            }

            function isAutomatedTask(item) {
                return TasksService.isTask(item) && TasksService.isAutomated(item);
            }

            function isManualTask(item) {
                return !TasksService.isTaskGroup(item) && TasksService.isTask(item) && !TasksService.isAutomated(item);
            }

            function isDependentTask(item) {
                return TasksService.isGateTask(item) && !_.isEmpty(item.dependencies);
            }

            function isActiveLeafTask(item) {
                return item.active && TasksService.isTask(item) && !TasksService.isTaskGroup(item);
            }

            function findMaxDisplayEndDate(items) {
                return findMaxDate(items, 'displayEndDate');
            }

            function findMaxDate(items, dateProperty) {
                if (!items || _.isEmpty(items)) {
                    return null;
                }

                return _.maxBy(items, function (child) {
                    var date = child[dateProperty] || 0;
                    return _.isNumber(date) ? date : date.valueOf();
                })[dateProperty];
            }

            function mapIdsToObjects(ids, objects) {
                return _.map(ids, function (id) {
                    return _.find(objects, { id: id });
                });
            }

            function flattenReleaseTree(releaseTree, release) {
                if (_.isEmpty(releaseTree)) {
                    return {};
                }
                return _.chain([release].concat(_.values(releaseTree.dependentReleases))).map(function (releaseTreeItem) {
                    return flattenPlan(angular.copy(releaseTreeItem));
                }).flatten().groupBy('id').mapValues(function (items) {
                    return _.head(items);
                }).value();
            }
        },

        getLinks: function getLinks() {
            var links = [];

            addLinksBetweenPhases();
            addLinksBetweenTasks();
            addLinksWithinTaskGroups();

            return links;

            function addLinksBetweenPhases() {
                for (var i = 0; i < release.phases.length - 1; i++) {
                    addLink(release.phases[i].id, release.phases[i + 1].id, true);
                }
            }

            function addLinksBetweenTasks() {
                _.forEach(release.phases, function (phase) {
                    for (var i = 0; i < phase.tasks.length - 1; i++) {
                        addLink(phase.tasks[i].id, phase.tasks[i + 1].id, true);
                    }
                });
            }

            function addLinksWithinTaskGroups() {
                _.forEach(release.phases, function (phase) {
                    _.forEach(phase.tasks, addLinkWithinTaskGroup);
                });
            }

            function addLinkWithinTaskGroup(task) {
                if (TasksService.isTaskGroup(task)) {
                    if (TasksService.isParallelGroup(task)) {
                        _.forEach(task.links, function (link) {
                            var readonly = !!task.hasBeenStarted || task.locked;
                            addLink(link.sourceId, link.targetId, readonly, link.id);
                        });
                    } else {
                        for (var i = 0; i < task.tasks.length - 1; i++) {
                            addLink(task.tasks[i].id, task.tasks[i + 1].id, true);
                        }
                    }
                    _.forEach(task.tasks, addLinkWithinTaskGroup);
                }
            }

            function addLink(sourceId, targetId, readOnly, linkId) {
                links.push({
                    id: makeLinkId(sourceId, targetId),
                    source: sourceId,
                    target: targetId,
                    type: FROM_END_TO_START,
                    readOnly: readOnly,
                    linkId: linkId
                });
            }
        },
        makeLinkId: makeLinkId,
        setRelease: function setRelease(newRelease) {
            release = newRelease;
            if (!_.isEmpty(releaseTree) && releaseTree.releaseId !== release.id) {
                releaseTree = null;
            }
        },
        setReleaseTree: function setReleaseTree(newReleaseTree) {
            releaseTree = newReleaseTree;
        }
    };
}]);

/***/ }),
/* 1205 */,
/* 1206 */,
/* 1207 */,
/* 1208 */,
/* 1209 */,
/* 1210 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('PlanningDataEditor', ['TasksService', function (TasksService) {
    function isContainer(item) {
        return !TasksService.isTask(item) || TasksService.isTaskGroup(item);
    }

    function hasValue(duration) {
        return duration !== null && angular.isDefined(duration);
    }

    function hasPlannedDuration(planItem) {
        return hasValue(planItem.plannedDuration);
    }

    function positiveOrNull(plannedDuration) {
        return plannedDuration >= 0 ? plannedDuration : null;
    }

    return {
        /**
         * Dragging left edge affects start date and duration
         */
        dragLeft: function dragLeft(element, date) {
            if (hasPlannedDuration(element.planItem)) {
                if (element.planItem.dueDate) {
                    element.planItem.plannedDuration = moment(element.planItem.dueDate).diff(date, 'milliseconds');
                } else if (element.displayStartDate) {
                    element.planItem.plannedDuration += moment(element.displayStartDate).diff(date, 'milliseconds');
                }
            } else {
                if (!element.planItem.dueDate) {
                    element.planItem.plannedDuration = moment(element.displayEndDate).diff(date, 'milliseconds');
                }
            }
            element.planItem.scheduledStartDate = date;
        },

        /**
         * Dragging right edge affects duration (and due date as a consequence if it was set)
         */
        dragRight: function dragRight(element, date) {
            if (!isContainer(element.planItem)) {
                var plannedDuration = moment(date).diff(element.displayStartDate, 'milliseconds');
                if (element.planItem.dueDate) {
                    var previousDuration = moment(element.planItem.dueDate).diff(element.displayStartDate, 'milliseconds');
                    element.planItem.dueDate = moment(element.planItem.dueDate).subtract(previousDuration - plannedDuration, 'milliseconds').valueOf();
                }
                element.planItem.plannedDuration = plannedDuration;
            } else {
                if (hasPlannedDuration(element.planItem)) {
                    if (element.displayStartDate) {
                        element.planItem.plannedDuration = moment(date).diff(element.displayStartDate, 'milliseconds');
                    } else if (element.planItem.dueDate) {
                        element.planItem.plannedDuration += moment(date).diff(element.planItem.dueDate, 'milliseconds');
                    }
                }
                element.planItem.dueDate = date;
            }
        },

        /**
         * Dragging entire thing affects only scheduled start date, and update due if it was set
         */
        move: function move(element, startDate, endDate) {
            element.planItem.scheduledStartDate = startDate;
            if (element.planItem.dueDate) {
                element.planItem.dueDate = endDate;
            }
        },
        setStartDate: function setStartDate(element, date) {
            if (date && element.planItem.dueDate && hasPlannedDuration(element.planItem)) {
                var plannedDuration = moment(element.planItem.dueDate).diff(date, 'milliseconds');
                element.planItem.plannedDuration = positiveOrNull(plannedDuration);
            }
            element.planItem.scheduledStartDate = date;
        },
        setEndDate: function setEndDate(element, date) {
            var itemStartDate = element.planItem.startDate || element.planItem.scheduledStartDate;
            if (date && itemStartDate && hasPlannedDuration(element.planItem)) {
                var plannedDuration = moment(date).diff(itemStartDate, 'milliseconds');
                element.planItem.plannedDuration = positiveOrNull(plannedDuration);
            }
            element.planItem.dueDate = date;
        },
        setDuration: function setDuration(element, duration) {
            if (hasValue(duration) && element.planItem.dueDate) {
                var previousDuration = moment(element.planItem.dueDate).diff(element.displayStartDate, 'milliseconds');
                element.planItem.dueDate = moment(element.planItem.dueDate).subtract(previousDuration - duration, 'milliseconds').valueOf();
            }
            element.planItem.plannedDuration = duration;
        }
    };
}]);

/***/ }),
/* 1211 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * This service is used by all controllers that needs to change planning data (scheduled start date, due date and duration)
 *
 * It should be used as a mixin, to enhance the $scope
 * usage :
 *      angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(yourCallback));
 *
 *      - then all functions defined in this service are available in the $scope. eg. $scope.planning.updateDuration.
 *      - $scope.planning.initPlanningData MUST be called before calling other methods.
 *      - item can be either a task, a phase or a release.
 *      - the callback is called whenever planning rules have been applied.
 */
angular.module('xlrelease').factory('PlanningDataEditorMixin', ['PlanningDataEditor', 'Planner', 'DependenciesService', 'ReleasesService', function (PlanningDataEditor, Planner, DependenciesService, ReleasesService) {
    return {
        withSaveCallback: function withSaveCallback(saveCallback) {
            return new function () {
                var planning = {};
                this.planning = planning;

                function refreshPlanElement(id) {
                    planning.planElement = _.find(Planner.makePlan().elements, { id: id });
                }

                planning.initPlanningData = function (item, release) {
                    if (release && release.id) {
                        DependenciesService.getReleaseTree(release).then(function (releaseTree) {
                            Planner.setRelease(release);
                            Planner.setReleaseTree(releaseTree);
                            refreshPlanElement(item.id);
                        });
                    } else if (release) {
                        Planner.setRelease(release);
                        Planner.setReleaseTree(null);
                        refreshPlanElement(item.id);
                    }
                };

                planning.updateDuration = function (item) {
                    PlanningDataEditor.setDuration(planning.planElement, item.plannedDuration);
                    planning.savePlanningData(item);
                };

                planning.updateDueDate = function (item) {
                    PlanningDataEditor.setEndDate(planning.planElement, item.dueDate);
                    planning.savePlanningData(item);
                };

                planning.updateScheduledStartDate = function (item) {
                    PlanningDataEditor.setStartDate(planning.planElement, item.scheduledStartDate);
                    planning.savePlanningData(item);
                };

                planning.savePlanningData = function (item) {
                    item.plannedDuration = planning.planElement.planItem.plannedDuration;
                    item.scheduledStartDate = planning.planElement.planItem.scheduledStartDate;
                    item.dueDate = planning.planElement.planItem.dueDate;
                    refreshPlanElement(item.id);
                    saveCallback(item);
                };
            }();
        }
    };
}]);

/***/ }),
/* 1212 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReleaseGridController = function () {
    function ReleaseGridController($scope, $location, releasePromise, Page, ViewStorage, ReleasesService, Events) {
        (0, _classCallCheck3.default)(this, ReleaseGridController);

        this.ReleasesService = ReleasesService;
        this.Events = Events;
        this.$scope = $scope;

        this.release = $scope.release = releasePromise.data;

        ViewStorage.setView(this.release.id, $location.path());

        Page.setReleaseOpened(this.release);

        this._createScopeBindings();
    }

    (0, _createClass3.default)(ReleaseGridController, [{
        key: '_createScopeBindings',
        value: function _createScopeBindings() {
            var _this = this;

            this.$scope.startRelease = function (release) {
                return _this.ReleasesService.startRelease(release).then(function () {
                    return _this.refreshGrid();
                });
            };
            this.$scope.abortRelease = function (release) {
                return _this.ReleasesService.abortRelease(release).then(function () {
                    return _this.refreshGrid();
                });
            };
        }

        // view model

    }, {
        key: 'canAbortRelease',
        value: function canAbortRelease(release) {
            return !this.ReleasesService.isTemplate(release) && this.$scope.security.hasPermission('release#abort', release) && !this.ReleasesService.isReleaseCompleted(release) && !this.ReleasesService.hasAutomatedTaskInProgress(release);
        }
    }, {
        key: 'canStartRelease',
        value: function canStartRelease(release) {
            return this.ReleasesService.isReleasePlanned(release) && this.$scope.security.hasPermission('release#start', release);
        }
    }, {
        key: 'canRefreshGrid',
        value: function canRefreshGrid(release) {
            return !this.ReleasesService.isTemplate(release) && !this.ReleasesService.isReleaseCompleted(release);
        }
    }, {
        key: 'refreshGrid',
        value: function refreshGrid() {
            var _this2 = this;

            this.ReleasesService.getRelease(this.release.id).then(function (resp) {
                var updatedRelease = resp.data;
                _this2.release = _this2.$scope.release = updatedRelease;
                _this2.$scope.$broadcast(_this2.Events.grid.refresh, { release: updatedRelease });
            });
        }
    }]);
    return ReleaseGridController;
}();

ReleaseGridController.$inject = ['$scope', '$location', 'releasePromise', 'Page', 'ViewStorage', 'ReleasesService', 'Events'];

angular.module('xlrelease').controller('releaseGridController', ReleaseGridController);

/***/ }),
/* 1213 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var ReleaseGridEditController = function () {
        function ReleaseGridEditController($scope, TasksService, Authenticator, Events, TaskDetailsUpdates, PhaseDetailsUpdates, PhasesService, ReleasesService) {
            (0, _classCallCheck3.default)(this, ReleaseGridEditController);

            this._scope = $scope;
            this._events = Events;
            this._taskDetailsUpdates = TaskDetailsUpdates;
            this._phaseDetailsUpdates = PhaseDetailsUpdates;
            this._phasesService = PhasesService;
            this._releasesService = ReleasesService;
            this.bindEvents(Events);
            this.bindContext(TasksService, Authenticator);
        }

        (0, _createClass3.default)(ReleaseGridEditController, [{
            key: 'bindEvents',
            value: function bindEvents(events) {
                this._scope.$on(events.grid.edit, this.editItem.bind(this));
            }
        }, {
            key: 'bindContext',
            value: function bindContext(tasksService, authenticator) {
                var _this = this;

                var reloadRelease = function reloadRelease() {
                    return _this.loadRelease(true);
                };
                this._scope.security = authenticator;
                this._scope.deleteTask = function (container, taskToDelete) {
                    return tasksService.deleteTask(container, taskToDelete);
                };
                this._scope.changeType = function (container, taskToConvert, convertToType) {
                    return tasksService.changeTaskType(container, taskToConvert, convertToType);
                };
                this._scope.duplicateTask = function (release, container, task) {
                    return tasksService.duplicateTask(release, task, container);
                };
                this._scope.completeTask = function (task, commentText) {
                    return tasksService.completeTask(task.id, commentText).then(reloadRelease);
                };
                this._scope.skipTask = function (task, commentText) {
                    return tasksService.skipTask(task.id, commentText).then(reloadRelease);
                };
                this._scope.failTask = function (task, commentText) {
                    return tasksService.failTask(task.id, commentText).then(reloadRelease);
                };
                this._scope.abortTask = function (task, commentText) {
                    return tasksService.abortTask(task.id, commentText).then(reloadRelease);
                };
                this._scope.retryTask = function (task, commentText) {
                    return tasksService.retryTask(task.id, commentText).then(reloadRelease);
                };
                this._scope.cancelTask = function (task, commentText) {
                    return tasksService.cancelTask(task.id, commentText).then(reloadRelease);
                };
                this._scope.startNow = function (task, commentText) {
                    return tasksService.startNow(task.id, commentText).then(reloadRelease);
                };
                this._scope.startTaskWithInput = function (task, variables) {
                    return tasksService.startTaskWithInput(task.id, variables).then(reloadRelease);
                };
                this._scope.reopenTask = function (task, commentText) {
                    return tasksService.reopenTask(task.id, commentText).then(reloadRelease);
                };
            }

            //

        }, {
            key: 'endEditTask',
            value: function endEditTask(task) {
                this.editTask = false;
                if (this._taskDetailsUpdates.planningDataChanged || this._taskDetailsUpdates.assigneeChanged || this.previousTitle !== task.title) {
                    this.loadRelease();
                    this._taskDetailsUpdates.reset();
                }
            }
        }, {
            key: 'endEditPhase',
            value: function endEditPhase(phase) {
                this.editPhase = false;
                if (this._phaseDetailsUpdates.planningDataChanged || this.previousTitle !== phase.title) {
                    this.loadRelease();
                    this._phaseDetailsUpdates.reset();
                }
            }
        }, {
            key: 'loadRelease',
            value: function loadRelease() {
                var reload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

                this._scope.$emit(this._events.grid.refresh, { reload: reload });
            }
        }, {
            key: 'editItem',
            value: function editItem(event, args) {
                if (!args.planItem) {
                    return;
                }

                this._scope.release = args.release;
                this.previousTitle = args.planItem.title;
                if (this._phasesService.isPhase(args.planItem)) {
                    this._scope.phase = args.planItem;
                    this.editPhase = true;
                } else if (!this._releasesService.isRelease(args.planItem) && !this._releasesService.isTemplate(args.planItem)) {
                    this._scope.task = args.planItem;
                    this.editTask = true;
                }
            }
        }]);
        return ReleaseGridEditController;
    }();

    ReleaseGridEditController.$inject = ['$scope', 'TasksService', 'Authenticator', 'Events', 'TaskDetailsUpdates', 'PhaseDetailsUpdates', 'PhasesService', 'ReleasesService'];
    angular.module('xlrelease').controller('releaseGridEditController', ReleaseGridEditController);
})();

/***/ }),
/* 1214 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var GridItem = function () {
        function GridItem(planItem, treeLevel, container) {
            (0, _classCallCheck3.default)(this, GridItem);

            this.container = container;
            this.planItem = planItem;
            this.id = planItem.id;
            this.$$treeLevel = treeLevel;

            this.status = planItem.status;
            this.title = planItem.title;
            this.type = planItem.type;
            this.typeDisplayName = GridItem.getTypeDisplayName(planItem);
            this.assignedTo = GridItem.getAssignedTo(planItem);
            this.duration = this.startDate = this.endDate = null;
            this.editable = planItem.editable;
            this.tags = planItem.tags;
        }

        (0, _createClass3.default)(GridItem, null, [{
            key: 'getAssignedTo',
            value: function getAssignedTo(planItem) {
                if (planItem.owner) {
                    return planItem.owner.fullName || planItem.owner.username;
                } else if (planItem.team) {
                    return planItem.team;
                }
                return null;
            }
        }, {
            key: 'getTypeDisplayName',
            value: function getTypeDisplayName(planItem) {
                if (planItem.type === 'xlrelease.Release' || planItem.type === 'xlrelease.ScmConnectedTemplate') {
                    return 'Release';
                } else if (planItem.type === 'xlrelease.Phase') {
                    return 'Phase';
                } else if (planItem.typeDisplayGroup === 'Core') {
                    return planItem.typeDisplayName;
                }

                return planItem.typeDisplayGroup + ': ' + planItem.typeDisplayName;
            }
        }]);
        return GridItem;
    }();

    var ReleaseGridService = function () {
        function ReleaseGridService(planner, variablesInterpolator) {
            (0, _classCallCheck3.default)(this, ReleaseGridService);

            this.planner = planner;
            this.variablesInterpolator = variablesInterpolator;
        }

        (0, _createClass3.default)(ReleaseGridService, [{
            key: 'getGridItems',
            value: function getGridItems(release, releaseTree) {
                var gridItems = this._toGridItems(0, release);
                this._calculateDates(release, releaseTree, gridItems);
                this._interpolateVariables(release, gridItems);
                return gridItems;
            }
        }, {
            key: '_toGridItems',
            value: function _toGridItems(level, planItem, container) {
                var _this = this;

                var children = planItem.phases ? planItem.phases : planItem.tasks ? planItem.tasks : [];
                return _.flatten([new GridItem(planItem, level, container)].concat(_.map(children, function (child) {
                    return _this._toGridItems(level + 1, child, planItem);
                })));
            }
        }, {
            key: '_interpolateVariables',
            value: function _interpolateVariables(release, gridItems) {
                var _this2 = this;

                gridItems.forEach(function (item) {
                    if (_.isString(item.assignedTo)) {
                        item.assignedTo = _this2.variablesInterpolator.interpolateInText(release.variables, item.assignedTo);
                    }
                });
            }
        }, {
            key: '_calculateDates',
            value: function _calculateDates(release, releaseTree, gridItems) {
                this.planner.setRelease(release);
                this.planner.setReleaseTree(releaseTree);
                var plan = this.planner.makePlan(false);
                gridItems.forEach(function (item) {
                    var itemPlan = _.find(plan.elements, { 'id': item.id });
                    if (!_.isUndefined(itemPlan)) {
                        item.startDate = itemPlan.displayStartDate.toDate();
                        item.endDate = itemPlan.displayEndDate.toDate();
                        item.duration = itemPlan.displayDuration;
                    }
                });
            }
        }]);
        return ReleaseGridService;
    }();

    ReleaseGridService.$inject = ['Planner', 'VariablesInterpolator'];

    angular.module('xlrelease').service('ReleaseGridService', ReleaseGridService);
})();

/***/ }),
/* 1215 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _promise = __webpack_require__(109);

var _promise2 = _interopRequireDefault(_promise);

var _from = __webpack_require__(308);

var _from2 = _interopRequireDefault(_from);

var _riskDetector = __webpack_require__(266);

var riskDetector = _interopRequireWildcard(_riskDetector);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').factory('ReleasesService', ['Backend', 'ReleasesStatusService', 'DependenciesService', 'TasksService', 'PhasesService', 'DateService', '$q', 'Download', '$location', 'UserProfile', 'FlagService', 'VariablesService', 'CiLoaderSettings', 'Ids', function (Backend, ReleasesStatusService, DependenciesService, TasksService, PhasesService, DateService, $q, Download, $location, UserProfile, FlagService, VariablesService, CiLoaderSettings, Ids) {
    var DEFAULT_START_HOUR = 9;
    var DEFAULT_DUE_HOUR = 17;

    function mapSelectedReleasesToDomainId(selectedReleases) {
        return (0, _from2.default)(selectedReleases).map(function (item) {
            return Ids.toDomainId(item);
        });
    }

    function getLeafTasks(release) {
        return _.flattenDeep(_.map(release.phases, PhasesService.getLeafTasks));
    }

    function getAllTasks(release) {
        return _.flattenDeep(_.map(release.phases, function (phase) {
            return _.map(phase.tasks, TasksService.getAllSubTasks);
        }));
    }

    function downloadRelease(release, format) {
        Download.launch('export/' + format + '/' + release.id);
    }

    function hasAutomatedTaskInProgress(release) {
        return _.some(release.currentSimpleTasks, function (task) {
            return TasksService.isTaskInProgress(task) && TasksService.isAutomated(task);
        });
    }

    function computeGroupedReleases(releases, filters) {
        var releasesByMonth = _.groupBy(releases, function (release) {
            var dateFormatter = 'MMMM YYYY';
            if (filters.completed) {
                return moment(release.endDate).format(dateFormatter);
            } else {
                return formatReleaseStartDate(release, dateFormatter);
            }
        });

        return _.map(_.keys(releasesByMonth), function (month) {
            return {
                month: month,
                releases: releasesByMonth[month]
            };
        });
    }

    function formatReleaseStartDate(release, dateFormatter) {
        if (release.startDate) {
            return moment(release.startDate).format(dateFormatter);
        } else if (release.scheduledStartDate) {
            return moment(release.scheduledStartDate).format(dateFormatter);
        }
    }

    function search(filters, config) {
        return Backend.post('releases/search', filters, config);
    }

    function searchFull(filters, config) {
        return search(filters, _.merge({ params: { depth: CiLoaderSettings.itemsMaxDepth } }, config));
    }

    var getRelease = function getRelease(releaseId, config) {
        return Backend.get('releases/' + releaseId, config);
    };

    var getTemplateDuration = function getTemplateDuration(templateId) {
        return Backend.get('releases/templates/' + templateId + '/duration');
    };

    return {
        getLeafTasks: getLeafTasks,
        getAllTasks: getAllTasks,
        isReleaseCompleted: ReleasesStatusService.isReleaseCompleted,
        hasCompletedStatus: ReleasesStatusService.hasCompletedStatus,
        isReleaseAborted: ReleasesStatusService.isReleaseAborted,
        isReleasePlanned: ReleasesStatusService.isReleasePlanned,
        isReleaseInProgress: ReleasesStatusService.isReleaseInProgress,
        isReleaseFailed: ReleasesStatusService.isReleaseFailed,
        isReleaseFailing: ReleasesStatusService.isReleaseFailing,
        isReleasePaused: ReleasesStatusService.isReleasePaused,
        isReleaseArchived: ReleasesStatusService.isReleaseArchived,
        isReleaseInsideFolder: function isReleaseInsideFolder(release) {
            return release.id.indexOf('Folder') !== -1;
        },
        computeGroupedReleases: computeGroupedReleases,
        startRelease: function startRelease(release) {
            return Backend.post('releases/' + release.id + '/start');
        },
        abortRelease: function abortRelease(release) {
            return Backend.post('releases/' + release.id + '/abort');
        },
        downloadCalendar: function downloadCalendar(release) {
            downloadRelease(release, 'calendar');
        },
        downloadExcel: function downloadExcel(release) {
            downloadRelease(release, 'excel');
        },
        exportZip: function exportZip(release) {
            downloadRelease(release, 'zip');
        },
        exportDsl: function exportDsl(release) {
            Download.launch('api/v1/dsl/export/' + Ids.toDomainId(release.id) + '?exportTemplate=true');
        },

        getReleasePermissions: function getReleasePermissions(releaseId) {
            return Backend.get('releases/' + releaseId + '/permissions');
        },
        getReleaseDependencies: function getReleaseDependencies(releaseId, params) {
            return Backend.get('dependencies/' + releaseId, { params: params });
        },
        getRelease: getRelease,
        getTemplateDuration: getTemplateDuration,
        getTemplateWithDuration: function getTemplateWithDuration(templateId) {
            return getRelease(templateId).then(function (releaseResponse) {
                return getTemplateDuration(templateId).then(function (durationResponse) {
                    releaseResponse.data.computed_duration = durationResponse.data;
                    return releaseResponse;
                });
            });
        },
        getReleaseWithDependencies: function getReleaseWithDependencies(releaseId, config) {

            return Backend.get('releases/' + releaseId, config).then(function (response) {
                var tree = DependenciesService.getReleaseTree(response.data);
                var release = _promise2.default.resolve(response);
                return _promise2.default.all([tree, release]);
            }).then(function (values) {
                var _values = (0, _slicedToArray3.default)(values, 2),
                    tree = _values[0],
                    release = _values[1];

                release.tree = tree;
                return release;
            });
        },

        search: search,
        searchFull: searchFull,
        searchArchived: function searchArchived(filters, config) {
            return searchFull(_.merge(filters, { onlyArchived: true }), config);
        },
        cropToReleaseDate: function cropToReleaseDate(phase, release) {
            var phaseStartDate = DateService.getStartOrScheduledDate(phase);
            var releaseStartDate = DateService.getStartOrScheduledDate(release);
            var phaseEndDate = DateService.getEndOrDueDate(phase);
            var releaseEndDate = DateService.getEndOrDueDate(release);
            return {
                startDate: moment(phaseStartDate).isBefore(moment(releaseStartDate)) ? moment(releaseStartDate) : moment(phaseStartDate),
                endDate: moment(phaseEndDate).isAfter(moment(releaseEndDate)) ? moment(releaseEndDate) : moment(phaseEndDate)
            };
        },
        countPhasesDone: function countPhasesDone(release) {
            return release ? _.filter(release.phases, PhasesService.isPhaseReadOnly).length : undefined;
        },
        hasAttachments: function hasAttachments(release) {
            if (release.attachments && release.attachments.length > 0) {
                return true;
            }

            return _(getAllTasks(release)).map('attachments').flatten().value().length > 0;
        },
        redirectToSummary: function redirectToSummary(release) {
            $location.url('/releases/' + release.id + '/summary');
        },
        redirectToOverview: function redirectToOverview(filters) {
            $location.url('/releases');
            $location.search(filters);
        },
        redirectToEditor: function redirectToEditor(release) {
            $location.url('/releases/' + release.id);
        },
        isRelease: function isRelease(planItem) {
            return planItem.type === 'xlrelease.Release';
        },
        isTemplate: function isTemplate(release) {
            return ReleasesStatusService.isTemplate(release);
        },

        hasAutomatedTaskInProgress: hasAutomatedTaskInProgress,
        isNewRelease: function isNewRelease(release) {
            return !release.id;
        },
        initNewTemplate: function initNewTemplate() {
            return {
                title: '',
                status: 'TEMPLATE',
                tags: [],
                scheduledStartDate: DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),
                dueDate: null,
                plannedDuration: null,
                type: 'xlrelease.Release',
                allowConcurrentReleasesFromTrigger: true
            };
        },
        initNewReleaseFromTemplate: function initNewReleaseFromTemplate(templateId) {
            var _this = this;

            return this.getTemplateWithDuration(templateId).then(function (templateResponse) {
                return VariablesService.getReleaseVariables(templateId).then(function (variablesResponse) {
                    var newRelease = _this.initNewRelease();
                    var template = templateResponse.data;
                    var variables = variablesResponse.data;
                    var now = moment();
                    var due = moment(now).add(template.computed_duration / 60, 'minutes');
                    newRelease.templateId = template.id;
                    _.assign(newRelease, {
                        scheduledStartDate: now,
                        dueDate: due,
                        description: template.description,
                        tags: template.tags,
                        abortOnFailure: template.abortOnFailure,
                        scriptUsername: template.scriptUsername,
                        scriptUserPassword: template.scriptUserPassword,
                        syntheticProperties: {
                            riskProfile: template.syntheticProperties.riskProfile
                        },
                        variables: variables
                    });
                    return newRelease;
                });
            });
        },

        initNewRelease: function initNewRelease() {
            return {
                title: '',
                owner: UserProfile.getCurrentUser(),
                scriptUsername: null,
                scriptUserPassword: null,
                scheduledStartDate: DateService.getToday().hours(DEFAULT_START_HOUR).toDate(),
                dueDate: DateService.getToday().hours(DEFAULT_DUE_HOUR).toDate(),
                plannedDuration: null,
                tags: [],
                variables: [],
                type: 'xlrelease.Release',
                flag: {
                    status: FlagService.NOT_FLAGGED_STATUS
                },
                syntheticProperties: {}
            };
        },
        getReleaseWithVariables: function getReleaseWithVariables(releaseId) {
            return this.getRelease(releaseId).then(function (releaseResponse) {
                var release = releaseResponse.data;
                return VariablesService.getReleaseVariables(releaseId).then(function (variablesResponse) {
                    release.variables = variablesResponse.data;
                    return release;
                });
            });
        },
        startReleases: function startReleases(selectedReleases) {
            return Backend.post('releases/start', mapSelectedReleasesToDomainId(selectedReleases));
        },
        abortReleases: function abortReleases(selectedReleases) {
            return Backend.post('releases/abort', mapSelectedReleasesToDomainId(selectedReleases));
        },
        getRiskStatusIcon: function getRiskStatusIcon(release, riskScore, riskConfig) {
            return {
                'xl-icon circle-cross-icon icon-xl': riskDetector.isAtRisk(release, riskScore, riskConfig),
                'xl-icon circle-exclamation-icon icon-xl': riskDetector.isAttentionNeeded(release, riskScore, riskConfig),
                'xl-icon circle-check-icon icon-xl': riskDetector.isOnTrack(release, riskScore, riskConfig) || this.hasCompletedStatus(release) || this.isReleaseAborted(release)
            };
        }
    };
}]);

/***/ }),
/* 1216 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {

    var injectParams = ['$stateParams', '$uibModal', 'ReleasesService', 'TeamsService', 'MemberType', 'Page', 'displayPermissionFilter', 'release', 'teams', 'users', 'roles', 'Ids', 'permissionTableUtils', 'FolderPathService'];

    var ReleasePermissionsController = function () {
        function ReleasePermissionsController($stateParams, $uibModal, ReleasesService, TeamsService, MemberType, Page, displayPermissionFilter, release, teams, users, roles, Ids, permissionTableUtils, FolderPathService) {
            var _this = this;

            (0, _classCallCheck3.default)(this, ReleasePermissionsController);

            this._$stateParams = $stateParams;
            this._$uibModal = $uibModal;
            this._ReleasesService = ReleasesService;
            this._TeamsService = TeamsService;
            this._MemberType = MemberType;
            this._Page = Page;
            this._displayPermissionFilter = displayPermissionFilter;
            this._release = release;
            this._loadedTeams = teams;
            this._users = users;
            this._roles = roles;
            this._Ids = Ids;
            this._permissionTableUtils = permissionTableUtils;
            this._FolderPathService = FolderPathService;

            this._readOnly = ReleasesService.isReleaseCompleted(release) || ReleasesService.isReleaseInsideFolder(release);
            this._permissionsCollapsed = 0;
            this._teamsCollapsed = 0;

            this._mapTeamToContainer = function (team) {
                return {
                    name: team.teamName,
                    type: _this._MemberType.TEAM
                };
            };

            this._mapPermissionToContainer = function (permission) {
                return {
                    action: _this._displayPermissionFilter(permission).label,
                    value: permission,
                    description: _this._displayPermissionFilter(permission).description,
                    teams: _this._teams.filter(function (team) {
                        return team.permissions.includes(permission);
                    }).map(_this._mapTeamToContainer)
                };
            };

            this._Page.setReleaseOpened(release);
            this._loadData();
        }

        (0, _createClass3.default)(ReleasePermissionsController, [{
            key: '_loadData',
            value: function _loadData() {
                var _this2 = this;

                this._teams = this._loadedTeams.map(function (team) {
                    var validTeam = (0, _extends3.default)({}, team);
                    validTeam.valid = true;
                    return validTeam;
                });

                this._ReleasesService.getReleasePermissions(this._$stateParams.releaseId).then(function (response) {
                    _this2._initPermissionsTableData(response.data);
                    _this2._initTeamsTableData();
                });

                this._inherited = this.isInherited();
                this._dirty = false;
            }
        }, {
            key: '_initTeamsTableData',
            value: function _initTeamsTableData() {
                var _context;

                this._teamsTableColumns = [{
                    title: 'Team name',
                    key: 'teamName'
                }, {
                    title: 'Global roles',
                    key: 'globalRoles',
                    suggestionData: this._roles,
                    type: this._MemberType.ROLE
                }, {
                    title: 'Users',
                    key: 'users',
                    suggestionData: this._users,
                    type: this._MemberType.PRINCIPAL
                }];
                this._teamsPermissionsContainer = this._teams.map((_context = this._permissionTableUtils).teamPermissionsToContainer.bind(_context));
            }
        }, {
            key: '_initPermissionsTableData',
            value: function _initPermissionsTableData(releasePermissionsView) {
                this._permissions = releasePermissionsView.permissions;
                this._permissionsTableColumns = [{
                    title: 'Action',
                    key: 'action'
                }, {
                    title: 'Teams',
                    key: 'teams',
                    suggestionData: this._teams.map(this._mapTeamToContainer),
                    type: this._MemberType.TEAM
                }];
                this._permissionsContainer = this._permissions.map(this._mapPermissionToContainer.bind(this)).sort(function (a, b) {
                    return a.action.localeCompare(b.action);
                });
            }
        }, {
            key: 'save',
            value: function save() {
                var _this3 = this;

                var teams = this._teams.map(function (t) {
                    return _this3._mapTeamToTeamWithPermissions(t);
                });
                this._TeamsService.updateTeams(this._$stateParams.releaseId, teams).then(function () {
                    _this3._lastSavedDate = moment().toDate();
                    _this3._dirty = false;
                });
            }
        }, {
            key: 'reset',
            value: function reset() {
                this._loadData();
                this._lastSavedDate = null;
                this._dirty = false;
            }
        }, {
            key: 'isInherited',
            value: function isInherited() {
                var _this4 = this;

                if (this._teams.length === 0) return false;
                var team = this._teams[0];
                var parentId = this._Ids.getParentIdGeneral(team.id, '-');
                var isInherited = parentId !== this._release.id;
                if (isInherited) {
                    this._FolderPathService.getPathFromRelativeFolderId(parentId).then(function (paths) {
                        _this4._inheritedFrom = _.last(paths);
                    });
                }
                return isInherited;
            }
        }, {
            key: 'setDirty',
            value: function setDirty() {
                this._dirty = true;
            }
        }, {
            key: 'openAddTeamModal',
            value: function openAddTeamModal() {
                var _this5 = this;

                var modal = this._$uibModal.open({
                    animation: false,
                    component: 'addTeamModal'
                });

                modal.result.then(function (teamName) {
                    if (teamName) {
                        var newTeam = {
                            teamName: teamName,
                            members: [],
                            permissions: []
                        };
                        _this5._teams.push(newTeam);
                        _this5._teamsPermissionsContainer.push(_this5._permissionTableUtils.teamPermissionsToContainer(newTeam));
                        _this5.updateTeamsSuggestions();
                        _this5.setDirty();
                    }
                });
            }
        }, {
            key: 'updateTeamsSuggestions',
            value: function updateTeamsSuggestions() {
                this._permissionsTableColumns[1].suggestionData = this._teams.map(this._mapTeamToContainer);
            }
        }, {
            key: 'onRemoveTeam',
            value: function onRemoveTeam(team) {
                var _this6 = this;

                var modal = this._$uibModal.open({
                    animation: false,
                    component: 'deleteTeamModal',
                    resolve: {
                        teamName: function teamName() {
                            return team.teamName;
                        }
                    }
                });

                modal.result.then(function (pressedDelete) {
                    if (pressedDelete) {
                        _.remove(_this6._teams, function (t) {
                            return t.teamName === team.teamName;
                        });
                        _this6._permissionsContainer.map(function (permission) {
                            return _.remove(permission.teams, function (t) {
                                return t.name === team.teamName;
                            });
                        });
                        _.remove(_this6._teamsPermissionsContainer, function (tpc) {
                            return tpc.teamName === team.teamName;
                        });
                        _this6.updateTeamsSuggestions();
                        _this6.setDirty();
                    }
                });
            }
        }, {
            key: 'validate',
            value: function validate(newName, team) {
                return !this._nameAlreadyUsed(newName, team);
            }
        }, {
            key: 'isReleaseCompleted',
            value: function isReleaseCompleted() {
                return this._ReleasesService.isReleaseCompleted(this._release);
            }
        }, {
            key: 'isTemplate',
            value: function isTemplate() {
                return this._ReleasesService.isTemplate(this._release);
            }
        }, {
            key: '_nameAlreadyUsed',
            value: function _nameAlreadyUsed(teamName, teamToIgnore) {
                return _.some(this._teams, function (team) {
                    return team.teamName === teamName && team !== teamToIgnore;
                });
            }
        }, {
            key: '_mapTeamToTeamWithPermissions',
            value: function _mapTeamToTeamWithPermissions(team) {
                team.permissions = this._permissionsContainer.filter(function (p) {
                    return _.find(p.teams, { 'name': team.teamName });
                }).map(function (permission) {
                    return permission.value;
                });

                team.members = _.chain(this._teamsPermissionsContainer).filter(function (c) {
                    return c.teamName === team.teamName;
                }).flatMap(function (c) {
                    return [].concat((0, _toConsumableArray3.default)(c.globalRoles), (0, _toConsumableArray3.default)(c.users));
                }).value();

                return _.omit(team, 'valid');
            }
        }, {
            key: 'release',
            get: function get() {
                return this._release;
            }
        }, {
            key: 'permissions',
            get: function get() {
                return this._permissions;
            }
        }, {
            key: 'lastSavedDate',
            get: function get() {
                return this._lastSavedDate;
            }
        }, {
            key: 'dirty',
            get: function get() {
                return this._dirty;
            }
        }, {
            key: 'teams',
            get: function get() {
                return this._teams;
            }
        }, {
            key: 'users',
            get: function get() {
                return this._users;
            }
        }, {
            key: 'roleNames',
            get: function get() {
                return this._roleNames;
            }
        }, {
            key: 'permissionsTableColumns',
            get: function get() {
                return this._permissionsTableColumns;
            }
        }, {
            key: 'permissionsContainers',
            get: function get() {
                return this._permissionsContainer;
            }
        }, {
            key: 'teamsTableColumns',
            get: function get() {
                return this._teamsTableColumns;
            }
        }, {
            key: 'teamsPermissionsContainer',
            get: function get() {
                return this._teamsPermissionsContainer;
            }
        }, {
            key: 'readOnly',
            get: function get() {
                return this._readOnly;
            }
        }, {
            key: 'permissionsCollapsed',
            get: function get() {
                return this._permissionsCollapsed;
            },
            set: function set(permissionsCollapsed) {
                this._permissionsCollapsed = permissionsCollapsed;
            }
        }, {
            key: 'teamsCollapsed',
            get: function get() {
                return this._teamsCollapsed;
            },
            set: function set(teamsCollapsed) {
                this._teamsCollapsed = teamsCollapsed;
            }
        }, {
            key: 'inherited',
            get: function get() {
                return this._inherited;
            }
        }, {
            key: 'inheritedFrom',
            get: function get() {
                return this._inheritedFrom;
            }
        }]);
        return ReleasePermissionsController;
    }();

    ReleasePermissionsController.$inject = injectParams;

    angular.module('xlrelease').controller('releasePermissionsController', ReleasePermissionsController);
})();

/***/ }),
/* 1217 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _defineProperty2 = __webpack_require__(18);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends3 = __webpack_require__(5);

var _extends4 = _interopRequireDefault(_extends3);

var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').controller('phaseDetailsController', ['$scope', 'Backend', 'PhasesService', 'PhaseDetailsUpdates', 'PlanningDataEditorMixin', 'VariablesService', function ($scope, Backend, PhasesService, PhaseDetailsUpdates, PlanningDataEditorMixin, VariablesService) {
    $scope.$watch('phase.scheduledStartDate + phase.dueDate', validatePhaseDates);
    $scope.$watch('phase.title', loadVariablesOnPhaseSaved);

    angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(function (phase) {
        $scope.updatePhase(phase);
        PhaseDetailsUpdates.planningDataChanged = true;
    }));

    $scope.planning.initPlanningData($scope.phase, $scope.release);

    function validatePhaseDates() {
        if (!$scope.phase) return;
        $scope.warning = {
            displayScheduledStartDateBefore: $scope.phase.scheduledStartDate !== null && $scope.release.scheduledStartDate !== null && moment($scope.phase.scheduledStartDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
            displayScheduledStartDateAfter: $scope.phase.scheduledStartDate !== null && $scope.release.dueDate !== null && moment($scope.phase.scheduledStartDate).isAfter(moment($scope.release.dueDate), 'minutes'),
            displayDueDateBefore: $scope.phase.dueDate !== null && $scope.release.scheduledStartDate !== null && moment($scope.phase.dueDate).isBefore(moment($scope.release.scheduledStartDate), 'minutes'),
            displayDueDateAfter: $scope.phase.dueDate !== null && $scope.release.dueDate !== null && moment($scope.phase.dueDate).isAfter(moment($scope.release.dueDate), 'minutes')
        };
        loadVariables();
    }

    function loadVariablesOnPhaseSaved() {
        var VARIABLE_MATCHER = /(\$\{[^}]+\})/g;
        var variables = _.uniq($scope.phase.title.match(VARIABLE_MATCHER));
        variables.filter(function (var1) {
            return !($scope.allVariables ? $scope.allVariables.some(function (var2) {
                return var1 === var2.key;
            }) : true);
        }).forEach(function (newVar) {
            return $scope.allVariablesWithReleaseVars.push({
                'displayName': newVar,
                'id': '',
                'key': newVar.replace('${', '').replace('}', ''),
                'requiresValue': false,
                'showOnReleaseStart': false,
                'type': "xlrelease.StringVariable",
                'variableName': newVar
            });
        });
    }

    function loadAllVariablesWithSpecialRelVars(allVariables, release) {
        if (release.variables) {
            var specialVariables = (0, _keys2.default)(release.variables).filter(function (key) {
                return key.includes('release.');
            }).reduce(function (obj, key) {
                return (0, _extends4.default)({}, obj, (0, _defineProperty3.default)({}, key, release.variables[key]));
            }, {});
            (0, _keys2.default)(specialVariables).forEach(function (key) {
                var obj = {
                    'displayName': key,
                    'id': '',
                    'key': key.replace('${', '').replace('}', ''),
                    'requiresValue': false,
                    'showOnReleaseStart': false,
                    'type': "xlrelease.StringVariable",
                    'value': specialVariables[key],
                    'variableName': key
                };
                allVariables.push(obj);
            });
        }

        return allVariables;
    }

    function loadVariables() {
        VariablesService.getAllVariables($scope.release.id).then(function (allVariables) {
            $scope.allVariables = allVariables;
            $scope.allVariablesWithReleaseVars = loadAllVariablesWithSpecialRelVars(allVariables, $scope.release);
        });
    }

    $scope.isEditable = function () {
        return !$scope.isPhaseReadOnly($scope.phase) && $scope.security.hasEditPermission($scope.release);
    };

    $scope.updatePhase = PhasesService.updatePhase;
    $scope.isPhaseInProgress = PhasesService.isPhaseInProgress;
    $scope.isPhaseReadOnly = PhasesService.isPhaseReadOnly;
    $scope.isPhasePlanned = PhasesService.isPhasePlanned;
}]);

/***/ }),
/* 1218 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('PhaseDetailsUpdates', [function () {
    return {
        planningDataChanged: false,
        reset: function reset() {
            this.planningDataChanged = false;
        }
    };
}]);

/***/ }),
/* 1219 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('releaseFlowHeader', function () {
    return {
        templateUrl: 'partials/releases/release-flow-header.html',
        replace: true,
        transclude: true
    };
});

/***/ }),
/* 1220 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var ReleaseSubpages = function () {
        function ReleaseSubpages(ViewStorage) {
            (0, _classCallCheck3.default)(this, ReleaseSubpages);

            this.ViewStorage = ViewStorage;
        }

        (0, _createClass3.default)(ReleaseSubpages, [{
            key: 'getSubpages',
            value: function getSubpages(releaseId) {
                return {
                    editor: { path: this._getEditorPath(releaseId), label: 'Release flow', weight: 20 },
                    grid: { path: '/table', label: 'Release flow', weight: 25, hidden: true },
                    gantt: { path: '/planner', label: 'Release flow', weight: 30, hidden: true },
                    releaseXfile: { path: '/releasefile', label: 'Release flow', weight: 40, hidden: true },
                    properties: { path: '/properties', label: 'Properties', weight: 45 },
                    variables: { path: '/variables', label: 'Variables', weight: 50 },
                    triggers: {
                        path: '/triggers', label: 'Triggers', weight: 60,
                        displayIf: "release.status == 'TEMPLATE' && security.hasPermission('template#edit_triggers', release)"
                    },
                    permissions: {
                        path: '/permissions', label: 'Teams & Permissions', weight: 70,
                        displayIf: 'security.hasEditSecurityPermission(release)', class: 'release-permissions'
                    }
                };
            }
        }, {
            key: '_getEditorPath',
            value: function _getEditorPath(releaseId) {
                var editorPath = '/';
                if (this.ViewStorage.getView(releaseId)) {
                    var storedView = this.ViewStorage.getView(releaseId);
                    editorPath += storedView.substr(storedView.lastIndexOf(releaseId) + releaseId.length + 1);
                }
                return editorPath === '/' ? '' : editorPath; // UI router doesn't like trailing slashes
            }
        }]);
        return ReleaseSubpages;
    }();

    ReleaseSubpages.$inject = ['ViewStorage'];

    angular.module('xlrelease').service('ReleaseSubpages', ReleaseSubpages);

    // Allows the release header to be customized according to the current location
    var injectParams = ['$scope', '$location', 'ReleaseSubpages', '$parse', '$stateParams', 'Authenticator', 'ReleasesService', 'UiExtensionsService', '$ngRedux'];
    var ReleaseHeaderController = function ReleaseHeaderController($scope, $location, ReleaseSubpages, $parse, $stateParams, Authenticator, ReleasesService, UiExtensionsService, $ngRedux) {

        init();

        // TODO: refactor. onDestroy...
        $scope.unsubscribe = $ngRedux.connect(mapStateToThis)($scope);

        function mapStateToThis(state) {
            var releaseGrid = state.releaseGrid;
            return {
                selectedCount: releaseGrid.selectedItems.length
            };
        }

        function init() {
            $scope.releaseId = $stateParams.releaseId;
            $scope.security = Authenticator;
            $scope.releaseTemplateVariable = _.includes($location.path(), '/templates/') ? 'templates' : 'releases';

            if ($scope.releasePageExtensionCtrl) {
                $scope.release = $scope.releasePageExtensionCtrl.release;
            }

            if ($scope.release) {
                generateReleaseSubpages($scope.release);
            } else if ($scope.releaseId) {
                ReleasesService.getRelease($scope.releaseId).then(function (response) {
                    generateReleaseSubpages(response.data);
                });
            }
        }

        function generateReleaseSubpages(release) {
            $scope.release = release;

            $scope.releaseSubpages = ReleaseSubpages.getSubpages($scope.releaseId); // to avoid errors while extended subpages are being fetched
            extendReleaseSubpages($scope.release).then(function (extendedSubpages) {
                $scope.releaseSubpages = extendedSubpages;

                var notDefaultPages = _.omit($scope.releaseSubpages, 'editor');

                $scope.page = _.find(notDefaultPages, function (aPage) {
                    var regexp = new RegExp(aPage.path, 'i');
                    return $location.path().match(regexp); // if current location ends with one of the subpages
                });
                $scope.page = $scope.page || $scope.releaseSubpages.editor;
            });

            $scope.isSubpageDisplayed = isSubpageDisplayed;
            $scope.showNewReleaseButton = showNewReleaseButton;
            //
            $scope.isActive = function (viewMode) {
                if ($scope.page && $scope.page.path !== null) {
                    return $scope.page.path === viewMode;
                } else {
                    return false;
                }
            };
        }

        function isSubpageDisplayed(subpage) {
            if (_.isString(subpage.displayIf)) {
                var displayFunction = $parse(subpage.displayIf);
                return displayFunction($scope);
            }
            return !subpage.hidden;
        }

        function showNewReleaseButton() {
            var isProperPage = angular.isDefined($scope.release) && $scope.release.status === 'TEMPLATE' && ($scope.releaseSubpages.editor === $scope.page || $scope.releaseSubpages.properties === $scope.page);
            var isAllowed = $scope.security.hasPermission('release#create') || $scope.security.hasPermission('template#create_release', $scope.release);
            return isProperPage && isAllowed;
        }

        function extendReleaseSubpages(release) {
            return UiExtensionsService.getReleaseMenuExtensions(release).then(function (extensions) {
                var extendedSubpages = _.clone(ReleaseSubpages.getSubpages(release.id), false);

                _.chain(extensions).filter(function (extension) {
                    return extension.permitted === true;
                }).filter(function (extension) {
                    if (extension.properties && extension.properties.showOnlyOnTemplate) {
                        return release.status === 'TEMPLATE';
                    }
                    return true;
                }).forEach(function (extension) {
                    extendedSubpages[extension.pathSuffix] = {
                        path: '/' + extension.pathSuffix,
                        label: extension.label,
                        weight: extension.weight
                    };
                }).value();

                extendedSubpages = _(extendedSubpages).toPairs().sortBy(function (keyValue) {
                    return keyValue[1].weight;
                }).fromPairs().value();
                return extendedSubpages;
            });
        }
    };
    ReleaseHeaderController.$inject = injectParams;

    angular.module('xlrelease').controller('releaseHeaderController', ReleaseHeaderController);
})();

/***/ }),
/* 1221 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('releaseHeader', function () {
    return {
        templateUrl: 'partials/releases/release-header.html',
        replace: true,
        transclude: true
    };
});

/***/ }),
/* 1222 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var injectParams = ['$location', '$stateParams', 'UiExtensionsService', 'Backend', 'Page', 'releasePromise'];

var ReleasePageExtensionController = function ReleasePageExtensionController($location, $stateParams, UiExtensionsService, Backend, Page, releasePromise) {
    var vm = this;
    vm.release = releasePromise.data;

    loadPageExtension();

    ///

    function redirectToDefaultPage() {
        // If the current URL is /releases/Release1, we redirect the user to 'releases'
        var defaultPage = $location.path().substring(1);
        defaultPage = defaultPage.substring(0, defaultPage.indexOf('/'));
        $location.url(defaultPage);
    }

    function loadPageExtension() {
        UiExtensionsService.getReleaseMenuExtensions(vm.release).then(function (extensions) {
            vm.pageExtension = _.find(extensions, { pathSuffix: $stateParams.extensionPath, permitted: true });

            if (vm.pageExtension) {

                if (vm.pageExtension.properties && vm.pageExtension.properties.showOnlyOnTemplate && vm.release.status !== 'TEMPLATE') {
                    redirectToDefaultPage();
                }

                Page.setReleaseOpened(vm.release);
            } else {
                redirectToDefaultPage();
            }
        });
    }
};

ReleasePageExtensionController.$inject = injectParams;

angular.module('xlrelease').controller('releasePageExtensionController', ReleasePageExtensionController);

/***/ }),
/* 1223 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('releaseVariablesController', ['$scope', 'Page', 'releasePromise', 'VariablesService', 'ReleasesService', 'Authenticator', 'Ids', function ($scope, Page, releasePromise, VariablesService, ReleasesService, Authenticator, Ids) {
    $scope.release = releasePromise.data;
    $scope.readonly = isReadonly($scope.release);
    $scope.pageType = $scope.release.status === 'TEMPLATE' ? 'TEMPLATE' : 'RELEASE';
    $scope.filters = {
        filter: ''
    };
    $scope.releaseVariable = true;
    $scope.updateReleaseVariable = updateReleaseVariable;
    $scope.createReleaseVariable = createReleaseVariable;
    $scope.deleteReleaseVariable = deleteReleaseVariable;
    $scope.reorderReleaseVariables = reorderReleaseVariables;
    $scope.newVariable = newVariable;
    $scope.showReleaseVariable = showReleaseVariable;
    $scope.isInFolder = Ids.isInFolder($scope.release.id);

    load();

    function load() {
        Page.setReleaseOpened($scope.release);
        loadAllVariables();
    }

    function isReadonly(release) {
        return ReleasesService.isReleaseCompleted(release) || !Authenticator.hasEditPermission(release);
    }

    function loadAllVariables() {
        VariablesService.getAllVariables($scope.release.id).then(function (allVariables) {
            $scope.allVariables = allVariables;
            $scope.folderVariables = _.sortBy(allVariables.filter(function (variable) {
                return VariablesService.isFolderVariable(variable.key);
            }), ['key']);
            var variables = [];
            angular.copy(allVariables, variables);
            $scope.variables = _.map(_.reject(variables, function (v) {
                return VariablesService.isFolderOrGlobalVariable(v.key);
            }), function (v) {
                delete v.displayName;
                delete v.variableName;
                return v;
            });
        });
    }

    function updateReleaseVariable(variable, onSuccess) {
        VariablesService.updateReleaseVariable(variable).then(function (result) {
            var updated = result.data;
            _.assign(_.find($scope.variables, { key: updated.key }), updated);
            _.assign(_.find($scope.allVariables, { key: updated.key }), updated);
            onSuccess();
        });
    }

    function createReleaseVariable(variable, onSuccess) {
        VariablesService.createReleaseVariable($scope.release.id, variable).then(function (result) {
            var variable = result.data;
            $scope.variables.push(variable);
            $scope.allVariables.push(VariablesService.decorateVariable(variable));
            onSuccess(variable);
        });
    }

    function newVariable() {
        return {
            type: 'xlrelease.StringVariable',
            requiresValue: true,
            showOnReleaseStart: true
        };
    }

    function deleteReleaseVariable(variable, onSuccess) {
        VariablesService.replaceReleaseVariable(variable, { value: variable.value, variable: variable.variable }).then(function () {
            return VariablesService.deleteReleaseVariable(variable);
        }).then(function () {
            loadAllVariables();
            onSuccess();
        });
    }

    function reorderReleaseVariables(variables) {
        VariablesService.updateReleaseVariables($scope.release.id, variables).then(function (result) {
            return $scope.variables = result.data;
        });
    }

    function showReleaseVariable(isReleaseVariable) {
        $scope.releaseVariable = isReleaseVariable;
    }
}]);

/***/ }),
/* 1224 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _colors = __webpack_require__(177);

var _colors2 = _interopRequireDefault(_colors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var sizes = {
    SYMBOL: 5,
    LINE: 1,
    LEGEND: 11,
    LABEL: 11,
    BAR: 20,
    BAR_VERTICAL: 45
};

var position = {
    CENTER: 'center'
};

var defaults = {
    TITLE_TEXT_STYLE: {
        color: _colors2.default.black,
        fontSize: 30,
        fontWeight: '600',
        fontFamily: 'OpenSans'
    },
    SUB_TITLE_TEXT_STYLE: {
        color: _colors2.default.black,
        fontSize: 12,
        fontFamily: 'OpenSans'
    }
};

var pieChartSmallSizeSettings = {
    title: {
        show: true,
        textStyle: {
            fontSize: 17
        },
        subtextStyle: {
            fontSize: 9
        },
        y: '38%'
    },
    legend: {
        show: true,
        bottom: 0
    },
    tooltip: {
        position: [0, '12%']
    },
    series: {
        radius: [35, '65%']
    }
};

var pieChartSmallHeightSettings = {
    title: {
        show: true,
        textStyle: {
            fontSize: 22
        },
        subtextStyle: {
            fontSize: 10
        },
        y: '35%'
    },
    legend: {
        show: true,
        bottom: 0
    },
    series: {
        radius: [45, '70%']
    }
};

var pieChartSmallWidthSettings = {
    title: {
        show: true,
        textStyle: {
            fontSize: 20
        },
        subtextStyle: {
            fontSize: 9
        },
        y: '45%'
    },
    tooltip: {
        position: [0, '30%']
    },
    series: {
        radius: [42, '80%']
    }
};

var HORIZONTAL_BAR_NUMS = 10;

var EchartsReportsService = function () {
    function EchartsReportsService(durationFilter) {
        (0, _classCallCheck3.default)(this, EchartsReportsService);

        this.durationFilter = durationFilter;
    }

    /** Report configurations **/

    (0, _createClass3.default)(EchartsReportsService, [{
        key: 'taskEfficiency',
        value: function taskEfficiency(releaseEfficiency) {
            var _this = this;

            var that = this;
            return this.automationTaskReport(releaseEfficiency.totalAutomatedTasks, releaseEfficiency.totalManualTasks, releaseEfficiency.totalTasks, 'tasks executed', function (params) {
                return _this.automationTaskReportTooltip(params.data.name, params.color, params.data.value, _this.formatPercentage(params.data.value, releaseEfficiency.totalTasks));
            });
        }
    }, {
        key: 'taskTimeSpent',
        value: function taskTimeSpent(releaseEfficiency) {
            var _this2 = this;

            var that = this;
            var durationFormatter = this.getDurationFormatter(releaseEfficiency.totalTimeSpent);
            return this.automationTaskReport(releaseEfficiency.totalAutomatedTimeSpent, releaseEfficiency.totalManualTimeSpent, durationFormatter.format(releaseEfficiency.totalTimeSpent) + ' ' + durationFormatter.name.charAt(0), 'in total', function (params) {
                return _this2.automationTaskReportTooltip(params.data.name, params.color, _this2.durationFilter(params.data.value), _this2.formatPercentage(params.data.value, releaseEfficiency.totalTimeSpent));
            });
        }
    }, {
        key: 'longestReleases',
        value: function longestReleases(_longestReleases) {
            return this.longestItemsHorizontalBarReport('release', _longestReleases);
        }
    }, {
        key: 'longestTasks',
        value: function longestTasks(_longestTasks) {
            return this.longestItemsHorizontalBarReport('task', _longestTasks);
        }
    }, {
        key: 'longestPhases',
        value: function longestPhases(_longestPhases) {
            return this.longestItemsHorizontalBarReport('phase', _longestPhases);
        }
    }, {
        key: 'releaseEfficiency',
        value: function releaseEfficiency(averageDurationAndAutomation) {
            var _this3 = this;

            return {
                grid: {
                    bottom: 80
                },
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'transparent',
                    formatter: function formatter(params) {
                        return _this3.getReleaseEfficiencyTooltip(params);
                    }
                },
                legend: {
                    bottom: 25,
                    itemWidth: 10,
                    data: ['Automation', 'Manual'],
                    selectedMode: false,
                    textStyle: {
                        color: _colors2.default.gray,
                        fontSize: sizes.LEGEND
                    }
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: false,
                    data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
                        return _this3.formatMonth(it.name);
                    }),
                    axisTick: { show: false },
                    axisLine: { show: false, lineStyle: { color: _colors2.default.gray } },
                    axisLabel: { fontSize: sizes.LABEL }
                },
                yAxis: {
                    type: 'value',
                    axisTick: { show: false },
                    axisLine: { show: false, lineStyle: { color: _colors2.default.gray } },
                    axisLabel: {
                        fontSize: sizes.LABEL,
                        formatter: function formatter(value) {
                            return value > 0 ? value + '%' : value;
                        }
                    }
                },
                series: [{
                    type: 'line',
                    name: 'Automation',
                    data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
                        return it.y;
                    }),
                    lineStyle: {
                        normal: {
                            color: _colors2.default.purple,
                            width: sizes.LINE
                        }
                    },
                    itemStyle: { normal: { color: _colors2.default.purple } },
                    symbol: 'circle',
                    symbolSize: sizes.SYMBOL
                }, {
                    type: 'line',
                    name: 'Manual',
                    data: averageDurationAndAutomation.releasesAutomation.map(function (it) {
                        return 100 - it.y;
                    }),
                    lineStyle: {
                        normal: {
                            color: _colors2.default.yellow,
                            width: sizes.LINE
                        }
                    },
                    itemStyle: { normal: { color: _colors2.default.yellow } },
                    symbol: 'circle',
                    symbolSize: sizes.SYMBOL
                }, {
                    type: 'line',
                    name: 'Duration',
                    show: false,
                    data: averageDurationAndAutomation.releasesDuration.map(function (it) {
                        return _this3.durationFilter(it.y);
                    })
                }]
            };
        }
    }, {
        key: 'numberOfReleasesPerMonth',
        value: function numberOfReleasesPerMonth(releaseEfficiency) {
            var _this4 = this;

            return {
                axisPointer: { show: false },
                color: [_colors2.default.blue],
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'transparent',
                    formatter: this.getNumberOfReleasesPerMonth.bind(this),
                    axisPointer: { lineStyle: { opacity: 0 } }
                },
                xAxis: {
                    type: 'category',
                    data: releaseEfficiency.numberOfReleasesPerMonth.map(function (it) {
                        return _this4.formatMonth(it.name);
                    }),
                    axisTick: { show: false },
                    axisLine: { show: false, lineStyle: { color: _colors2.default.gray } },
                    axisLabel: { fontSize: sizes.LABEL }
                },
                yAxis: {
                    type: 'value',
                    axisTick: { show: false },
                    axisLine: { show: false, lineStyle: { color: _colors2.default.gray } }
                },
                series: [{
                    type: 'bar',
                    barWidth: sizes.BAR_VERTICAL,
                    name: 'Releases',
                    data: releaseEfficiency.numberOfReleasesPerMonth.map(function (it) {
                        return it.y;
                    })
                }, {
                    type: 'line',
                    show: false,
                    name: 'Automation',
                    data: releaseEfficiency.releasesAutomation.map(function (it) {
                        return it.y + '%';
                    })
                }, {
                    type: 'line',
                    show: false,
                    name: 'Avg. release duration',
                    data: releaseEfficiency.releasesDuration.map(function (it) {
                        return _this4.durationFilter(it.y);
                    })
                }]
            };
        }
    }, {
        key: 'releaseDuration',
        value: function releaseDuration(averageDurationAndAutomation) {
            var _this5 = this;

            var durations = averageDurationAndAutomation.releasesDuration.map(function (it) {
                return it.y;
            });
            var maxDuration = _.max(durations);
            var durationFormatter = this.getDurationFormatter(maxDuration);

            return {
                tooltip: {
                    trigger: 'axis',
                    backgroundColor: 'transparent',
                    // Note: passing in first element of array since the value is taken from the axis
                    formatter: function formatter(params) {
                        return _this5.wrapTooltipTextContext(_this5.getAverageReleaseDuration(_this5.durationFilter(params[0].value)));
                    }
                },
                xAxis: {
                    type: 'category',
                    boundaryGap: false,
                    data: averageDurationAndAutomation.releasesDuration.map(function (it) {
                        return _this5.formatMonth(it.name);
                    }),
                    axisTick: { show: false },
                    axisLine: { show: false, lineStyle: { color: _colors2.default.gray } }
                },
                yAxis: {
                    name: durationFormatter.name,
                    nameLocation: 'start',
                    type: 'value',
                    axisTick: { show: false },
                    axisLine: { show: false, lineStyle: { color: _colors2.default.gray } },
                    axisLabel: {
                        formatter: durationFormatter.format
                    }
                },
                series: {
                    type: 'line',
                    lineStyle: {
                        normal: {
                            color: _colors2.default.blue,
                            width: sizes.LINE
                        }
                    },
                    itemStyle: {
                        normal: {
                            color: _colors2.default.blue
                        }
                    },
                    symbol: 'circle',
                    symbolSize: sizes.SYMBOL,
                    areaStyle: { normal: { color: _colors2.default.lightblue } },
                    data: durations
                }
            };
        }

        /** Helper methods **/

    }, {
        key: 'formatPercentage',
        value: function formatPercentage(num, total) {
            var round10 = parseFloat((num / total * 100).toFixed(2));
            if (round10 === 0) {
                return '<0.01';
            }
            return '' + round10;
        }
    }, {
        key: 'getReleaseEfficiencyTooltip',
        value: function getReleaseEfficiencyTooltip(params) {
            var _this6 = this;

            return this.wrapTooltipTextContext(params.map(function (param) {
                if (param.seriesName === 'Duration') {
                    return '<div class="tooltip-text-offset">' + _this6.getAverageReleaseDuration(param.value) + '</div>';
                }
                return '<div><span class="tooltip-text-circle" style="background: ' + param.color + '">&nbsp;</span>\n                    <span>' + param.seriesName + ': ' + param.value + '%</span></div>';
            }).join(''));
        }
    }, {
        key: 'getNumberOfReleasesPerMonth',
        value: function getNumberOfReleasesPerMonth(params) {
            return this.wrapTooltipTextContext(params.map(function (param) {
                return '<div>' + param.seriesName + ': ' + param.data + '</div>';
            }).join(''));
        }
    }, {
        key: 'automationTaskReportTooltip',
        value: function automationTaskReportTooltip(name, color, value, percentage) {
            return this.wrapTooltipTextContext('<span class="tooltip-text-circle" style="background: ' + color + '">&nbsp;</span>\n             <span>' + name + ': ' + value + ' (' + percentage + '%)</span>');
        }
    }, {
        key: 'automationTaskReport',
        value: function automationTaskReport(automatedValue, manualValue, text, subtext, tooltipFormatter) {
            var automatedName = 'Automated task';
            var manualName = 'Manual task';

            return {
                title: {
                    text: text, subtext: subtext,
                    x: position.CENTER,
                    y: '42%',
                    textStyle: defaults.TITLE_TEXT_STYLE,
                    subtextStyle: defaults.SUB_TITLE_TEXT_STYLE
                },
                tooltip: {
                    trigger: 'item',
                    backgroundColor: 'transparent',
                    formatter: tooltipFormatter
                },
                color: [_colors2.default.purple, _colors2.default.yellow],
                legend: {
                    selectedMode: false,
                    left: position.CENTER,
                    bottom: 15,
                    itemWidth: 10,
                    data: [{
                        name: automatedName,
                        icon: 'circle',
                        textStyle: {
                            color: _colors2.default.gray,
                            fontSize: sizes.LEGEND
                        }
                    }, {
                        name: manualName,
                        icon: 'circle',
                        textStyle: {
                            color: _colors2.default.gray,
                            fontSize: sizes.LEGEND
                        }
                    }]
                },
                label: {
                    normal: {
                        show: true
                    }
                },
                series: {
                    type: 'pie',
                    radius: [70, 100],
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            show: false,
                            position: position.CENTER
                        },
                        emphasis: {
                            show: false,
                            textStyle: { fontSize: '16' }
                        }
                    },
                    labelLine: {
                        normal: {
                            show: false
                        }
                    },
                    data: [{
                        value: automatedValue,
                        name: automatedName
                    }, {
                        value: manualValue,
                        name: manualName
                    }]
                }
            };
        }
    }, {
        key: 'sortOnDuration',
        value: function sortOnDuration(a, b) {
            if (a.duration < b.duration) return -1;
            if (a.duration > b.duration) return 1;
            return 0;
        }
    }, {
        key: 'getDurationFormatter',
        value: function getDurationFormatter(durationInMs) {
            var round10 = function round10(val) {
                return parseFloat(val.toFixed(2));
            };

            var durationInSec = function durationInSec(durationInMs) {
                return round10(durationInMs / 1000);
            };
            if (durationInSec(durationInMs) < 60) {
                return { format: durationInSec, name: 'sec' };
            }

            var durationInMin = function durationInMin(durationInMs) {
                return round10(durationInSec(durationInMs) / 60);
            };
            if (durationInMin(durationInMs) < 60) {
                return { format: durationInMin, name: 'min' };
            }

            var durationInHours = function durationInHours(durationInMs) {
                return round10(Math.ceil(durationInMin(durationInMs) / 6) / 10);
            };
            if (durationInHours(durationInMs) < 24) {
                return { format: durationInHours, name: 'hours' };
            }

            return { format: function format(durationInMs) {
                    return round10(durationInHours(durationInMs) / 24);
                }, name: 'days' };
        }
    }, {
        key: 'longestItemsHorizontalBarReport',
        value: function longestItemsHorizontalBarReport(seriesName, data) {
            var _this7 = this;

            // sort the data before using it
            data = data.sort(this.sortOnDuration);
            // add placeholders if needed
            if (data.length < HORIZONTAL_BAR_NUMS) {
                data = _.times(HORIZONTAL_BAR_NUMS - data.length, _.constant({ title: '', duration: 0, isPlaceholder: true })).concat(data);
            }

            var durations = data.map(function (it) {
                return it.duration;
            });
            var maxDuration = _.max(durations);
            var durationFormatter = this.getDurationFormatter(maxDuration);

            return {
                sortedData: data,
                color: [_colors2.default.blue],
                grid: {
                    left: 220
                },
                sort: 'descending',
                tooltip: {
                    trigger: 'axis',
                    axisPointer: { lineStyle: { opacity: 0 } },
                    backgroundColor: 'transparent',
                    formatter: function formatter(params) {
                        return _this7.getHorizontalBarTooltip(data, params[0]);
                    }
                },
                yAxis: {
                    type: 'category',
                    data: data.map(function (it) {
                        return it.title;
                    }),
                    axisTick: { show: false },
                    axisLine: { show: false },
                    axisLabel: {
                        color: _colors2.default.black,
                        margin: 200,
                        textStyle: {
                            align: 'left'
                        },
                        formatter: function formatter(label) {
                            return _this7.wrapText(label, 30);
                        }
                    }
                },
                xAxis: {
                    name: durationFormatter.name,
                    nameTextStyle: {
                        fontSize: sizes.LABEL,
                        color: _colors2.default.gray
                    },
                    type: 'value',
                    axisTick: { show: false },
                    axisLine: { show: false, lineStyle: { color: _colors2.default.gray } },
                    axisLabel: {
                        formatter: durationFormatter.format
                    }
                },
                series: {
                    type: 'bar',
                    barWidth: sizes.BAR,
                    name: seriesName,
                    data: durations
                }
            };
        }
    }, {
        key: 'getAverageReleaseDuration',
        value: function getAverageReleaseDuration(avg) {
            return 'Avg. release duration: ' + avg;
        }
    }, {
        key: 'getHorizontalBarTooltip',
        value: function getHorizontalBarTooltip(data, params) {
            var item = data[params.dataIndex];
            if (item.isPlaceholder) return '';

            var wrapTextNum = 40;
            var context = [];
            if (params.seriesName === 'release') {
                context.push('<div class="tooltip-release-title" >Release: ' + item.title + '</div>');
                context.push('<span>Duration: ' + this.durationFilter(item.duration) + '</span>');
            }

            if (params.seriesName === 'phase') {
                context.push('<div>Phase: ' + this.wrapText(item.title, wrapTextNum) + '</div>');
                context.push('<div>Duration: ' + this.durationFilter(item.duration) + '</div>');
                context.push('<div>Belongs to: ' + this.wrapText(item.release, wrapTextNum) + '</div>');
            }

            if (params.seriesName === 'task') {
                context.push('<div>Task: ' + this.wrapText(item.title, wrapTextNum) + '</div>');
                context.push('<div>Duration: ' + this.durationFilter(item.duration) + '</div>');
                context.push('<div>Belongs to: ' + this.wrapText(item.release, wrapTextNum) + '</div>');
                context.push('<div>Owner: ' + (item.owner.username || 'Not assigned') + '</div>');
            }

            return this.wrapTooltipTextContext(context.join(''));
        }
    }, {
        key: 'wrapTooltipTextContext',
        value: function wrapTooltipTextContext(context) {
            return '<div class="tooltip-text-content">' + context + '</div>';
        }
    }, {
        key: 'wrapText',
        value: function wrapText(string, len) {
            return string.length < len ? string : string.substring(0, len - 3) + '...';
        }
    }, {
        key: 'formatMonth',
        value: function formatMonth(month) {
            return month.substr(0, 3);
        }
    }, {
        key: 'responsivePie',
        value: function responsivePie(options) {
            var responsiveOptions = {};
            var mediaOptions = angular.copy(options);
            responsiveOptions.baseOption = angular.copy(options);
            responsiveOptions.media = [
            // Media queries order matters
            {
                query: { maxWidth: 290 },
                option: (0, _extends3.default)({}, mediaOptions, pieChartSmallWidthSettings)
            }, {
                query: { maxHeight: 300 },
                option: (0, _extends3.default)({}, mediaOptions, pieChartSmallHeightSettings)
            }, {
                query: { maxHeight: 300, maxWidth: 290 },
                option: (0, _extends3.default)({}, mediaOptions, pieChartSmallSizeSettings)
            }, {
                option: options
            }];
            return responsiveOptions;
        }
    }]);
    return EchartsReportsService;
}();

EchartsReportsService.$inject = ['durationFilter'];


angular.module('xlrelease').service('EchartsReportsService', EchartsReportsService);

/***/ }),
/* 1225 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').filter('duration', function () {
    function truncate(durationInDays) {
        if (durationInDays >= 10) {
            durationInDays = Math.ceil(durationInDays);
        }
        return durationInDays;
    }

    return function (durationInMs) {
        var durationInSec = Math.floor(durationInMs / 1000);
        if (durationInSec < 60) {
            return durationInSec + ' sec';
        }
        var durationInMin = Math.floor(durationInSec / 60);
        if (durationInMin < 60) {
            return durationInMin + ' min';
        }
        var durationInHours = truncate(Math.ceil(durationInMin / 6) / 10);
        if (durationInHours < 24) {
            return durationInHours + ' hours';
        }
        return truncate(Math.ceil(durationInHours / 2.4) / 10) + ' days';
    };
});

/***/ }),
/* 1226 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('MostRecentReleaseCharts', ['reportConfigurationService', function (reportConfigurationService) {
    return {
        stackedBarCharts: function stackedBarCharts(options) {
            return function link(scope, element) {
                scope.$watch('reports.mostRecentReleases.data', function (data) {
                    if (element.highcharts()) {
                        element.highcharts().destroy();
                    }

                    if (data && data.length) {
                        var releasesTitle = _.map(data, 'title');
                        var series = options.series(data);
                        var chartDef = {
                            colors: ['#a52a2a', '#68b749'],
                            xAxis: {
                                categories: releasesTitle,
                                labels: {
                                    rotation: -90,
                                    align: 'right',
                                    formatter: function formatter() {
                                        var maxLength = 25;
                                        var halfSlice = (maxLength - 3) / 2;
                                        var s = this.value;
                                        return s.length <= maxLength ? s : s.substr(0, halfSlice) + '...' + s.substr(-halfSlice);
                                    }
                                }
                            },
                            yAxis: options.yAxis,
                            series: [{
                                name: 'Manual tasks',
                                type: 'column',
                                data: series.manualTasksSerie
                            }, {
                                name: 'Automated tasks',
                                type: 'column',
                                data: series.automatedTasksSerie
                            }]
                        };

                        if (options.tooltip) {
                            chartDef.tooltip = options.tooltip;
                        }

                        element.highcharts(reportConfigurationService.getHighchartsOptions(chartDef));
                    }
                });
            };
        }
    };
}]);

/***/ }),
/* 1227 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('phaseDuration', ['reportConfigurationService', function (reportConfigurationService) {
    return function (scope, element) {
        var phase = scope.phase;
        var release = scope.release;
        var getDurationPercentage = scope.getDurationPercentage;
        var duration = getDurationPercentage(release, phase);

        var FOREGROUND_COLOR = '#aaa';
        var BACKGROUND_COLOR = '#fff';

        element.highcharts(reportConfigurationService.getHighchartsOptions({
            exporting: { enabled: false },
            colors: [FOREGROUND_COLOR, BACKGROUND_COLOR],
            chart: {
                spacing: [0, 0, 0, 0],
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: null,
                backgroundColor: null,
                borderWidth: 0,
                type: 'area',
                margin: [2, 0, 2, 0],
                width: 18,
                height: 18,
                style: {
                    overflow: 'visible'
                },
                skipClone: true
            },
            legend: {
                enabled: false
            },
            tooltip: {
                enabled: false
            },
            plotOptions: {
                pie: {
                    borderColor: FOREGROUND_COLOR,
                    allowPointSelect: false,
                    cursor: 'default',
                    dataLabels: {
                        enabled: false
                    },
                    size: '13.5'
                }
            },
            series: [{
                type: 'pie',
                name: '',
                data: [['Selected', duration], ['Unselected', 100 - duration]]
            }]
        }));
    };
}]);

/***/ }),
/* 1228 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ReleaseEfficiency', ['reportConfigurationService', function (reportConfigurationService) {
    return {
        pieChart: function pieChart(options) {
            return function link(scope, element) {
                scope.$watch('reports.releaseEfficiency.data', function (releaseEfficiency) {
                    if (element.highcharts()) {
                        element.highcharts().destroy();
                    }

                    if (releaseEfficiency) {
                        element.highcharts(reportConfigurationService.getHighchartsOptions({
                            colors: ['#68b749', '#a52a2a'],
                            tooltip: {
                                hideDelay: 0,
                                formatter: options.tooltipFormatter
                            },
                            chart: {
                                height: 225
                            },
                            plotOptions: {
                                pie: {
                                    size: 100,
                                    showInLegend: true
                                }
                            },
                            series: [{
                                type: 'pie',
                                data: options.data(releaseEfficiency),
                                dataLabels: {
                                    format: '{point.percentage:.1f} %',
                                    distance: -25,
                                    color: 'white'
                                }
                            }]
                        }));
                    }
                });
            };
        }
    };
}]);

angular.module('xlrelease').directive('releaseEfficiencyAutomation', ['ReleaseEfficiency', function (ReleaseEfficiency) {
    return ReleaseEfficiency.pieChart({
        data: function data(releaseEfficiency) {
            return [['Automated', releaseEfficiency.totalAutomatedTasks], ['Manual', releaseEfficiency.totalManualTasks]];
        },
        tooltipFormatter: function tooltipFormatter() {
            var tooltipContent = '<b>' + this.point.name + '</b><br>';
            tooltipContent += this.y + ' tasks';
            return tooltipContent;
        }
    });
}]);

angular.module('xlrelease').directive('releaseEfficiencyTimeSpent', ['ReleaseEfficiency', 'durationFilter', function (ReleaseEfficiency, durationFilter) {
    return ReleaseEfficiency.pieChart({
        data: function data(releaseEfficiency) {
            return [['Automated', releaseEfficiency.totalAutomatedTimeSpent], ['Manual', releaseEfficiency.totalManualTimeSpent]];
        },
        tooltipFormatter: function tooltipFormatter() {
            var tooltipContent = '<b>' + this.point.name + '</b><br>';
            tooltipContent += durationFilter(this.y);
            return tooltipContent;
        }
    });
}]);

/***/ }),
/* 1229 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _colors = __webpack_require__(177);

var _colors2 = _interopRequireDefault(_colors);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').directive('releaseNumberReport', ['reportConfigurationService', function (reportConfigurationService) {
    return function (scope, element) {
        scope.$watch('reports.numberOfReleasesPerMonth.data', function (numberOfReleasesPerMonth) {
            if (element.highcharts()) {
                element.highcharts().destroy();
            }

            if (numberOfReleasesPerMonth && numberOfReleasesPerMonth.length) {
                var categories = _.map(_.map(numberOfReleasesPerMonth, 'x'), function (date) {
                    return moment(date).format("MMMM YYYY");
                });
                var data = _.map(numberOfReleasesPerMonth, 'y');

                element.highcharts(reportConfigurationService.getHighchartsOptions({
                    tooltip: {
                        enabled: false
                    },
                    legend: {
                        enabled: false
                    },
                    xAxis: {
                        categories: categories
                    },
                    yAxis: {
                        title: {
                            text: 'Number'
                        },
                        min: 0
                    },
                    series: [{
                        type: 'column',
                        name: 'Number',
                        data: data,
                        dataLabels: {
                            enabled: true,
                            color: _colors2.default.white,
                            align: 'center',
                            y: 30
                        }
                    }]
                }));
            }
        });
    };
}]);

/***/ }),
/* 1230 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('reportConfigurationService', function () {
    var ONE_MONTH = 30 * 24 * 3600 * 1000;

    var defaultOptions = {
        title: {
            text: ''
        },
        credits: {
            enabled: false
        },
        xAxis: {
            type: 'datetime',
            labels: {
                formatter: function formatter() {
                    return moment(this.value).format("D MMMM YYYY");
                }
            },
            minTickInterval: ONE_MONTH
        },
        legend: {
            borderWidth: 0,
            symbolRadius: 0
        },
        plotOptions: {
            scatter: {
                marker: {
                    radius: 5,
                    states: {
                        hover: {
                            enabled: true,
                            lineColor: 'rgb(100,100,100)'
                        }
                    }
                },
                states: {
                    hover: {
                        marker: {
                            enabled: false
                        }
                    }
                }
            },
            spline: {
                marker: {
                    enabled: false
                },
                enableMouseTracking: false,
                lineWidth: 1
            },
            areaspline: {
                fillOpacity: 0.3,
                marker: {
                    enabled: false
                }
            },
            column: {
                stacking: 'normal'
            }
        }
    };

    return {
        getHighchartsOptions: function getHighchartsOptions(options) {
            return angular.extend(angular.copy(defaultOptions), options);
        }
    };
});

/***/ }),
/* 1231 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('reportContainer', [function () {
    return {
        templateUrl: 'partials/reports/report-container.html',
        transclude: true,
        scope: {
            report: '='
        }
    };
}]);

/***/ }),
/* 1232 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ReportsController = function () {
    function ReportsController($scope, TagsService, $location, ReportsService, filterSettings, Events, ClientSettings, durationFilter, $state, TaskDefinitionsService) {
        (0, _classCallCheck3.default)(this, ReportsController);

        this.scope = $scope;
        this.ClientSettings = ClientSettings;
        this.Events = Events;
        this.durationFilter = durationFilter;
        this.ReportsService = ReportsService;
        this.TagsService = TagsService;
        this.state = $state;
        this.TaskDefinitionsService = TaskDefinitionsService;

        $scope.filters = filterSettings;
        $scope.reportType = $location.path().substring(1);
        $scope.allTags = [];
        $scope.exportReport = ReportsService.exportReport;
        $scope.goToRelease = this.goToRelease.bind(this);
        $scope.formatDuration = this.formatDuration.bind(this);
        $scope.getTaskNameByType = this.getTaskNameByType.bind(this);
        ReportsService.setFilterSettings(filterSettings);
    }

    (0, _createClass3.default)(ReportsController, [{
        key: '$onInit',
        value: function $onInit() {
            var _this = this;

            this.scope.$on(this.Events.filters.filterChanged, function (evt, filters) {
                _this.loadReports();
                _this.ClientSettings.setReportsFilters(filters);
            });

            this.loadTaskDefinitions();
            this.loadTags();
            this.loadReports();
        }
    }, {
        key: 'formatDuration',
        value: function formatDuration(durationInMs) {
            var duration = moment.duration(durationInMs);
            return duration < 86400000 ? duration.format('d[d] h[h] m[m] s[s]') : duration.format('d[d] h[h] m[m]');
        }
    }, {
        key: 'goToRelease',
        value: function goToRelease(params, data) {
            var release = data[params.dataIndex];
            if (release && release.releaseId) {
                this.state.go('release', { releaseId: release.releaseId });
            }
        }
    }, {
        key: 'loadReports',
        value: function loadReports() {
            this.ReportsService.loadReports(this.scope.reportType);
            this.scope.reports = this.ReportsService.getReports();
        }
    }, {
        key: 'loadTags',
        value: function loadTags() {
            var _this2 = this;

            this.TagsService.getArchivedReleaseTags().then(function (tags) {
                _this2.scope.allTags = tags;
            });
        }
    }, {
        key: 'loadTaskDefinitions',
        value: function loadTaskDefinitions() {
            var _this3 = this;

            this.TaskDefinitionsService.getTaskDefinitions().then(function (resp) {
                _this3.scope.taskDefinitions = _.reduce(resp.data, function (result, value) {
                    result[value.typeName] = _.omit(value, 'typeName');
                    return result;
                }, {});
            });
        }
    }, {
        key: 'getTaskNameByType',
        value: function getTaskNameByType(taskType) {
            var taskDefs = this.scope.taskDefinitions;
            var isDefExist = angular.isDefined(taskDefs) && angular.isDefined(taskDefs[taskType]);
            return isDefExist ? taskDefs[taskType].displayGroup + ': ' + taskDefs[taskType].displayName : taskType;
        }
    }]);
    return ReportsController;
}();

ReportsController.$inject = ['$scope', 'TagsService', '$location', 'ReportsService', 'filterSettings', 'Events', 'ClientSettings', 'durationFilter', '$state', 'TaskDefinitionsService'];


angular.module('xlrelease').controller('ReportsController', ReportsController);

/***/ }),
/* 1233 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ReportsDefinition', ['ReportLoader', 'Report', 'EchartsReportsService', function (ReportLoader, Report, EchartsReportsService) {
    return {
        'release-automation': function releaseAutomation() {
            var MOST_RECENT_RELEASES_NUMBER = 20;

            this.loaders = {
                releasesDuration: new ReportLoader('reports/releases/duration'),
                releasesAutomation: new ReportLoader('reports/releases/automation'),
                mostRecentReleases: new ReportLoader('reports/releases/most-recent/' + MOST_RECENT_RELEASES_NUMBER)
            };

            this.reports = {
                releasesDuration: new Report().add('data', this.loaders.releasesDuration, function (data) {
                    return data.average;
                }),
                releasesAutomation: new Report().add('data', this.loaders.releasesAutomation, function (data) {
                    return data.averageAutomationPercentage;
                }),
                mostRecentReleases: new Report().add('data', this.loaders.mostRecentReleases, function (data) {
                    return data.reverse();
                })
            };
        },
        'reports': function reports() {
            var TOP_REPORT_SIZE = 10;

            function sliceReport(data) {
                if (data) {
                    data = data.slice(0, TOP_REPORT_SIZE);
                }
                return data;
            }

            function emptyArrayIfAllKeysAreZero(data) {
                if (_.sum(_.map(data)) !== 0) {
                    return data;
                }
                return [];
            }

            this.loaders = {
                longestTaskTypes: new ReportLoader('reports/longest-task-types'),
                longestTasks: new ReportLoader('reports/longest-tasks'),
                averageAndLongestTaskDuration: new ReportLoader('reports/average-and-longest-task-duration'),
                longestPhases: new ReportLoader('reports/longest-phases'),
                numberOfReleasesPerMonth: new ReportLoader('reports/releases/number-by-month'),
                mostInvolvedPeople: new ReportLoader('reports/most-involved-people'),
                releasesDuration: new ReportLoader('reports/releases/duration'),
                releasesAutomation: new ReportLoader('reports/releases/automation'),
                completedRelease: new ReportLoader('reports/release/completed'),
                averageAndLongestReleaseDuration: new ReportLoader('reports/release/average-and-longest-release-duration')
            };

            var averageDurationAndAutomation = new Report().add('releasesDuration', this.loaders.releasesDuration, function (data) {
                return data.average;
            }).add('releasesAutomation', this.loaders.releasesAutomation, function (data) {
                return data.averageAutomationPercentage;
            });

            var releaseEfficiency = new Report().add('releasesDuration', this.loaders.releasesDuration, function (data) {
                return data.average;
            }).add('releasesAutomation', this.loaders.releasesAutomation, function (data) {
                return data.averageAutomationPercentage;
            }).add('numberOfReleasesPerMonth', this.loaders.numberOfReleasesPerMonth);

            this.reports = {
                /** Echarts Reports **/
                echartsTaskTimeSpent: new Report().add('data', this.loaders.releasesAutomation, function (data) {
                    if (!!data.releaseEfficiency.totalTasks) {
                        return EchartsReportsService.taskTimeSpent(data.releaseEfficiency);
                    }
                }),
                echartsTaskEfficiency: new Report().add('data', this.loaders.releasesAutomation, function (data) {
                    if (!!data.releaseEfficiency.totalTasks) {
                        return EchartsReportsService.taskEfficiency(data.releaseEfficiency);
                    }
                }),
                echartsLongestReleases: new Report().add('data', this.loaders.releasesDuration, function (data) {
                    if (!!data.longestReleases.length) {
                        return EchartsReportsService.longestReleases(sliceReport(data.longestReleases));
                    }
                }),
                echartsLongestTasks: new Report().add('data', this.loaders.longestTasks, function (data) {
                    if (!!data.length) {
                        return EchartsReportsService.longestTasks(sliceReport(data));
                    }
                }),
                echartsLongestPhases: new Report().add('data', this.loaders.longestPhases, function (data) {
                    if (!!data.length) {
                        return EchartsReportsService.longestPhases(sliceReport(data));
                    }
                }),
                echartsReleaseDuration: new Report().addByReport('data', averageDurationAndAutomation, function (data) {
                    if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
                        return EchartsReportsService.releaseDuration(data);
                    }
                }),
                echartsNumberOfReleasesPerMonth: new Report().addByReport('data', releaseEfficiency, function (data) {
                    if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
                        return EchartsReportsService.numberOfReleasesPerMonth(data);
                    }
                }),
                echartsReleaseEfficiency: new Report().addByReport('data', averageDurationAndAutomation, function (data) {
                    if (!!(data.releasesAutomation.length && data.releasesDuration.length)) {
                        return EchartsReportsService.releaseEfficiency(data);
                    }
                }),

                /** Common reports **/
                releaseEfficiency: new Report().add('data', this.loaders.releasesAutomation, function (data) {
                    return data.releaseEfficiency;
                }),
                numberOfReleasesPerMonth: new Report().add('data', this.loaders.numberOfReleasesPerMonth),
                longestReleases: new Report().add('data', this.loaders.releasesDuration, function (data) {
                    return sliceReport(data.longestReleases);
                }),
                averageDurationAndAutomation: averageDurationAndAutomation,

                /** Others **/
                longestPhases: new Report().add('data', this.loaders.longestPhases, sliceReport),
                longestTasks: new Report().add('data', this.loaders.longestTasks, sliceReport),
                longestTaskTypes: new Report().add('data', this.loaders.longestTaskTypes, sliceReport),
                mostInvolvedPeople: new Report().add('data', this.loaders.mostInvolvedPeople, sliceReport),
                averageAndLongestTaskDuration: new Report().add('data', this.loaders.averageAndLongestTaskDuration, emptyArrayIfAllKeysAreZero),
                completedRelease: new Report().add('data', this.loaders.completedRelease, emptyArrayIfAllKeysAreZero),
                averageAndLongestReleaseDuration: new Report().add('data', this.loaders.averageAndLongestReleaseDuration, emptyArrayIfAllKeysAreZero)
            };
        }
    };
}]);

angular.module('xlrelease').factory('ReportsService', ['Backend', 'Download', 'ReportsDefinition', function (Backend, Download, ReportsDefinition) {
    var filterSettings = null;
    var reports = null;

    return {
        loadReports: function loadReports(reportType) {
            var NewReport = ReportsDefinition[reportType];
            if (!NewReport) {
                /* eslint-disable no-console, angular/log */
                console.warn('Cannot construct report of \'' + reportType + '\' type');
                return;
            }
            var reportsPage = new NewReport();
            var params = getReportsParams(filterSettings);
            _.forEach(reportsPage.loaders, function (loader) {
                loader.startLoading();
                Backend.post(loader.url, params).then(function (resp) {
                    return loader.loaded(resp.data);
                }).then(loader.endLoading, loader.endLoading);
            });
            reports = reportsPage.reports;
        },
        exportReport: function exportReport(type) {
            var params = getReportsParams(filterSettings);
            params.report = type;
            params = _.pickBy(params, _.identity); // Remove empty properties
            Download.launch('export/report/?' + $.param(params));
        },
        setFilterSettings: function setFilterSettings(settings) {
            filterSettings = settings;
        },
        getFilterSettings: function getFilterSettings() {
            return filterSettings;
        },
        getReports: function getReports() {
            return reports;
        }
    };

    function getReportsParams(filterSettings) {
        var params = angular.copy(filterSettings);
        params.tags = _.isEmpty(params.tags) ? undefined : _.join(params.tags);
        return params;
    }
}]);

angular.module('xlrelease').factory('ReportLoader', function () {
    return function (url) {
        var self = this;
        var callbacks = [];

        this.loading = false;
        this.failed = false;
        this.url = url;

        this.startLoading = function () {
            self.loading = true;
        };

        this.endLoading = function () {
            self.loading = false;
        };

        this.failLoading = function (reason) {
            self.loading = false;
            self.failed = true;
            self.reason = reason;
        };

        this.loaded = function (data) {
            _.forEach(callbacks, function (callback) {
                callback(data);
            });
        };

        this.whenLoaded = function (callback) {
            callbacks.push(callback);
        };
    };
});

angular.module('xlrelease').factory('Report', function () {
    return function () {
        var _this = this;

        var self = this;
        var dataProperties = [];
        this.loaders = [];

        this.add = function (dataProperty, loader, transform) {
            _this[dataProperty] = [];
            dataProperties.push(dataProperty);
            _this.loaders.push(loader);
            loader.whenLoaded(function (data) {
                self[dataProperty] = transform ? transform(data) : data;
            });
            return _this;
        };

        this.addByReport = function (dataProperty, report, transform) {
            _this[dataProperty] = [];
            dataProperties.push(dataProperty);
            report.loaders.forEach(function (loader) {
                _this.loaders.push(loader);
                loader.whenLoaded(function () {
                    if (!_.find(report.loaders, function (anotherLoader) {
                        return anotherLoader !== loader && anotherLoader.loading;
                    })) {
                        self[dataProperty] = transform ? transform(report) : data;
                    }
                });
            });
            return _this;
        };

        this.loading = function () {
            var loading = false;
            _.forEach(this.loaders, function (loader) {
                loading = loading || loader.loading;
            });
            return loading;
        };

        this.isEmpty = function () {
            return !!_.find(dataProperties, function (dataProperty) {
                return !self[dataProperty] || self[dataProperty].length === 0;
            });
        };

        this.isConfigured = function () {
            return dataProperties.length > 0;
        };

        this.hasError = function () {
            return !!this.loaders.find(function (loader) {
                return loader.failed;
            });
        };

        this.errorMessage = function () {
            return this.loaders.find(function (loader) {
                return loader.failed;
            }).reason.data;
        };
    };
});

/***/ }),
/* 1234 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('tileContainer', [function () {
    return {
        restrict: 'AE',
        templateUrl: 'partials/reports/tile-container.html',
        transclude: {
            'title': 'tileTitle',
            'content': '?tileContent',
            'footer': '?tileFooter'
        },
        scope: {
            report: '='
        }
    };
}]);

/***/ }),
/* 1235 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').filter('displayPermission', ['PermissionLabels', function (PermissionLabels) {
    return function (permission) {
        return PermissionLabels[permission];
    };
}]);

/***/ }),
/* 1236 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('forbiddenAccessController', ['$scope', 'ForbiddenAccessService', function ($scope, ForbiddenAccessService) {
    $scope.errorMessage = ForbiddenAccessService.errorMessage;
}]);

/***/ }),
/* 1237 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ForbiddenAccessService', [function () {
    return {
        errorMessage: ''
    };
}]);

/***/ }),
/* 1238 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('LimitedUsers', ['Backend', function (Backend) {
    var maxNumberOfUsers = null;
    var users = null;

    return {
        isEnabled: function isEnabled() {
            return maxNumberOfUsers !== null && users !== null;
        },
        maximumReached: function maximumReached() {
            return this.isEnabled() && this.countLeft() <= 0;
        },
        countLeft: function countLeft() {
            var numberOfUsersAllowed = _.filter(users, 'loginAllowed').length;
            return maxNumberOfUsers - numberOfUsersAllowed;
        },
        setUsers: function setUsers(input) {
            users = input;
        },
        loadLicense: function loadLicense() {
            Backend.get('server/license').then(function (resp) {
                return maxNumberOfUsers = resp.data.maxNumberOfUsers || null;
            });
        }
    };
}]);

/***/ }),
/* 1239 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var GlobalPermissions = {
    CREATE_TOP_LEVEL_FOLDER: 'folder#create_top_level',
    EDIT_GLOBAL_BLACKOUT: 'global_calendar#edit_blackout',
    EDIT_RISK_PROFILE: 'risk_profile#edit',
    CREATE_GLOBAL_DASHBOARD: 'dashboard#create',
    EDIT_GLOBAL_ENVIRONMENT: 'environment#edit',
    EDIT_GLOBAL_APPLICATION: 'application#edit',
    EDIT_GLOBAL_RESERVATION: 'reservation#edit'
};

var Permissions = {
    CREATE_TEMPLATE: 'template#create',
    EDIT_TEMPLATE: 'template#edit',
    CREATE_RELEASE_FROM_TEMPLATE: 'template#create_release',
    EDIT_FOLDER: 'folder#edit',
    CREATE_RELEASE: 'release#create',
    START_RELEASE: 'release#start',
    EDIT_TRIGGERS: 'template#edit_triggers',
    EDIT_RELEASE_GROUP: 'group#edit',
    EDIT_FOLDER_SECURITY: 'folder#edit_security',
    EDIT_FOLDER_TEAMS: 'folder#edit_teams',
    EDIT_FOLDER_VARIABLES: 'folder#edit_variables'
};

var PermissionLabels = {
    'admin': {
        label: 'Admin',
        description: 'All permissions'
    },
    'login': {
        label: 'Login',
        description: 'Permission to log in to XL Release'
    },
    'reports#view': {
        label: 'View reports',
        description: 'Permission to review reports.'
    },
    'dashboard#create': {
        label: 'Create dashboard',
        description: 'Permission to create, edit, or delete a custom dashboard.'
    },
    'dashboard#view': {
        label: 'View dashboard',
        description: 'Users can see a custom dashboard inside Folder in Dashboards screen.'
    },
    'dashboard#edit': {
        label: 'Edit dashboard',
        description: 'Users can edit a custom dashboard inside Folder in Dashboards screen.'
    },
    'release#view': {
        label: 'View release',
        description: 'Users have view access to this release. It will appear in the Release screen. In the release details, users have read-only access to the release flow, properties, and activity log.'
    },
    'release#edit': {
        label: 'Edit release',
        description: 'Users can alter the structure of a release by adding and moving tasks and phases. Release properties and teams are editable.'
    },
    'release#edit_security': {
        label: 'Edit release security',
        description: 'Users can edit teams and permissions in a release.'
    },
    'release#start': {
        label: 'Start release',
        description: 'Users can start a planned release.'
    },
    'release#abort': {
        label: 'Abort release',
        description: 'Users can abort an active or planned release.'
    },
    'release#create': {
        label: 'Create release',
        description: 'Users can create a release from the template.'
    },
    'release#reassign_task': {
        label: 'Reassign task',
        description: 'Users can assign tasks to other people. Team assignment is also enabled.'
    },
    'release#edit_task': {
        label: 'Edit task',
        description: 'Users can edit individual tasks.'
    },
    'release#edit_blackout': {
        label: 'Edit task blackout',
        description: 'Users can enable or disable the Postpone during blackout period setting at task level.'
    },
    'release#edit_failure_handler': {
        label: 'Edit release failure handler',
        description: 'Users can edit the task failure handler in a release.'
    },
    'release#edit_precondition': {
        label: 'Edit release precondition',
        description: 'Users can edit the task’s precondition in a release.'
    },
    'release#lock_task': {
        label: 'Lock release task',
        description: 'When a release task is locked only users with lock permissions are able to edit or unlock it.'
    },
    'read': {
        label: 'Read',
        description: null
    },
    'repo#edit': {
        label: 'Edit repository',
        description: null
    },
    'security#edit': {
        label: 'Edit security',
        description: 'Access to the Roles and Permissions pages and permission to edit security on releases and templates.'
    },
    'import#remove': {
        label: 'Remove import',
        description: null
    },
    'template#create': {
        label: 'Create template',
        description: 'Permission to create a new template.'
    },
    'template#create_release': {
        label: 'Create release',
        description: 'Users can create a release from the template.'
    },
    'template#view': {
        label: 'View template',
        description: 'Users can see templates organized by folder in the Folder screen and all templates in Templates screen.'
    },
    'template#edit': {
        label: 'Edit template',
        description: 'Users can change the template by adding tasks and phases and changing them.'
    },
    'template#edit_security': {
        label: 'Edit template security',
        description: 'Users can edit teams and permissions on the template.'
    },
    'template#edit_triggers': {
        label: 'Edit triggers',
        description: 'Users can view, edit, and delete triggers on the template. To create a trigger, you also need the Create Release permission.'
    },
    'template#edit_failure_handler': {
        label: 'Edit template failure handler',
        description: 'Users can edit the task failure handler in a template.'
    },
    'template#edit_precondition': {
        label: 'Edit template precondition',
        description: 'Users can edit the task’s precondition in a template.'
    },
    'template#lock_task': {
        label: 'Lock template task',
        description: 'When a template task is locked only users with lock permissions are able to edit or unlock it.'
    },
    'global_variables#edit': {
        label: 'Edit global variables',
        description: 'Permission to edit global variables.'
    },
    'folder#view': {
        label: 'Read folder',
        description: 'Users can see the folder in the Folders screen.'
    },
    'folder#edit': {
        label: 'Edit folder',
        description: 'Users can edit the folder (for example, by renaming it).'
    },
    'folder#edit_security': {
        label: 'Edit folder security',
        description: 'Users can edit the teams and permissions on a folder.'
    },
    'folder#edit_teams': {
        label: 'Edit folder teams and permissions',
        description: 'Users can edit the teams and permissions on a folder, with the limitations: \n' + '[1] Cannot modify teams that have the permissions “Edit folder security” or “Edit folder teams and permissions”.\n' + '[2] Cannot add or remove the permissions “Edit folder security” or “Edit folder teams and permissions”.'
    },
    'folder#edit_variables': {
        label: 'Edit folder variables',
        description: 'Users can edit the folder variables.'
    },
    'folder#create_top_level': {
        label: 'Create top level folders',
        description: 'Permission to create folders.'
    },
    'folder#edit_configuration': {
        label: 'Edit configuration',
        description: 'Users can see, create, and edit the configuration in the Folders screen.'
    },
    'global_calendar#edit_blackout': {
        label: 'Edit blackout periods',
        description: 'Permission to create, edit, or delete a blackout period.'
    },
    'risk_profile#edit': {
        label: 'Edit risk profile',
        description: 'Permission to create, edit, or delete a risk profile.'
    },
    'group#view': {
        label: 'View release group',
        description: 'Users can view release groups inside Folder in Groups screen.'
    },
    'group#edit': {
        label: 'Edit release group',
        description: 'Users can edit, or create release groups.'
    },
    'environment#edit': {
        label: 'Edit environment',
        description: 'Permission to create, edit or delete an environment. Permission is required to create stages and create environment labels.'
    },
    'application#edit': {
        label: 'Edit application',
        description: 'Permission to create, edit, or delete an application.'
    },
    'reservation#edit': {
        label: 'Edit environment reservation',
        description: 'Access to Scheduling pages, make a schedule, or reserve an environment.'
    }
};

var filterPermissions = function filterPermissions(permissions, type) {
    return _.chain(permissions).keys().filter(function (permission) {
        return permission.startsWith(type) && !_.includes(GlobalPermissions, permission);
    }).value();
};

var FolderPermissions = filterPermissions(PermissionLabels, 'folder');
var ReleasePermissions = filterPermissions(PermissionLabels, 'release');
var TemplatePermissions = filterPermissions(PermissionLabels, 'template');
var GroupPermissions = filterPermissions(PermissionLabels, 'group');
var DashboardPermissions = filterPermissions(PermissionLabels, 'dashboard');

var AvailableGroupedFolderPermissions = [{
    label: 'Folder',
    icon: 'folder-icon',
    permissions: ['folder#view', 'folder#edit', 'folder#edit_variables', 'folder#edit_security', 'folder#edit_teams']
}, {
    label: 'Templates',
    icon: 'template-icon',
    permissions: ['template#view', 'template#edit', 'template#edit_security', 'template#edit_failure_handler', 'template#edit_triggers']
}, {
    label: 'Releases',
    icon: 'release-icon',
    permissions: ['release#view', 'release#edit', 'template#create_release', 'release#start', 'release#abort', 'release#edit_security', 'release#edit_failure_handler']
}, {
    label: 'Tasks',
    icon: 'task-icon',
    permissions: ['release#reassign_task', 'release#edit_task', 'release#edit_blackout', 'template#edit_precondition', 'release#edit_precondition', 'template#lock_task', 'release#lock_task']
}, {
    label: 'Release groups',
    icon: 'group-icon',
    permissions: ['group#view', 'group#edit']
}, {
    label: 'Dashboards',
    icon: 'dashboard-icon',
    permissions: ['dashboard#edit', 'dashboard#view']
}, {
    label: 'Configuration',
    icon: 'config-icon',
    permissions: ['folder#edit_configuration']
}];

angular.module('xlrelease').constant('GlobalPermissions', GlobalPermissions);
angular.module('xlrelease').constant('Permissions', Permissions);
angular.module('xlrelease').constant('PermissionLabels', PermissionLabels);
angular.module('xlrelease').constant('FolderPermissions', FolderPermissions);
angular.module('xlrelease').constant('ReleasePermissions', ReleasePermissions);
angular.module('xlrelease').constant('TemplatePermissions', TemplatePermissions);
angular.module('xlrelease').constant('ReleaseGroupPermissions', GroupPermissions);
angular.module('xlrelease').constant('DashboardPermissions', DashboardPermissions);
angular.module('xlrelease').constant('AvailableGroupedFolderPermissions', AvailableGroupedFolderPermissions);

/***/ }),
/* 1240 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var PermissionsController = function () {
        function PermissionsController(Backend, MemberType, displayPermissionFilter, ConfirmLeaveService) {
            (0, _classCallCheck3.default)(this, PermissionsController);

            this._Backend = Backend;
            this._MemberType = MemberType;
            this._displayPermissionFilter = displayPermissionFilter;
            this._ConfirmLeaveService = ConfirmLeaveService;

            this._roles = null;
            this._permissionsTableColumns = null;
            this._permissionsContainer = null;
            this._lastSavedDate = null;
            this._dirty = false;

            this._loadPermissions();
        }

        (0, _createClass3.default)(PermissionsController, [{
            key: 'save',
            value: function save() {
                var _this = this;

                var permissionsContainer = this._roles.map(function (role) {
                    return {
                        role: role,
                        permissions: _this._permissionsContainer.filter(function (permission) {
                            return permission.roles.find(function (r) {
                                return role.name === r.name;
                            });
                        }).map(function (permission) {
                            return permission.value;
                        })
                    };
                });

                this._Backend.put('roles/permissions/global', permissionsContainer).then(function () {
                    _this._lastSavedDate = moment().toDate();
                    _this._dirty = false;
                    _this._ConfirmLeaveService.disableConfirmation();
                });
            }
        }, {
            key: 'reset',
            value: function reset() {
                this._loadPermissions();
                this._lastSavedDate = null;
                this._dirty = false;
                this._ConfirmLeaveService.disableConfirmation();
            }
        }, {
            key: 'setDirty',
            value: function setDirty() {
                this._dirty = true;
                this._ConfirmLeaveService.requireConfirmation();
            }
        }, {
            key: '_loadPermissions',
            value: function _loadPermissions() {
                var _this2 = this;

                this._Backend.get('roles/permissions/global').then(function (resp) {
                    var rolePermissionsView = resp.data;
                    _this2._roles = rolePermissionsView.rolePermissions.map(function (rolePermission) {
                        return rolePermission.role;
                    });
                    _this2._permissionsTableColumns = [{
                        title: 'Action',
                        key: 'action'
                    }, {
                        title: 'Roles',
                        key: 'roles',
                        suggestionData: _this2._roles.map(function (role) {
                            return {
                                name: role.name,
                                type: _this2._MemberType.ROLE
                            };
                        }),
                        type: _this2._MemberType.ROLE
                    }];
                    _this2._permissionsContainer = rolePermissionsView.permissions.filter(function (permission) {
                        return _this2._displayPermissionFilter(permission);
                    }).map(function (permission) {
                        return {
                            action: _this2._displayPermissionFilter(permission).label,
                            value: permission,
                            description: _this2._displayPermissionFilter(permission).description,
                            roles: rolePermissionsView.rolePermissions.filter(function (rolePermission) {
                                return rolePermission.permissions.includes(permission);
                            }).map(function (rolePermission) {
                                return {
                                    name: rolePermission.role.name,
                                    type: _this2._MemberType.ROLE
                                };
                            })
                        };
                    });
                });
            }
        }, {
            key: 'permissionsTableColumns',
            get: function get() {
                return this._permissionsTableColumns;
            }
        }, {
            key: 'permissionsContainer',
            get: function get() {
                return this._permissionsContainer;
            }
        }, {
            key: 'lastSavedDate',
            get: function get() {
                return this._lastSavedDate;
            }
        }, {
            key: 'dirty',
            get: function get() {
                return this._dirty;
            }
        }]);
        return PermissionsController;
    }();

    PermissionsController.$inject = ['Backend', 'MemberType', 'displayPermissionFilter', 'ConfirmLeaveService'];

    angular.module('xlrelease').controller('PermissionsController', PermissionsController);
})();

/***/ }),
/* 1241 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('RolesService', ['Backend', 'MemberType', function (Backend, MemberType) {
    var _this = this;

    this.mapRolesToObject = function (rolesList) {
        return rolesList.map(function (o) {
            return {
                name: o,
                type: MemberType.ROLE
            };
        });
    };

    return {
        getRolePrincipalsList: function getRolePrincipalsList() {
            return Backend.get('roles/principals');
        },
        getRoleNames: function getRoleNames() {
            return Backend.get('roles/names');
        },

        getRoles: function getRoles() {
            return Backend.get('roles/names').then(function (values) {
                return values.data;
            }).then(_this.mapRolesToObject);
        }
    };
}]);

/***/ }),
/* 1242 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var injectParams = ['Backend', 'RolesService', 'ConfirmLeaveService'];

var TaskAccessController = function () {
    function TaskAccessController(Backend, RolesService, ConfirmLeaveService) {
        var _this = this;

        (0, _classCallCheck3.default)(this, TaskAccessController);

        this._Backend = Backend;
        this._RolesService = RolesService;
        this._ConfirmLeaveService = ConfirmLeaveService;
        this._taskAccesses = [];
        this._taskAccessesMaster = [];
        this._groupedTaskAccesses = [];
        this._RolesService.getRoleNames().then(function (roleNames) {
            _this._roleNames = roleNames.data;
        });
        this._loadTaskAccesses();
    }

    (0, _createClass3.default)(TaskAccessController, [{
        key: '_loadTaskAccesses',
        value: function _loadTaskAccesses() {
            var ctx = this;
            this._Backend.get('tasks/types-access').then(function (resp) {
                var taskAccesses = resp.data;
                ctx._groupedTaskAccesses = _.groupBy(taskAccesses, function (taskAccess) {
                    return taskAccess.taskGroup;
                });
                ctx._taskAccesses = taskAccesses;
                ctx._taskAccessesMaster = angular.copy(taskAccesses);
            });
        }
    }, {
        key: 'save',
        value: function save() {
            var ctx = this;
            ctx._Backend.put('tasks/types-access', ctx._taskAccesses).then(function () {
                ctx._loadTaskAccesses();
                ctx._lastSavedDate = moment().toDate();
                ctx._ConfirmLeaveService.disableConfirmation();
            });
        }
    }, {
        key: 'isUnchanged',
        value: function isUnchanged() {
            return angular.equals(this._taskAccesses, this._taskAccessesMaster);
        }
    }, {
        key: 'reset',
        value: function reset() {
            var _this2 = this;

            // works much faster than copying the entire object
            _.each(this._taskAccesses, function (task, i) {
                task.allowedToAll = _this2._taskAccessesMaster[i].allowedToAll;
                task.roles = angular.copy(_this2._taskAccessesMaster[i].roles);
            });

            this._ConfirmLeaveService.disableConfirmation();
        }
    }, {
        key: 'onCheckboxAllowToAllChange',
        value: function onCheckboxAllowToAllChange(taskAccess) {
            if (taskAccess.allowedToAll) {
                taskAccess.roles = [];
            }
        }
    }, {
        key: 'groupedTaskAccesses',
        get: function get() {
            return this._groupedTaskAccesses;
        }
    }, {
        key: 'allRoles',
        get: function get() {
            return this._roleNames;
        }
    }, {
        key: 'lastSavedDate',
        get: function get() {
            return this._lastSavedDate;
        }
    }]);
    return TaskAccessController;
}();

TaskAccessController.$inject = injectParams;

angular.module('xlrelease').controller('taskAccessController', TaskAccessController);

/***/ }),
/* 1243 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('UsersController', ['$scope', 'Backend', 'Alerts', 'UsersService', 'LimitedUsers', function ($scope, Backend, Alerts, UsersService, LimitedUsers) {
    var self = this;

    function loadUsers() {
        Backend.get('users').then(function (resp) {
            self.all = resp.data;
            sanitizeUsersWithNullValues(self.all);
            LimitedUsers.setUsers(self.all);
        });
    }

    loadUsers();

    LimitedUsers.loadLicense();

    self.editNewUser = function () {
        self.newUser = true;
        self.editedUser = {
            username: '',
            email: '',
            fullName: '',
            external: false,
            password: '',
            passwordConfirmation: ''
        };
    };

    self.editUser = function (user) {
        self.newUser = false;
        self.editedUser = {
            username: user.username,
            email: user.email,
            fullName: user.fullName,
            external: user.external,
            password: '',
            passwordConfirmation: '',
            loginAllowed: user.loginAllowed
        };
    };

    self.saveUser = function (dismiss) {
        self.newUser ? createUser(dismiss) : updateUser(dismiss);
    };

    function createUser(dismiss) {
        self.conflict = false;

        var userForm = {
            username: self.editedUser.username,
            email: self.editedUser.email,
            fullName: self.editedUser.fullName,
            password: self.editedUser.password,
            loginAllowed: true
        };

        Backend.post('users', userForm, { hideAlert: true }).then(function () {
            loadUsers();
            dismiss();
        }, function (response) {
            var data = response.data,
                status = response.status,
                headers = response.headers,
                config = response.config;

            if (status === 409) {
                self.conflict = true;
            } else {
                Alerts.error({ data: data, status: status, headers: headers, config: config });
            }
        });
    }

    function updateUser(dismiss) {
        var userForm = {
            email: self.editedUser.email,
            fullName: self.editedUser.fullName,
            loginAllowed: self.editedUser.loginAllowed
        };

        if (self.editedUser.password) {
            userForm.password = self.editedUser.password;
        }

        Backend.put('users/' + encodeURIComponent(self.editedUser.username), userForm).then(function () {
            loadUsers();
            dismiss();
            delete self.editedUser.password;
        });
    }

    function sanitizeUsersWithNullValues(users) {
        users.map(function (user) {
            if (!user.lastActive) user.lastActive = 0;
            if (!user.fullName) user.fullName = '';
            if (!user.email) user.email = '';
            return user;
        });
    }

    $scope.isInternalUser = UsersService.isInternalUser;

    $scope.isUserNameAdmin = UsersService.isUserNameAdmin;

    $scope.sortColumn = null;

    $scope.sortDirection = null;

    $scope.toggleSortStyle = function () {
        return { 'xl-icon sort-asc-icon icon-s': !$scope.sortDirection, 'xl-icon sort-desc-icon icon-s': $scope.sortDirection };
    };

    $scope.sortBy = function (column) {
        $scope.sortDirection = $scope.sortColumn === column ? !$scope.sortDirection : true;
        $scope.sortColumn = column;
    };

    $scope.deleteUser = function (user) {
        Backend.del('users/' + encodeURIComponent(user.username)).then(loadUsers);
    };

    $scope.LimitedUsers = LimitedUsers;

    self.toggleLoginPermission = function (user) {
        Backend.put('users/' + encodeURIComponent(user.username), user);
    };
}]);

/***/ }),
/* 1244 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('UsersService', ['Backend', 'MemberType', function (Backend, MemberType) {
    var _this = this;

    var ADMINISTRATOR = 'admin';

    function isUserNameAdmin(user) {
        return user && user.toLowerCase() === ADMINISTRATOR;
    }

    this.mapUsersToObject = function (usersList) {
        return usersList.map(function (o) {
            return {
                name: o.username,
                fullName: o.fullName,
                type: MemberType.PRINCIPAL
            };
        });
    };

    return {
        isUserNameAdmin: isUserNameAdmin,
        isInternalUser: function isInternalUser(user) {
            return user.external === false;
        },
        getAllUsers: function getAllUsers() {
            return Backend.get('users/names');
        },

        getAllUsersAsObjects: function getAllUsersAsObjects() {
            return Backend.get('users/names').then(function (v) {
                return v.data;
            }).then(_this.mapUsersToObject);
        }

    };
}]);

/***/ }),
/* 1245 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').controller('generalSettingsController', ['$scope', 'MetadataService', 'CIManager', 'ValueStreamMapping', 'PollingSettings', 'ConfirmLeaveService', 'PhaseColors', 'Page', 'UploadService', 'ContentTypeService', function ($scope, MetadataService, CIManager, ValueStreamMapping, PollingSettings, ConfirmLeaveService, PhaseColors, Page, UploadService, ContentTypeService) {

    var _reportsSettingsCICopy = {};
    var _pollingSettingsCICopy = {};
    var _themeSettingsCICopy = {};
    var _customLogoSettingsCICopy = {};
    var _pluginCICopies = {};

    $scope.UploadService = UploadService;
    UploadService.reset();

    $scope.pluginsInitialized = false;
    $scope.pluginSettings = [{
        title: 'Track changes in template version control',
        help: 'XL Release will use these settings to enable automatic versioning of template edits. Settings will be effective after 1 minute.',
        descriptorType: 'xlrelease.TemplateVersioningSettings',
        isPresent: false,
        ciManagerSettings: {
            type: 'TemplateVersioningSettings',
            directory: 'Configuration/settings'
        }
    }];
    $scope.pluginCIs = {};
    $scope.allowedContentType = "";
    _initPluginsSettings();
    _initContentTypes();

    $scope.PhaseColors = PhaseColors;

    var _reportsSettingsSaveCallback = function _reportsSettingsSaveCallback() {
        ValueStreamMapping.refreshReportsSettings();
        _reportsSettingsCICopy = angular.copy($scope.reportsSettings.ci);
    };

    var _pollingSettingsSaveCallback = function _pollingSettingsSaveCallback() {
        PollingSettings.refresh();
        _pollingSettingsCICopy = angular.copy($scope.pollingSettings.ci);
    };

    var _themeSettingsSaveCallback = function _themeSettingsSaveCallback() {
        return _themeSettingsCICopy = angular.copy($scope.themeSettings.ci);
    };

    var _customLogoSettingsDeleteCallback = function _customLogoSettingsDeleteCallback() {
        _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
        Page.applyCustomLogo(false);
    };

    $scope.reportsSettings = new CIManager({
        type: 'ReportsSettings',
        directory: 'Configuration/reports',
        saveCallback: _reportsSettingsSaveCallback
    });

    $scope.pollingSettings = new CIManager({
        type: 'PollingSettings',
        directory: 'Configuration/settings',
        saveCallback: _pollingSettingsSaveCallback
    });

    $scope.archivingSettings = new CIManager({
        type: 'ArchivingSettings',
        directory: 'Configuration/settings'
    });

    $scope.themeSettings = new CIManager({
        type: 'ThemeSettings',
        directory: 'Configuration/settings',
        saveCallback: _themeSettingsSaveCallback
    });

    $scope.customLogoSettings = new CIManager({
        type: 'CustomLogoSettings',
        directory: 'Configuration/settings',
        deleteCallback: _customLogoSettingsDeleteCallback
    });

    $scope.archivingSettingsAge = 0;
    $scope.archivingSettingsAgeCopy = $scope.archivingSettingsAge;
    $scope.archivingSettingsAgeUnit = 'Days';

    $scope.$watch('archivingSettings.ci.releaseAgeToDeleteFromJcr', function (hours) {
        _setArchiving(hours);
    });

    $scope.setHeaderColor = function (color) {
        $scope.themeSettings.ci.headerAccentColor = color;
    };

    $scope.changeUnitType = function () {
        if ($scope.archivingSettingsAgeUnit === 'Days') {
            $scope.archivingSettingsAge = Math.round($scope.archivingSettingsAge / 24);
        } else {
            $scope.archivingSettingsAge = $scope.archivingSettingsAge * 24;
        }
    };

    function convertAgeToHours() {
        if ($scope.archivingSettingsAgeUnit === 'Days') {
            $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr = 24 * $scope.archivingSettingsAge;
        } else {
            $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr = $scope.archivingSettingsAge;
        }
    }

    $scope.save = function () {
        UploadService.reset();
        _setArchivingCI();
        $scope.reportsSettings.save();
        $scope.pollingSettings.save();
        $scope.archivingSettings.save();
        $scope.themeSettings.save();
        _savePluginSettings();

        if ($scope.file) {
            $scope.upload();
        } else if (angular.isDefined(_customLogoSettingsCICopy.filename) && angular.isUndefined($scope.customLogoSettings.ci.filename)) {
            $scope.customLogoSettings.deleteCi();
        }

        $scope.lastSavedDate = moment().toDate();
        ConfirmLeaveService.disableConfirmation();
        Page.applyTheme($scope.themeSettings.ci);
    };

    $scope.customLogoAddedCallback = function (result) {
        $scope.file = null;
        $scope.customLogoSettings.ci = result;
        _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);

        Page.applyCustomLogo(true);
    };

    $scope.isCustomLogoImageUndefined = function () {
        return angular.isUndefined($scope.customLogoSettings.ci.filename) && (angular.isUndefined($scope.file) || $scope.file === null || $scope.file === '');
    };

    $scope.getProperty = function (ciManager, propertyName) {
        if (ciManager.type) {
            return _.find(ciManager.type.properties, { name: propertyName });
        }
        return null;
    };

    $scope.reset = function () {
        $scope.reportsSettings.ci = angular.copy(_reportsSettingsCICopy);
        $scope.pollingSettings.ci = angular.copy(_pollingSettingsCICopy);
        $scope.themeSettings.ci = angular.copy(_themeSettingsCICopy);
        $scope.customLogoSettings.ci = angular.copy(_customLogoSettingsCICopy);
        $scope.file = null;
        UploadService.reset();
        _resetPluginSettings();
        _setArchiving($scope.archivingSettings.ci.releaseAgeToDeleteFromJcr);
        ConfirmLeaveService.disableConfirmation();
    };

    $scope.isUnchanged = function () {
        return angular.equals(_reportsSettingsCICopy, $scope.reportsSettings.ci) && angular.equals(_pollingSettingsCICopy, $scope.pollingSettings.ci) && angular.equals(_themeSettingsCICopy, $scope.themeSettings.ci) && angular.equals(_customLogoSettingsCICopy, $scope.customLogoSettings.ci) && (angular.isUndefined($scope.file) || $scope.file === null || $scope.file === "") && _isPluginSettingsUnchanged() && angular.equals($scope.archivingSettingsAgeCopy, $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr);
    };

    $scope.removeLoadedImage = function () {
        UploadService.reset();
        $scope.customLogoSettings.ci = {};
        $scope.file = null;
    };

    $scope.$watch('reportsSettings.ciLoaded', function (newVal) {
        if (newVal) {
            _reportsSettingsCICopy = angular.copy($scope.reportsSettings.ci);
        }
    });

    $scope.$watch('pollingSettings.ciLoaded', function (newVal) {
        if (newVal) {
            _pollingSettingsCICopy = angular.copy($scope.pollingSettings.ci);
        }
    });

    $scope.$watch('themeSettings.ciLoaded', function (newVal) {
        if (newVal) {
            _themeSettingsCICopy = angular.copy($scope.themeSettings.ci);
        }
    });

    $scope.$watch('customLogoSettings.ciLoaded', function (newVal) {
        if (newVal) {
            _customLogoSettingsCICopy = angular.copy($scope.customLogoSettings.ci);
        }
    });

    $scope.$watch('archivingSettingsAge', function (newVal) {
        $scope.archivingSettingsAgeCopy = _convertAgeToHours(newVal, $scope.archivingSettingsAgeUnit);
    });

    var _setArchivingCI = function _setArchivingCI() {
        $scope.archivingSettings.ci.releaseAgeToDeleteFromJcr = _convertAgeToHours($scope.archivingSettingsAge, $scope.archivingSettingsAgeUnit);
    };

    var _convertAgeToHours = function _convertAgeToHours(archivingSettingsAge, archivingSettingsAgeUnit) {
        if (archivingSettingsAgeUnit === 'Days') {
            return archivingSettingsAge * 24;
        }
        return archivingSettingsAge;
    };

    var _setArchiving = function _setArchiving(hours) {
        if (!_.isUndefined(hours)) {
            if (hours % 24 === 0) {
                $scope.archivingSettingsAgeUnit = 'Days';
                $scope.archivingSettingsAge = hours / 24;
            } else {
                $scope.archivingSettingsAgeUnit = 'Hours';
                $scope.archivingSettingsAge = hours;
            }
        }
    };

    function _initPluginsSettings() {
        $scope.pluginSettings.forEach(function (plugin) {
            MetadataService.isTypePresent(plugin.descriptorType).then(function (isPresent) {
                if (isPresent) {
                    plugin.isPresent = isPresent;
                    $scope.pluginCIs[plugin.descriptorType] = new CIManager((0, _extends3.default)({
                        saveCallback: function saveCallback() {
                            return _pluginCICopies[plugin.descriptorType] = angular.copy($scope.pluginCIs[plugin.descriptorType].ci);
                        },
                        loadCallback: function loadCallback(ci) {
                            _pluginCICopies[plugin.descriptorType] = angular.copy(ci);
                        }
                    }, plugin.ciManagerSettings));
                }
            });
        });
    }

    function _savePluginSettings() {
        $scope.pluginSettings.filter(function (plugin) {
            return plugin.isPresent;
        }).forEach(function (plugin) {
            $scope.pluginCIs[plugin.descriptorType].save();
        });
    }

    function _resetPluginSettings() {
        $scope.pluginSettings.filter(function (plugin) {
            return plugin.isPresent;
        }).forEach(function (plugin) {
            $scope.pluginCIs[plugin.descriptorType].ci = angular.copy(_pluginCICopies[plugin.descriptorType]);
        });
    }

    function _isPluginSettingsUnchanged() {
        return $scope.pluginSettings.filter(function (plugin) {
            return plugin.isPresent;
        }).every(function (plugin) {
            return angular.equals(_pluginCICopies[plugin.descriptorType], $scope.pluginCIs[plugin.descriptorType].ci);
        });
    }

    function _initContentTypes() {
        ContentTypeService.getContentTypesForImage().then(function (resp) {
            $scope.allowedContentType = resp.data.toString();
        });
    }
}]);

/***/ }),
/* 1246 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _toastrFactory = __webpack_require__(74);

var _toastrFactory2 = _interopRequireDefault(_toastrFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').controller('SmtpController', ['$scope', '$parse', 'Backend', 'CIManager', 'UserProfile', 'ConfirmLeaveService', function ($scope, $parse, Backend, CIManager, UserProfile, ConfirmLeaveService) {

    var init = function init() {
        var ciManager = new CIManager({
            type: 'SmtpServer',
            directory: 'Configuration/mail',
            saveCallback: function saveCallback() {
                return ConfirmLeaveService.disableConfirmation();
            } });

        if (!ciManager.ci.testAddress) {
            UserProfile.load().then(function (profile) {
                ciManager.ci.testAddress = profile.email;
            });
        }
        return ciManager;
    };

    $scope.smtp = init();

    var toaster = (0, _toastrFactory2.default)();

    $scope.testConfiguration = function () {
        $scope.isBusy = true;
        $scope.smtp.ci.type = 'xlrelease.SmtpServer';
        $scope.smtp.ci.id = 'Configuration/mail/SmtpServer';
        var URL = 'settings/smtp/checkConfig';
        Backend.post(URL, $scope.smtp.ci).then(function (resp) {
            if (resp) {
                toaster.success("Successfully sent the notification");
            }
        }).finally(function () {
            $scope.isBusy = false;
        });
    };

    $scope.invalidTestAddress = function (testAddress) {
        if (testAddress) {
            return testAddress.length === 0;
        } else return true;
    };
}]);

/***/ }),
/* 1247 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _dslTemplateController = __webpack_require__(1248);

var _dslTemplateController2 = _interopRequireDefault(_dslTemplateController);

var _dslTpl = __webpack_require__(1249);

var _dslTpl2 = _interopRequireDefault(_dslTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').config(['$urlMatcherFactoryProvider', '$stateProvider', '$urlRouterProvider', function ($urlMatcherFactoryProvider, $stateProvider, $urlRouterProvider) {

    // add this to have "pretty" URLs, by default UI Router encodes '/' to '~2F'
    $urlMatcherFactoryProvider.type('RiskProfileId', {
        raw: true
    });

    // see https://stackoverflow.com/questions/29892353/angular-ui-router-resolve-state-from-url/30926025#30926025
    $stateProvider.decorator('parent', function (internalStateObj, parentFn) {
        internalStateObj.self.$$state = function () {
            return internalStateObj;
        };
        return parentFn(internalStateObj);
    });

    $stateProvider.state('login', {
        url: '/login?reloadUserDetails',
        templateUrl: 'partials/login/login.html',
        controller: 'LoginController',
        resolve: {
            auth: ['Backend', 'Authenticator', '$stateParams', 'ClientSettings', function (Backend, Authenticator, $stateParams, ClientSettings) {
                if (Authenticator.isAuthenticated() && !$stateParams.reloadUserDetails) {
                    // FIXME: Tech debt from LoginController: should always call logout.
                    return Authenticator.logout();
                }
                delete $stateParams.reloadUserDetails;

                return Authenticator.tryLoginByIdentityProvider().then(function () {
                    if (!ClientSettings.getIdentityProvider()) {
                        return Authenticator.logout();
                    }
                });
            }]
        }
    }).state('tasks', {
        url: '/tasks',
        reloadOnSearch: false,
        templateUrl: 'partials/tasks/tasks.html',
        controller: 'TasksController',
        resolve: {
            filterSettings: ['Filters', function (Filters) {
                return Filters.getTasksFilterSettings();
            }],
            orderByValues: function orderByValues() {
                return [{
                    label: 'Task start date',
                    orderBy: 'start_date'
                }, {
                    label: 'Task end date',
                    orderBy: 'end_date'
                }];
            }
        }
    }).state('task', {
        url: '/tasks/:taskId?showDetails',
        templateUrl: 'partials/tasks/task.html',
        controller: 'TaskController'
    }).state('releaseCreate', {
        url: '/releases/create?fromTemplateId',
        template: '<release-properties release="$resolve.release"></release-properties>',
        resolve: {
            release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                if ($stateParams.fromTemplateId) {
                    return ReleasesService.initNewReleaseFromTemplate($stateParams.fromTemplateId);
                } else {
                    return ReleasesService.initNewRelease();
                }
            }]
        }
    }).state('release', {
        url: '/releases/:releaseId',
        templateUrl: 'partials/releases/release-editor.html',
        controller: 'releaseEditorController',
        resolve: {
            release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }]
        }
    }).state('releasePlanner', {
        url: '/releases/:releaseId/planner',
        templateUrl: 'partials/releases/gantt/gantt.html',
        controller: 'GanttController',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId);
            }]
        }
    }).state('releaseTable', {
        url: '/releases/:releaseId/table',
        templateUrl: 'partials/releases/grid/release-grid.html',
        controller: 'releaseGridController',
        controllerAs: 'pageCtrl',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId);
            }]
        }
    }).state('releasePermissions', {
        url: '/{page:releases|templates}/:releaseId/{optional:permissions|teams}',
        templateUrl: 'partials/releases/release-permissions.html',
        controller: 'releasePermissionsController',
        controllerAs: '$ctrl',
        resolve: {
            release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }],
            teams: ['$stateParams', 'TeamsService', function ($stateParams, TeamsService) {
                return TeamsService.getTeams($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }],
            users: ['UsersService', function (UsersService) {
                return UsersService.getAllUsersAsObjects();
            }],
            roles: ['RolesService', function (RolesService) {
                return RolesService.getRoles();
            }]
        }
    }).state('releaseProperties', {
        url: '/releases/:releaseId/properties',
        template: '<release-properties release="$resolve.release"></release-properties>',
        resolve: {
            release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithVariables($stateParams.releaseId);
            }]
        }
    }).state('releaseVariables', {
        url: '/releases/:releaseId/variables',
        templateUrl: 'partials/releases/release-variables.html',
        controller: 'releaseVariablesController',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId);
            }]
        }
    }).state('releasePageExtension', {
        url: '/releases/:releaseId/:extensionPath',
        templateUrl: 'partials/releases/release-page-extension-container.html',
        controller: 'releasePageExtensionController',
        controllerAs: 'releasePageExtensionCtrl',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
            }]
        }
    }).state('templates', {
        url: '/templates',
        reloadOnSearch: false,
        templateUrl: 'partials/templates/templates.html',
        controller: 'TemplatesController',
        resolve: {
            filters: ['Filters', function (Filters) {
                return Filters.getTemplatesFilterSettings();
            }]
        }
    }).state('templateCreate', {
        url: '/templates/create',
        template: '<template-properties template="$resolve.template"></template-properties>',
        resolve: {
            template: ['ReleasesService', function (ReleasesService) {
                return ReleasesService.initNewTemplate();
            }]
        }
    }).state('template', {
        url: '/templates/:releaseId',
        templateUrl: 'partials/releases/release-editor.html',
        controller: 'releaseEditorController',
        resolve: {
            release: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }]
        }
    }).state('templateTable', {
        url: '/templates/:releaseId/table',
        templateUrl: 'partials/releases/grid/release-grid.html',
        controller: 'releaseGridController',
        controllerAs: 'pageCtrl',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId);
            }]
        }
    }).state('templateProperties', {
        url: '/templates/:releaseId/properties',
        template: '<template-properties template="$resolve.template"></template-properties>',
        resolve: {
            template: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithVariables($stateParams.releaseId);
            }]
        }
    }).state('templateVariables', {
        url: '/templates/:releaseId/variables',
        templateUrl: 'partials/releases/release-variables.html',
        controller: 'releaseVariablesController',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId);
            }]
        }
    }).state('templateTriggers', {
        url: '/templates/:releaseId/triggers',
        templateUrl: 'partials/templates/template-triggers.html',
        controller: 'templateTriggersController',
        controllerAs: '$ctrl',
        resolve: {
            template: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }]
        }
    }).state('templateTriggersCreate', {
        url: '/templates/:releaseId/triggers/new/:triggerType',
        templateUrl: 'partials/templates/template-edit-trigger.html',
        controller: 'templateEditTriggerController',
        controllerAs: '$ctrl',
        resolve: {
            template: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }]
        }
    }).state('templateTriggersEdit', {
        url: '/templates/:releaseId/triggers/edit/:triggerId',
        templateUrl: 'partials/templates/template-edit-trigger.html',
        controller: 'templateEditTriggerController',
        controllerAs: '$ctrl',
        resolve: {
            template: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId).then(function (response) {
                    return response.data;
                });
            }]
        }
    }).state('templatePlanner', {
        url: '/templates/:releaseId/planner',
        templateUrl: 'partials/releases/gantt/gantt.html',
        controller: 'GanttController',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId);
            }]
        }
    }).state('templateDsl', {
        url: '/templates/:releaseId/releasefile?renderAsTemplate',
        params: {
            renderAsTemplate: "false"
        },
        controller: _dslTemplateController2.default,
        controllerAs: '$ctrl',
        template: _dslTpl2.default,
        resolve: {
            renderAsTemplate: ['$stateParams', function ($stateParams) {
                return $stateParams.renderAsTemplate === "true";
            }],
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getRelease($stateParams.releaseId);
            }]
        }
    }).state('templatePageExtension', {
        url: '/templates/:releaseId/:extensionPath',
        templateUrl: 'partials/releases/release-page-extension-container.html',
        controller: 'releasePageExtensionController',
        controllerAs: 'releasePageExtensionCtrl',
        resolve: {
            releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
                return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
            }]
        }
    }).state('profile', {
        url: '/profile',
        templateUrl: 'partials/profile/profile.html',
        controller: 'ProfileController',
        controllerAs: '$ctrl'
    }).state('users', {
        url: '/users',
        templateUrl: 'partials/security/users.html',
        controller: 'UsersController',
        controllerAs: 'users'
    }).state('permissions', {
        url: '/permissions',
        templateUrl: 'partials/security/permissions.html',
        controller: 'PermissionsController',
        controllerAs: '$ctrl'
    }).state('taskAccess', {
        url: '/task-access',
        templateUrl: 'partials/security/task-access.html',
        controller: 'taskAccessController',
        controllerAs: '$pageCtrl'
    }).state('generalSettings', {
        url: '/general-settings',
        templateUrl: 'partials/settings/general-settings.html',
        controller: 'generalSettingsController'
    }).state('globalVariables', {
        url: '/global-variables',
        templateUrl: 'partials/variables/global-variables.html',
        controller: 'globalVariablesController'
    }).state('calendar', {
        url: '/calendar',
        reloadOnSearch: false,
        templateUrl: 'partials/calendar/calendar.html',
        controller: 'CalendarController',
        resolve: {
            filterSettings: ['Filters', function (Filters) {
                return Filters.getCalendarFilterSettings();
            }],
            month: ['CalendarResolver', function (CalendarResolver) {
                return CalendarResolver.initCurrentMonth();
            }]
        }
    }).state('reports', {
        url: '/reports',
        reloadOnSearch: false,
        templateUrl: 'partials/reports/dashboard.html',
        controller: 'ReportsController',
        resolve: {
            filterSettings: ['Filters', function (Filters) {
                return Filters.getReportsFiltersSettings();
            }]
        }
    }).state('releaseValueStream', {
        url: '/release-value-stream',
        reloadOnSearch: false,
        templateUrl: 'partials/value-stream-mapping/release-value-stream.html',
        controller: 'releaseValueStreamController',
        resolve: {
            filterSettings: ['Filters', function (Filters) {
                return Filters.getReleaseValueStreamFilterSettings();
            }]
        }
    }).state('smtp', {
        url: '/smtp',
        templateUrl: 'partials/smtp/smtp.html',
        controller: 'SmtpController'
    }).state('riskSettings', {
        url: '/risks',
        params: { edit: null },
        templateUrl: 'partials/risks/risk-settings.html',
        controller: 'riskSettingsController',
        controllerAs: 'ctrl'
    }).state('riskProfile', {
        url: '/risks/riskProfile/{riskProfileId:RiskProfileId}',
        templateUrl: 'partials/risks/risk-profile/risk-profile.html',
        controller: 'riskProfileController',
        controllerAs: 'ctrl'
    }).state('configuration', {
        url: '/configuration',
        templateUrl: 'partials/configuration/configuration.html'
    }).state('forbiddenAccess', {
        url: '/forbidden-access',
        templateUrl: 'partials/server-error/forbidden-access.html',
        controller: 'forbiddenAccessController'
    }).state('invalidLicense', {
        url: '/invalid-license',
        templateUrl: 'partials/licenses/invalid-license.html',
        controller: 'LicenseController'
    }).state('default', {
        url: '/default',
        template: '<div></div>',
        controller: 'defaultRouteController'
    }).state('mainMenuExtensions', {
        templateUrl: 'partials/index/main-menu-extension-container.html',
        controller: 'mainMenuExtensionController',
        controllerAs: 'vm'
    });

    $urlRouterProvider.when(/(^$|\/$)/, '/default').otherwise(function ($injector) {
        var $state = $injector.get('$state');
        $state.go('mainMenuExtensions', {}, { location: false, reload: true });
    });
}]).run(['$rootScope', '$state', 'Authenticator', function ($rootScope, $state, Authenticator) {
    $rootScope.$on('$stateChangeError', function (event, toState, toParams, fromState) {
        if (fromState && fromState.name === 'login') {
            $state.go('releaseOverview');
        }
    });

    $rootScope.$on('$stateChangeStart', function (event, toState) {
        if (toState && !['login', 'default'].includes(toState.name) && !Authenticator.isAuthenticated()) {
            return Authenticator.loadUserDetailsByAuth();
        }
    });
}]);

/***/ }),
/* 1248 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _copyTextToClipboard = __webpack_require__(708);

var _copyTextToClipboard2 = _interopRequireDefault(_copyTextToClipboard);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DslTemplateController = function () {
    function DslTemplateController(Page, releasePromise, Backend, Ids, Download, Toastr, renderAsTemplate) {
        (0, _classCallCheck3.default)(this, DslTemplateController);

        this.release = releasePromise.data;
        this.Ids = Ids;
        this.Backend = Backend;
        this.Download = Download;
        this.Toastr = Toastr;
        this.templateDsl = "";
        this.renderAsTemplate = renderAsTemplate;
        Page.setReleaseOpened(this.release);
    }

    (0, _createClass3.default)(DslTemplateController, [{
        key: "$onInit",
        value: function $onInit() {
            this.loadDsl();
        }
    }, {
        key: "loadDsl",
        value: function loadDsl() {
            var _this = this;

            this.Backend.get(this.getExportUrl(true, this.renderAsTemplate)).then(function (response) {
                return _this.templateDsl = response.data;
            });
        }
    }, {
        key: "exportDsl",
        value: function exportDsl() {
            this.Download.launch(this.getExportUrl(false, true));
        }
    }, {
        key: "getExportUrl",
        value: function getExportUrl() {
            var preview = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
            var renderAsTemplate = arguments[1];

            return "api/v1/dsl" + (preview ? '/preview' : '/export') + "/" + this.Ids.toDomainId(this.release.id) + "?exportTemplate=" + renderAsTemplate;
        }
    }, {
        key: "copyDsl",
        value: function copyDsl() {
            (0, _copyTextToClipboard2.default)(this.templateDsl);
            this.Toastr.success('Releasefile was copied to the clipboard!', { preventDuplicates: true });
        }
    }]);
    return DslTemplateController;
}();

exports.default = DslTemplateController;


DslTemplateController.$inject = ['Page', 'releasePromise', 'Backend', 'Ids', 'Download', 'Toastr', 'renderAsTemplate'];

/***/ }),
/* 1249 */
/***/ (function(module, exports) {

module.exports = "<div release-flow-header>\n    <div class=\"buttons\">\n        <a ng-click=\"$ctrl.exportDsl()\" class=\"button\">Export</a>\n        <span doc-icon=\"xfile.html\"></span>\n    </div>\n</div>\n<div class=\"content-under-header\">\n    <div class=\"form-horizontal\">\n        <div class=\"form-group\">\n            <div class=\"col-sm-6\">\n                <label class=\"radio-inline\" style=\"padding-left: 0\">\n                    Generate as:\n                </label>\n                <label class=\"radio-inline\">\n                    <input type=\"radio\" ng-value=\"true\" ng-model=\"$ctrl.renderAsTemplate\" ng-change=\"$ctrl.loadDsl()\">Template\n                </label>\n                <label class=\"radio-inline\">\n                    <input type=\"radio\" ng-value=\"false\" ng-model=\"$ctrl.renderAsTemplate\" ng-change=\"$ctrl.loadDsl()\">Release\n                </label>\n            </div>\n            <div class=\"col-sm-6\">\n                <a ng-click=\"$ctrl.copyDsl()\" class=\"button btn-copy pull-right\">\n                    <i class=\"menu-item-icon copy-icon\"></i> Copy to clipboard\n                </a>\n            </div>\n        </div>\n    </div>\n\n    <div id=\"dsl-content\" ng-if=\"$ctrl.templateDsl\" hljs hljs-source=\"$ctrl.templateDsl\" hljs-language=\"groovy\"></div>\n</div>\n"

/***/ }),
/* 1250 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TagsService = function () {
    function TagsService(Backend) {
        (0, _classCallCheck3.default)(this, TagsService);

        this._Backend = Backend;
    }

    (0, _createClass3.default)(TagsService, [{
        key: 'getReleaseTags',
        value: function getReleaseTags() {
            return this._Backend.get('releases/tags').then(function (response) {
                return response.data;
            });
        }
    }, {
        key: 'getArchivedReleaseTags',
        value: function getArchivedReleaseTags() {
            return this._Backend.get('releases/tags/archived').then(function (response) {
                return response.data;
            });
        }
    }]);
    return TagsService;
}();

TagsService.$inject = ['Backend'];

angular.module('xlrelease').service('TagsService', TagsService);

/***/ }),
/* 1251 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('assignee', ['UserProfile', function (UserProfile) {
    return {
        templateUrl: "partials/tasks/assignee.html",
        scope: {
            owner: '=',
            team: '=',
            variables: '='
        },
        link: function link(scope) {
            scope.loggedUser = UserProfile.getCurrentUser();
        }
    };
}]);

/***/ }),
/* 1252 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.FacetFormComponent = undefined;

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FacetFormController = function () {
    function FacetFormController() {
        (0, _classCallCheck3.default)(this, FacetFormController);
    }

    (0, _createClass3.default)(FacetFormController, [{
        key: '$onInit',
        value: function $onInit() {
            this.facetTemplateUrl = '';
            this.selectedType = null;
            if (!this.facet) {
                this.facet = {};
            } else {
                this.selectedType = this.facet.type;
                this._fetchFacetProperties();
            }
            this.facetTypeNames = this.facetTypes.map(function (t) {
                return {
                    id: t.type,
                    title: t.label
                };
            });
        }
    }, {
        key: 'onFacetTypeChange',
        value: function onFacetTypeChange() {
            if (this.readonly) {
                return;
            }
            this.facet = {
                id: this.facet.id,
                targetId: this.facet.targetId
            };

            this._fetchFacetProperties();
        }
    }, {
        key: '_fetchFacetProperties',
        value: function _fetchFacetProperties() {
            var _this = this;

            var facetType = this.facetTypes.find(function (t) {
                return t.type === _this.selectedType;
            });
            this.facet.type = this.selectedType;
            this.facetSelected = facetType.properties.filter(function (prop) {
                return prop.name === 'configurationUri';
            })[0];
            this.facetTemplateUrl = 'static/8.6.1/' + this.facetSelected.default;
        }
    }, {
        key: 'onFormSubmit',
        value: function onFormSubmit() {
            if (this.readonly) {
                return;
            }
            if (!this.facet.id) {
                this.facet.id = '-1';
            }
            this.onSubmit({
                facet: (0, _extends3.default)({}, this.facet)
            });
        }
    }]);
    return FacetFormController;
}();

var FacetFormComponent = exports.FacetFormComponent = {
    bindings: {
        facet: '<',
        facetTypes: '<',
        onCancel: '&',
        onSubmit: '&',
        readonly: '<',
        variables: '<',
        resolvedVariables: '<',
        onNewVariable: '&'
    },
    controller: FacetFormController,
    templateUrl: 'partials/tasks/details/component/facet-form-component.html'
};

angular.module('xlrelease').component('facetForm', FacetFormComponent);

/***/ }),
/* 1253 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TaskIconComponent = undefined;

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var template = '\n    <!--Core tasks-->\n    <i ng-if="$ctrl.TasksService.isUserInputTask($ctrl.task)" class="xl-icon keyboard-icon" title="User Input"></i>\n    <i ng-if="$ctrl.TasksService.isNotificationTask($ctrl.task)" class="xl-icon mail-icon" title="Notification"></i>\n    <i ng-if="$ctrl.TasksService.isScriptTask($ctrl.task)" class="xl-icon script-icon" title="Script"></i>\n    <i ng-if="$ctrl.TasksService.isGateTask($ctrl.task)" class="xl-icon check-icon" title="Gate"></i>\n    <i ng-if="$ctrl.TasksService.isParallelGroup($ctrl.task)" class="xl-icon parallel-icon" title="Parallel Group"></i>\n    <i ng-if="$ctrl.TasksService.isSequentialGroup($ctrl.task)" class="xl-icon sequential-icon" title="Sequential Group"></i>\n    <i ng-if="$ctrl.TasksService.isCreateReleaseTask($ctrl.task)" class="xl-icon add-icon" title="Create Release"></i>\n    \n    <!--Manual task-->\n    <i ng-if="$ctrl.TasksService.isManualTask($ctrl.task) && $ctrl.taskOwner" class="xl-icon user-icon" title="Manual"></i>\n    <i ng-if="$ctrl.TasksService.isManualTask($ctrl.task) && !$ctrl.taskOwner" class="xl-icon users-icon" title="Manual"></i>\n    \n    <!--Custom script tasks-->\n    <i ng-if="$ctrl.TasksService.isCustomScriptTask($ctrl.task) && !$ctrl.task.customIconLocation" class="xl-icon script-icon"></i>\n    <i ng-if="$ctrl.TasksService.isCustomScriptTask($ctrl.task) && $ctrl.task.customIconLocation" class="custom-script-image">\n        <img ng-src="static/8.6.1/{{ $ctrl.task.customIconLocation }}">\n    </i>\n';

var TaskIconController = function () {
    function TaskIconController(TasksService) {
        (0, _classCallCheck3.default)(this, TaskIconController);

        this.TasksService = TasksService;
    }

    (0, _createClass3.default)(TaskIconController, [{
        key: '$onInit',
        value: function $onInit() {
            this.task = {
                type: this.taskType,
                taskOwner: this.taskOwner,
                customIconLocation: this.customIconLocation
            };
        }
    }]);
    return TaskIconController;
}();

TaskIconController.$inject = ['TasksService'];
var TaskIconComponent = exports.TaskIconComponent = {
    bindings: {
        taskType: '<',
        taskOwner: '<',
        customIconLocation: '<'
    },
    controller: TaskIconController,
    template: template
};

angular.module('xlrelease').component('taskIcon', TaskIconComponent);

/***/ }),
/* 1254 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {

    var DEFAULT_RISK_PROFILE_ID = "Configuration/riskProfiles/RiskProfileDefault";
    var CHANGE_TEMPLATE_MSGS = {
        default: 'Are you sure you want to change the template to "${targetTemplate}"?',
        noPermission: 'You do not have the permissions required to revert this change. Are you sure you want to select "${targetTemplate}"?',
        variableChanged: 'Template variables have been changed. Are you sure you want to select "${targetTemplate}"?',
        blank: 'Are you sure you want to remove this template from the task?',
        blankVarChanged: 'Template variables have been changed. Are you sure you want to remove this template from the task?',
        both: 'Template variables have been changed and reverting this template will not be possible. Are you sure you want to select "${targetTemplate}"?'
    };
    // TODO: check text
    var CHANGE_FOLDER_MSGS = {
        default: 'Are you sure you want to change the folder to "${targetFolderTitle}"?',
        noPermission: "You won't be able to select the previously selected folder again since you lack permissions"
    };

    var CreateReleaseDetailsController = function () {
        function CreateReleaseDetailsController($scope, $q, $timeout, TemplatesService, Backend, VariablesService, TasksService, FoldersService, Ids) {
            var _this = this;

            (0, _classCallCheck3.default)(this, CreateReleaseDetailsController);

            this.updateSelectedFolder = function (folder) {
                if (_this._selectedFolder.id) {
                    var selected = _this._findFolderById(folder.selectedId, _this._folders, 1000);
                    if (selected) {
                        _this._newSelectedFolder = selected;
                        _this._showFolderConfirmation = true;
                        _this.$scope.$apply(function () {
                            return _this._showFolderConfirmation;
                        });
                    }
                } else {
                    _this._selectedFolder = _this._findFolderById(folder.selectedId, _this._folders, 1000);
                    _this.folderId = _this._selectedFolder.id;
                    _this.$scope.$apply(function () {
                        return _this.folderId;
                    });
                }
            };

            this._propertiesWithVars = ['templateVariables[]', 'startRelease'];
            this.$scope = $scope;
            this.TemplatesService = TemplatesService;
            this.Backend = Backend;
            this.VariablesService = VariablesService;
            this.TasksService = TasksService;
            this.$q = $q;
            this.$timeout = $timeout;
            this.FoldersService = FoldersService;
            this.Ids = Ids;
            this._templates = [];
            this._riskProfiles = [];
            this._folders = [];
            // prevent tree-select component from rendering until this._folders is actually populated
            this.foldersReady = false;

            this._release = $scope.release;
            this._task = $scope.task;
            if (!this._task.releaseTags) {
                this._task.releaseTags = [];
            }
        }

        (0, _createClass3.default)(CreateReleaseDetailsController, [{
            key: '$onInit',
            value: function $onInit() {
                var _this2 = this;

                this._readOnly = this.TasksService.areTaskPropertiesReadonly(this._release, this._task);

                this._selectedTemplateHasPermission = true;
                this._variableChanged = false;
                this._showTemplateConfirmation = false;
                this.hiddenVariables = false;

                this.templateVariables = [];
                this.$scope.$watchCollection(function () {
                    return _this2.$scope.allVariables;
                }, function (newVal) {
                    if (newVal) {
                        _this2.templateVariables = newVal.filter(function (v) {
                            return !v.key.startsWith('release.');
                        });
                    }
                });

                this._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.default;
                this._changeFolderConfirmationMsg = CHANGE_FOLDER_MSGS.default;

                this._selectedFolder = {
                    id: this._task.folderId,
                    title: this._task.folderId ? this.Ids.getName(this._task.folderId) : "",
                    enabled: false
                };
                this._newSelectedFolder = undefined;
                this._showFolderConfirmation = false;

                this._expandTask(this._task);

                var isVariableSelected = this.VariablesService.containsOnlyVariable(this._task.templateId);
                this._fetchTemplates().then(function () {
                    _this2._selectedTemplate = {
                        variable: undefined,
                        value: undefined
                    };
                    if (isVariableSelected) {
                        _this2.setTemplateIdAsVariable(_this2._task.templateId, _this2._task.variables);
                    } else {
                        _this2._selectedTemplate.value = _.find(_this2._templates, { id: _this2._task.templateId }) || _.find(_this2._templates, function (t) {
                            return t.id.endsWith(_this2._task.templateId);
                        }) || { id: _this2._task.templateId, title: _this2.Ids.getName(_this2.Ids.toDomainId(_this2._task.templateId)) };
                    }
                });
                this._fetchRiskProfiles().then(function () {
                    var profile = _this2._getSelectedRiskProfile(_this2._riskProfiles);
                    _this2._selectedRiskProfile = profile;
                    _this2._task.riskProfileId = profile && profile.id;
                });
                if (!this._readOnly && !isVariableSelected) {
                    this._fetchTemplateVariables(this._task.templateId).then(function (vars) {
                        if (vars) {
                            _this2._processVariables(vars);
                            _this2._originalVariables = _.cloneDeep(vars);
                        }
                    });
                }
                this._createListHandlers();

                var stubFolder = function stubFolder(folderName) {
                    return { id: folderName, title: folderName, type: 'xlrelease.Folder', children: [], stub: true, enabled: false };
                };

                var stubFolderTree = function stubFolderTree(path) {
                    if (path && path.length > 0) {
                        var root = _.head(path);
                        if (root.stub && root.stub === true) {
                            root.id = 'Applications/' + root.id;
                        }
                        var curr = root;
                        _.forEach(_.tail(path), function (segment) {
                            if (curr.stub && curr.stub === true) {
                                segment.id = curr.id + '/' + segment.id;
                            }
                            if (curr.stub && curr.stub === true || segment.stub && segment.stub === true) {
                                curr.children.push(segment);
                            }
                            curr = segment;
                        });
                        return root;
                    } else {
                        return undefined;
                    }
                };

                // preparing a stub structure from the task.folderId populated with fake folders
                this._path = _.map(this._task.folderId ? this.Ids.noApplications(this._task.folderId).split('/') : [], function (folderName) {
                    return stubFolder(folderName);
                });

                // combine folder tree from server with our stub path
                var resolvePath = function resolvePath(folder) {
                    var depth = _this2.Ids.folderDepth(folder.id);
                    // if it might fall into the depth of our task.folderId path...
                    if (_this2._path.length >= depth) {
                        var segment = _this2._path[depth];
                        // and it matches one of our stub segment...
                        if (segment && segment.id === _this2.Ids.getName(folder.id)) {
                            // update the stub with the real thing.
                            _this2._path[depth] = folder;
                            _.forEach(folder.children, function (child) {
                                return resolvePath(child);
                            });
                            return depth === 0;
                        }
                    }
                    return false;
                };

                // fetch all the folders this user can see from the server.
                // Note that this set might be very different for each user and especially for the script user of this release.
                this.FoldersService.list().then(function (result) {
                    var foundFirstLevelFolder = false;
                    var folders = [];
                    _.forEach(result.data, function (folder) {
                        // try to see if one of the folders is part of the task.folderId path...
                        foundFirstLevelFolder = resolvePath(folder) || foundFirstLevelFolder;
                        folders.push(folder);
                    });
                    // still missing some part of the full path?
                    if (_.filter(_this2._path, function (p) {
                        return p.stub === true;
                    }).length > 0) {
                        var root = stubFolderTree(_this2._path);
                        if (!foundFirstLevelFolder) {
                            // ah, the selected folder is inside a first level folder we cannot see!
                            if (root) {
                                // let's add the stub-mixed-with-the-real-thing to the list of folders...
                                folders.push(root);
                            }
                        }
                    }
                    if (_this2._task.folderId) {
                        _this2._selectedFolder = _this2._findFolderById(_this2._task.folderId, folders, 1000);
                    }
                    _this2._folders = folders;
                    _this2.foldersReady = true;

                    _this2._fetchFolder();
                });
            }
        }, {
            key: '_fetchTemplates',
            value: function _fetchTemplates() {
                var _this3 = this;

                return this.TemplatesService.getAllIds().then(function (templates) {
                    return _this3._templates = _.filter(templates.data.cis, function (template) {
                        return template.id !== _this3.release.id;
                    });
                });
            }
        }, {
            key: '_fixTaskFolder',
            value: function _fixTaskFolder() {
                var _this4 = this;

                var parentFolder = this.Ids.getParentFolderIdFrom(this._task.id);
                if (parentFolder) {
                    var folderId = 'Applications/' + this.Ids.getName(parentFolder);
                    this.FoldersService.get(folderId).then(function (folder) {
                        if (_this4._selectedFolder) {
                            _this4._selectedFolder.enabled = true;
                        } else {
                            _this4._selectedFolder = folder;
                        }
                        _this4.folderTitle = folder.title;
                        _this4.folderId = folder.id;
                    });
                }
            }
        }, {
            key: '_fetchFolder',
            value: function _fetchFolder() {
                var _this5 = this;

                if (this._task.folderId) {
                    this.FoldersService.getSilent(this._task.folderId).then(function (folder) {
                        if (_this5.folderId !== folder.id) {
                            _this5._selectedFolder.enabled = folder.enabled;
                            _this5.folderTitle = folder.title;
                            _this5.folderId = folder.id;
                        }
                    }).catch(function (err) {
                        // for 403 'forbidden', we should keep the original folderId as it was likely set by someone else
                        if (err.status === 404 && !_this5._release.archived) {
                            _this5._fixTaskFolder();
                        } else {
                            if (_this5._selectedFolder) {
                                _this5._selectedFolder.enabled = false;
                            } else {
                                _this5._selectedFolder = {
                                    id: _this5._task.folderId,
                                    title: _this5.Ids.getName(_this5._task.folderId),
                                    enabled: false
                                };
                            }
                        }
                    });
                } else {
                    this._fixTaskFolder();
                }
            }
        }, {
            key: '_findFolderById',
            value: function _findFolderById(folderId, folders, maxDepth) {
                if (maxDepth <= 0) {
                    return undefined;
                }
                var found = _.find(folders, function (folder) {
                    return folder.id === folderId;
                });
                if (!found) {
                    var allTheChildren = _.flatMap(folders, function (folder) {
                        return folder.children;
                    });
                    return this._findFolderById(folderId, allTheChildren, maxDepth - 1);
                } else {
                    return found;
                }
            }
        }, {
            key: '_fetchRiskProfiles',
            value: function _fetchRiskProfiles() {
                var _this6 = this;

                return this.Backend.get('api/v1/risks/profiles').then(function (response) {
                    return _this6._riskProfiles = response.data;
                });
            }
        }, {
            key: '_fetchTemplateVariables',
            value: function _fetchTemplateVariables(templateId) {
                var _this7 = this;

                if (templateId) {
                    return this.VariablesService.getReleaseVariables(templateId, { dontRedirectWhenForbidden: true, hideAlertOnCodes: [403, 404, 500] }).then(function (r) {
                        _this7.hiddenVariables = false;
                        return r.data;
                    }).catch(function (err) {
                        if ([403].indexOf(err.status) > -1) {
                            _this7._selectedTemplateHasPermission = false;
                            _this7._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.noPermission;
                            _this7.hiddenVariables = true;
                        }
                    });
                }

                var deferred = this.$q.defer();
                deferred.resolve([]);
                return deferred.promise;
            }
        }, {
            key: '_processVariables',
            value: function _processVariables(vars) {
                this._expandTask(this._task);
                var templateVariables = vars;
                var taskVariables = this.variables;
                this.variables = _.chain(templateVariables).filter(function (templateVariable) {
                    return templateVariable.showOnReleaseStart;
                }).map(function (templateVariable) {
                    templateVariable.id = '';
                    var taskVariable = _.find(taskVariables, { key: templateVariable.key, type: templateVariable.type });

                    return (0, _extends3.default)({}, templateVariable, _.omit(taskVariable, 'valueProvider'));
                }).value();

                return this.variables;
            }
        }, {
            key: '_expandTask',
            value: function _expandTask(task) {
                var variableMapping = _.mapKeys(task.variableMapping, function (value, key) {
                    return _.includes(key, 'templateVariables') ? _.trim(key, '.value') : key;
                });
                this._expandedTask = this.VariablesService.expandProperties(_.mapKeys(task, function (value, key) {
                    return key.replace('variables', 'templateVariables');
                }), variableMapping, this._propertiesWithVars);
                this._expandedTask.createdReleaseId = { variable: task.createdReleaseId, value: null };
            }
        }, {
            key: '_updateTaskFromExpandedTask',
            value: function _updateTaskFromExpandedTask(task, expandedTask) {
                var transformTemplateVarsToTaskVars = function transformTemplateVarsToTaskVars(variable) {
                    var newTaskVariable = _.omit(variable, '$token');

                    if (_.has(variable, 'valueProvider')) {
                        newTaskVariable = (0, _extends3.default)({}, newTaskVariable, { 'valueProvider': variable.valueProvider.id });
                    }

                    return newTaskVariable;
                };

                var _VariablesService$col = this.VariablesService.collapseProperties(expandedTask, this._propertiesWithVars),
                    _VariablesService$col2 = (0, _slicedToArray3.default)(_VariablesService$col, 2),
                    collapsedTask = _VariablesService$col2[0],
                    variableMapping = _VariablesService$col2[1];

                task.variables = this.hiddenVariables ? this._task.variables : collapsedTask.templateVariables.map(transformTemplateVarsToTaskVars);

                task.startRelease = collapsedTask.startRelease;
                task.variableMapping = _.mapKeys(variableMapping, function (value, key) {
                    return _.includes(key, 'templateVariables') ? key + '.value' : key;
                });
                task.createdReleaseId = this._expandedTask.createdReleaseId.variable;
            }
        }, {
            key: '_createListHandlers',
            value: function _createListHandlers() {
                var _this8 = this;

                var autocompleteHandler = function autocompleteHandler(items, term) {
                    var deferred = _this8.$q.defer();
                    var candidates = _.filter(items, function (item) {
                        return item.title.indexOf(term) !== -1;
                    });
                    deferred.resolve(candidates);
                    return deferred.promise;
                };
                this._templateListHandlers = {
                    addCandidates: this._templates ? function (metadata, options) {
                        return autocompleteHandler(_this8._templates, options.term);
                    } : function (metadata, options) {
                        return autocompleteHandler(null, options.term);
                    },
                    onSelect: function onSelect(newTemplate) {
                        return _this8._onTemplateValueSelect(newTemplate);
                    },
                    removeElement: function removeElement() {
                        return _this8._onTemplateValueRemove();
                    }
                };
                this._riskProfileListHandlers = {
                    addCandidates: function addCandidates(metadata, options) {
                        return autocompleteHandler(_this8._riskProfiles, options.term);
                    }
                };
            }
        }, {
            key: '_getSelectedRiskProfile',
            value: function _getSelectedRiskProfile(riskProfiles) {
                var selected = void 0;

                if (this._task.riskProfileId) {
                    selected = _.find(riskProfiles, { id: this._task.riskProfileId });
                    if (selected) {
                        return selected;
                    }
                }
                var syntheticValue = this._release.syntheticProperties && this._release.syntheticProperties.riskProfile;
                if (syntheticValue) {
                    selected = _.find(riskProfiles, { id: syntheticValue });
                    if (selected) {
                        return selected;
                    }
                }
                return _.find(riskProfiles, { id: DEFAULT_RISK_PROFILE_ID });
            }
        }, {
            key: 'updateReleaseTags',
            value: function updateReleaseTags(tags) {
                this.releaseTags = tags;
                this.saveTask();
            }
        }, {
            key: 'saveTask',
            value: function saveTask() {
                var _this9 = this;

                this._variableChanged = false;
                this._updateTaskFromExpandedTask(this._task, this._expandedTask);

                return this.TasksService.updateTask(this._task).then(function (resp) {
                    var savedTask = resp.data;
                    // update task variables
                    _this9._task.variables = savedTask.variables;
                    // update expanded task variables and set them to non-initial state
                    savedTask.variables.forEach(function (updatedVariable) {
                        return _.assign(_.find(_this9.variables, { key: updatedVariable.key }), _.omit(updatedVariable, 'valueProvider'));
                    });
                });
            }
        }, {
            key: 'createVariable',
            value: function createVariable(name, variableType, createdCallback, isRequired) {
                if (isRequired) {
                    this.$scope.createRequiredVariable(this._task, name, variableType, createdCallback);
                } else {
                    this.$scope.createOptionalVariable(this._task, name, variableType, createdCallback);
                }
            }
        }, {
            key: 'isTemplateFromVariable',
            value: function isTemplateFromVariable(template) {
                return angular.isDefined(template) && angular.isDefined(template.variable) && this.VariablesService.containsOnlyVariable(template.variable);
            }
        }, {
            key: '_isTemplateFromValue',
            value: function _isTemplateFromValue(template) {
                return angular.isDefined(template) && angular.isDefined(template.value) && template.value !== null;
            }
        }, {
            key: 'getReleaseIdFromVariable',
            value: function getReleaseIdFromVariable(variableName) {
                var variable = this.allVariables.find(function (variable) {
                    return variable.variableName === variableName;
                });
                if (angular.isDefined(variable) && angular.isDefined(variable.value) && variable.value.includes('Release')) {
                    return this.Ids.toInternalId(variable.value);
                }
                return undefined;
            }
        }, {
            key: 'setTemplateIdAsVariable',
            value: function setTemplateIdAsVariable(variableName, variables) {
                var _this10 = this;

                var templateId = this.getReleaseIdFromVariable(variableName);
                if (angular.isDefined(templateId)) {
                    this._fetchTemplateVariables(templateId).then(function (vars) {
                        _this10._processVariables(vars);
                        _this10.saveTask();
                        _this10._originalVariables = _.cloneDeep(vars);
                    });
                } else {
                    this._processVariables(variables);
                    this.saveTask();
                    this._originalVariables = _.cloneDeep(variables);
                }
                this.selectedTemplate = {
                    variable: variableName,
                    value: undefined
                };
            }
        }, {
            key: '_onTemplateValueSelect',
            value: function _onTemplateValueSelect(newValue) {
                this._newSelectedTemplate = { value: newValue, variable: undefined };
                if (this._task.templateId) {
                    this.enableTemplateConfirmation();
                } else {
                    this.confirmTemplateChange(false);
                }
            }
        }, {
            key: 'onTemplateVariableChange',
            value: function onTemplateVariableChange() {
                if (this.isTemplateFromVariable(this._selectedTemplate)) {
                    this.confirmTemplateChange(true);
                } else {
                    //Switcher/Remove event
                    this._resetAllTemplateValues();
                }
            }
        }, {
            key: '_onTemplateValueRemove',
            value: function _onTemplateValueRemove() {
                var _this11 = this;

                var currentSelectedValue = this._selectedTemplate.value;
                this.$timeout(function () {
                    return _this11.selectedTemplate = { value: currentSelectedValue, variable: undefined };
                });
                this.enableTemplateConfirmation();
            }
        }, {
            key: '_resetAllTemplateValues',
            value: function _resetAllTemplateValues() {
                this._oldSelectedTemplate = { value: undefined, variable: undefined };
                this.selectedTemplate = { value: undefined, variable: undefined };
                this._newSelectedTemplate = { value: undefined, variable: undefined };
                this.confirmTemplateChange(true);
            }
        }, {
            key: '_getNewTemplateId',
            value: function _getNewTemplateId() {
                if (this.isTemplateFromVariable(this._newSelectedTemplate)) {
                    return this._newSelectedTemplate.variable;
                } else if (this._isTemplateFromValue(this._newSelectedTemplate)) {
                    return this._newSelectedTemplate.value.id;
                } else {
                    return null;
                }
            }
        }, {
            key: '_getNewTemplateTitle',
            value: function _getNewTemplateTitle() {
                if (this.isTemplateFromVariable(this._newSelectedTemplate)) {
                    return this._newSelectedTemplate.variable;
                } else if (this._isTemplateFromValue(this._newSelectedTemplate)) {
                    return this._newSelectedTemplate.value.title;
                } else {
                    return null;
                }
            }
        }, {
            key: 'addNewVariable',
            value: function addNewVariable() {
                this.saveTask();
            }
        }, {
            key: 'removeVariable',
            value: function removeVariable() {
                this.saveTask();
            }
        }, {
            key: 'confirmTemplateChange',
            value: function confirmTemplateChange(fromVariable) {
                var _this12 = this;

                this._task.templateId = fromVariable ? this._selectedTemplate.variable : this._getNewTemplateId();

                if (fromVariable) {
                    this.setTemplateIdAsVariable(this._task.templateId, []);
                } else {
                    this._fetchTemplateVariables(this._task.templateId).then(function (vars) {
                        _this12._processVariables(vars);
                        _this12.saveTask();
                        _this12._originalVariables = _.cloneDeep(vars);
                    });
                }

                this._oldSelectedTemplate = fromVariable ? angular.copy(this._selectedTemplate) : this._newSelectedTemplate;
                this.selectedTemplate = fromVariable ? this._selectedTemplate : this._newSelectedTemplate;
                this._showTemplateConfirmation = false;
                this._changeTemplateMsg = CHANGE_TEMPLATE_MSGS.default;
                this._newSelectedTemplate = { value: undefined, variable: undefined };
            }
        }, {
            key: 'cancelTemplateChange',
            value: function cancelTemplateChange() {
                if (this._isTemplateRestoreFromCurrent()) {
                    this._oldSelectedTemplate = { value: _.find(this._templates, { id: this._task.templateId }) };
                }
                this._selectedTemplate = angular.copy(this._oldSelectedTemplate);
                this._newSelectedTemplate = undefined;
                this._showTemplateConfirmation = false;
            }
        }, {
            key: '_isTemplateRestoreFromCurrent',
            value: function _isTemplateRestoreFromCurrent() {
                return (!this._oldSelectedTemplate || !this._oldSelectedTemplate.value) && this._task.templateId;
            }
        }, {
            key: 'confirmFolderChange',
            value: function confirmFolderChange() {
                this._selectedFolder = this._newSelectedFolder;
                this.folderId = this._selectedFolder.id;
                this._showFolderConfirmation = false;
            }
        }, {
            key: 'cancelFolderChange',
            value: function cancelFolderChange() {
                this._newSelectedFolder = undefined;
                this._showFolderConfirmation = false;
                this.folderId = this._selectedFolder.id;
            }

            // view model

            // task properties

        }, {
            key: 'enableTemplateConfirmation',
            value: function enableTemplateConfirmation() {
                var newMessage = void 0;
                if (this._variableChanged && this._selectedTemplateHasPermission) {
                    newMessage = CHANGE_TEMPLATE_MSGS.variableChanged;
                } else if (this._variableChanged && !this._selectedTemplateHasPermission) {
                    newMessage = CHANGE_TEMPLATE_MSGS.both;
                } else if (!this._selectedTemplateHasPermission) {
                    newMessage = CHANGE_TEMPLATE_MSGS.noPermission;
                } else {
                    newMessage = CHANGE_TEMPLATE_MSGS.default;
                }

                if (this._variableChanged) {
                    this._changeTemplateMsg = this._getNewTemplateTitle() !== null ? newMessage.replace('${targetTemplate}', this._getNewTemplateTitle()) : CHANGE_TEMPLATE_MSGS.blankVarChanged;
                } else {
                    this._changeTemplateMsg = this._getNewTemplateTitle() !== null ? newMessage.replace('${targetTemplate}', this._getNewTemplateTitle()) : CHANGE_TEMPLATE_MSGS.blank;
                }
                this._showTemplateConfirmation = true;
            }
        }, {
            key: 'onVariableChanged',
            value: function onVariableChanged(variable) {
                var _this13 = this;

                if (variable.value && variable.type === 'xlrelease.DateVariable') {
                    variable.value = moment(variable.value).format();
                }

                this.saveTask().then(function () {
                    var orig = _this13._originalVariables.find(function (o) {
                        return o.key === variable.key;
                    });
                    if (orig && orig.value !== variable.value) {
                        _this13._variableChanged = true;
                    }
                });
            }
        }, {
            key: 'newReleaseTitle',
            get: function get() {
                return this._task.newReleaseTitle;
            },
            set: function set(title) {
                this._task.newReleaseTitle = title;
                this.saveTask();
            }
        }, {
            key: 'selectedTemplate',
            get: function get() {
                return this._selectedTemplate;
            },
            set: function set(template) {
                this._selectedTemplate = template;
            }
        }, {
            key: 'changeTemplateErrorMsg',
            get: function get() {
                return this._changeTemplateMsg;
            }
        }, {
            key: 'folderId',
            get: function get() {
                return this._task.folderId;
            },
            set: function set(folderId) {
                this._task.folderId = folderId;
                this._selectedFolder.id = folderId;
                this.saveTask();
            }
        }, {
            key: 'folderTitle',
            get: function get() {
                return this._selectedFolder.title;
            },
            set: function set(folderTitle) {
                this._selectedFolder.title = folderTitle;
            }
        }, {
            key: 'hiddenFolder',
            get: function get() {
                if (this._selectedFolder && this._selectedFolder.id) {
                    return !this._selectedFolder.enabled;
                } else {
                    return false;
                }
            }
        }, {
            key: 'selectedRiskProfile',
            get: function get() {
                return this._selectedRiskProfile;
            },
            set: function set(profile) {
                this._selectedRiskProfile = profile;
                this._task.riskProfileId = profile && profile.id;
                this.saveTask();
            }
        }, {
            key: 'variables',
            get: function get() {
                return this._expandedTask.templateVariables;
            },
            set: function set(vars) {
                return this._expandedTask.templateVariables = vars;
            }
        }, {
            key: 'startRelease',
            get: function get() {
                return this._expandedTask.startRelease;
            },
            set: function set(startRelease) {
                this._expandedTask.startRelease = startRelease;
            }
        }, {
            key: 'createdReleaseId',
            get: function get() {
                return this._expandedTask.createdReleaseId;
            },
            set: function set(createdReleaseId) {
                this._expandedTask.createdReleaseId = createdReleaseId;
            }

            // codelist properties

        }, {
            key: 'readOnly',
            get: function get() {
                return this._readOnly;
            }
        }, {
            key: 'readOnlyOrLocked',
            get: function get() {
                return this.readOnly || this.TasksService.isLocked(this._task);
            }
        }, {
            key: 'showTemplateConfirmation',
            get: function get() {
                return this._showTemplateConfirmation;
            }
        }, {
            key: 'showFolderConfirmation',
            get: function get() {
                return this._showFolderConfirmation;
            }
        }, {
            key: 'changeFolderConfirmationMsg',
            get: function get() {
                return this._changeFolderConfirmationMsg.replace('${targetFolderTitle}', this._newSelectedFolder.title);
            }
        }, {
            key: 'release',
            get: function get() {
                return this._release;
            }
        }, {
            key: 'task',
            get: function get() {
                return this._task;
            }
        }, {
            key: 'releaseVariables',
            get: function get() {
                return this._release.variables;
            }
        }, {
            key: 'templateListHandlers',
            get: function get() {
                return this._templateListHandlers;
            }
        }, {
            key: 'riskProfileListHandlers',
            get: function get() {
                return this._riskProfileListHandlers;
            }
        }, {
            key: 'allVariables',
            get: function get() {
                return this.$scope.allVariables;
            }
        }, {
            key: 'editableReleaseVariables',
            get: function get() {
                return this.$scope.editableReleaseVariables;
            }
        }, {
            key: 'templates',
            get: function get() {
                return this._templates;
            }
        }, {
            key: 'riskProfiles',
            get: function get() {
                return this._riskProfiles;
            }
        }, {
            key: 'releaseTags',
            get: function get() {
                return this._task.releaseTags;
            },
            set: function set(value) {
                this._task.releaseTags = value;
            }
        }, {
            key: 'folders',
            get: function get() {
                return this._folders;
            }
        }]);
        return CreateReleaseDetailsController;
    }();

    CreateReleaseDetailsController.$inject = ['$scope', '$q', '$timeout', 'TemplatesService', 'Backend', 'VariablesService', 'TasksService', 'FoldersService', 'Ids'];


    angular.module('xlrelease').controller('xlrelease.CreateReleaseDetailsController', CreateReleaseDetailsController);
})();

/***/ }),
/* 1255 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var DependenciesService = function () {
        function DependenciesService(Backend, $q, ReleasesStatusService) {
            (0, _classCallCheck3.default)(this, DependenciesService);

            this.backend = Backend;
            this.$q = $q;
            this.releasesStatusService = ReleasesStatusService;

            this.cachedReleaseTreePromise = null;
            this.cachedReleaseId = null;
        }

        (0, _createClass3.default)(DependenciesService, [{
            key: 'getReleaseTree',
            value: function getReleaseTree(release) {
                if (this.releasesStatusService.isReleaseCompleted(release)) {
                    var deferred = this.$q.defer();
                    deferred.resolve(null);
                    this.cachedReleaseTreePromise = deferred.promise;
                } else if (!this.cachedReleaseTreePromise || this.cachedReleaseId !== release.id) {
                    this.cachedReleaseTreePromise = this.backend.get('dependencies/' + release.id + '/tree').then(function (result) {
                        return result.data;
                    });
                }
                this.cachedReleaseId = release.id;
                return this.cachedReleaseTreePromise;
            }
        }, {
            key: 'clearCache',
            value: function clearCache() {
                this.cachedReleaseId = null;
                this.cachedReleaseTreePromise = null;
            }
        }]);
        return DependenciesService;
    }();

    DependenciesService.$inject = ['Backend', '$q', 'ReleasesStatusService'];

    angular.module('xlrelease').service('DependenciesService', DependenciesService);
})();

/***/ }),
/* 1256 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('displayWithSeparators', function () {
    var DEFAULT_SEPARATOR = ' | ';
    var SEPARATOR_CLASS = 'separator';
    var separatorElement = void 0;

    function removeSeparators(element) {
        element.find('.' + SEPARATOR_CLASS).each(function (index, element) {
            angular.element(element).remove();
        });
    }

    function addSeparatorToVisibles(displayables) {
        var visibles = getVisibles(displayables);
        for (var i = 0; i < visibles.length - 1; i++) {
            addSeparator(angular.element(visibles[i].element));
        }
    }

    function getVisibles(displayables) {
        return _.filter(displayables, function (displayable) {
            return displayable.visible;
        });
    }

    function addSeparator(element) {
        element.after(separatorElement);
    }

    return {
        link: function link(scope, element, attrs) {
            separatorElement = '<span class="' + SEPARATOR_CLASS + '">' + (attrs.displayWithSeparators || DEFAULT_SEPARATOR) + '</span>';
        },

        controller: ['$scope', '$element', function (scope, element) {
            var displayables = [];
            this.register = function (displayable) {
                displayables.push(displayable);
            };
            this.refresh = function () {
                removeSeparators(element);
                addSeparatorToVisibles(displayables);
            };
        }]
    };
});

angular.module('xlrelease').directive('displayWhen', function () {
    return {
        require: '^displayWithSeparators',
        link: function link(scope, element, attrs, displayWithSeparator) {
            var displayable = {
                element: element,
                visible: true
            };

            displayWithSeparator.register(displayable);

            scope.$watch(attrs.displayWhen, function (isVisible) {
                isVisible ? element.show() : element.hide();
                displayable.visible = isVisible;
                displayWithSeparator.refresh();
            });
        }
    };
});

/***/ }),
/* 1257 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


GateDetailsController.$inject = ['$scope', '$state', 'Backend', 'Ids', 'GateService', 'TasksService', 'DependenciesService', 'Planner', 'ViewStorage'];

function GateDetailsController($scope, $state, Backend, Ids, GateService, TasksService, DependenciesService, Planner, ViewStorage) {

    var CONDITIONS_URL = 'gates/conditions/';

    var getEmptyDependency = function getEmptyDependency() {
        return {
            variableOrTarget: {
                value: {}
            }
        };
    };

    GateService.clearDependencyTargetCache();

    var gateDependenciesTargetStatuses = {};
    $scope.isGateTargetStatusesLoaded = false;
    $scope.dependencyWasChanged = false;

    $scope.$on("$destroy", function () {
        GateService.clearDependencyTargetCache();
    });

    $scope.onDependencyChange = function () {
        $scope.dependencyWasChanged = true;
    };

    $scope.addCondition = function () {
        Backend.post('gates/' + $scope.task.id + '/conditions').then(function (resp) {
            return $scope.task.conditions.push(resp.data);
        });
    };

    $scope.updateCondition = function (condition) {
        Backend.put(CONDITIONS_URL + condition.id, condition).then(function () {
            if (!TasksService.isGateClosed($scope.task)) {
                $scope.completeTaskMode = true;
            }
        });
    };

    $scope.removeCondition = function (removedCondition) {
        Backend.del(CONDITIONS_URL + removedCondition.id).then(function () {
            $scope.task.conditions = _.reject($scope.task.conditions, function (condition) {
                return removedCondition === condition;
            });
        });
    };

    $scope.addDependency = function () {
        var emptyDependency = getEmptyDependency();
        $scope.task.dependencies.push(emptyDependency);
        $scope.editDependency(emptyDependency);
    };

    function isLoadDependencyStatuses() {
        return (TasksService.isTaskInProgress($scope.task) || TasksService.isTaskFailed($scope.task)) && $scope.task.dependencies.length > 0;
    }

    $scope.isDisplayTargetDependencyStatuses = function () {
        return isLoadDependencyStatuses() && $scope.isGateTargetStatusesLoaded;
    };

    var loadDependenciesTargetStatuses = function loadDependenciesTargetStatuses() {
        if (isLoadDependencyStatuses()) {
            $scope.isGateTargetStatusesLoaded = false;
            GateService.getDependenciesTargetStatuses($scope.task.id).then(function (data) {
                gateDependenciesTargetStatuses = data.reduce(function (acc, val) {
                    acc[val.id] = val.status;
                    return acc;
                }, {});
            }).finally(function () {
                $scope.isGateTargetStatusesLoaded = true;
            });
        } else {
            $scope.isGateTargetStatusesLoaded = true;
        }
    };

    $scope.saveDependency = function () {
        var hasVariableOrTarget = $scope.draftDependency.variableOrTarget.variable || _.get($scope.draftDependency.variableOrTarget, 'value.releaseId');

        if (!$scope.editedDependency || !hasVariableOrTarget) {
            return;
        }

        function updateDependencyInList(updatedDependency) {
            var index = _.indexOf($scope.task.dependencies, $scope.editedDependency);
            if (index >= 0) {
                $scope.task.dependencies[index] = updatedDependency;
            }
            delete $scope.editedDependency;
            delete $scope.draftDependency;
            DependenciesService.clearCache();
            DependenciesService.getReleaseTree($scope.release).then(function (releaseTree) {
                Planner.setReleaseTree(releaseTree);
                $scope.planning.savePlanningData($scope.task);
            });
        }

        var promise = void 0;

        if ($scope.draftDependency.variableOrTarget.variable) {
            delete $scope.draftDependency.variableOrTarget.value;
        }
        if ($scope.editedDependency.id) {
            promise = Backend.put('dependencies/' + $scope.editedDependency.id, $scope.draftDependency);
        } else {
            promise = Backend.post('gates/' + $scope.task.id + '/dependencies', $scope.draftDependency);
        }

        promise.then(function (resp) {
            updateDependencyInList(resp.data);
            loadDependenciesTargetStatuses();
        });
    };

    $scope.editDependency = function (dependency) {
        $scope.editedDependency = dependency;
        $scope.draftDependency = _.defaultsDeep(getEmptyDependency(), dependency);
        $scope.dependencyWasChanged = false;
    };

    $scope.isEditingDependency = function (dependency) {
        return $scope.editedDependency === dependency;
    };

    $scope.cancelDependencyEditing = function () {
        if (!$scope.editedDependency || !$scope.editedDependency.id) {
            $scope.task.dependencies = _.without($scope.task.dependencies, $scope.editedDependency);
        }
        delete $scope.editedDependency;
        delete $scope.draftDependency;
        $scope.dependencyWasChanged = false;
    };

    $scope.getDependencyStatus = function (dependency) {
        var statuses = [];
        var targetId = dependency.variableOrTarget.variable || dependency.variableOrTarget.value.id;
        if (targetId in gateDependenciesTargetStatuses) statuses.push(gateDependenciesTargetStatuses[targetId]);
        if (dependency.archived) {
            statuses.push('archived');
        }
        return _.isEmpty(statuses) ? ['not_found'] : statuses;
    };

    $scope.$on('$destroy', $scope.cancelDependencyEditing);
    $scope.$on('$init', loadDependenciesTargetStatuses());

    function dependencyIsEditable(dependency) {
        return !dependency.resolved && (dependency.archived || dependency.variableOrTarget.variable || dependency.variableOrTarget.value);
    }

    $scope.canEditDependency = function (dependency) {
        return $scope.canEditAndIsUnlocked() && dependencyIsEditable(dependency);
    };

    $scope.canDeleteDependency = function (dependency) {
        return $scope.canEditAndIsUnlocked() && (dependencyIsEditable(dependency) || TasksService.isTaskPlanned($scope.task));
    };

    $scope.removeDependency = function (removedDependency) {
        Backend.del('dependencies/' + removedDependency.id).then(function () {
            $scope.task.dependencies = _.reject($scope.task.dependencies, function (dependency) {
                return removedDependency === dependency;
            });
            $scope.planning.savePlanningData($scope.task);
        });
    };

    $scope.showConditions = function () {
        return $scope.task.conditions.length > 0;
    };

    $scope.showAddCondition = function () {
        return $scope.canEditAndIsUnlocked();
    };

    $scope.showDependencies = function () {
        return $scope.task.dependencies.length > 0;
    };

    $scope.showAddDependency = function () {
        return $scope.canEditAndIsUnlocked() && !$scope.isDependencyEditInProgress();
    };

    $scope.isDependencyEditInProgress = function () {
        return _.find($scope.task.dependencies, function (d) {
            return $scope.isEditingDependency(d);
        });
    };

    $scope.isTaskInProgress = TasksService.isTaskInProgress;

    var getReleaseUrl = function getReleaseUrl(releaseId) {
        var internalId = Ids.toInternalId(releaseId);
        return '#' + ViewStorage.getView(internalId, '/releases/' + internalId);
    };

    var getPhaseUrl = function getPhaseUrl(releaseId, phaseId) {
        var internalId = Ids.toInternalId(phaseId);
        return getReleaseUrl(releaseId) + '?scrollToPhase=' + internalId;
    };

    var getTaskUrl = function getTaskUrl(releaseId, phaseTaskId) {
        var internalId = Ids.toInternalId(phaseTaskId);
        return getReleaseUrl(releaseId) + '?openTaskDetailsModal=' + internalId;
    };

    $scope.goToRelease = function (dependency) {
        if (!$scope.isEditingDependency(dependency)) {
            var releaseId = Ids.releaseIdFrom(dependency.variableOrTarget.value.id);
            var taskId = Ids.taskIdFrom(dependency.variableOrTarget.value.id);
            var phaseId = Ids.phaseIdFrom(dependency.variableOrTarget.value.id);
            var phaseTaskId = Ids.phaseTaskIdFrom(dependency.variableOrTarget.value.id);

            if (taskId !== null) {
                return getTaskUrl(releaseId, phaseTaskId);
            } else if (phaseId !== null) {
                return getPhaseUrl(releaseId, phaseId);
            } else {
                return getReleaseUrl(releaseId);
            }
        }
    };

    $scope.getDependencyTitle = function (dependencyValue) {
        var title = dependencyValue.releaseTitle;
        if (dependencyValue.phaseId) {
            title += ' / ' + dependencyValue.phaseTitle;
        }
        if (dependencyValue.taskId) {
            title += ' / ' + dependencyValue.taskTitle;
        }
        return title;
    };
}

angular.module('xlrelease').controller('gateDetailsController', GateDetailsController);

/***/ }),
/* 1258 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _map = __webpack_require__(221);

var _map2 = _interopRequireDefault(_map);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    'use strict';

    var GateService = function () {
        function GateService($q, Backend) {
            (0, _classCallCheck3.default)(this, GateService);

            this._$q = $q;
            this._Backend = Backend;
            this._dependencyTargetCandidatesCache = new _map2.default();
        }

        (0, _createClass3.default)(GateService, [{
            key: 'fetchDependencyTargetCandidates',
            value: function fetchDependencyTargetCandidates(taskId) {
                var _this = this;

                return this._fetchData(function () {
                    return _this._Backend.get('gates/' + taskId + '/dependency-target-candidates');
                }, 'DEPENDENCY_TARGET_CANDIDATES');
            }
        }, {
            key: 'fetchDependencyTargetCandidate',
            value: function fetchDependencyTargetCandidate(taskId, releaseId) {
                var _this2 = this;

                return this._fetchData(function () {
                    return _this2._Backend.get('gates/' + taskId + '/dependency-target-candidates/' + releaseId);
                }, releaseId);
            }
        }, {
            key: 'clearDependencyTargetCache',
            value: function clearDependencyTargetCache() {
                this._dependencyTargetCandidatesCache.clear();
            }
        }, {
            key: 'getDependenciesTargetStatuses',
            value: function getDependenciesTargetStatuses(taskId) {
                return this._Backend.get('gates/' + taskId + '/dependency-target-statuses').then(function (response) {
                    return response.data;
                });
            }

            ////

        }, {
            key: '_fetchData',
            value: function _fetchData(call, cacheKey) {
                var _this3 = this;

                var deferred = this._$q.defer();
                if (this._dependencyTargetCandidatesCache.has(cacheKey)) {
                    deferred.resolve(this._dependencyTargetCandidatesCache.get(cacheKey));
                } else {
                    call().then(function (response) {
                        var data = response.data;
                        _this3._dependencyTargetCandidatesCache.set(cacheKey, data);
                        deferred.resolve(data);
                    });
                }
                return deferred.promise;
            }
        }]);
        return GateService;
    }();

    GateService.$inject = ['$q', 'Backend'];

    angular.module('xlrelease').service('GateService', GateService);
})();

/***/ }),
/* 1259 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

var _extends2 = __webpack_require__(5);

var _extends3 = _interopRequireDefault(_extends2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').directive('quickTaskGenerator', ['TaskDefinitionsService', function (TaskDefinitionsService) {
    function enableForm(scope) {
        scope.$apply(function () {
            scope.showForm = true;
        });
    }

    function submitTask(scope) {
        scope.$apply(function () {
            if (angular.isDefined(scope.title) && scope.title !== null && scope.title !== '') {
                var taskForm = {
                    title: scope.title,
                    taskType: scope.taskType
                };
                scope.addTask({ taskForm: taskForm });
                scope.title = '';
            }
        });
    }

    function disableForm(scope) {
        scope.$apply(function () {
            scope.showForm = false;
            scope.title = '';
        });
    }

    return {
        templateUrl: 'partials/tasks/quick-task-generator.html',
        scope: {
            'addTask': '&',
            'taskDefinitions': '='
        },
        link: function link(scope, element) {
            scope.showForm = false;
            scope.title = '';

            scope.onSelect = function (item) {
                if (item) {
                    scope.taskTypeName = getTaskTypeName(item.group, item.text);
                    scope.taskType = item.id;
                }
            };

            scope.$watch('taskDefinitions', function (taskDefinitions) {
                if (!taskDefinitions) return;
                var groupedTaskDefs = TaskDefinitionsService.groupTaskDefinitions(taskDefinitions);

                _.forEach(groupedTaskDefs.groups, function (value, key) {
                    _.remove(value, function (v) {
                        return !v.isAllowed;
                    });
                    var founded = _.find(value, function (v) {
                        return v.isAllowed;
                    });
                    if (!founded) {
                        delete groupedTaskDefs.groups[key];
                    }
                });

                scope.groupedTaskDefinitions = getGroupedTasks(groupedTaskDefs.groups);

                var defaultValue = groupedTaskDefs.defaultValue;
                scope.taskType = defaultValue && defaultValue.typeName;
                scope.taskTypeName = defaultValue ? getTaskTypeName(defaultValue.displayGroup, defaultValue.displayName) : null;

                if (!defaultValue) {
                    scope.taskGeneratorDisabled = true;
                }
            });

            var input = element.find('input');

            element.find('.add-task').bind('click', function () {
                enableForm(scope);
                input.focus();
            });

            element.find('.add').bind('click', function () {
                submitTask(scope);
                input.focus();
            });

            element.find('.cancel').bind('click', function () {
                disableForm(scope);
            });

            input.bind('keyup', function (e) {
                if (e.which === 27) {
                    // on escape
                    disableForm(scope);
                }
                if (e.which === 13) {
                    // on enter
                    submitTask(scope);
                    input.focus();
                }
            });
        }
    };
}]);

var topGroups = ['Core', 'Script', 'Remote Script', 'Webhook'];

var getGroupedTasks = _.flow([convert, sort, addDivider(topGroups.length), applyItemTypes]);

function getTaskTypeName(groupName, taskName) {
    return groupName + ' > ' + taskName;
}

function addDivider(position) {
    return function (groupedTasks) {
        groupedTasks.splice(position, 0, { divider: true });
        return groupedTasks;
    };
}

function applyItemTypes(groupedTasks) {
    return groupedTasks.map(function (item) {
        return (0, _extends3.default)({}, item, {
            items: item.items && applyItemTypes(item.items),
            type: getItemType(item)
        });
    });
}

function getItemType(item) {
    if (item.items) {
        return 'submenu';
    }
    if (item.divider) {
        return 'divider';
    }
    return 'common';
}

function convert(groupedTasks) {
    return (0, _keys2.default)(groupedTasks).map(function (key) {
        var tasks = groupedTasks[key];
        return {
            id: key,
            text: key,
            items: tasks.map(function (task) {
                return {
                    id: task.typeName,
                    text: task.displayName,
                    group: key
                };
            })
        };
    });
}

function sort(groupedTasks) {
    return groupedTasks.sort(byGroupName(topGroups)).map(function (group) {
        return (0, _extends3.default)({}, group, {
            items: group.items.sort(byTaskType)
        });
    });
}

function byGroupName(topGroups) {
    return function (a, b) {
        var aIdx = topGroups.indexOf(a.text);
        var bIdx = topGroups.indexOf(b.text);

        if (aIdx > -1 && bIdx > -1) {
            return aIdx - bIdx;
        }
        if (aIdx > -1 && bIdx === -1) {
            return -1;
        }
        if (aIdx === -1 && bIdx > -1) {
            return 1;
        }
        if (a.text < b.text) {
            return -1;
        }
        if (a.text > b.text) {
            return 1;
        }

        return 0;
    };
}

function byTaskType(a, b) {
    if (a.text < b.text) return -1;
    if (a.text > b.text) return 1;
    return 0;
}

/***/ }),
/* 1260 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('scheduledStartDateTooltip', ['tooltipService', 'dateFilter', function (tooltipService, dateFilter) {
    return {
        restrict: 'A',
        link: function link(scope, element, attrs) {
            scope.$watch(attrs.scheduledStartDateTooltip, function (date) {
                var text = date ? 'Task will start on ' + dateFilter(date, 'mediumDate') + ' ' + dateFilter(date, 'shortTime') : 'Task will start shortly';
                tooltipService.setup(element, text, 'top');
            }, true);
        }
    };
}]);

/***/ }),
/* 1261 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').factory('TaskContextMenuService', ['Authenticator', 'TasksService', 'ReleasesService', function (Authenticator, TasksService, ReleasesService) {

    function controlFlowActions(task, release, withinBlackout) {
        var items = [];

        if (!TasksService.isTaskReadOnly(task)) {
            items.push({
                text: 'Assign to me',
                disabled: !TasksService.canAssignTaskToCurrentUser(task, release),
                click: function click() {
                    return TasksService.assignToCurrentUser(task);
                }
            });
        }

        if (TasksService.isTaskPending(task)) {
            items.push({
                text: 'Start now',
                disabled: !TasksService.canWorkOnTask(release, task) || task.delayDuringBlackout && withinBlackout && !TasksService.canEditBlackout(release, task),
                modal: 'partials/tasks/start-task-modal.html'
            });
        }

        if (TasksService.isTaskInProgress(task) && !TasksService.isAutomated(task) && !TasksService.isTaskGroup(task)) {

            items = items.concat([{
                text: 'Complete',
                disabled: !TasksService.canCompleteTask(release, task),
                modal: 'partials/tasks/complete-task-modal.html'
            }, {
                text: 'Skip',
                disabled: !TasksService.canExecuteActionOnLockedTask(task) || !TasksService.canUpdateInProgressStatus(task) || !TasksService.canWorkOnTask(release, task),
                modal: 'partials/tasks/skip-task-modal.html'
            }, {
                text: 'Fail',
                disabled: !TasksService.canFailTask(release, task),
                modal: 'partials/tasks/fail-task-modal.html'
            }]);
        }

        if (TasksService.isInProgressScriptTask(task) || TasksService.isTaskPreconditionInProgress(task) || TasksService.isTaskFailureHandlerInProgress(task) || TasksService.isTaskFacetInProgress(task)) {
            items.push({
                text: 'Abort',
                disabled: !TasksService.canWorkOnTask(release, task),
                modal: 'partials/tasks/abort-task-modal.html'
            });
        }

        if (TasksService.isTaskFailed(task) && (!TasksService.isTaskGroup(task) || TasksService.isTaskGroupSkippableOrRetriable(task))) {
            items.push({
                text: 'Skip',
                disabled: !TasksService.canExecuteActionOnLockedTask(task) || !TasksService.canWorkOnFailedTask(release, task),
                modal: 'partials/tasks/skip-task-modal.html'
            });
            if (!TasksService.isUnknownTask(task)) {
                items.push({
                    text: 'Retry',
                    disabled: !TasksService.canRetryTask(release, task),
                    modal: 'partials/tasks/retry-task-modal.html'
                });
            }
        }

        if (TasksService.isTaskPlanned(task) && !TasksService.isTaskGroup(task) && ReleasesService.isReleaseInProgress(release)) {
            if (!TasksService.isAutomated(task)) {
                items.push({
                    text: 'Complete',
                    disabled: !TasksService.canCompleteTask(release, task),
                    modal: 'partials/tasks/complete-task-modal.html'
                });
            }
            items.push({
                text: 'Skip',
                disabled: !TasksService.canExecuteActionOnLockedTask(task) || !TasksService.canUpdatePlannedStatus(task) || !TasksService.canWorkOnTask(release, task),
                modal: 'partials/tasks/skip-task-modal.html'
            });
        }

        if (ReleasesService.isReleaseInProgress(release) && TasksService.isTaskDoneInAdvance(task) && !TasksService.isTaskGroup(task)) {
            items.push({
                text: 'Reopen',
                disabled: !TasksService.canReopenTask(release, task),
                modal: 'partials/tasks/reopen-task-modal.html'
            });
        }

        var setTaskLock = function setTaskLock(lock) {
            var flatten = function flatten(t) {
                return [t].concat((0, _toConsumableArray3.default)(TasksService.isTaskGroup(t) ? _.flatMap(t.tasks, flatten) : []));
            };
            flatten(task).forEach(function (t) {
                return t.locked = lock;
            });
        };

        if (!task.locked) {
            items.push({
                text: 'Lock',
                disabled: !Authenticator.hasLockTaskPermission(release),
                click: function click() {
                    return TasksService.lock(task.id).then(function () {
                        setTaskLock(true);
                    });
                }
            });
        } else {
            items.push({
                text: 'Unlock',
                disabled: !Authenticator.hasLockTaskPermission(release),
                click: function click() {
                    return TasksService.unlock(task.id).then(function () {
                        setTaskLock(false);
                    });
                }
            });
        }

        if (items.length) {
            items.push({ divider: true });
        }
        return items;
    }

    function editActions(task, release, container) {
        return [{
            text: 'Duplicate',
            disabled: !TasksService.isDuplicateEnabled(task, release, container),
            click: function click() {
                if (TasksService.isDuplicateEnabled(task, release, container)) {
                    return TasksService.duplicateTask(release, task, container);
                }
            }
        }, {
            text: 'Delete',
            disabled: !TasksService.isRemoveEnabled(task, release, container),
            modal: 'partials/releases/delete-task-modal.html',
            cssClass: 'remove-task-button'
        }];
    }

    function changeTypeSubmenu(task, release, container, groupedTaskDefinitions) {
        if (TasksService.isTaskPlanned(task) && !TasksService.isTaskGroup(task) && Authenticator.hasEditTaskPermission(release)) {

            var mapTaskToType = function mapTaskToType(taskDefinition) {
                var isSameType = TasksService.isOfType(task, taskDefinition);
                return {
                    templateUrl: 'partials/tasks/change-type-submenu-item.html',
                    isSameType: isSameType,
                    taskDefinition: taskDefinition
                };
            };

            var topGroups = ['Core', 'Script', 'Remote Script', 'Webhook'];

            var types = _.map(groupedTaskDefinitions, function (taskDefinitions, group) {
                return {
                    text: group,
                    items: taskDefinitions.filter(function (taskDefinition) {
                        return taskDefinition.isAllowed;
                    }).sort(function (a, b) {
                        var aDisplayName = a.displayName.toUpperCase();
                        var bDisplayName = b.displayName.toUpperCase();
                        if (aDisplayName < bDisplayName) {
                            return -1;
                        }
                        if (aDisplayName > bDisplayName) {
                            return 1;
                        }
                        return 0;
                    }).map(function (taskDefinition) {
                        return mapTaskToType(taskDefinition);
                    })

                };
            }).sort(function (a, b) {
                var aIdx = topGroups.indexOf(a.text);
                var bIdx = topGroups.indexOf(b.text);

                if (aIdx > -1 && bIdx > -1) {
                    return aIdx - bIdx;
                }
                if (aIdx > -1 && bIdx === -1) {
                    return -1;
                }
                if (aIdx === -1 && bIdx > -1) {
                    return 1;
                }
                if (a.text < b.text) {
                    return -1;
                }
                if (a.text > b.text) {
                    return 1;
                }

                return 0;
            });

            types.splice(topGroups.length, 0, { divider: true });

            return [{
                text: 'Change type',
                disabled: !TasksService.isChangeTypeEnabled(task, release, container),
                items: types,
                filter: true
            }];
        } else {
            return [];
        }
    }

    function typeOf(item) {
        if (item.modal) return 'modal';
        if (item.click) return 'click';
        if (item.divider) return 'divider';
        if (item.templateUrl) return 'template';
        if (item.items) return 'submenu';
        return 'noAction';
    }

    function enhanceMenuItemsWithType(items) {
        _.map(items, function (item) {
            if (item.items) {
                enhanceMenuItemsWithType(item.items);
            }
            return _.extend(item, { type: typeOf(item) });
        });
    }

    return {
        getMenuItems: function getMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout) {
            var res = controlFlowActions(task, release, withinBlackout);
            res = res.concat(changeTypeSubmenu(task, release, container, groupedTaskDefinitions));
            res = res.concat(editActions(task, release, container));
            enhanceMenuItemsWithType(res);
            return res;
        }
    };
}]);

/***/ }),
/* 1262 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('TaskController', ['$scope', 'Backend', 'Events', '$stateParams', function ($scope, Backend, Events, $stateParams) {

    var ctrl = $scope;

    var taskId = $stateParams.taskId;

    if ($stateParams.showDetails === "true") {
        $scope.showTaskDetailsModal = true;
    }

    function loadTask() {
        $scope.$emit(Events.permission.refresh);
        Backend.get('tasks/' + taskId).then(function (resp) {
            var taskFullView = resp.data;
            Backend.get('tasks/' + taskId + '/release').then(function (result) {
                $scope.task = taskFullView;
                $scope.tasks = [taskFullView];
                $scope.release = result.data;
            });
        });
    }

    loadTask();

    $scope.onTaskChange = function () {
        loadTask();
    };

    $scope.onTaskDetailsClosed = function () {
        $scope.showTaskDetailsModal = false;
    };
}]);

/***/ }),
/* 1263 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('TaskDefinitionsService', ['Backend', function (Backend) {
    'use strict';

    return {
        getTaskDefinitions: function getTaskDefinitions() {
            return Backend.get('tasks/task-definitions');
        },
        groupTaskDefinitions: function groupTaskDefinitions(taskDefinitions) {
            if (!taskDefinitions) return;
            return {
                groups: _.groupBy(taskDefinitions, 'displayGroup'),
                defaultValue: _.find(taskDefinitions, function (taskDefinition) {
                    return taskDefinition.isAllowed === true;
                })
            };
        }
    };
}]);

/***/ }),
/* 1264 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _toConsumableArray2 = __webpack_require__(39);

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _defineProperty2 = __webpack_require__(18);

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends3 = __webpack_require__(5);

var _extends4 = _interopRequireDefault(_extends3);

var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').controller('taskDetailsController', ['$scope', 'ModalService', 'Backend', 'TasksService', 'ReleasesService', '$location', 'Authenticator', 'FlagService', 'TaskDetailsUpdates', 'UsersService', 'UserProfile', 'PlanningDataEditorMixin', 'ConfigurationInstances', 'ReleaseEditorCollapse', 'VariablesService', 'TaskContextMenuService', 'CalendarService', '$stateParams', 'Ids', function ($scope, ModalService, Backend, TasksService, ReleasesService, $location, Authenticator, FlagService, TaskDetailsUpdates, UsersService, UserProfile, PlanningDataEditorMixin, ConfigurationInstances, ReleaseEditorCollapse, VariablesService, TaskContextMenuService, CalendarService, $stateParams, Ids) {

    $scope.data = {
        newComment: '',
        showCommentForm: false
    };

    if ($scope.task) {
        if (TasksService.isTaskGroup($scope.task)) {
            $scope.isCollapsed = ReleaseEditorCollapse.isTaskGroupCollapsed($scope.task);
        }
    }

    $scope.ctrl = $scope;
    $scope.ctrlScope = $scope;
    $scope.tasksServices = TasksService;
    $scope.taskRecoverOps = [{ id: "Skip task", title: "Skip task" }, { id: "Run script", title: "Define additional action" }];

    $scope.formValid = true;

    function loadModalScope(task) {
        return CalendarService.withinBlackout().then(function (response) {
            var modalScope = $scope.$new();
            modalScope.withinBlackout = response.data;
            modalScope.canStartTaskWithinBlackout = function (release) {
                return task.delayDuringBlackout && TasksService.canEditBlackout(release, task) && modalScope.withinBlackout || TasksService.canWorkOnTask(release, task) && (!task.delayDuringBlackout || !modalScope.withinBlackout);
            };
            return modalScope;
        });
    }

    $scope.openTaskDetailsModal = function (task) {
        if (isTaskDisabledInView(task)) {
            return;
        }
        loadModalScope(task).then(function (modalScope) {
            ModalService.open(modalScope, "'partials/tasks/details/task-details-modal.html'", "editTask(task, release)", "loadReleaseAfterTaskUpdate()", true, true);
            modalScope.showModal();
        });
    };

    $scope.openTaskDetailsModalIfRequested = function () {
        if ($location.search().openTaskDetailsModal && Ids.phaseTaskIdFrom($location.search().openTaskDetailsModal) === Ids.phaseTaskIdFrom($scope.task.id)) {
            $scope.openTaskDetailsModal($scope.task);
        }
    };

    function decorateWithReleaseLoading(menuItems) {
        menuItems.forEach(function (i) {
            if (i.text === 'Duplicate') {
                var oldFn = i.click;
                i.click = function () {
                    return oldFn().then($scope.loadRelease);
                }; //it is a dirty hack but I cannot find a proper one
            }
        });
        return menuItems;
    }

    $scope.taskContextMenuItems = function (task, release, container, groupedTaskDefinitions, withinBlackout) {
        var items = TaskContextMenuService.getMenuItems(task, release, container, groupedTaskDefinitions, withinBlackout);
        return decorateWithReleaseLoading(items);
    };

    $scope.createOptionalVariable = function (task, name, variableType, createdCallback) {
        var variable = {
            key: name,
            requiresValue: false,
            showOnReleaseStart: false,
            type: variableType
        };

        $scope.createReleaseVariable(task, variable, createdCallback);
    };

    $scope.createRequiredVariable = function (task, name, variableType, createdCallback) {
        var variable = {
            key: name,
            type: variableType
        };

        $scope.createReleaseVariable(task, variable, createdCallback);
    };

    $scope.createReleaseVariable = function (task, variable, createdCallback) {
        VariablesService.createReleaseVariable(task.releaseId, variable).then(function (resp) {
            if (createdCallback) {
                createdCallback(resp.data);
            }
        });
    };

    $scope.updateTags = function (tags, task) {
        task.tags = tags;
        $scope.saveTask(task);
    };

    $scope.initTaskRecoverOp = function (task) {
        if (!task.taskRecoverOp) {
            task.taskRecoverOp = 'Skip task';
            $scope.saveTask(task);
        }
    };

    $scope.saveTask = function (task, saveCallback) {
        return TasksService.updateTask(task).then(function (resp) {
            var savedTask = resp.data;
            task.password = savedTask.password;
            task.outputProperties = savedTask.outputProperties;
            task.inputProperties = savedTask.inputProperties;
            task.variables = savedTask.variables;
            loadVariablesOnTaskSaved(task.releaseId);
            if (saveCallback) {
                saveCallback(task);
            }
        });
    };

    angular.extend($scope, PlanningDataEditorMixin.withSaveCallback(function (task) {
        resetWaitForScheduledStartDate(task);
        $scope.saveTask(task);
        TaskDetailsUpdates.planningDataChanged = true;
    }));

    function resetWaitForScheduledStartDate(task) {
        if (!task.scheduledStartDate) {
            task.waitForScheduledStartDate = true; // reset to default value
        }
    }

    $scope.reloadTaskVariablesCallback = function (release) {
        return function (task) {
            loadVariables(task, release);
        };
    };

    $scope.loadReleaseForEditTask = function (task, release) {
        ReleasesService.getRelease(release.id, { dontRedirectWhenForbidden: true, hideAlert: true }).then(function (result) {
            return $scope.editTask(task, result.data);
        }).catch(function (response) {
            if (response.status === 403) {
                Backend.get('tasks/' + task.id + '/release').then(function (resp) {
                    return $scope.editTask(task, resp.data);
                });
            }
        });
    };

    $scope.editTask = function (task, release) {
        loadModalScope(task).then(function (modalScope) {
            $scope.withinBlackout = modalScope.withinBlackout;
            $scope.canStartTaskWithinBlackout = modalScope.canStartTaskWithinBlackout;
        });

        if ('type' in release) {
            $scope.planning.initPlanningData(task, release);
        }
        loadVariables(task, release);
        loadUsernames(release);
        loadTeams(task.id, release);
        loadComments(task.id);
        loadCustomType(task);
        loadWatchers(task);
        var folderId = Ids.releaseIdToFolderId($stateParams.releaseId);
        ConfigurationInstances.load(folderId);
    };

    $scope.ConfigurationInstances = ConfigurationInstances;

    function loadVariables(task, release) {
        $scope.variables = undefined;
        $scope.allVariables = undefined;
        $scope.releaseVariables = undefined;
        $scope.editableReleaseVariables = undefined;
        if (TasksService.isTaskWaitingForInput(task) && TasksService.canWorkOnTask(release, task)) {
            TasksService.getTaskVariables(task).then(function (resp) {
                return $scope.variables = resp.data;
            });
        }

        if (canViewRelease(release)) {
            VariablesService.getAllVariables(release.id).then(function (allVariables) {
                $scope.allVariables = allVariables;
                $scope.allVariablesWithReleaseVars = loadAllVariablesWithSpecialRelVars(allVariables, release);
                $scope.releaseVariables = _.filter(allVariables, function (v) {
                    return !VariablesService.isFolderOrGlobalVariable(v.key);
                });
                $scope.editableReleaseVariables = _.filter($scope.releaseVariables, function (v) {
                    return !VariablesService.isCiPropertyVariableName(v.key);
                });
            });
        }
    }

    function loadVariablesOnTaskSaved(releaseId) {
        VariablesService.getAllVariables(releaseId).then(function (allVariables) {
            allVariables.filter(function (var1) {
                return !$scope.allVariables.some(function (var2) {
                    return var1.key === var2.key;
                });
            }).forEach(function (newVar) {
                return $scope.allVariablesWithReleaseVars.push(newVar);
            });
        });
    }

    function loadAllVariablesWithSpecialRelVars(allVariables, release) {
        if (release.variables) {
            var specialVariables = (0, _keys2.default)(release.variables).filter(function (key) {
                return key.includes('release.') === true;
            }).reduce(function (obj, key) {
                return (0, _extends4.default)({}, obj, (0, _defineProperty3.default)({}, key, release.variables[key]));
            }, {});

            (0, _keys2.default)(specialVariables).forEach(function (key) {
                allVariables.push({
                    'displayName': key,
                    'id': '',
                    'key': key.replace('${', '').replace('}', ''),
                    'requiresValue': false,
                    'showOnReleaseStart': false,
                    'type': "xlrelease.StringVariable",
                    'value': specialVariables[key],
                    'variableName': key
                });
            });
        }
        return allVariables;
    }

    function loadUsernames(release) {
        $scope.allUsers = [];
        if (Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release)) {
            UsersService.getAllUsers().then(function (resp) {
                $scope.allUsers = _.sortBy(resp.data, [function (rp) {
                    return rp.username.toLowerCase();
                }]);
            });
        }
    }

    function loadTeams(taskId, release) {
        $scope.teams = [];
        if (Authenticator.hasEditTaskPermission(release) || Authenticator.hasReassignTaskPermission(release)) {
            Backend.get('releases/' + release.id + '/teams/assignable').then(function (resp) {
                return $scope.teams = _.chain(resp.data).map(function (team) {
                    return { id: team.teamName, title: team.teamName };
                }).sortBy(function (t) {
                    return t.title.toLowerCase();
                }).value();
            });
        }
    }

    function loadComments(taskId) {
        $scope.comments = [];
        Backend.get('tasks/' + taskId + '/comments').then(function (resp) {
            return $scope.comments = resp.data;
        });
    }

    function loadCustomType(task) {
        $scope.scriptDefinition = null;
        if (task.scriptDefinitionType) {
            Backend.get('tasks/task-definitions/' + task.scriptDefinitionType).then(function (resp) {
                return $scope.scriptDefinition = resp.data;
            });
        }
    }

    $scope.saveComment = function (comment) {
        Backend.put('comments/' + comment.id, comment).then(function (resp) {
            var updatedComment = resp.data;
            comment.date = updatedComment.date;
            comment.text = updatedComment.text;
        });
    };

    $scope.addComment = function (task, commentText) {
        var newComment = {
            text: commentText
        };
        Backend.post('tasks/' + task.id + '/comments', newComment).then(function (resp) {
            $scope.data.newComment = '';
            $scope.comments.push(resp.data);
            task.numberOfComments++;
            $scope.data.showCommentForm = false;
        });
    };

    $scope.flag = function (flagStatus) {
        $scope.task.flag.status = flagStatus;
        if (!FlagService.isTaskFlagged($scope.task)) {
            $scope.task.flag.comment = '';
        }
        $scope.saveTask($scope.task);
    };

    $scope.removeOwner = function () {
        $scope.task.owner = null;
        Backend.del('tasks/' + $scope.task.id + '/owner');
        TaskDetailsUpdates.assigneeChanged = true;
    };

    $scope.updateOwner = function (task) {
        if (task.owner) {
            Backend.put('tasks/' + task.id + '/owner', TasksService.toTaskFullView(task));
            TaskDetailsUpdates.assigneeChanged = true;
        } else {
            $scope.removeOwner();
        }
    };

    $scope.removeTeam = function () {
        $scope.task.team = null;
        Backend.del('tasks/' + $scope.task.id + '/team');
        TaskDetailsUpdates.assigneeChanged = true;
    };

    $scope.updateTeam = function (task) {
        Backend.put('tasks/' + task.id + '/team', TasksService.toTaskFullView(task));
        TaskDetailsUpdates.assigneeChanged = true;
    };

    $scope.viewTaskInRelease = function (releaseId) {
        $location.url('releases/' + releaseId);
    };

    $scope.canWorkOnTask = function (release) {
        return TasksService.canWorkOnTask(release, $scope.task);
    };

    $scope.canCommentOnTask = function (release) {
        return TasksService.canCommentOnTask(release, $scope.task);
    };

    $scope.canWorkOnReadOnlyTask = function (release) {
        return TasksService.canWorkOnReadOnlyTask(release, $scope.task);
    };

    function canEditTask(release, task) {
        return TasksService.canEditTask(release, task || $scope.task);
    }

    $scope.canClaimTask = function (task, release) {
        return TasksService.canAssignTaskToCurrentUser(task, release);
    };

    $scope.canCompleteTask = function (release, task) {
        return TasksService.canCompleteTask(release, task);
    };

    $scope.canSkipTask = function (release, task) {
        return TasksService.canSkipTask(release, task);
    };

    $scope.$on('formValidityChanged', function (event, validity) {
        $scope.formValid = validity;
    });

    $scope.isPlannedOrPending = function (task) {
        return TasksService.isTaskPlanned(task) || TasksService.isTaskPending(task);
    };

    $scope.isTaskPostponedDueToBlackout = function (task) {
        return task.postponedDueToBlackout;
    };

    $scope.getOriginalScheduledStartDate = function (task) {
        if ($scope.isTaskPostponedDueToBlackout(task)) {
            return task.originalScheduledStartDate;
        } else {
            return null;
        }
    };

    $scope.isTaskInFinishedState = function (task) {
        return TasksService.isTaskCompleted(task) || TasksService.isTaskFailed(task) || TasksService.isTaskSkipped(task) || TasksService.isTaskAborted(task);
    };

    $scope.assignToMe = function (task) {
        task.owner = UserProfile.getCurrentUser();
        $scope.updateOwner(task);
    };

    $scope.deleteAttachment = function (release, task, attachment) {
        Backend.del('releases/' + release.id + '/' + task.id + '/attachments/' + attachment.id).then(function () {
            return _.remove(task.attachments, function (candidate) {
                return candidate.id === attachment.id;
            });
        });
    };

    function isTaskDisabledInView(task) {
        return task.disabledInView;
    }

    $scope.isTaskDisabledInView = isTaskDisabledInView;

    $scope.isTaskContextMenuAvailable = function (task) {
        return (!TasksService.isTaskReadOnly(task) || TasksService.isTaskDoneInAdvance(task)) && !isTaskDisabledInView(task);
    };

    // Task Watchers

    var sortWatchers = function sortWatchers(watchers) {
        var currentUser = UserProfile.getCurrentUser();
        var users = _.remove(watchers, function (w) {
            return w.username === currentUser.username;
        });
        var sortedWatchers = _.orderBy(watchers, [function (w) {
            return _.toLower(w.fullName);
        }, function (w) {
            return w.username.toLowerCase();
        }], ['asc', 'asc']);
        return [].concat((0, _toConsumableArray3.default)(users), (0, _toConsumableArray3.default)(sortedWatchers));
    };

    var excludeWatchersFromAllUsers = function excludeWatchersFromAllUsers(allUsers, watchers) {
        return _.differenceWith(allUsers, watchers, function (u1, u2) {
            return u1.username === u2.username;
        });
    };

    var handleWatcherResponse = function handleWatcherResponse(response) {
        $scope.watchers = sortWatchers(response.data);
        $scope.nonWatchingUsers = excludeWatchersFromAllUsers($scope.allUsers, $scope.watchers);
    };

    var loadWatchers = function loadWatchers(task) {
        $scope.watchers = [];
        Backend.get('tasks/' + task.id + '/watchers').then(handleWatcherResponse);
    };

    var isWatchingTask = function isWatchingTask(watcher) {
        return _.some($scope.watchers, function (w) {
            return w.username === watcher.username;
        });
    };

    var addWatcher = function addWatcher(task, watcher) {
        Backend.post('tasks/' + task.id + '/watchers', watcher).then(handleWatcherResponse);
    };

    var removeWatcher = function removeWatcher(task, watcher) {
        Backend.del('tasks/' + task.id + '/watchers/' + watcher.username).then(handleWatcherResponse);
    };

    $scope.isUserWatchingTask = function () {
        return isWatchingTask(UserProfile.getCurrentUser());
    };

    $scope.addMeAsWatcher = function (task) {
        addWatcher(task, UserProfile.getCurrentUser());
    };

    $scope.canRemoveWatcher = function (release, watcher) {
        var currentUser = UserProfile.getCurrentUser();
        return $scope.canEditTask(release) || currentUser.username === watcher.username;
    };

    $scope.removeWatcher = function (task, watcher) {
        removeWatcher(task, watcher);
    };

    $scope.watcherContainer = { watcher: null };
    $scope.handleWatcherChange = function (task) {
        var watcher = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { username: '' };

        var user = _.find($scope.nonWatchingUsers, function (u) {
            return u.username === watcher.username;
        });
        if (user) {
            addWatcher(task, user);
            $scope.watcherContainer.watcher = null;
        }
    };

    $scope.watchersTooltip = {
        placement: 'auto bottom',
        text: 'Assigning a watcher role to a user will allow him to receive notifications for this tasks events'
    };

    $scope.canEditTask = canEditTask;
    $scope.canEditBlackout = TasksService.canEditBlackout;
    $scope.canDelayTask = TasksService.canDelayTask;
    $scope.canWorkOnFailedTask = TasksService.canWorkOnFailedTask;
    $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
    $scope.canUpdateInProgressStatus = TasksService.canUpdateInProgressStatus;
    $scope.canUpdatePlannedStatus = TasksService.canUpdatePlannedStatus;
    $scope.canUpdateFailedStatus = TasksService.canUpdateFailedStatus;
    $scope.isTaskDoneInAdvance = TasksService.isTaskDoneInAdvance;
    $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
    $scope.isTaskInProgress = TasksService.isTaskInProgress;
    $scope.isGateTask = TasksService.isGateTask;
    $scope.isUserInputTask = TasksService.isUserInputTask;
    $scope.isNotificationTask = TasksService.isNotificationTask;
    $scope.isScriptTask = TasksService.isScriptTask;
    $scope.isTaskGroup = TasksService.isTaskGroup;
    $scope.isParallelGroup = TasksService.isParallelGroup;
    $scope.isSequentialGroup = TasksService.isSequentialGroup;
    $scope.isCustomScriptTask = TasksService.isCustomScriptTask;
    $scope.isCreateReleaseTask = TasksService.isCreateReleaseTask;
    $scope.isInProgressScriptTask = TasksService.isInProgressScriptTask;
    $scope.isGateClosed = TasksService.isGateClosed;
    $scope.isTaskReadOnly = TasksService.isTaskReadOnly;
    $scope.isTaskFailed = TasksService.isTaskFailed;
    $scope.isTaskFailing = TasksService.isTaskFailing;
    $scope.isTaskPending = TasksService.isTaskPending;
    $scope.shouldTaskShowStatusLine = TasksService.shouldTaskShowStatusLine;
    $scope.isTaskAborted = TasksService.isTaskAborted;
    $scope.isTaskCompleted = TasksService.isTaskCompleted;
    $scope.isTaskPreconditionInProgress = TasksService.isTaskPreconditionInProgress;
    $scope.isTaskFacetInProgress = TasksService.isTaskFacetInProgress;
    $scope.hasDeploymentFacet = TasksService.hasDeploymentFacet;
    $scope.isTaskFailureHandlerInProgress = TasksService.isTaskFailureHandlerInProgress;
    $scope.isTaskGroupSkippableOrRetriable = TasksService.isTaskGroupSkippableOrRetriable;
    $scope.isTaskCompletedInAdvance = TasksService.isTaskCompletedInAdvance;
    $scope.isTaskSkippedInAdvance = TasksService.isTaskSkippedInAdvance;
    $scope.isTaskSkipped = TasksService.isTaskSkipped;
    $scope.isDone = TasksService.isDone;
    $scope.isDoneInAdvance = TasksService.isTaskDoneInAdvance;
    $scope.isAutomated = TasksService.isAutomated;
    $scope.isTaskDelayedDuringBlackout = TasksService.isTaskDelayedDuringBlackout;
    $scope.hasOwner = TasksService.hasOwner;
    $scope.isReleaseInProgress = ReleasesService.isReleaseInProgress;
    $scope.hasConfigurationUri = TasksService.hasConfigurationUri;
    $scope.getConfigurationUri = TasksService.getConfigurationUri;

    $scope.isPreConditionCollapsed = ReleaseEditorCollapse.isPreConditionCollapsed;
    $scope.togglePreConditionState = ReleaseEditorCollapse.togglePreConditionState;

    $scope.areTaskPropertiesReadonly = areTaskPropertiesReadonly;

    $scope.areFacetsCollapsed = ReleaseEditorCollapse.areFacetsCollapsed;
    $scope.toggleFacetsState = ReleaseEditorCollapse.toggleFacetsState;

    $scope.isFailureHandlerCollapsed = ReleaseEditorCollapse.isFailureHandlerCollapsed;
    $scope.toggleFailureHandlerState = ReleaseEditorCollapse.toggleFailureHandlerState;

    $scope.isCommentsCollapsed = ReleaseEditorCollapse.isCommentsCollapsed;
    $scope.toggleCommentsState = ReleaseEditorCollapse.toggleCommentsState;

    $scope.isAttachmentsCollapsed = ReleaseEditorCollapse.isAttachmentsCollapsed;
    $scope.toggleAttachmentsState = ReleaseEditorCollapse.toggleAttachmentsState;
    $scope.toggleTaskGroupCollapseState = function (task) {
        $scope.isCollapsed = !$scope.isCollapsed;
        ReleaseEditorCollapse.toggleTaskGroupCollapseState(task);
    };

    $scope.hasLockPermission = function (release) {
        return Authenticator.hasLockTaskPermission(release);
    };

    $scope.isLocked = function () {
        return TasksService.isLocked($scope.task);
    };

    $scope.isUnknownTask = function () {
        return TasksService.isUnknownTask($scope.task);
    };

    $scope.canEditAndIsUnlocked = function () {
        return !$scope.isLocked() && canEditTask($scope.release, $scope.task);
    };

    $scope.canEditFacet = function () {
        return !$scope.isLocked() && canEditTask($scope.release, $scope.task);
    };

    $scope.canEditFailureHandler = function () {
        return !$scope.isLocked() && TasksService.canEditFailureHandler($scope.release, $scope.task);
    };

    $scope.canEditPrecondition = function () {
        return !$scope.isLocked() && TasksService.canEditPrecondition($scope.release, $scope.task);
    };

    $scope.areTaskPropertiesReadonlyOrLocked = function () {
        return areTaskPropertiesReadonly() || $scope.isLocked();
    };

    $scope.unlock = function (task) {
        return TasksService.unlock(task.id).then(function () {
            setTaskLock(task, false);
        });
    };

    function setTaskLock(task, lock) {
        var flatten = function flatten(t) {
            return [t].concat((0, _toConsumableArray3.default)(TasksService.isTaskGroup(t) ? _.flatMap(t.tasks, flatten) : []));
        };
        flatten(task).forEach(function (t) {
            t.locked = lock;
        });
    }

    function areTaskPropertiesReadonly() {
        var release = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : $scope.release;
        var task = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : $scope.task;

        return TasksService.areTaskPropertiesReadonly(release, task);
    }

    function canViewRelease(release) {
        return Authenticator.hasViewPermission(release);
    }

    $scope.$on('$destroy', function () {
        ConfigurationInstances.reset();
    });

    $scope.getEnvironmentAvailabilityTooltip = function (task) {
        if (TasksService.isTaskReadOnly(task)) {
            return undefined;
        } else if (TasksService.hasDeploymentFacet(task)) {
            return 'If the environment is not available, this option will fail the task';
        } else {
            return 'To use this feature, you must add deployment attributes';
        }
    };
}]);

/***/ }),
/* 1265 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('TaskDetailsUpdates', [function () {
    return {
        assigneeChanged: false,
        planningDataChanged: false,
        reset: function reset() {
            this.assigneeChanged = false;
            this.planningDataChanged = false;
        }
    };
}]);

/***/ }),
/* 1266 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('taskListController', ['$scope', 'TasksService', 'ReleasesService', 'FlagService', 'DateService', 'Authenticator', function ($scope, TasksService, ReleasesService, FlagService, DateService, Authenticator) {

    $scope.ctrl = $scope;

    $scope.security = Authenticator;
    $scope.isTaskPending = TasksService.isTaskPending;
    $scope.isTaskInProgress = TasksService.isTaskInProgress;
    $scope.isTaskFacetInProgress = TasksService.isTaskFacetInProgress;
    $scope.isTaskPreconditionInProgress = TasksService.isTaskPreconditionInProgress;
    $scope.isTaskOrPreconditionInProgress = TasksService.isTaskOrPreconditionInProgress;
    $scope.isTaskPlanned = TasksService.isTaskPlanned;
    $scope.isTaskSkipped = TasksService.isTaskSkipped;
    $scope.isTaskFailed = TasksService.isTaskFailed;
    $scope.isTaskFailing = TasksService.isTaskFailing;
    $scope.isTaskCompleted = TasksService.isTaskCompleted;
    $scope.isTaskCompletedInAdvance = TasksService.isTaskCompletedInAdvance;
    $scope.isTaskSkippedInAdvance = TasksService.isTaskSkippedInAdvance;
    $scope.isUserInputTask = TasksService.isUserInputTask;
    $scope.isGateTask = TasksService.isGateTask;
    $scope.isNotificationTask = TasksService.isNotificationTask;
    $scope.isManualTask = TasksService.isManualTask;
    $scope.isScriptTask = TasksService.isScriptTask;
    $scope.isCustomScriptTask = TasksService.isCustomScriptTask;
    $scope.isStatusUpdatable = TasksService.isStatusUpdatable;
    $scope.isTaskDelayedDuringBlackout = TasksService.isTaskDelayedDuringBlackout;
    $scope.hasOwner = TasksService.hasOwner;
    $scope.isTaskFlagged = FlagService.isTaskFlagged;
    $scope.isOverdue = DateService.isOverdue;
    $scope.isTaskWaitingForInput = TasksService.isTaskWaitingForInput;
    $scope.isLocked = TasksService.isLocked;

    $scope.completeTask = function (task, commentText) {
        TasksService.completeTask(task.id, commentText).then($scope.onTaskChange);
    };

    $scope.skipTask = function (task, commentText) {
        TasksService.skipTask(task.id, commentText).then($scope.onTaskChange);
    };

    $scope.failTask = function (task, commentText) {
        TasksService.failTask(task.id, commentText).then($scope.onTaskChange);
    };

    $scope.abortTask = function (task, commentText) {
        TasksService.abortTask(task.id, commentText).then($scope.onTaskChange);
    };

    $scope.cancelTask = function (task, commentText) {
        TasksService.cancelTask(task.id, commentText).then($scope.onTaskChange);
    };

    $scope.retryTask = function (task, commentText) {
        TasksService.retryTask(task.id, commentText).then($scope.onTaskChange);
    };

    $scope.startNow = function (task, commentText) {
        TasksService.startNow(task.id, commentText).then($scope.onTaskChange);
    };

    $scope.startTaskWithInput = function (task, variables) {
        TasksService.startTaskWithInput(task.id, variables).then($scope.onTaskChange);
    };

    $scope.showCompleteTaskLink = function (task, release) {
        return TasksService.canCompleteTask(release, task);
    };

    $scope.canSkipTask = function (task, release) {
        return TasksService.canSkipTask(release, task);
    };
}]);

/***/ }),
/* 1267 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('TaskPolling', ['Timeout', '$q', 'Backend', 'TasksService', 'Events', 'Alerts', 'PollingSettings', function (Timeout, $q, Backend, TasksService, Events, Alerts, PollingSettings) {
    var UNAUTHORIZED = 401;
    var currentRequest = null;

    PollingSettings.refresh();

    return {
        startTaskPolling: startTaskPolling,
        waitForPollRequest: waitForPollRequest
    };

    function startTaskPolling(tasks, scope) {
        scope.$broadcast(Events.polling.stop);

        var pollingContext = {
            taskUpdateDeferred: $q.defer(),
            timeoutPromise: null,
            cancelled: false
        };

        if (!scope.$$destroyed) {
            var pollableTasks = getPollableTasks(tasks);
            if (pollableTasks.length !== 0) {
                registerTimeoutCancellation(scope, pollingContext);
                poll(pollableTasks, pollingContext);
            }
        }

        return pollingContext.taskUpdateDeferred.promise;
    }

    function getPollableTasks(tasks) {
        return _.filter(tasks, function (task) {
            return TasksService.isTaskInProgress(task) || TasksService.isTaskFailed(task) || TasksService.isTaskWaitingForInput(task) || TasksService.isTaskPending(task) || TasksService.isTaskPreconditionInProgress(task) || TasksService.isTaskFailureHandlerInProgress(task) || TasksService.isTaskFacetInProgress(task);
        });
    }

    function registerTimeoutCancellation(scope, pollingContext) {
        var cancelHandler = function cancelHandler() {
            return cancel(pollingContext);
        };
        scope.$on('$destroy', cancelHandler);
        scope.$on(Events.polling.stop, cancelHandler);
    }

    function cancel(pollingContext) {
        Timeout.cancel(pollingContext.timeoutPromise);
        pollingContext.cancelled = true;
    }

    function poll(tasks, pollingContext) {
        if (pollingContext.cancelled) {
            return;
        }

        var onSuccess = function onSuccess(response) {
            if (pollingContext.cancelled) {
                return;
            }
            var serverTasks = response.data;
            updateTaskInfosFromServer(tasks, serverTasks);
            if (isAnyServerTaskUpdated(tasks, serverTasks)) {
                pollingContext.taskUpdateDeferred.resolve(serverTasks);
            } else {
                poll(tasks, pollingContext);
            }
        };

        var onError = function onError(response) {
            if (response.status !== UNAUTHORIZED) {
                Alerts.error(response);
            }
        };

        pollingContext.timeoutPromise = Timeout(function pollTaskStatus() {
            currentRequest = Backend.post('tasks/poll', { ids: _.map(tasks, 'id') }, { hideAlert: true }).then(onSuccess).catch(onError).finally(function () {
                return currentRequest = null;
            });
        }, PollingSettings.getPollingInterval());
    }

    function updateTaskInfosFromServer(tasks, serverTasks) {
        _.map(tasks, function (task) {
            if (TasksService.isCustomScriptTask(task)) {
                var serverTask = getAssociatedTask(task, serverTasks);
                task.statusLine = serverTask.statusLine;
            }
        });
    }

    function getAssociatedTask(task, serverTasks) {
        return _.find(serverTasks, function (candidate) {
            return task.id === candidate.id;
        });
    }

    function isAnyServerTaskUpdated(tasks, serverTasks) {
        return _.some(tasks, function (task) {
            var serverTask = getAssociatedTask(task, serverTasks);
            return task.status !== serverTask.status;
        });
    }

    function waitForPollRequest() {
        var deferred = $q.defer();

        if (currentRequest !== null) {
            currentRequest.finally(deferred.resolve);
        } else {
            deferred.resolve();
        }

        return deferred.promise;
    }
}]);

angular.module('xlrelease').factory('PollingSettings', ['Backend', function (Backend) {
    var pollingInterval = 1000;
    return {
        getPollingInterval: function getPollingInterval() {
            return pollingInterval;
        },
        refresh: function refresh() {
            return Backend.get('settings/polling-interval').then(function (resp) {
                return pollingInterval = resp.data * 1000;
            });
        }
    };
}]);

/***/ }),
/* 1268 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').filter('taskStatusCssClass', ['lowercaseFilter', function (lowercaseFilter) {
  return function (taskStatus) {
    return 'task-status-' + lowercaseFilter(taskStatus);
  };
}]);

/***/ }),
/* 1269 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').filter('taskTypeCssClass', ['lowercaseFilter', function (lowercaseFilter) {
    return function (taskType) {
        // Remove default prefix if any
        taskType = taskType.replace(/^xlrelease\./, '');

        // Replace any '.' with '-'
        taskType = taskType.replace(/\./g, '-');

        // Make everything lowercase
        taskType = lowercaseFilter(taskType);

        return 'task-type-' + taskType;
    };
}]);

/***/ }),
/* 1270 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('TasksController', ['$scope', 'Backend', 'TaskPolling', 'Events', 'Modal', 'filterSettings', 'TaskDetailsUpdates', 'ClientSettings', 'TaskConstants', function ($scope, Backend, TaskPolling, Events, Modal, filterSettings, TaskDetailsUpdates, ClientSettings, TaskConstants) {

    $scope.filters = filterSettings;

    $scope.orderByValues = [{
        label: 'Task due date',
        orderBy: 'due_date'
    }, {
        label: 'Task start date',
        orderBy: 'start_date'
    }];

    $scope.$on(Events.filters.filterChanged, function (e, filters) {
        loadTasks();
        ClientSettings.setTasksFilters(filters);
    });

    function loadTasks() {
        $scope.$emit(Events.permission.refresh);
        var config = {
            params: {
                limitTasksHint: TaskConstants.LIMIT_TASKS_HINT
            }
        };
        Backend.post('tasks/search', $scope.filters, config).then(function (resp) {
            var taskSearchView = resp.data;
            $scope.releases = taskSearchView.releaseTasks;
            orderReleases();
            $scope.limitReached = taskSearchView.limitReached;
            startPolling();
        });
    }

    function orderReleases(orderBy) {
        var originalReleases = $scope.releases;

        if (orderBy === "start_date") {
            _.forEach(originalReleases, function (release) {
                release.tasks = _.orderBy(release.tasks, ['startDate', 'scheduledStartDate'], ['asc', 'asc']);
            });
        } else {
            _.forEach(originalReleases, function (release) {
                release.tasks = _.orderBy(release.tasks, 'dueDate', 'asc');
            });
        }
    }

    loadTasks();

    function startPolling() {
        var tasks = _($scope.releases).map('tasks').flatten().value();
        TaskPolling.startTaskPolling(tasks, $scope).then(loadTasks);
        Modal.withScope($scope).onNextOpen(stopPolling).onNextClose(startPolling);
    }

    function stopPolling() {
        $scope.$broadcast(Events.polling.stop);
    }

    $scope.onTaskChange = function () {
        loadTasks();
    };

    $scope.onTaskDetailsClosed = function () {
        if (TaskDetailsUpdates.assigneeChanged) {
            loadTasks();
            TaskDetailsUpdates.reset();
        }
    };

    $scope.isOrderByActive = function isOrderByActive(order) {
        return $scope.activeOrderBy.orderBy === order;
    };

    $scope.onChange = orderReleases;
}]);

/***/ }),
/* 1271 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _dateService = __webpack_require__(709);

var _dateService2 = _interopRequireDefault(_dateService);

var _releasesStatusService = __webpack_require__(196);

var _releasesStatusService2 = _interopRequireDefault(_releasesStatusService);

var _ids = __webpack_require__(122);

var _ids2 = _interopRequireDefault(_ids);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DateService = (0, _dateService2.default)();
var ReleasesStatusService = (0, _releasesStatusService2.default)();
var Ids = (0, _ids2.default)();

function TaskService(Backend, Authenticator, UserProfile, TaskDetailsUpdates, VariablesService) {
    function isTaskPlanned(task) {
        return isStatusOneOf(task, 'PLANNED');
    }

    function isTaskPending(task) {
        return isStatusOneOf(task, 'PENDING');
    }

    function isTaskInProgress(task) {
        return isStatusOneOf(task, 'IN_PROGRESS');
    }

    function isTaskPreconditionInProgress(task) {
        return isStatusOneOf(task, 'PRECONDITION_IN_PROGRESS');
    }

    function isTaskFacetInProgress(task) {
        return isStatusOneOf(task, 'FACET_CHECK_IN_PROGRESS');
    }

    function isTaskFailureHandlerInProgress(task) {
        return isStatusOneOf(task, 'FAILURE_HANDLER_IN_PROGRESS');
    }

    function isTaskOrPreconditionInProgress(task) {
        return isTaskInProgress(task) || isTaskPreconditionInProgress(task) || isTaskFailureHandlerInProgress(task) || isTaskFacetInProgress(task);
    }

    function isTaskCompleted(task) {
        return isStatusOneOf(task, 'COMPLETED', 'ABORTED');
    }

    function isTaskCompletedInAdvance(task) {
        return isStatusOneOf(task, 'COMPLETED_IN_ADVANCE');
    }

    function isTaskSkippedInAdvance(task) {
        return isStatusOneOf(task, 'SKIPPED_IN_ADVANCE');
    }

    function isTaskDraggable(task, container) {
        var isReorderable = isTaskPlannedOrDoneInAdvance;
        if (container && isLocked(container)) {
            return false;
        }
        if (!isReorderable(task)) {
            return false;
        }
        return !(container && isParallelGroup(container) && !isReorderable(container));
    }

    function isTaskGroupDroppable(container) {
        if (!isTaskGroup(container) || isLocked(container)) {
            return false;
        }
        if (isParallelGroup(container)) {
            return isTaskPlanned(container) || isTaskPending(container);
        }
        if (isSequentialGroup(container)) {
            return !isTaskReadOnly(container);
        }
    }

    function isTaskSkipped(task) {
        return isStatusOneOf(task, 'SKIPPED');
    }

    function areAllRequiredValuesPresent(task) {
        var isRequiredAndEmpty = function isRequiredAndEmpty(v) {
            return v.requiresValue === true && (v.value === null || v.value === angular.undefined);
        };
        var emptyRequiredVariables = _.find(task.variables, function (v) {
            return isRequiredAndEmpty(v);
        });
        return !_.isObject(emptyRequiredVariables);
    }

    function isTaskFailed(task) {
        return isStatusOneOf(task, 'FAILED');
    }

    function isTaskFailing(task) {
        return isStatusOneOf(task, 'FAILING');
    }

    function isTaskDoneInAdvance(task) {
        return isTaskCompletedInAdvance(task) || isTaskSkippedInAdvance(task);
    }

    function isTaskPlannedOrDoneInAdvance(task) {
        return isTaskPlanned(task) || isTaskDoneInAdvance(task);
    }

    function isTaskWaitingForInput(task) {
        return isStatusOneOf(task, 'WAITING_FOR_INPUT');
    }

    function isUserInputTask(task) {
        return 'xlrelease.UserInputTask' === task.type;
    }

    function hasConfigurationUri(task) {
        return task.configurationUri;
    }

    function getConfigurationUri(task) {
        return 'static/8.6.1/' + task.configurationUri;
    }

    function isGateTask(task) {
        return 'xlrelease.GateTask' === task.type;
    }

    function isNotificationTask(task) {
        return 'xlrelease.NotificationTask' === task.type;
    }

    function isScriptTask(task) {
        return 'xlrelease.ScriptTask' === task.type || 'xlrelease.GroovyScriptTask' === task.type || 'xlrelease.ExternalScriptTask' === task.type;
    }

    function isTaskGroup(task) {
        return isParallelGroup(task) || isSequentialGroup(task);
    }

    function isUnknownTask(task) {
        return "Unknown Type" === task.typeDisplayName;
    }

    function isParallelGroup(task) {
        return 'xlrelease.ParallelGroup' === task.type;
    }

    function isSequentialGroup(task) {
        return 'xlrelease.SequentialGroup' === task.type;
    }

    function isManualTask(task) {
        return 'xlrelease.Task' === task.type;
    }

    function isCustomScriptTask(task) {
        return 'xlrelease.CustomScriptTask' === task.type;
    }

    function shouldTaskShowStatusLine(task) {
        return ['jenkins.Build', 'xlrelease.CreateReleaseTask', 'jira.CreateIssue', 'jira.UpdateIssue'].indexOf(task.scriptDefinitionType) !== -1;
    }

    function isTaskGroupInProgress(task) {
        return isTaskGroup(task) && isTaskInProgress(task);
    }

    function isCreateReleaseTask(task) {
        return 'xlrelease.CreateReleaseTask' === task.type;
    }

    function isParallelGroupInProgress(task) {
        return isParallelGroup(task) && isTaskInProgress(task);
    }

    function isTaskGroupSkippableOrRetriable(group) {
        var subTasks = _.flattenDeep(getSubTasks(group));
        return isTaskGroup(group) && isTaskFailed(group) && _.every(subTasks, isTaskPlannedOrDoneInAdvance);
    }

    function canUserInputTaskBeCompleted(task) {
        return isUserInputTask(task) && isTaskInProgress(task) && areAllRequiredValuesPresent(task);
    }

    function someGateConditionUnchecked(task) {
        return _.some(task.conditions, function (condition) {
            return condition.checked === false;
        });
    }

    function someGateDependencyUnresolved(task) {
        return _.some(task.dependencies, function (dependency) {
            return dependency.resolved === false;
        });
    }

    function isGateClosed(task) {
        return isGateTask(task) && (someGateConditionUnchecked(task) || someGateDependencyUnresolved(task));
    }

    function hasOwner(task) {
        return angular.isDefined(task.owner) && task.owner !== null;
    }

    function hasTeam(task) {
        return angular.isDefined(task.team) && task.team !== null;
    }

    function updateTaskStatusTo(status, id, commentText) {
        var comment = {
            text: commentText
        };
        return Backend.post("tasks/" + id + "/" + status, comment);
    }

    function startTaskWithInput(id, variables) {
        return Backend.post("api/v1/tasks/" + Ids.toDomainId(id) + "/start", { variables: variables });
    }

    function isAutomated(task) {
        return task.automated;
    }

    function getSubTasks(task) {
        if (isTaskGroup(task)) {
            return _.map(task.tasks, getSubTasks);
        }

        return [task];
    }

    function getAllSubTasks(task) {
        var subTasks = [];
        if (isTaskGroup(task)) {
            subTasks = _.map(task.tasks, getAllSubTasks);
        }

        return [subTasks, task];
    }

    function isDone(task) {
        return isStatusOneOf(task, 'COMPLETED', 'SKIPPED');
    }

    function isActive(task) {
        return isStatusOneOf(task, 'PENDING', 'PRECONDITION_IN_PROGRESS', 'WAITING_FOR_INPUT', 'IN_PROGRESS', 'FAILING', 'FAILED');
    }

    function isStatusOneOf(task) {
        return _.includes(arguments, task.status);
    }

    function canDelayTask(task) {
        return isTaskPlanned(task) || isTaskPending(task) || isTaskFailed(task) || isTaskWaitingForInput(task);
    }

    function isTaskDelayedDuringBlackout(task) {
        return task.delayDuringBlackout && canDelayTask(task);
    }

    function isTask(task) {
        return task.type !== 'xlrelease.ScmConnectedTemplate' && task.type !== 'xlrelease.Release' && task.type !== 'xlrelease.Phase';
    }

    function isTaskReadOnly(task) {
        return isTaskCompleted(task) || isTaskSkipped(task) || isTaskDoneInAdvance(task);
    }

    function isRemoveEnabled(task, release, container) {
        return canExecuteActionOnLockedTask(task, container) && !isTaskReadOnly(task) && !isTaskPending(task) && !isTaskWaitingForInput(task) && !isTaskInProgress(task) && !isTaskFailed(task) && !isParallelGroupInProgress(container) && !isTaskFailureHandlerInProgress(task) && !isTaskFacetInProgress(task) && Authenticator.hasEditPermission(release);
    }

    function isDuplicateEnabled(task, release, container) {
        return canExecuteActionOnLockedTask(task, container) && (!isTaskReadOnly(task) || isTaskDoneInAdvance(task)) && Authenticator.hasEditPermission(release) && !isParallelGroupInProgress(container);
    }

    function hasPermissionToWorkOnTask(release, task) {
        return Authenticator.hasPermissionToWorkOnTask(release, task);
    }

    function canWorkOnReadOnlyTask(release, task) {
        return hasPermissionToWorkOnTask(release, task);
    }

    function canUpdateFailedStatus(task) {
        return isTaskFailed(task) && (isAutomated(task) || hasOwner(task) || hasTeam(task));
    }

    function canWorkOnTask(release, task) {
        if (isTaskReadOnly(task)) {
            return false;
        }
        return hasPermissionToWorkOnTask(release, task);
    }

    function isReleaseInProgress(release) {
        return ReleasesStatusService.isReleaseInProgress(release);
    }

    function canCompleteTask(release, task) {
        if (canWorkOnTask(release, task) && !isTaskGroup(task) && !isAutomated(task)) {
            if (isTaskPlanned(task) && isReleaseInProgress(release)) {
                return canExecuteActionOnLockedTask(task) && canUpdatePlannedStatus(task) && !isGateClosed(task);
            }
            if (isTaskInProgress(task) && canUpdateInProgressStatus(task) && !isGateClosed(task)) {
                return isUserInputTask(task) ? canUserInputTaskBeCompleted(task) : true;
            }
        }
        return false;
    }

    function canEditTask(release, task) {
        return Authenticator.hasEditTaskPermission(release) && !isTaskReadOnly(task) && task.editable;
    }

    function canEditBlackout(release, task) {
        return Authenticator.hasEditBlackoutPermission(release) && canEditTask(release, task);
    }

    function canEditFailureHandler(release, task) {
        return Authenticator.hasEditFailureHandlerPermission(release) && canEditTask(release, task);
    }

    function canEditPrecondition(release, task) {
        return Authenticator.hasEditPreconditionPermission(release) && canEditTask(release, task);
    }

    function areTaskPropertiesReadonly(release, task) {
        return !canEditTask(release, task) || isTaskInProgress(task);
    }

    function canCommentOnTask(release, task) {
        return hasPermissionToWorkOnTask(release, task);
    }

    function canAddTask(release, taskGroup) {
        if (isLocked(taskGroup) || !Authenticator.hasEditPermission(release)) {
            return false;
        }
        if (isParallelGroup(taskGroup)) {
            return isTaskPlanned(taskGroup);
        }
        if (isSequentialGroup(taskGroup)) {
            return !isTaskReadOnly(taskGroup);
        }
        return false;
    }

    function addTask(container, taskForm) {
        return Backend.post("tasks/" + container.id, taskForm).then(function (addedTaskResp) {
            var addedTask = addedTaskResp.data;
            if (taskForm.taskType === 'xlrelease.ParallelGroup' || taskForm.taskType === 'xlrelease.SequentialGroup') {
                addedTask.wasJustAdded = true;
            }
            container.tasks.push(addedTask);
            return addedTask;
        });
    }

    function deleteTask(container, taskToDelete) {
        return Backend.del("tasks/" + taskToDelete.id).then(function () {
            container.tasks = _.filter(container.tasks, function (task) {
                return task.id !== taskToDelete.id;
            });
        });
    }

    function updateTask(task) {
        var taskForm = toTaskFullView(task);
        return Backend.put("tasks/" + taskForm.id, taskForm);
    }

    function duplicateTask(release, task, container) {
        return Backend.put("releases/" + release.id + "/tasks/duplicate/" + task.id).then(function (duplicatedTaskResp) {
            var duplicatedTask = duplicatedTaskResp.data;
            _.forEach(container.tasks, function (aTask, index) {
                if (aTask.id === task.id) {
                    container.tasks.splice(index + 1, 0, duplicatedTask);
                }
            });
            return duplicatedTask;
        });
    }

    function changeTaskType(container, task, convertToType) {
        task.disabledInView = true;
        return Backend.post("tasks/" + task.id + "/changeType?targetType=" + convertToType).then(function (newTaskResp) {
            task.disabledInView = false;
            var newTask = newTaskResp.data;
            newTask.$$hashKey = task.$$hashKey; //otherwise angular data-binding will be broken
            container.tasks[container.tasks.indexOf(task)] = newTask;
            return newTask;
        }).catch(function () {
            return task.disabledInView = false;
        });
    }

    function getTaskVariables(task) {
        return Backend.get("api/v1/tasks/" + Ids.toDomainId(task.id) + "/variables");
    }

    function isAssignedToUser(task, user) {
        return hasOwner(task) && user && task.owner.username === user.username;
    }

    function canAssignTaskToCurrentUser(task, release) {
        var taskNotAssignedToCurrentUser = !isAssignedToUser(task, UserProfile.getCurrentUser());
        var taskIsEditable = !isTaskReadOnly(task) && task.editable;
        var userHasReassignTaskPermission = Authenticator.hasReassignTaskPermission(release);
        var userInTeam = release.security.teams.indexOf(task.team) > -1;
        return taskNotAssignedToCurrentUser && taskIsEditable && (Authenticator.isAdmin() || userHasReassignTaskPermission && !isLocked(task) || userInTeam);
    }

    function canReassignTask(release, task) {
        var taskIsNotReadOnly = !isTaskReadOnly(task);
        var userHasReassignPermission = Authenticator.hasReassignTaskPermission(release);
        return canExecuteActionOnLockedTask(task) && userHasReassignPermission && taskIsNotReadOnly && task.editable;
    }

    function canExecuteActionOnLockedTask(task, container) {
        if (angular.isDefined(container) && isTaskGroup(container) && container.locked) {
            return false;
        }
        return !task.locked;
    }

    function assignToCurrentUser(task) {
        task.owner = UserProfile.getCurrentUser();
        return Backend.put("tasks/" + task.id + "/owner", toTaskFullView(task)).then(function () {
            TaskDetailsUpdates.assigneeChanged = true;
        });
    }

    function getTask(taskId) {
        return Backend.get("tasks/" + taskId);
    }

    function toTaskFullView(task) {
        return {
            checkAttributes: task.checkAttributes,
            cc: task.cc,
            bcc: task.bcc,
            replyTo: task.replyTo,
            from: task.from,
            mailPriority: task.mailPriority,
            addresses: task.addresses,
            body: task.body,
            createdReleaseId: task.createdReleaseId,
            delayDuringBlackout: task.delayDuringBlackout,
            deploymentPackage: task.deploymentPackage,
            description: task.description,
            dueDate: task.dueDate,
            environment: task.environment,
            failureHandler: task.failureHandler,
            taskFailureHandlerEnabled: task.taskFailureHandlerEnabled,
            taskRecoverOp: task.taskRecoverOp,
            flag: task.flag,
            gateId: task.gateId,
            id: task.id,
            inputProperties: task.inputProperties,
            newReleaseTitle: task.newReleaseTitle,
            outputProperties: task.outputProperties,
            owner: task.owner,
            password: task.password,
            plannedDuration: task.plannedDuration,
            precondition: task.precondition,
            releaseTags: task.releaseTags,
            riskProfileId: task.riskProfileId,
            scheduledStartDate: task.scheduledStartDate,
            script: task.script,
            scriptDefinitionType: task.scriptDefinitionType,
            server: task.server,
            startRelease: task.startRelease,
            subject: task.subject,
            tags: task.tags,
            team: task.team,
            templateId: task.templateId,
            folderId: task.folderId,
            title: task.title,
            type: task.type,
            username: task.username,
            variableMapping: task.variableMapping,
            variables: VariablesService.toSerializableVariables(task.variables),
            waitForScheduledStartDate: task.waitForScheduledStartDate,
            ignoreScriptVariableInterpolation: task.ignoreScriptVariableInterpolation,
            keepPreviousOutputPropertiesOnRetry: angular.isDefined(task.keepPreviousOutputPropertiesOnRetry) ? task.keepPreviousOutputPropertiesOnRetry : false
        };
    }

    function canUpdateInProgressStatus(task) {
        return isTaskInProgress(task) && !isAutomated(task) && (hasOwner(task) || hasTeam(task));
    }

    function canUpdatePlannedStatus(task) {
        return isTaskPlanned(task) && (hasOwner(task) || hasTeam(task));
    }

    function canSkipTask(release, task) {
        if (!task.locked) {
            if (isTaskInProgress(task) && !isAutomated(task)) {
                return canUpdateInProgressStatus(task) && canWorkOnTask(release, task);
            }

            if (isTaskPlanned(task) && isReleaseInProgress(release) && !isTaskGroup(task)) {
                return canUpdatePlannedStatus(task) && canWorkOnTask(release, task);
            }

            if (isTaskFailed(task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task))) {
                return canWorkOnFailedTask(release, task);
            }
        } else {
            return false;
        }
    }

    function canFailTask(release, task) {
        if (!isTaskReadOnly(task) && isTaskInProgress(task) && !isAutomated(task) && !isTaskGroup(task)) {
            return canUpdateInProgressStatus(task) && canWorkOnTask(release, task);
        }
        return false;
    }

    function canRetryTask(release, task) {
        if (isTaskFailed(task) && (!isTaskGroup(task) && !isUnknownTask(task) || isTaskGroupSkippableOrRetriable(task))) {
            return canWorkOnFailedTask(release, task) && (Authenticator.isAdminOr(task.releaseOwner) || Authenticator.isAdminOr(task.owner));
        }
        return false;
    }

    function canAbortTask(release, task) {
        if (isInProgressScriptTask(task) || isTaskPreconditionInProgress(task) || isTaskFailureHandlerInProgress(task) || isTaskFacetInProgress(task)) {
            return canWorkOnTask(release, task);
        }
        return false;
    }

    function canReopenTask(release, task) {
        if (isReleaseInProgress(release) && isTaskDoneInAdvance(task) && !isTaskGroup(task)) {
            return canWorkOnReadOnlyTask(release, task);
        }
        return false;
    }

    function canWorkOnFailedTask(release, task) {
        return canUpdateFailedStatus(task) && canWorkOnTask(release, task) && (!isTaskGroup(task) || isTaskGroupSkippableOrRetriable(task));
    }

    function isInProgressScriptTask(task) {
        return (isScriptTask(task) || isCustomScriptTask(task)) && isTaskInProgress(task);
    }

    var isLocked = function isLocked(task) {
        return task.locked;
    };

    var lock = function lock(taskId) {
        return Backend.put("api/v1/tasks/" + Ids.toDomainId(taskId) + "/lock");
    };

    var unlock = function unlock(taskId) {
        return Backend.del("api/v1/tasks/" + Ids.toDomainId(taskId) + "/lock");
    };

    var toInternalId = function toInternalId(releaseId) {
        return Ids.toInternalId(releaseId);
    };

    var hasDeploymentFacet = function hasDeploymentFacet(task) {
        return task.facets.filter(function (f) {
            return f.type === 'udm.DeploymentTaskFacet';
        }).length > 0;
    };

    return {
        toInternalId: toInternalId,
        hasOwner: hasOwner,
        hasTeam: hasTeam,
        isTaskPlanned: isTaskPlanned,
        isTaskPending: isTaskPending,
        isTaskInProgress: isTaskInProgress,
        isTaskFacetInProgress: isTaskFacetInProgress,
        isTaskPreconditionInProgress: isTaskPreconditionInProgress,
        isTaskFailureHandlerInProgress: isTaskFailureHandlerInProgress,
        isTaskOrPreconditionInProgress: isTaskOrPreconditionInProgress,
        isTaskCompleted: isTaskCompleted,
        isTaskCompletedInAdvance: isTaskCompletedInAdvance,
        isTaskSkippedInAdvance: isTaskSkippedInAdvance,
        isTaskDraggable: isTaskDraggable,
        isTaskGroupDroppable: isTaskGroupDroppable,
        isTaskSkipped: isTaskSkipped,
        isTaskFailed: isTaskFailed,
        isTaskFailing: isTaskFailing,
        isTaskDoneInAdvance: isTaskDoneInAdvance,
        isTaskWaitingForInput: isTaskWaitingForInput,
        isUserInputTask: isUserInputTask,
        isAutomated: isAutomated,
        canDelayTask: canDelayTask,
        isTaskDelayedDuringBlackout: isTaskDelayedDuringBlackout,
        isGateTask: isGateTask,
        isNotificationTask: isNotificationTask,
        isScriptTask: isScriptTask,
        isCustomScriptTask: isCustomScriptTask,
        isManualTask: isManualTask,
        isUnknownTask: isUnknownTask,
        isTaskGroup: isTaskGroup,
        isParallelGroup: isParallelGroup,
        isSequentialGroup: isSequentialGroup,
        isTaskGroupInProgress: isTaskGroupInProgress,
        isCreateReleaseTask: isCreateReleaseTask,
        isParallelGroupInProgress: isParallelGroupInProgress,
        isGateClosed: isGateClosed,
        getSubTasks: getSubTasks,
        getAllSubTasks: getAllSubTasks,
        isTaskGroupSkippableOrRetriable: isTaskGroupSkippableOrRetriable,
        shouldTaskShowStatusLine: shouldTaskShowStatusLine,
        canUserInputTaskBeCompleted: canUserInputTaskBeCompleted,
        areAllRequiredValuesPresent: areAllRequiredValuesPresent,
        isActive: isActive,
        isDone: isDone,
        isTaskReadOnly: isTaskReadOnly,
        isRemoveEnabled: isRemoveEnabled,
        isDuplicateEnabled: isDuplicateEnabled,
        hasPermissionToWorkOnTask: hasPermissionToWorkOnTask,
        canUpdateFailedStatus: canUpdateFailedStatus,
        canWorkOnReadOnlyTask: canWorkOnReadOnlyTask,
        canWorkOnTask: canWorkOnTask,
        canEditTask: canEditTask,
        canEditBlackout: canEditBlackout,
        canEditFailureHandler: canEditFailureHandler,
        canEditPrecondition: canEditPrecondition,
        canReassignTask: canReassignTask,
        areTaskPropertiesReadonly: areTaskPropertiesReadonly,
        canCommentOnTask: canCommentOnTask,
        canAddTask: canAddTask,
        addTask: addTask,
        deleteTask: deleteTask,
        duplicateTask: duplicateTask,
        updateTask: updateTask,
        changeTaskType: changeTaskType,
        startTaskWithInput: startTaskWithInput,
        getTaskVariables: getTaskVariables,
        assignToCurrentUser: assignToCurrentUser,
        getTask: getTask,
        isAssignedToUser: isAssignedToUser,
        canAssignTaskToCurrentUser: canAssignTaskToCurrentUser,
        toTaskFullView: toTaskFullView,
        hasConfigurationUri: hasConfigurationUri,
        getConfigurationUri: getConfigurationUri,
        canCompleteTask: canCompleteTask,
        canSkipTask: canSkipTask,
        canFailTask: canFailTask,
        canRetryTask: canRetryTask,
        canAbortTask: canAbortTask,
        canReopenTask: canReopenTask,
        canExecuteActionOnLockedTask: canExecuteActionOnLockedTask,

        isTaskAborted: function isTaskAborted(task) {
            return 'ABORTED' === task.status;
        },

        canUpdateInProgressStatus: canUpdateInProgressStatus,
        canWorkOnFailedTask: canWorkOnFailedTask,
        canUpdatePlannedStatus: canUpdatePlannedStatus,
        isInProgressScriptTask: isInProgressScriptTask,
        isStatusUpdatable: function isStatusUpdatable(task) {
            return isTaskInProgress(task) && !isAutomated(task) && (hasOwner(task) || hasTeam(task));
        },
        completeTask: function completeTask(taskId, commentText) {
            return updateTaskStatusTo('complete', taskId, commentText);
        },
        failTask: function failTask(taskId, commentText) {
            return updateTaskStatusTo('fail', taskId, commentText);
        },
        abortTask: function abortTask(taskId, commentText) {
            return updateTaskStatusTo('abort', taskId, commentText);
        },
        skipTask: function skipTask(taskId, commentText) {
            return updateTaskStatusTo('skip', taskId, commentText);
        },
        retryTask: function retryTask(taskId, commentText) {
            return updateTaskStatusTo('retry', taskId, commentText);
        },
        cancelTask: function cancelTask(taskId, commentText) {
            return updateTaskStatusTo('cancel', taskId, commentText);
        },
        startNow: function startNow(taskId, commentText) {
            return updateTaskStatusTo('startNow', taskId, commentText);
        },
        reopenTask: function reopenTask(taskId, commentText) {
            return updateTaskStatusTo('reopen', taskId, commentText);
        },
        isTaskDelayed: function isTaskDelayed(task) {
            if (!isTaskPlanned(task)) return false;
            return DateService.isOverdue(task.scheduledStartDate) || DateService.isOverdue(task.dueDate);
        },
        isAssignedToTeam: function isAssignedToTeam(task, team) {
            return hasTeam(task) && task.team === team;
        },

        isTask: isTask,
        isChangeTypeEnabled: function isChangeTypeEnabled(task, release, container) {
            return canExecuteActionOnLockedTask(task, container) && isRemoveEnabled(task, release, container) && !isTaskGroup(task);
        },
        isOfType: function isOfType(task, taskDefinition) {
            return taskDefinition.typeName === task.type || taskDefinition.typeName === task.scriptDefinitionType;
        },
        isValidCollapsedState: function isValidCollapsedState(state) {
            return typeof state === 'boolean';
        },

        isLocked: isLocked,
        lock: lock,
        unlock: unlock,
        hasDeploymentFacet: hasDeploymentFacet
    };
}

TaskService.$inject = ['Backend', 'Authenticator', 'UserProfile', 'TaskDetailsUpdates', 'VariablesService'];

angular.module('xlrelease').constant('TaskConstants', {
    LIMIT_TASKS_HINT: 30
});

angular.module('xlrelease').factory('TasksService', TaskService);

/***/ }),
/* 1272 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('userInputDetailsController', ['$scope', '$q', 'Authenticator', 'VariablesService', 'TasksService', function ($scope, $q, Authenticator, VariablesService, TasksService) {

    $scope.editVariableList = editVariableList;
    $scope.saveVariableList = saveVariableList;
    $scope.variableListHandler = { addCandidates: variablesAutocomplete };
    $scope.canEditVariableList = canEditVariableList;
    $scope.canEditVariables = canEditVariables();
    $scope.updateReleaseVariable = updateReleaseVariable;
    $scope.variableList = [];

    load();

    ///

    function load() {
        loadAvailableVariables($scope.release);
        $scope.$watch('userInputForm.$valid', function (validity) {
            $scope.$emit('formValidityChanged', validity);
        });
    }

    function loadAvailableVariables(release) {
        if (canEditVariableList()) {
            VariablesService.getReleaseVariables(release.id).then(function (resp) {
                var variables = resp.data;
                $scope.availableVariables = fillDisplayNames(variables);
                if ($scope.task.variables) {
                    updateTaskVariables(variables);
                }
            });
        }
    }

    function updateTaskVariables(variables) {
        $scope.task.variables = VariablesService.sortVariables(variables, task.variables);
    }

    function canEditVariableList() {
        return !TasksService.isTaskInProgress($scope.task) && !TasksService.isTaskReadOnly($scope.task) && Authenticator.hasEditTaskPermission($scope.release) && !TasksService.isTaskWaitingForInput($scope.task) && !TasksService.isLocked($scope.task);
    }

    function canEditVariables() {
        return TasksService.canWorkOnTask($scope.release, $scope.task) && !TasksService.isTaskWaitingForInput($scope.task);
    }

    function editVariableList() {
        loadAvailableVariables($scope.release);
        // update $scope.variableList without changing its reference: due to behavior of xl-dip-collection-of-ci
        $scope.variableList.length = 0;
        Array.prototype.push.apply($scope.variableList, fillDisplayNames($scope.task.variables));
    }

    function saveVariableList() {
        $scope.task.variables = _.clone($scope.variableList);
        $scope.saveTask($scope.task);
    }

    function variablesAutocomplete(metadata, options) {
        var deferred = $q.defer();
        var candidates = _.chain($scope.availableVariables).reject(function (releaseVar) {
            return _.find($scope.variableList, { key: releaseVar.key });
        }).filter(function (variable) {
            return variable.displayName.indexOf(options.term) !== -1;
        }).value();
        deferred.resolve(candidates);
        return deferred.promise;
    }

    function updateReleaseVariable(variable) {
        VariablesService.updateReleaseVariable(variable).then(function (resp) {
            var updatedVariable = resp.data;
            var taskVariable = _.find($scope.task.variables, function (taskVariable) {
                return taskVariable.id === updatedVariable.id;
            });
            if (taskVariable) {
                _.extend(taskVariable, updatedVariable);
            }
        });
    }

    function fillDisplayNames(variables) {
        return _.map(variables, function (variable) {
            variable.displayName = VariablesService.getLongDisplayName(variable);
            return variable;
        });
    }
}]);

/***/ }),
/* 1273 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var TemplateEditTriggerController = function () {
        function TemplateEditTriggerController($state, Page, Backend, MetadataService, VariablesService, template) {
            (0, _classCallCheck3.default)(this, TemplateEditTriggerController);

            this._$state = $state;
            this._Backend = Backend;
            this._MetadataService = MetadataService;
            this._VariablesService = VariablesService;

            this._template = template;
            this._trigger = null;
            this._descriptor = null;
            this._groupedProperties = null;
            this._variableProperties = null;

            var triggerId = $state.params.triggerId;

            if (triggerId) {
                this._loadTrigger(triggerId);
            } else {
                this._initializeNewTrigger($state.params.triggerType);
            }

            Page.setReleaseOpened(template);
        }

        (0, _createClass3.default)(TemplateEditTriggerController, [{
            key: '_loadTrigger',
            value: function _loadTrigger(triggerId) {
                var _this = this;

                var templateId = this._template.id;
                this._Backend.get('releases/' + templateId + '/triggers/' + triggerId).then(function (response) {
                    _this._trigger = response.data;
                    _this._loadMetadata(_this._trigger.type);
                });
            }
        }, {
            key: '_loadMetadata',
            value: function _loadMetadata(type) {
                var _this2 = this;

                return this._MetadataService.getDescriptor(type).then(function (descriptor) {
                    _this2._descriptor = descriptor;
                    _this2._groupedProperties = _.omit(descriptor.propertiesByCategory, 'hidden', 'variables');
                    _this2._variableProperties = _.pick(descriptor.propertiesByCategory, 'variables').variables;
                });
            }
        }, {
            key: '_initializeNewTrigger',
            value: function _initializeNewTrigger(triggerType) {
                var _this3 = this;

                var trigger = {
                    type: triggerType,
                    properties: {},
                    tags: []
                };

                this._VariablesService.getReleaseVariables(this._template.id).then(function (response) {
                    trigger.variables = response.data;

                    _this3._loadMetadata(triggerType).then(function () {
                        trigger.variables.forEach(function (variable) {
                            var propertyNames = _this3._variableProperties.map(function (variable) {
                                return variable.name;
                            });

                            if (propertyNames.includes(variable.key)) {
                                variable.value = _this3._VariablesService.getKey(variable);
                            }
                        });
                    });
                });

                this._trigger = trigger;
            }
        }, {
            key: 'listTriggers',
            value: function listTriggers() {
                this._$state.go('templateTriggers', {
                    releaseId: this._template.id
                });
            }
        }, {
            key: 'saveTrigger',
            value: function saveTrigger() {
                var _this4 = this;

                var templateId = this._template.id;

                if (this._trigger.id) {
                    var triggerId = this._trigger.id;
                    this._Backend.put('releases/' + templateId + '/triggers/' + triggerId, this._trigger).then(function () {
                        return _this4.listTriggers();
                    });
                } else {
                    this._Backend.post('releases/' + templateId + '/triggers/', this._trigger).then(function () {
                        return _this4.listTriggers();
                    });
                }
            }

            // 'Common' is the name given by the db when no categories are specified in the synthetic file

        }, {
            key: 'isNotCommonCategory',
            value: function isNotCommonCategory(category) {
                return 'Common' !== category;
            }
        }, {
            key: 'trigger',
            get: function get() {
                return this._trigger;
            }
        }, {
            key: 'descriptor',
            get: function get() {
                return this._descriptor;
            }
        }, {
            key: 'groupedProperties',
            get: function get() {
                return this._groupedProperties;
            }
        }, {
            key: 'variableProperties',
            get: function get() {
                return this._variableProperties;
            }
        }]);
        return TemplateEditTriggerController;
    }();

    TemplateEditTriggerController.$inject = ['$state', 'Page', 'Backend', 'MetadataService', 'VariablesService', 'template'];

    angular.module('xlrelease').controller('templateEditTriggerController', TemplateEditTriggerController);
})();

/***/ }),
/* 1274 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    var TemplateTriggersController = function () {
        function TemplateTriggersController($state, Authenticator, Permissions, Page, Backend, TemplatesService, template) {
            (0, _classCallCheck3.default)(this, TemplateTriggersController);

            this._$state = $state;
            this._Backend = Backend;
            this._TemplatesService = TemplatesService;

            this._template = template;
            this._triggers = null;
            this._triggerTypes = null;
            this._canCreateTriggers = Authenticator.hasPermission(Permissions.CREATE_RELEASE_FROM_TEMPLATE, template);

            this._loadTriggers();
            this._loadTriggerTypes();

            Page.setReleaseOpened(template);
        }

        (0, _createClass3.default)(TemplateTriggersController, [{
            key: '_loadTriggers',
            value: function _loadTriggers() {
                var _this = this;

                var templateId = this._$state.params.releaseId;
                this._Backend.get('releases/' + templateId + '/triggers').then(function (response) {
                    return _this._triggers = response.data;
                });
            }
        }, {
            key: '_loadTriggerTypes',
            value: function _loadTriggerTypes() {
                var _this2 = this;

                this._Backend.get('triggers/types').then(function (response) {
                    return _this2._triggerTypes = response.data;
                });
            }
        }, {
            key: 'addTrigger',
            value: function addTrigger(type) {
                this._$state.go('templateTriggersCreate', {
                    releaseId: this._template.id,
                    triggerType: type
                });
            }
        }, {
            key: 'deleteTrigger',
            value: function deleteTrigger(trigger) {
                var _this3 = this;

                var templateId = this._$state.params.releaseId;
                this._Backend.del('releases/' + templateId + '/triggers/' + trigger.id).then(function () {
                    return _this3._loadTriggers();
                });
            }
        }, {
            key: 'updateTemplate',
            value: function updateTemplate() {
                var _this4 = this;

                this._TemplatesService.update(this._template.id, this._template).then(function () {
                    return _this4._templateUpdatedAt = moment().toDate();
                });
            }
        }, {
            key: 'template',
            get: function get() {
                return this._template;
            }
        }, {
            key: 'triggers',
            get: function get() {
                return this._triggers;
            }
        }, {
            key: 'triggerTypes',
            get: function get() {
                return this._triggerTypes;
            }
        }, {
            key: 'templateUpdatedAt',
            get: function get() {
                return this._templateUpdatedAt;
            }
        }, {
            key: 'canCreateTriggers',
            get: function get() {
                return this._canCreateTriggers;
            }
        }]);
        return TemplateTriggersController;
    }();

    TemplateTriggersController.$inject = ['$state', 'Authenticator', 'Permissions', 'Page', 'Backend', 'TemplatesService', 'template'];

    angular.module('xlrelease').controller('templateTriggersController', TemplateTriggersController);
})();

/***/ }),
/* 1275 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('TemplatesController', ['$scope', 'Events', 'Backend', '$location', 'filters', 'ClientSettings', 'CisLoader', 'ViewStorage', 'TemplatesService', 'TagsService', function ($scope, Events, Backend, $location, filters, ClientSettings, CisLoader, ViewStorage, TemplatesService, TagsService) {
    $scope.filters = filters;
    $scope.allTags = [];

    $scope.filtersChanged = function (filters) {
        $scope.loadTemplates();
        ClientSettings.setTemplatesListFilters(filters);
    };

    function loadTemplates() {
        $scope.templates = null;
        $scope.templatesLoader = new CisLoader({
            filters: $scope.filters,
            searchCis: function searchCis(filters, config) {
                return TemplatesService.search(filters, config);
            },
            updateView: function updateView(templates) {
                $scope.templates = templates;
            }
        });
        $scope.templatesLoader.loadNextCis();
    }

    loadTemplates();

    $scope.loadTemplates = loadTemplates;

    $scope.initTemplateForm = function (template) {
        $scope.templateForm = {
            templateId: template.id,
            title: template.title,
            description: template.description,
            scheduledStartDate: template.scheduledStartDate
        };
    };

    TagsService.getReleaseTags().then(function (tags) {
        $scope.allTags = tags;
    });

    $scope.$on(Events.upload.success, loadTemplates);
}]);

/***/ }),
/* 1276 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(function () {
    'use strict';

    var DEFAULT_TEMPLATE_LIST_SIZE = 1000;
    var DEFAULT_TEMPLATE_LIST_DEPTH = 1;

    var TemplatesService = function () {
        function TemplatesService(Backend) {
            (0, _classCallCheck3.default)(this, TemplatesService);

            this._backend = Backend;
        }

        (0, _createClass3.default)(TemplatesService, [{
            key: 'getAll',
            value: function getAll() {
                return this._backend.post('releases/templates/search', {}, { params: { numberbypage: DEFAULT_TEMPLATE_LIST_SIZE, depth: DEFAULT_TEMPLATE_LIST_DEPTH } });
            }
        }, {
            key: 'getAllIds',
            value: function getAllIds() {
                return this._backend.get('releases/templates/search', { params: { numberbypage: DEFAULT_TEMPLATE_LIST_SIZE } });
            }
        }, {
            key: 'search',
            value: function search(filters, config) {
                return this._backend.post('releases/templates/search', filters, config);
            }
        }, {
            key: 'create',
            value: function create(template) {
                var templateForm = {
                    title: template.title,
                    description: template.description,
                    tags: template.tags,
                    scheduledStartDate: template.scheduledStartDate,
                    dueDate: template.dueDate,
                    plannedDuration: template.plannedDuration,
                    abortOnFailure: template.abortOnFailure,
                    allowConcurrentReleasesFromTrigger: template.allowConcurrentReleasesFromTrigger,
                    scriptUsername: template.scriptUsername,
                    scriptUserPassword: template.scriptUserPassword,
                    variables: template.variables,
                    syntheticProperties: template.syntheticProperties,
                    parentId: template.parentId
                };
                return this._backend.post('releases/templates', templateForm);
            }
        }, {
            key: 'update',
            value: function update(templateId, template) {
                var templateForm = {
                    title: template.title,
                    description: template.description,
                    tags: template.tags,
                    scheduledStartDate: template.scheduledStartDate,
                    dueDate: template.dueDate,
                    plannedDuration: template.plannedDuration,
                    abortOnFailure: template.abortOnFailure,
                    allowConcurrentReleasesFromTrigger: template.allowConcurrentReleasesFromTrigger,
                    scriptUsername: template.scriptUsername,
                    scriptUserPassword: template.scriptUserPassword,
                    variables: template.variables,
                    syntheticProperties: template.syntheticProperties
                };
                return this._backend.put('releases/templates/' + templateId, templateForm);
            }
        }]);
        return TemplatesService;
    }();

    TemplatesService.$inject = ['Backend'];

    angular.module('xlrelease').service('TemplatesService', TemplatesService);
})();

/***/ }),
/* 1277 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('UploadController', ['$scope', 'UploadService', function ($scope, UploadService) {
    UploadService.reset();
    $scope.UploadService = UploadService;

    $scope.setFolderId = function (folderId) {
        $scope.folderId = folderId;
    };
}]);

/***/ }),
/* 1278 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * @description
 * Directive to handle file uploads.
 * Must be used on a parent container of a file-input field.

 * Provides an upload() method in the scope to trigger the upload.
 *
 * @example
 * <div upload upload-type="templates">
 *     <input type="file/>
 *     <a ng-click="upload()">
 * </div>
 */
angular.module('xlrelease').directive('upload', ['UploadService', 'Events', '$parse', function (UploadService, Events, $parse) {

    return {
        link: function link(scope, element, attrs) {
            var dataSubmitter = null;

            var uploadUrl = void 0;
            scope.$watch(attrs.uploadUrl, function (newValue) {
                uploadUrl = newValue;
            });
            var clientCallback = attrs.onSuccess;
            var auto = 'auto' in attrs;

            angular.element(element).fileupload({
                // file input should not be replaced in UI when auto-mode is not set.
                replaceFileInput: auto,
                add: function add(e, data) {
                    dataSubmitter = data;
                    if (auto) {
                        upload();
                    }
                },
                progressall: function progressall() {
                    scope.$apply(UploadService.uploadProgressed);
                },

                fail: onFailure,
                done: onSuccess
            });

            var upload = function upload() {
                // Setting the upload url
                angular.element(element).fileupload('option', 'url', uploadUrl);
                dataSubmitter.submit();
            };

            if (!auto) {
                scope.upload = upload;
            }

            function onFailure(e, data) {
                scope.$apply(function () {
                    UploadService.uploadFailed(data.jqXHR.responseText);
                });
            }

            function onSuccess(e, data) {
                // On IE9 since it's based on an iframe, fail() is not called, we have to check if data.result is defined.
                if (_.isUndefined(data.result)) {
                    onFailure(e, data);
                    return;
                }

                var result = void 0;
                try {
                    // On IE9 since it's based on an iframe, the result is an html node.
                    var resultText = void 0;
                    if (_.includes(data.dataType, 'iframe')) {
                        resultText = angular.element(data.result).text();
                    } else {
                        resultText = data.result;
                    }
                    result = angular.fromJson(resultText);
                } catch (parseError) {
                    // On IE9 since it's based on an iframe, in case of a server side error
                    // the result can't be parsed.
                    onFailure(e, data);
                    return;
                }

                scope.$apply(function () {
                    scope.$emit(Events.upload.success, result);
                    UploadService.uploadSuccess(result);
                    $parse(clientCallback)(scope, { uploadResult: result });
                });
            }
        }
    };
}]);

/**
 * @description
 * Directive to handle form validation on input type=file, must be used with a ng-model.
 *
 * @example
 * <input type="file" file-input ng-model="file"/>
 */
angular.module('xlrelease').directive('fileInput', [function () {
    return {
        require: 'ngModel',
        link: function link(scope, element, attr, ngModel) {
            element.bind('change', function () {
                scope.$apply(function () {
                    var fileList = element[0].files;
                    var file = '';
                    if (fileList.length > 0) {
                        file = fileList[fileList.length - 1].name;
                    }
                    ngModel.$setValidity(attr.ngModel, true);
                    ngModel.$setViewValue(file);
                });
            });
        }
    };
}]);

/***/ }),
/* 1279 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('UploadService', [function () {
    var data = {};
    return {
        data: data,
        uploadProgressed: function uploadProgressed() {
            data.loading = true;
        },
        uploadFailed: function uploadFailed(errorMessage) {
            data.loading = false;
            data.error = true;
            data.errorMessage = errorMessage;
        },
        uploadSuccess: function uploadSuccess(result) {
            data.loading = false;
            data.result = result;
            data.error = false;
        },
        reset: function reset() {
            delete data.loading;
            delete data.result;
            delete data.error;
            delete data.errorMessage;
        }
    };
}]);

/***/ }),
/* 1280 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ContentTypeService = function () {
    function ContentTypeService(Backend) {
        (0, _classCallCheck3.default)(this, ContentTypeService);

        this._Backend = Backend;
    }

    (0, _createClass3.default)(ContentTypeService, [{
        key: 'getContentTypesForImage',
        value: function getContentTypesForImage() {
            return this._Backend.get('settings/content-type/image');
        }
    }]);
    return ContentTypeService;
}();

ContentTypeService.$inject = ['Backend'];


angular.module('xlrelease').service('ContentTypeService', ContentTypeService);

/***/ }),
/* 1281 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _is = __webpack_require__(1282);

var _is2 = _interopRequireDefault(_is);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This service is used by all controllers that needs to handle single CI such as SMTP CI or ReportsSettings CI.
 * Usage:
 *  var manager = new CIManager({
 *      type: type,
 *      directory: directory,
 *      loadCallback: loadCallback,
 *      saveCallback: saveCallback,
 *  });
 */
angular.module('xlrelease').factory('CIManager', ['Backend', function (Backend) {
    return function (settings) {
        var manager = {
            ci: {},
            type: null,
            lastSavedDate: null,
            ciLoaded: false,
            editableProperties: null,
            save: save,
            deleteCi: deleteCi
        };
        var ciExists = false;
        var URL = (0, _is2.default)(settings.customURL, undefined) ? 'settings/ci/' + settings.directory + '/' + settings.type : settings.customURL;

        Backend.get('metadata/type/xlrelease.' + settings.type).then(function (resp) {
            manager.type = resp.data;
            manager.editableProperties = resp.data.properties.filter(function (obj) {
                return obj.name !== 'folderId';
            });
        });

        Backend.get(URL, { hideAlert: true }).then(function (resp) {
            manager.ci = resp.data;
            manager.ciLoaded = true;
            ciExists = true;
        }, function (err) {
            manager.ciLoaded = true;
            ciExists = false;
        }).finally(function () {
            if (settings.loadCallback) {
                settings.loadCallback(manager.ci);
            }
        });

        function save() {
            if (ciExists) {
                return Backend.put(URL, manager.ci).then(function (resp) {
                    return ciSaved(resp.data);
                });
            } else {
                manager.ci.type = 'xlrelease.' + settings.type;
                manager.ci.id = settings.directory + '/' + settings.type;
                return Backend.post(URL, manager.ci).then(function (resp) {
                    return ciSaved(resp.data);
                });
            }
        }

        function ciSaved(ci) {
            ciExists = true;
            manager.lastSavedDate = moment().toDate();
            manager.ci = ci;
            if (settings.saveCallback) {
                settings.saveCallback();
            }
        }

        function deleteCi() {
            return Backend.del(URL).then(function (resp) {
                return ciDeleted();
            });
        }

        function ciDeleted() {
            ciExists = false;
            manager.lastSavedDate = moment().toDate();
            manager.ci = {};
            if (settings.deleteCallback) {
                settings.deleteCallback();
            }
        }

        return manager;
    };
}]);

/***/ }),
/* 1282 */,
/* 1283 */,
/* 1284 */,
/* 1285 */,
/* 1286 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Load CIs by page.
 *
 * Usage:
 *   var cisLoader = new CisLoader(settings)
 *   cisLoader.loadNextCis()
 *
 * settings:
 *  - filters: cis filters
 *  - updateView: call with cis when they are loaded
 *      ex:
 *      function updateView(releases) {
 *          $scope.releases = releases;
 *      }
 *
 * Available methods to monitor cis loader state:
 *  - isLoading
 *  - hasMoreCis
 *  - hasError
 */

angular.module('xlrelease').factory('CisLoader', ['$q', 'CiLoaderSettings', function ($q, CiLoaderSettings) {
    return function (settings) {
        var serverPage = 0;
        var cis = [];
        var endReached = false;
        var loading = false;
        var errorOccurred = false;

        this.loadNextCis = function (onMoreLoadedCallback) {
            searchNext().then(function (nextCis) {
                if (!_.isEmpty(nextCis)) {
                    cis = cis.concat(nextCis);
                    settings.updateView(cis);

                    if (onMoreLoadedCallback) onMoreLoadedCallback();
                }
            });
        };

        function searchNext() {
            var deferred = $q.defer();
            loading = true;
            settings.searchCis(settings.filters, {
                params: {
                    page: serverPage,
                    numberbypage: CiLoaderSettings.itemsByPage
                }
            }).then(function (resp) {
                var result = resp.data;
                if (result.cis.length < CiLoaderSettings.itemsByPage) {
                    endReached = true;
                }
                if (result.cis.length !== 0) {
                    serverPage = result.page;
                }
                deferred.resolve(result.cis);
            }, function () {
                errorOccurred = true;
                endReached = true;
                deferred.resolve([]);
            }).finally(function () {
                loading = false;
            });

            return deferred.promise;
        }

        this.isLoading = function () {
            return loading;
        };

        this.hasMoreCis = function () {
            return !endReached;
        };

        this.hasError = function () {
            return errorOccurred;
        };
    };
}]);

angular.module('xlrelease').constant('CiLoaderSettings', {
    itemsByPage: 15,
    itemsMaxDepth: 10
});

/***/ }),
/* 1287 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ClientSettings', ['LocalStorageWrapper', 'DateService', function (LocalStorageWrapper, DateService) {
    var localStorageCache = {};

    var knownItems = [{ name: 'AttachmentsState', mapItem: true, daysValidity: 8 }, { name: 'AuthenticationData' }, { name: 'CalendarFilters' }, { name: 'CommentsState', mapItem: true, daysValidity: 8 }, { name: 'FacetsCollapseState', mapItem: true, daysValidity: 8 }, { name: 'FailureHandlerCollapseState', mapItem: true, daysValidity: 8 }, { name: 'FolderLayoutCache' }, { name: 'FolderListCache' }, { name: 'FolderReleaseFiltersLayout' }, { name: 'GanttDatesColumnsCollapseState' }, { name: 'GanttElementsCollapseState' }, { name: 'GanttZoomLevel' }, { name: 'GroupsListFilters' }, { name: 'IdentityProvider' }, { name: 'LogsFilters', mapItem: true, daysValidity: 30 }, { name: 'Permissions' }, { name: 'PreConditionCollapseState', mapItem: true, daysValidity: 8 }, { name: 'ReleaseEditorCollapseState', mapItem: true, daysValidity: 30 }, { name: 'ReleaseEditorTaskFilters', mapItem: true, daysValidity: 30 }, { name: 'ReleaseFiltersLayout' }, { name: 'ReleaseGridCache' }, { name: 'ReleasesListFilters' }, { name: 'ReleaseValueStreamFilters' }, { name: 'ReportsFilters' }, { name: 'RestartPhaseVersion' }, { name: 'TasksFilters' }, { name: 'TemplatesListFilters' }, { name: 'FolderDashboardListFilters' }];

    function generateGetter(name) {
        return function () {
            var data = localStorageCache[name];
            if (angular.isUndefined(data) || data === null) {
                data = LocalStorageWrapper.getItem(name);
                if (data) {
                    localStorageCache[name] = data;
                }
            }
            return data ? angular.fromJson(data) : null;
        };
    }

    function generateMapItemGetter(name) {
        return function (id) {
            var data = void 0;
            var rawMap = localStorageCache[name];
            if (rawMap) {
                var map = angular.fromJson(rawMap);
                data = map[id];
                if (angular.isUndefined(data) || data === null) {
                    data = fromRefreshedCache(name, id);
                }
            } else {
                data = fromRefreshedCache(name, id);
            }
            return data;
        };
    }

    function fromRefreshedCache(name, id) {
        var rawMap = LocalStorageWrapper.getItem(name);
        localStorageCache[name] = rawMap;
        if (rawMap) {
            var map = angular.fromJson(rawMap);
            return map ? map[id] : null;
        }
        return null;
    }

    function generateSetter(name) {
        return function (value) {
            localStorageCache[name] = angular.toJson(value);
            LocalStorageWrapper.setItem(name, angular.toJson(value));
        };
    }

    function generateMapItemSetter(name, daysValidity) {
        return function (id, value) {
            var rawMap = localStorageCache[name];
            var map = rawMap ? angular.fromJson(rawMap) : { validities: {} };
            map[id] = value;

            if (daysValidity) {
                storeValidity(map, id);
                cleanInvalids(map);
            }

            localStorageCache[name] = angular.toJson(map);
            LocalStorageWrapper.setItem(name, angular.toJson(map));
        };

        function storeValidity(map, id) {
            map.validities[id] = DateService.getTodayWithTime().add(daysValidity, 'days').valueOf();
        }

        function cleanInvalids(map) {
            var now = DateService.getTodayWithTime().valueOf();
            _.forOwn(map.validities, function (timestamp, id) {
                if (parseInt(timestamp, 10) < now) {
                    delete map[id];
                    delete map.validities[id];
                }
            });
        }
    }

    function generateMapItemRemover(name) {
        return function (id) {
            var rawMap = localStorageCache[name];
            if (!rawMap) {
                rawMap = LocalStorageWrapper.getItem(name);
            }
            var map = angular.fromJson(rawMap);
            delete map[id];
            localStorageCache[name] = angular.toJson(map);
            LocalStorageWrapper.setItem(name, angular.toJson(map));
        };
    }

    function generateRemover(name) {
        return function () {
            LocalStorageWrapper.removeItem(name);
            delete localStorageCache[name];
        };
    }

    var result = {
        clear: function clear() {
            _.forEach(knownItems, function (item) {
                LocalStorageWrapper.removeItem(item.name);
                delete localStorageCache[item.name];
            });
            ['filters:releaseOverview'].forEach(function (item) {
                LocalStorageWrapper.removeItem(item);
            });
        }
    };
    _.forEach(knownItems, function (item) {
        result['get' + item.name] = item.mapItem ? generateMapItemGetter(item.name) : generateGetter(item.name);
        result['set' + item.name] = item.mapItem ? generateMapItemSetter(item.name, item.daysValidity) : generateSetter(item.name);
        result['remove' + item.name] = item.mapItem ? generateMapItemRemover(item.name) : generateRemover(item.name);
    });

    return result;
}]);

/***/ }),
/* 1288 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ColorService', ['ReleasesService', 'PhaseColors', function (ReleasesService, PhaseColors) {
    var pastBackgroundColor = '#f1f1f1';

    function desaturate(color) {
        return chroma.interpolate(color, pastBackgroundColor, 0.5).hex();
    }

    return {
        computeDayColor: function computeDayColor(day) {
            if (!day.color) return null;
            return day.dateStatus === 'past' ? desaturate(day.color) : day.color;
        },
        computePhaseColor: function computePhaseColor(release, phase) {
            var color = phase.color || PhaseColors[0].value;
            return ReleasesService.isReleaseCompleted(release) ? desaturate(color) : color;
        }
    };
}]);

/***/ }),
/* 1289 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ConfigurationItemService', [function () {
    return {
        getCIDuration: function getCIDuration(configurationItem) {
            if (!configurationItem.startDate || !configurationItem.endDate) {
                return 0;
            }
            return configurationItem.endDate - configurationItem.startDate;
        }
    };
}]);

/***/ }),
/* 1290 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').run(['$rootScope', 'Timeout', function ($rootScope, Timeout) {
    $rootScope.delayedWatch = function (delay, watchExp, listener, objectEquality) {
        var timeout = void 0;
        this.$watch(watchExp, function (newValue, oldValue) {
            if (newValue === oldValue) return;

            if (timeout) {
                Timeout.cancel(timeout);
            }

            timeout = Timeout(_.partial(listener, newValue, oldValue), delay);
        }, objectEquality);
    };
}]);

/***/ }),
/* 1291 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('Download', [function () {
    return {
        url: null,
        launch: function launch(url) {
            // Set the iframe URL, which triggers the download
            // Added cache buster to make repeated downloads possible
            var timestamp = new Date().getTime();
            if (url.indexOf('?') > -1) {
                url = url + '&';
            } else {
                url = url + '?';
            }
            url = url + $.param({ cb: timestamp });
            this.url = url;
        }
    };
}]);

angular.module('xlrelease').directive('downloader', ['Download', function (Download) {
    return {
        template: '<iframe ng-src="{{ Download.url }}" style="display: none;"></iframe>',
        link: function link(scope) {
            scope.Download = Download;
        }
    };
}]);

/***/ }),
/* 1292 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _create = __webpack_require__(710);

var _create2 = _interopRequireDefault(_create);

var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').service('EventBus', ['$timeout', function ($timeout) {
    var EventBus = function EventBus() {
        (0, _classCallCheck3.default)(this, EventBus);

        this.registry = [];
    };

    EventBus.prototype = (0, _create2.default)(EventEmitter.prototype);

    var eventBus = new EventBus();
    // methods to manage registry of wrappers
    EventBus.prototype.addWrapper = function (listener, wrapper) {
        eventBus.registry.push({
            listener: listener,
            wrapper: wrapper
        });
    };
    EventBus.prototype.getWrapper = function (listener) {
        return _.find(eventBus.registry, { listener: listener }).wrapper;
    };
    EventBus.prototype.removeWrapper = function (wrapper) {
        _.remove(eventBus.registry, { wrapper: wrapper });
    };
    // overriding EventEmitter methods
    EventBus.prototype.addListener = function (event, listener) {
        var wrapper = function wrapper(params) {
            $timeout(function () {
                return listener(params);
            }, 0);
        };
        eventBus.addWrapper(listener, wrapper);
        EventEmitter.prototype.addListener.call(eventBus, event, wrapper);
    };

    EventBus.prototype.removeListener = function (event, listener) {
        var wrapper = eventBus.getWrapper(listener);
        EventEmitter.prototype.removeListener.call(eventBus, event, wrapper);
        eventBus.removeWrapper(wrapper);
    };

    return eventBus;
}]);

/***/ }),
/* 1293 */,
/* 1294 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').constant('Events', {
    permission: {
        unauthorized: 'UNAUTHORIZED',
        forbidden: 'FORBIDDEN',
        refresh: 'REFRESH-PERMISSIONS',
        loggedIn: 'LOGGED-IN'
    },
    polling: {
        stop: 'STOP-TASK-POLLING'
    },
    timeline: {
        resize: 'RESIZE-TIMELINE',
        hasBeenResized: 'TIMELINE-RESIZED'
    },
    gantt: {
        openTaskDetails: 'OPEN-TASK-DETAILS',
        openPhaseDetails: 'OPEN-PHASE-DETAILS',
        hasBeenRefreshed: 'GANTT-REFRESHED'
    },
    filters: {
        filterChanged: 'FILTERS-FILTER-CHANGED'
    },
    grid: {
        refresh: 'REFRESH-RELEASE-GRID',
        edit: 'EDIT-RELEASE-GRID-ITEM'
    },
    tile: {
        resized: 'TILE-RESIZED'
    },
    upload: {
        success: 'UPLOAD-SUCCEEDED'
    },
    folders: {
        filterChanged: 'FOLDERS-FILTER-CHANGED',
        refresh: 'FOLDERS-REFRESH-GRID',
        loaded: 'FOLDERS-LOADED',
        createNew: 'FOLDERS-CREATE-NEW',
        rename: 'FOLDERS-RENAME',
        postRename: 'FOLDERS-RENAME-POST',
        delete: 'FOLDERS-DELETE',
        add: 'FOLDERS-ADD',
        cleanCache: 'FOLDERS-CLEAN-CACHE'
    },
    uiLayout: {
        collapse: 'COLLAPSE',
        expand: 'EXPAND',
        resize: 'RESIZE'
    },
    breadcrumbs: {
        update: 'BREADCRUMBS-UPDATE'
    },
    calendar: {
        setLabel: 'CALENDAR-SET-LABEL',
        setBlackout: 'CALENDAR-SET-BLACKOUT'
    },
    ui: {
        themeRefresh: 'UI-THEME-REFRESH',
        subMenuRefresh: 'SUB-MENU-REFRESH',
        customLogoRefresh: 'UI-CUSTOM-LOGO-REFRESH'
    },
    settings: {
        systemMessageUpdated: 'SETTINGS-SYSTEM-MESSAGE-UPDATE'
    }
});

/***/ }),
/* 1295 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

var _marked = __webpack_require__(1296);

var _marked2 = _interopRequireDefault(_marked);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').filter('dateFormatter', ['dateFilter', function (dateFilter) {
    return function (inputDate, format) {
        if (_(inputDate).isUndefined() || _(inputDate).isNull()) {
            return undefined;
        }
        var momentDate = moment(inputDate);
        if (moment().isSame(momentDate, 'day')) {
            return "Today";
        }
        return dateFilter(momentDate.toDate(), format || 'shortDate');
    };
}]).filter('timeFormatter', ['dateFilter', function (dateFilter) {
    return function (inputDate) {
        if (_(inputDate).isUndefined() || _(inputDate).isNull()) {
            return undefined;
        }
        return dateFilter(inputDate, 'shortTime');
    };
}]).filter('statusFormatter', function () {
    var statuses = {
        "TEMPLATE": "Template",
        "PLANNED": "Planned",
        "IN_PROGRESS": "In progress",
        "COMPLETED": "Completed",
        "FAILED": "Failed"
    };
    return function (inputStatus) {
        return statuses[inputStatus];
    };
}).filter('newlines', function () {
    function repeat(string, times) {
        return new Array(times + 1).join(string);
    }

    return function (text) {
        if (_(text).isUndefined() || _(text).isNull()) {
            return text;
        }
        return text.replace(/\t/g, '  ').replace(/^([^\S\n]+)/gm, function (ignored, match) {
            return repeat("&nbsp;", match.length);
        }).replace(/\n/g, '<br/>');
    };
}).filter('noHTML', function () {
    return function (text) {
        if (_(text).isUndefined() || _(text).isNull()) {
            return text;
        }
        return text.replace(/&/g, '&amp;').replace(/>/g, '&gt;').replace(/</g, '&lt;');
    };
}).filter('markdown', function () {
    _marked2.default.setOptions({
        sanitize: true
    });
    return function (text) {
        if (!text) {
            return '';
        }
        return (0, _marked2.default)(text);
    };
}).filter('userFormatter', function () {
    return function (user) {
        if (!user || !user.username) {
            return '';
        }
        return user.fullName ? user.fullName : user.username;
    };
}).filter('usernameFormatter', function () {
    return function (user) {
        if (!user || !user.username) {
            return '';
        }
        return user.fullName ? user.fullName + ' (' + user.username + ')' : user.username;
    };
}).filter('memberFormatter', function () {
    return function (member) {
        if (!member || !member.name) {
            return '';
        }
        return member.fullName ? member.fullName : member.name;
    };
}).filter('memberNameFormatter', function () {
    return function (member) {
        if (!member || !member.name) {
            return '';
        }
        return member.fullName ? member.fullName + ' (' + member.name + ')' : member.name;
    };
}).filter('configurationItemTypeFormatter', function (StringService) {
    return function (type) {
        if (!type) {
            return '';
        }

        var prefix = type.substring(0, type.indexOf('.'));
        var typeName = type.substring(type.indexOf('.') + 1);
        return StringService.capitalizeFirstLetter(prefix) + ': ' + StringService.capitalizeFirstLetter(StringService.deCamelize(typeName).toLowerCase());
    };
}).filter('shortConfigurationItemTypeFormatter', function (StringService) {
    return function (type) {
        if (!type) {
            return '';
        }

        var typeName = type.substring(type.indexOf('.') + 1);
        return StringService.capitalizeFirstLetter(StringService.deCamelize(typeName).toLowerCase());
    };
}).filter('prettyConfigurationItemLabelFormatter', function () {
    return function (label) {
        if (!label) {
            return '';
        }

        return label.split(':').join('');
    };
}).filter('toDate', function () {
    return function (date) {
        return moment.isMoment(date) ? date.toDate() : date;
    };
}).filter('capitalize', function (StringService) {
    return function (input) {
        if (!input) {
            return '';
        }
        return StringService.capitalizeFirstLetter(StringService.deCamelize(input).toLowerCase());
    };
}).filter('toArray', function () {
    return function (obj, addKey) {
        if (!angular.isObject(obj)) return obj;
        if (addKey === false) {
            return (0, _keys2.default)(obj).map(function (key) {
                return obj[key];
            });
        } else {
            return (0, _keys2.default)(obj).map(function (key) {
                var value = obj[key];
                return angular.isObject(value) ? Object.defineProperty(value, '$key', { enumerable: false, value: key }) : { $key: key, $value: value };
            });
        }
    };
});

/***/ }),
/* 1296 */,
/* 1297 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


$.fn.hasVerticalScrollBar = function () {
    return this.get(0) ? this.get(0).scrollHeight > this.innerHeight() : false;
};

/***/ }),
/* 1298 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var GridStateService = function () {
    function GridStateService(ClientSettings) {
        (0, _classCallCheck3.default)(this, GridStateService);

        this._ClientSettings = ClientSettings;
    }

    (0, _createClass3.default)(GridStateService, [{
        key: 'saveState',
        value: function saveState(grid, cacheName, qualifier) {
            var rowCache = _(this._getGridRows(grid)).map(function (row) {
                return {
                    'id': row.entity.id,
                    'state': row.treeNode.state
                };
            }).value();

            var currentCache = this._getCache(cacheName);
            currentCache[qualifier] = rowCache;

            this._setCache(cacheName, currentCache);
        }
    }, {
        key: 'loadState',
        value: function loadState(grid, cacheName, qualifier) {
            if (!this._hasCache(cacheName, qualifier)) {
                return;
            }

            var rowCache = this._getCache(cacheName)[qualifier];

            _.forEach(this._getGridRows(grid), function (row) {
                var cachedRow = _.find(rowCache, { 'id': row.entity.id });

                if (!_.isEmpty(cachedRow)) {
                    row.treeNode.state = cachedRow.state;
                }
            });

            grid.queueGridRefresh();
        }

        ////

    }, {
        key: '_setCache',
        value: function _setCache(cacheName, cache) {
            return this._ClientSettings['set' + cacheName](cache);
        }
    }, {
        key: '_getCache',
        value: function _getCache(cacheName) {
            var cache = this._ClientSettings['get' + cacheName]();
            return _.isEmpty(cache) ? {} : cache;
        }
    }, {
        key: '_hasCache',
        value: function _hasCache(cacheName, qualifier) {
            return _.has(this._getCache(cacheName, qualifier), qualifier);
        }
    }, {
        key: '_getGridRows',
        value: function _getGridRows(grid) {
            var _this = this;

            var tree = grid.treeBase.tree;
            if (!_.isArray(tree)) {
                return [];
            }
            var container = [];
            tree.forEach(function (r) {
                container = container.concat(_.flatten(_this._getRowChildrenRecursive(r.row, [])));
            });
            return container;
        }
    }, {
        key: '_getRowChildrenRecursive',
        value: function _getRowChildrenRecursive(row, children) {
            var _this2 = this;

            children.push(row);
            row.treeNode.children.map(function (child) {
                _this2._getRowChildrenRecursive(child.row, children);
            });
            return children;
        }
    }]);
    return GridStateService;
}();

GridStateService.$inject = ['ClientSettings'];

angular.module('xlrelease').service('GridStateService', GridStateService);

/***/ }),
/* 1299 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Keep in sync with variables.less
 */
angular.module('xlrelease').constant('Layout', {
  mainPageBorder: 10
});

/***/ }),
/* 1300 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('LocalStorageWrapper', ['$window', function ($window) {
    return $window.localStorage;
}]);

/***/ }),
/* 1301 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _map = __webpack_require__(221);

var _map2 = _interopRequireDefault(_map);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').factory('MetadataService', ['$q', 'Backend', function ($q, Backend) {
    var configurationDescriptors = null;
    var descriptors = undefined;
    var descriptorMap = new _map2.default();

    function getDescriptor(instanceType) {
        var deferred = $q.defer();
        if (!!descriptorMap.get(instanceType)) {
            deferred.resolve(descriptorMap.get(instanceType));
        } else {
            Backend.get('metadata/type/' + instanceType).then(function (result) {
                var descriptor = result.data;
                descriptor.propertiesByCategory = _.groupBy(descriptor.properties, 'category');
                descriptorMap.set(descriptor.type, descriptor);
                deferred.resolve(descriptor);
            });
        }
        return deferred.promise;
    }

    function getDescriptors() {
        var deferred = $q.defer();
        if (!descriptors) {
            Backend.get('metadata/type').then(function (result) {
                descriptors = result.data;
                deferred.resolve(descriptors);
            });
        } else {
            deferred.resolve(descriptors);
        }
        return deferred.promise;
    }

    function getSubDescriptors(ciTypeDescriptor) {
        return getAllSubDescriptors(ciTypeDescriptor).then(function (descriptorList) {
            return descriptorList.filter(function (descriptor) {
                return descriptor.virtual === false;
            });
        });
    }

    function getAllSubDescriptors(ciTypeDescriptor) {
        return getDescriptors().then(function (descriptorList) {
            return descriptorList.filter(function (descriptor) {
                return !_.isUndefined(descriptor.superTypes) && _.includes(descriptor.superTypes, getCiType(ciTypeDescriptor));
            });
        });
    }

    function getCiType(ciTypeDescriptor) {
        if (_.isUndefined(ciTypeDescriptor.type)) {
            return ciTypeDescriptor.referencedType;
        }
        return ciTypeDescriptor.type;
    }

    function isTypePresent(descriptorType) {
        return getDescriptors().then(function (descriptors) {
            return angular.isDefined(descriptors.find(function (descriptor) {
                return descriptor.type === descriptorType;
            }));
        });
    }

    function getConfigurationDescriptors() {
        if (!configurationDescriptors) {
            return Backend.get('configurations/descriptors').then(function (result) {
                configurationDescriptors = result.data;
                return configurationDescriptors;
            });
        }

        var deferred = $q.defer();
        deferred.resolve(configurationDescriptors);
        return deferred.promise;
    }

    return {
        getDescriptor: getDescriptor,
        getConfigurationDescriptors: getConfigurationDescriptors,
        getSubDescriptors: getSubDescriptors,
        getAllSubDescriptors: getAllSubDescriptors,
        getCiType: getCiType,
        isTypePresent: isTypePresent,
        getDescriptors: getDescriptors
    };
}]);

/***/ }),
/* 1302 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ModalService', ['$timeout', '$compile', '$parse', 'Modal', function ($timeout, $compile, $parse, Modal) {

    function initModal(scope, modalElement, templateUrl, initFunction, hideFunction, draggable, resizable, loadOnElement) {
        Modal.open();

        $parse(initFunction)(scope);

        var isDismissed = false;

        var dismissAction = function dismissAction() {
            $parse(hideFunction)(scope);
            Modal.close();

            modalElement.modal('hide');

            if (scope.unregisterLocationListener) {
                scope.unregisterLocationListener();
            }

            $timeout(function () {
                return scope.$destroy();
            });
        };

        scope.dismiss = function () {
            isDismissed = true;
            dismissAction();
        };

        var afterShowModalWindow = function afterShowModalWindow() {
            modalElement.on('click', function (e) {
                if (e.target.className && _.includes(e.target.className.split(' '), 'modal')) {
                    scope.$apply(scope.dismiss);
                }
            });

            angular.element('.modal-backdrop').on('click', function () {
                scope.$apply(scope.dismiss);
            });

            if (draggable) {
                modalElement.draggable({
                    handle: ".modal-header",
                    cursor: "move"
                });
            }
            if (resizable) {
                modalElement.find('.modal-content').resizable({
                    alsoResize: modalElement.find('.modal-body'),
                    handles: "se",
                    minHeight: 520,
                    minWidth: 750
                });
            }
        };

        scope.showModal = function () {
            modalElement.modal('show');
            $timeout(afterShowModalWindow, 100);
        };

        var template = '<div class="modal-dialog" ng-include="' + templateUrl + '"></div>';
        if (loadOnElement) {
            template = '<div class="modal-dialog" ng-include="' + templateUrl + '" onload="showModal()"></div>';
        }
        $compile(modalElement.html(template))(scope);

        modalElement.on('keyup', function (e) {
            if (e.which === 27) {
                // on escape
                modalElement.off('keyup');
                scope.$apply(scope.dismiss);
            }
        });

        modalElement.on('shown.bs.modal', function () {
            $timeout(function () {
                modalElement.off('shown.bs.modal');
                modalElement.find('[autofocus]:first').trigger('focus');
            });
        });

        modalElement.on('hidden.bs.modal', function () {
            $timeout(function () {
                modalElement.off('hidden.bs.modal');
                scope.$apply(scope.dismiss);
            });
        });

        scope.$on("$destroy", function () {
            if (!isDismissed) dismissAction();
            if (modalElement.data('ui-draggable')) {
                modalElement.draggable('destroy');
            }

            if (modalElement.find('.modal-content').data('ui-resizable')) {
                modalElement.find('.modal-content').resizable('destroy');
            }

            modalElement.removeData();
            modalElement.off();
            modalElement.empty();

            angular.element('.modal-backdrop').off();
        });

        scope.unregisterLocationListener = scope.$on('$locationChangeSuccess', scope.dismiss);
    }

    return {
        open: function open(scope, templateUrl, initFunction, hideFunction, draggable, resizable, loadOnElement) {
            var modalElement = angular.element('#modal');

            if (resizable) {
                modalElement = angular.element('#resizable-modal');
            }

            initModal(scope, modalElement, templateUrl, initFunction, hideFunction, draggable, resizable, loadOnElement);
        }
    };
}]);

var modalLinkFunction = function modalLinkFunction(ModalService, templateAttr, scope, element, attrs) {
    var watcher = scope.$watch(attrs.openOn, function (triggerCondition) {
        if (angular.isDefined(triggerCondition) && triggerCondition) {
            ModalService.open(scope.$new(), attrs[templateAttr], attrs.init, attrs.onModalHide, attrs.draggable, attrs.resizable, true);
        }
    });

    element.on('click', function (event) {
        if (!attrs.disabled) {
            event.stopPropagation();
            scope.$apply(function () {
                ModalService.open(scope.$new(), attrs[templateAttr], attrs.init, attrs.onModalHide, attrs.draggable, attrs.resizable, true);
            });
        }
    });

    scope.$on("$destroy", function () {
        watcher();
        element.off();
    });
};

angular.module('xlrelease').directive('modal', ['$compile', '$parse', 'Modal', 'ModalService', function ($compile, $parse, Modal, ModalService) {

    return {
        scope: true,
        link: modalLinkFunction.bind(null, ModalService, 'modal')
    };
}]);

angular.module('xlrelease').directive('scopeLessModal', ['$compile', '$parse', 'Modal', 'ModalService', function ($compile, $parse, Modal, ModalService) {

    return {
        scope: {
            ctrl: '='
        },
        link: modalLinkFunction.bind(null, ModalService, 'scopeLessModal')
    };
}]);

angular.module('xlrelease').factory('Modal', ['$q', function ($q) {
    var _open = $q.defer();
    var _close = $q.defer();

    function initPromise(parentPromise, scope) {
        var defer = $q.defer();
        parentPromise.then(defer.resolve);
        scope.$on('$destroy', defer.reject);
        return defer.promise;
    }

    return {
        open: function open() {
            _open.resolve('open');
            _open = $q.defer();
        },
        close: function close() {
            _close.resolve('close');
            _close = $q.defer();
        },
        withScope: function withScope(scope) {
            var nextOpen = initPromise(_open.promise, scope);
            var nextClose = initPromise(_close.promise, scope);

            return {
                onNextOpen: function onNextOpen(callback) {
                    nextOpen.then(callback);
                    return this;
                },
                onNextClose: function onNextClose(callback) {
                    nextClose.then(callback);
                    return this;
                }
            };
        }
    };
}]);

/***/ }),
/* 1303 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('PhasesService', ['TasksService', 'Backend', function (TasksService, Backend) {
    return {
        isPhaseInProgress: function isPhaseInProgress(phase) {
            return 'IN_PROGRESS' === phase.status;
        },
        isPhaseReadOnly: function isPhaseReadOnly(phase) {
            return 'COMPLETED' === phase.status || 'ABORTED' === phase.status || 'SKIPPED' === phase.status;
        },
        isPhasePlanned: function isPhasePlanned(phase) {
            return 'PLANNED' === phase.status;
        },
        isPlannedOrNotMostRecentCopy: function isPlannedOrNotMostRecentCopy(phase) {
            if ('PLANNED' === phase.status) {
                return true;
            }
            return !phase.mostRecentCopy;
        },
        isPlannedOrNotOriginal: function isPlannedOrNotOriginal(phase) {
            if ('PLANNED' === phase.status) {
                return true;
            }
            return !phase.origin;
        },
        isPhaseActive: function isPhaseActive(phase) {
            return 'IN_PROGRESS' === phase.status || 'FAILED' === phase.status || 'FAILING' === phase.status;
        },
        isPhase: function isPhase(planItem) {
            return planItem.type === 'xlrelease.Phase';
        },
        getLeafTasks: function getLeafTasks(phase) {
            return _.flattenDeep(_.map(phase.tasks, TasksService.getSubTasks));
        },
        updatePhase: function updatePhase(phase) {
            var phaseForm = {
                title: phase.title,
                description: phase.description,
                scheduledStartDate: phase.scheduledStartDate,
                dueDate: phase.dueDate,
                color: phase.color,
                plannedDuration: phase.plannedDuration
            };
            Backend.put('phases/' + phase.id, phaseForm);
        }
    };
}]);

/***/ }),
/* 1304 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('StringService', [function () {
    return {
        isUpperCase: function isUpperCase(c) {
            return c.toUpperCase() === c;
        },
        deCamelize: function deCamelize(input) {
            var output = '';

            for (var i = 0; i < input.length; i++) {
                var c = input.charAt(i);
                if (i === 0) {
                    c = c.toUpperCase();
                } else if (this.isUpperCase(c)) {
                    output += ' ';
                }
                output += c;
            }
            return output;
        },
        capitalizeFirstLetter: function capitalizeFirstLetter(input) {
            return input.substring(0, 1).toUpperCase() + input.substring(1);
        }
    };
}]);

/***/ }),
/* 1305 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('Timeout', ['$rootScope', '$q', '$exceptionHandler', function ($rootScope, $q, $exceptionHandler) {
    var deferreds = {};

    function timeout(fn, delay) {
        var deferred = timeout._getDeferred();
        var timeoutId = timeout._registerTimeout(deferred, fn, delay);
        return buildPromise(deferred, timeoutId);
    }

    timeout.cancel = function (promise) {
        if (promise && promise.$$timeoutId in deferreds) {
            deferreds[promise.$$timeoutId].reject('canceled');
            clearTimeout(promise.$$timeoutId);
            return true;
        }
        return false;
    };

    // visible for testing
    timeout._getDeferred = function () {
        return $q.defer();
    };

    // visible for testing
    timeout._registerTimeout = function (deferred, fn, delay) {
        var timeoutId = setTimeout(function () {
            try {
                deferred.resolve(fn());
            } catch (e) {
                deferred.reject(e);
                $exceptionHandler(e);
            }
            $rootScope.$apply();
        }, delay);

        deferreds[timeoutId] = deferred;

        return timeoutId;
    };

    // visible for testing
    timeout._cleanup = function (promise) {
        function cleanup() {
            delete deferreds[promise.$$timeoutId];
        }
        promise.then(cleanup, cleanup);
    };

    function buildPromise(deferred, timeoutId) {
        var promise = deferred.promise;

        promise.$$timeoutId = timeoutId;
        timeout._cleanup(promise);

        return promise;
    }

    return timeout;
}]);

/***/ }),
/* 1306 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('TopologicalSort', [function () {

    return {
        /**
         *  graph = {
         *      adjacencyList: [
         *          {sourceId: '1', targetId: '2'},
         *          {sourceId: '3', targetId: '2'}
         *      ],
         *      vertices: ['1', '2', '3']
         *  }
         *
         *  Returns ['3', '1', '2'], or null if the graph has a cycle
         */
        sort: function sort(graph) {
            var marked = {};
            var ordered = [];
            var onStack = {};
            var hasCycle = false;

            function adjacentsOf(vertex) {
                return _.chain(graph.adjacencyList).filter(function (adjacentItem) {
                    return adjacentItem.sourceId === vertex;
                }).map('targetId').value();
            }

            function depthFirstSearch(vertex) {
                onStack[vertex] = true;
                marked[vertex] = true;
                _.forEach(adjacentsOf(vertex), function (adjacent) {
                    if (!marked[adjacent]) {
                        depthFirstSearch(adjacent);
                    } else if (onStack[adjacent]) {
                        hasCycle = true;
                        return false;
                    }
                });
                ordered.unshift(vertex);
                onStack[vertex] = false;
                return true;
            }

            _.forEach(graph.vertices, function (vertex) {
                if (!marked[vertex]) {
                    depthFirstSearch(vertex);
                }
                if (hasCycle) {
                    return false;
                }
            });

            return hasCycle ? null : ordered;
        }
    };
}]);

/***/ }),
/* 1307 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ViewStorage', ['$window', function ($window) {
    var VIEWS_MAP = "xlreleaseViewStorage";

    var setView = function setView(key, view) {
        var views = getViews();
        views[key] = view;
        storeViews(views);
    };

    var getView = function getView(key, defaultView) {
        var views = getViews();
        return _.get(views, key, defaultView);
    };

    var removeView = function removeView(key) {
        var views = getViews();
        delete views[key];
        storeViews(views);
    };

    var clear = function clear() {
        storeViews({});
    };

    function getViews() {
        return _.assign({}, angular.fromJson($window.sessionStorage.getItem(VIEWS_MAP)));
    }

    function storeViews(views) {
        $window.sessionStorage.setItem(VIEWS_MAP, angular.toJson(views));
    }

    return {
        setView: setView,
        getView: getView,
        removeView: removeView,
        clear: clear
    };
}]);

/***/ }),
/* 1308 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('Window', [function () {
    var windowWrapper = angular.element(window);
    return {
        height: function height() {
            return windowWrapper.height();
        },
        onResize: function onResize(callback, scope) {
            windowWrapper.resize(callback);

            scope.$on('$destroy', function () {
                windowWrapper.off("resize", callback);
            });
        }
    };
}]);

/***/ }),
/* 1309 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('releaseValueStreamController', ['$scope', 'TagsService', '$location', 'PhasesService', 'filterSettings', 'ValueStreamMapping', 'ConfigurationItemService', 'ReleasesService', 'Events', 'ClientSettings', 'CisLoader', function ($scope, TagsService, $location, PhasesService, filterSettings, ValueStreamMapping, ConfigurationItemService, ReleasesService, Events, ClientSettings, CisLoader) {
    $scope.filters = filterSettings;
    $scope.filters.completed = true;
    $scope.allTags = [];

    $scope.$on(Events.filters.filterChanged, function (e, filters) {
        loadReleases();
        ClientSettings.setReleaseValueStreamFilters(filters);
    });

    function loadTags() {
        TagsService.getArchivedReleaseTags().then(function (tags) {
            $scope.allTags = tags;
        });
    }

    function loadReleases() {
        $scope.releases = null;
        $scope.releasesLoader = new CisLoader({
            searchCis: ReleasesService.searchArchived,
            filters: $scope.filters,
            updateView: function updateView(releases) {
                return $scope.releases = _.sortBy(releases, function (release) {
                    return release.endDate;
                }).reverse();
            }
        });
        $scope.releasesLoader.loadNextCis();
    }

    loadTags();
    loadReleases();

    $scope.getDurationPercentage = function (release, phase) {
        var ciDuration = ConfigurationItemService.getCIDuration(release);
        if (ciDuration === 0) {
            return 0;
        }
        return Math.round(ConfigurationItemService.getCIDuration(phase) * 100 / ciDuration);
    };

    $scope.getLeafTasks = PhasesService.getLeafTasks;
    $scope.isCritical = ValueStreamMapping.isCritical;
    $scope.getWarningThreshold = ValueStreamMapping.getWarningThreshold;
    $scope.getErrorThreshold = ValueStreamMapping.getErrorThreshold;
    $scope.getCriticalPhasesCount = ValueStreamMapping.getCriticalPhasesCount;
    $scope.getCIDuration = ConfigurationItemService.getCIDuration;
}]);

/***/ }),
/* 1310 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _classCallCheck2 = __webpack_require__(3);

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = __webpack_require__(4);

var _createClass3 = _interopRequireDefault(_createClass2);

var _taskCountersTpl = __webpack_require__(1311);

var _taskCountersTpl2 = _interopRequireDefault(_taskCountersTpl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var TaskCountersController = function () {
    function TaskCountersController(ValueStreamMapping) {
        (0, _classCallCheck3.default)(this, TaskCountersController);

        this._ValueStreamMapping = ValueStreamMapping;
    }

    (0, _createClass3.default)(TaskCountersController, [{
        key: 'getWarningThreshold',
        value: function getWarningThreshold() {
            return this._ValueStreamMapping.getWarningThreshold();
        }
    }, {
        key: 'getErrorThreshold',
        value: function getErrorThreshold() {
            return this._ValueStreamMapping.getErrorThreshold();
        }
    }]);
    return TaskCountersController;
}();

TaskCountersController.$inject = ['ValueStreamMapping'];

angular.module('xlrelease').component('taskCounters', {
    bindings: {
        flagsCount: '<',
        delaysCount: '<',
        failuresCount: '<'
    },
    controller: TaskCountersController,
    template: _taskCountersTpl2.default
});

/***/ }),
/* 1311 */
/***/ (function(module, exports) {

module.exports = "<div>\n    <span class=\"flag-count counter-item\"\n          ng-if=\"$ctrl.flagsCount == 1\"\n          tooltip=\"'1 flagged task'\">\n        <i class=\"xl-icon flag-none-icon icon-s\" />\n        1\n    </span>\n    <span class=\"flag-count counter-item\"\n          ng-if=\"$ctrl.flagsCount > 1\"\n          tooltip=\"$ctrl.flagsCount + ' flagged tasks'\">\n        <i class=\"xl-icon flag-none-icon icon-s\" />\n        {{ $ctrl.flagsCount }}\n    </span>\n\n    <span class=\"failure-count counter-item\"\n          ng-if=\"$ctrl.failuresCount == 1\"\n          tooltip=\"'1 task failure'\">\n        <i class=\"xl-icon lightning-icon icon-s\" />\n        1\n    </span>\n    <span class=\"failure-count counter-item\"\n          ng-if=\"$ctrl.failuresCount > 1\"\n          ng-class=\"{'count-warning': $ctrl.failuresCount >= $ctrl.getWarningThreshold(), 'count-error': $ctrl.failuresCount >= $ctrl.getErrorThreshold()}\"\n          tooltip=\"$ctrl.failuresCount + ' task failures'\">\n        <i class=\"xl-icon lightning-icon icon-s\" />\n        {{ $ctrl.failuresCount }}\n    </span>\n\n    <span class=\"delay-count counter-item\"\n          ng-if=\"$ctrl.delaysCount == 1\"\n          tooltip=\"'1 delayed task'\">\n        <i class=\"xl-icon delay-icon icon-s\" />\n        1\n    </span>\n    <span class=\"delay-count counter-item\"\n          ng-if=\"$ctrl.delaysCount > 1\"\n          ng-class=\"{'count-warning': $ctrl.delaysCount >= $ctrl.getWarningThreshold(), 'count-error': $ctrl.delaysCount >= $ctrl.getErrorThreshold()}\"\n          tooltip=\"$ctrl.delaysCount + ' delayed tasks'\">\n        <i class=\"xl-icon delay-icon icon-s\" />\n        {{ $ctrl.delaysCount }}\n    </span>\n</div>\n"

/***/ }),
/* 1312 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('ValueStreamMapping', ['Backend', function (Backend) {
    var settings = {
        warningThreshold: undefined,
        errorThreshold: undefined,
        criticalPhaseThreshold: undefined
    };

    function refreshReportsSettings() {
        Backend.get('settings/reports').then(function (resp) {
            var reportsSettings = resp.data;
            settings.warningThreshold = reportsSettings.warningThreshold;
            settings.errorThreshold = reportsSettings.errorThreshold;
            settings.criticalPhaseThreshold = reportsSettings.criticalPhaseThreshold;
        });
    }

    refreshReportsSettings();

    return {
        getWarningThreshold: function getWarningThreshold() {
            return settings.warningThreshold;
        },
        getErrorThreshold: function getErrorThreshold() {
            return settings.errorThreshold;
        },
        isCritical: function isCritical(phase) {
            return phase.taskFlaggedCount + phase.taskFailureCount + phase.taskDelayCount > settings.criticalPhaseThreshold;
        },
        getCriticalPhasesCount: function getCriticalPhasesCount(release) {
            return _(release.phases).map(this.isCritical).compact().size();
        },

        refreshReportsSettings: refreshReportsSettings
    };
}]);

/***/ }),
/* 1313 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _variableTypes = __webpack_require__(516);

var _variableTypes2 = _interopRequireDefault(_variableTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').directive('deleteVariable', function () {
    return {
        template: '<span class="action delete" modal="\'partials/variables/delete-variable-modal.html\'" init="initDeleteVariableDialog()">\n                <i class="xl-icon delete-icon"></i>\n                <span class="action-label">{{ !VARIABLE_TYPES.isGlobalOrFolder(pageType) ? \'Delete / Replace\' : \'Delete\' }}</span>\n            </span>',
        restrict: 'A',
        scope: {
            model: '=',
            pageType: '=',
            onDelete: '&',
            supportsNew: '&?',
            onNewVariable: '&?',
            allVariables: '='
        },
        controller: 'deleteVariableController'
    };
});

angular.module('xlrelease').controller('deleteVariableController', ['$scope', 'VariablesService', function ($scope, VariablesService) {
    $scope.initDeleteVariableDialog = initDeleteVariableDialog;
    $scope.deleteVariable = deleteVariable;
    $scope.createVariable = createVariable;
    $scope.checksUsage = checksUsage;
    $scope.handlers = {};
    $scope.getKey = VariablesService.getKey;
    $scope.VARIABLE_TYPES = _variableTypes2.default;

    //////

    function initDeleteVariableDialog() {
        var variable = $scope.variable = angular.copy($scope.model);

        if ($scope.allVariables && $scope.allVariables.length > 0) {
            $scope.allVariables = _.filter($scope.allVariables, function (variable) {
                return variable.id !== $scope.model.id;
            });
        }

        if (checksUsage()) {
            VariablesService.isReleaseVariableUsed(variable).then(function (resp) {
                $scope.isUsed = resp.data;
                if ($scope.isUsed) {
                    $scope.replacement = [{
                        key: variable.key,
                        label: 'Replace it with',
                        description: 'Replace all occurrences of the variable with a static value or replace them with a different variable. Leave empty to replace occurrences with a blank.',
                        type: variable.type,
                        requiresValue: false,
                        value: variable.value,
                        variable: null
                    }];
                }
            });
        }
    }

    function deleteVariable(variable, dismiss) {
        if ($scope.replacement) {
            delete $scope.variable.variable;

            var replacement = $scope.replacement[0];
            if (replacement.variable) {
                $scope.variable.variable = replacement.variable;
            } else if (VariablesService.containsOnlyVariable(replacement.value)) {
                $scope.variable.variable = replacement.value;
            } else {
                $scope.variable.value = replacement.value;
            }
        }
        $scope.onDelete({ variable: $scope.variable, callback: dismiss });
    }

    function createVariable(name, variableType, createdCallback) {
        $scope.onNewVariable()({ key: name, type: variableType }, createdCallback);
    }

    function checksUsage() {
        return !_variableTypes2.default.isGlobalOrFolder($scope.pageType);
    }
}]);

/***/ }),
/* 1314 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('displayVariables', ['displayVariablesFilter', function (displayVariablesFilter) {
    return function (scope, element, attrs) {
        scope.$watchCollection('[' + attrs.displayVariables + ', ' + attrs.variables + ', ' + attrs.limitTo + ']', function (watchedValues) {
            var content = watchedValues[0];
            var variables = watchedValues[1];
            var limitTo = angular.element(attrs.$$element).data('limit-to');
            var html = displayVariablesFilter(content, variables, angular.isDefined(attrs.markdown), angular.isDefined(attrs.keepNewLines), limitTo, angular.isDefined(attrs.slim));
            element.html(html);
        });
    };
}]).filter('displayVariables', ['newlinesFilter', 'markdownFilter', 'VariablesInterpolator', 'VariablesService', 'limitToFilter', function (newlinesFilter, markdownFilter, VariablesInterpolator, VariablesService, limitToFilter) {
    return function (content, variables, isMarkdown, keepNewLines, limitTo, isSlim) {
        var variablesMap = VariablesService.convertToMap(variables);
        var text = content || '';

        if (isMarkdown) {
            text = markdownFilter(text);
            text = text.replace(/%7B/g, '{').replace(/%7D/g, '}');
            if (isSlim) {
                var anchorElement = text.match(/<a[\s]+([^>]+)>((?:.(?!\<\/a\>))*.)<\/a>/g);
                if (anchorElement && anchorElement.length === 1) {
                    text = anchorElement[0].replace('<a', '<a target="_blank" rel="noopener"');
                }
            }
        } else {
            text = _.escape(text);
        }
        if (keepNewLines) {
            text = newlinesFilter(text);
        }

        var html = isMarkdown ? VariablesInterpolator.interpolateInText(variablesMap, text) : VariablesInterpolator.interpolateInHtml(variablesMap, text);

        if (limitTo) {
            var limitedHTML = limitToFilter(html, limitTo);

            if (limitedHTML.length < html.length) {
                return limitedHTML + "...";
            }
        }

        return html;
    };
}]);

/***/ }),
/* 1315 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _variableConstants = __webpack_require__(712);

var _variableTypes = __webpack_require__(516);

var _variableTypes2 = _interopRequireDefault(_variableTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').directive('editVariable', ['$compile', '$parse', 'MetadataService', 'VariablesService', function ($compile, $parse, MetadataService, VariablesService) {

    return {
        restrict: 'A',
        // scope: shared,
        link: function link($scope, element, attrs) {

            var initFunctionExpr = $parse(attrs.initVariable);
            var saveFunction = $parse(attrs.save)($scope);
            var onNewVariableFunction = $parse(attrs.onNewVariable)($scope);
            var allVariablesExpr = $parse(attrs.allVariables);
            $scope.VARIABLE_TYPES = _variableTypes2.default;
            $scope.isNew = $parse(attrs.isNew)($scope);
            $scope.isReadonly = $parse(attrs.isReadonly)($scope);
            $scope.pageType = $parse(attrs.pageType)($scope);
            $scope.isRenameEnabled = $parse(attrs.isRenameEnabled)($scope);

            $scope.listBoxValueProviderType = _variableConstants.VariableConstants.basicValueProvider;
            $scope.predefinedVariableType = _variableConstants.VariableConstants.type;
            $scope.selectedValueProviderType = $scope.listBoxValueProviderType.listOfStringConfiguration;

            $scope.initEditVariableDialog = function () {
                $scope.var = initFunctionExpr($scope);
                $scope.variableType = VariablesService.getVariableType($scope.var);
                if (allVariablesExpr) {
                    if (_variableTypes2.default.isGlobalOrFolder($scope.pageType)) {
                        $scope.allVariables = allVariablesExpr($scope);
                    }
                    $scope.existingVariableKeys = variableKeys($scope.pageType, $scope.allVariables, $scope.var);
                }

                MetadataService.getDescriptor(_variableConstants.VariableConstants.basicValueProvider.scriptConfiguration).then(function (ci) {
                    $scope.ciTypeDescriptor = ci;

                    if (VariablesService.isDropDownListBox($scope.var)) {
                        if (!$scope.var.valueProvider) {
                            $scope.var.valueProvider = VariablesService.initValueProvider($scope.var.type);
                        }

                        if ($scope.listBoxValueProviderType.listOfStringConfiguration === $scope.var.valueProvider.type) {
                            $scope.selectedValueProviderType = $scope.var.valueProvider.type;
                            loadValuesFromListOfStringValueProvider();
                        } else {
                            $scope.selectedValueProviderType = $scope.listBoxValueProviderType.scriptConfiguration;
                        }
                    }
                });
            };

            function initValueProviderForCiTypeDescriptor(ciTypeDescriptor) {
                // set something up in case getSubDescriptors(ciTypeDescriptor) is the empty list
                $scope.var.valueProvider = VariablesService.initValueProvider(ciTypeDescriptor.type);

                MetadataService.getSubDescriptors(ciTypeDescriptor).then(function (subDescriptors) {
                    $scope.var.valueProvider = VariablesService.initValueProvider(subDescriptors[0].type);
                });
            }

            $scope.changeValueProvider = changeValueProvider;

            function changeValueProvider(selectedValueProviderType) {
                if (selectedValueProviderType === $scope.listBoxValueProviderType.listOfStringConfiguration) {
                    $scope.var.valueProvider = VariablesService.initValueProvider(selectedValueProviderType);
                    loadValuesFromListOfStringValueProvider();
                } else {
                    initValueProviderForCiTypeDescriptor($scope.ciTypeDescriptor);
                    resetValues();
                }
            }

            $scope.validateNumberInput = function (keyDownEvent) {
                if (keyDownEvent.target.value === "" && keyDownEvent.keyCode === 189) {// allow - at the start
                    // ok
                } else if ([69, 187, 188, 189, 190].indexOf(keyDownEvent.keyCode) > -1) {
                    // disallow e . , -
                    event.preventDefault();
                }
            };

            $scope.invalidValueProvider = function () {
                var p = $scope.var.valueProvider;
                if (!p) {
                    // not a value provider
                    return false;
                }
                if (!p.type) {
                    // value provider with no type?
                    return true;
                }
                // invalid: value provider but no script selected
                return p.type === _variableConstants.VariableConstants.basicValueProvider.scriptConfiguration && !p.script;
            };

            $scope.saveVariable = function (updatedVariable, dismiss) {
                if (angular.isUndefined(updatedVariable.value)) {
                    switch (updatedVariable.type) {
                        case _variableConstants.VariableConstants.type.boolean.key:
                            updatedVariable.value = false;
                            break;
                        case _variableConstants.VariableConstants.type.integer.key:
                            updatedVariable.value = 0;
                            break;
                    }
                }

                if (saveFunction) {
                    saveFunction(updatedVariable, dismiss);
                } else if (dismiss) {
                    dismiss();
                }
            };

            $scope.onNewVariablePF = function (name, variableType, createdCallback) {
                var variableToCreate = {
                    key: name,
                    type: variableType
                };
                onNewVariableFunction(variableToCreate, createdCallback);
            };

            $scope.typeSelected = function (oldId, newId) {
                var variableTypeList = VariablesService.getVariableTypeList();
                var newType = _.find(variableTypeList, function (type) {
                    return type.id === newId;
                });

                if (newId !== oldId) {
                    $scope.var.value = undefined;
                    $scope.var.type = newType.key;
                    if (newType.valueProvider) {
                        $scope.var.valueProvider = VariablesService.initValueProvider(newType.valueProvider);
                        loadValuesFromListOfStringValueProvider();
                    } else {
                        delete $scope.var.valueProvider;
                    }
                }
            };

            $scope.saveProviderAndPopulateValues = saveListOfStringValueProviderAndPopulateValues;

            function loadValuesFromListOfStringValueProvider() {
                var provider = $scope.var.valueProvider;
                $scope.expandedValueProvider = VariablesService.expandProperties(provider, provider.variableMapping, ["values"]);

                saveListOfStringValueProviderAndPopulateValues();
            }

            function resetValues() {
                $scope.possibleValues = [];
            }

            function saveListOfStringValueProviderAndPopulateValues() {
                var possibleValues = [];
                if ($scope.expandedValueProvider.values.variable) {
                    var variableWithValues = _.find($scope.allVariables, {
                        key: VariablesService.withoutVariableSyntax($scope.expandedValueProvider.values.variable)
                    });
                    if (variableWithValues) {
                        possibleValues = variableWithValues.value;
                    } else {
                        $scope.expandedValueProvider.values.variable = undefined;
                    }
                } else {
                    possibleValues = $scope.expandedValueProvider.values.value || [];
                }
                $scope.possibleValues = possibleValues;

                var _VariablesService$col = VariablesService.collapseProperties($scope.expandedValueProvider, ["values"]),
                    _VariablesService$col2 = (0, _slicedToArray3.default)(_VariablesService$col, 2),
                    collapsedValueProvider = _VariablesService$col2[0],
                    variableMapping = _VariablesService$col2[1];

                collapsedValueProvider.variableMapping = variableMapping;
                if (collapsedValueProvider.values === null) {
                    collapsedValueProvider.values = undefined;
                }
                $scope.var.valueProvider = collapsedValueProvider;

                if (possibleValues.indexOf($scope.var.value) === -1) {
                    $scope.var.value = undefined;
                }
            }

            function variableKeys(pageType, variables, currentVariable) {
                return _.flatMap(variables, function (variable) {
                    if (variable.key === currentVariable.key) {
                        return [];
                    }
                    if (pageType === _variableTypes2.default.GLOBAL && VariablesService.isGlobalVariableName(variable.key)) {
                        return [variable.key.replace(/^global\./, '')];
                    }
                    if (pageType === _variableTypes2.default.FOLDER && VariablesService.isFolderVariable(variable.key)) {
                        return [variable.key.replace(/^folder\./, '')];
                    }
                    return [VariablesService.withoutVariableSyntax(variable.key), VariablesService.withVariableSyntax(variable.key)];
                });
            }

            var getVariableKeyPrefix = function getVariableKeyPrefix(key) {
                var regexMatch = (key || '').match(/(folder\.|global\.)/);
                return regexMatch !== null ? regexMatch[0] : null;
            };

            var getVariableKeyWithoutPrefix = function getVariableKeyWithoutPrefix(key) {
                return (key || '').replace(/(folder\.|global\.)/, '');
            };

            $scope.getKey = VariablesService.getKey;
            $scope.getValue = VariablesService.getValue;
            $scope.isStringVariable = VariablesService.isStringVariable;
            $scope.isDropDownListBox = VariablesService.isDropDownListBox;
            $scope.getVariableType = VariablesService.getVariableType;
            $scope.variableTypes = VariablesService.getVariableTypeList();
            $scope.allowedKeyPattern = /^(?!((\$\{)?(release|global|folder))\.).*$/i;
            $scope.getVariableKeyPrefix = getVariableKeyPrefix;
            $scope.getVariableKeyWithoutPrefix = getVariableKeyWithoutPrefix;
            $scope.isSimpleStringType = function (type) {
                return type === _variableConstants.VariableConstants.type.string.key || type === _variableConstants.VariableConstants.type.passwordString.key;
            };

            element.removeAttr('edit-variable');
            element.attr('init', 'initEditVariableDialog()');
            element.attr('modal', "'partials/variables/edit-variable-modal.html'");
            $compile(element)($scope);
        }
    };
}]);

/***/ }),
/* 1316 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').controller('globalVariablesController', ['$scope', 'VariablesService', 'Authenticator', function ($scope, VariablesService, Authenticator) {

    $scope.isReadonly = !Authenticator.hasEditGlobalVariablesPermission();
    $scope.filters = {
        filter: ''
    };
    $scope.updateGlobalVariable = updateGlobalVariable;
    $scope.createGlobalVariable = createGlobalVariable;
    $scope.deleteGlobalVariable = deleteGlobalVariable;
    $scope.newVariable = newVariable;

    loadVariables();

    function loadVariables() {
        VariablesService.getGlobalVariables().then(function (resp) {
            var variables = resp.data;
            $scope.variables = variables;
            $scope.decoratedVariables = _.map(variables, VariablesService.decorateVariable);
        });
    }

    function deleteGlobalVariable(variable, onSuccess) {
        VariablesService.deleteGlobalVariable(variable).then(function () {
            _.remove($scope.variables, { id: variable.id });
            _.remove($scope.decoratedVariables, { id: variable.id });
            onSuccess();
        });
    }

    function updateGlobalVariable(variable, onSuccess) {
        VariablesService.updateGlobalVariable(variable).then(function (resp) {
            var updated = resp.data;
            _.assign(_.find($scope.variables, { key: updated.key }), updated);
            _.assign(_.find($scope.decoratedVariables, { key: updated.key }), updated);
            onSuccess();
        });
    }

    function createGlobalVariable(variable, onSuccess) {
        variable.requiresValue = false;
        variable.showOnReleaseStart = false;
        VariablesService.createGlobalVariable(variable).then(function (resp) {
            var variable = resp.data;
            $scope.variables.push(variable);
            $scope.decoratedVariables.push(VariablesService.decorateVariable(variable));

            // Using sort in place so that array references propagated to variables-list and edit-variable
            // directives are updated automatically
            sortInplaceByKey($scope.variables);
            sortInplaceByKey($scope.decoratedVariables);

            onSuccess(variable);
        });
    }

    function sortInplaceByKey(array) {
        array.sort(function (a, b) {
            if (a.key < b.key) return -1;
            if (a.key === b.key) return 0;
            if (a.key > b.key) return 1;
        });
    }

    function newVariable() {
        return {
            key: "global.",
            type: 'xlrelease.StringVariable',
            requiresValue: false,
            showOnReleaseStart: false
        };
    }
}]);

/***/ }),
/* 1317 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').directive('variablesEditor', ['VariablesService', function (VariablesService) {
    return {
        templateUrl: 'partials/variables/variables-editor.html',
        restrict: 'A',
        controller: function controller($scope) {

            function isEmpty(value) {
                if (_.isBoolean(value)) {
                    return false;
                } else if (_.isNumber(value)) {
                    var stringed = "" + value;
                    if (stringed.length === 0 || stringed.indexOf(".") > -1) {
                        return true;
                    }
                } else if (_.isEmpty(value)) {
                    return true;
                }
                return false;
            }

            $scope.validateNumberInput = function (keyDownEvent) {
                if (keyDownEvent.target.value === "" && keyDownEvent.keyCode === 189) {// allow - at the start
                    // ok
                } else if ([69, 187, 188, 189, 190].indexOf(keyDownEvent.keyCode) > -1) {
                    // disallow e . , -
                    event.preventDefault();
                }
            };

            $scope.getVariableControlLabelClass = function (variable) {
                if (!variable.requiresValue) {
                    return '';
                }
                return isEmpty(variable.value) && isEmpty(variable.variable) ? 'error' : '';
            };
            $scope.removeVariable = function (variable) {
                var indexOfVarToDelete = $scope.variables.findIndex(function (v) {
                    return v.key === variable.key;
                });
                $scope.variables.splice(indexOfVarToDelete, 1);
                $scope.onRemove({ variable: variable });
            };
            $scope.getDisplayName = VariablesService.getDisplayName;
            $scope.getKey = VariablesService.getKey;
            $scope.isStringVariable = VariablesService.isStringVariable;
            $scope.isDropDownListBox = VariablesService.isDropDownListBox;
        },

        scope: {
            form: '=',
            variables: '=',
            readonly: '=',
            filter: '=',
            onChange: '&?',
            allVariables: '=',
            replaceVariables: '=',
            allVariablesReplaceable: '=',
            supportsNewVariable: '=',
            onNewVariable: '&?',
            enableRemove: '<',
            onRemove: '&?'
        }
    };
}]);

/***/ }),
/* 1318 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


angular.module('xlrelease').factory('VariablesInterpolator', [function () {
    // Matches and captures ${...}, where "..." contains anything except '}'
    var VARIABLE_MATCHER = /(\$\{[^}]+\})/g;

    // Matches and captures all special chars in regexps in order to escape them.
    var ESCAPE_REGEXP_MATCHER = /([.*+?^=!:${}()|\[\]\/\\])/g;

    function escapeRegExp(variableName) {
        return variableName.replace(ESCAPE_REGEXP_MATCHER, '\\$1');
    }

    function interpolate(text, variableValues, quoteReplacement) {
        if (text) {
            var variables = _.uniq(text.match(VARIABLE_MATCHER));

            _.forEach(variables, function (variable) {
                var replacement = variable;
                if (variableValues && !_.isUndefined(variableValues[variable]) && !_.isNull(variableValues[variable])) {
                    replacement = variableValues[variable];
                }

                var regExp = new RegExp(escapeRegExp(variable), 'g');
                text = text.replace(regExp, quoteReplacement(replacement));
            });
        }
        return text;
    }

    return {
        interpolateInText: function interpolateInText(variableViews, text) {
            return interpolate(text, variableViews, function (text) {
                return _.escape(text);
            });
        },
        interpolateInHtml: function interpolateInHtml(variableViews, text) {
            var variableValues = _.mapValues(variableViews, function (value) {
                return value ? _.escape(value) : value;
            });

            function quoteHtmlReplacement(replacement) {
                return '<span class="variable">' + replacement + '</span>';
            }
            return interpolate(text, variableValues, quoteHtmlReplacement);
        }
    };
}]);

/***/ }),
/* 1319 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _variableTypes = __webpack_require__(516);

var _variableTypes2 = _interopRequireDefault(_variableTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').directive('variablesList', function () {
    return {
        templateUrl: "partials/variables/variables-list.html",
        restrict: 'A',
        scope: {
            variables: '=',
            allVariables: '=',
            filter: '=',
            isReadonly: '=',
            pageType: '=',
            onChange: '&',
            onDelete: '&',
            onReorder: '&',
            onNewVariable: '&',
            isRenameEnabled: '=',
            showFolderPath: '<'
        },
        controller: 'variablesListController'
    };
});

angular.module('xlrelease').controller('variablesListController', ['$scope', '$filter', 'VariablesService', function ($scope, $filter, VariablesService) {
    $scope.getKey = VariablesService.getKey;
    $scope.getValue = VariablesService.getValue;
    $scope.getVariableType = VariablesService.getVariableType;

    $scope.sortableOptions = {
        tolerance: 'pointer',
        containment: 'parent',
        //helper function comes from https://bugzilla.mozilla.org/show_bug.cgi?id=787944
        helper: function helper(event, ui) {
            var $clone = angular.element(ui).clone();
            $clone.css('position', 'absolute');
            return $clone.get(0);
        },

        disabled: _variableTypes2.default.isGlobalOrFolder($scope.pageType) || $scope.isReadonly,
        update: function update() {
            $scope.onReorder($scope.variables);
        }
    };

    $scope.filterOnVisibleFields = _.memoize(function (filter) {
        function containsFilter(string) {
            if (!filter) {
                return true;
            }
            return angular.isString(string) && string.toLowerCase().indexOf(filter.toLowerCase()) >= 0;
        }

        return function (value) {
            return containsFilter(VariablesService.getKey(value)) || containsFilter(VariablesService.getValue(value)) || containsFilter(VariablesService.getVariableType(value).label) || containsFilter(value.label);
        };
    });

    $scope.filteredVariables = function () {
        return $filter('filter')($scope.variables, $scope.filterOnVisibleFields($scope.filter));
    };

    $scope.editVariable = function (variable) {
        return angular.copy(variable);
    };

    $scope.saveVariable = function (updatedVariable, onSuccess) {
        var variable = _.find($scope.variables, { id: updatedVariable.id });
        variable = _.extend(variable, updatedVariable);

        if ($scope.onChange && $scope.onChange()) {
            $scope.onChange()(variable, onSuccess);
        } else if (onSuccess) {
            onSuccess();
        }
    };

    $scope.createVariable = function (variable, onSuccess) {
        if ($scope.onNewVariable && $scope.onNewVariable()) {
            $scope.onNewVariable()(variable, onSuccess);
        } else if (onSuccess) {
            onSuccess(variable);
        }
    };
}]);

/***/ }),
/* 1320 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _keys = __webpack_require__(121);

var _keys2 = _interopRequireDefault(_keys);

var _slicedToArray2 = __webpack_require__(108);

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _typeof2 = __webpack_require__(81);

var _typeof3 = _interopRequireDefault(_typeof2);

var _variableConstants = __webpack_require__(712);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

angular.module('xlrelease').factory('VariablesService', ['$filter', '$q', '$sce', 'Backend', 'Ids', function ($filter, $q, $sce, Backend, Ids) {

    function containsOnlyVariable(value) {
        return (/^\$\{[^\}]+\}$/.test(value)
        );
    }

    function getAllVariables(releaseId, folderId) {
        folderId = Ids.getInternalFolderId(folderId || releaseId);
        var promises = releaseId ? [getReleaseVariables(releaseId)] : [];
        promises.push(getGlobalVariables());
        if (folderId) {
            promises.push(listFolderVariables(folderId));
        }
        return $q.all(promises).then(function (results) {
            return _.chain(results).map(function (result) {
                return result.data;
            }).flatten().map(decorateVariable).value();
        });
    }

    function getAllVariableValues(releaseId, folderId) {
        folderId = Ids.getInternalFolderId(folderId || releaseId);
        var promises = folderId ? [getFolderVariableValues(folderId)] : [];
        promises.push(getGlobalVariableValues());
        return releaseId ? getReleaseVariableValues(releaseId).then(function (response) {
            return response.data;
        }) : $q.all(promises).then(function (results) {
            return _.chain(results).map(function (response) {
                return response.data;
            }).reduce(_.assign).value();
        });
    }

    function decorateVariable(variable) {
        return _.chain(variable).cloneDeep().extend({
            displayName: getLongDisplayName(variable),
            variableName: getKey(variable)
        }).value();
    }

    function listFolderOnlyVariables(folderId) {
        var params = {
            folderOnly: true
        };
        return Backend.get('api/v1/folders/' + Ids.toDomainId(Ids.getInternalFolderId(folderId)) + '/variables', { params: params });
    }

    function listFolderVariables(folderId) {
        return Backend.get('api/v1/folders/' + Ids.toDomainId(Ids.getInternalFolderId(folderId)) + '/variables');
    }

    function getFolderVariableValues(folderId) {
        return Backend.get('api/v1/folders/' + Ids.toDomainId(Ids.getInternalFolderId(folderId)) + '/variableValues');
    }

    function createFolderVariable(folderId, variable) {
        return Backend.post('api/v1/folders/' + Ids.toDomainId(Ids.getInternalFolderId(folderId)) + '/variables', removeEmptyValue(variable));
    }

    function updateFolderVariable(variable) {
        return Backend.put('api/v1/folders/' + variable.folderId + '/' + variable.id, removeEmptyValue(variable));
    }

    function deleteFolderVariable(variable) {
        return Backend.del('api/v1/folders/' + variable.folderId + '/' + variable.id);
    }

    function serializeVariable(variable) {
        var cloned = _.cloneDeep(variable);
        delete cloned.displayName;
        delete cloned.variableName;
        return cloned;
    }

    function toSerializableVariables(variables) {
        if (!variables) return variables;
        return variables.map(serializeVariable);
    }

    function getReleaseVariables(releaseId, config) {
        return Backend.get('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variables', config);
    }

    function getReleaseVariableValues(releaseId) {
        return Backend.get('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variableValues');
    }

    function createReleaseVariable(releaseId, variable) {
        return Backend.post('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variables', removeEmptyValue(variable));
    }

    function updateReleaseVariables(releaseId, variables) {
        return Backend.put('api/v1/releases/' + Ids.toDomainId(releaseId) + '/variables', variables);
    }

    function updateReleaseVariable(variable) {
        return Backend.put('api/v1/releases/' + variable.id, removeEmptyValue(variable));
    }

    function replaceReleaseVariable(oldVariable, newVariable) {
        return Backend.post('api/v1/releases/' + oldVariable.id + '/replace', removeEmptyValue(newVariable));
    }

    function deleteReleaseVariable(variable) {
        return Backend.del('api/v1/releases/' + variable.id);
    }

    function isReleaseVariableUsed(variable) {
        return Backend.get('api/v1/releases/' + variable.id + '/used');
    }

    function getGlobalVariables() {
        return Backend.get('api/v1/config/Configuration/variables/global');
    }

    function getGlobalVariableValues() {
        return Backend.get('api/v1/config/Configuration/variableValues/global');
    }

    function createGlobalVariable(variable) {
        return Backend.post('api/v1/config/Configuration/variables/global', removeEmptyValue(variable));
    }

    function updateGlobalVariable(variable) {
        return Backend.put('api/v1/config/' + variable.id, removeEmptyValue(variable));
    }

    function deleteGlobalVariable(variable) {
        return Backend.del('api/v1/config/' + variable.id, removeEmptyValue(variable)); // TODO why passing json to delete
    }

    function convertToMap(variables) {
        if (_.isArray(variables)) {
            return _.fromPairs(_.map(_.reject(variables, isPasswordVariable), function (variable) {
                return [withVariableSyntax(variable.key), getValue(variable)];
            }));
        }
        return variables;
    }

    function isPasswordVariable(variable) {
        return variable && variable.type === _variableConstants.VariableConstants.type.passwordString.key;
    }

    function isCiPropertyVariableName(key) {
        return !_.isEmpty(key) && /^release\..*$/.test(withoutVariableSyntax(key));
    }

    function isGlobalVariableName(key) {
        return !_.isEmpty(key) && /^global\..*$/.test(withoutVariableSyntax(key));
    }

    function isFolderVariable(key) {
        return !_.isEmpty(key) && /^folder\..*$/.test(withoutVariableSyntax(key));
    }

    function isFolderOrGlobalVariable(key) {
        return isFolderVariable(key) || isGlobalVariableName(key);
    }

    function hasVariableSyntax(key) {
        return (/^\$\{.*$/.test(key)
        );
    }

    function withVariableSyntax(key) {
        return '${' + withoutVariableSyntax(key) + '}';
    }

    function withoutVariableSyntax(key) {
        return key.replace(/^\$\{([^}]+)\}$/, "$1");
    }

    function getKey(variable) {
        if (variable.key) {
            return '${' + withoutVariableSyntax(variable.key) + '}';
        }
        return variable.key;
    }

    function getVariableType(variable) {
        var variableTypeList = getVariableTypeList();
        return _.find(variableTypeList, function (type) {
            return type.key === variable.type && (angular.isDefined(variable.valueProvider) && angular.isDefined(type.valueProvider) || angular.isUndefined(variable.valueProvider) && angular.isUndefined(type.valueProvider));
        });
    }

    function getValue(variable) {
        if (variable && variable.value !== null && angular.isDefined(variable.value)) {
            if (variable.type === _variableConstants.VariableConstants.type.passwordString.key) {
                return '******';
            } else if (variable.type === _variableConstants.VariableConstants.type.setString.key) {
                return 'set([' + _.map(variable.value, function (v) {
                    return '"' + v + '"';
                }).join(', ') + '])';
            } else if (variable.type === _variableConstants.VariableConstants.type.boolean.key) {
                return variable.value ? 'True' : 'False';
            } else if (variable.type === _variableConstants.VariableConstants.type.date.key) {
                return $filter('date')(variable.value, 'short');
            } else if (variable.type === _variableConstants.VariableConstants.type.listString.key || variable.type === _variableConstants.VariableConstants.type.mapStringString.key || variable.type === _variableConstants.VariableConstants.type.integer.key) {
                return angular.toJson(variable.value, false);
  