import React from 'react';
import { mount } from 'enzyme/build';
import 'moment-duration-format';
import { OrderConst } from './const';
import { ReleaseListComponent } from './release-list.component';
import { NoData } from '../no-data/no-data';
import { ReleaseHeaderLabelComponent } from './release-header-label.component';
import { ReleaseRowComponent } from './release-row.component';

describe('ReleaseListComponent', () => {
    test('should render spinner when loading', () => {
        const onOrderChange = jest.fn();
        const releaseList = mount(
            <ReleaseListComponent
                header={[]}
                loadingReleases={true}
                noData={<NoData message={<span>No data</span>} />}
                onOrderChange={onOrderChange}
                releases={[]}
            />,
        );
        expect(releaseList.find('.spinner').exists()).toBeTruthy();
    });

    test('should render release list when no data', () => {
        const onOrderChange = jest.fn();
        const releaseList = mount(
            <ReleaseListComponent
                header={[]}
                loadingReleases={false}
                noData={<NoData message={<span>No data</span>} />}
                onOrderChange={onOrderChange}
                releases={[]}
            />,
        );
        expect(releaseList.find(NoData).text()).toContain('No data');
    });

    test('should render release list when with release data', () => {
        const header = [
            {
                label: 'Release',
                fieldName: 'title',
                class: 'release-title',
                sortable: false,
            },
            {
                label: 'Status',
                fieldName: 'status',
                class: 'release-status',
                sortable: true,
                order: OrderConst.SORT_NONE,
            },
            {
                label: 'Progress',
                fieldName: 'progress',
                class: 'release-progress',
                sortable: true,
                order: OrderConst.SORT_NONE,
            },
            {
                label: 'Start date',
                fieldName: 'start-date',
                class: 'release-start-date',
                sortable: true,
                order: OrderConst.SORT_NONE,
            },
            {
                label: 'End date',
                fieldName: 'end-date',
                class: 'release-end-date',
                sortable: true,
                order: OrderConst.SORT_NONE,
            },
            {
                label: 'Duration',
                fieldName: 'durationAuditReportReleaseRowHeaderComponent',
                class: 'release-duration',
                sortable: true,
                order: OrderConst.SORT_NONE,
            },
        ];
        const releases = [
            {
                id: 'Releasecc8395aca8dc471ab557a60d0945f2e2',
                title: 'Sample',
                currentPhase: 'Dev',
                startDate: 1557298800000,
                endDate: 1557327600000,
                duration: 324325,
                progress: { totalTasks: 100, totalRemainingTasks: 42 },
                status: 'IN_PROGRESS',
                isArchived: false,
                folders: [
                    {
                        id: 'Folder8620f34eee8d428ba3342ca6cbb34e28',
                        title: 'Folder 1',
                    },
                    {
                        id: 'Folder7fd97ed5e2314d5d81cb94f7ac56aa11',
                        title: 'Folder 2',
                    },
                ],
            },
            {
                id: 'Releasecc8395aca8dc471ab557a60d0945f2e1',
                title: 'Release 2',
                currentPhase: 'Dev',
                startDate: 1557298800000,
                endDate: 1557327600000,
                duration: 324325,
                progress: { totalTasks: 100, totalRemainingTasks: 42 },
                status: 'IN_PROGRESS',
                isArchived: false,
                folders: [
                    {
                        id: 'Folder8620f34eee8d428ba3342ca6cbb34e24',
                        title: 'Folder 1',
                    },
                    {
                        id: 'Folder7fd97ed5e2314d5d81cb94f7ac56aa13',
                        title: 'Folder 2',
                    },
                ],
            },
        ];
        const onOrderChange = jest.fn();
        const releaseList = mount(
            <ReleaseListComponent
                header={header}
                loadingReleases={false}
                noData={<NoData message={<span>No data</span>} />}
                onOrderChange={onOrderChange}
                releases={releases}
            />,
        );
        expect(releaseList.find(ReleaseHeaderLabelComponent).exists()).toBeTruthy();
        expect(releaseList.find(ReleaseRowComponent)).toHaveLength(2);
        expect(releaseList.find(NoData).exists()).toBeFalsy();
        expect(releaseList.find('.spinner').exists()).toBeFalsy();
    });
});
