import React from 'react';
import { mount } from 'enzyme/build';
import { HighlightText } from './hightlight-text';

describe('HighlightText', () => {
    test('should render highlight text component when no matches Found', () => {
        const text = 'FolderA';
        const searchText = 'FolderAA';
        const highlightTextComponent = mount(<HighlightText searchText={searchText} text={text} />);
        expect(highlightTextComponent.exists()).toBeTruthy();
        expect(highlightTextComponent.html()).toContain('<div class="highlight-text-wrapper">FolderA</div>');
    });

    test('should render highlight text component when matches Found', () => {
        const text = 'FolderA';
        const searchText = 'FolderA';
        const highlightTextComponent = mount(<HighlightText searchText={searchText} text={text} />);
        expect(highlightTextComponent.exists()).toBeTruthy();
        expect(highlightTextComponent.html()).toContain('<div class="highlight-text-wrapper"><span class="highlight-text">FolderA</span></div>');
    });

    test('should render correct highlighted text when matches Found', () => {
        const text = 'bla bla bla bla';
        const searchText = 'bla';
        const highlightTextComponent = mount(<HighlightText searchText={searchText} text={text} />);
        expect(highlightTextComponent.exists()).toBeTruthy();
        expect(highlightTextComponent.html()).toContain(
            '<div class="highlight-text-wrapper"><span class="highlight-text">bla</span> <span class="highlight-text">bla</span> <span class="highlight-text">bla</span> <span class="highlight-text">bla</span></div>',
        );
    });
});
