import React, { ChangeEventHandler } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import './search.less';

export interface SearchProps {
    defaultValue: string;
    inputPlaceholder: string;
    onFilterChange?: ChangeEventHandler<HTMLInputElement>;
    searchClassNames: string[];
}

export const Search = ({ defaultValue = '', onFilterChange, searchClassNames = [], inputPlaceholder = '' }: SearchProps) => {
    return (
        <div className={classNames('search', ...searchClassNames)}>
            <i className="xl-icon search-icon" />
            <input autoFocus={true} className="search-input" defaultValue={defaultValue} onChange={onFilterChange} placeholder={inputPlaceholder} type="text" />
        </div>
    );
};

Search.propTypes = {
    defaultValue: PropTypes.string,
    inputPlaceholder: PropTypes.string,
    onFilterChange: PropTypes.func.isRequired,
    searchClassNames: PropTypes.arrayOf(PropTypes.string),
};
