import React from 'react';
import { mount } from 'enzyme/build';
import { FolderPathComponent } from './folder-path.component';

describe('FolderPathComponent', () => {
    test('should render one folder', () => {
        const folders = [
            {
                id: 'Folder1',
                title: 'Folder 1',
            },
        ];
        const folderPathComponent = mount(<FolderPathComponent folders={folders} childUri={'templates'} />);
        expect(folderPathComponent.find('.folder-path-view > li')).toHaveLength(1);
        const folder1 = folderPathComponent.find('.folder-path-view > li').first();
        expect(folder1.text()).toContain('Folder 1');
        expect(folder1.find('div > a').prop('href')).toContain('#/folders/Applications/Folder1/templates');
    });

    test('should render folder with child', () => {
        const folders = [
            {
                id: 'Folder1',
                title: 'Folder 1',
            },
            {
                id: 'Folder2',
                title: 'Folder 2',
            },
        ];
        const folderPathComponent = mount(<FolderPathComponent folders={folders} childUri={'templates'} />);
        expect(folderPathComponent.find('.folder-path-view > li')).toHaveLength(2);
        const folderLinks = ['#/folders/Applications/Folder1/templates', '#/folders/Applications/Folder1/Folder2/templates'];
        folderPathComponent.find('.folder-path-view > li').forEach((node, idx) => {
            expect(node.text()).toContain(folders[idx].title);
            expect(node.find('div > a').prop('href')).toContain(folderLinks[idx]);
        });
    });

    test('should render folder with icon on icon flag on', () => {
        const folders = [
            {
                id: 'Folder1',
                title: 'Folder 1',
            },
        ];
        const folderPathComponent = mount(<FolderPathComponent folders={folders} showIcon={true} childUri={'templates'} />);
        expect(folderPathComponent.find('.folder-path-view > li')).toHaveLength(1);
        const folder1 = folderPathComponent.find('.folder-path-view > li').first();
        expect(folder1.text()).toContain('Folder 1');
        expect(folder1.find('div > a').prop('href')).toContain('#/folders/Applications/Folder1/templates');
        expect(folder1.find('div > a > i').prop('className')).toContain('xl-icon icon-xs folder-icon');
    });
});
