import React from 'react';
import { mount } from 'enzyme/build';
import { calculatePercentage, ReleaseProgressComponent } from './release-progress.component';

describe('ReleaseProgressComponent', () => {
    it('should render release progress', () => {
        const completedPercentage = 54.32;
        const releaseProgressComponent = mount(<ReleaseProgressComponent completedPercentage={completedPercentage} />);
        expect(releaseProgressComponent.find('.release-progress-bar-view').text()).toBe('54.32% Completed');
        expect(releaseProgressComponent.find('.release-progress-bar-view > .progress-bar-container > .progress-bar-line').prop('style')).toHaveProperty(
            'width',
            '54.32%',
        );
    });

    it('should return 0 if progress is undefined', () => {
        const progress = undefined;
        const completedPercentage = undefined;

        const releaseProgressComponent = mount(<ReleaseProgressComponent completedPercentage={completedPercentage} progress={progress} />);
        expect(releaseProgressComponent.find('.release-progress-bar-view').text()).toBe('0% Completed');
    });

    it('should return 0 when calculating the percetange', () => {
        expect(calculatePercentage(undefined)).toBe(0);
    });
});
