import { MainNavigationItem } from '../features/tasks/types/angular';
import { PropertiesByCategoryFromApi } from '../features/configuration/types';

export interface SyntheticPropertyDefinition {
    asContainment: boolean;
    category: string;
    default: { [key: string]: string } | string | string[] | boolean | number | null;
    description: string;
    enumValues?: Array<string>;
    fqn: string;
    hidden?: boolean;
    inputHint?: SyntheticInputHint;
    inspection: boolean;
    kind: KindType;
    label: string;
    name: string;
    password: boolean;
    readonly: boolean;
    referencedType: string | null;
    required: boolean;
    requiredInspection: boolean;
    size: SizeType;
    transient: boolean;
}

export interface SyntheticInputHint {
    'dynamic-lookup': boolean;
    'method-ref'?: string;
    referencedType?: string | null;
    values: Array<SyntheticInputHintValue>;
}

export type KindType =
    | 'ENUM'
    | 'BOOLEAN'
    | 'INTEGER'
    | 'STRING'
    | 'DATE'
    | 'CI'
    | 'SET_OF_CI'
    | 'SET_OF_STRING'
    | 'MAP_STRING_STRING'
    | 'LIST_OF_CI'
    | 'LIST_OF_STRING';

export type SizeType = 'DEFAULT' | 'SMALL' | 'MEDIUM' | 'LARGE';

export interface SyntheticInputHintValue {
    label?: string;
    value?: string;
}

export interface SyntheticTypeDefinition {
    description: string;
    label: string;
    properties: SyntheticPropertyDefinition[];
    propertiesByCategory?: PropertiesByCategoryFromApi;
    required?: boolean;
    superTypes?: string[];
    type: string;
    virtual: boolean;
}

export interface MenuItem {
    dispatch?: string;
    divider?: boolean;
    endIconId?: string;
    id?: string;
    items?: MenuItem[];
    pathSuffix?: string;
    permission?: string;
    selected?: boolean;
    startIconId?: string;
    text: string;
    title?: string;
    uri?: string;
    weight?: number;
}

export interface GetMenuItemExtensionsProps {
    currentPath: string;
    extensionServiceItems: MainNavigationItem[];
    isTemplate: boolean;
    releaseId: string;
}
