import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Popover } from 'antd';
import map from 'lodash/map';
import './release-count-component.less';

const ReleaseCountResult = PropTypes.shape({
    total: PropTypes.number,
    byStatus: PropTypes.object,
});
export const ReleaseCountResults = PropTypes.shape({
    all: ReleaseCountResult.isRequired,
    live: ReleaseCountResult.isRequired,
    archived: ReleaseCountResult.isRequired,
});

export class ReleaseCountComponent extends Component {
    static propTypes = {
        releaseCount: ReleaseCountResults,
    };

    render() {
        const { releaseCount } = this.props;
        const getIconClass = (status) => status.replace('_', '-').toLowerCase();
        const getStatusText = (status) => {
            const lowerCasedStatus = status.replace('_', ' ').toLowerCase();
            return lowerCasedStatus.charAt(0).toUpperCase() + lowerCasedStatus.slice(1);
        };
        const pluralizeReleaseWord = (count) => {
            if (count === 1) {
                return 'release';
            } else {
                return 'releases';
            }
        };

        // eslint-disable-next-line angular/definedundefined
        if (releaseCount === undefined) {
            return '';
        } else if (releaseCount.all.total === 0) {
            return '';
        }

        const all = map(releaseCount.all.byStatus, (count, status) => (
            <p key={status}>
                <i className={`circle ${getIconClass(status)}`} />
                {count} {getStatusText(status)}
            </p>
        ));
        const content = (
            <div className="release-status-count-popup">
                <div>{all}</div>
            </div>
        );

        return (
            <span className="release-count">
                <Popover content={content} overlayClassName="release-count-popover" placement="bottom">
                    {releaseCount.all.total} {pluralizeReleaseWord(releaseCount.all.total)}
                </Popover>
            </span>
        );
    }
}
