import React, { useEffect, useRef } from 'react';
import PropTypes from 'prop-types';

export const ClickOutside = ({ onClickyOutside, children }) => {
    const ref = useRef(null);

    const handleClick = (e) => {
        if (!ref.current.contains(e.target)) {
            onClickyOutside();
        }
    };

    useEffect(() => {
        document.addEventListener('mousedown', handleClick);
        return () => {
            document.removeEventListener('mousedown', handleClick);
        };
    }, []);

    return <div ref={ref}>{children}</div>;
};

ClickOutside.propTypes = {
    children: PropTypes.element.isRequired,
    onClickyOutside: PropTypes.func.isRequired,
};
