import React from 'react';
import PropTypes from 'prop-types';
import { DotButton, DotLink } from '@digital-ai/dot-components';
import './link-button.component.less';

export const LinkButton = ({ href, children }) => {
    return (
        <DotButton className="link-button">
            <DotLink href={href} underline="none">
                {children}
            </DotLink>
        </DotButton>
    );
};

LinkButton.propTypes = {
    children: PropTypes.element,
    href: PropTypes.string,
};
