import React, { Component } from 'react';
import cs from 'classnames';
import PropTypes from 'prop-types';
import './page-button.less';

export class PageButton extends Component {
    handleClick = (e) => {
        e.preventDefault();
        this.props.onPageChange(this.props.page);
    };

    render() {
        const { page, title, active, disabled, className } = this.props;
        const classes = cs(
            {
                active,
                disabled,
                'page-item': true,
            },
            className,
        );

        return (
            <li className={classes} title={title}>
                <button className="page" onClick={this.handleClick}>
                    {page}
                </button>
            </li>
        );
    }
}

PageButton.propTypes = {
    active: PropTypes.bool.isRequired,
    className: PropTypes.string,
    disabled: PropTypes.bool.isRequired,
    onPageChange: PropTypes.func.isRequired,
    page: PropTypes.oneOfType([PropTypes.node, PropTypes.number, PropTypes.string]).isRequired,
    title: PropTypes.string,
};
