import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { XlReactWidgetConfirmationDialog } from 'xl-react-components';
import { keyCodes } from '../../constants/key-codes';

export class XlrDeleteButton extends Component {
    static propTypes = {
        item: PropTypes.any.isRequired,
        modalHeader: PropTypes.string.isRequired,
        onDelete: PropTypes.func.isRequired,
        renderModalBodyFn: PropTypes.func.isRequired,
    };

    constructor(props) {
        super(props);
        this.state = {
            deleteModalIsOpen: false,
        };
    }

    delete = (action) => {
        const { item } = this.props;
        if (action === deleteButton.action) {
            this.props.onDelete(item);
        }
        this.setState({ deleteModalIsOpen: false });
    };

    showDeleteModal = () => this.setState({ deleteModalIsOpen: true });

    _handleKeyDown = (e) => {
        if (e.key === 'Enter') {
            this.showDeleteModal();
        }
    };

    render() {
        const { modalHeader, renderModalBodyFn } = this.props;
        const { deleteModalIsOpen } = this.state;
        const title = <React.Fragment>{modalHeader}</React.Fragment>;

        return (
            <span>
                <span className="link delete" onClick={this.showDeleteModal} onKeyDown={this._handleKeyDown}>
                    <i className="menu-item-icon xl-icon delete-icon" title="Delete" />
                    <span className="action-label">{deleteButton.label}</span>
                </span>
                <XlReactWidgetConfirmationDialog
                    buttons={[cancelButton, deleteButton]}
                    dialogClassName="xl-default-modal no-cross"
                    onButtonClick={this.delete}
                    show={deleteModalIsOpen}
                    title={title}
                >
                    {renderModalBodyFn()}
                </XlReactWidgetConfirmationDialog>
            </span>
        );
    }
}

const deleteButton = {
    action: 'delete',
    className: 'button primary',
    keyCodes: [keyCodes.ENTER, keyCodes.DELETE],
    label: 'Delete',
};

const cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [keyCodes.ESC],
    label: 'Cancel',
};
