import { AutoCompleteOption } from '@digital-ai/dot-components';
import { ExternalDeploymentFilters } from '../../../../modules/xlr-status-event-module/src/main/resources/web/include/external-deployments/external-deployment.types';
import { SyntheticPropertyDefinition } from './synthetic';
import { Watchers } from '../features/tasks/ducks/task-drawer.reducer';

export interface WithTitleAndId {
    id: string;
    title: string;
}

export interface UserProfileSettings {
    analyticsEnabled: boolean;
    dateFormat: string;
    email: string;
    external: boolean;
    externalId?: string;
    firstDayOfWeek: number;
    fullName?: string;
    lastActive: number;
    loginAllowed: boolean;
    profileId: string;
    taskDrawerEnabled: boolean;
    timeFormat: string;
    username: string;
}

export interface AuthenticationData {
    username: string;
}

export interface ClientSettings {
    getAuthenticationData: () => AuthenticationData;
    getExternalDeploymentsFilters: () => ExternalDeploymentFilters;
    setExternalDeploymentsFilters: (filter: ExternalDeploymentFilters) => void;
}

export interface FilterQueryParams {
    update: (filter: unknown) => void;
}

export interface TaskContainer {
    tasks: Array<Task>;
}

export type TaskStatus =
    | 'IN_PROGRESS'
    | 'PLANNED'
    | 'SKIPPED_IN_ADVANCE'
    | 'COMPLETED_IN_ADVANCE'
    | 'COMPLETED'
    | 'SKIPPED'
    | 'ABORTED'
    | 'PENDING'
    | 'FACET_CHECK_IN_PROGRESS'
    | 'FAILED'
    | 'FAILING'
    | 'FAILURE_HANDLER_IN_PROGRESS'
    | 'ABORT_SCRIPT_IN_PROGRESS'
    | 'PRECONDITION_IN_PROGRESS'
    | 'QUEUED'
    | 'ABORT_SCRIPT_QUEUED'
    | 'WAITING_FOR_INPUT'
    | 'FAILURE_HANDLER_QUEUED';

export type DependencyStatus = TaskStatus | 'archived' | 'not_found';
export type ReleaseStatus = 'TEMPLATE' | 'PLANNED' | 'IN_PROGRESS' | 'PAUSED' | 'FAILING' | 'FAILED' | 'COMPLETED' | 'ABORTED';

export type VariableType =
    | 'xlrelease.StringVariable'
    | 'xlrelease.PasswordStringVariable'
    | 'xlrelease.BooleanVariable'
    | 'xlrelease.IntegerVariable'
    | 'xlrelease.ListStringVariable'
    | 'xlrelease.DateVariable'
    | 'xlrelease.MapStringStringVariable'
    | 'xlrelease.SetStringVariable';

export interface User {
    fullName?: string;
    username: string;
}

export interface FacetType {
    label: string;
    properties: Array<SyntheticPropertyDefinition>;
    type: string;
}

export type TaskFacet = {
    [key: string]: Value | null;
} & {
    id: string; // defaults to "-1" when creating
    targetId: string;
    type: string;
    variableMapping: TaskVariableMapping;
};

export interface Task extends WithTitleAndId {
    attachments: Array<Attachment>;
    automated: boolean;
    checkAttributes?: boolean;
    color: string | null;
    configurationUri?: string;
    customIconClass?: string;
    customIconLocation?: string;
    delayDuringBlackout: boolean;
    description: string | null;
    dueDate?: number;
    editable: boolean;
    endDate?: number;
    facets: Array<TaskFacet>;
    failureHandler?: string;
    failureHandlerEnabled: boolean;
    flag: Flag;
    inputProperties?: TaskProperties;
    locked: boolean;
    numberOfComments: number;
    outputProperties?: TaskProperties;
    owner?: User;
    phaseTitle: string;
    plannedDuration?: number;
    postponedDueToBlackout?: boolean;
    precondition?: string;
    preconditionEnabled: boolean;
    releaseId: string;
    releaseOwner: User;
    releaseTitle: string;
    scheduledStartDate?: number;
    scriptDefinitionType?: string;
    startDate?: number;
    status: TaskStatus;
    tags: string[];
    taskFailureHandlerEnabled: boolean;
    taskRecoverOp: string;
    team?: string;
    type: string;
    typeDisplayGroup: string;
    typeDisplayName: string;
    variableMapping: TaskVariableMapping;
    waitForScheduledStartDate?: boolean;
    watchers: Watchers;
}

export interface ScriptTask extends Task {
    ignoreScriptVariableInterpolation: boolean;
    script: string | null;
}

export interface ExternalScriptTask extends Task {
    ignoreScriptVariableInterpolation: boolean;
    password: TaskInputPropertiesVariableOrValue;
    script: string | null;
    server: string | null;
    username: string | null;
    variables: Variable[];
}

export interface TaskWithVariables extends Task {
    variables: Variable[];
}

export interface UserInputTask extends TaskWithVariables {
    updatingVariablesCount?: number;
}

export interface TaskProperties {
    [key: string]: TaskInputPropertyValue;
}

export interface TaskVariableValues {
    [key: string]: TaskInputPropertiesVariableOrValue;
}

export interface TaskVariableMapping {
    [key: string]: string;
}

export type TaskInputPropertyValue = Value | TaskInputPropertiesVariableOrValue | null;

export interface TaskInputPropertiesVariableOrValue {
    value: Value | null;
    variable: string | null;
}

export interface TaskInputWithMap {
    [key: string]: string;
}

export type Value = string | number | boolean | string[] | TaskInputWithMap | null;
export type FlagStatus = 'OK' | 'ATTENTION_NEEDED' | 'AT_RISK';

export interface Flag {
    comment?: string;
    status: FlagStatus;
}

export interface ConfigurationItemWithTitle extends AutoCompleteOption {
    id?: string;
}

export interface CiArrayMap {
    [key: string]: Array<ConfigurationItemWithTitle> | SimpleRelease;
}

export interface TaskStatusMap {
    [key: string]: TaskStatus;
}

export interface DependencyTargetView {
    id: string;
    status: TaskStatus;
}

export interface DependencyTarget {
    archived?: boolean;
    id?: string;
    phaseId?: string;
    phaseTitle?: string;
    releaseId?: string;
    releaseTitle?: string;
    taskId?: string;
    taskTitle?: string;
}

export interface GateTaskCondition {
    checked: boolean;
    id: string;
    title: string;
}

export interface GateTaskVariableOrValue {
    value: DependencyTarget | null;
    variable?: string | null;
}

export interface GateTaskDependency {
    archived: boolean;
    id?: string;
    resolved?: boolean;
    variableOrTarget: GateTaskVariableOrValue;
}

export interface GateTask extends Task {
    conditions?: Array<GateTaskCondition>;
    dependencies?: Array<GateTaskDependency>;
}

export interface CreateReleaseTask extends Task {
    createdReleaseId: string | null;
    folderId: string | null;
    newReleaseTitle: string | null;
    releaseTags: string[];
    riskProfileId: string | null;
    startRelease: boolean | null;
    templateId: string | null;
    variables: Array<TaskVariable>;
}

export interface NotificationTask extends Task {
    addresses: Array<string>;
    bcc: Array<string>;
    body: string;
    cc: Array<string>;
    from: string;
    mailPriority: string;
    password: TaskInputPropertiesVariableOrValue;
    replyTo: string;
    subject: string;
    username: string;
}

export interface Phase extends TaskContainer, WithTitleAndId {}

export interface SimplePhase extends ConfigurationItemWithTitle {
    tasks?: Array<ConfigurationItemWithTitle>;
}

export interface TaskGroup extends Task, TaskContainer {}

// eslint-disable-next-line @typescript-eslint/no-empty-interface
export interface SequentialGroup extends TaskGroup {}

interface ParallelGroupLink {
    parallelGroup: ParallelGroup;
    source: Task;
    target: Task;
}

export interface ParallelGroup extends TaskGroup {
    links: Array<ParallelGroupLink>;
}

export interface ExternalVariableValue {
    externalKey?: string;
    id: string;
    path: string;
    server: string;
    type?: string;
}

export interface Variable {
    description?: string;
    displayName?: string;
    externalVariableValue?: ExternalVariableValue;
    id: string | null;
    inherited?: boolean;
    key: string;
    label?: string;
    requiresValue: boolean;
    showOnReleaseStart: boolean;
    title?: string;
    type: VariableType;
    value?: Value;
    valueProvider?: ValueProvider;
    variableName?: string;
}

export interface TaskVariable {
    description?: string;
    id: string | null;
    inherited?: boolean;
    key: string;
    label?: string;
    multiline?: boolean;
    requiresValue: boolean;
    showOnReleaseStart: boolean;
    type: VariableType;
    value?: Value;
    valueProvider?: string;
}

export interface ValueProvider {
    id: string;
    type: string;
    variable: string; // id of the parent variable
    variableMapping: TaskVariableMapping;
}

export type ValueProviderValue = string | WithTitleAndId;
export type ValueProviderValues = Array<ValueProviderValue>;

export interface ReleaseVariable {
    [key: string]: string; // release variables are always string
}

interface ReleaseSecurity {
    permissions: Array<string>;
    teams: Array<string>;
}

export interface Release extends WithTitleAndId {
    archived: boolean;
    phases: Array<Phase>;
    security: ReleaseSecurity;
    status: ReleaseStatus;
    variables?: ReleaseVariable;
}

export interface SimpleRelease extends ConfigurationItemWithTitle {
    phases: Array<SimplePhase>;
}

export interface Team {
    id: string;
    members: Array<string>;
    permissions: Array<string>;
    roles: Array<string>;
    teamName: string;
    type: string;
}

// com.xebialabs.xlrelease.views.ReleaseTasks
export interface ReleaseTasks extends WithTitleAndId {
    status: ReleaseStatus;
    tasks: Array<Task>;
    variables?: ReleaseVariable;
}

export interface Attachment {
    contentType: string;
    filename: string;
    id: string;
}

export interface Folder extends WithTitleAndId {
    children?: Array<Folder>;
}

export interface CustomConfiguration extends WithTitleAndId {
    type: string;
}

export interface LookupResultElement {
    label: string;
    value: string;
}

type RiskProfileType = 'xlrelease.RiskProfile';

export interface RiskProfile extends WithTitleAndId {
    defaultProfile: boolean;
    type: RiskProfileType;
}
