import React, { FC } from 'react';
import { DotButton, DotLink } from '@digital-ai/dot-components';
import './link-button.component.less';

export interface LinkButtonProps {
    dataTestId?: string;
    href: string;
}

// eslint-disable-next-line react/prop-types
export const LinkButton: FC<LinkButtonProps> = ({ dataTestId, href, children }) => {
    return (
        <DotButton className="link-button" data-testid={dataTestId}>
            <DotLink href={href} underline="none">
                {children}
            </DotLink>
        </DotButton>
    );
};
