import React, { Component } from 'react';
import PropTypes from 'prop-types';
import ClassNames from 'classnames';
import { RemoveComponent } from './remove.component';

export class Tag extends Component {
    static propTypes = {
        classNames: PropTypes.object,
        displayIcon: PropTypes.bool,
        labelField: PropTypes.string,
        onDelete: PropTypes.func.isRequired,
        onTagClicked: PropTypes.func,
        readOnly: PropTypes.bool,
        removeComponent: PropTypes.func,
        tag: PropTypes.shape({
            id: PropTypes.string.isRequired,
            className: PropTypes.string,
        }),
    };

    static defaultProps = {
        displayIcon: true,
        labelField: 'text',
        readOnly: false,
    };

    render() {
        const { props } = this;
        const label = props.tag[props.labelField];
        const { displayIcon, readOnly, tag, classNames } = props;
        const { className = '' } = tag;
        return (
            <React.Fragment>
                {displayIcon && <span className={classNames.tagIcon} />}
                <span
                    className={ClassNames('tag-wrapper', classNames.tag, className)}
                    data-tag-id={props.tag.id}
                    onClick={props.onTagClicked}
                    onKeyDown={props.onTagClicked}
                    onTouchStart={props.onTagClicked}
                >
                    {label}
                </span>
                <RemoveComponent
                    className={classNames.remove}
                    onClick={props.onDelete}
                    readOnly={readOnly}
                    removeComponent={props.removeComponent}
                    tag={props.tag}
                />
            </React.Fragment>
        );
    }
}
