export interface TaskContainer {
    tasks: Array<Task>;
}

export type TaskStatus =
    | 'IN_PROGRESS'
    | 'PLANNED'
    | 'SKIPPED_IN_ADVANCE'
    | 'COMPLETED_IN_ADVANCE'
    | 'COMPLETED'
    | 'SKIPPED'
    | 'ABORTED'
    | 'PENDING'
    | 'FACET_CHECK_IN_PROGRESS'
    | 'FAILED'
    | 'FAILING'
    | 'FAILURE_HANDLER_IN_PROGRESS'
    | 'ABORT_SCRIPT_IN_PROGRESS'
    | 'PRECONDITION_IN_PROGRESS'
    | 'QUEUED'
    | 'ABORT_SCRIPT_QUEUED'
    | 'WAITING_FOR_INPUT'
    | 'FAILURE_HANDLER_QUEUED';

type ReleaseStatus = 'TEMPLATE' | 'PLANNED' | 'IN_PROGRESS' | 'PAUSED' | 'FAILING' | 'FAILED' | 'COMPLETED' | 'ABORTED';

export interface User {
    fullName?: string;
    username: string;
}

export interface TaskFacet {
    type: string;
}

export interface Task {
    automated: boolean;
    configurationUri?: string;
    delayDuringBlackout: boolean;
    editable: boolean;
    facets: Array<TaskFacet>;
    id: string;
    locked: boolean;
    owner?: User;
    releaseOwner: User;
    status: TaskStatus;
    team?: string;
    title: string;
    type: string;
    typeDisplayName: string;
}

interface GateTaskCondition {
    checked: boolean;
}

interface GateTaskDependency {
    resolved: boolean;
}

export interface GateTask extends Task {
    conditions?: Array<GateTaskCondition>;
    dependencies?: Array<GateTaskDependency>;
}

export interface UserInputTask extends Task {
    updatingVariablesCount?: number;
    variables: Array<Variable>;
}

// eslint-disable-next-line @typescript-eslint/no-empty-interface
export interface Phase extends TaskContainer {}

export interface TaskGroup extends Task, TaskContainer {}

// eslint-disable-next-line @typescript-eslint/no-empty-interface
export interface SequentialGroup extends TaskGroup {}

export interface ParallelGroup extends TaskGroup {
    links: any;
}

export interface Variable {
    requiresValue: boolean;
    value: any;
}

export interface ReleaseVariable {
    [key: string]: any;
}

interface ReleaseSecurity {
    permissions: Array<string>;
    teams: Array<string>;
}

export interface Release {
    archived: boolean;
    security: ReleaseSecurity;
    status: ReleaseStatus;
    variables?: ReleaseVariable;
}
