import React from 'react';
import PropTypes from 'prop-types';

export const DocLinkComponent = ({ section }) => (
    <a
        className="xl-icon qmark-icon doc-icon"
        href={`https://docs.digital.ai/bundle/devops-release-version-v.@doc.version@/page/release/${section}`}
        rel="noopener noreferrer"
        target="_blank"
        title="Open documentation page related to this page in a new browser tab"
    />
);

DocLinkComponent.propTypes = {
    section: PropTypes.string.isRequired,
};
