import React, { useState } from 'react';
import PropTypes from 'prop-types';
import { DotButton, DotIcon, DotMenu } from '@digital-ai/dot-components';
import './dropdown.component.less';

export const Dropdown = ({ 'data-testid': dataTestId, className, text, maxVisibleItems, menuItems, type, onSelect, size }) => {
    const [isOpenDropdown, setOpenDropdown] = useState(false);
    const [dropdownAnchorEl, setDropdownAnchorEl] = useState(null);

    const switchDropdown = (event) => {
        setDropdownAnchorEl(event.currentTarget);
        setOpenDropdown(!isOpenDropdown);
    };

    return (
        <div className="dropdown-btn">
            <DotButton
                data-testid={dataTestId}
                endIcon={<DotIcon iconId={isOpenDropdown ? 'arrow-up' : 'arrow-down'} />}
                onClick={(e) => switchDropdown(e)}
                type={type}
            >
                {text}
            </DotButton>
            <DotMenu
                anchorEl={dropdownAnchorEl || undefined}
                className={className}
                disablePortal={true}
                maxVisibleItems={maxVisibleItems}
                menuItems={menuItems}
                menuPlacement="bottom-end"
                onLeave={() => setOpenDropdown(false)}
                onSelect={onSelect}
                open={isOpenDropdown}
            />
        </div>
    );
};

Dropdown.defaultProps = {
    type: 'outlined',
};

Dropdown.propTypes = {
    className: PropTypes.string,
    'data-testid': PropTypes.string,
    maxVisibleItems: PropTypes.number.isRequired,
    menuItems: PropTypes.arrayOf(PropTypes.object).isRequired,
    onSelect: PropTypes.func,
    size: PropTypes.oneOf(['small', 'medium', 'large']),
    text: PropTypes.string.isRequired,
    type: PropTypes.oneOf(['destructive', 'primary', 'outlined', 'text']),
};
