import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Popover} from 'antd';
import isUndefined from 'lodash/isUndefined';

import './contex-menu.component.less';

export class ContextMenuComponent extends Component {

    static propTypes = {
        destroyTooltipOnHide: PropTypes.bool,
        dismissOnClick: PropTypes.bool,
        handler: PropTypes.func,
        iconClassName: PropTypes.string,
        isDisabled: PropTypes.bool,
        isVisible: PropTypes.bool,
        label: PropTypes.string,
        menuName: PropTypes.string,
        menuOptions: PropTypes.arrayOf(PropTypes.shape({
            menuWrapperClassName: PropTypes.any,
        })),
        menuWrapperClassName: PropTypes.string,
        onVisibilityChanged: PropTypes.func
    };

    static defaultProps = {
        destroyTooltipOnHide: false,
        dismissOnClick: false,
        menuName: '',
        menuOptions: [],
        menuWrapperClassName: ''
    };

    constructor(props) {
        super(props);
        this.state = {
            visible: false,
        };
    }

    renderMenuContent = (menuOptions) => menuOptions.map((item, index) =>
        (isUndefined(item.isVisible) || !!item.isVisible) ?
            !!item.isDisabled ?
                <a className='link-disabled' key={`menu-item-${index}`}>{this.renderLabel(item)}</a> :
                <a key={`menu-item-${index}`}
                   onClick={(...args) => this.onItemClick(item, args)}>{this.renderLabel(item)}</a>
            : false);

    onItemClick(item, args) {
        if (this.props.dismissOnClick) {
            this.setState({visible: false});
        }
        item.handler(...args);
    }

    onVisibleChange = visible => {
        const {onVisibilityChanged} = this.props;
        this.setState({visible});
        if (onVisibilityChanged) {
            onVisibilityChanged(visible);
        }
    };

    renderLabel = (item) => {
        if (isUndefined(item.iconClassName)) {
            return item.label;
        } else {
            return (
                <div className='centered'>
                    <i className={item.iconClassName}/>
                    {item.label}
                </div>
            );
        }
    }

    renderMenu = (destroyTooltipOnHide, stageMenuOptions, menuWrapperClassName, menuName) =>
        <span className={menuWrapperClassName}>
            <Popover
                arrowPointAtCenter
                content={this.renderMenuContent(stageMenuOptions)}
                destroyTooltipOnHide={destroyTooltipOnHide}
                onVisibleChange={this.onVisibleChange}
                overlayClassName='context-menu-popover'
                placement='bottomRight'
                trigger='click'
                visible={this.state.visible}>
                <i className='xl-icon options-icon icon-l context-menu-btn' data-cy={'popup-' + menuName}/>
            </Popover>
        </span>

    render() {
        const {destroyTooltipOnHide, menuName, menuOptions, menuWrapperClassName} = this.props;
        return this.renderMenu(destroyTooltipOnHide, menuOptions, menuWrapperClassName, menuName);
    }

}
