import {useReducer} from 'react';
import isFunction from 'lodash/isFunction';


export function useReducerWithThunk(reducer, initialState) {
    const [state, dispatch] = useReducer(reducer, initialState);

    const customDispatch = (action) => {
        if (isFunction(action)) {
            action(customDispatch);
        } else {
            dispatch(action);
        }
    };
    return [state, customDispatch];
}
