(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[4],{

/***/ 0:
/***/ (function(module, exports) {

module.exports = React;

/***/ }),

/***/ 107:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ReleaseStatusFactory; });
function ReleaseStatusFactory() {
  return {
    isReleaseCompleted: function isReleaseCompleted(release) {
      return release && (release.status === 'COMPLETED' || release.status === 'ABORTED');
    },
    isReleaseAborted: function isReleaseAborted(release) {
      return release && release.status === 'ABORTED';
    },
    isReleasePlanned: function isReleasePlanned(release) {
      return release && release.status === 'PLANNED';
    },
    isReleaseInProgress: function isReleaseInProgress(release) {
      return release && release.status === 'IN_PROGRESS';
    },
    isReleaseFailed: function isReleaseFailed(release) {
      return release && release.status === 'FAILED';
    },
    isReleaseFailing: function isReleaseFailing(release) {
      return release && release.status === 'FAILING';
    },
    isReleasePaused: function isReleasePaused(release) {
      return release && release.status === 'PAUSED';
    },
    hasCompletedStatus: function hasCompletedStatus(release) {
      return release && release.status === 'COMPLETED';
    },
    isTemplate: function isTemplate(release) {
      return release && release.status === 'TEMPLATE';
    },
    isReleaseArchived: function isReleaseArchived(release) {
      return release && release.archived;
    },
    isReleaseActive: function isReleaseActive(release) {
      return release && (release.status === 'IN_PROGRESS' || release.status === "FAILED" || release.status === "FAILING" || release.status === "PAUSED");
    }
  };
}

/***/ }),

/***/ 109:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchDeliveries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return getDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteDelivery; });
/* unused harmony export createDelivery */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createDeliveryFromPattern; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return updateDelivery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isDeliveryUpdatable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return getTrackedItemApprovals; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(131);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var RELEASE_DELIVERY_API = 'api/v1/deliveries';
var RELEASE_DELIVERY_PATTERN_API = 'api/v1/delivery-patterns';
var RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API = 'activity';

function reduceFilters(filters) {
  var keys = _.keys(filters);

  return _.reduce(keys, function (reduced, key) {
    if (_.has(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"], key)) {
      filters[key] && reduced.statuses.push(_constants__WEBPACK_IMPORTED_MODULE_2__[/* RELEASE_STATUS_FILTER_KEY_TO_STATUS */ "c"][key]);
    } else {
      reduced[key] = filters[key];
    }

    return reduced;
  }, {
    statuses: []
  });
}

function fetchDeliveries(data, pageNumber) {
  var itemsPerPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "b"];
  var params = {
    resultsPerPage: itemsPerPage,
    page: pageNumber,
    orderBy: (data.orderBy || _constants__WEBPACK_IMPORTED_MODULE_2__[/* DEFAULT_ORDER_BY */ "a"]).toUpperCase()
  };
  var url = "".concat(RELEASE_DELIVERY_API, "/search?") + $.param(params);
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])(url, _objectSpread({}, reduceFilters(data)));
}
var getDelivery = function getDelivery(deliveryId) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId), hideAlert);
};
var deleteDelivery = function deleteDelivery(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpDELETE */ "b"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId));
};
var createDelivery = function createDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])(RELEASE_DELIVERY_API, delivery);
};
var createDeliveryFromPattern = function createDeliveryFromPattern(patternId, delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])("".concat(RELEASE_DELIVERY_PATTERN_API, "/").concat(patternId, "/create"), delivery);
};
var updateDelivery = function updateDelivery(delivery) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPUT */ "g"])("".concat(RELEASE_DELIVERY_API, "/").concat(delivery.id), delivery);
};
var isDeliveryUpdatable = function isDeliveryUpdatable(delivery) {
  return delivery && delivery.status !== 'COMPLETED';
};
var getTrackedItemApprovals = function getTrackedItemApprovals(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_ACTIVITY_LOGS_INTERNAL_API, "/").concat(deliveryId, "/approvals"));
};

/***/ }),

/***/ 117:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return fetchReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return fetchRisks; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return startReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return abortReleases; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return fetchReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return fetchArchivedReleaseTags; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return fetchCount; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_services_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var fetchReleases = function fetchReleases(filters, pageNumber) {
  var url = "releases/search?depth=3&numberbypage=".concat(_constants__WEBPACK_IMPORTED_MODULE_2__[/* ITEMS_PER_PAGE */ "c"], "&page=").concat(pageNumber, "&filter=").concat(filters.filter) + '&properties=riskScore&extensions=progress';
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('POST', url, {
    data: filters
  });
};
var fetchRisks = function fetchRisks(releaseId) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('GET', "api/v1/risks/".concat(releaseId, "/Risk"));
};
var startReleases = function startReleases(releasesIds) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('POST', "releases/start", {
    data: releasesIds
  });
};
var abortReleases = function abortReleases(releasesIds, abortComment) {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpRequest */ "h"])('POST', "releases/abort", {
    data: {
      releasesIds: releasesIds,
      abortComment: abortComment
    }
  });
};
var fetchReleaseTags = function fetchReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags');
};
var fetchArchivedReleaseTags = function fetchArchivedReleaseTags() {
  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpGET */ "c"])('releases/tags/archived');
};
var fetchCount = function fetchCount(filters) {
  if (filters.onlyArchived) {
    filters.planned = false;
    filters.inProgress = false;
    filters.failing = false;
    filters.failed = false;
    filters.paused = false;
  }

  return Object(_common_services_http__WEBPACK_IMPORTED_MODULE_1__[/* httpPOST */ "e"])('releases/count', _objectSpread(_objectSpread({}, filters), {}, {
    onlyArchived: false
  }));
};

/***/ }),

/***/ 120:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return loadEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return updateEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return searchEnvironments; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return getDeployableApplicationsForEnvironment; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var createEnvironment = function createEnvironment(environment) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/environments', environment);
};
var loadEnvironment = function loadEnvironment(environmentId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/".concat(environmentId)).then(function (response) {
    return response.data;
  });
};
var updateEnvironment = function updateEnvironment(environmentId, environment) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "g"])("api/v1/environments/".concat(environmentId), environment);
};
var searchEnvironments = function searchEnvironments(_ref) {
  var title = _ref.title,
      stage = _ref.stage;
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/environments/search', {
    title: title,
    stage: stage
  }).then(function (response) {
    return response.data;
  });
};
var deleteEnvironment = function deleteEnvironment(environmentId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/environments/".concat(environmentId));
};
var getDeployableApplicationsForEnvironment = function getDeployableApplicationsForEnvironment(environmentId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/".concat(environmentId, "/applications")).then(function (response) {
    return response.data;
  });
};

/***/ }),

/***/ 123:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export parseDateTimeFormat */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return formatDateTime; });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(129);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);


function parseDateTimeFormat(date, dateFormat, timeFormat) {
  var format = "".concat(dateFormat, " ").concat(timeFormat);

  if (_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsDateFormatToMomentFormat */ "a"][dateFormat]) {
    format = "".concat(_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsDateFormatToMomentFormat */ "a"][dateFormat]);

    if (_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsTimeFormatToMomentFormat */ "b"][timeFormat]) {
      format = "".concat(format, " ").concat(_constants__WEBPACK_IMPORTED_MODULE_0__[/* angularJsTimeFormatToMomentFormat */ "b"][timeFormat]);
    } else {
      format = "".concat(format, " ").concat(timeFormat);
    }
  } else {
    // can't find an appropriate format, use default
    format = "YYYY-MM-DD h:mm A";
  }

  return format;
}
function formatDateTime(date, dateFormat, timeFormat) {
  return moment__WEBPACK_IMPORTED_MODULE_1___default()(date).format(parseDateTimeFormat(date, dateFormat, timeFormat));
}

/***/ }),

/***/ 127:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ widget_datetime_WidgetDateTime; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/lodash/clone.js
var clone = __webpack_require__(135);
var clone_default = /*#__PURE__*/__webpack_require__.n(clone);

// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(14);

// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(22);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/widgets/datetime/widget-datetime.less
var widget_datetime = __webpack_require__(300);
var widget_datetime_default = /*#__PURE__*/__webpack_require__.n(widget_datetime);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/widgets/datetime/widget-datetime.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(widget_datetime_default.a, options);



/* harmony default export */ var datetime_widget_datetime = (widget_datetime_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/widgets/datetime/widget-datetime.js








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var widget_datetime_WidgetDateTime = /*#__PURE__*/function (_Component) {
  inherits_default()(WidgetDateTime, _Component);

  var _super = _createSuper(WidgetDateTime);

  function WidgetDateTime(props) {
    var _this;

    classCallCheck_default()(this, WidgetDateTime);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDateChange", function (selectedDate) {
      var _this$props = _this.props,
          model = _this$props.model,
          onModelChange = _this$props.onModelChange;
      var startDate = clone_default()(model);
      startDate.setFullYear(selectedDate.getFullYear(), selectedDate.getMonth(), selectedDate.getDate());

      if (!moment_js_exposed_default()(startDate).isSame(moment_js_exposed_default()(model))) {
        onModelChange(startDate);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartTimeChange", function (selectedDate) {
      var _this$props2 = _this.props,
          model = _this$props2.model,
          onModelChange = _this$props2.onModelChange;
      var startDate = clone_default()(model);
      startDate.setHours(selectedDate.getHours(), selectedDate.getMinutes());

      if (!moment_js_exposed_default()(startDate).isSame(moment_js_exposed_default()(model))) {
        onModelChange(startDate);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDatePristine", function (pristine) {
      var onDatePristinityChange = _this.props.onDatePristinityChange;

      _this.setState({
        datePristine: pristine
      });

      onDatePristinityChange(pristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTimePristine", function (pristine) {
      var onTimePristinityChange = _this.props.onTimePristinityChange;

      _this.setState({
        timePristine: pristine
      });

      onTimePristinityChange(pristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTimeValidityChange", function (valid) {
      var onValidityChange = _this.props.onValidityChange;
      _this.isTimeValid = valid;
      onValidityChange(_this.isFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDateValidityChange", function (valid) {
      var onValidityChange = _this.props.onValidityChange;
      _this.isDateValid = valid;
      onValidityChange(_this.isFormValid);
    });

    _this.state = {
      datePristine: true,
      timePristine: true
    };
    _this.isDateValid = false;
    _this.isTimeValid = false;
    return _this;
  }

  createClass_default()(WidgetDateTime, [{
    key: "isFormValid",
    get: function get() {
      return this.isDateValid && this.isTimeValid;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          disabled = _this$props3.disabled,
          metadata = _this$props3.metadata,
          minDate = _this$props3.minDate,
          model = _this$props3.model;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components widget-datetime"
      }, metadata.label && /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: metadata
      }), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "date-time-wrapper"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "date-time-input"
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetDate"], {
        dateFormat: metadata.dateFormat,
        disabled: disabled,
        minDate: minDate,
        model: model,
        onModelChange: this.onStartDateChange,
        onPristinityChange: this.onDatePristine,
        onValidityChange: this.onDateValidityChange
      }), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetTime"], {
        disabled: disabled,
        model: model,
        onModelChange: this.onStartTimeChange,
        onPristinityChange: this.onTimePristine,
        onValidityChange: this.onTimeValidityChange
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components-description"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, metadata.description))));
    }
  }]);

  return WidgetDateTime;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/widgets/index.js


/***/ }),

/***/ 129:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return angularJsDateFormatToMomentFormat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return angularJsTimeFormatToMomentFormat; });
var angularJsDateFormatToMomentFormat = {
  'd/M/yy': 'D/M/YY',
  'M/d/yy': 'M/D/YY',
  'dd/MM/yy': 'DD/MM/YY',
  'yy/MM/dd': 'YY/MM/DD',
  'MMM d, y': 'MMM DD, YYYY',
  'dd MMM y': 'DD MMM YYYY',
  'y MMM dd': 'YYYY MMM DD',
  'y MMMM dd EEEE': 'YYYY MMMM DD dddd',
  'EEEE dd MMMM y': 'dddd DD MMMM YYYY',
  'EEEE, MMMM d, y': 'dddd, MMMM, D, YYYY'
};
var angularJsTimeFormatToMomentFormat = {
  'HH:mm': 'HH:mm',
  'h:mm a': 'h:mm A'
};

/***/ }),

/***/ 131:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ITEMS_PER_PAGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DEFAULT_ORDER_BY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return RELEASE_STATUS_FILTER_KEY_TO_STATUS; });
/* unused harmony export ENTITY_ID_PLACEHOLDER */
var ITEMS_PER_PAGE = 15;
var DEFAULT_ORDER_BY = 'start_date';
var RELEASE_STATUS_FILTER_KEY_TO_STATUS = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED'
};
var ENTITY_ID_PLACEHOLDER = -1;

/***/ }),

/***/ 143:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createStage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return searchStages; });
/* unused harmony export getStage */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return updateStage; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteStage; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var createStage = function createStage(stage) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/environments/stages', stage);
};
var searchStages = function searchStages(title) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/environments/stages/search', {
    title: title
  }).then(function (response) {
    return response.data;
  });
};
var getStage = function getStage(stageId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/stages/".concat(stageId)).then(function (response) {
    return response.data;
  });
};
var updateStage = function updateStage(stageId, stage) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "g"])("api/v1/environments/stages/".concat(stageId), stage);
};
var deleteStage = function deleteStage(stageId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/environments/stages/".concat(stageId));
};

/***/ }),

/***/ 156:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return searchApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return getApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return updateApp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteApp; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var searchApp = function searchApp(title) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/applications/search', {
    title: title
  }).then(function (resp) {
    return resp.data;
  });
};
var createApp = function createApp(application) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/applications', application).then(function (response) {
    return response.data;
  });
};
var getApp = function getApp(applicationId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/applications/".concat(applicationId)).then(function (response) {
    return response.data;
  });
};
var updateApp = function updateApp(application) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "g"])("api/v1/applications/".concat(application.id), application);
};
var deleteApp = function deleteApp(applicationId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/applications/".concat(applicationId));
};

/***/ }),

/***/ 16:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return registerRequestInterceptor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return registerResponseInterceptors; });
/* unused harmony export directHttpRequest */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return httpRequest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return httpCodes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return httpGET; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return httpPOST; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return httpPUT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return httpDELETE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return httpPOSTBlob; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return httpGETBlob; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(516);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_http_backend__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(271);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var instance = axios__WEBPACK_IMPORTED_MODULE_1___default.a.create();
var registerRequestInterceptor = function registerRequestInterceptor(requestInterceptor) {
  instance.interceptors.request.use(requestInterceptor, function (error) {
    return error;
  });
};
var registerResponseInterceptors = function registerResponseInterceptors(successInterceptor, errorInterceptor) {
  instance.interceptors.response.use(successInterceptor, errorInterceptor);
};
var directHttpRequest = function directHttpRequest(method, url, config, headers) {
  var requestObject = _objectSpread(_objectSpread({}, config), {}, {
    headers: headers,
    method: method,
    url: url
  });

  return instance.request(requestObject);
};
var httpRequest = function httpRequest(method, url) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var accept = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'application/json';
  return directHttpRequest(method, "".concat(url), config, {
    'Accept': accept,
    'Accept-Type': accept,
    'X-HTTP-Auth-Override': 'true'
  });
};
var httpCodes = {
  UNAUTHORIZED: 401,
  PAYMENT_REQUIRED: 402,
  FORBIDDEN: 403,
  VERSION_CHANGED: 410
};
function httpGET(url) {
  var hideAlert = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var dontRedirectWhenForbidden = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('GET', url, {
    dontRedirectWhenForbidden: dontRedirectWhenForbidden,
    hideAlert: hideAlert
  });
}
function httpPOST(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('POST', url, {
    data: data,
    hideAlert: hideAlert
  });
}
function httpPUT(url, data) {
  return httpRequest('PUT', url, {
    data: data
  });
}
function httpDELETE(url, data) {
  return httpRequest('DELETE', url, {
    data: data
  });
}
function httpPOSTBlob(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('POST', url, {
    data: data,
    hideAlert: hideAlert,
    responseType: 'blob'
  }, '*/*');
}
function httpGETBlob(url, data) {
  var hideAlert = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return httpRequest('GET', url, {
    data: data,
    hideAlert: hideAlert,
    responseType: 'blob'
  }, '*/*');
}

/***/ }),

/***/ 166:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ calculatePercentage; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ release_progress_component_ReleaseProgressComponent; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.less
var release_progress_component = __webpack_require__(288);
var release_progress_component_default = /*#__PURE__*/__webpack_require__.n(release_progress_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(release_progress_component_default.a, options);



/* harmony default export */ var release_progress_release_progress_component = (release_progress_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.js






function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }




var calculatePercentage = function calculatePercentage(progress) {
  var totalTasks = progress.totalTasks;
  var totalRemainingTasks = progress.totalRemainingTasks;
  var tasksFinished = totalTasks - totalRemainingTasks;
  return tasksFinished === 0 ? 0 : Math.round(tasksFinished * 100 / totalTasks);
};
var release_progress_component_ReleaseProgressComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseProgressComponent, _Component);

  var _super = _createSuper(ReleaseProgressComponent);

  function ReleaseProgressComponent() {
    classCallCheck_default()(this, ReleaseProgressComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseProgressComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          completedPercentage = _this$props.completedPercentage,
          progress = _this$props.progress;
      var percentage = 0;

      if (completedPercentage) {
        percentage = completedPercentage;
      } else if (progress) {
        percentage = calculatePercentage(progress);
      }

      var barWidthStyle = {
        width: percentage + '%'
      };
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-progress-bar-view"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "percent-number"
      }, percentage, "% Completed"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "progress-bar-container"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "progress-bar-line",
        style: barWidthStyle
      })));
    }
  }]);

  return ReleaseProgressComponent;
}(external_React_["Component"]);

/***/ }),

/***/ 167:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return XLRelease; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);



var XLRelease = function XLRelease() {
  _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, XLRelease);
};

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(XLRelease, "version", '10.2.6');



/***/ }),

/***/ 170:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return TIME_FRAME_TYPES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TIME_FRAME_LABELS; });
var TIME_FRAME_TYPES = {
  LAST_MONTH: 'LAST_MONTH',
  LAST_THREE_MONTHS: 'LAST_THREE_MONTHS',
  LAST_SIX_MONTHS: 'LAST_SIX_MONTHS',
  LAST_YEAR: 'LAST_YEAR',
  RANGE: 'RANGE'
};
var TIME_FRAME_LABELS = {
  LAST_MONTH: 'Last 30 days',
  LAST_THREE_MONTHS: 'Last 3 months',
  LAST_SIX_MONTHS: 'Last 6 months',
  LAST_YEAR: 'Last year',
  RANGE: 'Range'
};

/***/ }),

/***/ 171:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return lazyInjector; });
/**
 * Angular2react needs an $injector, but it doesn't actually invoke $injector.get
 * until we invoke ReactDOM.render. We can take advantage of this to provide the
 * "lazy" injector below to React components created with angular2react, as a way
 * to avoid component ordering issues.
 *
 * @see https://github.com/coatue-oss/angular2react/issues/12
 */
// state
var $injector;
var lazyInjector = {
  get $injector() {
    return {
      get get() {
        return $injector.get;
      }

    };
  },

  set $injector(_$injector) {
    $injector = _$injector;
  }

};

/***/ }),

/***/ 187:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DownloadHelper; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);


var fileNameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
var DownloadHelper = function DownloadHelper() {
  _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, DownloadHelper);
};

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(DownloadHelper, "getNameFromContentDisposition", function (contentDisposition) {
  if (contentDisposition !== null) {
    var matches = fileNameRegex.exec(contentDisposition);

    if (matches !== null && matches[1]) {
      return matches[1].replace(/['"]/g, '');
    }
  }

  return 'unnamed';
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(DownloadHelper, "click", function (link) {
  var eventType = 'click';

  try {
    var event = link.ownerDocument.defaultView.createEvent('MouseEvents');

    if (event.initMouseEvent) {
      event.initMouseEvent(eventType, true, true, link.ownerDocument.defaultView, 0, 1, 1, 1, 1, false, false, false, false, 0, null);
      link.dispatchEvent(event);
      return;
    } else if (event.initEvent) {
      event.initEvent(eventType, true, true);
      link.dispatchEvent(event);
      return;
    }
  } catch (e) {//
  }

  try {
    var _event = new link.ownerDocument.defaultView.MouseEvent(eventType, {
      bubbles: true,
      cancelable: true,
      view: link.ownerDocument.defaultView
    });

    link.dispatchEvent(_event);
    return;
  } catch (e) {//
  }

  try {
    link.click();
  } catch (e) {//
  }
});

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(DownloadHelper, "download", function (result) {
  var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : result.data;
  var fileName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  if (window.navigator.msSaveOrOpenBlob) {
    var contentDisposition = angular.isObject(result.headers) ? result.headers['content-disposition'] : result.headers('content-disposition');
    window.navigator.msSaveOrOpenBlob(data, DownloadHelper.getNameFromContentDisposition(contentDisposition));
  } else {
    var link = document.createElement('a');
    link.href = window.URL.createObjectURL(data);

    if (!!fileName) {
      link.download = fileName;
    } else {
      if (result.headers['content-disposition']) {
        link.download = DownloadHelper.getNameFromContentDisposition(result.headers['content-disposition']);
      } else {
        link.download = DownloadHelper.getNameFromContentDisposition(result.headers('content-disposition'));
      }
    }

    DownloadHelper.click(link);
    window.URL.revokeObjectURL(link.href);

    try {
      document.removeChild(link);
    } catch (e) {//
    }
  }
});

/***/ }),

/***/ 196:
/***/ (function(module, exports) {

module.exports = jQuery;

/***/ }),

/***/ 207:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ no_data_NoData; });

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/no-data/no-data.less
var no_data = __webpack_require__(282);
var no_data_default = /*#__PURE__*/__webpack_require__.n(no_data);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(no_data_default.a, options);



/* harmony default export */ var no_data_no_data = (no_data_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.js



var no_data_NoData = function NoData(_ref) {
  var className = _ref.className,
      message = _ref.message;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: 'no-data-message' + (className ? " ".concat(className) : '')
  }, message);
};

/***/ }),

/***/ 21:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return primaryColors; });
/* unused harmony export rgbToHexString */
/* unused harmony export hexToRgb */
/* unused harmony export hexToRgbString */
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var primaryColors = {
  blue: '#0079BC',
  green: '#498500',
  red: '#CC4A3C',
  orange: '#FFAB00',
  purple: '#991C71',
  yellow: '#FCD866'
};
/* harmony default export */ __webpack_exports__["a"] = (_objectSpread(_objectSpread({}, primaryColors), {}, {
  // SECONDARY COLORS
  xldblue: '#14B0E4',
  lightblue: '#5FCBF4',
  darkblue: '#4C6C87',
  // SHADES OF GRAY
  black: '#414C58',
  antracite: '#495561',
  gray: '#65747C',
  lightgray: '#ADB9C3',
  background: '#F3F5F8',
  silver: '#F8F9FA',
  white: '#FFFFFF',
  // Semantic COLORS
  oddRowColor: '#FFFFFF',
  evenRowColor: '#F8F9FA',
  hoverColor: '#F3F5F8',
  selectedColor: '#E3E8Ef',
  highlightColor: '#CDEFDC',
  successBackground: '#E6F3EE',
  successHover: '#F6D2CE',
  warningBackground: '#FFF6E9',
  warningHover: '#FFE2C3',
  errorBackground: '#F7E4E2',
  errorHover: '#C1EBD4'
}));
function rgbToHexString(r, g, b) {
  return '#' + ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
}
function hexToRgb(hex) {
  // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
  var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
  hex = hex.replace(shorthandRegex, function (m, r, g, b) {
    return r + r + g + g + b + b;
  });
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result ? {
    r: parseInt(result[1], 16),
    g: parseInt(result[2], 16),
    b: parseInt(result[3], 16)
  } : null;
}
function hexToRgbString(hex) {
  var rgbObject = hexToRgb(hex);
  return "rgb(".concat(rgbObject.r, ", ").concat(rgbObject.g, ", ").concat(rgbObject.b, ")");
}

/***/ }),

/***/ 210:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return showError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return showServerDownError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AlertsFactory; });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(40);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97);
/* harmony import */ var lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isFunction__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(55);
/* harmony import */ var pluralize__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(pluralize__WEBPACK_IMPORTED_MODULE_3__);





function getResponseData(response) {
  var contentType = getHeader(response, 'content-type');

  if (contentType && !contentType.includes('text/html')) {
    if (response.data instanceof Blob) {
      return 'Requested file is not found';
    }

    if (getHeader(response, 'x-validation-exception', "false") === "true") {
      return extractValidationMessages(response);
    }

    return response.data;
  }

  return '';
}

function extractValidationMessages(response) {
  var validationMessages = response.data["validation-messages"];
  var messages = validationMessages.map(function (item) {
    return "<p>".concat(item.message, "</p>");
  });
  return "There ".concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('was', validationMessages.length), " ").concat(validationMessages.length, " validation ").concat(pluralize__WEBPACK_IMPORTED_MODULE_3___default()('error', validationMessages.length), ". ").concat(messages.join(""));
}

function getHeader(response, headerName) {
  var defaultVal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

  //we need this logic because we are still using different approaches to call a server
  if (lodash_isFunction__WEBPACK_IMPORTED_MODULE_1___default()(response.headers)) {
    //this is true for calls from $http
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers(), headerName, defaultVal);
  } else {
    return lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(response.headers, headerName, defaultVal); //this is true for calls from axios
  }
}

function getAlertMsg(response) {
  var responseData = _.escape(getResponseData(response));

  var path = _.escape(getHeader(response, 'x-path', response.config.url));

  var date = _.escape(getHeader(response, 'date'));

  return "\n        <div class='alert-details'>\n            <p>".concat(responseData, "</p>\n            <p>Status code: ").concat(response.status, "</p>\n            <p><strong>").concat(response.config.method, " ").concat(path, "</strong></p>\n            <p>").concat(date, "</p>\n        </div>").split('\n').join('');
}

var toaster = Object(_js_util_toastrFactory__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])();
function showError(response) {
  if (response.status === 409) {
    toaster.conflict(getAlertMsg(response), {
      escapeHtml: false
    });
  } else {
    toaster.error(getAlertMsg(response), 'An error occurred', {
      escapeHtml: false
    });
  }
}
function showServerDownError() {
  toaster.error('The Release server is not available', 'An error occurred');
}
function AlertsFactory() {
  return {
    error: showError,
    serverDownError: showServerDownError
  };
}

/***/ }),

/***/ 211:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return createLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return searchLabels; });
/* unused harmony export getLabel */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return updateLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return deleteLabel; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var createLabel = function createLabel(envLabel) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/environments/labels', envLabel);
};
var searchLabels = function searchLabels(title) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPOST */ "e"])('api/v1/environments/labels/search', {
    title: title
  }).then(function (response) {
    return response.data;
  });
};
var getLabel = function getLabel(envLabelId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("api/v1/environments/labels/".concat(envLabelId)).then(function (response) {
    return response.data;
  });
};
var updateLabel = function updateLabel(envLabelId, envLabel) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpPUT */ "g"])("api/v1/environments/labels/".concat(envLabelId), envLabel);
};
var deleteLabel = function deleteLabel(envLabelId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpDELETE */ "b"])("api/v1/environments/labels/".concat(envLabelId));
};

/***/ }),

/***/ 236:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return fetchTimeline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return fetchDelivery; });
/* harmony import */ var _core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

var RELEASE_DELIVERY_API = 'api/v1/deliveries';
var fetchTimeline = function fetchTimeline(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId, "/timeline"));
};
var fetchDelivery = function fetchDelivery(deliveryId) {
  return Object(_core_xlr_ui_app_features_common_services_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])("".concat(RELEASE_DELIVERY_API, "/").concat(deliveryId));
};

/***/ }),

/***/ 24:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ alert_message_AlertMessage; });
__webpack_require__.d(__webpack_exports__, "z", function() { return /* reexport */ alert_message_alertType; });
__webpack_require__.d(__webpack_exports__, "x", function() { return /* reexport */ delete_component_XlrDeleteButton; });
__webpack_require__.d(__webpack_exports__, "j", function() { return /* reexport */ help_block_HelpBlock; });
__webpack_require__.d(__webpack_exports__, "k", function() { return /* reexport */ no_data["a" /* NoData */]; });
__webpack_require__.d(__webpack_exports__, "m", function() { return /* reexport */ popup_Popup; });
__webpack_require__.d(__webpack_exports__, "p", function() { return /* reexport */ release_list_component_ReleaseListComponent; });
__webpack_require__.d(__webpack_exports__, "s", function() { return /* reexport */ release_status_component_ReleaseStatusComponent; });
__webpack_require__.d(__webpack_exports__, "l", function() { return /* reexport */ release_list_const["a" /* OrderConst */]; });
__webpack_require__.d(__webpack_exports__, "o", function() { return /* reexport */ ReleaseFlagComponent; });
__webpack_require__.d(__webpack_exports__, "r", function() { return /* reexport */ ReleaseRiskStatusIconComponent_ReleaseRiskStatusIconComponent; });
__webpack_require__.d(__webpack_exports__, "h", function() { return /* reexport */ inline_edit_EditableLabel; });
__webpack_require__.d(__webpack_exports__, "n", function() { return /* reexport */ release_count_component_ReleaseCountComponent; });
__webpack_require__.d(__webpack_exports__, "c", function() { return /* reexport */ button_with_popover_component_ButtonWithPopoverComponent; });
__webpack_require__.d(__webpack_exports__, "e", function() { return /* reexport */ context_menu_component_ContextMenuComponent; });
__webpack_require__.d(__webpack_exports__, "g", function() { return /* reexport */ doc_link_component["a" /* DocLinkComponent */]; });
__webpack_require__.d(__webpack_exports__, "t", function() { return /* reexport */ select_tree_component_SelectTreeComponent; });
__webpack_require__.d(__webpack_exports__, "y", function() { return /* reexport */ xlr_members_tags_component_XlrMembersTags; });
__webpack_require__.d(__webpack_exports__, "q", function() { return /* reexport */ release_progress_component["a" /* ReleaseProgressComponent */]; });
__webpack_require__.d(__webpack_exports__, "f", function() { return /* reexport */ display_variable_component_DisplayVariable; });
__webpack_require__.d(__webpack_exports__, "u", function() { return /* reexport */ TextAreaPassword_TextAreaPassword; });
__webpack_require__.d(__webpack_exports__, "v", function() { return /* reexport */ TextAreaPasswordEditMode_TextAreaPasswordEditMode; });
__webpack_require__.d(__webpack_exports__, "i", function() { return /* reexport */ folder_header_component_FolderHeader; });
__webpack_require__.d(__webpack_exports__, "d", function() { return /* reexport */ confirmation_dialog_component_ConfirmationDialog; });
__webpack_require__.d(__webpack_exports__, "w", function() { return /* reexport */ toggle_component_ToggleComponent; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* reexport */ avatar_component_AvatarComponent; });

// UNUSED EXPORTS: ReleaseCountResults, InfiniteListComponent, XlrTags, FolderDetails

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/alert-message/alert-message.js








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }



var alert_message_alertType = {
  INFO: 'info',
  WARNING: 'warning'
};
var alert_message_AlertMessage = /*#__PURE__*/function (_PureComponent) {
  inherits_default()(AlertMessage, _PureComponent);

  var _super = _createSuper(AlertMessage);

  function AlertMessage() {
    var _this;

    classCallCheck_default()(this, AlertMessage);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "alertIconsClasses", {
      'info': 'info-icon',
      'warning': 'warning-icon'
    });

    return _this;
  }

  createClass_default()(AlertMessage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          alertType = _this$props.alertType;
      var alertClass = "xlr-alert-".concat(alertType);
      var iconClass = "xl-icon ".concat(this.alertIconsClasses[alertType], " icon-l");
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: alertClass
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "icon"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: iconClass
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "message"
      }, children));
    }
  }]);

  return AlertMessage;
}(external_React_["PureComponent"]);
// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(14);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/constants/key-codes.js
var key_codes = __webpack_require__(43);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/delete/delete.component.js








function delete_component_createSuper(Derived) { var hasNativeReflectConstruct = delete_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delete_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var delete_component_XlrDeleteButton = /*#__PURE__*/function (_Component) {
  inherits_default()(XlrDeleteButton, _Component);

  var _super = delete_component_createSuper(XlrDeleteButton);

  function XlrDeleteButton(props) {
    var _this;

    classCallCheck_default()(this, XlrDeleteButton);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "delete", function (action) {
      var item = _this.props.item;

      if (action === deleteButton.action) {
        _this.props.onDelete(item);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function () {
      return _this.setState({
        deleteModalIsOpen: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      if (e.key === 'Enter') {
        _this.showDeleteModal();
      }
    });

    _this.state = {
      deleteModalIsOpen: false
    };
    return _this;
  }

  createClass_default()(XlrDeleteButton, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          modalHeader = _this$props.modalHeader,
          renderModalBodyFn = _this$props.renderModalBodyFn;
      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var title = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, modalHeader);
      return /*#__PURE__*/external_React_default.a.createElement("span", null, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link delete",
        onClick: this.showDeleteModal,
        onKeyDown: this._handleKeyDown
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, deleteButton.label)), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delete_component_cancelButton, deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.delete,
        show: deleteModalIsOpen,
        title: title
      }, renderModalBodyFn()));
    }
  }]);

  return XlrDeleteButton;
}(external_React_["Component"]);
var deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [key_codes["a" /* keyCodes */].ENTER, key_codes["a" /* keyCodes */].DELETE],
  label: 'Delete'
};
var delete_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [key_codes["a" /* keyCodes */].ESC],
  label: 'Cancel'
};
// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/help-block/help-block.less
var help_block = __webpack_require__(281);
var help_block_default = /*#__PURE__*/__webpack_require__.n(help_block);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/help-block/help-block.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(help_block_default.a, options);



/* harmony default export */ var help_block_help_block = (help_block_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/help-block/help-block.js



var help_block_HelpBlock = function HelpBlock(_ref) {
  var className = _ref.className,
      children = _ref.children;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "help-block-component ".concat(className)
  }, children);
};
help_block_HelpBlock.defaultProps = {
  className: ''
};
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.js + 1 modules
var no_data = __webpack_require__(207);

// EXTERNAL MODULE: external "ReactDOM"
var external_ReactDOM_ = __webpack_require__(31);
var external_ReactDOM_default = /*#__PURE__*/__webpack_require__.n(external_ReactDOM_);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/click-outside.decorator.js







function click_outside_decorator_createSuper(Derived) { var hasNativeReflectConstruct = click_outside_decorator_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function click_outside_decorator_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/* global document */




function clickOutside() {
  return function (WrappedComponent) {
    return /*#__PURE__*/function (_Component) {
      inherits_default()(WithClickOutside, _Component);

      var _super = click_outside_decorator_createSuper(WithClickOutside);

      function WithClickOutside(props) {
        var _this;

        classCallCheck_default()(this, WithClickOutside);

        _this = _super.call(this, props);
        _this.mounted = true;
        _this.handleDocumentClick = _this.handleDocumentClick.bind(assertThisInitialized_default()(_this));
        return _this;
      }

      createClass_default()(WithClickOutside, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          document.addEventListener('click', this.handleDocumentClick, false);
          document.addEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          this.mounted = false;
          document.removeEventListener('click', this.handleDocumentClick, false);
          document.removeEventListener('touchend', this.handleDocumentClick, false);
        }
      }, {
        key: "handleDocumentClick",
        value: function handleDocumentClick(event) {
          if (this.mounted && this.props.enable) {
            /* eslint-disable react/no-find-dom-node */
            if (!external_ReactDOM_default.a.findDOMNode(this).contains(event.target)) {
              if (this.props.onClickOutside) {
                this.props.onClickOutside();
              }
            }
          }
        }
      }, {
        key: "render",
        value: function render() {
          return /*#__PURE__*/external_React_default.a.createElement(WrappedComponent, this.props);
        }
      }], [{
        key: "propTypes",
        get: function get() {
          return {
            enable: prop_types_default.a.bool,
            onClickOutside: prop_types_default.a.func.isRequired
          };
        }
      }, {
        key: "defaultProps",
        get: function get() {
          return {
            enable: true
          };
        }
      }]);

      return WithClickOutside;
    }(external_React_["Component"]);
  };
}

/* harmony default export */ var click_outside_decorator = (clickOutside);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/popup/popup.less
var popup = __webpack_require__(283);
var popup_default = /*#__PURE__*/__webpack_require__.n(popup);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/popup.less

            

var popup_options = {};

popup_options.insert = "head";
popup_options.singleton = false;

var popup_update = injectStylesIntoStyleTag_default()(popup_default.a, popup_options);



/* harmony default export */ var popup_popup = (popup_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/popup-trigger.js




var popup_trigger_PopupTrigger = function PopupTrigger(props) {
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "popup__trigger"
  }, /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon options-icon remove-outline",
    onClick: props.onClick,
    role: "button",
    tabIndex: -1
  }), props.children);
};

/* harmony default export */ var popup_trigger = (popup_trigger_PopupTrigger);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/popup/popup.js








function popup_createSuper(Derived) { var hasNativeReflectConstruct = popup_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function popup_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var Trigger = click_outside_decorator()(popup_trigger);
var popup_Popup = /*#__PURE__*/function (_Component) {
  inherits_default()(Popup, _Component);

  var _super = popup_createSuper(Popup);

  function Popup(props) {
    var _this;

    classCallCheck_default()(this, Popup);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onClickOutside", function () {
      var onStateChange = _this.props.onStateChange;

      _this.setState({
        isOpen: false
      });

      if (onStateChange) {
        onStateChange(false);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "toggleDropdown", function (e) {
      e.stopPropagation();
      var onStateChange = _this.props.onStateChange;
      var state = !_this.state.isOpen;

      _this.setState({
        isOpen: state
      });

      if (onStateChange) {
        onStateChange(state);
      }
    });

    _this.state = {
      isOpen: false
    };
    return _this;
  }

  createClass_default()(Popup, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "popup__container ".concat(this.state.isOpen ? 'popup--expanded' : '')
      }, /*#__PURE__*/external_React_default.a.createElement(Trigger, {
        enable: this.state.isOpen,
        onClick: this.toggleDropdown,
        onClickOutside: this.onClickOutside
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "popup__content ".concat(this.state.isOpen ? 'popup__content--open' : ''),
        role: "presentation"
      }, this.props.children)));
    }
  }]);

  return Popup;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/release-list/const/index.js
var release_list_const = __webpack_require__(57);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/release-list-common.component.less
var release_list_common_component = __webpack_require__(284);
var release_list_common_component_default = /*#__PURE__*/__webpack_require__.n(release_list_common_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-list-common.component.less

            

var release_list_common_component_options = {};

release_list_common_component_options.insert = "head";
release_list_common_component_options.singleton = false;

var release_list_common_component_update = injectStylesIntoStyleTag_default()(release_list_common_component_default.a, release_list_common_component_options);



/* harmony default export */ var release_list_release_list_common_component = (release_list_common_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-header-label.component.js








function release_header_label_component_createSuper(Derived) { var hasNativeReflectConstruct = release_header_label_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_header_label_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var release_header_label_component_ReleaseHeaderLabelComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseHeaderLabelComponent, _Component);

  var _super = release_header_label_component_createSuper(ReleaseHeaderLabelComponent);

  function ReleaseHeaderLabelComponent() {
    var _this;

    classCallCheck_default()(this, ReleaseHeaderLabelComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "onOrderChange", function (column) {
      if (column.sortable) {
        _this.props.onOrderChange(column);
      }
    });

    return _this;
  }

  createClass_default()(ReleaseHeaderLabelComponent, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var header = this.props.header;
      var headerRow = header.map(function (column) {
        var className = column.sortable ? 'sortable' : '';
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "release-row-view-column ".concat(column.class, " ").concat(className),
          key: column.fieldName,
          onClick: function onClick() {
            return _this2.onOrderChange(column);
          }
        }, column.label, /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "order-icons"
        }, (column.order === release_list_const["a" /* OrderConst */].SORT_DESC || column.order === release_list_const["a" /* OrderConst */].SORT_NONE) && /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-s arrow-up-icon"
        }), (column.order === release_list_const["a" /* OrderConst */].SORT_ASC || column.order === release_list_const["a" /* OrderConst */].SORT_NONE) && /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-s arrow-down-icon"
        })));
      });
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-header-row-view"
      }, headerRow);
    }
  }]);

  return ReleaseHeaderLabelComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(22);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/display-duration/display-duration.component.less
var display_duration_component = __webpack_require__(285);
var display_duration_component_default = /*#__PURE__*/__webpack_require__.n(display_duration_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/display-duration/display-duration.component.less

            

var display_duration_component_options = {};

display_duration_component_options.insert = "head";
display_duration_component_options.singleton = false;

var display_duration_component_update = injectStylesIntoStyleTag_default()(display_duration_component_default.a, display_duration_component_options);



/* harmony default export */ var display_duration_display_duration_component = (display_duration_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/display-duration/display-duration.component.js






function display_duration_component_createSuper(Derived) { var hasNativeReflectConstruct = display_duration_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function display_duration_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var display_duration_component_DisplayDurationComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DisplayDurationComponent, _Component);

  var _super = display_duration_component_createSuper(DisplayDurationComponent);

  function DisplayDurationComponent() {
    classCallCheck_default()(this, DisplayDurationComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DisplayDurationComponent, [{
    key: "render",
    value: function render() {
      var duration = this.props.duration;
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "display-duration-view"
      }, moment_js_exposed_default.a.duration(duration, 'ms').format("d[d] h[h] m[m]", {
        trim: false
      }));
    }
  }]);

  return DisplayDurationComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ids.js
var ids = __webpack_require__(53);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/folder-path/folder-path.component.less
var folder_path_component = __webpack_require__(286);
var folder_path_component_default = /*#__PURE__*/__webpack_require__.n(folder_path_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/folder-path/folder-path.component.less

            

var folder_path_component_options = {};

folder_path_component_options.insert = "head";
folder_path_component_options.singleton = false;

var folder_path_component_update = injectStylesIntoStyleTag_default()(folder_path_component_default.a, folder_path_component_options);



/* harmony default export */ var folder_path_folder_path_component = (folder_path_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/folder-path/folder-path.component.js






function folder_path_component_createSuper(Derived) { var hasNativeReflectConstruct = folder_path_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function folder_path_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var folder_path_component_FolderPathComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(FolderPathComponent, _Component);

  var _super = folder_path_component_createSuper(FolderPathComponent);

  function FolderPathComponent() {
    classCallCheck_default()(this, FolderPathComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(FolderPathComponent, [{
    key: "render",
    value: function render() {
      var folders = this.props.folders;
      var folderUrl = '#/folders/Applications';
      var folderList = folders.map(function (folder, idx) {
        folderUrl += '/' + "".concat(Object(ids["a" /* default */])().noApplications(folder.id));
        return /*#__PURE__*/external_React_default.a.createElement("li", {
          key: folder.id
        }, /*#__PURE__*/external_React_default.a.createElement("div", null, idx !== 0 && /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xs chevron-right-icon"
        }), " ", /*#__PURE__*/external_React_default.a.createElement("a", {
          href: "".concat(folderUrl, "/templates")
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xs folder-icon"
        }), " ", folder.title)));
      });
      return /*#__PURE__*/external_React_default.a.createElement("ul", {
        className: "folder-path-view"
      }, folderList);
    }
  }]);

  return FolderPathComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/lodash/capitalize.js
var capitalize = __webpack_require__(208);
var capitalize_default = /*#__PURE__*/__webpack_require__.n(capitalize);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-list/release-status/release-status.component.less
var release_status_component = __webpack_require__(287);
var release_status_component_default = /*#__PURE__*/__webpack_require__.n(release_status_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-status/release-status.component.less

            

var release_status_component_options = {};

release_status_component_options.insert = "head";
release_status_component_options.singleton = false;

var release_status_component_update = injectStylesIntoStyleTag_default()(release_status_component_default.a, release_status_component_options);



/* harmony default export */ var release_status_release_status_component = (release_status_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-status/release-status.component.js






function release_status_component_createSuper(Derived) { var hasNativeReflectConstruct = release_status_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_status_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var release_status_component_ReleaseStatusComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseStatusComponent, _Component);

  var _super = release_status_component_createSuper(ReleaseStatusComponent);

  function ReleaseStatusComponent() {
    classCallCheck_default()(this, ReleaseStatusComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseStatusComponent, [{
    key: "getReleaseStatusLabel",
    value: function getReleaseStatusLabel(releaseStatus) {
      return capitalize_default()(releaseStatus.replace('_', ' '));
    }
  }, {
    key: "getStatusClassName",
    value: function getStatusClassName(releaseStatus) {
      return releaseStatus.toLowerCase();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          status = _this$props.status,
          isArchived = _this$props.isArchived;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-status-view"
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "release-status-label ".concat(this.getStatusClassName(status))
      }, this.getReleaseStatusLabel(status)), isArchived && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "release-status-label archived"
      }, "Archived"));
    }
  }]);

  return ReleaseStatusComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/release-list/release-progress/release-progress.component.js + 1 modules
var release_progress_component = __webpack_require__(166);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/utils.js
var utils = __webpack_require__(123);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/display-date/display-date.component.js







function display_date_component_createSuper(Derived) { var hasNativeReflectConstruct = display_date_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function display_date_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var display_date_component_DisplayDateComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DisplayDateComponent, _Component);

  var _super = display_date_component_createSuper(DisplayDateComponent);

  function DisplayDateComponent(props) {
    classCallCheck_default()(this, DisplayDateComponent);

    return _super.call(this, props);
  }

  createClass_default()(DisplayDateComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          date = _this$props.date,
          dateFormat = _this$props.dateFormat,
          isLink = _this$props.isLink,
          color = _this$props.color,
          timeFormat = _this$props.timeFormat;
      var format = Object(utils["a" /* formatDateTime */])(date, dateFormat, timeFormat);
      var style = {
        color: color || '#414C58'
      };

      if (isLink) {
        return /*#__PURE__*/external_React_default.a.createElement("a", {
          href: "#/calendar?has_filter&date=".concat(moment_js_exposed_default()(date).format('YYYY-MM-DD')),
          style: style
        }, format);
      }

      return /*#__PURE__*/external_React_default.a.createElement("span", {
        style: style
      }, format);
    }
  }]);

  return DisplayDateComponent;
}(external_React_["Component"]);

defineProperty_default()(display_date_component_DisplayDateComponent, "defaultProps", {
  dateFormat: 'YYYY-MM-DD',
  timeFormat: 'h:mm A'
});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-row.component.js






function release_row_component_createSuper(Derived) { var hasNativeReflectConstruct = release_row_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_row_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }










var release_row_component_ReleaseRowComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseRowComponent, _Component);

  var _super = release_row_component_createSuper(ReleaseRowComponent);

  function ReleaseRowComponent() {
    classCallCheck_default()(this, ReleaseRowComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseRowComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          title = _this$props.title,
          status = _this$props.status,
          duration = _this$props.duration,
          currentPhase = _this$props.currentPhase,
          endDate = _this$props.endDate,
          progress = _this$props.progress,
          startDate = _this$props.startDate,
          folders = _this$props.folders,
          isArchived = _this$props.isArchived,
          dateFormat = _this$props.dateFormat,
          timeFormat = _this$props.timeFormat;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-list-row-view"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-title"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("a", {
        href: "#/releases/".concat(id)
      }, /*#__PURE__*/external_React_default.a.createElement("strong", null, title), currentPhase && " - ".concat(currentPhase))), folders && folders.length > 0 && /*#__PURE__*/external_React_default.a.createElement(folder_path_component_FolderPathComponent, {
        folders: folders
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-status"
      }, /*#__PURE__*/external_React_default.a.createElement(release_status_component_ReleaseStatusComponent, {
        isArchived: isArchived,
        status: status
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-progress"
      }, /*#__PURE__*/external_React_default.a.createElement(release_progress_component["a" /* ReleaseProgressComponent */], {
        progress: progress
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-start-date"
      }, /*#__PURE__*/external_React_default.a.createElement(display_date_component_DisplayDateComponent, {
        date: startDate,
        dateFormat: dateFormat,
        isLink: true,
        timeFormat: timeFormat
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-end-date"
      }, /*#__PURE__*/external_React_default.a.createElement(display_date_component_DisplayDateComponent, {
        date: endDate,
        dateFormat: dateFormat,
        isLink: true,
        timeFormat: timeFormat
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-row-view-column release-duration"
      }, /*#__PURE__*/external_React_default.a.createElement(display_duration_component_DisplayDurationComponent, {
        duration: duration
      })));
    }
  }]);

  return ReleaseRowComponent;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-list.component.js






function release_list_component_createSuper(Derived) { var hasNativeReflectConstruct = release_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var release_list_component_ReleaseListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseListComponent, _Component);

  var _super = release_list_component_createSuper(ReleaseListComponent);

  function ReleaseListComponent() {
    classCallCheck_default()(this, ReleaseListComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseListComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          loadingReleases = _this$props.loadingReleases,
          header = _this$props.header,
          onOrderChange = _this$props.onOrderChange,
          releases = _this$props.releases,
          noData = _this$props.noData,
          dateFormat = _this$props.dateFormat,
          timeFormat = _this$props.timeFormat;
      var content = noData;

      if (releases.length > 0) {
        var releaseRows = releases.map(function (release) {
          return /*#__PURE__*/external_React_default.a.createElement(release_row_component_ReleaseRowComponent, {
            currentPhase: release.currentPhase,
            dateFormat: dateFormat,
            duration: release.duration,
            endDate: release.endDate,
            folders: release.folders,
            id: release.id,
            isArchived: release.isArchived,
            key: release.id,
            progress: release.progress,
            startDate: release.startDate,
            status: release.status,
            timeFormat: timeFormat,
            title: release.title
          });
        });
        content = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("h4", {
          className: "release-list-view-title"
        }, "Search results (top ", releases.length, ")"), /*#__PURE__*/external_React_default.a.createElement(release_header_label_component_ReleaseHeaderLabelComponent, {
          header: header,
          onOrderChange: onOrderChange
        }), releaseRows);
      }

      if (loadingReleases) {
        content = /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "spinner"
        }, /*#__PURE__*/external_React_default.a.createElement("img", {
          alt: "Loading...",
          src: "static/10.2.6/styles/img/big-ajax-loader.gif"
        }));
      }

      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-list-view"
      }, content);
    }
  }]);

  return ReleaseListComponent;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-flag/ReleaseFlagComponent.js


var RELEASE_FLAG_STATUSES = {
  AT_RISK: /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon flag-risk-icon"
  }),
  OK: /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon flag-none-icon icon-l"
  }),
  ATTENTION_NEEDED: /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon flag-attention-icon"
  })
};

var ReleaseFlagComponent = function ReleaseFlagComponent(_ref) {
  var status = _ref.status;
  return RELEASE_FLAG_STATUSES[status];
};

ReleaseFlagComponent.propTypes = {
  status: prop_types_default.a.string.isRequired
};

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(12);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/lodash/get.js
var lodash_get = __webpack_require__(40);
var get_default = /*#__PURE__*/__webpack_require__.n(lodash_get);

// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/risk-detector.js
var risk_detector = __webpack_require__(64);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-list/release-risk-status-icon/ReleaseRiskStatusIconComponent.js





var ICON_CLASSES = {
  completed: 'xl-icon circle-check-icon completed',
  onTrack: 'xl-icon circle-check-icon on-track',
  attentionNeeded: 'xl-icon circle-exclamation-icon attention-needed',
  atRisk: 'xl-icon circle-cross-icon at-risk'
};

var ReleaseRiskStatusIconComponent_ReleaseRiskStatusIconComponent = function ReleaseRiskStatusIconComponent(_ref) {
  var release = _ref.release,
      riskConfig = _ref.riskConfig;

  var hasCompletedStatus = function hasCompletedStatus(release) {
    return release.status === 'COMPLETED';
  };

  var hasAbortedStatus = function hasAbortedStatus(release) {
    return release.status === 'ABORTED';
  };

  var riskScore = parseInt(get_default()(release, 'syntheticProperties.riskScore'));

  var iconClass = function iconClass() {
    if (hasAbortedStatus(release) || hasCompletedStatus(release)) {
      return ICON_CLASSES.completed;
    } else if (Object(risk_detector["f" /* isOnTrack */])(release, riskScore, riskConfig)) {
      return ICON_CLASSES.onTrack;
    } else if (Object(risk_detector["d" /* isAttentionNeeded */])(release, riskScore, riskConfig)) {
      return ICON_CLASSES.attentionNeeded;
    } else if (Object(risk_detector["c" /* isAtRisk */])(release, riskScore, riskConfig)) {
      return ICON_CLASSES.atRisk;
    }

    return '';
  };

  return /*#__PURE__*/external_React_default.a.createElement("i", {
    className: classnames_default()('xl-icon', iconClass())
  });
};


// EXTERNAL MODULE: ./node_modules/lodash/isFunction.js
var isFunction = __webpack_require__(97);
var isFunction_default = /*#__PURE__*/__webpack_require__.n(isFunction);

// EXTERNAL MODULE: ./node_modules/lodash/noop.js
var noop = __webpack_require__(77);
var noop_default = /*#__PURE__*/__webpack_require__.n(noop);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/colors.js
var colors = __webpack_require__(21);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/inline-edit/index.js








function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function inline_edit_createSuper(Derived) { var hasNativeReflectConstruct = inline_edit_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function inline_edit_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var inline_edit_EditableLabel = /*#__PURE__*/function (_React$Component) {
  inherits_default()(EditableLabel, _React$Component);

  var _super = inline_edit_createSuper(EditableLabel);

  function EditableLabel(props) {
    var _this;

    classCallCheck_default()(this, EditableLabel);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleFocus", function () {
      var _this$props = _this.props,
          disabled = _this$props.disabled,
          onFocus = _this$props.onFocus,
          onFocusOut = _this$props.onFocusOut;

      if (!disabled) {
        var _this$state = _this.state,
            isEditing = _this$state.isEditing,
            text = _this$state.text,
            validationResult = _this$state.validationResult;

        if (isEditing) {
          /* eslint-disable angular/typecheck-function */
          if (isFunction_default()(onFocusOut)) {
            var _context;

            onFocusOut(text, (_context = _this).rollback.bind(_context), validationResult);
          }
          /* eslint-enable */

        } else {
          /* eslint-disable angular/typecheck-function */
          if (isFunction_default()(onFocus)) {
            onFocus(text);
          }
          /* eslint-enable */

        }

        if (text && text.length > 0) {
          _this.setState({
            lastSaved: text
          });
        }

        _this.setState({
          isEditing: !isEditing
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_selectValue", function (e) {
      e.target.select();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleChange", function (ev) {
      _this.setState({
        text: ev.target.value
      });

      _this.checkForValidation(ev.target.value);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      switch (e.key) {
        case 'Enter':
          _this._handleChange(e);

          _this._handleFocus(e);

          break;

        case 'Escape':
          _this.setState({
            text: _this.state.lastSaved,
            isEditing: false
          });

          if (isFunction_default()(_this.props.onDiscard)) {
            _this.props.onDiscard();
          }

          break;

        default:
          noop_default()();
      }
    });

    _this.state = {
      isEditing: _this.props.isEditing || false,
      text: _this.props.text || "",
      lastSaved: _this.props.text,
      validationResult: {
        valid: true
      }
    };
    return _this;
  }

  createClass_default()(EditableLabel, [{
    key: "rollback",
    value: function rollback() {
      this.setState({
        text: this.state.lastSaved
      });
      this.checkForValidation(this.state.lastSaved);
    }
  }, {
    key: "checkForValidation",
    value: function checkForValidation(value) {
      if (this.props.validators) {
        var isValid = function isValid(_ref) {
          var message = _ref.message;
          return message.type !== 'ERROR';
        };

        var validationToShow = this.props.validators.map(function (validator) {
          return validator(value.trim());
        }).find(function (result) {
          return result.condition;
        });
        var validationResult = validationToShow && validationToShow.condition ? {
          message: _objectSpread({}, validationToShow.message),
          valid: isValid(validationToShow)
        } : {
          valid: true
        };
        this.setState({
          validationResult: validationResult
        });
        this.props.onValidityChange(validationResult.valid);
      }
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("div", null, this.state.isEditing ? /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("input", {
        autoFocus: true,
        className: "".concat(this.props.inputClassName, " ").concat(this.state.validationResult.valid ? '' : 'input-field-error'),
        maxLength: this.props.inputMaxLength,
        onBlur: this._handleFocus,
        onChange: this._handleChange,
        onFocus: this._selectValue,
        onKeyDown: this._handleKeyDown,
        placeholder: this.props.inputPlaceHolder,
        style: {
          width: this.props.inputWidth,
          height: this.props.inputHeight,
          fontSize: this.props.inputFontSize,
          fontWeight: this.props.inputFontWeight,
          borderWidth: this.props.inputBorderWidth,
          borderColor: this.props.required && this.state.text.length === 0 ? colors["a" /* default */].red : 'none'
        },
        tabIndex: this.props.inputTabIndex,
        type: "text",
        value: this.state.text
      }), this.state.validationResult.valid ? /*#__PURE__*/external_React_default.a.createElement("span", null) : /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "validation-".concat(this.state.validationResult.message.type.toLowerCase())
      }, this.state.validationResult.message.text)) : /*#__PURE__*/external_React_default.a.createElement("label", {
        className: this.props.labelClassName,
        onClick: this._handleFocus,
        style: {
          fontSize: this.props.labelFontSize,
          fontWeight: this.props.labelFontWeight,
          height: '30px'
        },
        title: this.state.text
      }, this.state.text));
    }
  }]);

  return EditableLabel;
}(external_React_default.a.Component);

defineProperty_default()(inline_edit_EditableLabel, "defaultProps", {
  inputHeight: '30px'
});


// EXTERNAL MODULE: ./node_modules/antd/es/popover/index.js + 2 modules
var popover = __webpack_require__(3041);

// EXTERNAL MODULE: ./node_modules/lodash/map.js
var map = __webpack_require__(58);
var map_default = /*#__PURE__*/__webpack_require__.n(map);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/release-count/release-count-component.less
var release_count_component = __webpack_require__(289);
var release_count_component_default = /*#__PURE__*/__webpack_require__.n(release_count_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-count/release-count-component.less

            

var release_count_component_options = {};

release_count_component_options.insert = "head";
release_count_component_options.singleton = false;

var release_count_component_update = injectStylesIntoStyleTag_default()(release_count_component_default.a, release_count_component_options);



/* harmony default export */ var release_count_release_count_component = (release_count_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/release-count/release-count-component.js






function release_count_component_createSuper(Derived) { var hasNativeReflectConstruct = release_count_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_count_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var ReleaseCountResult = prop_types_default.a.shape({
  total: prop_types_default.a.number,
  byStatus: prop_types_default.a.object
});
var ReleaseCountResults = prop_types_default.a.shape({
  all: ReleaseCountResult.isRequired,
  live: ReleaseCountResult.isRequired,
  archived: ReleaseCountResult.isRequired
});
var release_count_component_ReleaseCountComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseCountComponent, _Component);

  var _super = release_count_component_createSuper(ReleaseCountComponent);

  function ReleaseCountComponent() {
    classCallCheck_default()(this, ReleaseCountComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ReleaseCountComponent, [{
    key: "render",
    value: function render() {
      var releaseCount = this.props.releaseCount;

      var getIconClass = function getIconClass(status) {
        return status.replace('_', '-').toLowerCase();
      };

      var getStatusText = function getStatusText(status) {
        var lowerCasedStatus = status.replace('_', ' ').toLowerCase();
        return lowerCasedStatus.charAt(0).toUpperCase() + lowerCasedStatus.slice(1);
      };

      var pluralizeReleaseWord = function pluralizeReleaseWord(count) {
        if (count === 1) {
          return 'release';
        } else {
          return 'releases';
        }
      }; // eslint-disable-next-line angular/definedundefined


      if (releaseCount === undefined) {
        return '';
      } else if (releaseCount.all.total === 0) {
        return '';
      }

      var all = map_default()(releaseCount.all.byStatus, function (count, status) {
        return /*#__PURE__*/external_React_default.a.createElement("p", {
          key: status
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "circle ".concat(getIconClass(status))
        }), count, " ", getStatusText(status));
      });
      var content = /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-status-count-popup"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, all));
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-count"
      }, /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        content: content,
        overlayClassName: "release-count-popover",
        placement: "bottom"
      }, releaseCount.all.total, " ", pluralizeReleaseWord(releaseCount.all.total)));
    }
  }]);

  return ReleaseCountComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/button-with-popover/button-with-popover.less
var button_with_popover = __webpack_require__(290);
var button_with_popover_default = /*#__PURE__*/__webpack_require__.n(button_with_popover);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/button-with-popover/button-with-popover.less

            

var button_with_popover_options = {};

button_with_popover_options.insert = "head";
button_with_popover_options.singleton = false;

var button_with_popover_update = injectStylesIntoStyleTag_default()(button_with_popover_default.a, button_with_popover_options);



/* harmony default export */ var button_with_popover_button_with_popover = (button_with_popover_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/button-with-popover/button-with-popover.component.js








function button_with_popover_component_createSuper(Derived) { var hasNativeReflectConstruct = button_with_popover_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function button_with_popover_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var placementList = ['top', 'left', 'right', 'bottom', 'topLeft', 'topRight', 'bottomLeft', 'bottomRight', 'leftTop', 'leftBottom', 'rightTop', 'rightBottom'];
var button_with_popover_component_ButtonWithPopoverComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ButtonWithPopoverComponent, _Component);

  var _super = button_with_popover_component_createSuper(ButtonWithPopoverComponent);

  function ButtonWithPopoverComponent() {
    var _this;

    classCallCheck_default()(this, ButtonWithPopoverComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "handleClick", function (e) {
      var _this$props = _this.props,
          isDisabled = _this$props.isDisabled,
          onActionClick = _this$props.onActionClick;

      if (!isDisabled) {
        onActionClick(e);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderPopoverContent", function () {
      var content = _this.props.content;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "bwp-message"
      }, content);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLink", function () {
      var _this$props2 = _this.props,
          isDisabled = _this$props2.isDisabled,
          label = _this$props2.label,
          buttonClassName = _this$props2.buttonClassName;
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('link', defineProperty_default()({}, "".concat(buttonClassName), buttonClassName), {
          'disabled': isDisabled
        }),
        onClick: _this.handleClick
      }, label);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderButton", function () {
      var _this$props3 = _this.props,
          isDisabled = _this$props3.isDisabled,
          label = _this$props3.label,
          buttonClassName = _this$props3.buttonClassName;
      return /*#__PURE__*/external_React_default.a.createElement("button", {
        className: classnames_default()('button', defineProperty_default()({}, "".concat(buttonClassName), buttonClassName)),
        disabled: isDisabled,
        onClick: _this.handleClick
      }, label);
    });

    return _this;
  }

  createClass_default()(ButtonWithPopoverComponent, [{
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          isTooltipVisible = _this$props4.isTooltipVisible,
          placement = _this$props4.placement,
          showAsLink = _this$props4.showAsLink;
      var buttonTemplate = /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('bwp-button')
      }, showAsLink ? this.renderLink() : this.renderButton());
      return isTooltipVisible ? /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        content: this.renderPopoverContent(),
        mouseEnterDelay: 0.5,
        mouseLeaveDelay: 0,
        overlayClassName: "button-with-popover",
        placement: placement
      }, buttonTemplate) : buttonTemplate;
    }
  }]);

  return ButtonWithPopoverComponent;
}(external_React_["Component"]);

defineProperty_default()(button_with_popover_component_ButtonWithPopoverComponent, "defaultProps", {
  placement: placementList[0]
});
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.js + 5 modules
var infinite_list_component = __webpack_require__(270);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__(23);
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// EXTERNAL MODULE: ./node_modules/lodash/isUndefined.js
var isUndefined = __webpack_require__(52);
var isUndefined_default = /*#__PURE__*/__webpack_require__.n(isUndefined);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/context-menu/contex-menu.component.less
var contex_menu_component = __webpack_require__(292);
var contex_menu_component_default = /*#__PURE__*/__webpack_require__.n(contex_menu_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/context-menu/contex-menu.component.less

            

var contex_menu_component_options = {};

contex_menu_component_options.insert = "head";
contex_menu_component_options.singleton = false;

var contex_menu_component_update = injectStylesIntoStyleTag_default()(contex_menu_component_default.a, contex_menu_component_options);



/* harmony default export */ var context_menu_contex_menu_component = (contex_menu_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/context-menu/context-menu.component.js









function context_menu_component_createSuper(Derived) { var hasNativeReflectConstruct = context_menu_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function context_menu_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var context_menu_component_ContextMenuComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ContextMenuComponent, _Component);

  var _super = context_menu_component_createSuper(ContextMenuComponent);

  function ContextMenuComponent(props) {
    var _this;

    classCallCheck_default()(this, ContextMenuComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "renderMenuContent", function (menuOptions) {
      return menuOptions.map(function (item, index) {
        return isUndefined_default()(item.isVisible) || !!item.isVisible ? !!item.isDisabled ? /*#__PURE__*/external_React_default.a.createElement("a", {
          className: "link-disabled",
          key: "menu-item-".concat(index)
        }, _this.renderLabel(item)) : /*#__PURE__*/external_React_default.a.createElement("a", {
          key: "menu-item-".concat(index),
          onClick: function onClick() {
            for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            return _this.onItemClick(item, args);
          }
        }, _this.renderLabel(item)) : false;
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onVisibleChange", function (visible) {
      var onVisibilityChanged = _this.props.onVisibilityChanged;

      _this.setState({
        visible: visible
      });

      if (onVisibilityChanged) {
        onVisibilityChanged(visible);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderLabel", function (item) {
      if (isUndefined_default()(item.iconClassName)) {
        return item.label;
      } else {
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "centered"
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: item.iconClassName
        }), item.label);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderMenu", function (destroyTooltipOnHide, stageMenuOptions, menuWrapperClassName, menuName) {
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: menuWrapperClassName
      }, /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        arrowPointAtCenter: true,
        content: _this.renderMenuContent(stageMenuOptions),
        destroyTooltipOnHide: destroyTooltipOnHide,
        onVisibleChange: _this.onVisibleChange,
        overlayClassName: "context-menu-popover",
        placement: "bottomRight",
        trigger: "click",
        visible: _this.state.visible
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon options-icon icon-l context-menu-btn",
        "data-cy": 'popup-' + menuName
      })));
    });

    _this.state = {
      visible: false
    };
    return _this;
  }

  createClass_default()(ContextMenuComponent, [{
    key: "onItemClick",
    value: function onItemClick(item, args) {
      if (this.props.dismissOnClick) {
        this.setState({
          visible: false
        });
      }

      item.handler.apply(item, toConsumableArray_default()(args));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          destroyTooltipOnHide = _this$props.destroyTooltipOnHide,
          menuName = _this$props.menuName,
          menuOptions = _this$props.menuOptions,
          menuWrapperClassName = _this$props.menuWrapperClassName;
      return this.renderMenu(destroyTooltipOnHide, menuOptions, menuWrapperClassName, menuName);
    }
  }]);

  return ContextMenuComponent;
}(external_React_["Component"]);

defineProperty_default()(context_menu_component_ContextMenuComponent, "defaultProps", {
  destroyTooltipOnHide: false,
  dismissOnClick: false,
  menuName: '',
  menuOptions: [],
  menuWrapperClassName: ''
});
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/doc-link/doc-link.component.js
var doc_link_component = __webpack_require__(269);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/select-tree/select-tree.component.less
var select_tree_component = __webpack_require__(293);
var select_tree_component_default = /*#__PURE__*/__webpack_require__.n(select_tree_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/select-tree/select-tree.component.less

            

var select_tree_component_options = {};

select_tree_component_options.insert = "head";
select_tree_component_options.singleton = false;

var select_tree_component_update = injectStylesIntoStyleTag_default()(select_tree_component_default.a, select_tree_component_options);



/* harmony default export */ var select_tree_select_tree_component = (select_tree_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/select-tree/select-tree.component.js





var select_tree_component_SelectTreeComponent = function SelectTreeComponent(_ref) {
  var clearable = _ref.clearable,
      data = _ref.data,
      onModelChange = _ref.onModelChange,
      selectedItemId = _ref.selectedItemId;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "select-tree-component"
  }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetTreeSelect"], {
    clearable: clearable,
    data: data,
    expandAll: true,
    indentGroupPadding: 10,
    onModelChange: onModelChange,
    selectedFolderId: selectedItemId
  }));
};


// EXTERNAL MODULE: ./node_modules/lodash/escapeRegExp.js
var escapeRegExp = __webpack_require__(527);
var escapeRegExp_default = /*#__PURE__*/__webpack_require__.n(escapeRegExp);

// EXTERNAL MODULE: ./node_modules/lodash/includes.js
var includes = __webpack_require__(42);
var includes_default = /*#__PURE__*/__webpack_require__.n(includes);

// EXTERNAL MODULE: ./node_modules/lodash/isEqual.js
var isEqual = __webpack_require__(85);
var isEqual_default = /*#__PURE__*/__webpack_require__.n(isEqual);

// EXTERNAL MODULE: ./node_modules/lodash/uniq.js
var uniq = __webpack_require__(528);
var uniq_default = /*#__PURE__*/__webpack_require__.n(uniq);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/suggestions.component.js








function suggestions_component_createSuper(Derived) { var hasNativeReflectConstruct = suggestions_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function suggestions_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var maybeScrollSuggestionIntoView = function maybeScrollSuggestionIntoView(suggestionEl, suggestionsContainer) {
  var containerHeight = suggestionsContainer.offsetHeight;
  var suggestionHeight = suggestionEl.offsetHeight;
  var relativeSuggestionTop = suggestionEl.offsetTop - suggestionsContainer.scrollTop;

  if (relativeSuggestionTop + suggestionHeight >= containerHeight) {
    suggestionsContainer.scrollTop += relativeSuggestionTop - containerHeight + suggestionHeight;
  } else if (relativeSuggestionTop < 0) {
    suggestionsContainer.scrollTop += relativeSuggestionTop;
  }
};

var suggestions_component_Suggestions = /*#__PURE__*/function (_Component) {
  inherits_default()(Suggestions, _Component);

  var _super = suggestions_component_createSuper(Suggestions);

  function Suggestions() {
    var _this;

    classCallCheck_default()(this, Suggestions);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "shouldRenderSuggestions", function (query) {
      var _this$props = _this.props,
          minQueryLength = _this$props.minQueryLength,
          isFocused = _this$props.isFocused;
      return query.length >= minQueryLength && isFocused;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderSuggestion", function (item, query) {
      var renderSuggestion = _this.props.renderSuggestion;

      if (isFunction_default()(renderSuggestion)) {
        return renderSuggestion(item, query);
      }

      var labelValue = item[_this.props.labelField];
      return /*#__PURE__*/external_React_default.a.createElement("span", null, labelValue);
    });

    return _this;
  }

  createClass_default()(Suggestions, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      var props = this.props;
      var shouldRenderSuggestions = props.shouldRenderSuggestions || this.shouldRenderSuggestions;
      return props.isFocused !== nextProps.isFocused || !isEqual_default()(props.suggestions, nextProps.suggestions) || shouldRenderSuggestions(nextProps.query) || shouldRenderSuggestions(nextProps.query) !== shouldRenderSuggestions(props.query);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props2 = this.props,
          selectedIndex = _this$props2.selectedIndex,
          classNames = _this$props2.classNames;

      if (this.suggestionsContainer && prevProps.selectedIndex !== selectedIndex) {
        var activeSuggestion = this.suggestionsContainer.querySelector(classNames.activeSuggestion);

        if (activeSuggestion) {
          maybeScrollSuggestionIntoView(activeSuggestion, this.suggestionsContainer);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var props = this.props;
      var suggestions = props.suggestions.map(function (item, i) {
        return /*#__PURE__*/external_React_default.a.createElement("li", {
          className: i === props.selectedIndex ? props.classNames.activeSuggestion : '',
          key: i,
          onMouseDown: props.handleClick.bind(null, i),
          onMouseOver: props.handleHover.bind(null, i),
          onTouchStart: props.handleClick.bind(null, i)
        }, _this2.renderSuggestion(item, props.query));
      });
      var shouldRenderSuggestions = props.shouldRenderSuggestions || this.shouldRenderSuggestions;

      if (suggestions.length === 0 || !shouldRenderSuggestions(props.query)) {
        return /*#__PURE__*/external_React_default.a.createElement(external_React_["Fragment"], null);
      }

      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: this.props.classNames.suggestions,
        ref: function ref(elem) {
          return _this2.suggestionsContainer = elem;
        },
        style: props.isShowFromBottom ? {
          bottom: '0px',
          position: 'fixed'
        } : null
      }, /*#__PURE__*/external_React_default.a.createElement("ul", null, " ", suggestions, " "));
    }
  }]);

  return Suggestions;
}(external_React_["Component"]);

defineProperty_default()(suggestions_component_Suggestions, "defaultProps", {
  minQueryLength: 2
});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags-constants.js
var DEFAULT_PLACEHOLDER = 'Add...';
var DEFAULT_LABEL_FIELD = 'text';
var DEFAULT_CLASSNAMES = {
  tags: 'tags',
  tagInput: 'tag-new',
  tagInputField: 'tag-input',
  selected: 'tag',
  tag: 'tag-label',
  tagIcon: 'xl-icon tag-icon',
  tagHighlight: 'tag-highlight',
  remove: 'tag-close',
  suggestions: 'xlr-tags-suggestions',
  activeSuggestion: 'xlr-tags-active-suggestions'
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/remove.component.js



var remove_component_RemoveComponent = function RemoveComponent(props) {
  var readOnly = props.readOnly,
      removeComponent = props.removeComponent,
      onClick = props.onClick,
      className = props.className;

  if (readOnly) {
    return /*#__PURE__*/external_React_default.a.createElement("span", null);
  }

  if (removeComponent) {
    var Component = removeComponent;
    return /*#__PURE__*/external_React_default.a.createElement(Component, props);
  }

  return /*#__PURE__*/external_React_default.a.createElement("a", {
    className: className,
    onClick: onClick,
    onKeyDown: onClick
  }, /*#__PURE__*/external_React_default.a.createElement("i", {
    className: "xl-icon close-icon icon-s"
  }));
};
remove_component_RemoveComponent.defaultProps = {
  className: DEFAULT_CLASSNAMES.remove,
  readOnly: false
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/tag.component.js







function tag_component_createSuper(Derived) { var hasNativeReflectConstruct = tag_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tag_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var tag_component_Tag = /*#__PURE__*/function (_Component) {
  inherits_default()(Tag, _Component);

  var _super = tag_component_createSuper(Tag);

  function Tag() {
    classCallCheck_default()(this, Tag);

    return _super.apply(this, arguments);
  }

  createClass_default()(Tag, [{
    key: "render",
    value: function render() {
      var props = this.props;
      var label = props.tag[props.labelField];
      var displayIcon = props.displayIcon,
          readOnly = props.readOnly,
          tag = props.tag,
          classNames = props.classNames;
      var _tag$className = tag.className,
          className = _tag$className === void 0 ? '' : _tag$className;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, displayIcon && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classNames.tagIcon
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('tag-wrapper', classNames.tag, className),
        "data-tag-id": props.tag.id,
        onClick: props.onTagClicked,
        onKeyDown: props.onTagClicked,
        onTouchStart: props.onTagClicked
      }, label), /*#__PURE__*/external_React_default.a.createElement(remove_component_RemoveComponent, {
        className: classNames.remove,
        onClick: props.onDelete,
        readOnly: readOnly,
        removeComponent: props.removeComponent,
        tag: props.tag
      }));
    }
  }]);

  return Tag;
}(external_React_["Component"]);

defineProperty_default()(tag_component_Tag, "defaultProps", {
  displayIcon: true,
  labelField: 'text',
  readOnly: false
});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags.less
var xlr_tags = __webpack_require__(294);
var xlr_tags_default = /*#__PURE__*/__webpack_require__.n(xlr_tags);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags.less

            

var xlr_tags_options = {};

xlr_tags_options.insert = "head";
xlr_tags_options.singleton = false;

var xlr_tags_update = injectStylesIntoStyleTag_default()(xlr_tags_default.a, xlr_tags_options);



/* harmony default export */ var react_tags_xlr_tags = (xlr_tags_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/react-tags/xlr-tags.component.js








function xlr_tags_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function xlr_tags_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { xlr_tags_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { xlr_tags_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function xlr_tags_component_createSuper(Derived) { var hasNativeReflectConstruct = xlr_tags_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function xlr_tags_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
















/**
 * @description
 * This component has been inspired from react-tags component (https://github.com/prakhar1989/react-tags/tree/v6.4.2)
 * It is customised as per XebiaLabs requirements.
 *
 * For all options, see https://github.com/prakhar1989/react-tags/tree/v6.4.2#options
 */

var xlr_tags_component_XlrTags = /*#__PURE__*/function (_Component) {
  inherits_default()(XlrTags, _Component);

  var _super = xlr_tags_component_createSuper(XlrTags);

  function XlrTags(props) {
    var _this;

    classCallCheck_default()(this, XlrTags);

    _this = _super.call(this, props);
    var suggestions = props.suggestions;
    _this.state = {
      suggestions: suggestions,
      query: '',
      isFocused: false,
      selectedIndex: -1,
      selectionMode: false,
      shouldShowSuggestionFromBottom: false
    };
    _this.handleFocus = _this.handleFocus.bind(assertThisInitialized_default()(_this));
    _this.handleBlur = _this.handleBlur.bind(assertThisInitialized_default()(_this));
    _this.handleKeyDown = _this.handleKeyDown.bind(assertThisInitialized_default()(_this));
    _this.handleChange = _this.handleChange.bind(assertThisInitialized_default()(_this));
    _this.handlePaste = _this.handlePaste.bind(assertThisInitialized_default()(_this));
    _this.resetAndFocusInput = _this.resetAndFocusInput.bind(assertThisInitialized_default()(_this));
    _this.handleSuggestionHover = _this.handleSuggestionHover.bind(assertThisInitialized_default()(_this));
    _this.handleSuggestionClick = _this.handleSuggestionClick.bind(assertThisInitialized_default()(_this));
    return _this;
  }

  createClass_default()(XlrTags, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          autofocus = _this$props.autofocus,
          readOnly = _this$props.readOnly;

      if (autofocus && !readOnly) {
        this.resetAndFocusInput();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!isEqual_default()(prevProps.suggestions, this.props.suggestions)) {
        this.updateSuggestions();
      }
    }
  }, {
    key: "filteredSuggestions",
    value: function filteredSuggestions(query, suggestions) {
      var _this2 = this;

      if (this.props.handleFilterSuggestions) {
        return this.props.handleFilterSuggestions(query, suggestions);
      }

      var exactSuggestions = suggestions.filter(function (item) {
        return _this2.getQueryIndex(query, item) === 0 && !includes_default()(map_default()(_this2.props.tags, _this2.props.labelField), item[_this2.props.labelField]);
      });
      var partialSuggestions = suggestions.filter(function (item) {
        return _this2.getQueryIndex(query, item) > 0 && !includes_default()(map_default()(_this2.props.tags, _this2.props.labelField), item[_this2.props.labelField]);
      });
      return exactSuggestions.concat(partialSuggestions);
    }
  }, {
    key: "getQueryIndex",
    value: function getQueryIndex(query, item) {
      return item[this.props.labelField].toLowerCase().indexOf(query.toLowerCase());
    }
  }, {
    key: "resetAndFocusInput",
    value: function resetAndFocusInput() {
      this.setState({
        query: ''
      });

      if (this.textInput) {
        this.textInput.value = '';
        this.textInput.focus();
      }
    }
  }, {
    key: "handleDelete",
    value: function handleDelete(i, e) {
      this.props.handleDelete(i, e);

      if (!this.props.resetInputOnDelete) {
        this.textInput && this.textInput.focus();
      } else {
        this.resetAndFocusInput();
      }

      e.stopPropagation();
    }
  }, {
    key: "handleTagClick",
    value: function handleTagClick(i, e) {
      if (this.props.handleTagClick) {
        this.props.handleTagClick(i, e);
      }

      if (!this.props.resetInputOnDelete) {
        this.textInput && this.textInput.focus();
      } else {
        this.resetAndFocusInput();
      }
    }
  }, {
    key: "handleChange",
    value: function handleChange(e) {
      if (this.props.handleInputChange) {
        this.props.handleInputChange(e.target.value);
      }

      var query = e.target.value.trim();
      this.setState({
        query: query
      }, this.updateSuggestions);
    }
    /**
     * Convert an array of delimiter characters into a regular expression
     * that can be used to split content by those delimiters.
     * @param {Array<char>} delimiters Array of characters to turn into a regex
     * @returns {RegExp} Regular expression
     */

  }, {
    key: "buildRegExpFromDelimiters",
    value: function buildRegExpFromDelimiters(delimiters) {
      var delimiterChars = delimiters.map(function (delimiter) {
        // See: http://stackoverflow.com/a/34711175/1463681
        var chrCode = delimiter - 48 * Math.floor(delimiter / 48);
        return String.fromCharCode(96 <= delimiter ? chrCode : delimiter);
      }).join('');
      var escapedDelimiterChars = escapeRegExp_default()(delimiterChars);
      return new RegExp("[".concat(escapedDelimiterChars, "]+"));
    }
  }, {
    key: "updateSuggestions",
    value: function updateSuggestions() {
      var _this$state = this.state,
          query = _this$state.query,
          selectedIndex = _this$state.selectedIndex;
      var suggestions = this.filteredSuggestions(query, this.props.suggestions);
      this.setState({
        suggestions: suggestions,
        selectedIndex: selectedIndex >= suggestions.length ? suggestions.length - 1 : selectedIndex
      });
    }
  }, {
    key: "isOutOfViewport",
    value: function isOutOfViewport(elem) {
      var bounding = elem.getBoundingClientRect();
      return bounding.bottom + 150 > window.innerHeight; //150px is max height for suggestion component
    }
  }, {
    key: "handleFocus",
    value: function handleFocus(e) {
      var value = e.target.value;

      if (this.props.handleInputFocus) {
        this.props.handleInputFocus(value);
      }

      var isOutOfViewport = this.isOutOfViewport(this.textInput);
      this.setState({
        isFocused: true,
        shouldShowSuggestionFromBottom: isOutOfViewport
      });
    }
  }, {
    key: "handleBlur",
    value: function handleBlur(e) {
      var value = e.target.value;

      if (this.props.handleInputBlur) {
        this.props.handleInputBlur(value);

        if (this.textInput) {
          this.textInput.value = '';
        }
      }

      this.setState({
        isFocused: false
      });
    }
  }, {
    key: "handleKeyDown",
    value: function handleKeyDown(e) {
      var _this$state2 = this.state,
          query = _this$state2.query,
          selectedIndex = _this$state2.selectedIndex,
          suggestions = _this$state2.suggestions,
          selectionMode = _this$state2.selectionMode; // hide suggestions menu on escape

      if (e.keyCode === key_codes["a" /* keyCodes */].ESC) {
        e.preventDefault();
        e.stopPropagation();
        this.setState({
          selectedIndex: -1,
          selectionMode: false,
          suggestions: []
        });
      } // When one of the terminating keys is pressed, add current query to the tags.
      // If no text is typed in so far, ignore the action - so we don't end up with a terminating
      // character typed in.


      if (includes_default()(this.props.delimiters, e.keyCode) && !e.shiftKey) {
        if (e.keyCode !== key_codes["a" /* keyCodes */].TAB || query !== '') {
          e.preventDefault();
        }

        var selectedQuery = selectionMode && selectedIndex !== -1 ? suggestions[selectedIndex] : defineProperty_default()({
          id: query
        }, this.props.labelField, query);

        if (selectedQuery !== '') {
          this.addTag(selectedQuery);
        }
      } // when backspace key is pressed and query is blank, delete tag


      if (e.keyCode === key_codes["a" /* keyCodes */].BACKSPACE && query === '' && this.props.allowDeleteFromEmptyInput) {
        this.handleDelete(this.props.tags.length - 1, e);
      } // up arrow


      if (e.keyCode === key_codes["a" /* keyCodes */].UP) {
        e.preventDefault();
        this.setState({
          selectedIndex: selectedIndex <= 0 ? suggestions.length - 1 : selectedIndex - 1,
          selectionMode: true
        });
      } // down arrow


      if (e.keyCode === key_codes["a" /* keyCodes */].DOWN) {
        e.preventDefault();
        this.setState({
          selectedIndex: suggestions.length === 0 ? -1 : (selectedIndex + 1) % suggestions.length,
          selectionMode: true
        });
      }
    }
  }, {
    key: "handlePaste",
    value: function handlePaste(e) {
      var _this3 = this;

      if (!this.props.allowAddFromPaste) {
        return;
      }

      e.preventDefault();
      var clipboardData = e.clipboardData || window.clipboardData;
      var clipboardText = clipboardData.getData('text');
      var _this$props$maxLength = this.props.maxLength,
          maxLength = _this$props$maxLength === void 0 ? clipboardText.length : _this$props$maxLength;
      var maxTextLength = Math.min(maxLength, clipboardText.length);
      var pastedText = clipboardData.getData('text').substr(0, maxTextLength); // Used to determine how the pasted content is split.

      var delimiterRegExp = this.buildRegExpFromDelimiters(this.props.delimiters);
      var tags = pastedText.split(delimiterRegExp); // Only add unique tags

      uniq_default()(tags).forEach(function (tag) {
        return _this3.addTag(defineProperty_default()({
          id: tag
        }, _this3.props.labelField, tag));
      });
    }
  }, {
    key: "highlight",
    value: function highlight(tag) {
      var classNames = xlr_tags_component_objectSpread(xlr_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), this.props.classNames);
      /* eslint-disable react/no-find-dom-node */


      var node = external_ReactDOM_default.a.findDOMNode(this);
      /* eslint-enable react/no-find-dom-node */

      if (node instanceof HTMLElement) {
        var parent = node.querySelector(".".concat(classNames.tag, "[data-tag-id='").concat(tag.id, "']")).parentNode;
        parent.classList.remove(classNames.tagHighlight);
        setTimeout(function () {
          return parent.classList.add(classNames.tagHighlight);
        }, 100);
      }
    }
  }, {
    key: "addTag",
    value: function addTag(tag) {
      var _tag$id;

      var _this$props2 = this.props,
          tags = _this$props2.tags,
          labelField = _this$props2.labelField,
          allowUnique = _this$props2.allowUnique;
      tag.readOnly = false; // by default, will be overwritten on  tag = possibleMatches[0];

      if (!tag.id || !tag[labelField]) {
        return;
      }

      var existingKeys = tags.map(function (item) {
        var _item$id;

        return (_item$id = item.id) === null || _item$id === void 0 ? void 0 : _item$id.toLowerCase();
      }); // Return if tag has been already added

      if (allowUnique && includes_default()(existingKeys, (_tag$id = tag.id) === null || _tag$id === void 0 ? void 0 : _tag$id.toLowerCase())) {
        this.highlight(tag);
        return;
      }

      if (this.props.autocomplete) {
        var possibleMatches = this.filteredSuggestions(tag[labelField], this.props.suggestions);

        if (this.props.autocomplete === 1 && possibleMatches.length === 1 || this.props.autocomplete === true && possibleMatches.length) {
          tag = possibleMatches[0];
        }
      } // Return if entered tag is any arbitrary value and not selected from suggestions


      if (this.props.allowAddOnlyFromSuggestion && !includes_default()(this.props.suggestions.map(function (item) {
        return item.id.toLowerCase();
      }), tag.id.toLowerCase())) {
        return;
      } // call method to add


      this.props.handleAddition(tag); // reset the state

      this.setState({
        query: '',
        selectionMode: false,
        selectedIndex: -1
      });
      this.resetAndFocusInput();
    }
  }, {
    key: "handleSuggestionClick",
    value: function handleSuggestionClick(i) {
      this.addTag(this.state.suggestions[i]);
    }
  }, {
    key: "handleSuggestionHover",
    value: function handleSuggestionHover(i) {
      this.setState({
        selectedIndex: i,
        selectionMode: true
      });
    }
  }, {
    key: "getTagItems",
    value: function getTagItems() {
      var _this4 = this;

      var _this$props3 = this.props,
          tags = _this$props3.tags,
          labelField = _this$props3.labelField,
          removeComponent = _this$props3.removeComponent;

      var classNames = xlr_tags_component_objectSpread(xlr_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), this.props.classNames);

      return tags.map(function (tag, index) {
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: classNames.selected,
          key: "div-".concat(tag.id, "-").concat(index)
        }, /*#__PURE__*/external_React_default.a.createElement(tag_component_Tag, {
          classNames: classNames,
          displayIcon: !tag.isVirtual,
          index: index,
          key: "".concat(tag.id, "-").concat(index),
          labelField: labelField,
          onDelete: _this4.handleDelete.bind(_this4, index),
          onTagClicked: _this4.handleTagClick.bind(_this4, index),
          readOnly: tag.readOnly,
          removeComponent: removeComponent,
          tag: tag
        }));
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;

      var tagItems = this.getTagItems();

      var classNames = xlr_tags_component_objectSpread(xlr_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), this.props.classNames); // get the suggestions for the given query


      var query = this.state.query.trim(),
          selectedIndex = this.state.selectedIndex,
          suggestions = this.state.suggestions;
      var _this$props4 = this.props,
          placeholder = _this$props4.placeholder,
          inputName = _this$props4.name,
          inputId = _this$props4.id,
          maxLength = _this$props4.maxLength;
      var tagInput = !this.props.readOnly ? /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classNames.tagInput
      }, /*#__PURE__*/external_React_default.a.createElement("input", {
        "aria-label": placeholder,
        className: classNames.tagInputField,
        id: inputId,
        maxLength: maxLength,
        name: inputName,
        onBlur: this.handleBlur,
        onChange: this.handleChange,
        onFocus: this.handleFocus,
        onKeyDown: this.handleKeyDown,
        onPaste: this.handlePaste,
        placeholder: placeholder,
        ref: function ref(input) {
          _this5.textInput = input;
        },
        type: "text",
        value: this.props.inputValue
      }), /*#__PURE__*/external_React_default.a.createElement(suggestions_component_Suggestions, {
        classNames: classNames,
        handleClick: this.handleSuggestionClick,
        handleHover: this.handleSuggestionHover,
        isFocused: this.state.isFocused,
        isShowFromBottom: this.state.shouldShowSuggestionFromBottom,
        labelField: this.props.labelField,
        minQueryLength: this.props.minQueryLength,
        query: query,
        renderSuggestion: this.props.renderSuggestion,
        selectedIndex: selectedIndex,
        shouldRenderSuggestions: this.props.shouldRenderSuggestions,
        suggestions: suggestions
      })) : null;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()(classNames.tags, 'react-tags-wrapper')
      }, tagItems, tagInput);
    }
  }]);

  return XlrTags;
}(external_React_["Component"]);

defineProperty_default()(xlr_tags_component_XlrTags, "defaultProps", {
  placeholder: DEFAULT_PLACEHOLDER,
  labelField: DEFAULT_LABEL_FIELD,
  suggestions: [],
  delimiters: [key_codes["a" /* keyCodes */].ENTER],
  autofocus: true,
  handleDelete: noop_default.a,
  handleAddition: noop_default.a,
  allowAddOnlyFromSuggestion: false,
  allowDeleteFromEmptyInput: true,
  allowAddFromPaste: true,
  resetInputOnDelete: true,
  autocomplete: false,
  readOnly: false,
  allowUnique: true,
  tags: []
});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/tags-input/xlr-members-tags.less
var xlr_members_tags = __webpack_require__(295);
var xlr_members_tags_default = /*#__PURE__*/__webpack_require__.n(xlr_members_tags);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/xlr-members-tags.less

            

var xlr_members_tags_options = {};

xlr_members_tags_options.insert = "head";
xlr_members_tags_options.singleton = false;

var xlr_members_tags_update = injectStylesIntoStyleTag_default()(xlr_members_tags_default.a, xlr_members_tags_options);



/* harmony default export */ var tags_input_xlr_members_tags = (xlr_members_tags_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/tags-input/xlr-members-tags.component.js








function xlr_members_tags_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function xlr_members_tags_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { xlr_members_tags_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { xlr_members_tags_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function xlr_members_tags_component_createSuper(Derived) { var hasNativeReflectConstruct = xlr_members_tags_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function xlr_members_tags_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






/**
 * @description
 * React component to manage tag list input with auto-completion for members.
 *
 * @example
 * <XlrMembersTags
 *    classNames={{tagInput: 'tag-new principal', selected: 'tag principal'}}
 *    placeholder={'Add principal...'}
 *    tags={tags}
 *    suggestions={suggestions}
 *    handleDelete={this.onMemberDelete}
 *    handleAddition={this.onMemberChange}
 *    readOnly={false}
 * />
 *
 * handleDelete(i) {
 *    const { tags } = this.state;
 *    this.setState({
 *      tags: tags.filter((tag, index) => index !== i),
 *    });
 * }
 *
 * handleAddition(tag) {
 *    this.setState(state => ({ tags: [...state.tags, tag] }));
 * }
 *
 */

var xlr_members_tags_component_XlrMembersTags = /*#__PURE__*/function (_Component) {
  inherits_default()(XlrMembersTags, _Component);

  var _super = xlr_members_tags_component_createSuper(XlrMembersTags);

  function XlrMembersTags() {
    var _this;

    classCallCheck_default()(this, XlrMembersTags);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderSuggestion", function (item) {
      var isVirtual = item.isVirtual;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: 'suggestion-wrapper'
      }, !isVirtual && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: 'xl-icon tag-icon'
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: 'tag-label'
      }, item[_this.props.label]));
    });

    return _this;
  }

  createClass_default()(XlrMembersTags, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          allowAddOnlyFromSuggestion = _this$props.allowAddOnlyFromSuggestion,
          handleAddition = _this$props.handleAddition,
          handleDelete = _this$props.handleDelete,
          id = _this$props.id,
          label = _this$props.label,
          maxLength = _this$props.maxLength,
          name = _this$props.name,
          placeholder = _this$props.placeholder,
          readOnly = _this$props.readOnly,
          suggestions = _this$props.suggestions,
          tags = _this$props.tags;

      var classNames = xlr_members_tags_component_objectSpread(xlr_members_tags_component_objectSpread({}, XlrMembersTags.defaultProps.classNames), this.props.classNames);

      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement(xlr_tags_component_XlrTags, {
        allowAddFromPaste: false,
        allowAddOnlyFromSuggestion: allowAddOnlyFromSuggestion,
        autofocus: false,
        classNames: classNames,
        handleAddition: handleAddition,
        handleDelete: handleDelete,
        id: id,
        labelField: label,
        maxLength: maxLength,
        minQueryLength: 1,
        name: name,
        placeholder: placeholder,
        readOnly: readOnly,
        renderSuggestion: this.renderSuggestion,
        suggestions: suggestions,
        tags: tags
      }));
    }
  }]);

  return XlrMembersTags;
}(external_React_["Component"]);

defineProperty_default()(xlr_members_tags_component_XlrMembersTags, "defaultProps", {
  allowAddOnlyFromSuggestion: false,
  classNames: xlr_members_tags_component_objectSpread(xlr_members_tags_component_objectSpread({}, DEFAULT_CLASSNAMES), {}, {
    tagInput: 'tag-new principal',
    selected: 'tag principal'
  }),
  label: "name",
  placeholder: "Add...",
  suggestions: [],
  readOnly: false,
  tags: []
});
// EXTERNAL MODULE: ./core/xlr-ui/app/js/variables/variable-constants.js
var variable_constants = __webpack_require__(41);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/display-variable/display-variable.less
var display_variable = __webpack_require__(296);
var display_variable_default = /*#__PURE__*/__webpack_require__.n(display_variable);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/display-variable/display-variable.less

            

var display_variable_options = {};

display_variable_options.insert = "head";
display_variable_options.singleton = false;

var display_variable_update = injectStylesIntoStyleTag_default()(display_variable_default.a, display_variable_options);



/* harmony default export */ var display_variable_display_variable = (display_variable_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/display-variable/display-variable.component.js





var display_variable_component_DisplayVariable = function DisplayVariable(_ref) {
  var variable = _ref.variable;

  var renderStringField = function renderStringField() {
    var isPassword = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key,
        type: isPassword ? 'password' : 'text'
      },
      model: variable.value
    });
  };

  var renderBooleanField = function renderBooleanField() {
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: variable.value ? 'True' : 'False'
    });
  };

  var renderSetField = function renderSetField() {
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: "set(".concat(transformObjectToText(), ")")
    });
  };

  var renderObjectField = function renderObjectField() {
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: transformObjectToText()
    });
  };

  var renderDateTimeField = function renderDateTimeField() {
    var value = moment(variable.value).format('DD/MM/YYYY hh:mm A');
    return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
      displayMode: 'visual',
      metadata: {
        label: variable.key
      },
      model: value
    });
  }; // eslint-disable-next-line no-console, angular/json-functions


  var transformObjectToText = function transformObjectToText() {
    return JSON.stringify(variable.value).split(',').join(', ');
  };

  var renderSwitch = function renderSwitch() {
    switch (variable.type) {
      case variable_constants["a" /* VariableConstants */].type.string.key:
      case variable_constants["a" /* VariableConstants */].type.integer.key:
        return renderStringField();

      case variable_constants["a" /* VariableConstants */].type.passwordString.key:
        return renderStringField(true);

      case variable_constants["a" /* VariableConstants */].type.boolean.key:
        return renderBooleanField();

      case variable_constants["a" /* VariableConstants */].type.setString.key:
        return renderSetField();

      case variable_constants["a" /* VariableConstants */].type.date.key:
        return renderDateTimeField();

      case variable_constants["a" /* VariableConstants */].type.listString.key:
      case variable_constants["a" /* VariableConstants */].type.mapStringString.key:
      default:
        return renderObjectField();
    }
  };

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "display-variable-wrapper form-group"
  }, renderSwitch());
};
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/slicedToArray.js
var slicedToArray = __webpack_require__(20);
var slicedToArray_default = /*#__PURE__*/__webpack_require__.n(slicedToArray);

// EXTERNAL MODULE: ./node_modules/lodash/isEmpty.js
var isEmpty = __webpack_require__(29);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/text-area-password/TextAreaPassword.js






var PasswordCharacterCode = "\u2022";

var TextAreaPassword_TextAreaPassword = function TextAreaPassword(_ref) {
  var name = _ref.name,
      onChange = _ref.onChange,
      _ref$required = _ref.required,
      required = _ref$required === void 0 ? false : _ref$required,
      _ref$rows = _ref.rows,
      rows = _ref$rows === void 0 ? 4 : _ref$rows,
      value = _ref.value;

  var _useState = Object(external_React_["useState"])(""),
      _useState2 = slicedToArray_default()(_useState, 2),
      passwordValue = _useState2[0],
      setPasswordValue = _useState2[1];

  var _useState3 = Object(external_React_["useState"])(true),
      _useState4 = slicedToArray_default()(_useState3, 2),
      isValid = _useState4[0],
      setValid = _useState4[1];

  Object(external_React_["useEffect"])(function () {
    var val = isEmpty_default()(value) ? "" : map_default()(value, function (_) {
      return PasswordCharacterCode;
    }).join('');
    setPasswordValue(val);
    setValidity(val);
  }, []);

  var onValueChange = function onValueChange(event) {
    var value = event.target.value;
    setPasswordValue(value);
    setValidity(value);
    onChange(value);
  };

  var setValidity = function setValidity(value) {
    if (required) {
      return setValid(!isEmpty_default()(value));
    }

    return setValid(true);
  };

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "password-textarea-component"
  }, /*#__PURE__*/external_React_default.a.createElement("textarea", {
    className: classnames_default()('password-textarea', {
      'is-invalid': !isValid
    }),
    name: name,
    onChange: onValueChange,
    spellCheck: "false",
    value: passwordValue
  }));
};


// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/text-area-password/text-area-password-edit-mode.less
var text_area_password_edit_mode = __webpack_require__(297);
var text_area_password_edit_mode_default = /*#__PURE__*/__webpack_require__.n(text_area_password_edit_mode);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/text-area-password/text-area-password-edit-mode.less

            

var text_area_password_edit_mode_options = {};

text_area_password_edit_mode_options.insert = "head";
text_area_password_edit_mode_options.singleton = false;

var text_area_password_edit_mode_update = injectStylesIntoStyleTag_default()(text_area_password_edit_mode_default.a, text_area_password_edit_mode_options);



/* harmony default export */ var text_area_password_text_area_password_edit_mode = (text_area_password_edit_mode_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/text-area-password/TextAreaPasswordEditMode.js








var TextAreaPasswordEditMode_TextAreaPasswordEditMode = function TextAreaPasswordEditMode(_ref) {
  var name = _ref.name,
      onChange = _ref.onChange,
      _ref$readOnly = _ref.readOnly,
      readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
      _ref$required = _ref.required,
      required = _ref$required === void 0 ? false : _ref$required,
      value = _ref.value;

  var _useState = Object(external_React_["useState"])(false),
      _useState2 = slicedToArray_default()(_useState, 2),
      isEditMode = _useState2[0],
      setEditMode = _useState2[1];

  var _useState3 = Object(external_React_["useState"])(false),
      _useState4 = slicedToArray_default()(_useState3, 2),
      passwordValue = _useState4[0],
      setPasswordValue = _useState4[1];

  Object(external_React_["useEffect"])(function () {
    setPasswordValue(value);
  }, [value]);

  var save = function save() {
    onChange(passwordValue);
    setEditMode(false);
  };

  var cancel = function cancel() {
    setEditMode(false);
  };

  var isValid = function isValid() {
    if (required) {
      return !isEmpty_default()(passwordValue);
    }

    return true;
  };

  var notEditMode = function notEditMode() {
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      className: classnames_default()("display inline-textarea", {
        'is-invalid': !isValid()
      })
    }, /*#__PURE__*/external_React_default.a.createElement("span", {
      className: "text placeholder light-text"
    }, "Click on edit icon to modify the password"), /*#__PURE__*/external_React_default.a.createElement("i", {
      className: "xl-icon edit-icon",
      onClick: function onClick() {
        return setEditMode(true);
      }
    }));
  };

  var editMode = function editMode() {
    return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement(TextAreaPassword_TextAreaPassword, {
      name: name,
      onChange: setPasswordValue,
      required: required,
      value: passwordValue
    }), /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "text-area-password-action-buttons"
    }, /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "ok",
      onClick: save
    }, /*#__PURE__*/external_React_default.a.createElement("i", {
      className: "xl-icon check-icon"
    }), "Save"), /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "cancel",
      onClick: cancel
    }, /*#__PURE__*/external_React_default.a.createElement("i", {
      className: "xl-icon close-icon"
    }), "Cancel")));
  };

  var readOnlyMode = function readOnlyMode() {
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      className: "field-readonly read-only"
    }, /*#__PURE__*/external_React_default.a.createElement("span", {
      className: "light-text"
    }, isEmpty_default()(passwordValue) ? '' : '*****'));
  };

  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "text-area-password-edit-mode"
  }, readOnly ? readOnlyMode() : isEditMode ? editMode() : notEditMode());
};


// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/folder/folder-details.component.js


var folder_details_component_FolderDetails = function FolderDetails(_ref) {
  var header = _ref.header,
      content = _ref.content;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "folder-details"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "header"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "grey"
  }, header)), /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "content"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "content-inner"
  }, content)));
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/folder/folder-header.component.js



var folder_header_component_FolderHeader = function FolderHeader(_ref) {
  var filters = _ref.filters,
      actions = _ref.actions,
      documentationPage = _ref.documentationPage;
  return /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "header"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "grey"
  }, /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "container-fluid"
  }, filters && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "filters"
  }, filters), actions && /*#__PURE__*/external_React_default.a.createElement("div", {
    className: "buttons"
  }, actions), documentationPage && /*#__PURE__*/external_React_default.a.createElement(doc_link_component["a" /* DocLinkComponent */], {
    section: documentationPage
  }))));
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/confirmation-dialog/confirmation-dialog.component.js



var confirmation_dialog_component_ConfirmationDialog = function ConfirmationDialog(_ref) {
  var isOpen = _ref.isOpen,
      onConfirm = _ref.onConfirm,
      onCancel = _ref.onCancel,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'Confirm' : _ref$title,
      _ref$message = _ref.message,
      message = _ref$message === void 0 ? 'Please confirm the action' : _ref$message,
      _ref$confirmationLabe = _ref.confirmationLabel,
      confirmationLabel = _ref$confirmationLabe === void 0 ? 'OK' : _ref$confirmationLabe;
  var confirmationButton = {
    action: 'confirm',
    className: 'button primary',
    keyCodes: [13],
    label: confirmationLabel
  };
  var cancelButton = {
    action: 'cancel',
    className: 'button cancel',
    keyCodes: [27],
    label: 'Cancel'
  };

  var onButtonClick = function onButtonClick(action) {
    if (action === confirmationButton.action) {
      onConfirm();
    } else {
      onCancel();
    }
  };

  return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
    buttons: [confirmationButton, cancelButton],
    dialogClassName: "xl-default-modal",
    onButtonClick: onButtonClick,
    show: isOpen,
    title: title
  }, message);
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/toggle/toggle.component.js


var toggle_component_ToggleComponent = function ToggleComponent(_ref) {
  var checked = _ref.checked,
      _onChange = _ref.onChange;
  return /*#__PURE__*/external_React_default.a.createElement("label", {
    className: "xl-ui-switch"
  }, /*#__PURE__*/external_React_default.a.createElement("input", {
    checked: checked,
    onChange: function onChange(e) {
      return _onChange(e.target.checked);
    },
    type: "checkbox"
  }), /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "xl-ui-switch-slider round"
  }));
};
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/avatar/avatar.less
var avatar = __webpack_require__(298);
var avatar_default = /*#__PURE__*/__webpack_require__.n(avatar);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/avatar/avatar.less

            

var avatar_options = {};

avatar_options.insert = "head";
avatar_options.singleton = false;

var avatar_update = injectStylesIntoStyleTag_default()(avatar_default.a, avatar_options);



/* harmony default export */ var avatar_avatar = (avatar_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/avatar/avatar.component.js





var defaultColors = [{
  background: colors["a" /* default */].green,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].blue,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].orange,
  text: colors["a" /* default */].black
}, {
  background: colors["a" /* default */].purple,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].yellow,
  text: colors["a" /* default */].black
}, {
  background: colors["a" /* default */].red,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].antracite,
  text: colors["a" /* default */].white
}, {
  background: colors["a" /* default */].lightgray,
  text: colors["a" /* default */].black
}];
var avatar_component_AvatarComponent = function AvatarComponent(_ref) {
  var text = _ref.text,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title;

  var parsedText = function parsedText() {
    var textArray = text.split(' ');

    if (textArray.length > 1) {
      var firstInitial = textArray[0].slice(0, 1).toUpperCase();
      var secondInitial = textArray[1].slice(0, 1).toUpperCase();
      return "".concat(firstInitial).concat(secondInitial);
    } else {
      return text ? text.slice(0, 1).toUpperCase() : '';
    }
  }; // https://en.wikipedia.org/wiki/Linear_congruential_generator


  var stringAsciiPRNG = function stringAsciiPRNG(value, m) {
    // Xn+1 = (a * Xn + c) % m
    // 0 < a < m
    // 0 <= c < m
    // 0 <= X0 < m
    var charCodes = toConsumableArray_default()(value).map(function (letter) {
      return letter.charCodeAt(0);
    });

    var len = charCodes.length;
    var a = len % (m - 1) + 1;
    var c = charCodes.reduce(function (current, next) {
      return current + next;
    }) % m;
    var random = charCodes[0] % m;

    for (var i = 0; i < len; i++) {
      random = (a * random + c) % m;
    }

    return random;
  };

  var getRandomColor = function getRandomColor(value) {
    if (!value) return {
      background: 'transparent',
      color: 'transparent'
    };
    var colorIndex = stringAsciiPRNG(value, defaultColors.length);
    return defaultColors[colorIndex];
  };

  return /*#__PURE__*/external_React_default.a.createElement("span", {
    className: "avatar",
    style: {
      background: getRandomColor(text).background,
      color: getRandomColor(text).text
    },
    title: title
  }, parsedText());
};
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/index.js






























/***/ }),

/***/ 26:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return getAngularService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return asyncGetAngularService; });
function getAngularService(name) {
  return angular.element(document.body).injector().get(name);
}
function asyncGetAngularService(name) {
  var service = getAngularService(name);
  return Promise.resolve(service);
}

/***/ }),

/***/ 269:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DocLinkComponent; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(0);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);


var DocLinkComponent = function DocLinkComponent(_ref) {
  var section = _ref.section;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("a", {
    className: "xl-icon qmark-icon doc-icon",
    href: "https://docs.xebialabs.com/xl-release/help/".concat(section),
    rel: "noopener noreferrer",
    target: "_blank",
    title: "Open documentation page related to this page in a new browser tab"
  });
};

/***/ }),

/***/ 270:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ infinite_list_component_InfiniteListComponent; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/lodash/noop.js
var noop = __webpack_require__(77);
var noop_default = /*#__PURE__*/__webpack_require__.n(noop);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/constants.js

var OrderConst = {
  SORT_ASC: 'asc',
  SORT_DESC: 'desc'
};
var Column = prop_types_default.a.shape({
  class: prop_types_default.a.string,
  propertyName: prop_types_default.a.string.isRequired,
  label: prop_types_default.a.string.isRequired,
  sortable: prop_types_default.a.bool.isRequired
});
var OrderBy = prop_types_default.a.shape({
  propertyName: prop_types_default.a.string.isRequired,
  direction: prop_types_default.a.oneOf([OrderConst.SORT_DESC, OrderConst.SORT_ASC])
});
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(12);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/extends.js
var helpers_extends = __webpack_require__(54);
var extends_default = /*#__PURE__*/__webpack_require__.n(helpers_extends);

// EXTERNAL MODULE: ./node_modules/lodash/omit.js
var omit = __webpack_require__(526);
var omit_default = /*#__PURE__*/__webpack_require__.n(omit);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/checkbox/checkbox.component.js








function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }




var checkbox_component_Checkbox = /*#__PURE__*/function (_Component) {
  inherits_default()(Checkbox, _Component);

  var _super = _createSuper(Checkbox);

  function Checkbox(props) {
    var _this;

    classCallCheck_default()(this, Checkbox);

    _this = _super.call(this, props);
    _this.checkboxRef = /*#__PURE__*/external_React_default.a.createRef();
    return _this;
  }

  createClass_default()(Checkbox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateIndeterminateFlag();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.isIndeterminate !== this.props.isIndeterminate) {
        this.updateIndeterminateFlag();
      }
    }
  }, {
    key: "updateIndeterminateFlag",
    value: function updateIndeterminateFlag() {
      this.checkboxRef.current.indeterminate = this.props.isIndeterminate;
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("input", extends_default()({}, omit_default()(this.props, 'isIndeterminate'), {
        ref: this.checkboxRef,
        type: "checkbox"
      }));
    }
  }]);

  return Checkbox;
}(external_React_["Component"]);

defineProperty_default()(checkbox_component_Checkbox, "defaultProps", {
  isIndeterminate: false
});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list-header.component.js






function infinite_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = infinite_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function infinite_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var infinite_list_header_component_InfiniteListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(InfiniteListHeaderComponent, _Component);

  var _super = infinite_list_header_component_createSuper(InfiniteListHeaderComponent);

  function InfiniteListHeaderComponent() {
    classCallCheck_default()(this, InfiniteListHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(InfiniteListHeaderComponent, [{
    key: "getNextDirection",
    value: function getNextDirection(propertyName) {
      var orderBy = this.props.orderBy;

      if (orderBy.propertyName !== propertyName) {
        return OrderConst.SORT_DESC;
      } else {
        return orderBy.direction === OrderConst.SORT_DESC ? OrderConst.SORT_ASC : OrderConst.SORT_DESC;
      }
    }
  }, {
    key: "onChangeOrder",
    value: function onChangeOrder(column) {
      this.props.onChangeOrder(column.propertyName, this.getNextDirection(column.propertyName));
    }
  }, {
    key: "renderOrderIcon",
    value: function renderOrderIcon() {
      var orderBy = this.props.orderBy;
      var orderedColumnClassNames = classnames_default()('xl-icon icon-s', {
        'arrow-up-icon': orderBy.direction === OrderConst.SORT_ASC,
        'arrow-down-icon': orderBy.direction === OrderConst.SORT_DESC
      });
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "order-icons"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: orderedColumnClassNames
      }));
    }
  }, {
    key: "renderDefaultIcon",
    value: function renderDefaultIcon() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "order-icons order-default"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon icon-s arrow-up-icon"
      }), /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon icon-s arrow-down-icon"
      }));
    }
  }, {
    key: "renderHeaderCell",
    value: function renderHeaderCell(column) {
      var _this = this;

      var orderBy = this.props.orderBy;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()("list-row-cell ".concat(column.class), {
          'sortable': column.sortable
        }),
        key: column.propertyName,
        onClick: function onClick() {
          return column.sortable && _this.onChangeOrder(column);
        }
      }, column.label, column.sortable && orderBy && (column.propertyName === orderBy.propertyName ? this.renderOrderIcon() : this.renderDefaultIcon()));
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          columns = _this$props.columns,
          toggleSelectAll = _this$props.toggleSelectAll,
          rows = _this$props.rows,
          selectedRows = _this$props.selectedRows;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "list-header"
      }, /*#__PURE__*/external_React_default.a.createElement(checkbox_component_Checkbox, {
        checked: rows.length === selectedRows.length,
        isIndeterminate: selectedRows.length > 0 && selectedRows.length < rows.length,
        onChange: toggleSelectAll
      }), columns.map(function (column) {
        return _this2.renderHeaderCell(column);
      }));
    }
  }]);

  return InfiniteListHeaderComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list-body.component.js








function infinite_list_body_component_createSuper(Derived) { var hasNativeReflectConstruct = infinite_list_body_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function infinite_list_body_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }



var infinite_list_body_component_InfiniteListBodyComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(InfiniteListBodyComponent, _Component);

  var _super = infinite_list_body_component_createSuper(InfiniteListBodyComponent);

  function InfiniteListBodyComponent(props) {
    var _this;

    classCallCheck_default()(this, InfiniteListBodyComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "loadMore", function () {
      var rowsRef = _this.rowsRef.current;

      if (rowsRef.scrollTop + rowsRef.clientHeight >= rowsRef.scrollHeight) {
        _this.props.loadMore();
      }
    });

    _this.rowsRef = /*#__PURE__*/external_React_default.a.createRef();
    return _this;
  }

  createClass_default()(InfiniteListBodyComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.rowsRef.current.addEventListener('scroll', this.loadMore);
      this.loadMore();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.rowsRef.current.removeEventListener('scroll', this.loadMore);
    }
  }, {
    key: "renderRow",
    value: function renderRow(row) {
      var _this2 = this;

      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "list-row-view-container",
        key: row.id
      }, /*#__PURE__*/external_React_default.a.createElement("input", {
        checked: this.props.selectedRows.includes(row.id),
        onChange: function onChange() {
          return _this2.props.toggleSelectedRows([row]);
        },
        type: "checkbox"
      }), this.props.renderRow(row));
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          rows = _this$props.rows,
          onScrollList = _this$props.onScrollList;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "list-view-rows",
        onScroll: onScrollList,
        ref: this.rowsRef
      }, rows.map(function (row) {
        return _this3.renderRow(row);
      }));
    }
  }]);

  return InfiniteListBodyComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.less
var infinite_list_component = __webpack_require__(291);
var infinite_list_component_default = /*#__PURE__*/__webpack_require__.n(infinite_list_component);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(infinite_list_component_default.a, options);



/* harmony default export */ var infinite_list_infinite_list_component = (infinite_list_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/infinite-list/infinite-list.component.js







function infinite_list_component_createSuper(Derived) { var hasNativeReflectConstruct = infinite_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function infinite_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }









var infinite_list_component_InfiniteListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(InfiniteListComponent, _Component);

  var _super = infinite_list_component_createSuper(InfiniteListComponent);

  function InfiniteListComponent() {
    classCallCheck_default()(this, InfiniteListComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(InfiniteListComponent, [{
    key: "renderSpinner",
    value: function renderSpinner() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "spinner"
      }, /*#__PURE__*/external_React_default.a.createElement("img", {
        alt: "Loading...",
        src: "static/10.2.6/styles/img/big-ajax-loader.gif"
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          loading = _this$props.loading,
          columns = _this$props.columns,
          onChangeOrder = _this$props.onChangeOrder,
          onScrollList = _this$props.onScrollList,
          rows = _this$props.rows,
          noData = _this$props.noData,
          renderRow = _this$props.renderRow,
          listTitle = _this$props.listTitle,
          loadMore = _this$props.loadMore,
          orderBy = _this$props.orderBy,
          toggleSelectedRows = _this$props.toggleSelectedRows,
          toggleSelectAll = _this$props.toggleSelectAll,
          selectedRows = _this$props.selectedRows;
      var hasRows = !!rows.length;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('infinite-list-container list-view', {
          'infinite-list-loading': loading
        })
      }, /*#__PURE__*/external_React_default.a.createElement("h4", {
        className: "list-view-title"
      }, listTitle), hasRows && /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement(infinite_list_header_component_InfiniteListHeaderComponent, {
        columns: columns,
        onChangeOrder: onChangeOrder,
        orderBy: orderBy,
        rows: rows,
        selectedRows: selectedRows,
        toggleSelectAll: toggleSelectAll
      }), /*#__PURE__*/external_React_default.a.createElement(infinite_list_body_component_InfiniteListBodyComponent, {
        loadMore: loadMore,
        onScrollList: onScrollList,
        renderRow: renderRow,
        rows: rows,
        selectedRows: selectedRows,
        toggleSelectedRows: toggleSelectedRows
      }), loading && this.renderSpinner()), !hasRows && loading && this.renderSpinner(), !hasRows && !loading && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "list-view-no-data alert notice"
      }, noData));
    }
  }]);

  return InfiniteListComponent;
}(external_React_["Component"]);

defineProperty_default()(infinite_list_component_InfiniteListComponent, "defaultProps", {
  onScrollList: function onScrollList() {
    return noop_default()();
  }
});

/***/ }),

/***/ 271:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Backend; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38);
/* harmony import */ var angular__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(angular__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(78);
/* harmony import */ var ngimport__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(ngimport__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _xlrelease__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(167);






var Backend;

var BackendServiceImpl = /*#__PURE__*/function () {
  function BackendServiceImpl() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, BackendServiceImpl);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(BackendServiceImpl, [{
    key: "post",
    value: function post(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].post(url, data, config);
    }
  }, {
    key: "get",
    value: function get(url, config) {
      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].get(url, this._extendWithVersion(this._extendWithCacheBuster(config)));
    }
  }, {
    key: "put",
    value: function put(url, data, config) {
      if (Object(angular__WEBPACK_IMPORTED_MODULE_3__["isUndefined"])(data)) {
        data = {};
      }

      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].put(url, data, this._extendWithVersion(config));
    }
  }, {
    key: "del",
    value: function del(url, config) {
      var extendedConfig = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, BackendServiceImpl.DELETE_CONFIG, config);
      extendedConfig.url = url;
      return ngimport__WEBPACK_IMPORTED_MODULE_4__["$http"].delete(url, this._extendWithVersion(extendedConfig));
    } // overridden in unit tests

  }, {
    key: "_extendWithCacheBuster",
    value: function _extendWithCacheBuster(config) {
      var cacheBuster = {
        cb: new Date().getTime()
      };
      return this.addParams(config, cacheBuster);
    }
  }, {
    key: "_extendWithVersion",
    value: function _extendWithVersion(config) {
      var version = {
        xlrv: _xlrelease__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"].version
      };
      return this.addParams(config, version);
    }
  }, {
    key: "addParams",
    value: function addParams(config, params) {
      var extendedConfig = config ? Object(angular__WEBPACK_IMPORTED_MODULE_3__["copy"])(config) : {};
      extendedConfig.params = Object(angular__WEBPACK_IMPORTED_MODULE_3__["extend"])({}, extendedConfig.params || {}, params);
      return extendedConfig;
    }
  }]);

  return BackendServiceImpl;
}();

_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_2___default()(BackendServiceImpl, "DELETE_CONFIG", {
  method: 'DELETE',
  // IE 8 do not support $http.delete()
  data: null,
  // Without data, Content-Type is deleted
  headers: {
    'Content-Type': 'application/json' // Without Content-Type, Browser's default Content-Type is used

  }
});

Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').service('Backend', BackendServiceImpl);
Object(angular__WEBPACK_IMPORTED_MODULE_3__["module"])('xlrelease').run(function () {
  return Backend = ngimport__WEBPACK_IMPORTED_MODULE_4__["$injector"].get('Backend');
});

/***/ }),

/***/ 274:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DateServiceFactory; });
/* harmony import */ var _releases_list_releases_status_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(107);
/* harmony import */ var _global_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45);


var ReleasesStatusService = Object(_releases_list_releases_status_service__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])();
DateServiceFactory.$inject = ['$filter'];
function DateServiceFactory($filter) {
  return {
    getMoment: function getMoment(dateString) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].ISODateTime;
      return moment(dateString, dateFormat);
    },
    isOverdue: function isOverdue(date) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].unixMillisecondTimestamp;
      if (!date) return false;
      return moment(date, dateFormat).isBefore();
    },
    getOverdueTooltipMessage: function getOverdueTooltipMessage(dueDate, endDate) {
      var compareDate = !!endDate ? moment(endDate) : moment();
      var overdueDuration = moment.duration(compareDate.diff(moment(dueDate)));

      if (overdueDuration.asSeconds() > 60) {
        return "Overdue: ".concat($filter('prettyDuration')(overdueDuration));
      } else {
        return "Overdue: ' ".concat($filter('prettyDuration')(moment.duration(1, 'minutes')));
      }
    },
    getToday: function getToday() {
      return this.atMidnight(moment());
    },
    getTodayWithTime: function getTodayWithTime() {
      return moment().seconds(0).milliseconds(0);
    },
    atMidnight: function atMidnight(date) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].ISODateTime;
      return moment(moment(date, dateFormat).hours(0).minutes(0).seconds(0).milliseconds(0).format());
    },
    getDateStatus: function getDateStatus(currentDay) {
      if (currentDay.isBefore(this.getToday())) {
        return 'past';
      } else if (currentDay.isAfter(this.getToday())) {
        return 'future';
      } else {
        return 'today';
      }
    },
    getStartOrScheduledDate: function getStartOrScheduledDate(planItem) {
      return planItem.startDate || planItem.scheduledStartDate;
    },
    getEndOrDueDate: function getEndOrDueDate(planItem) {
      var date = planItem.endDate || planItem.dueDate;

      if (date && planItem.type === "xlrelease.Release" && ReleasesStatusService.isReleaseInProgress(planItem)) {
        date = Math.max(date, this.getTodayWithTime().valueOf());
      }

      return date;
    },
    getDuration: function getDuration(startDate, endDate) {
      var start = this.getMoment(startDate);
      var end = this.getMoment(endDate);
      var diff = end.diff(start);

      if (diff > 0) {
        var duration = moment.duration(diff);

        if (duration.asMinutes() < 1) {
          return '1m';
        }

        return duration.format('d[d] h[h] m[m]');
      }
    },
    getRemainingDuration: function getRemainingDuration(endDate) {
      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].ISODateTime;
      var currentDate = moment(this.getTodayWithTime());
      var end = this.getMoment(endDate, dateFormat);
      var diff = end.diff(currentDate);
      var duration = moment.duration(diff);

      if (duration.asMinutes() < 1 && duration.asMinutes() >= -1) {
        return "1m";
      } else if (duration.asMinutes() < -1) {
        var displayDate = duration.format('d[d] h[h] m[m]');
        displayDate = displayDate.substr(1, displayDate.length);
        return "Overdue " + displayDate;
      }

      return duration.format('d[d] h[h] m[m]');
    },
    getOverdueDuration: function getOverdueDuration(actualDate, expectedDate) {
      var dateFormat = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _global_constants__WEBPACK_IMPORTED_MODULE_1__[/* dateTimeFormat */ "a"].unixMillisecondTimestamp;
      var duration = moment.duration(this.getMoment(actualDate, dateFormat).diff(this.getMoment(expectedDate, dateFormat)));

      if (!duration.isValid() || duration.asSeconds() <= 0) {
        return '';
      }

      if (duration.asMinutes() < 1) {
        return "(1m overdue)";
      }

      return "(".concat(duration.format('d[d] h[h] m[m]'), " overdue)");
    },
    getReportDuration: function getReportDuration(durationInMs) {
      var duration = moment.duration(durationInMs);
      return duration < moment.duration(1, 'days').asMilliseconds() ? duration.format('d[d] h[h] m[m] s[s]') : duration.format('d[d] h[h] m[m]');
    },
    checkDatesValidator: function checkDatesValidator(form) {
      return function () {
        if (form) {
          var dueDate = form.dueDate;
          var scheduledStartDate = form.scheduledStartDate;

          if (dueDate && scheduledStartDate) {
            form.hasValidDates = scheduledStartDate <= dueDate;
          }
        }
      };
    }
  };
}

/***/ }),

/***/ 2745:
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(3025);
__webpack_require__(3031);
__webpack_require__(3019);
__webpack_require__(3021);
__webpack_require__(3014);
__webpack_require__(3013);
__webpack_require__(3022);
__webpack_require__(3017);
__webpack_require__(3024);
__webpack_require__(3018);
__webpack_require__(3016);
__webpack_require__(3035);
__webpack_require__(3027);
__webpack_require__(3033);
module.exports = __webpack_require__(3034);


/***/ }),

/***/ 2752:
/***/ (function(module, exports) {

angular.module('xlrelease.dashboard', ['gridster', 'ui.router', 'mgcrea.ngStrap']).config(['$stateProvider', '$urlMatcherFactoryProvider', function ($stateProvider, $urlMatcherFactoryProvider) {
  $urlMatcherFactoryProvider.type('DashboardId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Applications\/Dashboard\w+/
  });
  $urlMatcherFactoryProvider.type('TileId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Applications\/Dashboard\w+\/Tile\w+/
  });
  $stateProvider.state('defaultDashboard', {
    url: '/dashboards',
    template: '<xlr-dashboard-placeholder sub-menu-items="subMenuItems"></xlr-dashboard-placeholder>'
  }).state('dashboards', {
    url: '/dashboards/{dashboardId: DashboardId}?dashboardMode&{refresh:bool}',
    template: '<div xlr-dashboard></div>'
  }).state('folderDashboards', {
    url: '/folders-dashboards/{dashboardId: DashboardId}?dashboardMode&folderId&{refresh:bool}',
    template: '<div xlr-dashboard></div>'
  }).state('folderDashboardsNew', {
    url: '/folders-dashboards/new?folderId',
    template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
  }).state('globalDashboardNew', {
    url: '/dashboards/new',
    template: '<xlr-add-dashboard-page></xlr-add-dashboard-page>'
  }).state('globalDashboardDetails', {
    url: '/dashboards/{tileId: TileId}/details?view',
    reloadOnSearch: true,
    templateUrl: 'static/10.2.6/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService) {
        return XlrDashboardService.loadTile($stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: [_.noop]
    }
  }).state('folderDashboardDetails', {
    url: '/folders-dashboards/{tileId: TileId}/details?view',
    reloadOnSearch: true,
    templateUrl: 'static/10.2.6/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', function ($stateParams, XlrDashboardService) {
        return XlrDashboardService.loadTile($stateParams.tileId);
      }],
      dashboardPromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadConfiguration(Ids.getParentId($stateParams.tileId));
      }],
      releasePromise: [_.noop]
    }
  }).state('releasesDashboard', {
    url: '/releases/:releaseId/summary/:tileId/details',
    templateUrl: 'static/10.2.6/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  }).state('templatesDashboard', {
    url: '/templates/:releaseId/summary/:tileId/details',
    templateUrl: 'static/10.2.6/include/DashboardPage/xlr-dashboard-details-mode.html',
    controller: 'xlrelease.dashboard.XlrTileDetailsController',
    controllerAs: 'xlrTileDetailsCtrl',
    resolve: {
      tilePromise: ['$stateParams', 'xlrelease.XlrDashboardService', 'Ids', function ($stateParams, XlrDashboardService, Ids) {
        return XlrDashboardService.loadTile(Ids.toDomainId($stateParams.releaseId) + '/summary/' + $stateParams.tileId);
      }],
      dashboardPromise: [_.noop],
      releasePromise: ['$stateParams', 'ReleasesService', function ($stateParams, ReleasesService) {
        return ReleasesService.getReleaseWithDependencies($stateParams.releaseId);
      }]
    }
  });
}]);
angular.module('xlrelease.dashboard').factory('xlrDashboardConfigProvider', function () {
  return {
    getPlaceholderProperties: function getPlaceholderProperties() {
      return {
        draggable: {
          enabled: false
        },
        resizable: {
          enabled: false
        }
      };
    },
    getConfig: function getConfig(designMode, changeCallback) {
      return {
        minSizeY: 1,
        minSizeX: 1,
        defaultSizeX: 1,
        defaultSizeY: 1,
        pushing: true,
        floating: true,
        // whether to automatically float items up so they stack (you can temporarily disable if you are adding unsorted items with ng-repeat)
        swapping: true,
        // whether or not to have items of the same size switch places instead of pushing down if they are the same size
        colWidth: 'auto',
        minRows: 1,
        rowHeight: 290,
        margins: [10, 10],
        mobileBreakPoint: 60,
        resizable: {
          enabled: designMode,
          handles: ['n', 'e', 's', 'w', 'ne', 'se', 'sw', 'nw'],
          start: function start(event, $element) {
            $element.addClass('dashboard-resizing');
          },
          stop: function stop(event, $element) {
            $element.removeClass('dashboard-resizing');
            changeCallback();
          }
        },
        draggable: {
          enabled: designMode,
          handle: '.xlr-tile-drag-handle',
          stop: function stop() {
            return changeCallback();
          }
        }
      };
    }
  };
});
angular.module('xlrelease').run(['MenuItemsProviderRegistry', 'Backend', '$state', function (MenuItemsProviderRegistry, Backend, $state) {
  MenuItemsProviderRegistry.addProvider('xlrelease.dashboard.provider', function () {
    return Backend.get('dashboards').then(function (resp) {
      var dashboards = resp.data.map(function (dashboard) {
        return {
          label: dashboard.title,
          pathSuffix: "dashboards/".concat(dashboard.id),
          permitted: true
        };
      });

      if ($state.is('globalDashboardNew')) {
        dashboards.push({
          label: 'New dashboard',
          pathSuffix: "dashboards/new",
          permitted: true
        });
      }

      return dashboards;
    });
  });
}]);

/***/ }),

/***/ 2753:
/***/ (function(module, exports) {

var XlrTileTitle = function XlrTileTitle() {
  return {
    restrict: 'A',
    require: ['^xlrTile'],
    transclude: true,
    link: function link(scope, elem, attr, ctrls, transclude) {
      _.head(ctrls).setTitle(transclude);
    }
  };
};

angular.module('xlrelease.dashboard').directive('xlrTileTitle', XlrTileTitle);

/***/ }),

/***/ 276:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony default export */ __webpack_exports__["a"] = ("<div class=\"item-count-tooltip tooltip in\">\n    <div class=\"tooltip-arrow\"></div>\n    <div class=\"tooltip-inner\">\n        <div ng-init=\"live = $ctrl.itemsCount.live.byStatus\">\n            <p ng-if=\"live.PLANNED > 0\">\n                <i class=\"circle planned\"></i>\n                {{live.PLANNED}} Planned\n            </p>\n            <p ng-if=\"live.IN_PROGRESS > 0\">\n                <i class=\"circle in-progress\"></i>\n                {{live.IN_PROGRESS}} In progress\n            </p>\n            <p ng-if=\"live.QUEUED > 0\">\n                <i class=\"circle queued\"></i>\n                {{live.QUEUED}} Queued\n            </p>\n            <p ng-if=\"live.PAUSED > 0\">\n                <i class=\"circle paused\"></i>\n                {{live.PAUSED}} Paused\n            </p>\n            <p ng-if=\"live.FAILED > 0\">\n                <i class=\"circle failed\"></i>\n                {{live.FAILED}} Failed\n            </p>\n            <p ng-if=\"live.FAILING > 0\">\n                <i class=\"circle failing\"></i>\n                {{live.FAILING}} Failing\n            </p>\n            <p ng-if=\"live.COMPLETED > 0\">\n                <i class=\"circle completed\"></i>\n                {{live.COMPLETED}} Completed\n            </p>\n            <p ng-if=\"live.ABORTED > 0\">\n                <i class=\"circle aborted\"></i>\n                {{live.ABORTED}} Aborted\n            </p>\n        </div>\n        <div ng-init=\"archived = $ctrl.itemsCount.archived.byStatus\">\n            <hr ng-if=\"$ctrl.itemsCount.live.total > 0 && $ctrl.itemsCount.archived.total > 0\"/>\n            <p ng-if=\"$ctrl.itemsCount.archived.total > 0\">\n                <i class=\"xl-icon archive-icon\"></i> Archived\n            </p>\n            <p ng-if=\"archived.COMPLETED > 0\">\n                <i class=\"circle completed\"></i>\n                {{archived.COMPLETED}} Completed\n            </p>\n            <p ng-if=\"archived.ABORTED > 0\">\n                <i class=\"circle aborted\"></i>\n                {{archived.ABORTED}} Aborted\n            </p>\n        </div>\n    </div>\n</div>\n");

/***/ }),

/***/ 277:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return releaseStatusLabelComponent; });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4);
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__);


var HTML = "<div class=\"release-status\">\n    <span class=\"label label-{{$ctrl.getClassSuffix()}}\">{{$ctrl.getLabel()}}</span>\n    <span ng-if=\"$ctrl.isArchived()\" class=\"label label-archived\">Archived</span>\n</div>";

var ReleaseStatusLabelController = /*#__PURE__*/function () {
  function ReleaseStatusLabelController() {
    _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0___default()(this, ReleaseStatusLabelController);
  }

  _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1___default()(ReleaseStatusLabelController, [{
    key: "$onInit",
    value: function $onInit() {
      this._mapping = {
        'IN_PROGRESS': {
          suffix: 'inprogress',
          label: 'In progress'
        },
        'FAILING': {
          suffix: 'warning-failing',
          label: 'Failing'
        },
        'PAUSED': {
          suffix: 'paused',
          label: 'Paused'
        },
        'FAILED': {
          suffix: 'warning-failed',
          label: 'Failed'
        },
        'PLANNED': {
          suffix: 'planned',
          label: 'Planned'
        },
        'ABORTED': {
          suffix: 'aborted',
          label: 'Aborted'
        },
        'COMPLETED': {
          suffix: 'completed',
          label: 'Completed'
        }
      };
    }
  }, {
    key: "getClassSuffix",
    value: function getClassSuffix() {
      return this._mapping[this.release.status].suffix;
    }
  }, {
    key: "getLabel",
    value: function getLabel() {
      return this._mapping[this.release.status].label;
    }
  }, {
    key: "isArchived",
    value: function isArchived() {
      return this.showArchived && this.release && this.release.archived;
    }
  }]);

  return ReleaseStatusLabelController;
}();

ReleaseStatusLabelController.$inject = [];
var releaseStatusLabelComponent = {
  controller: ReleaseStatusLabelController,
  template: HTML,
  bindings: {
    release: '<',
    showArchived: '<'
  }
};

/***/ }),

/***/ 278:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return loadUsernames; });
/* harmony import */ var _http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16);

function loadUsernames(release) {
  return Object(_http__WEBPACK_IMPORTED_MODULE_0__[/* httpGET */ "c"])('users/names').then(function (resp) {
    return resp.data;
  });
}

/***/ }),

/***/ 279:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ compositeFilterComponent; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter.html
/* harmony default export */ var composite_filter = ("<div ng-if=\"$ctrl.isLoading\" class=\"spinner\" style=\"text-align: center\">\n    <img src=\"static/10.2.6/styles/img/big-ajax-loader.gif\" alt=\"Loading...\"/>\n</div>\n<div ng-if=\"!$ctrl.isLoading\" class=\"filter-container\">\n    <div ng-repeat=\"filter in $ctrl.filters\">\n        <p data-ng-if=\"$index > 0\">AND</p>\n        <div class=\"composite-filter\">\n            <select class=\"filter-type-select\"\n                    name=\"filter-type-select\"\n                    ng-model=\"filter.type\"\n                    ng-change=\"$ctrl.onFilterTypeChange(filter)\"\n            >\n                <option value=\"\">Select filter</option>\n                <option ng-repeat=\"availableType in $ctrl.availableTypes\" value=\"{{availableType}}\">{{$ctrl.getFilterByType(availableType).title}}</option>\n            </select>\n            <div ng-if=\"filter.type\">\n                <select ng-model=\"filter.operator\"\n                        ng-change=\"$ctrl.onOperatorChange()\"\n                        class=\"filter-operator-select\">\n                    <option ng-repeat=\"operator in $ctrl.getOperators(filter.type)\" value=\"{{operator.value}}\">{{operator.title}}</option>\n                </select>\n                <div ng-if=\"$ctrl.isFilterTagsInput(filter.type)\" ng-init=\"$ctrl.setFocus()\"\n                     name=\"tags\"\n                     class=\"transparent filter\"\n                     filter-tag-input\n                     placeholder=\"Add more...\"\n                     on-change=\"$ctrl.onFilterChange(tags, filter)\"\n                     tags=\"filter.values\"\n                     completion-candidates=\"$ctrl.getAutoCompleteCandidates(filter.type)\">\n                </div>\n                <div ng-if=\"!$ctrl.isFilterTagsInput(filter.type)\" ng-init=\"$ctrl.setFocus()\"\n                     name=\"tags\"\n                     class=\"transparent filter\"\n                     tags-input\n                     placeholder=\"Add more...\"\n                     on-change=\"$ctrl.onFilterChange(tags, filter)\"\n                     tags=\"filter.values\"\n                     completion-candidates=\"$ctrl.getAutoCompleteCandidates(filter.type)\">\n                </div>\n            </div>\n            <button class=\"filter-remove-btn button\"\n                    ng-click=\"$ctrl.onRemoveFilterClick($index)\"\n                    type=\"button\"\n            ><i class=\"xl-icon delete-icon\"></i></button>\n        </div>\n    </div>\n    <div class=\"horizontal\">\n        <button class=\"filter-add-btn button\"\n                ng-click=\"$ctrl.onAddFilterClick()\"\n                type=\"button\">\n            <i class=\"xl-icon add-icon\"></i>Add filter\n        </button>\n        <button class=\"filter-add-btn button\" ng-click=\"$ctrl.clearAllFilters()\"><i class=\"xl-icon close-icon\"></i>Clear all</button>\n    </div>\n</div>\n");
// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter.less
var composite_filter_composite_filter = __webpack_require__(299);
var composite_filter_default = /*#__PURE__*/__webpack_require__.n(composite_filter_composite_filter);

// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter.less

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = injectStylesIntoStyleTag_default()(composite_filter_default.a, options);



/* harmony default export */ var filter_component_composite_filter_composite_filter = (composite_filter_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/xlr-components/filter-component/composite-filter/composite-filter-component.js






var composite_filter_component_CompositeFilterController = /*#__PURE__*/function () {
  function CompositeFilterController($element, CompositeFilterService) {
    classCallCheck_default()(this, CompositeFilterController);

    this.$element = $element;
    this.CompositeFilterService = CompositeFilterService;
  }

  createClass_default()(CompositeFilterController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.isLoading = true;
      this.CompositeFilterService.loadCandidates(this.availableTypes, true).then(function () {
        _this.isLoading = false;
        _this.filters = _this.getStoredFilters();
      }).catch(function () {
        return _this.isLoading = false;
      });
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      var storedFilters = changes.storedFilters;

      if (_.get(storedFilters, ['storedFilters', 'currentValue', 'length'])) {
        this.filters = this.getStoredFilters();
      }
    }
  }, {
    key: "getFilterByType",
    value: function getFilterByType(type) {
      return this.CompositeFilterService.getFilter(type);
    }
  }, {
    key: "isFilterTagsInput",
    value: function isFilterTagsInput(type) {
      return this.getFilterByType(type).filterTag;
    }
  }, {
    key: "getOperators",
    value: function getOperators(type) {
      return this.getFilterByType(type).operators;
    }
  }, {
    key: "getAutoCompleteCandidates",
    value: function getAutoCompleteCandidates(type) {
      return this.getFilterByType(type).loadedAutocompleteCandidates;
    }
  }, {
    key: "setFocus",
    value: function setFocus() {
      this.$element.find('.filter input').focus();
    }
  }, {
    key: "onAddFilterClick",
    value: function onAddFilterClick() {
      var _this2 = this;

      this.filters.push({
        type: null,
        operator: null,
        values: []
      }); // run the scroll after next angularjs render as the filters will be on screen

      setTimeout(function () {
        return _this2.$element.scrollParent().animate({
          scrollTop: 300 * _this2.filters.length
        }, 0);
      }, 0);
    }
  }, {
    key: "onRemoveFilterClick",
    value: function onRemoveFilterClick(index) {
      if (index !== null && angular.isDefined(index)) {
        if (index !== -1) {
          this.filters.splice(index, 1);
          this.triggerOnChange(this.filters.filter(function (f) {
            return f.type && f.values && f.values.length;
          }));
        }
      }
    }
  }, {
    key: "onOperatorChange",
    value: function onOperatorChange() {
      this.triggerOnChange(this.filters);
    }
  }, {
    key: "onFilterChange",
    value: function onFilterChange(tags, filter) {
      if (filter) {
        filter.values = tags;
      }

      this.triggerOnChange(this.filters.filter(function (f) {
        return f.type && f.values && f.values.length;
      }));
    }
  }, {
    key: "triggerOnChange",
    value: function triggerOnChange(filters) {
      this.onChange({
        filters: this.CompositeFilterService.convertToStored(filters)
      });
    }
  }, {
    key: "onFilterTypeChange",
    value: function onFilterTypeChange(filter) {
      filter.values = [];
      filter.operator = filter.type === 'xlrelease.TagsFilter' ? 'CONTAINS_ALL' : 'OR';
    }
  }, {
    key: "getStoredFilters",
    value: function getStoredFilters() {
      return this.CompositeFilterService.convertFromStored(this.storedFilters, this.availableTypes);
    }
  }, {
    key: "clearAllFilters",
    value: function clearAllFilters() {
      this.filters.length = 0;
      this.onChange({
        filters: this.CompositeFilterService.convertToStored(this.filters),
        isEmpty: true
      });
    }
  }]);

  return CompositeFilterController;
}();

defineProperty_default()(composite_filter_component_CompositeFilterController, "$inject", ['$element', 'CompositeFilterService']);

var compositeFilterComponent = {
  bindings: {
    storedFilters: '<',
    availableTypes: '<',
    onChange: '<'
  },
  controller: composite_filter_component_CompositeFilterController,
  template: composite_filter
};

/***/ }),

/***/ 281:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 282:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 283:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 284:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 285:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 286:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 287:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 288:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 289:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 290:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 291:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 292:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 293:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 294:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 295:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 296:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 297:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 298:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 299:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 300:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 3003:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('donutChart', ['reportConfigurationService', 'Events', function (reportConfigurationService, Events) {
  return {
    scope: {
      data: '=',
      options: '='
      /*
      topTitleText: Text/Function(scope.data)
      bottomTitleText: Text/Function(scope.data)
      series: Function(scope.data) => [{name: 'Tasks', data: [...]}]
      showLegend: true/false
      donutThickness: 70%
      */

    },
    link: function link(scope, element) {
      var chart = [];

      function addTitle() {
        if (this.title) {
          this.title.destroy();
        } // store chart so we can trigger when draw when the file finished resizing


        chart = this;
        var r = this.renderer,
            x = this.series[0].center[0] + this.plotLeft,
            y = this.series[0].center[1] + this.plotTop;
        var topTitleText = applyOrGet(scope.options.topTitleText, scope.data);
        var bottomTitleText = applyOrGet(scope.options.bottomTitleText, scope.data);
        var titleHtml = "<div><span>" + topTitleText + "</span><br><span>" + bottomTitleText + "</span></div>";
        this.title = r.label(titleHtml, x - 53, y - 12, 'rect', 0, 0, true, true, 'two-part-title').add();
        chart.container.onclick = null;
      }

      function applyOrGet(textOrFunction, args) {
        return angular.isFunction(textOrFunction) ? textOrFunction(args) : "" + textOrFunction;
      }

      var series = scope.options.series(scope.data);
      series.forEach(function (serie) {
        serie.type = 'pie';
        serie.dataLabels = {
          enabled: false
        };
      });
      element.highcharts(reportConfigurationService.getHighchartsOptions({
        tooltip: {
          hideDelay: 0
        },
        chart: {
          events: {
            load: addTitle,
            redraw: addTitle
          }
        },
        plotOptions: {
          pie: {
            showInLegend: scope.options.showLegend,
            allowPointSelect: false,
            innerSize: scope.options.donutThickness,
            borderWidth: 0,
            point: {
              events: {
                legendItemClick: function legendItemClick(e) {
                  e.preventDefault();
                }
              }
            }
          }
        },
        title: {
          text: "",
          floating: true
        },
        series: series
      }));
      scope.$on(Events.tile.resized, function () {
        chart.reflow();
      });
    }
  };
}]);

/***/ }),

/***/ 3004:
/***/ (function(module, exports) {

var ReleaseProgressTileViewController = function ReleaseProgressTileViewController($scope, ReleasesService, TasksService, Planner, RegionalSettings) {
  var vm = this;
  vm.isReleaseCompleted = isReleaseCompleted;
  vm.refresh = refresh;
  vm.release = $scope.release;
  vm.getStatus = getStatus;
  vm.calculateDelay = calculateDelay;
  vm.mediumDateFormat = RegionalSettings.currentMediumDateFormat;
  vm.chartOptions = {
    topTitleText: function topTitleText(data) {
      return data.completed + "/" + (data.completed + data.planned);
    },
    bottomTitleText: "tasks",
    legend: {
      borderRadius: 0
    },
    series: function series(data) {
      return [{
        name: 'Tasks',
        data: [{
          y: data.completed,
          name: "Completed",
          color: "#498500"
        }, {
          y: data.planned,
          name: "Planned",
          color: "#DDD"
        }]
      }];
    },
    showLegend: true,
    donutThickness: '90%'
  }; ///

  refresh();

  function refresh() {
    var flattenedTasks = ReleasesService.getLeafTasks(vm.release);
    var completedTasks = calculateCompletedTasks(flattenedTasks);
    vm.chartData = {
      completed: completedTasks.length,
      planned: flattenedTasks.length - completedTasks.length
    };
    vm.progress = calculateProgress(completedTasks.length, flattenedTasks.length);
    vm.estimatedEndDate = calculateEstimatedEndDate(vm.release);
  }

  function isReleaseCompleted() {
    return ReleasesService.isReleaseCompleted(vm.release);
  }

  function calculateCompletedTasks(tasks) {
    return _.filter(tasks, TasksService.isTaskReadOnly);
  }

  function calculateProgress(completed, total) {
    var progress = 0;

    if (angular.isNumber(completed) && angular.isNumber(total) && total !== 0) {
      progress = completed / total * 100;
    }

    return progress;
  }

  function calculateEstimatedEndDate(release) {
    Planner.setRelease(release);
    Planner.setReleaseTree(release.tree);
    var plan = Planner.makePlan(false);
    return plan.plannedEndDate;
  }

  function calculateDelay() {
    return moment.duration(vm.estimatedEndDate.diff(moment(vm.release.dueDate)));
  }

  function getStatus() {
    var status = "";

    if (isAborted()) {
      status = "ABORTED";
    } else if (isOnTime()) {
      status = "ON_TIME";
    } else {
      status = "DELAYED";
    }

    return status;
  }

  function isOnTime() {
    return !vm.estimatedEndDate.isAfter(moment(vm.release.dueDate));
  }

  function isAborted() {
    return ReleasesService.isReleaseAborted(vm.release);
  }
};

ReleaseProgressTileViewController.$inject = ['$scope', 'ReleasesService', 'TasksService', 'Planner', 'RegionalSettings'];
angular.module('xlrelease').controller('summary.ReleaseProgressTileViewController', ReleaseProgressTileViewController);

/***/ }),

/***/ 3005:
/***/ (function(module, exports) {

var ReleaseSummaryPageController = function ReleaseSummaryPageController($scope, ReleasesService, TasksService) {
  var vm = this;
  var xlrDashboard = $scope.xlrDashboard;
  vm.release = xlrDashboard.release;
  vm.isReleaseInProgress = ReleasesService.isReleaseInProgress;
  vm.isReleaseFailing = ReleasesService.isReleaseFailing;
  vm.isReleasePaused = ReleasesService.isReleasePaused;
  vm.isReleaseFailed = ReleasesService.isReleaseFailed;
  vm.isReleasePlanned = ReleasesService.isReleasePlanned;
  vm.isReleaseAborted = ReleasesService.isReleaseAborted;
  vm.isReleaseCompleted = ReleasesService.isReleaseCompleted;
  vm.hasCompletedStatus = ReleasesService.hasCompletedStatus;
  vm.isReleaseArchived = ReleasesService.isReleaseArchived;
  vm.flattenedTasks = ReleasesService.getLeafTasks(vm.release);
  vm.numberOfCompletedTasks = _.filter(vm.flattenedTasks, TasksService.isTaskReadOnly).length;
};

ReleaseSummaryPageController.$inject = ['$scope', 'ReleasesService', 'TasksService'];
angular.module('xlrelease').controller('summary.ReleaseSummaryPageController', ReleaseSummaryPageController);

/***/ }),

/***/ 3006:
/***/ (function(module, exports) {

var ReleaseSummaryTileViewController = function ReleaseSummaryTileViewController($scope, DateService) {
  var vm = this;
  var release = $scope.release;
  vm.isOverdue = DateService.isOverdue;
  vm.variables = release.variables;
  refresh();

  function refresh() {
    vm.releaseCurrentPhase = getActivePhase(release);
    vm.startDate = getStartDate(release);
    vm.dueDate = getDueDate(release);
    vm.releaseDuration = getDuration(release);
    vm.owner = release.owner;
  }

  function getActivePhase(release) {
    var activePhase = _.filter(release.phases, {
      'active': true
    });

    if (activePhase && activePhase.length > 0) {
      return activePhase[0].title;
    }

    return "Not started";
  }

  function getStartDate(release) {
    return DateService.getStartOrScheduledDate(release);
  }

  function getDueDate(release) {
    return DateService.getEndOrDueDate(release);
  }

  function getDuration(release) {
    var start = DateService.getStartOrScheduledDate(release);
    var end = DateService.getEndOrDueDate(release);
    return start && end && end >= start ? end - start : undefined;
  }
};

ReleaseSummaryTileViewController.$inject = ['$scope', 'DateService'];
angular.module('xlrelease').controller('summary.ReleaseSummaryTileViewController', ReleaseSummaryTileViewController);

/***/ }),

/***/ 3007:
/***/ (function(module, exports) {

angular.module('xlrelease').directive('statusBadge', function () {
  return {
    restrict: 'E',
    scope: {
      status: '='
    },
    template: '<span class="label {{badge.style}}">{{ badge.message }}</span>',
    link: function link($scope) {
      var badgesStyle = [];
      badgesStyle.NOT_FOUND = {
        style: 'label label-warning-failed',
        message: 'Not found'
      };
      badgesStyle.IN_PROGRESS = {
        style: 'label label-active',
        message: 'In progress'
      };
      badgesStyle.COMPLETED = {
        style: 'label label-completed',
        message: 'Completed'
      };
      badgesStyle.FAILED = {
        style: 'label label-warning-failed',
        message: 'Failed'
      };
      badgesStyle.FAILING = {
        style: 'label label-warning-failing',
        message: 'Failing'
      };
      badgesStyle.WAITING_FOR_INPUT = {
        style: 'label label-waiting',
        message: 'Needs input'
      };
      badgesStyle.PLANNED = {
        style: 'label label-planned',
        message: 'Planned'
      };
      badgesStyle.PENDING = {
        style: 'label label-pending',
        message: 'Pending'
      };
      badgesStyle.SKIPPED = {
        style: 'label label-default',
        message: 'Skipped'
      };
      badgesStyle.PAUSED = {
        style: 'label label-paused',
        message: 'Paused'
      };
      badgesStyle.ABORTED = {
        style: 'label label-aborted',
        message: 'Aborted'
      };
      badgesStyle.PRECONDITION_IN_PROGRESS = {
        style: 'label label-preconditioninprogress',
        message: 'Precondition'
      };
      badgesStyle.COMPLETED_IN_ADVANCE = {
        style: 'label label-completed',
        message: 'Completed'
      };
      badgesStyle.SKIPPED_IN_ADVANCE = {
        style: 'label label-default',
        message: 'Skipped'
      };
      badgesStyle.FAILURE_HANDLER_IN_PROGRESS = {
        style: 'label label-warning-failing',
        message: 'Handling failure'
      };
      badgesStyle.FACET_CHECK_IN_PROGRESS = {
        style: 'label label-preconditioninprogress',
        message: 'Verifying'
      };
      $scope.badge = badgesStyle[$scope.status.toUpperCase()];
    }
  };
});

/***/ }),

/***/ 3008:
/***/ (function(module, exports) {

var XlrTimelineDirectiveControllerInject = ['ColorService', 'DateService', 'RegionalSettings', '$filter'];

var XlrTimelineDirectiveController = function XlrTimelineDirectiveController(ColorService, DateService, RegionalSettings, $filter) {
  var vm = this;
  vm._$filter = $filter;
  vm.elapsedWidth = 0;
  vm.plannedWidth = 0;
  vm.estimatedWidth = 0;
  vm.delayWidth = 0;
  vm.timeline = {};
  vm.phases = [];
  vm.timelineHeight = 30;
  vm.phasesMargin = 85;
  vm.outgoingDependencies = [];
  vm.incomingDependencies = [];
  vm.showTimeIndicator = false;
  vm.redrawTimeline = redrawTimeline;
  vm.init = init;

  vm.buildReleaseLink = function (releaseId) {
    return "#/releases/".concat(releaseId, "/summary");
  };

  var CHARACTER_WIDTH = 8;
  var TIMELINE = {
    QUARTER_OF_HOUR: 15,
    HOURS_IN_A_DAY: 24,
    DAYS_IN_A_WEEK: 7,
    DAYS_IN_MONTH: 30
  };
  var METRICS = {
    MINUTES: 'minutes',
    HOURS: 'hours',
    DAYS: 'days',
    WEEKS: 'weeks',
    MONTHS: 'months'
  };
  var TIMELINE_FORMATS = {
    HOURS: function HOURS() {
      return RegionalSettings.currentTimeFormat.replace('mm', '00');
    },
    DAYS: function DAYS() {
      return RegionalSettings.currentDateFormat;
    },
    MONTHS: _.constant('MMM yyyy')
  };
  var COMPARE_FORMAT = {
    HOURS: 'YYYY-MM-DD HH',
    DAYS: 'YYYY-MM-DD'
  };
  var STEP_INDENT = 5;
  var day = 24;
  var week = 168;
  var month = 672;

  function redrawTimeline(width, height) {
    if (vm.timelineData.timeline && width) {
      vm.timelineWidth = Math.ceil(width);
      vm.timelineHeight = height;
      vm.elapsedWidth = 0;
      vm.plannedWidth = 0;
      vm.delayWidth = 0;
      vm.timeline = {};
      vm.showTimeIndicator = vm.timelineData.timeline.release.status === 'IN_PROGRESS' || vm.timelineData.timeline.release.status === 'PLANNED';
      vm.phases = [];
      drawTimeline(vm.timelineData.timeline);
    }
  }

  function init(width, height) {
    redrawTimeline(width, height);
  }

  function buildPhase(phases, release) {
    var currentPhaseX = 0;
    return _.map(phases, function (phase) {
      phase.color = ColorService.computePhaseColor(release, phase);
      var calculatedPhaseX = getPhaseX(phase, vm.timeline);

      if (calculatedPhaseX < currentPhaseX) {
        phase.x = currentPhaseX;
        var widthDiff = currentPhaseX - calculatedPhaseX;
        phase.width = getPhaseWidth(phase, vm.timeline) - widthDiff;
      } else {
        phase.x = calculatedPhaseX;
        phase.width = getPhaseWidth(phase, vm.timeline);
      }

      phase.shortTitle = calculateShortTitle(phase.plainTitle ? phase.plainTitle : phase.title, phase.width);
      currentPhaseX = phase.x + phase.width;
      return phase;
    });
  }

  function buildTimelinePeriods(startDay, format, timelineScale, containerSize) {
    var timeline = [];

    for (var i = 0; i < containerSize; i++) {
      timeline.push({
        title: vm._$filter('date')(startDay.toDate(), format)
      });
      startDay = startDay.add(1, timelineScale);
    }

    return timeline;
  }

  function buildContainer(startDay, endDay, timelineScale) {
    var container = {};
    var timelineStart = moment(startDay.format(COMPARE_FORMAT.DAYS));
    var timelineEnd = moment(endDay.format(COMPARE_FORMAT.DAYS));
    container.stepUnit = 1;
    container[timelineScale] = [];
    container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);

    switch (timelineScale) {
      case METRICS.HOURS:
        container.segments = TIMELINE.QUARTER_OF_HOUR;
        container.minimalMetric = METRICS.MINUTES;
        container.stepUnit = 4;
        timelineStart = moment(startDay.format(COMPARE_FORMAT.HOURS));
        timelineEnd = moment(endDay.format(COMPARE_FORMAT.HOURS));
        container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.HOURS(), timelineScale, container.size);
        break;

      case METRICS.DAYS:
        container.segments = TIMELINE.HOURS_IN_A_DAY;
        container.minimalMetric = METRICS.HOURS;
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.DAYS(), timelineScale, container.size);
        break;

      case METRICS.WEEKS:
        container.segments = TIMELINE.DAYS_IN_A_WEEK;
        container.minimalMetric = METRICS.DAYS;
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.DAYS(), timelineScale, container.size);
        break;

      case METRICS.MONTHS:
        timelineStart = DateService.getTodayWithTime().year(startDay.year()).month(startDay.month()).date(startDay.date());
        timelineEnd = moment(endDay.endOf('month'));
        container.size = Math.ceil(timelineEnd.diff(timelineStart, timelineScale, true) + 1);
        container.segments = TIMELINE.DAYS_IN_MONTH;
        container.minimalMetric = METRICS.DAYS;
        container[timelineScale] = buildTimelinePeriods(startDay, TIMELINE_FORMATS.MONTHS(), timelineScale, container.size);
        break;

      default:
        throw 'Unknown timeline scale';
    }

    container.timelineStart = timelineStart;
    container.timelineEnd = timelineEnd;
    container.metric = timelineScale;
    return container;
  }

  function drawTimeline(data) {
    if (!data || data.startDate === null || data.expectedEndDate === null) return;
    var startDay = data.startDate.clone();
    var endDay = data.expectedEndDate.clone();
    var detectMetric = calculateMetrics(startDay, endDay);
    vm.timeline = createTimeline(detectMetric);
    vm.phases = buildPhase(data.phases, data.release);
    vm.elapsedWidth = getElapsedSectionWidth(vm.timeline);
    vm.delayX = getPlannedSectionWidth(data.endDate, vm.timeline);
    vm.estimatedWidth = getPlannedSectionWidth(data.expectedEndDate, vm.timeline) - vm.phases[0].x;
    var delay = getDelaySectionWidth(data.endDate, data.expectedEndDate, vm.timeline) - vm.delayX;
    vm.delayWidth = delay > 0 ? delay : 0;
    vm.incomingDependencies = buildReleasesViews(vm.timelineData.incomingDependencies);
    vm.outgoingDependencies = buildReleasesViews(vm.timelineData.outgoingDependencies);

    if (vm.isDetailsView) {
      vm.phasesMargin = calculatePhaseMargin();
      vm.timelineHeight = calculateHeight();
    }
  }

  function calculateShortTitle(title, width) {
    if (title) {
      var actual = title;
      var maxLengthOfString = width / CHARACTER_WIDTH;

      if (actual.length > maxLengthOfString) {
        actual = actual.substring(0, maxLengthOfString);
        actual = actual + '...';
      }

      return actual;
    }
  }

  function calculateHeight() {
    var initialHeight = 250;
    var inLength = vm.incomingDependencies.length;

    if (inLength > 2) {
      initialHeight += inLength * 30;
    }

    var outLength = vm.outgoingDependencies.length;

    if (outLength > 2) {
      var delta = outLength - 2;
      initialHeight += delta * 30;
    }

    return initialHeight;
  }

  function calculatePhaseMargin() {
    var initialMargin = 120;
    var inLength = vm.incomingDependencies.length;

    if (inLength > 2) {
      var delta = inLength - 2;
      return initialMargin + delta * 30;
    }

    return initialMargin;
  }

  function calculateMetrics(startDay, endDay) {
    var container = {};
    var diff = endDay.diff(startDay, 'hours');

    if (diff < day * 1.5) {
      return buildContainer(startDay, endDay, 'hours');
    }

    if (diff >= day * 1.5 && diff < week * 3) {
      return buildContainer(startDay, endDay, 'days');
    }

    if (diff >= week * 3 && diff < month * 3) {
      return buildContainer(startDay, endDay, 'weeks');
    }

    if (diff >= month * 3) {
      return buildContainer(startDay, endDay, 'months');
    }

    return container;
  }

  function buildReleasesViews(releases) {
    return _.map(releases, function (release) {
      var releaseCoordinateX = getReleaseX(moment(release.startDate), moment(release.scheduledStartDate));
      var releaseWidth = getReleaseWidth(moment(release.startDate), moment(release.scheduledStartDate), moment(release.endDate), moment(release.dueDate));
      var actualWidth = releaseCoordinateX + releaseWidth > vm.timelineWidth ? vm.timelineWidth - releaseCoordinateX : releaseWidth;
      return {
        id: release.releaseId,
        xCord: releaseCoordinateX,
        width: actualWidth,
        title: release.releaseTitle,
        shortTitle: calculateShortTitle(release.releaseTitle, actualWidth - 30)
      };
    });
  }

  function getReleaseX(startDate, estimatedStartDate) {
    var start = startDate;

    if (!startDate.isValid()) {
      start = estimatedStartDate;
    }

    if (angular.isDefined(vm.timeline.start) && angular.isDefined(start) && start.isAfter(vm.timeline.start)) {
      var time = start.diff(vm.timeline.start, vm.timeline.minimalMetric, true);
      return time * vm.timeline.step / vm.timeline.unit;
    }

    return 0;
  }

  function getReleaseWidth(startDate, estimatedStartDate, endDate, estimatedDueDate) {
    var start = startDate;
    var end = endDate;

    if (startDate && !startDate.isValid()) {
      start = estimatedStartDate;
    }

    if (endDate && !endDate.isValid()) {
      end = estimatedDueDate;
    }

    if (angular.isDefined(vm.timeline.start) && angular.isDefined(start) && angular.isDefined(end)) {
      var time = end.diff(start, vm.timeline.minimalMetric, true);
      return time * vm.timeline.step / vm.timeline.unit;
    }

    return 0;
  }

  function getPhaseWidth(phase, timeline) {
    if (angular.isDefined(timeline.start) && angular.isDefined(phase.startDate)) {
      var time = phase.endDate.diff(phase.startDate, timeline.minimalMetric, true);
      return time * timeline.step / timeline.unit;
    }

    return 0;
  }

  function getPhaseX(phase, timeline) {
    if (angular.isDefined(timeline.start) && angular.isDefined(phase.startDate)) {
      var time = phase.startDate.diff(timeline.start, timeline.minimalMetric, true);
      return time * timeline.step / timeline.unit;
    }

    return 0;
  }

  function getPlannedSectionWidth(endDate, timeline) {
    if (angular.isDefined(endDate) && angular.isDefined(timeline.start)) {
      var time = endDate.diff(timeline.start, timeline.minimalMetric, true);
      return Math.ceil(time * timeline.step / timeline.unit);
    }

    return 0;
  }

  function getDelaySectionWidth(endDate, expectedEndDate, timeline) {
    if (expectedEndDate.isAfter(endDate)) {
      var time = expectedEndDate.diff(timeline.start, timeline.minimalMetric, true);
      return Math.ceil(time * timeline.step / timeline.unit);
    }

    return 0;
  }

  function getElapsedSectionWidth(timeline) {
    if (angular.isObject(timeline) && angular.isDefined(timeline.start)) {
      var end = DateService.getTodayWithTime();
      var time = end.diff(timeline.start, timeline.minimalMetric, true);
      return time * timeline.step / timeline.unit;
    }

    return 0;
  }

  function createTimeline(container) {
    var timeline = {};
    timeline.minimalMetric = container.minimalMetric;
    timeline.columnWidth = vm.timelineWidth / container.size;
    timeline.step = timeline.columnWidth / container.segments;
    timeline.textIndent = STEP_INDENT;
    timeline.titles = container[container.metric];
    timeline.range = [];
    timeline.unit = container.stepUnit;
    timeline.start = container.timelineStart;
    timeline.end = container.timelineEnd;

    for (var i = 0; i < container.size; i++) {
      timeline.range.push(i);
    }

    return timeline;
  }
};

XlrTimelineDirectiveController.$inject = XlrTimelineDirectiveControllerInject;
var XlrTimelineChartInject = ['$window', '$timeout', 'Events'];

var XlrTimelineChart = function XlrTimelineChart($window, $timeout, Events) {
  return {
    bindToController: {
      timelineData: '=',
      isDetailsView: '=detailView'
    },
    require: ['xlrTimelineChart', '?^xlrTile'],
    link: function link($scope, elem, attr, ctrls) {
      var ctrl = ctrls[0];
      var xlrTile = ctrls[1];
      var PANEL_BODY_PADDING = 60;

      if (ctrl.isDetailsView) {
        var resizeFn = function resizeFn() {
          $timeout(function () {
            ctrl.redrawTimeline($window.innerWidth - 110);
          }, 200);
        };

        angular.element($window).bind('resize', resizeFn);
        $scope.$on('$destroy', function () {
          angular.element($window).unbind('resize', resizeFn);
        });
        ctrl.init($window.innerWidth - 110);
      } else {
        if (xlrTile) {
          ctrl.init(xlrTile.width, xlrTile.height - PANEL_BODY_PADDING);
        }

        $scope.$on(Events.tile.resized, function () {
          if (xlrTile) {
            ctrl.redrawTimeline(xlrTile.width, xlrTile.height - PANEL_BODY_PADDING);
          }
        });
      }
    },
    controller: 'xlrTimelineDirectiveController',
    controllerAs: 'timelineCtrl',
    templateUrl: 'static/10.2.6/include/TimelineTile/partials/timeline-chart.html'
  };
};

XlrTimelineChart.$inject = XlrTimelineChartInject;
angular.module('xlrelease').controller('xlrTimelineDirectiveController', XlrTimelineDirectiveController);
angular.module('xlrelease').directive('xlrTimelineChart', XlrTimelineChart);

/***/ }),

/***/ 3009:
/***/ (function(module, exports) {

angular.module('xlrelease').factory('Timeline', ['Planner', function (Planner) {
  return {
    init: function init(currentRelease, currentReleaseTree) {
      Planner.setRelease(currentRelease);
      Planner.setReleaseTree(currentReleaseTree);
      var plan = Planner.makePlan();
      var releasePlan = plan.plan;
      var expectedEndDate = plan.plannedEndDate;
      var startDate = plan.elements[0].displayStartDate;
      var endDate = releasePlan.displayEndDate;

      var phaseDetails = _(plan.elements).filter({
        type: 'xlrelease.Phase'
      }).map(function (phase) {
        return {
          title: phase.text,
          plainTitle: phase.plainText,
          startDate: moment(phase.start_date),
          endDate: moment(phase.end_date),
          color: phase.planItem.color
        };
      }).value();

      return {
        release: currentRelease,
        startDate: startDate,
        expectedEndDate: expectedEndDate,
        endDate: endDate,
        phases: phaseDetails
      };
    }
  };
}]);

/***/ }),

/***/ 3013:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/services/index.js
var services = __webpack_require__(109);

// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/http.js
var http = __webpack_require__(16);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/delivery-pattern.service.js


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var API_URL = 'api/v1/delivery-patterns';
var API_URL_FOLDERS = 'api/v1/folders/list?depth=1000&permissions=true&resultsPerPage=1000000';
function delivery_pattern_service_fetchDeliveryPattern(patternId) {
  return Object(http["c" /* httpGET */])("".concat(API_URL, "/").concat(patternId), true, true).then(function (res) {
    return res.data;
  }).catch(function (err) {
    if (err.response.status === http["a" /* httpCodes */].FORBIDDEN) {
      return {
        id: 'forbiddenFolderNotNull',
        title: '',
        $metadata: {
          details: {
            folder: 'another folder'
          }
        }
      };
    } else {
      return {
        id: null,
        title: ''
      };
    }
  });
}
function fetchAllFolders() {
  return Object(http["c" /* httpGET */])("".concat(API_URL_FOLDERS), true, true).then(function (res) {
    return res.data;
  });
}
function createDeliveryPattern(deliveryPattern) {
  return Object(http["e" /* httpPOST */])(API_URL, _objectSpread(_objectSpread({
    id: '',
    type: 'delivery.Delivery'
  }, deliveryPattern), {}, {
    status: 'template'
  })).then(function (res) {
    return res.data;
  });
}
function copyDeliveryPattern(deliveryPattern) {
  return Object(http["e" /* httpPOST */])("".concat(API_URL, "/").concat(deliveryPattern.id, "/duplicate"), {
    title: deliveryPattern.title,
    description: deliveryPattern.description
  }).then(function (res) {
    return res.data;
  });
}
function updateDeliveryPattern(deliveryPattern) {
  return Object(http["g" /* httpPUT */])("".concat(API_URL, "/").concat(deliveryPattern.id), _objectSpread(_objectSpread({
    type: 'delivery.Delivery'
  }, deliveryPattern), {}, {
    status: 'template'
  })).then(function (res) {
    return res.data;
  });
}
function delivery_pattern_service_deleteDeliveryPattern(patternId) {
  return Object(http["b" /* httpDELETE */])("".concat(API_URL, "/").concat(patternId));
}
function searchDeliveryPatterns() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title,
      _ref$folderId = _ref.folderId,
      folderId = _ref$folderId === void 0 ? undefined : _ref$folderId,
      _ref$pageNumber = _ref.pageNumber,
      pageNumber = _ref$pageNumber === void 0 ? 0 : _ref$pageNumber,
      _ref$itemsPerPage = _ref.itemsPerPage,
      itemsPerPage = _ref$itemsPerPage === void 0 ? 100 : _ref$itemsPerPage;

  var params = {
    page: pageNumber,
    resultsPerPage: itemsPerPage
  };
  var url = "".concat(API_URL, "/search?") + $.param(params);
  return Object(http["e" /* httpPOST */])(url, {
    title: title,
    folderId: folderId
  }).then(function (res) {
    return res.data;
  });
}
function fetchStages(defId) {
  return Object(http["c" /* httpGET */])("".concat(API_URL, "/").concat(defId, "/stages")).then(function (res) {
    return res.data;
  });
}
function deleteStage(stageId) {
  return Object(http["b" /* httpDELETE */])("".concat(API_URL, "/").concat(stageId));
}
function updateStage(stageId, title) {
  return Object(http["g" /* httpPUT */])("".concat(API_URL, "/").concat(stageId), {
    id: stageId,
    title: title,
    type: 'delivery.Stage'
  }).then(function (res) {
    return res.data;
  });
}
function addStage(defId, before, after) {
  return Object(http["e" /* httpPOST */])("".concat(API_URL, "/").concat(defId, "/createStage"), {
    stage: {
      id: null,
      title: null,
      type: 'delivery.Stage'
    },
    before: before,
    after: after
  }).then(function (res) {
    return res.data;
  });
}
function addTransition(stageId) {
  return Object(http["e" /* httpPOST */])("".concat(API_URL, "/").concat(stageId, "/transitions"), {
    id: null,
    title: 'New Transition',
    type: 'delivery.Transition'
  }).then(function (res) {
    return res.data;
  });
}
function updateTransition(transition) {
  return Object(http["g" /* httpPUT */])("".concat(API_URL, "/").concat(transition.id), _objectSpread(_objectSpread({}, transition), {}, {
    type: 'delivery.Transition',
    stage: undefined
  })).then(function (res) {
    return res.data;
  });
}
function deleteTransition(transitionId) {
  return Object(http["b" /* httpDELETE */])("".concat(API_URL, "/").concat(transitionId));
}
function checkTitle(id, title) {
  return Object(http["e" /* httpPOST */])("".concat(API_URL, "/checkTitle"), {
    id: id,
    title: title
  }).then(function (res) {
    return res.data;
  });
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-selector.js





var delivery_selector_template = "\n<div class=\"form-group\">\n    <label class=\"col-xs-3 control-label\" for=\"deliveryId\">\n        {{$ctrl.propertyDefinition.label}} <span class=\"error\">*</span>\n    </label>\n\n    <div class=\"col-sm-9\">\n        <div ng-if=\"$ctrl.isLoaded\" xlr-dropdown-with-variables\n             name=\"$ctrl.propertyDefinition.name\"\n             model=\"$ctrl.selectedDelivery\"\n             variables=\"$ctrl.variables\"\n             metadata=\"{name: $ctrl.propertyDefinition.name}\"\n             on-change=\"$ctrl.onVariableChange()\"\n             reset-value-on-toggle=\"true\"\n             on-new=\"$ctrl.onVariableCreate(name, variableType, createdCallback)\"\n             options=\"{placeholder: 'Select ' + $ctrl.propertyDefinition.label.toLowerCase() + '...', handlers: $ctrl.deliveryHandlers, required: true}\"\n             read-only=\"$ctrl.readOnly\"\n        ></div>\n        <span ng-if=\"$ctrl.isPatternMode() && !$ctrl.hasPatternViewPermission\" class=\"field-errors\">You do not have permissions to view the selected pattern.</span>\n\n        <div class=\"description\" ng-class=\"{'error': !$ctrl.isDeliveryExist}\">{{$ctrl.description}}</div>\n    </div>\n</div>\n";

var delivery_selector_DeliverySelectorController = /*#__PURE__*/function () {
  function DeliverySelectorController($q, VariablesService, Ids) {
    classCallCheck_default()(this, DeliverySelectorController);

    this.VariablesService = VariablesService;
    this.$q = $q;
    this.Ids = Ids;
  }

  createClass_default()(DeliverySelectorController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.hasPatternViewPermission = true;
      this.isLoaded = false;
      this.isDeliveryExist = true;
      this.description = this.propertyDefinition.description;
      this.selectedDelivery = {
        variable: undefined,
        value: undefined
      };

      if (this.VariablesService.containsOnlyVariable(this.deliveryId)) {
        this.selectedDelivery.variable = this.deliveryId;
        this.isLoaded = true;
      } else if (this.deliveryId) {
        this.$q.when(this.fetchDelivery(this.deliveryId)).then(function (delivery) {
          if (_this.isPatternMode()) {
            if (_.get(delivery, "id") === "forbiddenFolderNotNull" && _.isEmpty(_.get(delivery, "title"))) {
              _this.hasPatternViewPermission = false;

              var pId = _this.Ids.getName(_this.Ids.toDomainId(_this.deliveryId));

              var patternWithId = {
                id: _this.deliveryId,
                title: pId
              };
              _this.selectedDelivery.value = patternWithId;
            } else {
              _this.hasPatternViewPermission = true;
              _this.selectedDelivery.value = delivery;
            }

            _this.fireOnChange(_this.selectedDelivery, true);
          } else {
            _this.selectedDelivery.value = delivery;

            _this.fireOnChange(_this.selectedDelivery, true);
          }
        }, function (err) {
          if (err.response.status === 404) {
            _this.isDeliveryExist = false;
            _this.selectedDelivery = {
              variable: undefined,
              value: {
                id: _this.deliveryId,
                title: _this.deliveryId
              }
            };
            _this.description = 'Currently selected delivery was deleted';
          }
        }).finally(function () {
          return _this.isLoaded = true;
        });
      } else {
        this.isLoaded = true;
      }

      this.searchDeliveries("").then(function (deliveries) {
        return _this.cachedDeliveries = deliveries;
      });
      this.deliveryHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return _this.autocompleteHandler(_this.cachedDeliveries, options.term);
        },
        onSelect: function onSelect(newDelivery) {
          _this.hasPatternViewPermission = true;
          _this.selectedDelivery = {
            value: newDelivery,
            variable: undefined
          };
          _this.description = _this.propertyDefinition.description;
          _this.isDeliveryExist = true;

          _this.fireOnChange(_this.selectedDelivery);
        },
        removeElement: function removeElement() {
          _this.hasPatternViewPermission = true;
          _this.selectedDelivery = {
            value: undefined,
            variable: undefined
          };
          _this.description = _this.propertyDefinition.description;
          _this.isDeliveryExist = true;

          _this.fireOnChange(_this.selectedDelivery);
        }
      };
    }
  }, {
    key: "autocompleteHandler",
    value: function autocompleteHandler(items, term) {
      var candidates = _.filter(items, function (item) {
        return item.title.toLowerCase().includes(term.toLowerCase());
      });

      return candidates.length > 0 ? Promise.resolve(candidates) : this.searchDeliveries(term);
    }
  }, {
    key: "onVariableCreate",
    value: function onVariableCreate(name, variableType, createdCallback) {
      this.onNewVariable({
        name: name,
        variableType: variableType,
        createdCallback: createdCallback
      });
      this.fireOnChange(this.selectedDelivery);
    }
  }, {
    key: "onVariableChange",
    value: function onVariableChange() {
      this.selectedDelivery = {
        value: undefined,
        variable: this.selectedDelivery.variable
      };
      this.description = this.propertyDefinition.description;
      this.isDeliveryExist = true;
      this.fireOnChange(this.selectedDelivery);
    }
  }, {
    key: "fireOnChange",
    value: function fireOnChange(delivery, initialLoad) {
      this.onChange({
        deliveryId: delivery.variable || (delivery.value || {}).id,
        delivery: delivery.value,
        initialLoad: initialLoad
      });
    }
  }, {
    key: "isPatternMode",
    value: function isPatternMode() {
      return this.mode === 'PATTERN';
    }
  }, {
    key: "fetchDelivery",
    value: function fetchDelivery(deliveryId) {
      if (this.isPatternMode()) {
        return delivery_pattern_service_fetchDeliveryPattern(deliveryId);
      } else {
        return Object(services["d" /* getDelivery */])(this.deliveryId, true).then(function (response) {
          return response.data;
        });
      }
    }
  }, {
    key: "searchDeliveries",
    value: function searchDeliveries(term) {
      if (this.isPatternMode()) {
        return searchDeliveryPatterns({
          title: term
        }).then(function (results) {
          return _.sortBy(results, 'title');
        });
      } else {
        return Object(services["c" /* fetchDeliveries */])({
          inProgress: true,
          title: term
        }, 0, 100).then(function (response) {
          return _.sortBy(response.data, 'title');
        });
      }
    }
  }, {
    key: "getName",
    value: function getName(id) {
      return this.Ids.getName(id);
    }
  }]);

  return DeliverySelectorController;
}();

defineProperty_default()(delivery_selector_DeliverySelectorController, "$inject", ['$q', 'VariablesService', 'Ids']);

var DeliverySelector = {
  bindings: {
    deliveryId: '<',
    propertyDefinition: '<',
    variables: '<',
    readOnly: '<',
    onChange: '&',
    onNewVariable: '&',
    mode: '@'
  },
  controller: delivery_selector_DeliverySelectorController,
  template: delivery_selector_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-item-selector.js



var delivery_item_selector_template = "\n<div class=\"form-group\">\n    <label class=\"col-sm-3 control-label\">{{$ctrl.propertyDefinition.label}} <span class=\"error\">*</span></label>\n\n    <div class=\"col-sm-9\">\n        <div xlr-template-from-value-or-variable-selector\n             name=\"$ctrl.propertyDefinition.name\"\n             model=\"$ctrl.selectedItem\"\n             variables=\"$ctrl.variables\"\n             metadata=\"{name: $ctrl.propertyDefinition.name}\"\n             on-change=\"$ctrl.onVariableChange()\"\n             on-new=\"$ctrl.onVariableCreate(name, variableType, createdCallback)\"\n             options=\"{placeholder: 'Select ' + $ctrl.propertyDefinition.label.toLowerCase() + '...', handlers: $ctrl.handlers, required: true}\"\n             read-only=\"$ctrl.readOnly\"\n        ></div>\n         <div class=\"description\">{{$ctrl.propertyDefinition.description}}<span ng-show=\"$ctrl.isLinkEnabled()\">. <a ng-click=\"$ctrl.onGetStages()\" style=\"cursor: pointer;\">Use delivery patterns to filter the list of stages</a></span></div>\n         </div>\n</div>\n";

var delivery_item_selector_DeliveryItemSelectorController = /*#__PURE__*/function () {
  function DeliveryItemSelectorController(VariablesService) {
    classCallCheck_default()(this, DeliveryItemSelectorController);

    this.VariablesService = VariablesService;
  }

  createClass_default()(DeliveryItemSelectorController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this = this;

      this.setSelectedItem(this.itemId, this.items);
      this.handlers = {
        addCandidates: function addCandidates(metadata, options) {
          var matches = (_this.items || []).filter(function (item) {
            return item.title.toLowerCase().includes(options.term.toLowerCase());
          });
          return Promise.resolve(matches);
        },
        onSelect: function onSelect(newItem) {
          _this.selectedItem = {
            value: newItem,
            variable: undefined
          };

          _this.fireOnChange(_this.selectedItem);
        },
        removeElement: function removeElement() {
          _this.selectedItem = {
            value: undefined,
            variable: undefined
          };

          _this.fireOnChange(_this.selectedItem);
        }
      };
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      if (changes.itemId) {
        this.setSelectedItem(changes.itemId.currentValue, this.items);
      }

      if (changes.items && changes.items.currentValue) {
        this.setSelectedItem(this.itemId, changes.items.currentValue);
      }
    }
  }, {
    key: "setSelectedItem",
    value: function setSelectedItem(itemId, items) {
      var _this2 = this;

      var isVariable = this.VariablesService.containsOnlyVariable(this.itemId);
      var variable = isVariable ? this.itemId : undefined;
      var value = !isVariable && items ? items.find(function (item) {
        return item.id === _this2.itemId || item.title === _this2.itemId;
      }) || {
        title: this.itemId
      } : undefined;
      this.selectedItem = {
        variable: variable,
        value: value
      };
    }
  }, {
    key: "onVariableCreate",
    value: function onVariableCreate(name, variableType, createdCallback) {
      this.onNewVariable({
        name: name,
        variableType: variableType,
        createdCallback: createdCallback
      });
      this.fireOnChange(this.selectedItem);
    }
  }, {
    key: "onVariableChange",
    value: function onVariableChange() {
      this.selectedItem = {
        value: undefined,
        variable: this.selectedItem.variable
      };
      this.fireOnChange(this.selectedItem);
    }
  }, {
    key: "fireOnChange",
    value: function fireOnChange(item, initialLoad) {
      this.onChange({
        itemId: item.variable || (item.value || {}).id,
        initialLoad: initialLoad
      });
    }
  }, {
    key: "isLinkEnabled",
    value: function isLinkEnabled() {
      return this.propertyDefinition && this.propertyDefinition.name === 'stage' && !this.readOnly && !this.delivery;
    }
  }]);

  return DeliveryItemSelectorController;
}();

defineProperty_default()(delivery_item_selector_DeliveryItemSelectorController, "$inject", ['VariablesService']);

var DeliveryItemSelector = {
  bindings: {
    delivery: '<?',
    itemId: '<',
    items: '<',
    propertyDefinition: '<',
    variables: '<',
    readOnly: '<',
    onChange: '&',
    onNewVariable: '&',
    onGetStages: '&'
  },
  controller: delivery_item_selector_DeliveryItemSelectorController,
  template: delivery_item_selector_template
};
// EXTERNAL MODULE: ./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js
var injectStylesIntoStyleTag = __webpack_require__(9);
var injectStylesIntoStyleTag_default = /*#__PURE__*/__webpack_require__.n(injectStylesIntoStyleTag);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-task-details.less
var delivery_task_details = __webpack_require__(870);
var delivery_task_details_default = /*#__PURE__*/__webpack_require__.n(delivery_task_details);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-task-details.less

            

var delivery_task_details_options = {};

delivery_task_details_options.insert = "head";
delivery_task_details_options.singleton = false;

var update = injectStylesIntoStyleTag_default()(delivery_task_details_default.a, delivery_task_details_options);



/* harmony default export */ var components_delivery_task_details = (delivery_task_details_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/delivery-task-details.js





var delivery_task_details_template = "\n<div class=\"delivery-task-details\">\n    <div class=\"form-horizontal\" ng-form=\"releaseSyncTaskForm\">\n        <div class=\"properties\">\n            <ng-transclude></ng-transclude>\n        </div>\n    </div>\n</div>\n";

var delivery_task_details_DeliveryTaskDetailsController = /*#__PURE__*/function () {
  function DeliveryTaskDetailsController($scope, VariablesService, Ids) {
    var _this = this;

    classCallCheck_default()(this, DeliveryTaskDetailsController);

    defineProperty_default()(this, "updateComponentModels", function (task) {
      _this.deliveryId = task.inputProperties.deliveryId;

      if (!task.inputProperties.patternId || _this.pattern.id !== task.inputProperties.patternId) {
        _this.pattern = null;
      }

      _this.stageId = task.inputProperties.stage;
    });

    this.$scope = $scope;
    this.VariablesService = VariablesService;
    this.Ids = Ids;
  }

  createClass_default()(DeliveryTaskDetailsController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.hasPatternViewPermission = true;
      this.deliveryId = this.task.inputProperties.deliveryId;

      if (this.VariablesService.containsOnlyVariable(this.deliveryId)) {
        this.delivery = null;
      }

      if (this.task.inputProperties.status) {
        this.status = this.task.inputProperties.status.value || "READY";
        this.statusOptions = [];

        if (this.task.scriptDefinitionType === 'delivery.WaitForTrackedItems') {
          this.statusOptions = [{
            title: 'Completed',
            value: 'READY'
          }, {
            title: 'Available',
            value: 'NOT_READY'
          }];
        } else if (this.task.scriptDefinitionType === 'delivery.MarkTrackedItems') {
          this.statusOptions = [{
            title: 'Completed',
            value: 'READY'
          }, {
            title: 'Skipped',
            value: 'SKIPPED'
          }];
        }
      }

      if (this.task.inputProperties.patternId) {
        this.fetchDeliveryPattern();
      }

      this.stageId = this.task.inputProperties.stage;
      this.dpHandlers = {
        addCandidates: function addCandidates(metadata, options) {
          return searchDeliveryPatterns({
            title: options.term
          });
        },
        onSelect: function onSelect(newPattern) {
          _this2.hasPatternViewPermission = true;
          _this2.task.inputProperties.patternId = newPattern.id;
          _this2.task.inputProperties.stage = _this2.updateStageValue(_this2.task.inputProperties.stage);

          _this2.onChange(_this2.task);

          _this2.updateComponentModels(_this2.task);
        },
        removeElement: function removeElement() {
          _this2.hasPatternViewPermission = true;
          _this2.task.inputProperties.patternId = null;
          _this2.task.inputProperties.stage = _this2.updateStageValue(_this2.task.inputProperties.stage);

          _this2.onChange(_this2.task);

          _this2.updateComponentModels(_this2.task);
        }
      };
      this.showDeliveryPattern = !!this.task.inputProperties.patternId && !!this.deliveryId;
    }
  }, {
    key: "fetchDeliveryPattern",
    value: function fetchDeliveryPattern() {
      var _this3 = this;

      delivery_pattern_service_fetchDeliveryPattern(this.task.inputProperties.patternId).then(function (data) {
        if (_.get(data, "id") === "forbiddenFolderNotNull" && _.isEmpty(_.get(data, "title"))) {
          _this3.hasPatternViewPermission = false;

          var pId = _this3.Ids.getName(_this3.Ids.toDomainId(_this3.task.inputProperties.patternId));

          var patternWithId = {
            id: _this3.task.inputProperties.patternId,
            title: pId
          };
          _this3.pattern = patternWithId;
        } else {
          _this3.hasPatternViewPermission = true;
          _this3.pattern = data;
        }

        _this3.$scope.$digest();
      });
    }
  }, {
    key: "onGetStages",
    value: function onGetStages() {
      this.showDeliveryPattern = true;
    }
  }, {
    key: "onDeliveryChange",
    value: function onDeliveryChange(deliveryId, delivery, initialLoad) {
      this.delivery = delivery;
      this.task.inputProperties.deliveryId = deliveryId;

      if (initialLoad) {
        this.$scope.$digest(); // React...
      } else {
        if (!delivery && this.VariablesService.containsOnlyVariable(deliveryId) && !this.showDeliveryPattern) {
          this.task.inputProperties.stage = this.updateStageValue(this.task.inputProperties.stage);
        }

        if (!!delivery || !deliveryId && !delivery) {
          this.showDeliveryPattern = false;
          this.task.inputProperties.patternId = null;
          this.task.inputProperties.stage = this.updateStageValue(this.task.inputProperties.stage);
        }

        this.onChange(this.task);
        this.updateComponentModels(this.task);
      }
    }
  }, {
    key: "onStageChange",
    value: function onStageChange(stageId, initialLoad) {
      this.task.inputProperties.stage = stageId;

      if (!initialLoad) {
        this.onChange(this.task);
        this.updateComponentModels(this.task);
      }
    }
  }, {
    key: "updateStageValue",
    value: function updateStageValue(stage) {
      var isStageVariable = this.VariablesService.containsOnlyVariable(this.stageId);

      if (isStageVariable) {
        return stage;
      } else {
        return null;
      }
    }
  }, {
    key: "inputMetadataWithout",
    value: function inputMetadataWithout(excludedProperties) {
      if (!this.filteredInputMetadata && this.inputMetadata) {
        this.filteredInputMetadata = this.inputMetadata.filter(function (property) {
          return !excludedProperties.includes(property.name);
        });
      }

      return this.filteredInputMetadata;
    }
  }, {
    key: "hasProperty",
    value: function hasProperty(propertyName) {
      return !!this.getProperty(propertyName);
    }
  }, {
    key: "getProperty",
    value: function getProperty(propertyName) {
      return this.inputMetadata ? this.inputMetadata.find(function (property) {
        return property.name === propertyName;
      }) : undefined;
    }
  }, {
    key: "stages",
    get: function get() {
      if (this.showDeliveryPattern && !!this.pattern) {
        return this.pattern.stages;
      } else if (!this.showDeliveryPattern && !!this.delivery) {
        return this.delivery.stages;
      }
    }
  }, {
    key: "onStatusChange",
    value: function onStatusChange() {
      this.task.inputProperties.status = {
        value: this.status
      };
      this.onChange(this.task);
    }
  }]);

  return DeliveryTaskDetailsController;
}();

defineProperty_default()(delivery_task_details_DeliveryTaskDetailsController, "$inject", ['$scope', 'VariablesService', 'Ids']);

var DeliveryTaskDetails = {
  bindings: {
    task: '<',
    variables: '<',
    readOnly: '<',
    onNewVariable: '&',
    onChange: '&',
    inputMetadata: '<'
  },
  transclude: true,
  controller: delivery_task_details_DeliveryTaskDetailsController,
  template: delivery_task_details_template
};
// EXTERNAL MODULE: ./node_modules/lodash/isString.js
var isString = __webpack_require__(341);
var isString_default = /*#__PURE__*/__webpack_require__.n(isString);

// EXTERNAL MODULE: ./node_modules/lodash/get.js
var get = __webpack_require__(40);
var get_default = /*#__PURE__*/__webpack_require__.n(get);

// EXTERNAL MODULE: ./node_modules/lodash/has.js
var has = __webpack_require__(402);
var has_default = /*#__PURE__*/__webpack_require__.n(has);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/find-or-create-delivery-task-details.less
var find_or_create_delivery_task_details = __webpack_require__(871);
var find_or_create_delivery_task_details_default = /*#__PURE__*/__webpack_require__.n(find_or_create_delivery_task_details);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/find-or-create-delivery-task-details.less

            

var find_or_create_delivery_task_details_options = {};

find_or_create_delivery_task_details_options.insert = "head";
find_or_create_delivery_task_details_options.singleton = false;

var find_or_create_delivery_task_details_update = injectStylesIntoStyleTag_default()(find_or_create_delivery_task_details_default.a, find_or_create_delivery_task_details_options);



/* harmony default export */ var components_find_or_create_delivery_task_details = (find_or_create_delivery_task_details_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/find-or-create-delivery-task-details.js







var find_or_create_delivery_task_details_template = "\n<div class=\"find-or-create-delivery-task-details\">\n    <div class=\"form-horizontal\" data-ng-form=\"releaseSyncTaskForm\">\n        <div class=\"properties\">\n            <ng-transclude></ng-transclude>\n        </div>\n    </div>\n</div>\n";
var CHANGE_FOLDER_MSGS = 'Are you sure you want to change the folder to "[targetFolderTitle]"?';

var find_or_create_delivery_task_details_FindOrCreateDeliveryTaskDetailsController = /*#__PURE__*/function () {
  function FindOrCreateDeliveryTaskDetailsController($scope, $q, FoldersService, VariablesService, Ids) {
    var _this = this;

    classCallCheck_default()(this, FindOrCreateDeliveryTaskDetailsController);

    defineProperty_default()(this, "_initFolders", function (folderId) {
      _this.FoldersService.fetchUserVisibleFoldersTree(folderId).then(function (folders) {
        _this._folders = folders;

        if (folderId && !_this._idIsFromVariable(folderId)) {
          var folderIdDomain = _this.Ids.toDomainId(folderId);

          var folder = _this.FoldersService.findFolderInFolderTreeById(folderIdDomain, folders, 1000);

          _this._setSelectedFolderFrom(folder, folder.enabled);

          _this.folderId = _this._selectedFolder.id;
        } else if (_this._idIsFromVariable(folderId)) {
          _this._setSelectedFolderFrom(folderId);
        }

        _this.foldersReady = true;
      });
    });

    defineProperty_default()(this, "onFolderValueChange", function (folder) {
      if (get_default()(folder, 'selectedId')) {
        var foundFolder = _this.FoldersService.findFolderInFolderTreeById(folder.selectedId, _this.folders, 1000);

        if (get_default()(_this._selectedFolder, 'value')) {
          if (foundFolder) {
            _this._newSelectedFolder = foundFolder;
            _this._showFolderConfirmation = true;

            _this.$scope.$apply(function () {
              return _this._showFolderConfirmation;
            });
          }
        } else {
          _this._setSelectedFolderFrom(foundFolder.id, foundFolder.enabled);

          _this.folderId = _this._selectedFolder.id;

          _this.onChange(_this.task);

          _this.$scope.$apply(function () {
            return _this.folderId;
          });
        }
      } else {
        //Clear selection
        _this._newSelectedFolder = null;
        _this._showFolderConfirmation = true;

        _this.$scope.$apply(function () {
          return _this._showFolderConfirmation;
        });
      }
    });

    this.$scope = $scope;
    this.$q = $q;
    this.FoldersService = FoldersService;
    this.VariablesService = VariablesService;
    this.Ids = Ids;
    this._folders = [];
    this.foldersReady = false;
  }

  createClass_default()(FindOrCreateDeliveryTaskDetailsController, [{
    key: "$onInit",
    value: function $onInit() {
      var _this2 = this;

      this.patternId = this.task.inputProperties.patternId;
      this._showFolderConfirmation = false;
      this._changeFolderConfirmationMsg = CHANGE_FOLDER_MSGS;
      this._newSelectedFolder = null;
      this._selectedFolder = {
        id: null,
        value: null,
        variable: null,
        title: '',
        enabled: false
      };

      if (!this.folderId) {
        this._tryResolveFolderIdFromTaskId().then(function (folderId) {
          _this2._initFolders(folderId);
        }).catch(function () {
          _this2._initFolders(null);
        });
      } else {
        this._initFolders(this.folderId);
      }
    }
  }, {
    key: "_tryResolveFolderIdFromTaskId",
    value: function _tryResolveFolderIdFromTaskId() {
      var deferred = this.$q.defer();
      var parentFolder = this.Ids.getParentFolderIdFrom(this.task.id);

      if (parentFolder) {
        var folderId = "Applications/".concat(this.Ids.getName(parentFolder));
        this.FoldersService.get(folderId).then(function (folder) {
          deferred.resolve(folder.id);
        }).catch(function (e) {
          return deferred.reject(e);
        });
      } else {
        deferred.resolve(null);
      }

      return deferred.promise;
    }
  }, {
    key: "_setSelectedFolderFrom",
    value: function _setSelectedFolderFrom(folder) {
      var enabled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var id = has_default()(folder, 'id') ? folder.id : folder;

      if (isString_default()(id)) {
        this._selectedFolder = this._idIsFromVariable(id) ? {
          id: undefined,
          value: undefined,
          variable: id,
          title: id,
          enabled: this.getFolderIdFromVariable(id) ? !!this.FoldersService.findFolderInFolderTreeById(this.getFolderIdFromVariable(id), this._folders, 1000) : true
        } : {
          id: id,
          value: id,
          variable: undefined,
          title: folder.title || this.Ids.getName(id),
          enabled: enabled
        };
      } else {
        this._selectedFolder = {
          id: undefined,
          value: undefined,
          variable: undefined
        };
      }
    }
  }, {
    key: "getFolderIdFromVariable",
    value: function getFolderIdFromVariable(variableName) {
      var variable = this.variables.find(function (variable) {
        return variable.variableName === variableName;
      });

      if (angular.isDefined(variable) && angular.isDefined(variable.value) && variable.value.includes('Folder')) {
        return this.Ids.toDomainId(variable.value);
      }

      return undefined;
    }
  }, {
    key: "_idIsFromVariable",
    value: function _idIsFromVariable(id) {
      return angular.isDefined(id) && this.VariablesService.containsOnlyVariable(id);
    }
  }, {
    key: "onFolderVariableChange",
    value: function onFolderVariableChange() {
      if (this.isFromVariable(this._selectedFolder)) {
        this._setSelectedFolderFrom(this._selectedFolder.variable);

        this.folderId = this._selectedFolder.variable;
        this.onChange(this.task);
      } else {
        this._resetAllFolderValues();
      }
    }
  }, {
    key: "_resetAllFolderValues",
    value: function _resetAllFolderValues() {
      this._setSelectedFolderFrom(this._selectedFolder.variable);

      this.folderId = this._selectedFolder.variable;
      this._newSelectedFolder = this._selectedFolder;
    }
  }, {
    key: "createVariable",
    value: function createVariable(name, variableType, createdCallback, isRequired) {
      if (isRequired) {
        this.$scope.$parent.createRequiredVariable(this.task, name, variableType, createdCallback);
      } else {
        this.$scope.$parent.createOptionalVariable(this.task, name, variableType, createdCallback);
      }
    }
  }, {
    key: "isFromVariable",
    value: function isFromVariable(templateOrFolder) {
      return angular.isDefined(templateOrFolder) && this._idIsFromVariable(templateOrFolder.variable);
    }
  }, {
    key: "confirmFolderChange",
    value: function confirmFolderChange() {
      this._setSelectedFolderFrom(this._newSelectedFolder);

      this.folderId = this._selectedFolder.id;
      this._showFolderConfirmation = false;
      this.onChange(this.task);
    }
  }, {
    key: "cancelFolderChange",
    value: function cancelFolderChange() {
      this._newSelectedFolder = null;
      this._showFolderConfirmation = false;
      this.folderId = this._selectedFolder.id;
    }
  }, {
    key: "onPatternChange",
    value: function onPatternChange(patternId, pattern, initialLoad) {
      this.pattern = pattern;
      this.task.inputProperties.patternId = patternId;

      if (initialLoad) {
        this.$scope.$digest(); // React...
      } else {
        this.onChange(this.task);
      }
    }
  }, {
    key: "inputMetadataWithout",
    value: function inputMetadataWithout(excludedProperties) {
      if (!this.filteredInputMetadata && this.inputMetadata) {
        this.filteredInputMetadata = this.inputMetadata.filter(function (property) {
          return !excludedProperties.includes(property.name);
        });
      }

      return this.filteredInputMetadata;
    }
  }, {
    key: "hasProperty",
    value: function hasProperty(propertyName) {
      return !!this.getProperty(propertyName);
    }
  }, {
    key: "getProperty",
    value: function getProperty(propertyName) {
      return this.inputMetadata ? this.inputMetadata.find(function (property) {
        return property.name === propertyName;
      }) : undefined;
    }
  }, {
    key: "searchStrategyInputProperty",
    get: function get() {
      if (!this.searchStrategyInput) {
        this.searchStrategyInput = this.getProperty('searchStrategy');
      }

      return this.searchStrategyInput;
    }
  }, {
    key: "nameFilterInputProperty",
    get: function get() {
      if (!this.nameFilterInput) {
        this.nameFilterInput = this.getProperty('nameFilter');
      }

      return this.nameFilterInput;
    }
  }, {
    key: "selectionStrategyInputProperty",
    get: function get() {
      if (!this.selectionStrategyInput) {
        this.selectionStrategyInput = this.getProperty('selectionStrategy');
      }

      return this.selectionStrategyInput;
    }
  }, {
    key: "fallbackProperty",
    get: function get() {
      if (!this.fallback) {
        this.fallback = this.getProperty('fallback');
      }

      return this.fallback;
    }
  }, {
    key: "selectedFolder",
    get: function get() {
      return this._selectedFolder;
    }
  }, {
    key: "folderId",
    get: function get() {
      return this.task.inputProperties.folderId;
    },
    set: function set(folderId) {
      this.task.inputProperties.folderId = folderId;
    }
  }, {
    key: "folders",
    get: function get() {
      return this._folders;
    }
  }, {
    key: "showFolderConfirmation",
    get: function get() {
      return this._showFolderConfirmation;
    }
  }, {
    key: "hiddenFolder",
    get: function get() {
      if (this._selectedFolder && this._selectedFolder.id || this.isFromVariable(this.selectedFolder)) {
        return !this._selectedFolder.enabled;
      } else {
        return false;
      }
    }
  }, {
    key: "changeFolderConfirmationMsg",
    get: function get() {
      return this._changeFolderConfirmationMsg.replace('[targetFolderTitle]', this._newSelectedFolder.title);
    }
  }]);

  return FindOrCreateDeliveryTaskDetailsController;
}();

defineProperty_default()(find_or_create_delivery_task_details_FindOrCreateDeliveryTaskDetailsController, "$inject", ['$scope', '$q', 'FoldersService', 'VariablesService', 'Ids']);

var FindOrCreateDeliveryTaskDetails = {
  bindings: {
    task: '<',
    variables: '<',
    readOnly: '<',
    onNewVariable: '&',
    onChange: '&',
    inputMetadata: '<'
  },
  transclude: true,
  controller: find_or_create_delivery_task_details_FindOrCreateDeliveryTaskDetailsController,
  template: find_or_create_delivery_task_details_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/find-delivery-task-details.js


var find_delivery_task_details_template = "\n<div class=\"find-delivery-task-details\">\n    <div class=\"form-horizontal\" data-ng-form=\"releaseSyncTaskForm\">\n        <div class=\"properties\">\n            <ng-transclude></ng-transclude>\n        </div>\n    </div>\n</div>\n";

var find_delivery_task_details_FindDeliveryTaskDetailsController = /*#__PURE__*/function () {
  function FindDeliveryTaskDetailsController() {
    classCallCheck_default()(this, FindDeliveryTaskDetailsController);
  }

  createClass_default()(FindDeliveryTaskDetailsController, [{
    key: "inputMetadataWithout",
    value: function inputMetadataWithout(excludedProperties) {
      if (!this.filteredInputMetadata && this.inputMetadata) {
        this.filteredInputMetadata = this.inputMetadata.filter(function (property) {
          return !excludedProperties.includes(property.name);
        });
      }

      return this.filteredInputMetadata;
    }
  }, {
    key: "hasProperty",
    value: function hasProperty(propertyName) {
      return !!this.getProperty(propertyName);
    }
  }, {
    key: "getProperty",
    value: function getProperty(propertyName) {
      return this.inputMetadata ? this.inputMetadata.find(function (property) {
        return property.name === propertyName;
      }) : undefined;
    }
  }, {
    key: "itemsFilterInputProperty",
    get: function get() {
      if (!this.itemsFilterInput) {
        this.itemsFilterInput = this.getProperty('itemsFilter');
      }

      return this.itemsFilterInput;
    }
  }, {
    key: "nameFilterInputProperty",
    get: function get() {
      if (!this.nameFilterInput) {
        this.nameFilterInput = this.getProperty('nameFilter');
      }

      return this.nameFilterInput;
    }
  }, {
    key: "selectionStrategyInputProperty",
    get: function get() {
      if (!this.selectionStrategyInput) {
        this.selectionStrategyInput = this.getProperty('selectionStrategy');
      }

      return this.selectionStrategyInput;
    }
  }]);

  return FindDeliveryTaskDetailsController;
}();

var FindDeliveryTaskDetails = {
  bindings: {
    task: '<',
    variables: '<',
    readOnly: '<',
    onNewVariable: '&',
    onChange: '&',
    inputMetadata: '<'
  },
  transclude: true,
  controller: find_delivery_task_details_FindDeliveryTaskDetailsController,
  template: find_delivery_task_details_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/components/index.js





angular.module('xlrelease').component('deliverySelector', DeliverySelector).component('deliveryItemSelector', DeliveryItemSelector).component('deliveryTaskDetails', DeliveryTaskDetails).component('findOrCreateDeliveryTaskDetails', FindOrCreateDeliveryTaskDetails).component('findDeliveryTaskDetails', FindDeliveryTaskDetails);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/js/index.js

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/Tasks/index.js

// EXTERNAL MODULE: ./core/xlr-ui/app/features/release-overview/release-status-label/index.js
var release_status_label = __webpack_require__(277);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-list/delivery-list-controller.js



var delivery_list_controller_DeliveryListController = /*#__PURE__*/function () {
  function DeliveryListController() {
    classCallCheck_default()(this, DeliveryListController);
  }

  createClass_default()(DeliveryListController, [{
    key: "showMore",
    value: function showMore() {
      this.onShowMoreDeliveries();
    }
  }, {
    key: "getDeliveries",
    value: function getDeliveries() {
      return this.deliveries.toJS();
    }
  }, {
    key: "hasDeliveries",
    value: function hasDeliveries() {
      return _.get(this, ['deliveries', 'size']);
    }
  }, {
    key: "hasMoreDeliveries",
    value: function hasMoreDeliveries() {
      return this.deliveriesHasMore && !this.deliveriesLoadingStatus;
    }
  }]);

  return DeliveryListController;
}();


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-list/delivery-list-tpl.html
/* harmony default export */ var delivery_list_tpl = ("<div class=\"content-under-header fc-list-items\">\n    <div class=\"row\" ng-if=\"$ctrl.deliveries.size\">\n        <div class=\"col-xs-12\">\n            <xlr-infinite-scroll-wrapper\n                    on-show-more=\"$ctrl.showMore()\"\n                    disable-when=\"!$ctrl.hasMoreDeliveries()\"\n                    show-loader-when=\"$ctrl.deliveriesLoadingStatus\">\n                <div ng-repeat=\"delivery in $ctrl.getDeliveries()\"\n                     ng-class=\"{'fc-list-item-first': $first}\"\n                     class=\"row fc-list-item fc-list-loaded\"\n                     xlr-infinite-scroll>\n                    <xlr-delivery-row delivery=\"delivery\"></xlr-delivery-row>\n                </div>\n            </xlr-infinite-scroll-wrapper>\n        </div>\n    </div>\n    <div class=\"alert notice fc-list-loaded\" ng-if=\"!$ctrl.hasDeliveries() && !$ctrl.deliveriesLoadingStatus\">\n        No deliveries found.\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-list/index.js


var deliveryListComponent = {
  bindings: {
    deliveries: '<',
    deliveriesLoadingStatus: '<',
    deliveriesHasMore: '<',
    onShowMoreDeliveries: '&'
  },
  controller: delivery_list_controller_DeliveryListController,
  template: delivery_list_tpl
};
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/actions/deliveries-actions.js
var deliveries_actions = __webpack_require__(68);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/global.constants.js
var global_constants = __webpack_require__(45);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/delivery-properties.constants.js
var deliveryStatus = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED'
};
var stageStatus = {
  open: 'OPEN',
  closed: 'CLOSED'
};
var ciTypes = {
  delivery: 'delivery.Delivery',
  stage: 'delivery.Stage'
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-row/delivery-row-controller.js








var delivery_row_controller_DeliveryRowController = /*#__PURE__*/function () {
  function DeliveryRowController(Authenticator, ReleasesService, DateService, $ngRedux, $location, $uibModal, $sanitize) {
    classCallCheck_default()(this, DeliveryRowController);

    this._releasesService = ReleasesService;
    this._dateService = DateService;
    this._security = Authenticator;
    this._$location = $location;
    this._$uibModal = $uibModal;
    this._$sanitize = $sanitize;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(DeliveryRowController, [{
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        delete: function _delete(id) {
          return dispatch(Object(deliveries_actions["c" /* deleteDelivery */])(id));
        }
      };
    }
  }, {
    key: "hasDuration",
    value: function hasDuration() {
      return this.delivery.status === 'IN_PROGRESS' && this.delivery.startDate && this.delivery.endDate;
    }
  }, {
    key: "getFormattedDuration",
    value: function getFormattedDuration() {
      if (this.hasDuration()) {
        return this._dateService.getRemainingDuration(this.delivery.endDate);
      }
    }
  }, {
    key: "getNumberOfTrackedItems",
    value: function getNumberOfTrackedItems() {
      return _.get(this.delivery, ['trackedItems', 'length']) || 0;
    }
  }, {
    key: "getCurrentActiveStage",
    value: function getCurrentActiveStage() {
      var _this = this;

      var stages = this.delivery.stages;
      var activeStages = [];

      _.forEach(stages, function (stage) {
        if (!_this.isStageClosed(stage)) {
          //sanitise as this will be used by bs-tooltip where html=true is set
          activeStages.push(_this._$sanitize(stage.title));

          if (_this.hasTransition(stage)) {
            return false;
          }
        }
      });

      this.stageTooltip = activeStages.join('<br>');
      return _.size(activeStages) > 1 ? "".concat(_.head(activeStages), ", +").concat(_.size(activeStages) - 1) : _.head(activeStages);
    }
  }, {
    key: "isStageClosed",
    value: function isStageClosed(stage) {
      return stage.status === stageStatus.closed;
    }
  }, {
    key: "hasTransition",
    value: function hasTransition(stage) {
      return _.has(stage, 'transition') ? _.size(stage.transition) : 0;
    }
  }, {
    key: "isUpdatable",
    value: function isUpdatable(delivery) {
      return Object(services["f" /* isDeliveryUpdatable */])(delivery) && this._security.hasDeliveryEditPermission(delivery);
    }
  }, {
    key: "isOverdue",
    value: function isOverdue(date) {
      return date.includes('Overdue') || this._dateService.isOverdue(date, global_constants["a" /* dateTimeFormat */].duration);
    }
  }, {
    key: "deleteDelivery",
    value: function deleteDelivery(_delivery) {
      var _this2 = this;

      this._$uibModal.open({
        animation: false,
        component: 'confirmDeleteDelivery',
        resolve: {
          delivery: function delivery() {
            return _delivery;
          }
        }
      }).result.then(function (confirm) {
        if (confirm) {
          _this2.delete(_delivery.id);
        }
      });
    }
  }, {
    key: "updateDelivery",
    value: function updateDelivery(delivery) {
      this._$location.url("/deliveries/".concat(delivery.id));
    }
  }]);

  return DeliveryRowController;
}();

defineProperty_default()(delivery_row_controller_DeliveryRowController, "$inject", ['Authenticator', 'ReleasesService', 'DateService', '$ngRedux', '$location', '$uibModal', '$sanitize']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-row/delivery-row-tpl.html
/* harmony default export */ var delivery_row_tpl = ("<div class=\"col-xs-12 raised-link-wrapper\">\n    <div class=\"fc-list-item-line\">\n        <div class=\"row\">\n            <div class=\"fc-list-item-wrapper\">\n                <a class=\"col-xs-3 raised-link\" href=\"#/deliveries/{{$ctrl.delivery.id}}\"></a>\n                <div class=\"col-xs-3 fc-list-item-title-wrapper\">\n                    <div class=\"fc-list-item-title\">\n                      <i class=\"xl-icon group-icon icon-l\"></i>\n                      <strong class=\"raised-link-target\">\n                          {{$ctrl.delivery.title}}\n                      </strong>\n                    </div>\n                    <folder-path folder-id=\"$ctrl.delivery.folderId\"></folder-path>\n                    <div class=\"fc-list-item-item-count\">\n                        <ng-pluralize count=\"$ctrl.getNumberOfTrackedItems()\"\n                                      when=\"{'one': '{} tracked item', 'other': '{} tracked items'}\"></ng-pluralize>\n                    </div>\n                </div>\n                <div class=\"col-xs-2\">\n                    <span class=\"fc-list-item-tooltip\" bs-tooltip data-placement=\"right\" data-trigger=\"hover\" data-container=\"body\" data-title=\"{{$ctrl.stageTooltip}}\" data-html=\"true\">\n                        <strong>{{$ctrl.getCurrentActiveStage()}}</strong>\n                    </span>\n                </div>\n                <div class=\"col-xs-7 fc-list-item-content-wrapper\">\n                    <div class=\"row\">\n                        <div class=\"col-xs-2 col-xs-offset-2 fc-list-item-content\">\n                            <delivery-status-label release=\"$ctrl.delivery\" show-archived=\"true\"></delivery-status-label>\n                        </div>\n                        <div class=\"col-xs-2 fc-list-item-content\">\n                            <span ng-if=\"$ctrl.delivery.startDate\">\n                                {{$ctrl.delivery.startDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 fc-list-item-content\">\n                            <span ng-if=\"$ctrl.delivery.endDate\">\n                                {{$ctrl.delivery.endDate | date: 'short'}}\n                            </span>\n                        </div>\n                        <div class=\"col-xs-2 duration fc-list-item-content\" ng-class=\"{'date-overdue': $ctrl.hasDuration() && $ctrl.isOverdue($ctrl.getFormattedDuration())}\">\n                            <span ng-if=\"$ctrl.hasDuration()\">{{$ctrl.getFormattedDuration()}}</span>\n                        </div>\n                        <div class=\"col-xs-2 text-centered fc-list-item-actions\">\n                            <div class=\"fc-list-item-actions-button fc-item-update link\" ng-if=\"$ctrl.isUpdatable($ctrl.delivery)\"\n                                  ng-click=\"$ctrl.updateDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon edit-icon\"></i>\n                                <span class=\"action-label\">Edit</span>\n                            </div>\n                            <div class=\"fc-list-item-actions-button fc-item-delete link\" ng-if=\"$ctrl.isUpdatable($ctrl.delivery)\"\n                                  ng-click=\"$ctrl.deleteDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon delete-icon\"></i>\n                                <span class=\"action-label\">Delete</span>\n                            </div>\n\n                            <div class=\"fc-list-item-actions-button fc-item-view link\" ng-if=\"!$ctrl.isUpdatable($ctrl.delivery)\"\n                                 ng-click=\"$ctrl.updateDelivery($ctrl.delivery)\">\n                                <i class=\"xl-icon visibility-on-icon\" title=\"view\"></i>\n                                <span class=\"action-label\">View</span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-row/index.js


var deliveryRowComponent = {
  bindToController: true,
  bindings: {
    delivery: '<'
  },
  controllerAs: '$ctrl',
  controller: delivery_row_controller_DeliveryRowController,
  template: delivery_row_tpl
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/components/delete-deliveries-modal-component.js
var delete_deliveries_modal_component_template = "\n    <div class=\"modal-header\">\n        <h4 class=\"modal-title pull-left\" id=\"modal-title\">Delete release delivery</h4>\n        <button type=\"button\" class=\"close pull-right\" ng-click=\"$ctrl.close()\"><i class=\"xl-icon close-icon\"></i></button>\n        <div class=\"clearfix\"></div>\n    </div>\n    <div class=\"modal-body\" id=\"modal-body\">\n        You are about to delete the release delivery <strong>{{::$ctrl.resolve.delivery.title}}</strong>.\n    </div>\n    <div class=\"modal-footer\">\n        <button class=\"button cancel\" type=\"button\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button class=\"button continue primary\" type=\"button\" focus-on=\"true\" ng-click=\"$ctrl.close({$value: true})\">Delete</button>\n    </div>\n";
var ConfirmDeleteDelivery = {
  bindings: {
    resolve: '<',
    close: '&',
    dismiss: '&'
  },
  template: delete_deliveries_modal_component_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-filter/delivery-filter-tpl.html
/* harmony default export */ var delivery_filter_tpl = ("<filter class=\"fc-list-header-filter\" filters=\"$ctrl.filters\" on-change=\"$ctrl.filtersChanged(filters)\">\n    <div class=\"fc-list-header-filter-basic\">\n        <text-filter field=\"'title'\" class=\"delivery\" placeholder=\"'Search for deliveries...'\"></text-filter>\n        <span>\n            <ci-filter-status statuses=\"$ctrl.statusOptions\"></ci-filter-status>\n            <order-by-filter order-options=\"$ctrl.orderOptions\" class=\"filter last\"></order-by-filter>\n        </span>\n        <div class=\"buttons\">\n            <span class=\"pull-right filter-all\" ng-if=\"$ctrl.itemsCount.live.total > 0\"\n                  bs-tooltip placement=\"bottom\" template=\"{{$ctrl.itemCountTemplate}}\">\n                <span ng-pluralize\n                      count=\"$ctrl.itemsCount.live.total\"\n                      when=\"{'1': '{} delivery', 'other': '{} deliveries', 'few': '{} deliveries', 'many': '{} deliveries'}\"\n                      style=\"font-weight: bold\"></span>\n            </span>\n\n            <span class=\"fc-list-header-doc-icon\" doc-icon=\"deliveries.html\"></span>\n        </div>\n    </div>\n</filter>\n");
// EXTERNAL MODULE: ./node_modules/xl-react-components/dist/index.js
var dist = __webpack_require__(14);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/colors.js
var colors = __webpack_require__(21);

// EXTERNAL MODULE: ./core/xlr-ui/app/partials/items-count/items-count-tpl.html
var items_count_tpl = __webpack_require__(276);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/partials/items-count/items-count.less
var items_count = __webpack_require__(872);
var items_count_default = /*#__PURE__*/__webpack_require__.n(items_count);

// CONCATENATED MODULE: ./core/xlr-ui/app/partials/items-count/items-count.less

            

var items_count_options = {};

items_count_options.insert = "head";
items_count_options.singleton = false;

var items_count_update = injectStylesIntoStyleTag_default()(items_count_default.a, items_count_options);



/* harmony default export */ var items_count_items_count = (items_count_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-filter/delivery-filter-controller.js







var delivery_filter_controller_DeliveryListHeaderController = /*#__PURE__*/function () {
  function DeliveryListHeaderController() {
    classCallCheck_default()(this, DeliveryListHeaderController);
  }

  createClass_default()(DeliveryListHeaderController, [{
    key: "$onInit",
    value: function $onInit() {
      this.statusOptions = [{
        label: 'In progress',
        value: 'In progress',
        color: colors["a" /* default */].blue
      }, {
        label: 'Completed',
        value: 'Completed',
        color: colors["a" /* default */].green
      }];
      this.orderOptions = [{
        label: 'Start date',
        filter: 'start_date'
      }, {
        label: 'End date',
        filter: 'end_date'
      }];
      this.itemCountTemplate = items_count_tpl["a" /* default */];
    }
  }]);

  return DeliveryListHeaderController;
}();


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-filter/index.js


var deliveryFilter = {
  bindings: {
    filters: '<',
    itemsCount: '<',
    filtersChanged: '&'
  },
  template: delivery_filter_tpl,
  controller: delivery_filter_controller_DeliveryListHeaderController
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-sub-header/delivery-sub-header-tpl.html
/* harmony default export */ var delivery_sub_header_tpl = ("<div class=\"container-fluid fc-list-sub-header\" ng-if=\"$ctrl.hasDeliveries()\">\n    <div class=\"col-xs-12\">\n        <div class=\"row\">\n            <div class=\"col-xs-3\">\n                <div class=\"release-table-text\">Name</div>\n            </div>\n            <div class=\"col-xs-2\">\n                <div class=\"release-table-text\">Active Stage</div>\n            </div>\n            <div class=\"col-xs-7\">\n                <div class=\"row\">\n                    <div class=\"col-xs-4\"></div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">Start date</div>\n                    </div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">End date</div>\n                    </div>\n                    <div class=\"col-xs-2\">\n                        <div class=\"release-table-text\">Remaining duration</div>\n                    </div>\n                    <div class=\"col-xs-2\"></div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/delivery-sub-header/index.js

var deliverySubHeader = {
  bindings: {
    hasDeliveries: '&'
  },
  template: delivery_sub_header_tpl
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries-tpl.html
/* harmony default export */ var deliveries_tpl = ("<div class=\"fc-list f-deliveries header\" id=\"deliveries\">\n    <div class=\"fc-list-header\">\n        <div class=\"fc-list-header-actions\">\n            <delivery-filter filters=\"$ctrl.filters\"\n                             filters-changed=\"$ctrl.filtersChanged()\"\n                             items-count=\"$ctrl.itemsCount\"></delivery-filter>\n            <delivery-sub-header has-deliveries=\"$ctrl.hasDeliveries()\"></delivery-sub-header>\n        </div>\n    </div>\n    <div class=\"fc-list-items-wrapper\">\n        <xlr-delivery-list deliveries=\"$ctrl.deliveries\"\n                           deliveries-loading-status=\"$ctrl.loading\"\n                           deliveries-has-more=\"$ctrl.hasMoreDeliveries\"\n                           on-show-more-deliveries=\"$ctrl.loadMoreDeliveries()\">\n        </xlr-delivery-list>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries-controller.js





var deliveries_controller_DeliveriesController = /*#__PURE__*/function () {
  function DeliveriesController($scope, Events, $uibModal, $ngRedux) {
    classCallCheck_default()(this, DeliveriesController);

    this._$scope = $scope;
    this._Events = Events;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis, this._mapDispatchToThis.call(this, $uibModal))(this);
  }

  createClass_default()(DeliveriesController, [{
    key: "$onInit",
    value: function $onInit() {
      if (this.folder) {
        this.filters.folderId = this.folder.id;
      }

      this._$scope.$emit(this._Events.permission.refresh);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(uibModalService) {
      return function (dispatch) {
        return {
          loadMoreDeliveries: function loadMoreDeliveries() {
            dispatch(Object(deliveries_actions["e" /* getMoreDeliveries */])());
          },
          updateFilters: function updateFilters(filters) {
            dispatch(Object(deliveries_actions["f" /* setFilters */])(filters, true));
          },
          deleteDelivery: function deleteDelivery() {
            dispatch(Object(deliveries_actions["c" /* deleteDelivery */])(uibModalService));
          }
        };
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.deliveries;
      return {
        deliveries: reducer.deliveries,
        itemsCount: reducer.itemsCount,
        loading: reducer.loading,
        hasMoreDeliveries: reducer.hasMoreDeliveries,
        filters: reducer.filters.toJS()
      };
    }
  }, {
    key: "filtersChanged",
    value: function filtersChanged() {
      this.updateFilters(this.filters);
    }
  }, {
    key: "hasDeliveries",
    value: function hasDeliveries() {
      return !!_.get(this.deliveries, 'size');
    }
  }]);

  return DeliveriesController;
}();

defineProperty_default()(deliveries_controller_DeliveriesController, "$inject", ['$scope', 'Events', '$uibModal', '$ngRedux']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries-component.js


/* harmony default export */ var deliveries_component = ({
  bindings: {
    filters: '<'
  },
  controller: deliveries_controller_DeliveriesController,
  template: deliveries_tpl
});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries.less
var deliveries = __webpack_require__(873);
var deliveries_default = /*#__PURE__*/__webpack_require__.n(deliveries);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/deliveries.less

            

var deliveries_options = {};

deliveries_options.insert = "head";
deliveries_options.singleton = false;

var deliveries_update = injectStylesIntoStyleTag_default()(deliveries_default.a, deliveries_options);



/* harmony default export */ var deliveries_deliveries = (deliveries_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries/index.js








/* harmony default export */ var include_deliveries = (angular.module('xlrelease.deliveries', []).component('deliveryStatusLabel', release_status_label["a" /* releaseStatusLabelComponent */]).component('xlrDeliveryList', deliveryListComponent).component('xlrDeliveryRow', deliveryRowComponent).component('confirmDeleteDelivery', ConfirmDeleteDelivery).component('deliveryFilter', deliveryFilter).component('deliverySubHeader', deliverySubHeader).component('deliveries', deliveries_component).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('deliveries', {
    url: '/deliveries',
    reloadOnSearch: false,
    controller: ['filters', function (filters) {
      this.filters = filters;
    }],
    template: '<deliveries filters="$ctrl.filters" />',
    controllerAs: '$ctrl',
    resolve: {
      filters: ['Filters', function (Filters) {
        return Filters.getDeliveriesFilterSettings();
      }]
    }
  });
}]).name);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/header/delivery-header-controller.js



var delivery_header_controller_DeliveryHeaderController = /*#__PURE__*/function () {
  function DeliveryHeaderController($parse, $location, UiExtensionsService, Page) {
    var _this = this;

    classCallCheck_default()(this, DeliveryHeaderController);

    defineProperty_default()(this, "isSubpageDisplayed", function (subpage) {
      if (_.isString(subpage.displayIf)) {
        var displayFunction = _this._$parse(subpage.displayIf);

        return displayFunction(_this);
      }

      return !subpage.hidden;
    });

    defineProperty_default()(this, "getSubpageLink", function (subpage) {
      return "#/".concat(_this.delivery.status === 'TEMPLATE' ? 'delivery-patterns' : 'deliveries', "/").concat(_this.delivery.id).concat(subpage.path);
    });

    this._$parse = $parse;
    this._$location = $location;
    this._UiExtensionsService = UiExtensionsService;
    this._Page = Page;
    this._isBreadCrumbInitialized = false;
    this.isSubpageDropdownAvailable = false;
  }

  createClass_default()(DeliveryHeaderController, [{
    key: "$onInit",
    value: function $onInit() {
      if (this.delivery) {
        this._initDropdown();
      }
    }
  }, {
    key: "$onChanges",
    value: function $onChanges(changes) {
      var delivery = changes.delivery;

      if (delivery && delivery.previousValue === null && delivery.currentValue !== null) {
        this._initDropdown();
      }
    }
  }, {
    key: "_initDropdown",
    value: function _initDropdown() {
      this._setBreadcrumbs(this.delivery);

      this._generateSubpages(this.delivery);
    }
  }, {
    key: "_generateSubpages",
    value: function _generateSubpages(delivery) {
      var _this2 = this;

      this.isSubpageDropdownAvailable = angular.isDefined(delivery) && !!delivery;

      this._extendSubpages(delivery).then(function (extendedSubpages) {
        _this2.deliverySubpages = extendedSubpages;

        var notDefaultPages = _.omit(_this2.deliverySubpages, '');

        _this2.page = _.find(notDefaultPages, function (aPage) {
          var regexp = new RegExp(aPage.path, 'i');
          return _this2._$location.path().match(regexp); // if current location ends with one of the subpages
        });
        _this2.page = _this2.page || _this2.deliverySubpages[''];
      });
    }
  }, {
    key: "_extendSubpages",
    value: function _extendSubpages(delivery) {
      var menuId = delivery.status === 'TEMPLATE' ? 'xlrelease.DeliveryPatternPageMenu' : 'xlrelease.DeliveryPageMenu';
      return this._UiExtensionsService.getMenuItems(menuId, delivery).then(function (extensions) {
        var extendedSubpages = [];

        _(extensions).filter({
          permitted: true
        }).forEach(function (extension) {
          extendedSubpages[extension.pathSuffix] = {
            path: '/' + extension.pathSuffix,
            label: extension.label,
            weight: extension.weight
          };
        });

        extendedSubpages = _(extendedSubpages).toPairs().sortBy(function (keyValue) {
          return keyValue[1].weight;
        }).fromPairs().value();
        return extendedSubpages;
      });
    }
  }, {
    key: "_setBreadcrumbs",
    value: function _setBreadcrumbs(delivery) {
      if (!this._isBreadCrumbInitialized) {
        this._Page.setFolderEntityOpened(delivery.folderId, delivery);

        this._isBreadCrumbInitialized = true;
      }
    }
  }]);

  return DeliveryHeaderController;
}();

defineProperty_default()(delivery_header_controller_DeliveryHeaderController, "$inject", ['$parse', '$location', 'UiExtensionsService', 'Page']);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/header/delivery-header.html
/* harmony default export */ var delivery_header = ("<div id=\"delivery-header\" class=\"header\">\n    <div class=\"subpage-links\" ng-if=\"$ctrl.isSubpageDropdownAvailable\">\n        <span class=\"show-label\">Show</span>\n        <button type=\"button\" class=\"button dropdown-button\" bs-popover\n                data-content-template=\"static/10.2.6/include/deliveries-details/header/delivery-subpages.html\"\n                data-placement=\"bottom\"\n                auto-close=\"true\">\n            {{ $ctrl.page.label }} <span class=\"caret\"></span>\n        </button>\n    </div>\n\n    <span class=\"header-container-flex\" ng-transclude></span>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/header/index.js


var deliveryDetailsHeader = {
  bindings: {
    delivery: '<?'
  },
  template: delivery_header,
  replace: true,
  transclude: true,
  controller: delivery_header_controller_DeliveryHeaderController,
  controllerAs: '$ctrl'
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/delivery-details-page-extension-container.html
/* harmony default export */ var delivery_details_page_extension_container = ("<div style=\"height: 100%\" ng-if=\"deliveryDetailsPageExtension.pageExtension.uri\"\n     ng-include=\"'static/10.2.6/' + deliveryDetailsPageExtension.pageExtension.uri\"></div>\n<div ng-if=\"deliveryDetailsPageExtension.pageExtension && !deliveryDetailsPageExtension.pageExtension.uri\">\n    <xlr-delivery-details-header delivery=\"deliveryDetailsPageExtension.delivery\"></xlr-delivery-details-header>\n    <div class=\"content-under-header\">\n        <h4>\n            No <strong>uri</strong> parameter specified in delivery menu item [{{ deliveryDetailsPageExtension.pageExtension.label }}]. Please check your plugin.\n            <pre>\n                {{deliveryDetailsPageExtension.pageExtension}}\n            </pre>\n        </h4>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/delivery-pattern.constants.js
var DELIVERY_PATTERN_EDIT_PERMISSION = "delivery_pattern#edit";
var DELIVERY_EDIT_PERMISSION = "delivery#edit";
var DELIVERY_TRACKED_ITEM_EDIT_PERMISSION = "delivery#edit_tracked_item";
var FOLDER_VIEW_PERMISSION = "folder#view";
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/deliveries-details-page-extension-controller.js




var deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController = /*#__PURE__*/function () {
  function DeliveryDetailsPageExtensionController($location, $stateParams, UiExtensionsService, Page, FoldersService, deliveryPromise, Authenticator) {
    classCallCheck_default()(this, DeliveryDetailsPageExtensionController);

    this._$location = $location;
    this._$stateParams = $stateParams;
    this._UiExtensionsService = UiExtensionsService;
    this._Page = Page;
    this._FoldersService = FoldersService;
    this._Authenticator = Authenticator;

    if (deliveryPromise.length === 2) {
      this.delivery = deliveryPromise[0].data;
      this.releases = deliveryPromise[1];
    } else {
      this.releases = [];
      this.delivery = deliveryPromise.data || deliveryPromise;
    }

    this.delivery.isEditable = Authenticator.hasPermission(this.delivery.status === 'TEMPLATE' ? DELIVERY_PATTERN_EDIT_PERMISSION : DELIVERY_EDIT_PERMISSION, this.delivery.$metadata);
    this.delivery.isTrackedItemEditable = Authenticator.hasAnyOfPermissions(this.delivery.status === 'TEMPLATE' ? [DELIVERY_PATTERN_EDIT_PERMISSION] : [DELIVERY_EDIT_PERMISSION, DELIVERY_TRACKED_ITEM_EDIT_PERMISSION], this.delivery.$metadata);
    this.delivery.canCreateDelivery = Authenticator.hasPermission(DELIVERY_EDIT_PERMISSION, this.delivery.$metadata);
  }

  createClass_default()(DeliveryDetailsPageExtensionController, [{
    key: "$onInit",
    value: function $onInit() {
      this._loadPageExtension();
    }
  }, {
    key: "_redirectToDefaultPage",
    value: function _redirectToDefaultPage() {
      // If the current URL is /deliveries/Delivery1, we redirect the user to 'deliveries'
      var defaultPage = this._$location.path().substring(1);

      defaultPage = defaultPage.substring(0, defaultPage.indexOf('/'));

      this._$location.url(defaultPage);
    }
  }, {
    key: "_loadPageExtension",
    value: function _loadPageExtension() {
      var _this = this;

      var canViewFolder = this._Authenticator.hasPermission(FOLDER_VIEW_PERMISSION, this.delivery.$metadata);

      var menuId = this.delivery.status === 'TEMPLATE' ? 'xlrelease.DeliveryPatternPageMenu' : 'xlrelease.DeliveryPageMenu';

      var getExtension = function getExtension(list) {
        return _.find(list, {
          pathSuffix: _this._$stateParams.extensionPath || "",
          permitted: true
        });
      };

      if (canViewFolder) {
        this._FoldersService.get(this.delivery.folderId).then(function (folder) {
          _this.folder = folder;

          _this._UiExtensionsService.getMenuItems(menuId, folder).then(function (extensions) {
            _this.pageExtension = getExtension(extensions);

            if (_this.pageExtension) {
              _this._Page.setFolderEntityOpened(_this.delivery.folderId, _this.delivery);
            } else {
              _this._redirectToDefaultPage();
            }
          });
        });
      } else {
        this._UiExtensionsService.getMenuItems(menuId).then(function (extensions) {
          _this.pageExtension = getExtension(extensions);

          if (_this.pageExtension) {
            _this._Page.setDeliveryOpened(_this.delivery);
          } else {
            _this._redirectToDefaultPage();
          }
        });
      }
    }
  }]);

  return DeliveryDetailsPageExtensionController;
}();

defineProperty_default()(deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController, "$inject", ['$location', '$stateParams', 'UiExtensionsService', 'Page', 'FoldersService', 'deliveryPromise', 'Authenticator']);
// EXTERNAL MODULE: ./node_modules/react2angular/index.js
var react2angular = __webpack_require__(44);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/prop-types/index.js
var prop_types = __webpack_require__(2);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);

// EXTERNAL MODULE: ./node_modules/react-redux/es/index.js + 22 modules
var es = __webpack_require__(19);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/typeof.js
var helpers_typeof = __webpack_require__(80);
var typeof_default = /*#__PURE__*/__webpack_require__.n(helpers_typeof);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/regenerator/index.js
var regenerator = __webpack_require__(7);
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);

// EXTERNAL MODULE: ./node_modules/redux/es/redux.js
var redux = __webpack_require__(50);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-core-npm-proxy.esm.js + 3 modules
var redux_saga_core_npm_proxy_esm = __webpack_require__(119);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-effects-npm-proxy.esm.js + 1 modules
var redux_saga_effects_npm_proxy_esm = __webpack_require__(3);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toConsumableArray.js
var toConsumableArray = __webpack_require__(23);
var toConsumableArray_default = /*#__PURE__*/__webpack_require__.n(toConsumableArray);

// EXTERNAL MODULE: ./node_modules/lodash/differenceBy.js
var differenceBy = __webpack_require__(348);
var differenceBy_default = /*#__PURE__*/__webpack_require__.n(differenceBy);

// EXTERNAL MODULE: ./node_modules/lodash/intersectionBy.js
var intersectionBy = __webpack_require__(1290);
var intersectionBy_default = /*#__PURE__*/__webpack_require__.n(intersectionBy);

// EXTERNAL MODULE: ./node_modules/lodash/last.js
var last = __webpack_require__(111);
var last_default = /*#__PURE__*/__webpack_require__.n(last);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/delivery-flow.actions.js
var actionTypes = {
  FULL_DELIVERY_DETAILS_REQUEST: 'FULL_DELIVERY_DETAILS_REQUEST',
  TRACKED_ITEM_CREATE_OR_UPDATE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/CREATE_OR_UPDATE_REQUEST',
  TRACKED_ITEM_CREATE_OR_UPDATE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/CREATE_OR_UPDATE_SUCCESS',
  TRACKED_ITEM_REMOVE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/REMOVE_REQUEST',
  TRACKED_ITEM_REMOVE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/REMOVE_SUCCESS',
  TRACKED_ITEM_DESCOPE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/DESCOPE_REQUEST',
  TRACKED_ITEM_RESCOPE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/RESCOPE_REQUEST',
  TRACKED_ITEM_SKIP_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/SKIP_REQUEST',
  TRACKED_ITEM_COMPLETE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/COMPLETE_REQUEST',
  TRACKED_ITEM_SKIP_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/SKIP_SUCCESS',
  TRACKED_ITEM_COMPLETE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/COMPLETE_SUCCESS',
  TRACKED_ITEM_UPDATE_DATA: 'TRACKED_ITEM_DELIVERY_FLOW/UPDATE_DATA',
  TRACKED_ITEM_STAGE_RELEASE_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/STAGE_RELEASE_REQUEST',
  TRACKED_ITEM_STAGE_RELEASE_SUCCESS: 'TRACKED_ITEM_DELIVERY_FLOW/STAGE_RELEASE_SUCCESS',
  TRACKED_ITEM_STAGE_TRANSITION_REQUEST: 'TRACKED_ITEM_DELIVERY_FLOW/STAGE_TRANSITION_REQUEST',
  TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING: 'TRACKED_ITEM_DELIVERY_FLOW/TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING',
  TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING: 'TRACKED_ITEM_DELIVERY_FLOW/TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING',
  TRACKED_ITEM_DELIVERY_DETAIL_POLLING_FAILURE: 'TRACKED_ITEM_DELIVERY_FLOW/TRACKED_ITEM_DELIVERY_DETAIL_POLLING_FAILURE',
  STAGE_COMPLETE_REQUEST: 'STAGE/COMPLETE_REQUEST',
  STAGE_COMPLETE_SUCCESS: 'STAGE/COMPLETE_SUCCESS',
  STAGE_REOPEN_REQUEST: 'STAGE/REOPEN_REQUEST',
  STAGE_REOPEN_SUCCESS: 'STAGE/REOPEN_SUCCESS',
  TRACKED_ITEM_APPROVALS_REQUEST: 'TRACKED_ITEM_APPROVALS_REQUEST',
  TRACKED_ITEM_APPROVALS_UPDATE: 'TRACKED_ITEM_APPROVALS_UPDATE',
  TRANSITION_ACTIVATE_REQUEST: 'TRANSITION/ACTIVATE_REQUEST',
  TRANSITION_ACTIVATE: 'TRANSITION/ACTIVATE',
  TRANSITION_DEACTIVATE_REQUEST: 'TRANSITION/DEACTIVATE_REQUEST',
  TRANSITION_DEACTIVATE: 'TRANSITION/DEACTIVATE',
  TRANSITION_SELECTION_UPDATE: 'TRANSITION/SELECTION_UPDATE',
  TRANSITION_TAB_CHANGE_REQUEST: 'TRANSITION/TRANSITION_TAB_CHANGE_REQUEST',
  TRANSITION_TAB_CHANGE: 'TRANSITION/TRANSITION_TAB_CHANGE',
  CONDITIONS_SAVE_REQUEST: 'TRANSITION/CONDITIONS_SAVE_REQUEST',
  CONDITION_UPDATE_SUCCESS: 'TRANSITION/CONDITION_UPDATE_SUCCESS',
  CONDITION_RESET_SUCCESS: 'TRANSITION/CONDITION_RESET_SUCCESS',
  CONDITION_EDIT_MODE_CHANGE_REQUEST: 'TRANSITION/CONDITION_EDIT_MODE_CHANGE_REQUEST',
  CONDITION_EDIT_MODE_CHANGE_RESPONSE: 'TRANSITION/CONDITION_EDIT_MODE_CHANGE_RESPONSE',
  SET_DATETIME_FORMAT_REQUEST: 'DELIVERY/SET_DATETIME_FORMAT_REQUEST',
  SET_DATETIME_FORMAT_SUCCESS: 'DELIVERY/SET_DATETIME_FORMAT_SUCCESS',
  MARK_TRANSITION_AUTOMATED: 'TRANSITION/MARK_AUTOMATED_SUCCESS'
};
var createOrUpdateTrackedItem = function createOrUpdateTrackedItem(trackedItem, deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_REQUEST,
    payload: {
      trackedItem: trackedItem,
      deliveryId: deliveryId
    }
  };
};
var fetchDeliveryDetails = function fetchDeliveryDetails(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_SUCCESS,
    payload: deliveryId
  };
};
var delivery_flow_actions_requestTrackedItemApprovals = function requestTrackedItemApprovals(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_APPROVALS_REQUEST,
    payload: deliveryId
  };
};
var updateTrackedItemApprovals = function updateTrackedItemApprovals(logs) {
  return {
    type: actionTypes.TRACKED_ITEM_APPROVALS_UPDATE,
    payload: logs
  };
};
var updateDataState = function updateDataState(delivery) {
  return {
    type: actionTypes.TRACKED_ITEM_UPDATE_DATA,
    payload: delivery
  };
};
var removeTrackedItem = function removeTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_REMOVE_REQUEST,
    payload: id
  };
};
var removedTrackedItem = function removedTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_REMOVE_SUCCESS,
    payload: id
  };
};
var delivery_flow_actions_descopeTrackedItem = function descopeTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_DESCOPE_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_rescopeTrackedItem = function rescopeTrackedItem(id) {
  return {
    type: actionTypes.TRACKED_ITEM_RESCOPE_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_skipTrackedItem = function skipTrackedItem(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_SKIP_REQUEST,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var delivery_flow_actions_completeTrackedItem = function completeTrackedItem(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_COMPLETE_REQUEST,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var trackedItemSkipped = function trackedItemSkipped(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_SKIP_SUCCESS,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var trackedItemCompleted = function trackedItemCompleted(stage, trackedItem) {
  return {
    type: actionTypes.TRACKED_ITEM_COMPLETE_SUCCESS,
    payload: {
      stage: stage,
      trackedItem: trackedItem
    }
  };
};
var delivery_flow_actions_getStageReleaseDetails = function getStageReleaseDetails(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST,
    payload: deliveryId
  };
};
var fetchStageReleasesSuccess = function fetchStageReleasesSuccess(releaseListDetails) {
  return {
    type: actionTypes.TRACKED_ITEM_STAGE_RELEASE_SUCCESS,
    payload: releaseListDetails
  };
};
var delivery_flow_actions_postTransitionDetails = function postTransitionDetails(deliveryId, transition, transitionItems) {
  return {
    type: actionTypes.TRACKED_ITEM_STAGE_TRANSITION_REQUEST,
    payload: {
      deliveryId: deliveryId,
      transition: transition,
      transitionItems: transitionItems
    }
  };
};
var delivery_flow_actions_fetchDeliveryDetailsWithPolling = function fetchDeliveryDetailsWithPolling(deliveryId) {
  return {
    type: actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING,
    payload: {
      deliveryId: deliveryId
    }
  };
};
var delivery_flow_actions_stopPolling = function stopPolling() {
  return {
    type: actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING
  };
};
var delivery_flow_actions_completeStage = function completeStage(id) {
  return {
    type: actionTypes.STAGE_COMPLETE_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_reopenStage = function reopenStage(id) {
  return {
    type: actionTypes.STAGE_REOPEN_REQUEST,
    payload: id
  };
};
var delivery_flow_actions_activateTransition = function activateTransition(stage) {
  return {
    type: actionTypes.TRANSITION_ACTIVATE_REQUEST,
    payload: stage
  };
};
var updateActivateTransition = function updateActivateTransition(stage) {
  return {
    type: actionTypes.TRANSITION_ACTIVATE,
    payload: stage
  };
};
var delivery_flow_actions_deactivateTransition = function deactivateTransition() {
  return {
    type: actionTypes.TRANSITION_DEACTIVATE_REQUEST
  };
};
var updateDeactivateTransition = function updateDeactivateTransition() {
  return {
    type: actionTypes.TRANSITION_DEACTIVATE
  };
};
var delivery_flow_actions_updateTransitionSelection = function updateTransitionSelection(selection) {
  return {
    type: actionTypes.TRANSITION_SELECTION_UPDATE,
    payload: selection
  };
};
var delivery_flow_actions_changeTransitionTab = function changeTransitionTab(tab) {
  return {
    type: actionTypes.TRANSITION_TAB_CHANGE_REQUEST,
    payload: tab
  };
};
var updateTransitionTabValue = function updateTransitionTabValue(tab) {
  return {
    type: actionTypes.TRANSITION_TAB_CHANGE,
    payload: tab
  };
};
var delivery_flow_actions_saveConditions = function saveConditions() {
  return {
    type: actionTypes.CONDITIONS_SAVE_REQUEST
  };
};
var delivery_flow_actions_updateCondition = function updateCondition(conditionId, fixedDate) {
  return {
    type: actionTypes.CONDITION_UPDATE_SUCCESS,
    payload: {
      conditionId: conditionId,
      fixedDate: fixedDate
    }
  };
};
var delivery_flow_actions_resetConditions = function resetConditions() {
  return {
    type: actionTypes.CONDITION_RESET_SUCCESS
  };
};
var delivery_flow_actions_showConditionEditMode = function showConditionEditMode(isConditionEditMode) {
  return {
    type: actionTypes.CONDITION_EDIT_MODE_CHANGE_REQUEST,
    payload: isConditionEditMode
  };
};
var changeConditionEditMode = function changeConditionEditMode(isConditionEditMode) {
  return {
    type: actionTypes.CONDITION_EDIT_MODE_CHANGE_RESPONSE,
    payload: isConditionEditMode
  };
};
var delivery_flow_actions_setDateTimeFormat = function setDateTimeFormat() {
  return {
    type: actionTypes.SET_DATETIME_FORMAT_REQUEST
  };
};
var dateTimeFormatSet = function dateTimeFormatSet(data) {
  return {
    type: actionTypes.SET_DATETIME_FORMAT_SUCCESS,
    payload: data
  };
};
var delivery_flow_actions_markTransitionAutomated = function markTransitionAutomated() {
  return {
    type: actionTypes.MARK_TRANSITION_AUTOMATED
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.utils.js
var countSelectedTransitionItems = function countSelectedTransitionItems(items) {
  return items.filter(function (item) {
    return item.transitionItem && !item.transitionItem.disabled && item.transitionItem.checked;
  }).length;
};
var isDisabledTransition = function isDisabledTransition(transition) {
  return transition.selectedTransitionItemCount === 0 && !transition.closeStages;
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.constants.js
var trackedItemStatus = {
  notReady: 'NOT_READY',
  ready: 'READY',
  skipped: 'SKIPPED'
};
var delivery_flow_constants_deliveryStatus = {
  inProgress: 'IN_PROGRESS',
  completed: 'COMPLETED',
  pattern: 'TEMPLATE'
};
var activePhaseStatuses = ['IN_PROGRESS', 'FAILING', 'FAILED'];
var activeTaskStatus = ['PENDING', 'PRECONDITION_IN_PROGRESS', 'FAILURE_HANDLER_IN_PROGRESS', 'IN_PROGRESS', 'FAILING', 'FAILED', 'WAITING_FOR_INPUT'];
var transitionTabs = [{
  value: 0,
  label: 'Automated'
}, {
  value: 1,
  label: 'Manual'
}];
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/delivery-flow.reducer.js



function delivery_flow_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_flow_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_flow_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_flow_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






 // -- REDUCER --

var delivery_flow_reducer_initialState = function initialState() {
  return {
    activeStageReleases: [],
    loadingReleasesInfo: false,
    trackedItems: [],
    stages: [],
    status: '',
    trackedItemApprovals: [],
    activeTransition: {
      id: null,
      items: [],
      status: null,
      automated: null
    },
    activeTransitionTab: transitionTabs[0].value,
    conditionChanges: [],
    // [ {id: conditionId1, time: time1}, {id: conditionId2, time: time2} ]
    isConditionEditMode: false,
    dateFormat: 'MMM DD, YYYY',
    timeFormat: 'h:mm a'
  };
};

var delivery_flow_reducer_deliveryFlow = function deliveryFlow() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : delivery_flow_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case actionTypes.TRACKED_ITEM_APPROVALS_UPDATE:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          trackedItemApprovals: action.payload
        });
      }

    case actionTypes.TRACKED_ITEM_UPDATE_DATA:
      {
        var activeTransition = state.activeTransition;
        var _action$payload = action.payload,
            trackedItems = _action$payload.trackedItems,
            stages = _action$payload.stages,
            status = _action$payload.status;
        var formattedStages = delivery_flow_reducer_mapTransitionsInStages(stages, trackedItems, state.activeTransition);

        if (!!activeTransition.id) {
          var activeStage = formattedStages.find(function (s) {
            return s.transition && s.transition.id === activeTransition.id;
          });

          if (!!activeStage) {
            activeTransition.items = activeStage.items.filter(function (item) {
              return item.transitionItem !== null;
            });
            activeTransition.status = activeStage.transition;
          }
        }

        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          trackedItems: trackedItems,
          stages: formattedStages,
          status: status
        });
      }

    case actionTypes.TRACKED_ITEM_REMOVE_SUCCESS:
      {
        var _trackedItems = state.trackedItems,
            _activeTransition = state.activeTransition;

        if (!!_activeTransition.id) {
          _activeTransition.items = toConsumableArray_default()(_activeTransition.items.filter(function (item) {
            return item.trackedItemId !== action.payload;
          }));
        }

        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          trackedItems: _trackedItems.filter(function (item) {
            return item.id !== action.payload;
          })
        });
      }

    case actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          loadingReleasesInfo: true
        });
      }

    case actionTypes.TRACKED_ITEM_STAGE_RELEASE_SUCCESS:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          activeStageReleases: action.payload,
          loadingReleasesInfo: false
        });
      }

    case actionTypes.TRANSITION_ACTIVATE:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          activeTransition: action.payload,
          activeTransitionTab: delivery_flow_reducer_initialState().activeTransitionTab
        });
      }

    case actionTypes.TRANSITION_DEACTIVATE:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          activeTransition: delivery_flow_reducer_initialState().activeTransition
        });
      }

    case actionTypes.TRANSITION_SELECTION_UPDATE:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          activeTransition: {
            id: state.activeTransition.id,
            items: action.payload.items,
            status: action.payload.status
          }
        });
      }

    case actionTypes.TRANSITION_TAB_CHANGE:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          activeTransitionTab: action.payload
        });
      }

    case actionTypes.TRACKED_ITEM_SKIP_SUCCESS:
      {
        var _stages = state.stages,
            _activeTransition2 = state.activeTransition,
            _trackedItems2 = state.trackedItems;
        var _action$payload2 = action.payload,
            stage = _action$payload2.stage,
            trackedItem = _action$payload2.trackedItem;
        var updatedState = delivery_flow_reducer_updateItemStatus(_stages, _activeTransition2, stage, trackedItem, trackedItemStatus.skipped, _trackedItems2);
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          stages: updatedState.stages,
          activeTransition: updatedState.activeTransition
        });
      }

    case actionTypes.TRACKED_ITEM_COMPLETE_SUCCESS:
      {
        var _stages2 = state.stages,
            _activeTransition3 = state.activeTransition,
            _trackedItems3 = state.trackedItems;
        var _action$payload3 = action.payload,
            _stage = _action$payload3.stage,
            _trackedItem = _action$payload3.trackedItem;

        var _updatedState = delivery_flow_reducer_updateItemStatus(_stages2, _activeTransition3, _stage, _trackedItem, trackedItemStatus.ready, _trackedItems3);

        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          stages: _updatedState.stages,
          activeTransition: _updatedState.activeTransition
        });
      }

    case actionTypes.CONDITION_UPDATE_SUCCESS:
      {
        var _action$payload4 = action.payload,
            conditionId = _action$payload4.conditionId,
            fixedDate = _action$payload4.fixedDate;
        var conditionChanges = state.conditionChanges.map(function (c) {
          return delivery_flow_reducer_objectSpread({}, c);
        }) || [];
        var found = conditionChanges.find(function (c) {
          return c.id === conditionId;
        });

        if (found) {
          found.fixedDate = fixedDate;
        } else {
          conditionChanges.push({
            id: conditionId,
            fixedDate: fixedDate
          });
        }

        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          conditionChanges: conditionChanges
        });
      }

    case actionTypes.CONDITION_RESET_SUCCESS:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          conditionChanges: []
        });
      }

    case actionTypes.CONDITION_EDIT_MODE_CHANGE_RESPONSE:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          isConditionEditMode: action.payload
        });
      }

    case actionTypes.SET_DATETIME_FORMAT_SUCCESS:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          dateFormat: action.payload.mediumDate,
          timeFormat: action.payload.shortTime
        });
      }

    case actionTypes.MARK_TRANSITION_AUTOMATED:
      {
        return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state), {}, {
          activeTransition: delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state.activeTransition), {}, {
            status: delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, state.activeTransition.status), {}, {
              automated: true
            })
          })
        });
      }

    default:
      return state;
  }
};

var delivery_flow_reducer_updateItemStatus = function updateItemStatus(oldStages, activeTransition, stage, trackedItem, itemStatus, trackedItems) {
  var stagesWithUpdatedItem = oldStages.map(function (s) {
    if (s.id === stage.id) {
      var items = s.items.map(function (item) {
        if (item.trackedItemId === trackedItem.id) {
          return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, item), {}, {
            status: itemStatus
          });
        }

        return delivery_flow_reducer_objectSpread({}, item);
      });
      return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, s), {}, {
        items: items
      });
    }

    return s;
  });
  var stages = stagesWithUpdatedItem.map(function (s, stageIndex) {
    if (s.transition) {
      var expandedStage = delivery_flow_reducer_formatTransitionOnStage(s.transition, trackedItems, activeTransition, stagesWithUpdatedItem, stageIndex);
      return expandedStage;
    } else {
      return s;
    }
  });

  if (!!activeTransition.id) {
    var stageWithActiveTransition = stages.find(function (s) {
      return s.id === activeTransition.status.stage;
    });
    activeTransition.items = stageWithActiveTransition.items.filter(function (item) {
      return item.transitionItem !== null;
    });
    activeTransition.status.selectedTransitionItemCount = countSelectedTransitionItems(stageWithActiveTransition.items);
  }

  return {
    stages: stages,
    activeTransition: activeTransition
  };
};

var delivery_flow_reducer_mapTransitionsInStages = function mapTransitionsInStages(stages, trackedItems, activeTransition) {
  // create an object with transitions and tracked item status whether its moved to other
  // stage or not this will help us to decide whether to show the checkbox as checked or not
  var modifiedStages = [];

  for (var stageIndex = 0; stageIndex < stages.length - 1; stageIndex++) {
    var transition = stages[stageIndex].transition;

    if (transition && !!transition) {
      var expandedStage = delivery_flow_reducer_formatTransitionOnStage(transition, trackedItems, activeTransition, stages, stageIndex);
      modifiedStages.push(expandedStage);
    } else {
      modifiedStages.push(stages[stageIndex]);
    }
  }

  modifiedStages.push(last_default()(stages));
  return modifiedStages;
};

var delivery_flow_reducer_formatTransitionOnStage = function formatTransitionOnStage(transition, trackedItems, activeTransition, stages, stageIndex) {
  var isItemDoneInStage = function isItemDoneInStage(stage, trackedItemId) {
    return stage.items.some(function (stageItem) {
      return stageItem.trackedItemId === trackedItemId && (stageItem.status === trackedItemStatus.ready || stageItem.status === trackedItemStatus.skipped);
    });
  }; // completed items for checkbox visibility


  var listOfReadyItemsInCurrentStage = stages[stageIndex].items.filter(function (currItem) {
    return !trackedItems.find(function (item) {
      return item.id === currItem.trackedItemId;
    }).descoped && stages.slice(0, stageIndex + 1).every(function (stage) {
      return isItemDoneInStage(stage, currItem.trackedItemId);
    });
  });
  var listOfItemsInNextStage = stages[stageIndex + 1].items; // compare next stage for availability

  var readyItems = differenceBy_default()(listOfReadyItemsInCurrentStage, listOfItemsInNextStage, 'trackedItemId');
  var alreadyTransitionedItems = intersectionBy_default()(listOfReadyItemsInCurrentStage, listOfItemsInNextStage, 'trackedItemId');
  var readyItemsExpanded = readyItems.map(function (item) {
    return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, item), {}, {
      transitionItem: {
        disabled: false,
        checked: true
      }
    });
  });
  var alreadyTransitionedItemsExpanded = alreadyTransitionedItems.map(function (item) {
    return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, item), {}, {
      transitionItem: {
        disabled: true,
        checked: true
      }
    });
  });
  var transitionItems = [].concat(toConsumableArray_default()(readyItemsExpanded), toConsumableArray_default()(alreadyTransitionedItemsExpanded));

  if (activeTransition.id && transition.id === activeTransition.id) {
    transitionItems.filter(function (item) {
      return !item.transitionItem.disabled;
    }).forEach(function (item) {
      var activeItem = activeTransition.items.find(function (i) {
        return i.id === item.id;
      });

      if (activeItem && activeItem.transitionItem) {
        item.transitionItem.checked = activeItem.transitionItem.checked;
        item.transitionItem.disabled = activeItem.transitionItem.disabled;
      } else {
        item.transitionItem.checked = false;
      }
    });
  }

  var items = stages[stageIndex].items.map(function (item) {
    var i = transitionItems.find(function (transitionItem) {
      return transitionItem.trackedItemId === item.trackedItemId;
    });

    if (i) {
      return delivery_flow_reducer_objectSpread({}, i);
    } else {
      return delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, item), {}, {
        transitionItem: null
      });
    }
  });

  var expandedStage = delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, stages[stageIndex]), {}, {
    items: items,
    transition: delivery_flow_reducer_objectSpread(delivery_flow_reducer_objectSpread({}, transition), {}, {
      selectedTransitionItemCount: countSelectedTransitionItems(items),
      closeStages: activeTransition.status ? activeTransition.status.closeStages : false
    }),
    selectableItemsCount: readyItems.length
  });

  expandedStage.transition.disabledTransition = isDisabledTransition(expandedStage.transition);
  return expandedStage;
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.service.js


function delivery_flow_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_flow_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_flow_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_flow_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var delivery_flow_service_API_URL = 'api/v1/deliveries';

function createItem(deliveryId, item) {
  return Object(http["e" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(deliveryId, "/tracked-items"), delivery_flow_service_objectSpread(delivery_flow_service_objectSpread({}, item), {}, {
    id: null,
    type: 'delivery.TrackedItem'
  })).then(function (res) {
    return res.data;
  });
}

function updateItem(item) {
  return Object(http["g" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(item.id), item).then(function (res) {
    return res.data;
  });
}

function removeItem(itemId) {
  return Object(http["b" /* httpDELETE */])("".concat(delivery_flow_service_API_URL, "/").concat(itemId)).then(function (res) {
    return res.data;
  });
}

function descopeItem(itemId) {
  return Object(http["g" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(itemId, "/descope")).then(function (res) {
    return res.data;
  });
}

function rescopeItem(itemId) {
  return Object(http["g" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(itemId, "/rescope")).then(function (res) {
    return res.data;
  });
}

function skipItem(stageId, trackedItemId) {
  return Object(http["g" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/").concat(trackedItemId, "/skip")).then(function (res) {
    return res.data;
  });
}

function completeItem(stageId, trackedItemId) {
  return Object(http["g" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/").concat(trackedItemId, "/complete")).then(function (res) {
    return res.data;
  });
}

function delivery_flow_service_list(deliveryId) {
  return Object(http["c" /* httpGET */])("".concat(delivery_flow_service_API_URL, "/").concat(deliveryId, "/tracked-items")).then(function (res) {
    return res.data;
  });
}

function fetchStageReleases(deliveryId) {
  return Object(http["c" /* httpGET */])("".concat(delivery_flow_service_API_URL, "/").concat(deliveryId, "/releases")).then(function (res) {
    return res.data;
  });
}

function makeTransition(transitionId, completableTrackedItems) {
  return Object(http["e" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(transitionId, "/complete"), completableTrackedItems);
}

function delivery_flow_service_completeStage(stageId) {
  return Object(http["e" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/complete"));
}

function delivery_flow_service_reopenStage(stageId) {
  return Object(http["e" /* httpPOST */])("".concat(delivery_flow_service_API_URL, "/").concat(stageId, "/reopen"));
}

function delivery_flow_service_updateTransition(transition) {
  return Object(http["g" /* httpPUT */])("".concat(delivery_flow_service_API_URL, "/").concat(transition.id), delivery_flow_service_objectSpread(delivery_flow_service_objectSpread({}, transition), {}, {
    type: 'delivery.Transition',
    stage: undefined
  }));
}

var deliveryFlowService = {
  createItem: createItem,
  updateItem: updateItem,
  removeItem: removeItem,
  descopeItem: descopeItem,
  rescopeItem: rescopeItem,
  skipItem: skipItem,
  completeItem: completeItem,
  list: delivery_flow_service_list,
  fetchStageReleases: fetchStageReleases,
  makeTransition: makeTransition,
  completeStage: delivery_flow_service_completeStage,
  reopenStage: delivery_flow_service_reopenStage,
  updateTransition: delivery_flow_service_updateTransition
};
// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/ids.js
var util_ids = __webpack_require__(53);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/utils/sagas.js
var sagas = __webpack_require__(70);

// EXTERNAL MODULE: ./node_modules/lodash/cloneDeep.js
var cloneDeep = __webpack_require__(89);
var cloneDeep_default = /*#__PURE__*/__webpack_require__.n(cloneDeep);

// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/angular-accessor.js
var angular_accessor = __webpack_require__(26);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/delivery-flow.sagas.js


var _marked = /*#__PURE__*/regenerator_default.a.mark(createOrUpdateItem),
    _marked2 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_removeItem),
    _marked3 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_descopeItem),
    _marked4 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_rescopeItem),
    _marked5 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_skipItem),
    _marked6 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_completeItem),
    _marked7 = /*#__PURE__*/regenerator_default.a.mark(delivery_flow_sagas_fetchDelivery),
    _marked8 = /*#__PURE__*/regenerator_default.a.mark(fetchTrackedItemApprovals),
    _marked9 = /*#__PURE__*/regenerator_default.a.mark(fetchStagesReleases),
    _marked10 = /*#__PURE__*/regenerator_default.a.mark(postTransition),
    _marked11 = /*#__PURE__*/regenerator_default.a.mark(fetchWithPolling),
    _marked12 = /*#__PURE__*/regenerator_default.a.mark(fetchFullDeliveryDetails),
    _marked13 = /*#__PURE__*/regenerator_default.a.mark(watchFetchDeliveryWithPollingSaga),
    _marked14 = /*#__PURE__*/regenerator_default.a.mark(completeStageInDelivery),
    _marked15 = /*#__PURE__*/regenerator_default.a.mark(reopenStageInDelivery),
    _marked16 = /*#__PURE__*/regenerator_default.a.mark(changeConditionDisplayMode),
    _marked17 = /*#__PURE__*/regenerator_default.a.mark(saveConditionChanges),
    _marked18 = /*#__PURE__*/regenerator_default.a.mark(onActivateTransition),
    _marked19 = /*#__PURE__*/regenerator_default.a.mark(onDeactivateTransition),
    _marked20 = /*#__PURE__*/regenerator_default.a.mark(onTransitionTabChange),
    _marked21 = /*#__PURE__*/regenerator_default.a.mark(checkIsAvailableToLeaveConditionBlock),
    _marked22 = /*#__PURE__*/regenerator_default.a.mark(setupDateTimeFormat),
    _marked23 = /*#__PURE__*/regenerator_default.a.mark(deliveryFlowSagas);









var POLLING_INTERVAL = 5000; // -- SAGAS --

function createOrUpdateItem(action) {
  var _action$payload, trackedItem, deliveryId;

  return regenerator_default.a.wrap(function createOrUpdateItem$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _action$payload = action.payload, trackedItem = _action$payload.trackedItem, deliveryId = _action$payload.deliveryId;

          if (!trackedItem.id) {
            _context.next = 9;
            break;
          }

          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.updateItem, trackedItem);

        case 5:
          _context.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 7:
          _context.next = 13;
          break;

        case 9:
          _context.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.createItem, deliveryId, trackedItem);

        case 11:
          _context.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 13:
          _context.next = 18;
          break;

        case 15:
          _context.prev = 15;
          _context.t0 = _context["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while creating or updating tracking item...', _context.t0);
          /* eslint-enable */

        case 18:
        case "end":
          return _context.stop();
      }
    }
  }, _marked, null, [[0, 15]]);
}

function delivery_flow_sagas_removeItem(action) {
  var id;
  return regenerator_default.a.wrap(function removeItem$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          id = action.payload;
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.removeItem, id);

        case 4:
          _context2.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(removedTrackedItem(id));

        case 6:
          _context2.next = 11;
          break;

        case 8:
          _context2.prev = 8;
          _context2.t0 = _context2["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while removing tracking item...', _context2.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context2.stop();
      }
    }
  }, _marked2, null, [[0, 8]]);
}

function delivery_flow_sagas_descopeItem(action) {
  var id;
  return regenerator_default.a.wrap(function descopeItem$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          id = action.payload;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.descopeItem, id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 6:
          _context3.next = 11;
          break;

        case 8:
          _context3.prev = 8;
          _context3.t0 = _context3["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while descoping tracking item...', _context3.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context3.stop();
      }
    }
  }, _marked3, null, [[0, 8]]);
}

function delivery_flow_sagas_rescopeItem(action) {
  var id;
  return regenerator_default.a.wrap(function rescopeItem$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          id = action.payload;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.rescopeItem, id);

        case 4:
          _context4.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 6:
          _context4.next = 11;
          break;

        case 8:
          _context4.prev = 8;
          _context4.t0 = _context4["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while rescoping tracked item...', _context4.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context4.stop();
      }
    }
  }, _marked4, null, [[0, 8]]);
}

function delivery_flow_sagas_skipItem(action) {
  var _action$payload2, stage, trackedItem;

  return regenerator_default.a.wrap(function skipItem$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _action$payload2 = action.payload, stage = _action$payload2.stage, trackedItem = _action$payload2.trackedItem;
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.skipItem, stage.id, trackedItem.id);

        case 4:
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(trackedItemSkipped(stage, trackedItem));

        case 6:
          _context5.next = 11;
          break;

        case 8:
          _context5.prev = 8;
          _context5.t0 = _context5["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while skipping tracking item...', _context5.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context5.stop();
      }
    }
  }, _marked5, null, [[0, 8]]);
}

function delivery_flow_sagas_completeItem(action) {
  var _action$payload3, stage, trackedItem;

  return regenerator_default.a.wrap(function completeItem$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.prev = 0;
          _action$payload3 = action.payload, stage = _action$payload3.stage, trackedItem = _action$payload3.trackedItem;
          _context6.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.completeItem, stage.id, trackedItem.id);

        case 4:
          _context6.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(trackedItemCompleted(stage, trackedItem));

        case 6:
          _context6.next = 11;
          break;

        case 8:
          _context6.prev = 8;
          _context6.t0 = _context6["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while completing tracking item...', _context6.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context6.stop();
      }
    }
  }, _marked6, null, [[0, 8]]);
}

function delivery_flow_sagas_fetchDelivery(action) {
  var deliveryResponse;
  return regenerator_default.a.wrap(function fetchDelivery$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          _context7.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["d" /* getDelivery */], action.payload);

        case 2:
          deliveryResponse = _context7.sent;
          _context7.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateDataState(deliveryResponse.data));

        case 5:
        case "end":
          return _context7.stop();
      }
    }
  }, _marked7);
}

function fetchTrackedItemApprovals(action) {
  var response;
  return regenerator_default.a.wrap(function fetchTrackedItemApprovals$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          _context8.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["e" /* getTrackedItemApprovals */], action.payload);

        case 2:
          response = _context8.sent;
          _context8.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateTrackedItemApprovals(response.data));

        case 5:
        case "end":
          return _context8.stop();
      }
    }
  }, _marked8);
}

function fetchStagesReleases(action) {
  var releaseDetailsList;
  return regenerator_default.a.wrap(function fetchStagesReleases$(_context9) {
    while (1) {
      switch (_context9.prev = _context9.next) {
        case 0:
          _context9.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.fetchStageReleases, action.payload);

        case 2:
          releaseDetailsList = _context9.sent;
          _context9.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchStageReleasesSuccess(releaseDetailsList));

        case 5:
        case "end":
          return _context9.stop();
      }
    }
  }, _marked9);
}

function postTransition(action) {
  var _action$payload4, deliveryId, transition, transitionItems;

  return regenerator_default.a.wrap(function postTransition$(_context10) {
    while (1) {
      switch (_context10.prev = _context10.next) {
        case 0:
          _context10.prev = 0;
          _action$payload4 = action.payload, deliveryId = _action$payload4.deliveryId, transition = _action$payload4.transition, transitionItems = _action$payload4.transitionItems;
          _context10.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.makeTransition, transition.id, {
            transitionItems: transitionItems,
            closeStages: transition.closeStages
          });

        case 4:
          _context10.next = 6;
          return fetchFullDeliveryDetails(deliveryId);

        case 6:
          _context10.next = 11;
          break;

        case 8:
          _context10.prev = 8;
          _context10.t0 = _context10["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while posting transition...', _context10.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context10.stop();
      }
    }
  }, _marked10, null, [[0, 8]]);
}

function delay(duration) {
  var promise = new Promise(function (resolve) {
    setTimeout(function () {
      return resolve(true);
    }, duration);
  });
  return promise;
}

function fetchWithPolling(action) {
  var deliveryId;
  return regenerator_default.a.wrap(function fetchWithPolling$(_context11) {
    while (1) {
      switch (_context11.prev = _context11.next) {
        case 0:
          if (false) {}

          _context11.prev = 1;
          deliveryId = action.payload.deliveryId;
          _context11.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delay, POLLING_INTERVAL);

        case 5:
          _context11.next = 7;
          return fetchFullDeliveryDetails(deliveryId);

        case 7:
          _context11.next = 13;
          break;

        case 9:
          _context11.prev = 9;
          _context11.t0 = _context11["catch"](1);
          _context11.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_POLLING_FAILURE,
            payload: _context11.t0
          });

        case 13:
          _context11.next = 0;
          break;

        case 15:
        case "end":
          return _context11.stop();
      }
    }
  }, _marked11, null, [[1, 9]]);
}

function fetchFullDeliveryDetails(deliveryId) {
  return regenerator_default.a.wrap(function fetchFullDeliveryDetails$(_context12) {
    while (1) {
      switch (_context12.prev = _context12.next) {
        case 0:
          _context12.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 2:
          _context12.next = 4;
          return fetchStagesReleases({
            payload: deliveryId
          });

        case 4:
          _context12.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_flow_actions_requestTrackedItemApprovals(deliveryId));

        case 6:
        case "end":
          return _context12.stop();
      }
    }
  }, _marked12);
}

function watchFetchDeliveryWithPollingSaga() {
  var myAction;
  return regenerator_default.a.wrap(function watchFetchDeliveryWithPollingSaga$(_context13) {
    while (1) {
      switch (_context13.prev = _context13.next) {
        case 0:
          if (false) {}

          _context13.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["j" /* take */])(actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_START_POLLING);

        case 3:
          myAction = _context13.sent;
          _context13.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["h" /* race */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(fetchWithPolling, myAction), Object(redux_saga_effects_npm_proxy_esm["j" /* take */])(actionTypes.TRACKED_ITEM_DELIVERY_DETAIL_STOP_POLLING)]);

        case 6:
          _context13.next = 0;
          break;

        case 8:
        case "end":
          return _context13.stop();
      }
    }
  }, _marked13);
}

function completeStageInDelivery(action) {
  var id;
  return regenerator_default.a.wrap(function completeStageInDelivery$(_context14) {
    while (1) {
      switch (_context14.prev = _context14.next) {
        case 0:
          id = action.payload;
          _context14.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.completeStage, id);

        case 3:
          _context14.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 5:
        case "end":
          return _context14.stop();
      }
    }
  }, _marked14);
}

function reopenStageInDelivery(action) {
  var id;
  return regenerator_default.a.wrap(function reopenStageInDelivery$(_context15) {
    while (1) {
      switch (_context15.prev = _context15.next) {
        case 0:
          id = action.payload;
          _context15.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.reopenStage, id);

        case 3:
          _context15.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(Object(util_ids["a" /* default */])().getParentId(id)));

        case 5:
        case "end":
          return _context15.stop();
      }
    }
  }, _marked15);
}

var getConditionChanges = function getConditionChanges(state) {
  return state.deliveryFlow.conditionChanges;
};
var delivery_flow_sagas_getStages = function getStages(state) {
  return state.deliveryFlow.stages;
};
var getActiveTransition = function getActiveTransition(state) {
  return state.deliveryFlow.activeTransition;
};
var getConditionEditMode = function getConditionEditMode(state) {
  return state.deliveryFlow.isConditionEditMode;
};
var delivery_flow_sagas_prepareTransition = function prepareTransition(stages, transitionId, changes, automated) {
  var stageId = Object(util_ids["a" /* default */])().getParentId(transitionId);
  var transition = cloneDeep_default()(stages.find(function (s) {
    return s.id === stageId;
  }).transition);
  ['selectedTransitionItemCount', 'closeStages', 'disabledTransition'].forEach(function (prop) {
    return delete transition[prop];
  });
  var conditions = transition.conditions[0].conditions.flatMap(function (c) {
    return c.conditions;
  });
  changes.forEach(function (change) {
    conditions.find(function (cond) {
      return cond.id === change.id;
    }).fixedDate = change.fixedDate;
  });
  transition.automated = automated;
  return {
    deliveryId: Object(util_ids["a" /* default */])().getParentId(stageId),
    transition: transition
  };
};
function changeConditionDisplayMode(action) {
  var isEditMode;
  return regenerator_default.a.wrap(function changeConditionDisplayMode$(_context16) {
    while (1) {
      switch (_context16.prev = _context16.next) {
        case 0:
          isEditMode = action.payload;
          _context16.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(isEditMode));

        case 3:
          _context16.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_flow_actions_resetConditions());

        case 5:
          if (isEditMode) {
            _context16.next = 8;
            break;
          }

          _context16.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 8:
        case "end":
          return _context16.stop();
      }
    }
  }, _marked16);
}
function saveConditionChanges() {
  var changes, activeTransition, stages, _yield$call, deliveryId, transition;

  return regenerator_default.a.wrap(function saveConditionChanges$(_context17) {
    while (1) {
      switch (_context17.prev = _context17.next) {
        case 0:
          _context17.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getConditionChanges);

        case 2:
          changes = _context17.sent;
          _context17.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getActiveTransition);

        case 5:
          activeTransition = _context17.sent;

          if (!(changes.length > 0 || activeTransition.status.automated)) {
            _context17.next = 25;
            break;
          }

          _context17.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(delivery_flow_sagas_getStages);

        case 9:
          stages = _context17.sent;
          _context17.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_flow_sagas_prepareTransition, stages, activeTransition.id, changes, activeTransition.status.automated);

        case 12:
          _yield$call = _context17.sent;
          deliveryId = _yield$call.deliveryId;
          transition = _yield$call.transition;
          _context17.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowService.updateTransition, transition);

        case 17:
          _context17.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(fetchDeliveryDetails(deliveryId));

        case 19:
          _context17.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(false));

        case 21:
          _context17.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 23:
          _context17.next = 25;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_flow_actions_resetConditions());

        case 25:
        case "end":
          return _context17.stop();
      }
    }
  }, _marked17);
}

function onActivateTransition(action) {
  var isChangeable;
  return regenerator_default.a.wrap(function onActivateTransition$(_context18) {
    while (1) {
      switch (_context18.prev = _context18.next) {
        case 0:
          _context18.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(checkIsAvailableToLeaveConditionBlock);

        case 2:
          isChangeable = _context18.sent;

          if (!isChangeable) {
            _context18.next = 6;
            break;
          }

          _context18.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateActivateTransition(action.payload));

        case 6:
        case "end":
          return _context18.stop();
      }
    }
  }, _marked18);
}

function onDeactivateTransition() {
  var isChangeable;
  return regenerator_default.a.wrap(function onDeactivateTransition$(_context19) {
    while (1) {
      switch (_context19.prev = _context19.next) {
        case 0:
          _context19.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(checkIsAvailableToLeaveConditionBlock);

        case 2:
          isChangeable = _context19.sent;

          if (!isChangeable) {
            _context19.next = 6;
            break;
          }

          _context19.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateDeactivateTransition());

        case 6:
        case "end":
          return _context19.stop();
      }
    }
  }, _marked19);
}

function onTransitionTabChange(action) {
  var isChangeable;
  return regenerator_default.a.wrap(function onTransitionTabChange$(_context20) {
    while (1) {
      switch (_context20.prev = _context20.next) {
        case 0:
          _context20.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(checkIsAvailableToLeaveConditionBlock);

        case 2:
          isChangeable = _context20.sent;

          if (!isChangeable) {
            _context20.next = 6;
            break;
          }

          _context20.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updateTransitionTabValue(action.payload));

        case 6:
        case "end":
          return _context20.stop();
      }
    }
  }, _marked20);
}

function checkIsAvailableToLeaveConditionBlock() {
  var isConditionEditMode, changes;
  return regenerator_default.a.wrap(function checkIsAvailableToLeaveConditionBlock$(_context21) {
    while (1) {
      switch (_context21.prev = _context21.next) {
        case 0:
          _context21.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getConditionEditMode);

        case 2:
          isConditionEditMode = _context21.sent;
          _context21.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getConditionChanges);

        case 5:
          changes = _context21.sent;

          if (!(isConditionEditMode && changes.length > 0)) {
            _context21.next = 22;
            break;
          }

          _context21.prev = 7;
          _context21.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["b" /* openConfirmationDialog */]);

        case 10:
          _context21.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(false));

        case 12:
          return _context21.abrupt("return", true);

        case 15:
          _context21.prev = 15;
          _context21.t0 = _context21["catch"](7);
          _context21.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changeConditionEditMode(true));

        case 19:
          return _context21.abrupt("return", false);

        case 20:
          _context21.next = 23;
          break;

        case 22:
          return _context21.abrupt("return", true);

        case 23:
        case "end":
          return _context21.stop();
      }
    }
  }, _marked21, null, [[7, 15]]);
}

function setupDateTimeFormat() {
  var locale;
  return regenerator_default.a.wrap(function setupDateTimeFormat$(_context22) {
    while (1) {
      switch (_context22.prev = _context22.next) {
        case 0:
          _context22.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$locale');

        case 2:
          locale = _context22.sent;
          _context22.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(dateTimeFormatSet(locale.DATETIME_FORMATS));

        case 5:
        case "end":
          return _context22.stop();
      }
    }
  }, _marked22);
}

function deliveryFlowSagas() {
  return regenerator_default.a.wrap(function deliveryFlowSagas$(_context23) {
    while (1) {
      switch (_context23.prev = _context23.next) {
        case 0:
          _context23.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_REQUEST, createOrUpdateItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_REMOVE_REQUEST, delivery_flow_sagas_removeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_DESCOPE_REQUEST, delivery_flow_sagas_descopeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_RESCOPE_REQUEST, delivery_flow_sagas_rescopeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_SKIP_REQUEST, delivery_flow_sagas_skipItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_COMPLETE_REQUEST, delivery_flow_sagas_completeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE_SUCCESS, delivery_flow_sagas_fetchDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_APPROVALS_REQUEST, fetchTrackedItemApprovals), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_STAGE_RELEASE_REQUEST, fetchStagesReleases), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRACKED_ITEM_STAGE_TRANSITION_REQUEST, postTransition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.STAGE_COMPLETE_REQUEST, completeStageInDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.STAGE_REOPEN_REQUEST, reopenStageInDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRANSITION_ACTIVATE_REQUEST, onActivateTransition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRANSITION_DEACTIVATE_REQUEST, onDeactivateTransition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.TRANSITION_TAB_CHANGE_REQUEST, onTransitionTabChange), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.CONDITION_EDIT_MODE_CHANGE_REQUEST, changeConditionDisplayMode), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.CONDITION_UPDATE_SUCCESS, sagas["a" /* addConfirmLeavePopup */]), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.CONDITIONS_SAVE_REQUEST, saveConditionChanges), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(actionTypes.SET_DATETIME_FORMAT_REQUEST, setupDateTimeFormat), watchFetchDeliveryWithPollingSaga()]);

        case 2:
        case "end":
          return _context23.stop();
      }
    }
  }, _marked23);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/ducks/index.js


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.store.js



var delivery_flow_store_marked = /*#__PURE__*/regenerator_default.a.mark(combinedSaga);

/* global window */




var sagaMiddleware = Object(redux_saga_core_npm_proxy_esm["a" /* default */])();
/* eslint-disable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */

var composeEnhancers = (typeof window === "undefined" ? "undefined" : typeof_default()(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
  name: 'delivery-flow' // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...

}) : redux["compose"];

function combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliveryFlowSagas)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);
          console.error('Release delivery flow saga:', _context.t0);

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, delivery_flow_store_marked, null, [[1, 6]]);
}

function configureStore(preloadedState) {
  var enhancer = composeEnhancers(Object(redux["applyMiddleware"])(sagaMiddleware));
  var store = Object(redux["createStore"])(Object(redux["combineReducers"])({
    deliveryFlow: delivery_flow_reducer_deliveryFlow
  }), preloadedState, enhancer);
  sagaMiddleware.run(combinedSaga);
  return store;
}

var delivery_flow_store_store = configureStore();
/* eslint-enable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/assertThisInitialized.js
var assertThisInitialized = __webpack_require__(6);
var assertThisInitialized_default = /*#__PURE__*/__webpack_require__.n(assertThisInitialized);

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(12);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: ./node_modules/lodash/findLast.js
var findLast = __webpack_require__(1291);
var findLast_default = /*#__PURE__*/__webpack_require__.n(findLast);

// EXTERNAL MODULE: ./node_modules/lodash/includes.js
var includes = __webpack_require__(42);
var includes_default = /*#__PURE__*/__webpack_require__.n(includes);

// EXTERNAL MODULE: ./node_modules/lodash/isUndefined.js
var isUndefined = __webpack_require__(52);
var isUndefined_default = /*#__PURE__*/__webpack_require__.n(isUndefined);

// EXTERNAL MODULE: ./node_modules/lodash/map.js
var map = __webpack_require__(58);
var map_default = /*#__PURE__*/__webpack_require__.n(map);

// EXTERNAL MODULE: ./node_modules/lodash/startCase.js
var startCase = __webpack_require__(301);
var startCase_default = /*#__PURE__*/__webpack_require__.n(startCase);

// EXTERNAL MODULE: ./node_modules/lodash/toLower.js
var toLower = __webpack_require__(349);
var toLower_default = /*#__PURE__*/__webpack_require__.n(toLower);

// EXTERNAL MODULE: ./node_modules/lodash/upperFirst.js
var upperFirst = __webpack_require__(340);
var upperFirst_default = /*#__PURE__*/__webpack_require__.n(upperFirst);

// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(22);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/utils/validators.js
var validators = __webpack_require__(35);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/delivery-flow.types.js

var TrackedItem = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
var ReleaseInfo = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string,
  status: prop_types_default.a.string,
  startDate: prop_types_default.a.number,
  endDate: prop_types_default.a.number,
  archived: prop_types_default.a.bool,
  fullId: prop_types_default.a.string
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/track-item-edit-modal/tracked-item-edit-modal.component.js








function tracked_item_edit_modal_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function tracked_item_edit_modal_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_item_edit_modal_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_item_edit_modal_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var nameOptions = {
  label: 'Name',
  description: 'Name of the tracked item',
  required: true
};

var tracked_item_edit_modal_component_nameValidator = function nameValidator(trackedItemList) {
  var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  return function (title) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(trackedItemList, id, 'title', title),
      message: Object(validators["a" /* createErrorMessage */])('Tracked item already exists')
    };
  };
};

var tracked_item_edit_modal_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var tracked_item_edit_modal_component_TrackedItemEditModalComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemEditModalComponent, _Component);

  var _super = _createSuper(TrackedItemEditModalComponent);

  function TrackedItemEditModalComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemEditModalComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeModal", function () {
      _this.handleButtonClick(cancelButton.action);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCheckboxClick", function (value) {
      _this.setState({
        createAnother: value.target.checked
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resetForm", function () {
      _this.setState({
        trackedItem: null,
        prevModel: null
      });

      if (_this.componentApi) {
        _this.componentApi.resetPristinity();

        _this.componentApi.focus();
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          onCancel = _this$props.onCancel,
          onSave = _this$props.onSave;
      var _this$state = _this.state,
          trackedItem = _this$state.trackedItem,
          createAnother = _this$state.createAnother;

      switch (action) {
        case 'update':
          onSave(trackedItem, createAnother);
          break;

        case 'cancel':
          onCancel();

          _this.setState({
            createAnother: false
          });

          break;

        default:
          throw 'Unknown action';
      }

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleModelChange", function (newTitle) {
      var trackedItem = _this.state.trackedItem;

      if (newTitle !== trackedItem.title) {
        _this.setState({
          trackedItem: tracked_item_edit_modal_component_objectSpread(tracked_item_edit_modal_component_objectSpread({}, trackedItem), {}, {
            title: newTitle
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });

    _this.state = {
      trackedItem: null,
      prevModel: null,
      createAnother: false
    };
    _this.isPristine = null;
    _this.isValid = null;
    _this.componentApi = null;
    return _this;
  }

  createClass_default()(TrackedItemEditModalComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isOpened = _this$props2.isOpened,
          trackedItems = _this$props2.trackedItems;
      var trackedItem = this.state.trackedItem;
      var disableSaving = this.isPristine || !this.isValid;
      var updateButton = {
        action: 'update',
        className: 'button primary',
        disabled: disableSaving,
        keyCodes: [13],
        label: 'Save'
      };
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, this.props.modalTitle, /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [cancelButton, updateButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        onCheckboxClick: this.onCheckboxClick,
        show: isOpened,
        skin: this.props.modalTitle !== 'Edit tracked item' ? 'checkbox' : 'default',
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: nameOptions,
        model: trackedItem.title,
        onModelChange: this.handleModelChange,
        onPristinityChange: this.handlePristinityChange,
        onValidityChange: this.handleValidityChange,
        register: this.onRegister,
        validators: [tracked_item_edit_modal_component_nameValidator(trackedItems, trackedItem.id), tracked_item_edit_modal_component_maxLengthValidator(nameOptions.label, 255), Object(validators["c" /* reservedCharactersValidator */])(nameOptions.label)]
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.trackedItem || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
        return tracked_item_edit_modal_component_objectSpread(tracked_item_edit_modal_component_objectSpread({}, state), {}, {
          trackedItem: props.model,
          prevModel: props.model
        });
      }

      return null;
    }
  }]);

  return TrackedItemEditModalComponent;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./node_modules/antd/es/popover/index.js + 2 modules
var popover = __webpack_require__(3041);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-timeline/delivery-timeline.less
var delivery_timeline = __webpack_require__(874);
var delivery_timeline_default = /*#__PURE__*/__webpack_require__.n(delivery_timeline);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-timeline/delivery-timeline.less

            

var delivery_timeline_options = {};

delivery_timeline_options.insert = "head";
delivery_timeline_options.singleton = false;

var delivery_timeline_update = injectStylesIntoStyleTag_default()(delivery_timeline_default.a, delivery_timeline_options);



/* harmony default export */ var delivery_timeline_delivery_timeline = (delivery_timeline_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-timeline/delivery-timeline.component.js








function delivery_timeline_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_timeline_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_timeline_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var delivery_timeline_component_DeliveryTimelineComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryTimelineComponent, _Component);

  var _super = delivery_timeline_component_createSuper(DeliveryTimelineComponent);

  function DeliveryTimelineComponent() {
    var _this;

    classCallCheck_default()(this, DeliveryTimelineComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "getPopoverContent", function (endDate) {
      var current = moment_js_exposed_default()().startOf('day');
      var duration = moment_js_exposed_default.a.duration(endDate.diff(current, 'days'), 'days').asDays();
      var calculatedDuration = duration > 0 ? duration : 0;
      var humanizedDuration = "".concat(calculatedDuration, " ").concat(calculatedDuration === 1 ? 'day' : 'days');
      return "Delivery start and end date (".concat(humanizedDuration, " left)");
    });

    return _this;
  }

  createClass_default()(DeliveryTimelineComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          startDate = _this$props.startDate,
          endDate = _this$props.endDate;
      return /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        content: this.getPopoverContent(endDate),
        overlayClassName: "delivery-timeline-popover",
        placement: "bottom",
        trigger: "hover"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        id: "delivery-timeline"
      }, /*#__PURE__*/external_React_default.a.createElement("span", null, startDate.format('ll')), /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "inline-item-icon xl-icon icon-l back-icon flip-icon"
      }), /*#__PURE__*/external_React_default.a.createElement("span", null, endDate.format('ll'))));
    }
  }]);

  return DeliveryTimelineComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/index.js + 49 modules
var components = __webpack_require__(24);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-header.component.less
var stage_header_component = __webpack_require__(875);
var stage_header_component_default = /*#__PURE__*/__webpack_require__.n(stage_header_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-header.component.less

            

var stage_header_component_options = {};

stage_header_component_options.insert = "head";
stage_header_component_options.singleton = false;

var stage_header_component_update = injectStylesIntoStyleTag_default()(stage_header_component_default.a, stage_header_component_options);



/* harmony default export */ var delivery_flow_stage_header_component = (stage_header_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-header.component.js








function stage_header_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var CONFIRM_ACTIONS = {
  reopen: 'reopen',
  complete: 'complete'
};
var stage_header_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var completeButton = {
  action: CONFIRM_ACTIONS.complete,
  className: 'button primary',
  keyCodes: [13],
  label: 'Complete'
};
var reopenButton = {
  action: CONFIRM_ACTIONS.reopen,
  className: 'button primary',
  keyCodes: [13],
  label: 'Reopen'
};
var stage_header_component_StageHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageHeaderComponent, _Component);

  var _super = stage_header_component_createSuper(StageHeaderComponent);

  function StageHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, StageHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleCompleteConfirmClose", function () {
      _this.setState({
        showCloseConfirm: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleCompleteConfirmAction", function (action) {
      var _this$props = _this.props,
          completeStage = _this$props.completeStage,
          stage = _this$props.stage;

      if (action === CONFIRM_ACTIONS.complete) {
        completeStage(stage.id);
      }

      _this.setState({
        showCloseConfirm: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleReopenConfirmClose", function () {
      _this.setState({
        showReopenConfirm: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleReopenConfirmAction", function (action) {
      var _this$props2 = _this.props,
          reopenStage = _this$props2.reopenStage,
          stage = _this$props2.stage;

      if (action === CONFIRM_ACTIONS.reopen) {
        reopenStage(stage.id);
      }

      _this.setState({
        showReopenConfirm: false
      });
    });

    _this.state = {
      showCloseConfirm: false,
      showReopenConfirm: false
    };
    return _this;
  }

  createClass_default()(StageHeaderComponent, [{
    key: "buildModalHeader",
    value: function buildModalHeader(caption, fn) {
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "delivery-header-text"
      }, caption, /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: fn,
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      }))));
    }
  }, {
    key: "renderCompleteConfirmDialog",
    value: function renderCompleteConfirmDialog() {
      var _this$props3 = this.props,
          delivery = _this$props3.delivery,
          stage = _this$props3.stage,
          trackedItems = _this$props3.trackedItems;
      var showCloseConfirm = this.state.showCloseConfirm;
      var modalHeader = this.buildModalHeader('Complete stage', this.handleCompleteConfirmClose);
      var descopedItemIds = new Set(trackedItems.filter(function (i) {
        return i.descoped;
      }).map(function (i) {
        return i.id;
      }));
      var itemIds = stage.items.filter(function (item) {
        return !descopedItemIds.has(item.trackedItemId) && item.status === trackedItemStatus.notReady;
      }).map(function (item) {
        return item.trackedItemId;
      });
      var isLastStage = delivery.stages.slice(-1)[0].id === stage.id;
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_header_component_cancelButton, completeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleCompleteConfirmAction,
        show: showCloseConfirm,
        title: modalHeader
      }, isLastStage && /*#__PURE__*/external_React_default.a.createElement("p", {
        className: "alert alert-warning"
      }, "This stage is the last in this delivery. Completing this stage will complete the delivery. You will not be able to close/reopen stages in the completed delivery."), /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to close the stage ", /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "stage-name"
      }, stage.title), "."), itemIds.length > 0 && /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("p", null, "By closing this stage the following not ready items will be marked as descoped in this delivery."), /*#__PURE__*/external_React_default.a.createElement("p", {
        className: "tracked-item-list-msg"
      }, "Tracked items that will be descoped (", itemIds.length, ")"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "tracked-item-container"
      }, trackedItems.filter(function (ti) {
        return itemIds.includes(ti.id);
      }).map(function (item, index) {
        return /*#__PURE__*/external_React_default.a.createElement("p", {
          className: "tracked-item-row",
          key: index
        }, item.title);
      }))));
    }
  }, {
    key: "renderReopenConfirmDialog",
    value: function renderReopenConfirmDialog() {
      var stage = this.props.stage;
      var showReopenConfirm = this.state.showReopenConfirm;
      var modalHeader = this.buildModalHeader('Reopen stage', this.handleReopenConfirmClose);
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_header_component_cancelButton, reopenButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleReopenConfirmAction,
        show: showReopenConfirm,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to reopen the stage ", /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "stage-name"
      }, stage.title), "."));
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props4 = this.props,
          collapseStage = _this$props4.collapseStage,
          isActive = _this$props4.isActive,
          isClosed = _this$props4.isClosed,
          isMenuVisible = _this$props4.isMenuVisible,
          stage = _this$props4.stage;
      var isEditable = this.props.delivery.isEditable;
      var menuOptions = [{
        label: 'Complete',
        handler: function handler() {
          _this2.setState({
            showCloseConfirm: true
          });
        },
        isVisible: !isClosed
      }, {
        label: 'Reopen',
        handler: function handler() {
          _this2.setState({
            showReopenConfirm: true
          });
        },
        isVisible: isClosed
      }];
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('header-cell', 'stage-header', 'curved-border-top', {
          'active': isActive
        }, {
          'closed': isClosed
        }),
        key: stage.id
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "stage-title-wrapper"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "stage-title"
      }, /*#__PURE__*/external_React_default.a.createElement("h6", {
        className: "truncate-title",
        title: stage.title
      }, stage.title)), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "stage-actions"
      }, isClosed && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "label label-completed"
      }, "Completed"), isActive && /*#__PURE__*/external_React_default.a.createElement("a", {
        className: "link-collapse-stage",
        onClick: collapseStage
      }, "Close detail view"), isEditable && isMenuVisible && /*#__PURE__*/external_React_default.a.createElement(components["e" /* ContextMenuComponent */], {
        menuName: stage.title,
        menuOptions: menuOptions,
        menuWrapperClassName: "stage-header-menu"
      }))), this.renderCompleteConfirmDialog(), this.renderReopenConfirmDialog());
    }
  }]);

  return StageHeaderComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/lodash/intersectionWith.js
var intersectionWith = __webpack_require__(1292);
var intersectionWith_default = /*#__PURE__*/__webpack_require__.n(intersectionWith);

// EXTERNAL MODULE: ./node_modules/react-content-loader/dist/react-content-loader.es.js
var react_content_loader_es = __webpack_require__(234);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/release-list/release-list.less
var release_list = __webpack_require__(876);
var release_list_default = /*#__PURE__*/__webpack_require__.n(release_list);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/release-list/release-list.less

            

var release_list_options = {};

release_list_options.insert = "head";
release_list_options.singleton = false;

var release_list_update = injectStylesIntoStyleTag_default()(release_list_default.a, release_list_options);



/* harmony default export */ var release_list_release_list = (release_list_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/release-list/release-list.component.js








function release_list_component_createSuper(Derived) { var hasNativeReflectConstruct = release_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function release_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var release_list_component_ReleaseListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ReleaseListComponent, _Component);

  var _super = release_list_component_createSuper(ReleaseListComponent);

  function ReleaseListComponent() {
    var _this;

    classCallCheck_default()(this, ReleaseListComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderReleaseRows", function (releaseList) {
      return releaseList.map(function (releaseDetail, i) {
        var releaseUrl = "#/releases/".concat(releaseDetail.fullId.replace(/^Applications\//, '').replace(/\//g, '-'));
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "col-xs-12 release-list-modal-release-row release",
          key: i
        }, /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "adjust-release-line release-modal-line release-line"
        }, /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "row-wrapper"
        }, /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "col-xs-3 release-title-wrapper"
        }, /*#__PURE__*/external_React_default.a.createElement("strong", {
          className: "release-title raised-link-target"
        }, /*#__PURE__*/external_React_default.a.createElement("a", {
          className: "black-text",
          href: releaseUrl
        }, releaseDetail.title))), /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "col-xs-3 text-left"
        }, /*#__PURE__*/external_React_default.a.createElement(components["s" /* ReleaseStatusComponent */], {
          isArchived: releaseDetail.archived,
          status: releaseDetail.status
        })), /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "col-xs-3 text-left calendar-link"
        }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("span", null, moment(releaseDetail.startDate).format('lll')))), /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "col-xs-3 text-left calendar-link"
        }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("span", null, releaseDetail.endDate ? moment(releaseDetail.endDate).format('lll') : ''))))));
      });
    });

    return _this;
  }

  createClass_default()(ReleaseListComponent, [{
    key: "render",
    value: function render() {
      var releaseList = this.props.releaseList;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "f-add-release"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "releases-list-modal-sub-header"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "row"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-xs-6"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("label", null, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "header"
      }, "Releases")))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-xs-3 text-left"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-table-text"
      }, "Start date")), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-xs-3 text-left end-date"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-table-text"
      }, "End date")))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "release-modal-list"
      }, this.renderReleaseRows(releaseList)));
    }
  }]);

  return ReleaseListComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-cell.component.less
var stage_cell_component = __webpack_require__(877);
var stage_cell_component_default = /*#__PURE__*/__webpack_require__.n(stage_cell_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-cell.component.less

            

var stage_cell_component_options = {};

stage_cell_component_options.insert = "head";
stage_cell_component_options.singleton = false;

var stage_cell_component_update = injectStylesIntoStyleTag_default()(stage_cell_component_default.a, stage_cell_component_options);



/* harmony default export */ var delivery_flow_stage_cell_component = (stage_cell_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/stage-cell.component.js








function stage_cell_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_cell_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_cell_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }














var stage_cell_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var stage_cell_component_Ids = Object(util_ids["a" /* default */])();
var stage_cell_component_StageCellComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageCellComponent, _Component);

  var _super = stage_cell_component_createSuper(StageCellComponent);

  function StageCellComponent(props) {
    var _this;

    classCallCheck_default()(this, StageCellComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "openReleaseListModal", function () {
      _this.setState({
        showReleaseList: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "openFailingReleasesModal", function () {
      _this.setState({
        showReleaseList: true,
        onlyFailing: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeReleaseListModal", function () {
      _this.setState({
        showReleaseList: false,
        onlyFailing: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isFailing", function (rel) {
      return rel.status === 'failed' || rel.status === 'failing';
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "buildContent", function (leftRenderer) {
      var rightRenderer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "cell-data-content-left"
      }, leftRenderer()), rightRenderer && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "cell-data-content-right"
      }, rightRenderer()));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderContent", function () {
      var _this$props = _this.props,
          stageItem = _this$props.stageItem,
          trackedItem = _this$props.trackedItem,
          isExpanded = _this$props.isExpanded,
          expandedStageReleases = _this$props.expandedStageReleases,
          isMenuVisible = _this$props.isMenuVisible,
          stageMenuOptions = _this$props.stageMenuOptions;
      var content = null;
      var status = null;

      if (trackedItem.descoped) {
        status = /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xl circle-outline-cross-icon"
        });
        content = _this.buildContent(_.constant('Descoped'), function () {
          return _this.renderReleaseCount(trackedItem.releaseIds);
        });
      } else if (stageItem) {
        switch (stageItem.status) {
          case trackedItemStatus.ready:
            {
              status = /*#__PURE__*/external_React_default.a.createElement("i", {
                className: "xl-icon icon-xl circle-check-icon"
              });
              content = _this.buildContent(_.constant('Completed this stage'), function () {
                return _this.renderReleaseCount(trackedItem.releaseIds);
              });
              break;
            }

          case trackedItemStatus.notReady:
            {
              if (trackedItem.releaseIds && trackedItem.releaseIds.length === 0) {
                status = /*#__PURE__*/external_React_default.a.createElement("i", {
                  className: "xl-icon icon-xl pending-icon"
                });
                content = _this.buildContent(_.constant('Waiting for activity'), function () {
                  return _this.renderMenu(stageMenuOptions, isMenuVisible);
                });
                break;
              } else if (expandedStageReleases.length && trackedItem.releaseIds.length) {
                content = _this.renderRegisteredItemContent();
              }

              status = /*#__PURE__*/external_React_default.a.createElement("i", {
                className: "xl-icon icon-xl progress-icon"
              }, !isExpanded && expandedStageReleases.find(function (rel) {
                return _this.isFailing(rel) && (trackedItem.releaseIds || []).map(function (id) {
                  return stage_cell_component_Ids.getName(id);
                }).includes(rel.id);
              }) && /*#__PURE__*/external_React_default.a.createElement("i", {
                className: "xl-icon circle-exclamation-icon top-right"
              }));
              break;
            }

          case trackedItemStatus.skipped:
            {
              status = /*#__PURE__*/external_React_default.a.createElement("i", {
                className: "xl-icon icon-xl circle-minus-icon"
              });
              content = _this.buildContent(_.constant('Skipped'), function () {
                return _this.renderReleaseCount(trackedItem.releaseIds);
              });
              break;
            }

          default:
            throw 'Unknown tracked item status';
        }
      }

      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, status && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "details-status"
      }, status) || /*#__PURE__*/external_React_default.a.createElement("span", null, "\xA0"), isExpanded && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "details-content"
      }, content));
    });

    _this.state = {
      showReleaseList: false,
      onlyFailing: false
    };
    return _this;
  }

  createClass_default()(StageCellComponent, [{
    key: "renderDeliveryMemberList",
    value: function renderDeliveryMemberList() {
      var _this$props2 = this.props,
          trackedItem = _this$props2.trackedItem,
          expandedStageReleases = _this$props2.expandedStageReleases;
      var showReleaseList = this.state.showReleaseList;
      var releaseList = intersectionWith_default()(expandedStageReleases, (trackedItem.releaseIds || []).map(function (id) {
        return stage_cell_component_Ids.getName(id);
      }), function (_ref, releaseId) {
        var id = _ref.id;
        return id === releaseId;
      });
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Linked Releases (", releaseList.length, ")", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeReleaseListModal,
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      releaseList.forEach(function (item) {
        item.fullId = trackedItem.releaseIds.find(function (id) {
          return stage_cell_component_Ids.getName(id) === item.id;
        });
      });
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_cell_component_cancelButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.closeReleaseListModal,
        show: showReleaseList,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("label", {
        className: "tracked-item-header-title"
      }, "Tracked Item: ", trackedItem.title), /*#__PURE__*/external_React_default.a.createElement(release_list_component_ReleaseListComponent, {
        releaseList: this.state.onlyFailing ? releaseList.filter(this.isFailing) : releaseList
      }));
    }
  }, {
    key: "renderMenu",
    value: function renderMenu(stageMenuOptions, isVisible) {
      return isVisible && /*#__PURE__*/external_React_default.a.createElement(components["e" /* ContextMenuComponent */], {
        menuOptions: stageMenuOptions,
        menuWrapperClassName: "stage-menu-wrapper"
      });
    }
  }, {
    key: "renderReleaseCount",
    value: function renderReleaseCount(releaseIds) {
      return releaseIds.length > 0 && /*#__PURE__*/external_React_default.a.createElement("a", {
        className: "release-counter",
        onClick: this.openReleaseListModal
      }, releaseIds.length, " releases");
    }
  }, {
    key: "renderRegisteredItemContent",
    value: function renderRegisteredItemContent() {
      var _this2 = this;

      var _this$props3 = this.props,
          trackedItem = _this$props3.trackedItem,
          expandedStageReleases = _this$props3.expandedStageReleases,
          stageMenuOptions = _this$props3.stageMenuOptions,
          isMenuVisible = _this$props3.isMenuVisible;

      var getReleaseInfo = function getReleaseInfo(releases, releaseId) {
        var failing = releases.find(_this2.isFailing);
        return failing || releases.find(function (rel) {
          return rel.id === releaseId;
        });
      };

      var ids = (trackedItem.releaseIds || []).map(function (id) {
        return stage_cell_component_Ids.getName(id);
      });
      var stageReleases = expandedStageReleases.filter(function (r) {
        return ids.includes(r.id);
      });
      var failingCount = stageReleases.filter(this.isFailing).length;
      var release = getReleaseInfo(stageReleases, last_default()(ids));
      var leftContent = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, failingCount === 0 && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "release-title"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon icon-xl release-icon"
      }), release && release.title), failingCount > 0 && /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("div", null, "In progress"), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "release-title failed"
      }, failingCount === 1 && /*#__PURE__*/external_React_default.a.createElement("span", null, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon circle-exclamation-icon"
      }), /*#__PURE__*/external_React_default.a.createElement("a", {
        href: "#/releases/" + release.id
      }, release.title, " is failing")), failingCount > 1 && /*#__PURE__*/external_React_default.a.createElement("span", null, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon circle-exclamation-icon"
      }), /*#__PURE__*/external_React_default.a.createElement("a", {
        onClick: this.openFailingReleasesModal
      }, failingCount, " releases are failing")))));
      var rightContent = /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "counter-and-menu-wrapper"
      }, this.renderMenu(stageMenuOptions, isMenuVisible), this.renderReleaseCount(trackedItem.releaseIds));
      return this.buildContent(function () {
        return leftContent;
      }, function () {
        return rightContent;
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
          isExpanded = _this$props4.isExpanded,
          loading = _this$props4.loading;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('stage-cell-content', isExpanded ? 'active' : '')
      }, loading && isExpanded && /*#__PURE__*/external_React_default.a.createElement(react_content_loader_es["a" /* default */], {
        height: 50,
        preserveAspectRatio: "xMinYMin meet",
        speed: 1
      }, /*#__PURE__*/external_React_default.a.createElement("rect", {
        height: "30",
        rx: "20",
        ry: "20",
        width: "30",
        x: "0",
        y: "0"
      }), /*#__PURE__*/external_React_default.a.createElement("rect", {
        height: "14",
        rx: "4",
        ry: "4",
        width: "450",
        x: "50",
        y: "9"
      })), !(isExpanded && loading) && this.renderContent()), this.renderDeliveryMemberList());
    }
  }]);

  return StageCellComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/lodash/noop.js
var noop = __webpack_require__(77);
var noop_default = /*#__PURE__*/__webpack_require__.n(noop);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/widgets/index.js + 2 modules
var widgets = __webpack_require__(127);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/stage.actions.js
var stage_actions_actionTypes = {
  STAGE_LIST_REQUESTED: "STAGE/LIST_REQUESTED",
  STAGE_LIST_SUCCEEDED: "STAGE/LIST_SUCCEEDED",
  STAGE_DELETE_REQUESTED: "STAGE/DELETE_REQUESTED",
  STAGE_DELETE_SUCCEEDED: "STAGE/DELETE_SUCCEEDED",
  STAGE_EDIT_REQUESTED: "STAGE/EDIT_REQUESTED",
  STAGE_EDIT_SUCCEEDED: "STAGE/EDIT_SUCCEEDED",
  STAGE_ADD_REQUESTED: "STAGE/ADD_REQUESTED",
  STAGE_ADD_SUCCEEDED: "STAGE/ADD_SUCCEEDED"
};
var loadStages = function loadStages(deliveryId) {
  return {
    type: stage_actions_actionTypes.STAGE_LIST_REQUESTED,
    payload: deliveryId
  };
};
var stagesLoaded = function stagesLoaded(list) {
  return {
    type: stage_actions_actionTypes.STAGE_LIST_SUCCEEDED,
    payload: list
  };
};
var stage_actions_deleteStage = function deleteStage(stageId) {
  return {
    type: stage_actions_actionTypes.STAGE_DELETE_REQUESTED,
    payload: stageId
  };
};
var stageDeleted = function stageDeleted(stageId) {
  return {
    type: stage_actions_actionTypes.STAGE_DELETE_SUCCEEDED,
    payload: stageId
  };
};
var editStage = function editStage(stageId, title) {
  return {
    type: stage_actions_actionTypes.STAGE_EDIT_REQUESTED,
    payload: {
      id: stageId,
      title: title
    }
  };
};
var stageEdited = function stageEdited(stage) {
  return {
    type: stage_actions_actionTypes.STAGE_EDIT_SUCCEEDED,
    payload: stage
  };
};
var stage_actions_addStage = function addStage(before, after) {
  return {
    type: stage_actions_actionTypes.STAGE_ADD_REQUESTED,
    payload: {
      before: before,
      after: after
    }
  };
};
var stageAdded = function stageAdded(stage, before, after) {
  return {
    type: stage_actions_actionTypes.STAGE_ADD_SUCCEEDED,
    payload: {
      stage: stage,
      before: before,
      after: after
    }
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/transition.actions.js
var transition_actions_actionTypes = {
  TRANSITION_ADD_REQUESTED: "TRANSITION/ADD_REQUESTED",
  TRANSITION_ADD_SUCCEEDED: "TRANSITION/ADD_SUCCEEDED",
  TRANSITION_UPDATE_REQUESTED: "TRANSITION/UPDATE_REQUESTED",
  TRANSITION_UPDATE_SUCCEEDED: "TRANSITION/UPDATE_SUCCEEDED",
  TRANSITION_DELETE_REQUESTED: "TRANSITION/DELETE_REQUESTED",
  TRANSITION_DELETE_SUCCEEDED: "TRANSITION/DELETE_SUCCEEDED",
  TRANSITION_ADD_CONDITION_REQUESTED: "TRANSITION/ADD_CONDITION_REQUESTED",
  TRANSITION_UPDATE_CONDITION_REQUESTED: "TRANSITION/UPDATE_CONDITION_REQUESTED",
  TRANSITION_DELETE_CONDITION_REQUESTED: "TRANSITION/DELETE_CONDITION_REQUESTED",
  TRANSITION_TOGGLE_OPERATOR_REQUESTED: "TRANSITION/TOGGLE_OPERATOR_REQUESTED",
  TRANSITION_TOGGLE_OPERATOR_SUCCEEDED: "TRANSITION/TOGGLE_OPERATOR_SUCCEEDED"
};
var transition_actions_addTransition = function addTransition(stageId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_ADD_REQUESTED,
    payload: stageId
  };
};
var transitionAdded = function transitionAdded(transition) {
  return {
    type: transition_actions_actionTypes.TRANSITION_ADD_SUCCEEDED,
    payload: transition
  };
};
var transition_actions_updateTransition = function updateTransition(id, stageId, title) {
  return {
    type: transition_actions_actionTypes.TRANSITION_UPDATE_REQUESTED,
    payload: {
      id: id,
      stageId: stageId,
      title: title
    }
  };
};
var transitionUpdated = function transitionUpdated(transition) {
  return {
    type: transition_actions_actionTypes.TRANSITION_UPDATE_SUCCEEDED,
    payload: transition
  };
};
var transition_actions_deleteTransition = function deleteTransition(id) {
  return {
    type: transition_actions_actionTypes.TRANSITION_DELETE_REQUESTED,
    payload: id
  };
};
var transitionDeleted = function transitionDeleted(transition) {
  return {
    type: transition_actions_actionTypes.TRANSITION_DELETE_SUCCEEDED,
    payload: transition
  };
};
var addCondition = function addCondition(transitionId, groupId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_ADD_CONDITION_REQUESTED,
    payload: {
      transitionId: transitionId,
      groupId: groupId
    }
  };
};
var transition_actions_updateCondition = function updateCondition(transitionId, conditionId, change) {
  return {
    type: transition_actions_actionTypes.TRANSITION_UPDATE_CONDITION_REQUESTED,
    payload: {
      transitionId: transitionId,
      conditionId: conditionId,
      change: change
    }
  };
};
var deleteCondition = function deleteCondition(transitionId, conditionId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_DELETE_CONDITION_REQUESTED,
    payload: {
      transitionId: transitionId,
      conditionId: conditionId
    }
  };
};
var toggleConditionOperator = function toggleConditionOperator(transitionId) {
  return {
    type: transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_REQUESTED,
    payload: transitionId
  };
};
var conditionOperatorToggled = function conditionOperatorToggled(transitionId, operator) {
  return {
    type: transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_SUCCEEDED,
    payload: {
      transitionId: transitionId,
      operator: operator
    }
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/delivery-pattern.types.js


var _conditionValueOpts;


var DeliveryPattern = prop_types_default.a.shape({
  description: prop_types_default.a.string,
  plannedDuration: prop_types_default.a.number,
  id: prop_types_default.a.string,
  title: prop_types_default.a.string.isRequired
});
var Condition = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.oneOf(['delivery.ItemsCompletionCondition', 'delivery.TimeCondition']),
  value: prop_types_default.a.string
});
var ConditionGroup = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.string,
  value: prop_types_default.a.string,
  operator: prop_types_default.a.string,
  conditions: prop_types_default.a.arrayOf(Condition).isRequired
});
var RootConditionGroup = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.string,
  value: prop_types_default.a.string,
  operator: prop_types_default.a.string,
  conditions: prop_types_default.a.arrayOf(ConditionGroup).isRequired
});
var Transition = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string.isRequired,
  stage: prop_types_default.a.string,
  conditions: prop_types_default.a.arrayOf(RootConditionGroup).isRequired
});
var Stage = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string.isRequired,
  transition: Transition
});
var conditionTypes = {
  STATE: 'delivery.ItemsCompletionCondition',
  TIMED: 'delivery.TimeCondition',
  GROUP: 'delivery.ConditionGroup'
};
var isTimeCondition = function isTimeCondition(condition) {
  return condition.type === conditionTypes.TIMED;
};
var isGroupCondition = function isGroupCondition(condition) {
  return condition.type === conditionTypes.GROUP;
};
var isStateCondition = function isStateCondition(condition) {
  return condition.type === conditionTypes.STATE;
};
var conditionValueOpts = (_conditionValueOpts = {}, defineProperty_default()(_conditionValueOpts, "".concat(conditionTypes.STATE), 'All items are completed in previous stage'), defineProperty_default()(_conditionValueOpts, "".concat(conditionTypes.TIMED), 'Scheduled'), _conditionValueOpts);
var conditionOperator = {
  AND: 'AND',
  OR: 'OR'
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/stage.reducer.js



function stage_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function stage_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { stage_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { stage_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }






var stage_reducer_initialState = function initialState() {
  return {
    list: [],
    operators: {},
    // {transitionId1: rootOperator1, transitionId2: rootOperator2}
    isCreateDeliveryDisabled: true
  };
};
var stage_reducer_stages = function stages() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : stage_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case stage_actions_actionTypes.STAGE_LIST_SUCCEEDED:
      {
        var list = action.payload.map(function (stage) {
          return {
            id: stage.id,
            title: stage.title,
            transition: stage.transition
          };
        });
        var operators = {};
        list.forEach(function (stage) {
          if (stage.transition) {
            operators[stage.transition.id] = stage.transition.conditions.length > 0 ? stage.transition.conditions[0].operator : conditionOperator.OR;
          }
        });
        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          list: list,
          operators: operators,
          isCreateDeliveryDisabled: stage_reducer_isCreateDeliveryDisabled(list)
        });
      }

    case stage_actions_actionTypes.STAGE_DELETE_SUCCEEDED:
      {
        var updated = cloneDeep_default()(state.list);
        var index = updated.findIndex(function (stage) {
          return stage.id === action.payload;
        });

        if (index > -1) {
          if (index > 0 && updated.length - 1 === index) {
            var prevIndex = index - 1;

            if (!isUndefined_default()(updated[prevIndex].transition)) {
              updated[prevIndex].transition = null;
            }
          }

          updated.splice(index, 1);
        }

        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          list: toConsumableArray_default()(updated),
          isCreateDeliveryDisabled: stage_reducer_isCreateDeliveryDisabled(updated)
        });
      }

    case stage_actions_actionTypes.STAGE_EDIT_SUCCEEDED:
      {
        var _list = state.list;
        var _action$payload = action.payload,
            id = _action$payload.id,
            title = _action$payload.title;
        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          list: _list.map(function (stage) {
            return stage.id === id ? stage_reducer_objectSpread(stage_reducer_objectSpread({}, stage), {}, {
              title: title
            }) : stage;
          })
        });
      }

    case stage_actions_actionTypes.STAGE_ADD_SUCCEEDED:
      {
        var _action$payload2 = action.payload,
            stage = _action$payload2.stage,
            before = _action$payload2.before,
            after = _action$payload2.after;

        var _list2 = toConsumableArray_default()(state.list);

        if (before) {
          var position = _list2.findIndex(function (stage) {
            return stage.id === before;
          });

          _list2.splice(position, 0, {
            id: stage.id,
            title: stage.title
          });
        } else {
          _list2.push({
            id: stage.id,
            title: stage.title
          });
        }

        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          list: _list2,
          isCreateDeliveryDisabled: false
        });
      }

    case transition_actions_actionTypes.TRANSITION_ADD_SUCCEEDED:
      {
        var transition = action.payload;
        var _operators = state.operators,
            _list3 = state.list;
        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          list: _list3.map(function (stage) {
            return stage.id === transition.stage ? stage_reducer_objectSpread(stage_reducer_objectSpread({}, stage), {}, {
              transition: {
                id: transition.id,
                title: transition.title,
                stage: transition.stage,
                automated: transition.automated,
                conditions: transition.conditions
              }
            }) : stage_reducer_objectSpread({}, stage);
          }),
          operators: stage_reducer_objectSpread(stage_reducer_objectSpread({}, _operators), {}, defineProperty_default()({}, "".concat(transition.id), conditionOperator.OR))
        });
      }

    case transition_actions_actionTypes.TRANSITION_UPDATE_SUCCEEDED:
      {
        var _list4 = state.list,
            _operators2 = state.operators;
        var _transition = action.payload;
        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          operators: Object.keys(_operators2).reduce(function (obj, key) {
            obj[key] = conditionOperator.OR;
            obj[key] = key === _transition.id && _transition.conditions.length > 0 ? _transition.conditions[0].operator : _operators2[key];
            return obj;
          }, {}),
          list: _list4.map(function (stage) {
            return stage.id === _transition.stage ? stage_reducer_objectSpread(stage_reducer_objectSpread({}, stage), {}, {
              transition: stage_reducer_objectSpread(stage_reducer_objectSpread({}, _transition), {}, {
                title: _transition.title,
                automated: _transition.automated,
                conditions: _transition.conditions
              })
            }) : stage;
          })
        });
      }

    case transition_actions_actionTypes.TRANSITION_DELETE_SUCCEEDED:
      {
        var _list5 = state.list;
        var transitionId = action.payload;
        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          list: _list5.map(function (stage) {
            return stage_reducer_objectSpread(stage_reducer_objectSpread({}, stage), {}, {
              transition: stage.transition && stage.transition.id === transitionId ? null : stage.transition
            });
          })
        });
      }

    case transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_SUCCEEDED:
      {
        var _action$payload3 = action.payload,
            _transitionId = _action$payload3.transitionId,
            operator = _action$payload3.operator;
        var _operators3 = state.operators;
        return stage_reducer_objectSpread(stage_reducer_objectSpread({}, state), {}, {
          operators: Object.keys(_operators3).reduce(function (obj, key) {
            obj[key] = key === _transitionId ? stage_reducer_inverseOperator(operator) : _operators3[key];
            return obj;
          }, {})
        });
      }

    default:
      return state;
  }
};

function stage_reducer_isCreateDeliveryDisabled(stages) {
  return stages.length === 0;
}

var stage_reducer_inverseOperator = function inverseOperator(op) {
  return op === conditionOperator.AND ? conditionOperator.OR : conditionOperator.AND;
};
// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/utils.js
var utils = __webpack_require__(123);

// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-tabs/automated-tab.component.less
var automated_tab_component = __webpack_require__(878);
var automated_tab_component_default = /*#__PURE__*/__webpack_require__.n(automated_tab_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-tabs/automated-tab.component.less

            

var automated_tab_component_options = {};

automated_tab_component_options.insert = "head";
automated_tab_component_options.singleton = false;

var automated_tab_component_update = injectStylesIntoStyleTag_default()(automated_tab_component_default.a, automated_tab_component_options);



/* harmony default export */ var transition_tabs_automated_tab_component = (automated_tab_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-tabs/automated-tab.component.js








function automated_tab_component_createSuper(Derived) { var hasNativeReflectConstruct = automated_tab_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function automated_tab_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }











var actions = [{
  caption: 'Move to next stage',
  items: [{
    iconClass: 'circle-check-icon',
    text: 'Items that are completed'
  }, {
    iconClass: 'circle-minus-icon',
    text: 'Items that are skipped'
  }]
}, {
  caption: 'Descope',
  items: [{
    iconClass: 'pending-icon',
    text: 'Items in waiting state'
  }, {
    iconClass: 'progress-icon',
    text: 'Items in progress state'
  }]
}];
var automated_tab_component_AutomatedTabComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(AutomatedTabComponent, _Component);

  var _super = automated_tab_component_createSuper(AutomatedTabComponent);

  function AutomatedTabComponent(props) {
    var _this;

    classCallCheck_default()(this, AutomatedTabComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "enterEditMode", function () {
      _this.props.showConditionEditMode(true);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "cancelEditMode", function () {
      _this.props.showConditionEditMode(false);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onSave", function () {
      _this.props.saveConditions();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionLabel", function (conditionType) {
      switch (conditionType) {
        case conditionTypes.TIMED:
          return 'Scheduled';

        case conditionTypes.STATE:
          return 'All items are completed';

        default:
          return "Not defined type ".concat(conditionType, ". Please add or change case statement");
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionStatusIcon", function (condition) {
      var isPendingStateCondition = isStateCondition(condition) && !condition.satisfied;
      var addMargin = !isGroupCondition(condition) && !isPendingStateCondition && (condition.satisfied || !_this.props.isConditionEditMode);
      var statusIconClass = classnames_default()('xl-icon', {
        'extra-margin': addMargin,
        'circle-check-icon': condition.satisfied,
        'pending-icon': !condition.satisfied
      });
      return /*#__PURE__*/external_React_default.a.createElement("i", {
        className: statusIconClass
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionBlockStatusLabel", function (conditionGroup) {
      var automated = _this.props.transition.automated;
      var statusLabelClass = classnames_default()('label', {
        'label-paused': !automated,
        'label-completed': automated && conditionGroup.satisfied,
        'label-pending': automated && !conditionGroup.satisfied
      });
      var text = !automated ? 'Paused' : conditionGroup.satisfied ? "Satisfied" : "Pending";
      return /*#__PURE__*/external_React_default.a.createElement("p", null, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: statusLabelClass
      }, text));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isConditionEditable", function (group, condition) {
      return !group.satisfied && !condition.satisfied && isTimeCondition(condition);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onConditionTimeChange", function (oldValue, newValue, condition) {
      if (oldValue.getTime() !== newValue.getTime()) {
        _this.props.updateCondition(condition.id, newValue);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onValidityChange", function (valid, conditionId) {
      var invalid = _this.state.invalid;

      if (!valid && !invalid.includes(conditionId)) {
        invalid.push(conditionId);

        _this.setState({
          invalid: invalid
        });
      } else if (valid && invalid.includes(conditionId)) {
        invalid.splice(invalid.indexOf(conditionId), 1);

        _this.setState({
          invalid: invalid
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "doNotShowConditionStatusIcon", function (group, condition) {
      var transition = _this.props.transition;
      var isNotSatisfiedInSatisfiedGroup = group.satisfied && !condition.satisfied;
      var isTransitionNotAutomated = !transition.automated;
      return isNotSatisfiedInSatisfiedGroup || isTransitionNotAutomated;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderCondition", function (group, condition, idx) {
      var _this$props = _this.props,
          isConditionEditMode = _this$props.isConditionEditMode,
          conditionChanges = _this$props.conditionChanges,
          dateTimeFormat = _this$props.dateTimeFormat;
      var change = conditionChanges.find(function (c) {
        return c.id === condition.id;
      });
      var changedDate = change ? change.fixedDate : null;
      var model = changedDate || new Date(condition.fixedDate) || new Date();
      var conditionClass = classnames_default()('condition-item', {
        ignored: group.satisfied && !condition.satisfied
      });
      var formats = dateTimeFormat.split('-');
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, {
        key: condition.id
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: conditionClass
      }, _this.renderConditionLabel(condition.type), _this.doNotShowConditionStatusIcon(group, condition) || _this.renderConditionStatusIcon(condition), isConditionEditMode && _this.isConditionEditable(group, condition) && /*#__PURE__*/external_React_default.a.createElement(widgets["a" /* WidgetDateTime */], {
        metadata: {
          description: 'Select time to perform the transition'
        },
        minDate: new Date(),
        model: model,
        onDatePristinityChange: noop_default.a,
        onModelChange: function onModelChange(newValue) {
          return _this.onConditionTimeChange(model, newValue, condition);
        },
        onTimePristinityChange: noop_default.a,
        onValidityChange: function onValidityChange(valid) {
          return _this.onValidityChange(valid, condition.id);
        }
      }) || (isTimeCondition(condition) || condition.satisfied) && /*#__PURE__*/external_React_default.a.createElement("div", null, Object(utils["a" /* formatDateTime */])(condition.satisfiedDate || condition.fixedDate, formats[0], formats[1]))), group.conditions.length !== idx + 1 && /*#__PURE__*/external_React_default.a.createElement("h4", {
        className: "condition-expr"
      }, /*#__PURE__*/external_React_default.a.createElement("span", null, group.operator)));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderGroupExpr", function (op) {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "condition-group-expr"
      }, stage_reducer_inverseOperator(op));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderConditionGroup", function (count, group, idx) {
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, {
        key: group.id
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "condition-group"
      }, _this.renderConditionBlockStatusLabel(group), group.conditions.map(function (c, jdx) {
        return _this.renderCondition(group, c, jdx);
      })), count !== idx + 1 && _this.renderGroupExpr(group.operator));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderActions", function () {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "actions-container"
      }, /*#__PURE__*/external_React_default.a.createElement("h4", null, "Actions"), /*#__PURE__*/external_React_default.a.createElement("div", null, actions.map(function (action, i) {
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "action",
          key: i
        }, /*#__PURE__*/external_React_default.a.createElement("span", {
          className: "caption"
        }, action.caption), action.items.map(function (item, j) {
          return /*#__PURE__*/external_React_default.a.createElement("div", {
            className: "item",
            key: j
          }, /*#__PURE__*/external_React_default.a.createElement("i", {
            className: "xl-icon ".concat(item.iconClass)
          }), item.text);
        }));
      })));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resumeTransition", function () {
      _this.props.markTransitionAutomated();

      _this.props.saveConditions();
    });

    _this.state = {
      invalid: []
    };
    return _this;
  }

  createClass_default()(AutomatedTabComponent, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.cancelEditMode();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          conditionChanges = _this$props2.conditionChanges,
          isEditable = _this$props2.isEditable,
          isConditionEditMode = _this$props2.isConditionEditMode,
          transition = _this$props2.transition,
          isClosed = _this$props2.isClosed;
      var conditions = transition.conditions;
      var invalid = this.state.invalid;
      var rootGroup = conditions.length === 1 ? conditions[0] : null;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "automated-tab-container"
      }, /*#__PURE__*/external_React_default.a.createElement("h4", null, isConditionEditMode && 'Edit conditions' || 'Conditions', isEditable && !isConditionEditMode && rootGroup && /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon edit-icon",
        onClick: this.enterEditMode
      })), isEditable && !isConditionEditMode && !isClosed && !transition.automated && /*#__PURE__*/external_React_default.a.createElement(components["a" /* AlertMessage */], {
        alertType: components["z" /* alertType */].WARNING
      }, /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("div", null, "Transition was reopened but automation conditions are paused"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "link"
      }, /*#__PURE__*/external_React_default.a.createElement("a", {
        onClick: this.resumeTransition
      }, "Resume automation")))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-action-form"
      }, rootGroup && rootGroup.conditions.map(function (group, idx) {
        return _this2.renderConditionGroup(rootGroup.conditions.length, group, idx);
      })), isConditionEditMode && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button cancel",
        onClick: this.cancelEditMode
      }, "Cancel"), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary",
        disabled: conditionChanges.length === 0 || invalid.length > 0,
        onClick: this.onSave
      }, "Save")), !isConditionEditMode && this.renderActions());
    }
  }]);

  return AutomatedTabComponent;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-tabs/manual-tab.component.js






function manual_tab_component_createSuper(Derived) { var hasNativeReflectConstruct = manual_tab_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function manual_tab_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }




var manual_tab_component_ManualTabComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(ManualTabComponent, _Component);

  var _super = manual_tab_component_createSuper(ManualTabComponent);

  function ManualTabComponent() {
    classCallCheck_default()(this, ManualTabComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(ManualTabComponent, [{
    key: "renderActionBoxWhenStageOpenedWithSelectableItems",
    value: function renderActionBoxWhenStageOpenedWithSelectableItems(transition, handleTransitionClick, handleCompletePrevStageChange, isEditable) {
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("h5", {
        className: "transition-title"
      }, "Action"), /*#__PURE__*/external_React_default.a.createElement("div", null, "Select the tracked items that should transition to the next stage"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-action-form"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("input", {
        checked: transition.closeStages,
        disabled: !isEditable,
        onChange: function onChange(event) {
          return handleCompletePrevStageChange(event.target.checked);
        },
        type: "checkbox"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "transition-action-label ".concat(!isEditable && 'disabled'),
        onClick: function onClick() {
          return isEditable && handleCompletePrevStageChange(!transition.closeStages);
        }
      }, "Complete the previous stages"))), transition.closeStages && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-action-warning"
      }, /*#__PURE__*/external_React_default.a.createElement(components["a" /* AlertMessage */], {
        alertType: components["z" /* alertType */].WARNING
      }, /*#__PURE__*/external_React_default.a.createElement("span", null, "Not completed items will be descoped when completing stages"))), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary btn-transition",
        disabled: transition.disabledTransition || !isEditable,
        onClick: handleTransitionClick
      }, "Transition (", transition.selectedTransitionItemCount, ") tracked items"));
    }
  }, {
    key: "renderActionBoxWhenStageOpenedWithoutSelectableItems",
    value: function renderActionBoxWhenStageOpenedWithoutSelectableItems() {
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("h5", {
        className: "transition-title"
      }, "Action"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "no-items"
      }, "There are currently no tracked items available to transition to the next stage"), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary btn-transition",
        disabled: true
      }, "Transition (0) tracked items"));
    }
  }, {
    key: "renderActionBoxWhenStageClosedWithSelectableItems",
    value: function renderActionBoxWhenStageClosedWithSelectableItems() {
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("h5", {
        className: "transition-title"
      }, "Action"), /*#__PURE__*/external_React_default.a.createElement("div", null, "Some tracked item(s) did not transition to the next stage, please reopen the stage to make a transition."));
    }
  }, {
    key: "renderActionBoxWhenStageClosedWithoutSelectableItems",
    value: function renderActionBoxWhenStageClosedWithoutSelectableItems() {
      return /*#__PURE__*/external_React_default.a.createElement("div", null);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          isClosed = _this$props.isClosed,
          isSelectable = _this$props.isSelectable,
          transition = _this$props.transition,
          isEditable = _this$props.isEditable,
          handleCompletePrevStageChange = _this$props.handleCompletePrevStageChange,
          handleTransitionClick = _this$props.handleTransitionClick;

      if (isClosed) {
        return isSelectable ? this.renderActionBoxWhenStageClosedWithSelectableItems() : this.renderActionBoxWhenStageClosedWithoutSelectableItems();
      } else {
        return isSelectable ? this.renderActionBoxWhenStageOpenedWithSelectableItems(transition, handleTransitionClick, handleCompletePrevStageChange, isEditable) : this.renderActionBoxWhenStageOpenedWithoutSelectableItems();
      }
    }
  }]);

  return ManualTabComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-action.component.less
var transition_action_component = __webpack_require__(879);
var transition_action_component_default = /*#__PURE__*/__webpack_require__.n(transition_action_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-action.component.less

            

var transition_action_component_options = {};

transition_action_component_options.insert = "head";
transition_action_component_options.singleton = false;

var transition_action_component_update = injectStylesIntoStyleTag_default()(transition_action_component_default.a, transition_action_component_options);



/* harmony default export */ var delivery_flow_transition_action_component = (transition_action_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-action.component.js






function transition_action_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_action_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_action_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var transition_action_component_TransitionActionComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TransitionActionComponent, _Component);

  var _super = transition_action_component_createSuper(TransitionActionComponent);

  function TransitionActionComponent() {
    classCallCheck_default()(this, TransitionActionComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(TransitionActionComponent, [{
    key: "conditionsDefined",
    value: function conditionsDefined(transition) {
      return transition.conditions.length > 0 && transition.conditions[0].conditions.length > 0;
    }
  }, {
    key: "isAutomated",
    value: function isAutomated(selectedTab, transition) {
      return selectedTab === transitionTabs[0].value && this.conditionsDefined(transition);
    }
  }, {
    key: "isManual",
    value: function isManual(selectedTab, transition) {
      return selectedTab === transitionTabs[1].value || transition.conditions.length === 0 || transition.conditions[0].conditions.length === 0;
    }
  }, {
    key: "renderTabs",
    value: function renderTabs(activeTab, onTabChange) {
      return transitionTabs.map(function (tab) {
        return /*#__PURE__*/external_React_default.a.createElement("h5", {
          className: classnames_default()('link', {
            'active': activeTab === tab.value
          }),
          key: tab.value,
          onClick: function onClick() {
            return onTabChange(tab.value);
          }
        }, tab.label);
      });
    }
  }, {
    key: "renderManualTitle",
    value: function renderManualTitle() {
      return /*#__PURE__*/external_React_default.a.createElement("h5", {
        className: "full-width active"
      }, transitionTabs[1].label);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          conditionChanges = _this$props.conditionChanges,
          dateTimeFormat = _this$props.dateTimeFormat,
          isClosed = _this$props.isClosed,
          isSelectable = _this$props.isSelectable,
          isEditable = _this$props.isEditable,
          markTransitionAutomated = _this$props.markTransitionAutomated,
          selectedTab = _this$props.selectedTab,
          transition = _this$props.transition,
          onTabChange = _this$props.onTabChange,
          containerHeight = _this$props.containerHeight,
          handleCompletePrevStageChange = _this$props.handleCompletePrevStageChange,
          handleTransitionClick = _this$props.handleTransitionClick,
          resetConditions = _this$props.resetConditions,
          saveConditions = _this$props.saveConditions,
          updateCondition = _this$props.updateCondition,
          isConditionEditMode = _this$props.isConditionEditMode,
          showConditionEditMode = _this$props.showConditionEditMode;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('transition-action-container', {
          'full-width': this.isAutomated(selectedTab, transition)
        }),
        style: {
          height: containerHeight
        }
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-tab-nav"
      }, this.conditionsDefined(transition) && this.renderTabs(selectedTab, onTabChange) || this.renderManualTitle()), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-tab-content"
      }, this.isAutomated(selectedTab, transition) && /*#__PURE__*/external_React_default.a.createElement(automated_tab_component_AutomatedTabComponent, {
        conditionChanges: conditionChanges,
        dateTimeFormat: dateTimeFormat,
        isClosed: isClosed,
        isConditionEditMode: isConditionEditMode,
        isEditable: isEditable && !isClosed,
        markTransitionAutomated: markTransitionAutomated,
        resetConditions: resetConditions,
        saveConditions: saveConditions,
        showConditionEditMode: showConditionEditMode,
        transition: transition,
        updateCondition: updateCondition
      }), this.isManual(selectedTab, transition) && /*#__PURE__*/external_React_default.a.createElement(manual_tab_component_ManualTabComponent, {
        handleCompletePrevStageChange: handleCompletePrevStageChange,
        handleTransitionClick: handleTransitionClick,
        isClosed: isClosed,
        isEditable: isEditable,
        isSelectable: isSelectable,
        transition: transition
      })));
    }
  }]);

  return TransitionActionComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-header.component.less
var transition_header_component = __webpack_require__(880);
var transition_header_component_default = /*#__PURE__*/__webpack_require__.n(transition_header_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-header.component.less

            

var transition_header_component_options = {};

transition_header_component_options.insert = "head";
transition_header_component_options.singleton = false;

var transition_header_component_update = injectStylesIntoStyleTag_default()(transition_header_component_default.a, transition_header_component_options);



/* harmony default export */ var delivery_flow_transition_header_component = (transition_header_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-header.component.js








function transition_header_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var transition_header_component_TransitionHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TransitionHeaderComponent, _Component);

  var _super = transition_header_component_createSuper(TransitionHeaderComponent);

  function TransitionHeaderComponent() {
    var _this;

    classCallCheck_default()(this, TransitionHeaderComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTransitionActionBox", function (transition, isActionSelectable, isEditable, isClosed, handleTransitionClick, handleCompletePrevStageChange, containerHeight, selectedTab, onTabChange) {
      var _this$props = _this.props,
          conditionChanges = _this$props.conditionChanges,
          dateTimeFormat = _this$props.dateTimeFormat,
          markTransitionAutomated = _this$props.markTransitionAutomated,
          resetConditions = _this$props.resetConditions,
          saveConditions = _this$props.saveConditions,
          updateCondition = _this$props.updateCondition,
          isConditionEditMode = _this$props.isConditionEditMode,
          showConditionEditMode = _this$props.showConditionEditMode;
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "transition-action-wrapper"
      }, /*#__PURE__*/external_React_default.a.createElement(transition_action_component_TransitionActionComponent, {
        conditionChanges: conditionChanges,
        containerHeight: containerHeight,
        dateTimeFormat: dateTimeFormat,
        handleCompletePrevStageChange: handleCompletePrevStageChange,
        handleTransitionClick: handleTransitionClick,
        isClosed: isClosed,
        isConditionEditMode: isConditionEditMode,
        isEditable: isEditable,
        isSelectable: isActionSelectable,
        markTransitionAutomated: markTransitionAutomated,
        onTabChange: onTabChange,
        resetConditions: resetConditions,
        saveConditions: saveConditions,
        selectedTab: selectedTab,
        showConditionEditMode: showConditionEditMode,
        transition: transition,
        updateCondition: updateCondition
      }));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderHeaderCheckbox", function (isEditable, isSelectedAll, onTransitionColumnSelectChange) {
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, isEditable && isSelectedAll && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "header-checkbox selected",
        onClick: function onClick() {
          return onTransitionColumnSelectChange(false);
        }
      }, "\xA0"), isEditable && !isSelectedAll && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "header-checkbox",
        onClick: function onClick() {
          return onTransitionColumnSelectChange(true);
        }
      }, "\xA0"), !isEditable && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "header-checkbox disabled"
      }, "\xA0"));
    });

    return _this;
  }

  createClass_default()(TransitionHeaderComponent, [{
    key: "renderToggleButton",
    value: function renderToggleButton(isExpanded, toggleColumn) {
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "transition-toggle-button",
        onClick: function onClick() {
          return toggleColumn();
        }
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: classnames_default()('xl-icon', {
          'chevron-left-icon': isExpanded
        }, {
          'chevron-right-icon': !isExpanded
        })
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isExpanded = _this$props2.isExpanded,
          isSelectable = _this$props2.isSelectable,
          isSelectedAll = _this$props2.isSelectedAll,
          isCompleted = _this$props2.isCompleted,
          name = _this$props2.name,
          onTransitionColumnSelectChange = _this$props2.onTransitionColumnSelectChange,
          toggleColumn = _this$props2.toggleColumn,
          isEditable = _this$props2.isEditable,
          transition = _this$props2.transition,
          containerHeight = _this$props2.containerHeight,
          isClosed = _this$props2.isClosed,
          isManual = _this$props2.isManual,
          handleTransitionClick = _this$props2.handleTransitionClick,
          handleCompletePrevStageChange = _this$props2.handleCompletePrevStageChange,
          selectedTab = _this$props2.selectedTab,
          onTabChange = _this$props2.onTabChange;
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('header-cell', 'transition-header', {
          'active': isExpanded
        }, {
          'closed': isCompleted
        })
      }, isExpanded && /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('transition-cell-data', {
          'empty-content': !isManual
        })
      }, !isClosed && isSelectable && isManual && this.renderHeaderCheckbox(isEditable, isSelectedAll, onTransitionColumnSelectChange), this.renderTransitionActionBox(transition, isSelectable, isEditable, isClosed, handleTransitionClick, handleCompletePrevStageChange, containerHeight, selectedTab, onTabChange)), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-cell-actions"
      }, /*#__PURE__*/external_React_default.a.createElement("h6", {
        className: "transition-name",
        title: name
      }, name))), this.renderToggleButton(isExpanded, toggleColumn, isEditable));
    }
  }]);

  return TransitionHeaderComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-cell.component.less
var transition_cell_component = __webpack_require__(881);
var transition_cell_component_default = /*#__PURE__*/__webpack_require__.n(transition_cell_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-cell.component.less

            

var transition_cell_component_options = {};

transition_cell_component_options.insert = "head";
transition_cell_component_options.singleton = false;

var transition_cell_component_update = injectStylesIntoStyleTag_default()(transition_cell_component_default.a, transition_cell_component_options);



/* harmony default export */ var delivery_flow_transition_cell_component = (transition_cell_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/transition-cell.component.js








function transition_cell_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_cell_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_cell_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var transition_cell_component_TransitionCellComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TransitionCellComponent, _Component);

  var _super = transition_cell_component_createSuper(TransitionCellComponent);

  function TransitionCellComponent() {
    var _this;

    classCallCheck_default()(this, TransitionCellComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "renderWithPopover", function (content, body) {
      return /*#__PURE__*/external_React_default.a.createElement(popover["a" /* default */], {
        arrowPointAtCenter: true,
        content: content,
        mouseLeaveDelay: 0,
        overlayClassName: "transition-approval-popover",
        placement: "left",
        trigger: "hover"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-popover-body"
      }, body));
    });

    return _this;
  }

  createClass_default()(TransitionCellComponent, [{
    key: "renderApprovalContent",
    value: function renderApprovalContent(approvalDetails) {
      return "".concat(moment(approvalDetails.eventTime).format('ll'), " - Transitioned by ").concat(approvalDetails.user.username);
    }
  }, {
    key: "renderCellData",
    value: function renderCellData(transitionItem, handleTransitionSelectChange, isClosed, isEditable) {
      return transitionItem && !(isClosed && !transitionItem.disabled) && /*#__PURE__*/external_React_default.a.createElement("input", {
        checked: transitionItem.checked && (transitionItem.disabled || isEditable),
        disabled: transitionItem.disabled || !isEditable,
        onChange: function onChange(event) {
          return handleTransitionSelectChange(event.target.checked);
        },
        type: "checkbox"
      });
    }
  }, {
    key: "renderCompletedTransition",
    value: function renderCompletedTransition(approvalContent) {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "closed-transition-content"
      }, approvalContent);
    }
  }, {
    key: "renderOpenedTransition",
    value: function renderOpenedTransition(transitionItem, handleTransitionSelectChange, approvalContent, isClosed, isEditable) {
      var cellData = this.renderCellData(transitionItem, handleTransitionSelectChange, isClosed, isEditable);
      return approvalContent ? this.renderWithPopover(approvalContent, cellData) : cellData;
    }
  }, {
    key: "renderExpandedCell",
    value: function renderExpandedCell() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          approvalDetails = _this$props.approvalDetails,
          isClosed = _this$props.isClosed,
          isCompleted = _this$props.isCompleted,
          isManual = _this$props.isManual,
          transitionItem = _this$props.transitionItem,
          handleTransitionSelectChange = _this$props.handleTransitionSelectChange;
      var approvalContent = approvalDetails && this.renderApprovalContent(approvalDetails);
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, isCompleted ? this.renderCompletedTransition(approvalContent) : isManual && this.renderOpenedTransition(transitionItem, handleTransitionSelectChange, approvalContent, isClosed, isEditable));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isExpanded = _this$props2.isExpanded,
          isManual = _this$props2.isManual;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-cell-data-wrapper"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('transition-cell-data', {
          'show-strips': isManual
        }, {
          'empty-content': !isManual
        })
      }, isExpanded && this.renderExpandedCell()));
    }
  }]);

  return TransitionCellComponent;
}(external_React_["Component"]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view-layout.less
var delivery_flow_view_layout = __webpack_require__(882);
var delivery_flow_view_layout_default = /*#__PURE__*/__webpack_require__.n(delivery_flow_view_layout);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view-layout.less

            

var delivery_flow_view_layout_options = {};

delivery_flow_view_layout_options.insert = "head";
delivery_flow_view_layout_options.singleton = false;

var delivery_flow_view_layout_update = injectStylesIntoStyleTag_default()(delivery_flow_view_layout_default.a, delivery_flow_view_layout_options);



/* harmony default export */ var delivery_flow_delivery_flow_view_layout = (delivery_flow_view_layout_default.a.locals || {});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view.less
var delivery_flow_view = __webpack_require__(883);
var delivery_flow_view_default = /*#__PURE__*/__webpack_require__.n(delivery_flow_view);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view.less

            

var delivery_flow_view_options = {};

delivery_flow_view_options.insert = "head";
delivery_flow_view_options.singleton = false;

var delivery_flow_view_update = injectStylesIntoStyleTag_default()(delivery_flow_view_default.a, delivery_flow_view_options);



/* harmony default export */ var delivery_flow_delivery_flow_view = (delivery_flow_view_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/components/delivery-flow/delivery-flow-view.component.js








function delivery_flow_view_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_flow_view_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_flow_view_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }


























var filterDeliveryFieldMetadata = {
  placeholder: 'Filter by tracked item...'
};
var deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var descopeButton = {
  action: 'descope',
  className: 'button primary',
  keyCodes: [13],
  label: 'Descope'
};
var rescopeButton = {
  action: 'rescope',
  className: 'button primary',
  keyCodes: [13],
  label: 'Rescope'
};
var delivery_flow_view_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var skipButton = {
  action: 'skip',
  className: 'button primary',
  keyCodes: [13],
  label: 'Skip'
};
var delivery_flow_view_component_completeButton = {
  action: 'complete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Complete'
};
var initTrackItemState = function initTrackItemState() {
  return {
    id: null,
    title: ''
  };
};
var openModalProps = {
  DELETE: 'deleteModalIsOpen',
  DESCOPE: 'descopeModalIsOpen',
  RESCOPE: 'rescopeModalIsOpen',
  SKIP: 'skipModalIsOpen',
  COMPLETE: 'completeModalIsOpen'
};
var headerHeight = 60;
var rowHeight = 60;
var delivery_flow_view_component_DeliveryFlowViewComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryFlowViewComponent, _Component);

  var _super = delivery_flow_view_component_createSuper(DeliveryFlowViewComponent);

  function DeliveryFlowViewComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryFlowViewComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "updateContainerClass", function () {
      _this.setState({
        windowResized: !_this.state.windowResized
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemRowFocus", function (trackedItemId) {
      _this.setState({
        activeTrackedItemMenu: trackedItemId
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseConfirmModal", function (action) {
      var trackedItem = _this.state.trackedItem;

      switch (action) {
        case deleteButton.action:
          _this.props.deleteTrackedItem(trackedItem.id);

          break;

        case descopeButton.action:
          _this.props.descopeTrackedItem(trackedItem.id);

          break;

        case rescopeButton.action:
          _this.props.rescopeTrackedItem(trackedItem.id);

          break;

        case skipButton.action:
          {
            var stage = _this.state.stage;

            _this.props.skipTrackedItem(stage, trackedItem);

            break;
          }

        case delivery_flow_view_component_completeButton.action:
          {
            var _stage = _this.state.stage;

            _this.props.completeTrackedItem(_stage, trackedItem);

            break;
          }

        case delivery_flow_view_component_cancelButton.action:
          {
            break;
          }

        default:
          throw 'Unknown modal action';
      }

      Object.keys(openModalProps).forEach(function (key) {
        var prop = openModalProps[key];

        if (_this.state[prop]) {
          _this.setState(defineProperty_default()({
            trackedItem: initTrackItemState()
          }, prop, false));
        }
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "expandStage", function (stage) {
      var _this$props = _this.props,
          delivery = _this$props.delivery,
          getStageReleaseDetails = _this$props.getStageReleaseDetails;

      if (_this.state.activeStageId !== stage.id) {
        if (stage.items.length) {
          getStageReleaseDetails(delivery.id);
        }

        _this.setState({
          activeStageId: stage.items.length ? stage.id : null
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "collapseStage", function () {
      _this.setState({
        activeStageId: null
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "toggleTransition", function (transition) {
      var _this$props2 = _this.props,
          activeTransition = _this$props2.activeTransition,
          activateTransition = _this$props2.activateTransition,
          deactivateTransition = _this$props2.deactivateTransition,
          stages = _this$props2.stages;

      if (activeTransition.id === transition.id) {
        deactivateTransition();
      } else {
        var currentStage = stages.find(function (stage) {
          return stage.id === transition.stage;
        });
        activateTransition({
          id: transition.id,
          items: currentStage.items.filter(function (item) {
            return item.transitionItem !== null;
          }),
          status: currentStage.transition
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTransitionTabChange", function (tabValue) {
      _this.props.changeTransitionTab(tabValue);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTransition", function (stage) {
      var _this$props3 = _this.props,
          delivery = _this$props3.delivery,
          postTransitionDetails = _this$props3.postTransitionDetails;
      var transitionItems = map_default()(stage.items, function (item) {
        if (item.transitionItem && !item.transitionItem.disabled && item.transitionItem.checked) {
          return item.trackedItemId;
        }
      }).filter(function (item) {
        return !isUndefined_default()(item);
      });
      postTransitionDetails(delivery.id, stage.transition, transitionItems);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showConfirmModal", function (trackedItem, prop) {
      var _this$setState2;

      return _this.setState((_this$setState2 = {}, defineProperty_default()(_this$setState2, prop, true), defineProperty_default()(_this$setState2, "trackedItem", trackedItem), _this$setState2));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showEditModal", function (trackedItem) {
      return _this.setState({
        editModalIsOpen: true,
        trackedItem: trackedItem,
        editModalTitle: 'Edit tracked item'
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCreate", function () {
      _this.setState({
        editModalIsOpen: true,
        editModalTitle: 'Add new tracked item'
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditSave", function (trackedItem) {
      var createAnother = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var _this$props4 = _this.props,
          saveTrackedItem = _this$props4.saveTrackedItem,
          delivery = _this$props4.delivery;
      saveTrackedItem(trackedItem, delivery.id);
      var trackItemState = initTrackItemState();

      _this.setState({
        editModalIsOpen: createAnother,
        trackedItem: trackItemState
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditCancel", function () {
      var trackItemState = initTrackItemState();

      _this.setState({
        editModalIsOpen: false,
        trackedItem: trackItemState
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (name) {
      _this.setState({
        trackedItemFilterText: name
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTransitionSelectChange", function (stageId, stageItemId, isSelected) {
      var _this$props5 = _this.props,
          activeTransition = _this$props5.activeTransition,
          stages = _this$props5.stages,
          updateTransitionSelection = _this$props5.updateTransitionSelection;
      var currentStage = stages.find(function (stage) {
        return stage.id === stageId;
      });
      currentStage.items.forEach(function (item) {
        if (item.id === stageItemId) {
          item.transitionItem.checked = isSelected;
        }
      });
      currentStage.transition.selectedTransitionItemCount = countSelectedTransitionItems(currentStage.items);
      currentStage.transition.disabledTransition = isDisabledTransition(currentStage.transition);

      if (activeTransition.id !== null) {
        updateTransitionSelection({
          status: currentStage.transition,
          items: currentStage.items.filter(function (item) {
            return item.transitionItem !== null;
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTransitionColumnSelectChange", function (stageId, isSelected) {
      var _this$props6 = _this.props,
          stages = _this$props6.stages,
          updateTransitionSelection = _this$props6.updateTransitionSelection;
      var currentStage = stages.find(function (stage) {
        return stage.id === stageId;
      });
      currentStage.items.forEach(function (item) {
        if (item.transitionItem && !item.transitionItem.disabled) {
          item.transitionItem.checked = isSelected;
        }
      });
      currentStage.transition.selectedTransitionItemCount = countSelectedTransitionItems(currentStage.items);
      currentStage.transition.disabledTransition = isDisabledTransition(currentStage.transition);
      updateTransitionSelection({
        items: currentStage.items.filter(function (item) {
          return item.transitionItem !== null;
        }),
        status: currentStage.transition
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCompletePrevStageChange", function (stage, isSelected) {
      var _this$props7 = _this.props,
          stages = _this$props7.stages,
          updateTransitionSelection = _this$props7.updateTransitionSelection;
      var currentStage = stages.find(function (s) {
        return s.id === stage.id;
      });
      currentStage.transition.closeStages = isSelected;
      currentStage.transition.disabledTransition = isDisabledTransition(currentStage.transition);
      updateTransitionSelection({
        items: currentStage.items.filter(function (item) {
          return item.transitionItem !== null;
        }),
        status: currentStage.transition
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isStageActive", function (stage) {
      var activeStageId = _this.state.activeStageId;
      return !!activeStageId && !!stage && activeStageId === stage.id;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isTransitionActive", function (transition) {
      var activeTransition = _this.props.activeTransition;
      return !!transition && activeTransition.id === transition.id;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "isManualTransition", function (transition) {
      return transition && transition.conditions.length === 0 || transition.conditions[0].conditions.length === 0 || _this.props.activeTransitionTab === transitionTabs[1].value;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showSkipItemInStageModal", function (stage, trackedItem) {
      var _this$setState3;

      return _this.setState((_this$setState3 = {}, defineProperty_default()(_this$setState3, openModalProps.SKIP, true), defineProperty_default()(_this$setState3, "stage", stage), defineProperty_default()(_this$setState3, "trackedItem", trackedItem), _this$setState3));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showCompleteItemInStageModal", function (stage, trackedItem) {
      var _this$setState4;

      return _this.setState((_this$setState4 = {}, defineProperty_default()(_this$setState4, openModalProps.COMPLETE, true), defineProperty_default()(_this$setState4, "stage", stage), defineProperty_default()(_this$setState4, "trackedItem", trackedItem), _this$setState4));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTrackedItemEditModal", function (editModalIsOpen, editModalTitle, trackedItem, trackedItems) {
      return /*#__PURE__*/external_React_default.a.createElement(tracked_item_edit_modal_component_TrackedItemEditModalComponent, {
        isOpened: editModalIsOpen,
        modalTitle: editModalTitle,
        model: trackedItem,
        onCancel: _this.handleTrackedItemEditCancel,
        onSave: _this.handleTrackedItemEditSave,
        trackedItems: trackedItems
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderStageCell", function (stage, stageItem, trackedItem, isStageActive, isTrackedItemEditable) {
      var _this$props8 = _this.props,
          activeStageReleases = _this$props8.activeStageReleases,
          loadingReleasesInfo = _this$props8.loadingReleasesInfo;
      var isMenuVisible = !!stageItem && _this.isRowInFocus(stageItem.trackedItemId) && isTrackedItemEditable;
      var stageMenuOptions = [{
        label: 'Complete',
        handler: function handler() {
          return _this.showCompleteItemInStageModal(stage, trackedItem);
        }
      }, {
        label: 'Skip',
        handler: function handler() {
          return _this.showSkipItemInStageModal(stage, trackedItem);
        }
      }];
      return /*#__PURE__*/external_React_default.a.createElement(stage_cell_component_StageCellComponent, {
        expandedStageReleases: activeStageReleases,
        isExpanded: isStageActive,
        isMenuVisible: isMenuVisible,
        loading: loadingReleasesInfo,
        stageItem: stageItem,
        stageMenuOptions: stageMenuOptions,
        trackedItem: trackedItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderFirstColumnCell", function (item) {
      var _this$props9 = _this.props,
          delivery = _this$props9.delivery,
          status = _this$props9.status;
      var isTrackedItemEditable = delivery.isTrackedItemEditable;
      return _this.buildRowCell(function () {
        return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, item.descoped && /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xl circle-outline-cross-icon"
        }), /*#__PURE__*/external_React_default.a.createElement("span", {
          className: "text-wrap",
          title: item.title
        }, item.title), _this.isRowInFocus(item.id) && isTrackedItemEditable && status !== delivery_flow_constants_deliveryStatus.completed && _this.renderTrackedItemMenu(item));
      }, "item-".concat(item.id), 'tracked-item-cell');
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTransitionCell", function (stage, stageItem, item, isTransitionActive, isStageCompleted, isStageClosed) {
      var _this$props10 = _this.props,
          activeTransition = _this$props10.activeTransition,
          delivery = _this$props10.delivery,
          trackedItemApprovals = _this$props10.trackedItemApprovals;
      var approval = stageItem && trackedItemApprovals.find(function (approval) {
        return approval.targetId === stageItem.id;
      });
      var currentItem = activeTransition.items.find(function (currItem) {
        return currItem.trackedItemId === item.id;
      });
      var transitionItem = !!currentItem ? currentItem.transitionItem : null;

      var isManual = _this.isManualTransition(stage.transition);

      return /*#__PURE__*/external_React_default.a.createElement(transition_cell_component_TransitionCellComponent, {
        approvalDetails: approval,
        handleTransitionSelectChange: function handleTransitionSelectChange(isSelected) {
          return _this.onTransitionSelectChange(stage.id, stageItem.id, isSelected);
        },
        isClosed: isStageClosed,
        isCompleted: isStageCompleted,
        isEditable: delivery.isEditable,
        isExpanded: isTransitionActive,
        isManual: isManual,
        key: stage.selectableItemsCount,
        transitionItem: transitionItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "buildRow", function (renderer) {
      var rowTrackedItemId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('table-row', !!rowTrackedItemId ? {
          'hover': _this.isRowInFocus(rowTrackedItemId)
        } : 'last-row'),
        key: "row-".concat(rowTrackedItemId || 'empty'),
        onMouseEnter: function onMouseEnter() {
          return !!rowTrackedItemId && _this.handleTrackedItemRowFocus(rowTrackedItemId);
        },
        onMouseLeave: function onMouseLeave() {
          return !!rowTrackedItemId && _this.handleTrackedItemRowFocus(null);
        }
      }, renderer());
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "buildRowCell", function (renderer, key, rowClass) {
      var isExpanded = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var isClosed = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var rowClickHandler = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
      var isEnabledExpand = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : true;
      return /*#__PURE__*/external_React_default.a.createElement("span", {
        className: classnames_default()('body-cell', rowClass, {
          'active': isExpanded && isEnabledExpand,
          'closed': isClosed,
          'disabled-expand': !isEnabledExpand
        }),
        key: key,
        onClick: rowClickHandler
      }, renderer && renderer());
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderStageAndTransitionColumns", function (stage, trackedItem, index, isTrackedItemEditable, isEnabledExpand) {
      var isStageActive = _this.isStageActive(stage);

      var isStageClosed = _this.isStageClosed(stage);

      var isTransitionActive = _this.isTransitionActive(stage.transition);

      var isStageCompleted = _this.isStageCompleted(stage);

      var stageItem = stage.items.find(function (currItem) {
        return currItem.trackedItemId === trackedItem.id;
      });
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, {
        key: "fragment-".concat(stage.id, "-").concat(trackedItem.id, "-").concat(index)
      }, _this.buildRowCell(function () {
        return _this.renderStageCell(stage, stageItem, trackedItem, isStageActive, isTrackedItemEditable);
      }, "stage-".concat(trackedItem.id, "-").concat(index), 'stage-cell', isStageActive, isStageClosed, function () {
        return isEnabledExpand && _this.expandStage(stage);
      }, isEnabledExpand), stage.transition && _this.buildRowCell(function () {
        return _this.renderTransitionCell(stage, stageItem, trackedItem, isTransitionActive, isStageCompleted, isStageClosed);
      }, "transition-".concat(trackedItem.id, "-").concat(index), 'transition-cell', isTransitionActive, isStageCompleted, function () {
        return !isTransitionActive && _this.toggleTransition(stage.transition);
      }));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderStageAndTransitionColumnsForLastRow", function (stage, isEditable, isEnabledExpand, index) {
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, {
        key: "fragment-".concat(stage.id, "-last-row-").concat(index)
      }, _this.buildRowCell(null, "stage-".concat(stage.id, "-last-row"), 'stage-cell', _this.isStageActive(stage), _this.isStageClosed(stage), function () {
        return isEnabledExpand && _this.expandStage(stage);
      }, isEnabledExpand), stage.transition && _this.buildRowCell(function () {
        return /*#__PURE__*/external_React_default.a.createElement("span", {
          className: "transition-cell-data empty-cell"
        }, _this.isStageCompleted(stage) && /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "closed-transition-content"
        }, "\xA0"));
      }, "transition-".concat(stage.transition.id, "-last-row}"), 'transition-cell', _this.isTransitionActive(stage.transition), _this.isStageCompleted(stage), function () {
        return !_this.isTransitionActive(stage.transition) && _this.toggleTransition(stage.transition);
      }));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onLeftDivMouseDown", function (e) {
      e.preventDefault();
      document.addEventListener('mousemove', _this.onLeftDivMouseMove);
      document.addEventListener('mouseup', _this.onLeftDivMouseUp);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onLeftDivMouseMove", function (e) {
      e.preventDefault();

      if (e.clientX < 900) {
        _this.setState({
          leftDivWidth: e.clientX
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onLeftDivMouseUp", function () {
      document.removeEventListener('mousemove', _this.onLeftDivMouseMove);
      document.removeEventListener('mouseup', _this.onLeftDivMouseUp);
    });

    _this.contentContainerRef = /*#__PURE__*/external_React_default.a.createRef();
    _this.scrollableContentRef = /*#__PURE__*/external_React_default.a.createRef();
    _this.state = {
      editModalIsOpen: false,
      trackedItemFilterText: '',
      editModalTitle: 'Add new tracked item',
      trackedItem: {
        id: null,
        title: null
      },
      activeTrackedItemMenu: null,
      activeStageId: null,
      windowResized: true,
      leftDivWidth: 0
    };
    Object.keys(openModalProps).forEach(function (key) {
      return _this.state[key] = false;
    });
    return _this;
  }

  createClass_default()(DeliveryFlowViewComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props11 = this.props,
          updateDeliveryFlowPropsFromDetails = _this$props11.updateDeliveryFlowPropsFromDetails,
          delivery = _this$props11.delivery,
          fetchDeliveryDetailsWithPolling = _this$props11.fetchDeliveryDetailsWithPolling;
      updateDeliveryFlowPropsFromDetails();
      fetchDeliveryDetailsWithPolling(delivery.id);
      window.addEventListener('resize', this.updateContainerClass);
      this.props.setDateTimeFormat();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var stopPolling = this.props.stopPolling;
      stopPolling();
      window.removeEventListener('resize', this.updateContainerClass);
    }
  }, {
    key: "isColumnShort",
    value: function isColumnShort(numOfRows) {
      return this.contentContainerRef && this.contentContainerRef.current ? this.contentContainerRef.current.clientHeight - headerHeight - headerHeight > numOfRows * rowHeight : false;
    }
  }, {
    key: "getTransitionActionBlockHeight",
    value: function getTransitionActionBlockHeight() {
      return this.scrollableContentRef && this.scrollableContentRef.current ? "".concat(this.scrollableContentRef.current.clientHeight - headerHeight - 1, "px") : 'auto';
    }
  }, {
    key: "isStageClosed",
    value: function isStageClosed(stage) {
      return stage.status === stageStatus.closed;
    }
  }, {
    key: "isStageCompleted",
    value: function isStageCompleted(stage) {
      return this.isStageClosed(stage) && stage.selectableItemsCount === 0;
    }
  }, {
    key: "isFirstOpenedStage",
    value: function isFirstOpenedStage(stages, stageId) {
      var _this2 = this;

      var firstOpenedStage = stages.find(function (s) {
        return !_this2.isStageClosed(s);
      });
      return !!firstOpenedStage && firstOpenedStage.id === stageId;
    }
  }, {
    key: "isLastClosedStage",
    value: function isLastClosedStage(stages, stageId) {
      var _this3 = this;

      var lastClosedStage = findLast_default()(stages, function (s) {
        return _this3.isStageClosed(s);
      });
      return !!lastClosedStage && lastClosedStage.id === stageId;
    }
  }, {
    key: "isRowInFocus",
    value: function isRowInFocus(trackedItemId) {
      var activeTrackedItemMenu = this.state.activeTrackedItemMenu;
      return activeTrackedItemMenu === trackedItemId;
    }
  }, {
    key: "renderTrackedItemMenu",
    value: function renderTrackedItemMenu(item) {
      var _this4 = this;

      var menuOptions = [{
        label: 'Edit',
        handler: function handler() {
          return _this4.showEditModal(item);
        }
      }, {
        label: 'Delete',
        handler: function handler() {
          return _this4.showConfirmModal(item, openModalProps.DELETE);
        }
      }, {
        label: 'Rescope',
        handler: function handler() {
          return _this4.showConfirmModal(item, openModalProps.RESCOPE);
        },
        isVisible: item.descoped
      }, {
        label: 'Descope',
        handler: function handler() {
          return _this4.showConfirmModal(item, openModalProps.DESCOPE);
        },
        isVisible: !item.descoped
      }];
      return /*#__PURE__*/external_React_default.a.createElement(components["e" /* ContextMenuComponent */], {
        menuOptions: menuOptions,
        menuWrapperClassName: "tracked-item-menu-wrapper"
      });
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this5 = this;

      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Delete tracked item", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this5.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to delete tracked item ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderDescopeModal",
    value: function renderDescopeModal() {
      var _this6 = this;

      var descopeModalIsOpen = this.state.descopeModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Descope tracked item", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this6.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, descopeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: descopeModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to descope tracked item ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderRescopeModal",
    value: function renderRescopeModal() {
      var _this7 = this;

      var rescopeModalIsOpen = this.state.rescopeModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Rescope tracked item", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this7.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, rescopeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: rescopeModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to rescope tracked item ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderSkipModal",
    value: function renderSkipModal() {
      var _this8 = this;

      var skipModalIsOpen = this.state.skipModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Skip tracked item", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this8.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, skipButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: skipModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to skip tracked item ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderCompleteModal",
    value: function renderCompleteModal() {
      var _this9 = this;

      var completeModalIsOpen = this.state.completeModalIsOpen;
      var title = this.state.trackedItem.title;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Complete tracked item", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: function onClick() {
          return _this9.onCloseConfirmModal(delivery_flow_view_component_cancelButton.action);
        },
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_flow_view_component_cancelButton, delivery_flow_view_component_completeButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseConfirmModal,
        show: completeModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to complete tracked item ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, title), "."));
    }
  }, {
    key: "renderRows",
    value: function renderRows(trackedItems, isTrackedItemEditable, isEditable, isEnabledExpand) {
      var _this10 = this;

      var stages = this.props.stages;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, trackedItems.map(function (rowTrackedItem, index) {
        return _this10.buildRow(function () {
          return stages.map(function (stage) {
            return _this10.renderStageAndTransitionColumns(stage, rowTrackedItem, index, isTrackedItemEditable, isEnabledExpand);
          });
        }, rowTrackedItem.id);
      }), // build empty last row
      this.buildRow(function () {
        return stages.map(function (stage, index) {
          return _this10.renderStageAndTransitionColumnsForLastRow(stage, isEditable, isEnabledExpand, index);
        });
      }, null));
    }
  }, {
    key: "renderFirstColumnRows",
    value: function renderFirstColumnRows(trackedItems) {
      var _this11 = this;

      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, trackedItems.map(function (rowTrackedItem, index) {
        return _this11.buildRow(function () {
          return _this11.renderFirstColumnCell(rowTrackedItem, index);
        }, rowTrackedItem.id);
      }));
    }
  }, {
    key: "renderStageHeader",
    value: function renderStageHeader(stage, stages, isEnabledExpand) {
      var _this12 = this;

      var _this$props12 = this.props,
          completeStage = _this$props12.completeStage,
          delivery = _this$props12.delivery,
          reopenStage = _this$props12.reopenStage,
          status = _this$props12.status,
          trackedItems = _this$props12.trackedItems;
      var isStageActive = this.isStageActive(stage);
      var isStageClosed = this.isStageClosed(stage);

      var isMenuVisible = function isMenuVisible(stageId) {
        return status !== delivery_flow_constants_deliveryStatus.completed && (_this12.isFirstOpenedStage(stages, stageId) || _this12.isLastClosedStage(stages, stageId));
      };

      return /*#__PURE__*/external_React_default.a.createElement(stage_header_component_StageHeaderComponent, {
        collapseStage: this.collapseStage,
        completeStage: completeStage,
        delivery: delivery,
        isActive: isStageActive && isEnabledExpand,
        isClosed: isStageClosed,
        isMenuVisible: isMenuVisible(stage.id),
        reopenStage: reopenStage,
        stage: stage,
        trackedItems: trackedItems
      });
    }
  }, {
    key: "renderTransitionHeader",
    value: function renderTransitionHeader(stage, isEditable) {
      var _this13 = this;

      var _this$props13 = this.props,
          activeTransition = _this$props13.activeTransition,
          conditionChanges = _this$props13.conditionChanges,
          dateFormat = _this$props13.dateFormat,
          markTransitionAutomated = _this$props13.markTransitionAutomated,
          resetConditions = _this$props13.resetConditions,
          saveConditions = _this$props13.saveConditions,
          updateCondition = _this$props13.updateCondition,
          isConditionEditMode = _this$props13.isConditionEditMode,
          showConditionEditMode = _this$props13.showConditionEditMode,
          timeFormat = _this$props13.timeFormat,
          activeTransitionTab = _this$props13.activeTransitionTab;
      var isTransitionActive = this.isTransitionActive(stage.transition);
      var allowedItemForSelectCount = stage.items.filter(function (item) {
        return item.transitionItem && !item.transitionItem.disabled;
      }).length;
      var isSelectedAll = stage.transition && stage.transition.selectedTransitionItemCount === allowedItemForSelectCount;
      var activeTransitionStatus = activeTransition.status;
      var isStageClosed = this.isStageClosed(stage);
      var typeName = upperFirst_default()(toLower_default()(startCase_default()(stage.transition.type.split('.')[1])));
      var isManual = this.isManualTransition(stage.transition);
      return /*#__PURE__*/external_React_default.a.createElement(transition_header_component_TransitionHeaderComponent, {
        conditionChanges: conditionChanges,
        containerHeight: this.getTransitionActionBlockHeight(),
        dateTimeFormat: "".concat(dateFormat, "-").concat(timeFormat),
        handleCompletePrevStageChange: function handleCompletePrevStageChange(isSelected) {
          return _this13.onCompletePrevStageChange(stage, isSelected);
        },
        handleTransitionClick: function handleTransitionClick() {
          return _this13.handleTransition(stage);
        },
        isClosed: isStageClosed,
        isCompleted: this.isStageCompleted(stage),
        isConditionEditMode: isConditionEditMode,
        isEditable: isEditable,
        isExpanded: isTransitionActive,
        isManual: isManual,
        isSelectable: stage.selectableItemsCount > 0,
        isSelectedAll: isSelectedAll,
        key: stage.transition.id,
        markTransitionAutomated: markTransitionAutomated,
        name: stage.transition.title,
        onTabChange: this.onTransitionTabChange,
        onTransitionColumnSelectChange: function onTransitionColumnSelectChange(isSelected) {
          return _this13.onTransitionColumnSelectChange(stage.id, isSelected);
        },
        resetConditions: resetConditions,
        saveConditions: saveConditions,
        selectedTab: activeTransitionTab,
        showConditionEditMode: showConditionEditMode,
        toggleColumn: function toggleColumn() {
          return _this13.toggleTransition(stage.transition);
        },
        tooltipTitle: "".concat(stage.transition.title, " (").concat(typeName, ")"),
        transition: activeTransitionStatus,
        updateCondition: updateCondition
      });
    }
  }, {
    key: "renderStageAndTransitionHeaders",
    value: function renderStageAndTransitionHeaders(stages, isEditable, isEnabledExpand) {
      var _this14 = this;

      return stages.map(function (stage, i) {
        return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, {
          key: "header-fragment-".concat(i)
        }, _this14.renderStageHeader(stage, stages, isEnabledExpand), stage.transition && _this14.renderTransitionHeader(stage, isEditable));
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props14 = this.props,
          stages = _this$props14.stages,
          status = _this$props14.status,
          trackedItems = _this$props14.trackedItems;
      var _this$props$delivery = this.props.delivery,
          isEditable = _this$props$delivery.isEditable,
          isTrackedItemEditable = _this$props$delivery.isTrackedItemEditable;
      var _this$state = this.state,
          editModalIsOpen = _this$state.editModalIsOpen,
          editModalTitle = _this$state.editModalTitle,
          trackedItem = _this$state.trackedItem,
          trackedItemFilterText = _this$state.trackedItemFilterText;
      var filteredTrackedItems = trackedItems.filter(function (ti) {
        return includes_default()(ti.title.toLowerCase(), trackedItemFilterText.toLowerCase());
      });
      var isEnabledExpand = filteredTrackedItems.length > 0;
      var resizableColumnStyle = this.state.leftDivWidth ? {
        width: this.state.leftDivWidth
      } : null;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, this.renderDeleteModal(), this.renderTrackedItemEditModal(editModalIsOpen, editModalTitle, trackedItem, trackedItems), this.renderDescopeModal(), this.renderRescopeModal(), this.renderSkipModal(), this.renderCompleteModal(), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "fixed-container"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "content-container",
        ref: this.contentContainerRef
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        id: "fixed-content"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "left-content delivery-header-text",
        style: resizableColumnStyle
      }, "Tracked items", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button",
        disabled: !isTrackedItemEditable || status === delivery_flow_constants_deliveryStatus.completed,
        onClick: this.onCreate,
        type: "button"
      }, "Add item")), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "right-content delivery-header-text"
      }, /*#__PURE__*/external_React_default.a.createElement("span", null, "Stages"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "timeline-container"
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_timeline_component_DeliveryTimelineComponent, {
        endDate: moment_js_exposed_default()(this.props.delivery.endDate),
        startDate: moment_js_exposed_default()(this.props.delivery.startDate)
      })))), /*#__PURE__*/external_React_default.a.createElement("div", {
        id: "scrollable-content",
        ref: this.scrollableContentRef
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()({
          'fill-screen': this.isColumnShort(filteredTrackedItems.length)
        }),
        id: "content"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        id: "top-left",
        style: resizableColumnStyle
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterDeliveryFieldMetadata,
        onUpdate: this.onNameChange
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "content-row",
        id: "top-row"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "header-empty-cell",
        style: resizableColumnStyle
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "table-head",
        id: "top-right"
      }, stages && this.renderStageAndTransitionHeaders(stages, isEditable, isEnabledExpand))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: classnames_default()('content-row', {
          'empty-row': !isEnabledExpand
        }),
        id: "bottom-row",
        style: {
          minHeight: this.getTransitionActionBlockHeight()
        }
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "table-body",
        id: "left-div",
        style: resizableColumnStyle
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "left-div-drag-handle",
        onMouseDown: this.onLeftDivMouseDown
      }), /*#__PURE__*/external_React_default.a.createElement("div", null), this.renderFirstColumnRows(filteredTrackedItems)), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "table-body",
        id: "center-div"
      }, this.renderRows(filteredTrackedItems, isTrackedItemEditable, isEditable, isEnabledExpand))))))));
    }
  }]);

  return DeliveryFlowViewComponent;
}(external_React_["Component"]);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/views/delivery-flow.container.js


function delivery_flow_container_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_flow_container_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_flow_container_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_flow_container_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var mapStateToProps = function mapStateToProps(state) {
  var deliveryFlow = state.deliveryFlow;
  return {
    activeTransition: deliveryFlow.activeTransition,
    activeTransitionTab: deliveryFlow.activeTransitionTab,
    conditionChanges: deliveryFlow.conditionChanges,
    dateFormat: deliveryFlow.dateFormat,
    trackedItems: deliveryFlow.trackedItems,
    loadingReleasesInfo: deliveryFlow.loadingReleasesInfo,
    stages: deliveryFlow.stages,
    activeStageReleases: deliveryFlow.activeStageReleases,
    status: deliveryFlow.status,
    timeFormat: deliveryFlow.timeFormat,
    trackedItemApprovals: deliveryFlow.trackedItemApprovals,
    isConditionEditMode: deliveryFlow.isConditionEditMode
  };
};

var mergeProps = function mergeProps(stateProps, dispatchProps, ownProps) {
  return delivery_flow_container_objectSpread(delivery_flow_container_objectSpread(delivery_flow_container_objectSpread(delivery_flow_container_objectSpread({}, ownProps), stateProps), dispatchProps), {}, {
    updateDeliveryFlowPropsFromDetails: function updateDeliveryFlowPropsFromDetails() {
      dispatchProps.updateDeliveryFlowProps(ownProps.delivery);
      dispatchProps.updateActiveStageReleases(ownProps.activeStageReleases);
      dispatchProps.requestTrackedItemApprovals(ownProps.delivery.id);
    }
  });
};

var delivery_flow_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    activateTransition: function activateTransition(stage) {
      return dispatch(delivery_flow_actions_activateTransition(stage));
    },
    updateTransitionSelection: function updateTransitionSelection(selection) {
      return dispatch(delivery_flow_actions_updateTransitionSelection(selection));
    },
    completeStage: function completeStage(id) {
      return dispatch(delivery_flow_actions_completeStage(id));
    },
    deactivateTransition: function deactivateTransition() {
      return dispatch(delivery_flow_actions_deactivateTransition());
    },
    changeTransitionTab: function changeTransitionTab(tab) {
      return dispatch(delivery_flow_actions_changeTransitionTab(tab));
    },
    deleteTrackedItem: function deleteTrackedItem(id) {
      return dispatch(removeTrackedItem(id));
    },
    descopeTrackedItem: function descopeTrackedItem(id) {
      return dispatch(delivery_flow_actions_descopeTrackedItem(id));
    },
    rescopeTrackedItem: function rescopeTrackedItem(id) {
      return dispatch(delivery_flow_actions_rescopeTrackedItem(id));
    },
    reopenStage: function reopenStage(id) {
      return dispatch(delivery_flow_actions_reopenStage(id));
    },
    skipTrackedItem: function skipTrackedItem(stage, trackedItem) {
      return dispatch(delivery_flow_actions_skipTrackedItem(stage, trackedItem));
    },
    completeTrackedItem: function completeTrackedItem(stage, trackedItem) {
      return dispatch(delivery_flow_actions_completeTrackedItem(stage, trackedItem));
    },
    saveTrackedItem: function saveTrackedItem(item, deliveryId) {
      return dispatch(createOrUpdateTrackedItem(item, deliveryId));
    },
    updateDeliveryFlowProps: function updateDeliveryFlowProps(delivery) {
      return dispatch(updateDataState(delivery));
    },
    getStageReleaseDetails: function getStageReleaseDetails(deliveryId) {
      return dispatch(delivery_flow_actions_getStageReleaseDetails(deliveryId));
    },
    postTransitionDetails: function postTransitionDetails(deliveryId, transition, transitionItems) {
      return dispatch(delivery_flow_actions_postTransitionDetails(deliveryId, transition, transitionItems));
    },
    fetchDeliveryDetailsWithPolling: function fetchDeliveryDetailsWithPolling(deliveryId) {
      return dispatch(delivery_flow_actions_fetchDeliveryDetailsWithPolling(deliveryId));
    },
    requestTrackedItemApprovals: function requestTrackedItemApprovals(deliveryId) {
      return dispatch(delivery_flow_actions_requestTrackedItemApprovals(deliveryId));
    },
    resetConditions: function resetConditions() {
      return dispatch(delivery_flow_actions_resetConditions());
    },
    saveConditions: function saveConditions() {
      return dispatch(delivery_flow_actions_saveConditions());
    },
    stopPolling: function stopPolling() {
      return dispatch(delivery_flow_actions_stopPolling());
    },
    updateActiveStageReleases: function updateActiveStageReleases(releases) {
      return dispatch(fetchStageReleasesSuccess(releases));
    },
    updateCondition: function updateCondition(conditionId, time) {
      return dispatch(delivery_flow_actions_updateCondition(conditionId, time));
    },
    showConditionEditMode: function showConditionEditMode(value) {
      return dispatch(delivery_flow_actions_showConditionEditMode(value));
    },
    setDateTimeFormat: function setDateTimeFormat() {
      return dispatch(delivery_flow_actions_setDateTimeFormat());
    },
    markTransitionAutomated: function markTransitionAutomated() {
      return dispatch(delivery_flow_actions_markTransitionAutomated());
    }
  };
};

/* harmony default export */ var delivery_flow_container = (Object(es["connect"])(mapStateToProps, delivery_flow_container_mapDispatchToProps, mergeProps)(delivery_flow_view_component_DeliveryFlowViewComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/views/delivery-flow.page.js






function delivery_flow_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_flow_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_flow_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var delivery_flow_page_DeliveryFlowPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryFlowPage, _Component);

  var _super = delivery_flow_page_createSuper(DeliveryFlowPage);

  function DeliveryFlowPage() {
    classCallCheck_default()(this, DeliveryFlowPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryFlowPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          activeStageReleases = _this$props.activeStageReleases,
          delivery = _this$props.delivery;
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: delivery_flow_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_flow_container, {
        activeStageReleases: activeStageReleases,
        delivery: delivery
      }));
    }
  }]);

  return DeliveryFlowPage;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/delivery-flow/index.js


angular.module('xlrelease').component('xlrDeliveryFlowView', Object(react2angular["react2angular"])(delivery_flow_page_DeliveryFlowPage, ['activeStageReleases', 'delivery']));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/properties.actions.js
var properties_actions_actionTypes = {
  RELEASE_DELIVERY_FORM_INIT_REQUEST: 'RELEASE_DELIVERY/FORM_INIT_REQUEST',
  RELEASE_DELIVERY_CREATE_FORM_INIT_SUCCESS: 'RELEASE_DELIVERY/CREATE_FORM_INIT_SUCCESS',
  RELEASE_DELIVERY_UPDATE_FORM_INIT_SUCCESS: 'RELEASE_DELIVERY/UPDATE_FORM_INIT_SUCCESS',
  RELEASE_DELIVERY_FETCH_FOLDER_LIST_SUCCESS: 'RELEASE_DELIVERY/FETCH_FOLDER_LIST_SUCCESS',
  RELEASE_DELIVERY_FORM_CLEAN: 'RELEASE_DELIVERY/FORM_CLEAN',
  RELEASE_DELIVERY_PRISTINE_CHANGE: 'RELEASE_DELIVERY/PRISTINE_CHANGE',
  RELEASE_DELIVERY_VALIDATION_CHANGE: 'RELEASE_DELIVERY/VALIDATION_CHANGE',
  RELEASE_DELIVERY_MODEL_CHANGE: 'RELEASE_DELIVERY/MODEL_CHANGE',
  RELEASE_DELIVERY_CREATE_OR_UPDATE_REQUEST: 'RELEASE_DELIVERY/CREATE_OR_UPDATE',
  RELEASE_DELIVERY_CREATE_SUCCESS: 'RELEASE_DELIVERY/CREATE_SUCCESS',
  RELEASE_DELIVERY_UPDATE_SUCCESS: 'RELEASE_DELIVERY/UPDATE_SUCCESS',
  RELEASE_DELIVERY_CREATE_CANCEL_REQUEST: 'RELEASE_DELIVERY/CREATE_CANCEL_REQUEST',
  RELEASE_DELIVERY_CREATE_DISCARD_CHANGES_REQUEST: 'RELEASE_DELIVERY/CREATE_DISCARD_CHANGES',
  RELEASE_DELIVERY_GO_TO_PATTERN: 'RELEASE_DELIVERY/GO_TO_PATTERN',
  RELEASE_DELIVERY_GO_TO_FOLDER: 'RELEASE_DELIVERY/GO_TO_FOLDER'
};
var properties_actions_initDeliveryForm = function initDeliveryForm(delivery, patternId, folder) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_FORM_INIT_REQUEST,
    payload: {
      delivery: delivery,
      patternId: patternId,
      folder: folder
    }
  };
};
var initializeCreateFormSuccess = function initializeCreateFormSuccess(pattern, folder, folders) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_FORM_INIT_SUCCESS,
    payload: {
      pattern: pattern,
      folder: folder,
      folders: folders
    }
  };
};
var initializeUpdateFormSuccess = function initializeUpdateFormSuccess(delivery, pattern, folder, isEditable) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_FORM_INIT_SUCCESS,
    payload: {
      delivery: delivery,
      pattern: pattern,
      folder: folder,
      isEditable: isEditable
    }
  };
};
var cleanFormFields = function cleanFormFields() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_FORM_CLEAN
  };
};
var changePristine = function changePristine(isPristine) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE,
    payload: isPristine
  };
};
var changeValidation = function changeValidation(isValid) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_VALIDATION_CHANGE,
    payload: isValid
  };
};
var changeModel = function changeModel(model) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_MODEL_CHANGE,
    payload: model
  };
};
var createOrUpdateDelivery = function createOrUpdateDelivery() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_OR_UPDATE_REQUEST
  };
};
var deliveryCreateSuccess = function deliveryCreateSuccess(delivery) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_SUCCESS,
    payload: delivery
  };
};
var deliveryUpdateSuccess = function deliveryUpdateSuccess(delivery, pattern, folder) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_SUCCESS,
    payload: {
      delivery: delivery,
      pattern: pattern,
      folder: folder
    }
  };
};
var cancelDelivery = function cancelDelivery() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_CANCEL_REQUEST
  };
};
var properties_actions_onDiscardDeliveryChanges = function onDiscardDeliveryChanges() {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_DISCARD_CHANGES_REQUEST
  };
};
var goToDeliveryPatternDetails = function goToDeliveryPatternDetails(patternId) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_PATTERN,
    payload: patternId
  };
};
var properties_actions_goToFolder = function goToFolder(folderId) {
  return {
    type: properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_FOLDER,
    payload: folderId
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/properties.reducers.js


function properties_reducers_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function properties_reducers_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { properties_reducers_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { properties_reducers_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var properties_reducers_initialState = function initialState() {
  return {
    folderTree: {
      key: 0,
      data: []
    },
    form: {
      key: 0,
      model: {
        id: null,
        type: ciTypes.delivery,
        title: '',
        folder: {
          id: '',
          title: ''
        },
        pattern: {
          id: '',
          title: ''
        },
        description: '',
        plannedDuration: 0,
        startDate: new Date(),
        endDate: new Date(new Date().getTime() + 1)
      },
      pristine: true,
      valid: false,
      lastSave: 0,
      isCreateForm: null
    }
  };
};

var properties_reducers_delivery = function delivery() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : properties_reducers_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_FORM_INIT_SUCCESS:
      {
        var _action$payload = action.payload,
            pattern = _action$payload.pattern,
            folder = _action$payload.folder,
            folders = _action$payload.folders;
        var startDate = new Date();
        return properties_reducers_objectSpread(properties_reducers_objectSpread({}, properties_reducers_initialState()), {}, {
          folderTree: properties_reducers_objectSpread(properties_reducers_objectSpread({}, properties_reducers_initialState().folderTree), {}, {
            data: folders
          }),
          form: properties_reducers_objectSpread(properties_reducers_objectSpread({}, properties_reducers_initialState().form), {}, {
            model: properties_reducers_objectSpread(properties_reducers_objectSpread({}, properties_reducers_initialState().form.model), {}, {
              description: pattern.description,
              startDate: startDate,
              endDate: moment_js_exposed_default()(startDate).add(pattern.plannedDuration || 1, pattern.plannedDuration ? 'hour' : 'month').toDate(),
              pattern: pattern,
              folder: folder
            }),
            isCreateForm: true
          })
        });
      }

    case properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_FORM_INIT_SUCCESS:
      {
        var _action$payload2 = action.payload,
            _delivery = _action$payload2.delivery,
            _pattern = _action$payload2.pattern,
            _folder = _action$payload2.folder,
            isEditable = _action$payload2.isEditable;
        return properties_reducers_objectSpread(properties_reducers_objectSpread({}, properties_reducers_initialState()), {}, {
          form: properties_reducers_objectSpread(properties_reducers_objectSpread({}, properties_reducers_initialState().form), {}, {
            key: moment_js_exposed_default()().valueOf(),
            model: properties_reducers_objectSpread(properties_reducers_objectSpread({}, _delivery), {}, {
              pattern: _pattern,
              folder: _folder,
              startDate: new Date(_delivery.startDate),
              endDate: new Date(_delivery.endDate)
            }),
            isCreateForm: false,
            isEditable: isEditable
          })
        });
      }

    case properties_actions_actionTypes.RELEASE_DELIVERY_MODEL_CHANGE:
      return properties_reducers_objectSpread(properties_reducers_objectSpread({}, state), {}, {
        form: properties_reducers_objectSpread(properties_reducers_objectSpread({}, state.form), {}, {
          model: action.payload
        })
      });

    case properties_actions_actionTypes.RELEASE_DELIVERY_FORM_CLEAN:
      {
        return properties_reducers_objectSpread({}, properties_reducers_initialState());
      }

    case properties_actions_actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE:
      return properties_reducers_objectSpread(properties_reducers_objectSpread({}, state), {}, {
        form: properties_reducers_objectSpread(properties_reducers_objectSpread({}, state.form), {}, {
          pristine: action.payload
        })
      });

    case properties_actions_actionTypes.RELEASE_DELIVERY_VALIDATION_CHANGE:
      return properties_reducers_objectSpread(properties_reducers_objectSpread({}, state), {}, {
        form: properties_reducers_objectSpread(properties_reducers_objectSpread({}, state.form), {}, {
          valid: action.payload
        })
      });

    case properties_actions_actionTypes.RELEASE_DELIVERY_UPDATE_SUCCESS:
      {
        var _action$payload3 = action.payload,
            _delivery2 = _action$payload3.delivery,
            _pattern2 = _action$payload3.pattern,
            _folder2 = _action$payload3.folder;
        return properties_reducers_objectSpread(properties_reducers_objectSpread({}, state), {}, {
          form: properties_reducers_objectSpread(properties_reducers_objectSpread({}, state.form), {}, {
            model: properties_reducers_objectSpread(properties_reducers_objectSpread({}, _delivery2), {}, {
              pattern: _pattern2,
              folder: _folder2,
              startDate: new Date(_delivery2.startDate),
              endDate: new Date(_delivery2.endDate)
            }),
            lastSave: new Date(),
            // Important for resetting pristinity on form
            key: moment_js_exposed_default()().valueOf()
          })
        });
      }

    default:
      return state;
  }
};
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/toArray.js
var toArray = __webpack_require__(1293);
var toArray_default = /*#__PURE__*/__webpack_require__.n(toArray);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/properties.sagas.js




var properties_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(updateBreadcrumbs),
    properties_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(initializeForm),
    properties_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(save),
    properties_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(cancel),
    properties_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(discardChanges),
    properties_sagas_marked6 = /*#__PURE__*/regenerator_default.a.mark(goToDetails),
    properties_sagas_marked7 = /*#__PURE__*/regenerator_default.a.mark(properties_sagas_goToDeliveryPatternDetails),
    properties_sagas_marked8 = /*#__PURE__*/regenerator_default.a.mark(goToDeliveryFolder),
    properties_sagas_marked9 = /*#__PURE__*/regenerator_default.a.mark(addConfirmLeavePopup),
    properties_sagas_marked10 = /*#__PURE__*/regenerator_default.a.mark(removeConfirmLeavePopup),
    properties_sagas_marked11 = /*#__PURE__*/regenerator_default.a.mark(deliverySagas);








var getFormModel = function getFormModel(state) {
  return state.delivery.form.model;
};

var properties_sagas_isEditable = function isEditable(delivery) {
  return Object(angular_accessor["b" /* default */])('Authenticator').hasPermission(DELIVERY_EDIT_PERMISSION, delivery.$metadata) && delivery.status !== 'COMPLETED';
};

function updateBreadcrumbs(checkUrl, delivery) {
  var page;
  return regenerator_default.a.wrap(function updateBreadcrumbs$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'Page');

        case 2:
          page = _context.sent;

          if (page.isOnPage(checkUrl)) {
            page.setFolderEntityOpened(delivery.folderId, delivery);
          }

        case 4:
        case "end":
          return _context.stop();
      }
    }
  }, properties_sagas_marked);
}

var properties_sagas_makeFolderEnabledFunc = function makeFolderEnabledFunc(fn, _ref) {
  var _ref2 = toArray_default()(_ref),
      folder = _ref2[0],
      restOfTheFolder = _ref2.slice(1);

  if (!!folder) {
    return [fn(folder)].concat(toConsumableArray_default()(makeFolderEnabledFunc(fn, restOfTheFolder)));
  }

  return [];
};

function makeFolderEnabled(folder) {
  if (properties_sagas_isEditable(folder)) {
    folder.enabled = true;

    if (!!folder.children && folder.children.length > 0) {
      properties_sagas_makeFolderEnabledFunc(makeFolderEnabled, folder.children);
    }
  }
}

function initializeForm(action) {
  var _action$payload, delivery, patternId, folder, folders, pattern, _pattern, patternFolder;

  return regenerator_default.a.wrap(function initializeForm$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _action$payload = action.payload, delivery = _action$payload.delivery, patternId = _action$payload.patternId;
          folder = action.payload.folder;
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(fetchAllFolders);

        case 4:
          folders = _context2.sent;
          properties_sagas_makeFolderEnabledFunc(makeFolderEnabled, folders);

          if (!(delivery && delivery.id)) {
            _context2.next = 14;
            break;
          }

          pattern = {
            id: null,
            title: null,
            hasViewAccess: false
          };

          if (delivery.originPatternId && delivery.$metadata.details && delivery.$metadata.details.pattern) {
            pattern.id = delivery.originPatternId;
            pattern.title = delivery.$metadata.details.pattern;
            pattern.hasViewAccess = delivery.$metadata.details.hasPatternViewAccess;
          }

          if (delivery.folderId && delivery.$metadata.details && delivery.$metadata.details.folder) {
            if (!folder) {
              folder = {
                id: null,
                title: null,
                hasViewAccess: false
              };
            }

            folder.id = folder.id || delivery.folderId;
            folder.title = folder.title || delivery.$metadata.details.folder;
            folder.hasViewAccess = delivery.$metadata.details.hasFolderViewAccess;
          }

          _context2.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initializeUpdateFormSuccess(delivery, pattern, folder, properties_sagas_isEditable(delivery)));

        case 12:
          _context2.next = 21;
          break;

        case 14:
          if (!patternId) {
            _context2.next = 21;
            break;
          }

          _context2.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_fetchDeliveryPattern, patternId);

        case 17:
          _pattern = _context2.sent;
          patternFolder = {
            id: _pattern.folderId,
            title: _pattern.$metadata.details.folder,
            hasViewAccess: _pattern.$metadata.details.hasFolderViewAccess
          };
          _context2.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initializeCreateFormSuccess(_pattern, patternFolder, folders));

        case 21:
        case "end":
          return _context2.stop();
      }
    }
  }, properties_sagas_marked2);
}

function save() {
  var deliveryModel, deliveryForm, $location, urlBeforeUpdate, updatedDeliveryResponse, createdDeliveryResponse;
  return regenerator_default.a.wrap(function save$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _context3.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getFormModel);

        case 3:
          deliveryModel = _context3.sent;

          if (!deliveryModel.folder.id) {
            deliveryModel.folder.id = deliveryModel.pattern.folderId;
          }

          deliveryForm = {
            id: deliveryModel.id,
            type: deliveryModel.type,
            title: deliveryModel.title,
            folderId: deliveryModel.folder.id,
            description: deliveryModel.description,
            startDate: deliveryModel.startDate.toISOString(),
            endDate: deliveryModel.endDate.toISOString(),
            plannedDuration: deliveryModel.plannedDuration,
            releaseIds: deliveryModel.releaseIds
          };

          if (!deliveryForm.id) {
            _context3.next = 20;
            break;
          }

          _context3.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$location');

        case 9:
          $location = _context3.sent;
          urlBeforeUpdate = $location.path();
          _context3.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["g" /* updateDelivery */], deliveryForm);

        case 13:
          updatedDeliveryResponse = _context3.sent;
          _context3.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateBreadcrumbs, urlBeforeUpdate, updatedDeliveryResponse.data);

        case 16:
          _context3.next = 18;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryUpdateSuccess(updatedDeliveryResponse.data, deliveryModel.pattern, deliveryModel.folder));

        case 18:
          _context3.next = 25;
          break;

        case 20:
          _context3.next = 22;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["a" /* createDeliveryFromPattern */], deliveryModel.pattern.id, deliveryForm);

        case 22:
          createdDeliveryResponse = _context3.sent;
          _context3.next = 25;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryCreateSuccess(createdDeliveryResponse.data));

        case 25:
          _context3.next = 30;
          break;

        case 27:
          _context3.prev = 27;
          _context3.t0 = _context3["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Something went wrong while creating or updating release delivery...', _context3.t0);
          /* eslint-enable */

        case 30:
        case "end":
          return _context3.stop();
      }
    }
  }, properties_sagas_marked3, null, [[0, 27]]);
}

function cancel() {
  var $window;
  return regenerator_default.a.wrap(function cancel$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          // yield call(removeConfirmLeavePopup);
          $window = Object(angular_accessor["b" /* default */])('$window');
          $window.history.back();
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields());

        case 4:
        case "end":
          return _context4.stop();
      }
    }
  }, properties_sagas_marked4);
}

function discardChanges(action) {
  var deliveryModel, deliveryResponse;
  return regenerator_default.a.wrap(function discardChanges$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(changePristine(true));

        case 2:
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getFormModel);

        case 4:
          deliveryModel = _context5.sent;
          _context5.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(services["d" /* getDelivery */], deliveryModel.id);

        case 7:
          deliveryResponse = _context5.sent;
          _context5.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initializeUpdateFormSuccess(deliveryResponse.data, deliveryModel.pattern, deliveryModel.folder, properties_sagas_isEditable(deliveryResponse.data)));

        case 10:
        case "end":
          return _context5.stop();
      }
    }
  }, properties_sagas_marked5);
}

function goToDetails(action) {
  var $location, $rootScope;
  return regenerator_default.a.wrap(function goToDetails$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          $location = Object(angular_accessor["b" /* default */])('$location');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          $location.url("/deliveries/".concat(action.payload.id));
          $rootScope.$digest();

        case 4:
        case "end":
          return _context6.stop();
      }
    }
  }, properties_sagas_marked6);
}

function properties_sagas_goToDeliveryPatternDetails(action) {
  var $location, $rootScope;
  return regenerator_default.a.wrap(function goToDeliveryPatternDetails$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          $location = Object(angular_accessor["b" /* default */])('$location');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          $location.url("/delivery-patterns/".concat(action.payload));
          $rootScope.$digest();

        case 4:
        case "end":
          return _context7.stop();
      }
    }
  }, properties_sagas_marked7);
}
function goToDeliveryFolder(action) {
  var $location, $rootScope;
  return regenerator_default.a.wrap(function goToDeliveryFolder$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          $location = Object(angular_accessor["b" /* default */])('$location');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          $location.url("/folders/".concat(action.payload, "/deliveries"));
          $rootScope.$digest();

        case 4:
        case "end":
          return _context8.stop();
      }
    }
  }, properties_sagas_marked8);
} // TODO: don't use temporary

function addConfirmLeavePopup() {
  var confirmLeaveService;
  return regenerator_default.a.wrap(function addConfirmLeavePopup$(_context9) {
    while (1) {
      switch (_context9.prev = _context9.next) {
        case 0:
          _context9.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'ConfirmLeaveService');

        case 2:
          confirmLeaveService = _context9.sent;
          _context9.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(confirmLeaveService.requireConfirmation.bind(confirmLeaveService));

        case 5:
        case "end":
          return _context9.stop();
      }
    }
  }, properties_sagas_marked9);
} // TODO: don't use temporary

function removeConfirmLeavePopup() {
  var confirmLeaveService;
  return regenerator_default.a.wrap(function removeConfirmLeavePopup$(_context10) {
    while (1) {
      switch (_context10.prev = _context10.next) {
        case 0:
          _context10.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'ConfirmLeaveService');

        case 2:
          confirmLeaveService = _context10.sent;
          _context10.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(confirmLeaveService.disableConfirmation.bind(confirmLeaveService));

        case 5:
        case "end":
          return _context10.stop();
      }
    }
  }, properties_sagas_marked10);
}
function deliverySagas() {
  return regenerator_default.a.wrap(function deliverySagas$(_context11) {
    while (1) {
      switch (_context11.prev = _context11.next) {
        case 0:
          _context11.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_FORM_INIT_REQUEST, initializeForm), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_OR_UPDATE_REQUEST, save), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_CANCEL_REQUEST, cancel), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_DISCARD_CHANGES_REQUEST, discardChanges), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_CREATE_SUCCESS, goToDetails), // takeEvery(actionTypes.RELEASE_DELIVERY_PRISTINE_CHANGE, addConfirmLeavePopup),
          Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_PATTERN, properties_sagas_goToDeliveryPatternDetails), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(properties_actions_actionTypes.RELEASE_DELIVERY_GO_TO_FOLDER, goToDeliveryFolder)]);

        case 2:
        case "end":
          return _context11.stop();
      }
    }
  }, properties_sagas_marked11);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/ducks/index.js


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/properties.store.js



var properties_store_marked = /*#__PURE__*/regenerator_default.a.mark(properties_store_combinedSaga);

/* global window */




var properties_store_sagaMiddleware = Object(redux_saga_core_npm_proxy_esm["a" /* default */])();
/* eslint-disable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */

var properties_store_composeEnhancers = (typeof window === "undefined" ? "undefined" : typeof_default()(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
  name: 'delivery-properties' // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...

}) : redux["compose"];

function properties_store_combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deliverySagas)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);
          console.error('Release delivery properties saga:', _context.t0);

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, properties_store_marked, null, [[1, 6]]);
}

function properties_store_configureStore(preloadedState) {
  var enhancer = properties_store_composeEnhancers(Object(redux["applyMiddleware"])(properties_store_sagaMiddleware));
  var store = Object(redux["createStore"])(Object(redux["combineReducers"])({
    delivery: properties_reducers_delivery
  }), preloadedState, enhancer);
  properties_store_sagaMiddleware.run(properties_store_combinedSaga);
  return store;
}

var properties_store_store = properties_store_configureStore();
/* eslint-enable no-underscore-dangle, angular/typecheck-object, angular/module-getter, no-console, angular/log, lodash/prefer-lodash-typecheck */
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/components/delivery-properties-header.component.js








function delivery_properties_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }




var delivery_properties_header_component_DeliveryPropertiesHeader = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesHeader, _Component);

  var _super = delivery_properties_header_component_createSuper(DeliveryPropertiesHeader);

  function DeliveryPropertiesHeader() {
    var _this;

    classCallCheck_default()(this, DeliveryPropertiesHeader);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "handleSave", function () {
      var onSaveDelivery = _this.props.onSaveDelivery;
      onSaveDelivery();
    });

    return _this;
  }

  createClass_default()(DeliveryPropertiesHeader, [{
    key: "renderCreateFormButtons",
    value: function renderCreateFormButtons() {
      var _this$props = this.props,
          onCancelDelivery = _this$props.onCancelDelivery,
          saveDisabled = _this$props.saveDisabled;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button cancel",
        onClick: onCancelDelivery
      }, "Cancel"), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary",
        disabled: saveDisabled,
        onClick: this.handleSave
      }, "Create"));
    }
  }, {
    key: "renderEditFormButtons",
    value: function renderEditFormButtons() {
      var _this$props2 = this.props,
          discardChangesDisabled = _this$props2.discardChangesDisabled,
          onDiscardDeliveryChanges = _this$props2.onDiscardDeliveryChanges,
          saveDisabled = _this$props2.saveDisabled,
          lastSave = _this$props2.lastSave;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, lastSave !== 0 && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "last-save-date"
      }, "Last saved on ", moment(lastSave).format('lll')), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button cancel",
        disabled: discardChangesDisabled,
        onClick: onDiscardDeliveryChanges
      }, "Discard changes"), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary",
        disabled: saveDisabled,
        onClick: this.handleSave
      }, "Save"));
    }
  }, {
    key: "render",
    value: function render() {
      var isCreateForm = this.props.isCreateForm;
      return /*#__PURE__*/external_React_default.a.createElement("div", null, isCreateForm && this.renderCreateFormButtons(), isCreateForm === false && this.renderEditFormButtons());
    }
  }]);

  return DeliveryPropertiesHeader;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties-header.container.js




var delivery_properties_header_container_mapStateToProps = function mapStateToProps(state) {
  var delivery = state.delivery;
  return {
    discardChangesDisabled: delivery.form.pristine,
    isCreateForm: delivery.form.isCreateForm,
    lastSave: delivery.form.lastSave,
    saveDisabled: delivery.form.pristine || !delivery.form.valid
  };
};

var delivery_properties_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCancelDelivery: function onCancelDelivery() {
      return dispatch(cancelDelivery());
    },
    onDiscardDeliveryChanges: function onDiscardDeliveryChanges() {
      return dispatch(properties_actions_onDiscardDeliveryChanges());
    },
    onSaveDelivery: function onSaveDelivery() {
      return dispatch(createOrUpdateDelivery());
    }
  };
};

/* harmony default export */ var delivery_properties_header_container = (Object(es["connect"])(delivery_properties_header_container_mapStateToProps, delivery_properties_header_container_mapDispatchToProps)(delivery_properties_header_component_DeliveryPropertiesHeader));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties-header.page.js






function delivery_properties_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var delivery_properties_header_page_DeliveryPropertiesHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesHeaderPage, _Component);

  var _super = delivery_properties_header_page_createSuper(DeliveryPropertiesHeaderPage);

  function DeliveryPropertiesHeaderPage() {
    classCallCheck_default()(this, DeliveryPropertiesHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPropertiesHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: properties_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_properties_header_container, null));
    }
  }]);

  return DeliveryPropertiesHeaderPage;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./node_modules/lodash/isEmpty.js
var isEmpty = __webpack_require__(29);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/tracked-item.types.js

var tracked_item_types_TrackedItem = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/delivery-properties.types.js



var StageStatus = prop_types_default.a.oneOf(Object.values(stageStatus));
var delivery_properties_types_Stage = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.oneOf([ciTypes.stage]),
  title: prop_types_default.a.string,
  status: StageStatus
});
var DeliveryStatus = prop_types_default.a.oneOf(Object.values(deliveryStatus));
var LinkObject = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
var Folder = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  title: prop_types_default.a.string
});
var FolderTree = prop_types_default.a.array;
var Delivery = prop_types_default.a.shape({
  id: prop_types_default.a.string,
  type: prop_types_default.a.oneOf([ciTypes.delivery]),
  title: prop_types_default.a.string,
  status: DeliveryStatus,
  startDate: prop_types_default.a.any,
  //PropTypes.instanceOf(Date), // PropTypes.instanceOf(Moment)// TODO: check props type 2019-05-10T13:00:38+02:00
  endDate: prop_types_default.a.any,
  plannedDuration: prop_types_default.a.number,
  releaseIds: prop_types_default.a.arrayOf(prop_types_default.a.string),
  progress: prop_types_default.a.number,
  folder: LinkObject,
  pattern: LinkObject,
  stages: prop_types_default.a.arrayOf(delivery_properties_types_Stage),
  trackedItems: prop_types_default.a.arrayOf(tracked_item_types_TrackedItem),
  $metadata: prop_types_default.a.object
});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/components/delivery-properties.less
var delivery_properties = __webpack_require__(884);
var delivery_properties_default = /*#__PURE__*/__webpack_require__.n(delivery_properties);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/components/delivery-properties.less

            

var delivery_properties_options = {};

delivery_properties_options.insert = "head";
delivery_properties_options.singleton = false;

var delivery_properties_update = injectStylesIntoStyleTag_default()(delivery_properties_default.a, delivery_properties_options);



/* harmony default export */ var components_delivery_properties = (delivery_properties_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/components/delivery-properties.component.js








function delivery_properties_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_properties_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_properties_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_properties_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_properties_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }









var nameFormMetadata = {
  label: 'Delivery name',
  placeholder: 'Add...',
  description: 'Name of the delivery',
  required: true
};
var patternFormMetadata = {
  label: 'Created from pattern'
};
var folderFormMetadata = {
  label: 'Folder'
};
var descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the delivery',
  size: 'MEDIUM'
};
var startDateFormMetadata = {
  label: 'Start date',
  placeholder: '',
  description: 'Date and time when you want the delivery to start'
};
var endDateFormMetadata = {
  label: 'End date',
  placeholder: '',
  description: 'Date and time when you want the delivery to end'
};

var delivery_properties_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var delivery_properties_component_DeliveryPropertiesComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesComponent, _Component);

  var _super = delivery_properties_component_createSuper(DeliveryPropertiesComponent);

  function DeliveryPropertiesComponent() {
    var _this;

    classCallCheck_default()(this, DeliveryPropertiesComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "isDescriptionPristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isNamePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isStartDatePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isStartTimePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isEndDatePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isEndTimePristine", true);

    defineProperty_default()(assertThisInitialized_default()(_this), "isNameValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "isDescriptionValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "isStartDateTimeValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "isEndDateTimeValid", false);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      var valid = _this.props.valid;

      if (e.key === 'Enter' && valid) {
        _this.props.onSaveDelivery();
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNamePristine", function (pristine) {
      _this.isNamePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescPristine", function (pristine) {
      _this.isDescriptionPristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDatePristineChange", function (pristine) {
      _this.isStartDatePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartTimePristineChange", function (pristine) {
      _this.isStartTimePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndDatePristineChange", function (pristine) {
      _this.isEndDatePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndTimePristineChange", function (pristine) {
      _this.isEndTimePristine = pristine;

      _this.props.onPristineChange(_this.isDeliveryFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (valid) {
      _this.isNameValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescriptionValidityChange", function (valid) {
      _this.isDescriptionValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDateTimeValidityChange", function (valid) {
      _this.isStartDateTimeValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndDateTimeValidityChange", function (valid) {
      _this.isEndDateTimeValid = valid;

      _this.props.onValidationChange(_this.isDeliveryFormValid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (title) {
      var _this$props = _this.props,
          model = _this$props.model,
          onFormChange = _this$props.onFormChange;

      if (title !== model.title) {
        onFormChange(delivery_properties_component_objectSpread(delivery_properties_component_objectSpread({}, model), {}, {
          title: title
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescriptionChange", function (description) {
      var _this$props2 = _this.props,
          model = _this$props2.model,
          onFormChange = _this$props2.onFormChange;

      if (description !== model.description) {
        onFormChange(delivery_properties_component_objectSpread(delivery_properties_component_objectSpread({}, model), {}, {
          description: description
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onStartDatetimeChange", function (startDate) {
      var _this$props3 = _this.props,
          model = _this$props3.model,
          onFormChange = _this$props3.onFormChange;

      if (startDate !== model.startDate) {
        onFormChange(delivery_properties_component_objectSpread(delivery_properties_component_objectSpread({}, model), {}, {
          startDate: startDate
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onEndDatetimeChange", function (endDate) {
      var _this$props4 = _this.props,
          model = _this$props4.model,
          onFormChange = _this$props4.onFormChange;

      if (endDate !== model.endDate) {
        onFormChange(delivery_properties_component_objectSpread(delivery_properties_component_objectSpread({}, model), {}, {
          endDate: endDate
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "goToDeliveryPattern", function () {
      var _this$props5 = _this.props,
          model = _this$props5.model,
          goToDeliveryPattern = _this$props5.goToDeliveryPattern;
      goToDeliveryPattern(model.pattern.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "goToFolder", function () {
      var _this$props6 = _this.props,
          model = _this$props6.model,
          goToFolder = _this$props6.goToFolder;
      goToFolder(model.folder.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderPattern", function (isNew, pattern) {
      return isNew || pattern.hasViewAccess ? /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components-input"
      }, /*#__PURE__*/external_React_default.a.createElement("a", {
        title: pattern.title,
        className: "details-link",
        onClick: _this.goToDeliveryPattern
      }, pattern.title)) : /*#__PURE__*/external_React_default.a.createElement("span", null, pattern.title);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "updateSelectedFolder", function (folder) {
      var _this$props7 = _this.props,
          model = _this$props7.model,
          onFormChange = _this$props7.onFormChange;

      if (folder.selectedId !== model.folder.id) {
        onFormChange(delivery_properties_component_objectSpread(delivery_properties_component_objectSpread({}, model), {}, {
          folder: {
            id: folder.selectedId,
            title: folder.title
          }
        }));
      }
    });

    return _this;
  }

  createClass_default()(DeliveryPropertiesComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props8 = this.props,
          delivery = _this$props8.delivery,
          folder = _this$props8.folder,
          initDeliveryForm = _this$props8.initDeliveryForm,
          patternId = _this$props8.patternId;
      initDeliveryForm(delivery, patternId, folder);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var cleanForm = this.props.cleanForm;
      cleanForm();
    }
  }, {
    key: "isDeliveryFormPristine",
    get: function get() {
      return this.isDescriptionPristine && this.isNamePristine && this.isStartDatePristine && this.isStartTimePristine && this.isEndDatePristine && this.isEndTimePristine;
    }
  }, {
    key: "isDeliveryFormValid",
    get: function get() {
      return this.isNameValid && this.isDescriptionValid && this.isStartDateTimeValid && this.isEndDateTimeValid;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props9 = this.props,
          model = _this$props9.model,
          propertiesFormKey = _this$props9.propertiesFormKey,
          delivery = _this$props9.delivery,
          folderTree = _this$props9.folderTree;
      var isFromCreateDelivery = !!folderTree && folderTree.length > 0;
      var reactWidgetTreeSelect = isFromCreateDelivery ? /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-widget-tree-select"
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetTreeSelect"], {
        data: folderTree,
        selectedFolderId: model.folder.id,
        onModelChange: this.updateSelectedFolder
      })) : model.folder.hasViewAccess ? /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components-input"
      }, /*#__PURE__*/external_React_default.a.createElement("a", {
        className: "details-link",
        "data-test-id": "folderId",
        onClick: this.goToFolder,
        title: model.folder.title
      }, model.folder.title)) : /*#__PURE__*/external_React_default.a.createElement("span", {
        "data-test-id": "folderId"
      }, model.folder.title); // eslint-disable-next-line angular/definedundefined

      var isEditable = this.props.isEditable !== undefined ? this.props.isEditable : true;
      /* eslint-enable angular/definedundefined */

      var isNew = isEmpty_default()(model.id);
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "row",
        id: "delivery-properties",
        key: propertiesFormKey
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-sm-7"
      }, /*#__PURE__*/external_React_default.a.createElement("fieldset", null, /*#__PURE__*/external_React_default.a.createElement("legend", null, "Properties ", !isNew && /*#__PURE__*/external_React_default.a.createElement("span", {
        title: delivery.title
      }, "for ", delivery.title)), /*#__PURE__*/external_React_default.a.createElement("div", {
        onKeyDown: this._handleKeyDown
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: nameFormMetadata,
        model: model.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [delivery_properties_component_maxLengthValidator(nameFormMetadata.label, 255), Object(validators["c" /* reservedCharactersValidator */])(nameFormMetadata.label)]
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: patternFormMetadata
      }), model.pattern && model.pattern.id ? this.renderPattern(isNew, model.pattern) : /*#__PURE__*/external_React_default.a.createElement("span", null, "[Pattern has been deleted]")), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components"
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetLabel"], {
        metadata: folderFormMetadata
      }), reactWidgetTreeSelect), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: descriptionFormMetadata,
        model: model.description,
        onModelChange: this.onDescriptionChange,
        onPristinityChange: this.onDescPristine,
        onValidityChange: this.onDescriptionValidityChange,
        validators: [delivery_properties_component_maxLengthValidator(descriptionFormMetadata.label, 1024)]
      }))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-sm-5"
      }, /*#__PURE__*/external_React_default.a.createElement("fieldset", null, /*#__PURE__*/external_React_default.a.createElement("legend", null, "Delivery details"), /*#__PURE__*/external_React_default.a.createElement(widgets["a" /* WidgetDateTime */], {
        disabled: !isEditable,
        metadata: startDateFormMetadata,
        model: model.startDate,
        onDatePristinityChange: this.onStartDatePristineChange,
        onModelChange: this.onStartDatetimeChange,
        onTimePristinityChange: this.onStartTimePristineChange,
        onValidityChange: this.onStartDateTimeValidityChange
      }), /*#__PURE__*/external_React_default.a.createElement(widgets["a" /* WidgetDateTime */], {
        disabled: !isEditable,
        metadata: endDateFormMetadata,
        model: model.endDate,
        onDatePristinityChange: this.onEndDatePristineChange,
        onModelChange: this.onEndDatetimeChange,
        onTimePristinityChange: this.onEndTimePristineChange,
        onValidityChange: this.onEndDateTimeValidityChange
      }))));
    }
  }]);

  return DeliveryPropertiesComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties.container.js




var delivery_properties_container_mapStateToProps = function mapStateToProps(state) {
  var delivery = state.delivery;
  return {
    isEditable: delivery.form.isEditable,
    model: delivery.form.model,
    propertiesFormKey: delivery.form.key,
    valid: delivery.form.valid,
    folderTree: delivery.folderTree.data
  };
};

var delivery_properties_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    initDeliveryForm: function initDeliveryForm(delivery, patternId, folder) {
      return dispatch(properties_actions_initDeliveryForm(delivery, patternId, folder));
    },
    cleanForm: function cleanForm() {
      return dispatch(cleanFormFields());
    },
    goToFolder: function goToFolder(folderId) {
      return dispatch(properties_actions_goToFolder(folderId));
    },
    goToDeliveryPattern: function goToDeliveryPattern(patternId) {
      return dispatch(goToDeliveryPatternDetails(patternId));
    },
    onFormChange: function onFormChange(model) {
      return dispatch(changeModel(model));
    },
    onPristineChange: function onPristineChange(pristine) {
      return dispatch(changePristine(pristine));
    },
    onValidationChange: function onValidationChange(valid) {
      return dispatch(changeValidation(valid));
    },
    onSaveDelivery: function onSaveDelivery() {
      return dispatch(createOrUpdateDelivery());
    }
  };
};

/* harmony default export */ var delivery_properties_container = (Object(es["connect"])(delivery_properties_container_mapStateToProps, delivery_properties_container_mapDispatchToProps)(delivery_properties_component_DeliveryPropertiesComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/view/delivery-properties.page.js






function delivery_properties_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_properties_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_properties_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var delivery_properties_page_DeliveryPropertiesPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPropertiesPage, _Component);

  var _super = delivery_properties_page_createSuper(DeliveryPropertiesPage);

  function DeliveryPropertiesPage() {
    classCallCheck_default()(this, DeliveryPropertiesPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPropertiesPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          delivery = _this$props.delivery,
          folder = _this$props.folder,
          patternId = _this$props.patternId;
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: properties_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_properties_container, {
        delivery: delivery,
        folder: folder,
        patternId: patternId
      }));
    }
  }]);

  return DeliveryPropertiesPage;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/properties/index.js



angular.module('xlrelease').component('xlrDeliveryPropertiesHeader', Object(react2angular["react2angular"])(delivery_properties_header_page_DeliveryPropertiesHeaderPage)).component('xlrDeliveryProperties', Object(react2angular["react2angular"])(delivery_properties_page_DeliveryPropertiesPage, ['delivery', 'folder', 'patternId']));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-row-name.html
/* harmony default export */ var timeline_row_name = ("<div class=\"timeline-row-name\" ng-init=\"model = getValue()\">\n    <span class=\"timeline-row-name-release\" ng-if=\"!model.isDelivery\">\n        <a class=\"release-title\" ng-href=\"{{model.releaseEditorURL}}\" title=\"{{::model.title}}\">{{::model.title}}</a>\n    </span>\n    <span class=\"timeline-row-name-delivery\" ng-if=\"model.isDelivery\">\n        <i class=\"xl-icon group-icon\"></i>\n        <span class=\"delivery-title\" title=\"{{::model.title}}\">{{::model.title}}</span>\n    </span>\n</div>\n");
// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/actions/deliveries-timeline-actions.js
var deliveries_timeline_actions = __webpack_require__(86);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-controller.js




function timeline_controller_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function timeline_controller_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { timeline_controller_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { timeline_controller_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }





var phaseContentTemplate = "\n    <div xlr-delivery-timeline-tooltip\n         class=\"fgt-timeline-task-content\">\n         {{::task.model.name}}\n     </div>\n";
var deliveryContentTemplate = "\n    <div xlr-delivery-timeline-tooltip>\n         {{::task.model.name}}\n     </div>\n";

var timeline_controller_TimelineController = /*#__PURE__*/function () {
  function TimelineController($ngRedux, $scope, ViewStorage, Ids, DateService, Authenticator) {
    classCallCheck_default()(this, TimelineController);

    this._scope = $scope;
    this._viewStorage = ViewStorage;
    this._Ids = Ids;
    this._DateService = DateService;
    this._Authenticator = Authenticator;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(TimelineController, [{
    key: "$onInit",
    value: function $onInit() {
      this.initGanttTableOptions();
      this.currentDate = new Date(); // For performance reasons, when a lot of tasks are loaded in the gantt chart,
      // tasks outside of the visible scrollable viewport are removed from the DOM.

      this.taskLimitThreshold = 30;
      this.registerGanttApi = this.registerGanttApi.bind(this);
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.resetToInitialState();

      this._unsubscribe();
    }
  }, {
    key: "initGanttTableOptions",
    value: function initGanttTableOptions() {
      this.tableColumns = ['row.model.id'];
      this.tableHeaders = {
        'row.model.id': 'Name'
      };
      this.tableContents = {
        'row.model.id': timeline_row_name
      };
      this.tableFormatters = {
        'row.model.id': this.getRowModel.bind(this)
      };
    }
  }, {
    key: "getRowModel",
    value: function getRowModel(value, column, row) {
      var isDelivery = _.get(row, 'model.tasks[0].data.isDelivery');

      if (isDelivery) {
        return {
          title: row.model.name,
          isDelivery: isDelivery
        };
      }

      var release = _.get(row, 'model.data.release');

      return {
        title: release && release.title,
        releaseEditorURL: this.getReleaseEditorURL(release),
        isDelivery: isDelivery,
        isUpdatable: this.isUpdatable.bind(this)
      };
    }
  }, {
    key: "getReleaseEditorURL",
    value: function getReleaseEditorURL(release) {
      var releaseId = this._Ids.toInternalId(release.id);

      return "#".concat(this._viewStorage.getView(releaseId, "/releases/".concat(releaseId)));
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        fetchDelivery: function (_fetchDelivery) {
          function fetchDelivery() {
            return _fetchDelivery.apply(this, arguments);
          }

          fetchDelivery.toString = function () {
            return _fetchDelivery.toString();
          };

          return fetchDelivery;
        }(function () {
          dispatch(fetchDelivery(this.delivery.id));
        }),
        resetToInitialState: function resetToInitialState() {
          dispatch(Object(deliveries_timeline_actions["c" /* resetToInitialState */])());
        }
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(state) {
      var reducer = state.deliveriesTimeline;
      var newGanttData = this.getGanttData(reducer.delivery, reducer.filteredReleases);
      var ganttData = _.isEqual(reducer.filteredReleasesDateStamp, this.filteredReleasesDateStamp) ? this.ganttData : newGanttData;
      return timeline_controller_objectSpread(timeline_controller_objectSpread({
        delivery: reducer.delivery,
        loading: reducer.loading,
        hasReleases: !!reducer.filteredReleases.length,
        filters: reducer.filters,
        filteredReleasesDateStamp: reducer.filteredReleasesDateStamp
      }, reducer.zoomLevel), ganttData);
    }
  }, {
    key: "registerGanttApi",
    value: function registerGanttApi(api) {
      api.directives.on.new(this._scope, function (dName, dScope, dElement) {
        if (dName === 'ganttTask') {
          var phaseColor = _.get(dScope, ['task', 'model', 'data', 'phase', 'color']);

          if (phaseColor) {
            dElement.css({
              'border-color': phaseColor
            });
          }
        }
      });
    }
  }, {
    key: "isUpdatable",
    value: function isUpdatable() {
      return Object(services["f" /* isDeliveryUpdatable */])(this.delivery) && this._Authenticator.hasDeliveryEditPermission(this.delivery);
    }
  }, {
    key: "getPhaseStartDate",
    value: function getPhaseStartDate(phase) {
      return phase.plannedStartDate;
    }
  }, {
    key: "getPhaseEndDate",
    value: function getPhaseEndDate(phase) {
      return phase.plannedEndDate;
    }
  }, {
    key: "getGanttData",
    value: function getGanttData(delivery, releases) {
      var _this = this;

      if (!delivery || !releases) {
        return {
          ganttData: {
            data: [],
            timespans: []
          }
        };
      }

      var height = 36;
      var deliveryTimespan = {
        from: moment(delivery.startDate).toDate(),
        to: moment(delivery.endDate).toDate()
      };

      var data = _.reduce(releases, function (rows, release) {
        rows.push({
          name: release.title,
          height: height,
          sortable: false,
          classes: 'gantt-row-milestone',
          tasks: (release.phases || []).filter(function (phase) {
            return _this.getPhaseStartDate(phase) && _this.getPhaseEndDate(phase);
          }).map(function (phase) {
            var from = moment(_this.getPhaseStartDate(phase));
            var to = moment(_this.getPhaseEndDate(phase));
            var classes = ['fgt-timeline-task-release-phase'];

            if (_this._DateService.isOverdue(to.valueOf())) {
              classes.push('fgt-timeline-task-incomplete');
            }

            return {
              name: phase.title,
              from: from.toDate(),
              to: to.toDate(),
              classes: classes,
              data: {
                phase: phase,
                release: release,
                $ctrl: _this
              },
              content: phaseContentTemplate
            };
          }),
          data: {
            release: release,
            isDelivery: false
          }
        });
        return rows;
      }, [{
        name: delivery.title,
        height: height,
        classes: ['fgt-timeline-task-delivery'],
        tasks: [timeline_controller_objectSpread({
          name: delivery.title,
          content: deliveryContentTemplate,
          data: {
            release: {
              status: 'PLANNED'
            },
            isDelivery: true
          }
        }, deliveryTimespan)]
      }]);

      return {
        ganttData: {
          data: data,
          timespans: data.length > 1 ? [deliveryTimespan] : []
        }
      };
    }
  }, {
    key: "getDateDiff",
    value: function getDateDiff(actualDate, expectedDate) {
      return this._DateService.getOverdueDuration(actualDate, expectedDate);
    }
  }, {
    key: "isDateOverdue",
    value: function isDateOverdue(actualDate, expectedDate) {
      return expectedDate && moment(actualDate, global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp).diff(moment(expectedDate, global_constants["a" /* dateTimeFormat */].unixMillisecondTimestamp)) > 0;
    }
  }, {
    key: "hasReleasesFound",
    value: function hasReleasesFound() {
      return this.hasReleases && !this.loading;
    }
  }]);

  return TimelineController;
}();

defineProperty_default()(timeline_controller_TimelineController, "$inject", ['$ngRedux', '$scope', 'ViewStorage', 'Ids', 'DateService', 'Authenticator']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-tpl.html
/* harmony default export */ var timeline_tpl = ("<div class=\"content-under-header fgt-delivery-timeline\">\n    <div class=\"row\">\n        <div gantt\n             data=\"$ctrl.ganttData.data\"\n             timespans=\"$ctrl.ganttData.timespans\"\n             current-date-value=\"$ctrl.currentDate\"\n             column-width=\"$ctrl.columnWidth\"\n             view-scale=\"$ctrl.viewScale\"\n             headers=\"$ctrl.headers\"\n             headers-scales=\"$ctrl.headersScales\"\n             headers-formats=\"$ctrl.headersFormats\"\n\n             allow-side-resizing=\"false\"\n             api=\"::$ctrl.registerGanttApi\"\n             current-date=\"'line'\"\n             expand-to-fit=\"true\"\n             taskLimitThreshold=\"::$ctrl.taskLimitThreshold\"\n             max-height=\"'100%'\">\n            <gantt-table\n                    columns=\"::$ctrl.tableColumns\"\n                    headers=\"::$ctrl.tableHeaders\"\n                    contents=\"::$ctrl.tableContents\"\n                    formatters=\"::$ctrl.tableFormatters\">\n            </gantt-table>\n\n            <gantt-bounds></gantt-bounds>\n            <gantt-progress></gantt-progress>\n            <gantt-overlap></gantt-overlap>\n            <gantt-deliveries></gantt-deliveries>\n        </div>\n    </div>\n    <div class=\"row alert notice no-release-message\" ng-if=\"!$ctrl.hasReleasesFound() && !$ctrl.loading\">\n        <div>No releases found</div>\n    </div>\n    <div class=\"spinner\" ng-if=\"$ctrl.loading\">\n        <img src=\"static/10.2.6/styles/img/big-ajax-loader.gif\" alt=\"Loading...\" />\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/index.js


var timelineComponent = {
  bindings: {
    loading: '<',
    delivery: '<',
    onRefresh: '&'
  },
  controller: timeline_controller_TimelineController,
  template: timeline_tpl
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-phase-tooltip.html
/* harmony default export */ var timeline_phase_tooltip = ("<div>\n    <span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Phase: {{::task.model.data.phase.title}}</span>\n    <ul class=\"list-unstyled\" ng-init=\"phase = task.model.data.phase\">\n        <li ng-if=\"::!phase.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Estimated start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedStartDate, phase.scheduledStartDate)}\">\n                {{::phase.plannedStartDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedStartDate, phase.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::phase.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.startDate, phase.scheduledStartDate)}\">\n                {{::phase.startDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.startDate, phase.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::!phase.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">Estimated end date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.plannedEndDate, phase.dueDate)}\">\n                {{::phase.plannedEndDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.plannedEndDate, phase.dueDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::phase.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">End date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(phase.endDate, phase.dueDate)}\">\n                {{::phase.endDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(phase.endDate, phase.dueDate)}}</div>\n            </span>\n        </li>\n    </ul>\n    <div class=\"running-task-info\" ng-show=\"::phase.currentTask\">\n        Running task: {{::phase.currentTask}}\n    </div>\n    <div class=\"fgt-timeline-tooltip-splitter\"></div>\n    <div class=\"fgt-timeline-tooltip-release\">\n        <span class=\"fgt-timeline-tooltip-belongs_to\">Release: {{::task.model.data.release.title}}</span>\n        <span class=\"pull-right\">\n            <release-status-label release=\"task.model.data.release\" show-archived=\"true\"></release-status-label>\n        </span>\n    </div>\n    <ul class=\"list-unstyled\" ng-init=\"release = task.model.data.release\">\n        <li ng-if=\"::!release.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Planned start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedStartDate, release.scheduledStartDate)}\">\n                {{::release.plannedStartDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedStartDate, release.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::release.startDate\" class=\"text-right\">\n            <span class=\"pull-left\">Start date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.startDate, release.scheduledStartDate)}\">\n                {{::release.startDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.startDate, release.scheduledStartDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::!release.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">Planned end date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.plannedEndDate, release.dueDate)}\">\n                {{::release.plannedEndDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.plannedEndDate, release.dueDate)}}</div>\n            </span>\n        </li>\n        <li ng-if=\"::release.endDate\" class=\"text-right\">\n            <span class=\"pull-left\">End date:</span>\n            <span ng-class=\"{'date-overdue': task.model.data.$ctrl.isDateOverdue(release.endDate, release.dueDate)}\">\n                {{::release.endDate | mediumDateShortTime}}\n                <div class=\"fgt-timeline-tooltip-date-diff\">{{::task.model.data.$ctrl.getDateDiff(release.endDate, release.dueDate)}}</div>\n            </span>\n        </li>\n    </ul>\n</div>");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-delivery-tooltip.html
/* harmony default export */ var timeline_delivery_tooltip = ("<div>\n    <span class=\"fgt-timeline-text-ellipsis fgt-timeline-tooltip-phase_name\">Delivery: {{::task.model.name}}</span>\n    <ul class=\"list-unstyled\">\n        <li>\n            <span>Start date:</span>\n            <span class=\"pull-right\">\n                {{::task.model.from.toDate() | mediumDateShortTime}}\n            </span>\n        </li>\n        <li>\n            <span>End date:</span>\n            <span class=\"pull-right\">\n                {{::task.model.to.toDate() | mediumDateShortTime}}\n            </span>\n        </li>\n    </ul>\n</div>");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/components/timeline-tooltip-directive.js


var tooltipTemplate = "\n    <div class='tooltip fgt-timeline-tooltip' role='tooltip'>\n        <div class='tooltip-arrow fgt-timeline-tooltip-arrow'></div>\n        <div class='tooltip-inner'></div>\n    </div>\n";
/* harmony default export */ var timeline_tooltip_directive = (['$compile', function ($compile) {
  return {
    restrict: 'A',
    link: function link(scope, element) {
      var template = _.get(scope, ['task', 'model', 'data', 'isDelivery']) ? timeline_delivery_tooltip : timeline_phase_tooltip;
      element.tooltip({
        title: function title() {
          var compiledTemplate = $compile(template)(scope);
          scope.$digest();
          return compiledTemplate[0].outerHTML;
        },
        delay: 50,
        trigger: 'hover',
        placement: 'auto',
        html: true,
        animation: false,
        container: 'body',
        template: tooltipTemplate
      });
      var offStateChangeStart = scope.$on('$stateChangeStart', function () {
        element.tooltip('destroy');
        offStateChangeStart();
      });

      var throttled = _.throttle(trackMove, 0);

      element.mousemove(throttled);

      function trackMove(event) {
        var tooltip = angular.element('.fgt-timeline-tooltip');
        var tooltipArrow = angular.element('.fgt-timeline-tooltip-arrow');
        var tooltipWidth = tooltip.outerWidth();
        var tooltipHalfWidth = tooltipWidth / 2;
        var clientX = parseInt(event.clientX);
        var marginRight = 5;

        if (event.clientX + tooltipHalfWidth + marginRight >= window.outerWidth) {
          tooltip.css('left', '');
          tooltip.css('right', "".concat(marginRight, "px"));
          tooltipArrow.css('left', "".concat(tooltipWidth - (window.outerWidth - clientX), "px"));
        } else {
          tooltipArrow.css('left', "".concat(tooltipHalfWidth, "px"));
          tooltip.css('left', "".concat(clientX - tooltipHalfWidth, "px"));
          tooltip.css('right', '');
        }
      }
    }
  };
}]);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/delivery-timeline-page.less
var delivery_timeline_page = __webpack_require__(885);
var delivery_timeline_page_default = /*#__PURE__*/__webpack_require__.n(delivery_timeline_page);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/delivery-timeline-page.less

            

var delivery_timeline_page_options = {};

delivery_timeline_page_options.insert = "head";
delivery_timeline_page_options.singleton = false;

var delivery_timeline_page_update = injectStylesIntoStyleTag_default()(delivery_timeline_page_default.a, delivery_timeline_page_options);



/* harmony default export */ var timeline_delivery_timeline_page = (delivery_timeline_page_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/delivery-timeline-page.js




function delivery_timeline_page_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_timeline_page_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_timeline_page_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_timeline_page_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var delivery_timeline_page_template = "\n<div id=\"deliveries\" class=\"fc-list fgd-deliveries\">\n    <xlr-delivery-details-header delivery=\"$ctrl.delivery\" class=\"delivery-header-gantt-fix\">\n        <filter class=\"filters\"\n                filters=\"$ctrl.filters\"\n                on-change=\"$ctrl.onFiltersChanged()\">\n            <div class=\"actions\">\n                <i class=\"button-toggle-filter-icon xl-icon search-icon\"></i>\n                <text-filter field=\"'title'\" placeholder=\"'Search for releases'\"/>\n                <order-by-filter class=\"filter last\"/>\n                <span class=\"fgt-zoom filter\">\n                        <span class=\"filter-title\">Zoom</span>\n                        <div class=\"button-delivery\">\n                            <button class=\"btn btn-flat button-icon\"\n                                    ng-click=\"$ctrl.zoomLevelOut && $ctrl.zoomOut()\"\n                                    ng-disabled=\"!$ctrl.zoomLevelOut\"><i class=\"xl-icon minus-icon\"></i></button>\n                        <button class=\"btn btn-flat button-icon\"\n                                ng-click=\"$ctrl.zoomLevelIn && $ctrl.zoomIn()\"\n                                ng-disabled=\"!$ctrl.zoomLevelIn\"><i class=\"xl-icon add-icon\"></i></button>\n                        </div>\n                    </span>\n            </div>\n        </filter>\n\n        <div class=\"buttons\">\n            <span doc-icon=\"deliveries-details.html\"/>\n        </div>\n    </xlr-delivery-details-header>\n    <div class=\"fc-list-items-wrapper\">\n        <xlr-delivery-timeline delivery=\"$ctrl.delivery\" loading=\"$ctrl.loading\" on-refresh=\"$ctrl.onFiltersChanged()\"/>\n    </div>\n</div>\n";

var delivery_timeline_page_DeliveryTimelinePageController = /*#__PURE__*/function () {
  function DeliveryTimelinePageController($scope, Events, $ngRedux, Page) {
    classCallCheck_default()(this, DeliveryTimelinePageController);

    this._$scope = $scope;
    this._Events = Events;
    this._Page = Page;
    this._isBreadCrumbInitialized = false;
    this._unsubscribe = $ngRedux.connect(this._mapStateToThis.bind(this), this._mapDispatchToThis.bind(this))(this);
  }

  createClass_default()(DeliveryTimelinePageController, [{
    key: "$onInit",
    value: function $onInit() {
      this._$scope.$emit(this._Events.permission.refresh);

      this.fetchTimeline({});
    }
  }, {
    key: "$onDestroy",
    value: function $onDestroy() {
      this.resetToInitialState();

      this._unsubscribe();
    }
  }, {
    key: "_mapDispatchToThis",
    value: function _mapDispatchToThis(dispatch) {
      return {
        resetToInitialState: function resetToInitialState() {
          dispatch(Object(deliveries_timeline_actions["c" /* resetToInitialState */])());
        },
        fetchTimeline: function fetchTimeline(filters) {
          dispatch(Object(deliveries_timeline_actions["b" /* getTimeline */])(this.delivery, filters));
        },
        updateFilters: function updateFilters(filters) {
          dispatch(Object(deliveries_timeline_actions["d" /* setFilters */])(filters));
        },
        zoomIn: function zoomIn() {
          dispatch({
            type: deliveries_timeline_actions["a" /* actionTypes */].ZOOM_IN
          });
        },
        zoomOut: function zoomOut() {
          dispatch({
            type: deliveries_timeline_actions["a" /* actionTypes */].ZOOM_OUT
          });
        }
      };
    }
  }, {
    key: "_mapStateToThis",
    value: function _mapStateToThis(_ref) {
      var deliveriesTimeline = _ref.deliveriesTimeline;
      var delivery = deliveriesTimeline.delivery;

      if (delivery) {
        this._setBreadcrumbs(delivery);
      }

      return delivery_timeline_page_objectSpread({
        gantt: deliveriesTimeline.gantt,
        delivery: delivery,
        loading: deliveriesTimeline.loading,
        filters: deliveriesTimeline.filters
      }, deliveriesTimeline.zoomLevel);
    }
  }, {
    key: "_setBreadcrumbs",
    value: function _setBreadcrumbs(delivery) {
      if (!this._isBreadCrumbInitialized) {
        this._Page.setFolderEntityOpened(delivery.folderId, delivery);

        this._isBreadCrumbInitialized = true;
      }
    }
  }, {
    key: "onFiltersChanged",
    value: function onFiltersChanged() {
      this.updateFilters(this.filters);
    }
  }]);

  return DeliveryTimelinePageController;
}();

defineProperty_default()(delivery_timeline_page_DeliveryTimelinePageController, "$inject", ['$scope', 'Events', '$ngRedux', 'Page']);

var deliveryTimelinePage = {
  bindings: {
    delivery: '<',
    folder: '<'
  },
  controller: delivery_timeline_page_DeliveryTimelinePageController,
  template: delivery_timeline_page_template
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/timeline/index.js



/* harmony default export */ var timeline = (angular.module('xlrelease.deliveriesDetails', ['gantt', 'gantt.table', 'gantt.bounds', 'gantt.progress', 'gantt.overlap', 'gantt.groups']).directive('xlrDeliveryTimelineTooltip', timeline_tooltip_directive).component('xlrDeliveryTimeline', timelineComponent).component('xlrDeliveryTimelinePage', deliveryTimelinePage));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/index.js



// EXTERNAL MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/services/index.js
var deliveries_details_services = __webpack_require__(236);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/activity-logs/delivery-activity-logs.html
/* harmony default export */ var delivery_activity_logs = ("<div id=\"logs\" ng-if=\"filters\">\n    <xlr-delivery-details-header delivery=\"delivery\">\n        <div class=\"filters\" ng-controller=\"FiltersController\">\n            <div class=\"actions\">\n                <input id=\"search-filter\" autofocus type=\"search\" class=\"filter\" placeholder=\"Filter by user or action...\" ng-model=\"filters.filter\">\n                <button type=\"button\" class=\"button dropdown-button filter\" bs-popover\n                        data-content-template=\"static/10.2.6/include/ActivityLogs/activity-logs-filter/activity-logs-categories-filter.html\"\n                        data-placement=\"bottom\" auto-close=\"true\">Filter categories\n                </button>\n                <span class=\"filter\" ng-include=\"'partials/filters/from-to-date-filters.html'\"></span>\n            </div>\n        </div>\n        <span doc-icon=\"activity-logs.html\"></span>\n    </xlr-delivery-details-header>\n    <div class=\"content-under-header\">\n        <activity-logs-list filters=\"filters\" container-id=\"containerId\" ></activity-logs-list>\n    </div>\n</div>\n");
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/components/activity-logs/delivery-activity-logs-controller.js



var delivery_activity_logs_controller_DeliveryActivityLogsController = function DeliveryActivityLogsController($scope, $stateParams, filterSettings, deliveryPromise) {
  classCallCheck_default()(this, DeliveryActivityLogsController);

  this._$scope = $scope;
  this._$scope.containerId = $stateParams.deliveryId;
  this._$scope.filters = filterSettings;
  this._$scope.activityFilters = [{
    id: "display-important",
    model: "important",
    label: "Important"
  }, {
    id: "display-lifecycle",
    model: "lifecycle",
    label: "Delivery life cycle"
  }, {
    id: "display-delivery_edit",
    model: "deliveryEdit",
    label: "Delivery edits"
  }, {
    id: "display-other",
    model: "other",
    label: "Other"
  }];
  this._$scope.delivery = deliveryPromise.data;
};

defineProperty_default()(delivery_activity_logs_controller_DeliveryActivityLogsController, "$inject", ['$scope', '$stateParams', 'filterSettings', 'deliveryPromise']);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-details/index.js









/* harmony default export */ var deliveries_details = (angular.module('xlrelease.deliveriesDetails').component('xlrDeliveryDetailsHeader', deliveryDetailsHeader).config(['$urlMatcherFactoryProvider', '$stateProvider', function ($urlMatcherFactoryProvider, $stateProvider) {
  $urlMatcherFactoryProvider.type('DeliveryId', {
    encode: angular.identity,
    decode: angular.identity,
    pattern: /Deliveries\/Delivery\w+/
  });
  $stateProvider.state('deliveryCreate', {
    url: '/deliveries/create?fromPatternId',
    controller: ['$stateParams', '$window', 'Ids', function ($stateParams, $window, Ids) {
      //redirect to previous page when patternId is not defined
      this.patternId = $stateParams.fromPatternId ? Ids.toDomainId($stateParams.fromPatternId) : $window.history.back();
    }],
    controllerAs: 'deliveryCreateCtrl',
    template: "\n                    <div id=\"delivery-details\">\n                        <xlr-delivery-details-header>\n                            <h4>Create new delivery</h4>\n                            <div class=\"buttons\">\n                                <xlr-delivery-properties-header></xlr-delivery-properties-header>\n                                <span doc-icon=\"deliveries.html\"></span>\n                            </div>\n                        </xlr-delivery-details-header>\n                    \n                        <div class=\"content-under-header\">\n                            <xlr-delivery-properties pattern-id=\"deliveryCreateCtrl.patternId\"></xlr-delivery-properties>\n                        </div>\n                    </div>"
  }).state('deliveriesDetails', {
    url: '/deliveries/{deliveryId: DeliveryId}',
    reloadOnSearch: false,
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return Promise.all([Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId), deliveryFlowService.fetchStageReleases($stateParams.deliveryId)]).then(function (responses) {
          return responses;
        });
      }]
    }
  }).state('deliveryLogs', {
    url: '/deliveries/{deliveryId: DeliveryId}/logs',
    reloadOnSearch: false,
    template: delivery_activity_logs,
    controller: delivery_activity_logs_controller_DeliveryActivityLogsController,
    controllerAs: '$ctrl',
    resolve: {
      filterSettings: ['$stateParams', 'Filters', function ($stateParams, Filters) {
        return Filters.getLogsFiltersSettings($stateParams.deliveryId);
      }],
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId);
      }]
    }
  }).state('deliveryDetailsPageExtension', {
    url: '/deliveries/{deliveryId: DeliveryId}/:extensionPath',
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        if ($stateParams.extensionPath === "") {
          return Promise.all([Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId), deliveryFlowService.fetchStageReleases($stateParams.deliveryId)]).then(function (responses) {
            return responses;
          });
        }

        return Object(deliveries_details_services["a" /* fetchDelivery */])($stateParams.deliveryId);
      }]
    }
  });
}]).name);
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/get.js
var helpers_get = __webpack_require__(535);
var helpers_get_default = /*#__PURE__*/__webpack_require__.n(helpers_get);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/folder-deliveries.html
/* harmony default export */ var folder_deliveries = ("\n<folder-details folder=\"$ctrl.folder\" ng-class=\"{'header-expanded': $ctrl.isHeaderExpanded}\" >\n    <header class=\"folder-deliveries-header\">\n      <delivery-filter\n          filters=\"$ctrl.filters\"\n          filters-changed=\"$ctrl.filtersChanged()\"\n          items-count=\"$ctrl.itemsCount\">\n      </delivery-filter>\n       <delivery-sub-header has-deliveries=\"$ctrl.hasDeliveries()\"></delivery-sub-header>\n    </header>\n    <content>\n        <div class=\"folder-deliveries-list\" id=\"deliveries\">\n            <xlr-delivery-list\n                 deliveries=\"$ctrl.deliveries\"\n                 deliveries-loading-status=\"$ctrl.loading\"\n                 deliveries-has-more=\"$ctrl.hasMoreDeliveries\"\n                 on-refresh=\"$ctrl.filtersChanged()\"\n                 on-show-more-deliveries=\"$ctrl.loadMoreDeliveries()\">\n            </xlr-delivery-list>\n        </div>\n    </content>\n</folder-details>\n");
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/folder-deliveries-list.less
var folder_deliveries_list = __webpack_require__(886);
var folder_deliveries_list_default = /*#__PURE__*/__webpack_require__.n(folder_deliveries_list);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/folder-deliveries-list.less

            

var folder_deliveries_list_options = {};

folder_deliveries_list_options.insert = "head";
folder_deliveries_list_options.singleton = false;

var folder_deliveries_list_update = injectStylesIntoStyleTag_default()(folder_deliveries_list_default.a, folder_deliveries_list_options);



/* harmony default export */ var deliveries_folder_folder_deliveries_list = (folder_deliveries_list_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/folder-deliveries-component.js









function folder_deliveries_component_createSuper(Derived) { var hasNativeReflectConstruct = folder_deliveries_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function folder_deliveries_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var folder_deliveries_component_FolderDeliveriesController = /*#__PURE__*/function (_DeliveriesController) {
  inherits_default()(FolderDeliveriesController, _DeliveriesController);

  var _super = folder_deliveries_component_createSuper(FolderDeliveriesController);

  function FolderDeliveriesController(ClientSettings) {
    var _this;

    classCallCheck_default()(this, FolderDeliveriesController);

    for (var _len = arguments.length, superArguments = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      superArguments[_key - 1] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(superArguments));
    _this._ClientSettings = ClientSettings;
    return _this;
  }

  createClass_default()(FolderDeliveriesController, [{
    key: "filtersChanged",
    value: function filtersChanged() {
      this._ClientSettings.setDeliveryListFilters(this.filters);

      helpers_get_default()(getPrototypeOf_default()(FolderDeliveriesController.prototype), "filtersChanged", this).call(this);
    }
  }]);

  return FolderDeliveriesController;
}(deliveries_controller_DeliveriesController);

defineProperty_default()(folder_deliveries_component_FolderDeliveriesController, "$inject", ['ClientSettings'].concat(toConsumableArray_default()(deliveries_controller_DeliveriesController.$inject)));

var FolderDeliveriesComponent = {
  bindings: {
    folder: '<',
    filters: '<'
  },
  controller: folder_deliveries_component_FolderDeliveriesController,
  template: folder_deliveries
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries-folder/index.js

angular.module('xlrelease.deliveries').component('folderDeliveriesList', FolderDeliveriesComponent);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/index.less
var delivery_patterns = __webpack_require__(887);
var delivery_patterns_default = /*#__PURE__*/__webpack_require__.n(delivery_patterns);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/index.less

            

var delivery_patterns_options = {};

delivery_patterns_options.insert = "head";
delivery_patterns_options.singleton = false;

var delivery_patterns_update = injectStylesIntoStyleTag_default()(delivery_patterns_default.a, delivery_patterns_options);



/* harmony default export */ var include_delivery_patterns = (delivery_patterns_default.a.locals || {});
// EXTERNAL MODULE: ./modules/xlr-activity-logs-module/src/main/resources/web/include/ActivityLogs/activity-logs-list/activity-logs-list-controller.js
var activity_logs_list_controller = __webpack_require__(711);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-list-header.component.js






function delivery_pattern_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_list_header_component_filterOptions = {
  placeholder: 'Filter by name...'
};

var delivery_pattern_list_header_component_DeliveryPatternListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListHeaderComponent, _Component);

  var _super = delivery_pattern_list_header_component_createSuper(DeliveryPatternListHeaderComponent);

  function DeliveryPatternListHeaderComponent(props) {
    classCallCheck_default()(this, DeliveryPatternListHeaderComponent);

    return _super.call(this, props);
  }

  createClass_default()(DeliveryPatternListHeaderComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props = this.props,
          filter = _this$props.filter,
          onFilterChange = _this$props.onFilterChange;
      onFilterChange(filter);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          filter = _this$props2.filter,
          isCreateAllowed = _this$props2.isCreateAllowed,
          onCreateDeliveryPattern = _this$props2.onCreateDeliveryPattern,
          onFilterChange = _this$props2.onFilterChange;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_["Fragment"], null, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: delivery_pattern_list_header_component_filterOptions,
        model: filter,
        onUpdate: onFilterChange,
        style: {
          marginBottom: '0'
        }
      }), isCreateAllowed && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary new-delivery-pattern",
        onClick: onCreateDeliveryPattern
      }, "New delivery pattern"), /*#__PURE__*/external_React_default.a.createElement(components["g" /* DocLink */], {
        section: "delivery-patterns.html"
      })));
    }
  }]);

  return DeliveryPatternListHeaderComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/delivery-pattern.actions.js
var delivery_pattern_actions_actionTypes = {
  DELIVERY_PATTERN_CREATE_FORM: "DELIVERY_PATTERN/CREATE_FORM",
  DELIVERY_PATTERN_CREATE_DELIVERY_FORM: "DELIVERY_PATTERN/CREATE_DELIVERY_FORM",
  DELIVERY_PATTERN_LIST_SUCCEEDED: 'DELIVERY_PATTERN/LIST_SUCCEEDED',
  DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED: 'DELIVERY_PATTERN/CREATE_CANCEL_REQUESTED',
  DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED: 'DELIVERY_PATTERN/CREATE_CANCEL_SUCCEEDED',
  DELIVERY_PATTERN_PRISTINE: 'DELIVERY_PATTERN/PRISTINE',
  DELIVERY_PATTERN_VALID: 'DELIVERY_PATTERN/VALID',
  DELIVERY_PATTERN_MODEL_CHANGE: 'DELIVERY_PATTERN/MODEL_CHANGE',
  DELIVERY_PATTERN_CREATE_REQUESTED: 'DELIVERY_PATTERN/CREATE_REQUESTED',
  DELIVERY_PATTERN_CREATE_SUCCEEDED: 'DELIVERY_PATTERN/CREATE_SUCCEEDED',
  DELIVERY_PATTERN_UPDATE_REQUESTED: 'DELIVERY_PATTERN/UPDATE_REQUESTED',
  DELIVERY_PATTERN_UPDATE_SUCCEEDED: 'DELIVERY_PATTERN/UPDATE_SUCCEEDED',
  DELIVERY_PATTERN_DELETE_REQUESTED: 'DELIVERY_PATTERN/DELETE_REQUESTED',
  DELIVERY_PATTERN_DELETE_SUCCEEDED: 'DELIVERY_PATTERN/DELETE_SUCCEEDED',
  DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED: 'DELIVERY_PATTERN/FILTER_CHANGE_REQUESTED',
  DELIVERY_PATTERN_LIST_FAILED: 'DELIVERY_PATTERN/LIST_FAILED',
  DELIVERY_PATTERN_GO_TO_DETAILS: 'DELIVERY_PATTERN/DETAILS',
  DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY: 'DELIVERY_PATTERN/GO_TO_CREATE_DELIVERY',
  DELIVERY_PATTERN_LOAD_REQUESTED: 'DELIVERY_PATTERN/LOAD_REQUESTED',
  DELIVERY_PATTERN_LOAD_SUCCEEDED: 'DELIVERY_PATTERN/LOAD_SUCCEEDED',
  DELIVERY_PATTERN_RESET_REQUESTED: 'DELIVERY_PATTERN/RESET_REQUESTED',
  DELIVERY_PATTERN_COPY_REQUESTED: 'DELIVERY_PATTERN/COPY_REQUESTED',
  DELIVERY_PATTERN_GET_ALL_REQUESTED: 'DELIVERY_PATTERN/GET_ALL_REQUESTED',
  DELIVERY_PATTERN_GET_ALL_SUCCEEDED: 'DELIVERY_PATTERN/GET_ALL_SUCCEEDED',
  DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED: 'DELIVERY_PATTERN/VALIDATE_TITLE_REQUESTED',
  DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED: 'DELIVERY_PATTERN/VALIDATE_TITLE_SUCCEEDED'
};
var deliveryPatternForm = function deliveryPatternForm() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_FORM
  };
};
var createDeliveryForm = function createDeliveryForm() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_DELIVERY_FORM
  };
};
var listLoaded = function listLoaded(list) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_SUCCEEDED,
    payload: list
  };
};
var listFailed = function listFailed() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_FAILED
  };
};
var cancelCreate = function cancelCreate() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED
  };
};
var createCancelled = function createCancelled() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED
  };
};
var delivery_pattern_actions_changeValidation = function changeValidation(valid) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALID,
    payload: valid
  };
};
var delivery_pattern_actions_changeModel = function changeModel(model) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_MODEL_CHANGE,
    payload: model
  };
};
var delivery_pattern_actions_createDeliveryPattern = function createDeliveryPattern() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_REQUESTED
  };
};
var deliveryPatternCreated = function deliveryPatternCreated(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_SUCCEEDED,
    payload: deliveryPattern
  };
};
var delivery_pattern_actions_deleteDeliveryPattern = function deleteDeliveryPattern(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_REQUESTED,
    payload: id
  };
};
var deliveryPatternDeleted = function deliveryPatternDeleted(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_SUCCEEDED,
    payload: id
  };
};
var changeDeliveryPatternFilter = function changeDeliveryPatternFilter(filter) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED,
    payload: filter
  };
};
var delivery_pattern_actions_goToDetails = function goToDetails(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_DETAILS,
    payload: id
  };
};
var goToCreateDelivery = function goToCreateDelivery(id) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY,
    payload: id
  };
};
var deliveryLoaded = function deliveryLoaded(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LOAD_SUCCEEDED,
    payload: deliveryPattern
  };
};
var delivery_pattern_actions_updateDeliveryPattern = function updateDeliveryPattern() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_REQUESTED
  };
};
var deliveryPatternUpdated = function deliveryPatternUpdated(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_SUCCEEDED,
    payload: deliveryPattern
  };
};
var resetDeliveryPattern = function resetDeliveryPattern() {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_RESET_REQUESTED
  };
};
var delivery_pattern_actions_copyDeliveryPattern = function copyDeliveryPattern(deliveryPattern) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_COPY_REQUESTED,
    payload: deliveryPattern
  };
};
var delivery_pattern_actions_changePristine = function changePristine(pristine) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_PRISTINE,
    payload: pristine
  };
};
var allPatternsLoaded = function allPatternsLoaded(defs) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GET_ALL_SUCCEEDED,
    payload: defs
  };
};
var delivery_pattern_actions_validateTitle = function validateTitle(id, title) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED,
    payload: {
      id: id,
      title: title
    }
  };
};
var titleValidated = function titleValidated(duplicatedDelivery) {
  return {
    type: delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED,
    payload: duplicatedDelivery
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list-header.container.js




var delivery_pattern_list_header_container_mapStateToProps = function mapStateToProps(state) {
  return {
    filter: state.deliveryPatterns.filter
  };
};

var delivery_pattern_list_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCreateDeliveryPattern: function onCreateDeliveryPattern() {
      return dispatch(deliveryPatternForm());
    },
    onFilterChange: function onFilterChange(title) {
      return dispatch(changeDeliveryPatternFilter(title));
    }
  };
};

/* harmony default export */ var delivery_pattern_list_header_container = (Object(es["connect"])(delivery_pattern_list_header_container_mapStateToProps, delivery_pattern_list_header_container_mapDispatchToProps)(delivery_pattern_list_header_component_DeliveryPatternListHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/delivery-pattern.reducer.js


function delivery_pattern_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }




var delivery_pattern_reducer_initialState = function initialState() {
  return {
    list: [],
    form: {
      model: {
        plannedDuration: 0,
        id: null,
        title: '',
        description: '',
        folderId: null
      },
      lastSaved: null,
      pristine: true,
      valid: false,
      isTitleValid: true,
      duplicatedDelivery: {
        id: null,
        title: ''
      },
      editable: true,
      all: []
    },
    loading: false,
    filter: "",
    canEdit: false
  };
};

var delivery_pattern_reducer_deliveryPatterns = function deliveryPatterns() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : delivery_pattern_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_FORM:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: {
          model: {
            plannedDuration: 0,
            id: null,
            title: '',
            description: ''
          },
          editable: true,
          pristine: true,
          isTitleValid: true,
          duplicatedDelivery: {
            id: null,
            title: ''
          },
          valid: false
        }
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_SUCCEEDED:
      var list = action.payload;
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        list: list,
        loading: false
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALID:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state.form), {}, {
          valid: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state.form), {}, {
          duplicatedDelivery: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_MODEL_CHANGE:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state.form), {}, {
          model: action.payload,
          pristine: false
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_SUCCEEDED:
    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread({}, state);

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        list: state.list.filter(function (item) {
          return item.id !== action.payload;
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        filter: action.payload,
        loading: true
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LIST_FAILED:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        loading: false
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LOAD_SUCCEEDED:
      var _action$payload = action.payload,
          description = _action$payload.description,
          plannedDuration = _action$payload.plannedDuration,
          folderId = _action$payload.folderId,
          id = _action$payload.id,
          isEditable = _action$payload.isEditable,
          title = _action$payload.title;
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state.form), {}, {
          model: {
            plannedDuration: plannedDuration,
            id: id,
            title: title,
            description: description,
            folderId: folderId
          },
          editable: isEditable,
          pristine: true
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_PRISTINE:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state.form), {}, {
          pristine: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GET_ALL_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state.form), {}, {
          all: action.payload
        })
      });

    case delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_SUCCEEDED:
      return delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state), {}, {
        form: delivery_pattern_reducer_objectSpread(delivery_pattern_reducer_objectSpread({}, state.form), {}, {
          lastSaved: moment_js_exposed_default()().format('MMMM DD, YYYY h:mm:ss A'),
          pristine: true
        })
      });

    default:
      return state;
  }
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/tracked-item.actions.js
// -- ACTIONS --
var tracked_item_actions_actionTypes = {
  TRACKED_ITEM_CREATE_OR_UPDATE: "TRACKED_ITEM/CREATE_OR_UPDATE",
  TRACKED_ITEM_ADDED: "TRACKED_ITEM/ADDED",
  TRACKED_ITEM_UPDATED: "TRACKED_ITEM/UPDATED",
  TRACKED_ITEM_REMOVE: "TRACKED_ITEM/REMOVE",
  TRACKED_ITEM_REMOVED: "TRACKED_ITEM/REMOVED",
  TRACKED_ITEM_FETCH_LIST: "TRACKED_ITEM/FETCH_LIST",
  TRACKED_ITEM_SET_LIST: "TRACKED_ITEM/SET_LIST",
  TRACKED_ITEM_FILTER_CHANGED: "TRACKED_ITEM/FILTER_CHANGED"
};
var tracked_item_actions_createOrUpdateTrackedItem = function createOrUpdateTrackedItem(trackedItem, deliveryId) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE,
    payload: {
      trackedItem: trackedItem,
      deliveryId: deliveryId
    }
  };
};
var addedTrackedItem = function addedTrackedItem(trackedItem) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_ADDED,
    payload: trackedItem
  };
};
var updatedTrackedItem = function updatedTrackedItem(trackedItem) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_UPDATED,
    payload: trackedItem
  };
};
var tracked_item_actions_removeTrackedItem = function removeTrackedItem(id) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVE,
    payload: id
  };
};
var tracked_item_actions_removedTrackedItem = function removedTrackedItem(id) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVED,
    payload: id
  };
};
var fetchTrackedItems = function fetchTrackedItems(deliveryId) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_FETCH_LIST,
    payload: deliveryId
  };
};
var setList = function setList(list) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_SET_LIST,
    payload: list
  };
};
var changeFilter = function changeFilter(filter) {
  return {
    type: tracked_item_actions_actionTypes.TRACKED_ITEM_FILTER_CHANGED,
    payload: filter
  };
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/tracked-item.reducer.js



function tracked_item_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function tracked_item_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_item_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_item_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var tracked_item_reducer_initialState = function initialState() {
  return {
    list: [],
    filter: ''
  };
};

var tracked_item_reducer_trackedItems = function trackedItems() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : tracked_item_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case tracked_item_actions_actionTypes.TRACKED_ITEM_SET_LIST:
      {
        return tracked_item_reducer_objectSpread(tracked_item_reducer_objectSpread({}, state), {}, {
          list: action.payload
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_ADDED:
      {
        var list = state.list;
        return tracked_item_reducer_objectSpread(tracked_item_reducer_objectSpread({}, state), {}, {
          list: list.concat([action.payload])
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_UPDATED:
      {
        var _list = state.list;
        var _action$payload = action.payload,
            id = _action$payload.id,
            title = _action$payload.title;
        _list.find(function (item) {
          return item.id === id;
        }).title = title;
        return tracked_item_reducer_objectSpread(tracked_item_reducer_objectSpread({}, state), {}, {
          list: toConsumableArray_default()(_list)
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVED:
      {
        var _list2 = state.list;
        return tracked_item_reducer_objectSpread(tracked_item_reducer_objectSpread({}, state), {}, {
          list: _list2.filter(function (item) {
            return item.id !== action.payload;
          })
        });
      }

    case tracked_item_actions_actionTypes.TRACKED_ITEM_FILTER_CHANGED:
      {
        var filter = action.payload;
        return tracked_item_reducer_objectSpread(tracked_item_reducer_objectSpread({}, state), {}, {
          filter: filter
        });
      }

    default:
      return state;
  }
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/delivery-pattern.sagas.js


function delivery_pattern_sagas_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_sagas_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_sagas_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_sagas_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var delivery_pattern_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_updateBreadcrumbs),
    delivery_pattern_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(loadDeliveryPattern),
    delivery_pattern_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(flowView),
    delivery_pattern_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_goToCreateDelivery),
    delivery_pattern_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_cancelCreate),
    delivery_pattern_sagas_marked6 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_searchDeliveryPatterns),
    delivery_pattern_sagas_marked7 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_createDeliveryPattern),
    delivery_pattern_sagas_marked8 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_updateDeliveryPattern),
    delivery_pattern_sagas_marked9 = /*#__PURE__*/regenerator_default.a.mark(removeDeliveryPattern),
    delivery_pattern_sagas_marked10 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_resetDeliveryPattern),
    delivery_pattern_sagas_marked11 = /*#__PURE__*/regenerator_default.a.mark(duplicateDeliveryPattern),
    delivery_pattern_sagas_marked12 = /*#__PURE__*/regenerator_default.a.mark(setupConfirmLeavePopup),
    delivery_pattern_sagas_marked13 = /*#__PURE__*/regenerator_default.a.mark(getAllPatterns),
    delivery_pattern_sagas_marked14 = /*#__PURE__*/regenerator_default.a.mark(validatePatternTitle),
    delivery_pattern_sagas_marked15 = /*#__PURE__*/regenerator_default.a.mark(delivery_pattern_sagas_combinedSaga);








function delivery_pattern_sagas_isEditable(def) {
  var authenticator = Object(angular_accessor["b" /* default */])('Authenticator');
  return authenticator.hasPermission(DELIVERY_PATTERN_EDIT_PERMISSION, def.$metadata);
}

function delivery_pattern_sagas_canCreateDelivery(def) {
  var authenticator = Object(angular_accessor["b" /* default */])('Authenticator');
  return authenticator.hasPermission(DELIVERY_EDIT_PERMISSION, def.$metadata);
}

function delivery_pattern_sagas_isCreateDeliveryDisabled(def) {
  return def.stages.length === 0;
}

function listView() {
  var param = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var $location = Object(angular_accessor["b" /* default */])('$location');
  var $stateParams = Object(angular_accessor["b" /* default */])('$stateParams');
  var $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
  $location.url("/folders/".concat($stateParams.folderId, "/delivery-patterns?").concat(param));
  $rootScope.$digest();
}

function delivery_pattern_sagas_deliveryPatternForm() {
  listView('action=create');
}

function delivery_pattern_sagas_createDeliveryForm() {
  var $state = Object(angular_accessor["b" /* default */])('$state');
  var Ids = Object(angular_accessor["b" /* default */])('Ids');
  var $stateParams = Object(angular_accessor["b" /* default */])('$stateParams');
  $state.go('deliveryCreate', {
    fromPatternId: Ids.toInternalId($stateParams.deliveryId)
  });
}

function delivery_pattern_sagas_updateBreadcrumbs(checkUrl, deliveryPattern) {
  var page;
  return regenerator_default.a.wrap(function updateBreadcrumbs$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], 'Page');

        case 2:
          page = _context.sent;

          if (page.isOnPage(checkUrl)) {
            page.setFolderEntityOpened(deliveryPattern.folderId, deliveryPattern);
          }

        case 4:
        case "end":
          return _context.stop();
      }
    }
  }, delivery_pattern_sagas_marked);
}

function loadDeliveryPattern(action) {
  var resp;
  return regenerator_default.a.wrap(function loadDeliveryPattern$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_fetchDeliveryPattern, action.payload);

        case 3:
          resp = _context2.sent;
          _context2.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 6:
          _context2.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryLoaded(delivery_pattern_sagas_objectSpread(delivery_pattern_sagas_objectSpread({}, resp), {}, {
            isEditable: delivery_pattern_sagas_isEditable(resp),
            canCreateDelivery: delivery_pattern_sagas_canCreateDelivery(resp)
          })));

        case 8:
          _context2.next = 13;
          break;

        case 10:
          _context2.prev = 10;
          _context2.t0 = _context2["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while loading delivery pattern...', _context2.t0);
          /* eslint-enable */

        case 13:
        case "end":
          return _context2.stop();
      }
    }
  }, delivery_pattern_sagas_marked2, null, [[0, 10]]);
}

function flowView(action) {
  var $location, $rootScope;
  return regenerator_default.a.wrap(function flowView$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          $location = Object(angular_accessor["b" /* default */])('$location');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          $location.url("/delivery-patterns/".concat(action.payload));
          $rootScope.$digest();

        case 4:
        case "end":
          return _context3.stop();
      }
    }
  }, delivery_pattern_sagas_marked3);
}

function delivery_pattern_sagas_goToCreateDelivery(action) {
  var $state, $rootScope, idsFactory, fromPatternId;
  return regenerator_default.a.wrap(function goToCreateDelivery$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          $state = Object(angular_accessor["b" /* default */])('$state');
          $rootScope = Object(angular_accessor["b" /* default */])('$rootScope');
          idsFactory = Object(angular_accessor["b" /* default */])('Ids');
          fromPatternId = idsFactory.toInternalId(action.payload);
          $state.go('deliveryCreate', {
            fromPatternId: fromPatternId
          });
          $rootScope.$digest();

        case 6:
        case "end":
          return _context4.stop();
      }
    }
  }, delivery_pattern_sagas_marked4);
}

function delivery_pattern_sagas_cancelCreate() {
  var $window;
  return regenerator_default.a.wrap(function cancelCreate$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          $window = Object(angular_accessor["b" /* default */])('$window');
          $window.history.back();
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(createCancelled());

        case 6:
        case "end":
          return _context5.stop();
      }
    }
  }, delivery_pattern_sagas_marked5);
}

function delivery_pattern_sagas_searchDeliveryPatterns() {
  var folderId, filter, list;
  return regenerator_default.a.wrap(function searchDeliveryPatterns$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.prev = 0;
          folderId = Object(angular_accessor["b" /* default */])('$stateParams').folderId;
          _context6.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.filter;
          });

        case 4:
          filter = _context6.sent;
          _context6.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(searchDeliveryPatterns, {
            title: filter,
            folderId: folderId
          });

        case 7:
          list = _context6.sent;
          _context6.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(listLoaded(list.map(function (d) {
            return {
              id: d.id,
              title: d.title,
              description: d.description,
              isEditable: delivery_pattern_sagas_isEditable(d),
              canCreateDelivery: delivery_pattern_sagas_canCreateDelivery(d),
              isCreateDeliveryDisabled: delivery_pattern_sagas_isCreateDeliveryDisabled(d)
            };
          })));

        case 10:
          _context6.next = 16;
          break;

        case 12:
          _context6.prev = 12;
          _context6.t0 = _context6["catch"](0);
          _context6.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(listFailed());

        case 16:
        case "end":
          return _context6.stop();
      }
    }
  }, delivery_pattern_sagas_marked6, null, [[0, 12]]);
}

function delivery_pattern_sagas_createDeliveryPattern() {
  var def, created;
  return regenerator_default.a.wrap(function createDeliveryPattern$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          _context7.prev = 0;
          _context7.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.form.model;
          });

        case 3:
          def = _context7.sent;
          def.folderId = Object(angular_accessor["b" /* default */])('$stateParams').folderId;
          _context7.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(createDeliveryPattern, def);

        case 7:
          created = _context7.sent;
          _context7.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryPatternCreated(created));

        case 10:
          _context7.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_pattern_actions_goToDetails(created.id));

        case 12:
          _context7.next = 17;
          break;

        case 14:
          _context7.prev = 14;
          _context7.t0 = _context7["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while creating delivery pattern...', _context7.t0);
          /* eslint-enable */

        case 17:
        case "end":
          return _context7.stop();
      }
    }
  }, delivery_pattern_sagas_marked7, null, [[0, 14]]);
}

function delivery_pattern_sagas_updateDeliveryPattern() {
  var $location, urlBeforeUpdate, def, updated;
  return regenerator_default.a.wrap(function updateDeliveryPattern$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          _context8.prev = 0;
          _context8.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$location');

        case 3:
          $location = _context8.sent;
          urlBeforeUpdate = $location.path();
          _context8.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.form.model;
          });

        case 7:
          def = _context8.sent;
          _context8.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateDeliveryPattern, def);

        case 10:
          updated = _context8.sent;
          _context8.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_sagas_updateBreadcrumbs, urlBeforeUpdate, updated);

        case 13:
          _context8.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 15:
          _context8.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(getAllPatterns);

        case 17:
          _context8.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryPatternUpdated(updated));

        case 19:
          _context8.next = 24;
          break;

        case 21:
          _context8.prev = 21;
          _context8.t0 = _context8["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while updating delivery pattern...', _context8.t0);
          /* eslint-enable */

        case 24:
        case "end":
          return _context8.stop();
      }
    }
  }, delivery_pattern_sagas_marked8, null, [[0, 21]]);
}

function removeDeliveryPattern(action) {
  return regenerator_default.a.wrap(function removeDeliveryPattern$(_context9) {
    while (1) {
      switch (_context9.prev = _context9.next) {
        case 0:
          _context9.prev = 0;
          _context9.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_deleteDeliveryPattern, action.payload);

        case 3:
          _context9.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryPatternDeleted(action.payload));

        case 5:
          _context9.next = 10;
          break;

        case 7:
          _context9.prev = 7;
          _context9.t0 = _context9["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while removing delivery pattern...', _context9.t0);
          /* eslint-enable */

        case 10:
        case "end":
          return _context9.stop();
      }
    }
  }, delivery_pattern_sagas_marked9, null, [[0, 7]]);
}

function delivery_pattern_sagas_resetDeliveryPattern() {
  var deliveryId, orig;
  return regenerator_default.a.wrap(function resetDeliveryPattern$(_context10) {
    while (1) {
      switch (_context10.prev = _context10.next) {
        case 0:
          _context10.prev = 0;
          _context10.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_pattern_actions_changePristine(true));

        case 3:
          _context10.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(function (state) {
            return state.deliveryPatterns.form.model.id;
          });

        case 5:
          deliveryId = _context10.sent;
          _context10.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_fetchDeliveryPattern, deliveryId);

        case 8:
          orig = _context10.sent;
          _context10.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 11:
          _context10.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(deliveryLoaded(delivery_pattern_sagas_objectSpread(delivery_pattern_sagas_objectSpread({}, orig), {}, {
            isEditable: delivery_pattern_sagas_isEditable(orig),
            canCreateDelivery: delivery_pattern_sagas_canCreateDelivery(orig)
          })));

        case 13:
          _context10.next = 18;
          break;

        case 15:
          _context10.prev = 15;
          _context10.t0 = _context10["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while resetting delivery pattern...', _context10.t0);
          /* eslint-enable */

        case 18:
        case "end":
          return _context10.stop();
      }
    }
  }, delivery_pattern_sagas_marked10, null, [[0, 15]]);
}

function duplicateDeliveryPattern(action) {
  var copied;
  return regenerator_default.a.wrap(function duplicateDeliveryPattern$(_context11) {
    while (1) {
      switch (_context11.prev = _context11.next) {
        case 0:
          _context11.prev = 0;
          _context11.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(copyDeliveryPattern, action.payload);

        case 3:
          copied = _context11.sent;
          _context11.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(delivery_pattern_actions_goToDetails(copied.id));

        case 6:
          _context11.next = 11;
          break;

        case 8:
          _context11.prev = 8;
          _context11.t0 = _context11["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error while duplicating delivery pattern...', _context11.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context11.stop();
      }
    }
  }, delivery_pattern_sagas_marked11, null, [[0, 8]]);
}

function setupConfirmLeavePopup(action) {
  return regenerator_default.a.wrap(function setupConfirmLeavePopup$(_context12) {
    while (1) {
      switch (_context12.prev = _context12.next) {
        case 0:
          if (action.payload) {
            _context12.next = 5;
            break;
          }

          _context12.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["a" /* addConfirmLeavePopup */]);

        case 3:
          _context12.next = 7;
          break;

        case 5:
          _context12.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 7:
        case "end":
          return _context12.stop();
      }
    }
  }, delivery_pattern_sagas_marked12);
}

function getAllPatterns() {
  var _all;

  return regenerator_default.a.wrap(function getAllPatterns$(_context13) {
    while (1) {
      switch (_context13.prev = _context13.next) {
        case 0:
          _context13.prev = 0;
          _context13.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(searchDeliveryPatterns);

        case 3:
          _all = _context13.sent;
          _context13.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(allPatternsLoaded(_all));

        case 6:
          _context13.next = 11;
          break;

        case 8:
          _context13.prev = 8;
          _context13.t0 = _context13["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error loading all patterns...', _context13.t0);
          /* eslint-enable */

        case 11:
        case "end":
          return _context13.stop();
      }
    }
  }, delivery_pattern_sagas_marked13, null, [[0, 8]]);
}

function validatePatternTitle(action) {
  var title, delivery;
  return regenerator_default.a.wrap(function validatePatternTitle$(_context14) {
    while (1) {
      switch (_context14.prev = _context14.next) {
        case 0:
          _context14.prev = 0;
          title = action.payload.title;

          if (!title) {
            _context14.next = 10;
            break;
          }

          _context14.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["e" /* delay */])(1000);

        case 5:
          _context14.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_service_fetchDeliveryPattern, title);

        case 7:
          delivery = _context14.sent;
          _context14.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(titleValidated(delivery));

        case 10:
          _context14.next = 15;
          break;

        case 12:
          _context14.prev = 12;
          _context14.t0 = _context14["catch"](0);

          /* eslint-disable no-console, angular/log */
          console.error('Error validating pattern title...', _context14.t0);
          /* eslint-enable */

        case 15:
        case "end":
          return _context14.stop();
      }
    }
  }, delivery_pattern_sagas_marked14, null, [[0, 12]]);
}

function delivery_pattern_sagas_combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context15) {
    while (1) {
      switch (_context15.prev = _context15.next) {
        case 0:
          _context15.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_FORM, delivery_pattern_sagas_deliveryPatternForm), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_DELIVERY_FORM, delivery_pattern_sagas_createDeliveryForm), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_CANCEL_REQUESTED, delivery_pattern_sagas_cancelCreate), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_CREATE_REQUESTED, delivery_pattern_sagas_createDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_DELETE_REQUESTED, removeDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_FILTER_CHANGE_REQUESTED, delivery_pattern_sagas_searchDeliveryPatterns), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_LOAD_REQUESTED, loadDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_DETAILS, flowView), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GO_TO_CREATE_DELIVERY, delivery_pattern_sagas_goToCreateDelivery), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_UPDATE_REQUESTED, delivery_pattern_sagas_updateDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_RESET_REQUESTED, delivery_pattern_sagas_resetDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_COPY_REQUESTED, duplicateDeliveryPattern), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_PRISTINE, setupConfirmLeavePopup), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_GET_ALL_REQUESTED, getAllPatterns), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(delivery_pattern_actions_actionTypes.DELIVERY_PATTERN_VALIDATE_TITLE_REQUESTED, validatePatternTitle)]);

        case 2:
        case "end":
          return _context15.stop();
      }
    }
  }, delivery_pattern_sagas_marked15);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/tracked-item.service.js


function tracked_item_service_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function tracked_item_service_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_item_service_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_item_service_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }


var tracked_item_service_API_URL = 'api/v1/delivery-patterns';
function tracked_item_service_createItem(deliveryId, item) {
  return Object(http["e" /* httpPOST */])("".concat(tracked_item_service_API_URL, "/").concat(deliveryId, "/tracked-items"), tracked_item_service_objectSpread(tracked_item_service_objectSpread({}, item), {}, {
    id: null,
    type: 'delivery.TrackedItem'
  })).then(function (res) {
    return res.data;
  });
}
function tracked_item_service_updateItem(item) {
  return Object(http["g" /* httpPUT */])("".concat(tracked_item_service_API_URL, "/").concat(item.id), item).then(function (res) {
    return res.data;
  });
}
function tracked_item_service_removeItem(itemId) {
  return Object(http["b" /* httpDELETE */])("".concat(tracked_item_service_API_URL, "/").concat(itemId)).then(function (res) {
    return res.data;
  });
}
function tracked_item_service_list(deliveryId) {
  return Object(http["c" /* httpGET */])("".concat(tracked_item_service_API_URL, "/").concat(deliveryId, "/tracked-items")).then(function (res) {
    return res.data;
  });
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/tracked-item.sagas.js


var tracked_item_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(refreshList),
    tracked_item_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(tracked_item_sagas_createOrUpdateItem),
    tracked_item_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(tracked_item_sagas_removeItem),
    tracked_item_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(tracked_item_sagas_list),
    tracked_item_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(trackedItemSagas);





var isConflict = function isConflict(exception) {
  return (exception.response || {}).status === 409;
};

function refreshList(deliveryId) {
  var trackedItems;
  return regenerator_default.a.wrap(function refreshList$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_list, deliveryId);

        case 2:
          trackedItems = _context.sent;
          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(setList(trackedItems));

        case 5:
        case "end":
          return _context.stop();
      }
    }
  }, tracked_item_sagas_marked);
} // -- SAGAS --


function tracked_item_sagas_createOrUpdateItem(action) {
  var _action$payload, trackedItem, deliveryId, updated, created;

  return regenerator_default.a.wrap(function createOrUpdateItem$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _action$payload = action.payload, trackedItem = _action$payload.trackedItem, deliveryId = _action$payload.deliveryId;
          _context2.prev = 1;

          if (!trackedItem.id) {
            _context2.next = 10;
            break;
          }

          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_updateItem, trackedItem);

        case 5:
          updated = _context2.sent;
          _context2.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(updatedTrackedItem(updated));

        case 8:
          _context2.next = 15;
          break;

        case 10:
          _context2.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_createItem, deliveryId, trackedItem);

        case 12:
          created = _context2.sent;
          _context2.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(addedTrackedItem(created));

        case 15:
          _context2.next = 25;
          break;

        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](1);

          if (!isConflict(_context2.t0)) {
            _context2.next = 24;
            break;
          }

          _context2.next = 22;
          return refreshList(deliveryId);

        case 22:
          _context2.next = 25;
          break;

        case 24:
          /* eslint-disable no-console, angular/log */
          console.error("Something went wrong while creating or updating tracking item...", _context2.t0);
          /* eslint-enable */

        case 25:
        case "end":
          return _context2.stop();
      }
    }
  }, tracked_item_sagas_marked2, null, [[1, 17]]);
}

function tracked_item_sagas_removeItem(action) {
  var id;
  return regenerator_default.a.wrap(function removeItem$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          id = action.payload;
          _context3.prev = 1;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(tracked_item_service_removeItem, id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(tracked_item_actions_removedTrackedItem(id));

        case 6:
          _context3.next = 16;
          break;

        case 8:
          _context3.prev = 8;
          _context3.t0 = _context3["catch"](1);

          if (!isConflict(_context3.t0)) {
            _context3.next = 15;
            break;
          }

          _context3.next = 13;
          return refreshList(deliveryId);

        case 13:
          _context3.next = 16;
          break;

        case 15:
          /* eslint-disable no-console, angular/log */
          console.error("Something went wrong while removing tracking item...", _context3.t0);
          /* eslint-enable */

        case 16:
        case "end":
          return _context3.stop();
      }
    }
  }, tracked_item_sagas_marked3, null, [[1, 8]]);
}

function tracked_item_sagas_list(action) {
  var deliveryId;
  return regenerator_default.a.wrap(function list$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          deliveryId = action.payload;
          _context4.next = 3;
          return refreshList(deliveryId);

        case 3:
        case "end":
          return _context4.stop();
      }
    }
  }, tracked_item_sagas_marked4);
}

function trackedItemSagas() {
  return regenerator_default.a.wrap(function trackedItemSagas$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(tracked_item_actions_actionTypes.TRACKED_ITEM_CREATE_OR_UPDATE, tracked_item_sagas_createOrUpdateItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(tracked_item_actions_actionTypes.TRACKED_ITEM_REMOVE, tracked_item_sagas_removeItem), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(tracked_item_actions_actionTypes.TRACKED_ITEM_FETCH_LIST, tracked_item_sagas_list)]);

        case 2:
        case "end":
          return _context5.stop();
      }
    }
  }, tracked_item_sagas_marked5);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/stage.sagas.js


var stage_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(refreshStages),
    stage_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(stage_sagas_list),
    stage_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(remove),
    stage_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(edit),
    stage_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(add),
    stage_sagas_marked6 = /*#__PURE__*/regenerator_default.a.mark(stageSagas);






var stage_sagas_Ids = Object(util_ids["a" /* default */])();
var stage_sagas_isConflict = function isConflict(exception) {
  return (exception.response || {}).status === 409;
};
function refreshStages(deliveryId) {
  var stages;
  return regenerator_default.a.wrap(function refreshStages$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(fetchStages, deliveryId);

        case 2:
          stages = _context.sent;
          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stagesLoaded(stages));

        case 5:
        case "end":
          return _context.stop();
      }
    }
  }, stage_sagas_marked);
}
function stage_sagas_list(action) {
  var stages;
  return regenerator_default.a.wrap(function list$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(fetchStages, action.payload);

        case 2:
          stages = _context2.sent;
          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stagesLoaded(stages));

        case 5:
        case "end":
          return _context2.stop();
      }
    }
  }, stage_sagas_marked2);
}
function remove(action) {
  var stageId;
  return regenerator_default.a.wrap(function remove$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          stageId = action.payload;
          _context3.prev = 1;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deleteStage, stageId);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stageDeleted(stageId));

        case 6:
          _context3.next = 15;
          break;

        case 8:
          _context3.prev = 8;
          _context3.t0 = _context3["catch"](1);

          if (!stage_sagas_isConflict(_context3.t0)) {
            _context3.next = 14;
            break;
          }

          return _context3.delegateYield(refreshStages(stage_sagas_Ids.getParentId(stageId)), "t1", 12);

        case 12:
          _context3.next = 15;
          break;

        case 14:
          throw _context3.t0;

        case 15:
        case "end":
          return _context3.stop();
      }
    }
  }, stage_sagas_marked3, null, [[1, 8]]);
}
function edit(action) {
  var _action$payload, id, title, updated;

  return regenerator_default.a.wrap(function edit$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _action$payload = action.payload, id = _action$payload.id, title = _action$payload.title;
          _context4.prev = 1;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateStage, id, title);

        case 4:
          updated = _context4.sent;
          _context4.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stageEdited(updated));

        case 7:
          _context4.next = 16;
          break;

        case 9:
          _context4.prev = 9;
          _context4.t0 = _context4["catch"](1);

          if (!stage_sagas_isConflict(_context4.t0)) {
            _context4.next = 15;
            break;
          }

          return _context4.delegateYield(refreshStages(stage_sagas_Ids.getParentId(id)), "t1", 13);

        case 13:
          _context4.next = 16;
          break;

        case 15:
          throw _context4.t0;

        case 16:
        case "end":
          return _context4.stop();
      }
    }
  }, stage_sagas_marked4, null, [[1, 9]]);
}
function add(action) {
  var _action$payload2, before, after, $stateParams, added;

  return regenerator_default.a.wrap(function add$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _action$payload2 = action.payload, before = _action$payload2.before, after = _action$payload2.after;
          _context5.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["a" /* asyncGetAngularService */], '$stateParams');

        case 3:
          $stateParams = _context5.sent;
          _context5.prev = 4;
          _context5.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(addStage, $stateParams.deliveryId, before, after);

        case 7:
          added = _context5.sent;
          _context5.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(stageAdded(added, before, after));

        case 10:
          _context5.next = 19;
          break;

        case 12:
          _context5.prev = 12;
          _context5.t0 = _context5["catch"](4);

          if (!stage_sagas_isConflict(_context5.t0)) {
            _context5.next = 18;
            break;
          }

          return _context5.delegateYield(refreshStages($stateParams.deliveryId), "t1", 16);

        case 16:
          _context5.next = 19;
          break;

        case 18:
          throw _context5.t0;

        case 19:
        case "end":
          return _context5.stop();
      }
    }
  }, stage_sagas_marked5, null, [[4, 12]]);
}
function stageSagas() {
  return regenerator_default.a.wrap(function stageSagas$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_LIST_REQUESTED, stage_sagas_list), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_DELETE_REQUESTED, remove), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_EDIT_REQUESTED, edit), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(stage_actions_actionTypes.STAGE_ADD_REQUESTED, add)]);

        case 2:
        case "end":
          return _context6.stop();
      }
    }
  }, stage_sagas_marked6);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/transition.sagas.js


function transition_sagas_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function transition_sagas_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { transition_sagas_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { transition_sagas_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var transition_sagas_marked = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_add),
    transition_sagas_marked2 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_edit),
    transition_sagas_marked3 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_remove),
    transition_sagas_marked4 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_addCondition),
    transition_sagas_marked5 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_updateCondition),
    transition_sagas_marked6 = /*#__PURE__*/regenerator_default.a.mark(transition_sagas_deleteCondition),
    transition_sagas_marked7 = /*#__PURE__*/regenerator_default.a.mark(toggleOperator),
    transition_sagas_marked8 = /*#__PURE__*/regenerator_default.a.mark(transitionSagas);









var transition_sagas_Ids = Object(util_ids["a" /* default */])();
var transition_sagas_getStages = function getStages(state) {
  return state.stages.list;
};
var getOperator = function getOperator(state, transitionId) {
  return state.stages.operators[transitionId];
};
function transition_sagas_add(action) {
  var stageId, added;
  return regenerator_default.a.wrap(function add$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          stageId = action.payload;
          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(addTransition, stageId);

        case 4:
          added = _context.sent;
          _context.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionAdded(added));

        case 7:
          _context.next = 16;
          break;

        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](1);

          if (!stage_sagas_isConflict(_context.t0)) {
            _context.next = 15;
            break;
          }

          return _context.delegateYield(refreshStages(transition_sagas_Ids.getParentId(stageId)), "t1", 13);

        case 13:
          _context.next = 16;
          break;

        case 15:
          throw _context.t0;

        case 16:
        case "end":
          return _context.stop();
      }
    }
  }, transition_sagas_marked, null, [[1, 9]]);
}
function transition_sagas_edit(action) {
  var _action$payload, id, title, stages, transition, updated;

  return regenerator_default.a.wrap(function edit$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _action$payload = action.payload, id = _action$payload.id, title = _action$payload.title;
          _context2.prev = 1;
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 4:
          stages = _context2.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === id;
          }).transition);
          transition.title = title;
          _context2.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 9:
          updated = _context2.sent;
          _context2.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 12:
          _context2.next = 21;
          break;

        case 14:
          _context2.prev = 14;
          _context2.t0 = _context2["catch"](1);

          if (!stage_sagas_isConflict(_context2.t0)) {
            _context2.next = 20;
            break;
          }

          return _context2.delegateYield(refreshStages(transition_sagas_Ids.getParentId(transition_sagas_Ids.getParentId(id))), "t1", 18);

        case 18:
          _context2.next = 21;
          break;

        case 20:
          /* eslint-disable no-console, angular/log */
          console.error("Edit transition title: something went wrong while updating transition...", _context2.t0);
          /* eslint-enable */

        case 21:
        case "end":
          return _context2.stop();
      }
    }
  }, transition_sagas_marked2, null, [[1, 14]]);
}
function transition_sagas_remove(action) {
  var id;
  return regenerator_default.a.wrap(function remove$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          id = action.payload;
          _context3.prev = 1;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(deleteTransition, id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionDeleted(id));

        case 6:
          _context3.next = 15;
          break;

        case 8:
          _context3.prev = 8;
          _context3.t0 = _context3["catch"](1);

          if (!stage_sagas_isConflict(_context3.t0)) {
            _context3.next = 14;
            break;
          }

          return _context3.delegateYield(refreshStages(transition_sagas_Ids.getParentId(transition_sagas_Ids.getParentId(id))), "t1", 12);

        case 12:
          _context3.next = 15;
          break;

        case 14:
          throw _context3.t0;

        case 15:
        case "end":
          return _context3.stop();
      }
    }
  }, transition_sagas_marked3, null, [[1, 8]]);
}
function transition_sagas_addCondition(action) {
  var _action$payload2, transitionId, groupId, stages, operator, transition, defaultCondition, innerGroup, rootGroup, _innerGroup, updated;

  return regenerator_default.a.wrap(function addCondition$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _action$payload2 = action.payload, transitionId = _action$payload2.transitionId, groupId = _action$payload2.groupId;
          _context4.prev = 1;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 4:
          stages = _context4.sent;
          _context4.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getOperator, transitionId);

        case 7:
          operator = _context4.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);
          defaultCondition = {
            id: null,
            type: conditionTypes.STATE
          };

          if (!groupId) {
            innerGroup = {
              id: null,
              type: conditionTypes.GROUP,
              operator: stage_reducer_inverseOperator(operator),
              conditions: [defaultCondition]
            };

            if (transition.conditions.length > 0) {
              transition.conditions[0].conditions.push(innerGroup);
            } else {
              transition.conditions.push({
                id: null,
                type: conditionTypes.GROUP,
                operator: operator,
                conditions: [innerGroup]
              });
            }
          } else {
            rootGroup = transition.conditions[0];
            _innerGroup = rootGroup.conditions.find(function (group) {
              return group.id === groupId;
            });

            _innerGroup.conditions.push(defaultCondition);
          }

          _context4.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 13:
          updated = _context4.sent;
          _context4.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 16:
          _context4.next = 25;
          break;

        case 18:
          _context4.prev = 18;
          _context4.t0 = _context4["catch"](1);

          if (!stage_sagas_isConflict(_context4.t0)) {
            _context4.next = 24;
            break;
          }

          return _context4.delegateYield(refreshStages(transition_sagas_Ids.getParentId(transition_sagas_Ids.getParentId(transitionId))), "t1", 22);

        case 22:
          _context4.next = 25;
          break;

        case 24:
          /* eslint-disable no-console, angular/log */
          console.error("Add condition: something went wrong while updating transition...", _context4.t0);
          /* eslint-enable */

        case 25:
        case "end":
          return _context4.stop();
      }
    }
  }, transition_sagas_marked4, null, [[1, 18]]);
}
function transition_sagas_updateCondition(action) {
  var _action$payload3, transitionId, conditionId, change, stages, transition, rootGroup, condition, updated;

  return regenerator_default.a.wrap(function updateCondition$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _action$payload3 = action.payload, transitionId = _action$payload3.transitionId, conditionId = _action$payload3.conditionId, change = _action$payload3.change;

          if (!(conditionId && (change.type || change.value))) {
            _context5.next = 25;
            break;
          }

          _context5.prev = 2;
          _context5.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 5:
          stages = _context5.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);
          rootGroup = transition.conditions[0];
          condition = rootGroup.conditions.flatMap(function (g) {
            return g.conditions;
          }).find(function (c) {
            return c.id === conditionId;
          });

          if (change.type) {
            Object.keys(condition).forEach(function (key) {
              if (key !== 'id') delete condition[key];
            });
            condition.type = change.type;
          }

          if (change.value) {
            condition.startDateOffset = change.value;
          }

          _context5.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 13:
          updated = _context5.sent;
          _context5.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 16:
          _context5.next = 25;
          break;

        case 18:
          _context5.prev = 18;
          _context5.t0 = _context5["catch"](2);

          if (!stage_sagas_isConflict(_context5.t0)) {
            _context5.next = 24;
            break;
          }

          return _context5.delegateYield(refreshStages(transition_sagas_Ids.getParentId(transition_sagas_Ids.getParentId(transitionId))), "t1", 22);

        case 22:
          _context5.next = 25;
          break;

        case 24:
          /* eslint-disable no-console, angular/log */
          console.error("Update condition: something went wrong while updating transition...", _context5.t0);
          /* eslint-enable */

        case 25:
        case "end":
          return _context5.stop();
      }
    }
  }, transition_sagas_marked5, null, [[2, 18]]);
}
function transition_sagas_deleteCondition(action) {
  var _action$payload4, transitionId, conditionId, stages, transition, rootGroup, updated;

  return regenerator_default.a.wrap(function deleteCondition$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _action$payload4 = action.payload, transitionId = _action$payload4.transitionId, conditionId = _action$payload4.conditionId;
          _context6.prev = 1;
          _context6.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 4:
          stages = _context6.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);
          rootGroup = transition.conditions[0];
          rootGroup.conditions = rootGroup.conditions.map(function (group) {
            return transition_sagas_objectSpread(transition_sagas_objectSpread({}, group), {}, {
              conditions: group.conditions.filter(function (c) {
                return c.id !== conditionId;
              })
            });
          }).filter(function (group) {
            return group.conditions.length !== 0;
          });
          _context6.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 10:
          updated = _context6.sent;
          _context6.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 13:
          _context6.next = 22;
          break;

        case 15:
          _context6.prev = 15;
          _context6.t0 = _context6["catch"](1);

          if (!stage_sagas_isConflict(_context6.t0)) {
            _context6.next = 21;
            break;
          }

          return _context6.delegateYield(refreshStages(transition_sagas_Ids.getParentId(transition_sagas_Ids.getParentId(transitionId))), "t1", 19);

        case 19:
          _context6.next = 22;
          break;

        case 21:
          /* eslint-disable no-console, angular/log */
          console.error("Delete condition: something went wrong while updating transition...", _context6.t0);
          /* eslint-enable */

        case 22:
        case "end":
          return _context6.stop();
      }
    }
  }, transition_sagas_marked6, null, [[1, 15]]);
}
function toggleOperator(action) {
  var transitionId, stages, operator, transition, rootGroup, updated;
  return regenerator_default.a.wrap(function toggleOperator$(_context7) {
    while (1) {
      switch (_context7.prev = _context7.next) {
        case 0:
          transitionId = action.payload;

          if (!transitionId) {
            _context7.next = 32;
            break;
          }

          _context7.prev = 2;
          _context7.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(transition_sagas_getStages);

        case 5:
          stages = _context7.sent;
          _context7.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getOperator, transitionId);

        case 8:
          operator = _context7.sent;
          transition = cloneDeep_default()(stages.find(function (s) {
            return s.transition && s.transition.id === transitionId;
          }).transition);

          if (!(transition.conditions.length > 0)) {
            _context7.next = 21;
            break;
          }

          rootGroup = transition.conditions[0];
          rootGroup.operator = stage_reducer_inverseOperator(operator);
          rootGroup.conditions.forEach(function (g) {
            g.operator = operator;
          });
          _context7.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(updateTransition, transition);

        case 16:
          updated = _context7.sent;
          _context7.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(transitionUpdated(updated));

        case 19:
          _context7.next = 23;
          break;

        case 21:
          _context7.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(conditionOperatorToggled(transitionId, operator));

        case 23:
          _context7.next = 32;
          break;

        case 25:
          _context7.prev = 25;
          _context7.t0 = _context7["catch"](2);

          if (!stage_sagas_isConflict(_context7.t0)) {
            _context7.next = 31;
            break;
          }

          return _context7.delegateYield(refreshStages(transition_sagas_Ids.getParentId(transition_sagas_Ids.getParentId(transitionId))), "t1", 29);

        case 29:
          _context7.next = 32;
          break;

        case 31:
          /* eslint-disable no-console, angular/log */
          console.error("Toggle operator: something went wrong while updating transition...", _context7.t0);
          /* eslint-enable */

        case 32:
        case "end":
          return _context7.stop();
      }
    }
  }, transition_sagas_marked7, null, [[2, 25]]);
}
function transitionSagas() {
  return regenerator_default.a.wrap(function transitionSagas$(_context8) {
    while (1) {
      switch (_context8.prev = _context8.next) {
        case 0:
          _context8.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_ADD_REQUESTED, transition_sagas_add), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_UPDATE_REQUESTED, transition_sagas_edit), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_DELETE_REQUESTED, transition_sagas_remove), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_ADD_CONDITION_REQUESTED, transition_sagas_addCondition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_UPDATE_CONDITION_REQUESTED, transition_sagas_updateCondition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_DELETE_CONDITION_REQUESTED, transition_sagas_deleteCondition), Object(redux_saga_effects_npm_proxy_esm["k" /* takeEvery */])(transition_actions_actionTypes.TRANSITION_TOGGLE_OPERATOR_REQUESTED, toggleOperator)]);

        case 2:
        case "end":
          return _context8.stop();
      }
    }
  }, transition_sagas_marked8);
}
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ducks/index.js







// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/deliveries.store.js



var deliveries_store_marked = /*#__PURE__*/regenerator_default.a.mark(deliveries_store_combinedSaga);

/* global window */




var deliveries_store_sagaMiddleware = Object(redux_saga_core_npm_proxy_esm["a" /* default */])();

function deliveries_store_combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(trackedItemSagas), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(delivery_pattern_sagas_combinedSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stageSagas), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(transitionSagas)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);

          /* eslint-disable no-console, angular/log */
          console.error('Release deliveries root saga:', _context.t0);
          /* eslint-enable */

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, deliveries_store_marked, null, [[1, 6]]);
}
/* eslint-disable no-underscore-dangle,angular/typecheck-object,angular/module-getter,lodash/prefer-lodash-typecheck */


var deliveries_store_composeEnhancers = (typeof window === "undefined" ? "undefined" : typeof_default()(window)) === 'object' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
  name: 'deliveries' // Specify extension’s options like name, actionsBlacklist, actionsCreators, serialize...

}) : redux["compose"];

function deliveries_store_configureStore(preloadedState) {
  var enhancer = deliveries_store_composeEnhancers(Object(redux["applyMiddleware"])(deliveries_store_sagaMiddleware));
  var store = Object(redux["createStore"])(Object(redux["combineReducers"])({
    trackedItems: tracked_item_reducer_trackedItems,
    deliveryPatterns: delivery_pattern_reducer_deliveryPatterns,
    stages: stage_reducer_stages
  }), preloadedState, enhancer);
  deliveries_store_sagaMiddleware.run(deliveries_store_combinedSaga);
  return store;
}

var deliveries_store_store = deliveries_store_configureStore();
/* eslint-enable no-underscore-dangle,angular/typecheck-object,angular/module-getter,lodash/prefer-lodash-typecheck */
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list-header.page.js






function delivery_pattern_list_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_list_header_page_DeliveryPatternListHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListHeaderPage, _Component);

  var _super = delivery_pattern_list_header_page_createSuper(DeliveryPatternListHeaderPage);

  function DeliveryPatternListHeaderPage() {
    classCallCheck_default()(this, DeliveryPatternListHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternListHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_pattern_list_header_container, {
        isCreateAllowed: this.props.isCreateAllowed
      }));
    }
  }]);

  return DeliveryPatternListHeaderPage;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-create-header.component.js






function delivery_pattern_create_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_create_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_create_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var delivery_pattern_create_header_component_DeliveryPatternCreateHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternCreateHeaderComponent, _Component);

  var _super = delivery_pattern_create_header_component_createSuper(DeliveryPatternCreateHeaderComponent);

  function DeliveryPatternCreateHeaderComponent() {
    classCallCheck_default()(this, DeliveryPatternCreateHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternCreateHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          disabled = _this$props.disabled,
          onCancel = _this$props.onCancel,
          onCreate = _this$props.onCreate;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_["Fragment"], null, /*#__PURE__*/external_React_default.a.createElement("h4", null, "Create delivery pattern"), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button cancel",
        onClick: onCancel
      }, "Cancel"), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary",
        disabled: disabled,
        onClick: onCreate
      }, "Create"), /*#__PURE__*/external_React_default.a.createElement(components["g" /* DocLink */], {
        section: "delivery-patterns.html"
      })));
    }
  }]);

  return DeliveryPatternCreateHeaderComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-create-header.container.js




var delivery_pattern_create_header_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    disabled: deliveryPatterns.form.pristine || !deliveryPatterns.form.valid
  };
};

var delivery_pattern_create_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCancel: function onCancel() {
      return dispatch(cancelCreate());
    },
    onCreate: function onCreate() {
      return dispatch(delivery_pattern_actions_createDeliveryPattern());
    }
  };
};

/* harmony default export */ var delivery_pattern_create_header_container = (Object(es["connect"])(delivery_pattern_create_header_container_mapStateToProps, delivery_pattern_create_header_container_mapDispatchToProps)(delivery_pattern_create_header_component_DeliveryPatternCreateHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-create-header.page.js






function delivery_pattern_create_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_create_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_create_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_create_header_page_DeliveryPatternListHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListHeaderPage, _Component);

  var _super = delivery_pattern_create_header_page_createSuper(DeliveryPatternListHeaderPage);

  function DeliveryPatternListHeaderPage() {
    classCallCheck_default()(this, DeliveryPatternListHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternListHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_pattern_create_header_container, null));
    }
  }]);

  return DeliveryPatternListHeaderPage;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-row.component.less
var delivery_pattern_row_component = __webpack_require__(888);
var delivery_pattern_row_component_default = /*#__PURE__*/__webpack_require__.n(delivery_pattern_row_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-row.component.less

            

var delivery_pattern_row_component_options = {};

delivery_pattern_row_component_options.insert = "head";
delivery_pattern_row_component_options.singleton = false;

var delivery_pattern_row_component_update = injectStylesIntoStyleTag_default()(delivery_pattern_row_component_default.a, delivery_pattern_row_component_options);



/* harmony default export */ var components_delivery_pattern_row_component = (delivery_pattern_row_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-row.component.js








function delivery_pattern_row_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_row_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_row_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_row_component_DeliveryPatternRowComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternRowComponent, _Component);

  var _super = delivery_pattern_row_component_createSuper(DeliveryPatternRowComponent);

  function DeliveryPatternRowComponent() {
    var _this;

    classCallCheck_default()(this, DeliveryPatternRowComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    defineProperty_default()(assertThisInitialized_default()(_this), "edit", function () {
      var _this$props = _this.props,
          onEdit = _this$props.onEdit,
          deliveryPattern = _this$props.deliveryPattern;
      onEdit(deliveryPattern.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "createDelivery", function (e) {
      e.stopPropagation();
      var _this$props2 = _this.props,
          onNewDelivery = _this$props2.onNewDelivery,
          deliveryPattern = _this$props2.deliveryPattern;
      onNewDelivery(deliveryPattern.id);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "delete", function (e) {
      e.stopPropagation();
      var _this$props3 = _this.props,
          onDelete = _this$props3.onDelete,
          deliveryPattern = _this$props3.deliveryPattern;
      onDelete(deliveryPattern);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "duplicate", function (e) {
      e.stopPropagation();
      var _this$props4 = _this.props,
          onCopy = _this$props4.onCopy,
          deliveryPattern = _this$props4.deliveryPattern;
      onCopy(deliveryPattern);
    });

    return _this;
  }

  createClass_default()(DeliveryPatternRowComponent, [{
    key: "render",
    value: function render() {
      var deliveryPattern = this.props.deliveryPattern;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "delivery-pattern-row",
        onClick: this.edit
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-xs-6",
        title: deliveryPattern.title
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "delivery-pattern-title"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon pattern-icon icon-l"
      }), /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "truncate"
      }, deliveryPattern.title))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "actions col-xs-6"
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "pull-right"
      }, deliveryPattern.isEditable && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link edit",
        onClick: this.edit
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, "Edit")), !deliveryPattern.isEditable && !deliveryPattern.canCreateDelivery && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link",
        onClick: this.edit
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon visibility-on-icon",
        title: "View"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, "View")), deliveryPattern.canCreateDelivery && /*#__PURE__*/external_React_default.a.createElement(components["c" /* ButtonWithPopover */], {
        buttonClassName: 'create-delivery',
        content: 'You require at least one stage to create a new delivery.',
        isDisabled: deliveryPattern.isCreateDeliveryDisabled,
        isTooltipVisible: deliveryPattern.isCreateDeliveryDisabled,
        label: /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "menu-item-icon xl-icon add-icon",
          title: "New delivery"
        }), /*#__PURE__*/external_React_default.a.createElement("span", {
          className: "action-label"
        }, "New delivery")),
        onActionClick: this.createDelivery,
        placement: 'bottom',
        showAsLink: true
      }), deliveryPattern.isEditable && /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link copy",
        onClick: this.duplicate
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon duplicate-icon",
        title: "Copy"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, "Copy")), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link delete",
        onClick: this.delete
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, "Delete"))))));
    }
  }]);

  return DeliveryPatternRowComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-duplicate-modal.component.js








function delivery_pattern_duplicate_modal_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_duplicate_modal_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_duplicate_modal_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_duplicate_modal_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_pattern_duplicate_modal_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_duplicate_modal_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_duplicate_modal_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var delivery_pattern_duplicate_modal_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Continue'
};
var delivery_pattern_duplicate_modal_component_nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the delivery pattern',
  required: true
};
var delivery_pattern_duplicate_modal_component_descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the delivery pattern',
  size: 'MEDIUM'
};

var delivery_pattern_duplicate_modal_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var delivery_pattern_duplicate_modal_component_DeliveryPatternDuplicateModalComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternDuplicateModalComponent, _Component);

  var _super = delivery_pattern_duplicate_modal_component_createSuper(DeliveryPatternDuplicateModalComponent);

  function DeliveryPatternDuplicateModalComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternDuplicateModalComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          onCancel = _this$props.onCancel,
          onContinue = _this$props.onContinue;
      var deliveryPattern = _this.state.deliveryPattern;

      switch (action) {
        case 'create':
          onContinue(deliveryPattern);
          break;

        case 'cancel':
          onCancel();
          break;

        default:
          throw 'Unknown action';
      }

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resetForm", function () {
      _this.setState({
        deliveryPattern: null
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onTitleChange", function (newTitle) {
      var deliveryPattern = _this.state.deliveryPattern;

      _this.setState({
        deliveryPattern: delivery_pattern_duplicate_modal_component_objectSpread(delivery_pattern_duplicate_modal_component_objectSpread({}, deliveryPattern), {}, {
          title: newTitle
        })
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescChange", function (newDescription) {
      var deliveryPattern = _this.state.deliveryPattern;

      _this.setState({
        deliveryPattern: delivery_pattern_duplicate_modal_component_objectSpread(delivery_pattern_duplicate_modal_component_objectSpread({}, deliveryPattern), {}, {
          description: newDescription
        })
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (isNameValid) {
      _this.isNameValid = isNameValid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescValidityChange", function (isDescValid) {
      _this.isDescValid = isDescValid;
    });

    _this.state = {
      deliveryPattern: null,
      prevModel: null
    };
    _this.isNameValid = null;
    _this.isDescValid = null;
    return _this;
  }

  createClass_default()(DeliveryPatternDuplicateModalComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isOpened = _this$props2.isOpened,
          modalTitle = _this$props2.modalTitle;
      var deliveryPattern = this.state.deliveryPattern;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, modalTitle);
      createButton.disabled = !this.isNameValid || !this.isDescValid;
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_pattern_duplicate_modal_component_cancelButton, createButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        show: isOpened,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: delivery_pattern_duplicate_modal_component_nameFormMetadata,
        model: deliveryPattern.title,
        onModelChange: this.onTitleChange,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [delivery_pattern_duplicate_modal_component_maxLengthValidator(delivery_pattern_duplicate_modal_component_nameFormMetadata.label, 255), Object(validators["c" /* reservedCharactersValidator */])(delivery_pattern_duplicate_modal_component_nameFormMetadata.label)]
      }), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: delivery_pattern_duplicate_modal_component_descriptionFormMetadata,
        model: deliveryPattern.description,
        onModelChange: this.onDescChange,
        onValidityChange: this.onDescValidityChange,
        validators: [delivery_pattern_duplicate_modal_component_maxLengthValidator(delivery_pattern_duplicate_modal_component_descriptionFormMetadata.label, 1024)]
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.deliveryPattern || props.model.title !== state.prevModel.title) {
        return delivery_pattern_duplicate_modal_component_objectSpread(delivery_pattern_duplicate_modal_component_objectSpread({}, state), {}, {
          deliveryPattern: props.model,
          prevModel: props.model
        });
      }

      return null;
    }
  }]);

  return DeliveryPatternDuplicateModalComponent;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./core/xlr-ui/app/react/components/no-data/no-data.js + 1 modules
var no_data = __webpack_require__(207);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-list.component.js








function delivery_pattern_list_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_list_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_list_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_list_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_pattern_list_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_list_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var delivery_pattern_list_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var delivery_pattern_list_component_DeliveryPatternListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListComponent, _Component);

  var _super = delivery_pattern_list_component_createSuper(DeliveryPatternListComponent);

  function DeliveryPatternListComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternListComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      var deliveryPattern = _this.state.deliveryPattern;

      if (action === 'delete') {
        _this.props.deleteDeliveryPattern(deliveryPattern.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function (deliveryPattern) {
      return _this.setState({
        deleteModalIsOpen: true,
        deliveryPattern: deliveryPattern
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDuplicateModal", function (deliveryPattern) {
      return _this.setState({
        duplicateModalIsOpen: true,
        deliveryPattern: delivery_pattern_list_component_objectSpread(delivery_pattern_list_component_objectSpread({}, deliveryPattern), {}, {
          title: _this.generateDeliveryPatternCopyTitle(deliveryPattern.title)
        })
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleDuplicateCancel", function () {
      _this.setState({
        duplicateModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleDuplicateContinue", function (deliveryPattern) {
      _this.props.onCopyDeliveryPattern(deliveryPattern);

      _this.setState({
        duplicateModalIsOpen: false
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      duplicateModalIsOpen: false,
      deliveryPattern: {
        id: null,
        title: null,
        description: null
      }
    };
    return _this;
  }

  createClass_default()(DeliveryPatternListComponent, [{
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$state = this.state,
          deleteModalIsOpen = _this$state.deleteModalIsOpen,
          deliveryPattern = _this$state.deliveryPattern;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Delete delivery pattern");
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [delivery_pattern_list_component_cancelButton, delivery_pattern_list_component_deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to delete delivery pattern ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, deliveryPattern.title), "."));
    }
  }, {
    key: "generateDeliveryPatternCopyTitle",
    value: function generateDeliveryPatternCopyTitle(title) {
      var regExp = /\(([0-9]+)\)$/;

      if (regExp.test(title)) {
        return title.replace(regExp, function (s, m1) {
          var nextNumber = parseInt(m1) + 1;
          return "(".concat(nextNumber, ")");
        });
      } else {
        return title + " (1)";
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          deliveryPatterns = _this$props.deliveryPatterns,
          onEditDeliveryPattern = _this$props.onEditDeliveryPattern,
          onNewDelivery = _this$props.onNewDelivery;
      var _this$state2 = this.state,
          duplicateModalIsOpen = _this$state2.duplicateModalIsOpen,
          deliveryPattern = _this$state2.deliveryPattern;
      var list = deliveryPatterns.map(function (item) {
        return /*#__PURE__*/external_React_default.a.createElement(delivery_pattern_row_component_DeliveryPatternRowComponent, {
          deliveryPattern: item,
          key: item.id,
          onCopy: _this2.showDuplicateModal,
          onDelete: _this2.showDeleteModal,
          onEdit: onEditDeliveryPattern,
          onNewDelivery: onNewDelivery
        });
      });
      return /*#__PURE__*/external_React_default.a.createElement(external_React_["Fragment"], null, this.renderDeleteModal(), /*#__PURE__*/external_React_default.a.createElement(delivery_pattern_duplicate_modal_component_DeliveryPatternDuplicateModalComponent, {
        isOpened: duplicateModalIsOpen,
        modalTitle: "Copy delivery pattern",
        model: deliveryPattern,
        onCancel: this.handleDuplicateCancel,
        onContinue: this.handleDuplicateContinue
      }), /*#__PURE__*/external_React_default.a.createElement("div", null, list, (!list || !list.length) && /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement(no_data["a" /* NoData */], {
        message: "No delivery patterns found."
      }))));
    }
  }]);

  return DeliveryPatternListComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list.container.js




var delivery_pattern_list_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    deliveryPatterns: deliveryPatterns.list
  };
};

var delivery_pattern_list_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCopyDeliveryPattern: function onCopyDeliveryPattern(deliveryPattern) {
      return dispatch(delivery_pattern_actions_copyDeliveryPattern(deliveryPattern));
    },
    onEditDeliveryPattern: function onEditDeliveryPattern(id) {
      return dispatch(delivery_pattern_actions_goToDetails(id));
    },
    onNewDelivery: function onNewDelivery(id) {
      return dispatch(goToCreateDelivery(id));
    },
    deleteDeliveryPattern: function deleteDeliveryPattern(id) {
      return dispatch(delivery_pattern_actions_deleteDeliveryPattern(id));
    }
  };
};

/* harmony default export */ var delivery_pattern_list_container = (Object(es["connect"])(delivery_pattern_list_container_mapStateToProps, delivery_pattern_list_container_mapDispatchToProps)(delivery_pattern_list_component_DeliveryPatternListComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-list.page.js






function delivery_pattern_list_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_list_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_list_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_list_page_DeliveryPatternListPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternListPage, _Component);

  var _super = delivery_pattern_list_page_createSuper(DeliveryPatternListPage);

  function DeliveryPatternListPage() {
    classCallCheck_default()(this, DeliveryPatternListPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternListPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_pattern_list_container, null));
    }
  }]);

  return DeliveryPatternListPage;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-form.component.less
var delivery_pattern_form_component = __webpack_require__(889);
var delivery_pattern_form_component_default = /*#__PURE__*/__webpack_require__.n(delivery_pattern_form_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-form.component.less

            

var delivery_pattern_form_component_options = {};

delivery_pattern_form_component_options.insert = "head";
delivery_pattern_form_component_options.singleton = false;

var delivery_pattern_form_component_update = injectStylesIntoStyleTag_default()(delivery_pattern_form_component_default.a, delivery_pattern_form_component_options);



/* harmony default export */ var components_delivery_pattern_form_component = (delivery_pattern_form_component_default.a.locals || {});
// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/functor.js



var functor_Functor = function Functor(v) {
  var _this = this;

  classCallCheck_default()(this, Functor);

  defineProperty_default()(this, "map", function (fn) {
    return new Functor(fn(_this.v));
  });

  defineProperty_default()(this, "identity", function () {
    return _this.v;
  });

  this.v = v;
};


// EXTERNAL MODULE: ./node_modules/pluralize/pluralize.js
var pluralize = __webpack_require__(55);
var pluralize_default = /*#__PURE__*/__webpack_require__.n(pluralize);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/components/duration-picker/duration-picker.js








function duration_picker_createSuper(Derived) { var hasNativeReflectConstruct = duration_picker_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function duration_picker_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var inputNames = ['months', 'days', 'hours'];
var duration_picker_DurationPicker = /*#__PURE__*/function (_React$Component) {
  inherits_default()(DurationPicker, _React$Component);

  var _super = duration_picker_createSuper(DurationPicker);

  function DurationPicker(props) {
    var _this;

    classCallCheck_default()(this, DurationPicker);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleOnBlur", function (e) {
      if (!(e.relatedTarget !== null && inputNames.includes(e.relatedTarget.name) || document.activeElement !== null && inputNames.includes(document.activeElement.name))) {
        _this.switchMode(e, true);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleKeyDown", function (e) {
      if (e.key === 'Escape') {
        _this.switchMode(e);
      }

      if (e.key === 'Enter') {
        _this.switchMode(e, true);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleEnter", function (e) {
      if (e.key === 'Enter') {
        _this.switchMode(e);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "editMode", function () {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "duration-editor",
        style: styles.editStyle
      }, /*#__PURE__*/external_React_default.a.createElement("input", {
        autoFocus: true,
        name: "months",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.months
      }), /*#__PURE__*/external_React_default.a.createElement("label", {
        style: styles.labelStyle
      }, "months"), /*#__PURE__*/external_React_default.a.createElement("input", {
        name: "days",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.days
      }), /*#__PURE__*/external_React_default.a.createElement("label", {
        style: styles.labelStyle
      }, "days"), /*#__PURE__*/external_React_default.a.createElement("input", {
        name: "hours",
        onBlur: _this.handleOnBlur,
        onChange: _this.onChange,
        onKeyDown: _this.handleKeyDown,
        style: styles.inputStyle,
        type: "text",
        value: _this.state.hours
      }), /*#__PURE__*/external_React_default.a.createElement("label", {
        style: styles.labelStyle
      }, "hours"));
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "validateMinimum", function (name, value, min) {
      var measures = ['days', 'hours', 'months'];
      measures.splice(measures.indexOf(name), 1);
      var found = measures.find(function (m) {
        var val = _this.state[m];
        return val > 0 && val >= min[m];
      });
      return value > 0 && value >= min[name] || !!found;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onChange", function (evt) {
      var minHours = _this.props.minHours;
      var target = evt.target;
      var name = target.name;
      var value = target.value;
      var isMoreThanMin = value >= 0;

      if (minHours) {
        isMoreThanMin = _this.validateMinimum(name, value, mapHoursToValues(minHours));
      }

      if (isNumeric(value) && isMoreThanMin && value <= 99) {
        _this.setState(defineProperty_default()({}, name, Math.max(0, value)));
      } else if (value === '') {
        _this.setState(defineProperty_default()({}, name, ''));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "switchMode", function (evt) {
      var set = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var _this$props = _this.props,
          onModelChange = _this$props.onModelChange,
          onPristinityChange = _this$props.onPristinityChange;
      var flag = !_this.state.editMode;

      if (set) {
        var _extractValues = extractValues(_this.state),
            months = _extractValues.months,
            days = _extractValues.days,
            hours = _extractValues.hours;

        var rs = evaluateDuration(months, days, hours);
        onModelChange(rs);

        if (onPristinityChange) {
          onPristinityChange(rs === _this.state.originalValue);
        }

        _this.setState({
          editMode: flag
        });
      } else {
        var _mapHoursToValues = mapHoursToValues(_this.state.originalValue),
            _months = _mapHoursToValues.months,
            _days = _mapHoursToValues.days,
            _hours = _mapHoursToValues.hours;

        _this.setState({
          months: _months,
          days: _days,
          hours: _hours,
          editMode: flag
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "viewMode", function () {
      var _extractValues2 = extractValues(_this.state),
          months = _extractValues2.months,
          days = _extractValues2.days,
          hours = _extractValues2.hours;

      if (!months && !days && !hours) {
        var originals = mapHoursToValues(_this.state.originalValue);
        months = originals.months;
        days = originals.days;
        hours = originals.hours;
      }

      var view = new functor_Functor("").map(function (s) {
        return appendString(s, months, pluralize_default()('month', months));
      }).map(function (s) {
        return appendString(s, days, pluralize_default()('day', days));
      }).map(function (s) {
        return appendString(s, hours, pluralize_default()('hour', hours));
      }).map(function (s) {
        return _this.props.tip ? "".concat(s, " ").concat(_this.props.tip) : s;
      }).map(function (s) {
        return s === "" ? _this.props.placeholder || "Placeholder" : s;
      }).identity();
      return !_this.props.disabled ? /*#__PURE__*/external_React_default.a.createElement("input", {
        onClick: _this.switchMode,
        onKeyDown: _this.handleEnter,
        readOnly: true,
        style: styles.viewStyle,
        value: view
      }) : /*#__PURE__*/external_React_default.a.createElement("input", {
        readOnly: true,
        style: styles.viewDisabledStyle,
        value: view
      });
    });

    _this.state = {};
    return _this;
  }

  createClass_default()(DurationPicker, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          description = _this$props2.description,
          disabled = _this$props2.disabled,
          label = _this$props2.label;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components"
      }, label && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components-label"
      }, label), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components-input ".concat(disabled && 'is-disabled')
      }, this.state.editMode ? this.editMode() : this.viewMode(), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "xl-react-components-description"
      }, /*#__PURE__*/external_React_default.a.createElement("div", null, description))));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (props.hours !== state.originalValue) {
        var _mapHoursToValues2 = mapHoursToValues(props.hours),
            months = _mapHoursToValues2.months,
            days = _mapHoursToValues2.days,
            hours = _mapHoursToValues2.hours;

        return {
          originalValue: Number(props.hours),
          months: months,
          days: days,
          hours: hours,
          editMode: false
        };
      }

      return null;
    }
  }]);

  return DurationPicker;
}(external_React_default.a.Component);

function extractValues(state) {
  var months = state.months,
      days = state.days,
      hours = state.hours;
  return {
    months: defaultVal(months),
    days: defaultVal(days),
    hours: defaultVal(hours)
  };
}

function defaultVal(val) {
  return isNumeric(val) ? val : 0;
}

function isNumeric(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}

function mapHoursToValues(hours) {
  var m = Math.floor(hours / 720);
  var remainder = hours - m * 720;
  var d = Math.floor(remainder / 24);
  var h = hours - m * 720 - d * 24;
  return {
    months: m,
    days: d,
    hours: h
  };
}

function evaluateDuration(months, days, hours) {
  return months * 720 + days * 24 + hours;
}

function appendString(str, value, marker) {
  return value !== 0 ? "".concat(str, " ").concat(value, " ").concat(marker) : str;
}

var styles = {
  editStyle: {
    display: "flex",
    flexDirection: "row",
    flexWrap: "nowrap",
    alignItems: "center"
  },
  viewDisabledStyle: {
    backgroundColor: colors["a" /* default */].background,
    borderWidth: 1,
    borderStyle: "solid",
    borderColor: colors["a" /* default */].lightgray,
    borderRadius: 4,
    minHeight: 30,
    display: "flex",
    alignItems: "center",
    paddingLeft: 10,
    color: colors["a" /* default */].gray,
    fontSize: 12,
    width: "100%"
  },
  viewStyle: {
    borderWidth: 1,
    borderStyle: "solid",
    borderColor: colors["a" /* default */].gray,
    borderRadius: 4,
    minHeight: 30,
    display: "flex",
    alignItems: "center",
    paddingLeft: 10,
    color: colors["a" /* default */].gray,
    fontSize: 12,
    width: "100%"
  },
  labelStyle: {
    fontSize: 11,
    cursor: "default",
    marginBottom: 0
  },
  inputStyle: {
    marginLeft: 5,
    marginRight: 5,
    marginBottom: 0,
    minHeight: 30,
    minWidth: 40,
    width: 40,
    borderRadius: 4
  },
  buttonStyle: {
    marginLeft: 5,
    marginRight: 5,
    marginBottom: 0,
    marginTop: 0,
    minHeight: 30,
    minWidth: 50,
    width: 50,
    borderRadius: 4,
    fontSize: 11
  }
};
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-form.component.js








function delivery_pattern_form_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function delivery_pattern_form_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { delivery_pattern_form_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { delivery_pattern_form_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function delivery_pattern_form_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_form_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_form_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }









var delivery_pattern_form_component_nameFormMetadata = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the delivery pattern',
  required: true
};
var delivery_pattern_form_component_descriptionFormMetadata = {
  label: 'Description',
  placeholder: 'Set description...',
  description: 'Description of the delivery pattern',
  size: 'MEDIUM'
};

var delivery_pattern_form_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var delivery_pattern_form_component_DeliveryPatternFormComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternFormComponent, _Component);

  var _super = delivery_pattern_form_component_createSuper(DeliveryPatternFormComponent);

  function DeliveryPatternFormComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternFormComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "_handleKeyDown", function (e) {
      var _this$props = _this.props,
          model = _this$props.model,
          valid = _this$props.valid;

      if (e.key === 'Enter' && valid) {
        if (isEmpty_default()(model.id)) {
          _this.props.onCreate();
        } else {
          _this.props.onSave();
        }
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameValidityChange", function (valid) {
      _this.props.onValidationChange(valid);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNameChange", function (title) {
      var _this$props2 = _this.props,
          model = _this$props2.model,
          onFormChange = _this$props2.onFormChange,
          validateTitle = _this$props2.validateTitle;

      if (title !== model.title) {
        onFormChange(delivery_pattern_form_component_objectSpread(delivery_pattern_form_component_objectSpread({}, model), {}, {
          title: title
        }));
        validateTitle(model.id, title);
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescriptionChange", function (description) {
      var _this$props3 = _this.props,
          model = _this$props3.model,
          onFormChange = _this$props3.onFormChange;

      if (description !== model.description) {
        onFormChange(delivery_pattern_form_component_objectSpread(delivery_pattern_form_component_objectSpread({}, model), {}, {
          description: description
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDurationChange", function (plannedDuration) {
      var _this$props4 = _this.props,
          model = _this$props4.model,
          onFormChange = _this$props4.onFormChange;

      if (plannedDuration !== model.plannedDuration) {
        onFormChange(delivery_pattern_form_component_objectSpread(delivery_pattern_form_component_objectSpread({}, model), {}, {
          plannedDuration: plannedDuration
        }));
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onNamePristine", function (pristine) {
      _this.setState({
        namePristine: pristine
      });

      var _this$state = _this.state,
          descriptionPristine = _this$state.descriptionPristine,
          durationPristine = _this$state.durationPristine;
      var isFormPristine = pristine && descriptionPristine && durationPristine;

      _this.props.onPristineChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDescPristine", function (pristine) {
      _this.setState({
        descriptionPristine: pristine
      });

      var _this$state2 = _this.state,
          namePristine = _this$state2.namePristine,
          durationPristine = _this$state2.durationPristine;
      var isFormPristine = pristine && namePristine && durationPristine;

      _this.props.onPristineChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onDurationPristine", function (pristine) {
      _this.setState({
        durationPristine: pristine
      });

      var _this$state3 = _this.state,
          namePristine = _this$state3.namePristine,
          descriptionPristine = _this$state3.descriptionPristine;
      var isFormPristine = pristine && namePristine && descriptionPristine;

      _this.props.onPristineChange(isFormPristine);
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "findPatternTitleFromPatternList", function (patterns, deliveryId) {
      var pattern = patterns ? patterns.find(function (def) {
        return def.id === deliveryId;
      }) : null;
      return pattern ? pattern.title : '';
    });

    _this.state = {
      namePristine: true,
      descriptionPristine: true,
      durationPristine: true
    };
    return _this;
  }

  createClass_default()(DeliveryPatternFormComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props5 = this.props,
          delivery = _this$props5.delivery,
          onInit = _this$props5.onInit;

      if (delivery) {
        onInit(delivery);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.props.onPristineChange(true);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props6 = this.props,
          patterns = _this$props6.patterns,
          delivery = _this$props6.delivery,
          isEditable = _this$props6.isEditable,
          model = _this$props6.model,
          duplicatedDelivery = _this$props6.duplicatedDelivery;
      var isNew = isEmpty_default()(model.id);
      var isTitleValid = isEmpty_default()(duplicatedDelivery.id);

      var titleValidator = function titleValidator() {
        return {
          condition: !isTitleValid,
          message: Object(validators["a" /* createErrorMessage */])("Pattern already exists in ".concat(duplicatedDelivery.id && duplicatedDelivery.$metadata.details.folder))
        };
      };

      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "row",
        id: "delivery-pattern-form"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-sm-7"
      }, /*#__PURE__*/external_React_default.a.createElement("fieldset", null, /*#__PURE__*/external_React_default.a.createElement("legend", null, "Properties ", !isNew && /*#__PURE__*/external_React_default.a.createElement("span", null, "for ", this.findPatternTitleFromPatternList(patterns, delivery.id))), /*#__PURE__*/external_React_default.a.createElement("div", {
        onKeyDown: this._handleKeyDown
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: delivery_pattern_form_component_nameFormMetadata,
        model: model.title,
        onModelChange: this.onNameChange,
        onPristinityChange: this.onNamePristine,
        onValidityChange: this.onNameValidityChange,
        register: this.onRegister,
        validators: [delivery_pattern_form_component_maxLengthValidator(delivery_pattern_form_component_nameFormMetadata.label, 255), titleValidator, Object(validators["c" /* reservedCharactersValidator */])(delivery_pattern_form_component_nameFormMetadata.label)]
      })), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        disabled: !isEditable,
        metadata: delivery_pattern_form_component_descriptionFormMetadata,
        model: model.description,
        onModelChange: this.onDescriptionChange,
        onPristinityChange: this.onDescPristine,
        validators: [delivery_pattern_form_component_maxLengthValidator(delivery_pattern_form_component_descriptionFormMetadata.label, 1024)]
      }))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-sm-5"
      }, /*#__PURE__*/external_React_default.a.createElement("fieldset", null, /*#__PURE__*/external_React_default.a.createElement("legend", null, "Pattern details"), /*#__PURE__*/external_React_default.a.createElement(duration_picker_DurationPicker, {
        description: "Duration of the delivery pattern",
        disabled: !isEditable,
        hours: model.plannedDuration,
        label: "Duration",
        onModelChange: this.onDurationChange,
        onPristinityChange: this.onDurationPristine,
        placeholder: "Set duration..."
      }))));
    }
  }]);

  return DeliveryPatternFormComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-form.container.js




var delivery_pattern_form_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    isEditable: deliveryPatterns.form.editable,
    duplicatedDelivery: deliveryPatterns.form.duplicatedDelivery,
    model: deliveryPatterns.form.model,
    valid: deliveryPatterns.form.valid
  };
};

var delivery_pattern_form_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onPristineChange: function onPristineChange(pristine) {
      return dispatch(delivery_pattern_actions_changePristine(pristine));
    },
    onValidationChange: function onValidationChange(valid) {
      return dispatch(delivery_pattern_actions_changeValidation(valid));
    },
    onFormChange: function onFormChange(model) {
      return dispatch(delivery_pattern_actions_changeModel(model));
    },
    onInit: function onInit(pattern) {
      return dispatch(deliveryLoaded(pattern));
    },
    onCreate: function onCreate() {
      return dispatch(delivery_pattern_actions_createDeliveryPattern());
    },
    onSave: function onSave() {
      return dispatch(delivery_pattern_actions_updateDeliveryPattern());
    },
    validateTitle: function validateTitle(id, title) {
      return dispatch(delivery_pattern_actions_validateTitle(id, title));
    }
  };
};

/* harmony default export */ var delivery_pattern_form_container = (Object(es["connect"])(delivery_pattern_form_container_mapStateToProps, delivery_pattern_form_container_mapDispatchToProps)(delivery_pattern_form_component_DeliveryPatternFormComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-form.page.js






function delivery_pattern_form_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_form_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_form_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_form_page_DeliveryPatternFormPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternFormPage, _Component);

  var _super = delivery_pattern_form_page_createSuper(DeliveryPatternFormPage);

  function DeliveryPatternFormPage() {
    classCallCheck_default()(this, DeliveryPatternFormPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternFormPage, [{
    key: "render",
    value: function render() {
      var delivery = this.props.delivery;
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_pattern_form_container, {
        delivery: delivery
      }));
    }
  }]);

  return DeliveryPatternFormPage;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/ng/folders-delivery-patterns.js




var folders_delivery_patterns_template = "\n    <ng-switch on=\"$ctrl.getViewMode()\">\n        <div ng-switch-default style=\"height: 100%\">\n            <folder-details folder=\"$ctrl.folder\">\n                <header>\n                    <delivery-pattern-list-header class=\"folder-delivery-patterns-header\" is-create-allowed=\"$ctrl.isCreateAllowed\"/>\n                </header>\n                <content class=\"content-under-header form-content\">\n                    <delivery-pattern-list />\n                </content>\n            </folder-details>\n        </div>\n    \n        <div ng-switch-when=\"create\" style=\"height: 100%\">\n            <folder-details folder=\"$ctrl.folder\">\n                <header>\n                    <delivery-pattern-create-header class=\"folder-delivery-patterns-header\"/>\n                </header>\n                <content class=\"content-under-header form-content\">\n                    <delivery-pattern-form />\n                </content>\n            </folder-details>\n        </div>\n    </ng-switch>\n";

var folders_delivery_patterns_DeliveryPatternsController = /*#__PURE__*/function () {
  function DeliveryPatternsController($location, Authenticator) {
    classCallCheck_default()(this, DeliveryPatternsController);

    this._$location = $location;
    this._Authenticator = Authenticator;
  }

  createClass_default()(DeliveryPatternsController, [{
    key: "$onInit",
    value: function $onInit() {
      this.isCreateAllowed = this._Authenticator.hasPermission(DELIVERY_PATTERN_EDIT_PERMISSION, this.folder.$metadata);
    }
  }, {
    key: "getViewMode",
    value: function getViewMode() {
      var action = this._$location.search().action;

      if (!_.isUndefined(action) && action === 'create') {
        return 'create';
      } else {
        return 'list';
      }
    }
  }]);

  return DeliveryPatternsController;
}();

defineProperty_default()(folders_delivery_patterns_DeliveryPatternsController, "$inject", ['$location', 'Authenticator']);

var DeliveryPatternsComponent = {
  bindings: {
    folder: '<'
  },
  controller: folders_delivery_patterns_DeliveryPatternsController,
  template: folders_delivery_patterns_template
};
/* harmony default export */ var folders_delivery_patterns = (DeliveryPatternsComponent);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-row.less
var tracked_item_row = __webpack_require__(890);
var tracked_item_row_default = /*#__PURE__*/__webpack_require__.n(tracked_item_row);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-row.less

            

var tracked_item_row_options = {};

tracked_item_row_options.insert = "head";
tracked_item_row_options.singleton = false;

var tracked_item_row_update = injectStylesIntoStyleTag_default()(tracked_item_row_default.a, tracked_item_row_options);



/* harmony default export */ var tracked_items_tracked_item_row = (tracked_item_row_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-row.component.js






function tracked_item_row_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_row_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_row_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var tracked_item_row_component_TrackedItemRowComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemRowComponent, _Component);

  var _super = tracked_item_row_component_createSuper(TrackedItemRowComponent);

  function TrackedItemRowComponent() {
    classCallCheck_default()(this, TrackedItemRowComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(TrackedItemRowComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          onDelete = _this$props.onDelete,
          onEdit = _this$props.onEdit,
          trackedItem = _this$props.trackedItem;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "track-panel"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "col-xs-8 panel-data",
        title: trackedItem.title
      }, trackedItem.title), isEditable && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "actions col-xs-4"
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "pull-right"
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link color-inherited",
        onClick: function onClick() {
          return onEdit(trackedItem);
        }
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon edit-icon",
        title: "Edit"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, "Edit")), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link delete",
        onClick: function onClick() {
          return onDelete(trackedItem);
        }
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "action-label"
      }, "Delete")))));
    }
  }]);

  return TrackedItemRowComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-edit-modal.component.js








function tracked_items_tracked_item_edit_modal_component_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function tracked_items_tracked_item_edit_modal_component_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { tracked_items_tracked_item_edit_modal_component_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { tracked_items_tracked_item_edit_modal_component_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function tracked_item_edit_modal_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_edit_modal_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_edit_modal_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var tracked_item_edit_modal_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var tracked_item_edit_modal_component_nameOptions = {
  label: 'Name',
  description: 'Name of the tracked item',
  required: true
};

var tracked_items_tracked_item_edit_modal_component_nameValidator = function nameValidator(trackedItemList) {
  var id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  return function (title) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(trackedItemList, id, 'title', title),
      message: Object(validators["a" /* createErrorMessage */])('Tracked item already exists')
    };
  };
};

var tracked_items_tracked_item_edit_modal_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var tracked_items_tracked_item_edit_modal_component_TrackedItemEditModalComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemEditModalComponent, _Component);

  var _super = tracked_item_edit_modal_component_createSuper(TrackedItemEditModalComponent);

  function TrackedItemEditModalComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemEditModalComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          onCancel = _this$props.onCancel,
          onSave = _this$props.onSave;
      var trackedItem = _this.state.trackedItem;

      switch (action) {
        case 'update':
          onSave(trackedItem);
          break;

        case 'cancel':
          onCancel();
          break;

        default:
          throw 'Unknown action';
      }

      _this.resetForm();
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleModelChange", function (newTitle) {
      var trackedItem = _this.state.trackedItem;

      if (newTitle !== trackedItem.title) {
        _this.setState({
          trackedItem: tracked_items_tracked_item_edit_modal_component_objectSpread(tracked_items_tracked_item_edit_modal_component_objectSpread({}, trackedItem), {}, {
            title: newTitle
          })
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (valid) {
      _this.isValid = valid;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handlePristinityChange", function (pristine) {
      _this.isPristine = pristine;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "resetForm", function () {
      _this.setState({
        trackedItem: null
      });

      if (_this.componentApi) {
        _this.componentApi.resetPristinity();
      }
    });

    _this.state = {
      trackedItem: null,
      prevModel: null
    };
    _this.isPristine = null;
    _this.isValid = null;
    _this.componentApi = null;
    return _this;
  }

  createClass_default()(TrackedItemEditModalComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isOpened = _this$props2.isOpened,
          trackedItems = _this$props2.trackedItems;
      var trackedItem = this.state.trackedItem;
      var disableSaving = this.isPristine || !this.isValid;
      var updateButton = {
        action: 'update',
        className: 'button primary',
        disabled: disableSaving,
        keyCodes: [13],
        label: 'Save'
      };
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Edit tracked item");
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [tracked_item_edit_modal_component_cancelButton, updateButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        show: isOpened,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: tracked_item_edit_modal_component_nameOptions,
        model: trackedItem.title,
        onModelChange: this.handleModelChange,
        onPristinityChange: this.handlePristinityChange,
        onValidityChange: this.handleValidityChange,
        register: this.onRegister,
        validators: [tracked_items_tracked_item_edit_modal_component_nameValidator(trackedItems, trackedItem.id), tracked_items_tracked_item_edit_modal_component_maxLengthValidator(tracked_item_edit_modal_component_nameOptions.label, 255), Object(validators["c" /* reservedCharactersValidator */])(tracked_item_edit_modal_component_nameOptions.label)]
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      if (!state.trackedItem || props.model.title !== state.prevModel.title || props.model.title === state.prevModel.title && props.model.id !== state.prevModel.id) {
        return tracked_items_tracked_item_edit_modal_component_objectSpread(tracked_items_tracked_item_edit_modal_component_objectSpread({}, state), {}, {
          trackedItem: props.model,
          prevModel: props.model
        });
      }

      return null;
    }
  }]);

  return TrackedItemEditModalComponent;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-list.less
var tracked_item_list = __webpack_require__(891);
var tracked_item_list_default = /*#__PURE__*/__webpack_require__.n(tracked_item_list);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-list.less

            

var tracked_item_list_options = {};

tracked_item_list_options.insert = "head";
tracked_item_list_options.singleton = false;

var tracked_item_list_update = injectStylesIntoStyleTag_default()(tracked_item_list_default.a, tracked_item_list_options);



/* harmony default export */ var tracked_items_tracked_item_list = (tracked_item_list_default.a.locals || {});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./core/xlr-ui/app/react/styles/common.less
var common = __webpack_require__(892);
var common_default = /*#__PURE__*/__webpack_require__.n(common);

// CONCATENATED MODULE: ./core/xlr-ui/app/react/styles/common.less

            

var common_options = {};

common_options.insert = "head";
common_options.singleton = false;

var common_update = injectStylesIntoStyleTag_default()(common_default.a, common_options);



/* harmony default export */ var styles_common = (common_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-list.component.js








function tracked_item_list_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }










 // import {alertType, WidgetAlertMessage} from '../../shared/widgets/widget-alert-message';

var tracked_item_list_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var tracked_item_list_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var tracked_item_list_component_TrackedItemListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemListComponent, _Component);

  var _super = tracked_item_list_component_createSuper(TrackedItemListComponent);

  function TrackedItemListComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemListComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function (trackedItem) {
      return _this.setState({
        deleteModalIsOpen: true,
        trackedItem: trackedItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showEditModal", function (trackedItem) {
      return _this.setState({
        editModalIsOpen: true,
        trackedItem: trackedItem
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      var trackedItem = _this.state.trackedItem;

      if (action === 'delete') {
        _this.props.deleteTrackedItem(trackedItem.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditSave", function (trackedItem) {
      var _this$props = _this.props,
          saveTrackedItem = _this$props.saveTrackedItem,
          deliveryId = _this$props.deliveryId;
      saveTrackedItem(trackedItem, deliveryId);

      _this.setState({
        editModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleTrackedItemEditCancel", function () {
      _this.setState({
        editModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "closeModal", function () {
      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "renderTrackedItem", function (item) {
      return /*#__PURE__*/external_React_default.a.createElement(tracked_item_row_component_TrackedItemRowComponent, {
        isEditable: _this.props.isEditable,
        key: item.id,
        onDelete: _this.showDeleteModal,
        onEdit: _this.showEditModal,
        trackedItem: item
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      disabledUpdateButton: true,
      editModalIsOpen: false,
      trackedItem: {
        id: null,
        title: null
      }
    };
    return _this;
  }

  createClass_default()(TrackedItemListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.searchTrackedItems(this.props.deliveryId);
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var _this$state = this.state,
          deleteModalIsOpen = _this$state.deleteModalIsOpen,
          trackedItem = _this$state.trackedItem;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Delete tracked item", /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-close",
        onClick: this.closeModal,
        type: "button"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon close-icon"
      })));
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [tracked_item_list_component_cancelButton, tracked_item_list_component_deleteButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to delete tracked item ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, trackedItem.title), "."));
    }
  }, {
    key: "renderTrackedItems",
    value: function renderTrackedItems() {
      var _this$props2 = this.props,
          filter = _this$props2.filter,
          trackedItems = _this$props2.trackedItems;
      var list = trackedItems.filter(function (ti) {
        return ti.title.toLowerCase().includes(filter.toLowerCase());
      }).map(this.renderTrackedItem);
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "track-items"
      }, /*#__PURE__*/external_React_default.a.createElement("h4", {
        className: "page-title"
      }, "Tracked items (", list.length, ")"), /*#__PURE__*/external_React_default.a.createElement(components["j" /* HelpBlock */], {
        className: "help-message-container"
      }, "Tracked items can be components, features, services, changes, or other items that are part of your releases. You can add tracked items to a delivery to help you synchronize releases. Use ", /*#__PURE__*/external_React_default.a.createElement("strong", null, "Register Tracked Items"), " task to create the link."), list.length ? list : /*#__PURE__*/external_React_default.a.createElement("div", null, /*#__PURE__*/external_React_default.a.createElement(no_data["a" /* NoData */], {
        message: "No tracked items found."
      })));
    }
  }, {
    key: "render",
    value: function render() {
      var trackedItems = this.props.trackedItems;
      var _this$state2 = this.state,
          trackedItem = _this$state2.trackedItem,
          editModalIsOpen = _this$state2.editModalIsOpen;
      return /*#__PURE__*/external_React_default.a.createElement("div", null, this.renderDeleteModal(), /*#__PURE__*/external_React_default.a.createElement(tracked_items_tracked_item_edit_modal_component_TrackedItemEditModalComponent, {
        isOpened: editModalIsOpen,
        model: trackedItem,
        onCancel: this.handleTrackedItemEditCancel,
        onSave: this.handleTrackedItemEditSave,
        trackedItems: trackedItems
      }), /*#__PURE__*/external_React_default.a.createElement("div", null, this.renderTrackedItems()));
    }
  }]);

  return TrackedItemListComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item.container.js




var tracked_item_container_mapStateToProps = function mapStateToProps(state) {
  var trackedItems = state.trackedItems;
  return {
    filter: trackedItems.filter,
    trackedItems: trackedItems.list
  };
};

var tracked_item_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    deleteTrackedItem: function deleteTrackedItem(id) {
      return dispatch(tracked_item_actions_removeTrackedItem(id));
    },
    searchTrackedItems: function searchTrackedItems(deliveryId) {
      return dispatch(fetchTrackedItems(deliveryId));
    },
    saveTrackedItem: function saveTrackedItem(item, deliveryId) {
      return dispatch(tracked_item_actions_createOrUpdateTrackedItem(item, deliveryId));
    }
  };
};

/* harmony default export */ var tracked_item_container = (Object(es["connect"])(tracked_item_container_mapStateToProps, tracked_item_container_mapDispatchToProps)(tracked_item_list_component_TrackedItemListComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item.page.js






function tracked_item_page_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var tracked_item_page_TrackedItemsPage = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemsPage, _Component);

  var _super = tracked_item_page_createSuper(TrackedItemsPage);

  function TrackedItemsPage() {
    classCallCheck_default()(this, TrackedItemsPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(TrackedItemsPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(tracked_item_container, {
        deliveryId: this.props.deliveryId,
        isEditable: this.props.isEditable
      }));
    }
  }]);

  return TrackedItemsPage;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/styles/modal.less
var modal = __webpack_require__(387);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/tracked-items/tracked-item-header.component.js








function tracked_item_header_component_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var tracked_item_header_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};
var tracked_item_header_component_createButton = {
  action: 'create',
  className: 'button primary',
  keyCodes: [13],
  label: 'Create'
};
var tracked_item_header_component_nameOptions = {
  label: 'Name',
  placeholder: 'Add...',
  description: 'Name of the tracked item',
  required: true
};

var tracked_item_header_component_nameValidator = function nameValidator(trackedItemList) {
  return function (title) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(trackedItemList, null, 'title', title),
      message: Object(validators["a" /* createErrorMessage */])('Tracked item already existing')
    };
  };
};

var tracked_item_header_component_maxLengthValidator = function maxLengthValidator(filedLabel, maxLength) {
  return function (inputText) {
    return {
      condition: Object(validators["e" /* validateMaxLength */])(inputText, maxLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be ").concat(maxLength, " characters or less"))
    };
  };
};

var tracked_item_header_component_TrackedItemHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemHeaderComponent, _Component);

  var _super = tracked_item_header_component_createSuper(TrackedItemHeaderComponent);

  function TrackedItemHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, TrackedItemHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "onRegister", function (componentApi) {
      componentApi.focus();
      _this.componentApi = componentApi;
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCreate", function () {
      _this.setState({
        modalIsOpen: true
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleButtonClick", function (action) {
      var _this$props = _this.props,
          deliveryId = _this$props.deliveryId,
          onSave = _this$props.onSave;

      switch (action) {
        case 'create':
          onSave({
            title: _this.state.title
          }, deliveryId);

          _this.setState({
            modalIsOpen: _this.state.createAnother,
            title: ''
          });

          if (_this.state.createAnother) {
            _this.componentApi.resetPristinity();
          }

          break;

        case 'cancel':
          _this.setState({
            createAnother: false,
            title: '',
            modalIsOpen: false
          });

          break;

        default:
          throw 'Unknown action';
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onModelChange", function (title) {
      _this.setState({
        title: title
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onValidityChange", function (valid) {
      _this.setState({
        createButtonDisabled: !valid
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCheckboxClick", function (event) {
      _this.setState({
        createAnother: event.target.checked
      });
    });

    _this.state = {
      createAnother: false,
      createButtonDisabled: false,
      modalIsOpen: false,
      title: ''
    };
    _this.componentApi = null;
    return _this;
  }

  createClass_default()(TrackedItemHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          isEditable = _this$props2.isEditable,
          onFilterChange = _this$props2.onFilterChange,
          trackedItems = _this$props2.trackedItems;
      var _this$state = this.state,
          modalIsOpen = _this$state.modalIsOpen,
          createButtonDisabled = _this$state.createButtonDisabled;
      var filterOptions = {
        placeholder: 'Filter by tracked item...'
      };
      tracked_item_header_component_createButton.disabled = createButtonDisabled;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "New tracked item");
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        id: "header-tracked-items"
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetFilter"], {
        metadata: filterOptions,
        onUpdate: onFilterChange
      }), isEditable && /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "buttons"
      }, /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary",
        onClick: this.onCreate
      }, "Add tracked item"), /*#__PURE__*/external_React_default.a.createElement(components["g" /* DocLink */], {
        section: "delivery-patterns.html"
      })), /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [tracked_item_header_component_cancelButton, tracked_item_header_component_createButton],
        dialogClassName: "xl-default-modal",
        onButtonClick: this.handleButtonClick,
        onCheckboxClick: this.onCheckboxClick,
        show: modalIsOpen,
        skin: "checkbox",
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetString"], {
        metadata: tracked_item_header_component_nameOptions,
        model: this.state.title,
        onModelChange: this.onModelChange,
        onValidityChange: this.onValidityChange,
        register: this.onRegister,
        validators: [tracked_item_header_component_nameValidator(trackedItems), tracked_item_header_component_maxLengthValidator(tracked_item_header_component_nameOptions.label, 255), Object(validators["c" /* reservedCharactersValidator */])(tracked_item_header_component_nameOptions.label)]
      })));
    }
  }]);

  return TrackedItemHeaderComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item-header.container.js




var tracked_item_header_container_mapStateToProps = function mapStateToProps(state) {
  var trackedItems = state.trackedItems;
  return {
    filter: trackedItems.filter,
    trackedItems: trackedItems.list
  };
};

var tracked_item_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onFilterChange: function onFilterChange(filter) {
      return dispatch(changeFilter(filter));
    },
    onSave: function onSave(item, deliveryId) {
      return dispatch(tracked_item_actions_createOrUpdateTrackedItem(item, deliveryId));
    }
  };
};

/* harmony default export */ var tracked_item_header_container = (Object(es["connect"])(tracked_item_header_container_mapStateToProps, tracked_item_header_container_mapDispatchToProps)(tracked_item_header_component_TrackedItemHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/tracked-item-header.page.js






function tracked_item_header_page_createSuper(Derived) { var hasNativeReflectConstruct = tracked_item_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function tracked_item_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var tracked_item_header_page_TrackedItemHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(TrackedItemHeaderPage, _Component);

  var _super = tracked_item_header_page_createSuper(TrackedItemHeaderPage);

  function TrackedItemHeaderPage() {
    classCallCheck_default()(this, TrackedItemHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(TrackedItemHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(tracked_item_header_container, {
        deliveryId: this.props.deliveryId,
        isEditable: this.props.isEditable
      }));
    }
  }]);

  return TrackedItemHeaderPage;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-properties-header.component.js








function delivery_pattern_properties_header_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_properties_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_properties_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }





var delivery_pattern_properties_header_component_DeliveryPatternPropertiesHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternPropertiesHeaderComponent, _Component);

  var _super = delivery_pattern_properties_header_component_createSuper(DeliveryPatternPropertiesHeaderComponent);

  function DeliveryPatternPropertiesHeaderComponent(props) {
    var _this;

    classCallCheck_default()(this, DeliveryPatternPropertiesHeaderComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "reset", function () {
      var _this$props = _this.props,
          pristine = _this$props.pristine,
          onCancel = _this$props.onCancel;

      if (!pristine) {
        onCancel();
      }
    });

    return _this;
  }

  createClass_default()(DeliveryPatternPropertiesHeaderComponent, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          lastSaved = _this$props2.lastSaved,
          onSave = _this$props2.onSave,
          pristine = _this$props2.pristine,
          valid = _this$props2.valid;
      return /*#__PURE__*/external_React_default.a.createElement(external_React_["Fragment"], null, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "buttons"
      }, lastSaved && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "last-save-date"
      }, "Last saved on ", lastSaved), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button cancel",
        disabled: pristine,
        onClick: this.reset
      }, "Discard changes"), /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button primary",
        disabled: pristine || !valid,
        onClick: onSave
      }, "Save"), /*#__PURE__*/external_React_default.a.createElement(components["g" /* DocLink */], {
        section: "delivery-patterns.html"
      })));
    }
  }]);

  return DeliveryPatternPropertiesHeaderComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-properties-header.container.js




var delivery_pattern_properties_header_container_mapStateToProps = function mapStateToProps(state) {
  var deliveryPatterns = state.deliveryPatterns;
  return {
    lastSaved: deliveryPatterns.form.lastSaved,
    model: deliveryPatterns.form.model,
    pristine: deliveryPatterns.form.pristine,
    valid: deliveryPatterns.form.valid
  };
};

var delivery_pattern_properties_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onCancel: function onCancel() {
      return dispatch(resetDeliveryPattern());
    },
    onSave: function onSave() {
      return dispatch(delivery_pattern_actions_updateDeliveryPattern());
    }
  };
};

/* harmony default export */ var delivery_pattern_properties_header_container = (Object(es["connect"])(delivery_pattern_properties_header_container_mapStateToProps, delivery_pattern_properties_header_container_mapDispatchToProps)(delivery_pattern_properties_header_component_DeliveryPatternPropertiesHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-properties-header.page.js






function delivery_pattern_properties_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_properties_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_properties_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var delivery_pattern_properties_header_page_DeliveryPatternPropertiesHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternPropertiesHeaderPage, _Component);

  var _super = delivery_pattern_properties_header_page_createSuper(DeliveryPatternPropertiesHeaderPage);

  function DeliveryPatternPropertiesHeaderPage() {
    classCallCheck_default()(this, DeliveryPatternPropertiesHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternPropertiesHeaderPage, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(delivery_pattern_properties_header_container, null));
    }
  }]);

  return DeliveryPatternPropertiesHeaderPage;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage-list.component.less
var stage_list_component = __webpack_require__(893);
var stage_list_component_default = /*#__PURE__*/__webpack_require__.n(stage_list_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage-list.component.less

            

var stage_list_component_options = {};

stage_list_component_options.insert = "head";
stage_list_component_options.singleton = false;

var stage_list_component_update = injectStylesIntoStyleTag_default()(stage_list_component_default.a, stage_list_component_options);



/* harmony default export */ var stage_stage_list_component = (stage_list_component_default.a.locals || {});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/transition.component.less
var transition_component = __webpack_require__(894);
var transition_component_default = /*#__PURE__*/__webpack_require__.n(transition_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/transition.component.less

            

var transition_component_options = {};

transition_component_options.insert = "head";
transition_component_options.singleton = false;

var transition_component_update = injectStylesIntoStyleTag_default()(transition_component_default.a, transition_component_options);



/* harmony default export */ var transition_transition_component = (transition_component_default.a.locals || {});
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/condition-block.component.less
var condition_block_component = __webpack_require__(895);
var condition_block_component_default = /*#__PURE__*/__webpack_require__.n(condition_block_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/condition-block.component.less

            

var condition_block_component_options = {};

condition_block_component_options.insert = "head";
condition_block_component_options.singleton = false;

var condition_block_component_update = injectStylesIntoStyleTag_default()(condition_block_component_default.a, condition_block_component_options);



/* harmony default export */ var transition_condition_block_component = (condition_block_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/condition-block.component.js






function condition_block_component_createSuper(Derived) { var hasNativeReflectConstruct = condition_block_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function condition_block_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var condition_block_component_typeToValue = function typeToValue(type) {
  return conditionValueOpts[type];
};

var condition_block_component_valueToType = function valueToType(value) {
  return Object.keys(conditionValueOpts).find(function (key) {
    return conditionValueOpts[key] === value;
  });
};

var condition_block_component_ConditionBlockComponent = /*#__PURE__*/function (_React$Component) {
  inherits_default()(ConditionBlockComponent, _React$Component);

  var _super = condition_block_component_createSuper(ConditionBlockComponent);

  function ConditionBlockComponent(props) {
    classCallCheck_default()(this, ConditionBlockComponent);

    return _super.call(this, props);
  }

  createClass_default()(ConditionBlockComponent, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          group = _this$props.group,
          isEditable = _this$props.isEditable,
          onAdd = _this$props.onAdd,
          onChange = _this$props.onChange,
          onDelete = _this$props.onDelete,
          op = _this$props.op;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "condition-block"
      }, group.conditions && group.conditions.map(function (condition, idx) {
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "condition-wrapper",
          key: condition.id
        }, /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetAutocomplete"], {
          disabled: !isEditable,
          handlers: {
            addCandidates: function addCandidates() {
              return Promise.resolve(Object.values(conditionValueOpts).reduce(function (a, v) {
                a.push({
                  'id': v
                });
                return a;
              }, []));
            }
          },
          metadata: {
            placeholder: ''
          },
          model: conditionValueOpts[condition.type],
          onModelChange: function onModelChange(option) {
            if (condition_block_component_typeToValue(condition.type) !== option) {
              onChange(condition.id, {
                type: condition_block_component_valueToType(option)
              });
            }
          }
        }), isEditable && /*#__PURE__*/external_React_default.a.createElement("span", {
          className: "link delete-condition-btn",
          onClick: function onClick() {
            return onDelete(condition.id);
          }
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "menu-item-icon xl-icon delete-icon",
          title: "Delete"
        })), condition.type === conditionTypes.TIMED && /*#__PURE__*/external_React_default.a.createElement(duration_picker_DurationPicker, {
          disabled: !isEditable,
          hours: condition.startDateOffset,
          minHours: 1,
          onModelChange: function onModelChange(value) {
            return onChange(condition.id, {
              value: value
            });
          },
          placeholder: "Set schedule...",
          tip: "from delivery start date"
        }), group.conditions.length !== idx + 1 && /*#__PURE__*/external_React_default.a.createElement("div", {
          style: {
            width: '100%'
          }
        }, /*#__PURE__*/external_React_default.a.createElement("h4", {
          className: "condition-block-expr"
        }, /*#__PURE__*/external_React_default.a.createElement("span", null, op))));
      }), isEditable && /*#__PURE__*/external_React_default.a.createElement("p", {
        className: "add-condition-btn",
        onClick: function onClick() {
          return onAdd(group.id);
        }
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon icon-xl add-icon"
      }), " Add condition to this group"));
    }
  }]);

  return ConditionBlockComponent;
}(external_React_default.a.Component);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/transition/transition.component.js








function transition_component_createSuper(Derived) { var hasNativeReflectConstruct = transition_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function transition_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }










var transition_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var transition_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var transition_component_existenceValidator = function existenceValidator(filledlabel) {
  return function (inputText) {
    return {
      condition: Object(validators["d" /* validateExistence */])(inputText),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filledlabel, " must be set"))
    };
  };
};

var transition_component_minLengthValidator = function minLengthValidator(filledlabel, minLength) {
  return function (inputText) {
    return {
      condition: Object(validators["f" /* validateMinLength */])(inputText, minLength),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filledlabel, " must be set"))
    };
  };
};

var transition_component_actions = [{
  status: 'Completed',
  label: 'Move to next stage',
  iconClass: 'circle-check-icon'
}, {
  status: 'In progress',
  label: 'Mark as descoped',
  iconClass: 'progress-icon'
}, {
  status: 'Waiting',
  label: 'Mark as descoped',
  iconClass: 'pending-icon'
}];
var transition_component_TransitionComponent = /*#__PURE__*/function (_React$Component) {
  inherits_default()(TransitionComponent, _React$Component);

  var _super = transition_component_createSuper(TransitionComponent);

  function TransitionComponent(props) {
    var _this;

    classCallCheck_default()(this, TransitionComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFocusOut", function (title, rollback) {
      if (_this.state.isValid && title.trim() !== _this.props.model.title) {
        _this.props.onUpdate(_this.props.model.id, title);
      } else {
        rollback();

        _this.setState({
          isValid: true
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "handleValidityChange", function (isValid) {
      _this.setState({
        isValid: isValid
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      if (action === 'delete') {
        _this.props.onDelete(_this.props.model.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function () {
      return _this.setState({
        deleteModalIsOpen: true
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      isValid: true
    };
    return _this;
  }

  createClass_default()(TransitionComponent, [{
    key: "renderSlimView",
    value: function renderSlimView() {
      var onAdd = this.props.onAdd;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition-add"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "add-button",
        "data-cy": "btn-transition-add",
        onClick: onAdd
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon add-icon"
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "slim-main"
      }));
    }
  }, {
    key: "renderMainView",
    value: function renderMainView() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          model = _this$props.model,
          onAddCondition = _this$props.onAddCondition,
          onDeleteCondition = _this$props.onDeleteCondition,
          onToggleOperator = _this$props.onToggleOperator,
          onUpdateCondition = _this$props.onUpdateCondition,
          operator = _this$props.operator;
      var rootGroup = model.conditions.length > 0 ? model.conditions[0] : null;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "transition"
      }, this.renderDeleteModal(), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "main"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "header"
      }, /*#__PURE__*/external_React_default.a.createElement(components["h" /* EditableLabel */], {
        disabled: !isEditable,
        inputMaxLength: 255,
        inputWidth: "400px",
        labelClassName: "truncate",
        labelFontSize: "14px",
        labelFontWeight: "bold",
        onFocusOut: this.handleFocusOut,
        onValidityChange: this.handleValidityChange,
        required: true,
        text: model.title,
        validators: [transition_component_existenceValidator('Transition title'), Object(validators["c" /* reservedCharactersValidator */])('Transition title'), transition_component_minLengthValidator('Transition title', 1)]
      }), isEditable && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "pull-right"
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link",
        onClick: this.showDeleteModal
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      })))), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "scroll-container"
      }, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "content-wrapper"
      }, /*#__PURE__*/external_React_default.a.createElement("h4", null, "Conditions"), isEditable && /*#__PURE__*/external_React_default.a.createElement("p", null, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "condition-switch-label"
      }, "Toggle operator"), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "condition-switch-wrapper"
      }, "Groups", /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "condition-switch",
        onClick: function onClick() {
          return onToggleOperator(model.id);
        }
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "condition-op"
      }, operator), /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon change-icon"
      }), /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "condition-op"
      }, stage_reducer_inverseOperator(operator))), "Conditions")), rootGroup && rootGroup.conditions.map(function (group, idx) {
        return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, {
          key: idx
        }, /*#__PURE__*/external_React_default.a.createElement(condition_block_component_ConditionBlockComponent, {
          group: group,
          isEditable: isEditable,
          onAdd: function onAdd(groupId) {
            return onAddCondition(model.id, groupId);
          },
          onChange: function onChange(conditionId, type) {
            return onUpdateCondition(model.id, conditionId, type);
          },
          onDelete: function onDelete(conditionId) {
            return onDeleteCondition(model.id, conditionId);
          },
          op: stage_reducer_inverseOperator(operator)
        }), rootGroup.conditions.length !== idx + 1 && /*#__PURE__*/external_React_default.a.createElement("h4", {
          className: "condition-block-expr"
        }, operator));
      }), isEditable && /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "btn-add-condition-block",
        onClick: function onClick() {
          return onAddCondition(model.id);
        }
      }, /*#__PURE__*/external_React_default.a.createElement("span", null, "Add condition group"), /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon icon-xl add-icon"
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "cover"
      })), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "shadow"
      }), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "content-wrapper"
      }, /*#__PURE__*/external_React_default.a.createElement("h4", null, "Actions"), /*#__PURE__*/external_React_default.a.createElement("p", null, "Actions to execute after conditions defined above are satisfied"), transition_component_actions.map(function (action, idx) {
        return /*#__PURE__*/external_React_default.a.createElement("div", {
          className: "action",
          key: idx
        }, /*#__PURE__*/external_React_default.a.createElement("span", {
          className: "status"
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon ".concat(action.iconClass)
        }), action.status, " items"), /*#__PURE__*/external_React_default.a.createElement("span", {
          className: "type"
        }, action.label));
      })))));
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Delete transition");
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [transition_component_cancelButton, transition_component_deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to delete transition ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, this.props.model.title), "."));
    }
  }, {
    key: "render",
    value: function render() {
      return this.props.model ? this.renderMainView() : this.props.isEditable && this.renderSlimView();
    }
  }]);

  return TransitionComponent;
}(external_React_default.a.Component);
// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage.component.less
var stage_component = __webpack_require__(896);
var stage_component_default = /*#__PURE__*/__webpack_require__.n(stage_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage.component.less

            

var stage_component_options = {};

stage_component_options.insert = "head";
stage_component_options.singleton = false;

var stage_component_update = injectStylesIntoStyleTag_default()(stage_component_default.a, stage_component_options);



/* harmony default export */ var stage_stage_component = (stage_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage.component.js








function stage_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }









var stage_component_deleteButton = {
  action: 'delete',
  className: 'button primary',
  keyCodes: [13],
  label: 'Delete'
};
var stage_component_cancelButton = {
  action: 'cancel',
  className: 'button cancel',
  keyCodes: [27],
  label: 'Cancel'
};

var stage_component_existenceValidator = function existenceValidator(filedLabel) {
  return function (inputText) {
    return {
      condition: Object(validators["d" /* validateExistence */])(inputText),
      message: Object(validators["a" /* createErrorMessage */])("".concat(filedLabel, " must be set"))
    };
  };
};

var stage_component_nameValidator = function nameValidator(stageList, id) {
  return function (name) {
    return {
      condition: Object(validators["b" /* itemAlreadyDefined */])(stageList, id, 'title', name),
      message: Object(validators["a" /* createErrorMessage */])('Stage already exists')
    };
  };
};

var stage_component_PatternStageComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(PatternStageComponent, _Component);

  var _super = stage_component_createSuper(PatternStageComponent);

  function PatternStageComponent(props) {
    var _this;

    classCallCheck_default()(this, PatternStageComponent);

    _this = _super.call(this, props);

    defineProperty_default()(assertThisInitialized_default()(_this), "handleFocusOut", function (title, rollback) {
      if (_this.state.isValid && title.trim() !== _this.props.stage.title) {
        _this.props.onUpdate(_this.props.stage.id, title);
      } else {
        rollback();

        _this.setState({
          isValid: true
        });
      }
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "onCloseDeleteModal", function (action) {
      if (action === 'delete') {
        _this.props.onDelete(_this.props.stage.id);
      }

      _this.setState({
        deleteModalIsOpen: false
      });
    });

    defineProperty_default()(assertThisInitialized_default()(_this), "showDeleteModal", function () {
      return _this.setState({
        deleteModalIsOpen: true
      });
    });

    _this.state = {
      deleteModalIsOpen: false,
      isValid: true
    };
    return _this;
  }

  createClass_default()(PatternStageComponent, [{
    key: "handleValidityChange",
    value: function handleValidityChange(isValid) {
      this.setState({
        isValid: isValid
      });
    }
  }, {
    key: "renderDeleteModal",
    value: function renderDeleteModal() {
      var deleteModalIsOpen = this.state.deleteModalIsOpen;
      var modalHeader = /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, "Delete stage");
      return /*#__PURE__*/external_React_default.a.createElement(dist["XlReactWidgetConfirmationDialog"], {
        buttons: [stage_component_cancelButton, stage_component_deleteButton],
        dialogClassName: "xl-default-modal no-cross",
        onButtonClick: this.onCloseDeleteModal,
        show: deleteModalIsOpen,
        title: modalHeader
      }, /*#__PURE__*/external_React_default.a.createElement("p", null, "You are about to delete stage ", /*#__PURE__*/external_React_default.a.createElement("strong", {
        className: "wrap-text"
      }, this.props.stage.title), "."));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          stage = _this$props.stage;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "stage"
      }, this.renderDeleteModal(), /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "stage-title"
      }, /*#__PURE__*/external_React_default.a.createElement(components["h" /* EditableLabel */], {
        disabled: !isEditable,
        inputMaxLength: 255,
        inputWidth: "100%",
        labelClassName: "truncate",
        labelFontSize: "14px",
        labelFontWeight: "bold",
        onFocusOut: this.handleFocusOut,
        onValidityChange: this.handleValidityChange.bind(this),
        required: true,
        text: stage.title,
        validators: [stage_component_existenceValidator('Stage title'), stage_component_nameValidator(this.props.stages, stage.id), Object(validators["c" /* reservedCharactersValidator */])('Stage title')]
      }), isEditable && /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "stage-actions"
      }, /*#__PURE__*/external_React_default.a.createElement("span", {
        className: "link",
        onClick: this.showDeleteModal
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "menu-item-icon xl-icon delete-icon",
        title: "Delete"
      })))));
    }
  }]);

  return PatternStageComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage-list.component.js






function stage_list_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_list_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_list_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var stage_list_component_DefStageListComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DefStageListComponent, _Component);

  var _super = stage_list_component_createSuper(DefStageListComponent);

  function DefStageListComponent() {
    classCallCheck_default()(this, DefStageListComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DefStageListComponent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.props.getStages(this.props.deliveryId);
    }
  }, {
    key: "renderStages",
    value: function renderStages() {
      var _this$props = this.props,
          isEditable = _this$props.isEditable,
          onAddStage = _this$props.onAddStage,
          onAddTransition = _this$props.onAddTransition,
          onAddCondition = _this$props.onAddCondition,
          onUpdateTransition = _this$props.onUpdateTransition,
          onUpdateCondition = _this$props.onUpdateCondition,
          onDeleteTransition = _this$props.onDeleteTransition,
          onDeleteCondition = _this$props.onDeleteCondition,
          onDeleteStage = _this$props.onDeleteStage,
          onToggleOperator = _this$props.onToggleOperator,
          onUpdateStage = _this$props.onUpdateStage,
          operators = _this$props.operators,
          stages = _this$props.stages;
      return stages.map(function (stage, key) {
        return /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, {
          key: stage.id
        }, isEditable && /*#__PURE__*/external_React_default.a.createElement("button", {
          className: "button add-stage in-between",
          onClick: function onClick() {
            return onAddStage(stage.id, (stages[key - 1] || {}).id);
          }
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xl add-icon"
        })), /*#__PURE__*/external_React_default.a.createElement(stage_component_PatternStageComponent, {
          isEditable: isEditable,
          onDelete: onDeleteStage,
          onUpdate: onUpdateStage,
          stage: stage,
          stages: stages
        }), stages.length !== key + 1 && /*#__PURE__*/external_React_default.a.createElement(transition_component_TransitionComponent, {
          isEditable: isEditable,
          model: stage.transition,
          onAdd: function onAdd() {
            return onAddTransition(stage.id);
          },
          onAddCondition: onAddCondition,
          onDelete: onDeleteTransition,
          onDeleteCondition: onDeleteCondition,
          onToggleOperator: onToggleOperator,
          onUpdate: function onUpdate(id, title) {
            return onUpdateTransition(id, stage.id, title);
          },
          onUpdateCondition: onUpdateCondition,
          operator: stage.transition && operators[stage.transition.id]
        }), isEditable && stages.length === key + 1 && /*#__PURE__*/external_React_default.a.createElement("button", {
          className: "button add-stage",
          "data-test": "add-stage-to-end",
          onClick: function onClick() {
            return onAddStage(null, stage.id);
          }
        }, /*#__PURE__*/external_React_default.a.createElement("i", {
          className: "xl-icon icon-xl add-icon"
        }), /*#__PURE__*/external_React_default.a.createElement("p", null, "Add stage")));
      });
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "stages"
      }, this.renderStages(), /*#__PURE__*/external_React_default.a.createElement("div", {
        style: {
          minWidth: '1px'
        }
      }));
    }
  }]);

  return DefStageListComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/stage-list.container.js





var stage_list_container_mapStateToProps = function mapStateToProps(state) {
  return {
    stages: state.stages.list,
    operators: state.stages.operators
  };
};

var stage_list_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    getStages: function getStages(deliveryId) {
      dispatch(loadStages(deliveryId));
    },
    onAddStage: function onAddStage(before, after) {
      dispatch(stage_actions_addStage(before, after));
    },
    onAddCondition: function onAddCondition(transitionId, groupId) {
      dispatch(addCondition(transitionId, groupId));
    },
    onAddTransition: function onAddTransition(stageId) {
      dispatch(transition_actions_addTransition(stageId));
    },
    onDeleteStage: function onDeleteStage(stageId) {
      dispatch(stage_actions_deleteStage(stageId));
    },
    onDeleteCondition: function onDeleteCondition(transitionId, conditionId) {
      dispatch(deleteCondition(transitionId, conditionId));
    },
    onDeleteTransition: function onDeleteTransition(transitionId) {
      dispatch(transition_actions_deleteTransition(transitionId));
    },
    onToggleOperator: function onToggleOperator(transitionId) {
      dispatch(toggleConditionOperator(transitionId));
    },
    onUpdateCondition: function onUpdateCondition(transitionId, conditionId, change) {
      dispatch(transition_actions_updateCondition(transitionId, conditionId, change));
    },
    onUpdateTransition: function onUpdateTransition(transitionId, stageId, title) {
      return dispatch(transition_actions_updateTransition(transitionId, stageId, title));
    },
    onUpdateStage: function onUpdateStage(stageId, title) {
      dispatch(editStage(stageId, title));
    }
  };
};

/* harmony default export */ var stage_list_container = (Object(es["connect"])(stage_list_container_mapStateToProps, stage_list_container_mapDispatchToProps)(stage_list_component_DefStageListComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-flow.page.js






function delivery_pattern_flow_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_flow_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_flow_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }








var delivery_pattern_flow_page_PatternFlowPage = /*#__PURE__*/function (_Component) {
  inherits_default()(PatternFlowPage, _Component);

  var _super = delivery_pattern_flow_page_createSuper(PatternFlowPage);

  function PatternFlowPage() {
    classCallCheck_default()(this, PatternFlowPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(PatternFlowPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          delivery = _this$props.delivery,
          isEditable = _this$props.isEditable;
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(external_React_default.a.Fragment, null, /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "def-flow-subheader"
      }, /*#__PURE__*/external_React_default.a.createElement("h4", {
        className: "page-title"
      }, "Delivery flow")), /*#__PURE__*/external_React_default.a.createElement(stage_list_container, {
        deliveryId: delivery.id,
        isEditable: isEditable
      })));
    }
  }]);

  return PatternFlowPage;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/stage/stage-list-header.component.js






function stage_list_header_component_createSuper(Derived) { var hasNativeReflectConstruct = stage_list_header_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function stage_list_header_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }






var stage_list_header_component_StageListHeaderComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(StageListHeaderComponent, _Component);

  var _super = stage_list_header_component_createSuper(StageListHeaderComponent);

  function StageListHeaderComponent() {
    classCallCheck_default()(this, StageListHeaderComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(StageListHeaderComponent, [{
    key: "renderAddStageButton",
    value: function renderAddStageButton() {
      var _this = this;

      return /*#__PURE__*/external_React_default.a.createElement("button", {
        className: "button",
        "data-cy": "btn-stage-add",
        onClick: function onClick() {
          return _this.props.onAddStage(null, (_this.props.stageList[_this.props.stageList.length - 1] || {}).id);
        },
        style: {
          marginRight: '15px'
        }
      }, "Add stage");
    }
  }, {
    key: "renderAddCreateDeliveryButton",
    value: function renderAddCreateDeliveryButton(isDisabled) {
      return /*#__PURE__*/external_React_default.a.createElement(components["c" /* ButtonWithPopover */], {
        buttonClassName: 'primary',
        content: 'You require at least one stage to create a new delivery.',
        isDisabled: isDisabled,
        isTooltipVisible: isDisabled,
        label: 'New delivery',
        onActionClick: this.props.onCreateDelivery,
        placement: 'bottom'
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          canAddStage = _this$props.canAddStage,
          canCreateDelivery = _this$props.canCreateDelivery,
          isCreateDeliveryDisabled = _this$props.isCreateDeliveryDisabled;
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "buttons"
      }, canAddStage && this.renderAddStageButton(), canCreateDelivery && this.renderAddCreateDeliveryButton(isCreateDeliveryDisabled), /*#__PURE__*/external_React_default.a.createElement(components["g" /* DocLink */], {
        section: "delivery-patterns.html"
      }));
    }
  }]);

  return StageListHeaderComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/stage-list-header.container.js





var stage_list_header_container_mapStateToProps = function mapStateToProps(state) {
  return {
    stageList: state.stages.list || [],
    isCreateDeliveryDisabled: state.stages.isCreateDeliveryDisabled
  };
};

var stage_list_header_container_mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onAddStage: function onAddStage(before, after) {
      return dispatch(stage_actions_addStage(before, after));
    },
    onCreateDelivery: function onCreateDelivery() {
      return dispatch(createDeliveryForm());
    }
  };
};

/* harmony default export */ var stage_list_header_container = (Object(es["connect"])(stage_list_header_container_mapStateToProps, stage_list_header_container_mapDispatchToProps)(stage_list_header_component_StageListHeaderComponent));
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/views/delivery-pattern-flow-header.page.js






function delivery_pattern_flow_header_page_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_flow_header_page_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_flow_header_page_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }







var delivery_pattern_flow_header_page_PatternFlowHeaderPage = /*#__PURE__*/function (_Component) {
  inherits_default()(PatternFlowHeaderPage, _Component);

  var _super = delivery_pattern_flow_header_page_createSuper(PatternFlowHeaderPage);

  function PatternFlowHeaderPage() {
    classCallCheck_default()(this, PatternFlowHeaderPage);

    return _super.apply(this, arguments);
  }

  createClass_default()(PatternFlowHeaderPage, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          canAddStage = _this$props.canAddStage,
          canCreateDelivery = _this$props.canCreateDelivery;
      return /*#__PURE__*/external_React_default.a.createElement(es["Provider"], {
        store: deliveries_store_store
      }, /*#__PURE__*/external_React_default.a.createElement(stage_list_header_container, {
        canAddStage: canAddStage,
        canCreateDelivery: canCreateDelivery
      }));
    }
  }]);

  return PatternFlowHeaderPage;
}(external_React_["Component"]);


// EXTERNAL MODULE: ./node_modules/mini-css-extract-plugin/dist/loader.js!./node_modules/css-loader/dist/cjs.js!./node_modules/less-loader/dist/cjs.js!./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-sub-header-label.component.less
var delivery_pattern_sub_header_label_component = __webpack_require__(897);
var delivery_pattern_sub_header_label_component_default = /*#__PURE__*/__webpack_require__.n(delivery_pattern_sub_header_label_component);

// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-sub-header-label.component.less

            

var delivery_pattern_sub_header_label_component_options = {};

delivery_pattern_sub_header_label_component_options.insert = "head";
delivery_pattern_sub_header_label_component_options.singleton = false;

var delivery_pattern_sub_header_label_component_update = injectStylesIntoStyleTag_default()(delivery_pattern_sub_header_label_component_default.a, delivery_pattern_sub_header_label_component_options);



/* harmony default export */ var components_delivery_pattern_sub_header_label_component = (delivery_pattern_sub_header_label_component_default.a.locals || {});
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/components/delivery-pattern-sub-header-label.component.js






function delivery_pattern_sub_header_label_component_createSuper(Derived) { var hasNativeReflectConstruct = delivery_pattern_sub_header_label_component_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = getPrototypeOf_default()(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = getPrototypeOf_default()(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return possibleConstructorReturn_default()(this, result); }; }

function delivery_pattern_sub_header_label_component_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }




var delivery_pattern_sub_header_label_component_DeliveryPatternSubHeaderLabelComponent = /*#__PURE__*/function (_Component) {
  inherits_default()(DeliveryPatternSubHeaderLabelComponent, _Component);

  var _super = delivery_pattern_sub_header_label_component_createSuper(DeliveryPatternSubHeaderLabelComponent);

  function DeliveryPatternSubHeaderLabelComponent() {
    classCallCheck_default()(this, DeliveryPatternSubHeaderLabelComponent);

    return _super.apply(this, arguments);
  }

  createClass_default()(DeliveryPatternSubHeaderLabelComponent, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/external_React_default.a.createElement("div", {
        className: "pattern-sub-header text-center"
      }, /*#__PURE__*/external_React_default.a.createElement("i", {
        className: "xl-icon pattern-icon"
      }), /*#__PURE__*/external_React_default.a.createElement("strong", null, "PATTERN"));
    }
  }]);

  return DeliveryPatternSubHeaderLabelComponent;
}(external_React_["Component"]);


// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/delivery-patterns/index.js
















/* harmony default export */ var web_include_delivery_patterns = (angular.module('xlrelease.deliveryPatterns', []).component('deliveryPatternListHeader', Object(react2angular["react2angular"])(delivery_pattern_list_header_page_DeliveryPatternListHeaderPage, ['isCreateAllowed'])).component('deliveryPatternList', Object(react2angular["react2angular"])(delivery_pattern_list_page_DeliveryPatternListPage)).component('deliveryPatternForm', Object(react2angular["react2angular"])(delivery_pattern_form_page_DeliveryPatternFormPage, ['delivery'])).component('deliveryPatternCreateHeader', Object(react2angular["react2angular"])(delivery_pattern_create_header_page_DeliveryPatternListHeaderPage)).component('folderDeliveryPatterns', folders_delivery_patterns).component('patternTrackedItems', Object(react2angular["react2angular"])(tracked_item_page_TrackedItemsPage, ['deliveryId', 'isEditable'])).component('patternTrackedItemsHeader', Object(react2angular["react2angular"])(tracked_item_header_page_TrackedItemHeaderPage, ['deliveryId', 'isEditable'])).component('deliveryPatternPropertiesHeader', Object(react2angular["react2angular"])(delivery_pattern_properties_header_page_DeliveryPatternPropertiesHeaderPage)).component('patternFlow', Object(react2angular["react2angular"])(delivery_pattern_flow_page_PatternFlowPage, ['delivery', 'isEditable'])).component('patternSubHeaderLabel', Object(react2angular["react2angular"])(delivery_pattern_sub_header_label_component_DeliveryPatternSubHeaderLabelComponent)).component('patternFlowHeader', Object(react2angular["react2angular"])(delivery_pattern_flow_header_page_PatternFlowHeaderPage, ['canAddStage', 'canCreateDelivery'])).config(['$stateProvider', function ($stateProvider) {
  $stateProvider.state('deliveryPatternsDetails', {
    url: '/delivery-patterns/{deliveryId: DeliveryId}',
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return delivery_pattern_service_fetchDeliveryPattern($stateParams.deliveryId);
      }]
    }
  }).state('deliveryPatternsDetailsPageExtension', {
    url: '/delivery-patterns/{deliveryId: DeliveryId}/:extensionPath',
    template: delivery_details_page_extension_container,
    controller: deliveries_details_page_extension_controller_DeliveryDetailsPageExtensionController,
    controllerAs: 'deliveryDetailsPageExtension',
    resolve: {
      deliveryPromise: ['$stateParams', function ($stateParams) {
        return delivery_pattern_service_fetchDeliveryPattern($stateParams.deliveryId);
      }]
    }
  });
}]).name);
// CONCATENATED MODULE: ./modules/xlr-release-delivery-module/src/main/resources/web/include/index.js






/***/ }),

/***/ 3014:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/react2angular/index.js
var react2angular = __webpack_require__(44);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/classCallCheck.js
var classCallCheck = __webpack_require__(4);
var classCallCheck_default = /*#__PURE__*/__webpack_require__.n(classCallCheck);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/createClass.js
var createClass = __webpack_require__(5);
var createClass_default = /*#__PURE__*/__webpack_require__.n(createClass);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/inherits.js
var inherits = __webpack_require__(11);
var inherits_default = /*#__PURE__*/__webpack_require__.n(inherits);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js
var possibleConstructorReturn = __webpack_require__(10);
var possibleConstructorReturn_default = /*#__PURE__*/__webpack_require__.n(possibleConstructorReturn);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/getPrototypeOf.js
var getPrototypeOf = __webpack_require__(8);
var getPrototypeOf_default = /*#__PURE__*/__webpack_require__.n(getPrototypeOf);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(0);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/react-redux/es/index.js + 22 modules
var es = __webpack_require__(19);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/typeof.js
var helpers_typeof = __webpack_require__(80);
var typeof_default = /*#__PURE__*/__webpack_require__.n(helpers_typeof);

// EXTERNAL MODULE: ./node_modules/redux/es/redux.js
var redux = __webpack_require__(50);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-core-npm-proxy.esm.js + 3 modules
var redux_saga_core_npm_proxy_esm = __webpack_require__(119);

// EXTERNAL MODULE: ./node_modules/@babel/runtime/regenerator/index.js
var regenerator = __webpack_require__(7);
var regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);

// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-effects-npm-proxy.esm.js + 1 modules
var redux_saga_effects_npm_proxy_esm = __webpack_require__(3);

// EXTERNAL MODULE: ./core/xlr-ui/app/js/util/toastrFactory.js
var toastrFactory = __webpack_require__(46);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/environment-actions.js
var actionTypes = {
  ENVIRONMENTS_SEARCH_REQUEST: 'envMgmt/ENVIRONMENTS_SEARCH_REQUEST',
  ENVIRONMENTS_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENTS_SEARCH_SUCCESS',
  ENVIRONMENTS_SEARCH_FAILURE: 'envMgmt/ENVIRONMENTS_SEARCH_FAILURE',
  ENVIRONMENT_ADD: 'envMgmt/ENVIRONMENT_ADD',
  ENVIRONMENT_EDIT: 'envMgmt/ENVIRONMENT_EDIT',
  ENVIRONMENT_DELETE_REQUEST: 'envMgmt/ENVIRONMENT_DELETE_REQUEST',
  ENVIRONMENT_DELETE_SUCCESS: 'envMgmt/ENVIRONMENT_DELETE_SUCCESS',
  ENVIRONMENT_DELETE_FAILURE: 'envMgmt/ENVIRONMENT_DELETE_FAILURE',
  INIT_ENVIRONMENT_LIST: 'envMgmt/INIT_ENVIRONMENT_LIST',
  INIT_ENVIRONMENT_LIST_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_LIST_SUCCESS',
  INIT_ENVIRONMENT_LIST_FAILURE: 'envMgmt/INIT_ENVIRONMENT_LIST_FAILURE',
  TITLE_FILTER_CHANGE: 'envMgmt/TITLE_FILTER_CHANGE',
  STAGE_FILTER_CHANGE: 'envMgmt/STAGE_FILTER_CHANGE'
};
var environment_actions_onAddEnvironment = function onAddEnvironment() {
  return {
    type: actionTypes.ENVIRONMENT_ADD
  };
};
var environment_actions_onEditEnvironment = function onEditEnvironment(environment) {
  return {
    type: actionTypes.ENVIRONMENT_EDIT,
    payload: environment
  };
};
var searchEnvironments = function searchEnvironments(_ref) {
  var title = _ref.title,
      stageTitle = _ref.stageTitle;
  return {
    type: actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
    payload: {
      title: title,
      stageTitle: stageTitle
    }
  };
};
var environment_actions_onDeleteEnvironment = function onDeleteEnvironment(environment) {
  return {
    type: actionTypes.ENVIRONMENT_DELETE_REQUEST,
    payload: environment
  };
};
var initEnvironmentList = function initEnvironmentList() {
  return {
    type: actionTypes.INIT_ENVIRONMENT_LIST
  };
};
var initEnvironmentListSuccess = function initEnvironmentListSuccess(environments, stages) {
  return {
    type: actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS,
    payload: {
      environments: environments,
      stages: stages
    }
  };
};
var titleFilterChange = function titleFilterChange(title) {
  return {
    type: actionTypes.TITLE_FILTER_CHANGE,
    payload: title
  };
};
var stageFilterChange = function stageFilterChange(stageTitle) {
  return {
    type: actionTypes.STAGE_FILTER_CHANGE,
    payload: stageTitle
  };
};
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/angular-accessor.js
var angular_accessor = __webpack_require__(26);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/environment-service.js
var environment_service = __webpack_require__(120);

// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/stage-service.js
var stage_service = __webpack_require__(143);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/environment-list-saga.js


var _marked = /*#__PURE__*/regenerator_default.a.mark(search),
    _marked2 = /*#__PURE__*/regenerator_default.a.mark(addEnvironment),
    _marked3 = /*#__PURE__*/regenerator_default.a.mark(editEnvironment),
    _marked4 = /*#__PURE__*/regenerator_default.a.mark(_deleteEnvironment),
    _marked5 = /*#__PURE__*/regenerator_default.a.mark(environment_list_saga_initEnvironmentList),
    _marked6 = /*#__PURE__*/regenerator_default.a.mark(environmentListSaga);







var toastr = Object(toastrFactory["a" /* default */])();
var getFilters = function getFilters(state) {
  return state.environmentList.filters;
};
function search(action) {
  var _action$payload, title, stageTitle, stage, environments;

  return regenerator_default.a.wrap(function search$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _action$payload = action.payload, title = _action$payload.title, stageTitle = _action$payload.stageTitle;
          stage = stageTitle || null;
          _context.prev = 2;
          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {
            title: title,
            stage: stage
          });

        case 5:
          environments = _context.sent;
          _context.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENTS_SEARCH_SUCCESS,
            payload: environments
          });

        case 8:
          _context.next = 14;
          break;

        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](2);
          _context.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENTS_SEARCH_FAILURE
          });

        case 14:
        case "end":
          return _context.stop();
      }
    }
  }, _marked, null, [[2, 10]]);
}
function addEnvironment() {
  var $state;
  return regenerator_default.a.wrap(function addEnvironment$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 2:
          $state = _context2.sent;
          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentCreate');

        case 5:
        case "end":
          return _context2.stop();
      }
    }
  }, _marked2);
}
function editEnvironment(action) {
  var $state;
  return regenerator_default.a.wrap(function editEnvironment$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 2:
          $state = _context3.sent;
          _context3.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentCreate', {
            environmentId: action.payload.id
          });

        case 5:
        case "end":
          return _context3.stop();
      }
    }
  }, _marked3);
}
function _deleteEnvironment(action) {
  var environment, currentFilter;
  return regenerator_default.a.wrap(function _deleteEnvironment$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          environment = action.payload;
          _context4.prev = 1;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["b" /* deleteEnvironment */], environment.id);

        case 4:
          _context4.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENT_DELETE_SUCCESS
          });

        case 6:
          _context4.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(toastr.success, "Environment [".concat(environment.title, "] deleted."));

        case 8:
          _context4.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getFilters);

        case 10:
          currentFilter = _context4.sent;
          _context4.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENTS_SEARCH_REQUEST,
            payload: currentFilter
          });

        case 13:
          _context4.next = 19;
          break;

        case 15:
          _context4.prev = 15;
          _context4.t0 = _context4["catch"](1);
          _context4.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.ENVIRONMENT_DELETE_FAILURE
          });

        case 19:
        case "end":
          return _context4.stop();
      }
    }
  }, _marked4, null, [[1, 15]]);
}
function environment_list_saga_initEnvironmentList() {
  var environments, stages;
  return regenerator_default.a.wrap(function initEnvironmentList$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _context5.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {
            title: '',
            stageTitle: ''
          });

        case 3:
          environments = _context5.sent;
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */]);

        case 6:
          stages = _context5.sent;
          _context5.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initEnvironmentListSuccess(environments, stages));

        case 9:
          _context5.next = 15;
          break;

        case 11:
          _context5.prev = 11;
          _context5.t0 = _context5["catch"](0);
          _context5.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: actionTypes.INIT_ENVIRONMENT_LIST_FAILURE
          });

        case 15:
        case "end":
          return _context5.stop();
      }
    }
  }, _marked5, null, [[0, 11]]);
}
function environmentListSaga() {
  return regenerator_default.a.wrap(function environmentListSaga$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENT_ADD, addEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENT_EDIT, editEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENT_DELETE_REQUEST, _deleteEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.ENVIRONMENTS_SEARCH_REQUEST, search), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(actionTypes.INIT_ENVIRONMENT_LIST, environment_list_saga_initEnvironmentList)]);

        case 2:
        case "end":
          return _context6.stop();
      }
    }
  }, _marked6);
}
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/slicedToArray.js
var slicedToArray = __webpack_require__(20);
var slicedToArray_default = /*#__PURE__*/__webpack_require__.n(slicedToArray);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/environment-form-actions.js
var environment_form_actions_actionTypes = {
  ENVIRONMENT_EDIT_SAVE_FORM: 'envMgmt/ENVIRONMENT_EDIT_SAVE_FORM',
  ENVIRONMENT_EDIT_CANCEL_FORM: 'envMgmt/ENVIRONMENT_EDIT_CANCEL_FORM',
  ENVIRONMENT_EDIT_CLEAN_FORM: 'envMgmt/ENVIRONMENT_EDIT_CLEAN_FORM',
  ENVIRONMENT_EDIT_VALID_FORM: 'envMgmt/ENVIRONMENT_EDIT_VALID_FORM',
  ENVIRONMENT_EDIT_PRISTINE_FORM: 'envMgmt/ENVIRONMENT_EDIT_PRISTINE_FORM',
  ENVIRONMENT_EDIT_CHANGE_FORM: 'envMgmt/ENVIRONMENT_EDIT_CHANGE_FORM',
  ENVIRONMENT_EDIT_CHECK_LEAVE: 'envMgmt/ENVIRONMENT_EDIT_CHECK_LEAVE',
  ENVIRONMENT_LOAD: 'envMgmt/ENVIRONMENT_LOAD',
  ENVIRONMENT_LOAD_SUCCESS: 'envMgmt/ENVIRONMENT_LOAD_SUCCESS',
  ENVIRONMENT_SEARCH: 'envMgmt/ENVIRONMENT_SEARCH',
  ENVIRONMENT_SEARCH_SUCCESS: 'envMgmt/ENVIRONMENT_SEARCH_SUCCESS',
  INIT_ENVIRONMENT_FORM: 'envMgmt/INIT_ENVIRONMENT_FORM',
  INIT_ENVIRONMENT_FORM_SUCCESS: 'envMgmt/INIT_ENVIRONMENT_FORM_SUCCESS',
  INIT_ENVIRONMENT_FORM_FAILURE: 'envMgmt/INIT_ENVIRONMENT_FORM_FAILURE'
};
var onFormChange = function onFormChange(environment) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM,
    payload: environment
  };
};
var onFormSave = function onFormSave(environment) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_SAVE_FORM,
    payload: environment
  };
};
var environment_form_actions_onFormCancel = function onFormCancel() {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM
  };
};
var onFormValidChange = function onFormValidChange(valid) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_VALID_FORM,
    payload: valid
  };
};
var onFormPristineChange = function onFormPristineChange(pristine) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM,
    payload: pristine
  };
};
var cleanEnvironment = function cleanEnvironment() {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE
  };
};
var loadEnvironment = function loadEnvironment(environmentId) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_LOAD,
    payload: environmentId
  };
};
var environment_form_actions_searchEnvironments = function searchEnvironments(title) {
  return {
    type: environment_form_actions_actionTypes.ENVIRONMENT_SEARCH,
    payload: title
  };
};
var initEnvironmentForm = function initEnvironmentForm(environmentId) {
  return {
    type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM,
    payload: environmentId
  };
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/stage-actions.js
var stage_actions_actionTypes = {
  STAGE_SEARCH: 'envMgmt/STAGE_SEARCH',
  STAGE_SEARCH_SUCCESS: 'envMgmt/STAGE_SEARCH_SUCCESS',
  STAGE_SEARCH_FAILURE: 'envMgmt/STAGE_SEARCH_FAILURE',
  DELETE_STAGE: 'envMgmt/STAGE_DELETE_STAGE',
  DELETE_STAGE_SUCCESS: 'envMgmt/DELETE_STAGE_SUCCESS',
  DELETE_STAGE_FAILURE: 'envMgmt/DELETE_STAGE_FAILURE',
  SAVE_STAGE: 'envMgmt/STAGE_SAVE_STAGE',
  SAVE_STAGE_SUCCESS: 'envMgmt/SAVE_STAGE_SUCCESS',
  SAVE_STAGE_FAILURE: 'envMgmt/SAVE_STAGE_FAILURE'
};
var searchStages = function searchStages(title) {
  return {
    type: stage_actions_actionTypes.STAGE_SEARCH,
    payload: title
  };
};
var deleteStage = function deleteStage(stage) {
  return {
    type: stage_actions_actionTypes.DELETE_STAGE,
    payload: stage
  };
};
var stage_actions_saveStage = function saveStage(stage) {
  return {
    type: stage_actions_actionTypes.SAVE_STAGE,
    payload: stage
  };
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/label-actions.js
var label_actions_actionTypes = {
  LABEL_SEARCH: 'envMgmt/LABEL_SEARCH',
  LABEL_SEARCH_SUCCESS: 'envMgmt/LABEL_SEARCH_SUCCESS',
  LABEL_SEARCH_FAILURE: 'envMgmt/LABEL_SEARCH_FAILURE',
  SAVE_LABEL: 'envMgmt/LABEL_SAVE_LABEL',
  SAVE_LABEL_SUCCESS: 'envMgmt/SAVE_LABEL_SUCCESS',
  SAVE_LABEL_FAILURE: 'envMgmt/SAVE_LABEL_FAILURE',
  DELETE_LABEL: 'envMgmt/DELETE_LABEL_LABEL',
  DELETE_LABEL_SUCCESS: 'envMgmt/DELETE_LABEL_SUCCESS',
  DELETE_LABEL_FAILURE: 'envMgmt/DELETE_LABEL_FAILURE'
};
var searchLabels = function searchLabels(title) {
  return {
    type: label_actions_actionTypes.LABEL_SEARCH,
    payload: title
  };
};
var label_actions_saveLabel = function saveLabel(envType) {
  return {
    type: label_actions_actionTypes.SAVE_LABEL,
    payload: envType
  };
};
var deleteLabel = function deleteLabel(envType) {
  return {
    type: label_actions_actionTypes.DELETE_LABEL,
    payload: envType
  };
};
// EXTERNAL MODULE: ./node_modules/lodash/isEmpty.js
var isEmpty = __webpack_require__(29);
var isEmpty_default = /*#__PURE__*/__webpack_require__.n(isEmpty);

// EXTERNAL MODULE: ./node_modules/lodash/map.js
var map = __webpack_require__(58);
var map_default = /*#__PURE__*/__webpack_require__.n(map);

// EXTERNAL MODULE: ./core/xlr-ui/app/react/utils/sagas.js
var sagas = __webpack_require__(70);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/environment-form-saga.js



var environment_form_saga_marked = /*#__PURE__*/regenerator_default.a.mark(save),
    environment_form_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(cancel),
    environment_form_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(environment_form_saga_initEnvironmentForm),
    environment_form_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(environment_form_saga_cleanEnvironment),
    environment_form_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(environmentFormSaga);











var cleanFormFields = {
  type: environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM
};
var environment_form_saga_toastr = Object(toastrFactory["a" /* default */])();
function save(action) {
  var $state, environment, environmentForm;
  return regenerator_default.a.wrap(function save$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 3:
          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 5:
          $state = _context.sent;
          environment = action.payload;
          environmentForm = {
            title: environment.title,
            stageId: environment.stage.id,
            description: environment.description,
            labelIds: map_default()(environment.labels, 'id')
          };

          if (!isEmpty_default()(environment.id)) {
            _context.next = 15;
            break;
          }

          _context.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["a" /* createEnvironment */], environmentForm);

        case 11:
          _context.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_form_saga_toastr.success, "Environment [".concat(environment.title, "] created"));

        case 13:
          _context.next = 19;
          break;

        case 15:
          _context.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["f" /* updateEnvironment */], environment.id, environmentForm);

        case 17:
          _context.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_form_saga_toastr.success, "Environment [".concat(environment.title, "] updated"));

        case 19:
          _context.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentList');

        case 21:
          _context.next = 27;
          break;

        case 23:
          _context.prev = 23;
          _context.t0 = _context["catch"](0);
          _context.next = 27;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(console.error, 'Environment form saga:', _context.t0);

        case 27:
          _context.prev = 27;
          _context.next = 30;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields);

        case 30:
          return _context.finish(27);

        case 31:
        case "end":
          return _context.stop();
      }
    }
  }, environment_form_saga_marked, null, [[0, 23, 27, 31]]);
}
function cancel() {
  var $state;
  return regenerator_default.a.wrap(function cancel$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context2.sent;
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'environmentList');

        case 7:
          _context2.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields);

        case 9:
        case "end":
          return _context2.stop();
      }
    }
  }, environment_form_saga_marked2);
}
function environment_form_saga_initEnvironmentForm(_ref) {
  var environmentId, _yield$all, _yield$all2, environments, environment, _environments;

  return regenerator_default.a.wrap(function initEnvironmentForm$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          environmentId = _ref.payload;
          _context3.prev = 1;

          if (!environmentId) {
            _context3.next = 13;
            break;
          }

          _context3.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {}), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["d" /* loadEnvironment */], environmentId)]);

        case 5:
          _yield$all = _context3.sent;
          _yield$all2 = slicedToArray_default()(_yield$all, 2);
          environments = _yield$all2[0];
          environment = _yield$all2[1];
          _context3.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
            payload: {
              environment: environment,
              environments: environments
            }
          });

        case 11:
          _context3.next = 18;
          break;

        case 13:
          _context3.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], {});

        case 15:
          _environments = _context3.sent;
          _context3.next = 18;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS,
            payload: {
              environments: _environments
            }
          });

        case 18:
          _context3.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(searchStages(null));

        case 20:
          _context3.next = 22;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(searchLabels(null));

        case 22:
          _context3.next = 28;
          break;

        case 24:
          _context3.prev = 24;
          _context3.t0 = _context3["catch"](1);
          _context3.next = 28;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_FAILURE
          });

        case 28:
        case "end":
          return _context3.stop();
      }
    }
  }, environment_form_saga_marked3, null, [[1, 24]]);
}
function environment_form_saga_cleanEnvironment() {
  return regenerator_default.a.wrap(function cleanEnvironment$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(cleanFormFields);

        case 4:
        case "end":
          return _context4.stop();
      }
    }
  }, environment_form_saga_marked4);
}
function environmentFormSaga() {
  return regenerator_default.a.wrap(function environmentFormSaga$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CANCEL_FORM, cancel), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_SAVE_FORM, save), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM, environment_form_saga_initEnvironmentForm), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM, sagas["a" /* addConfirmLeavePopup */]), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHECK_LEAVE, environment_form_saga_cleanEnvironment)]);

        case 2:
        case "end":
          return _context5.stop();
      }
    }
  }, environment_form_saga_marked5);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/stage-saga.js


var stage_saga_marked = /*#__PURE__*/regenerator_default.a.mark(_searchStages),
    stage_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(_saveStage),
    stage_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(_deleteStage),
    stage_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(stageSaga);






var stage_saga_toastr = Object(toastrFactory["a" /* default */])();
function _searchStages(action) {
  var stages;
  return regenerator_default.a.wrap(function _searchStages$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */], action.payload);

        case 3:
          stages = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.STAGE_SEARCH_SUCCESS,
            payload: stages
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.STAGE_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, stage_saga_marked, null, [[0, 8]]);
}
function _saveStage(action) {
  var stage;
  return regenerator_default.a.wrap(function _saveStage$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          stage = action.payload;
          _context2.prev = 1;

          if (!isEmpty_default()(stage.id)) {
            _context2.next = 9;
            break;
          }

          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["a" /* createStage */], stage);

        case 5:
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_saga_toastr.success, "Stage [".concat(stage.title, "] created"));

        case 7:
          _context2.next = 13;
          break;

        case 9:
          _context2.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["d" /* updateStage */], stage.id, stage);

        case 11:
          _context2.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_saga_toastr.success, "Stage [".concat(stage.title, "] updated"));

        case 13:
          _context2.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.SAVE_STAGE_SUCCESS
          });

        case 15:
          _context2.next = 21;
          break;

        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](1);
          _context2.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.SAVE_STAGE_FAILURE
          });

        case 21:
        case "end":
          return _context2.stop();
      }
    }
  }, stage_saga_marked2, null, [[1, 17]]);
}
function _deleteStage(action) {
  var stage;
  return regenerator_default.a.wrap(function _deleteStage$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          stage = action.payload;
          _context3.prev = 1;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["b" /* deleteStage */], stage.id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_saga_toastr.success, "Stage [".concat(stage.title, "] deleted"));

        case 6:
          _context3.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.DELETE_STAGE_SUCCESS
          });

        case 8:
          _context3.next = 14;
          break;

        case 10:
          _context3.prev = 10;
          _context3.t0 = _context3["catch"](1);
          _context3.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: stage_actions_actionTypes.DELETE_STAGE_FAILURE
          });

        case 14:
        case "end":
          return _context3.stop();
      }
    }
  }, stage_saga_marked3, null, [[1, 10]]);
}
function stageSaga() {
  return regenerator_default.a.wrap(function stageSaga$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(stage_actions_actionTypes.SAVE_STAGE, _saveStage), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(stage_actions_actionTypes.DELETE_STAGE, _deleteStage), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])([stage_actions_actionTypes.STAGE_SEARCH, stage_actions_actionTypes.DELETE_STAGE_SUCCESS, stage_actions_actionTypes.SAVE_STAGE_SUCCESS], _searchStages)]);

        case 2:
        case "end":
          return _context4.stop();
      }
    }
  }, stage_saga_marked4);
}
// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/label-service.js
var label_service = __webpack_require__(211);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/label-saga.js


var label_saga_marked = /*#__PURE__*/regenerator_default.a.mark(_searchLabels),
    label_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(_saveLabel),
    label_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(_deleteLabel),
    label_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(labelSaga);






var label_saga_toastr = Object(toastrFactory["a" /* default */])();
function _searchLabels(action) {
  var labels;
  return regenerator_default.a.wrap(function _searchLabels$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["c" /* searchLabels */], action.payload);

        case 3:
          labels = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.LABEL_SEARCH_SUCCESS,
            payload: labels
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.LABEL_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, label_saga_marked, null, [[0, 8]]);
}
function _saveLabel(action) {
  var envLabel;
  return regenerator_default.a.wrap(function _saveLabel$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          envLabel = action.payload;
          _context2.prev = 1;

          if (!isEmpty_default()(envLabel.id)) {
            _context2.next = 9;
            break;
          }

          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["a" /* createLabel */], envLabel);

        case 5:
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_saga_toastr.success, "Label [".concat(envLabel.title, "] created"));

        case 7:
          _context2.next = 13;
          break;

        case 9:
          _context2.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["d" /* updateLabel */], envLabel.id, envLabel);

        case 11:
          _context2.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_saga_toastr.success, "Label [".concat(envLabel.title, "] updated"));

        case 13:
          _context2.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.SAVE_LABEL_SUCCESS
          });

        case 15:
          _context2.next = 21;
          break;

        case 17:
          _context2.prev = 17;
          _context2.t0 = _context2["catch"](1);
          _context2.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.SAVE_LABEL_FAILURE
          });

        case 21:
        case "end":
          return _context2.stop();
      }
    }
  }, label_saga_marked2, null, [[1, 17]]);
}
function _deleteLabel(action) {
  var envLabel;
  return regenerator_default.a.wrap(function _deleteLabel$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          envLabel = action.payload;
          _context3.prev = 1;
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["b" /* deleteLabel */], envLabel.id);

        case 4:
          _context3.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_saga_toastr.success, "Label [".concat(envLabel.title, "] deleted"));

        case 6:
          _context3.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.DELETE_LABEL_SUCCESS
          });

        case 8:
          _context3.next = 14;
          break;

        case 10:
          _context3.prev = 10;
          _context3.t0 = _context3["catch"](1);
          _context3.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: label_actions_actionTypes.DELETE_LABEL_FAILURE
          });

        case 14:
        case "end":
          return _context3.stop();
      }
    }
  }, label_saga_marked3, null, [[1, 10]]);
}
function labelSaga() {
  return regenerator_default.a.wrap(function labelSaga$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(label_actions_actionTypes.SAVE_LABEL, _saveLabel), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(label_actions_actionTypes.DELETE_LABEL, _deleteLabel), Object(redux_saga_effects_npm_proxy_esm["m" /* throttle */])(200, [label_actions_actionTypes.LABEL_SEARCH, label_actions_actionTypes.SAVE_LABEL_SUCCESS, label_actions_actionTypes.DELETE_LABEL_SUCCESS], _searchLabels)]);

        case 2:
        case "end":
          return _context4.stop();
      }
    }
  }, label_saga_marked4);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/application-actions.js
var application_actions_actionTypes = {
  APPLICATION_SEARCH_REQUEST: 'envMgmt/APPLICATION_SEARCH_REQUEST',
  APPLICATION_SEARCH_SUCCESS: 'envMgmt/APPLICATION_SEARCH_SUCCESS',
  APPLICATION_SEARCH_FAILURE: 'envMgmt/APPLICATION_SEARCH_FAILURE',
  APPLICATION_GOTO_CREATE_PAGE: 'envMgmt/APPLICATION_GOTO_CREATE_PAGE',
  APPLICATION_GOTO_EDIT_PAGE: 'envMgmt/APPLICATION_GOTO_EDIT_PAGE',
  APPLICATION_DELETE_REQUEST: 'envMgmt/APPLICATION_DELETE_REQUEST',
  APPLICATION_DELETE_SUCCESS: 'envMgmt/APPLICATION_DELETE_SUCCESS',
  APPLICATION_DELETE_FAILURE: 'envMgmt/APPLICATION_DELETE_FAILURE',
  APPLICATION_FORM_CANCEL: 'envMgmt/APPLICATION_FORM_CANCEL',
  APPLICATION_FORM_CLEAN: 'envMgmt/APPLICATION_FORM_CLEAN',
  APPLICATION_FORM_INIT: 'envMgmt/APPLICATION_FORM_INIT',
  APPLICATION_FORM_FAILURE: 'envMgmt/APPLICATION_FORM_FAILURE',
  APPLICATION_LOAD_REQUEST: 'envMgmt/APPLICATION_LOAD_REQUEST',
  APPLICATION_LOAD_SUCCESS: 'envMgmt/APPLICATION_LOAD_SUCCESS',
  APPLICATION_ENV_LOAD_SUCCESS: 'envMgmt/APPLICATION_ENV_LOAD_SUCCESS',
  APPLICATION_STAGE_LOAD_SUCCESS: 'envMgmt/APPLICATION_STAGE_LOAD_SUCCESS',
  APPLICATION_LIST_LOAD_SUCCESS: 'envMgmt/APPLICATION_LIST_LOAD_SUCCESS',
  APPLICATION_FORM_UPDATE_MODEL: 'envMgmt/APPLICATION_FORM_UPDATE_MODEL',
  APPLICATION_FORM_PRISTINE: 'envMgmt/APPLICATION_FORM_PRISTINE',
  APPLICATION_SAVE_REQUEST: 'envMgmt/APPLICATION_SAVE_REQUEST',
  APPLICATION_SAVE_FAILURE: 'envMgmt/APPLICATION_SAVE_FAILURE'
};
var application_actions_applicationList = {
  searchApplications: function searchApplications(applicationName) {
    return {
      type: application_actions_actionTypes.APPLICATION_SEARCH_REQUEST,
      payload: applicationName
    };
  },
  goToCreatePage: function goToCreatePage() {
    return {
      type: application_actions_actionTypes.APPLICATION_GOTO_CREATE_PAGE
    };
  },
  goToEditPage: function goToEditPage(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_GOTO_EDIT_PAGE,
      payload: application
    };
  },
  deleteApplication: function deleteApplication(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_DELETE_REQUEST,
      payload: application
    };
  }
};
var applicationForm = {
  initForm: function initForm(applicationId) {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_INIT,
      payload: applicationId
    };
  },
  cancelForm: function cancelForm() {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_CANCEL
    };
  },
  saveApplication: function saveApplication(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_SAVE_REQUEST,
      payload: application
    };
  },
  updateModel: function updateModel(application) {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_UPDATE_MODEL,
      payload: application
    };
  },
  pristineFormChange: function pristineFormChange(pristine) {
    return {
      type: application_actions_actionTypes.APPLICATION_FORM_PRISTINE,
      payload: pristine
    };
  }
};
// EXTERNAL MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/application-service.js
var application_service = __webpack_require__(156);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/application-list-saga.js


var application_list_saga_marked = /*#__PURE__*/regenerator_default.a.mark(searchApplications),
    application_list_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(goToApplicationCreate),
    application_list_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(goToApplicationEdit),
    application_list_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(deleteApplication),
    application_list_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(applicationListSaga);






var application_list_saga_toastr = Object(toastrFactory["a" /* default */])();
function searchApplications(action) {
  var applications;
  return regenerator_default.a.wrap(function searchApplications$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["d" /* searchApp */], action.payload);

        case 3:
          applications = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_SEARCH_SUCCESS,
            payload: applications
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, application_list_saga_marked, null, [[0, 8]]);
}
function goToApplicationCreate() {
  var $state;
  return regenerator_default.a.wrap(function goToApplicationCreate$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_FORM_CLEAN
          });

        case 2:
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context2.sent;
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationCreate');

        case 7:
        case "end":
          return _context2.stop();
      }
    }
  }, application_list_saga_marked2);
}
function goToApplicationEdit(action) {
  var $state;
  return regenerator_default.a.wrap(function goToApplicationEdit$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_FORM_CLEAN
          });

        case 2:
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context3.sent;
          _context3.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationCreate', {
            applicationId: action.payload.id
          });

        case 7:
        case "end":
          return _context3.stop();
      }
    }
  }, application_list_saga_marked3);
}
function deleteApplication(action) {
  var application;
  return regenerator_default.a.wrap(function deleteApplication$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          application = action.payload;
          _context4.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["b" /* deleteApp */], application.id);

        case 4:
          _context4.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_DELETE_SUCCESS,
            payload: action.payload
          });

        case 6:
          _context4.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_list_saga_toastr.success, "Deleted application [".concat(application.title, "]"));

        case 8:
          _context4.next = 14;
          break;

        case 10:
          _context4.prev = 10;
          _context4.t0 = _context4["catch"](0);
          _context4.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_DELETE_FAILURE
          });

        case 14:
        case "end":
          return _context4.stop();
      }
    }
  }, application_list_saga_marked4, null, [[0, 10]]);
}
function applicationListSaga() {
  return regenerator_default.a.wrap(function applicationListSaga$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_GOTO_CREATE_PAGE, goToApplicationCreate);

        case 2:
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_GOTO_EDIT_PAGE, goToApplicationEdit);

        case 4:
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_DELETE_REQUEST, deleteApplication);

        case 6:
          _context5.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["m" /* throttle */])(200, application_actions_actionTypes.APPLICATION_SEARCH_REQUEST, searchApplications);

        case 8:
        case "end":
          return _context5.stop();
      }
    }
  }, application_list_saga_marked5);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/application-form-saga.js


var application_form_saga_marked = /*#__PURE__*/regenerator_default.a.mark(initApplicationForm),
    application_form_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(cancelApplicationForm),
    application_form_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(updateApplicationModel),
    application_form_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(saveApplication),
    application_form_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(applicationFormSaga);










var application_form_saga_toastr = Object(toastrFactory["a" /* default */])();
var application_form_saga_cleanFormFields = {
  type: application_actions_actionTypes.APPLICATION_FORM_CLEAN
};
function initApplicationForm(action) {
  var applicationId, application, environments, stages, applications;
  return regenerator_default.a.wrap(function initApplicationForm$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          applicationId = action.payload;

          if (isEmpty_default()(applicationId)) {
            _context.next = 8;
            break;
          }

          _context.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["c" /* getApp */], applicationId);

        case 5:
          application = _context.sent;
          _context.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_LOAD_SUCCESS,
            payload: application
          });

        case 8:
          _context.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["e" /* searchEnvironments */], '');

        case 10:
          environments = _context.sent;
          _context.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_ENV_LOAD_SUCCESS,
            payload: environments
          });

        case 13:
          _context.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */], '');

        case 15:
          stages = _context.sent;
          _context.next = 18;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_STAGE_LOAD_SUCCESS,
            payload: stages
          });

        case 18:
          _context.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["d" /* searchApp */], '');

        case 20:
          applications = _context.sent;
          _context.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_LIST_LOAD_SUCCESS,
            payload: applications
          });

        case 23:
          _context.next = 29;
          break;

        case 25:
          _context.prev = 25;
          _context.t0 = _context["catch"](0);
          _context.next = 29;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_FORM_FAILURE
          });

        case 29:
        case "end":
          return _context.stop();
      }
    }
  }, application_form_saga_marked, null, [[0, 25]]);
}
function cancelApplicationForm() {
  var $state;
  return regenerator_default.a.wrap(function cancelApplicationForm$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 2:
          _context2.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 4:
          $state = _context2.sent;
          _context2.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationList');

        case 7:
          _context2.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(application_form_saga_cleanFormFields);

        case 9:
        case "end":
          return _context2.stop();
      }
    }
  }, application_form_saga_marked2);
}
function updateApplicationModel(action) {
  return regenerator_default.a.wrap(function updateApplicationModel$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_LOAD_SUCCESS,
            payload: action.payload
          });

        case 2:
        case "end":
          return _context3.stop();
      }
    }
  }, application_form_saga_marked3);
}
function saveApplication(action) {
  var application, $state;
  return regenerator_default.a.wrap(function saveApplication$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          application = action.payload;
          application.environmentIds = application.environments.map(function (env) {
            return env.id;
          });
          _context4.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(angular_accessor["b" /* default */], '$state');

        case 5:
          $state = _context4.sent;
          _context4.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(sagas["c" /* removeConfirmLeavePopup */]);

        case 8:
          if (!isEmpty_default()(application.id)) {
            _context4.next = 17;
            break;
          }

          _context4.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["a" /* createApp */], application);

        case 11:
          _context4.next = 13;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_form_saga_toastr.success, "Created application [".concat(action.payload.title, "]"));

        case 13:
          _context4.next = 15;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationList');

        case 15:
          _context4.next = 23;
          break;

        case 17:
          _context4.next = 19;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["e" /* updateApp */], application);

        case 19:
          _context4.next = 21;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_form_saga_toastr.success, "Updated application [".concat(action.payload.title, "]"));

        case 21:
          _context4.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])($state.go, 'applicationList');

        case 23:
          _context4.next = 29;
          break;

        case 25:
          _context4.prev = 25;
          _context4.t0 = _context4["catch"](0);
          _context4.next = 29;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: application_actions_actionTypes.APPLICATION_SAVE_FAILURE,
            error: _context4.t0 // for testing purposes

          });

        case 29:
        case "end":
          return _context4.stop();
      }
    }
  }, application_form_saga_marked4, null, [[0, 25]]);
}
function applicationFormSaga() {
  return regenerator_default.a.wrap(function applicationFormSaga$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_SAVE_REQUEST, saveApplication);

        case 2:
          _context5.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_INIT, initApplicationForm);

        case 4:
          _context5.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_UPDATE_MODEL, updateApplicationModel);

        case 6:
          _context5.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_CANCEL, cancelApplicationForm);

        case 8:
          _context5.next = 10;
          return Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(application_actions_actionTypes.APPLICATION_FORM_PRISTINE, sagas["a" /* addConfirmLeavePopup */]);

        case 10:
        case "end":
          return _context5.stop();
      }
    }
  }, application_form_saga_marked5);
}
// EXTERNAL MODULE: ./node_modules/moment/moment.js-exposed
var moment_js_exposed = __webpack_require__(22);
var moment_js_exposed_default = /*#__PURE__*/__webpack_require__.n(moment_js_exposed);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/scheduling-environment-reservation-form-actions.js
var scheduling_environment_reservation_form_actions_actionTypes = {
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED',
  SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM',
  SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM',
  SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM',
  SCHEDULE_ENVIRONMENT_RESERVE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE',
  SCHEDULE_ENVIRONMENT_RESERVE_CANCEL: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_CANCEL',
  SCHEDULE_ENVIRONMENT_RESERVE_FAILURE: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVE_FAILURE',
  SCHEDULE_ENVIRONMENT_DELETE_RESERVATION: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION',
  SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT',
  SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED: 'envMgmt/SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED'
};
var onReserveEnvironment = function onReserveEnvironment(reservationModel) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE,
    payload: reservationModel
  };
};
var scheduling_environment_reservation_form_actions_onReserveEnvironmentCancel = function onReserveEnvironmentCancel() {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL
  };
};
var onDeleteEnvironmentReservation = function onDeleteEnvironmentReservation(reservationId) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION,
    payload: reservationId
  };
};
var scheduling_environment_reservation_form_actions_onReservationFormChange = function onReservationFormChange(reservationModel) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
    payload: reservationModel
  };
};
var scheduling_environment_reservation_form_actions_onReservationEnvironmentChange = function onReservationEnvironmentChange(reservationModel) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE,
    payload: reservationModel
  };
};
var scheduling_environment_reservation_form_actions_onReservationFormPristineChange = function onReservationFormPristineChange(pristine) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_PRISTINE_FORM,
    payload: pristine
  };
};
var scheduling_environment_reservation_form_actions_onReservationFormValidChange = function onReservationFormValidChange(valid) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_VALID_FORM,
    payload: valid
  };
};
var initEnvironmentReservationForm = function initEnvironmentReservationForm(reservationId) {
  return {
    type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT,
    payload: reservationId
  };
};
// EXTERNAL MODULE: ./core/xlr-ui/app/features/common/services/http.js
var http = __webpack_require__(16);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/common/scheduling-service.js

var scheduling_service_searchReservations = function searchReservations(schedulerFilter) {
  return Object(http["e" /* httpPOST */])('api/v1/environments/reservations/search', schedulerFilter).then(function (response) {
    return response.data;
  });
};
var scheduling_service_createReservation = function createReservation(reservation) {
  return Object(http["e" /* httpPOST */])('api/v1/environments/reservations', reservation);
};
var scheduling_service_updateReservation = function updateReservation(reservationId, reservation) {
  return Object(http["g" /* httpPUT */])("api/v1/environments/reservations/".concat(reservationId), reservation);
};
var scheduling_service_fetchReservation = function fetchReservation(reservationId) {
  return Object(http["c" /* httpGET */])("api/v1/environments/reservations/".concat(reservationId)).then(function (response) {
    return response.data;
  });
};
var scheduling_service_deleteReservation = function deleteReservation(reservationId) {
  return Object(http["b" /* httpDELETE */])("api/v1/environments/reservations/".concat(reservationId));
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/actions/scheduling-actions.js
var scheduling_actions_actionTypes = {
  SCHEDULE_SEARCH_REQUEST: 'envMgmt/SCHEDULE_SEARCH_REQUEST',
  SCHEDULE_SEARCH_SUCCESS: 'envMgmt/SCHEDULE_SEARCH_SUCCESS',
  SCHEDULE_SEARCH_FAILURE: 'envMgmt/SCHEDULE_SEARCH_FAILURE',
  SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM: 'envMgmt/SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM',
  SCHEDULE_SHOW_RESERVATION_SIDEBAR: 'envMgmt/SCHEDULE_SHOW_RESERVATION_SIDEBAR',
  SCHEDULE_INIT_HEADER_REQUEST: 'envMgmt/SCHEDULE_INIT_HEADER_REQUEST',
  SCHEDULE_INIT_HEADER_SUCCESS: 'envMgmt/SCHEDULE_INIT_HEADER_SUCCESS',
  SCHEDULE_CLEAN_STATE: 'envMgmt/SCHEDULE_CLEAN_STATE'
};
var onSearchReservations = function onSearchReservations(schedulerFilter) {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_SEARCH_REQUEST,
    payload: schedulerFilter
  };
};
var openEnvironmentReservationForm = function openEnvironmentReservationForm(reservationId) {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM,
    payload: reservationId
  };
};
var showReservationSidebar = function showReservationSidebar(isOpen) {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
    payload: isOpen
  };
};
var initHeader = function initHeader() {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_REQUEST
  };
};
var cleanSchedulingState = function cleanSchedulingState() {
  return {
    type: scheduling_actions_actionTypes.SCHEDULE_CLEAN_STATE
  };
};
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/scheduling-environment-reservation-form-saga.js


var scheduling_environment_reservation_form_saga_marked = /*#__PURE__*/regenerator_default.a.mark(reservationEnvironmentChange),
    scheduling_environment_reservation_form_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(reserveEnvironment),
    scheduling_environment_reservation_form_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(scheduling_environment_reservation_form_saga_cancel),
    scheduling_environment_reservation_form_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(deleteEnvironmentReservation),
    scheduling_environment_reservation_form_saga_marked5 = /*#__PURE__*/regenerator_default.a.mark(scheduling_environment_reservation_form_saga_initEnvironmentForm),
    scheduling_environment_reservation_form_saga_marked6 = /*#__PURE__*/regenerator_default.a.mark(scheduleEnvironmentReservationFormSaga);









var scheduling_environment_reservation_form_saga_cleanFormFields = {
  type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_CLEAN_FORM
};
var scheduling_environment_reservation_form_saga_toastr = Object(toastrFactory["a" /* default */])();
var getStateSchedulerFilter = function getStateSchedulerFilter(state) {
  return state.scheduling.schedulerFilter;
};
function reservationEnvironmentChange(action) {
  var applications;
  return regenerator_default.a.wrap(function reservationEnvironmentChange$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;

          if (!isEmpty_default()(action.payload)) {
            _context.next = 5;
            break;
          }

          _context.t0 = [];
          _context.next = 8;
          break;

        case 5:
          _context.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environment_service["c" /* getDeployableApplicationsForEnvironment */], action.payload.id);

        case 7:
          _context.t0 = _context.sent;

        case 8:
          applications = _context.t0;
          _context.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
            payload: applications
          });

        case 11:
          _context.next = 17;
          break;

        case 13:
          _context.prev = 13;
          _context.t1 = _context["catch"](0);
          _context.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ENVIRONMENT_CHANGED,
            payload: []
          });

        case 17:
        case "end":
          return _context.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked, null, [[0, 13]]);
}
function reserveEnvironment(action) {
  var reservationModel, reservationForm, schedulerFilter;
  return regenerator_default.a.wrap(function reserveEnvironment$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          reservationModel = action.payload;
          reservationForm = {
            environmentId: reservationModel.environment.id,
            applicationIds: reservationModel.applications.map(function (app) {
              return app.id;
            }),
            startDate: moment_js_exposed_default()(reservationModel.startDate).valueOf(),
            endDate: moment_js_exposed_default()(reservationModel.endDate).valueOf(),
            note: isEmpty_default()(reservationModel.note) ? null : reservationModel.note
          };
          _context2.prev = 2;

          if (!isEmpty_default()(reservationModel.id)) {
            _context2.next = 10;
            break;
          }

          _context2.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_createReservation, reservationForm);

        case 6:
          _context2.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_environment_reservation_form_saga_toastr.success, "Environment reserved.");

        case 8:
          _context2.next = 14;
          break;

        case 10:
          _context2.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_updateReservation, reservationModel.id, reservationForm);

        case 12:
          _context2.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_environment_reservation_form_saga_toastr.success, "Environment reservation updated.");

        case 14:
          _context2.next = 16;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(showReservationSidebar(false));

        case 16:
          _context2.next = 18;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 18:
          _context2.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getStateSchedulerFilter);

        case 20:
          schedulerFilter = _context2.sent;
          _context2.next = 23;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(onSearchReservations(schedulerFilter));

        case 23:
          _context2.next = 29;
          break;

        case 25:
          _context2.prev = 25;
          _context2.t0 = _context2["catch"](2);
          _context2.next = 29;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_FAILURE
          });

        case 29:
        case "end":
          return _context2.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked2, null, [[2, 25]]);
}
function scheduling_environment_reservation_form_saga_cancel() {
  return regenerator_default.a.wrap(function cancel$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(showReservationSidebar(false));

        case 2:
          _context3.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 4:
        case "end":
          return _context3.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked3);
}
function deleteEnvironmentReservation(action) {
  var schedulerFilter;
  return regenerator_default.a.wrap(function deleteEnvironmentReservation$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          _context4.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_deleteReservation, action.payload);

        case 3:
          _context4.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_environment_reservation_form_saga_toastr.success, "Reservation deleted.", action.payload);

        case 5:
          _context4.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(showReservationSidebar(false));

        case 7:
          _context4.next = 9;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 9:
          _context4.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["i" /* select */])(getStateSchedulerFilter);

        case 11:
          schedulerFilter = _context4.sent;
          _context4.next = 14;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(onSearchReservations(schedulerFilter));

        case 14:
          _context4.next = 20;
          break;

        case 16:
          _context4.prev = 16;
          _context4.t0 = _context4["catch"](0);
          _context4.next = 20;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION_FAILED
          });

        case 20:
        case "end":
          return _context4.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked4, null, [[0, 16]]);
}
function scheduling_environment_reservation_form_saga_initEnvironmentForm(action) {
  var reservationId, reservation, reservationModel;
  return regenerator_default.a.wrap(function initEnvironmentForm$(_context5) {
    while (1) {
      switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _context5.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(scheduling_environment_reservation_form_saga_cleanFormFields);

        case 3:
          reservationId = action.payload;

          if (isEmpty_default()(reservationId)) {
            _context5.next = 11;
            break;
          }

          _context5.next = 7;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_fetchReservation, reservationId);

        case 7:
          reservation = _context5.sent;
          reservationModel = {
            id: reservation.id,
            environment: {
              id: reservation.environment.id,
              title: reservation.environment.title
            },
            applications: reservation.applications,
            startDate: new Date(reservation.startDate),
            endDate: new Date(reservation.endDate),
            note: reservation.note
          };
          _context5.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_CHANGE,
            payload: reservationModel
          });

        case 11:
          _context5.next = 17;
          break;

        case 13:
          _context5.prev = 13;
          _context5.t0 = _context5["catch"](0);
          _context5.next = 17;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT_FAILED
          });

        case 17:
        case "end":
          return _context5.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked5, null, [[0, 13]]);
}
function scheduleEnvironmentReservationFormSaga() {
  return regenerator_default.a.wrap(function scheduleEnvironmentReservationFormSaga$(_context6) {
    while (1) {
      switch (_context6.prev = _context6.next) {
        case 0:
          _context6.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_ON_ENVIRONMENT_CHANGE, reservationEnvironmentChange), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE, reserveEnvironment), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_DELETE_RESERVATION, deleteEnvironmentReservation), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVE_CANCEL, scheduling_environment_reservation_form_saga_cancel), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_environment_reservation_form_actions_actionTypes.SCHEDULE_ENVIRONMENT_RESERVATION_FORM_INIT, scheduling_environment_reservation_form_saga_initEnvironmentForm)]);

        case 2:
        case "end":
          return _context6.stop();
      }
    }
  }, scheduling_environment_reservation_form_saga_marked6);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/scheduling-saga.js


var scheduling_saga_marked = /*#__PURE__*/regenerator_default.a.mark(searchReservation),
    scheduling_saga_marked2 = /*#__PURE__*/regenerator_default.a.mark(scheduling_saga_openEnvironmentReservationForm),
    scheduling_saga_marked3 = /*#__PURE__*/regenerator_default.a.mark(loadApplicationsStagesAndLabels),
    scheduling_saga_marked4 = /*#__PURE__*/regenerator_default.a.mark(schedulingSaga);








function searchReservation(action) {
  var environmentReservations;
  return regenerator_default.a.wrap(function searchReservation$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduling_service_searchReservations, action.payload);

        case 3:
          environmentReservations = _context.sent;
          _context.next = 6;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SEARCH_SUCCESS,
            payload: environmentReservations
          });

        case 6:
          _context.next = 12;
          break;

        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          _context.next = 12;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SEARCH_FAILURE
          });

        case 12:
        case "end":
          return _context.stop();
      }
    }
  }, scheduling_saga_marked, null, [[0, 8]]);
}
function scheduling_saga_openEnvironmentReservationForm(action) {
  return regenerator_default.a.wrap(function openEnvironmentReservationForm$(_context2) {
    while (1) {
      switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])(initEnvironmentReservationForm(action.payload));

        case 3:
          _context2.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
            payload: true
          });

        case 5:
          _context2.next = 11;
          break;

        case 7:
          _context2.prev = 7;
          _context2.t0 = _context2["catch"](0);
          _context2.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_SHOW_RESERVATION_SIDEBAR,
            payload: false
          });

        case 11:
        case "end":
          return _context2.stop();
      }
    }
  }, scheduling_saga_marked2, null, [[0, 7]]);
}
function loadApplicationsStagesAndLabels() {
  var applications, stages, labels;
  return regenerator_default.a.wrap(function loadApplicationsStagesAndLabels$(_context3) {
    while (1) {
      switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(application_service["d" /* searchApp */], '');

        case 2:
          applications = _context3.sent;
          _context3.next = 5;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stage_service["c" /* searchStages */], '');

        case 5:
          stages = _context3.sent;
          _context3.next = 8;
          return Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(label_service["c" /* searchLabels */], '');

        case 8:
          labels = _context3.sent;
          _context3.next = 11;
          return Object(redux_saga_effects_npm_proxy_esm["g" /* put */])({
            type: scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_SUCCESS,
            payload: {
              applications: applications,
              stages: stages,
              labels: labels
            }
          });

        case 11:
        case "end":
          return _context3.stop();
      }
    }
  }, scheduling_saga_marked3);
}
function schedulingSaga() {
  return regenerator_default.a.wrap(function schedulingSaga$(_context4) {
    while (1) {
      switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["m" /* throttle */])(200, scheduling_actions_actionTypes.SCHEDULE_SEARCH_REQUEST, searchReservation), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_actions_actionTypes.SCHEDULE_OPEN_ENVIRONMENT_RESERVATION_FORM, scheduling_saga_openEnvironmentReservationForm), Object(redux_saga_effects_npm_proxy_esm["l" /* takeLatest */])(scheduling_actions_actionTypes.SCHEDULE_INIT_HEADER_REQUEST, loadApplicationsStagesAndLabels)]);

        case 2:
        case "end":
          return _context4.stop();
      }
    }
  }, scheduling_saga_marked4);
}
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/sagas/sagas.js


var sagas_marked = /*#__PURE__*/regenerator_default.a.mark(combinedSaga);










function combinedSaga() {
  return regenerator_default.a.wrap(function combinedSaga$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          if (false) {}

          _context.prev = 1;
          _context.next = 4;
          return Object(redux_saga_effects_npm_proxy_esm["a" /* all */])([Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environmentListSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(environmentFormSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(stageSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(labelSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(applicationListSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(applicationFormSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(scheduleEnvironmentReservationFormSaga), Object(redux_saga_effects_npm_proxy_esm["b" /* call */])(schedulingSaga)]);

        case 4:
          _context.next = 9;
          break;

        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](1);

          /* eslint-disable no-console, angular/log */
          console.error('Environment management root saga:', _context.t0);
          /* eslint-enable */

        case 9:
          _context.next = 0;
          break;

        case 11:
        case "end":
          return _context.stop();
      }
    }
  }, sagas_marked, null, [[1, 6]]);
}
// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/defineProperty.js
var defineProperty = __webpack_require__(1);
var defineProperty_default = /*#__PURE__*/__webpack_require__.n(defineProperty);

// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/environment-form-reducer.js


function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var environment_form_reducer_initialState = function initialState() {
  return {
    environmentModel: {
      stage: {},
      id: null,
      labels: [],
      title: '',
      description: ''
    },
    environments: [],
    formIsPristine: true,
    formIsValid: false
  };
};

/* harmony default export */ var environment_form_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : environment_form_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CLEAN_FORM:
      return _objectSpread(_objectSpread({}, environment_form_reducer_initialState()), {}, {
        environmentModel: _objectSpread({}, environment_form_reducer_initialState().environmentModel),
        formIsPristine: state.formIsPristine
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_VALID_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        formIsValid: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_PRISTINE_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        formIsPristine: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_EDIT_CHANGE_FORM:
      return _objectSpread(_objectSpread({}, state), {}, {
        environmentModel: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_LOAD_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        environmentModel: action.payload
      });

    case environment_form_actions_actionTypes.ENVIRONMENT_SEARCH_SUCCESS:
      return _objectSpread(_objectSpread({}, state), {}, {
        environments: action.payload
      });

    case environment_form_actions_actionTypes.INIT_ENVIRONMENT_FORM_SUCCESS:
      var _action$payload = action.payload,
          environment = _action$payload.environment,
          environments = _action$payload.environments;
      return _objectSpread(_objectSpread({}, state), {}, {
        environmentModel: environment || environment_form_reducer_initialState().environmentModel,
        environments: environments
      });

    default:
      return state;
  }
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/utils.js
function by(fieldSelector) {
  return function (a, b) {
    var nameA = fieldSelector(a).toLowerCase();
    var nameB = fieldSelector(b).toLowerCase();

    if (nameA < nameB) {
      return -1;
    }

    if (nameA > nameB) {
      return 1;
    }

    return 0;
  };
}

var byTitle = by(function (it) {
  return it.title;
});
// CONCATENATED MODULE: ./modules/xlr-environment-management-module/src/main/resources/web/include/reducers/environment-list-reducer.js


function environment_list_reducer_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function environment_list_reducer_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { environment_list_reducer_ownKeys(Object(source), true).forEach(function (key) { defineProperty_default()(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { environment_list_reducer_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }



var environment_list_reducer_initialState = function initialState() {
  return {
    list: [],
    filters: {
      title: '',
      stage: {}
    },
    loading: false
  };
};
/* harmony default export */ var environment_list_reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : environment_list_reducer_initialState();
  var action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case actionTypes.INIT_ENVIRONMENT_LIST:
    case actionTypes.ENVIRONMENTS_SEARCH_REQUEST:
      return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
        loading: true
      });

    case actionTypes.ENVIRONMENTS_SEARCH_SUCCESS:
      {
        var environments = action.payload.sort(byTitle);
        return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
          list: environments,
          loading: false
        });
      }

    case actionTypes.ENVIRONMENTS_SEARCH_FAILURE:
      return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
        loading: false
      });

    case actionTypes.ENVIRONMENT_DELETE_REQUEST:
      return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
        loading: true
      });

    case actionTypes.ENVIRONMENT_DELETE_SUCCESS:
      return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
        loading: false
      });

    case actionTypes.ENVIRONMENT_DELETE_FAILURE:
      return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
        loading: false
      });

    case actionTypes.INIT_ENVIRONMENT_LIST_SUCCESS:
      {
        var _environments = action.payload.environments;
        return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
          list: _environments.sort(byTitle),
          loading: false
        });
      }

    case actionTypes.INIT_ENVIRONMENT_LIST_FAILURE:
      return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
        loading: false
      });

    case actionTypes.TITLE_FILTER_CHANGE:
      var title = action.payload;
      return environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state), {}, {
        filters: environment_list_reducer_objectSpread(environment_list_reducer_objectSpread({}, state.filters), {}, {
          title: title
        })
      });

    case actionTypes.STAGE_FILTER_CHANGE:
      var stage = action.payload;
      return environment_list_reducer_ob